var CLOSURE_NO_DEPS = true;
window.polymerSkipLoadingFontRoboto = true;
/** vim: et:ts=4:sw=4:sts=4
 * @license RequireJS 2.3.6 Copyright jQuery Foundation and other contributors.
 * Released under MIT license, https://github.com/requirejs/requirejs/blob/master/LICENSE
 */
//Not using strict: uneven strict support in browsers, #392, and causes
//problems with requirejs.exec()/transpiler plugins that may not be strict.
/*jslint regexp: true, nomen: true, sloppy: true */
/*global window, navigator, document, importScripts, setTimeout, opera */

var requirejs, require, define;
(function (global, setTimeout) {
    var req, s, head, baseElement, dataMain, src,
        interactiveScript, currentlyAddingScript, mainScript, subPath,
        version = '2.3.6',
        commentRegExp = /\/\*[\s\S]*?\*\/|([^:"'=]|^)\/\/.*$/mg,
        cjsRequireRegExp = /[^.]\s*require\s*\(\s*["']([^'"\s]+)["']\s*\)/g,
        jsSuffixRegExp = /\.js$/,
        currDirRegExp = /^\.\//,
        op = Object.prototype,
        ostring = op.toString,
        hasOwn = op.hasOwnProperty,
        isBrowser = !!(typeof window !== 'undefined' && typeof navigator !== 'undefined' && window.document),
        isWebWorker = !isBrowser && typeof importScripts !== 'undefined',
        //PS3 indicates loaded and complete, but need to wait for complete
        //specifically. Sequence is 'loading', 'loaded', execution,
        // then 'complete'. The UA check is unfortunate, but not sure how
        //to feature test w/o causing perf issues.
        readyRegExp = isBrowser && navigator.platform === 'PLAYSTATION 3' ?
                      /^complete$/ : /^(complete|loaded)$/,
        defContextName = '_',
        //Oh the tragedy, detecting opera. See the usage of isOpera for reason.
        isOpera = typeof opera !== 'undefined' && opera.toString() === '[object Opera]',
        contexts = {},
        cfg = {},
        globalDefQueue = [],
        useInteractive = false;

    //Could match something like ')//comment', do not lose the prefix to comment.
    function commentReplace(match, singlePrefix) {
        return singlePrefix || '';
    }

    function isFunction(it) {
        return ostring.call(it) === '[object Function]';
    }

    function isArray(it) {
        return ostring.call(it) === '[object Array]';
    }

    /**
     * Helper function for iterating over an array. If the func returns
     * a true value, it will break out of the loop.
     */
    function each(ary, func) {
        if (ary) {
            var i;
            for (i = 0; i < ary.length; i += 1) {
                if (ary[i] && func(ary[i], i, ary)) {
                    break;
                }
            }
        }
    }

    /**
     * Helper function for iterating over an array backwards. If the func
     * returns a true value, it will break out of the loop.
     */
    function eachReverse(ary, func) {
        if (ary) {
            var i;
            for (i = ary.length - 1; i > -1; i -= 1) {
                if (ary[i] && func(ary[i], i, ary)) {
                    break;
                }
            }
        }
    }

    function hasProp(obj, prop) {
        return hasOwn.call(obj, prop);
    }

    function getOwn(obj, prop) {
        return hasProp(obj, prop) && obj[prop];
    }

    /**
     * Cycles over properties in an object and calls a function for each
     * property value. If the function returns a truthy value, then the
     * iteration is stopped.
     */
    function eachProp(obj, func) {
        var prop;
        for (prop in obj) {
            if (hasProp(obj, prop)) {
                if (func(obj[prop], prop)) {
                    break;
                }
            }
        }
    }

    /**
     * Simple function to mix in properties from source into target,
     * but only if target does not already have a property of the same name.
     */
    function mixin(target, source, force, deepStringMixin) {
        if (source) {
            eachProp(source, function (value, prop) {
                if (force || !hasProp(target, prop)) {
                    if (deepStringMixin && typeof value === 'object' && value &&
                        !isArray(value) && !isFunction(value) &&
                        !(value instanceof RegExp)) {

                        if (!target[prop]) {
                            target[prop] = {};
                        }
                        mixin(target[prop], value, force, deepStringMixin);
                    } else {
                        target[prop] = value;
                    }
                }
            });
        }
        return target;
    }

    //Similar to Function.prototype.bind, but the 'this' object is specified
    //first, since it is easier to read/figure out what 'this' will be.
    function bind(obj, fn) {
        return function () {
            return fn.apply(obj, arguments);
        };
    }

    function scripts() {
        return document.getElementsByTagName('script');
    }

    function defaultOnError(err) {
        throw err;
    }

    //Allow getting a global that is expressed in
    //dot notation, like 'a.b.c'.
    function getGlobal(value) {
        if (!value) {
            return value;
        }
        var g = global;
        each(value.split('.'), function (part) {
            g = g[part];
        });
        return g;
    }

    /**
     * Constructs an error with a pointer to an URL with more information.
     * @param {String} id the error ID that maps to an ID on a web page.
     * @param {String} message human readable error.
     * @param {Error} [err] the original error, if there is one.
     *
     * @returns {Error}
     */
    function makeError(id, msg, err, requireModules) {
        var e = new Error(msg + '\nhttps://requirejs.org/docs/errors.html#' + id);
        e.requireType = id;
        e.requireModules = requireModules;
        if (err) {
            e.originalError = err;
        }
        return e;
    }

    if (typeof define !== 'undefined') {
        //If a define is already in play via another AMD loader,
        //do not overwrite.
        return;
    }

    if (typeof requirejs !== 'undefined') {
        if (isFunction(requirejs)) {
            //Do not overwrite an existing requirejs instance.
            return;
        }
        cfg = requirejs;
        requirejs = undefined;
    }

    //Allow for a require config object
    if (typeof require !== 'undefined' && !isFunction(require)) {
        //assume it is a config object.
        cfg = require;
        require = undefined;
    }

    function newContext(contextName) {
        var inCheckLoaded, Module, context, handlers,
            checkLoadedTimeoutId,
            config = {
                //Defaults. Do not set a default for map
                //config to speed up normalize(), which
                //will run faster if there is no default.
                waitSeconds: 7,
                baseUrl: './',
                paths: {},
                bundles: {},
                pkgs: {},
                shim: {},
                config: {}
            },
            registry = {},
            //registry of just enabled modules, to speed
            //cycle breaking code when lots of modules
            //are registered, but not activated.
            enabledRegistry = {},
            undefEvents = {},
            defQueue = [],
            defined = {},
            urlFetched = {},
            bundlesMap = {},
            requireCounter = 1,
            unnormalizedCounter = 1;

        /**
         * Trims the . and .. from an array of path segments.
         * It will keep a leading path segment if a .. will become
         * the first path segment, to help with module name lookups,
         * which act like paths, but can be remapped. But the end result,
         * all paths that use this function should look normalized.
         * NOTE: this method MODIFIES the input array.
         * @param {Array} ary the array of path segments.
         */
        function trimDots(ary) {
            var i, part;
            for (i = 0; i < ary.length; i++) {
                part = ary[i];
                if (part === '.') {
                    ary.splice(i, 1);
                    i -= 1;
                } else if (part === '..') {
                    // If at the start, or previous value is still ..,
                    // keep them so that when converted to a path it may
                    // still work when converted to a path, even though
                    // as an ID it is less than ideal. In larger point
                    // releases, may be better to just kick out an error.
                    if (i === 0 || (i === 1 && ary[2] === '..') || ary[i - 1] === '..') {
                        continue;
                    } else if (i > 0) {
                        ary.splice(i - 1, 2);
                        i -= 2;
                    }
                }
            }
        }

        /**
         * Given a relative module name, like ./something, normalize it to
         * a real name that can be mapped to a path.
         * @param {String} name the relative name
         * @param {String} baseName a real name that the name arg is relative
         * to.
         * @param {Boolean} applyMap apply the map config to the value. Should
         * only be done if this normalization is for a dependency ID.
         * @returns {String} normalized name
         */
        function normalize(name, baseName, applyMap) {
            var pkgMain, mapValue, nameParts, i, j, nameSegment, lastIndex,
                foundMap, foundI, foundStarMap, starI, normalizedBaseParts,
                baseParts = (baseName && baseName.split('/')),
                map = config.map,
                starMap = map && map['*'];

            //Adjust any relative paths.
            if (name) {
                name = name.split('/');
                lastIndex = name.length - 1;

                // If wanting node ID compatibility, strip .js from end
                // of IDs. Have to do this here, and not in nameToUrl
                // because node allows either .js or non .js to map
                // to same file.
                if (config.nodeIdCompat && jsSuffixRegExp.test(name[lastIndex])) {
                    name[lastIndex] = name[lastIndex].replace(jsSuffixRegExp, '');
                }

                // Starts with a '.' so need the baseName
                if (name[0].charAt(0) === '.' && baseParts) {
                    //Convert baseName to array, and lop off the last part,
                    //so that . matches that 'directory' and not name of the baseName's
                    //module. For instance, baseName of 'one/two/three', maps to
                    //'one/two/three.js', but we want the directory, 'one/two' for
                    //this normalization.
                    normalizedBaseParts = baseParts.slice(0, baseParts.length - 1);
                    name = normalizedBaseParts.concat(name);
                }

                trimDots(name);
                name = name.join('/');
            }

            //Apply map config if available.
            if (applyMap && map && (baseParts || starMap)) {
                nameParts = name.split('/');

                outerLoop: for (i = nameParts.length; i > 0; i -= 1) {
                    nameSegment = nameParts.slice(0, i).join('/');

                    if (baseParts) {
                        //Find the longest baseName segment match in the config.
                        //So, do joins on the biggest to smallest lengths of baseParts.
                        for (j = baseParts.length; j > 0; j -= 1) {
                            mapValue = getOwn(map, baseParts.slice(0, j).join('/'));

                            //baseName segment has config, find if it has one for
                            //this name.
                            if (mapValue) {
                                mapValue = getOwn(mapValue, nameSegment);
                                if (mapValue) {
                                    //Match, update name to the new value.
                                    foundMap = mapValue;
                                    foundI = i;
                                    break outerLoop;
                                }
                            }
                        }
                    }

                    //Check for a star map match, but just hold on to it,
                    //if there is a shorter segment match later in a matching
                    //config, then favor over this star map.
                    if (!foundStarMap && starMap && getOwn(starMap, nameSegment)) {
                        foundStarMap = getOwn(starMap, nameSegment);
                        starI = i;
                    }
                }

                if (!foundMap && foundStarMap) {
                    foundMap = foundStarMap;
                    foundI = starI;
                }

                if (foundMap) {
                    nameParts.splice(0, foundI, foundMap);
                    name = nameParts.join('/');
                }
            }

            // If the name points to a package's name, use
            // the package main instead.
            pkgMain = getOwn(config.pkgs, name);

            return pkgMain ? pkgMain : name;
        }

        function removeScript(name) {
            if (isBrowser) {
                each(scripts(), function (scriptNode) {
                    if (scriptNode.getAttribute('data-requiremodule') === name &&
                            scriptNode.getAttribute('data-requirecontext') === context.contextName) {
                        scriptNode.parentNode.removeChild(scriptNode);
                        return true;
                    }
                });
            }
        }

        function hasPathFallback(id) {
            var pathConfig = getOwn(config.paths, id);
            if (pathConfig && isArray(pathConfig) && pathConfig.length > 1) {
                //Pop off the first array value, since it failed, and
                //retry
                pathConfig.shift();
                context.require.undef(id);

                //Custom require that does not do map translation, since
                //ID is "absolute", already mapped/resolved.
                context.makeRequire(null, {
                    skipMap: true
                })([id]);

                return true;
            }
        }

        //Turns a plugin!resource to [plugin, resource]
        //with the plugin being undefined if the name
        //did not have a plugin prefix.
        function splitPrefix(name) {
            var prefix,
                index = name ? name.indexOf('!') : -1;
            if (index > -1) {
                prefix = name.substring(0, index);
                name = name.substring(index + 1, name.length);
            }
            return [prefix, name];
        }

        /**
         * Creates a module mapping that includes plugin prefix, module
         * name, and path. If parentModuleMap is provided it will
         * also normalize the name via require.normalize()
         *
         * @param {String} name the module name
         * @param {String} [parentModuleMap] parent module map
         * for the module name, used to resolve relative names.
         * @param {Boolean} isNormalized: is the ID already normalized.
         * This is true if this call is done for a define() module ID.
         * @param {Boolean} applyMap: apply the map config to the ID.
         * Should only be true if this map is for a dependency.
         *
         * @returns {Object}
         */
        function makeModuleMap(name, parentModuleMap, isNormalized, applyMap) {
            var url, pluginModule, suffix, nameParts,
                prefix = null,
                parentName = parentModuleMap ? parentModuleMap.name : null,
                originalName = name,
                isDefine = true,
                normalizedName = '';

            //If no name, then it means it is a require call, generate an
            //internal name.
            if (!name) {
                isDefine = false;
                name = '_@r' + (requireCounter += 1);
            }

            nameParts = splitPrefix(name);
            prefix = nameParts[0];
            name = nameParts[1];

            if (prefix) {
                prefix = normalize(prefix, parentName, applyMap);
                pluginModule = getOwn(defined, prefix);
            }

            //Account for relative paths if there is a base name.
            if (name) {
                if (prefix) {
                    if (isNormalized) {
                        normalizedName = name;
                    } else if (pluginModule && pluginModule.normalize) {
                        //Plugin is loaded, use its normalize method.
                        normalizedName = pluginModule.normalize(name, function (name) {
                            return normalize(name, parentName, applyMap);
                        });
                    } else {
                        // If nested plugin references, then do not try to
                        // normalize, as it will not normalize correctly. This
                        // places a restriction on resourceIds, and the longer
                        // term solution is not to normalize until plugins are
                        // loaded and all normalizations to allow for async
                        // loading of a loader plugin. But for now, fixes the
                        // common uses. Details in #1131
                        normalizedName = name.indexOf('!') === -1 ?
                                         normalize(name, parentName, applyMap) :
                                         name;
                    }
                } else {
                    //A regular module.
                    normalizedName = normalize(name, parentName, applyMap);

                    //Normalized name may be a plugin ID due to map config
                    //application in normalize. The map config values must
                    //already be normalized, so do not need to redo that part.
                    nameParts = splitPrefix(normalizedName);
                    prefix = nameParts[0];
                    normalizedName = nameParts[1];
                    isNormalized = true;

                    url = context.nameToUrl(normalizedName);
                }
            }

            //If the id is a plugin id that cannot be determined if it needs
            //normalization, stamp it with a unique ID so two matching relative
            //ids that may conflict can be separate.
            suffix = prefix && !pluginModule && !isNormalized ?
                     '_unnormalized' + (unnormalizedCounter += 1) :
                     '';

            return {
                prefix: prefix,
                name: normalizedName,
                parentMap: parentModuleMap,
                unnormalized: !!suffix,
                url: url,
                originalName: originalName,
                isDefine: isDefine,
                id: (prefix ?
                        prefix + '!' + normalizedName :
                        normalizedName) + suffix
            };
        }

        function getModule(depMap) {
            var id = depMap.id,
                mod = getOwn(registry, id);

            if (!mod) {
                mod = registry[id] = new context.Module(depMap);
            }

            return mod;
        }

        function on(depMap, name, fn) {
            var id = depMap.id,
                mod = getOwn(registry, id);

            if (hasProp(defined, id) &&
                    (!mod || mod.defineEmitComplete)) {
                if (name === 'defined') {
                    fn(defined[id]);
                }
            } else {
                mod = getModule(depMap);
                if (mod.error && name === 'error') {
                    fn(mod.error);
                } else {
                    mod.on(name, fn);
                }
            }
        }

        function onError(err, errback) {
            var ids = err.requireModules,
                notified = false;

            if (errback) {
                errback(err);
            } else {
                each(ids, function (id) {
                    var mod = getOwn(registry, id);
                    if (mod) {
                        //Set error on module, so it skips timeout checks.
                        mod.error = err;
                        if (mod.events.error) {
                            notified = true;
                            mod.emit('error', err);
                        }
                    }
                });

                if (!notified) {
                    req.onError(err);
                }
            }
        }

        /**
         * Internal method to transfer globalQueue items to this context's
         * defQueue.
         */
        function takeGlobalQueue() {
            //Push all the globalDefQueue items into the context's defQueue
            if (globalDefQueue.length) {
                each(globalDefQueue, function(queueItem) {
                    var id = queueItem[0];
                    if (typeof id === 'string') {
                        context.defQueueMap[id] = true;
                    }
                    defQueue.push(queueItem);
                });
                globalDefQueue = [];
            }
        }

        handlers = {
            'require': function (mod) {
                if (mod.require) {
                    return mod.require;
                } else {
                    return (mod.require = context.makeRequire(mod.map));
                }
            },
            'exports': function (mod) {
                mod.usingExports = true;
                if (mod.map.isDefine) {
                    if (mod.exports) {
                        return (defined[mod.map.id] = mod.exports);
                    } else {
                        return (mod.exports = defined[mod.map.id] = {});
                    }
                }
            },
            'module': function (mod) {
                if (mod.module) {
                    return mod.module;
                } else {
                    return (mod.module = {
                        id: mod.map.id,
                        uri: mod.map.url,
                        config: function () {
                            return getOwn(config.config, mod.map.id) || {};
                        },
                        exports: mod.exports || (mod.exports = {})
                    });
                }
            }
        };

        function cleanRegistry(id) {
            //Clean up machinery used for waiting modules.
            delete registry[id];
            delete enabledRegistry[id];
        }

        function breakCycle(mod, traced, processed) {
            var id = mod.map.id;

            if (mod.error) {
                mod.emit('error', mod.error);
            } else {
                traced[id] = true;
                each(mod.depMaps, function (depMap, i) {
                    var depId = depMap.id,
                        dep = getOwn(registry, depId);

                    //Only force things that have not completed
                    //being defined, so still in the registry,
                    //and only if it has not been matched up
                    //in the module already.
                    if (dep && !mod.depMatched[i] && !processed[depId]) {
                        if (getOwn(traced, depId)) {
                            mod.defineDep(i, defined[depId]);
                            mod.check(); //pass false?
                        } else {
                            breakCycle(dep, traced, processed);
                        }
                    }
                });
                processed[id] = true;
            }
        }

        function checkLoaded() {
            var err, usingPathFallback,
                waitInterval = config.waitSeconds * 1000,
                //It is possible to disable the wait interval by using waitSeconds of 0.
                expired = waitInterval && (context.startTime + waitInterval) < new Date().getTime(),
                noLoads = [],
                reqCalls = [],
                stillLoading = false,
                needCycleCheck = true;

            //Do not bother if this call was a result of a cycle break.
            if (inCheckLoaded) {
                return;
            }

            inCheckLoaded = true;

            //Figure out the state of all the modules.
            eachProp(enabledRegistry, function (mod) {
                var map = mod.map,
                    modId = map.id;

                //Skip things that are not enabled or in error state.
                if (!mod.enabled) {
                    return;
                }

                if (!map.isDefine) {
                    reqCalls.push(mod);
                }

                if (!mod.error) {
                    //If the module should be executed, and it has not
                    //been inited and time is up, remember it.
                    if (!mod.inited && expired) {
                        if (hasPathFallback(modId)) {
                            usingPathFallback = true;
                            stillLoading = true;
                        } else {
                            noLoads.push(modId);
                            removeScript(modId);
                        }
                    } else if (!mod.inited && mod.fetched && map.isDefine) {
                        stillLoading = true;
                        if (!map.prefix) {
                            //No reason to keep looking for unfinished
                            //loading. If the only stillLoading is a
                            //plugin resource though, keep going,
                            //because it may be that a plugin resource
                            //is waiting on a non-plugin cycle.
                            return (needCycleCheck = false);
                        }
                    }
                }
            });

            if (expired && noLoads.length) {
                //If wait time expired, throw error of unloaded modules.
                err = makeError('timeout', 'Load timeout for modules: ' + noLoads, null, noLoads);
                err.contextName = context.contextName;
                return onError(err);
            }

            //Not expired, check for a cycle.
            if (needCycleCheck) {
                each(reqCalls, function (mod) {
                    breakCycle(mod, {}, {});
                });
            }

            //If still waiting on loads, and the waiting load is something
            //other than a plugin resource, or there are still outstanding
            //scripts, then just try back later.
            if ((!expired || usingPathFallback) && stillLoading) {
                //Something is still waiting to load. Wait for it, but only
                //if a timeout is not already in effect.
                if ((isBrowser || isWebWorker) && !checkLoadedTimeoutId) {
                    checkLoadedTimeoutId = setTimeout(function () {
                        checkLoadedTimeoutId = 0;
                        checkLoaded();
                    }, 50);
                }
            }

            inCheckLoaded = false;
        }

        Module = function (map) {
            this.events = getOwn(undefEvents, map.id) || {};
            this.map = map;
            this.shim = getOwn(config.shim, map.id);
            this.depExports = [];
            this.depMaps = [];
            this.depMatched = [];
            this.pluginMaps = {};
            this.depCount = 0;

            /* this.exports this.factory
               this.depMaps = [],
               this.enabled, this.fetched
            */
        };

        Module.prototype = {
            init: function (depMaps, factory, errback, options) {
                options = options || {};

                //Do not do more inits if already done. Can happen if there
                //are multiple define calls for the same module. That is not
                //a normal, common case, but it is also not unexpected.
                if (this.inited) {
                    return;
                }

                this.factory = factory;

                if (errback) {
                    //Register for errors on this module.
                    this.on('error', errback);
                } else if (this.events.error) {
                    //If no errback already, but there are error listeners
                    //on this module, set up an errback to pass to the deps.
                    errback = bind(this, function (err) {
                        this.emit('error', err);
                    });
                }

                //Do a copy of the dependency array, so that
                //source inputs are not modified. For example
                //"shim" deps are passed in here directly, and
                //doing a direct modification of the depMaps array
                //would affect that config.
                this.depMaps = depMaps && depMaps.slice(0);

                this.errback = errback;

                //Indicate this module has be initialized
                this.inited = true;

                this.ignore = options.ignore;

                //Could have option to init this module in enabled mode,
                //or could have been previously marked as enabled. However,
                //the dependencies are not known until init is called. So
                //if enabled previously, now trigger dependencies as enabled.
                if (options.enabled || this.enabled) {
                    //Enable this module and dependencies.
                    //Will call this.check()
                    this.enable();
                } else {
                    this.check();
                }
            },

            defineDep: function (i, depExports) {
                //Because of cycles, defined callback for a given
                //export can be called more than once.
                if (!this.depMatched[i]) {
                    this.depMatched[i] = true;
                    this.depCount -= 1;
                    this.depExports[i] = depExports;
                }
            },

            fetch: function () {
                if (this.fetched) {
                    return;
                }
                this.fetched = true;

                context.startTime = (new Date()).getTime();

                var map = this.map;

                //If the manager is for a plugin managed resource,
                //ask the plugin to load it now.
                if (this.shim) {
                    context.makeRequire(this.map, {
                        enableBuildCallback: true
                    })(this.shim.deps || [], bind(this, function () {
                        return map.prefix ? this.callPlugin() : this.load();
                    }));
                } else {
                    //Regular dependency.
                    return map.prefix ? this.callPlugin() : this.load();
                }
            },

            load: function () {
                var url = this.map.url;

                //Regular dependency.
                if (!urlFetched[url]) {
                    urlFetched[url] = true;
                    context.load(this.map.id, url);
                }
            },

            /**
             * Checks if the module is ready to define itself, and if so,
             * define it.
             */
            check: function () {
                if (!this.enabled || this.enabling) {
                    return;
                }

                var err, cjsModule,
                    id = this.map.id,
                    depExports = this.depExports,
                    exports = this.exports,
                    factory = this.factory;

                if (!this.inited) {
                    // Only fetch if not already in the defQueue.
                    if (!hasProp(context.defQueueMap, id)) {
                        this.fetch();
                    }
                } else if (this.error) {
                    this.emit('error', this.error);
                } else if (!this.defining) {
                    //The factory could trigger another require call
                    //that would result in checking this module to
                    //define itself again. If already in the process
                    //of doing that, skip this work.
                    this.defining = true;

                    if (this.depCount < 1 && !this.defined) {
                        if (isFunction(factory)) {
                            //If there is an error listener, favor passing
                            //to that instead of throwing an error. However,
                            //only do it for define()'d  modules. require
                            //errbacks should not be called for failures in
                            //their callbacks (#699). However if a global
                            //onError is set, use that.
                            if ((this.events.error && this.map.isDefine) ||
                                req.onError !== defaultOnError) {
                                try {
                                    exports = context.execCb(id, factory, depExports, exports);
                                } catch (e) {
                                    err = e;
                                }
                            } else {
                                exports = context.execCb(id, factory, depExports, exports);
                            }

                            // Favor return value over exports. If node/cjs in play,
                            // then will not have a return value anyway. Favor
                            // module.exports assignment over exports object.
                            if (this.map.isDefine && exports === undefined) {
                                cjsModule = this.module;
                                if (cjsModule) {
                                    exports = cjsModule.exports;
                                } else if (this.usingExports) {
                                    //exports already set the defined value.
                                    exports = this.exports;
                                }
                            }

                            if (err) {
                                err.requireMap = this.map;
                                err.requireModules = this.map.isDefine ? [this.map.id] : null;
                                err.requireType = this.map.isDefine ? 'define' : 'require';
                                return onError((this.error = err));
                            }

                        } else {
                            //Just a literal value
                            exports = factory;
                        }

                        this.exports = exports;

                        if (this.map.isDefine && !this.ignore) {
                            defined[id] = exports;

                            if (req.onResourceLoad) {
                                var resLoadMaps = [];
                                each(this.depMaps, function (depMap) {
                                    resLoadMaps.push(depMap.normalizedMap || depMap);
                                });
                                req.onResourceLoad(context, this.map, resLoadMaps);
                            }
                        }

                        //Clean up
                        cleanRegistry(id);

                        this.defined = true;
                    }

                    //Finished the define stage. Allow calling check again
                    //to allow define notifications below in the case of a
                    //cycle.
                    this.defining = false;

                    if (this.defined && !this.defineEmitted) {
                        this.defineEmitted = true;
                        this.emit('defined', this.exports);
                        this.defineEmitComplete = true;
                    }

                }
            },

            callPlugin: function () {
                var map = this.map,
                    id = map.id,
                    //Map already normalized the prefix.
                    pluginMap = makeModuleMap(map.prefix);

                //Mark this as a dependency for this plugin, so it
                //can be traced for cycles.
                this.depMaps.push(pluginMap);

                on(pluginMap, 'defined', bind(this, function (plugin) {
                    var load, normalizedMap, normalizedMod,
                        bundleId = getOwn(bundlesMap, this.map.id),
                        name = this.map.name,
                        parentName = this.map.parentMap ? this.map.parentMap.name : null,
                        localRequire = context.makeRequire(map.parentMap, {
                            enableBuildCallback: true
                        });

                    //If current map is not normalized, wait for that
                    //normalized name to load instead of continuing.
                    if (this.map.unnormalized) {
                        //Normalize the ID if the plugin allows it.
                        if (plugin.normalize) {
                            name = plugin.normalize(name, function (name) {
                                return normalize(name, parentName, true);
                            }) || '';
                        }

                        //prefix and name should already be normalized, no need
                        //for applying map config again either.
                        normalizedMap = makeModuleMap(map.prefix + '!' + name,
                                                      this.map.parentMap,
                                                      true);
                        on(normalizedMap,
                            'defined', bind(this, function (value) {
                                this.map.normalizedMap = normalizedMap;
                                this.init([], function () { return value; }, null, {
                                    enabled: true,
                                    ignore: true
                                });
                            }));

                        normalizedMod = getOwn(registry, normalizedMap.id);
                        if (normalizedMod) {
                            //Mark this as a dependency for this plugin, so it
                            //can be traced for cycles.
                            this.depMaps.push(normalizedMap);

                            if (this.events.error) {
                                normalizedMod.on('error', bind(this, function (err) {
                                    this.emit('error', err);
                                }));
                            }
                            normalizedMod.enable();
                        }

                        return;
                    }

                    //If a paths config, then just load that file instead to
                    //resolve the plugin, as it is built into that paths layer.
                    if (bundleId) {
                        this.map.url = context.nameToUrl(bundleId);
                        this.load();
                        return;
                    }

                    load = bind(this, function (value) {
                        this.init([], function () { return value; }, null, {
                            enabled: true
                        });
                    });

                    load.error = bind(this, function (err) {
                        this.inited = true;
                        this.error = err;
                        err.requireModules = [id];

                        //Remove temp unnormalized modules for this module,
                        //since they will never be resolved otherwise now.
                        eachProp(registry, function (mod) {
                            if (mod.map.id.indexOf(id + '_unnormalized') === 0) {
                                cleanRegistry(mod.map.id);
                            }
                        });

                        onError(err);
                    });

                    //Allow plugins to load other code without having to know the
                    //context or how to 'complete' the load.
                    load.fromText = bind(this, function (text, textAlt) {
                        /*jslint evil: true */
                        var moduleName = map.name,
                            moduleMap = makeModuleMap(moduleName),
                            hasInteractive = useInteractive;

                        //As of 2.1.0, support just passing the text, to reinforce
                        //fromText only being called once per resource. Still
                        //support old style of passing moduleName but discard
                        //that moduleName in favor of the internal ref.
                        if (textAlt) {
                            text = textAlt;
                        }

                        //Turn off interactive script matching for IE for any define
                        //calls in the text, then turn it back on at the end.
                        if (hasInteractive) {
                            useInteractive = false;
                        }

                        //Prime the system by creating a module instance for
                        //it.
                        getModule(moduleMap);

                        //Transfer any config to this other module.
                        if (hasProp(config.config, id)) {
                            config.config[moduleName] = config.config[id];
                        }

                        try {
                            req.exec(text);
                        } catch (e) {
                            return onError(makeError('fromtexteval',
                                             'fromText eval for ' + id +
                                            ' failed: ' + e,
                                             e,
                                             [id]));
                        }

                        if (hasInteractive) {
                            useInteractive = true;
                        }

                        //Mark this as a dependency for the plugin
                        //resource
                        this.depMaps.push(moduleMap);

                        //Support anonymous modules.
                        context.completeLoad(moduleName);

                        //Bind the value of that module to the value for this
                        //resource ID.
                        localRequire([moduleName], load);
                    });

                    //Use parentName here since the plugin's name is not reliable,
                    //could be some weird string with no path that actually wants to
                    //reference the parentName's path.
                    plugin.load(map.name, localRequire, load, config);
                }));

                context.enable(pluginMap, this);
                this.pluginMaps[pluginMap.id] = pluginMap;
            },

            enable: function () {
                enabledRegistry[this.map.id] = this;
                this.enabled = true;

                //Set flag mentioning that the module is enabling,
                //so that immediate calls to the defined callbacks
                //for dependencies do not trigger inadvertent load
                //with the depCount still being zero.
                this.enabling = true;

                //Enable each dependency
                each(this.depMaps, bind(this, function (depMap, i) {
                    var id, mod, handler;

                    if (typeof depMap === 'string') {
                        //Dependency needs to be converted to a depMap
                        //and wired up to this module.
                        depMap = makeModuleMap(depMap,
                                               (this.map.isDefine ? this.map : this.map.parentMap),
                                               false,
                                               !this.skipMap);
                        this.depMaps[i] = depMap;

                        handler = getOwn(handlers, depMap.id);

                        if (handler) {
                            this.depExports[i] = handler(this);
                            return;
                        }

                        this.depCount += 1;

                        on(depMap, 'defined', bind(this, function (depExports) {
                            if (this.undefed) {
                                return;
                            }
                            this.defineDep(i, depExports);
                            this.check();
                        }));

                        if (this.errback) {
                            on(depMap, 'error', bind(this, this.errback));
                        } else if (this.events.error) {
                            // No direct errback on this module, but something
                            // else is listening for errors, so be sure to
                            // propagate the error correctly.
                            on(depMap, 'error', bind(this, function(err) {
                                this.emit('error', err);
                            }));
                        }
                    }

                    id = depMap.id;
                    mod = registry[id];

                    //Skip special modules like 'require', 'exports', 'module'
                    //Also, don't call enable if it is already enabled,
                    //important in circular dependency cases.
                    if (!hasProp(handlers, id) && mod && !mod.enabled) {
                        context.enable(depMap, this);
                    }
                }));

                //Enable each plugin that is used in
                //a dependency
                eachProp(this.pluginMaps, bind(this, function (pluginMap) {
                    var mod = getOwn(registry, pluginMap.id);
                    if (mod && !mod.enabled) {
                        context.enable(pluginMap, this);
                    }
                }));

                this.enabling = false;

                this.check();
            },

            on: function (name, cb) {
                var cbs = this.events[name];
                if (!cbs) {
                    cbs = this.events[name] = [];
                }
                cbs.push(cb);
            },

            emit: function (name, evt) {
                each(this.events[name], function (cb) {
                    cb(evt);
                });
                if (name === 'error') {
                    //Now that the error handler was triggered, remove
                    //the listeners, since this broken Module instance
                    //can stay around for a while in the registry.
                    delete this.events[name];
                }
            }
        };

        function callGetModule(args) {
            //Skip modules already defined.
            if (!hasProp(defined, args[0])) {
                getModule(makeModuleMap(args[0], null, true)).init(args[1], args[2]);
            }
        }

        function removeListener(node, func, name, ieName) {
            //Favor detachEvent because of IE9
            //issue, see attachEvent/addEventListener comment elsewhere
            //in this file.
            if (node.detachEvent && !isOpera) {
                //Probably IE. If not it will throw an error, which will be
                //useful to know.
                if (ieName) {
                    node.detachEvent(ieName, func);
                }
            } else {
                node.removeEventListener(name, func, false);
            }
        }

        /**
         * Given an event from a script node, get the requirejs info from it,
         * and then removes the event listeners on the node.
         * @param {Event} evt
         * @returns {Object}
         */
        function getScriptData(evt) {
            //Using currentTarget instead of target for Firefox 2.0's sake. Not
            //all old browsers will be supported, but this one was easy enough
            //to support and still makes sense.
            var node = evt.currentTarget || evt.srcElement;

            //Remove the listeners once here.
            removeListener(node, context.onScriptLoad, 'load', 'onreadystatechange');
            removeListener(node, context.onScriptError, 'error');

            return {
                node: node,
                id: node && node.getAttribute('data-requiremodule')
            };
        }

        function intakeDefines() {
            var args;

            //Any defined modules in the global queue, intake them now.
            takeGlobalQueue();

            //Make sure any remaining defQueue items get properly processed.
            while (defQueue.length) {
                args = defQueue.shift();
                if (args[0] === null) {
                    return onError(makeError('mismatch', 'Mismatched anonymous define() module: ' +
                        args[args.length - 1]));
                } else {
                    //args are id, deps, factory. Should be normalized by the
                    //define() function.
                    callGetModule(args);
                }
            }
            context.defQueueMap = {};
        }

        context = {
            config: config,
            contextName: contextName,
            registry: registry,
            defined: defined,
            urlFetched: urlFetched,
            defQueue: defQueue,
            defQueueMap: {},
            Module: Module,
            makeModuleMap: makeModuleMap,
            nextTick: req.nextTick,
            onError: onError,

            /**
             * Set a configuration for the context.
             * @param {Object} cfg config object to integrate.
             */
            configure: function (cfg) {
                //Make sure the baseUrl ends in a slash.
                if (cfg.baseUrl) {
                    if (cfg.baseUrl.charAt(cfg.baseUrl.length - 1) !== '/') {
                        cfg.baseUrl += '/';
                    }
                }

                // Convert old style urlArgs string to a function.
                if (typeof cfg.urlArgs === 'string') {
                    var urlArgs = cfg.urlArgs;
                    cfg.urlArgs = function(id, url) {
                        return (url.indexOf('?') === -1 ? '?' : '&') + urlArgs;
                    };
                }

                //Save off the paths since they require special processing,
                //they are additive.
                var shim = config.shim,
                    objs = {
                        paths: true,
                        bundles: true,
                        config: true,
                        map: true
                    };

                eachProp(cfg, function (value, prop) {
                    if (objs[prop]) {
                        if (!config[prop]) {
                            config[prop] = {};
                        }
                        mixin(config[prop], value, true, true);
                    } else {
                        config[prop] = value;
                    }
                });

                //Reverse map the bundles
                if (cfg.bundles) {
                    eachProp(cfg.bundles, function (value, prop) {
                        each(value, function (v) {
                            if (v !== prop) {
                                bundlesMap[v] = prop;
                            }
                        });
                    });
                }

                //Merge shim
                if (cfg.shim) {
                    eachProp(cfg.shim, function (value, id) {
                        //Normalize the structure
                        if (isArray(value)) {
                            value = {
                                deps: value
                            };
                        }
                        if ((value.exports || value.init) && !value.exportsFn) {
                            value.exportsFn = context.makeShimExports(value);
                        }
                        shim[id] = value;
                    });
                    config.shim = shim;
                }

                //Adjust packages if necessary.
                if (cfg.packages) {
                    each(cfg.packages, function (pkgObj) {
                        var location, name;

                        pkgObj = typeof pkgObj === 'string' ? {name: pkgObj} : pkgObj;

                        name = pkgObj.name;
                        location = pkgObj.location;
                        if (location) {
                            config.paths[name] = pkgObj.location;
                        }

                        //Save pointer to main module ID for pkg name.
                        //Remove leading dot in main, so main paths are normalized,
                        //and remove any trailing .js, since different package
                        //envs have different conventions: some use a module name,
                        //some use a file name.
                        config.pkgs[name] = pkgObj.name + '/' + (pkgObj.main || 'main')
                                     .replace(currDirRegExp, '')
                                     .replace(jsSuffixRegExp, '');
                    });
                }

                //If there are any "waiting to execute" modules in the registry,
                //update the maps for them, since their info, like URLs to load,
                //may have changed.
                eachProp(registry, function (mod, id) {
                    //If module already has init called, since it is too
                    //late to modify them, and ignore unnormalized ones
                    //since they are transient.
                    if (!mod.inited && !mod.map.unnormalized) {
                        mod.map = makeModuleMap(id, null, true);
                    }
                });

                //If a deps array or a config callback is specified, then call
                //require with those args. This is useful when require is defined as a
                //config object before require.js is loaded.
                if (cfg.deps || cfg.callback) {
                    context.require(cfg.deps || [], cfg.callback);
                }
            },

            makeShimExports: function (value) {
                function fn() {
                    var ret;
                    if (value.init) {
                        ret = value.init.apply(global, arguments);
                    }
                    return ret || (value.exports && getGlobal(value.exports));
                }
                return fn;
            },

            makeRequire: function (relMap, options) {
                options = options || {};

                function localRequire(deps, callback, errback) {
                    var id, map, requireMod;

                    if (options.enableBuildCallback && callback && isFunction(callback)) {
                        callback.__requireJsBuild = true;
                    }

                    if (typeof deps === 'string') {
                        if (isFunction(callback)) {
                            //Invalid call
                            return onError(makeError('requireargs', 'Invalid require call'), errback);
                        }

                        //If require|exports|module are requested, get the
                        //value for them from the special handlers. Caveat:
                        //this only works while module is being defined.
                        if (relMap && hasProp(handlers, deps)) {
                            return handlers[deps](registry[relMap.id]);
                        }

                        //Synchronous access to one module. If require.get is
                        //available (as in the Node adapter), prefer that.
                        if (req.get) {
                            return req.get(context, deps, relMap, localRequire);
                        }

                        //Normalize module name, if it contains . or ..
                        map = makeModuleMap(deps, relMap, false, true);
                        id = map.id;

                        if (!hasProp(defined, id)) {
                            return onError(makeError('notloaded', 'Module name "' +
                                        id +
                                        '" has not been loaded yet for context: ' +
                                        contextName +
                                        (relMap ? '' : '. Use require([])')));
                        }
                        return defined[id];
                    }

                    //Grab defines waiting in the global queue.
                    intakeDefines();

                    //Mark all the dependencies as needing to be loaded.
                    context.nextTick(function () {
                        //Some defines could have been added since the
                        //require call, collect them.
                        intakeDefines();

                        requireMod = getModule(makeModuleMap(null, relMap));

                        //Store if map config should be applied to this require
                        //call for dependencies.
                        requireMod.skipMap = options.skipMap;

                        requireMod.init(deps, callback, errback, {
                            enabled: true
                        });

                        checkLoaded();
                    });

                    return localRequire;
                }

                mixin(localRequire, {
                    isBrowser: isBrowser,

                    /**
                     * Converts a module name + .extension into an URL path.
                     * *Requires* the use of a module name. It does not support using
                     * plain URLs like nameToUrl.
                     */
                    toUrl: function (moduleNamePlusExt) {
                        var ext,
                            index = moduleNamePlusExt.lastIndexOf('.'),
                            segment = moduleNamePlusExt.split('/')[0],
                            isRelative = segment === '.' || segment === '..';

                        //Have a file extension alias, and it is not the
                        //dots from a relative path.
                        if (index !== -1 && (!isRelative || index > 1)) {
                            ext = moduleNamePlusExt.substring(index, moduleNamePlusExt.length);
                            moduleNamePlusExt = moduleNamePlusExt.substring(0, index);
                        }

                        return context.nameToUrl(normalize(moduleNamePlusExt,
                                                relMap && relMap.id, true), ext,  true);
                    },

                    defined: function (id) {
                        return hasProp(defined, makeModuleMap(id, relMap, false, true).id);
                    },

                    specified: function (id) {
                        id = makeModuleMap(id, relMap, false, true).id;
                        return hasProp(defined, id) || hasProp(registry, id);
                    }
                });

                //Only allow undef on top level require calls
                if (!relMap) {
                    localRequire.undef = function (id) {
                        //Bind any waiting define() calls to this context,
                        //fix for #408
                        takeGlobalQueue();

                        var map = makeModuleMap(id, relMap, true),
                            mod = getOwn(registry, id);

                        mod.undefed = true;
                        removeScript(id);

                        delete defined[id];
                        delete urlFetched[map.url];
                        delete undefEvents[id];

                        //Clean queued defines too. Go backwards
                        //in array so that the splices do not
                        //mess up the iteration.
                        eachReverse(defQueue, function(args, i) {
                            if (args[0] === id) {
                                defQueue.splice(i, 1);
                            }
                        });
                        delete context.defQueueMap[id];

                        if (mod) {
                            //Hold on to listeners in case the
                            //module will be attempted to be reloaded
                            //using a different config.
                            if (mod.events.defined) {
                                undefEvents[id] = mod.events;
                            }

                            cleanRegistry(id);
                        }
                    };
                }

                return localRequire;
            },

            /**
             * Called to enable a module if it is still in the registry
             * awaiting enablement. A second arg, parent, the parent module,
             * is passed in for context, when this method is overridden by
             * the optimizer. Not shown here to keep code compact.
             */
            enable: function (depMap) {
                var mod = getOwn(registry, depMap.id);
                if (mod) {
                    getModule(depMap).enable();
                }
            },

            /**
             * Internal method used by environment adapters to complete a load event.
             * A load event could be a script load or just a load pass from a synchronous
             * load call.
             * @param {String} moduleName the name of the module to potentially complete.
             */
            completeLoad: function (moduleName) {
                var found, args, mod,
                    shim = getOwn(config.shim, moduleName) || {},
                    shExports = shim.exports;

                takeGlobalQueue();

                while (defQueue.length) {
                    args = defQueue.shift();
                    if (args[0] === null) {
                        args[0] = moduleName;
                        //If already found an anonymous module and bound it
                        //to this name, then this is some other anon module
                        //waiting for its completeLoad to fire.
                        if (found) {
                            break;
                        }
                        found = true;
                    } else if (args[0] === moduleName) {
                        //Found matching define call for this script!
                        found = true;
                    }

                    callGetModule(args);
                }
                context.defQueueMap = {};

                //Do this after the cycle of callGetModule in case the result
                //of those calls/init calls changes the registry.
                mod = getOwn(registry, moduleName);

                if (!found && !hasProp(defined, moduleName) && mod && !mod.inited) {
                    if (config.enforceDefine && (!shExports || !getGlobal(shExports))) {
                        if (hasPathFallback(moduleName)) {
                            return;
                        } else {
                            return onError(makeError('nodefine',
                                             'No define call for ' + moduleName,
                                             null,
                                             [moduleName]));
                        }
                    } else {
                        //A script that does not call define(), so just simulate
                        //the call for it.
                        callGetModule([moduleName, (shim.deps || []), shim.exportsFn]);
                    }
                }

                checkLoaded();
            },

            /**
             * Converts a module name to a file path. Supports cases where
             * moduleName may actually be just an URL.
             * Note that it **does not** call normalize on the moduleName,
             * it is assumed to have already been normalized. This is an
             * internal API, not a public one. Use toUrl for the public API.
             */
            nameToUrl: function (moduleName, ext, skipExt) {
                var paths, syms, i, parentModule, url,
                    parentPath, bundleId,
                    pkgMain = getOwn(config.pkgs, moduleName);

                if (pkgMain) {
                    moduleName = pkgMain;
                }

                bundleId = getOwn(bundlesMap, moduleName);

                if (bundleId) {
                    return context.nameToUrl(bundleId, ext, skipExt);
                }

                //If a colon is in the URL, it indicates a protocol is used and it is just
                //an URL to a file, or if it starts with a slash, contains a query arg (i.e. ?)
                //or ends with .js, then assume the user meant to use an url and not a module id.
                //The slash is important for protocol-less URLs as well as full paths.
                if (req.jsExtRegExp.test(moduleName)) {
                    //Just a plain path, not module name lookup, so just return it.
                    //Add extension if it is included. This is a bit wonky, only non-.js things pass
                    //an extension, this method probably needs to be reworked.
                    url = moduleName + (ext || '');
                } else {
                    //A module that needs to be converted to a path.
                    paths = config.paths;

                    syms = moduleName.split('/');
                    //For each module name segment, see if there is a path
                    //registered for it. Start with most specific name
                    //and work up from it.
                    for (i = syms.length; i > 0; i -= 1) {
                        parentModule = syms.slice(0, i).join('/');

                        parentPath = getOwn(paths, parentModule);
                        if (parentPath) {
                            //If an array, it means there are a few choices,
                            //Choose the one that is desired
                            if (isArray(parentPath)) {
                                parentPath = parentPath[0];
                            }
                            syms.splice(0, i, parentPath);
                            break;
                        }
                    }

                    //Join the path parts together, then figure out if baseUrl is needed.
                    url = syms.join('/');
                    url += (ext || (/^data\:|^blob\:|\?/.test(url) || skipExt ? '' : '.js'));
                    url = (url.charAt(0) === '/' || url.match(/^[\w\+\.\-]+:/) ? '' : config.baseUrl) + url;
                }

                return config.urlArgs && !/^blob\:/.test(url) ?
                       url + config.urlArgs(moduleName, url) : url;
            },

            //Delegates to req.load. Broken out as a separate function to
            //allow overriding in the optimizer.
            load: function (id, url) {
                req.load(context, id, url);
            },

            /**
             * Executes a module callback function. Broken out as a separate function
             * solely to allow the build system to sequence the files in the built
             * layer in the right sequence.
             *
             * @private
             */
            execCb: function (name, callback, args, exports) {
                return callback.apply(exports, args);
            },

            /**
             * callback for script loads, used to check status of loading.
             *
             * @param {Event} evt the event from the browser for the script
             * that was loaded.
             */
            onScriptLoad: function (evt) {
                //Using currentTarget instead of target for Firefox 2.0's sake. Not
                //all old browsers will be supported, but this one was easy enough
                //to support and still makes sense.
                if (evt.type === 'load' ||
                        (readyRegExp.test((evt.currentTarget || evt.srcElement).readyState))) {
                    //Reset interactive script so a script node is not held onto for
                    //to long.
                    interactiveScript = null;

                    //Pull out the name of the module and the context.
                    var data = getScriptData(evt);
                    context.completeLoad(data.id);
                }
            },

            /**
             * Callback for script errors.
             */
            onScriptError: function (evt) {
                var data = getScriptData(evt);
                if (!hasPathFallback(data.id)) {
                    var parents = [];
                    eachProp(registry, function(value, key) {
                        if (key.indexOf('_@r') !== 0) {
                            each(value.depMaps, function(depMap) {
                                if (depMap.id === data.id) {
                                    parents.push(key);
                                    return true;
                                }
                            });
                        }
                    });
                    return onError(makeError('scripterror', 'Script error for "' + data.id +
                                             (parents.length ?
                                             '", needed by: ' + parents.join(', ') :
                                             '"'), evt, [data.id]));
                }
            }
        };

        context.require = context.makeRequire();
        return context;
    }

    /**
     * Main entry point.
     *
     * If the only argument to require is a string, then the module that
     * is represented by that string is fetched for the appropriate context.
     *
     * If the first argument is an array, then it will be treated as an array
     * of dependency string names to fetch. An optional function callback can
     * be specified to execute when all of those dependencies are available.
     *
     * Make a local req variable to help Caja compliance (it assumes things
     * on a require that are not standardized), and to give a short
     * name for minification/local scope use.
     */
    req = requirejs = function (deps, callback, errback, optional) {

        //Find the right context, use default
        var context, config,
            contextName = defContextName;

        // Determine if have config object in the call.
        if (!isArray(deps) && typeof deps !== 'string') {
            // deps is a config object
            config = deps;
            if (isArray(callback)) {
                // Adjust args if there are dependencies
                deps = callback;
                callback = errback;
                errback = optional;
            } else {
                deps = [];
            }
        }

        if (config && config.context) {
            contextName = config.context;
        }

        context = getOwn(contexts, contextName);
        if (!context) {
            context = contexts[contextName] = req.s.newContext(contextName);
        }

        if (config) {
            context.configure(config);
        }

        return context.require(deps, callback, errback);
    };

    /**
     * Support require.config() to make it easier to cooperate with other
     * AMD loaders on globally agreed names.
     */
    req.config = function (config) {
        return req(config);
    };

    /**
     * Execute something after the current tick
     * of the event loop. Override for other envs
     * that have a better solution than setTimeout.
     * @param  {Function} fn function to execute later.
     */
    req.nextTick = typeof setTimeout !== 'undefined' ? function (fn) {
        setTimeout(fn, 4);
    } : function (fn) { fn(); };

    /**
     * Export require as a global, but only if it does not already exist.
     */
    if (!require) {
        require = req;
    }

    req.version = version;

    //Used to filter out dependencies that are already paths.
    req.jsExtRegExp = /^\/|:|\?|\.js$/;
    req.isBrowser = isBrowser;
    s = req.s = {
        contexts: contexts,
        newContext: newContext
    };

    //Create default context.
    req({});

    //Exports some context-sensitive methods on global require.
    each([
        'toUrl',
        'undef',
        'defined',
        'specified'
    ], function (prop) {
        //Reference from contexts instead of early binding to default context,
        //so that during builds, the latest instance of the default context
        //with its config gets used.
        req[prop] = function () {
            var ctx = contexts[defContextName];
            return ctx.require[prop].apply(ctx, arguments);
        };
    });

    if (isBrowser) {
        head = s.head = document.getElementsByTagName('head')[0];
        //If BASE tag is in play, using appendChild is a problem for IE6.
        //When that browser dies, this can be removed. Details in this jQuery bug:
        //http://dev.jquery.com/ticket/2709
        baseElement = document.getElementsByTagName('base')[0];
        if (baseElement) {
            head = s.head = baseElement.parentNode;
        }
    }

    /**
     * Any errors that require explicitly generates will be passed to this
     * function. Intercept/override it if you want custom error handling.
     * @param {Error} err the error object.
     */
    req.onError = defaultOnError;

    /**
     * Creates the node for the load command. Only used in browser envs.
     */
    req.createNode = function (config, moduleName, url) {
        var node = config.xhtml ?
                document.createElementNS('http://www.w3.org/1999/xhtml', 'html:script') :
                document.createElement('script');
        node.type = config.scriptType || 'text/javascript';
        node.charset = 'utf-8';
        node.async = true;
        return node;
    };

    /**
     * Does the request to load a module for the browser case.
     * Make this a separate function to allow other environments
     * to override it.
     *
     * @param {Object} context the require context to find state.
     * @param {String} moduleName the name of the module.
     * @param {Object} url the URL to the module.
     */
    req.load = function (context, moduleName, url) {
        var config = (context && context.config) || {},
            node;
        if (isBrowser) {
            //In the browser so use a script tag
            node = req.createNode(config, moduleName, url);

            node.setAttribute('data-requirecontext', context.contextName);
            node.setAttribute('data-requiremodule', moduleName);

            //Set up load listener. Test attachEvent first because IE9 has
            //a subtle issue in its addEventListener and script onload firings
            //that do not match the behavior of all other browsers with
            //addEventListener support, which fire the onload event for a
            //script right after the script execution. See:
            //https://connect.microsoft.com/IE/feedback/details/648057/script-onload-event-is-not-fired-immediately-after-script-execution
            //UNFORTUNATELY Opera implements attachEvent but does not follow the script
            //script execution mode.
            if (node.attachEvent &&
                    //Check if node.attachEvent is artificially added by custom script or
                    //natively supported by browser
                    //read https://github.com/requirejs/requirejs/issues/187
                    //if we can NOT find [native code] then it must NOT natively supported.
                    //in IE8, node.attachEvent does not have toString()
                    //Note the test for "[native code" with no closing brace, see:
                    //https://github.com/requirejs/requirejs/issues/273
                    !(node.attachEvent.toString && node.attachEvent.toString().indexOf('[native code') < 0) &&
                    !isOpera) {
                //Probably IE. IE (at least 6-8) do not fire
                //script onload right after executing the script, so
                //we cannot tie the anonymous define call to a name.
                //However, IE reports the script as being in 'interactive'
                //readyState at the time of the define call.
                useInteractive = true;

                node.attachEvent('onreadystatechange', context.onScriptLoad);
                //It would be great to add an error handler here to catch
                //404s in IE9+. However, onreadystatechange will fire before
                //the error handler, so that does not help. If addEventListener
                //is used, then IE will fire error before load, but we cannot
                //use that pathway given the connect.microsoft.com issue
                //mentioned above about not doing the 'script execute,
                //then fire the script load event listener before execute
                //next script' that other browsers do.
                //Best hope: IE10 fixes the issues,
                //and then destroys all installs of IE 6-9.
                //node.attachEvent('onerror', context.onScriptError);
            } else {
                node.addEventListener('load', context.onScriptLoad, false);
                node.addEventListener('error', context.onScriptError, false);
            }
            node.src = url;

            //Calling onNodeCreated after all properties on the node have been
            //set, but before it is placed in the DOM.
            if (config.onNodeCreated) {
                config.onNodeCreated(node, config, moduleName, url);
            }

            //For some cache cases in IE 6-8, the script executes before the end
            //of the appendChild execution, so to tie an anonymous define
            //call to the module name (which is stored on the node), hold on
            //to a reference to this node, but clear after the DOM insertion.
            currentlyAddingScript = node;
            if (baseElement) {
                head.insertBefore(node, baseElement);
            } else {
                head.appendChild(node);
            }
            currentlyAddingScript = null;

            return node;
        } else if (isWebWorker) {
            try {
                //In a web worker, use importScripts. This is not a very
                //efficient use of importScripts, importScripts will block until
                //its script is downloaded and evaluated. However, if web workers
                //are in play, the expectation is that a build has been done so
                //that only one script needs to be loaded anyway. This may need
                //to be reevaluated if other use cases become common.

                // Post a task to the event loop to work around a bug in WebKit
                // where the worker gets garbage-collected after calling
                // importScripts(): https://webkit.org/b/153317
                setTimeout(function() {}, 0);
                importScripts(url);

                //Account for anonymous modules
                context.completeLoad(moduleName);
            } catch (e) {
                context.onError(makeError('importscripts',
                                'importScripts failed for ' +
                                    moduleName + ' at ' + url,
                                e,
                                [moduleName]));
            }
        }
    };

    function getInteractiveScript() {
        if (interactiveScript && interactiveScript.readyState === 'interactive') {
            return interactiveScript;
        }

        eachReverse(scripts(), function (script) {
            if (script.readyState === 'interactive') {
                return (interactiveScript = script);
            }
        });
        return interactiveScript;
    }

    //Look for a data-main script attribute, which could also adjust the baseUrl.
    if (isBrowser && !cfg.skipDataMain) {
        //Figure out baseUrl. Get it from the script tag with require.js in it.
        eachReverse(scripts(), function (script) {
            //Set the 'head' where we can append children by
            //using the script's parent.
            if (!head) {
                head = script.parentNode;
            }

            //Look for a data-main attribute to set main script for the page
            //to load. If it is there, the path to data main becomes the
            //baseUrl, if it is not already set.
            dataMain = script.getAttribute('data-main');
            if (dataMain) {
                //Preserve dataMain in case it is a path (i.e. contains '?')
                mainScript = dataMain;

                //Set final baseUrl if there is not already an explicit one,
                //but only do so if the data-main value is not a loader plugin
                //module ID.
                if (!cfg.baseUrl && mainScript.indexOf('!') === -1) {
                    //Pull off the directory of data-main for use as the
                    //baseUrl.
                    src = mainScript.split('/');
                    mainScript = src.pop();
                    subPath = src.length ? src.join('/')  + '/' : './';

                    cfg.baseUrl = subPath;
                }

                //Strip off any trailing .js since mainScript is now
                //like a module name.
                mainScript = mainScript.replace(jsSuffixRegExp, '');

                //If mainScript is still a path, fall back to dataMain
                if (req.jsExtRegExp.test(mainScript)) {
                    mainScript = dataMain;
                }

                //Put the data-main script in the files to load.
                cfg.deps = cfg.deps ? cfg.deps.concat(mainScript) : [mainScript];

                return true;
            }
        });
    }

    /**
     * The function that handles definitions of modules. Differs from
     * require() in that a string for the module should be the first argument,
     * and the function to execute after dependencies are loaded should
     * return a value to define the module corresponding to the first argument's
     * name.
     */
    define = function (name, deps, callback) {
        var node, context;

        //Allow for anonymous modules
        if (typeof name !== 'string') {
            //Adjust args appropriately
            callback = deps;
            deps = name;
            name = null;
        }

        //This module may not have dependencies
        if (!isArray(deps)) {
            callback = deps;
            deps = null;
        }

        //If no name, and callback is a function, then figure out if it a
        //CommonJS thing with dependencies.
        if (!deps && isFunction(callback)) {
            deps = [];
            //Remove comments from the callback string,
            //look for require calls, and pull them into the dependencies,
            //but only if there are function args.
            if (callback.length) {
                callback
                    .toString()
                    .replace(commentRegExp, commentReplace)
                    .replace(cjsRequireRegExp, function (match, dep) {
                        deps.push(dep);
                    });

                //May be a CommonJS thing even without require calls, but still
                //could use exports, and module. Avoid doing exports and module
                //work though if it just needs require.
                //REQUIRES the function to expect the CommonJS variables in the
                //order listed below.
                deps = (callback.length === 1 ? ['require'] : ['require', 'exports', 'module']).concat(deps);
            }
        }

        //If in IE 6-8 and hit an anonymous define() call, do the interactive
        //work.
        if (useInteractive) {
            node = currentlyAddingScript || getInteractiveScript();
            if (node) {
                if (!name) {
                    name = node.getAttribute('data-requiremodule');
                }
                context = contexts[node.getAttribute('data-requirecontext')];
            }
        }

        //Always save off evaluating the def call until the script onload handler.
        //This allows multiple modules to be in a file without prematurely
        //tracing dependencies, and allows for anonymous module support,
        //where the module name is not known until the script onload event
        //occurs. If no context, use the global queue, and get it processed
        //in the onscript load callback.
        if (context) {
            context.defQueue.push([name, deps, callback]);
            context.defQueueMap[name] = true;
        } else {
            globalDefQueue.push([name, deps, callback]);
        }
    };

    define.amd = {
        jQuery: true
    };

    /**
     * Executes the text. Normally just uses eval, but can be modified
     * to use a better, environment-specific call. Only used for transpiling
     * loader plugins, not for plain JS modules.
     * @param {String} text the text to execute/evaluate.
     */
    req.exec = function (text) {
        /*jslint evil: true */
        return eval(text);
    };

    //Set up with config info.
    req(cfg);
}(this, (typeof setTimeout === 'undefined' ? undefined : setTimeout)));

// Copyright 2014 Google Inc. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
//     You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//     See the License for the specific language governing permissions and
// limitations under the License.

!function(){var a={},b={},c={};!function(a,b){function c(a){if("number"==typeof a)return a;var b={};for(var c in a)b[c]=a[c];return b}function d(){this._delay=0,this._endDelay=0,this._fill="none",this._iterationStart=0,this._iterations=1,this._duration=0,this._playbackRate=1,this._direction="normal",this._easing="linear",this._easingFunction=x}function e(){return a.isDeprecated("Invalid timing inputs","2016-03-02","TypeError exceptions will be thrown instead.",!0)}function f(b,c,e){var f=new d;return c&&(f.fill="both",f.duration="auto"),"number"!=typeof b||isNaN(b)?void 0!==b&&Object.getOwnPropertyNames(b).forEach(function(c){if("auto"!=b[c]){if(("number"==typeof f[c]||"duration"==c)&&("number"!=typeof b[c]||isNaN(b[c])))return;if("fill"==c&&-1==v.indexOf(b[c]))return;if("direction"==c&&-1==w.indexOf(b[c]))return;if("playbackRate"==c&&1!==b[c]&&a.isDeprecated("AnimationEffectTiming.playbackRate","2014-11-28","Use Animation.playbackRate instead."))return;f[c]=b[c]}}):f.duration=b,f}function g(a){return"number"==typeof a&&(a=isNaN(a)?{duration:0}:{duration:a}),a}function h(b,c){return b=a.numericTimingToObject(b),f(b,c)}function i(a,b,c,d){return a<0||a>1||c<0||c>1?x:function(e){function f(a,b,c){return 3*a*(1-c)*(1-c)*c+3*b*(1-c)*c*c+c*c*c}if(e<=0){var g=0;return a>0?g=b/a:!b&&c>0&&(g=d/c),g*e}if(e>=1){var h=0;return c<1?h=(d-1)/(c-1):1==c&&a<1&&(h=(b-1)/(a-1)),1+h*(e-1)}for(var i=0,j=1;i<j;){var k=(i+j)/2,l=f(a,c,k);if(Math.abs(e-l)<1e-5)return f(b,d,k);l<e?i=k:j=k}return f(b,d,k)}}function j(a,b){return function(c){if(c>=1)return 1;var d=1/a;return(c+=b*d)-c%d}}function k(a){C||(C=document.createElement("div").style),C.animationTimingFunction="",C.animationTimingFunction=a;var b=C.animationTimingFunction;if(""==b&&e())throw new TypeError(a+" is not a valid value for easing");return b}function l(a){if("linear"==a)return x;var b=E.exec(a);if(b)return i.apply(this,b.slice(1).map(Number));var c=F.exec(a);if(c)return j(Number(c[1]),A);var d=G.exec(a);return d?j(Number(d[1]),{start:y,middle:z,end:A}[d[2]]):B[a]||x}function m(a){return Math.abs(n(a)/a.playbackRate)}function n(a){return 0===a.duration||0===a.iterations?0:a.duration*a.iterations}function o(a,b,c){if(null==b)return H;var d=c.delay+a+c.endDelay;return b<Math.min(c.delay,d)?I:b>=Math.min(c.delay+a,d)?J:K}function p(a,b,c,d,e){switch(d){case I:return"backwards"==b||"both"==b?0:null;case K:return c-e;case J:return"forwards"==b||"both"==b?a:null;case H:return null}}function q(a,b,c,d,e){var f=e;return 0===a?b!==I&&(f+=c):f+=d/a,f}function r(a,b,c,d,e,f){var g=a===1/0?b%1:a%1;return 0!==g||c!==J||0===d||0===e&&0!==f||(g=1),g}function s(a,b,c,d){return a===J&&b===1/0?1/0:1===c?Math.floor(d)-1:Math.floor(d)}function t(a,b,c){var d=a;if("normal"!==a&&"reverse"!==a){var e=b;"alternate-reverse"===a&&(e+=1),d="normal",e!==1/0&&e%2!=0&&(d="reverse")}return"normal"===d?c:1-c}function u(a,b,c){var d=o(a,b,c),e=p(a,c.fill,b,d,c.delay);if(null===e)return null;var f=q(c.duration,d,c.iterations,e,c.iterationStart),g=r(f,c.iterationStart,d,c.iterations,e,c.duration),h=s(d,c.iterations,g,f),i=t(c.direction,h,g);return c._easingFunction(i)}var v="backwards|forwards|both|none".split("|"),w="reverse|alternate|alternate-reverse".split("|"),x=function(a){return a};d.prototype={_setMember:function(b,c){this["_"+b]=c,this._effect&&(this._effect._timingInput[b]=c,this._effect._timing=a.normalizeTimingInput(this._effect._timingInput),this._effect.activeDuration=a.calculateActiveDuration(this._effect._timing),this._effect._animation&&this._effect._animation._rebuildUnderlyingAnimation())},get playbackRate(){return this._playbackRate},set delay(a){this._setMember("delay",a)},get delay(){return this._delay},set endDelay(a){this._setMember("endDelay",a)},get endDelay(){return this._endDelay},set fill(a){this._setMember("fill",a)},get fill(){return this._fill},set iterationStart(a){if((isNaN(a)||a<0)&&e())throw new TypeError("iterationStart must be a non-negative number, received: "+a);this._setMember("iterationStart",a)},get iterationStart(){return this._iterationStart},set duration(a){if("auto"!=a&&(isNaN(a)||a<0)&&e())throw new TypeError("duration must be non-negative or auto, received: "+a);this._setMember("duration",a)},get duration(){return this._duration},set direction(a){this._setMember("direction",a)},get direction(){return this._direction},set easing(a){this._easingFunction=l(k(a)),this._setMember("easing",a)},get easing(){return this._easing},set iterations(a){if((isNaN(a)||a<0)&&e())throw new TypeError("iterations must be non-negative, received: "+a);this._setMember("iterations",a)},get iterations(){return this._iterations}};var y=1,z=.5,A=0,B={ease:i(.25,.1,.25,1),"ease-in":i(.42,0,1,1),"ease-out":i(0,0,.58,1),"ease-in-out":i(.42,0,.58,1),"step-start":j(1,y),"step-middle":j(1,z),"step-end":j(1,A)},C=null,D="\\s*(-?\\d+\\.?\\d*|-?\\.\\d+)\\s*",E=new RegExp("cubic-bezier\\("+D+","+D+","+D+","+D+"\\)"),F=/steps\(\s*(\d+)\s*\)/,G=/steps\(\s*(\d+)\s*,\s*(start|middle|end)\s*\)/,H=0,I=1,J=2,K=3;a.cloneTimingInput=c,a.makeTiming=f,a.numericTimingToObject=g,a.normalizeTimingInput=h,a.calculateActiveDuration=m,a.calculateIterationProgress=u,a.calculatePhase=o,a.normalizeEasing=k,a.parseEasingFunction=l}(a),function(a,b){function c(a,b){return a in k?k[a][b]||b:b}function d(a){return"display"===a||0===a.lastIndexOf("animation",0)||0===a.lastIndexOf("transition",0)}function e(a,b,e){if(!d(a)){var f=h[a];if(f){i.style[a]=b;for(var g in f){var j=f[g],k=i.style[j];e[j]=c(j,k)}}else e[a]=c(a,b)}}function f(a){var b=[];for(var c in a)if(!(c in["easing","offset","composite"])){var d=a[c];Array.isArray(d)||(d=[d]);for(var e,f=d.length,g=0;g<f;g++)e={},e.offset="offset"in a?a.offset:1==f?1:g/(f-1),"easing"in a&&(e.easing=a.easing),"composite"in a&&(e.composite=a.composite),e[c]=d[g],b.push(e)}return b.sort(function(a,b){return a.offset-b.offset}),b}function g(b){function c(){var a=d.length;null==d[a-1].offset&&(d[a-1].offset=1),a>1&&null==d[0].offset&&(d[0].offset=0);for(var b=0,c=d[0].offset,e=1;e<a;e++){var f=d[e].offset;if(null!=f){for(var g=1;g<e-b;g++)d[b+g].offset=c+(f-c)*g/(e-b);b=e,c=f}}}if(null==b)return[];window.Symbol&&Symbol.iterator&&Array.prototype.from&&b[Symbol.iterator]&&(b=Array.from(b)),Array.isArray(b)||(b=f(b));for(var d=b.map(function(b){var c={};for(var d in b){var f=b[d];if("offset"==d){if(null!=f){if(f=Number(f),!isFinite(f))throw new TypeError("Keyframe offsets must be numbers.");if(f<0||f>1)throw new TypeError("Keyframe offsets must be between 0 and 1.")}}else if("composite"==d){if("add"==f||"accumulate"==f)throw{type:DOMException.NOT_SUPPORTED_ERR,name:"NotSupportedError",message:"add compositing is not supported"};if("replace"!=f)throw new TypeError("Invalid composite mode "+f+".")}else f="easing"==d?a.normalizeEasing(f):""+f;e(d,f,c)}return void 0==c.offset&&(c.offset=null),void 0==c.easing&&(c.easing="linear"),c}),g=!0,h=-1/0,i=0;i<d.length;i++){var j=d[i].offset;if(null!=j){if(j<h)throw new TypeError("Keyframes are not loosely sorted by offset. Sort or specify offsets.");h=j}else g=!1}return d=d.filter(function(a){return a.offset>=0&&a.offset<=1}),g||c(),d}var h={background:["backgroundImage","backgroundPosition","backgroundSize","backgroundRepeat","backgroundAttachment","backgroundOrigin","backgroundClip","backgroundColor"],border:["borderTopColor","borderTopStyle","borderTopWidth","borderRightColor","borderRightStyle","borderRightWidth","borderBottomColor","borderBottomStyle","borderBottomWidth","borderLeftColor","borderLeftStyle","borderLeftWidth"],borderBottom:["borderBottomWidth","borderBottomStyle","borderBottomColor"],borderColor:["borderTopColor","borderRightColor","borderBottomColor","borderLeftColor"],borderLeft:["borderLeftWidth","borderLeftStyle","borderLeftColor"],borderRadius:["borderTopLeftRadius","borderTopRightRadius","borderBottomRightRadius","borderBottomLeftRadius"],borderRight:["borderRightWidth","borderRightStyle","borderRightColor"],borderTop:["borderTopWidth","borderTopStyle","borderTopColor"],borderWidth:["borderTopWidth","borderRightWidth","borderBottomWidth","borderLeftWidth"],flex:["flexGrow","flexShrink","flexBasis"],font:["fontFamily","fontSize","fontStyle","fontVariant","fontWeight","lineHeight"],margin:["marginTop","marginRight","marginBottom","marginLeft"],outline:["outlineColor","outlineStyle","outlineWidth"],padding:["paddingTop","paddingRight","paddingBottom","paddingLeft"]},i=document.createElementNS("http://www.w3.org/1999/xhtml","div"),j={thin:"1px",medium:"3px",thick:"5px"},k={borderBottomWidth:j,borderLeftWidth:j,borderRightWidth:j,borderTopWidth:j,fontSize:{"xx-small":"60%","x-small":"75%",small:"89%",medium:"100%",large:"120%","x-large":"150%","xx-large":"200%"},fontWeight:{normal:"400",bold:"700"},outlineWidth:j,textShadow:{none:"0px 0px 0px transparent"},boxShadow:{none:"0px 0px 0px 0px transparent"}};a.convertToArrayForm=f,a.normalizeKeyframes=g}(a),function(a){var b={};a.isDeprecated=function(a,c,d,e){var f=e?"are":"is",g=new Date,h=new Date(c);return h.setMonth(h.getMonth()+3),!(g<h&&(a in b||console.warn("Web Animations: "+a+" "+f+" deprecated and will stop working on "+h.toDateString()+". "+d),b[a]=!0,1))},a.deprecated=function(b,c,d,e){var f=e?"are":"is";if(a.isDeprecated(b,c,d,e))throw new Error(b+" "+f+" no longer supported. "+d)}}(a),function(){if(document.documentElement.animate){var c=document.documentElement.animate([],0),d=!0;if(c&&(d=!1,"play|currentTime|pause|reverse|playbackRate|cancel|finish|startTime|playState".split("|").forEach(function(a){void 0===c[a]&&(d=!0)})),!d)return}!function(a,b,c){function d(a){for(var b={},c=0;c<a.length;c++)for(var d in a[c])if("offset"!=d&&"easing"!=d&&"composite"!=d){var e={offset:a[c].offset,easing:a[c].easing,value:a[c][d]};b[d]=b[d]||[],b[d].push(e)}for(var f in b){var g=b[f];if(0!=g[0].offset||1!=g[g.length-1].offset)throw{type:DOMException.NOT_SUPPORTED_ERR,name:"NotSupportedError",message:"Partial keyframes are not supported"}}return b}function e(c){var d=[];for(var e in c)for(var f=c[e],g=0;g<f.length-1;g++){var h=g,i=g+1,j=f[h].offset,k=f[i].offset,l=j,m=k;0==g&&(l=-1/0,0==k&&(i=h)),g==f.length-2&&(m=1/0,1==j&&(h=i)),d.push({applyFrom:l,applyTo:m,startOffset:f[h].offset,endOffset:f[i].offset,easingFunction:a.parseEasingFunction(f[h].easing),property:e,interpolation:b.propertyInterpolation(e,f[h].value,f[i].value)})}return d.sort(function(a,b){return a.startOffset-b.startOffset}),d}b.convertEffectInput=function(c){var f=a.normalizeKeyframes(c),g=d(f),h=e(g);return function(a,c){if(null!=c)h.filter(function(a){return c>=a.applyFrom&&c<a.applyTo}).forEach(function(d){var e=c-d.startOffset,f=d.endOffset-d.startOffset,g=0==f?0:d.easingFunction(e/f);b.apply(a,d.property,d.interpolation(g))});else for(var d in g)"offset"!=d&&"easing"!=d&&"composite"!=d&&b.clear(a,d)}}}(a,b),function(a,b,c){function d(a){return a.replace(/-(.)/g,function(a,b){return b.toUpperCase()})}function e(a,b,c){h[c]=h[c]||[],h[c].push([a,b])}function f(a,b,c){for(var f=0;f<c.length;f++){e(a,b,d(c[f]))}}function g(c,e,f){var g=c;/-/.test(c)&&!a.isDeprecated("Hyphenated property names","2016-03-22","Use camelCase instead.",!0)&&(g=d(c)),"initial"!=e&&"initial"!=f||("initial"==e&&(e=i[g]),"initial"==f&&(f=i[g]));for(var j=e==f?[]:h[g],k=0;j&&k<j.length;k++){var l=j[k][0](e),m=j[k][0](f);if(void 0!==l&&void 0!==m){var n=j[k][1](l,m);if(n){var o=b.Interpolation.apply(null,n);return function(a){return 0==a?e:1==a?f:o(a)}}}}return b.Interpolation(!1,!0,function(a){return a?f:e})}var h={};b.addPropertiesHandler=f;var i={backgroundColor:"transparent",backgroundPosition:"0% 0%",borderBottomColor:"currentColor",borderBottomLeftRadius:"0px",borderBottomRightRadius:"0px",borderBottomWidth:"3px",borderLeftColor:"currentColor",borderLeftWidth:"3px",borderRightColor:"currentColor",borderRightWidth:"3px",borderSpacing:"2px",borderTopColor:"currentColor",borderTopLeftRadius:"0px",borderTopRightRadius:"0px",borderTopWidth:"3px",bottom:"auto",clip:"rect(0px, 0px, 0px, 0px)",color:"black",fontSize:"100%",fontWeight:"400",height:"auto",left:"auto",letterSpacing:"normal",lineHeight:"120%",marginBottom:"0px",marginLeft:"0px",marginRight:"0px",marginTop:"0px",maxHeight:"none",maxWidth:"none",minHeight:"0px",minWidth:"0px",opacity:"1.0",outlineColor:"invert",outlineOffset:"0px",outlineWidth:"3px",paddingBottom:"0px",paddingLeft:"0px",paddingRight:"0px",paddingTop:"0px",right:"auto",strokeDasharray:"none",strokeDashoffset:"0px",textIndent:"0px",textShadow:"0px 0px 0px transparent",top:"auto",transform:"",verticalAlign:"0px",visibility:"visible",width:"auto",wordSpacing:"normal",zIndex:"auto"};b.propertyInterpolation=g}(a,b),function(a,b,c){function d(b){var c=a.calculateActiveDuration(b),d=function(d){return a.calculateIterationProgress(c,d,b)};return d._totalDuration=b.delay+c+b.endDelay,d}b.KeyframeEffect=function(c,e,f,g){var h,i=d(a.normalizeTimingInput(f)),j=b.convertEffectInput(e),k=function(){j(c,h)};return k._update=function(a){return null!==(h=i(a))},k._clear=function(){j(c,null)},k._hasSameTarget=function(a){return c===a},k._target=c,k._totalDuration=i._totalDuration,k._id=g,k}}(a,b),function(a,b){a.apply=function(b,c,d){b.style[a.propertyName(c)]=d},a.clear=function(b,c){b.style[a.propertyName(c)]=""}}(b),function(a){window.Element.prototype.animate=function(b,c){var d="";return c&&c.id&&(d=c.id),a.timeline._play(a.KeyframeEffect(this,b,c,d))}}(b),function(a,b){function c(a,b,d){if("number"==typeof a&&"number"==typeof b)return a*(1-d)+b*d;if("boolean"==typeof a&&"boolean"==typeof b)return d<.5?a:b;if(a.length==b.length){for(var e=[],f=0;f<a.length;f++)e.push(c(a[f],b[f],d));return e}throw"Mismatched interpolation arguments "+a+":"+b}a.Interpolation=function(a,b,d){return function(e){return d(c(a,b,e))}}}(b),function(a,b,c){a.sequenceNumber=0;var d=function(a,b,c){this.target=a,this.currentTime=b,this.timelineTime=c,this.type="finish",this.bubbles=!1,this.cancelable=!1,this.currentTarget=a,this.defaultPrevented=!1,this.eventPhase=Event.AT_TARGET,this.timeStamp=Date.now()};b.Animation=function(b){this.id="",b&&b._id&&(this.id=b._id),this._sequenceNumber=a.sequenceNumber++,this._currentTime=0,this._startTime=null,this._paused=!1,this._playbackRate=1,this._inTimeline=!0,this._finishedFlag=!0,this.onfinish=null,this._finishHandlers=[],this._effect=b,this._inEffect=this._effect._update(0),this._idle=!0,this._currentTimePending=!1},b.Animation.prototype={_ensureAlive:function(){this.playbackRate<0&&0===this.currentTime?this._inEffect=this._effect._update(-1):this._inEffect=this._effect._update(this.currentTime),this._inTimeline||!this._inEffect&&this._finishedFlag||(this._inTimeline=!0,b.timeline._animations.push(this))},_tickCurrentTime:function(a,b){a!=this._currentTime&&(this._currentTime=a,this._isFinished&&!b&&(this._currentTime=this._playbackRate>0?this._totalDuration:0),this._ensureAlive())},get currentTime(){return this._idle||this._currentTimePending?null:this._currentTime},set currentTime(a){a=+a,isNaN(a)||(b.restart(),this._paused||null==this._startTime||(this._startTime=this._timeline.currentTime-a/this._playbackRate),this._currentTimePending=!1,this._currentTime!=a&&(this._idle&&(this._idle=!1,this._paused=!0),this._tickCurrentTime(a,!0),b.applyDirtiedAnimation(this)))},get startTime(){return this._startTime},set startTime(a){a=+a,isNaN(a)||this._paused||this._idle||(this._startTime=a,this._tickCurrentTime((this._timeline.currentTime-this._startTime)*this.playbackRate),b.applyDirtiedAnimation(this))},get playbackRate(){return this._playbackRate},set playbackRate(a){if(a!=this._playbackRate){var c=this.currentTime;this._playbackRate=a,this._startTime=null,"paused"!=this.playState&&"idle"!=this.playState&&(this._finishedFlag=!1,this._idle=!1,this._ensureAlive(),b.applyDirtiedAnimation(this)),null!=c&&(this.currentTime=c)}},get _isFinished(){return!this._idle&&(this._playbackRate>0&&this._currentTime>=this._totalDuration||this._playbackRate<0&&this._currentTime<=0)},get _totalDuration(){return this._effect._totalDuration},get playState(){return this._idle?"idle":null==this._startTime&&!this._paused&&0!=this.playbackRate||this._currentTimePending?"pending":this._paused?"paused":this._isFinished?"finished":"running"},_rewind:function(){if(this._playbackRate>=0)this._currentTime=0;else{if(!(this._totalDuration<1/0))throw new DOMException("Unable to rewind negative playback rate animation with infinite duration","InvalidStateError");this._currentTime=this._totalDuration}},play:function(){this._paused=!1,(this._isFinished||this._idle)&&(this._rewind(),this._startTime=null),this._finishedFlag=!1,this._idle=!1,this._ensureAlive(),b.applyDirtiedAnimation(this)},pause:function(){this._isFinished||this._paused||this._idle?this._idle&&(this._rewind(),this._idle=!1):this._currentTimePending=!0,this._startTime=null,this._paused=!0},finish:function(){this._idle||(this.currentTime=this._playbackRate>0?this._totalDuration:0,this._startTime=this._totalDuration-this.currentTime,this._currentTimePending=!1,b.applyDirtiedAnimation(this))},cancel:function(){this._inEffect&&(this._inEffect=!1,this._idle=!0,this._paused=!1,this._finishedFlag=!0,this._currentTime=0,this._startTime=null,this._effect._update(null),b.applyDirtiedAnimation(this))},reverse:function(){this.playbackRate*=-1,this.play()},addEventListener:function(a,b){"function"==typeof b&&"finish"==a&&this._finishHandlers.push(b)},removeEventListener:function(a,b){if("finish"==a){var c=this._finishHandlers.indexOf(b);c>=0&&this._finishHandlers.splice(c,1)}},_fireEvents:function(a){if(this._isFinished){if(!this._finishedFlag){var b=new d(this,this._currentTime,a),c=this._finishHandlers.concat(this.onfinish?[this.onfinish]:[]);setTimeout(function(){c.forEach(function(a){a.call(b.target,b)})},0),this._finishedFlag=!0}}else this._finishedFlag=!1},_tick:function(a,b){this._idle||this._paused||(null==this._startTime?b&&(this.startTime=a-this._currentTime/this.playbackRate):this._isFinished||this._tickCurrentTime((a-this._startTime)*this.playbackRate)),b&&(this._currentTimePending=!1,this._fireEvents(a))},get _needsTick(){return this.playState in{pending:1,running:1}||!this._finishedFlag},_targetAnimations:function(){var a=this._effect._target;return a._activeAnimations||(a._activeAnimations=[]),a._activeAnimations},_markTarget:function(){var a=this._targetAnimations();-1===a.indexOf(this)&&a.push(this)},_unmarkTarget:function(){var a=this._targetAnimations(),b=a.indexOf(this);-1!==b&&a.splice(b,1)}}}(a,b),function(a,b,c){function d(a){var b=j;j=[],a<q.currentTime&&(a=q.currentTime),q._animations.sort(e),q._animations=h(a,!0,q._animations)[0],b.forEach(function(b){b[1](a)}),g(),l=void 0}function e(a,b){return a._sequenceNumber-b._sequenceNumber}function f(){this._animations=[],this.currentTime=window.performance&&performance.now?performance.now():0}function g(){o.forEach(function(a){a()}),o.length=0}function h(a,c,d){p=!0,n=!1,b.timeline.currentTime=a,m=!1;var e=[],f=[],g=[],h=[];return d.forEach(function(b){b._tick(a,c),b._inEffect?(f.push(b._effect),b._markTarget()):(e.push(b._effect),b._unmarkTarget()),b._needsTick&&(m=!0);var d=b._inEffect||b._needsTick;b._inTimeline=d,d?g.push(b):h.push(b)}),o.push.apply(o,e),o.push.apply(o,f),m&&requestAnimationFrame(function(){}),p=!1,[g,h]}var i=window.requestAnimationFrame,j=[],k=0;window.requestAnimationFrame=function(a){var b=k++;return 0==j.length&&i(d),j.push([b,a]),b},window.cancelAnimationFrame=function(a){j.forEach(function(b){b[0]==a&&(b[1]=function(){})})},f.prototype={_play:function(c){c._timing=a.normalizeTimingInput(c.timing);var d=new b.Animation(c);return d._idle=!1,d._timeline=this,this._animations.push(d),b.restart(),b.applyDirtiedAnimation(d),d}};var l=void 0,m=!1,n=!1;b.restart=function(){return m||(m=!0,requestAnimationFrame(function(){}),n=!0),n},b.applyDirtiedAnimation=function(a){if(!p){a._markTarget();var c=a._targetAnimations();c.sort(e),h(b.timeline.currentTime,!1,c.slice())[1].forEach(function(a){var b=q._animations.indexOf(a);-1!==b&&q._animations.splice(b,1)}),g()}};var o=[],p=!1,q=new f;b.timeline=q}(a,b),function(a){function b(a,b){var c=a.exec(b);if(c)return c=a.ignoreCase?c[0].toLowerCase():c[0],[c,b.substr(c.length)]}function c(a,b){b=b.replace(/^\s*/,"");var c=a(b);if(c)return[c[0],c[1].replace(/^\s*/,"")]}function d(a,d,e){a=c.bind(null,a);for(var f=[];;){var g=a(e);if(!g)return[f,e];if(f.push(g[0]),e=g[1],!(g=b(d,e))||""==g[1])return[f,e];e=g[1]}}function e(a,b){for(var c=0,d=0;d<b.length&&(!/\s|,/.test(b[d])||0!=c);d++)if("("==b[d])c++;else if(")"==b[d]&&(c--,0==c&&d++,c<=0))break;var e=a(b.substr(0,d));return void 0==e?void 0:[e,b.substr(d)]}function f(a,b){for(var c=a,d=b;c&&d;)c>d?c%=d:d%=c;return c=a*b/(c+d)}function g(a){return function(b){var c=a(b);return c&&(c[0]=void 0),c}}function h(a,b){return function(c){return a(c)||[b,c]}}function i(b,c){for(var d=[],e=0;e<b.length;e++){var f=a.consumeTrimmed(b[e],c);if(!f||""==f[0])return;void 0!==f[0]&&d.push(f[0]),c=f[1]}if(""==c)return d}function j(a,b,c,d,e){for(var g=[],h=[],i=[],j=f(d.length,e.length),k=0;k<j;k++){var l=b(d[k%d.length],e[k%e.length]);if(!l)return;g.push(l[0]),h.push(l[1]),i.push(l[2])}return[g,h,function(b){var d=b.map(function(a,b){return i[b](a)}).join(c);return a?a(d):d}]}function k(a,b,c){for(var d=[],e=[],f=[],g=0,h=0;h<c.length;h++)if("function"==typeof c[h]){var i=c[h](a[g],b[g++]);d.push(i[0]),e.push(i[1]),f.push(i[2])}else!function(a){d.push(!1),e.push(!1),f.push(function(){return c[a]})}(h);return[d,e,function(a){for(var b="",c=0;c<a.length;c++)b+=f[c](a[c]);return b}]}a.consumeToken=b,a.consumeTrimmed=c,a.consumeRepeated=d,a.consumeParenthesised=e,a.ignore=g,a.optional=h,a.consumeList=i,a.mergeNestedRepeated=j.bind(null,null),a.mergeWrappedNestedRepeated=j,a.mergeList=k}(b),function(a){function b(b){function c(b){var c=a.consumeToken(/^inset/i,b);return c?(d.inset=!0,c):(c=a.consumeLengthOrPercent(b))?(d.lengths.push(c[0]),c):(c=a.consumeColor(b),c?(d.color=c[0],c):void 0)}var d={inset:!1,lengths:[],color:null},e=a.consumeRepeated(c,/^/,b);if(e&&e[0].length)return[d,e[1]]}function c(c){var d=a.consumeRepeated(b,/^,/,c);if(d&&""==d[1])return d[0]}function d(b,c){for(;b.lengths.length<Math.max(b.lengths.length,c.lengths.length);)b.lengths.push({px:0});for(;c.lengths.length<Math.max(b.lengths.length,c.lengths.length);)c.lengths.push({px:0});if(b.inset==c.inset&&!!b.color==!!c.color){for(var d,e=[],f=[[],0],g=[[],0],h=0;h<b.lengths.length;h++){var i=a.mergeDimensions(b.lengths[h],c.lengths[h],2==h);f[0].push(i[0]),g[0].push(i[1]),e.push(i[2])}if(b.color&&c.color){var j=a.mergeColors(b.color,c.color);f[1]=j[0],g[1]=j[1],d=j[2]}return[f,g,function(a){for(var c=b.inset?"inset ":" ",f=0;f<e.length;f++)c+=e[f](a[0][f])+" ";return d&&(c+=d(a[1])),c}]}}function e(b,c,d,e){function f(a){return{inset:a,color:[0,0,0,0],lengths:[{px:0},{px:0},{px:0},{px:0}]}}for(var g=[],h=[],i=0;i<d.length||i<e.length;i++){var j=d[i]||f(e[i].inset),k=e[i]||f(d[i].inset);g.push(j),h.push(k)}return a.mergeNestedRepeated(b,c,g,h)}var f=e.bind(null,d,", ");a.addPropertiesHandler(c,f,["box-shadow","text-shadow"])}(b),function(a,b){function c(a){return a.toFixed(3).replace(/0+$/,"").replace(/\.$/,"")}function d(a,b,c){return Math.min(b,Math.max(a,c))}function e(a){if(/^\s*[-+]?(\d*\.)?\d+\s*$/.test(a))return Number(a)}function f(a,b){return[a,b,c]}function g(a,b){if(0!=a)return i(0,1/0)(a,b)}function h(a,b){return[a,b,function(a){return Math.round(d(1,1/0,a))}]}function i(a,b){return function(e,f){return[e,f,function(e){return c(d(a,b,e))}]}}function j(a){var b=a.trim().split(/\s*[\s,]\s*/);if(0!==b.length){for(var c=[],d=0;d<b.length;d++){var f=e(b[d]);if(void 0===f)return;c.push(f)}return c}}function k(a,b){if(a.length==b.length)return[a,b,function(a){return a.map(c).join(" ")}]}function l(a,b){return[a,b,Math.round]}a.clamp=d,a.addPropertiesHandler(j,k,["stroke-dasharray"]),a.addPropertiesHandler(e,i(0,1/0),["border-image-width","line-height"]),a.addPropertiesHandler(e,i(0,1),["opacity","shape-image-threshold"]),a.addPropertiesHandler(e,g,["flex-grow","flex-shrink"]),a.addPropertiesHandler(e,h,["orphans","widows"]),a.addPropertiesHandler(e,l,["z-index"]),a.parseNumber=e,a.parseNumberList=j,a.mergeNumbers=f,a.numberToString=c}(b),function(a,b){function c(a,b){if("visible"==a||"visible"==b)return[0,1,function(c){return c<=0?a:c>=1?b:"visible"}]}a.addPropertiesHandler(String,c,["visibility"])}(b),function(a,b){function c(a){a=a.trim(),f.fillStyle="#000",f.fillStyle=a;var b=f.fillStyle;if(f.fillStyle="#fff",f.fillStyle=a,b==f.fillStyle){f.fillRect(0,0,1,1);var c=f.getImageData(0,0,1,1).data;f.clearRect(0,0,1,1);var d=c[3]/255;return[c[0]*d,c[1]*d,c[2]*d,d]}}function d(b,c){return[b,c,function(b){function c(a){return Math.max(0,Math.min(255,a))}if(b[3])for(var d=0;d<3;d++)b[d]=Math.round(c(b[d]/b[3]));return b[3]=a.numberToString(a.clamp(0,1,b[3])),"rgba("+b.join(",")+")"}]}var e=document.createElementNS("http://www.w3.org/1999/xhtml","canvas");e.width=e.height=1;var f=e.getContext("2d");a.addPropertiesHandler(c,d,["background-color","border-bottom-color","border-left-color","border-right-color","border-top-color","color","fill","flood-color","lighting-color","outline-color","stop-color","stroke","text-decoration-color"]),a.consumeColor=a.consumeParenthesised.bind(null,c),a.mergeColors=d}(b),function(a,b){function c(a){function b(){var b=h.exec(a);g=b?b[0]:void 0}function c(){var a=Number(g);return b(),a}function d(){if("("!==g)return c();b();var a=f();return")"!==g?NaN:(b(),a)}function e(){for(var a=d();"*"===g||"/"===g;){var c=g;b();var e=d();"*"===c?a*=e:a/=e}return a}function f(){for(var a=e();"+"===g||"-"===g;){var c=g;b();var d=e();"+"===c?a+=d:a-=d}return a}var g,h=/([\+\-\w\.]+|[\(\)\*\/])/g;return b(),f()}function d(a,b){if("0"==(b=b.trim().toLowerCase())&&"px".search(a)>=0)return{px:0};if(/^[^(]*$|^calc/.test(b)){b=b.replace(/calc\(/g,"(");var d={};b=b.replace(a,function(a){return d[a]=null,"U"+a});for(var e="U("+a.source+")",f=b.replace(/[-+]?(\d*\.)?\d+([Ee][-+]?\d+)?/g,"N").replace(new RegExp("N"+e,"g"),"D").replace(/\s[+-]\s/g,"O").replace(/\s/g,""),g=[/N\*(D)/g,/(N|D)[*\/]N/g,/(N|D)O\1/g,/\((N|D)\)/g],h=0;h<g.length;)g[h].test(f)?(f=f.replace(g[h],"$1"),h=0):h++;if("D"==f){for(var i in d){var j=c(b.replace(new RegExp("U"+i,"g"),"").replace(new RegExp(e,"g"),"*0"));if(!isFinite(j))return;d[i]=j}return d}}}function e(a,b){return f(a,b,!0)}function f(b,c,d){var e,f=[];for(e in b)f.push(e);for(e in c)f.indexOf(e)<0&&f.push(e);return b=f.map(function(a){return b[a]||0}),c=f.map(function(a){return c[a]||0}),[b,c,function(b){var c=b.map(function(c,e){return 1==b.length&&d&&(c=Math.max(c,0)),a.numberToString(c)+f[e]}).join(" + ");return b.length>1?"calc("+c+")":c}]}var g="px|em|ex|ch|rem|vw|vh|vmin|vmax|cm|mm|in|pt|pc",h=d.bind(null,new RegExp(g,"g")),i=d.bind(null,new RegExp(g+"|%","g")),j=d.bind(null,/deg|rad|grad|turn/g);a.parseLength=h,a.parseLengthOrPercent=i,a.consumeLengthOrPercent=a.consumeParenthesised.bind(null,i),a.parseAngle=j,a.mergeDimensions=f;var k=a.consumeParenthesised.bind(null,h),l=a.consumeRepeated.bind(void 0,k,/^/),m=a.consumeRepeated.bind(void 0,l,/^,/);a.consumeSizePairList=m;var n=function(a){var b=m(a);if(b&&""==b[1])return b[0]},o=a.mergeNestedRepeated.bind(void 0,e," "),p=a.mergeNestedRepeated.bind(void 0,o,",");a.mergeNonNegativeSizePair=o,a.addPropertiesHandler(n,p,["background-size"]),a.addPropertiesHandler(i,e,["border-bottom-width","border-image-width","border-left-width","border-right-width","border-top-width","flex-basis","font-size","height","line-height","max-height","max-width","outline-width","width"]),a.addPropertiesHandler(i,f,["border-bottom-left-radius","border-bottom-right-radius","border-top-left-radius","border-top-right-radius","bottom","left","letter-spacing","margin-bottom","margin-left","margin-right","margin-top","min-height","min-width","outline-offset","padding-bottom","padding-left","padding-right","padding-top","perspective","right","shape-margin","stroke-dashoffset","text-indent","top","vertical-align","word-spacing"])}(b),function(a,b){function c(b){return a.consumeLengthOrPercent(b)||a.consumeToken(/^auto/,b)}function d(b){var d=a.consumeList([a.ignore(a.consumeToken.bind(null,/^rect/)),a.ignore(a.consumeToken.bind(null,/^\(/)),a.consumeRepeated.bind(null,c,/^,/),a.ignore(a.consumeToken.bind(null,/^\)/))],b);if(d&&4==d[0].length)return d[0]}function e(b,c){return"auto"==b||"auto"==c?[!0,!1,function(d){var e=d?b:c;if("auto"==e)return"auto";var f=a.mergeDimensions(e,e);return f[2](f[0])}]:a.mergeDimensions(b,c)}function f(a){return"rect("+a+")"}var g=a.mergeWrappedNestedRepeated.bind(null,f,e,", ");a.parseBox=d,a.mergeBoxes=g,a.addPropertiesHandler(d,g,["clip"])}(b),function(a,b){function c(a){return function(b){var c=0;return a.map(function(a){return a===k?b[c++]:a})}}function d(a){return a}function e(b){if("none"==(b=b.toLowerCase().trim()))return[];for(var c,d=/\s*(\w+)\(([^)]*)\)/g,e=[],f=0;c=d.exec(b);){if(c.index!=f)return;f=c.index+c[0].length;var g=c[1],h=n[g];if(!h)return;var i=c[2].split(","),j=h[0];if(j.length<i.length)return;for(var k=[],o=0;o<j.length;o++){var p,q=i[o],r=j[o];if(void 0===(p=q?{A:function(b){return"0"==b.trim()?m:a.parseAngle(b)},N:a.parseNumber,T:a.parseLengthOrPercent,L:a.parseLength}[r.toUpperCase()](q):{a:m,n:k[0],t:l}[r]))return;k.push(p)}if(e.push({t:g,d:k}),d.lastIndex==b.length)return e}}function f(a){return a.toFixed(6).replace(".000000","")}function g(b,c){if(b.decompositionPair!==c){b.decompositionPair=c;var d=a.makeMatrixDecomposition(b)}if(c.decompositionPair!==b){c.decompositionPair=b;var e=a.makeMatrixDecomposition(c)}return null==d[0]||null==e[0]?[[!1],[!0],function(a){return a?c[0].d:b[0].d}]:(d[0].push(0),e[0].push(1),[d,e,function(b){var c=a.quat(d[0][3],e[0][3],b[5]);return a.composeMatrix(b[0],b[1],b[2],c,b[4]).map(f).join(",")}])}function h(a){return a.replace(/[xy]/,"")}function i(a){return a.replace(/(x|y|z|3d)?$/,"3d")}function j(b,c){var d=a.makeMatrixDecomposition&&!0,e=!1;if(!b.length||!c.length){b.length||(e=!0,b=c,c=[]);for(var f=0;f<b.length;f++){var j=b[f].t,k=b[f].d,l="scale"==j.substr(0,5)?1:0;c.push({t:j,d:k.map(function(a){if("number"==typeof a)return l;var b={};for(var c in a)b[c]=l;return b})})}}var m=function(a,b){return"perspective"==a&&"perspective"==b||("matrix"==a||"matrix3d"==a)&&("matrix"==b||"matrix3d"==b)},o=[],p=[],q=[];if(b.length!=c.length){if(!d)return;var r=g(b,c);o=[r[0]],p=[r[1]],q=[["matrix",[r[2]]]]}else for(var f=0;f<b.length;f++){var j,s=b[f].t,t=c[f].t,u=b[f].d,v=c[f].d,w=n[s],x=n[t];if(m(s,t)){if(!d)return;var r=g([b[f]],[c[f]]);o.push(r[0]),p.push(r[1]),q.push(["matrix",[r[2]]])}else{if(s==t)j=s;else if(w[2]&&x[2]&&h(s)==h(t))j=h(s),u=w[2](u),v=x[2](v);else{if(!w[1]||!x[1]||i(s)!=i(t)){if(!d)return;var r=g(b,c);o=[r[0]],p=[r[1]],q=[["matrix",[r[2]]]];break}j=i(s),u=w[1](u),v=x[1](v)}for(var y=[],z=[],A=[],B=0;B<u.length;B++){var C="number"==typeof u[B]?a.mergeNumbers:a.mergeDimensions,r=C(u[B],v[B]);y[B]=r[0],z[B]=r[1],A.push(r[2])}o.push(y),p.push(z),q.push([j,A])}}if(e){var D=o;o=p,p=D}return[o,p,function(a){return a.map(function(a,b){var c=a.map(function(a,c){return q[b][1][c](a)}).join(",");return"matrix"==q[b][0]&&16==c.split(",").length&&(q[b][0]="matrix3d"),q[b][0]+"("+c+")"}).join(" ")}]}var k=null,l={px:0},m={deg:0},n={matrix:["NNNNNN",[k,k,0,0,k,k,0,0,0,0,1,0,k,k,0,1],d],matrix3d:["NNNNNNNNNNNNNNNN",d],rotate:["A"],rotatex:["A"],rotatey:["A"],rotatez:["A"],rotate3d:["NNNA"],perspective:["L"],scale:["Nn",c([k,k,1]),d],scalex:["N",c([k,1,1]),c([k,1])],scaley:["N",c([1,k,1]),c([1,k])],scalez:["N",c([1,1,k])],scale3d:["NNN",d],skew:["Aa",null,d],skewx:["A",null,c([k,m])],skewy:["A",null,c([m,k])],translate:["Tt",c([k,k,l]),d],translatex:["T",c([k,l,l]),c([k,l])],translatey:["T",c([l,k,l]),c([l,k])],translatez:["L",c([l,l,k])],translate3d:["TTL",d]};a.addPropertiesHandler(e,j,["transform"]),a.transformToSvgMatrix=function(b){var c=a.transformListToMatrix(e(b));return"matrix("+f(c[0])+" "+f(c[1])+" "+f(c[4])+" "+f(c[5])+" "+f(c[12])+" "+f(c[13])+")"}}(b),function(a,b){function c(a,b){b.concat([a]).forEach(function(b){b in document.documentElement.style&&(d[a]=b),e[b]=a})}var d={},e={};c("transform",["webkitTransform","msTransform"]),c("transformOrigin",["webkitTransformOrigin"]),c("perspective",["webkitPerspective"]),c("perspectiveOrigin",["webkitPerspectiveOrigin"]),a.propertyName=function(a){return d[a]||a},a.unprefixedPropertyName=function(a){return e[a]||a}}(b)}(),function(){if(void 0===document.createElement("div").animate([]).oncancel){var a;if(window.performance&&performance.now)var a=function(){return performance.now()};else var a=function(){return Date.now()};var b=function(a,b,c){this.target=a,this.currentTime=b,this.timelineTime=c,this.type="cancel",this.bubbles=!1,this.cancelable=!1,this.currentTarget=a,this.defaultPrevented=!1,this.eventPhase=Event.AT_TARGET,this.timeStamp=Date.now()},c=window.Element.prototype.animate;window.Element.prototype.animate=function(d,e){var f=c.call(this,d,e);f._cancelHandlers=[],f.oncancel=null;var g=f.cancel;f.cancel=function(){g.call(this);var c=new b(this,null,a()),d=this._cancelHandlers.concat(this.oncancel?[this.oncancel]:[]);setTimeout(function(){d.forEach(function(a){a.call(c.target,c)})},0)};var h=f.addEventListener;f.addEventListener=function(a,b){"function"==typeof b&&"cancel"==a?this._cancelHandlers.push(b):h.call(this,a,b)};var i=f.removeEventListener;return f.removeEventListener=function(a,b){if("cancel"==a){var c=this._cancelHandlers.indexOf(b);c>=0&&this._cancelHandlers.splice(c,1)}else i.call(this,a,b)},f}}}(),function(a){var b=document.documentElement,c=null,d=!1;try{var e=getComputedStyle(b).getPropertyValue("opacity"),f="0"==e?"1":"0";c=b.animate({opacity:[f,f]},{duration:1}),c.currentTime=0,d=getComputedStyle(b).getPropertyValue("opacity")==f}catch(a){}finally{c&&c.cancel()}if(!d){var g=window.Element.prototype.animate;window.Element.prototype.animate=function(b,c){return window.Symbol&&Symbol.iterator&&Array.prototype.from&&b[Symbol.iterator]&&(b=Array.from(b)),Array.isArray(b)||null===b||(b=a.convertToArrayForm(b)),g.call(this,b,c)}}}(a),function(a,b,c){function d(a){var c=b.timeline;c.currentTime=a,c._discardAnimations(),0==c._animations.length?f=!1:requestAnimationFrame(d)}var e=window.requestAnimationFrame;window.requestAnimationFrame=function(a){return e(function(c){b.timeline._updateAnimationsPromises(),a(c),b.timeline._updateAnimationsPromises()})},b.AnimationTimeline=function(){this._animations=[],this.currentTime=void 0},b.AnimationTimeline.prototype={getAnimations:function(){return this._discardAnimations(),this._animations.slice()},_updateAnimationsPromises:function(){b.animationsWithPromises=b.animationsWithPromises.filter(function(a){return a._updatePromises()})},_discardAnimations:function(){this._updateAnimationsPromises(),this._animations=this._animations.filter(function(a){return"finished"!=a.playState&&"idle"!=a.playState})},_play:function(a){var c=new b.Animation(a,this);return this._animations.push(c),b.restartWebAnimationsNextTick(),c._updatePromises(),c._animation.play(),c._updatePromises(),c},play:function(a){return a&&a.remove(),this._play(a)}};var f=!1;b.restartWebAnimationsNextTick=function(){f||(f=!0,requestAnimationFrame(d))};var g=new b.AnimationTimeline;b.timeline=g;try{Object.defineProperty(window.document,"timeline",{configurable:!0,get:function(){return g}})}catch(a){}try{window.document.timeline=g}catch(a){}}(0,c),function(a,b,c){b.animationsWithPromises=[],b.Animation=function(b,c){if(this.id="",b&&b._id&&(this.id=b._id),this.effect=b,b&&(b._animation=this),!c)throw new Error("Animation with null timeline is not supported");this._timeline=c,this._sequenceNumber=a.sequenceNumber++,this._holdTime=0,this._paused=!1,this._isGroup=!1,this._animation=null,this._childAnimations=[],this._callback=null,this._oldPlayState="idle",this._rebuildUnderlyingAnimation(),this._animation.cancel(),this._updatePromises()},b.Animation.prototype={_updatePromises:function(){var a=this._oldPlayState,b=this.playState;return this._readyPromise&&b!==a&&("idle"==b?(this._rejectReadyPromise(),this._readyPromise=void 0):"pending"==a?this._resolveReadyPromise():"pending"==b&&(this._readyPromise=void 0)),this._finishedPromise&&b!==a&&("idle"==b?(this._rejectFinishedPromise(),this._finishedPromise=void 0):"finished"==b?this._resolveFinishedPromise():"finished"==a&&(this._finishedPromise=void 0)),this._oldPlayState=this.playState,this._readyPromise||this._finishedPromise},_rebuildUnderlyingAnimation:function(){this._updatePromises();var a,c,d,e,f=!!this._animation;f&&(a=this.playbackRate,c=this._paused,d=this.startTime,e=this.currentTime,this._animation.cancel(),this._animation._wrapper=null,this._animation=null),(!this.effect||this.effect instanceof window.KeyframeEffect)&&(this._animation=b.newUnderlyingAnimationForKeyframeEffect(this.effect),b.bindAnimationForKeyframeEffect(this)),(this.effect instanceof window.SequenceEffect||this.effect instanceof window.GroupEffect)&&(this._animation=b.newUnderlyingAnimationForGroup(this.effect),b.bindAnimationForGroup(this)),this.effect&&this.effect._onsample&&b.bindAnimationForCustomEffect(this),f&&(1!=a&&(this.playbackRate=a),null!==d?this.startTime=d:null!==e?this.currentTime=e:null!==this._holdTime&&(this.currentTime=this._holdTime),c&&this.pause()),this._updatePromises()},_updateChildren:function(){if(this.effect&&"idle"!=this.playState){var a=this.effect._timing.delay;this._childAnimations.forEach(function(c){this._arrangeChildren(c,a),this.effect instanceof window.SequenceEffect&&(a+=b.groupChildDuration(c.effect))}.bind(this))}},_setExternalAnimation:function(a){if(this.effect&&this._isGroup)for(var b=0;b<this.effect.children.length;b++)this.effect.children[b]._animation=a,this._childAnimations[b]._setExternalAnimation(a)},_constructChildAnimations:function(){if(this.effect&&this._isGroup){var a=this.effect._timing.delay;this._removeChildAnimations(),this.effect.children.forEach(function(c){var d=b.timeline._play(c);this._childAnimations.push(d),d.playbackRate=this.playbackRate,this._paused&&d.pause(),c._animation=this.effect._animation,this._arrangeChildren(d,a),this.effect instanceof window.SequenceEffect&&(a+=b.groupChildDuration(c))}.bind(this))}},_arrangeChildren:function(a,b){null===this.startTime?a.currentTime=this.currentTime-b/this.playbackRate:a.startTime!==this.startTime+b/this.playbackRate&&(a.startTime=this.startTime+b/this.playbackRate)},get timeline(){return this._timeline},get playState(){return this._animation?this._animation.playState:"idle"},get finished(){return window.Promise?(this._finishedPromise||(-1==b.animationsWithPromises.indexOf(this)&&b.animationsWithPromises.push(this),this._finishedPromise=new Promise(function(a,b){this._resolveFinishedPromise=function(){a(this)},this._rejectFinishedPromise=function(){b({type:DOMException.ABORT_ERR,name:"AbortError"})}}.bind(this)),"finished"==this.playState&&this._resolveFinishedPromise()),this._finishedPromise):(console.warn("Animation Promises require JavaScript Promise constructor"),null)},get ready(){return window.Promise?(this._readyPromise||(-1==b.animationsWithPromises.indexOf(this)&&b.animationsWithPromises.push(this),this._readyPromise=new Promise(function(a,b){this._resolveReadyPromise=function(){a(this)},this._rejectReadyPromise=function(){b({type:DOMException.ABORT_ERR,name:"AbortError"})}}.bind(this)),"pending"!==this.playState&&this._resolveReadyPromise()),this._readyPromise):(console.warn("Animation Promises require JavaScript Promise constructor"),null)},get onfinish(){return this._animation.onfinish},set onfinish(a){this._animation.onfinish="function"==typeof a?function(b){b.target=this,a.call(this,b)}.bind(this):a},get oncancel(){return this._animation.oncancel},set oncancel(a){this._animation.oncancel="function"==typeof a?function(b){b.target=this,a.call(this,b)}.bind(this):a},get currentTime(){this._updatePromises();var a=this._animation.currentTime;return this._updatePromises(),a},set currentTime(a){this._updatePromises(),this._animation.currentTime=isFinite(a)?a:Math.sign(a)*Number.MAX_VALUE,this._register(),this._forEachChild(function(b,c){b.currentTime=a-c}),this._updatePromises()},get startTime(){return this._animation.startTime},set startTime(a){this._updatePromises(),this._animation.startTime=isFinite(a)?a:Math.sign(a)*Number.MAX_VALUE,this._register(),this._forEachChild(function(b,c){b.startTime=a+c}),this._updatePromises()},get playbackRate(){return this._animation.playbackRate},set playbackRate(a){this._updatePromises();var b=this.currentTime;this._animation.playbackRate=a,this._forEachChild(function(b){b.playbackRate=a}),null!==b&&(this.currentTime=b),this._updatePromises()},play:function(){this._updatePromises(),this._paused=!1,this._animation.play(),-1==this._timeline._animations.indexOf(this)&&this._timeline._animations.push(this),this._register(),b.awaitStartTime(this),this._forEachChild(function(a){var b=a.currentTime;a.play(),a.currentTime=b}),this._updatePromises()},pause:function(){this._updatePromises(),this.currentTime&&(this._holdTime=this.currentTime),this._animation.pause(),this._register(),this._forEachChild(function(a){a.pause()}),this._paused=!0,this._updatePromises()},finish:function(){this._updatePromises(),this._animation.finish(),this._register(),this._updatePromises()},cancel:function(){this._updatePromises(),this._animation.cancel(),this._register(),this._removeChildAnimations(),this._updatePromises()},reverse:function(){this._updatePromises();var a=this.currentTime;this._animation.reverse(),this._forEachChild(function(a){a.reverse()}),null!==a&&(this.currentTime=a),this._updatePromises()},addEventListener:function(a,b){var c=b;"function"==typeof b&&(c=function(a){a.target=this,b.call(this,a)}.bind(this),b._wrapper=c),this._animation.addEventListener(a,c)},removeEventListener:function(a,b){this._animation.removeEventListener(a,b&&b._wrapper||b)},_removeChildAnimations:function(){for(;this._childAnimations.length;)this._childAnimations.pop().cancel()},_forEachChild:function(b){var c=0;if(this.effect.children&&this._childAnimations.length<this.effect.children.length&&this._constructChildAnimations(),this._childAnimations.forEach(function(a){b.call(this,a,c),this.effect instanceof window.SequenceEffect&&(c+=a.effect.activeDuration)}.bind(this)),"pending"!=this.playState){var d=this.effect._timing,e=this.currentTime;null!==e&&(e=a.calculateIterationProgress(a.calculateActiveDuration(d),e,d)),(null==e||isNaN(e))&&this._removeChildAnimations()}}},window.Animation=b.Animation}(a,c),function(a,b,c){function d(b){this._frames=a.normalizeKeyframes(b)}function e(){for(var a=!1;i.length;)i.shift()._updateChildren(),a=!0;return a}var f=function(a){if(a._animation=void 0,a instanceof window.SequenceEffect||a instanceof window.GroupEffect)for(var b=0;b<a.children.length;b++)f(a.children[b])};b.removeMulti=function(a){for(var b=[],c=0;c<a.length;c++){var d=a[c];d._parent?(-1==b.indexOf(d._parent)&&b.push(d._parent),d._parent.children.splice(d._parent.children.indexOf(d),1),d._parent=null,f(d)):d._animation&&d._animation.effect==d&&(d._animation.cancel(),d._animation.effect=new KeyframeEffect(null,[]),d._animation._callback&&(d._animation._callback._animation=null),d._animation._rebuildUnderlyingAnimation(),f(d))}for(c=0;c<b.length;c++)b[c]._rebuild()},b.KeyframeEffect=function(b,c,e,f){return this.target=b,this._parent=null,e=a.numericTimingToObject(e),this._timingInput=a.cloneTimingInput(e),this._timing=a.normalizeTimingInput(e),this.timing=a.makeTiming(e,!1,this),this.timing._effect=this,"function"==typeof c?(a.deprecated("Custom KeyframeEffect","2015-06-22","Use KeyframeEffect.onsample instead."),this._normalizedKeyframes=c):this._normalizedKeyframes=new d(c),this._keyframes=c,this.activeDuration=a.calculateActiveDuration(this._timing),this._id=f,this},b.KeyframeEffect.prototype={getFrames:function(){return"function"==typeof this._normalizedKeyframes?this._normalizedKeyframes:this._normalizedKeyframes._frames},set onsample(a){if("function"==typeof this.getFrames())throw new Error("Setting onsample on custom effect KeyframeEffect is not supported.");this._onsample=a,this._animation&&this._animation._rebuildUnderlyingAnimation()},get parent(){return this._parent},clone:function(){if("function"==typeof this.getFrames())throw new Error("Cloning custom effects is not supported.");var b=new KeyframeEffect(this.target,[],a.cloneTimingInput(this._timingInput),this._id);return b._normalizedKeyframes=this._normalizedKeyframes,b._keyframes=this._keyframes,b},remove:function(){b.removeMulti([this])}};var g=Element.prototype.animate;Element.prototype.animate=function(a,c){var d="";return c&&c.id&&(d=c.id),b.timeline._play(new b.KeyframeEffect(this,a,c,d))};var h=document.createElementNS("http://www.w3.org/1999/xhtml","div");b.newUnderlyingAnimationForKeyframeEffect=function(a){if(a){var b=a.target||h,c=a._keyframes;"function"==typeof c&&(c=[]);var d=a._timingInput;d.id=a._id}else var b=h,c=[],d=0;return g.apply(b,[c,d])},b.bindAnimationForKeyframeEffect=function(a){a.effect&&"function"==typeof a.effect._normalizedKeyframes&&b.bindAnimationForCustomEffect(a)};var i=[];b.awaitStartTime=function(a){null===a.startTime&&a._isGroup&&(0==i.length&&requestAnimationFrame(e),i.push(a))};var j=window.getComputedStyle;Object.defineProperty(window,"getComputedStyle",{configurable:!0,enumerable:!0,value:function(){b.timeline._updateAnimationsPromises();var a=j.apply(this,arguments);return e()&&(a=j.apply(this,arguments)),b.timeline._updateAnimationsPromises(),a}}),window.KeyframeEffect=b.KeyframeEffect,window.Element.prototype.getAnimations=function(){return document.timeline.getAnimations().filter(function(a){return null!==a.effect&&a.effect.target==this}.bind(this))}}(a,c),function(a,b,c){function d(a){a._registered||(a._registered=!0,g.push(a),h||(h=!0,requestAnimationFrame(e)))}function e(a){var b=g;g=[],b.sort(function(a,b){return a._sequenceNumber-b._sequenceNumber}),b=b.filter(function(a){a();var b=a._animation?a._animation.playState:"idle";return"running"!=b&&"pending"!=b&&(a._registered=!1),a._registered}),g.push.apply(g,b),g.length?(h=!0,requestAnimationFrame(e)):h=!1}var f=(document.createElementNS("http://www.w3.org/1999/xhtml","div"),0);b.bindAnimationForCustomEffect=function(b){var c,e=b.effect.target,g="function"==typeof b.effect.getFrames();c=g?b.effect.getFrames():b.effect._onsample;var h=b.effect.timing,i=null;h=a.normalizeTimingInput(h);var j=function(){var d=j._animation?j._animation.currentTime:null;null!==d&&(d=a.calculateIterationProgress(a.calculateActiveDuration(h),d,h),isNaN(d)&&(d=null)),d!==i&&(g?c(d,e,b.effect):c(d,b.effect,b.effect._animation)),i=d};j._animation=b,j._registered=!1,j._sequenceNumber=f++,b._callback=j,d(j)};var g=[],h=!1;b.Animation.prototype._register=function(){this._callback&&d(this._callback)}}(a,c),function(a,b,c){function d(a){return a._timing.delay+a.activeDuration+a._timing.endDelay}function e(b,c,d){this._id=d,this._parent=null,this.children=b||[],this._reparent(this.children),c=a.numericTimingToObject(c),this._timingInput=a.cloneTimingInput(c),this._timing=a.normalizeTimingInput(c,!0),this.timing=a.makeTiming(c,!0,this),this.timing._effect=this,"auto"===this._timing.duration&&(this._timing.duration=this.activeDuration)}window.SequenceEffect=function(){e.apply(this,arguments)},window.GroupEffect=function(){e.apply(this,arguments)},e.prototype={_isAncestor:function(a){for(var b=this;null!==b;){if(b==a)return!0;b=b._parent}return!1},_rebuild:function(){for(var a=this;a;)"auto"===a.timing.duration&&(a._timing.duration=a.activeDuration),a=a._parent;this._animation&&this._animation._rebuildUnderlyingAnimation()},_reparent:function(a){b.removeMulti(a);for(var c=0;c<a.length;c++)a[c]._parent=this},_putChild:function(a,b){for(var c=b?"Cannot append an ancestor or self":"Cannot prepend an ancestor or self",d=0;d<a.length;d++)if(this._isAncestor(a[d]))throw{type:DOMException.HIERARCHY_REQUEST_ERR,name:"HierarchyRequestError",message:c};for(var d=0;d<a.length;d++)b?this.children.push(a[d]):this.children.unshift(a[d]);this._reparent(a),this._rebuild()},append:function(){this._putChild(arguments,!0)},prepend:function(){this._putChild(arguments,!1)},get parent(){return this._parent},get firstChild(){return this.children.length?this.children[0]:null},get lastChild(){return this.children.length?this.children[this.children.length-1]:null},clone:function(){for(var b=a.cloneTimingInput(this._timingInput),c=[],d=0;d<this.children.length;d++)c.push(this.children[d].clone());return this instanceof GroupEffect?new GroupEffect(c,b):new SequenceEffect(c,b)},remove:function(){b.removeMulti([this])}},window.SequenceEffect.prototype=Object.create(e.prototype),Object.defineProperty(window.SequenceEffect.prototype,"activeDuration",{get:function(){var a=0;return this.children.forEach(function(b){a+=d(b)}),Math.max(a,0)}}),window.GroupEffect.prototype=Object.create(e.prototype),Object.defineProperty(window.GroupEffect.prototype,"activeDuration",{get:function(){var a=0;return this.children.forEach(function(b){a=Math.max(a,d(b))}),a}}),b.newUnderlyingAnimationForGroup=function(c){var d,e=null,f=function(b){var c=d._wrapper;if(c&&"pending"!=c.playState&&c.effect)return null==b?void c._removeChildAnimations():0==b&&c.playbackRate<0&&(e||(e=a.normalizeTimingInput(c.effect.timing)),b=a.calculateIterationProgress(a.calculateActiveDuration(e),-1,e),isNaN(b)||null==b)?(c._forEachChild(function(a){a.currentTime=-1}),void c._removeChildAnimations()):void 0},g=new KeyframeEffect(null,[],c._timing,c._id);return g.onsample=f,d=b.timeline._play(g)},b.bindAnimationForGroup=function(a){a._animation._wrapper=a,a._isGroup=!0,b.awaitStartTime(a),a._constructChildAnimations(),a._setExternalAnimation(a)},b.groupChildDuration=d}(a,c)}();

!(function(){
/*! *****************************************************************************
    Copyright (c) Microsoft Corporation.

    Permission to use, copy, modify, and/or distribute this software for any
    purpose with or without fee is hereby granted.

    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
    PERFORMANCE OF THIS SOFTWARE.
    ***************************************************************************** */
function t(t,e,n,i){var r,o=arguments.length,a=o<3?e:null===i?i=Object.getOwnPropertyDescriptor(e,n):i;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(t,e,n,i);else for(var s=t.length-1;s>=0;s--)(r=t[s])&&(a=(o<3?r(a):o>3?r(e,n,a):r(e,n))||a);return o>3&&a&&Object.defineProperty(e,n,a),a}function e(t,e){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(t,e)}function n(t,e,n,i){return new(n||(n=Promise))((function(r,o){function a(t){try{l(i.next(t))}catch(t){o(t)}}function s(t){try{l(i.throw(t))}catch(t){o(t)}}function l(t){t.done?r(t.value):(function e(t){return t instanceof n?t:new n((function(e){e(t)}))})(t.value).then(a,s)}l((i=i.apply(t,e||[])).next())}))}
/**
     * @license
     * Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
     * This code may only be used under the BSD style license found at
     * http://polymer.github.io/LICENSE.txt The complete set of authors may be found
     * at http://polymer.github.io/AUTHORS.txt The complete set of contributors may
     * be found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by
     * Google as part of the polymer project is also subject to an additional IP
     * rights grant found at http://polymer.github.io/PATENTS.txt
     */function i(t){return e=>{if(t)if(e.hasOwnProperty("is")){if(t!==e.is)throw new Error(`custom element tag names do not match: (${t} !== ${e.is})`)}else Object.defineProperty(e,"is",{value:t});window.customElements.define(e.is,e)}}function r(t,e,n){t.constructor.hasOwnProperty("properties")||Object.defineProperty(t.constructor,"properties",{value:{}}),t.constructor.properties[e]=Object.assign({},t.constructor.properties[e],n)}function o(t){return(e,n)=>{r(e,n,t)}}function a(...t){return(e,n)=>{e.constructor.hasOwnProperty("observers")||Object.defineProperty(e.constructor,"observers",{value:[]}),e.constructor.observers.push(`${n}(${t.join(",")})`)}}function s(t,...e){return(n,i,o)=>{const a=`__compute${i}`;Object.defineProperty(n,a,{value:o.get}),o.get=void 0,r(n,i,{computed:`${a}(${[t,...e].join(",")})`})}}
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */window.JSCompiler_renameProperty=function(t,e){return t};
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
let l,c,u=/(url\()([^)]*)(\))/g,h=/(^\/[^\/])|(^#)|(^[\w-\d]*:)/;function d(t,e){if(t&&h.test(t))return t;if("//"===t)return t;if(void 0===l){l=!1;try{const t=new URL("b","http://a");t.pathname="c%20d",l="http://a/c%20d"===t.href}catch(t){}}if(e||(e=document.baseURI||window.location.href),l)try{return new URL(t,e).href}catch(e){return t}return c||(c=document.implementation.createHTMLDocument("temp"),c.base=c.createElement("base"),c.head.appendChild(c.base),c.anchor=c.createElement("a"),c.body.appendChild(c.anchor)),c.base.href=e,c.anchor.href=t,c.anchor.href||t}function p(t,e){return t.replace(u,(function(t,n,i,r){return n+"'"+d(i.replace(/["']/g,""),e)+"'"+r}))}function f(t){return t.substring(0,t.lastIndexOf("/")+1)}
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */const m=!window.ShadyDOM||!window.ShadyDOM.inUse;Boolean(!window.ShadyCSS||window.ShadyCSS.nativeCss);const g=m&&"adoptedStyleSheets"in Document.prototype&&"replaceSync"in CSSStyleSheet.prototype&&(()=>{try{const t=new CSSStyleSheet;t.replaceSync("");const e=document.createElement("div");return e.attachShadow({mode:"open"}),e.shadowRoot.adoptedStyleSheets=[t],e.shadowRoot.adoptedStyleSheets[0]===t}catch(t){return!1}})();let _=window.Polymer&&window.Polymer.rootPath||f(document.baseURI||window.location.href),y=window.Polymer&&window.Polymer.sanitizeDOMValue||void 0,v=window.Polymer&&window.Polymer.setPassiveTouchGestures||!1,b=window.Polymer&&window.Polymer.strictTemplatePolicy||!1,x=window.Polymer&&window.Polymer.allowTemplateFromDomModule||!1,w=window.Polymer&&window.Polymer.legacyOptimizations||!1,S=window.Polymer&&window.Polymer.legacyWarnings||!1,M=window.Polymer&&window.Polymer.syncInitialRender||!1,E=window.Polymer&&window.Polymer.legacyUndefined||!1,T=window.Polymer&&window.Polymer.orderedComputed||!1,C=window.Polymer&&window.Polymer.removeNestedTemplates||!1,A=window.Polymer&&window.Polymer.fastDomIf||!1,k=window.Polymer&&window.Polymer.suppressTemplateNotifications||!1,L=window.Polymer&&window.Polymer.legacyNoObservedAttributes||!1,P=window.Polymer&&window.Polymer.useAdoptedStyleSheetsWithBuiltCSS||!1,N=0;const I=function(t){let e=t.__mixinApplications;e||(e=new WeakMap,t.__mixinApplications=e);let n=N++;return function i(r){let o=r.__mixinSet;if(o&&o[n])return r;let a=e,s=a.get(r);if(!s){s=t(r),a.set(r,s);let e=Object.create(s.__mixinSet||o||null);e[n]=!0,s.__mixinSet=e}return s}};
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */let R={},O={};function z(t,e){R[t]=O[t.toLowerCase()]=e}function D(t){return R[t]||O[t.toLowerCase()]}class B extends HTMLElement{static get observedAttributes(){return["id"]}static import(t,e){if(t){let n=D(t);return n&&e?n.querySelector(e):n}return null}attributeChangedCallback(t,e,n,i){e!==n&&this.register()}get assetpath(){if(!this.__assetpath){const t=window.HTMLImports&&HTMLImports.importForElement?HTMLImports.importForElement(this)||document:this.ownerDocument,e=d(this.getAttribute("assetpath")||"",t.baseURI);this.__assetpath=f(e)}return this.__assetpath}register(t){if(t=t||this.id){if(b&&void 0!==D(t))throw z(t,null),new Error(`strictTemplatePolicy: dom-module ${t} re-registered`);this.id=t,z(t,this),(function e(t){t.querySelector("style")&&console.warn("dom-module %s has style outside template",t.id)})(this)}}}B.prototype.modules=R,customElements.define("dom-module",B);
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
const H="shady-unscoped";function F(t){return B.import(t)}function V(t){const e=p((t.body?t.body:t).textContent,t.baseURI),n=document.createElement("style");return n.textContent=e,n}function U(t){const e=t.trim().split(/\s+/),n=[];for(let t=0;t<e.length;t++)n.push(...j(e[t]));return n}function j(t){const e=F(t);if(!e)return console.warn("Could not find style data in module named",t),[];if(void 0===e._styles){const t=[];t.push(...W(e));const n=e.querySelector("template");n&&t.push(...G(n,e.assetpath)),e._styles=t}return e._styles}function G(t,e){if(!t._styles){const n=[],i=t.content.querySelectorAll("style");for(let t=0;t<i.length;t++){let r=i[t],o=r.getAttribute("include");o&&n.push(...U(o).filter((function(t,e,n){return n.indexOf(t)===e}))),e&&(r.textContent=p(r.textContent,e)),n.push(r)}t._styles=n}return t._styles}function W(t){const e=[],n=t.querySelectorAll("link[rel=import][type~=css]");for(let t=0;t<n.length;t++){let i=n[t];if(i.import){const t=i.import,n=i.hasAttribute(H);if(n&&!t._unscopedStyle){const e=V(t);e.setAttribute(H,""),t._unscopedStyle=e}else t._style||(t._style=V(t));e.push(n?t._unscopedStyle:t._style)}}return e}function q(t){let e=F(t);if(e&&void 0===e._cssText){let t=(function n(t){let e="",n=W(t);for(let t=0;t<n.length;t++)e+=n[t].textContent;return e}
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */)(e),n=e.querySelector("template");n&&(t+=(function i(t,e){let n="";const i=G(t,e);for(let t=0;t<i.length;t++){let e=i[t];e.parentNode&&e.parentNode.removeChild(e),n+=e.textContent}return n})(n,e.assetpath)),e._cssText=t||null}return e||console.warn("Could not find style data in module named",t),e&&e._cssText||""}const Y=window.ShadyDOM&&window.ShadyDOM.noPatch&&window.ShadyDOM.wrap?window.ShadyDOM.wrap:window.ShadyDOM?t=>ShadyDOM.patch(t):t=>t;
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */function X(t){return t.indexOf(".")>=0}function $(t){let e=t.indexOf(".");return-1===e?t:t.slice(0,e)}function K(t,e){return 0===t.indexOf(e+".")}function Z(t,e){return 0===e.indexOf(t+".")}function J(t,e,n){return e+n.slice(t.length)}function Q(t,e){return t===e||K(t,e)||Z(t,e)}function tt(t){if(Array.isArray(t)){let e=[];for(let n=0;n<t.length;n++){let i=t[n].toString().split(".");for(let t=0;t<i.length;t++)e.push(i[t])}return e.join(".")}return t}function et(t){return Array.isArray(t)?tt(t).split("."):t.toString().split(".")}function nt(t,e,n){let i=t,r=et(e);for(let t=0;t<r.length;t++){if(!i)return;i=i[r[t]]}return n&&(n.path=r.join(".")),i}function it(t,e,n){let i=t,r=et(e),o=r[r.length-1];if(r.length>1){for(let t=0;t<r.length-1;t++)if(i=i[r[t]],!i)return;i[o]=n}else i[e]=n;return r.join(".")}
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */const rt={},ot=/-[a-z]/g,at=/([A-Z])/g;function st(t){return rt[t]||(rt[t]=t.indexOf("-")<0?t:t.replace(ot,(t=>t[1].toUpperCase())))}function lt(t){return rt[t]||(rt[t]=t.replace(at,"-$1").toLowerCase())}
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */let ct=0,ut=0,ht=[],dt=0,pt=!1,ft=document.createTextNode("");new window.MutationObserver((function mt(){pt=!1;const t=ht.length;for(let e=0;e<t;e++){let t=ht[e];if(t)try{t()}catch(t){setTimeout((()=>{throw t}))}}ht.splice(0,t),ut+=t})).observe(ft,{characterData:!0});const gt={after:t=>({run:e=>window.setTimeout(e,t),cancel(t){window.clearTimeout(t)}}),run:(t,e)=>window.setTimeout(t,e),cancel(t){window.clearTimeout(t)}},_t={run:t=>window.requestAnimationFrame(t),cancel(t){window.cancelAnimationFrame(t)}},yt={run:t=>window.requestIdleCallback?window.requestIdleCallback(t):window.setTimeout(t,16),cancel(t){window.cancelIdleCallback?window.cancelIdleCallback(t):window.clearTimeout(t)}},vt={run:t=>(pt||(pt=!0,ft.textContent=dt++),ht.push(t),ct++),cancel(t){const e=t-ut;if(e>=0){if(!ht[e])throw new Error("invalid async handle: "+t);ht[e]=null}}},bt=vt,xt=I((t=>class extends t{static createProperties(t){const e=this.prototype;for(let n in t)n in e||e._createPropertyAccessor(n)}static attributeNameForProperty(t){return t.toLowerCase()}static typeForProperty(t){}_createPropertyAccessor(t,e){this._addPropertyToAttributeMap(t),this.hasOwnProperty(JSCompiler_renameProperty("__dataHasAccessor",this))||(this.__dataHasAccessor=Object.assign({},this.__dataHasAccessor)),this.__dataHasAccessor[t]||(this.__dataHasAccessor[t]=!0,this._definePropertyAccessor(t,e))}_addPropertyToAttributeMap(t){this.hasOwnProperty(JSCompiler_renameProperty("__dataAttributes",this))||(this.__dataAttributes=Object.assign({},this.__dataAttributes));let e=this.__dataAttributes[t];return e||(e=this.constructor.attributeNameForProperty(t),this.__dataAttributes[e]=t),e}_definePropertyAccessor(t,e){Object.defineProperty(this,t,{get(){return this.__data[t]},set:e?function(){}:function(e){this._setPendingProperty(t,e,!0)&&this._invalidateProperties()}})}constructor(){super(),this.__dataEnabled=!1,this.__dataReady=!1,this.__dataInvalid=!1,this.__data={},this.__dataPending=null,this.__dataOld=null,this.__dataInstanceProps=null,this.__dataCounter=0,this.__serializing=!1,this._initializeProperties()}ready(){this.__dataReady=!0,this._flushProperties()}_initializeProperties(){for(let t in this.__dataHasAccessor)this.hasOwnProperty(t)&&(this.__dataInstanceProps=this.__dataInstanceProps||{},this.__dataInstanceProps[t]=this[t],delete this[t])}_initializeInstanceProperties(t){Object.assign(this,t)}_setProperty(t,e){this._setPendingProperty(t,e)&&this._invalidateProperties()}_getProperty(t){return this.__data[t]}_setPendingProperty(t,e,n){let i=this.__data[t],r=this._shouldPropertyChange(t,e,i);return r&&(this.__dataPending||(this.__dataPending={},this.__dataOld={}),this.__dataOld&&!(t in this.__dataOld)&&(this.__dataOld[t]=i),this.__data[t]=e,this.__dataPending[t]=e),r}_isPropertyPending(t){return!(!this.__dataPending||!this.__dataPending.hasOwnProperty(t))}_invalidateProperties(){!this.__dataInvalid&&this.__dataReady&&(this.__dataInvalid=!0,bt.run((()=>{this.__dataInvalid&&(this.__dataInvalid=!1,this._flushProperties())})))}_enableProperties(){this.__dataEnabled||(this.__dataEnabled=!0,this.__dataInstanceProps&&(this._initializeInstanceProperties(this.__dataInstanceProps),this.__dataInstanceProps=null),this.ready())}_flushProperties(){this.__dataCounter++;const t=this.__data,e=this.__dataPending,n=this.__dataOld;this._shouldPropertiesChange(t,e,n)&&(this.__dataPending=null,this.__dataOld=null,this._propertiesChanged(t,e,n)),this.__dataCounter--}_shouldPropertiesChange(t,e,n){return Boolean(e)}_propertiesChanged(t,e,n){}_shouldPropertyChange(t,e,n){return n!==e&&(n==n||e==e)}attributeChangedCallback(t,e,n,i){e!==n&&this._attributeToProperty(t,n),super.attributeChangedCallback&&super.attributeChangedCallback(t,e,n,i)}_attributeToProperty(t,e,n){if(!this.__serializing){const i=this.__dataAttributes,r=i&&i[t]||t;this[r]=this._deserializeValue(e,n||this.constructor.typeForProperty(r))}}_propertyToAttribute(t,e,n){this.__serializing=!0,this._valueToNodeAttribute(this,n=arguments.length<3?this[t]:n,e||this.constructor.attributeNameForProperty(t)),this.__serializing=!1}_valueToNodeAttribute(t,e,n){const i=this._serializeValue(e);"class"!==n&&"name"!==n&&"slot"!==n||(t=Y(t)),void 0===i?t.removeAttribute(n):t.setAttribute(n,i)}_serializeValue(t){switch(typeof t){case"boolean":return t?"":void 0;default:return null!=t?t.toString():void 0}}_deserializeValue(t,e){switch(e){case Boolean:return null!==t;case Number:return Number(t);default:return t}}})),wt={};let St=HTMLElement.prototype;for(;St;){let t=Object.getOwnPropertyNames(St);for(let e=0;e<t.length;e++)wt[t[e]]=!0;St=Object.getPrototypeOf(St)}const Mt=I((t=>{const e=xt(t);return class extends e{static createPropertiesForAttributes(){let t=this.observedAttributes;for(let e=0;e<t.length;e++)this.prototype._createPropertyAccessor(st(t[e]))}static attributeNameForProperty(t){return lt(t)}_initializeProperties(){this.__dataProto&&(this._initializeProtoProperties(this.__dataProto),this.__dataProto=null),super._initializeProperties()}_initializeProtoProperties(t){for(let e in t)this._setProperty(e,t[e])}_ensureAttribute(t,e){this.hasAttribute(t)||this._valueToNodeAttribute(this,e,t)}_serializeValue(t){switch(typeof t){case"object":if(t instanceof Date)return t.toString();if(t)try{return JSON.stringify(t)}catch(t){return""}default:return super._serializeValue(t)}}_deserializeValue(t,e){let n;switch(e){case Object:try{n=JSON.parse(t)}catch(e){n=t}break;case Array:try{n=JSON.parse(t)}catch(e){n=null,console.warn(`Polymer::Attributes: couldn't decode Array as JSON: ${t}`)}break;case Date:n=isNaN(t)?String(t):Number(t),n=new Date(n);break;default:n=super._deserializeValue(t,e)}return n}_definePropertyAccessor(t,e){!(function n(t,e){if(!wt[e]){let n=t[e];void 0!==n&&(t.__data?t._setPendingProperty(e,n):(t.__dataProto?t.hasOwnProperty(JSCompiler_renameProperty("__dataProto",t))||(t.__dataProto=Object.create(t.__dataProto)):t.__dataProto={},t.__dataProto[e]=n))}})(this,t),super._definePropertyAccessor(t,e)}_hasAccessor(t){return this.__dataHasAccessor&&this.__dataHasAccessor[t]}_isPropertyPending(t){return Boolean(this.__dataPending&&t in this.__dataPending)}}})),Et={"dom-if":!0,"dom-repeat":!0};
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */let Tt=!1,Ct=!1;function At(t){let e=t.getAttribute("is");if(e&&Et[e]){let n=t;for(n.removeAttribute("is"),t=n.ownerDocument.createElement(e),n.parentNode.replaceChild(t,n),t.appendChild(n);n.attributes.length;)t.setAttribute(n.attributes[0].name,n.attributes[0].value),n.removeAttribute(n.attributes[0].name)}return t}function kt(t,e){let n=e.parentInfo&&kt(t,e.parentInfo);if(!n)return t;for(let t=n.firstChild,i=0;t;t=t.nextSibling)if(e.parentIndex===i++)return t}function Lt(t,e,n,i){i.id&&(e[i.id]=n)}function Pt(t,e,n){if(n.events&&n.events.length)for(let i,r=0,o=n.events;r<o.length&&(i=o[r]);r++)t._addMethodEventListenerToNode(e,i.name,i.value,t)}function Nt(t,e,n,i){n.templateInfo&&(e._templateInfo=n.templateInfo,e._parentTemplateInfo=i)}const It=I((t=>class extends t{static _parseTemplate(t,e){if(!t._templateInfo){let n=t._templateInfo={};n.nodeInfoList=[],n.nestedTemplate=Boolean(e),n.stripWhiteSpace=e&&e.stripWhiteSpace||t.hasAttribute("strip-whitespace"),this._parseTemplateContent(t,n,{parent:null})}return t._templateInfo}static _parseTemplateContent(t,e,n){return this._parseTemplateNode(t.content,e,n)}static _parseTemplateNode(t,e,n){let i=!1,r=t;return"template"!=r.localName||r.hasAttribute("preserve-content")?"slot"===r.localName&&(e.hasInsertionPoint=!0):i=this._parseTemplateNestedTemplate(r,e,n)||i,(function o(t){(function e(){if(!Tt){Tt=!0;const t=document.createElement("textarea");t.placeholder="a",Ct=t.placeholder===t.textContent}return Ct})()&&"textarea"===t.localName&&t.placeholder&&t.placeholder===t.textContent&&(t.textContent=null)})(r),r.firstChild&&this._parseTemplateChildNodes(r,e,n),r.hasAttributes&&r.hasAttributes()&&(i=this._parseTemplateNodeAttributes(r,e,n)||i),i||n.noted}static _parseTemplateChildNodes(t,e,n){if("script"!==t.localName&&"style"!==t.localName)for(let i,r=t.firstChild,o=0;r;r=i){if("template"==r.localName&&(r=At(r)),i=r.nextSibling,r.nodeType===Node.TEXT_NODE){let n=i;for(;n&&n.nodeType===Node.TEXT_NODE;)r.textContent+=n.textContent,i=n.nextSibling,t.removeChild(n),n=i;if(e.stripWhiteSpace&&!r.textContent.trim()){t.removeChild(r);continue}}let a={parentIndex:o,parentInfo:n};this._parseTemplateNode(r,e,a)&&(a.infoIndex=e.nodeInfoList.push(a)-1),r.parentNode&&o++}}static _parseTemplateNestedTemplate(t,e,n){let i=t,r=this._parseTemplate(i,e);return(r.content=i.content.ownerDocument.createDocumentFragment()).appendChild(i.content),n.templateInfo=r,!0}static _parseTemplateNodeAttributes(t,e,n){let i=!1,r=Array.from(t.attributes);for(let o,a=r.length-1;o=r[a];a--)i=this._parseTemplateNodeAttribute(t,e,n,o.name,o.value)||i;return i}static _parseTemplateNodeAttribute(t,e,n,i,r){return"on-"===i.slice(0,3)?(t.removeAttribute(i),n.events=n.events||[],n.events.push({name:i.slice(3),value:r}),!0):"id"===i&&(n.id=r,!0)}static _contentForTemplate(t){let e=t._templateInfo;return e&&e.content||t.content}_stampTemplate(t,e){t&&!t.content&&window.HTMLTemplateElement&&HTMLTemplateElement.decorate&&HTMLTemplateElement.decorate(t);let n=(e=e||this.constructor._parseTemplate(t)).nodeInfoList,i=document.importNode(e.content||t.content,!0);i.__noInsertionPoint=!e.hasInsertionPoint;let r=i.nodeList=new Array(n.length);i.$={};for(let t,o=0,a=n.length;o<a&&(t=n[o]);o++){let n=r[o]=kt(i,t);Lt(0,i.$,n,t),Nt(0,n,t,e),Pt(this,n,t)}return i=i,i}_addMethodEventListenerToNode(t,e,n,i){let r=(function o(t,e,n){return t=t._methodHost||t,function(e){t[n]?t[n](e,e.detail):console.warn("listener method `"+n+"` not defined")}})(i=i||t,0,n);return this._addEventListenerToNode(t,e,r),r}_addEventListenerToNode(t,e,n){t.addEventListener(e,n)}_removeEventListenerFromNode(t,e,n){t.removeEventListener(e,n)}}));
/**
     * @fileoverview
     * @suppress {checkPrototypalTypes}
     * @license Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
     * This code may only be used under the BSD style license found at
     * http://polymer.github.io/LICENSE.txt The complete set of authors may be found
     * at http://polymer.github.io/AUTHORS.txt The complete set of contributors may
     * be found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by
     * Google as part of the polymer project is also subject to an additional IP
     * rights grant found at http://polymer.github.io/PATENTS.txt
     */let Rt=0;const Ot=[],zt={COMPUTE:"__computeEffects",REFLECT:"__reflectEffects",NOTIFY:"__notifyEffects",PROPAGATE:"__propagateEffects",OBSERVE:"__observeEffects",READ_ONLY:"__readOnly"},Dt=/[A-Z]/;function Bt(t,e,n){let i=t[e];if(i){if(!t.hasOwnProperty(e)&&(i=t[e]=Object.create(t[e]),n))for(let t in i){let e=i[t],n=i[t]=Array(e.length);for(let t=0;t<e.length;t++)n[t]=e[t]}}else i=t[e]={};return i}function Ht(t,e,n,i,r,o){if(e){let a=!1;const s=Rt++;for(let l in n){let c=e[r?$(l):l];if(c)for(let e,u=0,h=c.length;u<h&&(e=c[u]);u++)e.info&&e.info.lastRun===s||r&&!Vt(l,e.trigger)||(e.info&&(e.info.lastRun=s),e.fn(t,l,n,i,e.info,r,o),a=!0)}return a}return!1}function Ft(t,e,n,i,r,o,a,s){let l=!1,c=e[a?$(i):i];if(c)for(let e,u=0,h=c.length;u<h&&(e=c[u]);u++)e.info&&e.info.lastRun===n||a&&!Vt(i,e.trigger)||(e.info&&(e.info.lastRun=n),e.fn(t,i,r,o,e.info,a,s),l=!0);return l}function Vt(t,e){if(e){let n=e.name;return n==t||!(!e.structured||!K(n,t))||!(!e.wildcard||!Z(n,t))}return!0}function Ut(t,e,n,i,r){let o="string"==typeof r.method?t[r.method]:r.method,a=r.property;o?o.call(t,t.__data[a],i[a]):r.dynamicFn||console.warn("observer method `"+r.method+"` not defined")}function jt(t,e,n){let i=$(e);return i!==e&&(Gt(t,lt(i)+"-changed",n[e],e),!0)}function Gt(t,e,n,i){let r={value:n,queueProperty:!0};i&&(r.path=i),Y(t).dispatchEvent(new CustomEvent(e,{detail:r}))}function Wt(t,e,n,i,r,o){let a=(o?$(e):e)!=e?e:null,s=a?nt(t,a):t.__data[e];a&&void 0===s&&(s=n[e]),Gt(t,r.eventName,s,a)}function qt(t,e,n,i,r){let o=t.__data[e];y&&(o=y(o,r.attrName,"attribute",t)),t._propertyToAttribute(e,r.attrName,o)}const Yt=(t,e,n)=>{let i=0,r=e.length-1,o=-1;for(;i<=r;){const a=i+r>>1,s=n.get(e[a].methodInfo)-n.get(t.methodInfo);if(s<0)i=a+1;else{if(!(s>0)){o=a;break}r=a-1}}o<0&&(o=r+1),e.splice(o,0,t)},Xt=(t,e,n,i,r)=>{const o=e[r?$(t):t];if(o)for(let e=0;e<o.length;e++){const a=o[e];a.info.lastRun===Rt||r&&!Vt(t,a.trigger)||(a.info.lastRun=Rt,Yt(a.info,n,i))}};function $t(t,e,n,i,r){let o=ne(t,e,n,0,r);if(o===Ot)return!1;let a=r.methodInfo;return t.__dataHasAccessor&&t.__dataHasAccessor[a]?t._setPendingProperty(a,o,!0):(t[a]=o,!1)}function Kt(t,e,n,i,r,o,a){n.bindings=n.bindings||[];let s={kind:i,target:r,parts:o,literal:a,isCompound:1!==o.length};if(n.bindings.push(s),(function l(t){return Boolean(t.target)&&"attribute"!=t.kind&&"text"!=t.kind&&!t.isCompound&&"{"===t.parts[0].mode})(s)){let{event:t,negate:e}=s.parts[0];s.listenerEvent=t||lt(r)+"-changed",s.listenerNegate=e}let c=e.nodeInfoList.length;for(let n=0;n<s.parts.length;n++){let i=s.parts[n];i.compoundIndex=n,Zt(t,e,s,i,c)}}function Zt(t,e,n,i,r){if(!i.literal)if("attribute"===n.kind&&"-"===n.target[0])console.warn("Cannot set attribute "+n.target+' because "-" is not a valid attribute starting character');else{let o=i.dependencies,a={index:r,binding:n,part:i,evaluator:t};for(let n=0;n<o.length;n++){let i=o[n];"string"==typeof i&&(i=se(i),i.wildcard=!0),t._addTemplatePropertyEffect(e,i.rootProperty,{fn:Jt,info:a,trigger:i})}}}function Jt(t,e,n,i,r,o,a){let s=a[r.index],l=r.binding,c=r.part;if(o&&c.source&&e.length>c.source.length&&"property"==l.kind&&!l.isCompound&&s.__isPropertyEffectsClient&&s.__dataHasAccessor&&s.__dataHasAccessor[l.target]){let i=n[e];e=J(c.source,l.target,e),s._setPendingPropertyOrPath(e,i,!1,!0)&&t._enqueueClient(s)}else{let a=r.evaluator._evaluateBinding(t,c,e,n,i,o);a!==Ot&&(function u(t,e,n,i,r){if(r=(function o(t,e,n,i){if(n.isCompound){let r=t.__dataCompoundStorage[n.target];r[i.compoundIndex]=e,e=r.join("")}return"attribute"!==n.kind&&("textContent"!==n.target&&("value"!==n.target||"input"!==t.localName&&"textarea"!==t.localName)||(e=null==e?"":e)),e})(e,r,n,i),y&&(r=y(r,n.target,n.kind,e)),"attribute"==n.kind)t._valueToNodeAttribute(e,r,n.target);else{let i=n.target;e.__isPropertyEffectsClient&&e.__dataHasAccessor&&e.__dataHasAccessor[i]?e[zt.READ_ONLY]&&e[zt.READ_ONLY][i]||e._setPendingProperty(i,r)&&t._enqueueClient(e):t._setUnmanagedPropertyToNode(e,i,r)}})(t,s,l,c,a)}}function Qt(t,e){if(e.isCompound){let n=t.__dataCompoundStorage||(t.__dataCompoundStorage={}),i=e.parts,r=new Array(i.length);for(let t=0;t<i.length;t++)r[t]=i[t].literal;let o=e.target;n[o]=r,e.literal&&"property"==e.kind&&("className"===o&&(t=Y(t)),t[o]=e.literal)}}function te(t,e,n){if(n.listenerEvent){let i=n.parts[0];t.addEventListener(n.listenerEvent,(function(t){!(function r(t,e,n,i,o){let a,s=t.detail,l=s&&s.path;l?(i=J(n,i,l),a=s&&s.value):a=t.currentTarget[n],a=o?!a:a,e[zt.READ_ONLY]&&e[zt.READ_ONLY][i]||!e._setPendingPropertyOrPath(i,a,!0,Boolean(l))||s&&s.queueProperty||e._invalidateProperties()})(t,e,n.target,i.source,i.negate)}))}}function ee(t,e,n,i,r,o){let a={methodName:e.methodName,args:e.args,methodInfo:r,dynamicFn:o=e.static||o&&("object"!=typeof o||o[e.methodName])};for(let r,o=0;o<e.args.length&&(r=e.args[o]);o++)r.literal||t._addPropertyEffect(r.rootProperty,n,{fn:i,info:a,trigger:r});return o&&t._addPropertyEffect(e.methodName,n,{fn:i,info:a}),a}function ne(t,e,n,i,r){let o=t._methodHost||t,a=o[r.methodName];if(a){let i=t._marshalArgs(r.args,e,n);return i===Ot?Ot:a.apply(o,i)}r.dynamicFn||console.warn("method `"+r.methodName+"` not defined")}const ie=[],re=new RegExp("(\\[\\[|{{)\\s*(?:(!)\\s*)?((?:[a-zA-Z_$][\\w.:$\\-*]*)\\s*(?:\\(\\s*(?:(?:(?:((?:[a-zA-Z_$][\\w.:$\\-*]*)|(?:[-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?)|(?:(?:'(?:[^'\\\\]|\\\\.)*')|(?:\"(?:[^\"\\\\]|\\\\.)*\")))\\s*)(?:,\\s*(?:((?:[a-zA-Z_$][\\w.:$\\-*]*)|(?:[-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?)|(?:(?:'(?:[^'\\\\]|\\\\.)*')|(?:\"(?:[^\"\\\\]|\\\\.)*\")))\\s*))*)?)\\)\\s*)?)(?:]]|}})","g");function oe(t){let e="";for(let n=0;n<t.length;n++)e+=t[n].literal||"";return e}function ae(t){let e=t.match(/([^\s]+?)\(([\s\S]*)\)/);if(e){let t={methodName:e[1],static:!0,args:ie};return e[2].trim()?(function n(t,e){return e.args=t.map((function(t){let n=se(t);return n.literal||(e.static=!1),n}),this),e})(e[2].replace(/\\,/g,"&comma;").split(","),t):t}return null}function se(t){let e=t.trim().replace(/&comma;/g,",").replace(/\\(.)/g,"$1"),n={name:e,value:"",literal:!1},i=e[0];switch("-"===i&&(i=e[1]),i>="0"&&i<="9"&&(i="#"),i){case"'":case'"':n.value=e.slice(1,-1),n.literal=!0;break;case"#":n.value=Number(e),n.literal=!0}return n.literal||(n.rootProperty=$(e),n.structured=X(e),n.structured&&(n.wildcard=".*"==e.slice(-2),n.wildcard&&(n.name=e.slice(0,-2)))),n}function le(t,e,n){let i=nt(t,n);return void 0===i&&(i=e[n]),i}function ce(t,e,n,i){const r={indexSplices:i};E&&!t._overrideLegacyUndefined&&(e.splices=r),t.notifyPath(n+".splices",r),t.notifyPath(n+".length",e.length),E&&!t._overrideLegacyUndefined&&(r.indexSplices=[])}function ue(t,e,n,i,r,o){ce(t,e,n,[{index:i,addedCount:r,removed:o,object:e,type:"splice"}])}const he=I((t=>{const e=It(Mt(t));return class extends e{constructor(){super(),this.__isPropertyEffectsClient=!0}get PROPERTY_EFFECT_TYPES(){return zt}_initializeProperties(){super._initializeProperties(),this._registerHost(),this.__dataClientsReady=!1,this.__dataPendingClients=null,this.__dataToNotify=null,this.__dataLinkedPaths=null,this.__dataHasPaths=!1,this.__dataCompoundStorage=this.__dataCompoundStorage||null,this.__dataHost=this.__dataHost||null,this.__dataTemp={},this.__dataClientsInitialized=!1}_registerHost(){if(de.length){let t=de[de.length-1];t._enqueueClient(this),this.__dataHost=t}}_initializeProtoProperties(t){this.__data=Object.create(t),this.__dataPending=Object.create(t),this.__dataOld={}}_initializeInstanceProperties(t){let e=this[zt.READ_ONLY];for(let n in t)e&&e[n]||(this.__dataPending=this.__dataPending||{},this.__dataOld=this.__dataOld||{},this.__data[n]=this.__dataPending[n]=t[n])}_addPropertyEffect(t,e,n){this._createPropertyAccessor(t,e==zt.READ_ONLY);let i=Bt(this,e,!0)[t];i||(i=this[e][t]=[]),i.push(n)}_removePropertyEffect(t,e,n){let i=Bt(this,e,!0)[t],r=i.indexOf(n);r>=0&&i.splice(r,1)}_hasPropertyEffect(t,e){let n=this[e];return Boolean(n&&n[t])}_hasReadOnlyEffect(t){return this._hasPropertyEffect(t,zt.READ_ONLY)}_hasNotifyEffect(t){return this._hasPropertyEffect(t,zt.NOTIFY)}_hasReflectEffect(t){return this._hasPropertyEffect(t,zt.REFLECT)}_hasComputedEffect(t){return this._hasPropertyEffect(t,zt.COMPUTE)}_setPendingPropertyOrPath(t,e,n,i){if(i||$(Array.isArray(t)?t[0]:t)!==t){if(!i){let n=nt(this,t);if(!(t=it(this,t,e))||!super._shouldPropertyChange(t,e,n))return!1}if(this.__dataHasPaths=!0,this._setPendingProperty(t,e,n))return(function r(t,e,n){let i=t.__dataLinkedPaths;if(i){let r;for(let o in i){let a=i[o];Z(o,e)?(r=J(o,a,e),t._setPendingPropertyOrPath(r,n,!0,!0)):Z(a,e)&&(r=J(a,o,e),t._setPendingPropertyOrPath(r,n,!0,!0))}}})(this,t,e),!0}else{if(this.__dataHasAccessor&&this.__dataHasAccessor[t])return this._setPendingProperty(t,e,n);this[t]=e}return!1}_setUnmanagedPropertyToNode(t,e,n){n===t[e]&&"object"!=typeof n||("className"===e&&(t=Y(t)),t[e]=n)}_setPendingProperty(t,e,n){let i=this.__dataHasPaths&&X(t);return!!this._shouldPropertyChange(t,e,(i?this.__dataTemp:this.__data)[t])&&(this.__dataPending||(this.__dataPending={},this.__dataOld={}),t in this.__dataOld||(this.__dataOld[t]=this.__data[t]),i?this.__dataTemp[t]=e:this.__data[t]=e,this.__dataPending[t]=e,(i||this[zt.NOTIFY]&&this[zt.NOTIFY][t])&&(this.__dataToNotify=this.__dataToNotify||{},this.__dataToNotify[t]=n),!0)}_setProperty(t,e){this._setPendingProperty(t,e,!0)&&this._invalidateProperties()}_invalidateProperties(){this.__dataReady&&this._flushProperties()}_enqueueClient(t){this.__dataPendingClients=this.__dataPendingClients||[],t!==this&&this.__dataPendingClients.push(t)}_flushClients(){this.__dataClientsReady?this.__enableOrFlushClients():(this.__dataClientsReady=!0,this._readyClients(),this.__dataReady=!0)}__enableOrFlushClients(){let t=this.__dataPendingClients;if(t){this.__dataPendingClients=null;for(let e=0;e<t.length;e++){let n=t[e];n.__dataEnabled?n.__dataPending&&n._flushProperties():n._enableProperties()}}}_readyClients(){this.__enableOrFlushClients()}setProperties(t,e){for(let n in t)!e&&this[zt.READ_ONLY]&&this[zt.READ_ONLY][n]||this._setPendingPropertyOrPath(n,t[n],!0);this._invalidateProperties()}ready(){this._flushProperties(),this.__dataClientsReady||this._flushClients(),this.__dataPending&&this._flushProperties()}_propertiesChanged(t,e,n){let i,r=this.__dataHasPaths;this.__dataHasPaths=!1,(function o(t,e,n,i){let r=t[zt.COMPUTE];if(r)if(T){Rt++;const o=(function a(t){let e=t.constructor.__orderedComputedDeps;if(!e){e=new Map;const n=t[zt.COMPUTE];let i,{counts:r,ready:o,total:a}=(function s(t){const e=t.__computeInfo,n={},i=t[zt.COMPUTE],r=[];let o=0;for(let t in e){const i=e[t];o+=n[t]=i.args.filter((t=>!t.literal)).length+(i.dynamicFn?1:0)}for(let t in i)e[t]||r.push(t);return{counts:n,ready:r,total:o}})(t);for(;i=o.shift();){e.set(i,e.size);const t=n[i];t&&t.forEach((t=>{const e=t.info.methodInfo;--a,0==--r[e]&&o.push(e)}))}0!==a&&console.warn(`Computed graph for ${t.localName} incomplete; circular?`),t.constructor.__orderedComputedDeps=e}return e})(t),s=[];for(let t in e)Xt(t,r,s,o,i);let l;for(;l=s.shift();)$t(t,"",e,0,l)&&Xt(l.methodInfo,r,s,o,i);Object.assign(n,t.__dataOld),Object.assign(e,t.__dataPending),t.__dataPending=null}else{let o=e;for(;Ht(t,r,o,n,i);)Object.assign(n,t.__dataOld),Object.assign(e,t.__dataPending),o=t.__dataPending,t.__dataPending=null}})(this,e,n,r),i=this.__dataToNotify,this.__dataToNotify=null,this._propagatePropertyChanges(e,n,r),this._flushClients(),Ht(this,this[zt.REFLECT],e,n,r),Ht(this,this[zt.OBSERVE],e,n,r),i&&(function a(t,e,n,i,r){let o,a,s=t[zt.NOTIFY],l=Rt++;for(let a in e)e[a]&&(s&&Ft(t,s,l,a,n,i,r)||r&&jt(t,a,n))&&(o=!0);o&&(a=t.__dataHost)&&a._invalidateProperties&&a._invalidateProperties()})(this,i,e,n,r),1==this.__dataCounter&&(this.__dataTemp={})}_propagatePropertyChanges(t,e,n){this[zt.PROPAGATE]&&Ht(this,this[zt.PROPAGATE],t,e,n),this.__templateInfo&&this._runEffectsForTemplate(this.__templateInfo,t,e,n)}_runEffectsForTemplate(t,e,n,i){const r=(e,i)=>{Ht(this,t.propertyEffects,e,n,i,t.nodeList);for(let r=t.firstChild;r;r=r.nextSibling)this._runEffectsForTemplate(r,e,n,i)};t.runEffects?t.runEffects(r,e,i):r(e,i)}linkPaths(t,e){t=tt(t),e=tt(e),this.__dataLinkedPaths=this.__dataLinkedPaths||{},this.__dataLinkedPaths[t]=e}unlinkPaths(t){t=tt(t),this.__dataLinkedPaths&&delete this.__dataLinkedPaths[t]}notifySplices(t,e){let n={path:""};ce(this,nt(this,t,n),n.path,e)}get(t,e){return nt(e||this,t)}set(t,e,n){n?it(n,t,e):this[zt.READ_ONLY]&&this[zt.READ_ONLY][t]||this._setPendingPropertyOrPath(t,e,!0)&&this._invalidateProperties()}push(t,...e){let n={path:""},i=nt(this,t,n),r=i.length,o=i.push(...e);return e.length&&ue(this,i,n.path,r,e.length,[]),o}pop(t){let e={path:""},n=nt(this,t,e),i=Boolean(n.length),r=n.pop();return i&&ue(this,n,e.path,n.length,0,[r]),r}splice(t,e,n,...i){let r,o={path:""},a=nt(this,t,o);return e<0?e=a.length-Math.floor(-e):e&&(e=Math.floor(e)),r=2===arguments.length?a.splice(e):a.splice(e,n,...i),(i.length||r.length)&&ue(this,a,o.path,e,i.length,r),r}shift(t){let e={path:""},n=nt(this,t,e),i=Boolean(n.length),r=n.shift();return i&&ue(this,n,e.path,0,0,[r]),r}unshift(t,...e){let n={path:""},i=nt(this,t,n),r=i.unshift(...e);return e.length&&ue(this,i,n.path,0,e.length,[]),r}notifyPath(t,e){let n;if(1==arguments.length){let i={path:""};e=nt(this,t,i),n=i.path}else n=Array.isArray(t)?tt(t):t;this._setPendingPropertyOrPath(n,e,!0,!0)&&this._invalidateProperties()}_createReadOnlyProperty(t,e){this._addPropertyEffect(t,zt.READ_ONLY),e&&(this["_set"+(function n(t){return t[0].toUpperCase()+t.substring(1)})(t)]=function(e){this._setProperty(t,e)})}_createPropertyObserver(t,e,n){let i={property:t,method:e,dynamicFn:Boolean(n)};this._addPropertyEffect(t,zt.OBSERVE,{fn:Ut,info:i,trigger:{name:t}}),n&&this._addPropertyEffect(e,zt.OBSERVE,{fn:Ut,info:i,trigger:{name:e}})}_createMethodObserver(t,e){let n=ae(t);if(!n)throw new Error("Malformed observer expression '"+t+"'");ee(this,n,zt.OBSERVE,ne,null,e)}_createNotifyingProperty(t){this._addPropertyEffect(t,zt.NOTIFY,{fn:Wt,info:{eventName:lt(t)+"-changed",property:t}})}_createReflectedProperty(t){let e=this.constructor.attributeNameForProperty(t);"-"===e[0]?console.warn("Property "+t+" cannot be reflected to attribute "+e+' because "-" is not a valid starting attribute name. Use a lowercase first letter for the property instead.'):this._addPropertyEffect(t,zt.REFLECT,{fn:qt,info:{attrName:e}})}_createComputedProperty(t,e,n){let i=ae(e);if(!i)throw new Error("Malformed computed expression '"+e+"'");const r=ee(this,i,zt.COMPUTE,$t,t,n);Bt(this,"__computeInfo")[t]=r}_marshalArgs(t,e,n){const i=this.__data,r=[];for(let o=0,a=t.length;o<a;o++){let{name:a,structured:s,wildcard:l,value:c,literal:u}=t[o];if(!u)if(l){const t=Z(a,e),r=le(i,n,t?e:a);c={path:t?e:a,value:r,base:t?nt(i,a):r}}else c=s?le(i,n,a):i[a];if(E&&!this._overrideLegacyUndefined&&void 0===c&&t.length>1)return Ot;r[o]=c}return r}static addPropertyEffect(t,e,n){this.prototype._addPropertyEffect(t,e,n)}static createPropertyObserver(t,e,n){this.prototype._createPropertyObserver(t,e,n)}static createMethodObserver(t,e){this.prototype._createMethodObserver(t,e)}static createNotifyingProperty(t){this.prototype._createNotifyingProperty(t)}static createReadOnlyProperty(t,e){this.prototype._createReadOnlyProperty(t,e)}static createReflectedProperty(t){this.prototype._createReflectedProperty(t)}static createComputedProperty(t,e,n){this.prototype._createComputedProperty(t,e,n)}static bindTemplate(t){return this.prototype._bindTemplate(t)}_bindTemplate(t,e){let n=this.constructor._parseTemplate(t),i=this.__preBoundTemplateInfo==n;if(!i)for(let t in n.propertyEffects)this._createPropertyAccessor(t);if(e)if(n=Object.create(n),n.wasPreBound=i,this.__templateInfo){const e=t._parentTemplateInfo||this.__templateInfo,i=e.lastChild;n.parent=e,e.lastChild=n,n.previousSibling=i,i?i.nextSibling=n:e.firstChild=n}else this.__templateInfo=n;else this.__preBoundTemplateInfo=n;return n}static _addTemplatePropertyEffect(t,e,n){(t.hostProps=t.hostProps||{})[e]=!0;let i=t.propertyEffects=t.propertyEffects||{};(i[e]=i[e]||[]).push(n)}_stampTemplate(t,e){e=e||this._bindTemplate(t,!0),de.push(this);let n=super._stampTemplate(t,e);if(de.pop(),e.nodeList=n.nodeList,!e.wasPreBound){let t=e.childNodes=[];for(let e=n.firstChild;e;e=e.nextSibling)t.push(e)}return n.templateInfo=e,(function i(t,e){let{nodeList:n,nodeInfoList:i}=e;if(i.length)for(let e=0;e<i.length;e++){let r=n[e],o=i[e].bindings;if(o)for(let e=0;e<o.length;e++){let n=o[e];Qt(r,n),te(r,t,n)}r.__dataHost=t}})(this,e),this.__dataClientsReady&&(this._runEffectsForTemplate(e,this.__data,null,!1),this._flushClients()),n}_removeBoundDom(t){const e=t.templateInfo,{previousSibling:n,nextSibling:i,parent:r}=e;n?n.nextSibling=i:r&&(r.firstChild=i),i?i.previousSibling=n:r&&(r.lastChild=n),e.nextSibling=e.previousSibling=null;let o=e.childNodes;for(let t=0;t<o.length;t++){let e=o[t];Y(Y(e).parentNode).removeChild(e)}}static _parseTemplateNode(t,n,i){let r=e._parseTemplateNode.call(this,t,n,i);if(t.nodeType===Node.TEXT_NODE){let e=this._parseBindings(t.textContent,n);e&&(t.textContent=oe(e)||" ",Kt(this,n,i,"text","textContent",e),r=!0)}return r}static _parseTemplateNodeAttribute(t,n,i,r,o){let a=this._parseBindings(o,n);if(a){let e=r,o="property";Dt.test(r)?o="attribute":"$"==r[r.length-1]&&(r=r.slice(0,-1),o="attribute");let s=oe(a);return s&&"attribute"==o&&("class"==r&&t.hasAttribute("class")&&(s+=" "+t.getAttribute(r)),t.setAttribute(r,s)),"attribute"==o&&"disable-upgrade$"==e&&t.setAttribute(r,""),"input"===t.localName&&"value"===e&&t.setAttribute(e,""),t.removeAttribute(e),"property"===o&&(r=st(r)),Kt(this,n,i,o,r,a,s),!0}return e._parseTemplateNodeAttribute.call(this,t,n,i,r,o)}static _parseTemplateNestedTemplate(t,n,i){let r=e._parseTemplateNestedTemplate.call(this,t,n,i);const o=t.parentNode,a=i.templateInfo,s="dom-if"===o.localName;C&&(s||"dom-repeat"===o.localName)&&(o.removeChild(t),(i=i.parentInfo).templateInfo=a,i.noted=!0,r=!1);let l=a.hostProps;if(A&&s)l&&(n.hostProps=Object.assign(n.hostProps||{},l),C||(i.parentInfo.noted=!0));else{let t="{";for(let e in l)Kt(this,n,i,"property","_host_"+e,[{mode:t,source:e,dependencies:[e],hostProp:!0}])}return r}static _parseBindings(t,e){let n,i=[],r=0;for(;null!==(n=re.exec(t));){n.index>r&&i.push({literal:t.slice(r,n.index)});let o=n[1][0],a=Boolean(n[2]),s=n[3].trim(),l=!1,c="",u=-1;"{"==o&&(u=s.indexOf("::"))>0&&(c=s.substring(u+2),s=s.substring(0,u),l=!0);let h=ae(s),d=[];if(h){let{args:t,methodName:n}=h;for(let e=0;e<t.length;e++){let n=t[e];n.literal||d.push(n)}let i=e.dynamicFns;(i&&i[n]||h.static)&&(d.push(n),h.dynamicFn=!0)}else d.push(s);i.push({source:s,mode:o,negate:a,customEvent:l,signature:h,dependencies:d,event:c}),r=re.lastIndex}if(r&&r<t.length){let e=t.substring(r);e&&i.push({literal:e})}return i.length?i:null}static _evaluateBinding(t,e,n,i,r,o){let a;return a=e.signature?ne(t,n,i,0,e.signature):n!=e.source?nt(t,e.source):o&&X(n)?nt(t,n):t.__data[n],e.negate&&(a=!a),a}}})),de=[],pe=I((t=>{const e=xt(t);function n(t){const e=Object.getPrototypeOf(t);return e.prototype instanceof r?e:null}function i(t){if(!t.hasOwnProperty(JSCompiler_renameProperty("__ownProperties",t))){let e=null;if(t.hasOwnProperty(JSCompiler_renameProperty("properties",t))){const n=t.properties;n&&(e=(
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
function e(t){const e={};for(let n in t){const i=t[n];e[n]="function"==typeof i?{type:i}:i}return e})(n))}t.__ownProperties=e}return t.__ownProperties}class r extends e{static get observedAttributes(){if(!this.hasOwnProperty(JSCompiler_renameProperty("__observedAttributes",this))){const t=this._properties;this.__observedAttributes=t?Object.keys(t).map((t=>this.prototype._addPropertyToAttributeMap(t))):[]}return this.__observedAttributes}static finalize(){if(!this.hasOwnProperty(JSCompiler_renameProperty("__finalized",this))){const t=n(this);t&&t.finalize(),this.__finalized=!0,this._finalizeClass()}}static _finalizeClass(){const t=i(this);t&&this.createProperties(t)}static get _properties(){if(!this.hasOwnProperty(JSCompiler_renameProperty("__properties",this))){const t=n(this);this.__properties=Object.assign({},t&&t._properties,i(this))}return this.__properties}static typeForProperty(t){const e=this._properties[t];return e&&e.type}_initializeProperties(){this.constructor.finalize(),super._initializeProperties()}connectedCallback(){super.connectedCallback&&super.connectedCallback(),this._enableProperties()}disconnectedCallback(){super.disconnectedCallback&&super.disconnectedCallback()}}return r})),fe=window.ShadyCSS&&window.ShadyCSS.cssBuild,me=I((t=>{const e=pe(he(t));function n(t,e,n,i){n.computed&&(n.readOnly=!0),n.computed&&(t._hasReadOnlyEffect(e)?console.warn(`Cannot redefine computed property '${e}'.`):t._createComputedProperty(e,n.computed,i)),n.readOnly&&!t._hasReadOnlyEffect(e)?t._createReadOnlyProperty(e,!n.computed):!1===n.readOnly&&t._hasReadOnlyEffect(e)&&console.warn(`Cannot make readOnly property '${e}' non-readOnly.`),n.reflectToAttribute&&!t._hasReflectEffect(e)?t._createReflectedProperty(e):!1===n.reflectToAttribute&&t._hasReflectEffect(e)&&console.warn(`Cannot make reflected property '${e}' non-reflected.`),n.notify&&!t._hasNotifyEffect(e)?t._createNotifyingProperty(e):!1===n.notify&&t._hasNotifyEffect(e)&&console.warn(`Cannot make notify property '${e}' non-notify.`),n.observer&&t._createPropertyObserver(e,n.observer,i[n.observer]),t._addPropertyToAttributeMap(e)}return class extends e{static get polymerElementVersion(){return"3.4.1"}static _finalizeClass(){e._finalizeClass.call(this);const t=(function n(t){return t.hasOwnProperty(JSCompiler_renameProperty("__ownObservers",t))||(t.__ownObservers=t.hasOwnProperty(JSCompiler_renameProperty("observers",t))?t.observers:null),t.__ownObservers})(this);t&&this.createObservers(t,this._properties),this._prepareTemplate()}static _prepareTemplate(){let t=this.template;t&&("string"==typeof t?(console.error("template getter must return HTMLTemplateElement"),t=null):w||(t=t.cloneNode(!0))),this.prototype._template=t}static createProperties(t){for(let e in t)n(this.prototype,e,t[e],t)}static createObservers(t,e){const n=this.prototype;for(let i=0;i<t.length;i++)n._createMethodObserver(t[i],e)}static get template(){if(!this.hasOwnProperty(JSCompiler_renameProperty("_template",this))){const t=this.prototype.hasOwnProperty(JSCompiler_renameProperty("_template",this.prototype))?this.prototype._template:void 0;this._template=void 0!==t?t:this.hasOwnProperty(JSCompiler_renameProperty("is",this))&&(function e(t){let e=null;if(t&&(!b||x)&&(e=B.import(t,"template"),b&&!e))throw new Error(`strictTemplatePolicy: expecting dom-module or null template for ${t}`);return e})(this.is)||Object.getPrototypeOf(this.prototype).constructor.template}return this._template}static set template(t){this._template=t}static get importPath(){if(!this.hasOwnProperty(JSCompiler_renameProperty("_importPath",this))){const t=this.importMeta;if(t)this._importPath=f(t.url);else{const t=B.import(this.is);this._importPath=t&&t.assetpath||Object.getPrototypeOf(this.prototype).constructor.importPath}}return this._importPath}constructor(){super()}_initializeProperties(){this.constructor.finalize(),this.constructor._finalizeTemplate(this.localName),super._initializeProperties(),this.rootPath=_,this.importPath=this.constructor.importPath;let t=(function e(t){if(!t.hasOwnProperty(JSCompiler_renameProperty("__propertyDefaults",t))){t.__propertyDefaults=null;let e=t._properties;for(let n in e){let i=e[n];"value"in i&&(t.__propertyDefaults=t.__propertyDefaults||{},t.__propertyDefaults[n]=i)}}return t.__propertyDefaults})(this.constructor);if(t)for(let e in t){let n=t[e];if(this._canApplyPropertyDefault(e)){let t="function"==typeof n.value?n.value.call(this):n.value;this._hasAccessor(e)?this._setPendingProperty(e,t,!0):this[e]=t}}}_canApplyPropertyDefault(t){return!this.hasOwnProperty(t)}static _processStyleText(t,e){return p(t,e)}static _finalizeTemplate(t){const e=this.prototype._template;if(e&&!e.__polymerFinalized){e.__polymerFinalized=!0;const n=this.importPath;(function i(t,e,n,r){if(!fe){const i=e.content.querySelectorAll("style"),o=G(e),a=(function s(t){let e=F(t);return e?W(e):[]})(n),l=e.content.firstElementChild;for(let n=0;n<a.length;n++){let i=a[n];i.textContent=t._processStyleText(i.textContent,r),e.content.insertBefore(i,l)}let c=0;for(let e=0;e<o.length;e++){let n=o[e],a=i[c];a!==n?(n=n.cloneNode(!0),a.parentNode.insertBefore(n,a)):c++,n.textContent=t._processStyleText(n.textContent,r)}}if(window.ShadyCSS&&window.ShadyCSS.prepareTemplate(e,n),P&&fe&&g){const n=e.content.querySelectorAll("style");if(n){let e="";Array.from(n).forEach((t=>{e+=t.textContent,t.parentNode.removeChild(t)})),t._styleSheet=new CSSStyleSheet,t._styleSheet.replaceSync(e)}}})(this,e,t,n?d(n):""),this.prototype._bindTemplate(e)}}connectedCallback(){window.ShadyCSS&&this._template&&window.ShadyCSS.styleElement(this),super.connectedCallback()}ready(){this._template&&(this.root=this._stampTemplate(this._template),this.$=this.root.$),super.ready()}_readyClients(){this._template&&(this.root=this._attachDom(this.root)),super._readyClients()}_attachDom(t){const e=Y(this);if(e.attachShadow)return t?(e.shadowRoot||(e.attachShadow({mode:"open",shadyUpgradeFragment:t}),e.shadowRoot.appendChild(t),this.constructor._styleSheet&&(e.shadowRoot.adoptedStyleSheets=[this.constructor._styleSheet])),M&&window.ShadyDOM&&window.ShadyDOM.flushInitial(e.shadowRoot),e.shadowRoot):null;throw new Error("ShadowDOM not available. PolymerElement can create dom as children instead of in ShadowDOM by setting `this.root = this;` before `ready`.")}updateStyles(t){window.ShadyCSS&&window.ShadyCSS.styleSubtree(this,t)}resolveUrl(t,e){return!e&&this.importPath&&(e=d(this.importPath)),d(t,e)}static _parseTemplateContent(t,n,i){return n.dynamicFns=n.dynamicFns||this._properties,e._parseTemplateContent.call(this,t,n,i)}static _addTemplatePropertyEffect(t,n,i){return!S||n in this._properties||i.info.part.signature&&i.info.part.signature.static||i.info.part.hostProp||t.nestedTemplate||console.warn(`Property '${n}' used in template but not declared in 'properties'; attribute will not be observed.`),e._addTemplatePropertyEffect.call(this,t,n,i)}}}));
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
class ge{constructor(t){this.value=t.toString()}toString(){return this.value}}const _e=function t(e,...n){const i=document.createElement("template");return i.innerHTML=n.reduce(((t,n,i)=>t+(function r(t){if(t instanceof HTMLTemplateElement)return t.innerHTML;if(t instanceof ge)return(function e(t){if(t instanceof ge)return t.value;throw new Error(`non-literal value passed to Polymer's htmlLiteral function: ${t}`)})(t);throw new Error(`non-template value passed to Polymer's html function: ${t}`)})(n)+e[i+1]),e[0]),i},ye=me(HTMLElement);
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */var ve="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function be(t){if(t.__esModule)return t;var e=Object.defineProperty({},"__esModule",{value:!0});return Object.keys(t).forEach((function(n){var i=Object.getOwnPropertyDescriptor(t,n);Object.defineProperty(e,n,i.get?i:{enumerable:!0,get:function(){return t[n]}})})),e}var xe,we,Se={exports:{}};
/**
     * @license
     * Lodash <https://lodash.com/>
     * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
     * Released under MIT license <https://lodash.com/license>
     * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
     * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
     */xe=Se,we=Se.exports,function(){var t,e="Expected a function",n="__lodash_hash_undefined__",i="__lodash_placeholder__",r=32,o=128,a=1/0,s=9007199254740991,l=NaN,c=4294967295,u=[["ary",o],["bind",1],["bindKey",2],["curry",8],["curryRight",16],["flip",512],["partial",r],["partialRight",64],["rearg",256]],h="[object Arguments]",d="[object Array]",p="[object Boolean]",f="[object Date]",m="[object Error]",g="[object Function]",_="[object GeneratorFunction]",y="[object Map]",v="[object Number]",b="[object Object]",x="[object Promise]",w="[object RegExp]",S="[object Set]",M="[object String]",E="[object Symbol]",T="[object WeakMap]",C="[object ArrayBuffer]",A="[object DataView]",k="[object Float32Array]",L="[object Float64Array]",P="[object Int8Array]",N="[object Int16Array]",I="[object Int32Array]",R="[object Uint8Array]",O="[object Uint8ClampedArray]",z="[object Uint16Array]",D="[object Uint32Array]",B=/\b__p \+= '';/g,H=/\b(__p \+=) '' \+/g,F=/(__e\(.*?\)|\b__t\)) \+\n'';/g,V=/&(?:amp|lt|gt|quot|#39);/g,U=/[&<>"']/g,j=RegExp(V.source),G=RegExp(U.source),W=/<%-([\s\S]+?)%>/g,q=/<%([\s\S]+?)%>/g,Y=/<%=([\s\S]+?)%>/g,X=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,$=/^\w*$/,K=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,Z=/[\\^$.*+?()[\]{}|]/g,J=RegExp(Z.source),Q=/^\s+/,tt=/\s/,et=/\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/,nt=/\{\n\/\* \[wrapped with (.+)\] \*/,it=/,? & /,rt=/[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g,ot=/[()=,{}\[\]\/\s]/,at=/\\(\\)?/g,st=/\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g,lt=/\w*$/,ct=/^[-+]0x[0-9a-f]+$/i,ut=/^0b[01]+$/i,ht=/^\[object .+?Constructor\]$/,dt=/^0o[0-7]+$/i,pt=/^(?:0|[1-9]\d*)$/,ft=/[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g,mt=/($^)/,gt=/['\n\r\u2028\u2029\\]/g,_t="\\u0300-\\u036f\\ufe20-\\ufe2f\\u20d0-\\u20ff",yt="a-z\\xdf-\\xf6\\xf8-\\xff",vt="A-Z\\xc0-\\xd6\\xd8-\\xde",bt="\\xac\\xb1\\xd7\\xf7\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf\\u2000-\\u206f \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000",xt="["+bt+"]",wt="["+_t+"]",St="\\d+",Mt="["+yt+"]",Et="[^\\ud800-\\udfff"+bt+St+"\\u2700-\\u27bf"+yt+vt+"]",Tt="\\ud83c[\\udffb-\\udfff]",Ct="[^\\ud800-\\udfff]",At="(?:\\ud83c[\\udde6-\\uddff]){2}",kt="[\\ud800-\\udbff][\\udc00-\\udfff]",Lt="["+vt+"]",Pt="(?:"+Mt+"|"+Et+")",Nt="(?:"+Lt+"|"+Et+")",It="(?:['’](?:d|ll|m|re|s|t|ve))?",Rt="(?:['’](?:D|LL|M|RE|S|T|VE))?",Ot="(?:"+wt+"|"+Tt+")?",zt="[\\ufe0e\\ufe0f]?",Dt=zt+Ot+"(?:\\u200d(?:"+[Ct,At,kt].join("|")+")"+zt+Ot+")*",Bt="(?:"+["[\\u2700-\\u27bf]",At,kt].join("|")+")"+Dt,Ht="(?:"+[Ct+wt+"?",wt,At,kt,"[\\ud800-\\udfff]"].join("|")+")",Ft=RegExp("['’]","g"),Vt=RegExp(wt,"g"),Ut=RegExp(Tt+"(?="+Tt+")|"+Ht+Dt,"g"),jt=RegExp([Lt+"?"+Mt+"+"+It+"(?="+[xt,Lt,"$"].join("|")+")",Nt+"+"+Rt+"(?="+[xt,Lt+Pt,"$"].join("|")+")",Lt+"?"+Pt+"+"+It,Lt+"+"+Rt,"\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])","\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])",St,Bt].join("|"),"g"),Gt=RegExp("[\\u200d\\ud800-\\udfff"+_t+"\\ufe0e\\ufe0f]"),Wt=/[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/,qt=["Array","Buffer","DataView","Date","Error","Float32Array","Float64Array","Function","Int8Array","Int16Array","Int32Array","Map","Math","Object","Promise","RegExp","Set","String","Symbol","TypeError","Uint8Array","Uint8ClampedArray","Uint16Array","Uint32Array","WeakMap","_","clearTimeout","isFinite","parseInt","setTimeout"],Yt=-1,Xt={};Xt[k]=Xt[L]=Xt[P]=Xt[N]=Xt[I]=Xt[R]=Xt[O]=Xt[z]=Xt[D]=!0,Xt[h]=Xt[d]=Xt[C]=Xt[p]=Xt[A]=Xt[f]=Xt[m]=Xt[g]=Xt[y]=Xt[v]=Xt[b]=Xt[w]=Xt[S]=Xt[M]=Xt[T]=!1;var $t={};$t[h]=$t[d]=$t[C]=$t[A]=$t[p]=$t[f]=$t[k]=$t[L]=$t[P]=$t[N]=$t[I]=$t[y]=$t[v]=$t[b]=$t[w]=$t[S]=$t[M]=$t[E]=$t[R]=$t[O]=$t[z]=$t[D]=!0,$t[m]=$t[g]=$t[T]=!1;var Kt={"\\":"\\","'":"'","\n":"n","\r":"r","\u2028":"u2028","\u2029":"u2029"},Zt=parseFloat,Jt=parseInt,Qt="object"==typeof ve&&ve&&ve.Object===Object&&ve,te="object"==typeof self&&self&&self.Object===Object&&self,ee=Qt||te||Function("return this")(),ne=we&&!we.nodeType&&we,ie=ne&&xe&&!xe.nodeType&&xe,re=ie&&ie.exports===ne,oe=re&&Qt.process,ae=(function(){try{return ie&&ie.require&&ie.require("util").types||oe&&oe.binding&&oe.binding("util")}catch(t){}})(),se=ae&&ae.isArrayBuffer,le=ae&&ae.isDate,ce=ae&&ae.isMap,ue=ae&&ae.isRegExp,he=ae&&ae.isSet,de=ae&&ae.isTypedArray;function pe(t,e,n){switch(n.length){case 0:return t.call(e);case 1:return t.call(e,n[0]);case 2:return t.call(e,n[0],n[1]);case 3:return t.call(e,n[0],n[1],n[2])}return t.apply(e,n)}function fe(t,e,n,i){for(var r=-1,o=null==t?0:t.length;++r<o;){var a=t[r];e(i,a,n(a),t)}return i}function me(t,e){for(var n=-1,i=null==t?0:t.length;++n<i&&!1!==e(t[n],n,t););return t}function ge(t,e){for(var n=null==t?0:t.length;n--&&!1!==e(t[n],n,t););return t}function _e(t,e){for(var n=-1,i=null==t?0:t.length;++n<i;)if(!e(t[n],n,t))return!1;return!0}function ye(t,e){for(var n=-1,i=null==t?0:t.length,r=0,o=[];++n<i;){var a=t[n];e(a,n,t)&&(o[r++]=a)}return o}function be(t,e){return!(null==t||!t.length)&&Ne(t,e,0)>-1}function Se(t,e,n){for(var i=-1,r=null==t?0:t.length;++i<r;)if(n(e,t[i]))return!0;return!1}function Me(t,e){for(var n=-1,i=null==t?0:t.length,r=Array(i);++n<i;)r[n]=e(t[n],n,t);return r}function Ee(t,e){for(var n=-1,i=e.length,r=t.length;++n<i;)t[r+n]=e[n];return t}function Te(t,e,n,i){var r=-1,o=null==t?0:t.length;for(i&&o&&(n=t[++r]);++r<o;)n=e(n,t[r],r,t);return n}function Ce(t,e,n,i){var r=null==t?0:t.length;for(i&&r&&(n=t[--r]);r--;)n=e(n,t[r],r,t);return n}function Ae(t,e){for(var n=-1,i=null==t?0:t.length;++n<i;)if(e(t[n],n,t))return!0;return!1}var ke=ze("length");function Le(t,e,n){var i;return n(t,(function(t,n,r){if(e(t,n,r))return i=n,!1})),i}function Pe(t,e,n,i){for(var r=t.length,o=n+(i?1:-1);i?o--:++o<r;)if(e(t[o],o,t))return o;return-1}function Ne(t,e,n){return e==e?(function i(t,e,n){for(var i=n-1,r=t.length;++i<r;)if(t[i]===e)return i;return-1})(t,e,n):Pe(t,Re,n)}function Ie(t,e,n,i){for(var r=n-1,o=t.length;++r<o;)if(i(t[r],e))return r;return-1}function Re(t){return t!=t}function Oe(t,e){var n=null==t?0:t.length;return n?He(t,e)/n:l}function ze(e){return function(n){return null==n?t:n[e]}}function De(e){return function(n){return null==e?t:e[n]}}function Be(t,e,n,i,r){return r(t,(function(t,r,o){n=i?(i=!1,t):e(n,t,r,o)})),n}function He(e,n){for(var i,r=-1,o=e.length;++r<o;){var a=n(e[r]);a!==t&&(i=i===t?a:i+a)}return i}function Fe(t,e){for(var n=-1,i=Array(t);++n<t;)i[n]=e(n);return i}function Ve(t){return t?t.slice(0,an(t)+1).replace(Q,""):t}function Ue(t){return function(e){return t(e)}}function je(t,e){return Me(e,(function(e){return t[e]}))}function Ge(t,e){return t.has(e)}function We(t,e){for(var n=-1,i=t.length;++n<i&&Ne(e,t[n],0)>-1;);return n}function qe(t,e){for(var n=t.length;n--&&Ne(e,t[n],0)>-1;);return n}function Ye(t,e){for(var n=t.length,i=0;n--;)t[n]===e&&++i;return i}var Xe=De({"À":"A","Á":"A","Â":"A","Ã":"A","Ä":"A","Å":"A","à":"a","á":"a","â":"a","ã":"a","ä":"a","å":"a","Ç":"C","ç":"c","Ð":"D","ð":"d","È":"E","É":"E","Ê":"E","Ë":"E","è":"e","é":"e","ê":"e","ë":"e","Ì":"I","Í":"I","Î":"I","Ï":"I","ì":"i","í":"i","î":"i","ï":"i","Ñ":"N","ñ":"n","Ò":"O","Ó":"O","Ô":"O","Õ":"O","Ö":"O","Ø":"O","ò":"o","ó":"o","ô":"o","õ":"o","ö":"o","ø":"o","Ù":"U","Ú":"U","Û":"U","Ü":"U","ù":"u","ú":"u","û":"u","ü":"u","Ý":"Y","ý":"y","ÿ":"y","Æ":"Ae","æ":"ae","Þ":"Th","þ":"th","ß":"ss","Ā":"A","Ă":"A","Ą":"A","ā":"a","ă":"a","ą":"a","Ć":"C","Ĉ":"C","Ċ":"C","Č":"C","ć":"c","ĉ":"c","ċ":"c","č":"c","Ď":"D","Đ":"D","ď":"d","đ":"d","Ē":"E","Ĕ":"E","Ė":"E","Ę":"E","Ě":"E","ē":"e","ĕ":"e","ė":"e","ę":"e","ě":"e","Ĝ":"G","Ğ":"G","Ġ":"G","Ģ":"G","ĝ":"g","ğ":"g","ġ":"g","ģ":"g","Ĥ":"H","Ħ":"H","ĥ":"h","ħ":"h","Ĩ":"I","Ī":"I","Ĭ":"I","Į":"I","İ":"I","ĩ":"i","ī":"i","ĭ":"i","į":"i","ı":"i","Ĵ":"J","ĵ":"j","Ķ":"K","ķ":"k","ĸ":"k","Ĺ":"L","Ļ":"L","Ľ":"L","Ŀ":"L","Ł":"L","ĺ":"l","ļ":"l","ľ":"l","ŀ":"l","ł":"l","Ń":"N","Ņ":"N","Ň":"N","Ŋ":"N","ń":"n","ņ":"n","ň":"n","ŋ":"n","Ō":"O","Ŏ":"O","Ő":"O","ō":"o","ŏ":"o","ő":"o","Ŕ":"R","Ŗ":"R","Ř":"R","ŕ":"r","ŗ":"r","ř":"r","Ś":"S","Ŝ":"S","Ş":"S","Š":"S","ś":"s","ŝ":"s","ş":"s","š":"s","Ţ":"T","Ť":"T","Ŧ":"T","ţ":"t","ť":"t","ŧ":"t","Ũ":"U","Ū":"U","Ŭ":"U","Ů":"U","Ű":"U","Ų":"U","ũ":"u","ū":"u","ŭ":"u","ů":"u","ű":"u","ų":"u","Ŵ":"W","ŵ":"w","Ŷ":"Y","ŷ":"y","Ÿ":"Y","Ź":"Z","Ż":"Z","Ž":"Z","ź":"z","ż":"z","ž":"z","Ĳ":"IJ","ĳ":"ij","Œ":"Oe","œ":"oe","ŉ":"'n","ſ":"s"}),$e=De({"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"});function Ke(t){return"\\"+Kt[t]}function Ze(t){return Gt.test(t)}function Je(t){var e=-1,n=Array(t.size);return t.forEach((function(t,i){n[++e]=[i,t]})),n}function Qe(t,e){return function(n){return t(e(n))}}function tn(t,e){for(var n=-1,r=t.length,o=0,a=[];++n<r;){var s=t[n];s!==e&&s!==i||(t[n]=i,a[o++]=n)}return a}function en(t){var e=-1,n=Array(t.size);return t.forEach((function(t){n[++e]=t})),n}function nn(t){var e=-1,n=Array(t.size);return t.forEach((function(t){n[++e]=[t,t]})),n}function rn(t){return Ze(t)?(function e(t){for(var e=Ut.lastIndex=0;Ut.test(t);)++e;return e})(t):ke(t)}function on(t){return Ze(t)?(function e(t){return t.match(Ut)||[]})(t):(function n(t){return t.split("")})(t)}function an(t){for(var e=t.length;e--&&tt.test(t.charAt(e)););return e}var sn=De({"&amp;":"&","&lt;":"<","&gt;":">","&quot;":'"',"&#39;":"'"}),ln=(function tt(_t){var yt,vt=(_t=null==_t?ee:ln.defaults(ee.Object(),_t,ln.pick(ee,qt))).Array,bt=_t.Date,xt=_t.Error,wt=_t.Function,St=_t.Math,Mt=_t.Object,Et=_t.RegExp,Tt=_t.String,Ct=_t.TypeError,At=vt.prototype,kt=Mt.prototype,Lt=_t["__core-js_shared__"],Pt=wt.prototype.toString,Nt=kt.hasOwnProperty,It=0,Rt=(yt=/[^.]+$/.exec(Lt&&Lt.keys&&Lt.keys.IE_PROTO||""))?"Symbol(src)_1."+yt:"",Ot=kt.toString,zt=Pt.call(Mt),Dt=ee._,Bt=Et("^"+Pt.call(Nt).replace(Z,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$"),Ht=re?_t.Buffer:t,Ut=_t.Symbol,Gt=_t.Uint8Array,Kt=Ht?Ht.allocUnsafe:t,Qt=Qe(Mt.getPrototypeOf,Mt),te=Mt.create,ne=kt.propertyIsEnumerable,ie=At.splice,oe=Ut?Ut.isConcatSpreadable:t,ae=Ut?Ut.iterator:t,ve=Ut?Ut.toStringTag:t,xe=(function(){try{var t=Po(Mt,"defineProperty");return t({},"",{}),t}catch(t){}})(),we=_t.clearTimeout!==ee.clearTimeout&&_t.clearTimeout,ke=bt&&bt.now!==ee.Date.now&&bt.now,De=_t.setTimeout!==ee.setTimeout&&_t.setTimeout,cn=St.ceil,un=St.floor,hn=Mt.getOwnPropertySymbols,dn=Ht?Ht.isBuffer:t,pn=_t.isFinite,fn=At.join,mn=Qe(Mt.keys,Mt),gn=St.max,_n=St.min,yn=bt.now,vn=_t.parseInt,bn=St.random,xn=At.reverse,wn=Po(_t,"DataView"),Sn=Po(_t,"Map"),Mn=Po(_t,"Promise"),En=Po(_t,"Set"),Tn=Po(_t,"WeakMap"),Cn=Po(Mt,"create"),An=Tn&&new Tn,kn={},Ln=oa(wn),Pn=oa(Sn),Nn=oa(Mn),In=oa(En),Rn=oa(Tn),On=Ut?Ut.prototype:t,zn=On?On.valueOf:t,Dn=On?On.toString:t;function Bn(t){if(Ms(t)&&!hs(t)&&!(t instanceof Un)){if(t instanceof Vn)return t;if(Nt.call(t,"__wrapped__"))return aa(t)}return new Vn(t)}var Hn=(function(){function e(){}return function(n){if(!Ss(n))return{};if(te)return te(n);e.prototype=n;var i=new e;return e.prototype=t,i}})();function Fn(){}function Vn(e,n){this.__wrapped__=e,this.__actions__=[],this.__chain__=!!n,this.__index__=0,this.__values__=t}function Un(t){this.__wrapped__=t,this.__actions__=[],this.__dir__=1,this.__filtered__=!1,this.__iteratees__=[],this.__takeCount__=c,this.__views__=[]}function jn(t){var e=-1,n=null==t?0:t.length;for(this.clear();++e<n;){var i=t[e];this.set(i[0],i[1])}}function Gn(t){var e=-1,n=null==t?0:t.length;for(this.clear();++e<n;){var i=t[e];this.set(i[0],i[1])}}function Wn(t){var e=-1,n=null==t?0:t.length;for(this.clear();++e<n;){var i=t[e];this.set(i[0],i[1])}}function qn(t){var e=-1,n=null==t?0:t.length;for(this.__data__=new Wn;++e<n;)this.add(t[e])}function Yn(t){var e=this.__data__=new Gn(t);this.size=e.size}function Xn(t,e){var n=hs(t),i=!n&&us(t),r=!n&&!i&&gs(t),o=!n&&!i&&!r&&Os(t),a=n||i||r||o,s=a?Fe(t.length,Tt):[],l=s.length;for(var c in t)!e&&!Nt.call(t,c)||a&&("length"==c||r&&("offset"==c||"parent"==c)||o&&("buffer"==c||"byteLength"==c||"byteOffset"==c)||Bo(c,l))||s.push(c);return s}function $n(e){var n=e.length;return n?e[pr(0,n-1)]:t}function Kn(t,e){return ea(Xr(t),oi(e,0,t.length))}function Zn(t){return ea(Xr(t))}function Jn(e,n,i){(i!==t&&!ss(e[n],i)||i===t&&!(n in e))&&ii(e,n,i)}function Qn(e,n,i){var r=e[n];Nt.call(e,n)&&ss(r,i)&&(i!==t||n in e)||ii(e,n,i)}function ti(t,e){for(var n=t.length;n--;)if(ss(t[n][0],e))return n;return-1}function ei(t,e,n,i){return Ni(t,(function(t,r,o){e(i,t,n(t),o)})),i}function ni(t,e){return t&&$r(e,rl(e),t)}function ii(t,e,n){"__proto__"==e&&xe?xe(t,e,{configurable:!0,enumerable:!0,value:n,writable:!0}):t[e]=n}function ri(e,n){for(var i=-1,r=n.length,o=vt(r),a=null==e;++i<r;)o[i]=a?t:Qs(e,n[i]);return o}function oi(e,n,i){return e==e&&(i!==t&&(e=e<=i?e:i),n!==t&&(e=e>=n?e:n)),e}function ai(e,n,i,r,o,a){var s,l=1&n,c=2&n,u=4&n;if(i&&(s=o?i(e,r,o,a):i(e)),s!==t)return s;if(!Ss(e))return e;var d=hs(e);if(d){if(s=(function m(t){var e=t.length,n=new t.constructor(e);return e&&"string"==typeof t[0]&&Nt.call(t,"index")&&(n.index=t.index,n.input=t.input),n})(e),!l)return Xr(e,s)}else{var x=Ro(e),T=x==g||x==_;if(gs(e))return Ur(e,l);if(x==b||x==h||T&&!o){if(s=c||T?{}:zo(e),!l)return c?(function H(t,e){return $r(t,Io(t),e)})(e,(function B(t,e){return t&&$r(e,ol(e),t)})(s,e)):(function F(t,e){return $r(t,No(t),e)})(e,ni(s,e))}else{if(!$t[x])return o?e:{};s=(function V(t,e,n){var i=t.constructor;switch(e){case C:return jr(t);case p:case f:return new i(+t);case A:return(function r(t,e){var n=e?jr(t.buffer):t.buffer;return new t.constructor(n,t.byteOffset,t.byteLength)})(t,n);case k:case L:case P:case N:case I:case R:case O:case z:case D:return Gr(t,n);case y:return new i;case v:case M:return new i(t);case w:return(function o(t){var e=new t.constructor(t.source,lt.exec(t));return e.lastIndex=t.lastIndex,e})(t);case S:return new i;case E:return(function a(t){return zn?Mt(zn.call(t)):{}})(t)}})(e,x,l)}}a||(a=new Yn);var U=a.get(e);if(U)return U;a.set(e,s),Ps(e)?e.forEach((function(t){s.add(ai(t,n,i,t,e,a))})):Es(e)&&e.forEach((function(t,r){s.set(r,ai(t,n,i,r,e,a))}));var j=d?t:(u?c?Mo:So:c?ol:rl)(e);return me(j||e,(function(t,r){j&&(t=e[r=t]),Qn(s,r,ai(t,n,i,r,e,a))})),s}function si(e,n,i){var r=i.length;if(null==e)return!r;for(e=Mt(e);r--;){var o=i[r],a=e[o];if(a===t&&!(o in e)||!(0,n[o])(a))return!1}return!0}function li(n,i,r){if("function"!=typeof n)throw new Ct(e);return Zo((function(){n.apply(t,r)}),i)}function ci(t,e,n,i){var r=-1,o=be,a=!0,s=t.length,l=[],c=e.length;if(!s)return l;n&&(e=Me(e,Ue(n))),i?(o=Se,a=!1):e.length>=200&&(o=Ge,a=!1,e=new qn(e));t:for(;++r<s;){var u=t[r],h=null==n?u:n(u);if(u=i||0!==u?u:0,a&&h==h){for(var d=c;d--;)if(e[d]===h)continue t;l.push(u)}else o(e,h,i)||l.push(u)}return l}Bn.templateSettings={escape:W,evaluate:q,interpolate:Y,variable:"",imports:{_:Bn}},(Bn.prototype=Fn.prototype).constructor=Bn,(Vn.prototype=Hn(Fn.prototype)).constructor=Vn,(Un.prototype=Hn(Fn.prototype)).constructor=Un,jn.prototype.clear=function ui(){this.__data__=Cn?Cn(null):{},this.size=0},jn.prototype.delete=function hi(t){var e=this.has(t)&&delete this.__data__[t];return this.size-=e?1:0,e},jn.prototype.get=function di(e){var i=this.__data__;if(Cn){var r=i[e];return r===n?t:r}return Nt.call(i,e)?i[e]:t},jn.prototype.has=function pi(e){var n=this.__data__;return Cn?n[e]!==t:Nt.call(n,e)},jn.prototype.set=function fi(e,i){var r=this.__data__;return this.size+=this.has(e)?0:1,r[e]=Cn&&i===t?n:i,this},Gn.prototype.clear=function mi(){this.__data__=[],this.size=0},Gn.prototype.delete=function gi(t){var e=this.__data__,n=ti(e,t);return!(n<0||(n==e.length-1?e.pop():ie.call(e,n,1),--this.size,0))},Gn.prototype.get=function _i(e){var n=this.__data__,i=ti(n,e);return i<0?t:n[i][1]},Gn.prototype.has=function yi(t){return ti(this.__data__,t)>-1},Gn.prototype.set=function vi(t,e){var n=this.__data__,i=ti(n,t);return i<0?(++this.size,n.push([t,e])):n[i][1]=e,this},Wn.prototype.clear=function bi(){this.size=0,this.__data__={hash:new jn,map:new(Sn||Gn),string:new jn}},Wn.prototype.delete=function xi(t){var e=ko(this,t).delete(t);return this.size-=e?1:0,e},Wn.prototype.get=function wi(t){return ko(this,t).get(t)},Wn.prototype.has=function Si(t){return ko(this,t).has(t)},Wn.prototype.set=function Mi(t,e){var n=ko(this,t),i=n.size;return n.set(t,e),this.size+=n.size==i?0:1,this},qn.prototype.add=qn.prototype.push=function Ei(t){return this.__data__.set(t,n),this},qn.prototype.has=function Ti(t){return this.__data__.has(t)},Yn.prototype.clear=function Ci(){this.__data__=new Gn,this.size=0},Yn.prototype.delete=function Ai(t){var e=this.__data__,n=e.delete(t);return this.size=e.size,n},Yn.prototype.get=function ki(t){return this.__data__.get(t)},Yn.prototype.has=function Li(t){return this.__data__.has(t)},Yn.prototype.set=function Pi(t,e){var n=this.__data__;if(n instanceof Gn){var i=n.__data__;if(!Sn||i.length<199)return i.push([t,e]),this.size=++n.size,this;n=this.__data__=new Wn(i)}return n.set(t,e),this.size=n.size,this};var Ni=Jr(Fi),Ii=Jr(Vi,!0);function Ri(t,e){var n=!0;return Ni(t,(function(t,i,r){return n=!!e(t,i,r)})),n}function Oi(e,n,i){for(var r=-1,o=e.length;++r<o;){var a=e[r],s=n(a);if(null!=s&&(l===t?s==s&&!Rs(s):i(s,l)))var l=s,c=a}return c}function zi(t,e){var n=[];return Ni(t,(function(t,i,r){e(t,i,r)&&n.push(t)})),n}function Di(t,e,n,i,r){var o=-1,a=t.length;for(n||(n=Do),r||(r=[]);++o<a;){var s=t[o];e>0&&n(s)?e>1?Di(s,e-1,n,i,r):Ee(r,s):i||(r[r.length]=s)}return r}var Bi=Qr(),Hi=Qr(!0);function Fi(t,e){return t&&Bi(t,e,rl)}function Vi(t,e){return t&&Hi(t,e,rl)}function Ui(t,e){return ye(e,(function(e){return bs(t[e])}))}function ji(e,n){for(var i=0,r=(n=Br(n,e)).length;null!=e&&i<r;)e=e[ra(n[i++])];return i&&i==r?e:t}function Gi(t,e,n){var i=e(t);return hs(t)?i:Ee(i,n(t))}function Wi(e){return null==e?e===t?"[object Undefined]":"[object Null]":ve&&ve in Mt(e)?(function n(e){var n=Nt.call(e,ve),i=e[ve];try{e[ve]=t;var r=!0}catch(t){}var o=Ot.call(e);return r&&(n?e[ve]=i:delete e[ve]),o})(e):(function i(t){return Ot.call(t)})(e)}function qi(t,e){return t>e}function Yi(t,e){return null!=t&&Nt.call(t,e)}function Xi(t,e){return null!=t&&e in Mt(t)}function $i(e,n,i){for(var r=i?Se:be,o=e[0].length,a=e.length,s=a,l=vt(a),c=1/0,u=[];s--;){var h=e[s];s&&n&&(h=Me(h,Ue(n))),c=_n(h.length,c),l[s]=!i&&(n||o>=120&&h.length>=120)?new qn(s&&h):t}h=e[0];var d=-1,p=l[0];t:for(;++d<o&&u.length<c;){var f=h[d],m=n?n(f):f;if(f=i||0!==f?f:0,!(p?Ge(p,m):r(u,m,i))){for(s=a;--s;){var g=l[s];if(!(g?Ge(g,m):r(e[s],m,i)))continue t}p&&p.push(m),u.push(f)}}return u}function Ki(e,n,i){var r=null==(e=Yo(e,n=Br(n,e)))?e:e[ra(_a(n))];return null==r?t:pe(r,e,i)}function Zi(t){return Ms(t)&&Wi(t)==h}function Ji(e,n,i,r,o){return e===n||(null==e||null==n||!Ms(e)&&!Ms(n)?e!=e&&n!=n:(function a(e,n,i,r,o,s){var l=hs(e),c=hs(n),u=l?d:Ro(e),g=c?d:Ro(n),_=(u=u==h?b:u)==b,x=(g=g==h?b:g)==b,T=u==g;if(T&&gs(e)){if(!gs(n))return!1;l=!0,_=!1}if(T&&!_)return s||(s=new Yn),l||Os(e)?xo(e,n,i,r,o,s):(function k(t,e,n,i,r,o,a){switch(n){case A:if(t.byteLength!=e.byteLength||t.byteOffset!=e.byteOffset)return!1;t=t.buffer,e=e.buffer;case C:return!(t.byteLength!=e.byteLength||!o(new Gt(t),new Gt(e)));case p:case f:case v:return ss(+t,+e);case m:return t.name==e.name&&t.message==e.message;case w:case M:return t==e+"";case y:var s=Je;case S:if(s||(s=en),t.size!=e.size&&!(1&i))return!1;var l=a.get(t);if(l)return l==e;i|=2,a.set(t,e);var c=xo(s(t),s(e),i,r,o,a);return a.delete(t),c;case E:if(zn)return zn.call(t)==zn.call(e)}return!1})(e,n,u,i,r,o,s);if(!(1&i)){var L=_&&Nt.call(e,"__wrapped__"),P=x&&Nt.call(n,"__wrapped__");if(L||P){var N=L?e.value():e,I=P?n.value():n;return s||(s=new Yn),o(N,I,i,r,s)}}return!!T&&(s||(s=new Yn),(function R(e,n,i,r,o,a){var s=1&i,l=So(e),c=l.length;if(c!=So(n).length&&!s)return!1;for(var u=c;u--;){var h=l[u];if(!(s?h in n:Nt.call(n,h)))return!1}var d=a.get(e),p=a.get(n);if(d&&p)return d==n&&p==e;var f=!0;a.set(e,n),a.set(n,e);for(var m=s;++u<c;){var g=e[h=l[u]],_=n[h];if(r)var y=s?r(_,g,h,n,e,a):r(g,_,h,e,n,a);if(!(y===t?g===_||o(g,_,i,r,a):y)){f=!1;break}m||(m="constructor"==h)}if(f&&!m){var v=e.constructor,b=n.constructor;v==b||!("constructor"in e)||!("constructor"in n)||"function"==typeof v&&v instanceof v&&"function"==typeof b&&b instanceof b||(f=!1)}return a.delete(e),a.delete(n),f})(e,n,i,r,o,s))})(e,n,i,r,Ji,o))}function Qi(e,n,i,r){var o=i.length,a=o,s=!r;if(null==e)return!a;for(e=Mt(e);o--;){var l=i[o];if(s&&l[2]?l[1]!==e[l[0]]:!(l[0]in e))return!1}for(;++o<a;){var c=(l=i[o])[0],u=e[c],h=l[1];if(s&&l[2]){if(u===t&&!(c in e))return!1}else{var d=new Yn;if(r)var p=r(u,h,c,e,n,d);if(!(p===t?Ji(h,u,3,r,d):p))return!1}}return!0}function tr(t){return!(!Ss(t)||(function e(t){return!!Rt&&Rt in t})(t))&&(bs(t)?Bt:ht).test(oa(t))}function er(t){return"function"==typeof t?t:null==t?Ll:"object"==typeof t?hs(t)?ar(t[0],t[1]):or(t):Hl(t)}function nr(t){if(!jo(t))return mn(t);var e=[];for(var n in Mt(t))Nt.call(t,n)&&"constructor"!=n&&e.push(n);return e}function ir(t,e){return t<e}function rr(t,e){var n=-1,i=fs(t)?vt(t.length):[];return Ni(t,(function(t,r,o){i[++n]=e(t,r,o)})),i}function or(t){var e=Lo(t);return 1==e.length&&e[0][2]?Wo(e[0][0],e[0][1]):function(n){return n===t||Qi(n,t,e)}}function ar(e,n){return Fo(e)&&Go(n)?Wo(ra(e),n):function(i){var r=Qs(i,e);return r===t&&r===n?tl(i,e):Ji(n,r,3)}}function sr(e,n,i,r,o){e!==n&&Bi(n,(function(a,s){if(o||(o=new Yn),Ss(a))!(function l(e,n,i,r,o,a,s){var l=$o(e,i),c=$o(n,i),u=s.get(c);if(u)Jn(e,i,u);else{var h=a?a(l,c,i+"",e,n,s):t,d=h===t;if(d){var p=hs(c),f=!p&&gs(c),m=!p&&!f&&Os(c);h=c,p||f||m?hs(l)?h=l:ms(l)?h=Xr(l):f?(d=!1,h=Ur(c,!0)):m?(d=!1,h=Gr(c,!0)):h=[]:As(c)||us(c)?(h=l,us(l)?h=Gs(l):Ss(l)&&!bs(l)||(h=zo(c))):d=!1}d&&(s.set(c,h),o(h,c,r,a,s),s.delete(c)),Jn(e,i,h)}})(e,n,s,i,sr,r,o);else{var c=r?r($o(e,s),a,s+"",e,n,o):t;c===t&&(c=a),Jn(e,s,c)}}),ol)}function lr(e,n){var i=e.length;if(i)return Bo(n+=n<0?i:0,i)?e[n]:t}function cr(t,e,n){e=e.length?Me(e,(function(t){return hs(t)?function(e){return ji(e,1===t.length?t[0]:t)}:t})):[Ll];var i=-1;return e=Me(e,Ue(Ao())),(function r(t,e){var n=t.length;for(t.sort(e);n--;)t[n]=t[n].value;return t})(rr(t,(function(t,n,r){return{criteria:Me(e,(function(e){return e(t)})),index:++i,value:t}})),(function(t,e){return(function i(t,e,n){for(var i=-1,r=t.criteria,o=e.criteria,a=r.length,s=n.length;++i<a;){var l=Wr(r[i],o[i]);if(l)return i>=s?l:l*("desc"==n[i]?-1:1)}return t.index-e.index})(t,e,n)}))}function ur(t,e,n){for(var i=-1,r=e.length,o={};++i<r;){var a=e[i],s=ji(t,a);n(s,a)&&yr(o,Br(a,t),s)}return o}function hr(t,e,n,i){var r=i?Ie:Ne,o=-1,a=e.length,s=t;for(t===e&&(e=Xr(e)),n&&(s=Me(t,Ue(n)));++o<a;)for(var l=0,c=e[o],u=n?n(c):c;(l=r(s,u,l,i))>-1;)s!==t&&ie.call(s,l,1),ie.call(t,l,1);return t}function dr(t,e){for(var n=t?e.length:0,i=n-1;n--;){var r=e[n];if(n==i||r!==o){var o=r;Bo(r)?ie.call(t,r,1):Lr(t,r)}}return t}function pr(t,e){return t+un(bn()*(e-t+1))}function fr(t,e){var n="";if(!t||e<1||e>s)return n;do{e%2&&(n+=t),(e=un(e/2))&&(t+=t)}while(e);return n}function mr(t,e){return Jo(qo(t,e,Ll),t+"")}function gr(t){return $n(pl(t))}function _r(t,e){var n=pl(t);return ea(n,oi(e,0,n.length))}function yr(e,n,i,r){if(!Ss(e))return e;for(var o=-1,a=(n=Br(n,e)).length,s=a-1,l=e;null!=l&&++o<a;){var c=ra(n[o]),u=i;if("__proto__"===c||"constructor"===c||"prototype"===c)return e;if(o!=s){var h=l[c];(u=r?r(h,c,l):t)===t&&(u=Ss(h)?h:Bo(n[o+1])?[]:{})}Qn(l,c,u),l=l[c]}return e}var vr=An?function(t,e){return An.set(t,e),t}:Ll,br=xe?function(t,e){return xe(t,"toString",{configurable:!0,enumerable:!1,value:Cl(e),writable:!0})}:Ll;function xr(t){return ea(pl(t))}function wr(t,e,n){var i=-1,r=t.length;e<0&&(e=-e>r?0:r+e),(n=n>r?r:n)<0&&(n+=r),r=e>n?0:n-e>>>0,e>>>=0;for(var o=vt(r);++i<r;)o[i]=t[i+e];return o}function Sr(t,e){var n;return Ni(t,(function(t,i,r){return!(n=e(t,i,r))})),!!n}function Mr(t,e,n){var i=0,r=null==t?i:t.length;if("number"==typeof e&&e==e&&r<=2147483647){for(;i<r;){var o=i+r>>>1,a=t[o];null!==a&&!Rs(a)&&(n?a<=e:a<e)?i=o+1:r=o}return r}return Er(t,e,Ll,n)}function Er(e,n,i,r){var o=0,a=null==e?0:e.length;if(0===a)return 0;for(var s=(n=i(n))!=n,l=null===n,c=Rs(n),u=n===t;o<a;){var h=un((o+a)/2),d=i(e[h]),p=d!==t,f=null===d,m=d==d,g=Rs(d);if(s)var _=r||m;else _=u?m&&(r||p):l?m&&p&&(r||!f):c?m&&p&&!f&&(r||!g):!f&&!g&&(r?d<=n:d<n);_?o=h+1:a=h}return _n(a,4294967294)}function Tr(t,e){for(var n=-1,i=t.length,r=0,o=[];++n<i;){var a=t[n],s=e?e(a):a;if(!n||!ss(s,l)){var l=s;o[r++]=0===a?0:a}}return o}function Cr(t){return"number"==typeof t?t:Rs(t)?l:+t}function Ar(t){if("string"==typeof t)return t;if(hs(t))return Me(t,Ar)+"";if(Rs(t))return Dn?Dn.call(t):"";var e=t+"";return"0"==e&&1/t==-1/0?"-0":e}function kr(t,e,n){var i=-1,r=be,o=t.length,a=!0,s=[],l=s;if(n)a=!1,r=Se;else if(o>=200){var c=e?null:mo(t);if(c)return en(c);a=!1,r=Ge,l=new qn}else l=e?[]:s;t:for(;++i<o;){var u=t[i],h=e?e(u):u;if(u=n||0!==u?u:0,a&&h==h){for(var d=l.length;d--;)if(l[d]===h)continue t;e&&l.push(h),s.push(u)}else r(l,h,n)||(l!==s&&l.push(h),s.push(u))}return s}function Lr(t,e){return null==(t=Yo(t,e=Br(e,t)))||delete t[ra(_a(e))]}function Pr(t,e,n,i){return yr(t,e,n(ji(t,e)),i)}function Nr(t,e,n,i){for(var r=t.length,o=i?r:-1;(i?o--:++o<r)&&e(t[o],o,t););return n?wr(t,i?0:o,i?o+1:r):wr(t,i?o+1:0,i?r:o)}function Ir(t,e){var n=t;return n instanceof Un&&(n=n.value()),Te(e,(function(t,e){return e.func.apply(e.thisArg,Ee([t],e.args))}),n)}function Rr(t,e,n){var i=t.length;if(i<2)return i?kr(t[0]):[];for(var r=-1,o=vt(i);++r<i;)for(var a=t[r],s=-1;++s<i;)s!=r&&(o[r]=ci(o[r]||a,t[s],e,n));return kr(Di(o,1),e,n)}function Or(e,n,i){for(var r=-1,o=e.length,a=n.length,s={};++r<o;)i(s,e[r],r<a?n[r]:t);return s}function zr(t){return ms(t)?t:[]}function Dr(t){return"function"==typeof t?t:Ll}function Br(t,e){return hs(t)?t:Fo(t,e)?[t]:na(Ws(t))}var Hr=mr;function Fr(e,n,i){var r=e.length;return i=i===t?r:i,!n&&i>=r?e:wr(e,n,i)}var Vr=we||function(t){return ee.clearTimeout(t)};function Ur(t,e){if(e)return t.slice();var n=t.length,i=Kt?Kt(n):new t.constructor(n);return t.copy(i),i}function jr(t){var e=new t.constructor(t.byteLength);return new Gt(e).set(new Gt(t)),e}function Gr(t,e){var n=e?jr(t.buffer):t.buffer;return new t.constructor(n,t.byteOffset,t.length)}function Wr(e,n){if(e!==n){var i=e!==t,r=null===e,o=e==e,a=Rs(e),s=n!==t,l=null===n,c=n==n,u=Rs(n);if(!l&&!u&&!a&&e>n||a&&s&&c&&!l&&!u||r&&s&&c||!i&&c||!o)return 1;if(!r&&!a&&!u&&e<n||u&&i&&o&&!r&&!a||l&&i&&o||!s&&o||!c)return-1}return 0}function qr(t,e,n,i){for(var r=-1,o=t.length,a=n.length,s=-1,l=e.length,c=gn(o-a,0),u=vt(l+c),h=!i;++s<l;)u[s]=e[s];for(;++r<a;)(h||r<o)&&(u[n[r]]=t[r]);for(;c--;)u[s++]=t[r++];return u}function Yr(t,e,n,i){for(var r=-1,o=t.length,a=-1,s=n.length,l=-1,c=e.length,u=gn(o-s,0),h=vt(u+c),d=!i;++r<u;)h[r]=t[r];for(var p=r;++l<c;)h[p+l]=e[l];for(;++a<s;)(d||r<o)&&(h[p+n[a]]=t[r++]);return h}function Xr(t,e){var n=-1,i=t.length;for(e||(e=vt(i));++n<i;)e[n]=t[n];return e}function $r(e,n,i,r){var o=!i;i||(i={});for(var a=-1,s=n.length;++a<s;){var l=n[a],c=r?r(i[l],e[l],l,i,e):t;c===t&&(c=e[l]),o?ii(i,l,c):Qn(i,l,c)}return i}function Kr(t,e){return function(n,i){var r=hs(n)?fe:ei,o=e?e():{};return r(n,t,Ao(i,2),o)}}function Zr(e){return mr((function(n,i){var r=-1,o=i.length,a=o>1?i[o-1]:t,s=o>2?i[2]:t;for(a=e.length>3&&"function"==typeof a?(o--,a):t,s&&Ho(i[0],i[1],s)&&(a=o<3?t:a,o=1),n=Mt(n);++r<o;){var l=i[r];l&&e(n,l,r,a)}return n}))}function Jr(t,e){return function(n,i){if(null==n)return n;if(!fs(n))return t(n,i);for(var r=n.length,o=e?r:-1,a=Mt(n);(e?o--:++o<r)&&!1!==i(a[o],o,a););return n}}function Qr(t){return function(e,n,i){for(var r=-1,o=Mt(e),a=i(e),s=a.length;s--;){var l=a[t?s:++r];if(!1===n(o[l],l,o))break}return e}}function to(e){return function(n){var i=Ze(n=Ws(n))?on(n):t,r=i?i[0]:n.charAt(0),o=i?Fr(i,1).join(""):n.slice(1);return r[e]()+o}}function eo(t){return function(e){return Te(Ml(gl(e).replace(Ft,"")),t,"")}}function no(t){return function(){var e=arguments;switch(e.length){case 0:return new t;case 1:return new t(e[0]);case 2:return new t(e[0],e[1]);case 3:return new t(e[0],e[1],e[2]);case 4:return new t(e[0],e[1],e[2],e[3]);case 5:return new t(e[0],e[1],e[2],e[3],e[4]);case 6:return new t(e[0],e[1],e[2],e[3],e[4],e[5]);case 7:return new t(e[0],e[1],e[2],e[3],e[4],e[5],e[6])}var n=Hn(t.prototype),i=t.apply(n,e);return Ss(i)?i:n}}function io(e){return function(n,i,r){var o=Mt(n);if(!fs(n)){var a=Ao(i,3);n=rl(n),i=function(t){return a(o[t],t,o)}}var s=e(n,i,r);return s>-1?o[a?n[s]:s]:t}}function ro(n){return wo((function(i){var r=i.length,o=r,a=Vn.prototype.thru;for(n&&i.reverse();o--;){var s=i[o];if("function"!=typeof s)throw new Ct(e);if(a&&!l&&"wrapper"==To(s))var l=new Vn([],!0)}for(o=l?o:r;++o<r;){var c=To(s=i[o]),u="wrapper"==c?Eo(s):t;l=u&&Vo(u[0])&&424==u[1]&&!u[4].length&&1==u[9]?l[To(u[0])].apply(l,u[3]):1==s.length&&Vo(s)?l[c]():l.thru(s)}return function(){var t=arguments,e=t[0];if(l&&1==t.length&&hs(e))return l.plant(e).value();for(var n=0,o=r?i[n].apply(this,t):e;++n<r;)o=i[n].call(this,o);return o}}))}function oo(e,n,i,r,a,s,l,c,u,h){var d=n&o,p=1&n,f=2&n,m=24&n,g=512&n,_=f?t:no(e);return function t(){for(var o=arguments.length,y=vt(o),v=o;v--;)y[v]=arguments[v];if(m)var b=Co(t),x=Ye(y,b);if(r&&(y=qr(y,r,a,m)),s&&(y=Yr(y,s,l,m)),o-=x,m&&o<h){var w=tn(y,b);return po(e,n,oo,t.placeholder,i,y,w,c,u,h-o)}var S=p?i:this,M=f?S[e]:e;return o=y.length,c?y=Xo(y,c):g&&o>1&&y.reverse(),d&&u<o&&(y.length=u),this&&this!==ee&&this instanceof t&&(M=_||no(M)),M.apply(S,y)}}function ao(t,e){return function(n,i){return(function r(t,e,n,i){return Fi(t,(function(t,r,o){e(i,n(t),r,o)})),i})(n,t,e(i),{})}}function so(e,n){return function(i,r){var o;if(i===t&&r===t)return n;if(i!==t&&(o=i),r!==t){if(o===t)return r;"string"==typeof i||"string"==typeof r?(i=Ar(i),r=Ar(r)):(i=Cr(i),r=Cr(r)),o=e(i,r)}return o}}function lo(t){return wo((function(e){return e=Me(e,Ue(Ao())),mr((function(n){var i=this;return t(e,(function(t){return pe(t,i,n)}))}))}))}function co(e,n){var i=(n=n===t?" ":Ar(n)).length;if(i<2)return i?fr(n,e):n;var r=fr(n,cn(e/rn(n)));return Ze(n)?Fr(on(r),0,e).join(""):r.slice(0,e)}function uo(e){return function(n,i,r){return r&&"number"!=typeof r&&Ho(n,i,r)&&(i=r=t),n=Fs(n),i===t?(i=n,n=0):i=Fs(i),(function o(t,e,n,i){for(var r=-1,o=gn(cn((e-t)/(n||1)),0),a=vt(o);o--;)a[i?o:++r]=t,t+=n;return a})(n,i,r=r===t?n<i?1:-1:Fs(r),e)}}function ho(t){return function(e,n){return"string"==typeof e&&"string"==typeof n||(e=js(e),n=js(n)),t(e,n)}}function po(e,n,i,o,a,s,l,c,u,h){var d=8&n;n|=d?r:64,4&(n&=~(d?64:r))||(n&=-4);var p=[e,n,a,d?s:t,d?l:t,d?t:s,d?t:l,c,u,h],f=i.apply(t,p);return Vo(e)&&Ko(f,p),f.placeholder=o,Qo(f,e,n)}function fo(t){var e=St[t];return function(t,n){if(t=js(t),(n=null==n?0:_n(Vs(n),292))&&pn(t)){var i=(Ws(t)+"e").split("e");return+((i=(Ws(e(i[0]+"e"+(+i[1]+n)))+"e").split("e"))[0]+"e"+(+i[1]-n))}return e(t)}}var mo=En&&1/en(new En([,-0]))[1]==a?function(t){return new En(t)}:Ol;function go(t){return function(e){var n=Ro(e);return n==y?Je(e):n==S?nn(e):(function i(t,e){return Me(e,(function(e){return[e,t[e]]}))})(e,t(e))}}function _o(n,a,s,l,c,u,h,d){var p=2&a;if(!p&&"function"!=typeof n)throw new Ct(e);var f=l?l.length:0;if(f||(a&=-97,l=c=t),h=h===t?h:gn(Vs(h),0),d=d===t?d:Vs(d),f-=c?c.length:0,64&a){var m=l,g=c;l=c=t}var _=p?t:Eo(n),y=[n,a,s,l,c,m,g,u,h,d];if(_&&(function v(t,e){var n=t[1],r=e[1],a=n|r;if(!(a<131||r==o&&8==n||r==o&&256==n&&t[7].length<=e[8]||384==r&&e[7].length<=e[8]&&8==n))return t;1&r&&(t[2]=e[2],a|=1&n?0:4);var s=e[3];if(s){var l=t[3];t[3]=l?qr(l,s,e[4]):s,t[4]=l?tn(t[3],i):e[4]}(s=e[5])&&(t[5]=(l=t[5])?Yr(l,s,e[6]):s,t[6]=l?tn(t[5],i):e[6]),(s=e[7])&&(t[7]=s),r&o&&(t[8]=null==t[8]?e[8]:_n(t[8],e[8])),null==t[9]&&(t[9]=e[9]),t[0]=e[0],t[1]=a})(y,_),n=y[0],a=y[1],s=y[2],l=y[3],c=y[4],!(d=y[9]=y[9]===t?p?0:n.length:gn(y[9]-f,0))&&24&a&&(a&=-25),a&&1!=a)w=8==a||16==a?(function b(e,n,i){var r=no(e);return function o(){for(var a=arguments.length,s=vt(a),l=a,c=Co(o);l--;)s[l]=arguments[l];var u=a<3&&s[0]!==c&&s[a-1]!==c?[]:tn(s,c);return(a-=u.length)<i?po(e,n,oo,o.placeholder,t,s,u,t,t,i-a):pe(this&&this!==ee&&this instanceof o?r:e,this,s)}})(n,a,d):a!=r&&33!=a||c.length?oo.apply(t,y):(function x(t,e,n,i){var r=1&e,o=no(t);return function e(){for(var a=-1,s=arguments.length,l=-1,c=i.length,u=vt(c+s),h=this&&this!==ee&&this instanceof e?o:t;++l<c;)u[l]=i[l];for(;s--;)u[l++]=arguments[++a];return pe(h,r?n:this,u)}})(n,a,s,l);else var w=(function S(t,e,n){var i=1&e,r=no(t);return function e(){return(this&&this!==ee&&this instanceof e?r:t).apply(i?n:this,arguments)}})(n,a,s);return Qo((_?vr:Ko)(w,y),n,a)}function yo(e,n,i,r){return e===t||ss(e,kt[i])&&!Nt.call(r,i)?n:e}function vo(e,n,i,r,o,a){return Ss(e)&&Ss(n)&&(a.set(n,e),sr(e,n,t,vo,a),a.delete(n)),e}function bo(e){return As(e)?t:e}function xo(e,n,i,r,o,a){var s=1&i,l=e.length,c=n.length;if(l!=c&&!(s&&c>l))return!1;var u=a.get(e),h=a.get(n);if(u&&h)return u==n&&h==e;var d=-1,p=!0,f=2&i?new qn:t;for(a.set(e,n),a.set(n,e);++d<l;){var m=e[d],g=n[d];if(r)var _=s?r(g,m,d,n,e,a):r(m,g,d,e,n,a);if(_!==t){if(_)continue;p=!1;break}if(f){if(!Ae(n,(function(t,e){if(!Ge(f,e)&&(m===t||o(m,t,i,r,a)))return f.push(e)}))){p=!1;break}}else if(m!==g&&!o(m,g,i,r,a)){p=!1;break}}return a.delete(e),a.delete(n),p}function wo(e){return Jo(qo(e,t,da),e+"")}function So(t){return Gi(t,rl,No)}function Mo(t){return Gi(t,ol,Io)}var Eo=An?function(t){return An.get(t)}:Ol;function To(t){for(var e=t.name+"",n=kn[e],i=Nt.call(kn,e)?n.length:0;i--;){var r=n[i],o=r.func;if(null==o||o==t)return r.name}return e}function Co(t){return(Nt.call(Bn,"placeholder")?Bn:t).placeholder}function Ao(){var t=Bn.iteratee||Pl;return t=t===Pl?er:t,arguments.length?t(arguments[0],arguments[1]):t}function ko(t,e){var n=t.__data__;return(function i(t){var e=typeof t;return"string"==e||"number"==e||"symbol"==e||"boolean"==e?"__proto__"!==t:null===t})(e)?n["string"==typeof e?"string":"hash"]:n.map}function Lo(t){for(var e=rl(t),n=e.length;n--;){var i=e[n],r=t[i];e[n]=[i,r,Go(r)]}return e}function Po(e,n){var i=(function r(e,n){return null==e?t:e[n]})(e,n);return tr(i)?i:t}var No=hn?function(t){return null==t?[]:(t=Mt(t),ye(hn(t),(function(e){return ne.call(t,e)})))}:Ul,Io=hn?function(t){for(var e=[];t;)Ee(e,No(t)),t=Qt(t);return e}:Ul,Ro=Wi;function Oo(t,e,n){for(var i=-1,r=(e=Br(e,t)).length,o=!1;++i<r;){var a=ra(e[i]);if(!(o=null!=t&&n(t,a)))break;t=t[a]}return o||++i!=r?o:!!(r=null==t?0:t.length)&&ws(r)&&Bo(a,r)&&(hs(t)||us(t))}function zo(t){return"function"!=typeof t.constructor||jo(t)?{}:Hn(Qt(t))}function Do(t){return hs(t)||us(t)||!!(oe&&t&&t[oe])}function Bo(t,e){var n=typeof t;return!!(e=null==e?s:e)&&("number"==n||"symbol"!=n&&pt.test(t))&&t>-1&&t%1==0&&t<e}function Ho(t,e,n){if(!Ss(n))return!1;var i=typeof e;return!!("number"==i?fs(n)&&Bo(e,n.length):"string"==i&&e in n)&&ss(n[e],t)}function Fo(t,e){if(hs(t))return!1;var n=typeof t;return!("number"!=n&&"symbol"!=n&&"boolean"!=n&&null!=t&&!Rs(t))||$.test(t)||!X.test(t)||null!=e&&t in Mt(e)}function Vo(t){var e=To(t),n=Bn[e];if("function"!=typeof n||!(e in Un.prototype))return!1;if(t===n)return!0;var i=Eo(n);return!!i&&t===i[0]}(wn&&Ro(new wn(new ArrayBuffer(1)))!=A||Sn&&Ro(new Sn)!=y||Mn&&Ro(Mn.resolve())!=x||En&&Ro(new En)!=S||Tn&&Ro(new Tn)!=T)&&(Ro=function(e){var n=Wi(e),i=n==b?e.constructor:t,r=i?oa(i):"";if(r)switch(r){case Ln:return A;case Pn:return y;case Nn:return x;case In:return S;case Rn:return T}return n});var Uo=Lt?bs:jl;function jo(t){var e=t&&t.constructor;return t===("function"==typeof e&&e.prototype||kt)}function Go(t){return t==t&&!Ss(t)}function Wo(e,n){return function(i){return null!=i&&i[e]===n&&(n!==t||e in Mt(i))}}function qo(e,n,i){return n=gn(n===t?e.length-1:n,0),function(){for(var t=arguments,r=-1,o=gn(t.length-n,0),a=vt(o);++r<o;)a[r]=t[n+r];r=-1;for(var s=vt(n+1);++r<n;)s[r]=t[r];return s[n]=i(a),pe(e,this,s)}}function Yo(t,e){return e.length<2?t:ji(t,wr(e,0,-1))}function Xo(e,n){for(var i=e.length,r=_n(n.length,i),o=Xr(e);r--;){var a=n[r];e[r]=Bo(a,i)?o[a]:t}return e}function $o(t,e){if(("constructor"!==e||"function"!=typeof t[e])&&"__proto__"!=e)return t[e]}var Ko=ta(vr),Zo=De||function(t,e){return ee.setTimeout(t,e)},Jo=ta(br);function Qo(t,e,n){var i=e+"";return Jo(t,(function a(t,e){var n=e.length;if(!n)return t;var i=n-1;return e[i]=(n>1?"& ":"")+e[i],e=e.join(n>2?", ":" "),t.replace(et,"{\n/* [wrapped with "+e+"] */\n")})(i,(function o(t,e){return me(u,(function(n){var i="_."+n[0];e&n[1]&&!be(t,i)&&t.push(i)})),t.sort()})((function r(t){var e=t.match(nt);return e?e[1].split(it):[]})(i),n)))}function ta(e){var n=0,i=0;return function(){var r=yn(),o=16-(r-i);if(i=r,o>0){if(++n>=800)return arguments[0]}else n=0;return e.apply(t,arguments)}}function ea(e,n){var i=-1,r=e.length,o=r-1;for(n=n===t?r:n;++i<n;){var a=pr(i,o),s=e[a];e[a]=e[i],e[i]=s}return e.length=n,e}var na=(function ia(t){var e=es(t,(function(t){return 500===n.size&&n.clear(),t})),n=e.cache;return e})((function(t){var e=[];return 46===t.charCodeAt(0)&&e.push(""),t.replace(K,(function(t,n,i,r){e.push(i?r.replace(at,"$1"):n||t)})),e}));function ra(t){if("string"==typeof t||Rs(t))return t;var e=t+"";return"0"==e&&1/t==-1/0?"-0":e}function oa(t){if(null!=t){try{return Pt.call(t)}catch(t){}try{return t+""}catch(t){}}return""}function aa(t){if(t instanceof Un)return t.clone();var e=new Vn(t.__wrapped__,t.__chain__);return e.__actions__=Xr(t.__actions__),e.__index__=t.__index__,e.__values__=t.__values__,e}var sa=mr((function(t,e){return ms(t)?ci(t,Di(e,1,ms,!0)):[]})),la=mr((function(e,n){var i=_a(n);return ms(i)&&(i=t),ms(e)?ci(e,Di(n,1,ms,!0),Ao(i,2)):[]})),ca=mr((function(e,n){var i=_a(n);return ms(i)&&(i=t),ms(e)?ci(e,Di(n,1,ms,!0),t,i):[]}));function ua(t,e,n){var i=null==t?0:t.length;if(!i)return-1;var r=null==n?0:Vs(n);return r<0&&(r=gn(i+r,0)),Pe(t,Ao(e,3),r)}function ha(e,n,i){var r=null==e?0:e.length;if(!r)return-1;var o=r-1;return i!==t&&(o=Vs(i),o=i<0?gn(r+o,0):_n(o,r-1)),Pe(e,Ao(n,3),o,!0)}function da(t){return null!=t&&t.length?Di(t,1):[]}function pa(e){return e&&e.length?e[0]:t}var fa=mr((function(t){var e=Me(t,zr);return e.length&&e[0]===t[0]?$i(e):[]})),ma=mr((function(e){var n=_a(e),i=Me(e,zr);return n===_a(i)?n=t:i.pop(),i.length&&i[0]===e[0]?$i(i,Ao(n,2)):[]})),ga=mr((function(e){var n=_a(e),i=Me(e,zr);return(n="function"==typeof n?n:t)&&i.pop(),i.length&&i[0]===e[0]?$i(i,t,n):[]}));function _a(e){var n=null==e?0:e.length;return n?e[n-1]:t}var ya=mr(va);function va(t,e){return t&&t.length&&e&&e.length?hr(t,e):t}var ba=wo((function(t,e){var n=null==t?0:t.length,i=ri(t,e);return dr(t,Me(e,(function(t){return Bo(t,n)?+t:t})).sort(Wr)),i}));function xa(t){return null==t?t:xn.call(t)}var wa=mr((function(t){return kr(Di(t,1,ms,!0))})),Sa=mr((function(e){var n=_a(e);return ms(n)&&(n=t),kr(Di(e,1,ms,!0),Ao(n,2))})),Ma=mr((function(e){var n=_a(e);return n="function"==typeof n?n:t,kr(Di(e,1,ms,!0),t,n)}));function Ea(t){if(!t||!t.length)return[];var e=0;return t=ye(t,(function(t){if(ms(t))return e=gn(t.length,e),!0})),Fe(e,(function(e){return Me(t,ze(e))}))}function Ta(e,n){if(!e||!e.length)return[];var i=Ea(e);return null==n?i:Me(i,(function(e){return pe(n,t,e)}))}var Ca=mr((function(t,e){return ms(t)?ci(t,e):[]})),Aa=mr((function(t){return Rr(ye(t,ms))})),ka=mr((function(e){var n=_a(e);return ms(n)&&(n=t),Rr(ye(e,ms),Ao(n,2))})),La=mr((function(e){var n=_a(e);return n="function"==typeof n?n:t,Rr(ye(e,ms),t,n)})),Pa=mr(Ea),Na=mr((function(e){var n=e.length,i=n>1?e[n-1]:t;return i="function"==typeof i?(e.pop(),i):t,Ta(e,i)}));function Ia(t){var e=Bn(t);return e.__chain__=!0,e}function Ra(t,e){return e(t)}var Oa=wo((function(e){var n=e.length,i=n?e[0]:0,r=this.__wrapped__,o=function(t){return ri(t,e)};return!(n>1||this.__actions__.length)&&r instanceof Un&&Bo(i)?((r=r.slice(i,+i+(n?1:0))).__actions__.push({func:Ra,args:[o],thisArg:t}),new Vn(r,this.__chain__).thru((function(e){return n&&!e.length&&e.push(t),e}))):this.thru(o)})),za=Kr((function(t,e,n){Nt.call(t,n)?++t[n]:ii(t,n,1)})),Da=io(ua),Ba=io(ha);function Ha(t,e){return(hs(t)?me:Ni)(t,Ao(e,3))}function Fa(t,e){return(hs(t)?ge:Ii)(t,Ao(e,3))}var Va=Kr((function(t,e,n){Nt.call(t,n)?t[n].push(e):ii(t,n,[e])})),Ua=mr((function(t,e,n){var i=-1,r="function"==typeof e,o=fs(t)?vt(t.length):[];return Ni(t,(function(t){o[++i]=r?pe(e,t,n):Ki(t,e,n)})),o})),ja=Kr((function(t,e,n){ii(t,n,e)}));function Ga(t,e){return(hs(t)?Me:rr)(t,Ao(e,3))}var Wa=Kr((function(t,e,n){t[n?0:1].push(e)}),(function(){return[[],[]]})),qa=mr((function(t,e){if(null==t)return[];var n=e.length;return n>1&&Ho(t,e[0],e[1])?e=[]:n>2&&Ho(e[0],e[1],e[2])&&(e=[e[0]]),cr(t,Di(e,1),[])})),Ya=ke||function(){return ee.Date.now()};function Xa(e,n,i){return n=i?t:n,_o(e,o,t,t,t,t,n=e&&null==n?e.length:n)}function $a(n,i){var r;if("function"!=typeof i)throw new Ct(e);return n=Vs(n),function(){return--n>0&&(r=i.apply(this,arguments)),n<=1&&(i=t),r}}var Ka=mr((function(t,e,n){var i=1;if(n.length){var o=tn(n,Co(Ka));i|=r}return _o(t,i,e,n,o)})),Za=mr((function(t,e,n){var i=3;if(n.length){var o=tn(n,Co(Za));i|=r}return _o(e,i,t,n,o)}));function Ja(n,i,r){var o,a,s,l,c,u,h=0,d=!1,p=!1,f=!0;if("function"!=typeof n)throw new Ct(e);function m(e){var i=o,r=a;return o=a=t,h=e,l=n.apply(r,i)}function g(t){return h=t,c=Zo(y,i),d?m(t):l}function _(e){var n=e-u;return u===t||n>=i||n<0||p&&e-h>=s}function y(){var t=Ya();if(_(t))return v(t);c=Zo(y,(function e(t){var e=i-(t-u);return p?_n(e,s-(t-h)):e})(t))}function v(e){return c=t,f&&o?m(e):(o=a=t,l)}function b(){var e=Ya(),n=_(e);if(o=arguments,a=this,u=e,n){if(c===t)return g(u);if(p)return Vr(c),c=Zo(y,i),m(u)}return c===t&&(c=Zo(y,i)),l}return i=js(i)||0,Ss(r)&&(d=!!r.leading,s=(p="maxWait"in r)?gn(js(r.maxWait)||0,i):s,f="trailing"in r?!!r.trailing:f),b.cancel=function x(){c!==t&&Vr(c),h=0,o=u=a=c=t},b.flush=function w(){return c===t?l:v(Ya())},b}var Qa=mr((function(t,e){return li(t,1,e)})),ts=mr((function(t,e,n){return li(t,js(e)||0,n)}));function es(t,n){if("function"!=typeof t||null!=n&&"function"!=typeof n)throw new Ct(e);var i=function(){var e=arguments,r=n?n.apply(this,e):e[0],o=i.cache;if(o.has(r))return o.get(r);var a=t.apply(this,e);return i.cache=o.set(r,a)||o,a};return i.cache=new(es.Cache||Wn),i}function ns(t){if("function"!=typeof t)throw new Ct(e);return function(){var e=arguments;switch(e.length){case 0:return!t.call(this);case 1:return!t.call(this,e[0]);case 2:return!t.call(this,e[0],e[1]);case 3:return!t.call(this,e[0],e[1],e[2])}return!t.apply(this,e)}}es.Cache=Wn;var is=Hr((function(t,e){var n=(e=1==e.length&&hs(e[0])?Me(e[0],Ue(Ao())):Me(Di(e,1),Ue(Ao()))).length;return mr((function(i){for(var r=-1,o=_n(i.length,n);++r<o;)i[r]=e[r].call(this,i[r]);return pe(t,this,i)}))})),rs=mr((function(e,n){var i=tn(n,Co(rs));return _o(e,r,t,n,i)})),os=mr((function(e,n){var i=tn(n,Co(os));return _o(e,64,t,n,i)})),as=wo((function(e,n){return _o(e,256,t,t,t,n)}));function ss(t,e){return t===e||t!=t&&e!=e}var ls=ho(qi),cs=ho((function(t,e){return t>=e})),us=Zi((function(){return arguments})())?Zi:function(t){return Ms(t)&&Nt.call(t,"callee")&&!ne.call(t,"callee")},hs=vt.isArray,ds=se?Ue(se):function ps(t){return Ms(t)&&Wi(t)==C};function fs(t){return null!=t&&ws(t.length)&&!bs(t)}function ms(t){return Ms(t)&&fs(t)}var gs=dn||jl,_s=le?Ue(le):function ys(t){return Ms(t)&&Wi(t)==f};function vs(t){if(!Ms(t))return!1;var e=Wi(t);return e==m||"[object DOMException]"==e||"string"==typeof t.message&&"string"==typeof t.name&&!As(t)}function bs(t){if(!Ss(t))return!1;var e=Wi(t);return e==g||e==_||"[object AsyncFunction]"==e||"[object Proxy]"==e}function xs(t){return"number"==typeof t&&t==Vs(t)}function ws(t){return"number"==typeof t&&t>-1&&t%1==0&&t<=s}function Ss(t){var e=typeof t;return null!=t&&("object"==e||"function"==e)}function Ms(t){return null!=t&&"object"==typeof t}var Es=ce?Ue(ce):function Ts(t){return Ms(t)&&Ro(t)==y};function Cs(t){return"number"==typeof t||Ms(t)&&Wi(t)==v}function As(t){if(!Ms(t)||Wi(t)!=b)return!1;var e=Qt(t);if(null===e)return!0;var n=Nt.call(e,"constructor")&&e.constructor;return"function"==typeof n&&n instanceof n&&Pt.call(n)==zt}var ks=ue?Ue(ue):function Ls(t){return Ms(t)&&Wi(t)==w},Ps=he?Ue(he):function Ns(t){return Ms(t)&&Ro(t)==S};function Is(t){return"string"==typeof t||!hs(t)&&Ms(t)&&Wi(t)==M}function Rs(t){return"symbol"==typeof t||Ms(t)&&Wi(t)==E}var Os=de?Ue(de):function zs(t){return Ms(t)&&ws(t.length)&&!!Xt[Wi(t)]},Ds=ho(ir),Bs=ho((function(t,e){return t<=e}));function Hs(t){if(!t)return[];if(fs(t))return Is(t)?on(t):Xr(t);if(ae&&t[ae])return(function e(t){for(var e,n=[];!(e=t.next()).done;)n.push(e.value);return n})(t[ae]());var n=Ro(t);return(n==y?Je:n==S?en:pl)(t)}function Fs(t){return t?(t=js(t))===a||t===-1/0?17976931348623157e292*(t<0?-1:1):t==t?t:0:0===t?t:0}function Vs(t){var e=Fs(t),n=e%1;return e==e?n?e-n:e:0}function Us(t){return t?oi(Vs(t),0,c):0}function js(t){if("number"==typeof t)return t;if(Rs(t))return l;if(Ss(t)){var e="function"==typeof t.valueOf?t.valueOf():t;t=Ss(e)?e+"":e}if("string"!=typeof t)return 0===t?t:+t;t=Ve(t);var n=ut.test(t);return n||dt.test(t)?Jt(t.slice(2),n?2:8):ct.test(t)?l:+t}function Gs(t){return $r(t,ol(t))}function Ws(t){return null==t?"":Ar(t)}var qs=Zr((function(t,e){if(jo(e)||fs(e))$r(e,rl(e),t);else for(var n in e)Nt.call(e,n)&&Qn(t,n,e[n])})),Ys=Zr((function(t,e){$r(e,ol(e),t)})),Xs=Zr((function(t,e,n,i){$r(e,ol(e),t,i)})),$s=Zr((function(t,e,n,i){$r(e,rl(e),t,i)})),Ks=wo(ri),Zs=mr((function(e,n){e=Mt(e);var i=-1,r=n.length,o=r>2?n[2]:t;for(o&&Ho(n[0],n[1],o)&&(r=1);++i<r;)for(var a=n[i],s=ol(a),l=-1,c=s.length;++l<c;){var u=s[l],h=e[u];(h===t||ss(h,kt[u])&&!Nt.call(e,u))&&(e[u]=a[u])}return e})),Js=mr((function(e){return e.push(t,vo),pe(sl,t,e)}));function Qs(e,n,i){var r=null==e?t:ji(e,n);return r===t?i:r}function tl(t,e){return null!=t&&Oo(t,e,Xi)}var el=ao((function(t,e,n){null!=e&&"function"!=typeof e.toString&&(e=Ot.call(e)),t[e]=n}),Cl(Ll)),nl=ao((function(t,e,n){null!=e&&"function"!=typeof e.toString&&(e=Ot.call(e)),Nt.call(t,e)?t[e].push(n):t[e]=[n]}),Ao),il=mr(Ki);function rl(t){return fs(t)?Xn(t):nr(t)}function ol(t){return fs(t)?Xn(t,!0):(function e(t){if(!Ss(t))return(function e(t){var e=[];if(null!=t)for(var n in Mt(t))e.push(n);return e})(t);var n=jo(t),i=[];for(var r in t)("constructor"!=r||!n&&Nt.call(t,r))&&i.push(r);return i})(t)}var al=Zr((function(t,e,n){sr(t,e,n)})),sl=Zr((function(t,e,n,i){sr(t,e,n,i)})),ll=wo((function(t,e){var n={};if(null==t)return n;var i=!1;e=Me(e,(function(e){return e=Br(e,t),i||(i=e.length>1),e})),$r(t,Mo(t),n),i&&(n=ai(n,7,bo));for(var r=e.length;r--;)Lr(n,e[r]);return n})),cl=wo((function(t,e){return null==t?{}:(function n(t,e){return ur(t,e,(function(e,n){return tl(t,n)}))})(t,e)}));function ul(t,e){if(null==t)return{};var n=Me(Mo(t),(function(t){return[t]}));return e=Ao(e),ur(t,n,(function(t,n){return e(t,n[0])}))}var hl=go(rl),dl=go(ol);function pl(t){return null==t?[]:je(t,rl(t))}var fl=eo((function(t,e,n){return e=e.toLowerCase(),t+(n?ml(e):e)}));function ml(t){return Sl(Ws(t).toLowerCase())}function gl(t){return(t=Ws(t))&&t.replace(ft,Xe).replace(Vt,"")}var _l=eo((function(t,e,n){return t+(n?"-":"")+e.toLowerCase()})),yl=eo((function(t,e,n){return t+(n?" ":"")+e.toLowerCase()})),vl=to("toLowerCase"),bl=eo((function(t,e,n){return t+(n?"_":"")+e.toLowerCase()})),xl=eo((function(t,e,n){return t+(n?" ":"")+Sl(e)})),wl=eo((function(t,e,n){return t+(n?" ":"")+e.toUpperCase()})),Sl=to("toUpperCase");function Ml(e,n,i){return e=Ws(e),(n=i?t:n)===t?(function r(t){return Wt.test(t)})(e)?(function o(t){return t.match(jt)||[]})(e):(function a(t){return t.match(rt)||[]})(e):e.match(n)||[]}var El=mr((function(e,n){try{return pe(e,t,n)}catch(t){return vs(t)?t:new xt(t)}})),Tl=wo((function(t,e){return me(e,(function(e){e=ra(e),ii(t,e,Ka(t[e],t))})),t}));function Cl(t){return function(){return t}}var Al=ro(),kl=ro(!0);function Ll(t){return t}function Pl(t){return er("function"==typeof t?t:ai(t,1))}var Nl=mr((function(t,e){return function(n){return Ki(n,t,e)}})),Il=mr((function(t,e){return function(n){return Ki(t,n,e)}}));function Rl(t,e,n){var i=rl(e),r=Ui(e,i);null!=n||Ss(e)&&(r.length||!i.length)||(n=e,e=t,t=this,r=Ui(e,rl(e)));var o=!(Ss(n)&&"chain"in n&&!n.chain),a=bs(t);return me(r,(function(n){var i=e[n];t[n]=i,a&&(t.prototype[n]=function(){var e=this.__chain__;if(o||e){var n=t(this.__wrapped__),r=n.__actions__=Xr(this.__actions__);return r.push({func:i,args:arguments,thisArg:t}),n.__chain__=e,n}return i.apply(t,Ee([this.value()],arguments))})})),t}function Ol(){}var zl=lo(Me),Dl=lo(_e),Bl=lo(Ae);function Hl(t){return Fo(t)?ze(ra(t)):(function e(t){return function(e){return ji(e,t)}})(t)}var Fl=uo(),Vl=uo(!0);function Ul(){return[]}function jl(){return!1}var Gl,Wl=so((function(t,e){return t+e}),0),ql=fo("ceil"),Yl=so((function(t,e){return t/e}),1),Xl=fo("floor"),$l=so((function(t,e){return t*e}),1),Kl=fo("round"),Zl=so((function(t,e){return t-e}),0);return Bn.after=function Jl(t,n){if("function"!=typeof n)throw new Ct(e);return t=Vs(t),function(){if(--t<1)return n.apply(this,arguments)}},Bn.ary=Xa,Bn.assign=qs,Bn.assignIn=Ys,Bn.assignInWith=Xs,Bn.assignWith=$s,Bn.at=Ks,Bn.before=$a,Bn.bind=Ka,Bn.bindAll=Tl,Bn.bindKey=Za,Bn.castArray=function Ql(){if(!arguments.length)return[];var t=arguments[0];return hs(t)?t:[t]},Bn.chain=Ia,Bn.chunk=function tc(e,n,i){n=(i?Ho(e,n,i):n===t)?1:gn(Vs(n),0);var r=null==e?0:e.length;if(!r||n<1)return[];for(var o=0,a=0,s=vt(cn(r/n));o<r;)s[a++]=wr(e,o,o+=n);return s},Bn.compact=function ec(t){for(var e=-1,n=null==t?0:t.length,i=0,r=[];++e<n;){var o=t[e];o&&(r[i++]=o)}return r},Bn.concat=function nc(){var t=arguments.length;if(!t)return[];for(var e=vt(t-1),n=arguments[0],i=t;i--;)e[i-1]=arguments[i];return Ee(hs(n)?Xr(n):[n],Di(e,1))},Bn.cond=function ic(t){var n=null==t?0:t.length,i=Ao();return t=n?Me(t,(function(t){if("function"!=typeof t[1])throw new Ct(e);return[i(t[0]),t[1]]})):[],mr((function(e){for(var i=-1;++i<n;){var r=t[i];if(pe(r[0],this,e))return pe(r[1],this,e)}}))},Bn.conforms=function rc(t){return(function e(t){var e=rl(t);return function(n){return si(n,t,e)}})(ai(t,1))},Bn.constant=Cl,Bn.countBy=za,Bn.create=function oc(t,e){var n=Hn(t);return null==e?n:ni(n,e)},Bn.curry=function e(n,i,r){var o=_o(n,8,t,t,t,t,t,i=r?t:i);return o.placeholder=e.placeholder,o},Bn.curryRight=function e(n,i,r){var o=_o(n,16,t,t,t,t,t,i=r?t:i);return o.placeholder=e.placeholder,o},Bn.debounce=Ja,Bn.defaults=Zs,Bn.defaultsDeep=Js,Bn.defer=Qa,Bn.delay=ts,Bn.difference=sa,Bn.differenceBy=la,Bn.differenceWith=ca,Bn.drop=function ac(e,n,i){var r=null==e?0:e.length;return r?wr(e,(n=i||n===t?1:Vs(n))<0?0:n,r):[]},Bn.dropRight=function sc(e,n,i){var r=null==e?0:e.length;return r?wr(e,0,(n=r-(n=i||n===t?1:Vs(n)))<0?0:n):[]},Bn.dropRightWhile=function lc(t,e){return t&&t.length?Nr(t,Ao(e,3),!0,!0):[]},Bn.dropWhile=function cc(t,e){return t&&t.length?Nr(t,Ao(e,3),!0):[]},Bn.fill=function uc(e,n,i,r){var o=null==e?0:e.length;return o?(i&&"number"!=typeof i&&Ho(e,n,i)&&(i=0,r=o),(function a(e,n,i,r){var o=e.length;for((i=Vs(i))<0&&(i=-i>o?0:o+i),(r=r===t||r>o?o:Vs(r))<0&&(r+=o),r=i>r?0:Us(r);i<r;)e[i++]=n;return e})(e,n,i,r)):[]},Bn.filter=function hc(t,e){return(hs(t)?ye:zi)(t,Ao(e,3))},Bn.flatMap=function dc(t,e){return Di(Ga(t,e),1)},Bn.flatMapDeep=function pc(t,e){return Di(Ga(t,e),a)},Bn.flatMapDepth=function fc(e,n,i){return i=i===t?1:Vs(i),Di(Ga(e,n),i)},Bn.flatten=da,Bn.flattenDeep=function mc(t){return null!=t&&t.length?Di(t,a):[]},Bn.flattenDepth=function gc(e,n){return null!=e&&e.length?Di(e,n=n===t?1:Vs(n)):[]},Bn.flip=function _c(t){return _o(t,512)},Bn.flow=Al,Bn.flowRight=kl,Bn.fromPairs=function yc(t){for(var e=-1,n=null==t?0:t.length,i={};++e<n;){var r=t[e];i[r[0]]=r[1]}return i},Bn.functions=function vc(t){return null==t?[]:Ui(t,rl(t))},Bn.functionsIn=function bc(t){return null==t?[]:Ui(t,ol(t))},Bn.groupBy=Va,Bn.initial=function xc(t){return null!=t&&t.length?wr(t,0,-1):[]},Bn.intersection=fa,Bn.intersectionBy=ma,Bn.intersectionWith=ga,Bn.invert=el,Bn.invertBy=nl,Bn.invokeMap=Ua,Bn.iteratee=Pl,Bn.keyBy=ja,Bn.keys=rl,Bn.keysIn=ol,Bn.map=Ga,Bn.mapKeys=function wc(t,e){var n={};return e=Ao(e,3),Fi(t,(function(t,i,r){ii(n,e(t,i,r),t)})),n},Bn.mapValues=function Sc(t,e){var n={};return e=Ao(e,3),Fi(t,(function(t,i,r){ii(n,i,e(t,i,r))})),n},Bn.matches=function Mc(t){return or(ai(t,1))},Bn.matchesProperty=function Ec(t,e){return ar(t,ai(e,1))},Bn.memoize=es,Bn.merge=al,Bn.mergeWith=sl,Bn.method=Nl,Bn.methodOf=Il,Bn.mixin=Rl,Bn.negate=ns,Bn.nthArg=function Tc(t){return t=Vs(t),mr((function(e){return lr(e,t)}))},Bn.omit=ll,Bn.omitBy=function Cc(t,e){return ul(t,ns(Ao(e)))},Bn.once=function Ac(t){return $a(2,t)},Bn.orderBy=function kc(e,n,i,r){return null==e?[]:(hs(n)||(n=null==n?[]:[n]),hs(i=r?t:i)||(i=null==i?[]:[i]),cr(e,n,i))},Bn.over=zl,Bn.overArgs=is,Bn.overEvery=Dl,Bn.overSome=Bl,Bn.partial=rs,Bn.partialRight=os,Bn.partition=Wa,Bn.pick=cl,Bn.pickBy=ul,Bn.property=Hl,Bn.propertyOf=function Lc(e){return function(n){return null==e?t:ji(e,n)}},Bn.pull=ya,Bn.pullAll=va,Bn.pullAllBy=function Pc(t,e,n){return t&&t.length&&e&&e.length?hr(t,e,Ao(n,2)):t},Bn.pullAllWith=function Nc(e,n,i){return e&&e.length&&n&&n.length?hr(e,n,t,i):e},Bn.pullAt=ba,Bn.range=Fl,Bn.rangeRight=Vl,Bn.rearg=as,Bn.reject=function Ic(t,e){return(hs(t)?ye:zi)(t,ns(Ao(e,3)))},Bn.remove=function Rc(t,e){var n=[];if(!t||!t.length)return n;var i=-1,r=[],o=t.length;for(e=Ao(e,3);++i<o;){var a=t[i];e(a,i,t)&&(n.push(a),r.push(i))}return dr(t,r),n},Bn.rest=function Oc(n,i){if("function"!=typeof n)throw new Ct(e);return mr(n,i=i===t?i:Vs(i))},Bn.reverse=xa,Bn.sampleSize=function zc(e,n,i){return n=(i?Ho(e,n,i):n===t)?1:Vs(n),(hs(e)?Kn:_r)(e,n)},Bn.set=function Dc(t,e,n){return null==t?t:yr(t,e,n)},Bn.setWith=function Bc(e,n,i,r){return r="function"==typeof r?r:t,null==e?e:yr(e,n,i,r)},Bn.shuffle=function Hc(t){return(hs(t)?Zn:xr)(t)},Bn.slice=function Fc(e,n,i){var r=null==e?0:e.length;return r?(i&&"number"!=typeof i&&Ho(e,n,i)?(n=0,i=r):(n=null==n?0:Vs(n),i=i===t?r:Vs(i)),wr(e,n,i)):[]},Bn.sortBy=qa,Bn.sortedUniq=function Vc(t){return t&&t.length?Tr(t):[]},Bn.sortedUniqBy=function Uc(t,e){return t&&t.length?Tr(t,Ao(e,2)):[]},Bn.split=function jc(e,n,i){return i&&"number"!=typeof i&&Ho(e,n,i)&&(n=i=t),(i=i===t?c:i>>>0)?(e=Ws(e))&&("string"==typeof n||null!=n&&!ks(n))&&!(n=Ar(n))&&Ze(e)?Fr(on(e),0,i):e.split(n,i):[]},Bn.spread=function Gc(t,n){if("function"!=typeof t)throw new Ct(e);return n=null==n?0:gn(Vs(n),0),mr((function(e){var i=e[n],r=Fr(e,0,n);return i&&Ee(r,i),pe(t,this,r)}))},Bn.tail=function Wc(t){var e=null==t?0:t.length;return e?wr(t,1,e):[]},Bn.take=function qc(e,n,i){return e&&e.length?wr(e,0,(n=i||n===t?1:Vs(n))<0?0:n):[]},Bn.takeRight=function Yc(e,n,i){var r=null==e?0:e.length;return r?wr(e,(n=r-(n=i||n===t?1:Vs(n)))<0?0:n,r):[]},Bn.takeRightWhile=function Xc(t,e){return t&&t.length?Nr(t,Ao(e,3),!1,!0):[]},Bn.takeWhile=function $c(t,e){return t&&t.length?Nr(t,Ao(e,3)):[]},Bn.tap=function Kc(t,e){return e(t),t},Bn.throttle=function Zc(t,n,i){var r=!0,o=!0;if("function"!=typeof t)throw new Ct(e);return Ss(i)&&(r="leading"in i?!!i.leading:r,o="trailing"in i?!!i.trailing:o),Ja(t,n,{leading:r,maxWait:n,trailing:o})},Bn.thru=Ra,Bn.toArray=Hs,Bn.toPairs=hl,Bn.toPairsIn=dl,Bn.toPath=function Jc(t){return hs(t)?Me(t,ra):Rs(t)?[t]:Xr(na(Ws(t)))},Bn.toPlainObject=Gs,Bn.transform=function Qc(t,e,n){var i=hs(t),r=i||gs(t)||Os(t);if(e=Ao(e,4),null==n){var o=t&&t.constructor;n=r?i?new o:[]:Ss(t)&&bs(o)?Hn(Qt(t)):{}}return(r?me:Fi)(t,(function(t,i,r){return e(n,t,i,r)})),n},Bn.unary=function tu(t){return Xa(t,1)},Bn.union=wa,Bn.unionBy=Sa,Bn.unionWith=Ma,Bn.uniq=function eu(t){return t&&t.length?kr(t):[]},Bn.uniqBy=function nu(t,e){return t&&t.length?kr(t,Ao(e,2)):[]},Bn.uniqWith=function iu(e,n){return n="function"==typeof n?n:t,e&&e.length?kr(e,t,n):[]},Bn.unset=function ru(t,e){return null==t||Lr(t,e)},Bn.unzip=Ea,Bn.unzipWith=Ta,Bn.update=function ou(t,e,n){return null==t?t:Pr(t,e,Dr(n))},Bn.updateWith=function au(e,n,i,r){return r="function"==typeof r?r:t,null==e?e:Pr(e,n,Dr(i),r)},Bn.values=pl,Bn.valuesIn=function su(t){return null==t?[]:je(t,ol(t))},Bn.without=Ca,Bn.words=Ml,Bn.wrap=function lu(t,e){return rs(Dr(e),t)},Bn.xor=Aa,Bn.xorBy=ka,Bn.xorWith=La,Bn.zip=Pa,Bn.zipObject=function cu(t,e){return Or(t||[],e||[],Qn)},Bn.zipObjectDeep=function uu(t,e){return Or(t||[],e||[],yr)},Bn.zipWith=Na,Bn.entries=hl,Bn.entriesIn=dl,Bn.extend=Ys,Bn.extendWith=Xs,Rl(Bn,Bn),Bn.add=Wl,Bn.attempt=El,Bn.camelCase=fl,Bn.capitalize=ml,Bn.ceil=ql,Bn.clamp=function hu(e,n,i){return i===t&&(i=n,n=t),i!==t&&(i=(i=js(i))==i?i:0),n!==t&&(n=(n=js(n))==n?n:0),oi(js(e),n,i)},Bn.clone=function du(t){return ai(t,4)},Bn.cloneDeep=function pu(t){return ai(t,5)},Bn.cloneDeepWith=function fu(e,n){return ai(e,5,n="function"==typeof n?n:t)},Bn.cloneWith=function mu(e,n){return ai(e,4,n="function"==typeof n?n:t)},Bn.conformsTo=function gu(t,e){return null==e||si(t,e,rl(e))},Bn.deburr=gl,Bn.defaultTo=function _u(t,e){return null==t||t!=t?e:t},Bn.divide=Yl,Bn.endsWith=function yu(e,n,i){e=Ws(e),n=Ar(n);var r=e.length,o=i=i===t?r:oi(Vs(i),0,r);return(i-=n.length)>=0&&e.slice(i,o)==n},Bn.eq=ss,Bn.escape=function vu(t){return(t=Ws(t))&&G.test(t)?t.replace(U,$e):t},Bn.escapeRegExp=function bu(t){return(t=Ws(t))&&J.test(t)?t.replace(Z,"\\$&"):t},Bn.every=function xu(e,n,i){var r=hs(e)?_e:Ri;return i&&Ho(e,n,i)&&(n=t),r(e,Ao(n,3))},Bn.find=Da,Bn.findIndex=ua,Bn.findKey=function wu(t,e){return Le(t,Ao(e,3),Fi)},Bn.findLast=Ba,Bn.findLastIndex=ha,Bn.findLastKey=function Su(t,e){return Le(t,Ao(e,3),Vi)},Bn.floor=Xl,Bn.forEach=Ha,Bn.forEachRight=Fa,Bn.forIn=function Mu(t,e){return null==t?t:Bi(t,Ao(e,3),ol)},Bn.forInRight=function Eu(t,e){return null==t?t:Hi(t,Ao(e,3),ol)},Bn.forOwn=function Tu(t,e){return t&&Fi(t,Ao(e,3))},Bn.forOwnRight=function Cu(t,e){return t&&Vi(t,Ao(e,3))},Bn.get=Qs,Bn.gt=ls,Bn.gte=cs,Bn.has=function Au(t,e){return null!=t&&Oo(t,e,Yi)},Bn.hasIn=tl,Bn.head=pa,Bn.identity=Ll,Bn.includes=function ku(t,e,n,i){t=fs(t)?t:pl(t),n=n&&!i?Vs(n):0;var r=t.length;return n<0&&(n=gn(r+n,0)),Is(t)?n<=r&&t.indexOf(e,n)>-1:!!r&&Ne(t,e,n)>-1},Bn.indexOf=function Lu(t,e,n){var i=null==t?0:t.length;if(!i)return-1;var r=null==n?0:Vs(n);return r<0&&(r=gn(i+r,0)),Ne(t,e,r)},Bn.inRange=function Pu(e,n,i){return n=Fs(n),i===t?(i=n,n=0):i=Fs(i),(function r(t,e,n){return t>=_n(e,n)&&t<gn(e,n)})(e=js(e),n,i)},Bn.invoke=il,Bn.isArguments=us,Bn.isArray=hs,Bn.isArrayBuffer=ds,Bn.isArrayLike=fs,Bn.isArrayLikeObject=ms,Bn.isBoolean=function Nu(t){return!0===t||!1===t||Ms(t)&&Wi(t)==p},Bn.isBuffer=gs,Bn.isDate=_s,Bn.isElement=function Iu(t){return Ms(t)&&1===t.nodeType&&!As(t)},Bn.isEmpty=function Ru(t){if(null==t)return!0;if(fs(t)&&(hs(t)||"string"==typeof t||"function"==typeof t.splice||gs(t)||Os(t)||us(t)))return!t.length;var e=Ro(t);if(e==y||e==S)return!t.size;if(jo(t))return!nr(t).length;for(var n in t)if(Nt.call(t,n))return!1;return!0},Bn.isEqual=function Ou(t,e){return Ji(t,e)},Bn.isEqualWith=function zu(e,n,i){var r=(i="function"==typeof i?i:t)?i(e,n):t;return r===t?Ji(e,n,t,i):!!r},Bn.isError=vs,Bn.isFinite=function Du(t){return"number"==typeof t&&pn(t)},Bn.isFunction=bs,Bn.isInteger=xs,Bn.isLength=ws,Bn.isMap=Es,Bn.isMatch=function Bu(t,e){return t===e||Qi(t,e,Lo(e))},Bn.isMatchWith=function Hu(e,n,i){return i="function"==typeof i?i:t,Qi(e,n,Lo(n),i)},Bn.isNaN=function Fu(t){return Cs(t)&&t!=+t},Bn.isNative=function Vu(t){if(Uo(t))throw new xt("Unsupported core-js use. Try https://npms.io/search?q=ponyfill.");return tr(t)},Bn.isNil=function Uu(t){return null==t},Bn.isNull=function ju(t){return null===t},Bn.isNumber=Cs,Bn.isObject=Ss,Bn.isObjectLike=Ms,Bn.isPlainObject=As,Bn.isRegExp=ks,Bn.isSafeInteger=function Gu(t){return xs(t)&&t>=-9007199254740991&&t<=s},Bn.isSet=Ps,Bn.isString=Is,Bn.isSymbol=Rs,Bn.isTypedArray=Os,Bn.isUndefined=function Wu(e){return e===t},Bn.isWeakMap=function qu(t){return Ms(t)&&Ro(t)==T},Bn.isWeakSet=function Yu(t){return Ms(t)&&"[object WeakSet]"==Wi(t)},Bn.join=function Xu(t,e){return null==t?"":fn.call(t,e)},Bn.kebabCase=_l,Bn.last=_a,Bn.lastIndexOf=function $u(e,n,i){var r=null==e?0:e.length;if(!r)return-1;var o=r;return i!==t&&(o=(o=Vs(i))<0?gn(r+o,0):_n(o,r-1)),n==n?(function a(t,e,n){for(var i=n+1;i--;)if(t[i]===e)return i;return i})(e,n,o):Pe(e,Re,o,!0)},Bn.lowerCase=yl,Bn.lowerFirst=vl,Bn.lt=Ds,Bn.lte=Bs,Bn.max=function Ku(e){return e&&e.length?Oi(e,Ll,qi):t},Bn.maxBy=function Zu(e,n){return e&&e.length?Oi(e,Ao(n,2),qi):t},Bn.mean=function Ju(t){return Oe(t,Ll)},Bn.meanBy=function Qu(t,e){return Oe(t,Ao(e,2))},Bn.min=function th(e){return e&&e.length?Oi(e,Ll,ir):t},Bn.minBy=function eh(e,n){return e&&e.length?Oi(e,Ao(n,2),ir):t},Bn.stubArray=Ul,Bn.stubFalse=jl,Bn.stubObject=function nh(){return{}},Bn.stubString=function ih(){return""},Bn.stubTrue=function rh(){return!0},Bn.multiply=$l,Bn.nth=function oh(e,n){return e&&e.length?lr(e,Vs(n)):t},Bn.noConflict=function ah(){return ee._===this&&(ee._=Dt),this},Bn.noop=Ol,Bn.now=Ya,Bn.pad=function sh(t,e,n){t=Ws(t);var i=(e=Vs(e))?rn(t):0;if(!e||i>=e)return t;var r=(e-i)/2;return co(un(r),n)+t+co(cn(r),n)},Bn.padEnd=function lh(t,e,n){t=Ws(t);var i=(e=Vs(e))?rn(t):0;return e&&i<e?t+co(e-i,n):t},Bn.padStart=function ch(t,e,n){t=Ws(t);var i=(e=Vs(e))?rn(t):0;return e&&i<e?co(e-i,n)+t:t},Bn.parseInt=function uh(t,e,n){return n||null==e?e=0:e&&(e=+e),vn(Ws(t).replace(Q,""),e||0)},Bn.random=function hh(e,n,i){if(i&&"boolean"!=typeof i&&Ho(e,n,i)&&(n=i=t),i===t&&("boolean"==typeof n?(i=n,n=t):"boolean"==typeof e&&(i=e,e=t)),e===t&&n===t?(e=0,n=1):(e=Fs(e),n===t?(n=e,e=0):n=Fs(n)),e>n){var r=e;e=n,n=r}if(i||e%1||n%1){var o=bn();return _n(e+o*(n-e+Zt("1e-"+((o+"").length-1))),n)}return pr(e,n)},Bn.reduce=function dh(t,e,n){var i=hs(t)?Te:Be,r=arguments.length<3;return i(t,Ao(e,4),n,r,Ni)},Bn.reduceRight=function ph(t,e,n){var i=hs(t)?Ce:Be,r=arguments.length<3;return i(t,Ao(e,4),n,r,Ii)},Bn.repeat=function fh(e,n,i){return n=(i?Ho(e,n,i):n===t)?1:Vs(n),fr(Ws(e),n)},Bn.replace=function mh(){var t=arguments,e=Ws(t[0]);return t.length<3?e:e.replace(t[1],t[2])},Bn.result=function gh(e,n,i){var r=-1,o=(n=Br(n,e)).length;for(o||(o=1,e=t);++r<o;){var a=null==e?t:e[ra(n[r])];a===t&&(r=o,a=i),e=bs(a)?a.call(e):a}return e},Bn.round=Kl,Bn.runInContext=tt,Bn.sample=function _h(t){return(hs(t)?$n:gr)(t)},Bn.size=function yh(t){if(null==t)return 0;if(fs(t))return Is(t)?rn(t):t.length;var e=Ro(t);return e==y||e==S?t.size:nr(t).length},Bn.snakeCase=bl,Bn.some=function vh(e,n,i){var r=hs(e)?Ae:Sr;return i&&Ho(e,n,i)&&(n=t),r(e,Ao(n,3))},Bn.sortedIndex=function bh(t,e){return Mr(t,e)},Bn.sortedIndexBy=function xh(t,e,n){return Er(t,e,Ao(n,2))},Bn.sortedIndexOf=function wh(t,e){var n=null==t?0:t.length;if(n){var i=Mr(t,e);if(i<n&&ss(t[i],e))return i}return-1},Bn.sortedLastIndex=function Sh(t,e){return Mr(t,e,!0)},Bn.sortedLastIndexBy=function Mh(t,e,n){return Er(t,e,Ao(n,2),!0)},Bn.sortedLastIndexOf=function Eh(t,e){if(null!=t&&t.length){var n=Mr(t,e,!0)-1;if(ss(t[n],e))return n}return-1},Bn.startCase=xl,Bn.startsWith=function Th(t,e,n){return t=Ws(t),n=null==n?0:oi(Vs(n),0,t.length),e=Ar(e),t.slice(n,n+e.length)==e},Bn.subtract=Zl,Bn.sum=function Ch(t){return t&&t.length?He(t,Ll):0},Bn.sumBy=function Ah(t,e){return t&&t.length?He(t,Ao(e,2)):0},Bn.template=function kh(e,n,i){var r=Bn.templateSettings;i&&Ho(e,n,i)&&(n=t),e=Ws(e),n=Xs({},n,r,yo);var o,a,s=Xs({},n.imports,r.imports,yo),l=rl(s),c=je(s,l),u=0,h=n.interpolate||mt,d="__p += '",p=Et((n.escape||mt).source+"|"+h.source+"|"+(h===Y?st:mt).source+"|"+(n.evaluate||mt).source+"|$","g"),f="//# sourceURL="+(Nt.call(n,"sourceURL")?(n.sourceURL+"").replace(/\s/g," "):"lodash.templateSources["+ ++Yt+"]")+"\n";e.replace(p,(function(t,n,i,r,s,l){return i||(i=r),d+=e.slice(u,l).replace(gt,Ke),n&&(o=!0,d+="' +\n__e("+n+") +\n'"),s&&(a=!0,d+="';\n"+s+";\n__p += '"),i&&(d+="' +\n((__t = ("+i+")) == null ? '' : __t) +\n'"),u=l+t.length,t})),d+="';\n";var m=Nt.call(n,"variable")&&n.variable;if(m){if(ot.test(m))throw new xt("Invalid `variable` option passed into `_.template`")}else d="with (obj) {\n"+d+"\n}\n";d=(a?d.replace(B,""):d).replace(H,"$1").replace(F,"$1;"),d="function("+(m||"obj")+") {\n"+(m?"":"obj || (obj = {});\n")+"var __t, __p = ''"+(o?", __e = _.escape":"")+(a?", __j = Array.prototype.join;\nfunction print() { __p += __j.call(arguments, '') }\n":";\n")+d+"return __p\n}";var g=El((function(){return wt(l,f+"return "+d).apply(t,c)}));if(g.source=d,vs(g))throw g;return g},Bn.times=function Lh(t,e){if((t=Vs(t))<1||t>s)return[];var n=c,i=_n(t,c);e=Ao(e),t-=c;for(var r=Fe(i,e);++n<t;)e(n);return r},Bn.toFinite=Fs,Bn.toInteger=Vs,Bn.toLength=Us,Bn.toLower=function Ph(t){return Ws(t).toLowerCase()},Bn.toNumber=js,Bn.toSafeInteger=function Nh(t){return t?oi(Vs(t),-9007199254740991,s):0===t?t:0},Bn.toString=Ws,Bn.toUpper=function Ih(t){return Ws(t).toUpperCase()},Bn.trim=function Rh(e,n,i){if((e=Ws(e))&&(i||n===t))return Ve(e);if(!e||!(n=Ar(n)))return e;var r=on(e),o=on(n);return Fr(r,We(r,o),qe(r,o)+1).join("")},Bn.trimEnd=function Oh(e,n,i){if((e=Ws(e))&&(i||n===t))return e.slice(0,an(e)+1);if(!e||!(n=Ar(n)))return e;var r=on(e);return Fr(r,0,qe(r,on(n))+1).join("")},Bn.trimStart=function zh(e,n,i){if((e=Ws(e))&&(i||n===t))return e.replace(Q,"");if(!e||!(n=Ar(n)))return e;var r=on(e);return Fr(r,We(r,on(n))).join("")},Bn.truncate=function Dh(e,n){var i=30,r="...";if(Ss(n)){var o="separator"in n?n.separator:o;i="length"in n?Vs(n.length):i,r="omission"in n?Ar(n.omission):r}var a=(e=Ws(e)).length;if(Ze(e)){var s=on(e);a=s.length}if(i>=a)return e;var l=i-rn(r);if(l<1)return r;var c=s?Fr(s,0,l).join(""):e.slice(0,l);if(o===t)return c+r;if(s&&(l+=c.length-l),ks(o)){if(e.slice(l).search(o)){var u,h=c;for(o.global||(o=Et(o.source,Ws(lt.exec(o))+"g")),o.lastIndex=0;u=o.exec(h);)var d=u.index;c=c.slice(0,d===t?l:d)}}else if(e.indexOf(Ar(o),l)!=l){var p=c.lastIndexOf(o);p>-1&&(c=c.slice(0,p))}return c+r},Bn.unescape=function Bh(t){return(t=Ws(t))&&j.test(t)?t.replace(V,sn):t},Bn.uniqueId=function Hh(t){var e=++It;return Ws(t)+e},Bn.upperCase=wl,Bn.upperFirst=Sl,Bn.each=Ha,Bn.eachRight=Fa,Bn.first=pa,Rl(Bn,(Gl={},Fi(Bn,(function(t,e){Nt.call(Bn.prototype,e)||(Gl[e]=t)})),Gl),{chain:!1}),Bn.VERSION="4.17.21",me(["bind","bindKey","curry","curryRight","partial","partialRight"],(function(t){Bn[t].placeholder=Bn})),me(["drop","take"],(function(e,n){Un.prototype[e]=function(i){i=i===t?1:gn(Vs(i),0);var r=this.__filtered__&&!n?new Un(this):this.clone();return r.__filtered__?r.__takeCount__=_n(i,r.__takeCount__):r.__views__.push({size:_n(i,c),type:e+(r.__dir__<0?"Right":"")}),r},Un.prototype[e+"Right"]=function(t){return this.reverse()[e](t).reverse()}})),me(["filter","map","takeWhile"],(function(t,e){var n=e+1,i=1==n||3==n;Un.prototype[t]=function(t){var e=this.clone();return e.__iteratees__.push({iteratee:Ao(t,3),type:n}),e.__filtered__=e.__filtered__||i,e}})),me(["head","last"],(function(t,e){var n="take"+(e?"Right":"");Un.prototype[t]=function(){return this[n](1).value()[0]}})),me(["initial","tail"],(function(t,e){var n="drop"+(e?"":"Right");Un.prototype[t]=function(){return this.__filtered__?new Un(this):this[n](1)}})),Un.prototype.compact=function(){return this.filter(Ll)},Un.prototype.find=function(t){return this.filter(t).head()},Un.prototype.findLast=function(t){return this.reverse().find(t)},Un.prototype.invokeMap=mr((function(t,e){return"function"==typeof t?new Un(this):this.map((function(n){return Ki(n,t,e)}))})),Un.prototype.reject=function(t){return this.filter(ns(Ao(t)))},Un.prototype.slice=function(e,n){e=Vs(e);var i=this;return i.__filtered__&&(e>0||n<0)?new Un(i):(e<0?i=i.takeRight(-e):e&&(i=i.drop(e)),n!==t&&(i=(n=Vs(n))<0?i.dropRight(-n):i.take(n-e)),i)},Un.prototype.takeRightWhile=function(t){return this.reverse().takeWhile(t).reverse()},Un.prototype.toArray=function(){return this.take(c)},Fi(Un.prototype,(function(e,n){var i=/^(?:filter|find|map|reject)|While$/.test(n),r=/^(?:head|last)$/.test(n),o=Bn[r?"take"+("last"==n?"Right":""):n],a=r||/^find/.test(n);o&&(Bn.prototype[n]=function(){var n=this.__wrapped__,s=r?[1]:arguments,l=n instanceof Un,c=s[0],u=l||hs(n),h=function(t){var e=o.apply(Bn,Ee([t],s));return r&&d?e[0]:e};u&&i&&"function"==typeof c&&1!=c.length&&(l=u=!1);var d=this.__chain__,p=!!this.__actions__.length,f=a&&!d,m=l&&!p;if(!a&&u){n=m?n:new Un(this);var g=e.apply(n,s);return g.__actions__.push({func:Ra,args:[h],thisArg:t}),new Vn(g,d)}return f&&m?e.apply(this,s):(g=this.thru(h),f?r?g.value()[0]:g.value():g)})})),me(["pop","push","shift","sort","splice","unshift"],(function(t){var e=At[t],n=/^(?:push|sort|unshift)$/.test(t)?"tap":"thru",i=/^(?:pop|shift)$/.test(t);Bn.prototype[t]=function(){var t=arguments;if(i&&!this.__chain__){var r=this.value();return e.apply(hs(r)?r:[],t)}return this[n]((function(n){return e.apply(hs(n)?n:[],t)}))}})),Fi(Un.prototype,(function(t,e){var n=Bn[e];if(n){var i=n.name+"";Nt.call(kn,i)||(kn[i]=[]),kn[i].push({name:e,func:n})}})),kn[oo(t,2).name]=[{name:"wrapper",func:t}],Un.prototype.clone=function Fh(){var t=new Un(this.__wrapped__);return t.__actions__=Xr(this.__actions__),t.__dir__=this.__dir__,t.__filtered__=this.__filtered__,t.__iteratees__=Xr(this.__iteratees__),t.__takeCount__=this.__takeCount__,t.__views__=Xr(this.__views__),t},Un.prototype.reverse=function Vh(){if(this.__filtered__){var t=new Un(this);t.__dir__=-1,t.__filtered__=!0}else(t=this.clone()).__dir__*=-1;return t},Un.prototype.value=function Uh(){var t=this.__wrapped__.value(),e=this.__dir__,n=hs(t),i=e<0,r=n?t.length:0,o=(function a(t,e,n){for(var i=-1,r=n.length;++i<r;){var o=n[i],a=o.size;switch(o.type){case"drop":t+=a;break;case"dropRight":e-=a;break;case"take":e=_n(e,t+a);break;case"takeRight":t=gn(t,e-a)}}return{start:t,end:e}})(0,r,this.__views__),s=o.start,l=o.end,c=l-s,u=i?l:s-1,h=this.__iteratees__,d=h.length,p=0,f=_n(c,this.__takeCount__);if(!n||!i&&r==c&&f==c)return Ir(t,this.__actions__);var m=[];t:for(;c--&&p<f;){for(var g=-1,_=t[u+=e];++g<d;){var y=h[g],v=y.type,b=(0,y.iteratee)(_);if(2==v)_=b;else if(!b){if(1==v)continue t;break t}}m[p++]=_}return m},Bn.prototype.at=Oa,Bn.prototype.chain=function jh(){return Ia(this)},Bn.prototype.commit=function Gh(){return new Vn(this.value(),this.__chain__)},Bn.prototype.next=function Wh(){this.__values__===t&&(this.__values__=Hs(this.value()));var e=this.__index__>=this.__values__.length;return{done:e,value:e?t:this.__values__[this.__index__++]}},Bn.prototype.plant=function qh(e){for(var n,i=this;i instanceof Fn;){var r=aa(i);r.__index__=0,r.__values__=t,n?o.__wrapped__=r:n=r;var o=r;i=i.__wrapped__}return o.__wrapped__=e,n},Bn.prototype.reverse=function Yh(){var e=this.__wrapped__;if(e instanceof Un){var n=e;return this.__actions__.length&&(n=new Un(this)),(n=n.reverse()).__actions__.push({func:Ra,args:[xa],thisArg:t}),new Vn(n,this.__chain__)}return this.thru(xa)},Bn.prototype.toJSON=Bn.prototype.valueOf=Bn.prototype.value=function Xh(){return Ir(this.__wrapped__,this.__actions__)},Bn.prototype.first=Bn.prototype.head,ae&&(Bn.prototype[ae]=function $h(){return this}),Bn})();ie?((ie.exports=ln)._=ln,ne._=ln):ee._=ln}.call(ve);
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
const Me=!(window.ShadyDOM&&window.ShadyDOM.inUse);let Ee,Te;function Ce(t){Ee=(!t||!t.shimcssproperties)&&(Me||Boolean(!navigator.userAgent.match(/AppleWebKit\/601|Edge\/15/)&&window.CSS&&CSS.supports&&CSS.supports("box-shadow","0 0 0 var(--foo)")))}window.ShadyCSS&&void 0!==window.ShadyCSS.cssBuild&&(Te=window.ShadyCSS.cssBuild);const Ae=Boolean(window.ShadyCSS&&window.ShadyCSS.disableRuntime);window.ShadyCSS&&void 0!==window.ShadyCSS.nativeCss?Ee=window.ShadyCSS.nativeCss:window.ShadyCSS?(Ce(window.ShadyCSS),window.ShadyCSS=void 0):Ce(window.WebComponents&&window.WebComponents.flags);const ke=Ee;
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */class Le{constructor(){this.start=0,this.end=0,this.previous=null,this.parent=null,this.rules=null,this.parsedCssText="",this.cssText="",this.atRule=!1,this.type=0,this.keyframesName="",this.selector="",this.parsedSelector=""}}function Pe(t){return Ne((function n(t){let e=new Le;e.start=0,e.end=t.length;let n=e;for(let i=0,r=t.length;i<r;i++)if(t[i]===Oe){n.rules||(n.rules=[]);let t=n,e=t.rules[t.rules.length-1]||null;n=new Le,n.start=i+1,n.parent=t,n.previous=e,t.rules.push(n)}else t[i]===ze&&(n.end=i+1,n=n.parent||e);return e})(t=(function e(t){return t.replace(De.comments,"").replace(De.port,"")})(t)),t)}function Ne(t,e){let n=e.substring(t.start,t.end-1);if(t.parsedCssText=t.cssText=n.trim(),t.parent){n=e.substring(t.previous?t.previous.end:t.parent.start,t.start-1),n=(function i(t){return t.replace(/\\([0-9a-f]{1,6})\s/gi,(function(){let t=arguments[1],e=6-t.length;for(;e--;)t="0"+t;return"\\"+t}))})(n),n=n.replace(De.multipleSpaces," "),n=n.substring(n.lastIndexOf(";")+1);let i=t.parsedSelector=t.selector=n.trim();t.atRule=0===i.indexOf(Fe),t.atRule?0===i.indexOf(He)?t.type=Re.MEDIA_RULE:i.match(De.keyframesRule)&&(t.type=Re.KEYFRAMES_RULE,t.keyframesName=t.selector.split(De.multipleSpaces).pop()):t.type=0===i.indexOf(Be)?Re.MIXIN_RULE:Re.STYLE_RULE}let r=t.rules;if(r)for(let t,n=0,i=r.length;n<i&&(t=r[n]);n++)Ne(t,e);return t}function Ie(t,e,n=""){let i="";if(t.cssText||t.rules){let n=t.rules;if(n&&!(function r(t){let e=t[0];return Boolean(e)&&Boolean(e.selector)&&0===e.selector.indexOf(Be)})(n))for(let t,r=0,o=n.length;r<o&&(t=n[r]);r++)i=Ie(t,e,i);else i=e?t.cssText:(function o(t){return(function n(t){return t.replace(De.mixinApply,"").replace(De.varApply,"")})(t=(function e(t){return t.replace(De.customProp,"").replace(De.mixinProp,"")})(t))})(t.cssText),i=i.trim(),i&&(i="  "+i+"\n")}return i&&(t.selector&&(n+=t.selector+" "+Oe+"\n"),n+=i,t.selector&&(n+=ze+"\n\n")),n}const Re={STYLE_RULE:1,KEYFRAMES_RULE:7,MEDIA_RULE:4,MIXIN_RULE:1e3},Oe="{",ze="}",De={comments:/\/\*[^*]*\*+([^/*][^*]*\*+)*\//gim,port:/@import[^;]*;/gim,customProp:/(?:^[^;\-\s}]+)?--[^;{}]*?:[^{};]*?(?:[;\n]|$)/gim,mixinProp:/(?:^[^;\-\s}]+)?--[^;{}]*?:[^{};]*?{[^}]*?}(?:[;\n]|$)?/gim,mixinApply:/@apply\s*\(?[^);]*\)?\s*(?:[;\n]|$)?/gim,varApply:/[^;:]*?:[^;]*?var\([^;]*\)(?:[;\n]|$)?/gim,keyframesRule:/^@[^\s]*keyframes/,multipleSpaces:/\s+/g},Be="--",He="@media",Fe="@",Ve=/(?:^|[;\s{]\s*)(--[\w-]*?)\s*:\s*(?:((?:'(?:\\'|.)*?'|"(?:\\"|.)*?"|\([^)]*?\)|[^};{])+)|\{([^}]*)\}(?:(?=[;\s}])|$))/gi,Ue=/(?:^|\W+)@apply\s*\(?([^);\n]*)\)?/gi,je=/@media\s(.*)/,Ge=new Set;function We(t){const e=t.textContent;if(!Ge.has(e)){Ge.add(e);const t=document.createElement("style");t.setAttribute("shady-unscoped",""),t.textContent=e,document.head.appendChild(t)}}function qe(t){return t.hasAttribute("shady-unscoped")}
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */function Ye(t,e){return t?("string"==typeof t&&(t=Pe(t)),e&&$e(t,e),Ie(t,ke)):""}function Xe(t){return!t.__cssRules&&t.textContent&&(t.__cssRules=Pe(t.textContent)),t.__cssRules||null}function $e(t,e,n,i){if(!t)return;let r=!1,o=t.type;if(i&&o===Re.MEDIA_RULE){let e=t.selector.match(je);e&&(window.matchMedia(e[1]).matches||(r=!0))}o===Re.STYLE_RULE?e(t):n&&o===Re.KEYFRAMES_RULE?n(t):o===Re.MIXIN_RULE&&(r=!0);let a=t.rules;if(a&&!r)for(let t,r=0,o=a.length;r<o&&(t=a[r]);r++)$e(t,e,n,i)}function Ke(t,e){let n=t.indexOf("var(");if(-1===n)return e(t,"","","");let i=(function r(t,e){let n=0;for(let i=e,r=t.length;i<r;i++)if("("===t[i])n++;else if(")"===t[i]&&0==--n)return i;return-1})(t,n+3),o=t.substring(n+4,i),a=t.substring(0,n),s=Ke(t.substring(i+1),e),l=o.indexOf(",");return-1===l?e(a,o.trim(),"",s):e(a,o.substring(0,l).trim(),o.substring(l+1).trim(),s)}window.ShadyDOM&&window;const Ze="css-build";function Je(t){return""!==(function e(t){if(void 0!==Te)return Te;if(void 0===t.__cssBuild){const e=t.getAttribute(Ze);if(e)t.__cssBuild=e;else{const e=(function e(t){const e="template"===t.localName?t.content.firstChild:t.firstChild;if(e instanceof Comment){const t=e.textContent.trim().split(":");if(t[0]===Ze)return t[1]}return""})(t);""!==e&&(function n(t){const e="template"===t.localName?t.content.firstChild:t.firstChild;e.parentNode.removeChild(e)}
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */)(t),t.__cssBuild=e}}return t.__cssBuild||""})(t)}function Qe(t,e){for(let n in e)null===n?t.style.removeProperty(n):t.style.setProperty(n,e[n])}function tn(t,e){const n=window.getComputedStyle(t).getPropertyValue(e);return n?n.trim():""}
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
const en=/;\s*/m,nn=/^\s*(initial)|(inherit)\s*$/,rn=/\s*!important/;class on{constructor(){this._map={}}set(t,e){t=t.trim(),this._map[t]={properties:e,dependants:{}}}get(t){return t=t.trim(),this._map[t]||null}}let an=null;class sn{constructor(){this._currentElement=null,this._measureElement=null,this._map=new on}detectMixin(t){return(function e(t){const e=Ue.test(t)||Ve.test(t);return Ue.lastIndex=0,Ve.lastIndex=0,e})(t)}gatherStyles(t){const e=(function n(t){const e=[],n=t.querySelectorAll("style");for(let t=0;t<n.length;t++){const i=n[t];qe(i)?Me||(We(i),i.parentNode.removeChild(i)):(e.push(i.textContent),i.parentNode.removeChild(i))}return e.join("").trim()})(t.content);if(e){const n=document.createElement("style");return n.textContent=e,t.content.insertBefore(n,t.content.firstChild),n}return null}transformTemplate(t,e){void 0===t._gatheredStyle&&(t._gatheredStyle=this.gatherStyles(t));const n=t._gatheredStyle;return n?this.transformStyle(n,e):null}transformStyle(t,e=""){let n=Xe(t);return this.transformRules(n,e),t.textContent=Ye(n),n}transformCustomStyle(t){let e=Xe(t);return $e(e,(t=>{":root"===t.selector&&(t.selector="html"),this.transformRule(t)})),t.textContent=Ye(e),e}transformRules(t,e){this._currentElement=e,$e(t,(t=>{this.transformRule(t)})),this._currentElement=null}transformRule(t){t.cssText=this.transformCssText(t.parsedCssText,t),":root"===t.selector&&(t.selector=":host > *")}transformCssText(t,e){return t=t.replace(Ve,((t,n,i,r)=>this._produceCssProperties(t,n,i,r,e))),this._consumeCssProperties(t,e)}_getInitialValueForProperty(t){return this._measureElement||(this._measureElement=document.createElement("meta"),this._measureElement.setAttribute("apply-shim-measure",""),this._measureElement.style.all="initial",document.head.appendChild(this._measureElement)),window.getComputedStyle(this._measureElement).getPropertyValue(t)}_fallbacksFromPreviousRules(t){let e=t;for(;e.parent;)e=e.parent;const n={};let i=!1;return $e(e,(e=>{i=i||e===t,i||e.selector===t.selector&&Object.assign(n,this._cssTextToMap(e.parsedCssText))})),n}_consumeCssProperties(t,e){let n=null;for(;n=Ue.exec(t);){let i=n[0],r=n[1],o=n.index,a=o+i.indexOf("@apply"),s=o+i.length,l=t.slice(0,a),c=t.slice(s),u=e?this._fallbacksFromPreviousRules(e):{};Object.assign(u,this._cssTextToMap(l));let h=this._atApplyToCssProperties(r,u);t=`${l}${h}${c}`,Ue.lastIndex=o+h.length}return t}_atApplyToCssProperties(t,e){t=t.replace(en,"");let n=[],i=this._map.get(t);if(i||(this._map.set(t,{}),i=this._map.get(t)),i){let r,o,a;this._currentElement&&(i.dependants[this._currentElement]=!0);const s=i.properties;for(r in s)a=e&&e[r],o=[r,": var(",t,"_-_",r],a&&o.push(",",a.replace(rn,"")),o.push(")"),rn.test(s[r])&&o.push(" !important"),n.push(o.join(""))}return n.join("; ")}_replaceInitialOrInherit(t,e){let n=nn.exec(e);return n&&(e=n[1]?this._getInitialValueForProperty(t):"apply-shim-inherit"),e}_cssTextToMap(t,e=!1){let n,i,r=t.split(";"),o={};for(let t,a,s=0;s<r.length;s++)t=r[s],t&&(a=t.split(":"),a.length>1&&(n=a[0].trim(),i=a.slice(1).join(":"),e&&(i=this._replaceInitialOrInherit(n,i)),o[n]=i));return o}_invalidateMixinEntry(t){if(an)for(let e in t.dependants)e!==this._currentElement&&an(e)}_produceCssProperties(t,e,n,i,r){if(n&&Ke(n,((t,e)=>{e&&this._map.get(e)&&(i=`@apply ${e};`)})),!i)return t;let o=this._consumeCssProperties(""+i,r),a=t.slice(0,t.indexOf("--")),s=this._cssTextToMap(o,!0),l=s,c=this._map.get(e),u=c&&c.properties;u?l=Object.assign(Object.create(u),s):this._map.set(e,l);let h,d,p=[],f=!1;for(h in l)d=s[h],void 0===d&&(d="initial"),u&&!(h in u)&&(f=!0),p.push(`${e}_-_${h}: ${d}`);return f&&this._invalidateMixinEntry(c),c&&(c.properties=l),n&&(a=`${t};${a}`),`${a}${p.join("; ")};`}}sn.prototype.detectMixin=sn.prototype.detectMixin,sn.prototype.transformStyle=sn.prototype.transformStyle,sn.prototype.transformCustomStyle=sn.prototype.transformCustomStyle,sn.prototype.transformRules=sn.prototype.transformRules,sn.prototype.transformRule=sn.prototype.transformRule,sn.prototype.transformTemplate=sn.prototype.transformTemplate,sn.prototype._separator="_-_",Object.defineProperty(sn.prototype,"invalidCallback",{get:()=>an,set(t){an=t}});
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
const ln={},cn="_applyShimCurrentVersion",un="_applyShimNextVersion",hn="_applyShimValidatingVersion",dn=Promise.resolve();
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */function pn(t){let e=ln[t];e&&(function n(t){t[cn]=t[cn]||0,t[hn]=t[hn]||0,t[un]=(t[un]||0)+1})(e)}function fn(t){return t[cn]===t[un]}
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
let mn,gn=null,_n=window.HTMLImports&&window.HTMLImports.whenReady||null;function yn(t){requestAnimationFrame((function(){_n?_n(t):(gn||(gn=new Promise((t=>{mn=t})),"complete"===document.readyState?mn():document.addEventListener("readystatechange",(()=>{"complete"===document.readyState&&mn()}))),gn.then((function(){t&&t()})))}))}
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */const vn="__seenByShadyCSS",bn="__shadyCSSCachedStyle";let xn=null,wn=null;class Sn{constructor(){this.customStyles=[],this.enqueued=!1,yn((()=>{window.ShadyCSS.flushCustomStyles&&window.ShadyCSS.flushCustomStyles()}))}enqueueDocumentValidation(){!this.enqueued&&wn&&(this.enqueued=!0,yn(wn))}addCustomStyle(t){t[vn]||(t[vn]=!0,this.customStyles.push(t),this.enqueueDocumentValidation())}getStyleForCustomStyle(t){if(t[bn])return t[bn];let e;return e=t.getStyle?t.getStyle():t,e}processStyles(){const t=this.customStyles;for(let e=0;e<t.length;e++){const n=t[e];if(n[bn])continue;const i=this.getStyleForCustomStyle(n);if(i){const t=i.__appliedElement||i;xn&&xn(t),n[bn]=t}}return t}}Sn.prototype.addCustomStyle=Sn.prototype.addCustomStyle,Sn.prototype.getStyleForCustomStyle=Sn.prototype.getStyleForCustomStyle,Sn.prototype.processStyles=Sn.prototype.processStyles,Object.defineProperties(Sn.prototype,{transformCallback:{get:()=>xn,set(t){xn=t}},validateCallback:{get:()=>wn,set(t){let e=!1;wn||(e=!0),wn=t,e&&this.enqueueDocumentValidation()}}});
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
const Mn=new sn;class En{constructor(){this.customStyleInterface=null,Mn.invalidCallback=pn}ensure(){this.customStyleInterface||window.ShadyCSS.CustomStyleInterface&&(this.customStyleInterface=window.ShadyCSS.CustomStyleInterface,this.customStyleInterface.transformCallback=t=>{Mn.transformCustomStyle(t)},this.customStyleInterface.validateCallback=()=>{requestAnimationFrame((()=>{this.customStyleInterface.enqueued&&this.flushCustomStyles()}))})}prepareTemplate(t,e){if(this.ensure(),Je(t))return;ln[e]=t;let n=Mn.transformTemplate(t,e);t._styleAst=n}flushCustomStyles(){if(this.ensure(),!this.customStyleInterface)return;let t=this.customStyleInterface.processStyles();if(this.customStyleInterface.enqueued){for(let e=0;e<t.length;e++){let n=this.customStyleInterface.getStyleForCustomStyle(t[e]);n&&Mn.transformCustomStyle(n)}this.customStyleInterface.enqueued=!1}}styleSubtree(t,e){if(this.ensure(),e&&Qe(t,e),t.shadowRoot){this.styleElement(t);let e=t.shadowRoot.children||t.shadowRoot.childNodes;for(let t=0;t<e.length;t++)this.styleSubtree(e[t])}else{let e=t.children||t.childNodes;for(let t=0;t<e.length;t++)this.styleSubtree(e[t])}}styleElement(t){this.ensure();let{is:e}=(function n(t){let e=t.localName,n="",i="";return e?e.indexOf("-")>-1?n=e:(i=e,n=t.getAttribute&&t.getAttribute("is")||""):(n=t.is,i=t.extends),{is:n,typeExtension:i}})(t),i=ln[e];if((!i||!Je(i))&&i&&!fn(i)){(function n(t){return!fn(t)&&t[hn]===t[un]})(i)||(this.prepareTemplate(i,e),(function r(t){t[hn]=t[un],t._validating||(t._validating=!0,dn.then((function(){t[cn]=t[un],t._validating=!1})))})(i));let o=t.shadowRoot;if(o){let t=o.querySelector("style");t&&(t.__cssRules=i._styleAst,t.textContent=Ye(i._styleAst))}}}styleDocument(t){this.ensure(),this.styleSubtree(document.body,t)}}if(!window.ShadyCSS||!window.ShadyCSS.ScopingShim){const t=new En;let e=window.ShadyCSS&&window.ShadyCSS.CustomStyleInterface;window.ShadyCSS={prepareTemplate(e,n,i){t.flushCustomStyles(),t.prepareTemplate(e,n)},prepareTemplateStyles(t,e,n){window.ShadyCSS.prepareTemplate(t,e,n)},prepareTemplateDom(t,e){},styleSubtree(e,n){t.flushCustomStyles(),t.styleSubtree(e,n)},styleElement(e){t.flushCustomStyles(),t.styleElement(e)},styleDocument(e){t.flushCustomStyles(),t.styleDocument(e)},getComputedStyleValue:(t,e)=>tn(t,e),flushCustomStyles(){t.flushCustomStyles()},nativeCss:ke,nativeShadow:Me,cssBuild:Te,disableRuntime:Ae},e&&(window.ShadyCSS.CustomStyleInterface=e)}window.ShadyCSS.ApplyShim=Mn;
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
class Tn{constructor(){this._asyncModule=null,this._callback=null,this._timer=null}setConfig(t,e){this._asyncModule=t,this._callback=e,this._timer=this._asyncModule.run((()=>{this._timer=null,Cn.delete(this),this._callback()}))}cancel(){this.isActive()&&(this._cancelAsync(),Cn.delete(this))}_cancelAsync(){this.isActive()&&(this._asyncModule.cancel(this._timer),this._timer=null)}flush(){this.isActive()&&(this.cancel(),this._callback())}isActive(){return null!=this._timer}static debounce(t,e,n){return t instanceof Tn?t._cancelAsync():t=new Tn,t.setConfig(e,n),t}}let Cn=new Set;const An=function(t){Cn.add(t)},kn=function(){const t=Boolean(Cn.size);return Cn.forEach((t=>{try{t.flush()}catch(t){setTimeout((()=>{throw t}))}})),t};
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
let Ln="string"==typeof document.head.style.touchAction,Pn="__polymerGestures",Nn="__polymerGesturesHandled",In="__polymerGesturesTouchAction",Rn=["mousedown","mousemove","mouseup","click"],On=[0,1,4,2],zn=(function(){try{return 1===new MouseEvent("test",{buttons:1}).buttons}catch(t){return!1}})();function Dn(t){return Rn.indexOf(t)>-1}let Bn=!1;function Hn(t){if(!Dn(t)&&"touchend"!==t)return Ln&&Bn&&v?{passive:!0}:void 0}!(function(){try{let t=Object.defineProperty({},"passive",{get(){Bn=!0}});window.addEventListener("test",null,t),window.removeEventListener("test",null,t)}catch(t){}})();let Fn=navigator.userAgent.match(/iP(?:[oa]d|hone)|Android/);const Vn=[],Un={button:!0,input:!0,keygen:!0,meter:!0,output:!0,textarea:!0,progress:!0,select:!0},jn={button:!0,command:!0,fieldset:!0,input:!0,keygen:!0,optgroup:!0,option:!0,select:!0,textarea:!0};function Gn(t){let e=Array.prototype.slice.call(t.labels||[]);if(!e.length){e=[];let n=t.getRootNode();if(t.id){let i=n.querySelectorAll(`label[for = ${t.id}]`);for(let t=0;t<i.length;t++)e.push(i[t])}}return e}let Wn=function(t){let e=t.sourceCapabilities;if((!e||e.firesTouchEvents)&&(t[Nn]={skip:!0},"click"===t.type)){let e=!1,n=Jn(t);for(let t=0;t<n.length;t++){if(n[t].nodeType===Node.ELEMENT_NODE)if("label"===n[t].localName)Vn.push(n[t]);else if(Un[n[t].localName]){let i=Gn(n[t]);for(let t=0;t<i.length;t++)e=e||Vn.indexOf(i[t])>-1}if(n[t]===Xn.mouse.target)return}if(e)return;t.preventDefault(),t.stopPropagation()}};function qn(t){let e=Fn?["click"]:Rn;for(let n,i=0;i<e.length;i++)n=e[i],t?(Vn.length=0,document.addEventListener(n,Wn,!0)):document.removeEventListener(n,Wn,!0)}function Yn(t){let e=t.type;if(!Dn(e))return!1;if("mousemove"===e){let e=void 0===t.buttons?1:t.buttons;return t instanceof window.MouseEvent&&!zn&&(e=On[t.which]||0),Boolean(1&e)}return 0===(void 0===t.button?0:t.button)}let Xn={mouse:{target:null,mouseIgnoreJob:null},touch:{x:0,y:0,id:-1,scrollDecided:!1}};function $n(t,e,n){t.movefn=e,t.upfn=n,document.addEventListener("mousemove",e),document.addEventListener("mouseup",n)}function Kn(t){document.removeEventListener("mousemove",t.movefn),document.removeEventListener("mouseup",t.upfn),t.movefn=null,t.upfn=null}document.addEventListener("touchend",(function Zn(t){Xn.mouse.mouseIgnoreJob||qn(!0),Xn.mouse.target=Jn(t)[0],Xn.mouse.mouseIgnoreJob=Tn.debounce(Xn.mouse.mouseIgnoreJob,gt.after(2500),(function(){qn(),Xn.mouse.target=null,Xn.mouse.mouseIgnoreJob=null}))}),!!Bn&&{passive:!0});const Jn=window.ShadyDOM&&window.ShadyDOM.noPatch?window.ShadyDOM.composedPath:t=>t.composedPath&&t.composedPath()||[],Qn={},ti=[];function ei(t){const e=Jn(t);return e.length>0?e[0]:t.target}function ni(t){let e,n=t.type,i=t.currentTarget[Pn];if(!i)return;let r=i[n];if(r){if(!t[Nn]&&(t[Nn]={},"touch"===n.slice(0,5))){let e=(t=t).changedTouches[0];if("touchstart"===n&&1===t.touches.length&&(Xn.touch.id=e.identifier),Xn.touch.id!==e.identifier)return;Ln||"touchstart"!==n&&"touchmove"!==n||(function o(t){let e=t.changedTouches[0],n=t.type;if("touchstart"===n)Xn.touch.x=e.clientX,Xn.touch.y=e.clientY,Xn.touch.scrollDecided=!1;else if("touchmove"===n){if(Xn.touch.scrollDecided)return;Xn.touch.scrollDecided=!0;let n=(function i(t){let e="auto",n=Jn(t);for(let t,i=0;i<n.length;i++)if(t=n[i],t[In]){e=t[In];break}return e})(t),i=!1,r=Math.abs(Xn.touch.x-e.clientX),o=Math.abs(Xn.touch.y-e.clientY);t.cancelable&&("none"===n?i=!0:"pan-x"===n?i=o>r:"pan-y"===n&&(i=r>o)),i?t.preventDefault():si("track")}})(t)}if(e=t[Nn],!e.skip){for(let n,i=0;i<ti.length;i++)n=ti[i],r[n.name]&&!e[n.name]&&n.flow&&n.flow.start.indexOf(t.type)>-1&&n.reset&&n.reset();for(let i,o=0;o<ti.length;o++)i=ti[o],r[i.name]&&!e[i.name]&&(e[i.name]=!0,i[n](t))}}}function ii(t,e,n){return!!Qn[e]&&((function i(t,e,n){let i=Qn[e],r=i.deps,o=i.name,a=t[Pn];a||(t[Pn]=a={});for(let e,n,i=0;i<r.length;i++)e=r[i],Fn&&Dn(e)&&"click"!==e||(n=a[e],n||(a[e]=n={_count:0}),0===n._count&&t.addEventListener(e,ni,Hn(e)),n[o]=(n[o]||0)+1,n._count=(n._count||0)+1);t.addEventListener(e,n),i.touchAction&&oi(t,i.touchAction)})(t,e,n),!0)}function ri(t){ti.push(t);for(let e=0;e<t.emits.length;e++)Qn[t.emits[e]]=t}function oi(t,e){Ln&&t instanceof HTMLElement&&vt.run((()=>{t.style.touchAction=e})),t[In]=e}function ai(t,e,n){let i=new Event(e,{bubbles:!0,cancelable:!0,composed:!0});if(i.detail=n,Y(t).dispatchEvent(i),i.defaultPrevented){let t=n.preventer||n.sourceEvent;t&&t.preventDefault&&t.preventDefault()}}function si(t){let e=(function n(t){for(let e,n=0;n<ti.length;n++){e=ti[n];for(let n,i=0;i<e.emits.length;i++)if(n=e.emits[i],n===t)return e}return null})(t);e.info&&(e.info.prevent=!0)}function li(t,e,n,i){e&&ai(e,t,{x:n.clientX,y:n.clientY,sourceEvent:n,preventer:i,prevent:function(t){return si(t)}})}function ci(t,e,n){if(t.prevent)return!1;if(t.started)return!0;let i=Math.abs(t.x-e),r=Math.abs(t.y-n);return i>=5||r>=5}function ui(t,e,n){if(!e)return;let i,r=t.moves[t.moves.length-2],o=t.moves[t.moves.length-1],a=0;r&&(i=o.x-r.x,a=o.y-r.y),ai(e,"track",{state:t.state,x:n.clientX,y:n.clientY,dx:o.x-t.x,dy:o.y-t.y,ddx:i,ddy:a,sourceEvent:n,hover:function(){return(function t(e,n){let i=document.elementFromPoint(e,n),r=i;for(;r&&r.shadowRoot&&!window.ShadyDOM;){let t=r;if(r=r.shadowRoot.elementFromPoint(e,n),t===r)break;r&&(i=r)}return i})(n.clientX,n.clientY)}})}function hi(t,e,n){let i=Math.abs(e.clientX-t.x),r=Math.abs(e.clientY-t.y),o=ei(n||e);!o||jn[o.localName]&&o.hasAttribute("disabled")||(isNaN(i)||isNaN(r)||i<=25&&r<=25||(function a(t){if("click"===t.type){if(0===t.detail)return!0;let e=ei(t);if(!e.nodeType||e.nodeType!==Node.ELEMENT_NODE)return!0;let n=e.getBoundingClientRect(),i=t.pageX,r=t.pageY;return!(i>=n.left&&i<=n.right&&r>=n.top&&r<=n.bottom)}return!1})(e))&&(t.prevent||ai(o,"tap",{x:e.clientX,y:e.clientY,sourceEvent:e,preventer:n}))}ri({name:"downup",deps:["mousedown","touchstart","touchend"],flow:{start:["mousedown","touchstart"],end:["mouseup","touchend"]},emits:["down","up"],info:{movefn:null,upfn:null},reset:function(){Kn(this.info)},mousedown:function(t){if(!Yn(t))return;let e=ei(t),n=this;$n(this.info,(function t(i){Yn(i)||(li("up",e,i),Kn(n.info))}),(function t(i){Yn(i)&&li("up",e,i),Kn(n.info)})),li("down",e,t)},touchstart:function(t){li("down",ei(t),t.changedTouches[0],t)},touchend:function(t){li("up",ei(t),t.changedTouches[0],t)}}),ri({name:"track",touchAction:"none",deps:["mousedown","touchstart","touchmove","touchend"],flow:{start:["mousedown","touchstart"],end:["mouseup","touchend"]},emits:["track"],info:{x:0,y:0,state:"start",started:!1,moves:[],addMove:function(t){this.moves.length>2&&this.moves.shift(),this.moves.push(t)},movefn:null,upfn:null,prevent:!1},reset:function(){this.info.state="start",this.info.started=!1,this.info.moves=[],this.info.x=0,this.info.y=0,this.info.prevent=!1,Kn(this.info)},mousedown:function(t){if(!Yn(t))return;let e=ei(t),n=this,i=function t(i){let r=i.clientX,o=i.clientY;ci(n.info,r,o)&&(n.info.state=n.info.started?"mouseup"===i.type?"end":"track":"start","start"===n.info.state&&si("tap"),n.info.addMove({x:r,y:o}),Yn(i)||(n.info.state="end",Kn(n.info)),e&&ui(n.info,e,i),n.info.started=!0)};$n(this.info,i,(function t(e){n.info.started&&i(e),Kn(n.info)})),this.info.x=t.clientX,this.info.y=t.clientY},touchstart:function(t){let e=t.changedTouches[0];this.info.x=e.clientX,this.info.y=e.clientY},touchmove:function(t){let e=ei(t),n=t.changedTouches[0],i=n.clientX,r=n.clientY;ci(this.info,i,r)&&("start"===this.info.state&&si("tap"),this.info.addMove({x:i,y:r}),ui(this.info,e,n),this.info.state="track",this.info.started=!0)},touchend:function(t){let e=ei(t),n=t.changedTouches[0];this.info.started&&(this.info.state="end",this.info.addMove({x:n.clientX,y:n.clientY}),ui(this.info,e,n))}}),ri({name:"tap",deps:["mousedown","click","touchstart","touchend"],flow:{start:["mousedown","touchstart"],end:["click","touchend"]},emits:["tap"],info:{x:NaN,y:NaN,prevent:!1},reset:function(){this.info.x=NaN,this.info.y=NaN,this.info.prevent=!1},mousedown:function(t){Yn(t)&&(this.info.x=t.clientX,this.info.y=t.clientY)},click:function(t){Yn(t)&&hi(this.info,t)},touchstart:function(t){const e=t.changedTouches[0];this.info.x=e.clientX,this.info.y=e.clientY},touchend:function(t){hi(this.info,t.changedTouches[0],t)}});const di=ei,pi=I((t=>class extends t{_addEventListenerToNode(t,e,n){ii(t,e,n)||super._addEventListenerToNode(t,e,n)}_removeEventListenerFromNode(t,e,n){(function i(t,e,n){return!!Qn[e]&&((function i(t,e,n){let i=Qn[e],r=i.deps,o=i.name,a=t[Pn];if(a)for(let e,n,i=0;i<r.length;i++)e=r[i],n=a[e],n&&n[o]&&(n[o]=(n[o]||1)-1,n._count=(n._count||1)-1,0===n._count&&t.removeEventListener(e,ni,Hn(e)));t.removeEventListener(e,n)})(t,e,n),!0)})(t,e,n)||super._removeEventListenerFromNode(t,e,n)}})),fi=/:host\(:dir\((ltr|rtl)\)\)/g,mi=/([\s\w-#\.\[\]\*]*):dir\((ltr|rtl)\)/g,gi=/:dir\((?:ltr|rtl)\)/,_i=Boolean(window.ShadyDOM&&window.ShadyDOM.inUse),yi=[];
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */let vi=null,bi="";function xi(){bi=document.documentElement.getAttribute("dir")}function wi(t){t.__autoDirOptOut||t.setAttribute("dir",bi)}function Si(){xi(),bi=document.documentElement.getAttribute("dir");for(let t=0;t<yi.length;t++)wi(yi[t])}const Mi=I((t=>{_i||vi||(xi(),vi=new MutationObserver(Si),vi.observe(document.documentElement,{attributes:!0,attributeFilter:["dir"]}));const e=Mt(t);class n extends e{static _processStyleText(t,n){return t=e._processStyleText.call(this,t,n),!_i&&gi.test(t)&&(t=this._replaceDirInCssText(t),this.__activateDir=!0),t}static _replaceDirInCssText(t){let e=t;return e=e.replace(fi,':host([dir="$1"])'),e=e.replace(mi,':host([dir="$2"]) $1'),e}constructor(){super(),this.__autoDirOptOut=!1}ready(){super.ready(),this.__autoDirOptOut=this.hasAttribute("dir")}connectedCallback(){e.prototype.connectedCallback&&super.connectedCallback(),this.constructor.__activateDir&&((function t(){vi&&vi.takeRecords().length&&Si()})(),yi.push(this),wi(this))}disconnectedCallback(){if(e.prototype.disconnectedCallback&&super.disconnectedCallback(),this.constructor.__activateDir){const t=yi.indexOf(this);t>-1&&yi.splice(t,1)}}}return n.__activateDir=!1,n}));
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */let Ei=!1,Ti=[],Ci=[];function Ai(){Ei=!0,requestAnimationFrame((function(){Ei=!1,(function t(e){for(;e.length;)ki(e.shift())})(Ti),setTimeout((function(){!(function t(e){for(let t=0,n=e.length;t<n;t++)ki(e.shift())})(Ci)}))}))}function ki(t){const e=t[0],n=t[1],i=t[2];try{n.apply(e,i)}catch(t){setTimeout((()=>{throw t}))}}function Li(t,e,n){Ei||Ai(),Ci.push([t,e,n])}
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */function Pi(){document.body.removeAttribute("unresolved")}
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
function Ni(t,e,n){return{index:t,removed:e,addedCount:n}}function Ii(t,e){return(function n(t,e,i,r,o,a){let s,l=0,c=0,u=Math.min(i-e,a-o);if(0==e&&0==o&&(l=(function h(t,e,n){for(let i=0;i<n;i++)if(!Ri(t[i],e[i]))return i;return n})(t,r,u)),i==t.length&&a==r.length&&(c=(function d(t,e,n){let i=t.length,r=e.length,o=0;for(;o<n&&Ri(t[--i],e[--r]);)o++;return o})(t,r,u-l)),o+=l,a-=c,(i-=c)-(e+=l)==0&&a-o==0)return[];if(e==i){for(s=Ni(e,[],0);o<a;)s.removed.push(r[o++]);return[s]}if(o==a)return[Ni(e,[],i-e)];let p=(function m(t){let e=t.length-1,n=t[0].length-1,i=t[e][n],r=[];for(;e>0||n>0;){if(0==e){r.push(2),n--;continue}if(0==n){r.push(3),e--;continue}let o,a=t[e-1][n-1],s=t[e-1][n],l=t[e][n-1];o=s<l?s<a?s:a:l<a?l:a,o==a?(a==i?r.push(0):(r.push(1),i=a),e--,n--):o==s?(r.push(3),e--,i=s):(r.push(2),n--,i=l)}return r.reverse(),r})((function f(t,e,n,i,r,o){let a=o-r+1,s=n-e+1,l=new Array(a);for(let t=0;t<a;t++)l[t]=new Array(s),l[t][0]=t;for(let t=0;t<s;t++)l[0][t]=t;for(let n=1;n<a;n++)for(let o=1;o<s;o++)if(Ri(t[e+o-1],i[r+n-1]))l[n][o]=l[n-1][o-1];else{let t=l[n-1][o]+1,e=l[n][o-1]+1;l[n][o]=t<e?t:e}return l})(t,e,i,r,o,a));s=void 0;let g=[],_=e,y=o;for(let t=0;t<p.length;t++)switch(p[t]){case 0:s&&(g.push(s),s=void 0),_++,y++;break;case 1:s||(s=Ni(_,[],0)),s.addedCount++,_++,s.removed.push(r[y]),y++;break;case 2:s||(s=Ni(_,[],0)),s.addedCount++,_++;break;case 3:s||(s=Ni(_,[],0)),s.removed.push(r[y]),y++}return s&&g.push(s),g})(t,0,t.length,e,0,e.length)}function Ri(t,e){return t===e}
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */function Oi(t){return"slot"===t.localName}"interactive"===document.readyState||"complete"===document.readyState?Pi():window.addEventListener("DOMContentLoaded",Pi);let zi=class{static getFlattenedNodes(t){const e=Y(t);return Oi(t)?(t=t,e.assignedNodes({flatten:!0})):Array.from(e.childNodes).map((t=>Oi(t)?Y(t=t).assignedNodes({flatten:!0}):[t])).reduce(((t,e)=>t.concat(e)),[])}constructor(t,e){this._shadyChildrenObserver=null,this._nativeChildrenObserver=null,this._connected=!1,this._target=t,this.callback=e,this._effectiveNodes=[],this._observer=null,this._scheduled=!1,this._boundSchedule=()=>{this._schedule()},this.connect(),this._schedule()}connect(){Oi(this._target)?this._listenSlots([this._target]):Y(this._target).children&&(this._listenSlots(Y(this._target).children),window.ShadyDOM?this._shadyChildrenObserver=window.ShadyDOM.observeChildren(this._target,(t=>{this._processMutations(t)})):(this._nativeChildrenObserver=new MutationObserver((t=>{this._processMutations(t)})),this._nativeChildrenObserver.observe(this._target,{childList:!0}))),this._connected=!0}disconnect(){Oi(this._target)?this._unlistenSlots([this._target]):Y(this._target).children&&(this._unlistenSlots(Y(this._target).children),window.ShadyDOM&&this._shadyChildrenObserver?(window.ShadyDOM.unobserveChildren(this._shadyChildrenObserver),this._shadyChildrenObserver=null):this._nativeChildrenObserver&&(this._nativeChildrenObserver.disconnect(),this._nativeChildrenObserver=null)),this._connected=!1}_schedule(){this._scheduled||(this._scheduled=!0,vt.run((()=>this.flush())))}_processMutations(t){this._processSlotMutations(t),this.flush()}_processSlotMutations(t){if(t)for(let e=0;e<t.length;e++){let n=t[e];n.addedNodes&&this._listenSlots(n.addedNodes),n.removedNodes&&this._unlistenSlots(n.removedNodes)}}flush(){if(!this._connected)return!1;window.ShadyDOM&&ShadyDOM.flush(),this._nativeChildrenObserver?this._processSlotMutations(this._nativeChildrenObserver.takeRecords()):this._shadyChildrenObserver&&this._processSlotMutations(this._shadyChildrenObserver.takeRecords()),this._scheduled=!1;let t={target:this._target,addedNodes:[],removedNodes:[]},e=this.constructor.getFlattenedNodes(this._target),n=Ii(e,this._effectiveNodes);for(let e,i=0;i<n.length&&(e=n[i]);i++)for(let n,i=0;i<e.removed.length&&(n=e.removed[i]);i++)t.removedNodes.push(n);for(let i,r=0;r<n.length&&(i=n[r]);r++)for(let n=i.index;n<i.index+i.addedCount;n++)t.addedNodes.push(e[n]);this._effectiveNodes=e;let i=!1;return(t.addedNodes.length||t.removedNodes.length)&&(i=!0,this.callback.call(this._target,t)),i}_listenSlots(t){for(let e=0;e<t.length;e++){let n=t[e];Oi(n)&&n.addEventListener("slotchange",this._boundSchedule)}}_unlistenSlots(t){for(let e=0;e<t.length;e++){let n=t[e];Oi(n)&&n.removeEventListener("slotchange",this._boundSchedule)}}};
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */const Di=function(){let t,e;do{t=window.ShadyDOM&&ShadyDOM.flush(),window.ShadyCSS&&window.ShadyCSS.ScopingShim&&window.ShadyCSS.ScopingShim.flush(),e=kn()}while(t||e)},Bi=Element.prototype,Hi=Bi.matches||Bi.matchesSelector||Bi.mozMatchesSelector||Bi.msMatchesSelector||Bi.oMatchesSelector||Bi.webkitMatchesSelector,Fi=function(t,e){return Hi.call(t,e)};
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */class Vi{constructor(t){window.ShadyDOM&&window.ShadyDOM.inUse&&window.ShadyDOM.patch(t),this.node=t}observeNodes(t){return new zi(this.node,t)}unobserveNodes(t){t.disconnect()}notifyObserver(){}deepContains(t){if(Y(this.node).contains(t))return!0;let e=t,n=t.ownerDocument;for(;e&&e!==n&&e!==this.node;)e=Y(e).parentNode||Y(e).host;return e===this.node}getOwnerRoot(){return Y(this.node).getRootNode()}getDistributedNodes(){return"slot"===this.node.localName?Y(this.node).assignedNodes({flatten:!0}):[]}getDestinationInsertionPoints(){let t=[],e=Y(this.node).assignedSlot;for(;e;)t.push(e),e=Y(e).assignedSlot;return t}importNode(t,e){let n=this.node instanceof Document?this.node:this.node.ownerDocument;return Y(n).importNode(t,e)}getEffectiveChildNodes(){return zi.getFlattenedNodes(this.node)}queryDistributedElements(t){let e=this.getEffectiveChildNodes(),n=[];for(let i,r=0,o=e.length;r<o&&(i=e[r]);r++)i.nodeType===Node.ELEMENT_NODE&&Fi(i,t)&&n.push(i);return n}get activeElement(){let t=this.node;return void 0!==t._activeElement?t._activeElement:t.activeElement}}function Ui(t,e){for(let n=0;n<e.length;n++){let i=e[n];Object.defineProperty(t,i,{get:function(){return this.node[i]},configurable:!0})}}class ji{constructor(t){this.event=t}get rootTarget(){return this.path[0]}get localTarget(){return this.event.target}get path(){return this.event.composedPath()}}let Gi=Vi;if(window.ShadyDOM&&window.ShadyDOM.inUse&&window.ShadyDOM.noPatch&&window.ShadyDOM.Wrapper){class t extends window.ShadyDOM.Wrapper{}Object.getOwnPropertyNames(Vi.prototype).forEach((e=>{"activeElement"!=e&&(t.prototype[e]=Vi.prototype[e])})),Ui(t.prototype,["classList"]),Gi=t,Object.defineProperties(ji.prototype,{localTarget:{get(){const t=this.event.currentTarget,e=t&&Yi(t).getOwnerRoot(),n=this.path;for(let t=0;t<n.length;t++){const i=n[t];if(Yi(i).getOwnerRoot()===e)return i}},configurable:!0},path:{get(){return window.ShadyDOM.composedPath(this.event)},configurable:!0}})}else!(function Wi(t,e){for(let n=0;n<e.length;n++){let i=e[n];t[i]=function(){return this.node[i].apply(this.node,arguments)}}})(Vi.prototype,["cloneNode","appendChild","insertBefore","removeChild","replaceChild","setAttribute","removeAttribute","querySelector","querySelectorAll"]),Ui(Vi.prototype,["parentNode","firstChild","lastChild","nextSibling","previousSibling","firstElementChild","lastElementChild","nextElementSibling","previousElementSibling","childNodes","children","classList"]),(function qi(t,e){for(let n=0;n<e.length;n++){let i=e[n];Object.defineProperty(t,i,{get:function(){return this.node[i]},set:function(t){this.node[i]=t},configurable:!0})}})(Vi.prototype,["textContent","innerHTML","className"]);const Yi=function(t){if((t=t||document)instanceof Gi)return t;if(t instanceof ji)return t;let e=t.__domApi;return e||(e=t instanceof Event?new ji(t):new Gi(t),t.__domApi=e),e},Xi=window.ShadyDOM,$i=window.ShadyCSS;
/**
    @license
    Copyright (c) 2019 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */function Ki(t,e){return Y(t).getRootNode()===e}
/**
     * @fileoverview
     * @suppress {checkPrototypalTypes}
     * @license Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
     * This code may only be used under the BSD style license found at
     * http://polymer.github.io/LICENSE.txt The complete set of authors may be found
     * at http://polymer.github.io/AUTHORS.txt The complete set of contributors may
     * be found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by
     * Google as part of the polymer project is also subject to an additional IP
     * rights grant found at http://polymer.github.io/PATENTS.txt
     */
const Zi="disable-upgrade",Ji=t=>{for(;t;){const e=Object.getOwnPropertyDescriptor(t,"observedAttributes");if(e)return e.get;t=Object.getPrototypeOf(t.prototype).constructor}return()=>[]};I((t=>{const e=me(t);let n=Ji(e);return class extends e{constructor(){super()}static get observedAttributes(){return n.call(this).concat(Zi)}_initializeProperties(){this.hasAttribute(Zi)?this.__isUpgradeDisabled=!0:super._initializeProperties()}_enableProperties(){this.__isUpgradeDisabled||super._enableProperties()}_canApplyPropertyDefault(t){return super._canApplyPropertyDefault(t)&&!(this.__isUpgradeDisabled&&this._isPropertyPending(t))}attributeChangedCallback(t,e,n,i){t==Zi?this.__isUpgradeDisabled&&null==n&&(super._initializeProperties(),this.__isUpgradeDisabled=!1,Y(this).isConnected&&super.connectedCallback()):super.attributeChangedCallback(t,e,n,i)}connectedCallback(){this.__isUpgradeDisabled||super.connectedCallback()}disconnectedCallback(){this.__isUpgradeDisabled||super.disconnectedCallback()}}}));
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
const Qi="disable-upgrade";let tr=window.ShadyCSS;const er=I((t=>{const e=pi(me(t)),n=fe?e:Mi(e),i=Ji(n),r={x:"pan-x",y:"pan-y",none:"none",all:"auto"};class o extends n{constructor(){super()}static get importMeta(){return this.prototype.importMeta}created(){}__attributeReaction(t,e,n){(this.__dataAttributes&&this.__dataAttributes[t]||t===Qi)&&this.attributeChangedCallback(t,e,n,null)}setAttribute(t,e){if(L&&!this._legacyForceObservedAttributes){const n=this.getAttribute(t);super.setAttribute(t,e),this.__attributeReaction(t,n,String(e))}else super.setAttribute(t,e)}removeAttribute(t){if(L&&!this._legacyForceObservedAttributes){const e=this.getAttribute(t);super.removeAttribute(t),this.__attributeReaction(t,e,null)}else super.removeAttribute(t)}static get observedAttributes(){return L&&!this.prototype._legacyForceObservedAttributes?(this.hasOwnProperty(JSCompiler_renameProperty("__observedAttributes",this))||(this.__observedAttributes=[]),this.__observedAttributes):i.call(this).concat(Qi)}_enableProperties(){this.__isUpgradeDisabled||super._enableProperties()}_canApplyPropertyDefault(t){return super._canApplyPropertyDefault(t)&&!(this.__isUpgradeDisabled&&this._isPropertyPending(t))}connectedCallback(){this.__needsAttributesAtConnected&&this._takeAttributes(),this.__isUpgradeDisabled||(super.connectedCallback(),this.isAttached=!0,this.attached())}attached(){}disconnectedCallback(){this.__isUpgradeDisabled||(super.disconnectedCallback(),this.isAttached=!1,this.detached())}detached(){}attributeChangedCallback(t,e,n,i){e!==n&&(t==Qi?this.__isUpgradeDisabled&&null==n&&(this._initializeProperties(),this.__isUpgradeDisabled=!1,Y(this).isConnected&&this.connectedCallback()):(super.attributeChangedCallback(t,e,n,i),this.attributeChanged(t,e,n)))}attributeChanged(t,e,n){}_initializeProperties(){if(w&&this.hasAttribute(Qi))this.__isUpgradeDisabled=!0;else{let t=Object.getPrototypeOf(this);t.hasOwnProperty(JSCompiler_renameProperty("__hasRegisterFinished",t))||(this._registered(),t.__hasRegisterFinished=!0),super._initializeProperties(),this.root=this,this.created(),L&&!this._legacyForceObservedAttributes&&(this.hasAttributes()?this._takeAttributes():this.parentNode||(this.__needsAttributesAtConnected=!0)),this._applyListeners()}}_takeAttributes(){const t=this.attributes;for(let e=0,n=t.length;e<n;e++){const n=t[e];this.__attributeReaction(n.name,null,n.value)}}_registered(){}ready(){this._ensureAttributes(),super.ready()}_ensureAttributes(){}_applyListeners(){}serialize(t){return this._serializeValue(t)}deserialize(t,e){return this._deserializeValue(t,e)}reflectPropertyToAttribute(t,e,n){this._propertyToAttribute(t,e,n)}serializeValueToAttribute(t,e,n){this._valueToNodeAttribute(n||this,t,e)}extend(t,e){if(!t||!e)return t||e;let n=Object.getOwnPropertyNames(e);for(let i,r=0;r<n.length&&(i=n[r]);r++){let n=Object.getOwnPropertyDescriptor(e,i);n&&Object.defineProperty(t,i,n)}return t}mixin(t,e){for(let n in e)t[n]=e[n];return t}chainObject(t,e){return t&&e&&t!==e&&(t.__proto__=e),t}instanceTemplate(t){let e=this.constructor._contentForTemplate(t);return document.importNode(e,!0)}fire(t,e,n){n=n||{},e=null==e?{}:e;let i=new Event(t,{bubbles:void 0===n.bubbles||n.bubbles,cancelable:Boolean(n.cancelable),composed:void 0===n.composed||n.composed});return i.detail=e,Y(n.node||this).dispatchEvent(i),i}listen(t,e,n){t=t||this;let i=this.__boundListeners||(this.__boundListeners=new WeakMap),r=i.get(t);r||(r={},i.set(t,r));let o=e+n;r[o]||(r[o]=this._addMethodEventListenerToNode(t,e,n,this))}unlisten(t,e,n){t=t||this;let i=this.__boundListeners&&this.__boundListeners.get(t),r=e+n,o=i&&i[r];o&&(this._removeEventListenerFromNode(t,e,o),i[r]=null)}setScrollDirection(t,e){oi(e||this,r[t]||"auto")}$$(t){return this.root.querySelector(t)}get domHost(){let t=Y(this).getRootNode();return t instanceof DocumentFragment?t.host:t}distributeContent(){const t=Yi(this);window.ShadyDOM&&t.shadowRoot&&ShadyDOM.flush()}getEffectiveChildNodes(){return Yi(this).getEffectiveChildNodes()}queryDistributedElements(t){return Yi(this).queryDistributedElements(t)}getEffectiveChildren(){return this.getEffectiveChildNodes().filter((function(t){return t.nodeType===Node.ELEMENT_NODE}))}getEffectiveTextContent(){let t=this.getEffectiveChildNodes(),e=[];for(let n,i=0;n=t[i];i++)n.nodeType!==Node.COMMENT_NODE&&e.push(n.textContent);return e.join("")}queryEffectiveChildren(t){let e=this.queryDistributedElements(t);return e&&e[0]}queryAllEffectiveChildren(t){return this.queryDistributedElements(t)}getContentChildNodes(t){let e=this.root.querySelector(t||"slot");return e?Yi(e).getDistributedNodes():[]}getContentChildren(t){return this.getContentChildNodes(t).filter((function(t){return t.nodeType===Node.ELEMENT_NODE}))}isLightDescendant(t){const e=this;return e!==t&&Y(e).contains(t)&&Y(e).getRootNode()===Y(t).getRootNode()}isLocalDescendant(t){return this.root===Y(t).getRootNode()}scopeSubtree(t,e=!1){return(function n(t,e=!1){if(!Xi||!$i)return null;if(!Xi.handlesDynamicScoping)return null;const n=$i.ScopingShim;if(!n)return null;const i=n.scopeForNode(t),r=Y(t).getRootNode(),o=t=>{if(!Ki(t,r))return;const e=Array.from(Xi.nativeMethods.querySelectorAll.call(t,"*"));e.push(t);for(let t=0;t<e.length;t++){const o=e[t];if(!Ki(o,r))continue;const a=n.currentScopeForNode(o);a!==i&&(""!==a&&n.unscopeNode(o,a),n.scopeNode(o,i))}};if(o(t),e){const e=new MutationObserver((t=>{for(let e=0;e<t.length;e++){const n=t[e];for(let t=0;t<n.addedNodes.length;t++){const e=n.addedNodes[t];e.nodeType===Node.ELEMENT_NODE&&o(e)}}}));return e.observe(t,{childList:!0,subtree:!0}),e}return null})(t,e)}getComputedStyleValue(t){return tr.getComputedStyleValue(this,t)}debounce(t,e,n){return this._debouncers=this._debouncers||{},this._debouncers[t]=Tn.debounce(this._debouncers[t],n>0?gt.after(n):vt,e.bind(this))}isDebouncerActive(t){this._debouncers=this._debouncers||{};let e=this._debouncers[t];return!(!e||!e.isActive())}flushDebouncer(t){this._debouncers=this._debouncers||{};let e=this._debouncers[t];e&&e.flush()}cancelDebouncer(t){this._debouncers=this._debouncers||{};let e=this._debouncers[t];e&&e.cancel()}async(t,e){return e>0?gt.run(t.bind(this),e):~vt.run(t.bind(this))}cancelAsync(t){t<0?vt.cancel(~t):gt.cancel(t)}create(t,e){let n=document.createElement(t);if(e)if(n.setProperties)n.setProperties(e);else for(let t in e)n[t]=e[t];return n}elementMatches(t,e){return Fi(e||this,t)}toggleAttribute(t,e){let n=this;return 3===arguments.length&&(n=arguments[2]),1==arguments.length&&(e=!n.hasAttribute(t)),e?(Y(n).setAttribute(t,""),!0):(Y(n).removeAttribute(t),!1)}toggleClass(t,e,n){n=n||this,1==arguments.length&&(e=!n.classList.contains(t)),e?n.classList.add(t):n.classList.remove(t)}transform(t,e){(e=e||this).style.webkitTransform=t,e.style.transform=t}translate3d(t,e,n,i){this.transform("translate3d("+t+","+e+","+n+")",i=i||this)}arrayDelete(t,e){let n;if(Array.isArray(t)){if(n=t.indexOf(e),n>=0)return t.splice(n,1)}else if(n=nt(this,t).indexOf(e),n>=0)return this.splice(t,n,1);return null}_logger(t,e){switch(Array.isArray(e)&&1===e.length&&Array.isArray(e[0])&&(e=e[0]),t){case"log":case"warn":case"error":console[t](...e)}}_log(...t){this._logger("log",t)}_warn(...t){this._logger("warn",t)}_error(...t){this._logger("error",t)}_logf(t,...e){return["[%s::%s]",this.is,t,...e]}}return o.prototype.is="",o}));function nr(t,e){let n=0,i=0;for(;;){if(n===t.length)return i===e.length?0:-1;if(i===e.length)return 1;if(rr(t[n])&&rr(e[i])){const r=n,o=i;n=ir(t,n+1),i=ir(e,i+1);const a=parseFloat(t.slice(r,n)),s=parseFloat(e.slice(o,i));if(a<s)return-1;if(a>s)return 1}else{if(or(t[n])){if(!or(e[i]))return-1}else{if(or(e[i]))return 1;if(t[n]<e[i])return-1;if(t[n]>e[i])return 1}n++,i++}}}function ir(t,e){let n;!(function(t){t[t.NATURAL=0]="NATURAL",t[t.REAL=1]="REAL",t[t.EXPONENT_SIGN=2]="EXPONENT_SIGN",t[t.EXPONENT=3]="EXPONENT"})(n||(n={}));let i=n.NATURAL;for(;e<t.length;e++)if(i===n.NATURAL){if("."===t[e])i=n.REAL;else if("e"===t[e]||"E"===t[e])i=n.EXPONENT_SIGN;else if(!rr(t[e]))break}else if(i===n.REAL){if("e"===t[e]||"E"===t[e])i=n.EXPONENT_SIGN;else if(!rr(t[e]))break}else if(i===n.EXPONENT_SIGN){if(!rr(t[e])&&"+"!==t[e]&&"-"!==t[e])break;i=n.EXPONENT}else if(i===n.EXPONENT&&!rr(t[e]))break;return e}function rr(t){return"0"<=t&&t<="9"}function or(t){return"/"===t||"_"===t||rr(t)}function ar(t){return Se.exports.union.apply(null,Se.exports.values(t)).sort(nr)}class sr extends Error{constructor(){super(...arguments),this.name="RequestCancellationError"}}class lr extends Error{constructor(t){super(t),this.name="InvalidRequestOptionsError",Object.setPrototypeOf(this,lr.prototype)}}class cr extends Error{constructor(t,e){super(),this.message=`RequestNetworkError: ${t.status} at ${e}`,this.name="RequestNetworkError",this.req=t,this.url=e}}var ur;!(function(t){t.GET="GET",t.POST="POST"})(ur||(ur={}));class hr{validate(){if(this.methodType===ur.GET&&this.body)throw new lr("body must be missing for a GET request.")}}class dr{constructor(t=1e3,e=3){this._queue=[],this._nActiveRequests=0,this._nSimultaneousRequests=t,this._maxRetries=e}request(t,e){const n=(function i(t){const e=new hr;return t?(e.methodType=ur.POST,e.body=(function n(t){const e=new FormData;for(const[n,i]of Object.entries(t)){const t=Array.isArray(i)?i:[i];for(const i of t)e.append(n,i)}return e})(t),e):(e.methodType=ur.GET,e)})(e);return this.requestWithOptions(t,n)}requestWithOptions(t,e){return e.validate(),new Promise(((t,e)=>{this._queue.push({resolve:t,reject:e}),this.launchRequests()})).then((()=>this.promiseWithRetries(t,this._maxRetries,e))).then((t=>(this._nActiveRequests--,this.launchRequests(),t)),(t=>("RequestNetworkError"===t.name&&(this._nActiveRequests--,this.launchRequests()),Promise.reject(t))))}fetch(t,e){return new Promise(((t,e)=>{this._queue.push({resolve:t,reject:e}),this.launchRequests()})).then((()=>{let n=1;return new Promise((i=>{const r=()=>{fetch(t,e).then((t=>{if(!t.ok&&this._maxRetries>n)return n++,void r();i(t),this._nActiveRequests--,this.launchRequests()}))};r()}))}))}clearQueue(){for(;this._queue.length>0;)this._queue.pop().reject(new sr("Request cancelled by clearQueue"))}activeRequests(){return this._nActiveRequests}outstandingRequests(){return this._nActiveRequests+this._queue.length}launchRequests(){for(;this._nActiveRequests<this._nSimultaneousRequests&&this._queue.length>0;)this._nActiveRequests++,this._queue.pop().resolve(void 0)}promiseWithRetries(t,e,n){return this._promiseFromUrl(t,n).then((t=>t),(i=>e>0?this.promiseWithRetries(t,e-1,n):Promise.reject(i)))}_promiseFromUrl(t,e){return new Promise(((n,i)=>{const r=(function o(t,e,n,i){const r=new XMLHttpRequest;return r.open(t,e),n&&(r.withCredentials=n),i&&r.setRequestHeader("Content-Type",i),r})(e.methodType,t,e.withCredentials,e.contentType);r.onload=function(){200===r.status?n(JSON.parse(r.responseText)):i(new cr(r,t))},r.onerror=function(){i(new cr(r,t))},e.body?r.send(e.body):r.send()}))}}const pr="experimentalPlugin",fr=new URLSearchParams(window.location.search);let mr=gr();function gr(t="data",e=fr){return"/"===t[t.length-1]&&(t=t.slice(0,t.length-1)),{environment:()=>yr(t,"/environment"),experiments:()=>yr(t,"/experiments"),pluginRoute:(e,n,i)=>yr(t+"/plugin",`/${e}${n}`,i),pluginsListing:()=>yr(t,"/plugins_listing",vr({[pr]:e.getAll(pr)})),runs:()=>yr(t,"/runs"),runsForExperiment:e=>yr(t,"/experiment_runs",vr({experiment:String(e)}))}}function _r(){return mr}function yr(t,e,n=new URLSearchParams){let i=t+e;return String(n)&&(i+=(e.includes("?")?"&":"?")+String(n)),i}function vr(t={}){const e=Object.keys(t).sort().filter((e=>t[e])),n=new URLSearchParams;return e.forEach((e=>{const i=t[e];(Array.isArray(i)?i:[i]).forEach((t=>n.append(e,t)))})),n}var br;function xr(t,e){const n=(()=>{try{return new RegExp(e)}catch(t){return null}})();return{name:e,metadata:{type:br.SEARCH_RESULTS,validRegex:!!n,universalRegex:".*"===e},items:n?t.filter((t=>t.match(n))):[]}}function wr(t,e,n){const i=(function r(t,e=""){const n=[xr(t,e)],i=(function r(t,e="/"){const n=[],i={};return t.forEach((t=>{const r=t.indexOf(e),o=r>=0?t.slice(0,r):t;if(!i[o]){const t={name:o,metadata:{type:br.PREFIX_GROUP},items:[]};i[o]=t,n.push(t)}i[o].items.push(t)})),n})(t);return[].concat(n,i)})(ar(t),n),o=(function a(t){const e=new Map;return Object.keys(t).forEach((n=>{t[n].forEach((t=>{const i=e.get(t)||[];i.push(n),e.set(t,i)}))})),e})(Se.exports.pick(t,e));return i.map((({name:t,metadata:e,items:n})=>({name:t,metadata:e,items:n.map((t=>({tag:t,runs:(o.get(t)||[]).slice()})))})))}function Sr(t,e){const n=nr(t.tag,e.tag);return 0!=n?n:nr(t.run,e.run)}function Mr(t,e,n){return wr(t,e,n).map((function i(t){const e=Se.exports.flatten(t.items.map((({tag:t,runs:e})=>e.map((e=>({tag:t,run:e}))))));return e.sort(Sr),{name:t.name,metadata:t.metadata,items:e}}))}
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */!(function(t){t[t.SEARCH_RESULTS=0]="SEARCH_RESULTS",t[t.PREFIX_GROUP=1]="PREFIX_GROUP"})(br||(br={}));const Er={attached:!0,detached:!0,ready:!0,created:!0,beforeRegister:!0,registered:!0,attributeChanged:!0,listeners:!0,hostAttributes:!0},Tr={attached:!0,detached:!0,ready:!0,created:!0,beforeRegister:!0,registered:!0,attributeChanged:!0,behaviors:!0,_noAccessors:!0},Cr=Object.assign({listeners:!0,hostAttributes:!0,properties:!0,observers:!0},Tr);function Ar(t,e,n,i){!(function r(t,e,n){const i=t._noAccessors,r=Object.getOwnPropertyNames(t);for(let o=0;o<r.length;o++){let a=r[o];if(!(a in n))if(i)e[a]=t[a];else{let n=Object.getOwnPropertyDescriptor(t,a);n&&(n.configurable=!0,Object.defineProperty(e,a,n))}}})(e,t,i);for(let t in Er)e[t]&&(n[t]=n[t]||[],n[t].push(e[t]))}function kr(t,e,n){e=e||[];for(let i=t.length-1;i>=0;i--){let r=t[i];r?Array.isArray(r)?kr(r,e):e.indexOf(r)<0&&(!n||n.indexOf(r)<0)&&e.unshift(r):console.warn("behavior is null, check for missing or 404 import")}return e}function Lr(t,e){for(const n in e){const i=t[n],r=e[n];t[n]=!("value"in r)&&i&&"value"in i?Object.assign({value:i.value},r):r}}const Pr=er(HTMLElement);function Nr(t,e,n){let i;const r={};class o extends e{static _finalizeClass(){if(this.hasOwnProperty(JSCompiler_renameProperty("generatedFrom",this))){if(i)for(let t,e=0;e<i.length;e++)t=i[e],t.properties&&this.createProperties(t.properties),t.observers&&this.createObservers(t.observers,t.properties);t.properties&&this.createProperties(t.properties),t.observers&&this.createObservers(t.observers,t.properties),this._prepareTemplate()}else e._finalizeClass.call(this)}static get properties(){const e={};if(i)for(let t=0;t<i.length;t++)Lr(e,i[t].properties);return Lr(e,t.properties),e}static get observers(){let e=[];if(i)for(let t,n=0;n<i.length;n++)t=i[n],t.observers&&(e=e.concat(t.observers));return t.observers&&(e=e.concat(t.observers)),e}created(){super.created();const t=r.created;if(t)for(let e=0;e<t.length;e++)t[e].call(this)}_registered(){const t=o.prototype;if(!t.hasOwnProperty(JSCompiler_renameProperty("__hasRegisterFinished",t))){t.__hasRegisterFinished=!0,super._registered(),w&&a(t);const e=Object.getPrototypeOf(this);let n=r.beforeRegister;if(n)for(let t=0;t<n.length;t++)n[t].call(e);if(n=r.registered,n)for(let t=0;t<n.length;t++)n[t].call(e)}}_applyListeners(){super._applyListeners();const t=r.listeners;if(t)for(let e=0;e<t.length;e++){const n=t[e];if(n)for(let t in n)this._addMethodEventListenerToNode(this,t,n[t])}}_ensureAttributes(){const t=r.hostAttributes;if(t)for(let e=t.length-1;e>=0;e--){const n=t[e];for(let t in n)this._ensureAttribute(t,n[t])}super._ensureAttributes()}ready(){super.ready();let t=r.ready;if(t)for(let e=0;e<t.length;e++)t[e].call(this)}attached(){super.attached();let t=r.attached;if(t)for(let e=0;e<t.length;e++)t[e].call(this)}detached(){super.detached();let t=r.detached;if(t)for(let e=0;e<t.length;e++)t[e].call(this)}attributeChanged(t,e,n){super.attributeChanged();let i=r.attributeChanged;if(i)for(let r=0;r<i.length;r++)i[r].call(this,t,e,n)}}if(n){Array.isArray(n)||(n=[n]);let t=e.prototype.behaviors;i=kr(n,null,t),o.prototype.behaviors=t?t.concat(n):i}const a=e=>{i&&(function n(t,e,i){for(let n=0;n<e.length;n++)Ar(t,e[n],i,Cr)})(e,i,r),Ar(e,t,r,Tr)};return w||a(o.prototype),o.generatedFrom=t,o}const Ir=function(t,e){t||console.warn("Polymer.Class requires `info` argument");let n=e?e(Pr):Pr;return n=Nr(t,n,t.behaviors),n.is=n.prototype.is=t.is,n},Rr=function(t){let e;return e="function"==typeof t?t:Rr.Class(t),t._legacyForceObservedAttributes&&(e.prototype._legacyForceObservedAttributes=t._legacyForceObservedAttributes),customElements.define(e.is,e),e};
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
function Or(t,e,n,i,r){let o;r&&(o="object"==typeof n&&null!==n,o&&(i=t.__dataTemp[e]));let a=i!==n&&(i==i||n==n);return o&&a&&(t.__dataTemp[e]=n),a}Rr.Class=Ir;const zr=I((t=>class extends t{_shouldPropertyChange(t,e,n){return Or(this,t,e,n,!0)}})),Dr=I((t=>class extends t{static get properties(){return{mutableData:Boolean}}_shouldPropertyChange(t,e,n){return Or(this,t,e,n,this.mutableData)}}));zr._mutablePropertyChange=Or;
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
let Br=null;function Hr(){return Br}Hr.prototype=Object.create(HTMLTemplateElement.prototype,{constructor:{value:Hr,writable:!0}});const Fr=he(Hr),Vr=zr(Fr),Ur=he(class{});function jr(t,e){for(let n=0;n<e.length;n++){let i=e[n];if(Boolean(t)!=Boolean(i.__hideTemplateChildren__))if(i.nodeType===Node.TEXT_NODE)t?(i.__polymerTextContent__=i.textContent,i.textContent=""):i.textContent=i.__polymerTextContent__;else if("slot"===i.localName)if(t)i.__polymerReplaced__=document.createComment("hidden-slot"),Y(Y(i).parentNode).replaceChild(i.__polymerReplaced__,i);else{const t=i.__polymerReplaced__;t&&Y(Y(t).parentNode).replaceChild(i,t)}else i.style&&(t?(i.__polymerDisplay__=i.style.display,i.style.display="none"):i.style.display=i.__polymerDisplay__);i.__hideTemplateChildren__=t,i._showHideChildren&&i._showHideChildren(t)}}class Gr extends Ur{constructor(t){super(),this._configureProperties(t),this.root=this._stampTemplate(this.__dataHost);let e=[];this.children=e;for(let t=this.root.firstChild;t;t=t.nextSibling)e.push(t),t.__templatizeInstance=this;this.__templatizeOwner&&this.__templatizeOwner.__hideTemplateChildren__&&this._showHideChildren(!0);let n=this.__templatizeOptions;(t&&n.instanceProps||!n.instanceProps)&&this._enableProperties()}_configureProperties(t){if(this.__templatizeOptions.forwardHostProp)for(let t in this.__hostProps)this._setPendingProperty(t,this.__dataHost["_host_"+t]);for(let e in t)this._setPendingProperty(e,t[e])}forwardHostProp(t,e){this._setPendingPropertyOrPath(t,e,!1,!0)&&this.__dataHost._enqueueClient(this)}_addEventListenerToNode(t,e,n){if(this._methodHost&&this.__templatizeOptions.parentModel)this._methodHost._addEventListenerToNode(t,e,(t=>{t.model=this,n(t)}));else{let i=this.__dataHost.__dataHost;i&&i._addEventListenerToNode(t,e,n)}}_showHideChildren(t){jr(t,this.children)}_setUnmanagedPropertyToNode(t,e,n){t.__hideTemplateChildren__&&t.nodeType==Node.TEXT_NODE&&"textContent"==e?t.__polymerTextContent__=n:super._setUnmanagedPropertyToNode(t,e,n)}get parentModel(){let t=this.__parentModel;if(!t){let e;t=this;do{t=t.__dataHost.__dataHost}while((e=t.__templatizeOptions)&&!e.parentModel);this.__parentModel=t}return t}dispatchEvent(t){return!0}}const Wr=zr(Gr);function qr(t){let e=t.__dataHost;return e&&e._methodHost||e}function Yr(t,e){return function t(n,i,r){e.call(n.__templatizeOwner,i.substring("_host_".length),r[i])}}function Xr(t,e){return function t(n,i,r){e.call(n.__templatizeOwner,n,i,r[i])}}function $r(t,e,n){if(b&&!qr(t))throw new Error("strictTemplatePolicy: template owner not trusted");if(n=n||{},t.__templatizeOwner)throw new Error("A <template> can only be templatized once");t.__templatizeOwner=e;let i=(e?e.constructor:Gr)._parseTemplate(t),r=i.templatizeInstanceClass;r||(r=(function o(t,e,n){let i=n.mutableData?Wr:Gr;$r.mixin&&(i=$r.mixin(i));let r=class extends i{};return r.prototype.__templatizeOptions=n,r.prototype._bindTemplate(t),(function o(t,e,n,i){let r=n.hostProps||{};for(let e in i.instanceProps){delete r[e];let n=i.notifyInstanceProp;n&&t.prototype._addPropertyEffect(e,t.prototype.PROPERTY_EFFECT_TYPES.NOTIFY,{fn:Xr(0,n)})}if(i.forwardHostProp&&e.__dataHost)for(let e in r)n.hasHostProps||(n.hasHostProps=!0),t.prototype._addPropertyEffect(e,t.prototype.PROPERTY_EFFECT_TYPES.NOTIFY,{fn:function t(e,n,i){e.__dataHost._setPendingPropertyOrPath("_host_"+n,i[n],!0,!0)}})})(r,t,e,n),r})(t,i,n),i.templatizeInstanceClass=r);const a=qr(t);!(function s(t,e,n,i){let r=n.forwardHostProp;if(r&&e.hasHostProps){const o="template"==t.localName;let a=e.templatizeTemplateClass;if(!a){if(o){let t=n.mutableData?Vr:Fr;class i extends t{}a=e.templatizeTemplateClass=i}else{const n=t.constructor;class i extends n{}a=e.templatizeTemplateClass=i}let s=e.hostProps;for(let t in s)a.prototype._addPropertyEffect("_host_"+t,a.prototype.PROPERTY_EFFECT_TYPES.PROPAGATE,{fn:Yr(0,r)}),a.prototype._createNotifyingProperty("_host_"+t);S&&i&&(function o(t,e,n){const i=n.constructor._properties,{propertyEffects:r}=t,{instanceProps:o}=e;for(let t in r)if(!(i[t]||o&&o[t])){const e=r[t];for(let n=0;n<e.length;n++){const{part:i}=e[n].info;if(!i.signature||!i.signature.static){console.warn(`Property '${t}' used in template but not declared in 'properties'; attribute will not be observed.`);break}}}})(e,n,i)}if(t.__dataProto&&Object.assign(t.__data,t.__dataProto),o)!(function a(t,e){Br=t,Object.setPrototypeOf(t,e.prototype),new e,Br=null})(t,a),t.__dataTemp={},t.__dataPending=null,t.__dataOld=null,t._enableProperties();else{Object.setPrototypeOf(t,a.prototype);const n=e.hostProps;for(let e in n)if(e="_host_"+e,e in t){const n=t[e];delete t[e],t.__data[e]=n}}}})(t,i,n,a);let l=class extends r{};return l.prototype._methodHost=a,l.prototype.__dataHost=t,l.prototype.__templatizeOwner=e,l.prototype.__hostProps=i.hostProps,l=l,l}function Kr(t,e){let n;for(;e;)if(n=e.__dataHost?e:e.__templatizeInstance){if(n.__dataHost==t)return n;e=n.__dataHost}else e=Y(e).parentNode;return null}
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */const Zr={templatize(t,e){this._templatizerTemplate=t,this.ctor=$r(t,this,{mutableData:Boolean(e),parentModel:this._parentModel,instanceProps:this._instanceProps,forwardHostProp:this._forwardHostPropV2,notifyInstanceProp:this._notifyInstancePropV2})},stamp(t){return new this.ctor(t)},modelForElement(t){return Kr(this._templatizerTemplate,t)}};
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */let Jr=!1;function Qr(){if(w&&!m){if(!Jr){Jr=!0;const t=document.createElement("style");t.textContent="dom-bind,dom-if,dom-repeat{display:none;}",document.head.appendChild(t)}return!0}return!1}
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */const to=pi(Dr(he(HTMLElement)));customElements.define("dom-bind",class extends to{static get observedAttributes(){return["mutable-data"]}constructor(){if(super(),b)throw new Error("strictTemplatePolicy: dom-bind not allowed");this.root=null,this.$=null,this.__children=null}attributeChangedCallback(t,e,n,i){this.mutableData=!0}connectedCallback(){Qr()||(this.style.display="none"),this.render()}disconnectedCallback(){this.__removeChildren()}__insertChildren(){Y(Y(this).parentNode).insertBefore(this.root,this)}__removeChildren(){if(this.__children)for(let t=0;t<this.__children.length;t++)this.root.appendChild(this.__children[t])}render(){let t;if(!this.__children){if(t=t||this.querySelector("template"),!t){let e=new MutationObserver((()=>{if(t=this.querySelector("template"),!t)throw new Error("dom-bind requires a <template> child");e.disconnect(),this.render()}));return void e.observe(this,{childList:!0})}this.root=this._stampTemplate(t),this.$=this.root.$,this.__children=[];for(let t=this.root.firstChild;t;t=t.nextSibling)this.__children[this.__children.length]=t;this._enableProperties()}this.__insertChildren(),this.dispatchEvent(new CustomEvent("dom-change",{bubbles:!0,composed:!0}))}});
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
const eo=Dr(ye);class no extends eo{static get is(){return"dom-repeat"}static get template(){return null}static get properties(){return{items:{type:Array},as:{type:String,value:"item"},indexAs:{type:String,value:"index"},itemsIndexAs:{type:String,value:"itemsIndex"},sort:{type:Function,observer:"__sortChanged"},filter:{type:Function,observer:"__filterChanged"},observe:{type:String,observer:"__observeChanged"},delay:Number,renderedItemCount:{type:Number,notify:!k,readOnly:!0},initialCount:{type:Number},targetFramerate:{type:Number,value:20},_targetFrameTime:{type:Number,computed:"__computeFrameTime(targetFramerate)"},notifyDomChange:{type:Boolean},reuseChunkedInstances:{type:Boolean}}}static get observers(){return["__itemsChanged(items.*)"]}constructor(){super(),this.__instances=[],this.__renderDebouncer=null,this.__itemsIdxToInstIdx={},this.__chunkCount=null,this.__renderStartTime=null,this.__itemsArrayChanged=!1,this.__shouldMeasureChunk=!1,this.__shouldContinueChunking=!1,this.__chunkingId=0,this.__sortFn=null,this.__filterFn=null,this.__observePaths=null,this.__ctor=null,this.__isDetached=!0,this.template=null}disconnectedCallback(){super.disconnectedCallback(),this.__isDetached=!0;for(let t=0;t<this.__instances.length;t++)this.__detachInstance(t)}connectedCallback(){if(super.connectedCallback(),Qr()||(this.style.display="none"),this.__isDetached){this.__isDetached=!1;let t=Y(Y(this).parentNode);for(let e=0;e<this.__instances.length;e++)this.__attachInstance(e,t)}}__ensureTemplatized(){if(!this.__ctor){const t=this;let e=this.template=t._templateInfo?t:this.querySelector("template");if(!e){let t=new MutationObserver((()=>{if(!this.querySelector("template"))throw new Error("dom-repeat requires a <template> child");t.disconnect(),this.__render()}));return t.observe(this,{childList:!0}),!1}let n={};n[this.as]=!0,n[this.indexAs]=!0,n[this.itemsIndexAs]=!0,this.__ctor=$r(e,this,{mutableData:this.mutableData,parentModel:!0,instanceProps:n,forwardHostProp:function(t,e){let n=this.__instances;for(let i,r=0;r<n.length&&(i=n[r]);r++)i.forwardHostProp(t,e)},notifyInstanceProp:function(t,e,n){if(Q(this.as,e)){let i=t[this.itemsIndexAs];e==this.as&&(this.items[i]=n);let r=J(this.as,`${JSCompiler_renameProperty("items",this)}.${i}`,e);this.notifyPath(r,n)}}})}return!0}__getMethodHost(){return this.__dataHost._methodHost||this.__dataHost}__functionFromPropertyValue(t){if("string"==typeof t){let e=t,n=this.__getMethodHost();return function(){return n[e].apply(n,arguments)}}return t}__sortChanged(t){this.__sortFn=this.__functionFromPropertyValue(t),this.items&&this.__debounceRender(this.__render)}__filterChanged(t){this.__filterFn=this.__functionFromPropertyValue(t),this.items&&this.__debounceRender(this.__render)}__computeFrameTime(t){return Math.ceil(1e3/t)}__observeChanged(){this.__observePaths=this.observe&&this.observe.replace(".*",".").split(" ")}__handleObservedPaths(t){if(this.__sortFn||this.__filterFn)if(t){if(this.__observePaths){let e=this.__observePaths;for(let n=0;n<e.length;n++)0===t.indexOf(e[n])&&this.__debounceRender(this.__render,this.delay)}}else this.__debounceRender(this.__render,this.delay)}__itemsChanged(t){this.items&&!Array.isArray(this.items)&&console.warn("dom-repeat expected array for `items`, found",this.items),this.__handleItemPath(t.path,t.value)||("items"===t.path&&(this.__itemsArrayChanged=!0),this.__debounceRender(this.__render))}__debounceRender(t,e=0){this.__renderDebouncer=Tn.debounce(this.__renderDebouncer,e>0?gt.after(e):vt,t.bind(this)),An(this.__renderDebouncer)}render(){this.__debounceRender(this.__render),Di()}__render(){if(!this.__ensureTemplatized())return;let t=this.items||[];const e=this.__sortAndFilterItems(t),n=this.__calculateLimit(e.length);this.__updateInstances(t,n,e),this.initialCount&&(this.__shouldMeasureChunk||this.__shouldContinueChunking)&&(cancelAnimationFrame(this.__chunkingId),this.__chunkingId=requestAnimationFrame((()=>this.__continueChunking()))),this._setRenderedItemCount(this.__instances.length),k&&!this.notifyDomChange||this.dispatchEvent(new CustomEvent("dom-change",{bubbles:!0,composed:!0}))}__sortAndFilterItems(t){let e=new Array(t.length);for(let n=0;n<t.length;n++)e[n]=n;return this.__filterFn&&(e=e.filter(((e,n,i)=>this.__filterFn(t[e],n,i)))),this.__sortFn&&e.sort(((e,n)=>this.__sortFn(t[e],t[n]))),e}__calculateLimit(t){let e=t;const n=this.__instances.length;if(this.initialCount){let i;!this.__chunkCount||this.__itemsArrayChanged&&!this.reuseChunkedInstances?(e=Math.min(t,this.initialCount),i=Math.max(e-n,0),this.__chunkCount=i||1):(i=Math.min(Math.max(t-n,0),this.__chunkCount),e=Math.min(n+i,t)),this.__shouldMeasureChunk=i===this.__chunkCount,this.__shouldContinueChunking=e<t,this.__renderStartTime=performance.now()}return this.__itemsArrayChanged=!1,e}__continueChunking(){if(this.__shouldMeasureChunk){const t=performance.now()-this.__renderStartTime;this.__chunkCount=Math.round(this.__chunkCount*(this._targetFrameTime/t))||1}this.__shouldContinueChunking&&this.__debounceRender(this.__render)}__updateInstances(t,e,n){const i=this.__itemsIdxToInstIdx={};let r;for(r=0;r<e;r++){let e=this.__instances[r],o=n[r],a=t[o];i[o]=r,e?(e._setPendingProperty(this.as,a),e._setPendingProperty(this.indexAs,r),e._setPendingProperty(this.itemsIndexAs,o),e._flushProperties()):this.__insertInstance(a,r,o)}for(let t=this.__instances.length-1;t>=r;t--)this.__detachAndRemoveInstance(t)}__detachInstance(t){let e=this.__instances[t];const n=Y(e.root);for(let t=0;t<e.children.length;t++)n.appendChild(e.children[t]);return e}__attachInstance(t,e){e.insertBefore(this.__instances[t].root,this)}__detachAndRemoveInstance(t){this.__detachInstance(t),this.__instances.splice(t,1)}__stampInstance(t,e,n){let i={};return i[this.as]=t,i[this.indexAs]=e,i[this.itemsIndexAs]=n,new this.__ctor(i)}__insertInstance(t,e,n){const i=this.__stampInstance(t,e,n);let r=this.__instances[e+1],o=r?r.children[0]:this;return Y(Y(this).parentNode).insertBefore(i.root,o),this.__instances[e]=i,i}_showHideChildren(t){for(let e=0;e<this.__instances.length;e++)this.__instances[e]._showHideChildren(t)}__handleItemPath(t,e){let n=t.slice(6),i=n.indexOf("."),r=i<0?n:n.substring(0,i);if(r==parseInt(r,10)){let t=i<0?"":n.substring(i+1);this.__handleObservedPaths(t);let o=this.__instances[this.__itemsIdxToInstIdx[r]];return o&&(o._setPendingPropertyOrPath(this.as+(t?"."+t:""),e,!1,!0),o._flushProperties()),!0}}itemForElement(t){let e=this.modelForElement(t);return e&&e[this.as]}indexForElement(t){let e=this.modelForElement(t);return e&&e[this.indexAs]}modelForElement(t){return Kr(this.template,t)}}customElements.define(no.is,no);
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
class io extends ye{static get is(){return"dom-if"}static get template(){return null}static get properties(){return{if:{type:Boolean,observer:"__debounceRender"},restamp:{type:Boolean,observer:"__debounceRender"},notifyDomChange:{type:Boolean}}}constructor(){super(),this.__renderDebouncer=null,this._lastIf=!1,this.__hideTemplateChildren__=!1}__debounceRender(){this.__renderDebouncer=Tn.debounce(this.__renderDebouncer,vt,(()=>this.__render())),An(this.__renderDebouncer)}disconnectedCallback(){super.disconnectedCallback();const t=Y(this).parentNode;t&&(t.nodeType!=Node.DOCUMENT_FRAGMENT_NODE||Y(t).host)||this.__teardownInstance()}connectedCallback(){super.connectedCallback(),Qr()||(this.style.display="none"),this.if&&this.__debounceRender()}__ensureTemplate(){if(!this.__template){const t=this;let e=t._templateInfo?t:Y(t).querySelector("template");if(!e){let t=new MutationObserver((()=>{if(!Y(this).querySelector("template"))throw new Error("dom-if requires a <template> child");t.disconnect(),this.__render()}));return t.observe(this,{childList:!0}),!1}this.__template=e}return!0}__ensureInstance(){let t=Y(this).parentNode;if(this.__hasInstance()){let e=this.__getInstanceNodes();if(e&&e.length&&Y(this).previousSibling!==e[e.length-1])for(let n,i=0;i<e.length&&(n=e[i]);i++)Y(t).insertBefore(n,this)}else{if(!t)return!1;if(!this.__ensureTemplate())return!1;this.__createAndInsertInstance(t)}return!0}render(){Di()}__render(){if(this.if){if(!this.__ensureInstance())return}else this.restamp&&this.__teardownInstance();this._showHideChildren(),k&&!this.notifyDomChange||this.if==this._lastIf||(this.dispatchEvent(new CustomEvent("dom-change",{bubbles:!0,composed:!0})),this._lastIf=this.if)}__hasInstance(){}__getInstanceNodes(){}__createAndInsertInstance(t){}__teardownInstance(){}_showHideChildren(){}}const ro=A?class extends io{constructor(){super(),this.__instance=null,this.__syncInfo=null}__hasInstance(){return Boolean(this.__instance)}__getInstanceNodes(){return this.__instance.templateInfo.childNodes}__createAndInsertInstance(t){const e=this.__dataHost||this;if(b&&!this.__dataHost)throw new Error("strictTemplatePolicy: template owner not trusted");const n=e._bindTemplate(this.__template,!0);n.runEffects=(t,e,n)=>{let i=this.__syncInfo;if(this.if)i&&(this.__syncInfo=null,this._showHideChildren(),e=Object.assign(i.changedProps,e)),t(e,n);else if(this.__instance)if(i||(i=this.__syncInfo={runEffects:t,changedProps:{}}),n)for(const t in e){const e=$(t);i.changedProps[e]=this.__dataHost[e]}else Object.assign(i.changedProps,e)},this.__instance=e._stampTemplate(this.__template,n),Y(t).insertBefore(this.__instance,this)}__syncHostProperties(){const t=this.__syncInfo;t&&(this.__syncInfo=null,t.runEffects(t.changedProps,!1))}__teardownInstance(){this.__instance&&((this.__dataHost||this)._removeBoundDom(this.__instance),this.__instance=null,this.__syncInfo=null)}_showHideChildren(){const t=this.__hideTemplateChildren__||!this.if;this.__instance&&Boolean(this.__instance.__hidden)!==t&&(this.__instance.__hidden=t,jr(t,this.__instance.templateInfo.childNodes)),t||this.__syncHostProperties()}}:class extends io{constructor(){super(),this.__ctor=null,this.__instance=null,this.__invalidProps=null}__hasInstance(){return Boolean(this.__instance)}__getInstanceNodes(){return this.__instance.children}__createAndInsertInstance(t){this.__ctor||(this.__ctor=$r(this.__template,this,{mutableData:!0,forwardHostProp:function(t,e){this.__instance&&(this.if?this.__instance.forwardHostProp(t,e):(this.__invalidProps=this.__invalidProps||Object.create(null),this.__invalidProps[$(t)]=!0))}})),this.__instance=new this.__ctor,Y(t).insertBefore(this.__instance.root,this)}__teardownInstance(){if(this.__instance){let t=this.__instance.children;if(t&&t.length){let e=Y(t[0]).parentNode;if(e){e=Y(e);for(let n,i=0;i<t.length&&(n=t[i]);i++)e.removeChild(n)}}this.__invalidProps=null,this.__instance=null}}__syncHostProperties(){let t=this.__invalidProps;if(t){this.__invalidProps=null;for(let e in t)this.__instance._setPendingProperty(e,this.__dataHost[e]);this.__instance._flushProperties()}}_showHideChildren(){const t=this.__hideTemplateChildren__||!this.if;this.__instance&&Boolean(this.__instance.__hidden)!==t&&(this.__instance.__hidden=t,this.__instance._showHideChildren(t)),t||this.__syncHostProperties()}};customElements.define(ro.is,ro);
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
let oo=I((t=>{let e=me(t);return class extends e{static get properties(){return{items:{type:Array},multi:{type:Boolean,value:!1},selected:{type:Object,notify:!0},selectedItem:{type:Object,notify:!0},toggle:{type:Boolean,value:!1}}}static get observers(){return["__updateSelection(multi, items.*)"]}constructor(){super(),this.__lastItems=null,this.__lastMulti=null,this.__selectedMap=null}__updateSelection(t,e){let n=e.path;if(n==JSCompiler_renameProperty("items",this)){let n=e.base||[],i=this.__lastItems;if(t!==this.__lastMulti&&this.clearSelection(),i){let t=Ii(n,i);this.__applySplices(t)}this.__lastItems=n,this.__lastMulti=t}else if(e.path==`${JSCompiler_renameProperty("items",this)}.splices`)this.__applySplices(e.value.indexSplices);else{let t=n.slice(`${JSCompiler_renameProperty("items",this)}.`.length),e=parseInt(t,10);t.indexOf(".")<0&&t==e&&this.__deselectChangedIdx(e)}}__applySplices(t){let e=this.__selectedMap;for(let n=0;n<t.length;n++){let i=t[n];e.forEach(((t,n)=>{t<i.index||e.set(n,t>=i.index+i.removed.length?t+i.addedCount-i.removed.length:-1)}));for(let t=0;t<i.addedCount;t++){let n=i.index+t;e.has(this.items[n])&&e.set(this.items[n],n)}}this.__updateLinks();let n=0;e.forEach(((t,i)=>{t<0?(this.multi?this.splice(JSCompiler_renameProperty("selected",this),n,1):this.selected=this.selectedItem=null,e.delete(i)):n++}))}__updateLinks(){if(this.__dataLinkedPaths={},this.multi){let t=0;this.__selectedMap.forEach((e=>{e>=0&&this.linkPaths(`${JSCompiler_renameProperty("items",this)}.${e}`,`${JSCompiler_renameProperty("selected",this)}.${t++}`)}))}else this.__selectedMap.forEach((t=>{this.linkPaths(JSCompiler_renameProperty("selected",this),`${JSCompiler_renameProperty("items",this)}.${t}`),this.linkPaths(JSCompiler_renameProperty("selectedItem",this),`${JSCompiler_renameProperty("items",this)}.${t}`)}))}clearSelection(){this.__dataLinkedPaths={},this.__selectedMap=new Map,this.selected=this.multi?[]:null,this.selectedItem=null}isSelected(t){return this.__selectedMap.has(t)}isIndexSelected(t){return this.isSelected(this.items[t])}__deselectChangedIdx(t){let e=this.__selectedIndexForItemIndex(t);if(e>=0){let t=0;this.__selectedMap.forEach(((n,i)=>{e==t++&&this.deselect(i)}))}}__selectedIndexForItemIndex(t){let e=this.__dataLinkedPaths[`${JSCompiler_renameProperty("items",this)}.${t}`];if(e)return parseInt(e.slice(`${JSCompiler_renameProperty("selected",this)}.`.length),10)}deselect(t){let e=this.__selectedMap.get(t);if(e>=0){let n;this.__selectedMap.delete(t),this.multi&&(n=this.__selectedIndexForItemIndex(e)),this.__updateLinks(),this.multi?this.splice(JSCompiler_renameProperty("selected",this),n,1):this.selected=this.selectedItem=null}}deselectIndex(t){this.deselect(this.items[t])}select(t){this.selectIndex(this.items.indexOf(t))}selectIndex(t){let e=this.items[t];this.isSelected(e)?this.toggle&&this.deselectIndex(t):(this.multi||this.__selectedMap.clear(),this.__selectedMap.set(e,t),this.__updateLinks(),this.multi?this.push(JSCompiler_renameProperty("selected",this),e):this.selected=this.selectedItem=e)}}}))(ye);class ao extends oo{static get is(){return"array-selector"}static get template(){return null}}customElements.define(ao.is,ao);
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
const so=new Sn;window.ShadyCSS||(window.ShadyCSS={prepareTemplate(t,e,n){},prepareTemplateDom(t,e){},prepareTemplateStyles(t,e,n){},styleSubtree(t,e){so.processStyles(),Qe(t,e)},styleElement(t){so.processStyles()},styleDocument(t){so.processStyles(),Qe(document.body,t)},getComputedStyleValue:(t,e)=>tn(t,e),flushCustomStyles(){},nativeCss:ke,nativeShadow:Me,cssBuild:Te,disableRuntime:Ae}),window.ShadyCSS.CustomStyleInterface=so;
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
const lo="include",co=window.ShadyCSS.CustomStyleInterface;class uo extends HTMLElement{constructor(){super(),this._style=null,co.addCustomStyle(this)}getStyle(){if(this._style)return this._style;const t=this.querySelector("style");if(!t)return null;this._style=t;const e=t.getAttribute(lo);return e&&(t.removeAttribute(lo),t.textContent=(function n(t){let e=t.trim().split(/\s+/),n="";for(let t=0;t<e.length;t++)n+=q(e[t]);return n})(e)+t.textContent),this.ownerDocument!==window.document&&window.document.head.appendChild(this),this._style}}
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
let ho;window.customElements.define("custom-style",uo),ho=zr._mutablePropertyChange;const po={properties:{mutableData:Boolean},_shouldPropertyChange(t,e,n){return ho(this,t,e,n,this.mutableData)}},fo=er(HTMLElement).prototype;
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
var mo=new Set;const go={properties:{_parentResizable:{type:Object,observer:"_parentResizableChanged"},_notifyingDescendant:{type:Boolean,value:!1}},listeners:{"iron-request-resize-notifications":"_onIronRequestResizeNotifications"},created:function(){this._interestedResizables=[],this._boundNotifyResize=this.notifyResize.bind(this),this._boundOnDescendantIronResize=this._onDescendantIronResize.bind(this)},attached:function(){this._requestResizeNotifications()},detached:function(){this._parentResizable?this._parentResizable.stopResizeNotificationsFor(this):(mo.delete(this),window.removeEventListener("resize",this._boundNotifyResize)),this._parentResizable=null},notifyResize:function(){this.isAttached&&(this._interestedResizables.forEach((function(t){this.resizerShouldNotify(t)&&this._notifyDescendant(t)}),this),this._fireResize())},assignParentResizable:function(t){this._parentResizable&&this._parentResizable.stopResizeNotificationsFor(this),this._parentResizable=t,t&&-1===t._interestedResizables.indexOf(this)&&(t._interestedResizables.push(this),t._subscribeIronResize(this))},stopResizeNotificationsFor:function(t){var e=this._interestedResizables.indexOf(t);e>-1&&(this._interestedResizables.splice(e,1),this._unsubscribeIronResize(t))},_subscribeIronResize:function(t){t.addEventListener("iron-resize",this._boundOnDescendantIronResize)},_unsubscribeIronResize:function(t){t.removeEventListener("iron-resize",this._boundOnDescendantIronResize)},resizerShouldNotify:function(t){return!0},_onDescendantIronResize:function(t){this._notifyingDescendant?t.stopPropagation():m||this._fireResize()},_fireResize:function(){this.fire("iron-resize",null,{node:this,bubbles:!1})},_onIronRequestResizeNotifications:function(t){var e=Yi(t).rootTarget;e!==this&&(e.assignParentResizable(this),this._notifyDescendant(e),t.stopPropagation())},_parentResizableChanged:function(t){t&&window.removeEventListener("resize",this._boundNotifyResize)},_notifyDescendant:function(t){this.isAttached&&(this._notifyingDescendant=!0,t.notifyResize(),this._notifyingDescendant=!1)},_requestResizeNotifications:function(){if(this.isAttached)if("loading"===document.readyState){var t=this._requestResizeNotifications.bind(this);document.addEventListener("readystatechange",(function e(){document.removeEventListener("readystatechange",e),t()}))}else this._findParent(),this._parentResizable?this._parentResizable._interestedResizables.forEach((function(t){t!==this&&t._findParent()}),this):(mo.forEach((function(t){t!==this&&t._findParent()}),this),window.addEventListener("resize",this._boundNotifyResize),this.notifyResize())},_findParent:function(){this.assignParentResizable(null),this.fire("iron-request-resize-notifications",null,{node:this,bubbles:!0,cancelable:!0}),this._parentResizable?mo.delete(this):mo.add(this)}};var _o=Object.freeze({__proto__:null,IronResizableBehavior:go});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */Rr({_template:_e`
    <style>
      :host {
        display: block;
        transition-duration: var(--iron-collapse-transition-duration, 300ms);
        /* Safari 10 needs this property prefixed to correctly apply the custom property */
        -webkit-transition-duration: var(--iron-collapse-transition-duration, 300ms);
        overflow: visible;
      }

      :host(.iron-collapse-closed) {
        display: none;
      }

      :host(:not(.iron-collapse-opened)) {
        overflow: hidden;
      }
    </style>

    <slot></slot>
`,is:"iron-collapse",behaviors:[go],properties:{horizontal:{type:Boolean,value:!1,observer:"_horizontalChanged"},opened:{type:Boolean,value:!1,notify:!0,observer:"_openedChanged"},transitioning:{type:Boolean,notify:!0,readOnly:!0},noAnimation:{type:Boolean},_desiredSize:{type:String,value:""}},get dimension(){return this.horizontal?"width":"height"},get _dimensionMax(){return this.horizontal?"maxWidth":"maxHeight"},get _dimensionMaxCss(){return this.horizontal?"max-width":"max-height"},hostAttributes:{role:"group","aria-hidden":"true"},listeners:{transitionend:"_onTransitionEnd"},toggle:function(){this.opened=!this.opened},show:function(){this.opened=!0},hide:function(){this.opened=!1},updateSize:function(t,e){t="auto"===t?"":t;var n=e&&!this.noAnimation&&this.isAttached&&this._desiredSize!==t;if(this._desiredSize=t,this._updateTransition(!1),n){var i=this._calcSize();""===t&&(this.style[this._dimensionMax]="",t=this._calcSize()),this.style[this._dimensionMax]=i,this.scrollTop=this.scrollTop,this._updateTransition(!0),n=t!==i}this.style[this._dimensionMax]=t,n||this._transitionEnd()},enableTransition:function(t){fo._warn("`enableTransition()` is deprecated, use `noAnimation` instead."),this.noAnimation=!t},_updateTransition:function(t){this.style.transitionDuration=t&&!this.noAnimation?"":"0s"},_horizontalChanged:function(){this.style.transitionProperty=this._dimensionMaxCss,this.style["maxWidth"===this._dimensionMax?"maxHeight":"maxWidth"]="",this.updateSize(this.opened?"auto":"0px",!1)},_openedChanged:function(){this.setAttribute("aria-hidden",!this.opened),this._setTransitioning(!0),this.toggleClass("iron-collapse-closed",!1),this.toggleClass("iron-collapse-opened",!1),this.updateSize(this.opened?"auto":"0px",!0),this.opened&&this.focus()},_transitionEnd:function(){this.style[this._dimensionMax]=this._desiredSize,this.toggleClass("iron-collapse-closed",!this.opened),this.toggleClass("iron-collapse-opened",this.opened),this._updateTransition(!1),this.notifyResize(),this._setTransitioning(!1)},_onTransitionEnd:function(t){Yi(t).rootTarget===this&&this._transitionEnd()},_calcSize:function(){return this.getBoundingClientRect()[this.dimension]+"px"}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const yo=_e`
/* Most common used flex styles*/
<dom-module id="iron-flex">
  <template>
    <style>
      .layout.horizontal,
      .layout.vertical {
        display: -ms-flexbox;
        display: -webkit-flex;
        display: flex;
      }

      .layout.inline {
        display: -ms-inline-flexbox;
        display: -webkit-inline-flex;
        display: inline-flex;
      }

      .layout.horizontal {
        -ms-flex-direction: row;
        -webkit-flex-direction: row;
        flex-direction: row;
      }

      .layout.vertical {
        -ms-flex-direction: column;
        -webkit-flex-direction: column;
        flex-direction: column;
      }

      .layout.wrap {
        -ms-flex-wrap: wrap;
        -webkit-flex-wrap: wrap;
        flex-wrap: wrap;
      }

      .layout.no-wrap {
        -ms-flex-wrap: nowrap;
        -webkit-flex-wrap: nowrap;
        flex-wrap: nowrap;
      }

      .layout.center,
      .layout.center-center {
        -ms-flex-align: center;
        -webkit-align-items: center;
        align-items: center;
      }

      .layout.center-justified,
      .layout.center-center {
        -ms-flex-pack: center;
        -webkit-justify-content: center;
        justify-content: center;
      }

      .flex {
        -ms-flex: 1 1 0.000000001px;
        -webkit-flex: 1;
        flex: 1;
        -webkit-flex-basis: 0.000000001px;
        flex-basis: 0.000000001px;
      }

      .flex-auto {
        -ms-flex: 1 1 auto;
        -webkit-flex: 1 1 auto;
        flex: 1 1 auto;
      }

      .flex-none {
        -ms-flex: none;
        -webkit-flex: none;
        flex: none;
      }
    </style>
  </template>
</dom-module>
/* Basic flexbox reverse styles */
<dom-module id="iron-flex-reverse">
  <template>
    <style>
      .layout.horizontal-reverse,
      .layout.vertical-reverse {
        display: -ms-flexbox;
        display: -webkit-flex;
        display: flex;
      }

      .layout.horizontal-reverse {
        -ms-flex-direction: row-reverse;
        -webkit-flex-direction: row-reverse;
        flex-direction: row-reverse;
      }

      .layout.vertical-reverse {
        -ms-flex-direction: column-reverse;
        -webkit-flex-direction: column-reverse;
        flex-direction: column-reverse;
      }

      .layout.wrap-reverse {
        -ms-flex-wrap: wrap-reverse;
        -webkit-flex-wrap: wrap-reverse;
        flex-wrap: wrap-reverse;
      }
    </style>
  </template>
</dom-module>
/* Flexbox alignment */
<dom-module id="iron-flex-alignment">
  <template>
    <style>
      /**
       * Alignment in cross axis.
       */
      .layout.start {
        -ms-flex-align: start;
        -webkit-align-items: flex-start;
        align-items: flex-start;
      }

      .layout.center,
      .layout.center-center {
        -ms-flex-align: center;
        -webkit-align-items: center;
        align-items: center;
      }

      .layout.end {
        -ms-flex-align: end;
        -webkit-align-items: flex-end;
        align-items: flex-end;
      }

      .layout.baseline {
        -ms-flex-align: baseline;
        -webkit-align-items: baseline;
        align-items: baseline;
      }

      /**
       * Alignment in main axis.
       */
      .layout.start-justified {
        -ms-flex-pack: start;
        -webkit-justify-content: flex-start;
        justify-content: flex-start;
      }

      .layout.center-justified,
      .layout.center-center {
        -ms-flex-pack: center;
        -webkit-justify-content: center;
        justify-content: center;
      }

      .layout.end-justified {
        -ms-flex-pack: end;
        -webkit-justify-content: flex-end;
        justify-content: flex-end;
      }

      .layout.around-justified {
        -ms-flex-pack: distribute;
        -webkit-justify-content: space-around;
        justify-content: space-around;
      }

      .layout.justified {
        -ms-flex-pack: justify;
        -webkit-justify-content: space-between;
        justify-content: space-between;
      }

      /**
       * Self alignment.
       */
      .self-start {
        -ms-align-self: flex-start;
        -webkit-align-self: flex-start;
        align-self: flex-start;
      }

      .self-center {
        -ms-align-self: center;
        -webkit-align-self: center;
        align-self: center;
      }

      .self-end {
        -ms-align-self: flex-end;
        -webkit-align-self: flex-end;
        align-self: flex-end;
      }

      .self-stretch {
        -ms-align-self: stretch;
        -webkit-align-self: stretch;
        align-self: stretch;
      }

      .self-baseline {
        -ms-align-self: baseline;
        -webkit-align-self: baseline;
        align-self: baseline;
      }

      /**
       * multi-line alignment in main axis.
       */
      .layout.start-aligned {
        -ms-flex-line-pack: start;  /* IE10 */
        -ms-align-content: flex-start;
        -webkit-align-content: flex-start;
        align-content: flex-start;
      }

      .layout.end-aligned {
        -ms-flex-line-pack: end;  /* IE10 */
        -ms-align-content: flex-end;
        -webkit-align-content: flex-end;
        align-content: flex-end;
      }

      .layout.center-aligned {
        -ms-flex-line-pack: center;  /* IE10 */
        -ms-align-content: center;
        -webkit-align-content: center;
        align-content: center;
      }

      .layout.between-aligned {
        -ms-flex-line-pack: justify;  /* IE10 */
        -ms-align-content: space-between;
        -webkit-align-content: space-between;
        align-content: space-between;
      }

      .layout.around-aligned {
        -ms-flex-line-pack: distribute;  /* IE10 */
        -ms-align-content: space-around;
        -webkit-align-content: space-around;
        align-content: space-around;
      }
    </style>
  </template>
</dom-module>
/* Non-flexbox positioning helper styles */
<dom-module id="iron-flex-factors">
  <template>
    <style>
      .flex,
      .flex-1 {
        -ms-flex: 1 1 0.000000001px;
        -webkit-flex: 1;
        flex: 1;
        -webkit-flex-basis: 0.000000001px;
        flex-basis: 0.000000001px;
      }

      .flex-2 {
        -ms-flex: 2;
        -webkit-flex: 2;
        flex: 2;
      }

      .flex-3 {
        -ms-flex: 3;
        -webkit-flex: 3;
        flex: 3;
      }

      .flex-4 {
        -ms-flex: 4;
        -webkit-flex: 4;
        flex: 4;
      }

      .flex-5 {
        -ms-flex: 5;
        -webkit-flex: 5;
        flex: 5;
      }

      .flex-6 {
        -ms-flex: 6;
        -webkit-flex: 6;
        flex: 6;
      }

      .flex-7 {
        -ms-flex: 7;
        -webkit-flex: 7;
        flex: 7;
      }

      .flex-8 {
        -ms-flex: 8;
        -webkit-flex: 8;
        flex: 8;
      }

      .flex-9 {
        -ms-flex: 9;
        -webkit-flex: 9;
        flex: 9;
      }

      .flex-10 {
        -ms-flex: 10;
        -webkit-flex: 10;
        flex: 10;
      }

      .flex-11 {
        -ms-flex: 11;
        -webkit-flex: 11;
        flex: 11;
      }

      .flex-12 {
        -ms-flex: 12;
        -webkit-flex: 12;
        flex: 12;
      }
    </style>
  </template>
</dom-module>
<dom-module id="iron-positioning">
  <template>
    <style>
      .block {
        display: block;
      }

      [hidden] {
        display: none !important;
      }

      .invisible {
        visibility: hidden !important;
      }

      .relative {
        position: relative;
      }

      .fit {
        position: absolute;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
      }

      body.fullbleed {
        margin: 0;
        height: 100vh;
      }

      .scroll {
        -webkit-overflow-scrolling: touch;
        overflow: auto;
      }

      /* fixed position */
      .fixed-bottom,
      .fixed-left,
      .fixed-right,
      .fixed-top {
        position: fixed;
      }

      .fixed-top {
        top: 0;
        left: 0;
        right: 0;
      }

      .fixed-right {
        top: 0;
        right: 0;
        bottom: 0;
      }

      .fixed-bottom {
        right: 0;
        bottom: 0;
        left: 0;
      }

      .fixed-left {
        top: 0;
        bottom: 0;
        left: 0;
      }
    </style>
  </template>
</dom-module>
`;yo.setAttribute("style","display: none;"),document.head.appendChild(yo.content);
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const vo=_e`
<custom-style>
  <style is="custom-style">
    [hidden] {
      display: none !important;
    }
  </style>
</custom-style>
<custom-style>
  <style is="custom-style">
    html {

      --layout: {
        display: -ms-flexbox;
        display: -webkit-flex;
        display: flex;
      };

      --layout-inline: {
        display: -ms-inline-flexbox;
        display: -webkit-inline-flex;
        display: inline-flex;
      };

      --layout-horizontal: {
        @apply --layout;

        -ms-flex-direction: row;
        -webkit-flex-direction: row;
        flex-direction: row;
      };

      --layout-horizontal-reverse: {
        @apply --layout;

        -ms-flex-direction: row-reverse;
        -webkit-flex-direction: row-reverse;
        flex-direction: row-reverse;
      };

      --layout-vertical: {
        @apply --layout;

        -ms-flex-direction: column;
        -webkit-flex-direction: column;
        flex-direction: column;
      };

      --layout-vertical-reverse: {
        @apply --layout;

        -ms-flex-direction: column-reverse;
        -webkit-flex-direction: column-reverse;
        flex-direction: column-reverse;
      };

      --layout-wrap: {
        -ms-flex-wrap: wrap;
        -webkit-flex-wrap: wrap;
        flex-wrap: wrap;
      };

      --layout-wrap-reverse: {
        -ms-flex-wrap: wrap-reverse;
        -webkit-flex-wrap: wrap-reverse;
        flex-wrap: wrap-reverse;
      };

      --layout-flex-auto: {
        -ms-flex: 1 1 auto;
        -webkit-flex: 1 1 auto;
        flex: 1 1 auto;
      };

      --layout-flex-none: {
        -ms-flex: none;
        -webkit-flex: none;
        flex: none;
      };

      --layout-flex: {
        -ms-flex: 1 1 0.000000001px;
        -webkit-flex: 1;
        flex: 1;
        -webkit-flex-basis: 0.000000001px;
        flex-basis: 0.000000001px;
      };

      --layout-flex-2: {
        -ms-flex: 2;
        -webkit-flex: 2;
        flex: 2;
      };

      --layout-flex-3: {
        -ms-flex: 3;
        -webkit-flex: 3;
        flex: 3;
      };

      --layout-flex-4: {
        -ms-flex: 4;
        -webkit-flex: 4;
        flex: 4;
      };

      --layout-flex-5: {
        -ms-flex: 5;
        -webkit-flex: 5;
        flex: 5;
      };

      --layout-flex-6: {
        -ms-flex: 6;
        -webkit-flex: 6;
        flex: 6;
      };

      --layout-flex-7: {
        -ms-flex: 7;
        -webkit-flex: 7;
        flex: 7;
      };

      --layout-flex-8: {
        -ms-flex: 8;
        -webkit-flex: 8;
        flex: 8;
      };

      --layout-flex-9: {
        -ms-flex: 9;
        -webkit-flex: 9;
        flex: 9;
      };

      --layout-flex-10: {
        -ms-flex: 10;
        -webkit-flex: 10;
        flex: 10;
      };

      --layout-flex-11: {
        -ms-flex: 11;
        -webkit-flex: 11;
        flex: 11;
      };

      --layout-flex-12: {
        -ms-flex: 12;
        -webkit-flex: 12;
        flex: 12;
      };

      /* alignment in cross axis */

      --layout-start: {
        -ms-flex-align: start;
        -webkit-align-items: flex-start;
        align-items: flex-start;
      };

      --layout-center: {
        -ms-flex-align: center;
        -webkit-align-items: center;
        align-items: center;
      };

      --layout-end: {
        -ms-flex-align: end;
        -webkit-align-items: flex-end;
        align-items: flex-end;
      };

      --layout-baseline: {
        -ms-flex-align: baseline;
        -webkit-align-items: baseline;
        align-items: baseline;
      };

      /* alignment in main axis */

      --layout-start-justified: {
        -ms-flex-pack: start;
        -webkit-justify-content: flex-start;
        justify-content: flex-start;
      };

      --layout-center-justified: {
        -ms-flex-pack: center;
        -webkit-justify-content: center;
        justify-content: center;
      };

      --layout-end-justified: {
        -ms-flex-pack: end;
        -webkit-justify-content: flex-end;
        justify-content: flex-end;
      };

      --layout-around-justified: {
        -ms-flex-pack: distribute;
        -webkit-justify-content: space-around;
        justify-content: space-around;
      };

      --layout-justified: {
        -ms-flex-pack: justify;
        -webkit-justify-content: space-between;
        justify-content: space-between;
      };

      --layout-center-center: {
        @apply --layout-center;
        @apply --layout-center-justified;
      };

      /* self alignment */

      --layout-self-start: {
        -ms-align-self: flex-start;
        -webkit-align-self: flex-start;
        align-self: flex-start;
      };

      --layout-self-center: {
        -ms-align-self: center;
        -webkit-align-self: center;
        align-self: center;
      };

      --layout-self-end: {
        -ms-align-self: flex-end;
        -webkit-align-self: flex-end;
        align-self: flex-end;
      };

      --layout-self-stretch: {
        -ms-align-self: stretch;
        -webkit-align-self: stretch;
        align-self: stretch;
      };

      --layout-self-baseline: {
        -ms-align-self: baseline;
        -webkit-align-self: baseline;
        align-self: baseline;
      };

      /* multi-line alignment in main axis */

      --layout-start-aligned: {
        -ms-flex-line-pack: start;  /* IE10 */
        -ms-align-content: flex-start;
        -webkit-align-content: flex-start;
        align-content: flex-start;
      };

      --layout-end-aligned: {
        -ms-flex-line-pack: end;  /* IE10 */
        -ms-align-content: flex-end;
        -webkit-align-content: flex-end;
        align-content: flex-end;
      };

      --layout-center-aligned: {
        -ms-flex-line-pack: center;  /* IE10 */
        -ms-align-content: center;
        -webkit-align-content: center;
        align-content: center;
      };

      --layout-between-aligned: {
        -ms-flex-line-pack: justify;  /* IE10 */
        -ms-align-content: space-between;
        -webkit-align-content: space-between;
        align-content: space-between;
      };

      --layout-around-aligned: {
        -ms-flex-line-pack: distribute;  /* IE10 */
        -ms-align-content: space-around;
        -webkit-align-content: space-around;
        align-content: space-around;
      };

      /*******************************
                Other Layout
      *******************************/

      --layout-block: {
        display: block;
      };

      --layout-invisible: {
        visibility: hidden !important;
      };

      --layout-relative: {
        position: relative;
      };

      --layout-fit: {
        position: absolute;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
      };

      --layout-scroll: {
        -webkit-overflow-scrolling: touch;
        overflow: auto;
      };

      --layout-fullbleed: {
        margin: 0;
        height: 100vh;
      };

      /* fixed position */

      --layout-fixed-top: {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
      };

      --layout-fixed-right: {
        position: fixed;
        top: 0;
        right: 0;
        bottom: 0;
      };

      --layout-fixed-bottom: {
        position: fixed;
        right: 0;
        bottom: 0;
        left: 0;
      };

      --layout-fixed-left: {
        position: fixed;
        top: 0;
        bottom: 0;
        left: 0;
      };

    }
  </style>
</custom-style>`;vo.setAttribute("style","display: none;"),document.head.appendChild(vo.content);var bo=document.createElement("style");bo.textContent="[hidden] { display: none !important; }",document.head.appendChild(bo);
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
class xo{constructor(t){xo[" "](t),this.type=t&&t.type||"default",this.key=t&&t.key,t&&"value"in t&&(this.value=t.value)}get value(){var t=this.type,e=this.key;if(t&&e)return xo.types[t]&&xo.types[t][e]}set value(t){var e=this.type,n=this.key;e&&n&&(e=xo.types[e]=xo.types[e]||{},null==t?delete e[n]:e[n]=t)}get list(){if(this.type){var t=xo.types[this.type];return t?Object.keys(t).map((function(t){return wo[this.type][t]}),this):[]}}byKey(t){return this.key=t,this.value}}xo[" "]=function(){},xo.types={};var wo=xo.types;Rr({is:"iron-meta",properties:{type:{type:String,value:"default"},key:{type:String},value:{type:String,notify:!0},self:{type:Boolean,observer:"_selfChanged"},__meta:{type:Boolean,computed:"__computeMeta(type, key, value)"}},hostAttributes:{hidden:!0},__computeMeta:function(t,e,n){var i=new xo({type:t,key:e});return void 0!==n&&n!==i.value?i.value=n:this.value!==i.value&&(this.value=i.value),i},get list(){return this.__meta&&this.__meta.list},_selfChanged:function(t){t&&(this.value=this)},byKey:function(t){return new xo({type:this.type,key:t}).value}}),
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({_template:_e`
    <style>
      :host {
        @apply --layout-inline;
        @apply --layout-center-center;
        position: relative;

        vertical-align: middle;

        fill: var(--iron-icon-fill-color, currentcolor);
        stroke: var(--iron-icon-stroke-color, none);

        width: var(--iron-icon-width, 24px);
        height: var(--iron-icon-height, 24px);
        @apply --iron-icon;
      }

      :host([hidden]) {
        display: none;
      }
    </style>
`,is:"iron-icon",properties:{icon:{type:String},theme:{type:String},src:{type:String},_meta:{value:fo.create("iron-meta",{type:"iconset"})}},observers:["_updateIcon(_meta, isAttached)","_updateIcon(theme, isAttached)","_srcChanged(src, isAttached)","_iconChanged(icon, isAttached)"],_DEFAULT_ICONSET:"icons",_iconChanged:function(t){var e=(t||"").split(":");this._iconName=e.pop(),this._iconsetName=e.pop()||this._DEFAULT_ICONSET,this._updateIcon()},_srcChanged:function(t){this._updateIcon()},_usesIconset:function(){return this.icon||!this.src},_updateIcon:function(){this._usesIconset()?(this._img&&this._img.parentNode&&Yi(this.root).removeChild(this._img),""===this._iconName?this._iconset&&this._iconset.removeIcon(this):this._iconsetName&&this._meta&&(this._iconset=this._meta.byKey(this._iconsetName),this._iconset?(this._iconset.applyIcon(this,this._iconName,this.theme),this.unlisten(window,"iron-iconset-added","_updateIcon")):this.listen(window,"iron-iconset-added","_updateIcon"))):(this._iconset&&this._iconset.removeIcon(this),this._img||(this._img=document.createElement("img"),this._img.style.width="100%",this._img.style.height="100%",this._img.draggable=!1),this._img.src=this.src,Yi(this.root).appendChild(this._img))}}),
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({is:"iron-iconset-svg",properties:{name:{type:String,observer:"_nameChanged"},size:{type:Number,value:24},rtlMirroring:{type:Boolean,value:!1},useGlobalRtlAttribute:{type:Boolean,value:!1}},created:function(){this._meta=new xo({type:"iconset",key:null,value:null})},attached:function(){this.style.display="none"},getIconNames:function(){return this._icons=this._createIconMap(),Object.keys(this._icons).map((function(t){return this.name+":"+t}),this)},applyIcon:function(t,e){this.removeIcon(t);var n=this._cloneIcon(e,this.rtlMirroring&&this._targetIsRTL(t));if(n){var i=Yi(t.root||t);return i.insertBefore(n,i.childNodes[0]),t._svgIcon=n}return null},removeIcon:function(t){t._svgIcon&&(Yi(t.root||t).removeChild(t._svgIcon),t._svgIcon=null)},_targetIsRTL:function(t){if(null==this.__targetIsRTL)if(this.useGlobalRtlAttribute){var e=document.body&&document.body.hasAttribute("dir")?document.body:document.documentElement;this.__targetIsRTL="rtl"===e.getAttribute("dir")}else t&&t.nodeType!==Node.ELEMENT_NODE&&(t=t.host),this.__targetIsRTL=t&&"rtl"===window.getComputedStyle(t).direction;return this.__targetIsRTL},_nameChanged:function(){this._meta.value=null,this._meta.key=this.name,this._meta.value=this,this.async((function(){this.fire("iron-iconset-added",this,{node:window})}))},_createIconMap:function(){var t=Object.create(null);return Yi(this).querySelectorAll("[id]").forEach((function(e){t[e.id]=e})),t},_cloneIcon:function(t,e){return this._icons=this._icons||this._createIconMap(),this._prepareSvgClone(this._icons[t],this.size,e)},_prepareSvgClone:function(t,e,n){if(t){var i=t.cloneNode(!0),r=document.createElementNS("http://www.w3.org/2000/svg","svg"),o=i.getAttribute("viewBox")||"0 0 "+e+" "+e,a="pointer-events: none; display: block; width: 100%; height: 100%;";return n&&i.hasAttribute("mirror-in-rtl")&&(a+="-webkit-transform:scale(-1,1);transform:scale(-1,1);transform-origin:center;"),r.setAttribute("viewBox",o),r.setAttribute("preserveAspectRatio","xMidYMid meet"),r.setAttribute("focusable","false"),r.style.cssText=a,r.appendChild(i).removeAttribute("id"),r}return null}});
/**
    @license
    Copyright (c) 2014 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const So=_e`<iron-iconset-svg name="image" size="24">
<svg><defs>
<g id="add-a-photo"><path d="M3 4V1h2v3h3v2H5v3H3V6H0V4h3zm3 6V7h3V4h7l1.83 2H21c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H5c-1.1 0-2-.9-2-2V10h3zm7 9c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm-3.2-5c0 1.77 1.43 3.2 3.2 3.2s3.2-1.43 3.2-3.2-1.43-3.2-3.2-3.2-3.2 1.43-3.2 3.2z"></path></g>
<g id="add-to-photos"><path d="M4 6H2v14c0 1.1.9 2 2 2h14v-2H4V6zm16-4H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-1 9h-4v4h-2v-4H9V9h4V5h2v4h4v2z"></path></g>
<g id="adjust"><path d="M12 2C6.49 2 2 6.49 2 12s4.49 10 10 10 10-4.49 10-10S17.51 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm3-8c0 1.66-1.34 3-3 3s-3-1.34-3-3 1.34-3 3-3 3 1.34 3 3z"></path></g>
<g id="assistant"><path d="M19 2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h4l3 3 3-3h4c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-5.12 10.88L12 17l-1.88-4.12L6 11l4.12-1.88L12 5l1.88 4.12L18 11l-4.12 1.88z"></path></g>
<g id="assistant-photo"><path d="M14.4 6L14 4H5v17h2v-7h5.6l.4 2h7V6z"></path></g>
<g id="audiotrack"><path d="M12 3v9.28c-.47-.17-.97-.28-1.5-.28C8.01 12 6 14.01 6 16.5S8.01 21 10.5 21c2.31 0 4.2-1.75 4.45-4H15V6h4V3h-7z"></path></g>
<g id="blur-circular"><path d="M10 9c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0 4c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zM7 9.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm3 7c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm-3-3c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm3-6c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zM14 9c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0-1.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zm3 6c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm0-4c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zM12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm2-3.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm0-3.5c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1z"></path></g>
<g id="blur-linear"><path d="M5 17.5c.83 0 1.5-.67 1.5-1.5s-.67-1.5-1.5-1.5-1.5.67-1.5 1.5.67 1.5 1.5 1.5zM9 13c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm0-4c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zM3 21h18v-2H3v2zM5 9.5c.83 0 1.5-.67 1.5-1.5S5.83 6.5 5 6.5 3.5 7.17 3.5 8 4.17 9.5 5 9.5zm0 4c.83 0 1.5-.67 1.5-1.5s-.67-1.5-1.5-1.5-1.5.67-1.5 1.5.67 1.5 1.5 1.5zM9 17c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm8-.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zM3 3v2h18V3H3zm14 5.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zm0 4c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zM13 9c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm0 4c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm0 4c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1z"></path></g>
<g id="blur-off"><path d="M14 7c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm-.2 4.48l.2.02c.83 0 1.5-.67 1.5-1.5s-.67-1.5-1.5-1.5-1.5.67-1.5 1.5l.02.2c.09.67.61 1.19 1.28 1.28zM14 3.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zm-4 0c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zm11 7c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zM10 7c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm8 8c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm0-4c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm0-4c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm-4 13.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zM2.5 5.27l3.78 3.78L6 9c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1c0-.1-.03-.19-.06-.28l2.81 2.81c-.71.11-1.25.73-1.25 1.47 0 .83.67 1.5 1.5 1.5.74 0 1.36-.54 1.47-1.25l2.81 2.81c-.09-.03-.18-.06-.28-.06-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1c0-.1-.03-.19-.06-.28l3.78 3.78L20 20.23 3.77 4 2.5 5.27zM10 17c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm11-3.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zM6 13c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zM3 9.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm7 11c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zM6 17c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm-3-3.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5z"></path></g>
<g id="blur-on"><path d="M6 13c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0 4c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0-8c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm-3 .5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zM6 5c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm15 5.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zM14 7c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm0-3.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zm-11 10c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm7 7c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm0-17c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zM10 7c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm0 5.5c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5-.67-1.5-1.5-1.5zm8 .5c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0 4c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0-8c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0-4c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm3 8.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zM14 17c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0 3.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm-4-12c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5-.67-1.5-1.5-1.5zm0 8.5c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm4-4.5c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5-.67-1.5-1.5-1.5zm0-4c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5-.67-1.5-1.5-1.5z"></path></g>
<g id="brightness-1"><circle cx="12" cy="12" r="10"></circle></g>
<g id="brightness-2"><path d="M10 2c-1.82 0-3.53.5-5 1.35C7.99 5.08 10 8.3 10 12s-2.01 6.92-5 8.65C6.47 21.5 8.18 22 10 22c5.52 0 10-4.48 10-10S15.52 2 10 2z"></path></g>
<g id="brightness-3"><path d="M9 2c-1.05 0-2.05.16-3 .46 4.06 1.27 7 5.06 7 9.54 0 4.48-2.94 8.27-7 9.54.95.3 1.95.46 3 .46 5.52 0 10-4.48 10-10S14.52 2 9 2z"></path></g>
<g id="brightness-4"><path d="M20 8.69V4h-4.69L12 .69 8.69 4H4v4.69L.69 12 4 15.31V20h4.69L12 23.31 15.31 20H20v-4.69L23.31 12 20 8.69zM12 18c-.89 0-1.74-.2-2.5-.55C11.56 16.5 13 14.42 13 12s-1.44-4.5-3.5-5.45C10.26 6.2 11.11 6 12 6c3.31 0 6 2.69 6 6s-2.69 6-6 6z"></path></g>
<g id="brightness-5"><path d="M20 15.31L23.31 12 20 8.69V4h-4.69L12 .69 8.69 4H4v4.69L.69 12 4 15.31V20h4.69L12 23.31 15.31 20H20v-4.69zM12 18c-3.31 0-6-2.69-6-6s2.69-6 6-6 6 2.69 6 6-2.69 6-6 6z"></path></g>
<g id="brightness-6"><path d="M20 15.31L23.31 12 20 8.69V4h-4.69L12 .69 8.69 4H4v4.69L.69 12 4 15.31V20h4.69L12 23.31 15.31 20H20v-4.69zM12 18V6c3.31 0 6 2.69 6 6s-2.69 6-6 6z"></path></g>
<g id="brightness-7"><path d="M20 8.69V4h-4.69L12 .69 8.69 4H4v4.69L.69 12 4 15.31V20h4.69L12 23.31 15.31 20H20v-4.69L23.31 12 20 8.69zM12 18c-3.31 0-6-2.69-6-6s2.69-6 6-6 6 2.69 6 6-2.69 6-6 6zm0-10c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4z"></path></g>
<g id="broken-image"><path d="M21 5v6.59l-3-3.01-4 4.01-4-4-4 4-3-3.01V5c0-1.1.9-2 2-2h14c1.1 0 2 .9 2 2zm-3 6.42l3 3.01V19c0 1.1-.9 2-2 2H5c-1.1 0-2-.9-2-2v-6.58l3 2.99 4-4 4 4 4-3.99z"></path></g>
<g id="brush"><path d="M7 14c-1.66 0-3 1.34-3 3 0 1.31-1.16 2-2 2 .92 1.22 2.49 2 4 2 2.21 0 4-1.79 4-4 0-1.66-1.34-3-3-3zm13.71-9.37l-1.34-1.34c-.39-.39-1.02-.39-1.41 0L9 12.25 11.75 15l8.96-8.96c.39-.39.39-1.02 0-1.41z"></path></g>
<g id="burst-mode"><path d="M1 5h2v14H1zm4 0h2v14H5zm17 0H10c-.55 0-1 .45-1 1v12c0 .55.45 1 1 1h12c.55 0 1-.45 1-1V6c0-.55-.45-1-1-1zM11 17l2.5-3.15L15.29 16l2.5-3.22L21 17H11z"></path></g>
<g id="camera"><path d="M9.4 10.5l4.77-8.26C13.47 2.09 12.75 2 12 2c-2.4 0-4.6.85-6.32 2.25l3.66 6.35.06-.1zM21.54 9c-.92-2.92-3.15-5.26-6-6.34L11.88 9h9.66zm.26 1h-7.49l.29.5 4.76 8.25C21 16.97 22 14.61 22 12c0-.69-.07-1.35-.2-2zM8.54 12l-3.9-6.75C3.01 7.03 2 9.39 2 12c0 .69.07 1.35.2 2h7.49l-1.15-2zm-6.08 3c.92 2.92 3.15 5.26 6 6.34L12.12 15H2.46zm11.27 0l-3.9 6.76c.7.15 1.42.24 2.17.24 2.4 0 4.6-.85 6.32-2.25l-3.66-6.35-.93 1.6z"></path></g>
<g id="camera-alt"><circle cx="12" cy="12" r="3.2"></circle><path d="M9 2L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2h-3.17L15 2H9zm3 15c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5z"></path></g>
<g id="camera-front"><path d="M10 20H5v2h5v2l3-3-3-3v2zm4 0v2h5v-2h-5zM12 8c1.1 0 2-.9 2-2s-.9-2-2-2-1.99.9-1.99 2S10.9 8 12 8zm5-8H7C5.9 0 5 .9 5 2v14c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V2c0-1.1-.9-2-2-2zM7 2h10v10.5c0-1.67-3.33-2.5-5-2.5s-5 .83-5 2.5V2z"></path></g>
<g id="camera-rear"><path d="M10 20H5v2h5v2l3-3-3-3v2zm4 0v2h5v-2h-5zm3-20H7C5.9 0 5 .9 5 2v14c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V2c0-1.1-.9-2-2-2zm-5 6c-1.11 0-2-.9-2-2s.89-2 1.99-2 2 .9 2 2C14 5.1 13.1 6 12 6z"></path></g>
<g id="camera-roll"><path d="M14 5c0-1.1-.9-2-2-2h-1V2c0-.55-.45-1-1-1H6c-.55 0-1 .45-1 1v1H4c-1.1 0-2 .9-2 2v15c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2h8V5h-8zm-2 13h-2v-2h2v2zm0-9h-2V7h2v2zm4 9h-2v-2h2v2zm0-9h-2V7h2v2zm4 9h-2v-2h2v2zm0-9h-2V7h2v2z"></path></g>
<g id="center-focus-strong"><path d="M12 8c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm-7 7H3v4c0 1.1.9 2 2 2h4v-2H5v-4zM5 5h4V3H5c-1.1 0-2 .9-2 2v4h2V5zm14-2h-4v2h4v4h2V5c0-1.1-.9-2-2-2zm0 16h-4v2h4c1.1 0 2-.9 2-2v-4h-2v4z"></path></g>
<g id="center-focus-weak"><path d="M5 15H3v4c0 1.1.9 2 2 2h4v-2H5v-4zM5 5h4V3H5c-1.1 0-2 .9-2 2v4h2V5zm14-2h-4v2h4v4h2V5c0-1.1-.9-2-2-2zm0 16h-4v2h4c1.1 0 2-.9 2-2v-4h-2v4zM12 8c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm0 6c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z"></path></g>
<g id="collections"><path d="M22 16V4c0-1.1-.9-2-2-2H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2zm-11-4l2.03 2.71L16 11l4 5H8l3-4zM2 6v14c0 1.1.9 2 2 2h14v-2H4V6H2z"></path></g>
<g id="collections-bookmark"><path d="M4 6H2v14c0 1.1.9 2 2 2h14v-2H4V6zm16-4H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 10l-2.5-1.5L15 12V4h5v8z"></path></g>
<g id="color-lens"><path d="M12 3c-4.97 0-9 4.03-9 9s4.03 9 9 9c.83 0 1.5-.67 1.5-1.5 0-.39-.15-.74-.39-1.01-.23-.26-.38-.61-.38-.99 0-.83.67-1.5 1.5-1.5H16c2.76 0 5-2.24 5-5 0-4.42-4.03-8-9-8zm-5.5 9c-.83 0-1.5-.67-1.5-1.5S5.67 9 6.5 9 8 9.67 8 10.5 7.33 12 6.5 12zm3-4C8.67 8 8 7.33 8 6.5S8.67 5 9.5 5s1.5.67 1.5 1.5S10.33 8 9.5 8zm5 0c-.83 0-1.5-.67-1.5-1.5S13.67 5 14.5 5s1.5.67 1.5 1.5S15.33 8 14.5 8zm3 4c-.83 0-1.5-.67-1.5-1.5S16.67 9 17.5 9s1.5.67 1.5 1.5-.67 1.5-1.5 1.5z"></path></g>
<g id="colorize"><path d="M20.71 5.63l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-3.12 3.12-1.93-1.91-1.41 1.41 1.42 1.42L3 16.25V21h4.75l8.92-8.92 1.42 1.42 1.41-1.41-1.92-1.92 3.12-3.12c.4-.4.4-1.03.01-1.42zM6.92 19L5 17.08l8.06-8.06 1.92 1.92L6.92 19z"></path></g>
<g id="compare"><path d="M10 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h5v2h2V1h-2v2zm0 15H5l5-6v6zm9-15h-5v2h5v13l-5-6v9h5c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2z"></path></g>
<g id="control-point"><path d="M13 7h-2v4H7v2h4v4h2v-4h4v-2h-4V7zm-1-5C6.49 2 2 6.49 2 12s4.49 10 10 10 10-4.49 10-10S17.51 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z"></path></g>
<g id="control-point-duplicate"><path d="M16 8h-2v3h-3v2h3v3h2v-3h3v-2h-3zM2 12c0-2.79 1.64-5.2 4.01-6.32V3.52C2.52 4.76 0 8.09 0 12s2.52 7.24 6.01 8.48v-2.16C3.64 17.2 2 14.79 2 12zm13-9c-4.96 0-9 4.04-9 9s4.04 9 9 9 9-4.04 9-9-4.04-9-9-9zm0 16c-3.86 0-7-3.14-7-7s3.14-7 7-7 7 3.14 7 7-3.14 7-7 7z"></path></g>
<g id="crop"><path d="M17 15h2V7c0-1.1-.9-2-2-2H9v2h8v8zM7 17V1H5v4H1v2h4v10c0 1.1.9 2 2 2h10v4h2v-4h4v-2H7z"></path></g>
<g id="crop-16-9"><path d="M19 6H5c-1.1 0-2 .9-2 2v8c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm0 10H5V8h14v8z"></path></g>
<g id="crop-3-2"><path d="M19 4H5c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 14H5V6h14v12z"></path></g>
<g id="crop-5-4"><path d="M19 5H5c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 12H5V7h14v10z"></path></g>
<g id="crop-7-5"><path d="M19 7H5c-1.1 0-2 .9-2 2v6c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V9c0-1.1-.9-2-2-2zm0 8H5V9h14v6z"></path></g>
<g id="crop-din"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V5h14v14z"></path></g>
<g id="crop-free"><path d="M3 5v4h2V5h4V3H5c-1.1 0-2 .9-2 2zm2 10H3v4c0 1.1.9 2 2 2h4v-2H5v-4zm14 4h-4v2h4c1.1 0 2-.9 2-2v-4h-2v4zm0-16h-4v2h4v4h2V5c0-1.1-.9-2-2-2z"></path></g>
<g id="crop-landscape"><path d="M19 5H5c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 12H5V7h14v10z"></path></g>
<g id="crop-original"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V5h14v14zm-5.04-6.71l-2.75 3.54-1.96-2.36L6.5 17h11l-3.54-4.71z"></path></g>
<g id="crop-portrait"><path d="M17 3H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H7V5h10v14z"></path></g>
<g id="crop-rotate"><path d="M7.47 21.49C4.2 19.93 1.86 16.76 1.5 13H0c.51 6.16 5.66 11 11.95 11 .23 0 .44-.02.66-.03L8.8 20.15l-1.33 1.34zM12.05 0c-.23 0-.44.02-.66.04l3.81 3.81 1.33-1.33C19.8 4.07 22.14 7.24 22.5 11H24c-.51-6.16-5.66-11-11.95-11zM16 14h2V8c0-1.11-.9-2-2-2h-6v2h6v6zm-8 2V4H6v2H4v2h2v8c0 1.1.89 2 2 2h8v2h2v-2h2v-2H8z"></path></g>
<g id="crop-square"><path d="M18 4H6c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 14H6V6h12v12z"></path></g>
<g id="dehaze"><path d="M2 15.5v2h20v-2H2zm0-5v2h20v-2H2zm0-5v2h20v-2H2z"></path></g>
<g id="details"><path d="M3 4l9 16 9-16H3zm3.38 2h11.25L12 16 6.38 6z"></path></g>
<g id="edit"><path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"></path></g>
<g id="exposure"><path d="M15 17v2h2v-2h2v-2h-2v-2h-2v2h-2v2h2zm5-15H4c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM5 5h6v2H5V5zm15 15H4L20 4v16z"></path></g>
<g id="exposure-neg-1"><path d="M4 11v2h8v-2H4zm15 7h-2V7.38L14 8.4V6.7L18.7 5h.3v13z"></path></g>
<g id="exposure-neg-2"><path d="M15.05 16.29l2.86-3.07c.38-.39.72-.79 1.04-1.18.32-.39.59-.78.82-1.17.23-.39.41-.78.54-1.17s.19-.79.19-1.18c0-.53-.09-1.02-.27-1.46-.18-.44-.44-.81-.78-1.11-.34-.31-.77-.54-1.26-.71-.51-.16-1.08-.24-1.72-.24-.69 0-1.31.11-1.85.32-.54.21-1 .51-1.36.88-.37.37-.65.8-.84 1.3-.18.47-.27.97-.28 1.5h2.14c.01-.31.05-.6.13-.87.09-.29.23-.54.4-.75.18-.21.41-.37.68-.49.27-.12.6-.18.96-.18.31 0 .58.05.81.15.23.1.43.25.59.43.16.18.28.4.37.65.08.25.13.52.13.81 0 .22-.03.43-.08.65-.06.22-.15.45-.29.7-.14.25-.32.53-.56.83-.23.3-.52.65-.88 1.03l-4.17 4.55V18H21v-1.71h-5.95zM2 11v2h8v-2H2z"></path></g>
<g id="exposure-plus-1"><path d="M10 7H8v4H4v2h4v4h2v-4h4v-2h-4V7zm10 11h-2V7.38L15 8.4V6.7L19.7 5h.3v13z"></path></g>
<g id="exposure-plus-2"><path d="M16.05 16.29l2.86-3.07c.38-.39.72-.79 1.04-1.18.32-.39.59-.78.82-1.17.23-.39.41-.78.54-1.17.13-.39.19-.79.19-1.18 0-.53-.09-1.02-.27-1.46-.18-.44-.44-.81-.78-1.11-.34-.31-.77-.54-1.26-.71-.51-.16-1.08-.24-1.72-.24-.69 0-1.31.11-1.85.32-.54.21-1 .51-1.36.88-.37.37-.65.8-.84 1.3-.18.47-.27.97-.28 1.5h2.14c.01-.31.05-.6.13-.87.09-.29.23-.54.4-.75.18-.21.41-.37.68-.49.27-.12.6-.18.96-.18.31 0 .58.05.81.15.23.1.43.25.59.43.16.18.28.4.37.65.08.25.13.52.13.81 0 .22-.03.43-.08.65-.06.22-.15.45-.29.7-.14.25-.32.53-.56.83-.23.3-.52.65-.88 1.03l-4.17 4.55V18H22v-1.71h-5.95zM8 7H6v4H2v2h4v4h2v-4h4v-2H8V7z"></path></g>
<g id="exposure-zero"><path d="M16.14 12.5c0 1-.1 1.85-.3 2.55-.2.7-.48 1.27-.83 1.7-.36.44-.79.75-1.3.95-.51.2-1.07.3-1.7.3-.62 0-1.18-.1-1.69-.3-.51-.2-.95-.51-1.31-.95-.36-.44-.65-1.01-.85-1.7-.2-.7-.3-1.55-.3-2.55v-2.04c0-1 .1-1.85.3-2.55.2-.7.48-1.26.84-1.69.36-.43.8-.74 1.31-.93C10.81 5.1 11.38 5 12 5c.63 0 1.19.1 1.7.29.51.19.95.5 1.31.93.36.43.64.99.84 1.69.2.7.3 1.54.3 2.55v2.04zm-2.11-2.36c0-.64-.05-1.18-.13-1.62-.09-.44-.22-.79-.4-1.06-.17-.27-.39-.46-.64-.58-.25-.13-.54-.19-.86-.19-.32 0-.61.06-.86.18s-.47.31-.64.58c-.17.27-.31.62-.4 1.06s-.13.98-.13 1.62v2.67c0 .64.05 1.18.14 1.62.09.45.23.81.4 1.09s.39.48.64.61.54.19.87.19c.33 0 .62-.06.87-.19s.46-.33.63-.61c.17-.28.3-.64.39-1.09.09-.45.13-.99.13-1.62v-2.66z"></path></g>
<g id="filter"><path d="M15.96 10.29l-2.75 3.54-1.96-2.36L8.5 15h11l-3.54-4.71zM3 5H1v16c0 1.1.9 2 2 2h16v-2H3V5zm18-4H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14z"></path></g>
<g id="filter-1"><path d="M3 5H1v16c0 1.1.9 2 2 2h16v-2H3V5zm11 10h2V5h-4v2h2v8zm7-14H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14z"></path></g>
<g id="filter-2"><path d="M3 5H1v16c0 1.1.9 2 2 2h16v-2H3V5zm18-4H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14zm-4-4h-4v-2h2c1.1 0 2-.89 2-2V7c0-1.11-.9-2-2-2h-4v2h4v2h-2c-1.1 0-2 .89-2 2v4h6v-2z"></path></g>
<g id="filter-3"><path d="M21 1H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14zM3 5H1v16c0 1.1.9 2 2 2h16v-2H3V5zm14 8v-1.5c0-.83-.67-1.5-1.5-1.5.83 0 1.5-.67 1.5-1.5V7c0-1.11-.9-2-2-2h-4v2h4v2h-2v2h2v2h-4v2h4c1.1 0 2-.89 2-2z"></path></g>
<g id="filter-4"><path d="M3 5H1v16c0 1.1.9 2 2 2h16v-2H3V5zm12 10h2V5h-2v4h-2V5h-2v6h4v4zm6-14H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14z"></path></g>
<g id="filter-5"><path d="M21 1H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14zM3 5H1v16c0 1.1.9 2 2 2h16v-2H3V5zm14 8v-2c0-1.11-.9-2-2-2h-2V7h4V5h-6v6h4v2h-4v2h4c1.1 0 2-.89 2-2z"></path></g>
<g id="filter-6"><path d="M3 5H1v16c0 1.1.9 2 2 2h16v-2H3V5zm18-4H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14zm-8-2h2c1.1 0 2-.89 2-2v-2c0-1.11-.9-2-2-2h-2V7h4V5h-4c-1.1 0-2 .89-2 2v6c0 1.11.9 2 2 2zm0-4h2v2h-2v-2z"></path></g>
<g id="filter-7"><path d="M3 5H1v16c0 1.1.9 2 2 2h16v-2H3V5zm18-4H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14zm-8-2l4-8V5h-6v2h4l-4 8h2z"></path></g>
<g id="filter-8"><path d="M3 5H1v16c0 1.1.9 2 2 2h16v-2H3V5zm18-4H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14zm-8-2h2c1.1 0 2-.89 2-2v-1.5c0-.83-.67-1.5-1.5-1.5.83 0 1.5-.67 1.5-1.5V7c0-1.11-.9-2-2-2h-2c-1.1 0-2 .89-2 2v1.5c0 .83.67 1.5 1.5 1.5-.83 0-1.5.67-1.5 1.5V13c0 1.11.9 2 2 2zm0-8h2v2h-2V7zm0 4h2v2h-2v-2z"></path></g>
<g id="filter-9"><path d="M3 5H1v16c0 1.1.9 2 2 2h16v-2H3V5zm18-4H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14zM15 5h-2c-1.1 0-2 .89-2 2v2c0 1.11.9 2 2 2h2v2h-4v2h4c1.1 0 2-.89 2-2V7c0-1.11-.9-2-2-2zm0 4h-2V7h2v2z"></path></g>
<g id="filter-9-plus"><path d="M3 5H1v16c0 1.1.9 2 2 2h16v-2H3V5zm11 7V8c0-1.11-.9-2-2-2h-1c-1.1 0-2 .89-2 2v1c0 1.11.9 2 2 2h1v1H9v2h3c1.1 0 2-.89 2-2zm-3-3V8h1v1h-1zm10-8H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 8h-2V7h-2v2h-2v2h2v2h2v-2h2v6H7V3h14v6z"></path></g>
<g id="filter-b-and-w"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16l-7-8v8H5l7-8V5h7v14z"></path></g>
<g id="filter-center-focus"><path d="M5 15H3v4c0 1.1.9 2 2 2h4v-2H5v-4zM5 5h4V3H5c-1.1 0-2 .9-2 2v4h2V5zm14-2h-4v2h4v4h2V5c0-1.1-.9-2-2-2zm0 16h-4v2h4c1.1 0 2-.9 2-2v-4h-2v4zM12 9c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"></path></g>
<g id="filter-drama"><path d="M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.61 5.64 5.36 8.04 2.35 8.36 0 10.9 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM19 18H6c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4h2c0-2.76-1.86-5.08-4.4-5.78C8.61 6.88 10.2 6 12 6c3.03 0 5.5 2.47 5.5 5.5v.5H19c1.65 0 3 1.35 3 3s-1.35 3-3 3z"></path></g>
<g id="filter-frames"><path d="M20 4h-4l-4-4-4 4H4c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 16H4V6h4.52l3.52-3.5L15.52 6H20v14zM18 8H6v10h12"></path></g>
<g id="filter-hdr"><path d="M14 6l-3.75 5 2.85 3.8-1.6 1.2C9.81 13.75 7 10 7 10l-6 8h22L14 6z"></path></g>
<g id="filter-none"><path d="M3 5H1v16c0 1.1.9 2 2 2h16v-2H3V5zm18-4H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14z"></path></g>
<g id="filter-tilt-shift"><path d="M11 4.07V2.05c-2.01.2-3.84 1-5.32 2.21L7.1 5.69c1.11-.86 2.44-1.44 3.9-1.62zm7.32.19C16.84 3.05 15.01 2.25 13 2.05v2.02c1.46.18 2.79.76 3.9 1.62l1.42-1.43zM19.93 11h2.02c-.2-2.01-1-3.84-2.21-5.32L18.31 7.1c.86 1.11 1.44 2.44 1.62 3.9zM5.69 7.1L4.26 5.68C3.05 7.16 2.25 8.99 2.05 11h2.02c.18-1.46.76-2.79 1.62-3.9zM4.07 13H2.05c.2 2.01 1 3.84 2.21 5.32l1.43-1.43c-.86-1.1-1.44-2.43-1.62-3.89zM15 12c0-1.66-1.34-3-3-3s-3 1.34-3 3 1.34 3 3 3 3-1.34 3-3zm3.31 4.9l1.43 1.43c1.21-1.48 2.01-3.32 2.21-5.32h-2.02c-.18 1.45-.76 2.78-1.62 3.89zM13 19.93v2.02c2.01-.2 3.84-1 5.32-2.21l-1.43-1.43c-1.1.86-2.43 1.44-3.89 1.62zm-7.32-.19C7.16 20.95 9 21.75 11 21.95v-2.02c-1.46-.18-2.79-.76-3.9-1.62l-1.42 1.43z"></path></g>
<g id="filter-vintage"><path d="M18.7 12.4c-.28-.16-.57-.29-.86-.4.29-.11.58-.24.86-.4 1.92-1.11 2.99-3.12 3-5.19-1.79-1.03-4.07-1.11-6 0-.28.16-.54.35-.78.54.05-.31.08-.63.08-.95 0-2.22-1.21-4.15-3-5.19C10.21 1.85 9 3.78 9 6c0 .32.03.64.08.95-.24-.2-.5-.39-.78-.55-1.92-1.11-4.2-1.03-6 0 0 2.07 1.07 4.08 3 5.19.28.16.57.29.86.4-.29.11-.58.24-.86.4-1.92 1.11-2.99 3.12-3 5.19 1.79 1.03 4.07 1.11 6 0 .28-.16.54-.35.78-.54-.05.32-.08.64-.08.96 0 2.22 1.21 4.15 3 5.19 1.79-1.04 3-2.97 3-5.19 0-.32-.03-.64-.08-.95.24.2.5.38.78.54 1.92 1.11 4.2 1.03 6 0-.01-2.07-1.08-4.08-3-5.19zM12 16c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4z"></path></g>
<g id="flare"><path d="M7 11H1v2h6v-2zm2.17-3.24L7.05 5.64 5.64 7.05l2.12 2.12 1.41-1.41zM13 1h-2v6h2V1zm5.36 6.05l-1.41-1.41-2.12 2.12 1.41 1.41 2.12-2.12zM17 11v2h6v-2h-6zm-5-2c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3zm2.83 7.24l2.12 2.12 1.41-1.41-2.12-2.12-1.41 1.41zm-9.19.71l1.41 1.41 2.12-2.12-1.41-1.41-2.12 2.12zM11 23h2v-6h-2v6z"></path></g>
<g id="flash-auto"><path d="M3 2v12h3v9l7-12H9l4-9H3zm16 0h-2l-3.2 9h1.9l.7-2h3.2l.7 2h1.9L19 2zm-2.15 5.65L18 4l1.15 3.65h-2.3z"></path></g>
<g id="flash-off"><path d="M3.27 3L2 4.27l5 5V13h3v9l3.58-6.14L17.73 20 19 18.73 3.27 3zM17 10h-4l4-8H7v2.18l8.46 8.46L17 10z"></path></g>
<g id="flash-on"><path d="M7 2v11h3v9l7-12h-4l4-8z"></path></g>
<g id="flip"><path d="M15 21h2v-2h-2v2zm4-12h2V7h-2v2zM3 5v14c0 1.1.9 2 2 2h4v-2H5V5h4V3H5c-1.1 0-2 .9-2 2zm16-2v2h2c0-1.1-.9-2-2-2zm-8 20h2V1h-2v22zm8-6h2v-2h-2v2zM15 5h2V3h-2v2zm4 8h2v-2h-2v2zm0 8c1.1 0 2-.9 2-2h-2v2z"></path></g>
<g id="gradient"><path d="M11 9h2v2h-2zm-2 2h2v2H9zm4 0h2v2h-2zm2-2h2v2h-2zM7 9h2v2H7zm12-6H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM9 18H7v-2h2v2zm4 0h-2v-2h2v2zm4 0h-2v-2h2v2zm2-7h-2v2h2v2h-2v-2h-2v2h-2v-2h-2v2H9v-2H7v2H5v-2h2v-2H5V5h14v6z"></path></g>
<g id="grain"><path d="M10 12c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zM6 8c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 8c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm12-8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm-4 8c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm4-4c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-4-4c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-4-4c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"></path></g>
<g id="grid-off"><path d="M8 4v1.45l2 2V4h4v4h-3.45l2 2H14v1.45l2 2V10h4v4h-3.45l2 2H20v1.45l2 2V4c0-1.1-.9-2-2-2H4.55l2 2H8zm8 0h4v4h-4V4zM1.27 1.27L0 2.55l2 2V20c0 1.1.9 2 2 2h15.46l2 2 1.27-1.27L1.27 1.27zM10 12.55L11.45 14H10v-1.45zm-6-6L5.45 8H4V6.55zM8 20H4v-4h4v4zm0-6H4v-4h3.45l.55.55V14zm6 6h-4v-4h3.45l.55.54V20zm2 0v-1.46L17.46 20H16z"></path></g>
<g id="grid-on"><path d="M20 2H4c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM8 20H4v-4h4v4zm0-6H4v-4h4v4zm0-6H4V4h4v4zm6 12h-4v-4h4v4zm0-6h-4v-4h4v4zm0-6h-4V4h4v4zm6 12h-4v-4h4v4zm0-6h-4v-4h4v4zm0-6h-4V4h4v4z"></path></g>
<g id="hdr-off"><path d="M17.5 15v-2h1.1l.9 2H21l-.9-2.1c.5-.2.9-.8.9-1.4v-1c0-.8-.7-1.5-1.5-1.5H16v4.9l1.1 1.1h.4zm0-4.5h2v1h-2v-1zm-4.5 0v.4l1.5 1.5v-1.9c0-.8-.7-1.5-1.5-1.5h-1.9l1.5 1.5h.4zm-3.5-1l-7-7-1.1 1L6.9 9h-.4v2h-2V9H3v6h1.5v-2.5h2V15H8v-4.9l1.5 1.5V15h3.4l7.6 7.6 1.1-1.1-12.1-12z"></path></g>
<g id="hdr-on"><path d="M21 11.5v-1c0-.8-.7-1.5-1.5-1.5H16v6h1.5v-2h1.1l.9 2H21l-.9-2.1c.5-.3.9-.8.9-1.4zm-1.5 0h-2v-1h2v1zm-13-.5h-2V9H3v6h1.5v-2.5h2V15H8V9H6.5v2zM13 9H9.5v6H13c.8 0 1.5-.7 1.5-1.5v-3c0-.8-.7-1.5-1.5-1.5zm0 4.5h-2v-3h2v3z"></path></g>
<g id="hdr-strong"><path d="M17 6c-3.31 0-6 2.69-6 6s2.69 6 6 6 6-2.69 6-6-2.69-6-6-6zM5 8c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm0 6c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z"></path></g>
<g id="hdr-weak"><path d="M5 8c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm12-2c-3.31 0-6 2.69-6 6s2.69 6 6 6 6-2.69 6-6-2.69-6-6-6zm0 10c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4z"></path></g>
<g id="healing"><path d="M17.73 12.02l3.98-3.98c.39-.39.39-1.02 0-1.41l-4.34-4.34c-.39-.39-1.02-.39-1.41 0l-3.98 3.98L8 2.29C7.8 2.1 7.55 2 7.29 2c-.25 0-.51.1-.7.29L2.25 6.63c-.39.39-.39 1.02 0 1.41l3.98 3.98L2.25 16c-.39.39-.39 1.02 0 1.41l4.34 4.34c.39.39 1.02.39 1.41 0l3.98-3.98 3.98 3.98c.2.2.45.29.71.29.26 0 .51-.1.71-.29l4.34-4.34c.39-.39.39-1.02 0-1.41l-3.99-3.98zM12 9c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm-4.71 1.96L3.66 7.34l3.63-3.63 3.62 3.62-3.62 3.63zM10 13c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm2 2c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm2-4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm2.66 9.34l-3.63-3.62 3.63-3.63 3.62 3.62-3.62 3.63z"></path></g>
<g id="image"><path d="M21 19V5c0-1.1-.9-2-2-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2zM8.5 13.5l2.5 3.01L14.5 12l4.5 6H5l3.5-4.5z"></path></g>
<g id="image-aspect-ratio"><path d="M16 10h-2v2h2v-2zm0 4h-2v2h2v-2zm-8-4H6v2h2v-2zm4 0h-2v2h2v-2zm8-6H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 14H4V6h16v12z"></path></g>
<g id="iso"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM5.5 7.5h2v-2H9v2h2V9H9v2H7.5V9h-2V7.5zM19 19H5L19 5v14zm-2-2v-1.5h-5V17h5z"></path></g>
<g id="landscape"><path d="M14 6l-3.75 5 2.85 3.8-1.6 1.2C9.81 13.75 7 10 7 10l-6 8h22L14 6z"></path></g>
<g id="leak-add"><path d="M6 3H3v3c1.66 0 3-1.34 3-3zm8 0h-2c0 4.97-4.03 9-9 9v2c6.08 0 11-4.93 11-11zm-4 0H8c0 2.76-2.24 5-5 5v2c3.87 0 7-3.13 7-7zm0 18h2c0-4.97 4.03-9 9-9v-2c-6.07 0-11 4.93-11 11zm8 0h3v-3c-1.66 0-3 1.34-3 3zm-4 0h2c0-2.76 2.24-5 5-5v-2c-3.87 0-7 3.13-7 7z"></path></g>
<g id="leak-remove"><path d="M10 3H8c0 .37-.04.72-.12 1.06l1.59 1.59C9.81 4.84 10 3.94 10 3zM3 4.27l2.84 2.84C5.03 7.67 4.06 8 3 8v2c1.61 0 3.09-.55 4.27-1.46L8.7 9.97C7.14 11.24 5.16 12 3 12v2c2.71 0 5.19-.99 7.11-2.62l2.5 2.5C10.99 15.81 10 18.29 10 21h2c0-2.16.76-4.14 2.03-5.69l1.43 1.43C14.55 17.91 14 19.39 14 21h2c0-1.06.33-2.03.89-2.84L19.73 21 21 19.73 4.27 3 3 4.27zM14 3h-2c0 1.5-.37 2.91-1.02 4.16l1.46 1.46C13.42 6.98 14 5.06 14 3zm5.94 13.12c.34-.08.69-.12 1.06-.12v-2c-.94 0-1.84.19-2.66.52l1.6 1.6zm-4.56-4.56l1.46 1.46C18.09 12.37 19.5 12 21 12v-2c-2.06 0-3.98.58-5.62 1.56z"></path></g>
<g id="lens"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2z"></path></g>
<g id="linked-camera"><circle cx="12" cy="14" r="3.2"></circle><path d="M16 3.33c2.58 0 4.67 2.09 4.67 4.67H22c0-3.31-2.69-6-6-6v1.33M16 6c1.11 0 2 .89 2 2h1.33c0-1.84-1.49-3.33-3.33-3.33V6"></path><path d="M17 9c0-1.11-.89-2-2-2V4H9L7.17 6H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V9h-5zm-5 10c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5z"></path></g>
<g id="looks"><path d="M12 10c-3.86 0-7 3.14-7 7h2c0-2.76 2.24-5 5-5s5 2.24 5 5h2c0-3.86-3.14-7-7-7zm0-4C5.93 6 1 10.93 1 17h2c0-4.96 4.04-9 9-9s9 4.04 9 9h2c0-6.07-4.93-11-11-11z"></path></g>
<g id="looks-3"><path d="M19.01 3h-14c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-4 7.5c0 .83-.67 1.5-1.5 1.5.83 0 1.5.67 1.5 1.5V15c0 1.11-.9 2-2 2h-4v-2h4v-2h-2v-2h2V9h-4V7h4c1.1 0 2 .89 2 2v1.5z"></path></g>
<g id="looks-4"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-4 14h-2v-4H9V7h2v4h2V7h2v10z"></path></g>
<g id="looks-5"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-4 6h-4v2h2c1.1 0 2 .89 2 2v2c0 1.11-.9 2-2 2H9v-2h4v-2H9V7h6v2z"></path></g>
<g id="looks-6"><path d="M11 15h2v-2h-2v2zm8-12H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-4 6h-4v2h2c1.1 0 2 .89 2 2v2c0 1.11-.9 2-2 2h-2c-1.1 0-2-.89-2-2V9c0-1.11.9-2 2-2h4v2z"></path></g>
<g id="looks-one"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-5 14h-2V9h-2V7h4v10z"></path></g>
<g id="looks-two"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-4 8c0 1.11-.9 2-2 2h-2v2h4v2H9v-4c0-1.11.9-2 2-2h2V9H9V7h4c1.1 0 2 .89 2 2v2z"></path></g>
<g id="loupe"><path d="M13 7h-2v4H7v2h4v4h2v-4h4v-2h-4V7zm-1-5C6.49 2 2 6.49 2 12s4.49 10 10 10h8c1.1 0 2-.9 2-2v-8c0-5.51-4.49-10-10-10zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z"></path></g>
<g id="monochrome-photos"><path d="M20 5h-3.2L15 3H9L7.2 5H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 14h-8v-1c-2.8 0-5-2.2-5-5s2.2-5 5-5V7h8v12zm-3-6c0-2.8-2.2-5-5-5v1.8c1.8 0 3.2 1.4 3.2 3.2s-1.4 3.2-3.2 3.2V18c2.8 0 5-2.2 5-5zm-8.2 0c0 1.8 1.4 3.2 3.2 3.2V9.8c-1.8 0-3.2 1.4-3.2 3.2z"></path></g>
<g id="movie-creation"><path d="M18 4l2 4h-3l-2-4h-2l2 4h-3l-2-4H8l2 4H7L5 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V4h-4z"></path></g>
<g id="movie-filter"><path d="M18 4l2 3h-3l-2-3h-2l2 3h-3l-2-3H8l2 3H7L5 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V4h-4zm-6.75 11.25L10 18l-1.25-2.75L6 14l2.75-1.25L10 10l1.25 2.75L14 14l-2.75 1.25zm5.69-3.31L16 14l-.94-2.06L13 11l2.06-.94L16 8l.94 2.06L19 11l-2.06.94z"></path></g>
<g id="music-note"><path d="M12 3v10.55c-.59-.34-1.27-.55-2-.55-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4V7h4V3h-6z"></path></g>
<g id="nature"><path d="M13 16.12c3.47-.41 6.17-3.36 6.17-6.95 0-3.87-3.13-7-7-7s-7 3.13-7 7c0 3.47 2.52 6.34 5.83 6.89V20H5v2h14v-2h-6v-3.88z"></path></g>
<g id="nature-people"><path d="M22.17 9.17c0-3.87-3.13-7-7-7s-7 3.13-7 7c0 3.47 2.52 6.34 5.83 6.89V20H6v-3h1v-4c0-.55-.45-1-1-1H3c-.55 0-1 .45-1 1v4h1v5h16v-2h-3v-3.88c3.47-.41 6.17-3.36 6.17-6.95zM4.5 11c.83 0 1.5-.67 1.5-1.5S5.33 8 4.5 8 3 8.67 3 9.5 3.67 11 4.5 11z"></path></g>
<g id="navigate-before"><path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"></path></g>
<g id="navigate-next"><path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"></path></g>
<g id="palette"><path d="M12 3c-4.97 0-9 4.03-9 9s4.03 9 9 9c.83 0 1.5-.67 1.5-1.5 0-.39-.15-.74-.39-1.01-.23-.26-.38-.61-.38-.99 0-.83.67-1.5 1.5-1.5H16c2.76 0 5-2.24 5-5 0-4.42-4.03-8-9-8zm-5.5 9c-.83 0-1.5-.67-1.5-1.5S5.67 9 6.5 9 8 9.67 8 10.5 7.33 12 6.5 12zm3-4C8.67 8 8 7.33 8 6.5S8.67 5 9.5 5s1.5.67 1.5 1.5S10.33 8 9.5 8zm5 0c-.83 0-1.5-.67-1.5-1.5S13.67 5 14.5 5s1.5.67 1.5 1.5S15.33 8 14.5 8zm3 4c-.83 0-1.5-.67-1.5-1.5S16.67 9 17.5 9s1.5.67 1.5 1.5-.67 1.5-1.5 1.5z"></path></g>
<g id="panorama"><path d="M23 18V6c0-1.1-.9-2-2-2H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2zM8.5 12.5l2.5 3.01L14.5 11l4.5 6H5l3.5-4.5z"></path></g>
<g id="panorama-fish-eye"><path d="M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z"></path></g>
<g id="panorama-horizontal"><path d="M20 6.54v10.91c-2.6-.77-5.28-1.16-8-1.16-2.72 0-5.4.39-8 1.16V6.54c2.6.77 5.28 1.16 8 1.16 2.72.01 5.4-.38 8-1.16M21.43 4c-.1 0-.2.02-.31.06C18.18 5.16 15.09 5.7 12 5.7c-3.09 0-6.18-.55-9.12-1.64-.11-.04-.22-.06-.31-.06-.34 0-.57.23-.57.63v14.75c0 .39.23.62.57.62.1 0 .2-.02.31-.06 2.94-1.1 6.03-1.64 9.12-1.64 3.09 0 6.18.55 9.12 1.64.11.04.21.06.31.06.33 0 .57-.23.57-.63V4.63c0-.4-.24-.63-.57-.63z"></path></g>
<g id="panorama-vertical"><path d="M19.94 21.12c-1.1-2.94-1.64-6.03-1.64-9.12 0-3.09.55-6.18 1.64-9.12.04-.11.06-.22.06-.31 0-.34-.23-.57-.63-.57H4.63c-.4 0-.63.23-.63.57 0 .1.02.2.06.31C5.16 5.82 5.71 8.91 5.71 12c0 3.09-.55 6.18-1.64 9.12-.05.11-.07.22-.07.31 0 .33.23.57.63.57h14.75c.39 0 .63-.24.63-.57-.01-.1-.03-.2-.07-.31zM6.54 20c.77-2.6 1.16-5.28 1.16-8 0-2.72-.39-5.4-1.16-8h10.91c-.77 2.6-1.16 5.28-1.16 8 0 2.72.39 5.4 1.16 8H6.54z"></path></g>
<g id="panorama-wide-angle"><path d="M12 6c2.45 0 4.71.2 7.29.64.47 1.78.71 3.58.71 5.36 0 1.78-.24 3.58-.71 5.36-2.58.44-4.84.64-7.29.64s-4.71-.2-7.29-.64C4.24 15.58 4 13.78 4 12c0-1.78.24-3.58.71-5.36C7.29 6.2 9.55 6 12 6m0-2c-2.73 0-5.22.24-7.95.72l-.93.16-.25.9C2.29 7.85 2 9.93 2 12s.29 4.15.87 6.22l.25.89.93.16c2.73.49 5.22.73 7.95.73s5.22-.24 7.95-.72l.93-.16.25-.89c.58-2.08.87-4.16.87-6.23s-.29-4.15-.87-6.22l-.25-.89-.93-.16C17.22 4.24 14.73 4 12 4z"></path></g>
<g id="photo"><path d="M21 19V5c0-1.1-.9-2-2-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2zM8.5 13.5l2.5 3.01L14.5 12l4.5 6H5l3.5-4.5z"></path></g>
<g id="photo-album"><path d="M18 2H6c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM6 4h5v8l-2.5-1.5L6 12V4zm0 15l3-3.86 2.14 2.58 3-3.86L18 19H6z"></path></g>
<g id="photo-camera"><circle cx="12" cy="12" r="3.2"></circle><path d="M9 2L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2h-3.17L15 2H9zm3 15c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5z"></path></g>
<g id="photo-filter"><path d="M19.02 10v9H5V5h9V3H5.02c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-9h-2zM17 10l.94-2.06L20 7l-2.06-.94L17 4l-.94 2.06L14 7l2.06.94zm-3.75.75L12 8l-1.25 2.75L8 12l2.75 1.25L12 16l1.25-2.75L16 12z"></path></g>
<g id="photo-library"><path d="M22 16V4c0-1.1-.9-2-2-2H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2zm-11-4l2.03 2.71L16 11l4 5H8l3-4zM2 6v14c0 1.1.9 2 2 2h14v-2H4V6H2z"></path></g>
<g id="photo-size-select-actual"><path d="M21 3H3C2 3 1 4 1 5v14c0 1.1.9 2 2 2h18c1 0 2-1 2-2V5c0-1-1-2-2-2zM5 17l3.5-4.5 2.5 3.01L14.5 11l4.5 6H5z"></path></g>
<g id="photo-size-select-large"><path d="M21 15h2v2h-2v-2zm0-4h2v2h-2v-2zm2 8h-2v2c1 0 2-1 2-2zM13 3h2v2h-2V3zm8 4h2v2h-2V7zm0-4v2h2c0-1-1-2-2-2zM1 7h2v2H1V7zm16-4h2v2h-2V3zm0 16h2v2h-2v-2zM3 3C2 3 1 4 1 5h2V3zm6 0h2v2H9V3zM5 3h2v2H5V3zm-4 8v8c0 1.1.9 2 2 2h12V11H1zm2 8l2.5-3.21 1.79 2.15 2.5-3.22L13 19H3z"></path></g>
<g id="photo-size-select-small"><path d="M23 15h-2v2h2v-2zm0-4h-2v2h2v-2zm0 8h-2v2c1 0 2-1 2-2zM15 3h-2v2h2V3zm8 4h-2v2h2V7zm-2-4v2h2c0-1-1-2-2-2zM3 21h8v-6H1v4c0 1.1.9 2 2 2zM3 7H1v2h2V7zm12 12h-2v2h2v-2zm4-16h-2v2h2V3zm0 16h-2v2h2v-2zM3 3C2 3 1 4 1 5h2V3zm0 8H1v2h2v-2zm8-8H9v2h2V3zM7 3H5v2h2V3z"></path></g>
<g id="picture-as-pdf"><path d="M20 2H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-8.5 7.5c0 .83-.67 1.5-1.5 1.5H9v2H7.5V7H10c.83 0 1.5.67 1.5 1.5v1zm5 2c0 .83-.67 1.5-1.5 1.5h-2.5V7H15c.83 0 1.5.67 1.5 1.5v3zm4-3H19v1h1.5V11H19v2h-1.5V7h3v1.5zM9 9.5h1v-1H9v1zM4 6H2v14c0 1.1.9 2 2 2h14v-2H4V6zm10 5.5h1v-3h-1v3z"></path></g>
<g id="portrait"><path d="M12 12.25c1.24 0 2.25-1.01 2.25-2.25S13.24 7.75 12 7.75 9.75 8.76 9.75 10s1.01 2.25 2.25 2.25zm4.5 4c0-1.5-3-2.25-4.5-2.25s-4.5.75-4.5 2.25V17h9v-.75zM19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V5h14v14z"></path></g>
<g id="remove-red-eye"><path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"></path></g>
<g id="rotate-90-degrees-ccw"><path d="M7.34 6.41L.86 12.9l6.49 6.48 6.49-6.48-6.5-6.49zM3.69 12.9l3.66-3.66L11 12.9l-3.66 3.66-3.65-3.66zm15.67-6.26C17.61 4.88 15.3 4 13 4V.76L8.76 5 13 9.24V6c1.79 0 3.58.68 4.95 2.05 2.73 2.73 2.73 7.17 0 9.9C16.58 19.32 14.79 20 13 20c-.97 0-1.94-.21-2.84-.61l-1.49 1.49C10.02 21.62 11.51 22 13 22c2.3 0 4.61-.88 6.36-2.64 3.52-3.51 3.52-9.21 0-12.72z"></path></g>
<g id="rotate-left"><path d="M7.11 8.53L5.7 7.11C4.8 8.27 4.24 9.61 4.07 11h2.02c.14-.87.49-1.72 1.02-2.47zM6.09 13H4.07c.17 1.39.72 2.73 1.62 3.89l1.41-1.42c-.52-.75-.87-1.59-1.01-2.47zm1.01 5.32c1.16.9 2.51 1.44 3.9 1.61V17.9c-.87-.15-1.71-.49-2.46-1.03L7.1 18.32zM13 4.07V1L8.45 5.55 13 10V6.09c2.84.48 5 2.94 5 5.91s-2.16 5.43-5 5.91v2.02c3.95-.49 7-3.85 7-7.93s-3.05-7.44-7-7.93z"></path></g>
<g id="rotate-right"><path d="M15.55 5.55L11 1v3.07C7.06 4.56 4 7.92 4 12s3.05 7.44 7 7.93v-2.02c-2.84-.48-5-2.94-5-5.91s2.16-5.43 5-5.91V10l4.55-4.45zM19.93 11c-.17-1.39-.72-2.73-1.62-3.89l-1.42 1.42c.54.75.88 1.6 1.02 2.47h2.02zM13 17.9v2.02c1.39-.17 2.74-.71 3.9-1.61l-1.44-1.44c-.75.54-1.59.89-2.46 1.03zm3.89-2.42l1.42 1.41c.9-1.16 1.45-2.5 1.62-3.89h-2.02c-.14.87-.48 1.72-1.02 2.48z"></path></g>
<g id="slideshow"><path d="M10 8v8l5-4-5-4zm9-5H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V5h14v14z"></path></g>
<g id="straighten"><path d="M21 6H3c-1.1 0-2 .9-2 2v8c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm0 10H3V8h2v4h2V8h2v4h2V8h2v4h2V8h2v4h2V8h2v8z"></path></g>
<g id="style"><path d="M2.53 19.65l1.34.56v-9.03l-2.43 5.86c-.41 1.02.08 2.19 1.09 2.61zm19.5-3.7L17.07 3.98c-.31-.75-1.04-1.21-1.81-1.23-.26 0-.53.04-.79.15L7.1 5.95c-.75.31-1.21 1.03-1.23 1.8-.01.27.04.54.15.8l4.96 11.97c.31.76 1.05 1.22 1.83 1.23.26 0 .52-.05.77-.15l7.36-3.05c1.02-.42 1.51-1.59 1.09-2.6zM7.88 8.75c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-2 11c0 1.1.9 2 2 2h1.45l-3.45-8.34v6.34z"></path></g>
<g id="switch-camera"><path d="M20 4h-3.17L15 2H9L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-5 11.5V13H9v2.5L5.5 12 9 8.5V11h6V8.5l3.5 3.5-3.5 3.5z"></path></g>
<g id="switch-video"><path d="M18 9.5V6c0-.55-.45-1-1-1H3c-.55 0-1 .45-1 1v12c0 .55.45 1 1 1h14c.55 0 1-.45 1-1v-3.5l4 4v-13l-4 4zm-5 6V13H7v2.5L3.5 12 7 8.5V11h6V8.5l3.5 3.5-3.5 3.5z"></path></g>
<g id="tag-faces"><path d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm3.5-9c.83 0 1.5-.67 1.5-1.5S16.33 8 15.5 8 14 8.67 14 9.5s.67 1.5 1.5 1.5zm-7 0c.83 0 1.5-.67 1.5-1.5S9.33 8 8.5 8 7 8.67 7 9.5 7.67 11 8.5 11zm3.5 6.5c2.33 0 4.31-1.46 5.11-3.5H6.89c.8 2.04 2.78 3.5 5.11 3.5z"></path></g>
<g id="texture"><path d="M19.51 3.08L3.08 19.51c.09.34.27.65.51.9.25.24.56.42.9.51L20.93 4.49c-.19-.69-.73-1.23-1.42-1.41zM11.88 3L3 11.88v2.83L14.71 3h-2.83zM5 3c-1.1 0-2 .9-2 2v2l4-4H5zm14 18c.55 0 1.05-.22 1.41-.59.37-.36.59-.86.59-1.41v-2l-4 4h2zm-9.71 0h2.83L21 12.12V9.29L9.29 21z"></path></g>
<g id="timelapse"><path d="M16.24 7.76C15.07 6.59 13.54 6 12 6v6l-4.24 4.24c2.34 2.34 6.14 2.34 8.49 0 2.34-2.34 2.34-6.14-.01-8.48zM12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z"></path></g>
<g id="timer"><path d="M15 1H9v2h6V1zm-4 13h2V8h-2v6zm8.03-6.61l1.42-1.42c-.43-.51-.9-.99-1.41-1.41l-1.42 1.42C16.07 4.74 14.12 4 12 4c-4.97 0-9 4.03-9 9s4.02 9 9 9 9-4.03 9-9c0-2.12-.74-4.07-1.97-5.61zM12 20c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7z"></path></g>
<g id="timer-10"><path d="M0 7.72V9.4l3-1V18h2V6h-.25L0 7.72zm23.78 6.65c-.14-.28-.35-.53-.63-.74-.28-.21-.61-.39-1.01-.53s-.85-.27-1.35-.38c-.35-.07-.64-.15-.87-.23-.23-.08-.41-.16-.55-.25-.14-.09-.23-.19-.28-.3-.05-.11-.08-.24-.08-.39 0-.14.03-.28.09-.41.06-.13.15-.25.27-.34.12-.1.27-.18.45-.24s.4-.09.64-.09c.25 0 .47.04.66.11.19.07.35.17.48.29.13.12.22.26.29.42.06.16.1.32.1.49h1.95c0-.39-.08-.75-.24-1.09-.16-.34-.39-.63-.69-.88-.3-.25-.66-.44-1.09-.59C21.49 9.07 21 9 20.46 9c-.51 0-.98.07-1.39.21-.41.14-.77.33-1.06.57-.29.24-.51.52-.67.84-.16.32-.23.65-.23 1.01s.08.69.23.96c.15.28.36.52.64.73.27.21.6.38.98.53.38.14.81.26 1.27.36.39.08.71.17.95.26s.43.19.57.29c.13.1.22.22.27.34.05.12.07.25.07.39 0 .32-.13.57-.4.77-.27.2-.66.29-1.17.29-.22 0-.43-.02-.64-.08-.21-.05-.4-.13-.56-.24-.17-.11-.3-.26-.41-.44-.11-.18-.17-.41-.18-.67h-1.89c0 .36.08.71.24 1.05.16.34.39.65.7.93.31.27.69.49 1.15.66.46.17.98.25 1.58.25.53 0 1.01-.06 1.44-.19.43-.13.8-.31 1.11-.54.31-.23.54-.51.71-.83.17-.32.25-.67.25-1.06-.02-.4-.09-.74-.24-1.02zm-9.96-7.32c-.34-.4-.75-.7-1.23-.88-.47-.18-1.01-.27-1.59-.27-.58 0-1.11.09-1.59.27-.48.18-.89.47-1.23.88-.34.41-.6.93-.79 1.59-.18.65-.28 1.45-.28 2.39v1.92c0 .94.09 1.74.28 2.39.19.66.45 1.19.8 1.6.34.41.75.71 1.23.89.48.18 1.01.28 1.59.28.59 0 1.12-.09 1.59-.28.48-.18.88-.48 1.22-.89.34-.41.6-.94.78-1.6.18-.65.28-1.45.28-2.39v-1.92c0-.94-.09-1.74-.28-2.39-.18-.66-.44-1.19-.78-1.59zm-.92 6.17c0 .6-.04 1.11-.12 1.53-.08.42-.2.76-.36 1.02-.16.26-.36.45-.59.57-.23.12-.51.18-.82.18-.3 0-.58-.06-.82-.18s-.44-.31-.6-.57c-.16-.26-.29-.6-.38-1.02-.09-.42-.13-.93-.13-1.53v-2.5c0-.6.04-1.11.13-1.52.09-.41.21-.74.38-1 .16-.25.36-.43.6-.55.24-.11.51-.17.81-.17.31 0 .58.06.81.17.24.11.44.29.6.55.16.25.29.58.37.99.08.41.13.92.13 1.52v2.51z"></path></g>
<g id="timer-3"><path d="M11.61 12.97c-.16-.24-.36-.46-.62-.65-.25-.19-.56-.35-.93-.48.3-.14.57-.3.8-.5.23-.2.42-.41.57-.64.15-.23.27-.46.34-.71.08-.24.11-.49.11-.73 0-.55-.09-1.04-.28-1.46-.18-.42-.44-.77-.78-1.06-.33-.28-.73-.5-1.2-.64-.45-.13-.97-.2-1.53-.2-.55 0-1.06.08-1.52.24-.47.17-.87.4-1.2.69-.33.29-.6.63-.78 1.03-.2.39-.29.83-.29 1.29h1.98c0-.26.05-.49.14-.69.09-.2.22-.38.38-.52.17-.14.36-.25.58-.33.22-.08.46-.12.73-.12.61 0 1.06.16 1.36.47.3.31.44.75.44 1.32 0 .27-.04.52-.12.74-.08.22-.21.41-.38.57-.17.16-.38.28-.63.37-.25.09-.55.13-.89.13H6.72v1.57H7.9c.34 0 .64.04.91.11.27.08.5.19.69.35.19.16.34.36.44.61.1.24.16.54.16.87 0 .62-.18 1.09-.53 1.42-.35.33-.84.49-1.45.49-.29 0-.56-.04-.8-.13-.24-.08-.44-.2-.61-.36-.17-.16-.3-.34-.39-.56-.09-.22-.14-.46-.14-.72H4.19c0 .55.11 1.03.32 1.45.21.42.5.77.86 1.05s.77.49 1.24.63.96.21 1.48.21c.57 0 1.09-.08 1.58-.23.49-.15.91-.38 1.26-.68.36-.3.64-.66.84-1.1.2-.43.3-.93.3-1.48 0-.29-.04-.58-.11-.86-.08-.25-.19-.51-.35-.76zm9.26 1.4c-.14-.28-.35-.53-.63-.74-.28-.21-.61-.39-1.01-.53s-.85-.27-1.35-.38c-.35-.07-.64-.15-.87-.23-.23-.08-.41-.16-.55-.25-.14-.09-.23-.19-.28-.3-.05-.11-.08-.24-.08-.39s.03-.28.09-.41c.06-.13.15-.25.27-.34.12-.1.27-.18.45-.24s.4-.09.64-.09c.25 0 .47.04.66.11.19.07.35.17.48.29.13.12.22.26.29.42.06.16.1.32.1.49h1.95c0-.39-.08-.75-.24-1.09-.16-.34-.39-.63-.69-.88-.3-.25-.66-.44-1.09-.59-.43-.15-.92-.22-1.46-.22-.51 0-.98.07-1.39.21-.41.14-.77.33-1.06.57-.29.24-.51.52-.67.84-.16.32-.23.65-.23 1.01s.08.68.23.96c.15.28.37.52.64.73.27.21.6.38.98.53.38.14.81.26 1.27.36.39.08.71.17.95.26s.43.19.57.29c.13.1.22.22.27.34.05.12.07.25.07.39 0 .32-.13.57-.4.77-.27.2-.66.29-1.17.29-.22 0-.43-.02-.64-.08-.21-.05-.4-.13-.56-.24-.17-.11-.3-.26-.41-.44-.11-.18-.17-.41-.18-.67h-1.89c0 .36.08.71.24 1.05.16.34.39.65.7.93.31.27.69.49 1.15.66.46.17.98.25 1.58.25.53 0 1.01-.06 1.44-.19.43-.13.8-.31 1.11-.54.31-.23.54-.51.71-.83.17-.32.25-.67.25-1.06-.02-.4-.09-.74-.24-1.02z"></path></g>
<g id="timer-off"><path d="M19.04 4.55l-1.42 1.42C16.07 4.74 14.12 4 12 4c-1.83 0-3.53.55-4.95 1.48l1.46 1.46C9.53 6.35 10.73 6 12 6c3.87 0 7 3.13 7 7 0 1.27-.35 2.47-.94 3.49l1.45 1.45C20.45 16.53 21 14.83 21 13c0-2.12-.74-4.07-1.97-5.61l1.42-1.42-1.41-1.42zM15 1H9v2h6V1zm-4 8.44l2 2V8h-2v1.44zM3.02 4L1.75 5.27 4.5 8.03C3.55 9.45 3 11.16 3 13c0 4.97 4.02 9 9 9 1.84 0 3.55-.55 4.98-1.5l2.5 2.5 1.27-1.27-7.71-7.71L3.02 4zM12 20c-3.87 0-7-3.13-7-7 0-1.28.35-2.48.95-3.52l9.56 9.56c-1.03.61-2.23.96-3.51.96z"></path></g>
<g id="tonality"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 17.93c-3.94-.49-7-3.85-7-7.93s3.05-7.44 7-7.93v15.86zm2-15.86c1.03.13 2 .45 2.87.93H13v-.93zM13 7h5.24c.25.31.48.65.68 1H13V7zm0 3h6.74c.08.33.15.66.19 1H13v-1zm0 9.93V19h2.87c-.87.48-1.84.8-2.87.93zM18.24 17H13v-1h5.92c-.2.35-.43.69-.68 1zm1.5-3H13v-1h6.93c-.04.34-.11.67-.19 1z"></path></g>
<g id="transform"><path d="M22 18v-2H8V4h2L7 1 4 4h2v2H2v2h4v8c0 1.1.9 2 2 2h8v2h-2l3 3 3-3h-2v-2h4zM10 8h6v6h2V8c0-1.1-.9-2-2-2h-6v2z"></path></g>
<g id="tune"><path d="M3 17v2h6v-2H3zM3 5v2h10V5H3zm10 16v-2h8v-2h-8v-2h-2v6h2zM7 9v2H3v2h4v2h2V9H7zm14 4v-2H11v2h10zm-6-4h2V7h4V5h-4V3h-2v6z"></path></g>
<g id="view-comfy"><path d="M3 9h4V5H3v4zm0 5h4v-4H3v4zm5 0h4v-4H8v4zm5 0h4v-4h-4v4zM8 9h4V5H8v4zm5-4v4h4V5h-4zm5 9h4v-4h-4v4zM3 19h4v-4H3v4zm5 0h4v-4H8v4zm5 0h4v-4h-4v4zm5 0h4v-4h-4v4zm0-14v4h4V5h-4z"></path></g>
<g id="view-compact"><path d="M3 19h6v-7H3v7zm7 0h12v-7H10v7zM3 5v6h19V5H3z"></path></g>
<g id="vignette"><path d="M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-9 15c-4.42 0-8-2.69-8-6s3.58-6 8-6 8 2.69 8 6-3.58 6-8 6z"></path></g>
<g id="wb-auto"><path d="M6.85 12.65h2.3L8 9l-1.15 3.65zM22 7l-1.2 6.29L19.3 7h-1.6l-1.49 6.29L15 7h-.76C12.77 5.17 10.53 4 8 4c-4.42 0-8 3.58-8 8s3.58 8 8 8c3.13 0 5.84-1.81 7.15-4.43l.1.43H17l1.5-6.1L20 16h1.75l2.05-9H22zm-11.7 9l-.7-2H6.4l-.7 2H3.8L7 7h2l3.2 9h-1.9z"></path></g>
<g id="wb-cloudy"><path d="M19.36 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.64-4.96z"></path></g>
<g id="wb-incandescent"><path d="M3.55 18.54l1.41 1.41 1.79-1.8-1.41-1.41-1.79 1.8zM11 22.45h2V19.5h-2v2.95zM4 10.5H1v2h3v-2zm11-4.19V1.5H9v4.81C7.21 7.35 6 9.28 6 11.5c0 3.31 2.69 6 6 6s6-2.69 6-6c0-2.22-1.21-4.15-3-5.19zm5 4.19v2h3v-2h-3zm-2.76 7.66l1.79 1.8 1.41-1.41-1.8-1.79-1.4 1.4z"></path></g>
<g id="wb-iridescent"><path d="M5 14.5h14v-6H5v6zM11 .55V3.5h2V.55h-2zm8.04 2.5l-1.79 1.79 1.41 1.41 1.8-1.79-1.42-1.41zM13 22.45V19.5h-2v2.95h2zm7.45-3.91l-1.8-1.79-1.41 1.41 1.79 1.8 1.42-1.42zM3.55 4.46l1.79 1.79 1.41-1.41-1.79-1.79-1.41 1.41zm1.41 15.49l1.79-1.8-1.41-1.41-1.79 1.79 1.41 1.42z"></path></g>
<g id="wb-sunny"><path d="M6.76 4.84l-1.8-1.79-1.41 1.41 1.79 1.79 1.42-1.41zM4 10.5H1v2h3v-2zm9-9.95h-2V3.5h2V.55zm7.45 3.91l-1.41-1.41-1.79 1.79 1.41 1.41 1.79-1.79zm-3.21 13.7l1.79 1.8 1.41-1.41-1.8-1.79-1.4 1.4zM20 10.5v2h3v-2h-3zm-8-5c-3.31 0-6 2.69-6 6s2.69 6 6 6 6-2.69 6-6-2.69-6-6-6zm-1 16.95h2V19.5h-2v2.95zm-7.45-3.91l1.41 1.41 1.79-1.8-1.41-1.41-1.79 1.8z"></path></g>
</defs></svg>
</iron-iconset-svg>`;document.head.appendChild(So.content);
/**
    @license
    Copyright (c) 2014 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const Mo=_e`<iron-iconset-svg name="icons" size="24">
<svg><defs>
<g id="3d-rotation"><path d="M7.52 21.48C4.25 19.94 1.91 16.76 1.55 13H.05C.56 19.16 5.71 24 12 24l.66-.03-3.81-3.81-1.33 1.32zm.89-6.52c-.19 0-.37-.03-.52-.08-.16-.06-.29-.13-.4-.24-.11-.1-.2-.22-.26-.37-.06-.14-.09-.3-.09-.47h-1.3c0 .36.07.68.21.95.14.27.33.5.56.69.24.18.51.32.82.41.3.1.62.15.96.15.37 0 .72-.05 1.03-.15.32-.1.6-.25.83-.44s.42-.43.55-.72c.13-.29.2-.61.2-.97 0-.19-.02-.38-.07-.56-.05-.18-.12-.35-.23-.51-.1-.16-.24-.3-.4-.43-.17-.13-.37-.23-.61-.31.2-.09.37-.2.52-.33.15-.13.27-.27.37-.42.1-.15.17-.3.22-.46.05-.16.07-.32.07-.48 0-.36-.06-.68-.18-.96-.12-.28-.29-.51-.51-.69-.2-.19-.47-.33-.77-.43C9.1 8.05 8.76 8 8.39 8c-.36 0-.69.05-1 .16-.3.11-.57.26-.79.45-.21.19-.38.41-.51.67-.12.26-.18.54-.18.85h1.3c0-.17.03-.32.09-.45s.14-.25.25-.34c.11-.09.23-.17.38-.22.15-.05.3-.08.48-.08.4 0 .7.1.89.31.19.2.29.49.29.86 0 .18-.03.34-.08.49-.05.15-.14.27-.25.37-.11.1-.25.18-.41.24-.16.06-.36.09-.58.09H7.5v1.03h.77c.22 0 .42.02.6.07s.33.13.45.23c.12.11.22.24.29.4.07.16.1.35.1.57 0 .41-.12.72-.35.93-.23.23-.55.33-.95.33zm8.55-5.92c-.32-.33-.7-.59-1.14-.77-.43-.18-.92-.27-1.46-.27H12v8h2.3c.55 0 1.06-.09 1.51-.27.45-.18.84-.43 1.16-.76.32-.33.57-.73.74-1.19.17-.47.26-.99.26-1.57v-.4c0-.58-.09-1.1-.26-1.57-.18-.47-.43-.87-.75-1.2zm-.39 3.16c0 .42-.05.79-.14 1.13-.1.33-.24.62-.43.85-.19.23-.43.41-.71.53-.29.12-.62.18-.99.18h-.91V9.12h.97c.72 0 1.27.23 1.64.69.38.46.57 1.12.57 1.99v.4zM12 0l-.66.03 3.81 3.81 1.33-1.33c3.27 1.55 5.61 4.72 5.96 8.48h1.5C23.44 4.84 18.29 0 12 0z"></path></g>
<g id="accessibility"><path d="M12 2c1.1 0 2 .9 2 2s-.9 2-2 2-2-.9-2-2 .9-2 2-2zm9 7h-6v13h-2v-6h-2v6H9V9H3V7h18v2z"></path></g>
<g id="accessible"><circle cx="12" cy="4" r="2"></circle><path d="M19 13v-2c-1.54.02-3.09-.75-4.07-1.83l-1.29-1.43c-.17-.19-.38-.34-.61-.45-.01 0-.01-.01-.02-.01H13c-.35-.2-.75-.3-1.19-.26C10.76 7.11 10 8.04 10 9.09V15c0 1.1.9 2 2 2h5v5h2v-5.5c0-1.1-.9-2-2-2h-3v-3.45c1.29 1.07 3.25 1.94 5 1.95zm-6.17 5c-.41 1.16-1.52 2-2.83 2-1.66 0-3-1.34-3-3 0-1.31.84-2.41 2-2.83V12.1c-2.28.46-4 2.48-4 4.9 0 2.76 2.24 5 5 5 2.42 0 4.44-1.72 4.9-4h-2.07z"></path></g>
<g id="account-balance"><path d="M4 10v7h3v-7H4zm6 0v7h3v-7h-3zM2 22h19v-3H2v3zm14-12v7h3v-7h-3zm-4.5-9L2 6v2h19V6l-9.5-5z"></path></g>
<g id="account-balance-wallet"><path d="M21 18v1c0 1.1-.9 2-2 2H5c-1.11 0-2-.9-2-2V5c0-1.1.89-2 2-2h14c1.1 0 2 .9 2 2v1h-9c-1.11 0-2 .9-2 2v8c0 1.1.89 2 2 2h9zm-9-2h10V8H12v8zm4-2.5c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5z"></path></g>
<g id="account-box"><path d="M3 5v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2H5c-1.11 0-2 .9-2 2zm12 4c0 1.66-1.34 3-3 3s-3-1.34-3-3 1.34-3 3-3 3 1.34 3 3zm-9 8c0-2 4-3.1 6-3.1s6 1.1 6 3.1v1H6v-1z"></path></g>
<g id="account-circle"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 3c1.66 0 3 1.34 3 3s-1.34 3-3 3-3-1.34-3-3 1.34-3 3-3zm0 14.2c-2.5 0-4.71-1.28-6-3.22.03-1.99 4-3.08 6-3.08 1.99 0 5.97 1.09 6 3.08-1.29 1.94-3.5 3.22-6 3.22z"></path></g>
<g id="add"><path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z"></path></g>
<g id="add-alert"><path d="M10.01 21.01c0 1.1.89 1.99 1.99 1.99s1.99-.89 1.99-1.99h-3.98zm8.87-4.19V11c0-3.25-2.25-5.97-5.29-6.69v-.72C13.59 2.71 12.88 2 12 2s-1.59.71-1.59 1.59v.72C7.37 5.03 5.12 7.75 5.12 11v5.82L3 18.94V20h18v-1.06l-2.12-2.12zM16 13.01h-3v3h-2v-3H8V11h3V8h2v3h3v2.01z"></path></g>
<g id="add-box"><path d="M19 3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-2 10h-4v4h-2v-4H7v-2h4V7h2v4h4v2z"></path></g>
<g id="add-circle"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm5 11h-4v4h-2v-4H7v-2h4V7h2v4h4v2z"></path></g>
<g id="add-circle-outline"><path d="M13 7h-2v4H7v2h4v4h2v-4h4v-2h-4V7zm-1-5C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z"></path></g>
<g id="add-shopping-cart"><path d="M11 9h2V6h3V4h-3V1h-2v3H8v2h3v3zm-4 9c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2zm10 0c-1.1 0-1.99.9-1.99 2s.89 2 1.99 2 2-.9 2-2-.9-2-2-2zm-9.83-3.25l.03-.12.9-1.63h7.45c.75 0 1.41-.41 1.75-1.03l3.86-7.01L19.42 4h-.01l-1.1 2-2.76 5H8.53l-.13-.27L6.16 6l-.95-2-.94-2H1v2h2l3.6 7.59-1.35 2.45c-.16.28-.25.61-.25.96 0 1.1.9 2 2 2h12v-2H7.42c-.13 0-.25-.11-.25-.25z"></path></g>
<g id="alarm"><path d="M22 5.72l-4.6-3.86-1.29 1.53 4.6 3.86L22 5.72zM7.88 3.39L6.6 1.86 2 5.71l1.29 1.53 4.59-3.85zM12.5 8H11v6l4.75 2.85.75-1.23-4-2.37V8zM12 4c-4.97 0-9 4.03-9 9s4.02 9 9 9c4.97 0 9-4.03 9-9s-4.03-9-9-9zm0 16c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7z"></path></g>
<g id="alarm-add"><path d="M7.88 3.39L6.6 1.86 2 5.71l1.29 1.53 4.59-3.85zM22 5.72l-4.6-3.86-1.29 1.53 4.6 3.86L22 5.72zM12 4c-4.97 0-9 4.03-9 9s4.02 9 9 9c4.97 0 9-4.03 9-9s-4.03-9-9-9zm0 16c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7zm1-11h-2v3H8v2h3v3h2v-3h3v-2h-3V9z"></path></g>
<g id="alarm-off"><path d="M12 6c3.87 0 7 3.13 7 7 0 .84-.16 1.65-.43 2.4l1.52 1.52c.58-1.19.91-2.51.91-3.92 0-4.97-4.03-9-9-9-1.41 0-2.73.33-3.92.91L9.6 6.43C10.35 6.16 11.16 6 12 6zm10-.28l-4.6-3.86-1.29 1.53 4.6 3.86L22 5.72zM2.92 2.29L1.65 3.57 2.98 4.9l-1.11.93 1.42 1.42 1.11-.94.8.8C3.83 8.69 3 10.75 3 13c0 4.97 4.02 9 9 9 2.25 0 4.31-.83 5.89-2.2l2.2 2.2 1.27-1.27L3.89 3.27l-.97-.98zm13.55 16.1C15.26 19.39 13.7 20 12 20c-3.87 0-7-3.13-7-7 0-1.7.61-3.26 1.61-4.47l9.86 9.86zM8.02 3.28L6.6 1.86l-.86.71 1.42 1.42.86-.71z"></path></g>
<g id="alarm-on"><path d="M22 5.72l-4.6-3.86-1.29 1.53 4.6 3.86L22 5.72zM7.88 3.39L6.6 1.86 2 5.71l1.29 1.53 4.59-3.85zM12 4c-4.97 0-9 4.03-9 9s4.02 9 9 9c4.97 0 9-4.03 9-9s-4.03-9-9-9zm0 16c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7zm-1.46-5.47L8.41 12.4l-1.06 1.06 3.18 3.18 6-6-1.06-1.06-4.93 4.95z"></path></g>
<g id="all-out"><path d="M16.21 4.16l4 4v-4zm4 12l-4 4h4zm-12 4l-4-4v4zm-4-12l4-4h-4zm12.95-.95c-2.73-2.73-7.17-2.73-9.9 0s-2.73 7.17 0 9.9 7.17 2.73 9.9 0 2.73-7.16 0-9.9zm-1.1 8.8c-2.13 2.13-5.57 2.13-7.7 0s-2.13-5.57 0-7.7 5.57-2.13 7.7 0 2.13 5.57 0 7.7z"></path></g>
<g id="android"><path d="M6 18c0 .55.45 1 1 1h1v3.5c0 .83.67 1.5 1.5 1.5s1.5-.67 1.5-1.5V19h2v3.5c0 .83.67 1.5 1.5 1.5s1.5-.67 1.5-1.5V19h1c.55 0 1-.45 1-1V8H6v10zM3.5 8C2.67 8 2 8.67 2 9.5v7c0 .83.67 1.5 1.5 1.5S5 17.33 5 16.5v-7C5 8.67 4.33 8 3.5 8zm17 0c-.83 0-1.5.67-1.5 1.5v7c0 .83.67 1.5 1.5 1.5s1.5-.67 1.5-1.5v-7c0-.83-.67-1.5-1.5-1.5zm-4.97-5.84l1.3-1.3c.2-.2.2-.51 0-.71-.2-.2-.51-.2-.71 0l-1.48 1.48C13.85 1.23 12.95 1 12 1c-.96 0-1.86.23-2.66.63L7.85.15c-.2-.2-.51-.2-.71 0-.2.2-.2.51 0 .71l1.31 1.31C6.97 3.26 6 5.01 6 7h12c0-1.99-.97-3.75-2.47-4.84zM10 5H9V4h1v1zm5 0h-1V4h1v1z"></path></g>
<g id="announcement"><path d="M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-7 9h-2V5h2v6zm0 4h-2v-2h2v2z"></path></g>
<g id="apps"><path d="M4 8h4V4H4v4zm6 12h4v-4h-4v4zm-6 0h4v-4H4v4zm0-6h4v-4H4v4zm6 0h4v-4h-4v4zm6-10v4h4V4h-4zm-6 4h4V4h-4v4zm6 6h4v-4h-4v4zm0 6h4v-4h-4v4z"></path></g>
<g id="archive"><path d="M20.54 5.23l-1.39-1.68C18.88 3.21 18.47 3 18 3H6c-.47 0-.88.21-1.16.55L3.46 5.23C3.17 5.57 3 6.02 3 6.5V19c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V6.5c0-.48-.17-.93-.46-1.27zM12 17.5L6.5 12H10v-2h4v2h3.5L12 17.5zM5.12 5l.81-1h12l.94 1H5.12z"></path></g>
<g id="arrow-back"><path d="M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z"></path></g>
<g id="arrow-downward"><path d="M20 12l-1.41-1.41L13 16.17V4h-2v12.17l-5.58-5.59L4 12l8 8 8-8z"></path></g>
<g id="arrow-drop-down"><path d="M7 10l5 5 5-5z"></path></g>
<g id="arrow-drop-down-circle"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 12l-4-4h8l-4 4z"></path></g>
<g id="arrow-drop-up"><path d="M7 14l5-5 5 5z"></path></g>
<g id="arrow-forward"><path d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z"></path></g>
<g id="arrow-upward"><path d="M4 12l1.41 1.41L11 7.83V20h2V7.83l5.58 5.59L20 12l-8-8-8 8z"></path></g>
<g id="aspect-ratio"><path d="M19 12h-2v3h-3v2h5v-5zM7 9h3V7H5v5h2V9zm14-6H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16.01H3V4.99h18v14.02z"></path></g>
<g id="assessment"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM9 17H7v-7h2v7zm4 0h-2V7h2v10zm4 0h-2v-4h2v4z"></path></g>
<g id="assignment"><path d="M19 3h-4.18C14.4 1.84 13.3 1 12 1c-1.3 0-2.4.84-2.82 2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7 0c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm2 14H7v-2h7v2zm3-4H7v-2h10v2zm0-4H7V7h10v2z"></path></g>
<g id="assignment-ind"><path d="M19 3h-4.18C14.4 1.84 13.3 1 12 1c-1.3 0-2.4.84-2.82 2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7 0c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm0 4c1.66 0 3 1.34 3 3s-1.34 3-3 3-3-1.34-3-3 1.34-3 3-3zm6 12H6v-1.4c0-2 4-3.1 6-3.1s6 1.1 6 3.1V19z"></path></g>
<g id="assignment-late"><path d="M19 3h-4.18C14.4 1.84 13.3 1 12 1c-1.3 0-2.4.84-2.82 2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-6 15h-2v-2h2v2zm0-4h-2V8h2v6zm-1-9c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z"></path></g>
<g id="assignment-return"><path d="M19 3h-4.18C14.4 1.84 13.3 1 12 1c-1.3 0-2.4.84-2.82 2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7 0c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm4 12h-4v3l-5-5 5-5v3h4v4z"></path></g>
<g id="assignment-returned"><path d="M19 3h-4.18C14.4 1.84 13.3 1 12 1c-1.3 0-2.4.84-2.82 2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7 0c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm0 15l-5-5h3V9h4v4h3l-5 5z"></path></g>
<g id="assignment-turned-in"><path d="M19 3h-4.18C14.4 1.84 13.3 1 12 1c-1.3 0-2.4.84-2.82 2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7 0c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm-2 14l-4-4 1.41-1.41L10 14.17l6.59-6.59L18 9l-8 8z"></path></g>
<g id="attachment"><path d="M2 12.5C2 9.46 4.46 7 7.5 7H18c2.21 0 4 1.79 4 4s-1.79 4-4 4H9.5C8.12 15 7 13.88 7 12.5S8.12 10 9.5 10H17v2H9.41c-.55 0-.55 1 0 1H18c1.1 0 2-.9 2-2s-.9-2-2-2H7.5C5.57 9 4 10.57 4 12.5S5.57 16 7.5 16H17v2H7.5C4.46 18 2 15.54 2 12.5z"></path></g>
<g id="autorenew"><path d="M12 6v3l4-4-4-4v3c-4.42 0-8 3.58-8 8 0 1.57.46 3.03 1.24 4.26L6.7 14.8c-.45-.83-.7-1.79-.7-2.8 0-3.31 2.69-6 6-6zm6.76 1.74L17.3 9.2c.44.84.7 1.79.7 2.8 0 3.31-2.69 6-6 6v-3l-4 4 4 4v-3c4.42 0 8-3.58 8-8 0-1.57-.46-3.03-1.24-4.26z"></path></g>
<g id="backspace"><path d="M22 3H7c-.69 0-1.23.35-1.59.88L0 12l5.41 8.11c.36.53.9.89 1.59.89h15c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-3 12.59L17.59 17 14 13.41 10.41 17 9 15.59 12.59 12 9 8.41 10.41 7 14 10.59 17.59 7 19 8.41 15.41 12 19 15.59z"></path></g>
<g id="backup"><path d="M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM14 13v4h-4v-4H7l5-5 5 5h-3z"></path></g>
<g id="block"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zM4 12c0-4.42 3.58-8 8-8 1.85 0 3.55.63 4.9 1.69L5.69 16.9C4.63 15.55 4 13.85 4 12zm8 8c-1.85 0-3.55-.63-4.9-1.69L18.31 7.1C19.37 8.45 20 10.15 20 12c0 4.42-3.58 8-8 8z"></path></g>
<g id="book"><path d="M18 2H6c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM6 4h5v8l-2.5-1.5L6 12V4z"></path></g>
<g id="bookmark"><path d="M17 3H7c-1.1 0-1.99.9-1.99 2L5 21l7-3 7 3V5c0-1.1-.9-2-2-2z"></path></g>
<g id="bookmark-border"><path d="M17 3H7c-1.1 0-1.99.9-1.99 2L5 21l7-3 7 3V5c0-1.1-.9-2-2-2zm0 15l-5-2.18L7 18V5h10v13z"></path></g>
<g id="bug-report"><path d="M20 8h-2.81c-.45-.78-1.07-1.45-1.82-1.96L17 4.41 15.59 3l-2.17 2.17C12.96 5.06 12.49 5 12 5c-.49 0-.96.06-1.41.17L8.41 3 7 4.41l1.62 1.63C7.88 6.55 7.26 7.22 6.81 8H4v2h2.09c-.05.33-.09.66-.09 1v1H4v2h2v1c0 .34.04.67.09 1H4v2h2.81c1.04 1.79 2.97 3 5.19 3s4.15-1.21 5.19-3H20v-2h-2.09c.05-.33.09-.66.09-1v-1h2v-2h-2v-1c0-.34-.04-.67-.09-1H20V8zm-6 8h-4v-2h4v2zm0-4h-4v-2h4v2z"></path></g>
<g id="build"><path d="M22.7 19l-9.1-9.1c.9-2.3.4-5-1.5-6.9-2-2-5-2.4-7.4-1.3L9 6 6 9 1.6 4.7C.4 7.1.9 10.1 2.9 12.1c1.9 1.9 4.6 2.4 6.9 1.5l9.1 9.1c.4.4 1 .4 1.4 0l2.3-2.3c.5-.4.5-1.1.1-1.4z"></path></g>
<g id="cached"><path d="M19 8l-4 4h3c0 3.31-2.69 6-6 6-1.01 0-1.97-.25-2.8-.7l-1.46 1.46C8.97 19.54 10.43 20 12 20c4.42 0 8-3.58 8-8h3l-4-4zM6 12c0-3.31 2.69-6 6-6 1.01 0 1.97.25 2.8.7l1.46-1.46C15.03 4.46 13.57 4 12 4c-4.42 0-8 3.58-8 8H1l4 4 4-4H6z"></path></g>
<g id="camera-enhance"><path d="M9 3L7.17 5H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2h-3.17L15 3H9zm3 15c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-1l1.25-2.75L16 13l-2.75-1.25L12 9l-1.25 2.75L8 13l2.75 1.25z"></path></g>
<g id="cancel"><path d="M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm5 13.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z"></path></g>
<g id="card-giftcard"><path d="M20 6h-2.18c.11-.31.18-.65.18-1 0-1.66-1.34-3-3-3-1.05 0-1.96.54-2.5 1.35l-.5.67-.5-.68C10.96 2.54 10.05 2 9 2 7.34 2 6 3.34 6 5c0 .35.07.69.18 1H4c-1.11 0-1.99.89-1.99 2L2 19c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V8c0-1.11-.89-2-2-2zm-5-2c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zM9 4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm11 15H4v-2h16v2zm0-5H4V8h5.08L7 10.83 8.62 12 11 8.76l1-1.36 1 1.36L15.38 12 17 10.83 14.92 8H20v6z"></path></g>
<g id="card-membership"><path d="M20 2H4c-1.11 0-2 .89-2 2v11c0 1.11.89 2 2 2h4v5l4-2 4 2v-5h4c1.11 0 2-.89 2-2V4c0-1.11-.89-2-2-2zm0 13H4v-2h16v2zm0-5H4V4h16v6z"></path></g>
<g id="card-travel"><path d="M20 6h-3V4c0-1.11-.89-2-2-2H9c-1.11 0-2 .89-2 2v2H4c-1.11 0-2 .89-2 2v11c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V8c0-1.11-.89-2-2-2zM9 4h6v2H9V4zm11 15H4v-2h16v2zm0-5H4V8h3v2h2V8h6v2h2V8h3v6z"></path></g>
<g id="change-history"><path d="M12 7.77L18.39 18H5.61L12 7.77M12 4L2 20h20L12 4z"></path></g>
<g id="check"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"></path></g>
<g id="check-box"><path d="M19 3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.11 0 2-.9 2-2V5c0-1.1-.89-2-2-2zm-9 14l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"></path></g>
<g id="check-box-outline-blank"><path d="M19 5v14H5V5h14m0-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2z"></path></g>
<g id="check-circle"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"></path></g>
<g id="chevron-left"><path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"></path></g>
<g id="chevron-right"><path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"></path></g>
<g id="chrome-reader-mode"><path d="M13 12h7v1.5h-7zm0-2.5h7V11h-7zm0 5h7V16h-7zM21 4H3c-1.1 0-2 .9-2 2v13c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 15h-9V6h9v13z"></path></g>
<g id="class"><path d="M18 2H6c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM6 4h5v8l-2.5-1.5L6 12V4z"></path></g>
<g id="clear"><path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"></path></g>
<g id="close"><path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"></path></g>
<g id="cloud"><path d="M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96z"></path></g>
<g id="cloud-circle"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm4.5 14H8c-1.66 0-3-1.34-3-3s1.34-3 3-3l.14.01C8.58 8.28 10.13 7 12 7c2.21 0 4 1.79 4 4h.5c1.38 0 2.5 1.12 2.5 2.5S17.88 16 16.5 16z"></path></g>
<g id="cloud-done"><path d="M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM10 17l-3.5-3.5 1.41-1.41L10 14.17 15.18 9l1.41 1.41L10 17z"></path></g>
<g id="cloud-download"><path d="M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM17 13l-5 5-5-5h3V9h4v4h3z"></path></g>
<g id="cloud-off"><path d="M19.35 10.04C18.67 6.59 15.64 4 12 4c-1.48 0-2.85.43-4.01 1.17l1.46 1.46C10.21 6.23 11.08 6 12 6c3.04 0 5.5 2.46 5.5 5.5v.5H19c1.66 0 3 1.34 3 3 0 1.13-.64 2.11-1.56 2.62l1.45 1.45C23.16 18.16 24 16.68 24 15c0-2.64-2.05-4.78-4.65-4.96zM3 5.27l2.75 2.74C2.56 8.15 0 10.77 0 14c0 3.31 2.69 6 6 6h11.73l2 2L21 20.73 4.27 4 3 5.27zM7.73 10l8 8H6c-2.21 0-4-1.79-4-4s1.79-4 4-4h1.73z"></path></g>
<g id="cloud-queue"><path d="M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM19 18H6c-2.21 0-4-1.79-4-4s1.79-4 4-4h.71C7.37 7.69 9.48 6 12 6c3.04 0 5.5 2.46 5.5 5.5v.5H19c1.66 0 3 1.34 3 3s-1.34 3-3 3z"></path></g>
<g id="cloud-upload"><path d="M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM14 13v4h-4v-4H7l5-5 5 5h-3z"></path></g>
<g id="code"><path d="M9.4 16.6L4.8 12l4.6-4.6L8 6l-6 6 6 6 1.4-1.4zm5.2 0l4.6-4.6-4.6-4.6L16 6l6 6-6 6-1.4-1.4z"></path></g>
<g id="compare-arrows"><path d="M9.01 14H2v2h7.01v3L13 15l-3.99-4v3zm5.98-1v-3H22V8h-7.01V5L11 9l3.99 4z"></path></g>
<g id="content-copy"><path d="M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"></path></g>
<g id="content-cut"><path d="M9.64 7.64c.23-.5.36-1.05.36-1.64 0-2.21-1.79-4-4-4S2 3.79 2 6s1.79 4 4 4c.59 0 1.14-.13 1.64-.36L10 12l-2.36 2.36C7.14 14.13 6.59 14 6 14c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4c0-.59-.13-1.14-.36-1.64L12 14l7 7h3v-1L9.64 7.64zM6 8c-1.1 0-2-.89-2-2s.9-2 2-2 2 .89 2 2-.9 2-2 2zm0 12c-1.1 0-2-.89-2-2s.9-2 2-2 2 .89 2 2-.9 2-2 2zm6-7.5c-.28 0-.5-.22-.5-.5s.22-.5.5-.5.5.22.5.5-.22.5-.5.5zM19 3l-6 6 2 2 7-7V3z"></path></g>
<g id="content-paste"><path d="M19 2h-4.18C14.4.84 13.3 0 12 0c-1.3 0-2.4.84-2.82 2H5c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-7 0c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm7 18H5V4h2v3h10V4h2v16z"></path></g>
<g id="copyright"><path d="M10.08 10.86c.05-.33.16-.62.3-.87s.34-.46.59-.62c.24-.15.54-.22.91-.23.23.01.44.05.63.13.2.09.38.21.52.36s.25.33.34.53.13.42.14.64h1.79c-.02-.47-.11-.9-.28-1.29s-.4-.73-.7-1.01-.66-.5-1.08-.66-.88-.23-1.39-.23c-.65 0-1.22.11-1.7.34s-.88.53-1.2.92-.56.84-.71 1.36S8 11.29 8 11.87v.27c0 .58.08 1.12.23 1.64s.39.97.71 1.35.72.69 1.2.91 1.05.34 1.7.34c.47 0 .91-.08 1.32-.23s.77-.36 1.08-.63.56-.58.74-.94.29-.74.3-1.15h-1.79c-.01.21-.06.4-.15.58s-.21.33-.36.46-.32.23-.52.3c-.19.07-.39.09-.6.1-.36-.01-.66-.08-.89-.23-.25-.16-.45-.37-.59-.62s-.25-.55-.3-.88-.08-.67-.08-1v-.27c0-.35.03-.68.08-1.01zM12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z"></path></g>
<g id="create"><path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"></path></g>
<g id="create-new-folder"><path d="M20 6h-8l-2-2H4c-1.11 0-1.99.89-1.99 2L2 18c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V8c0-1.11-.89-2-2-2zm-1 8h-3v3h-2v-3h-3v-2h3V9h2v3h3v2z"></path></g>
<g id="credit-card"><path d="M20 4H4c-1.11 0-1.99.89-1.99 2L2 18c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V6c0-1.11-.89-2-2-2zm0 14H4v-6h16v6zm0-10H4V6h16v2z"></path></g>
<g id="dashboard"><path d="M3 13h8V3H3v10zm0 8h8v-6H3v6zm10 0h8V11h-8v10zm0-18v6h8V3h-8z"></path></g>
<g id="date-range"><path d="M9 11H7v2h2v-2zm4 0h-2v2h2v-2zm4 0h-2v2h2v-2zm2-7h-1V2h-2v2H8V2H6v2H5c-1.11 0-1.99.9-1.99 2L3 20c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 16H5V9h14v11z"></path></g>
<g id="delete"><path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"></path></g>
<g id="delete-forever"><path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zm2.46-7.12l1.41-1.41L12 12.59l2.12-2.12 1.41 1.41L13.41 14l2.12 2.12-1.41 1.41L12 15.41l-2.12 2.12-1.41-1.41L10.59 14l-2.13-2.12zM15.5 4l-1-1h-5l-1 1H5v2h14V4z"></path></g>
<g id="delete-sweep"><path d="M15 16h4v2h-4zm0-8h7v2h-7zm0 4h6v2h-6zM3 18c0 1.1.9 2 2 2h6c1.1 0 2-.9 2-2V8H3v10zM14 5h-3l-1-1H6L5 5H2v2h12z"></path></g>
<g id="description"><path d="M14 2H6c-1.1 0-1.99.9-1.99 2L4 20c0 1.1.89 2 1.99 2H18c1.1 0 2-.9 2-2V8l-6-6zm2 16H8v-2h8v2zm0-4H8v-2h8v2zm-3-5V3.5L18.5 9H13z"></path></g>
<g id="dns"><path d="M20 13H4c-.55 0-1 .45-1 1v6c0 .55.45 1 1 1h16c.55 0 1-.45 1-1v-6c0-.55-.45-1-1-1zM7 19c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zM20 3H4c-.55 0-1 .45-1 1v6c0 .55.45 1 1 1h16c.55 0 1-.45 1-1V4c0-.55-.45-1-1-1zM7 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z"></path></g>
<g id="done"><path d="M9 16.2L4.8 12l-1.4 1.4L9 19 21 7l-1.4-1.4L9 16.2z"></path></g>
<g id="done-all"><path d="M18 7l-1.41-1.41-6.34 6.34 1.41 1.41L18 7zm4.24-1.41L11.66 16.17 7.48 12l-1.41 1.41L11.66 19l12-12-1.42-1.41zM.41 13.41L6 19l1.41-1.41L1.83 12 .41 13.41z"></path></g>
<g id="donut-large"><path d="M11 5.08V2c-5 .5-9 4.81-9 10s4 9.5 9 10v-3.08c-3-.48-6-3.4-6-6.92s3-6.44 6-6.92zM18.97 11H22c-.47-5-4-8.53-9-9v3.08C16 5.51 18.54 8 18.97 11zM13 18.92V22c5-.47 8.53-4 9-9h-3.03c-.43 3-2.97 5.49-5.97 5.92z"></path></g>
<g id="donut-small"><path d="M11 9.16V2c-5 .5-9 4.79-9 10s4 9.5 9 10v-7.16c-1-.41-2-1.52-2-2.84s1-2.43 2-2.84zM14.86 11H22c-.48-4.75-4-8.53-9-9v7.16c1 .3 1.52.98 1.86 1.84zM13 14.84V22c5-.47 8.52-4.25 9-9h-7.14c-.34.86-.86 1.54-1.86 1.84z"></path></g>
<g id="drafts"><path d="M21.99 8c0-.72-.37-1.35-.94-1.7L12 1 2.95 6.3C2.38 6.65 2 7.28 2 8v10c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2l-.01-10zM12 13L3.74 7.84 12 3l8.26 4.84L12 13z"></path></g>
<g id="eject"><path d="M5 17h14v2H5zm7-12L5.33 15h13.34z"></path></g>
<g id="error"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"></path></g>
<g id="error-outline"><path d="M11 15h2v2h-2zm0-8h2v6h-2zm.99-5C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z"></path></g>
<g id="euro-symbol"><path d="M15 18.5c-2.51 0-4.68-1.42-5.76-3.5H15v-2H8.58c-.05-.33-.08-.66-.08-1s.03-.67.08-1H15V9H9.24C10.32 6.92 12.5 5.5 15 5.5c1.61 0 3.09.59 4.23 1.57L21 5.3C19.41 3.87 17.3 3 15 3c-3.92 0-7.24 2.51-8.48 6H3v2h3.06c-.04.33-.06.66-.06 1 0 .34.02.67.06 1H3v2h3.52c1.24 3.49 4.56 6 8.48 6 2.31 0 4.41-.87 6-2.3l-1.78-1.77c-1.13.98-2.6 1.57-4.22 1.57z"></path></g>
<g id="event"><path d="M17 12h-5v5h5v-5zM16 1v2H8V1H6v2H5c-1.11 0-1.99.9-1.99 2L3 19c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2h-1V1h-2zm3 18H5V8h14v11z"></path></g>
<g id="event-seat"><path d="M4 18v3h3v-3h10v3h3v-6H4zm15-8h3v3h-3zM2 10h3v3H2zm15 3H7V5c0-1.1.9-2 2-2h6c1.1 0 2 .9 2 2v8z"></path></g>
<g id="exit-to-app"><path d="M10.09 15.59L11.5 17l5-5-5-5-1.41 1.41L12.67 11H3v2h9.67l-2.58 2.59zM19 3H5c-1.11 0-2 .9-2 2v4h2V5h14v14H5v-4H3v4c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2z"></path></g>
<g id="expand-less"><path d="M12 8l-6 6 1.41 1.41L12 10.83l4.59 4.58L18 14z"></path></g>
<g id="expand-more"><path d="M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6z"></path></g>
<g id="explore"><path d="M12 10.9c-.61 0-1.1.49-1.1 1.1s.49 1.1 1.1 1.1c.61 0 1.1-.49 1.1-1.1s-.49-1.1-1.1-1.1zM12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm2.19 12.19L6 18l3.81-8.19L18 6l-3.81 8.19z"></path></g>
<g id="extension"><path d="M20.5 11H19V7c0-1.1-.9-2-2-2h-4V3.5C13 2.12 11.88 1 10.5 1S8 2.12 8 3.5V5H4c-1.1 0-1.99.9-1.99 2v3.8H3.5c1.49 0 2.7 1.21 2.7 2.7s-1.21 2.7-2.7 2.7H2V20c0 1.1.9 2 2 2h3.8v-1.5c0-1.49 1.21-2.7 2.7-2.7 1.49 0 2.7 1.21 2.7 2.7V22H17c1.1 0 2-.9 2-2v-4h1.5c1.38 0 2.5-1.12 2.5-2.5S21.88 11 20.5 11z"></path></g>
<g id="face"><path d="M9 11.75c-.69 0-1.25.56-1.25 1.25s.56 1.25 1.25 1.25 1.25-.56 1.25-1.25-.56-1.25-1.25-1.25zm6 0c-.69 0-1.25.56-1.25 1.25s.56 1.25 1.25 1.25 1.25-.56 1.25-1.25-.56-1.25-1.25-1.25zM12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8 0-.29.02-.58.05-.86 2.36-1.05 4.23-2.98 5.21-5.37C11.07 8.33 14.05 10 17.42 10c.78 0 1.53-.09 2.25-.26.21.71.33 1.47.33 2.26 0 4.41-3.59 8-8 8z"></path></g>
<g id="favorite"><path d="M12 21.35l-1.45-1.32C5.4 15.36 2 12.28 2 8.5 2 5.42 4.42 3 7.5 3c1.74 0 3.41.81 4.5 2.09C13.09 3.81 14.76 3 16.5 3 19.58 3 22 5.42 22 8.5c0 3.78-3.4 6.86-8.55 11.54L12 21.35z"></path></g>
<g id="favorite-border"><path d="M16.5 3c-1.74 0-3.41.81-4.5 2.09C10.91 3.81 9.24 3 7.5 3 4.42 3 2 5.42 2 8.5c0 3.78 3.4 6.86 8.55 11.54L12 21.35l1.45-1.32C18.6 15.36 22 12.28 22 8.5 22 5.42 19.58 3 16.5 3zm-4.4 15.55l-.1.1-.1-.1C7.14 14.24 4 11.39 4 8.5 4 6.5 5.5 5 7.5 5c1.54 0 3.04.99 3.57 2.36h1.87C13.46 5.99 14.96 5 16.5 5c2 0 3.5 1.5 3.5 3.5 0 2.89-3.14 5.74-7.9 10.05z"></path></g>
<g id="feedback"><path d="M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-7 12h-2v-2h2v2zm0-4h-2V6h2v4z"></path></g>
<g id="file-download"><path d="M19 9h-4V3H9v6H5l7 7 7-7zM5 18v2h14v-2H5z"></path></g>
<g id="file-upload"><path d="M9 16h6v-6h4l-7-7-7 7h4zm-4 2h14v2H5z"></path></g>
<g id="filter-list"><path d="M10 18h4v-2h-4v2zM3 6v2h18V6H3zm3 7h12v-2H6v2z"></path></g>
<g id="find-in-page"><path d="M20 19.59V8l-6-6H6c-1.1 0-1.99.9-1.99 2L4 20c0 1.1.89 2 1.99 2H18c.45 0 .85-.15 1.19-.4l-4.43-4.43c-.8.52-1.74.83-2.76.83-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5c0 1.02-.31 1.96-.83 2.75L20 19.59zM9 13c0 1.66 1.34 3 3 3s3-1.34 3-3-1.34-3-3-3-3 1.34-3 3z"></path></g>
<g id="find-replace"><path d="M11 6c1.38 0 2.63.56 3.54 1.46L12 10h6V4l-2.05 2.05C14.68 4.78 12.93 4 11 4c-3.53 0-6.43 2.61-6.92 6H6.1c.46-2.28 2.48-4 4.9-4zm5.64 9.14c.66-.9 1.12-1.97 1.28-3.14H15.9c-.46 2.28-2.48 4-4.9 4-1.38 0-2.63-.56-3.54-1.46L10 12H4v6l2.05-2.05C7.32 17.22 9.07 18 11 18c1.55 0 2.98-.51 4.14-1.36L20 21.49 21.49 20l-4.85-4.86z"></path></g>
<g id="fingerprint"><path d="M17.81 4.47c-.08 0-.16-.02-.23-.06C15.66 3.42 14 3 12.01 3c-1.98 0-3.86.47-5.57 1.41-.24.13-.54.04-.68-.2-.13-.24-.04-.55.2-.68C7.82 2.52 9.86 2 12.01 2c2.13 0 3.99.47 6.03 1.52.25.13.34.43.21.67-.09.18-.26.28-.44.28zM3.5 9.72c-.1 0-.2-.03-.29-.09-.23-.16-.28-.47-.12-.7.99-1.4 2.25-2.5 3.75-3.27C9.98 4.04 14 4.03 17.15 5.65c1.5.77 2.76 1.86 3.75 3.25.16.22.11.54-.12.7-.23.16-.54.11-.7-.12-.9-1.26-2.04-2.25-3.39-2.94-2.87-1.47-6.54-1.47-9.4.01-1.36.7-2.5 1.7-3.4 2.96-.08.14-.23.21-.39.21zm6.25 12.07c-.13 0-.26-.05-.35-.15-.87-.87-1.34-1.43-2.01-2.64-.69-1.23-1.05-2.73-1.05-4.34 0-2.97 2.54-5.39 5.66-5.39s5.66 2.42 5.66 5.39c0 .28-.22.5-.5.5s-.5-.22-.5-.5c0-2.42-2.09-4.39-4.66-4.39-2.57 0-4.66 1.97-4.66 4.39 0 1.44.32 2.77.93 3.85.64 1.15 1.08 1.64 1.85 2.42.19.2.19.51 0 .71-.11.1-.24.15-.37.15zm7.17-1.85c-1.19 0-2.24-.3-3.1-.89-1.49-1.01-2.38-2.65-2.38-4.39 0-.28.22-.5.5-.5s.5.22.5.5c0 1.41.72 2.74 1.94 3.56.71.48 1.54.71 2.54.71.24 0 .64-.03 1.04-.1.27-.05.53.13.58.41.05.27-.13.53-.41.58-.57.11-1.07.12-1.21.12zM14.91 22c-.04 0-.09-.01-.13-.02-1.59-.44-2.63-1.03-3.72-2.1-1.4-1.39-2.17-3.24-2.17-5.22 0-1.62 1.38-2.94 3.08-2.94 1.7 0 3.08 1.32 3.08 2.94 0 1.07.93 1.94 2.08 1.94s2.08-.87 2.08-1.94c0-3.77-3.25-6.83-7.25-6.83-2.84 0-5.44 1.58-6.61 4.03-.39.81-.59 1.76-.59 2.8 0 .78.07 2.01.67 3.61.1.26-.03.55-.29.64-.26.1-.55-.04-.64-.29-.49-1.31-.73-2.61-.73-3.96 0-1.2.23-2.29.68-3.24 1.33-2.79 4.28-4.6 7.51-4.6 4.55 0 8.25 3.51 8.25 7.83 0 1.62-1.38 2.94-3.08 2.94s-3.08-1.32-3.08-2.94c0-1.07-.93-1.94-2.08-1.94s-2.08.87-2.08 1.94c0 1.71.66 3.31 1.87 4.51.95.94 1.86 1.46 3.27 1.85.27.07.42.35.35.61-.05.23-.26.38-.47.38z"></path></g>
<g id="first-page"><path d="M18.41 16.59L13.82 12l4.59-4.59L17 6l-6 6 6 6zM6 6h2v12H6z"></path></g>
<g id="flag"><path d="M14.4 6L14 4H5v17h2v-7h5.6l.4 2h7V6z"></path></g>
<g id="flight-land"><path d="M2.5 19h19v2h-19zm7.18-5.73l4.35 1.16 5.31 1.42c.8.21 1.62-.26 1.84-1.06.21-.8-.26-1.62-1.06-1.84l-5.31-1.42-2.76-9.02L10.12 2v8.28L5.15 8.95l-.93-2.32-1.45-.39v5.17l1.6.43 5.31 1.43z"></path></g>
<g id="flight-takeoff"><path d="M2.5 19h19v2h-19zm19.57-9.36c-.21-.8-1.04-1.28-1.84-1.06L14.92 10l-6.9-6.43-1.93.51 4.14 7.17-4.97 1.33-1.97-1.54-1.45.39 1.82 3.16.77 1.33 1.6-.43 5.31-1.42 4.35-1.16L21 11.49c.81-.23 1.28-1.05 1.07-1.85z"></path></g>
<g id="flip-to-back"><path d="M9 7H7v2h2V7zm0 4H7v2h2v-2zm0-8c-1.11 0-2 .9-2 2h2V3zm4 12h-2v2h2v-2zm6-12v2h2c0-1.1-.9-2-2-2zm-6 0h-2v2h2V3zM9 17v-2H7c0 1.1.89 2 2 2zm10-4h2v-2h-2v2zm0-4h2V7h-2v2zm0 8c1.1 0 2-.9 2-2h-2v2zM5 7H3v12c0 1.1.89 2 2 2h12v-2H5V7zm10-2h2V3h-2v2zm0 12h2v-2h-2v2z"></path></g>
<g id="flip-to-front"><path d="M3 13h2v-2H3v2zm0 4h2v-2H3v2zm2 4v-2H3c0 1.1.89 2 2 2zM3 9h2V7H3v2zm12 12h2v-2h-2v2zm4-18H9c-1.11 0-2 .9-2 2v10c0 1.1.89 2 2 2h10c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 12H9V5h10v10zm-8 6h2v-2h-2v2zm-4 0h2v-2H7v2z"></path></g>
<g id="folder"><path d="M10 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2h-8l-2-2z"></path></g>
<g id="folder-open"><path d="M20 6h-8l-2-2H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm0 12H4V8h16v10z"></path></g>
<g id="folder-shared"><path d="M20 6h-8l-2-2H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm-5 3c1.1 0 2 .9 2 2s-.9 2-2 2-2-.9-2-2 .9-2 2-2zm4 8h-8v-1c0-1.33 2.67-2 4-2s4 .67 4 2v1z"></path></g>
<g id="font-download"><path d="M9.93 13.5h4.14L12 7.98zM20 2H4c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-4.05 16.5l-1.14-3H9.17l-1.12 3H5.96l5.11-13h1.86l5.11 13h-2.09z"></path></g>
<g id="forward"><path d="M12 8V4l8 8-8 8v-4H4V8z"></path></g>
<g id="fullscreen"><path d="M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z"></path></g>
<g id="fullscreen-exit"><path d="M5 16h3v3h2v-5H5v2zm3-8H5v2h5V5H8v3zm6 11h2v-3h3v-2h-5v5zm2-11V5h-2v5h5V8h-3z"></path></g>
<g id="g-translate"><path d="M20 5h-9.12L10 2H4c-1.1 0-2 .9-2 2v13c0 1.1.9 2 2 2h7l1 3h8c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zM7.17 14.59c-2.25 0-4.09-1.83-4.09-4.09s1.83-4.09 4.09-4.09c1.04 0 1.99.37 2.74 1.07l.07.06-1.23 1.18-.06-.05c-.29-.27-.78-.59-1.52-.59-1.31 0-2.38 1.09-2.38 2.42s1.07 2.42 2.38 2.42c1.37 0 1.96-.87 2.12-1.46H7.08V9.91h3.95l.01.07c.04.21.05.4.05.61 0 2.35-1.61 4-3.92 4zm6.03-1.71c.33.6.74 1.18 1.19 1.7l-.54.53-.65-2.23zm.77-.76h-.99l-.31-1.04h3.99s-.34 1.31-1.56 2.74c-.52-.62-.89-1.23-1.13-1.7zM21 20c0 .55-.45 1-1 1h-7l2-2-.81-2.77.92-.92L17.79 18l.73-.73-2.71-2.68c.9-1.03 1.6-2.25 1.92-3.51H19v-1.04h-3.64V9h-1.04v1.04h-1.96L11.18 6H20c.55 0 1 .45 1 1v13z"></path></g>
<g id="gavel"><path d="M1 21h12v2H1zM5.245 8.07l2.83-2.827 14.14 14.142-2.828 2.828zM12.317 1l5.657 5.656-2.83 2.83-5.654-5.66zM3.825 9.485l5.657 5.657-2.828 2.828-5.657-5.657z"></path></g>
<g id="gesture"><path d="M4.59 6.89c.7-.71 1.4-1.35 1.71-1.22.5.2 0 1.03-.3 1.52-.25.42-2.86 3.89-2.86 6.31 0 1.28.48 2.34 1.34 2.98.75.56 1.74.73 2.64.46 1.07-.31 1.95-1.4 3.06-2.77 1.21-1.49 2.83-3.44 4.08-3.44 1.63 0 1.65 1.01 1.76 1.79-3.78.64-5.38 3.67-5.38 5.37 0 1.7 1.44 3.09 3.21 3.09 1.63 0 4.29-1.33 4.69-6.1H21v-2.5h-2.47c-.15-1.65-1.09-4.2-4.03-4.2-2.25 0-4.18 1.91-4.94 2.84-.58.73-2.06 2.48-2.29 2.72-.25.3-.68.84-1.11.84-.45 0-.72-.83-.36-1.92.35-1.09 1.4-2.86 1.85-3.52.78-1.14 1.3-1.92 1.3-3.28C8.95 3.69 7.31 3 6.44 3 5.12 3 3.97 4 3.72 4.25c-.36.36-.66.66-.88.93l1.75 1.71zm9.29 11.66c-.31 0-.74-.26-.74-.72 0-.6.73-2.2 2.87-2.76-.3 2.69-1.43 3.48-2.13 3.48z"></path></g>
<g id="get-app"><path d="M19 9h-4V3H9v6H5l7 7 7-7zM5 18v2h14v-2H5z"></path></g>
<g id="gif"><path d="M11.5 9H13v6h-1.5zM9 9H6c-.6 0-1 .5-1 1v4c0 .5.4 1 1 1h3c.6 0 1-.5 1-1v-2H8.5v1.5h-2v-3H10V10c0-.5-.4-1-1-1zm10 1.5V9h-4.5v6H16v-2h2v-1.5h-2v-1z"></path></g>
<g id="grade"><path d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z"></path></g>
<g id="group-work"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zM8 17.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5zM9.5 8c0-1.38 1.12-2.5 2.5-2.5s2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5S9.5 9.38 9.5 8zm6.5 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"></path></g>
<g id="help"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 17h-2v-2h2v2zm2.07-7.75l-.9.92C13.45 12.9 13 13.5 13 15h-2v-.5c0-1.1.45-2.1 1.17-2.83l1.24-1.26c.37-.36.59-.86.59-1.41 0-1.1-.9-2-2-2s-2 .9-2 2H8c0-2.21 1.79-4 4-4s4 1.79 4 4c0 .88-.36 1.68-.93 2.25z"></path></g>
<g id="help-outline"><path d="M11 18h2v-2h-2v2zm1-16C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm0-14c-2.21 0-4 1.79-4 4h2c0-1.1.9-2 2-2s2 .9 2 2c0 2-3 1.75-3 5h2c0-2.25 3-2.5 3-5 0-2.21-1.79-4-4-4z"></path></g>
<g id="highlight-off"><path d="M14.59 8L12 10.59 9.41 8 8 9.41 10.59 12 8 14.59 9.41 16 12 13.41 14.59 16 16 14.59 13.41 12 16 9.41 14.59 8zM12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z"></path></g>
<g id="history"><path d="M13 3c-4.97 0-9 4.03-9 9H1l3.89 3.89.07.14L9 12H6c0-3.87 3.13-7 7-7s7 3.13 7 7-3.13 7-7 7c-1.93 0-3.68-.79-4.94-2.06l-1.42 1.42C8.27 19.99 10.51 21 13 21c4.97 0 9-4.03 9-9s-4.03-9-9-9zm-1 5v5l4.28 2.54.72-1.21-3.5-2.08V8H12z"></path></g>
<g id="home"><path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"></path></g>
<g id="hourglass-empty"><path d="M6 2v6h.01L6 8.01 10 12l-4 4 .01.01H6V22h12v-5.99h-.01L18 16l-4-4 4-3.99-.01-.01H18V2H6zm10 14.5V20H8v-3.5l4-4 4 4zm-4-5l-4-4V4h8v3.5l-4 4z"></path></g>
<g id="hourglass-full"><path d="M6 2v6h.01L6 8.01 10 12l-4 4 .01.01H6V22h12v-5.99h-.01L18 16l-4-4 4-3.99-.01-.01H18V2H6z"></path></g>
<g id="http"><path d="M4.5 11h-2V9H1v6h1.5v-2.5h2V15H6V9H4.5v2zm2.5-.5h1.5V15H10v-4.5h1.5V9H7v1.5zm5.5 0H14V15h1.5v-4.5H17V9h-4.5v1.5zm9-1.5H18v6h1.5v-2h2c.8 0 1.5-.7 1.5-1.5v-1c0-.8-.7-1.5-1.5-1.5zm0 2.5h-2v-1h2v1z"></path></g>
<g id="https"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm-6 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm3.1-9H8.9V6c0-1.71 1.39-3.1 3.1-3.1 1.71 0 3.1 1.39 3.1 3.1v2z"></path></g>
<g id="important-devices"><path d="M23 11.01L18 11c-.55 0-1 .45-1 1v9c0 .55.45 1 1 1h5c.55 0 1-.45 1-1v-9c0-.55-.45-.99-1-.99zM23 20h-5v-7h5v7zM20 2H2C.89 2 0 2.89 0 4v12c0 1.1.89 2 2 2h7v2H7v2h8v-2h-2v-2h2v-2H2V4h18v5h2V4c0-1.11-.9-2-2-2zm-8.03 7L11 6l-.97 3H7l2.47 1.76-.94 2.91 2.47-1.8 2.47 1.8-.94-2.91L15 9h-3.03z"></path></g>
<g id="inbox"><path d="M19 3H4.99c-1.11 0-1.98.89-1.98 2L3 19c0 1.1.88 2 1.99 2H19c1.1 0 2-.9 2-2V5c0-1.11-.9-2-2-2zm0 12h-4c0 1.66-1.35 3-3 3s-3-1.34-3-3H4.99V5H19v10z"></path></g>
<g id="indeterminate-check-box"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-2 10H7v-2h10v2z"></path></g>
<g id="info"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z"></path></g>
<g id="info-outline"><path d="M11 17h2v-6h-2v6zm1-15C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zM11 9h2V7h-2v2z"></path></g>
<g id="input"><path d="M21 3.01H3c-1.1 0-2 .9-2 2V9h2V4.99h18v14.03H3V15H1v4.01c0 1.1.9 1.98 2 1.98h18c1.1 0 2-.88 2-1.98v-14c0-1.11-.9-2-2-2zM11 16l4-4-4-4v3H1v2h10v3z"></path></g>
<g id="invert-colors"><path d="M17.66 7.93L12 2.27 6.34 7.93c-3.12 3.12-3.12 8.19 0 11.31C7.9 20.8 9.95 21.58 12 21.58c2.05 0 4.1-.78 5.66-2.34 3.12-3.12 3.12-8.19 0-11.31zM12 19.59c-1.6 0-3.11-.62-4.24-1.76C6.62 16.69 6 15.19 6 13.59s.62-3.11 1.76-4.24L12 5.1v14.49z"></path></g>
<g id="label"><path d="M17.63 5.84C17.27 5.33 16.67 5 16 5L5 5.01C3.9 5.01 3 5.9 3 7v10c0 1.1.9 1.99 2 1.99L16 19c.67 0 1.27-.33 1.63-.84L22 12l-4.37-6.16z"></path></g>
<g id="label-outline"><path d="M17.63 5.84C17.27 5.33 16.67 5 16 5L5 5.01C3.9 5.01 3 5.9 3 7v10c0 1.1.9 1.99 2 1.99L16 19c.67 0 1.27-.33 1.63-.84L22 12l-4.37-6.16zM16 17H5V7h11l3.55 5L16 17z"></path></g>
<g id="language"><path d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zm6.93 6h-2.95c-.32-1.25-.78-2.45-1.38-3.56 1.84.63 3.37 1.91 4.33 3.56zM12 4.04c.83 1.2 1.48 2.53 1.91 3.96h-3.82c.43-1.43 1.08-2.76 1.91-3.96zM4.26 14C4.1 13.36 4 12.69 4 12s.1-1.36.26-2h3.38c-.08.66-.14 1.32-.14 2 0 .68.06 1.34.14 2H4.26zm.82 2h2.95c.32 1.25.78 2.45 1.38 3.56-1.84-.63-3.37-1.9-4.33-3.56zm2.95-8H5.08c.96-1.66 2.49-2.93 4.33-3.56C8.81 5.55 8.35 6.75 8.03 8zM12 19.96c-.83-1.2-1.48-2.53-1.91-3.96h3.82c-.43 1.43-1.08 2.76-1.91 3.96zM14.34 14H9.66c-.09-.66-.16-1.32-.16-2 0-.68.07-1.35.16-2h4.68c.09.65.16 1.32.16 2 0 .68-.07 1.34-.16 2zm.25 5.56c.6-1.11 1.06-2.31 1.38-3.56h2.95c-.96 1.65-2.49 2.93-4.33 3.56zM16.36 14c.08-.66.14-1.32.14-2 0-.68-.06-1.34-.14-2h3.38c.16.64.26 1.31.26 2s-.1 1.36-.26 2h-3.38z"></path></g>
<g id="last-page"><path d="M5.59 7.41L10.18 12l-4.59 4.59L7 18l6-6-6-6zM16 6h2v12h-2z"></path></g>
<g id="launch"><path d="M19 19H5V5h7V3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2v-7h-2v7zM14 3v2h3.59l-9.83 9.83 1.41 1.41L19 6.41V10h2V3h-7z"></path></g>
<g id="lightbulb-outline"><path d="M9 21c0 .55.45 1 1 1h4c.55 0 1-.45 1-1v-1H9v1zm3-19C8.14 2 5 5.14 5 9c0 2.38 1.19 4.47 3 5.74V17c0 .55.45 1 1 1h6c.55 0 1-.45 1-1v-2.26c1.81-1.27 3-3.36 3-5.74 0-3.86-3.14-7-7-7zm2.85 11.1l-.85.6V16h-4v-2.3l-.85-.6C7.8 12.16 7 10.63 7 9c0-2.76 2.24-5 5-5s5 2.24 5 5c0 1.63-.8 3.16-2.15 4.1z"></path></g>
<g id="line-style"><path d="M3 16h5v-2H3v2zm6.5 0h5v-2h-5v2zm6.5 0h5v-2h-5v2zM3 20h2v-2H3v2zm4 0h2v-2H7v2zm4 0h2v-2h-2v2zm4 0h2v-2h-2v2zm4 0h2v-2h-2v2zM3 12h8v-2H3v2zm10 0h8v-2h-8v2zM3 4v4h18V4H3z"></path></g>
<g id="line-weight"><path d="M3 17h18v-2H3v2zm0 3h18v-1H3v1zm0-7h18v-3H3v3zm0-9v4h18V4H3z"></path></g>
<g id="link"><path d="M3.9 12c0-1.71 1.39-3.1 3.1-3.1h4V7H7c-2.76 0-5 2.24-5 5s2.24 5 5 5h4v-1.9H7c-1.71 0-3.1-1.39-3.1-3.1zM8 13h8v-2H8v2zm9-6h-4v1.9h4c1.71 0 3.1 1.39 3.1 3.1s-1.39 3.1-3.1 3.1h-4V17h4c2.76 0 5-2.24 5-5s-2.24-5-5-5z"></path></g>
<g id="list"><path d="M3 13h2v-2H3v2zm0 4h2v-2H3v2zm0-8h2V7H3v2zm4 4h14v-2H7v2zm0 4h14v-2H7v2zM7 7v2h14V7H7z"></path></g>
<g id="lock"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm-6 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm3.1-9H8.9V6c0-1.71 1.39-3.1 3.1-3.1 1.71 0 3.1 1.39 3.1 3.1v2z"></path></g>
<g id="lock-open"><path d="M12 17c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm6-9h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6h1.9c0-1.71 1.39-3.1 3.1-3.1 1.71 0 3.1 1.39 3.1 3.1v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm0 12H6V10h12v10z"></path></g>
<g id="lock-outline"><path d="M12 17c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm6-9h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zM8.9 6c0-1.71 1.39-3.1 3.1-3.1s3.1 1.39 3.1 3.1v2H8.9V6zM18 20H6V10h12v10z"></path></g>
<g id="low-priority"><path d="M14 5h8v2h-8zm0 5.5h8v2h-8zm0 5.5h8v2h-8zM2 11.5C2 15.08 4.92 18 8.5 18H9v2l3-3-3-3v2h-.5C6.02 16 4 13.98 4 11.5S6.02 7 8.5 7H12V5H8.5C4.92 5 2 7.92 2 11.5z"></path></g>
<g id="loyalty"><path d="M21.41 11.58l-9-9C12.05 2.22 11.55 2 11 2H4c-1.1 0-2 .9-2 2v7c0 .55.22 1.05.59 1.42l9 9c.36.36.86.58 1.41.58.55 0 1.05-.22 1.41-.59l7-7c.37-.36.59-.86.59-1.41 0-.55-.23-1.06-.59-1.42zM5.5 7C4.67 7 4 6.33 4 5.5S4.67 4 5.5 4 7 4.67 7 5.5 6.33 7 5.5 7zm11.77 8.27L13 19.54l-4.27-4.27C8.28 14.81 8 14.19 8 13.5c0-1.38 1.12-2.5 2.5-2.5.69 0 1.32.28 1.77.74l.73.72.73-.73c.45-.45 1.08-.73 1.77-.73 1.38 0 2.5 1.12 2.5 2.5 0 .69-.28 1.32-.73 1.77z"></path></g>
<g id="mail"><path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"></path></g>
<g id="markunread"><path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"></path></g>
<g id="markunread-mailbox"><path d="M20 6H10v6H8V4h6V0H6v6H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2z"></path></g>
<g id="menu"><path d="M3 18h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z"></path></g>
<g id="more-horiz"><path d="M6 10c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm12 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-6 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"></path></g>
<g id="more-vert"><path d="M12 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"></path></g>
<g id="motorcycle"><path d="M19.44 9.03L15.41 5H11v2h3.59l2 2H5c-2.8 0-5 2.2-5 5s2.2 5 5 5c2.46 0 4.45-1.69 4.9-4h1.65l2.77-2.77c-.21.54-.32 1.14-.32 1.77 0 2.8 2.2 5 5 5s5-2.2 5-5c0-2.65-1.97-4.77-4.56-4.97zM7.82 15C7.4 16.15 6.28 17 5 17c-1.63 0-3-1.37-3-3s1.37-3 3-3c1.28 0 2.4.85 2.82 2H5v2h2.82zM19 17c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3z"></path></g>
<g id="move-to-inbox"><path d="M19 3H4.99c-1.11 0-1.98.9-1.98 2L3 19c0 1.1.88 2 1.99 2H19c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 12h-4c0 1.66-1.35 3-3 3s-3-1.34-3-3H4.99V5H19v10zm-3-5h-2V7h-4v3H8l4 4 4-4z"></path></g>
<g id="next-week"><path d="M20 7h-4V5c0-.55-.22-1.05-.59-1.41C15.05 3.22 14.55 3 14 3h-4c-1.1 0-2 .9-2 2v2H4c-1.1 0-2 .9-2 2v11c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V9c0-1.1-.9-2-2-2zM10 5h4v2h-4V5zm1 13.5l-1-1 3-3-3-3 1-1 4 4-4 4z"></path></g>
<g id="note-add"><path d="M14 2H6c-1.1 0-1.99.9-1.99 2L4 20c0 1.1.89 2 1.99 2H18c1.1 0 2-.9 2-2V8l-6-6zm2 14h-3v3h-2v-3H8v-2h3v-3h2v3h3v2zm-3-7V3.5L18.5 9H13z"></path></g>
<g id="offline-pin"><path d="M12 2C6.5 2 2 6.5 2 12s4.5 10 10 10 10-4.5 10-10S17.5 2 12 2zm5 16H7v-2h10v2zm-6.7-4L7 10.7l1.4-1.4 1.9 1.9 5.3-5.3L17 7.3 10.3 14z"></path></g>
<g id="opacity"><path d="M17.66 8L12 2.35 6.34 8C4.78 9.56 4 11.64 4 13.64s.78 4.11 2.34 5.67 3.61 2.35 5.66 2.35 4.1-.79 5.66-2.35S20 15.64 20 13.64 19.22 9.56 17.66 8zM6 14c.01-2 .62-3.27 1.76-4.4L12 5.27l4.24 4.38C17.38 10.77 17.99 12 18 14H6z"></path></g>
<g id="open-in-browser"><path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"></path></g>
<g id="open-in-new"><path d="M19 19H5V5h7V3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2v-7h-2v7zM14 3v2h3.59l-9.83 9.83 1.41 1.41L19 6.41V10h2V3h-7z"></path></g>
<g id="open-with"><path d="M10 9h4V6h3l-5-5-5 5h3v3zm-1 1H6V7l-5 5 5 5v-3h3v-4zm14 2l-5-5v3h-3v4h3v3l5-5zm-9 3h-4v3H7l5 5 5-5h-3v-3z"></path></g>
<g id="pageview"><path d="M11.5 9C10.12 9 9 10.12 9 11.5s1.12 2.5 2.5 2.5 2.5-1.12 2.5-2.5S12.88 9 11.5 9zM20 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-3.21 14.21l-2.91-2.91c-.69.44-1.51.7-2.39.7C9.01 16 7 13.99 7 11.5S9.01 7 11.5 7 16 9.01 16 11.5c0 .88-.26 1.69-.7 2.39l2.91 2.9-1.42 1.42z"></path></g>
<g id="pan-tool"><path d="M23 5.5V20c0 2.2-1.8 4-4 4h-7.3c-1.08 0-2.1-.43-2.85-1.19L1 14.83s1.26-1.23 1.3-1.25c.22-.19.49-.29.79-.29.22 0 .42.06.6.16.04.01 4.31 2.46 4.31 2.46V4c0-.83.67-1.5 1.5-1.5S11 3.17 11 4v7h1V1.5c0-.83.67-1.5 1.5-1.5S15 .67 15 1.5V11h1V2.5c0-.83.67-1.5 1.5-1.5s1.5.67 1.5 1.5V11h1V5.5c0-.83.67-1.5 1.5-1.5s1.5.67 1.5 1.5z"></path></g>
<g id="payment"><path d="M20 4H4c-1.11 0-1.99.89-1.99 2L2 18c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V6c0-1.11-.89-2-2-2zm0 14H4v-6h16v6zm0-10H4V6h16v2z"></path></g>
<g id="perm-camera-mic"><path d="M20 5h-3.17L15 3H9L7.17 5H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h7v-2.09c-2.83-.48-5-2.94-5-5.91h2c0 2.21 1.79 4 4 4s4-1.79 4-4h2c0 2.97-2.17 5.43-5 5.91V21h7c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm-6 8c0 1.1-.9 2-2 2s-2-.9-2-2V9c0-1.1.9-2 2-2s2 .9 2 2v4z"></path></g>
<g id="perm-contact-calendar"><path d="M19 3h-1V1h-2v2H8V1H6v2H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7 3c1.66 0 3 1.34 3 3s-1.34 3-3 3-3-1.34-3-3 1.34-3 3-3zm6 12H6v-1c0-2 4-3.1 6-3.1s6 1.1 6 3.1v1z"></path></g>
<g id="perm-data-setting"><path d="M18.99 11.5c.34 0 .67.03 1 .07L20 0 0 20h11.56c-.04-.33-.07-.66-.07-1 0-4.14 3.36-7.5 7.5-7.5zm3.71 7.99c.02-.16.04-.32.04-.49 0-.17-.01-.33-.04-.49l1.06-.83c.09-.08.12-.21.06-.32l-1-1.73c-.06-.11-.19-.15-.31-.11l-1.24.5c-.26-.2-.54-.37-.85-.49l-.19-1.32c-.01-.12-.12-.21-.24-.21h-2c-.12 0-.23.09-.25.21l-.19 1.32c-.3.13-.59.29-.85.49l-1.24-.5c-.11-.04-.24 0-.31.11l-1 1.73c-.06.11-.04.24.06.32l1.06.83c-.02.16-.03.32-.03.49 0 .17.01.33.03.49l-1.06.83c-.09.08-.12.21-.06.32l1 1.73c.06.11.19.15.31.11l1.24-.5c.26.2.54.37.85.49l.19 1.32c.02.12.12.21.25.21h2c.12 0 .23-.09.25-.21l.19-1.32c.3-.13.59-.29.84-.49l1.25.5c.11.04.24 0 .31-.11l1-1.73c.06-.11.03-.24-.06-.32l-1.07-.83zm-3.71 1.01c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5z"></path></g>
<g id="perm-device-information"><path d="M13 7h-2v2h2V7zm0 4h-2v6h2v-6zm4-9.99L7 1c-1.1 0-2 .9-2 2v18c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V3c0-1.1-.9-1.99-2-1.99zM17 19H7V5h10v14z"></path></g>
<g id="perm-identity"><path d="M12 5.9c1.16 0 2.1.94 2.1 2.1s-.94 2.1-2.1 2.1S9.9 9.16 9.9 8s.94-2.1 2.1-2.1m0 9c2.97 0 6.1 1.46 6.1 2.1v1.1H5.9V17c0-.64 3.13-2.1 6.1-2.1M12 4C9.79 4 8 5.79 8 8s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm0 9c-2.67 0-8 1.34-8 4v3h16v-3c0-2.66-5.33-4-8-4z"></path></g>
<g id="perm-media"><path d="M2 6H0v5h.01L0 20c0 1.1.9 2 2 2h18v-2H2V6zm20-2h-8l-2-2H6c-1.1 0-1.99.9-1.99 2L4 16c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zM7 15l4.5-6 3.5 4.51 2.5-3.01L21 15H7z"></path></g>
<g id="perm-phone-msg"><path d="M20 15.5c-1.25 0-2.45-.2-3.57-.57-.35-.11-.74-.03-1.02.24l-2.2 2.2c-2.83-1.44-5.15-3.75-6.59-6.58l2.2-2.21c.28-.27.36-.66.25-1.01C8.7 6.45 8.5 5.25 8.5 4c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1 0 9.39 7.61 17 17 17 .55 0 1-.45 1-1v-3.5c0-.55-.45-1-1-1zM12 3v10l3-3h6V3h-9z"></path></g>
<g id="perm-scan-wifi"><path d="M12 3C6.95 3 3.15 4.85 0 7.23L12 22 24 7.25C20.85 4.87 17.05 3 12 3zm1 13h-2v-6h2v6zm-2-8V6h2v2h-2z"></path></g>
<g id="pets"><circle cx="4.5" cy="9.5" r="2.5"></circle><circle cx="9" cy="5.5" r="2.5"></circle><circle cx="15" cy="5.5" r="2.5"></circle><circle cx="19.5" cy="9.5" r="2.5"></circle><path d="M17.34 14.86c-.87-1.02-1.6-1.89-2.48-2.91-.46-.54-1.05-1.08-1.75-1.32-.11-.04-.22-.07-.33-.09-.25-.04-.52-.04-.78-.04s-.53 0-.79.05c-.11.02-.22.05-.33.09-.7.24-1.28.78-1.75 1.32-.87 1.02-1.6 1.89-2.48 2.91-1.31 1.31-2.92 2.76-2.62 4.79.29 1.02 1.02 2.03 2.33 2.32.73.15 3.06-.44 5.54-.44h.18c2.48 0 4.81.58 5.54.44 1.31-.29 2.04-1.31 2.33-2.32.31-2.04-1.3-3.49-2.61-4.8z"></path></g>
<g id="picture-in-picture"><path d="M19 7h-8v6h8V7zm2-4H3c-1.1 0-2 .9-2 2v14c0 1.1.9 1.98 2 1.98h18c1.1 0 2-.88 2-1.98V5c0-1.1-.9-2-2-2zm0 16.01H3V4.98h18v14.03z"></path></g>
<g id="picture-in-picture-alt"><path d="M19 11h-8v6h8v-6zm4 8V4.98C23 3.88 22.1 3 21 3H3c-1.1 0-2 .88-2 1.98V19c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2zm-2 .02H3V4.97h18v14.05z"></path></g>
<g id="play-for-work"><path d="M11 5v5.59H7.5l4.5 4.5 4.5-4.5H13V5h-2zm-5 9c0 3.31 2.69 6 6 6s6-2.69 6-6h-2c0 2.21-1.79 4-4 4s-4-1.79-4-4H6z"></path></g>
<g id="polymer"><path d="M19 4h-4L7.11 16.63 4.5 12 9 4H5L.5 12 5 20h4l7.89-12.63L19.5 12 15 20h4l4.5-8z"></path></g>
<g id="power-settings-new"><path d="M13 3h-2v10h2V3zm4.83 2.17l-1.42 1.42C17.99 7.86 19 9.81 19 12c0 3.87-3.13 7-7 7s-7-3.13-7-7c0-2.19 1.01-4.14 2.58-5.42L6.17 5.17C4.23 6.82 3 9.26 3 12c0 4.97 4.03 9 9 9s9-4.03 9-9c0-2.74-1.23-5.18-3.17-6.83z"></path></g>
<g id="pregnant-woman"><path d="M9 4c0-1.11.89-2 2-2s2 .89 2 2-.89 2-2 2-2-.89-2-2zm7 9c-.01-1.34-.83-2.51-2-3 0-1.66-1.34-3-3-3s-3 1.34-3 3v7h2v5h3v-5h3v-4z"></path></g>
<g id="print"><path d="M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z"></path></g>
<g id="query-builder"><path d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z"></path></g>
<g id="question-answer"><path d="M21 6h-2v9H6v2c0 .55.45 1 1 1h11l4 4V7c0-.55-.45-1-1-1zm-4 6V3c0-.55-.45-1-1-1H3c-.55 0-1 .45-1 1v14l4-4h10c.55 0 1-.45 1-1z"></path></g>
<g id="radio-button-checked"><path d="M12 7c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.24-5-5-5zm0-5C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z"></path></g>
<g id="radio-button-unchecked"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z"></path></g>
<g id="receipt"><path d="M18 17H6v-2h12v2zm0-4H6v-2h12v2zm0-4H6V7h12v2zM3 22l1.5-1.5L6 22l1.5-1.5L9 22l1.5-1.5L12 22l1.5-1.5L15 22l1.5-1.5L18 22l1.5-1.5L21 22V2l-1.5 1.5L18 2l-1.5 1.5L15 2l-1.5 1.5L12 2l-1.5 1.5L9 2 7.5 3.5 6 2 4.5 3.5 3 2v20z"></path></g>
<g id="record-voice-over"><circle cx="9" cy="9" r="4"></circle><path d="M9 15c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4zm7.76-9.64l-1.68 1.69c.84 1.18.84 2.71 0 3.89l1.68 1.69c2.02-2.02 2.02-5.07 0-7.27zM20.07 2l-1.63 1.63c2.77 3.02 2.77 7.56 0 10.74L20.07 16c3.9-3.89 3.91-9.95 0-14z"></path></g>
<g id="redeem"><path d="M20 6h-2.18c.11-.31.18-.65.18-1 0-1.66-1.34-3-3-3-1.05 0-1.96.54-2.5 1.35l-.5.67-.5-.68C10.96 2.54 10.05 2 9 2 7.34 2 6 3.34 6 5c0 .35.07.69.18 1H4c-1.11 0-1.99.89-1.99 2L2 19c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V8c0-1.11-.89-2-2-2zm-5-2c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zM9 4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm11 15H4v-2h16v2zm0-5H4V8h5.08L7 10.83 8.62 12 11 8.76l1-1.36 1 1.36L15.38 12 17 10.83 14.92 8H20v6z"></path></g>
<g id="redo"><path d="M18.4 10.6C16.55 8.99 14.15 8 11.5 8c-4.65 0-8.58 3.03-9.96 7.22L3.9 16c1.05-3.19 4.05-5.5 7.6-5.5 1.95 0 3.73.72 5.12 1.88L13 16h9V7l-3.6 3.6z"></path></g>
<g id="refresh"><path d="M17.65 6.35C16.2 4.9 14.21 4 12 4c-4.42 0-7.99 3.58-7.99 8s3.57 8 7.99 8c3.73 0 6.84-2.55 7.73-6h-2.08c-.82 2.33-3.04 4-5.65 4-3.31 0-6-2.69-6-6s2.69-6 6-6c1.66 0 3.14.69 4.22 1.78L13 11h7V4l-2.35 2.35z"></path></g>
<g id="remove"><path d="M19 13H5v-2h14v2z"></path></g>
<g id="remove-circle"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm5 11H7v-2h10v2z"></path></g>
<g id="remove-circle-outline"><path d="M7 11v2h10v-2H7zm5-9C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z"></path></g>
<g id="remove-shopping-cart"><path d="M22.73 22.73L2.77 2.77 2 2l-.73-.73L0 2.54l4.39 4.39 2.21 4.66-1.35 2.45c-.16.28-.25.61-.25.96 0 1.1.9 2 2 2h7.46l1.38 1.38c-.5.36-.83.95-.83 1.62 0 1.1.89 2 1.99 2 .67 0 1.26-.33 1.62-.84L21.46 24l1.27-1.27zM7.42 15c-.14 0-.25-.11-.25-.25l.03-.12.9-1.63h2.36l2 2H7.42zm8.13-2c.75 0 1.41-.41 1.75-1.03l3.58-6.49c.08-.14.12-.31.12-.48 0-.55-.45-1-1-1H6.54l9.01 9zM7 18c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2z"></path></g>
<g id="reorder"><path d="M3 15h18v-2H3v2zm0 4h18v-2H3v2zm0-8h18V9H3v2zm0-6v2h18V5H3z"></path></g>
<g id="reply"><path d="M10 9V5l-7 7 7 7v-4.1c5 0 8.5 1.6 11 5.1-1-5-4-10-11-11z"></path></g>
<g id="reply-all"><path d="M7 8V5l-7 7 7 7v-3l-4-4 4-4zm6 1V5l-7 7 7 7v-4.1c5 0 8.5 1.6 11 5.1-1-5-4-10-11-11z"></path></g>
<g id="report"><path d="M15.73 3H8.27L3 8.27v7.46L8.27 21h7.46L21 15.73V8.27L15.73 3zM12 17.3c-.72 0-1.3-.58-1.3-1.3 0-.72.58-1.3 1.3-1.3.72 0 1.3.58 1.3 1.3 0 .72-.58 1.3-1.3 1.3zm1-4.3h-2V7h2v6z"></path></g>
<g id="report-problem"><path d="M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"></path></g>
<g id="restore"><path d="M13 3c-4.97 0-9 4.03-9 9H1l3.89 3.89.07.14L9 12H6c0-3.87 3.13-7 7-7s7 3.13 7 7-3.13 7-7 7c-1.93 0-3.68-.79-4.94-2.06l-1.42 1.42C8.27 19.99 10.51 21 13 21c4.97 0 9-4.03 9-9s-4.03-9-9-9zm-1 5v5l4.28 2.54.72-1.21-3.5-2.08V8H12z"></path></g>
<g id="restore-page"><path d="M14 2H6c-1.1 0-1.99.9-1.99 2L4 20c0 1.1.89 2 1.99 2H18c1.1 0 2-.9 2-2V8l-6-6zm-2 16c-2.05 0-3.81-1.24-4.58-3h1.71c.63.9 1.68 1.5 2.87 1.5 1.93 0 3.5-1.57 3.5-3.5S13.93 9.5 12 9.5c-1.35 0-2.52.78-3.1 1.9l1.6 1.6h-4V9l1.3 1.3C8.69 8.92 10.23 8 12 8c2.76 0 5 2.24 5 5s-2.24 5-5 5z"></path></g>
<g id="room"><path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"></path></g>
<g id="rounded-corner"><path d="M19 19h2v2h-2v-2zm0-2h2v-2h-2v2zM3 13h2v-2H3v2zm0 4h2v-2H3v2zm0-8h2V7H3v2zm0-4h2V3H3v2zm4 0h2V3H7v2zm8 16h2v-2h-2v2zm-4 0h2v-2h-2v2zm4 0h2v-2h-2v2zm-8 0h2v-2H7v2zm-4 0h2v-2H3v2zM21 8c0-2.76-2.24-5-5-5h-5v2h5c1.65 0 3 1.35 3 3v5h2V8z"></path></g>
<g id="rowing"><path d="M8.5 14.5L4 19l1.5 1.5L9 17h2l-2.5-2.5zM15 1c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm6 20.01L18 24l-2.99-3.01V19.5l-7.1-7.09c-.31.05-.61.07-.91.07v-2.16c1.66.03 3.61-.87 4.67-2.04l1.4-1.55c.19-.21.43-.38.69-.5.29-.14.62-.23.96-.23h.03C15.99 6.01 17 7.02 17 8.26v5.75c0 .84-.35 1.61-.92 2.16l-3.58-3.58v-2.27c-.63.52-1.43 1.02-2.29 1.39L16.5 18H18l3 3.01z"></path></g>
<g id="save"><path d="M17 3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V7l-4-4zm-5 16c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3zm3-10H5V5h10v4z"></path></g>
<g id="schedule"><path d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z"></path></g>
<g id="search"><path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"></path></g>
<g id="select-all"><path d="M3 5h2V3c-1.1 0-2 .9-2 2zm0 8h2v-2H3v2zm4 8h2v-2H7v2zM3 9h2V7H3v2zm10-6h-2v2h2V3zm6 0v2h2c0-1.1-.9-2-2-2zM5 21v-2H3c0 1.1.9 2 2 2zm-2-4h2v-2H3v2zM9 3H7v2h2V3zm2 18h2v-2h-2v2zm8-8h2v-2h-2v2zm0 8c1.1 0 2-.9 2-2h-2v2zm0-12h2V7h-2v2zm0 8h2v-2h-2v2zm-4 4h2v-2h-2v2zm0-16h2V3h-2v2zM7 17h10V7H7v10zm2-8h6v6H9V9z"></path></g>
<g id="send"><path d="M2.01 21L23 12 2.01 3 2 10l15 2-15 2z"></path></g>
<g id="settings"><path d="M19.43 12.98c.04-.32.07-.64.07-.98s-.03-.66-.07-.98l2.11-1.65c.19-.15.24-.42.12-.64l-2-3.46c-.12-.22-.39-.3-.61-.22l-2.49 1c-.52-.4-1.08-.73-1.69-.98l-.38-2.65C14.46 2.18 14.25 2 14 2h-4c-.25 0-.46.18-.49.42l-.38 2.65c-.61.25-1.17.59-1.69.98l-2.49-1c-.23-.09-.49 0-.61.22l-2 3.46c-.13.22-.07.49.12.64l2.11 1.65c-.04.32-.07.65-.07.98s.03.66.07.98l-2.11 1.65c-.19.15-.24.42-.12.64l2 3.46c.12.22.39.3.61.22l2.49-1c.52.4 1.08.73 1.69.98l.38 2.65c.03.24.24.42.49.42h4c.25 0 .46-.18.49-.42l.38-2.65c.61-.25 1.17-.59 1.69-.98l2.49 1c.23.09.49 0 .61-.22l2-3.46c.12-.22.07-.49-.12-.64l-2.11-1.65zM12 15.5c-1.93 0-3.5-1.57-3.5-3.5s1.57-3.5 3.5-3.5 3.5 1.57 3.5 3.5-1.57 3.5-3.5 3.5z"></path></g>
<g id="settings-applications"><path d="M12 10c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm7-7H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.11 0 2-.9 2-2V5c0-1.1-.89-2-2-2zm-1.75 9c0 .23-.02.46-.05.68l1.48 1.16c.13.11.17.3.08.45l-1.4 2.42c-.09.15-.27.21-.43.15l-1.74-.7c-.36.28-.76.51-1.18.69l-.26 1.85c-.03.17-.18.3-.35.3h-2.8c-.17 0-.32-.13-.35-.29l-.26-1.85c-.43-.18-.82-.41-1.18-.69l-1.74.7c-.16.06-.34 0-.43-.15l-1.4-2.42c-.09-.15-.05-.34.08-.45l1.48-1.16c-.03-.23-.05-.46-.05-.69 0-.23.02-.46.05-.68l-1.48-1.16c-.13-.11-.17-.3-.08-.45l1.4-2.42c.09-.15.27-.21.43-.15l1.74.7c.36-.28.76-.51 1.18-.69l.26-1.85c.03-.17.18-.3.35-.3h2.8c.17 0 .32.13.35.29l.26 1.85c.43.18.82.41 1.18.69l1.74-.7c.16-.06.34 0 .43.15l1.4 2.42c.09.15.05.34-.08.45l-1.48 1.16c.03.23.05.46.05.69z"></path></g>
<g id="settings-backup-restore"><path d="M14 12c0-1.1-.9-2-2-2s-2 .9-2 2 .9 2 2 2 2-.9 2-2zm-2-9c-4.97 0-9 4.03-9 9H0l4 4 4-4H5c0-3.87 3.13-7 7-7s7 3.13 7 7-3.13 7-7 7c-1.51 0-2.91-.49-4.06-1.3l-1.42 1.44C8.04 20.3 9.94 21 12 21c4.97 0 9-4.03 9-9s-4.03-9-9-9z"></path></g>
<g id="settings-bluetooth"><path d="M11 24h2v-2h-2v2zm-4 0h2v-2H7v2zm8 0h2v-2h-2v2zm2.71-18.29L12 0h-1v7.59L6.41 3 5 4.41 10.59 10 5 15.59 6.41 17 11 12.41V20h1l5.71-5.71-4.3-4.29 4.3-4.29zM13 3.83l1.88 1.88L13 7.59V3.83zm1.88 10.46L13 16.17v-3.76l1.88 1.88z"></path></g>
<g id="settings-brightness"><path d="M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16.01H3V4.99h18v14.02zM8 16h2.5l1.5 1.5 1.5-1.5H16v-2.5l1.5-1.5-1.5-1.5V8h-2.5L12 6.5 10.5 8H8v2.5L6.5 12 8 13.5V16zm4-7c1.66 0 3 1.34 3 3s-1.34 3-3 3V9z"></path></g>
<g id="settings-cell"><path d="M7 24h2v-2H7v2zm4 0h2v-2h-2v2zm4 0h2v-2h-2v2zM16 .01L8 0C6.9 0 6 .9 6 2v16c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V2c0-1.1-.9-1.99-2-1.99zM16 16H8V4h8v12z"></path></g>
<g id="settings-ethernet"><path d="M7.77 6.76L6.23 5.48.82 12l5.41 6.52 1.54-1.28L3.42 12l4.35-5.24zM7 13h2v-2H7v2zm10-2h-2v2h2v-2zm-6 2h2v-2h-2v2zm6.77-7.52l-1.54 1.28L20.58 12l-4.35 5.24 1.54 1.28L23.18 12l-5.41-6.52z"></path></g>
<g id="settings-input-antenna"><path d="M12 5c-3.87 0-7 3.13-7 7h2c0-2.76 2.24-5 5-5s5 2.24 5 5h2c0-3.87-3.13-7-7-7zm1 9.29c.88-.39 1.5-1.26 1.5-2.29 0-1.38-1.12-2.5-2.5-2.5S9.5 10.62 9.5 12c0 1.02.62 1.9 1.5 2.29v3.3L7.59 21 9 22.41l3-3 3 3L16.41 21 13 17.59v-3.3zM12 1C5.93 1 1 5.93 1 12h2c0-4.97 4.03-9 9-9s9 4.03 9 9h2c0-6.07-4.93-11-11-11z"></path></g>
<g id="settings-input-component"><path d="M5 2c0-.55-.45-1-1-1s-1 .45-1 1v4H1v6h6V6H5V2zm4 14c0 1.3.84 2.4 2 2.82V23h2v-4.18c1.16-.41 2-1.51 2-2.82v-2H9v2zm-8 0c0 1.3.84 2.4 2 2.82V23h2v-4.18C6.16 18.4 7 17.3 7 16v-2H1v2zM21 6V2c0-.55-.45-1-1-1s-1 .45-1 1v4h-2v6h6V6h-2zm-8-4c0-.55-.45-1-1-1s-1 .45-1 1v4H9v6h6V6h-2V2zm4 14c0 1.3.84 2.4 2 2.82V23h2v-4.18c1.16-.41 2-1.51 2-2.82v-2h-6v2z"></path></g>
<g id="settings-input-composite"><path d="M5 2c0-.55-.45-1-1-1s-1 .45-1 1v4H1v6h6V6H5V2zm4 14c0 1.3.84 2.4 2 2.82V23h2v-4.18c1.16-.41 2-1.51 2-2.82v-2H9v2zm-8 0c0 1.3.84 2.4 2 2.82V23h2v-4.18C6.16 18.4 7 17.3 7 16v-2H1v2zM21 6V2c0-.55-.45-1-1-1s-1 .45-1 1v4h-2v6h6V6h-2zm-8-4c0-.55-.45-1-1-1s-1 .45-1 1v4H9v6h6V6h-2V2zm4 14c0 1.3.84 2.4 2 2.82V23h2v-4.18c1.16-.41 2-1.51 2-2.82v-2h-6v2z"></path></g>
<g id="settings-input-hdmi"><path d="M18 7V4c0-1.1-.9-2-2-2H8c-1.1 0-2 .9-2 2v3H5v6l3 6v3h8v-3l3-6V7h-1zM8 4h8v3h-2V5h-1v2h-2V5h-1v2H8V4z"></path></g>
<g id="settings-input-svideo"><path d="M8 11.5c0-.83-.67-1.5-1.5-1.5S5 10.67 5 11.5 5.67 13 6.5 13 8 12.33 8 11.5zm7-5c0-.83-.67-1.5-1.5-1.5h-3C9.67 5 9 5.67 9 6.5S9.67 8 10.5 8h3c.83 0 1.5-.67 1.5-1.5zM8.5 15c-.83 0-1.5.67-1.5 1.5S7.67 18 8.5 18s1.5-.67 1.5-1.5S9.33 15 8.5 15zM12 1C5.93 1 1 5.93 1 12s4.93 11 11 11 11-4.93 11-11S18.07 1 12 1zm0 20c-4.96 0-9-4.04-9-9s4.04-9 9-9 9 4.04 9 9-4.04 9-9 9zm5.5-11c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5-.67-1.5-1.5-1.5zm-2 5c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5-.67-1.5-1.5-1.5z"></path></g>
<g id="settings-overscan"><path d="M12.01 5.5L10 8h4l-1.99-2.5zM18 10v4l2.5-1.99L18 10zM6 10l-2.5 2.01L6 14v-4zm8 6h-4l2.01 2.5L14 16zm7-13H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16.01H3V4.99h18v14.02z"></path></g>
<g id="settings-phone"><path d="M13 9h-2v2h2V9zm4 0h-2v2h2V9zm3 6.5c-1.25 0-2.45-.2-3.57-.57-.35-.11-.74-.03-1.02.24l-2.2 2.2c-2.83-1.44-5.15-3.75-6.59-6.58l2.2-2.21c.28-.27.36-.66.25-1.01C8.7 6.45 8.5 5.25 8.5 4c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1 0 9.39 7.61 17 17 17 .55 0 1-.45 1-1v-3.5c0-.55-.45-1-1-1zM19 9v2h2V9h-2z"></path></g>
<g id="settings-power"><path d="M7 24h2v-2H7v2zm4 0h2v-2h-2v2zm2-22h-2v10h2V2zm3.56 2.44l-1.45 1.45C16.84 6.94 18 8.83 18 11c0 3.31-2.69 6-6 6s-6-2.69-6-6c0-2.17 1.16-4.06 2.88-5.12L7.44 4.44C5.36 5.88 4 8.28 4 11c0 4.42 3.58 8 8 8s8-3.58 8-8c0-2.72-1.36-5.12-3.44-6.56zM15 24h2v-2h-2v2z"></path></g>
<g id="settings-remote"><path d="M15 9H9c-.55 0-1 .45-1 1v12c0 .55.45 1 1 1h6c.55 0 1-.45 1-1V10c0-.55-.45-1-1-1zm-3 6c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zM7.05 6.05l1.41 1.41C9.37 6.56 10.62 6 12 6s2.63.56 3.54 1.46l1.41-1.41C15.68 4.78 13.93 4 12 4s-3.68.78-4.95 2.05zM12 0C8.96 0 6.21 1.23 4.22 3.22l1.41 1.41C7.26 3.01 9.51 2 12 2s4.74 1.01 6.36 2.64l1.41-1.41C17.79 1.23 15.04 0 12 0z"></path></g>
<g id="settings-voice"><path d="M7 24h2v-2H7v2zm5-11c1.66 0 2.99-1.34 2.99-3L15 4c0-1.66-1.34-3-3-3S9 2.34 9 4v6c0 1.66 1.34 3 3 3zm-1 11h2v-2h-2v2zm4 0h2v-2h-2v2zm4-14h-1.7c0 3-2.54 5.1-5.3 5.1S6.7 13 6.7 10H5c0 3.41 2.72 6.23 6 6.72V20h2v-3.28c3.28-.49 6-3.31 6-6.72z"></path></g>
<g id="shop"><path d="M16 6V4c0-1.11-.89-2-2-2h-4c-1.11 0-2 .89-2 2v2H2v13c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V6h-6zm-6-2h4v2h-4V4zM9 18V9l7.5 4L9 18z"></path></g>
<g id="shop-two"><path d="M3 9H1v11c0 1.11.89 2 2 2h14c1.11 0 2-.89 2-2H3V9zm15-4V3c0-1.11-.89-2-2-2h-4c-1.11 0-2 .89-2 2v2H5v11c0 1.11.89 2 2 2h14c1.11 0 2-.89 2-2V5h-5zm-6-2h4v2h-4V3zm0 12V8l5.5 3-5.5 4z"></path></g>
<g id="shopping-basket"><path d="M17.21 9l-4.38-6.56c-.19-.28-.51-.42-.83-.42-.32 0-.64.14-.83.43L6.79 9H2c-.55 0-1 .45-1 1 0 .09.01.18.04.27l2.54 9.27c.23.84 1 1.46 1.92 1.46h13c.92 0 1.69-.62 1.93-1.46l2.54-9.27L23 10c0-.55-.45-1-1-1h-4.79zM9 9l3-4.4L15 9H9zm3 8c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z"></path></g>
<g id="shopping-cart"><path d="M7 18c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2zM1 2v2h2l3.6 7.59-1.35 2.45c-.16.28-.25.61-.25.96 0 1.1.9 2 2 2h12v-2H7.42c-.14 0-.25-.11-.25-.25l.03-.12.9-1.63h7.45c.75 0 1.41-.41 1.75-1.03l3.58-6.49c.08-.14.12-.31.12-.48 0-.55-.45-1-1-1H5.21l-.94-2H1zm16 16c-1.1 0-1.99.9-1.99 2s.89 2 1.99 2 2-.9 2-2-.9-2-2-2z"></path></g>
<g id="sort"><path d="M3 18h6v-2H3v2zM3 6v2h18V6H3zm0 7h12v-2H3v2z"></path></g>
<g id="speaker-notes"><path d="M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM8 14H6v-2h2v2zm0-3H6V9h2v2zm0-3H6V6h2v2zm7 6h-5v-2h5v2zm3-3h-8V9h8v2zm0-3h-8V6h8v2z"></path></g>
<g id="speaker-notes-off"><path d="M10.54 11l-.54-.54L7.54 8 6 6.46 2.38 2.84 1.27 1.73 0 3l2.01 2.01L2 22l4-4h9l5.73 5.73L22 22.46 17.54 18l-7-7zM8 14H6v-2h2v2zm-2-3V9l2 2H6zm14-9H4.08L10 7.92V6h8v2h-7.92l1 1H18v2h-4.92l6.99 6.99C21.14 17.95 22 17.08 22 16V4c0-1.1-.9-2-2-2z"></path></g>
<g id="spellcheck"><path d="M12.45 16h2.09L9.43 3H7.57L2.46 16h2.09l1.12-3h5.64l1.14 3zm-6.02-5L8.5 5.48 10.57 11H6.43zm15.16.59l-8.09 8.09L9.83 16l-1.41 1.41 5.09 5.09L23 13l-1.41-1.41z"></path></g>
<g id="star"><path d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z"></path></g>
<g id="star-border"><path d="M22 9.24l-7.19-.62L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21 12 17.27 18.18 21l-1.63-7.03L22 9.24zM12 15.4l-3.76 2.27 1-4.28-3.32-2.88 4.38-.38L12 6.1l1.71 4.04 4.38.38-3.32 2.88 1 4.28L12 15.4z"></path></g>
<g id="star-half"><path d="M22 9.24l-7.19-.62L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21 12 17.27 18.18 21l-1.63-7.03L22 9.24zM12 15.4V6.1l1.71 4.04 4.38.38-3.32 2.88 1 4.28L12 15.4z"></path></g>
<g id="stars"><path d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zm4.24 16L12 15.45 7.77 18l1.12-4.81-3.73-3.23 4.92-.42L12 5l1.92 4.53 4.92.42-3.73 3.23L16.23 18z"></path></g>
<g id="store"><path d="M20 4H4v2h16V4zm1 10v-2l-1-5H4l-1 5v2h1v6h10v-6h4v6h2v-6h1zm-9 4H6v-4h6v4z"></path></g>
<g id="subdirectory-arrow-left"><path d="M11 9l1.42 1.42L8.83 14H18V4h2v12H8.83l3.59 3.58L11 21l-6-6 6-6z"></path></g>
<g id="subdirectory-arrow-right"><path d="M19 15l-6 6-1.42-1.42L15.17 16H4V4h2v10h9.17l-3.59-3.58L13 9l6 6z"></path></g>
<g id="subject"><path d="M14 17H4v2h10v-2zm6-8H4v2h16V9zM4 15h16v-2H4v2zM4 5v2h16V5H4z"></path></g>
<g id="supervisor-account"><path d="M16.5 12c1.38 0 2.49-1.12 2.49-2.5S17.88 7 16.5 7C15.12 7 14 8.12 14 9.5s1.12 2.5 2.5 2.5zM9 11c1.66 0 2.99-1.34 2.99-3S10.66 5 9 5C7.34 5 6 6.34 6 8s1.34 3 3 3zm7.5 3c-1.83 0-5.5.92-5.5 2.75V19h11v-2.25c0-1.83-3.67-2.75-5.5-2.75zM9 13c-2.33 0-7 1.17-7 3.5V19h7v-2.25c0-.85.33-2.34 2.37-3.47C10.5 13.1 9.66 13 9 13z"></path></g>
<g id="swap-horiz"><path d="M6.99 11L3 15l3.99 4v-3H14v-2H6.99v-3zM21 9l-3.99-4v3H10v2h7.01v3L21 9z"></path></g>
<g id="swap-vert"><path d="M16 17.01V10h-2v7.01h-3L15 21l4-3.99h-3zM9 3L5 6.99h3V14h2V6.99h3L9 3z"></path></g>
<g id="swap-vertical-circle"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zM6.5 9L10 5.5 13.5 9H11v4H9V9H6.5zm11 6L14 18.5 10.5 15H13v-4h2v4h2.5z"></path></g>
<g id="system-update-alt"><path d="M12 16.5l4-4h-3v-9h-2v9H8l4 4zm9-13h-6v1.99h6v14.03H3V5.49h6V3.5H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2v-14c0-1.1-.9-2-2-2z"></path></g>
<g id="tab"><path d="M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H3V5h10v4h8v10z"></path></g>
<g id="tab-unselected"><path d="M1 9h2V7H1v2zm0 4h2v-2H1v2zm0-8h2V3c-1.1 0-2 .9-2 2zm8 16h2v-2H9v2zm-8-4h2v-2H1v2zm2 4v-2H1c0 1.1.9 2 2 2zM21 3h-8v6h10V5c0-1.1-.9-2-2-2zm0 14h2v-2h-2v2zM9 5h2V3H9v2zM5 21h2v-2H5v2zM5 5h2V3H5v2zm16 16c1.1 0 2-.9 2-2h-2v2zm0-8h2v-2h-2v2zm-8 8h2v-2h-2v2zm4 0h2v-2h-2v2z"></path></g>
<g id="text-format"><path d="M5 17v2h14v-2H5zm4.5-4.2h5l.9 2.2h2.1L12.75 4h-1.5L6.5 15h2.1l.9-2.2zM12 5.98L13.87 11h-3.74L12 5.98z"></path></g>
<g id="theaters"><path d="M18 3v2h-2V3H8v2H6V3H4v18h2v-2h2v2h8v-2h2v2h2V3h-2zM8 17H6v-2h2v2zm0-4H6v-2h2v2zm0-4H6V7h2v2zm10 8h-2v-2h2v2zm0-4h-2v-2h2v2zm0-4h-2V7h2v2z"></path></g>
<g id="thumb-down"><path d="M15 3H6c-.83 0-1.54.5-1.84 1.22l-3.02 7.05c-.09.23-.14.47-.14.73v1.91l.01.01L1 14c0 1.1.9 2 2 2h6.31l-.95 4.57-.03.32c0 .41.17.79.44 1.06L9.83 23l6.59-6.59c.36-.36.58-.86.58-1.41V5c0-1.1-.9-2-2-2zm4 0v12h4V3h-4z"></path></g>
<g id="thumb-up"><path d="M1 21h4V9H1v12zm22-11c0-1.1-.9-2-2-2h-6.31l.95-4.57.03-.32c0-.41-.17-.79-.44-1.06L14.17 1 7.59 7.59C7.22 7.95 7 8.45 7 9v10c0 1.1.9 2 2 2h9c.83 0 1.54-.5 1.84-1.22l3.02-7.05c.09-.23.14-.47.14-.73v-1.91l-.01-.01L23 10z"></path></g>
<g id="thumbs-up-down"><path d="M12 6c0-.55-.45-1-1-1H5.82l.66-3.18.02-.23c0-.31-.13-.59-.33-.8L5.38 0 .44 4.94C.17 5.21 0 5.59 0 6v6.5c0 .83.67 1.5 1.5 1.5h6.75c.62 0 1.15-.38 1.38-.91l2.26-5.29c.07-.17.11-.36.11-.55V6zm10.5 4h-6.75c-.62 0-1.15.38-1.38.91l-2.26 5.29c-.07.17-.11.36-.11.55V18c0 .55.45 1 1 1h5.18l-.66 3.18-.02.24c0 .31.13.59.33.8l.79.78 4.94-4.94c.27-.27.44-.65.44-1.06v-6.5c0-.83-.67-1.5-1.5-1.5z"></path></g>
<g id="timeline"><path d="M23 8c0 1.1-.9 2-2 2-.18 0-.35-.02-.51-.07l-3.56 3.55c.05.16.07.34.07.52 0 1.1-.9 2-2 2s-2-.9-2-2c0-.18.02-.36.07-.52l-2.55-2.55c-.16.05-.34.07-.52.07s-.36-.02-.52-.07l-4.55 4.56c.05.16.07.33.07.51 0 1.1-.9 2-2 2s-2-.9-2-2 .9-2 2-2c.18 0 .35.02.51.07l4.56-4.55C8.02 9.36 8 9.18 8 9c0-1.1.9-2 2-2s2 .9 2 2c0 .18-.02.36-.07.52l2.55 2.55c.16-.05.34-.07.52-.07s.36.02.52.07l3.55-3.56C19.02 8.35 19 8.18 19 8c0-1.1.9-2 2-2s2 .9 2 2z"></path></g>
<g id="toc"><path d="M3 9h14V7H3v2zm0 4h14v-2H3v2zm0 4h14v-2H3v2zm16 0h2v-2h-2v2zm0-10v2h2V7h-2zm0 6h2v-2h-2v2z"></path></g>
<g id="today"><path d="M19 3h-1V1h-2v2H8V1H6v2H5c-1.11 0-1.99.9-1.99 2L3 19c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V8h14v11zM7 10h5v5H7z"></path></g>
<g id="toll"><path d="M15 4c-4.42 0-8 3.58-8 8s3.58 8 8 8 8-3.58 8-8-3.58-8-8-8zm0 14c-3.31 0-6-2.69-6-6s2.69-6 6-6 6 2.69 6 6-2.69 6-6 6zM3 12c0-2.61 1.67-4.83 4-5.65V4.26C3.55 5.15 1 8.27 1 12s2.55 6.85 6 7.74v-2.09c-2.33-.82-4-3.04-4-5.65z"></path></g>
<g id="touch-app"><path d="M9 11.24V7.5C9 6.12 10.12 5 11.5 5S14 6.12 14 7.5v3.74c1.21-.81 2-2.18 2-3.74C16 5.01 13.99 3 11.5 3S7 5.01 7 7.5c0 1.56.79 2.93 2 3.74zm9.84 4.63l-4.54-2.26c-.17-.07-.35-.11-.54-.11H13v-6c0-.83-.67-1.5-1.5-1.5S10 6.67 10 7.5v10.74l-3.43-.72c-.08-.01-.15-.03-.24-.03-.31 0-.59.13-.79.33l-.79.8 4.94 4.94c.27.27.65.44 1.06.44h6.79c.75 0 1.33-.55 1.44-1.28l.75-5.27c.01-.07.02-.14.02-.2 0-.62-.38-1.16-.91-1.38z"></path></g>
<g id="track-changes"><path d="M19.07 4.93l-1.41 1.41C19.1 7.79 20 9.79 20 12c0 4.42-3.58 8-8 8s-8-3.58-8-8c0-4.08 3.05-7.44 7-7.93v2.02C8.16 6.57 6 9.03 6 12c0 3.31 2.69 6 6 6s6-2.69 6-6c0-1.66-.67-3.16-1.76-4.24l-1.41 1.41C15.55 9.9 16 10.9 16 12c0 2.21-1.79 4-4 4s-4-1.79-4-4c0-1.86 1.28-3.41 3-3.86v2.14c-.6.35-1 .98-1 1.72 0 1.1.9 2 2 2s2-.9 2-2c0-.74-.4-1.38-1-1.72V2h-1C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10c0-2.76-1.12-5.26-2.93-7.07z"></path></g>
<g id="translate"><path d="M12.87 15.07l-2.54-2.51.03-.03c1.74-1.94 2.98-4.17 3.71-6.53H17V4h-7V2H8v2H1v1.99h11.17C11.5 7.92 10.44 9.75 9 11.35 8.07 10.32 7.3 9.19 6.69 8h-2c.73 1.63 1.73 3.17 2.98 4.56l-5.09 5.02L4 19l5-5 3.11 3.11.76-2.04zM18.5 10h-2L12 22h2l1.12-3h4.75L21 22h2l-4.5-12zm-2.62 7l1.62-4.33L19.12 17h-3.24z"></path></g>
<g id="trending-down"><path d="M16 18l2.29-2.29-4.88-4.88-4 4L2 7.41 3.41 6l6 6 4-4 6.3 6.29L22 12v6z"></path></g>
<g id="trending-flat"><path d="M22 12l-4-4v3H3v2h15v3z"></path></g>
<g id="trending-up"><path d="M16 6l2.29 2.29-4.88 4.88-4-4L2 16.59 3.41 18l6-6 4 4 6.3-6.29L22 12V6z"></path></g>
<g id="turned-in"><path d="M17 3H7c-1.1 0-1.99.9-1.99 2L5 21l7-3 7 3V5c0-1.1-.9-2-2-2z"></path></g>
<g id="turned-in-not"><path d="M17 3H7c-1.1 0-1.99.9-1.99 2L5 21l7-3 7 3V5c0-1.1-.9-2-2-2zm0 15l-5-2.18L7 18V5h10v13z"></path></g>
<g id="unarchive"><path d="M20.55 5.22l-1.39-1.68C18.88 3.21 18.47 3 18 3H6c-.47 0-.88.21-1.15.55L3.46 5.22C3.17 5.57 3 6.01 3 6.5V19c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V6.5c0-.49-.17-.93-.45-1.28zM12 9.5l5.5 5.5H14v2h-4v-2H6.5L12 9.5zM5.12 5l.82-1h12l.93 1H5.12z"></path></g>
<g id="undo"><path d="M12.5 8c-2.65 0-5.05.99-6.9 2.6L2 7v9h9l-3.62-3.62c1.39-1.16 3.16-1.88 5.12-1.88 3.54 0 6.55 2.31 7.6 5.5l2.37-.78C21.08 11.03 17.15 8 12.5 8z"></path></g>
<g id="unfold-less"><path d="M7.41 18.59L8.83 20 12 16.83 15.17 20l1.41-1.41L12 14l-4.59 4.59zm9.18-13.18L15.17 4 12 7.17 8.83 4 7.41 5.41 12 10l4.59-4.59z"></path></g>
<g id="unfold-more"><path d="M12 5.83L15.17 9l1.41-1.41L12 3 7.41 7.59 8.83 9 12 5.83zm0 12.34L8.83 15l-1.41 1.41L12 21l4.59-4.59L15.17 15 12 18.17z"></path></g>
<g id="update"><path d="M21 10.12h-6.78l2.74-2.82c-2.73-2.7-7.15-2.8-9.88-.1-2.73 2.71-2.73 7.08 0 9.79 2.73 2.71 7.15 2.71 9.88 0C18.32 15.65 19 14.08 19 12.1h2c0 1.98-.88 4.55-2.64 6.29-3.51 3.48-9.21 3.48-12.72 0-3.5-3.47-3.53-9.11-.02-12.58 3.51-3.47 9.14-3.47 12.65 0L21 3v7.12zM12.5 8v4.25l3.5 2.08-.72 1.21L11 13V8h1.5z"></path></g>
<g id="verified-user"><path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm-2 16l-4-4 1.41-1.41L10 14.17l6.59-6.59L18 9l-8 8z"></path></g>
<g id="view-agenda"><path d="M20 13H3c-.55 0-1 .45-1 1v6c0 .55.45 1 1 1h17c.55 0 1-.45 1-1v-6c0-.55-.45-1-1-1zm0-10H3c-.55 0-1 .45-1 1v6c0 .55.45 1 1 1h17c.55 0 1-.45 1-1V4c0-.55-.45-1-1-1z"></path></g>
<g id="view-array"><path d="M4 18h3V5H4v13zM18 5v13h3V5h-3zM8 18h9V5H8v13z"></path></g>
<g id="view-carousel"><path d="M7 19h10V4H7v15zm-5-2h4V6H2v11zM18 6v11h4V6h-4z"></path></g>
<g id="view-column"><path d="M10 18h5V5h-5v13zm-6 0h5V5H4v13zM16 5v13h5V5h-5z"></path></g>
<g id="view-day"><path d="M2 21h19v-3H2v3zM20 8H3c-.55 0-1 .45-1 1v6c0 .55.45 1 1 1h17c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1zM2 3v3h19V3H2z"></path></g>
<g id="view-headline"><path d="M4 15h16v-2H4v2zm0 4h16v-2H4v2zm0-8h16V9H4v2zm0-6v2h16V5H4z"></path></g>
<g id="view-list"><path d="M4 14h4v-4H4v4zm0 5h4v-4H4v4zM4 9h4V5H4v4zm5 5h12v-4H9v4zm0 5h12v-4H9v4zM9 5v4h12V5H9z"></path></g>
<g id="view-module"><path d="M4 11h5V5H4v6zm0 7h5v-6H4v6zm6 0h5v-6h-5v6zm6 0h5v-6h-5v6zm-6-7h5V5h-5v6zm6-6v6h5V5h-5z"></path></g>
<g id="view-quilt"><path d="M10 18h5v-6h-5v6zm-6 0h5V5H4v13zm12 0h5v-6h-5v6zM10 5v6h11V5H10z"></path></g>
<g id="view-stream"><path d="M4 18h17v-6H4v6zM4 5v6h17V5H4z"></path></g>
<g id="view-week"><path d="M6 5H3c-.55 0-1 .45-1 1v12c0 .55.45 1 1 1h3c.55 0 1-.45 1-1V6c0-.55-.45-1-1-1zm14 0h-3c-.55 0-1 .45-1 1v12c0 .55.45 1 1 1h3c.55 0 1-.45 1-1V6c0-.55-.45-1-1-1zm-7 0h-3c-.55 0-1 .45-1 1v12c0 .55.45 1 1 1h3c.55 0 1-.45 1-1V6c0-.55-.45-1-1-1z"></path></g>
<g id="visibility"><path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"></path></g>
<g id="visibility-off"><path d="M12 7c2.76 0 5 2.24 5 5 0 .65-.13 1.26-.36 1.83l2.92 2.92c1.51-1.26 2.7-2.89 3.43-4.75-1.73-4.39-6-7.5-11-7.5-1.4 0-2.74.25-3.98.7l2.16 2.16C10.74 7.13 11.35 7 12 7zM2 4.27l2.28 2.28.46.46C3.08 8.3 1.78 10.02 1 12c1.73 4.39 6 7.5 11 7.5 1.55 0 3.03-.3 4.38-.84l.42.42L19.73 22 21 20.73 3.27 3 2 4.27zM7.53 9.8l1.55 1.55c-.05.21-.08.43-.08.65 0 1.66 1.34 3 3 3 .22 0 .44-.03.65-.08l1.55 1.55c-.67.33-1.41.53-2.2.53-2.76 0-5-2.24-5-5 0-.79.2-1.53.53-2.2zm4.31-.78l3.15 3.15.02-.16c0-1.66-1.34-3-3-3l-.17.01z"></path></g>
<g id="warning"><path d="M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"></path></g>
<g id="watch-later"><path d="M12 2C6.5 2 2 6.5 2 12s4.5 10 10 10 10-4.5 10-10S17.5 2 12 2zm4.2 14.2L11 13V7h1.5v5.2l4.5 2.7-.8 1.3z"></path></g>
<g id="weekend"><path d="M21 10c-1.1 0-2 .9-2 2v3H5v-3c0-1.1-.9-2-2-2s-2 .9-2 2v5c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2v-5c0-1.1-.9-2-2-2zm-3-5H6c-1.1 0-2 .9-2 2v2.15c1.16.41 2 1.51 2 2.82V14h12v-2.03c0-1.3.84-2.4 2-2.82V7c0-1.1-.9-2-2-2z"></path></g>
<g id="work"><path d="M20 6h-4V4c0-1.11-.89-2-2-2h-4c-1.11 0-2 .89-2 2v2H4c-1.11 0-1.99.89-1.99 2L2 19c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V8c0-1.11-.89-2-2-2zm-6 0h-4V4h4v2z"></path></g>
<g id="youtube-searched-for"><path d="M17.01 14h-.8l-.27-.27c.98-1.14 1.57-2.61 1.57-4.23 0-3.59-2.91-6.5-6.5-6.5s-6.5 3-6.5 6.5H2l3.84 4 4.16-4H6.51C6.51 7 8.53 5 11.01 5s4.5 2.01 4.5 4.5c0 2.48-2.02 4.5-4.5 4.5-.65 0-1.26-.14-1.82-.38L7.71 15.1c.97.57 2.09.9 3.3.9 1.61 0 3.08-.59 4.22-1.57l.27.27v.79l5.01 4.99L22 19l-4.99-5z"></path></g>
<g id="zoom-in"><path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14zm2.5-4h-2v2H9v-2H7V9h2V7h1v2h2v1z"></path></g>
<g id="zoom-out"><path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14zM7 9h5v1H7z"></path></g>
</defs></svg>
</iron-iconset-svg>`;document.head.appendChild(Mo.content);
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
var Eo={"U+0008":"backspace","U+0009":"tab","U+001B":"esc","U+0020":"space","U+007F":"del"},To={8:"backspace",9:"tab",13:"enter",27:"esc",33:"pageup",34:"pagedown",35:"end",36:"home",32:"space",37:"left",38:"up",39:"right",40:"down",46:"del",106:"*"},Co={shift:"shiftKey",ctrl:"ctrlKey",alt:"altKey",meta:"metaKey"},Ao=/[a-z0-9*]/,ko=/U\+/,Lo=/^arrow/,Po=/^space(bar)?/,No=/^escape$/;function Io(t,e){var n="";if(t){var i=t.toLowerCase();" "===i||Po.test(i)?n="space":No.test(i)?n="esc":1==i.length?e&&!Ao.test(i)||(n=i):n=Lo.test(i)?i.replace("arrow",""):"multiply"==i?"*":i}return n}function Ro(t,e){return(function n(t,e){return t.key?Io(t.key,e):t.detail&&t.detail.key?Io(t.detail.key,e):(function n(t){var e="";return t&&(t in Eo?e=Eo[t]:ko.test(t)?(t=parseInt(t.replace("U+","0x"),16),e=String.fromCharCode(t).toLowerCase()):e=t.toLowerCase()),e})(t.keyIdentifier)||(function i(t){var e="";return Number(t)&&(e=t>=65&&t<=90?String.fromCharCode(32+t):t>=112&&t<=123?"f"+(t-112+1):t>=48&&t<=57?String(t-48):t>=96&&t<=105?String(t-96):To[t]),e})(t.keyCode)||""})(e,t.hasModifiers)===t.key&&(!t.hasModifiers||!!e.shiftKey==!!t.shiftKey&&!!e.ctrlKey==!!t.ctrlKey&&!!e.altKey==!!t.altKey&&!!e.metaKey==!!t.metaKey)}function Oo(t){return t.trim().split(" ").map((function(t){return(function e(t){return 1===t.length?{combo:t,key:t,event:"keydown"}:t.split("+").reduce((function(t,e){var n=e.split(":"),i=n[0],r=n[1];return i in Co?(t[Co[i]]=!0,t.hasModifiers=!0):(t.key=i,t.event=r||"keydown"),t}),{combo:t.split(":").shift()})})(t)}))}const zo={properties:{keyEventTarget:{type:Object,value:function(){return this}},stopKeyboardEventPropagation:{type:Boolean,value:!1},_boundKeyHandlers:{type:Array,value:function(){return[]}},_imperativeKeyBindings:{type:Object,value:function(){return{}}}},observers:["_resetKeyEventListeners(keyEventTarget, _boundKeyHandlers)"],keyBindings:{},registered:function(){this._prepKeyBindings()},attached:function(){this._listenKeyEventListeners()},detached:function(){this._unlistenKeyEventListeners()},addOwnKeyBinding:function(t,e){this._imperativeKeyBindings[t]=e,this._prepKeyBindings(),this._resetKeyEventListeners()},removeOwnKeyBindings:function(){this._imperativeKeyBindings={},this._prepKeyBindings(),this._resetKeyEventListeners()},keyboardEventMatchesKeys:function(t,e){for(var n=Oo(e),i=0;i<n.length;++i)if(Ro(n[i],t))return!0;return!1},_collectKeyBindings:function(){var t=this.behaviors.map((function(t){return t.keyBindings}));return-1===t.indexOf(this.keyBindings)&&t.push(this.keyBindings),t},_prepKeyBindings:function(){for(var t in this._keyBindings={},this._collectKeyBindings().forEach((function(t){for(var e in t)this._addKeyBinding(e,t[e])}),this),this._imperativeKeyBindings)this._addKeyBinding(t,this._imperativeKeyBindings[t]);for(var e in this._keyBindings)this._keyBindings[e].sort((function(t,e){var n=t[0].hasModifiers;return n===e[0].hasModifiers?0:n?-1:1}))},_addKeyBinding:function(t,e){Oo(t).forEach((function(t){this._keyBindings[t.event]=this._keyBindings[t.event]||[],this._keyBindings[t.event].push([t,e])}),this)},_resetKeyEventListeners:function(){this._unlistenKeyEventListeners(),this.isAttached&&this._listenKeyEventListeners()},_listenKeyEventListeners:function(){this.keyEventTarget&&Object.keys(this._keyBindings).forEach((function(t){var e=this._onKeyBindingEvent.bind(this,this._keyBindings[t]);this._boundKeyHandlers.push([this.keyEventTarget,t,e]),this.keyEventTarget.addEventListener(t,e)}),this)},_unlistenKeyEventListeners:function(){for(var t;this._boundKeyHandlers.length;)(t=this._boundKeyHandlers.pop())[0].removeEventListener(t[1],t[2])},_onKeyBindingEvent:function(t,e){if(this.stopKeyboardEventPropagation&&e.stopPropagation(),!e.defaultPrevented)for(var n=0;n<t.length;n++){var i=t[n][0],r=t[n][1];if(Ro(i,e)&&(this._triggerKeyHandler(i,r,e),e.defaultPrevented))return}},_triggerKeyHandler:function(t,e,n){var i=Object.create(t);i.keyboardEvent=n;var r=new CustomEvent(t.event,{detail:i,cancelable:!0});this[e].call(this,r),r.defaultPrevented&&n.preventDefault()}},Do={properties:{scrollTarget:{type:HTMLElement,value:function(){return this._defaultScrollTarget}}},observers:["_scrollTargetChanged(scrollTarget, isAttached)"],_shouldHaveListener:!0,_scrollTargetChanged:function(t,e){if(this._oldScrollTarget&&(this._toggleScrollListener(!1,this._oldScrollTarget),this._oldScrollTarget=null),e)if("document"===t)this.scrollTarget=this._doc;else if("string"==typeof t){var n=this.domHost;this.scrollTarget=n&&n.$?n.$[t]:Yi(this.ownerDocument).querySelector("#"+t)}else this._isValidScrollTarget()&&(this._oldScrollTarget=t,this._toggleScrollListener(this._shouldHaveListener,t))},_scrollHandler:function t(){},get _defaultScrollTarget(){return this._doc},get _doc(){return this.ownerDocument.documentElement},get _scrollTop(){return this._isValidScrollTarget()?this.scrollTarget===this._doc?window.pageYOffset:this.scrollTarget.scrollTop:0},get _scrollLeft(){return this._isValidScrollTarget()?this.scrollTarget===this._doc?window.pageXOffset:this.scrollTarget.scrollLeft:0},set _scrollTop(t){this.scrollTarget===this._doc?window.scrollTo(window.pageXOffset,t):this._isValidScrollTarget()&&(this.scrollTarget.scrollTop=t)},set _scrollLeft(t){this.scrollTarget===this._doc?window.scrollTo(t,window.pageYOffset):this._isValidScrollTarget()&&(this.scrollTarget.scrollLeft=t)},scroll:function(t,e){var n;"object"==typeof t?(n=t.left,e=t.top):n=t,n=n||0,e=e||0,this.scrollTarget===this._doc?window.scrollTo(n,e):this._isValidScrollTarget()&&(this.scrollTarget.scrollLeft=n,this.scrollTarget.scrollTop=e)},get _scrollTargetWidth(){return this._isValidScrollTarget()?this.scrollTarget===this._doc?window.innerWidth:this.scrollTarget.offsetWidth:0},get _scrollTargetHeight(){return this._isValidScrollTarget()?this.scrollTarget===this._doc?window.innerHeight:this.scrollTarget.offsetHeight:0},_isValidScrollTarget:function(){return this.scrollTarget instanceof HTMLElement},_toggleScrollListener:function(t,e){var n=e===this._doc?window:e;t?this._boundScrollHandler||(this._boundScrollHandler=this._scrollHandler.bind(this),n.addEventListener("scroll",this._boundScrollHandler)):this._boundScrollHandler&&(n.removeEventListener("scroll",this._boundScrollHandler),this._boundScrollHandler=null)},toggleScrollListener:function(t){this._shouldHaveListener=t,this._toggleScrollListener(t,this.scrollTarget)}};
/**
    @license
    Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
/**
    @license
    Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
var Bo=navigator.userAgent.match(/iP(?:hone|ad;(?: U;)? CPU) OS (\d+)/),Ho=Bo&&Bo[1]>=8,Fo="-10000px",Vo=-100;Rr({_template:_e`
    <style>
      :host {
        display: block;
      }

      @media only screen and (-webkit-max-device-pixel-ratio: 1) {
        :host {
          will-change: transform;
        }
      }

      #items {
        @apply --iron-list-items-container;
        position: relative;
      }

      :host(:not([grid])) #items > ::slotted(*) {
        width: 100%;
      }

      #items > ::slotted(*) {
        box-sizing: border-box;
        margin: 0;
        position: absolute;
        top: 0;
        will-change: transform;
      }
    </style>

    <array-selector id="selector" items="{{items}}" selected="{{selectedItems}}" selected-item="{{selectedItem}}"></array-selector>

    <div id="items">
      <slot></slot>
    </div>
`,is:"iron-list",properties:{items:{type:Array},as:{type:String,value:"item"},indexAs:{type:String,value:"index"},selectedAs:{type:String,value:"selected"},grid:{type:Boolean,value:!1,reflectToAttribute:!0,observer:"_gridChanged"},selectionEnabled:{type:Boolean,value:!1},selectedItem:{type:Object,notify:!0},selectedItems:{type:Object,notify:!0},multiSelection:{type:Boolean,value:!1},scrollOffset:{type:Number,value:0}},observers:["_itemsChanged(items.*)","_selectionEnabledChanged(selectionEnabled)","_multiSelectionChanged(multiSelection)","_setOverflow(scrollTarget, scrollOffset)"],behaviors:[Zr,go,Do,po],_ratio:.5,_scrollerPaddingTop:0,_scrollPosition:0,_physicalSize:0,_physicalAverage:0,_physicalAverageCount:0,_physicalTop:0,_virtualCount:0,_estScrollHeight:0,_scrollHeight:0,_viewportHeight:0,_viewportWidth:0,_physicalItems:null,_physicalSizes:null,_firstVisibleIndexVal:null,_lastVisibleIndexVal:null,_maxPages:2,_focusedItem:null,_focusedVirtualIndex:-1,_focusedPhysicalIndex:-1,_offscreenFocusedItem:null,_focusBackfillItem:null,_itemsPerRow:1,_itemWidth:0,_rowHeight:0,_templateCost:0,_parentModel:!0,get _physicalBottom(){return this._physicalTop+this._physicalSize},get _scrollBottom(){return this._scrollPosition+this._viewportHeight},get _virtualEnd(){return this._virtualStart+this._physicalCount-1},get _hiddenContentSize(){return(this.grid?this._physicalRows*this._rowHeight:this._physicalSize)-this._viewportHeight},get _itemsParent(){return Yi(Yi(this._userTemplate).parentNode)},get _maxScrollTop(){return this._estScrollHeight-this._viewportHeight+this._scrollOffset},get _maxVirtualStart(){var t=this._convertIndexToCompleteRow(this._virtualCount);return Math.max(0,t-this._physicalCount)},set _virtualStart(t){t=this._clamp(t,0,this._maxVirtualStart),this.grid&&(t-=t%this._itemsPerRow),this._virtualStartVal=t},get _virtualStart(){return this._virtualStartVal||0},set _physicalStart(t){(t%=this._physicalCount)<0&&(t=this._physicalCount+t),this.grid&&(t-=t%this._itemsPerRow),this._physicalStartVal=t},get _physicalStart(){return this._physicalStartVal||0},get _physicalEnd(){return(this._physicalStart+this._physicalCount-1)%this._physicalCount},set _physicalCount(t){this._physicalCountVal=t},get _physicalCount(){return this._physicalCountVal||0},get _optPhysicalSize(){return 0===this._viewportHeight?1/0:this._viewportHeight*this._maxPages},get _isVisible(){return Boolean(this.offsetWidth||this.offsetHeight)},get firstVisibleIndex(){var t=this._firstVisibleIndexVal;if(null==t){var e=this._physicalTop+this._scrollOffset;t=this._iterateItems((function(t,n){return(e+=this._getPhysicalSizeIncrement(t))>this._scrollPosition?this.grid?n-n%this._itemsPerRow:n:this.grid&&this._virtualCount-1===n?n-n%this._itemsPerRow:void 0}))||0,this._firstVisibleIndexVal=t}return t},get lastVisibleIndex(){var t=this._lastVisibleIndexVal;if(null==t){if(this.grid)t=Math.min(this._virtualCount,this.firstVisibleIndex+this._estRowsInView*this._itemsPerRow-1);else{var e=this._physicalTop+this._scrollOffset;this._iterateItems((function(n,i){e<this._scrollBottom&&(t=i),e+=this._getPhysicalSizeIncrement(n)}))}this._lastVisibleIndexVal=t}return t},get _defaultScrollTarget(){return this},get _virtualRowCount(){return Math.ceil(this._virtualCount/this._itemsPerRow)},get _estRowsInView(){return Math.ceil(this._viewportHeight/this._rowHeight)},get _physicalRows(){return Math.ceil(this._physicalCount/this._itemsPerRow)},get _scrollOffset(){return this._scrollerPaddingTop+this.scrollOffset},ready:function(){this.addEventListener("focus",this._didFocus.bind(this),!0)},attached:function(){this._debounce("_render",this._render,_t),this.listen(this,"iron-resize","_resizeHandler"),this.listen(this,"keydown","_keydownHandler")},detached:function(){this.unlisten(this,"iron-resize","_resizeHandler"),this.unlisten(this,"keydown","_keydownHandler")},_setOverflow:function(t){this.style.webkitOverflowScrolling=t===this?"touch":"",this.style.overflowY=t===this?"auto":"",this._lastVisibleIndexVal=null,this._firstVisibleIndexVal=null,this._debounce("_render",this._render,_t)},updateViewportBoundaries:function(){var t=window.getComputedStyle(this);this._scrollerPaddingTop=this.scrollTarget===this?0:parseInt(t["padding-top"],10),this._isRTL=Boolean("rtl"===t.direction),this._viewportWidth=this.$.items.offsetWidth,this._viewportHeight=this._scrollTargetHeight,this.grid&&this._updateGridMetrics()},_scrollHandler:function(){var t=Math.max(0,Math.min(this._maxScrollTop,this._scrollTop)),e=t-this._scrollPosition,n=e>=0;if(this._scrollPosition=t,this._firstVisibleIndexVal=null,this._lastVisibleIndexVal=null,Math.abs(e)>this._physicalSize&&this._physicalSize>0){e-=this._scrollOffset;var i=Math.round(e/this._physicalAverage)*this._itemsPerRow;this._virtualStart=this._virtualStart+i,this._physicalStart=this._physicalStart+i,this._physicalTop=Math.min(Math.floor(this._virtualStart/this._itemsPerRow)*this._physicalAverage,this._scrollPosition),this._update()}else if(this._physicalCount>0){var r=this._getReusables(n);n?(this._physicalTop=r.physicalTop,this._virtualStart=this._virtualStart+r.indexes.length,this._physicalStart=this._physicalStart+r.indexes.length):(this._virtualStart=this._virtualStart-r.indexes.length,this._physicalStart=this._physicalStart-r.indexes.length),this._update(r.indexes,n?null:r.indexes),this._debounce("_increasePoolIfNeeded",this._increasePoolIfNeeded.bind(this,0),vt)}},_getReusables:function(t){var e,n,i,r=[],o=this._hiddenContentSize*this._ratio,a=this._virtualStart,s=this._virtualEnd,l=this._physicalCount,c=this._physicalTop+this._scrollOffset,u=this._scrollPosition,h=this._scrollBottom;for(t?(e=this._physicalStart,n=u-c):(e=this._physicalEnd,n=this._physicalBottom+this._scrollOffset-h);n-=i=this._getPhysicalSizeIncrement(e),!(r.length>=l||n<=o);)if(t){if(s+r.length+1>=this._virtualCount)break;if(c+i>=u-this._scrollOffset)break;r.push(e),c+=i,e=(e+1)%l}else{if(a-r.length<=0)break;if(c+this._physicalSize-i<=h)break;r.push(e),c-=i,e=0===e?l-1:e-1}return{indexes:r,physicalTop:c-this._scrollOffset}},_update:function(t,e){if(!(t&&0===t.length||0===this._physicalCount)){if(this._manageFocus(),this._assignModels(t),this._updateMetrics(t),e)for(;e.length;){var n=e.pop();this._physicalTop-=this._getPhysicalSizeIncrement(n)}this._positionItems(),this._updateScrollerSize()}},_createPool:function(t){var e,n;this._ensureTemplatized();var i=new Array(t);for(e=0;e<t;e++)n=this.stamp(null),i[e]=n.root.querySelector("*"),this._itemsParent.appendChild(n.root);return i},_isClientFull:function(){return 0!=this._scrollBottom&&this._physicalBottom-1>=this._scrollBottom&&this._physicalTop<=this._scrollPosition},_increasePoolIfNeeded:function(t){var e=this._clamp(this._physicalCount+t,3,this._virtualCount-this._virtualStart);if(e=this._convertIndexToCompleteRow(e),this.grid){var n=e%this._itemsPerRow;n&&e-n<=this._physicalCount&&(e+=this._itemsPerRow),e-=n}var i=e-this._physicalCount,r=Math.round(.5*this._physicalCount);if(!(i<0)){if(i>0){var o=window.performance.now();[].push.apply(this._physicalItems,this._createPool(i));for(var a=0;a<i;a++)this._physicalSizes.push(0);this._physicalCount=this._physicalCount+i,this._physicalStart>this._physicalEnd&&this._isIndexRendered(this._focusedVirtualIndex)&&this._getPhysicalIndex(this._focusedVirtualIndex)<this._physicalEnd&&(this._physicalStart=this._physicalStart+i),this._update(),this._templateCost=(window.performance.now()-o)/i,r=Math.round(.5*this._physicalCount)}this._virtualEnd>=this._virtualCount-1||0===r||(this._isClientFull()?this._physicalSize<this._optPhysicalSize&&this._debounce("_increasePoolIfNeeded",this._increasePoolIfNeeded.bind(this,this._clamp(Math.round(50/this._templateCost),1,r)),yt):this._debounce("_increasePoolIfNeeded",this._increasePoolIfNeeded.bind(this,r),vt))}},_render:function(){if(this.isAttached&&this._isVisible)if(0!==this._physicalCount){var t=this._getReusables(!0);this._physicalTop=t.physicalTop,this._virtualStart=this._virtualStart+t.indexes.length,this._physicalStart=this._physicalStart+t.indexes.length,this._update(t.indexes),this._update(),this._increasePoolIfNeeded(0)}else this._virtualCount>0&&(this.updateViewportBoundaries(),this._increasePoolIfNeeded(3))},_ensureTemplatized:function(){if(!this.ctor){this._userTemplate=this.queryEffectiveChildren("template"),this._userTemplate||console.warn("iron-list requires a template to be provided in light-dom");var t={__key__:!0};t[this.as]=!0,t[this.indexAs]=!0,t[this.selectedAs]=!0,t.tabIndex=!0,this._instanceProps=t,this.templatize(this._userTemplate,this.mutableData)}},_gridChanged:function(t,e){void 0!==e&&(this.notifyResize(),Di(),t&&this._updateGridMetrics())},_itemsChanged:function(t){if("items"===t.path)this._virtualStart=0,this._physicalTop=0,this._virtualCount=this.items?this.items.length:0,this._physicalIndexForKey={},this._firstVisibleIndexVal=null,this._lastVisibleIndexVal=null,this._physicalCount=this._physicalCount||0,this._physicalItems=this._physicalItems||[],this._physicalSizes=this._physicalSizes||[],this._physicalStart=0,this._scrollTop>this._scrollOffset&&this._resetScrollPosition(0),this._removeFocusedItem(),this._debounce("_render",this._render,_t);else if("items.splices"===t.path){if(this._adjustVirtualIndex(t.value.indexSplices),this._virtualCount=this.items?this.items.length:0,t.value.indexSplices.some((function(t){return t.addedCount>0||t.removed.length>0}))){var e=this._getActiveElement();this.contains(e)&&e.blur()}var n=t.value.indexSplices.some((function(t){return t.index+t.addedCount>=this._virtualStart&&t.index<=this._virtualEnd}),this);this._isClientFull()&&!n||this._debounce("_render",this._render,_t)}else"items.length"!==t.path&&this._forwardItemPath(t.path,t.value)},_forwardItemPath:function(t,e){var n,i,r,o=(t=t.slice(6)).indexOf(".");-1===o&&(o=t.length);var a=this.modelForElement(this._offscreenFocusedItem),s=parseInt(t.substring(0,o),10);(n=this._isIndexRendered(s))?(i=this._getPhysicalIndex(s),r=this.modelForElement(this._physicalItems[i])):a&&(r=a),r&&r[this.indexAs]===s&&(t=t.substring(o+1),r._setPendingPropertyOrPath(t=this.as+(t?"."+t:""),e,!1,!0),r._flushProperties&&r._flushProperties(),n&&(this._updateMetrics([i]),this._positionItems(),this._updateScrollerSize()))},_adjustVirtualIndex:function(t){t.forEach((function(t){if(t.removed.forEach(this._removeItem,this),t.index<this._virtualStart){var e=Math.max(t.addedCount-t.removed.length,t.index-this._virtualStart);this._virtualStart=this._virtualStart+e,this._focusedVirtualIndex>=0&&(this._focusedVirtualIndex=this._focusedVirtualIndex+e)}}),this)},_removeItem:function(t){this.$.selector.deselect(t),this._focusedItem&&this.modelForElement(this._focusedItem)[this.as]===t&&this._removeFocusedItem()},_iterateItems:function(t,e){var n,i,r,o;if(2===arguments.length&&e){for(o=0;o<e.length;o++)if(i=this._computeVidx(n=e[o]),null!=(r=t.call(this,n,i)))return r}else{for(n=this._physicalStart,i=this._virtualStart;n<this._physicalCount;n++,i++)if(null!=(r=t.call(this,n,i)))return r;for(n=0;n<this._physicalStart;n++,i++)if(null!=(r=t.call(this,n,i)))return r}},_computeVidx:function(t){return t>=this._physicalStart?this._virtualStart+(t-this._physicalStart):this._virtualStart+(this._physicalCount-this._physicalStart)+t},_assignModels:function(t){this._iterateItems((function(t,e){var n=this._physicalItems[t],i=this.items&&this.items[e];if(null!=i){var r=this.modelForElement(n);r.__key__=null,this._forwardProperty(r,this.as,i),this._forwardProperty(r,this.selectedAs,this.$.selector.isSelected(i)),this._forwardProperty(r,this.indexAs,e),this._forwardProperty(r,"tabIndex",this._focusedVirtualIndex===e?0:-1),this._physicalIndexForKey[r.__key__]=t,r._flushProperties&&r._flushProperties(!0),n.removeAttribute("hidden")}else n.setAttribute("hidden","")}),t)},_updateMetrics:function(t){Di();var e=0,n=0,i=this._physicalAverageCount,r=this._physicalAverage;this._iterateItems((function(t,i){n+=this._physicalSizes[t],this._physicalSizes[t]=this._physicalItems[t].offsetHeight,e+=this._physicalSizes[t],this._physicalAverageCount+=this._physicalSizes[t]?1:0}),t),this.grid?(this._updateGridMetrics(),this._physicalSize=Math.ceil(this._physicalCount/this._itemsPerRow)*this._rowHeight):(n=1===this._itemsPerRow?n:Math.ceil(this._physicalCount/this._itemsPerRow)*this._rowHeight,this._physicalSize=this._physicalSize+e-n,this._itemsPerRow=1),this._physicalAverageCount!==i&&(this._physicalAverage=Math.round((r*i+e)/this._physicalAverageCount))},_updateGridMetrics:function(){this._itemWidth=this._physicalCount>0?this._physicalItems[0].getBoundingClientRect().width:200,this._rowHeight=this._physicalCount>0?this._physicalItems[0].offsetHeight:200,this._itemsPerRow=this._itemWidth?Math.floor(this._viewportWidth/this._itemWidth):this._itemsPerRow},_positionItems:function(){this._adjustScrollPosition();var t=this._physicalTop;if(this.grid){var e=(this._viewportWidth-this._itemsPerRow*this._itemWidth)/2;this._iterateItems((function(n,i){var r=Math.floor(i%this._itemsPerRow*this._itemWidth+e);this._isRTL&&(r*=-1),this.translate3d(r+"px",t+"px",0,this._physicalItems[n]),this._shouldRenderNextRow(i)&&(t+=this._rowHeight)}))}else{const e=[];this._iterateItems((function(n,i){const r=this._physicalItems[n];this.translate3d(0,t+"px",0,r),t+=this._physicalSizes[n];const o=r.id;o&&e.push(o)})),e.length&&this.setAttribute("aria-owns",e.join(" "))}},_getPhysicalSizeIncrement:function(t){return this.grid?this._computeVidx(t)%this._itemsPerRow!=this._itemsPerRow-1?0:this._rowHeight:this._physicalSizes[t]},_shouldRenderNextRow:function(t){return t%this._itemsPerRow==this._itemsPerRow-1},_adjustScrollPosition:function(){var t=0===this._virtualStart?this._physicalTop:Math.min(this._scrollPosition+this._physicalTop,0);if(0!==t){this._physicalTop=this._physicalTop-t;var e=this._scrollPosition;!Ho&&e>0&&this._resetScrollPosition(e-t)}},_resetScrollPosition:function(t){this.scrollTarget&&t>=0&&(this._scrollTop=t,this._scrollPosition=this._scrollTop)},_updateScrollerSize:function(t){this._estScrollHeight=this.grid?this._virtualRowCount*this._rowHeight:this._physicalBottom+Math.max(this._virtualCount-this._physicalCount-this._virtualStart,0)*this._physicalAverage,((t=(t=(t=t||0===this._scrollHeight)||this._scrollPosition>=this._estScrollHeight-this._physicalSize)||this.grid&&this.$.items.style.height<this._estScrollHeight)||Math.abs(this._estScrollHeight-this._scrollHeight)>=this._viewportHeight)&&(this.$.items.style.height=this._estScrollHeight+"px",this._scrollHeight=this._estScrollHeight)},scrollToItem:function(t){return this.scrollToIndex(this.items.indexOf(t))},scrollToIndex:function(t){if(!("number"!=typeof t||t<0||t>this.items.length-1)&&(Di(),0!==this._physicalCount)){t=this._clamp(t,0,this._virtualCount-1),(!this._isIndexRendered(t)||t>=this._maxVirtualStart)&&(this._virtualStart=this.grid?t-2*this._itemsPerRow:t-1),this._manageFocus(),this._assignModels(),this._updateMetrics(),this._physicalTop=Math.floor(this._virtualStart/this._itemsPerRow)*this._physicalAverage;for(var e=this._physicalStart,n=this._virtualStart,i=0,r=this._hiddenContentSize;n<t&&i<=r;)i+=this._getPhysicalSizeIncrement(e),e=(e+1)%this._physicalCount,n++;this._updateScrollerSize(!0),this._positionItems(),this._resetScrollPosition(this._physicalTop+this._scrollOffset+i),this._increasePoolIfNeeded(0),this._firstVisibleIndexVal=null,this._lastVisibleIndexVal=null}},_resetAverage:function(){this._physicalAverage=0,this._physicalAverageCount=0},_resizeHandler:function(){this._debounce("_render",(function(){this._firstVisibleIndexVal=null,this._lastVisibleIndexVal=null,this._isVisible?(this.updateViewportBoundaries(),this.toggleScrollListener(!0),this._resetAverage(),this._render()):this.toggleScrollListener(!1)}),_t)},selectItem:function(t){return this.selectIndex(this.items.indexOf(t))},selectIndex:function(t){if(!(t<0||t>=this._virtualCount)){if(!this.multiSelection&&this.selectedItem&&this.clearSelection(),this._isIndexRendered(t)){var e=this.modelForElement(this._physicalItems[this._getPhysicalIndex(t)]);e&&(e[this.selectedAs]=!0),this.updateSizeForIndex(t)}this.$.selector.selectIndex(t)}},deselectItem:function(t){return this.deselectIndex(this.items.indexOf(t))},deselectIndex:function(t){t<0||t>=this._virtualCount||(this._isIndexRendered(t)&&(this.modelForElement(this._physicalItems[this._getPhysicalIndex(t)])[this.selectedAs]=!1,this.updateSizeForIndex(t)),this.$.selector.deselectIndex(t))},toggleSelectionForItem:function(t){return this.toggleSelectionForIndex(this.items.indexOf(t))},toggleSelectionForIndex:function(t){(this.$.selector.isIndexSelected?this.$.selector.isIndexSelected(t):this.$.selector.isSelected(this.items[t]))?this.deselectIndex(t):this.selectIndex(t)},clearSelection:function(){this._iterateItems((function(t,e){this.modelForElement(this._physicalItems[t])[this.selectedAs]=!1})),this.$.selector.clearSelection()},_selectionEnabledChanged:function(t){(t?this.listen:this.unlisten).call(this,this,"tap","_selectionHandler")},_selectionHandler:function(t){var e=this.modelForElement(t.target);if(e){var n,i,r=Yi(t).path[0],o=this._getActiveElement(),a=this._physicalItems[this._getPhysicalIndex(e[this.indexAs])];"input"!==r.localName&&"button"!==r.localName&&"select"!==r.localName&&(n=e.tabIndex,e.tabIndex=Vo,i=o?o.tabIndex:-1,e.tabIndex=n,o&&a!==o&&a.contains(o)&&i!==Vo||this.toggleSelectionForItem(e[this.as]))}},_multiSelectionChanged:function(t){this.clearSelection(),this.$.selector.multi=t},updateSizeForItem:function(t){return this.updateSizeForIndex(this.items.indexOf(t))},updateSizeForIndex:function(t){return this._isIndexRendered(t)?(this._updateMetrics([this._getPhysicalIndex(t)]),this._positionItems(),null):null},_manageFocus:function(){var t=this._focusedVirtualIndex;t>=0&&t<this._virtualCount?this._isIndexRendered(t)?this._restoreFocusedItem():this._createFocusBackfillItem():this._virtualCount>0&&this._physicalCount>0&&(this._focusedPhysicalIndex=this._physicalStart,this._focusedVirtualIndex=this._virtualStart,this._focusedItem=this._physicalItems[this._physicalStart])},_convertIndexToCompleteRow:function(t){return this._itemsPerRow=this._itemsPerRow||1,this.grid?Math.ceil(t/this._itemsPerRow)*this._itemsPerRow:t},_isIndexRendered:function(t){return t>=this._virtualStart&&t<=this._virtualEnd},_isIndexVisible:function(t){return t>=this.firstVisibleIndex&&t<=this.lastVisibleIndex},_getPhysicalIndex:function(t){return(this._physicalStart+(t-this._virtualStart))%this._physicalCount},focusItem:function(t){this._focusPhysicalItem(t)},_focusPhysicalItem:function(t){if(!(t<0||t>=this._virtualCount)){this._restoreFocusedItem(),this._isIndexRendered(t)||this.scrollToIndex(t);var e,n=this._physicalItems[this._getPhysicalIndex(t)],i=this.modelForElement(n);i.tabIndex=Vo,n.tabIndex===Vo&&(e=n),e||(e=Yi(n).querySelector('[tabindex="-100"]')),i.tabIndex=0,this._focusedVirtualIndex=t,e&&e.focus()}},_removeFocusedItem:function(){this._offscreenFocusedItem&&this._itemsParent.removeChild(this._offscreenFocusedItem),this._offscreenFocusedItem=null,this._focusBackfillItem=null,this._focusedItem=null,this._focusedVirtualIndex=-1,this._focusedPhysicalIndex=-1},_createFocusBackfillItem:function(){var t=this._focusedPhysicalIndex;if(!(this._offscreenFocusedItem||this._focusedVirtualIndex<0)){if(!this._focusBackfillItem){var e=this.stamp(null);this._focusBackfillItem=e.root.querySelector("*"),this._itemsParent.appendChild(e.root)}this._offscreenFocusedItem=this._physicalItems[t],this.modelForElement(this._offscreenFocusedItem).tabIndex=0,this._physicalItems[t]=this._focusBackfillItem,this._focusedPhysicalIndex=t,this.translate3d(0,Fo,0,this._offscreenFocusedItem)}},_restoreFocusedItem:function(){if(this._offscreenFocusedItem&&!(this._focusedVirtualIndex<0)){this._assignModels();var t=this._focusedPhysicalIndex=this._getPhysicalIndex(this._focusedVirtualIndex),e=this._physicalItems[t];if(e){var n=this.modelForElement(e),i=this.modelForElement(this._offscreenFocusedItem);n[this.as]===i[this.as]?(this._focusBackfillItem=e,n.tabIndex=-1,this._physicalItems[t]=this._offscreenFocusedItem,this.translate3d(0,Fo,0,this._focusBackfillItem)):(this._removeFocusedItem(),this._focusBackfillItem=null),this._offscreenFocusedItem=null}}},_didFocus:function(t){var e=this.modelForElement(t.target),n=this.modelForElement(this._focusedItem),i=null!==this._offscreenFocusedItem,r=this._focusedVirtualIndex;e&&(n===e?this._isIndexVisible(r)||this.scrollToIndex(r):(this._restoreFocusedItem(),n&&(n.tabIndex=-1),e.tabIndex=0,this._focusedVirtualIndex=r=e[this.indexAs],this._focusedPhysicalIndex=this._getPhysicalIndex(r),this._focusedItem=this._physicalItems[this._focusedPhysicalIndex],i&&!this._offscreenFocusedItem&&this._update()))},_keydownHandler:function(t){switch(t.keyCode){case 40:this._focusedVirtualIndex<this._virtualCount-1&&t.preventDefault(),this._focusPhysicalItem(this._focusedVirtualIndex+(this.grid?this._itemsPerRow:1));break;case 39:this.grid&&this._focusPhysicalItem(this._focusedVirtualIndex+(this._isRTL?-1:1));break;case 38:this._focusedVirtualIndex>0&&t.preventDefault(),this._focusPhysicalItem(this._focusedVirtualIndex-(this.grid?this._itemsPerRow:1));break;case 37:this.grid&&this._focusPhysicalItem(this._focusedVirtualIndex+(this._isRTL?1:-1));break;case 13:this._focusPhysicalItem(this._focusedVirtualIndex),this.selectionEnabled&&this._selectionHandler(t)}},_clamp:function(t,e,n){return Math.min(n,Math.max(e,t))},_debounce:function(t,e,n){this._debouncers=this._debouncers||{},this._debouncers[t]=Tn.debounce(this._debouncers[t],n,e.bind(this)),An(this._debouncers[t])},_forwardProperty:function(t,e,n){t._setPendingProperty(e,n)},_forwardHostPropV2:function(t,e){(this._physicalItems||[]).concat([this._offscreenFocusedItem,this._focusBackfillItem]).forEach((function(n){n&&this.modelForElement(n).forwardHostProp(t,e)}),this)},_notifyInstancePropV2:function(t,e,n){if(Q(this.as,e)){var i=t[this.indexAs];e==this.as&&(this.items[i]=n),this.notifyPath(J(this.as,"items."+i,e),n)}},_getStampedChildren:function(){return this._physicalItems},_forwardInstancePath:function(t,e,n){0===e.indexOf(this.as+".")&&this.notifyPath("items."+t.__key__+"."+e.slice(this.as.length+1),n)},_forwardParentPath:function(t,e){(this._physicalItems||[]).concat([this._offscreenFocusedItem,this._focusBackfillItem]).forEach((function(n){n&&this.modelForElement(n).notifyPath(t,e)}),this)},_forwardParentProp:function(t,e){(this._physicalItems||[]).concat([this._offscreenFocusedItem,this._focusBackfillItem]).forEach((function(n){n&&(this.modelForElement(n)[t]=e)}),this)},_getActiveElement:function(){var t=this._itemsParent.node.domHost;return Yi(t?t.root:document).activeElement}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
class Uo{constructor(t){this.selection=[],this.selectCallback=t}get(){return this.multi?this.selection.slice():this.selection[0]}clear(t){this.selection.slice().forEach((function(e){(!t||t.indexOf(e)<0)&&this.setItemSelected(e,!1)}),this)}isSelected(t){return this.selection.indexOf(t)>=0}setItemSelected(t,e){if(null!=t&&e!==this.isSelected(t)){if(e)this.selection.push(t);else{var n=this.selection.indexOf(t);n>=0&&this.selection.splice(n,1)}this.selectCallback&&this.selectCallback(t,e)}}select(t){this.multi?this.toggle(t):this.get()!==t&&(this.setItemSelected(this.get(),!1),this.setItemSelected(t,!0))}toggle(t){this.setItemSelected(t,!this.isSelected(t))}}
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */const jo={properties:{attrForSelected:{type:String,value:null},selected:{type:String,notify:!0},selectedItem:{type:Object,readOnly:!0,notify:!0},activateEvent:{type:String,value:"tap",observer:"_activateEventChanged"},selectable:String,selectedClass:{type:String,value:"iron-selected"},selectedAttribute:{type:String,value:null},fallbackSelection:{type:String,value:null},items:{type:Array,readOnly:!0,notify:!0,value:function(){return[]}},_excludedLocalNames:{type:Object,value:function(){return{template:1,"dom-bind":1,"dom-if":1,"dom-repeat":1}}}},observers:["_updateAttrForSelected(attrForSelected)","_updateSelected(selected)","_checkFallback(fallbackSelection)"],created:function(){this._bindFilterItem=this._filterItem.bind(this),this._selection=new Uo(this._applySelection.bind(this))},attached:function(){this._observer=this._observeItems(this),this._addListener(this.activateEvent)},detached:function(){this._observer&&Yi(this).unobserveNodes(this._observer),this._removeListener(this.activateEvent)},indexOf:function(t){return this.items?this.items.indexOf(t):-1},select:function(t){this.selected=t},selectPrevious:function(){var t=this.items.length,e=t-1;void 0!==this.selected&&(e=(Number(this._valueToIndex(this.selected))-1+t)%t),this.selected=this._indexToValue(e)},selectNext:function(){var t=0;void 0!==this.selected&&(t=(Number(this._valueToIndex(this.selected))+1)%this.items.length),this.selected=this._indexToValue(t)},selectIndex:function(t){this.select(this._indexToValue(t))},forceSynchronousItemUpdate:function(){this._observer&&"function"==typeof this._observer.flush?this._observer.flush():this._updateItems()},get _shouldUpdateSelection(){return null!=this.selected},_checkFallback:function(){this._updateSelected()},_addListener:function(t){this.listen(this,t,"_activateHandler")},_removeListener:function(t){this.unlisten(this,t,"_activateHandler")},_activateEventChanged:function(t,e){this._removeListener(e),this._addListener(t)},_updateItems:function(){var t=Yi(this).queryDistributedElements(this.selectable||"*");t=Array.prototype.filter.call(t,this._bindFilterItem),this._setItems(t)},_updateAttrForSelected:function(){this.selectedItem&&(this.selected=this._valueForItem(this.selectedItem))},_updateSelected:function(){this._selectSelected(this.selected)},_selectSelected:function(t){if(this.items){var e=this._valueToItem(this.selected);e?this._selection.select(e):this._selection.clear(),this.fallbackSelection&&this.items.length&&void 0===this._selection.get()&&(this.selected=this.fallbackSelection)}},_filterItem:function(t){return!this._excludedLocalNames[t.localName]},_valueToItem:function(t){return null==t?null:this.items[this._valueToIndex(t)]},_valueToIndex:function(t){if(!this.attrForSelected)return Number(t);for(var e,n=0;e=this.items[n];n++)if(this._valueForItem(e)==t)return n},_indexToValue:function(t){if(!this.attrForSelected)return t;var e=this.items[t];return e?this._valueForItem(e):void 0},_valueForItem:function(t){if(!t)return null;if(!this.attrForSelected){var e=this.indexOf(t);return-1===e?null:e}var n=t[st(this.attrForSelected)];return null!=n?n:t.getAttribute(this.attrForSelected)},_applySelection:function(t,e){this.selectedClass&&this.toggleClass(this.selectedClass,e,t),this.selectedAttribute&&this.toggleAttribute(this.selectedAttribute,e,t),this._selectionChange(),this.fire("iron-"+(e?"select":"deselect"),{item:t})},_selectionChange:function(){this._setSelectedItem(this._selection.get())},_observeItems:function(t){return Yi(t).observeNodes((function(t){this._updateItems(),this._updateSelected(),this.fire("iron-items-changed",t,{bubbles:!1,cancelable:!1})}))},_activateHandler:function(t){for(var e=t.target,n=this.items;e&&e!=this;){var i=n.indexOf(e);if(i>=0){var r=this._indexToValue(i);return void this._itemActivate(r,e)}e=e.parentNode}},_itemActivate:function(t,e){this.fire("iron-activate",{selected:t,item:e},{cancelable:!0}).defaultPrevented||this.select(t)}};
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */Rr({_template:_e`
    <style>
      :host {
        display: block;
      }

      :host > ::slotted(:not(slot):not(.iron-selected)) {
        display: none !important;
      }
    </style>

    <slot></slot>
`,is:"iron-pages",behaviors:[go,jo],properties:{activateEvent:{type:String,value:null}},observers:["_selectedPageChanged(selected)"],_selectedPageChanged:function(t,e){this.async(this.notifyResize)}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const Go=_e`
<custom-style>
  <style is="custom-style">
    html {

      --shadow-transition: {
        transition: box-shadow 0.28s cubic-bezier(0.4, 0, 0.2, 1);
      };

      --shadow-none: {
        box-shadow: none;
      };

      /* from http://codepen.io/shyndman/pen/c5394ddf2e8b2a5c9185904b57421cdb */

      --shadow-elevation-2dp: {
        box-shadow: 0 2px 2px 0 rgba(0, 0, 0, 0.14),
                    0 1px 5px 0 rgba(0, 0, 0, 0.12),
                    0 3px 1px -2px rgba(0, 0, 0, 0.2);
      };

      --shadow-elevation-3dp: {
        box-shadow: 0 3px 4px 0 rgba(0, 0, 0, 0.14),
                    0 1px 8px 0 rgba(0, 0, 0, 0.12),
                    0 3px 3px -2px rgba(0, 0, 0, 0.4);
      };

      --shadow-elevation-4dp: {
        box-shadow: 0 4px 5px 0 rgba(0, 0, 0, 0.14),
                    0 1px 10px 0 rgba(0, 0, 0, 0.12),
                    0 2px 4px -1px rgba(0, 0, 0, 0.4);
      };

      --shadow-elevation-6dp: {
        box-shadow: 0 6px 10px 0 rgba(0, 0, 0, 0.14),
                    0 1px 18px 0 rgba(0, 0, 0, 0.12),
                    0 3px 5px -1px rgba(0, 0, 0, 0.4);
      };

      --shadow-elevation-8dp: {
        box-shadow: 0 8px 10px 1px rgba(0, 0, 0, 0.14),
                    0 3px 14px 2px rgba(0, 0, 0, 0.12),
                    0 5px 5px -3px rgba(0, 0, 0, 0.4);
      };

      --shadow-elevation-12dp: {
        box-shadow: 0 12px 16px 1px rgba(0, 0, 0, 0.14),
                    0 4px 22px 3px rgba(0, 0, 0, 0.12),
                    0 6px 7px -4px rgba(0, 0, 0, 0.4);
      };

      --shadow-elevation-16dp: {
        box-shadow: 0 16px 24px 2px rgba(0, 0, 0, 0.14),
                    0  6px 30px 5px rgba(0, 0, 0, 0.12),
                    0  8px 10px -5px rgba(0, 0, 0, 0.4);
      };

      --shadow-elevation-24dp: {
        box-shadow: 0 24px 38px 3px rgba(0, 0, 0, 0.14),
                    0 9px 46px 8px rgba(0, 0, 0, 0.12),
                    0 11px 15px -7px rgba(0, 0, 0, 0.4);
      };
    }
  </style>
</custom-style>`;Go.setAttribute("style","display: none;"),document.head.appendChild(Go.content);
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const Wo=_e`
<dom-module id="paper-material-styles">
  <template>
    <style>
      html {
        --paper-material: {
          display: block;
          position: relative;
        };
        --paper-material-elevation-1: {
          @apply --shadow-elevation-2dp;
        };
        --paper-material-elevation-2: {
          @apply --shadow-elevation-4dp;
        };
        --paper-material-elevation-3: {
          @apply --shadow-elevation-6dp;
        };
        --paper-material-elevation-4: {
          @apply --shadow-elevation-8dp;
        };
        --paper-material-elevation-5: {
          @apply --shadow-elevation-16dp;
        };
      }
      .paper-material {
        @apply --paper-material;
      }
      .paper-material[elevation="1"] {
        @apply --paper-material-elevation-1;
      }
      .paper-material[elevation="2"] {
        @apply --paper-material-elevation-2;
      }
      .paper-material[elevation="3"] {
        @apply --paper-material-elevation-3;
      }
      .paper-material[elevation="4"] {
        @apply --paper-material-elevation-4;
      }
      .paper-material[elevation="5"] {
        @apply --paper-material-elevation-5;
      }

      /* Duplicate the styles because of https://github.com/webcomponents/shadycss/issues/193 */
      :host {
        --paper-material: {
          display: block;
          position: relative;
        };
        --paper-material-elevation-1: {
          @apply --shadow-elevation-2dp;
        };
        --paper-material-elevation-2: {
          @apply --shadow-elevation-4dp;
        };
        --paper-material-elevation-3: {
          @apply --shadow-elevation-6dp;
        };
        --paper-material-elevation-4: {
          @apply --shadow-elevation-8dp;
        };
        --paper-material-elevation-5: {
          @apply --shadow-elevation-16dp;
        };
      }
      :host(.paper-material) {
        @apply --paper-material;
      }
      :host(.paper-material[elevation="1"]) {
        @apply --paper-material-elevation-1;
      }
      :host(.paper-material[elevation="2"]) {
        @apply --paper-material-elevation-2;
      }
      :host(.paper-material[elevation="3"]) {
        @apply --paper-material-elevation-3;
      }
      :host(.paper-material[elevation="4"]) {
        @apply --paper-material-elevation-4;
      }
      :host(.paper-material[elevation="5"]) {
        @apply --paper-material-elevation-5;
      }
    </style>
  </template>
</dom-module>`;Wo.setAttribute("style","display: none;"),document.head.appendChild(Wo.content);
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const qo={properties:{focused:{type:Boolean,value:!1,notify:!0,readOnly:!0,reflectToAttribute:!0},disabled:{type:Boolean,value:!1,notify:!0,observer:"_disabledChanged",reflectToAttribute:!0},_oldTabIndex:{type:String},_boundFocusBlurHandler:{type:Function,value:function(){return this._focusBlurHandler.bind(this)}}},observers:["_changedControlState(focused, disabled)"],ready:function(){this.addEventListener("focus",this._boundFocusBlurHandler,!0),this.addEventListener("blur",this._boundFocusBlurHandler,!0)},_focusBlurHandler:function(t){this._setFocused("focus"===t.type)},_disabledChanged:function(t,e){this.setAttribute("aria-disabled",t?"true":"false"),this.style.pointerEvents=t?"none":"",t?(this._oldTabIndex=this.getAttribute("tabindex"),this._setFocused(!1),this.tabIndex=-1,this.blur()):void 0!==this._oldTabIndex&&(null===this._oldTabIndex?this.removeAttribute("tabindex"):this.setAttribute("tabindex",this._oldTabIndex))},_changedControlState:function(){this._controlStateChanged&&this._controlStateChanged()}},Yo={properties:{pressed:{type:Boolean,readOnly:!0,value:!1,reflectToAttribute:!0,observer:"_pressedChanged"},toggles:{type:Boolean,value:!1,reflectToAttribute:!0},active:{type:Boolean,value:!1,notify:!0,reflectToAttribute:!0},pointerDown:{type:Boolean,readOnly:!0,value:!1},receivedFocusFromKeyboard:{type:Boolean,readOnly:!0},ariaActiveAttribute:{type:String,value:"aria-pressed",observer:"_ariaActiveAttributeChanged"}},listeners:{down:"_downHandler",up:"_upHandler",tap:"_tapHandler"},observers:["_focusChanged(focused)","_activeChanged(active, ariaActiveAttribute)"],keyBindings:{"enter:keydown":"_asyncClick","space:keydown":"_spaceKeyDownHandler","space:keyup":"_spaceKeyUpHandler"},_mouseEventRe:/^mouse/,_tapHandler:function(){this.toggles?this._userActivate(!this.active):this.active=!1},_focusChanged:function(t){this._detectKeyboardFocus(t),t||this._setPressed(!1)},_detectKeyboardFocus:function(t){this._setReceivedFocusFromKeyboard(!this.pointerDown&&t)},_userActivate:function(t){this.active!==t&&(this.active=t,this.fire("change"))},_downHandler:function(t){this._setPointerDown(!0),this._setPressed(!0),this._setReceivedFocusFromKeyboard(!1)},_upHandler:function(){this._setPointerDown(!1),this._setPressed(!1)},_spaceKeyDownHandler:function(t){var e=t.detail.keyboardEvent,n=Yi(e).localTarget;this.isLightDescendant(n)||(e.preventDefault(),e.stopImmediatePropagation(),this._setPressed(!0))},_spaceKeyUpHandler:function(t){var e=Yi(t.detail.keyboardEvent).localTarget;this.isLightDescendant(e)||(this.pressed&&this._asyncClick(),this._setPressed(!1))},_asyncClick:function(){this.async((function(){this.click()}),1)},_pressedChanged:function(t){this._changedButtonState()},_ariaActiveAttributeChanged:function(t,e){e&&e!=t&&this.hasAttribute(e)&&this.removeAttribute(e)},_activeChanged:function(t,e){this.toggles?this.setAttribute(this.ariaActiveAttribute,t?"true":"false"):this.removeAttribute(this.ariaActiveAttribute),this._changedButtonState()},_controlStateChanged:function(){this.disabled?this._setPressed(!1):this._changedButtonState()},_changedButtonState:function(){this._buttonStateChanged&&this._buttonStateChanged()}},Xo=[zo,Yo];
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
/**
    @license
    Copyright (c) 2014 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
var $o={distance:function(t,e,n,i){var r=t-n,o=e-i;return Math.sqrt(r*r+o*o)},now:window.performance&&window.performance.now?window.performance.now.bind(window.performance):Date.now};function Ko(t){this.element=t,this.width=this.boundingRect.width,this.height=this.boundingRect.height,this.size=Math.max(this.width,this.height)}function Zo(t){this.element=t,this.color=window.getComputedStyle(t).color,this.wave=document.createElement("div"),this.waveContainer=document.createElement("div"),this.wave.style.backgroundColor=this.color,this.wave.classList.add("wave"),this.waveContainer.classList.add("wave-container"),Yi(this.waveContainer).appendChild(this.wave),this.resetInteractionState()}Ko.prototype={get boundingRect(){return this.element.getBoundingClientRect()},furthestCornerDistanceFrom:function(t,e){var n=$o.distance(t,e,0,0),i=$o.distance(t,e,this.width,0),r=$o.distance(t,e,0,this.height),o=$o.distance(t,e,this.width,this.height);return Math.max(n,i,r,o)}},Zo.MAX_RADIUS=300,Zo.prototype={get recenters(){return this.element.recenters},get center(){return this.element.center},get mouseDownElapsed(){var t;return this.mouseDownStart?(t=$o.now()-this.mouseDownStart,this.mouseUpStart&&(t-=this.mouseUpElapsed),t):0},get mouseUpElapsed(){return this.mouseUpStart?$o.now()-this.mouseUpStart:0},get mouseDownElapsedSeconds(){return this.mouseDownElapsed/1e3},get mouseUpElapsedSeconds(){return this.mouseUpElapsed/1e3},get mouseInteractionSeconds(){return this.mouseDownElapsedSeconds+this.mouseUpElapsedSeconds},get initialOpacity(){return this.element.initialOpacity},get opacityDecayVelocity(){return this.element.opacityDecayVelocity},get radius(){var t=1.1*Math.min(Math.sqrt(this.containerMetrics.width*this.containerMetrics.width+this.containerMetrics.height*this.containerMetrics.height),Zo.MAX_RADIUS)+5,e=t*(1-Math.pow(80,-this.mouseInteractionSeconds/(1.1-t/Zo.MAX_RADIUS*.2)));return Math.abs(e)},get opacity(){return this.mouseUpStart?Math.max(0,this.initialOpacity-this.mouseUpElapsedSeconds*this.opacityDecayVelocity):this.initialOpacity},get outerOpacity(){return Math.max(0,Math.min(.3*this.mouseUpElapsedSeconds,this.opacity))},get isOpacityFullyDecayed(){return this.opacity<.01&&this.radius>=Math.min(this.maxRadius,Zo.MAX_RADIUS)},get isRestingAtMaxRadius(){return this.opacity>=this.initialOpacity&&this.radius>=Math.min(this.maxRadius,Zo.MAX_RADIUS)},get isAnimationComplete(){return this.mouseUpStart?this.isOpacityFullyDecayed:this.isRestingAtMaxRadius},get translationFraction(){return Math.min(1,this.radius/this.containerMetrics.size*2/Math.sqrt(2))},get xNow(){return this.xEnd?this.xStart+this.translationFraction*(this.xEnd-this.xStart):this.xStart},get yNow(){return this.yEnd?this.yStart+this.translationFraction*(this.yEnd-this.yStart):this.yStart},get isMouseDown(){return this.mouseDownStart&&!this.mouseUpStart},resetInteractionState:function(){this.maxRadius=0,this.mouseDownStart=0,this.mouseUpStart=0,this.xStart=0,this.yStart=0,this.xEnd=0,this.yEnd=0,this.slideDistance=0,this.containerMetrics=new Ko(this.element)},draw:function(){var t,e,n;this.wave.style.opacity=this.opacity,t=this.radius/(this.containerMetrics.size/2),this.waveContainer.style.webkitTransform="translate("+(e=this.xNow-this.containerMetrics.width/2)+"px, "+(n=this.yNow-this.containerMetrics.height/2)+"px)",this.waveContainer.style.transform="translate3d("+e+"px, "+n+"px, 0)",this.wave.style.webkitTransform="scale("+t+","+t+")",this.wave.style.transform="scale3d("+t+","+t+",1)"},downAction:function(t){var e=this.containerMetrics.width/2,n=this.containerMetrics.height/2;this.resetInteractionState(),this.mouseDownStart=$o.now(),this.center?(this.xStart=e,this.yStart=n,this.slideDistance=$o.distance(this.xStart,this.yStart,this.xEnd,this.yEnd)):(this.xStart=t?t.detail.x-this.containerMetrics.boundingRect.left:this.containerMetrics.width/2,this.yStart=t?t.detail.y-this.containerMetrics.boundingRect.top:this.containerMetrics.height/2),this.recenters&&(this.xEnd=e,this.yEnd=n,this.slideDistance=$o.distance(this.xStart,this.yStart,this.xEnd,this.yEnd)),this.maxRadius=this.containerMetrics.furthestCornerDistanceFrom(this.xStart,this.yStart),this.waveContainer.style.top=(this.containerMetrics.height-this.containerMetrics.size)/2+"px",this.waveContainer.style.left=(this.containerMetrics.width-this.containerMetrics.size)/2+"px",this.waveContainer.style.width=this.containerMetrics.size+"px",this.waveContainer.style.height=this.containerMetrics.size+"px"},upAction:function(t){this.isMouseDown&&(this.mouseUpStart=$o.now())},remove:function(){Yi(Yi(this.waveContainer).parentNode).removeChild(this.waveContainer)}},Rr({_template:_e`
    <style>
      :host {
        display: block;
        position: absolute;
        border-radius: inherit;
        overflow: hidden;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;

        /* See PolymerElements/paper-behaviors/issues/34. On non-Chrome browsers,
         * creating a node (with a position:absolute) in the middle of an event
         * handler "interrupts" that event handler (which happens when the
         * ripple is created on demand) */
        pointer-events: none;
      }

      :host([animating]) {
        /* This resolves a rendering issue in Chrome (as of 40) where the
           ripple is not properly clipped by its parent (which may have
           rounded corners). See: http://jsbin.com/temexa/4

           Note: We only apply this style conditionally. Otherwise, the browser
           will create a new compositing layer for every ripple element on the
           page, and that would be bad. */
        -webkit-transform: translate(0, 0);
        transform: translate3d(0, 0, 0);
      }

      #background,
      #waves,
      .wave-container,
      .wave {
        pointer-events: none;
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
      }

      #background,
      .wave {
        opacity: 0;
      }

      #waves,
      .wave {
        overflow: hidden;
      }

      .wave-container,
      .wave {
        border-radius: 50%;
      }

      :host(.circle) #background,
      :host(.circle) #waves {
        border-radius: 50%;
      }

      :host(.circle) .wave-container {
        overflow: hidden;
      }
    </style>

    <div id="background"></div>
    <div id="waves"></div>
`,is:"paper-ripple",behaviors:[zo],properties:{initialOpacity:{type:Number,value:.25},opacityDecayVelocity:{type:Number,value:.8},recenters:{type:Boolean,value:!1},center:{type:Boolean,value:!1},ripples:{type:Array,value:function(){return[]}},animating:{type:Boolean,readOnly:!0,reflectToAttribute:!0,value:!1},holdDown:{type:Boolean,value:!1,observer:"_holdDownChanged"},noink:{type:Boolean,value:!1},_animating:{type:Boolean},_boundAnimate:{type:Function,value:function(){return this.animate.bind(this)}}},get target(){return this.keyEventTarget},keyBindings:{"enter:keydown":"_onEnterKeydown","space:keydown":"_onSpaceKeydown","space:keyup":"_onSpaceKeyup"},attached:function(){this.keyEventTarget=11==Yi(this).parentNode.nodeType?Yi(this).getOwnerRoot().host:Yi(this).parentNode;var t=this.keyEventTarget;this.listen(t,"up","uiUpAction"),this.listen(t,"down","uiDownAction")},detached:function(){this.unlisten(this.keyEventTarget,"up","uiUpAction"),this.unlisten(this.keyEventTarget,"down","uiDownAction"),this.keyEventTarget=null},get shouldKeepAnimating(){for(var t=0;t<this.ripples.length;++t)if(!this.ripples[t].isAnimationComplete)return!0;return!1},simulatedRipple:function(){this.downAction(null),this.async((function(){this.upAction()}),1)},uiDownAction:function(t){this.noink||this.downAction(t)},downAction:function(t){this.holdDown&&this.ripples.length>0||(this.addRipple().downAction(t),this._animating||(this._animating=!0,this.animate()))},uiUpAction:function(t){this.noink||this.upAction(t)},upAction:function(t){this.holdDown||(this.ripples.forEach((function(e){e.upAction(t)})),this._animating=!0,this.animate())},onAnimationComplete:function(){this._animating=!1,this.$.background.style.backgroundColor="",this.fire("transitionend")},addRipple:function(){var t=new Zo(this);return Yi(this.$.waves).appendChild(t.waveContainer),this.$.background.style.backgroundColor=t.color,this.ripples.push(t),this._setAnimating(!0),t},removeRipple:function(t){var e=this.ripples.indexOf(t);e<0||(this.ripples.splice(e,1),t.remove(),this.ripples.length||this._setAnimating(!1))},animate:function(){if(this._animating){var t,e;for(t=0;t<this.ripples.length;++t)(e=this.ripples[t]).draw(),this.$.background.style.opacity=e.outerOpacity,e.isOpacityFullyDecayed&&!e.isRestingAtMaxRadius&&this.removeRipple(e);this.shouldKeepAnimating||0!==this.ripples.length?window.requestAnimationFrame(this._boundAnimate):this.onAnimationComplete()}},animateRipple:function(){return this.animate()},_onEnterKeydown:function(){this.uiDownAction(),this.async(this.uiUpAction,1)},_onSpaceKeydown:function(){this.uiDownAction()},_onSpaceKeyup:function(){this.uiUpAction()},_holdDownChanged:function(t,e){void 0!==e&&(t?this.downAction():this.upAction())}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const Jo={properties:{noink:{type:Boolean,observer:"_noinkChanged"},_rippleContainer:{type:Object}},_buttonStateChanged:function(){this.focused&&this.ensureRipple()},_downHandler:function(t){Yo._downHandler.call(this,t),this.pressed&&this.ensureRipple(t)},ensureRipple:function(t){if(!this.hasRipple()){this._ripple=this._createRipple(),this._ripple.noink=this.noink;var e=this._rippleContainer||this.root;if(e&&Yi(e).appendChild(this._ripple),t){var n=Yi(this._rippleContainer||this),i=Yi(t).rootTarget;n.deepContains(i)&&this._ripple.uiDownAction(t)}}},getRipple:function(){return this.ensureRipple(),this._ripple},hasRipple:function(){return Boolean(this._ripple)},_createRipple:function(){return document.createElement("paper-ripple")},_noinkChanged:function(t){this.hasRipple()&&(this._ripple.noink=t)}},Qo={properties:{elevation:{type:Number,reflectToAttribute:!0,readOnly:!0}},observers:["_calculateElevation(focused, disabled, active, pressed, receivedFocusFromKeyboard)","_computeKeyboardClass(receivedFocusFromKeyboard)"],hostAttributes:{role:"button",tabindex:"0",animated:!0},_calculateElevation:function(){var t=1;this.disabled?t=0:this.active||this.pressed?t=4:this.receivedFocusFromKeyboard&&(t=3),this._setElevation(t)},_computeKeyboardClass:function(t){this.toggleClass("keyboard-focus",t)},_spaceKeyDownHandler:function(t){Yo._spaceKeyDownHandler.call(this,t),this.hasRipple()&&this.getRipple().ripples.length<1&&this._ripple.uiDownAction()},_spaceKeyUpHandler:function(t){Yo._spaceKeyUpHandler.call(this,t),this.hasRipple()&&this._ripple.uiUpAction()}},ta=[Xo,qo,Jo,Qo],ea=_e`
  <style include="paper-material-styles">
    /* Need to specify the same specificity as the styles imported from paper-material. */
    :host {
      @apply --layout-inline;
      @apply --layout-center-center;
      position: relative;
      box-sizing: border-box;
      min-width: 5.14em;
      margin: 0 0.29em;
      background: transparent;
      -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
      -webkit-tap-highlight-color: transparent;
      font: inherit;
      text-transform: uppercase;
      outline-width: 0;
      border-radius: 3px;
      -moz-user-select: none;
      -ms-user-select: none;
      -webkit-user-select: none;
      user-select: none;
      cursor: pointer;
      z-index: 0;
      padding: 0.7em 0.57em;

      @apply --paper-font-common-base;
      @apply --paper-button;
    }

    :host([elevation="1"]) {
      @apply --paper-material-elevation-1;
    }

    :host([elevation="2"]) {
      @apply --paper-material-elevation-2;
    }

    :host([elevation="3"]) {
      @apply --paper-material-elevation-3;
    }

    :host([elevation="4"]) {
      @apply --paper-material-elevation-4;
    }

    :host([elevation="5"]) {
      @apply --paper-material-elevation-5;
    }

    :host([hidden]) {
      display: none !important;
    }

    :host([raised].keyboard-focus) {
      font-weight: bold;
      @apply --paper-button-raised-keyboard-focus;
    }

    :host(:not([raised]).keyboard-focus) {
      font-weight: bold;
      @apply --paper-button-flat-keyboard-focus;
    }

    :host([disabled]) {
      background: none;
      color: #a8a8a8;
      cursor: auto;
      pointer-events: none;

      @apply --paper-button-disabled;
    }

    :host([disabled][raised]) {
      background: #eaeaea;
    }


    :host([animated]) {
      @apply --shadow-transition;
    }

    paper-ripple {
      color: var(--paper-button-ink-color);
    }
  </style>

  <slot></slot>`;
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */ea.setAttribute("strip-whitespace",""),Rr({_template:ea,is:"paper-button",behaviors:[ta],properties:{raised:{type:Boolean,reflectToAttribute:!0,value:!1,observer:"_calculateElevation"}},_calculateElevation:function(){this.raised?Qo._calculateElevation.apply(this):this._setElevation(0)}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const na=_e`
<custom-style>
  <style is="custom-style">
    html {

      /* Material Design color palette for Google products */

      --google-red-100: #f4c7c3;
      --google-red-300: #e67c73;
      --google-red-500: #db4437;
      --google-red-700: #c53929;

      --google-blue-100: #c6dafc;
      --google-blue-300: #7baaf7;
      --google-blue-500: #4285f4;
      --google-blue-700: #3367d6;

      --google-green-100: #b7e1cd;
      --google-green-300: #57bb8a;
      --google-green-500: #0f9d58;
      --google-green-700: #0b8043;

      --google-yellow-100: #fce8b2;
      --google-yellow-300: #f7cb4d;
      --google-yellow-500: #f4b400;
      --google-yellow-700: #f09300;

      --google-grey-100: #f5f5f5;
      --google-grey-300: #e0e0e0;
      --google-grey-500: #9e9e9e;
      --google-grey-700: #616161;

      /* Material Design color palette from online spec document */

      --paper-red-50: #ffebee;
      --paper-red-100: #ffcdd2;
      --paper-red-200: #ef9a9a;
      --paper-red-300: #e57373;
      --paper-red-400: #ef5350;
      --paper-red-500: #f44336;
      --paper-red-600: #e53935;
      --paper-red-700: #d32f2f;
      --paper-red-800: #c62828;
      --paper-red-900: #b71c1c;
      --paper-red-a100: #ff8a80;
      --paper-red-a200: #ff5252;
      --paper-red-a400: #ff1744;
      --paper-red-a700: #d50000;

      --paper-pink-50: #fce4ec;
      --paper-pink-100: #f8bbd0;
      --paper-pink-200: #f48fb1;
      --paper-pink-300: #f06292;
      --paper-pink-400: #ec407a;
      --paper-pink-500: #e91e63;
      --paper-pink-600: #d81b60;
      --paper-pink-700: #c2185b;
      --paper-pink-800: #ad1457;
      --paper-pink-900: #880e4f;
      --paper-pink-a100: #ff80ab;
      --paper-pink-a200: #ff4081;
      --paper-pink-a400: #f50057;
      --paper-pink-a700: #c51162;

      --paper-purple-50: #f3e5f5;
      --paper-purple-100: #e1bee7;
      --paper-purple-200: #ce93d8;
      --paper-purple-300: #ba68c8;
      --paper-purple-400: #ab47bc;
      --paper-purple-500: #9c27b0;
      --paper-purple-600: #8e24aa;
      --paper-purple-700: #7b1fa2;
      --paper-purple-800: #6a1b9a;
      --paper-purple-900: #4a148c;
      --paper-purple-a100: #ea80fc;
      --paper-purple-a200: #e040fb;
      --paper-purple-a400: #d500f9;
      --paper-purple-a700: #aa00ff;

      --paper-deep-purple-50: #ede7f6;
      --paper-deep-purple-100: #d1c4e9;
      --paper-deep-purple-200: #b39ddb;
      --paper-deep-purple-300: #9575cd;
      --paper-deep-purple-400: #7e57c2;
      --paper-deep-purple-500: #673ab7;
      --paper-deep-purple-600: #5e35b1;
      --paper-deep-purple-700: #512da8;
      --paper-deep-purple-800: #4527a0;
      --paper-deep-purple-900: #311b92;
      --paper-deep-purple-a100: #b388ff;
      --paper-deep-purple-a200: #7c4dff;
      --paper-deep-purple-a400: #651fff;
      --paper-deep-purple-a700: #6200ea;

      --paper-indigo-50: #e8eaf6;
      --paper-indigo-100: #c5cae9;
      --paper-indigo-200: #9fa8da;
      --paper-indigo-300: #7986cb;
      --paper-indigo-400: #5c6bc0;
      --paper-indigo-500: #3f51b5;
      --paper-indigo-600: #3949ab;
      --paper-indigo-700: #303f9f;
      --paper-indigo-800: #283593;
      --paper-indigo-900: #1a237e;
      --paper-indigo-a100: #8c9eff;
      --paper-indigo-a200: #536dfe;
      --paper-indigo-a400: #3d5afe;
      --paper-indigo-a700: #304ffe;

      --paper-blue-50: #e3f2fd;
      --paper-blue-100: #bbdefb;
      --paper-blue-200: #90caf9;
      --paper-blue-300: #64b5f6;
      --paper-blue-400: #42a5f5;
      --paper-blue-500: #2196f3;
      --paper-blue-600: #1e88e5;
      --paper-blue-700: #1976d2;
      --paper-blue-800: #1565c0;
      --paper-blue-900: #0d47a1;
      --paper-blue-a100: #82b1ff;
      --paper-blue-a200: #448aff;
      --paper-blue-a400: #2979ff;
      --paper-blue-a700: #2962ff;

      --paper-light-blue-50: #e1f5fe;
      --paper-light-blue-100: #b3e5fc;
      --paper-light-blue-200: #81d4fa;
      --paper-light-blue-300: #4fc3f7;
      --paper-light-blue-400: #29b6f6;
      --paper-light-blue-500: #03a9f4;
      --paper-light-blue-600: #039be5;
      --paper-light-blue-700: #0288d1;
      --paper-light-blue-800: #0277bd;
      --paper-light-blue-900: #01579b;
      --paper-light-blue-a100: #80d8ff;
      --paper-light-blue-a200: #40c4ff;
      --paper-light-blue-a400: #00b0ff;
      --paper-light-blue-a700: #0091ea;

      --paper-cyan-50: #e0f7fa;
      --paper-cyan-100: #b2ebf2;
      --paper-cyan-200: #80deea;
      --paper-cyan-300: #4dd0e1;
      --paper-cyan-400: #26c6da;
      --paper-cyan-500: #00bcd4;
      --paper-cyan-600: #00acc1;
      --paper-cyan-700: #0097a7;
      --paper-cyan-800: #00838f;
      --paper-cyan-900: #006064;
      --paper-cyan-a100: #84ffff;
      --paper-cyan-a200: #18ffff;
      --paper-cyan-a400: #00e5ff;
      --paper-cyan-a700: #00b8d4;

      --paper-teal-50: #e0f2f1;
      --paper-teal-100: #b2dfdb;
      --paper-teal-200: #80cbc4;
      --paper-teal-300: #4db6ac;
      --paper-teal-400: #26a69a;
      --paper-teal-500: #009688;
      --paper-teal-600: #00897b;
      --paper-teal-700: #00796b;
      --paper-teal-800: #00695c;
      --paper-teal-900: #004d40;
      --paper-teal-a100: #a7ffeb;
      --paper-teal-a200: #64ffda;
      --paper-teal-a400: #1de9b6;
      --paper-teal-a700: #00bfa5;

      --paper-green-50: #e8f5e9;
      --paper-green-100: #c8e6c9;
      --paper-green-200: #a5d6a7;
      --paper-green-300: #81c784;
      --paper-green-400: #66bb6a;
      --paper-green-500: #4caf50;
      --paper-green-600: #43a047;
      --paper-green-700: #388e3c;
      --paper-green-800: #2e7d32;
      --paper-green-900: #1b5e20;
      --paper-green-a100: #b9f6ca;
      --paper-green-a200: #69f0ae;
      --paper-green-a400: #00e676;
      --paper-green-a700: #00c853;

      --paper-light-green-50: #f1f8e9;
      --paper-light-green-100: #dcedc8;
      --paper-light-green-200: #c5e1a5;
      --paper-light-green-300: #aed581;
      --paper-light-green-400: #9ccc65;
      --paper-light-green-500: #8bc34a;
      --paper-light-green-600: #7cb342;
      --paper-light-green-700: #689f38;
      --paper-light-green-800: #558b2f;
      --paper-light-green-900: #33691e;
      --paper-light-green-a100: #ccff90;
      --paper-light-green-a200: #b2ff59;
      --paper-light-green-a400: #76ff03;
      --paper-light-green-a700: #64dd17;

      --paper-lime-50: #f9fbe7;
      --paper-lime-100: #f0f4c3;
      --paper-lime-200: #e6ee9c;
      --paper-lime-300: #dce775;
      --paper-lime-400: #d4e157;
      --paper-lime-500: #cddc39;
      --paper-lime-600: #c0ca33;
      --paper-lime-700: #afb42b;
      --paper-lime-800: #9e9d24;
      --paper-lime-900: #827717;
      --paper-lime-a100: #f4ff81;
      --paper-lime-a200: #eeff41;
      --paper-lime-a400: #c6ff00;
      --paper-lime-a700: #aeea00;

      --paper-yellow-50: #fffde7;
      --paper-yellow-100: #fff9c4;
      --paper-yellow-200: #fff59d;
      --paper-yellow-300: #fff176;
      --paper-yellow-400: #ffee58;
      --paper-yellow-500: #ffeb3b;
      --paper-yellow-600: #fdd835;
      --paper-yellow-700: #fbc02d;
      --paper-yellow-800: #f9a825;
      --paper-yellow-900: #f57f17;
      --paper-yellow-a100: #ffff8d;
      --paper-yellow-a200: #ffff00;
      --paper-yellow-a400: #ffea00;
      --paper-yellow-a700: #ffd600;

      --paper-amber-50: #fff8e1;
      --paper-amber-100: #ffecb3;
      --paper-amber-200: #ffe082;
      --paper-amber-300: #ffd54f;
      --paper-amber-400: #ffca28;
      --paper-amber-500: #ffc107;
      --paper-amber-600: #ffb300;
      --paper-amber-700: #ffa000;
      --paper-amber-800: #ff8f00;
      --paper-amber-900: #ff6f00;
      --paper-amber-a100: #ffe57f;
      --paper-amber-a200: #ffd740;
      --paper-amber-a400: #ffc400;
      --paper-amber-a700: #ffab00;

      --paper-orange-50: #fff3e0;
      --paper-orange-100: #ffe0b2;
      --paper-orange-200: #ffcc80;
      --paper-orange-300: #ffb74d;
      --paper-orange-400: #ffa726;
      --paper-orange-500: #ff9800;
      --paper-orange-600: #fb8c00;
      --paper-orange-700: #f57c00;
      --paper-orange-800: #ef6c00;
      --paper-orange-900: #e65100;
      --paper-orange-a100: #ffd180;
      --paper-orange-a200: #ffab40;
      --paper-orange-a400: #ff9100;
      --paper-orange-a700: #ff6500;

      --paper-deep-orange-50: #fbe9e7;
      --paper-deep-orange-100: #ffccbc;
      --paper-deep-orange-200: #ffab91;
      --paper-deep-orange-300: #ff8a65;
      --paper-deep-orange-400: #ff7043;
      --paper-deep-orange-500: #ff5722;
      --paper-deep-orange-600: #f4511e;
      --paper-deep-orange-700: #e64a19;
      --paper-deep-orange-800: #d84315;
      --paper-deep-orange-900: #bf360c;
      --paper-deep-orange-a100: #ff9e80;
      --paper-deep-orange-a200: #ff6e40;
      --paper-deep-orange-a400: #ff3d00;
      --paper-deep-orange-a700: #dd2c00;

      --paper-brown-50: #efebe9;
      --paper-brown-100: #d7ccc8;
      --paper-brown-200: #bcaaa4;
      --paper-brown-300: #a1887f;
      --paper-brown-400: #8d6e63;
      --paper-brown-500: #795548;
      --paper-brown-600: #6d4c41;
      --paper-brown-700: #5d4037;
      --paper-brown-800: #4e342e;
      --paper-brown-900: #3e2723;

      --paper-grey-50: #fafafa;
      --paper-grey-100: #f5f5f5;
      --paper-grey-200: #eeeeee;
      --paper-grey-300: #e0e0e0;
      --paper-grey-400: #bdbdbd;
      --paper-grey-500: #9e9e9e;
      --paper-grey-600: #757575;
      --paper-grey-700: #616161;
      --paper-grey-800: #424242;
      --paper-grey-900: #212121;

      --paper-blue-grey-50: #eceff1;
      --paper-blue-grey-100: #cfd8dc;
      --paper-blue-grey-200: #b0bec5;
      --paper-blue-grey-300: #90a4ae;
      --paper-blue-grey-400: #78909c;
      --paper-blue-grey-500: #607d8b;
      --paper-blue-grey-600: #546e7a;
      --paper-blue-grey-700: #455a64;
      --paper-blue-grey-800: #37474f;
      --paper-blue-grey-900: #263238;

      /* opacity for dark text on a light background */
      --dark-divider-opacity: 0.12;
      --dark-disabled-opacity: 0.38; /* or hint text or icon */
      --dark-secondary-opacity: 0.54;
      --dark-primary-opacity: 0.87;

      /* opacity for light text on a dark background */
      --light-divider-opacity: 0.12;
      --light-disabled-opacity: 0.3; /* or hint text or icon */
      --light-secondary-opacity: 0.7;
      --light-primary-opacity: 1.0;

    }

  </style>
</custom-style>
`;na.setAttribute("style","display: none;"),document.head.appendChild(na.content);
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const ia=_e`
<custom-style>
  <style is="custom-style">
    html {
      /*
       * You can use these generic variables in your elements for easy theming.
       * For example, if all your elements use \`--primary-text-color\` as its main
       * color, then switching from a light to a dark theme is just a matter of
       * changing the value of \`--primary-text-color\` in your application.
       */
      --primary-text-color: var(--light-theme-text-color);
      --primary-background-color: var(--light-theme-background-color);
      --secondary-text-color: var(--light-theme-secondary-color);
      --disabled-text-color: var(--light-theme-disabled-color);
      --divider-color: var(--light-theme-divider-color);
      --error-color: var(--paper-deep-orange-a700);

      /*
       * Primary and accent colors. Also see color.js for more colors.
       */
      --primary-color: var(--paper-indigo-500);
      --light-primary-color: var(--paper-indigo-100);
      --dark-primary-color: var(--paper-indigo-700);

      --accent-color: var(--paper-pink-a200);
      --light-accent-color: var(--paper-pink-a100);
      --dark-accent-color: var(--paper-pink-a400);


      /*
       * Material Design Light background theme
       */
      --light-theme-background-color: #ffffff;
      --light-theme-base-color: #000000;
      --light-theme-text-color: var(--paper-grey-900);
      --light-theme-secondary-color: #737373;  /* for secondary text and icons */
      --light-theme-disabled-color: #9b9b9b;  /* disabled/hint text */
      --light-theme-divider-color: #dbdbdb;

      /*
       * Material Design Dark background theme
       */
      --dark-theme-background-color: var(--paper-grey-900);
      --dark-theme-base-color: #ffffff;
      --dark-theme-text-color: #ffffff;
      --dark-theme-secondary-color: #bcbcbc;  /* for secondary text and icons */
      --dark-theme-disabled-color: #646464;  /* disabled/hint text */
      --dark-theme-divider-color: #3c3c3c;

      /*
       * Deprecated values because of their confusing names.
       */
      --text-primary-color: var(--dark-theme-text-color);
      --default-primary-color: var(--primary-color);
    }
  </style>
</custom-style>`;ia.setAttribute("style","display: none;"),document.head.appendChild(ia.content);
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const ra={properties:{name:{type:String},value:{notify:!0,type:String},required:{type:Boolean,value:!1}},attached:function(){},detached:function(){}};
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */let oa=null;const aa={properties:{validator:{type:String},invalid:{notify:!0,reflectToAttribute:!0,type:Boolean,value:!1,observer:"_invalidChanged"}},registered:function(){oa=new xo({type:"validator"})},_invalidChanged:function(){this.invalid?this.setAttribute("aria-invalid","true"):this.removeAttribute("aria-invalid")},get _validator(){return oa&&oa.byKey(this.validator)},hasValidator:function(){return null!=this._validator},validate:function(t){return this.invalid=void 0===t&&void 0!==this.value?!this._getValidity(this.value):!this._getValidity(t),!this.invalid},_getValidity:function(t){return!this.hasValidator()||this._validator.validate(t)}},sa={properties:{checked:{type:Boolean,value:!1,reflectToAttribute:!0,notify:!0,observer:"_checkedChanged"},toggles:{type:Boolean,value:!0,reflectToAttribute:!0},value:{type:String,value:"on",observer:"_valueChanged"}},observers:["_requiredChanged(required)"],created:function(){this._hasIronCheckedElementBehavior=!0},_getValidity:function(t){return this.disabled||!this.required||this.checked},_requiredChanged:function(){this.required?this.setAttribute("aria-required","true"):this.removeAttribute("aria-required")},_checkedChanged:function(){this.active=this.checked,this.fire("iron-change")},_valueChanged:function(){null==this.value&&(this.value="on")}},la={observers:["_focusedChanged(receivedFocusFromKeyboard)"],_focusedChanged:function(t){t&&this.ensureRipple(),this.hasRipple()&&(this._ripple.holdDown=t)},_createRipple:function(){var t=Jo._createRipple();return t.id="ink",t.setAttribute("center",""),t.classList.add("circle"),t}},ca=[Xo,qo,Jo,la],ua=[ca,[ra,aa,sa],{_checkedChanged:function(){sa._checkedChanged.call(this),this.hasRipple()&&(this.checked?this._ripple.setAttribute("checked",""):this._ripple.removeAttribute("checked"))},_buttonStateChanged:function(){Jo._buttonStateChanged.call(this),this.disabled||this.isAttached&&(this.checked=this.active)}}],ha=_e`<style>
  :host {
    display: inline-block;
    white-space: nowrap;
    cursor: pointer;
    --calculated-paper-checkbox-size: var(--paper-checkbox-size, 18px);
    /* -1px is a sentinel for the default and is replaced in \`attached\`. */
    --calculated-paper-checkbox-ink-size: var(--paper-checkbox-ink-size, -1px);
    @apply --paper-font-common-base;
    line-height: 0;
    -webkit-tap-highlight-color: transparent;
  }

  :host([hidden]) {
    display: none !important;
  }

  :host(:focus) {
    outline: none;
  }

  .hidden {
    display: none;
  }

  #checkboxContainer {
    display: inline-block;
    position: relative;
    width: var(--calculated-paper-checkbox-size);
    height: var(--calculated-paper-checkbox-size);
    min-width: var(--calculated-paper-checkbox-size);
    margin: var(--paper-checkbox-margin, initial);
    vertical-align: var(--paper-checkbox-vertical-align, middle);
    background-color: var(--paper-checkbox-unchecked-background-color, transparent);
  }

  #ink {
    position: absolute;

    /* Center the ripple in the checkbox by negative offsetting it by
     * (inkWidth - rippleWidth) / 2 */
    top: calc(0px - (var(--calculated-paper-checkbox-ink-size) - var(--calculated-paper-checkbox-size)) / 2);
    left: calc(0px - (var(--calculated-paper-checkbox-ink-size) - var(--calculated-paper-checkbox-size)) / 2);
    width: var(--calculated-paper-checkbox-ink-size);
    height: var(--calculated-paper-checkbox-ink-size);
    color: var(--paper-checkbox-unchecked-ink-color, var(--primary-text-color));
    opacity: 0.6;
    pointer-events: none;
  }

  #ink:dir(rtl) {
    right: calc(0px - (var(--calculated-paper-checkbox-ink-size) - var(--calculated-paper-checkbox-size)) / 2);
    left: auto;
  }

  #ink[checked] {
    color: var(--paper-checkbox-checked-ink-color, var(--primary-color));
  }

  #checkbox {
    position: relative;
    box-sizing: border-box;
    height: 100%;
    border: solid 2px;
    border-color: var(--paper-checkbox-unchecked-color, var(--primary-text-color));
    border-radius: 2px;
    pointer-events: none;
    -webkit-transition: background-color 140ms, border-color 140ms;
    transition: background-color 140ms, border-color 140ms;

    -webkit-transition-duration: var(--paper-checkbox-animation-duration, 140ms);
    transition-duration: var(--paper-checkbox-animation-duration, 140ms);
  }

  /* checkbox checked animations */
  #checkbox.checked #checkmark {
    -webkit-animation: checkmark-expand 140ms ease-out forwards;
    animation: checkmark-expand 140ms ease-out forwards;

    -webkit-animation-duration: var(--paper-checkbox-animation-duration, 140ms);
    animation-duration: var(--paper-checkbox-animation-duration, 140ms);
  }

  @-webkit-keyframes checkmark-expand {
    0% {
      -webkit-transform: scale(0, 0) rotate(45deg);
    }
    100% {
      -webkit-transform: scale(1, 1) rotate(45deg);
    }
  }

  @keyframes checkmark-expand {
    0% {
      transform: scale(0, 0) rotate(45deg);
    }
    100% {
      transform: scale(1, 1) rotate(45deg);
    }
  }

  #checkbox.checked {
    background-color: var(--paper-checkbox-checked-color, var(--primary-color));
    border-color: var(--paper-checkbox-checked-color, var(--primary-color));
  }

  #checkmark {
    position: absolute;
    width: 36%;
    height: 70%;
    border-style: solid;
    border-top: none;
    border-left: none;
    border-right-width: calc(2/15 * var(--calculated-paper-checkbox-size));
    border-bottom-width: calc(2/15 * var(--calculated-paper-checkbox-size));
    border-color: var(--paper-checkbox-checkmark-color, white);
    -webkit-transform-origin: 97% 86%;
    transform-origin: 97% 86%;
    box-sizing: content-box; /* protect against page-level box-sizing */
  }

  #checkmark:dir(rtl) {
    -webkit-transform-origin: 50% 14%;
    transform-origin: 50% 14%;
  }

  /* label */
  #checkboxLabel {
    position: relative;
    display: inline-block;
    vertical-align: middle;
    padding-left: var(--paper-checkbox-label-spacing, 8px);
    white-space: normal;
    line-height: normal;
    color: var(--paper-checkbox-label-color, var(--primary-text-color));
    @apply --paper-checkbox-label;
  }

  :host([checked]) #checkboxLabel {
    color: var(--paper-checkbox-label-checked-color, var(--paper-checkbox-label-color, var(--primary-text-color)));
    @apply --paper-checkbox-label-checked;
  }

  #checkboxLabel:dir(rtl) {
    padding-right: var(--paper-checkbox-label-spacing, 8px);
    padding-left: 0;
  }

  #checkboxLabel[hidden] {
    display: none;
  }

  /* disabled state */

  :host([disabled]) #checkbox {
    opacity: 0.5;
    border-color: var(--paper-checkbox-unchecked-color, var(--primary-text-color));
  }

  :host([disabled][checked]) #checkbox {
    background-color: var(--paper-checkbox-unchecked-color, var(--primary-text-color));
    opacity: 0.5;
  }

  :host([disabled]) #checkboxLabel  {
    opacity: 0.65;
  }

  /* invalid state */
  #checkbox.invalid:not(.checked) {
    border-color: var(--paper-checkbox-error-color, var(--error-color));
  }
</style>

<div id="checkboxContainer">
  <div id="checkbox" class$="[[_computeCheckboxClass(checked, invalid)]]">
    <div id="checkmark" class$="[[_computeCheckmarkClass(checked)]]"></div>
  </div>
</div>

<div id="checkboxLabel"><slot></slot></div>`;
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
let da;ha.setAttribute("strip-whitespace",""),Rr({_template:ha,is:"paper-checkbox",behaviors:[ua],hostAttributes:{role:"checkbox","aria-checked":!1,tabindex:0},properties:{ariaActiveAttribute:{type:String,value:"aria-checked"}},attached:function(){Li(this,(function(){if("-1px"===this.getComputedStyleValue("--calculated-paper-checkbox-ink-size").trim()){var t=this.getComputedStyleValue("--calculated-paper-checkbox-size").trim(),e="px",n=t.match(/[A-Za-z]+$/);null!==n&&(e=n[0]);var i=parseFloat(t),r=8/3*i;"px"===e&&(r=Math.floor(r))%2!=i%2&&r++,this.updateStyles({"--paper-checkbox-ink-size":r+e})}}))},_computeCheckboxClass:function(t,e){var n="";return t&&(n+="checked "),e&&(n+="invalid"),n},_computeCheckmarkClass:function(t){return t?"":"hidden"},_createRipple:function(){return this._rippleContainer=this.$.checkboxContainer,la._createRipple.call(this)}});const pa={properties:{sizingTarget:{type:Object,value:function(){return this}},fitInto:{type:Object,value:window},noOverlap:{type:Boolean},positionTarget:{type:Element},horizontalAlign:{type:String},verticalAlign:{type:String},dynamicAlign:{type:Boolean},horizontalOffset:{type:Number,value:0,notify:!0},verticalOffset:{type:Number,value:0,notify:!0},autoFitOnAttach:{type:Boolean,value:!1},expandSizingTargetForScrollbars:{type:Boolean,value:!1},_fitInfo:{type:Object}},get _fitWidth(){return this.fitInto===window?this.fitInto.innerWidth:this.fitInto.getBoundingClientRect().width},get _fitHeight(){return this.fitInto===window?this.fitInto.innerHeight:this.fitInto.getBoundingClientRect().height},get _fitLeft(){return this.fitInto===window?0:this.fitInto.getBoundingClientRect().left},get _fitTop(){return this.fitInto===window?0:this.fitInto.getBoundingClientRect().top},get _defaultPositionTarget(){var t=Yi(this).parentNode;return t&&t.nodeType===Node.DOCUMENT_FRAGMENT_NODE&&(t=t.host),t},get _localeHorizontalAlign(){if(this._isRTL){if("right"===this.horizontalAlign)return"left";if("left"===this.horizontalAlign)return"right"}return this.horizontalAlign},get __shouldPosition(){return(this.horizontalAlign||this.verticalAlign)&&this.positionTarget},get _isRTL(){return void 0===this._memoizedIsRTL&&(this._memoizedIsRTL="rtl"==window.getComputedStyle(this).direction),this._memoizedIsRTL},attached:function(){this.positionTarget=this.positionTarget||this._defaultPositionTarget,this.autoFitOnAttach&&("none"===window.getComputedStyle(this).display?setTimeout(function(){this.fit()}.bind(this)):(window.ShadyDOM&&ShadyDOM.flush(),this.fit()))},detached:function(){this.__deferredFit&&(clearTimeout(this.__deferredFit),this.__deferredFit=null)},fit:function(){this.position(),this.constrain(),this.center()},_discoverInfo:function(){if(!this._fitInfo){var t=window.getComputedStyle(this),e=window.getComputedStyle(this.sizingTarget);this._fitInfo={inlineStyle:{top:this.style.top||"",left:this.style.left||"",position:this.style.position||""},sizerInlineStyle:{maxWidth:this.sizingTarget.style.maxWidth||"",maxHeight:this.sizingTarget.style.maxHeight||"",boxSizing:this.sizingTarget.style.boxSizing||""},positionedBy:{vertically:"auto"!==t.top?"top":"auto"!==t.bottom?"bottom":null,horizontally:"auto"!==t.left?"left":"auto"!==t.right?"right":null},sizedBy:{height:"none"!==e.maxHeight,width:"none"!==e.maxWidth,minWidth:parseInt(e.minWidth,10)||0,minHeight:parseInt(e.minHeight,10)||0},margin:{top:parseInt(t.marginTop,10)||0,right:parseInt(t.marginRight,10)||0,bottom:parseInt(t.marginBottom,10)||0,left:parseInt(t.marginLeft,10)||0}}}},resetFit:function(){var t=this._fitInfo||{};for(var e in t.sizerInlineStyle)this.sizingTarget.style[e]=t.sizerInlineStyle[e];for(var e in t.inlineStyle)this.style[e]=t.inlineStyle[e];this._fitInfo=null},refit:function(){var t=this.sizingTarget.scrollLeft,e=this.sizingTarget.scrollTop;this.resetFit(),this.fit(),this.sizingTarget.scrollLeft=t,this.sizingTarget.scrollTop=e},position:function(){if(!this.__shouldPosition)return;this._discoverInfo(),window.ShadyDOM&&window.ShadyDOM.flush(),this.style.position="fixed",this.sizingTarget.style.boxSizing="border-box",this.style.left="0px",this.style.top="0px";var t=this.getBoundingClientRect(),e=this.__getNormalizedRect(this.positionTarget),n=this.__getNormalizedRect(this.fitInto);let i,r,o,a;this.expandSizingTargetForScrollbars&&(i=this.sizingTarget.offsetWidth,r=this.sizingTarget.offsetHeight,o=this.sizingTarget.clientWidth,a=this.sizingTarget.clientHeight);var s=this._fitInfo.margin,l=this.__getPosition(this._localeHorizontalAlign,this.verticalAlign,{width:t.width+s.left+s.right,height:t.height+s.top+s.bottom},t,e,n),c=l.left+s.left,u=l.top+s.top,h=Math.min(n.right-s.right,c+t.width),d=Math.min(n.bottom-s.bottom,u+t.height);c=Math.max(n.left+s.left,Math.min(c,h-this._fitInfo.sizedBy.minWidth)),u=Math.max(n.top+s.top,Math.min(u,d-this._fitInfo.sizedBy.minHeight));const p=Math.max(h-c,this._fitInfo.sizedBy.minWidth),f=Math.max(d-u,this._fitInfo.sizedBy.minHeight);this.sizingTarget.style.maxWidth=p+"px",this.sizingTarget.style.maxHeight=f+"px";const m=c-t.left,g=u-t.top;if(this.style.left=`${m}px`,this.style.top=`${g}px`,this.expandSizingTargetForScrollbars){const t=this.sizingTarget.offsetHeight,e=t-this.sizingTarget.clientHeight-(r-a);if(e>0){const i=Math.min(n.height-s.top-s.bottom,f+e);this.sizingTarget.style.maxHeight=`${i}px`;const r=this.sizingTarget.offsetHeight,o=r-t;let a;"top"===l.verticalAlign?a=g:"middle"===l.verticalAlign?a=g-o/2:"bottom"===l.verticalAlign&&(a=g-o),a=Math.max(n.top+s.top,Math.min(a,n.bottom-s.bottom-r)),this.style.top=`${a}px`}const c=this.sizingTarget.offsetWidth,u=c-this.sizingTarget.clientWidth-(i-o);if(u>0){const t=(()=>{if(void 0!==da)return da;const t=document.createElement("div");Object.assign(t.style,{overflow:"auto",position:"fixed",left:"0px",top:"0px",maxWidth:"100px",maxHeight:"100px"});const e=document.createElement("div");return e.style.width="200px",e.style.height="200px",t.appendChild(e),document.body.appendChild(t),da=Math.abs(t.offsetWidth-100)>1?t.offsetWidth-t.clientWidth:0,document.body.removeChild(t),da})(),e=Math.min(n.width-s.left-s.right,p+u-t);this.sizingTarget.style.maxWidth=`${e}px`;const i=this.sizingTarget.offsetWidth+t,r=i-c;let o;"left"===l.horizontalAlign?o=m:"center"===l.horizontalAlign?o=m-r/2:"right"===l.horizontalAlign&&(o=m-r),o=Math.max(n.left+s.left,Math.min(o,n.right-s.right-i)),this.style.left=`${o}px`}}},constrain:function(){if(!this.__shouldPosition){this._discoverInfo();var t=this._fitInfo;t.positionedBy.vertically||(this.style.position="fixed",this.style.top="0px"),t.positionedBy.horizontally||(this.style.position="fixed",this.style.left="0px"),this.sizingTarget.style.boxSizing="border-box";var e=this.getBoundingClientRect();t.sizedBy.height||this.__sizeDimension(e,t.positionedBy.vertically,"top","bottom","Height"),t.sizedBy.width||this.__sizeDimension(e,t.positionedBy.horizontally,"left","right","Width")}},_sizeDimension:function(t,e,n,i,r){this.__sizeDimension(t,e,n,i,r)},__sizeDimension:function(t,e,n,i,r){var o=this._fitInfo,a=this.__getNormalizedRect(this.fitInto),s="Width"===r?a.width:a.height,l=e===i,c="offset"+r;this.sizingTarget.style["max"+r]=s-o.margin[l?n:i]-(l?s-t[i]:t[n])-(this[c]-this.sizingTarget[c])+"px"},center:function(){if(!this.__shouldPosition){this._discoverInfo();var t=this._fitInfo.positionedBy;if(!t.vertically||!t.horizontally){this.style.position="fixed",t.vertically||(this.style.top="0px"),t.horizontally||(this.style.left="0px");var e=this.getBoundingClientRect(),n=this.__getNormalizedRect(this.fitInto);t.vertically||(this.style.top=n.top-e.top+(n.height-e.height)/2+"px"),t.horizontally||(this.style.left=n.left-e.left+(n.width-e.width)/2+"px")}}},__getNormalizedRect:function(t){return t===document.documentElement||t===window?{top:0,left:0,width:window.innerWidth,height:window.innerHeight,right:window.innerWidth,bottom:window.innerHeight}:t.getBoundingClientRect()},__getOffscreenArea:function(t,e,n){var i=Math.min(0,t.top)+Math.min(0,n.bottom-(t.top+e.height)),r=Math.min(0,t.left)+Math.min(0,n.right-(t.left+e.width));return Math.abs(i)*e.width+Math.abs(r)*e.height},__getPosition:function(t,e,n,i,r,o){var a,s=[{verticalAlign:"top",horizontalAlign:"left",top:r.top+this.verticalOffset,left:r.left+this.horizontalOffset},{verticalAlign:"top",horizontalAlign:"right",top:r.top+this.verticalOffset,left:r.right-n.width-this.horizontalOffset},{verticalAlign:"bottom",horizontalAlign:"left",top:r.bottom-n.height-this.verticalOffset,left:r.left+this.horizontalOffset},{verticalAlign:"bottom",horizontalAlign:"right",top:r.bottom-n.height-this.verticalOffset,left:r.right-n.width-this.horizontalOffset}];if(this.noOverlap){for(var l=0,c=s.length;l<c;l++){var u={};for(var h in s[l])u[h]=s[l][h];s.push(u)}s[0].top=s[1].top+=r.height,s[2].top=s[3].top-=r.height,s[4].left=s[6].left+=r.width,s[5].left=s[7].left-=r.width}for(e="auto"===e?null:e,(t="auto"===t?null:t)&&"center"!==t||(s.push({verticalAlign:"top",horizontalAlign:"center",top:r.top+this.verticalOffset+(this.noOverlap?r.height:0),left:r.left-i.width/2+r.width/2+this.horizontalOffset}),s.push({verticalAlign:"bottom",horizontalAlign:"center",top:r.bottom-n.height-this.verticalOffset-(this.noOverlap?r.height:0),left:r.left-i.width/2+r.width/2+this.horizontalOffset})),e&&"middle"!==e||(s.push({verticalAlign:"middle",horizontalAlign:"left",top:r.top-i.height/2+r.height/2+this.verticalOffset,left:r.left+this.horizontalOffset+(this.noOverlap?r.width:0)}),s.push({verticalAlign:"middle",horizontalAlign:"right",top:r.top-i.height/2+r.height/2+this.verticalOffset,left:r.right-n.width-this.horizontalOffset-(this.noOverlap?r.width:0)})),"middle"===e&&"center"===t&&s.push({verticalAlign:"middle",horizontalAlign:"center",top:r.top-i.height/2+r.height/2+this.verticalOffset,left:r.left-i.width/2+r.width/2+this.horizontalOffset}),l=0;l<s.length;l++){var d=s[l],p=d.verticalAlign===e,f=d.horizontalAlign===t;if(!this.dynamicAlign&&!this.noOverlap&&p&&f){a=d;break}var m=(!e||p)&&(!t||f);if(this.dynamicAlign||m){if(d.offscreenArea=this.__getOffscreenArea(d,n,o),0===d.offscreenArea&&m){a=d;break}var g=d.offscreenArea-(a=a||d).offscreenArea;(g<0||0===g&&(p||f))&&(a=d)}}return a}};
/**
    @license
    Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
var fa=Element.prototype,ma=fa.matches||fa.matchesSelector||fa.mozMatchesSelector||fa.msMatchesSelector||fa.oMatchesSelector||fa.webkitMatchesSelector;const ga=new class{getTabbableNodes(t){var e=[];return this._collectTabbableNodes(t,e)?this._sortByTabIndex(e):e}isFocusable(t){return ma.call(t,"input, select, textarea, button, object")?ma.call(t,":not([disabled])"):ma.call(t,"a[href], area[href], iframe, [tabindex], [contentEditable]")}isTabbable(t){return this.isFocusable(t)&&ma.call(t,':not([tabindex="-1"])')&&this._isVisible(t)}_normalizedTabIndex(t){if(this.isFocusable(t)){var e=t.getAttribute("tabindex")||0;return Number(e)}return-1}_collectTabbableNodes(t,e){if(t.nodeType!==Node.ELEMENT_NODE)return!1;var n=t;if(!this._isVisible(n))return!1;var i,r=this._normalizedTabIndex(n),o=r>0;r>=0&&e.push(n),i="content"===n.localName||"slot"===n.localName?Yi(n).getDistributedNodes():Yi(n.root||n).children;for(var a=0;a<i.length;a++)o=this._collectTabbableNodes(i[a],e)||o;return o}_isVisible(t){var e=t.style;return"hidden"!==e.visibility&&"none"!==e.display&&"hidden"!==(e=window.getComputedStyle(t)).visibility&&"none"!==e.display}_sortByTabIndex(t){var e=t.length;if(e<2)return t;var n=Math.ceil(e/2),i=this._sortByTabIndex(t.slice(0,n)),r=this._sortByTabIndex(t.slice(n));return this._mergeSortByTabIndex(i,r)}_mergeSortByTabIndex(t,e){for(var n=[];t.length>0&&e.length>0;)this._hasLowerTabOrder(t[0],e[0])?n.push(e.shift()):n.push(t.shift());return n.concat(t,e)}_hasLowerTabOrder(t,e){var n=Math.max(t.tabIndex,0),i=Math.max(e.tabIndex,0);return 0===n||0===i?i>n:n>i}};
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */Rr({_template:_e`
    <style>
      :host {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: var(--iron-overlay-backdrop-background-color, #000);
        opacity: 0;
        transition: opacity 0.2s;
        pointer-events: none;
        @apply --iron-overlay-backdrop;
      }

      :host(.opened) {
        opacity: var(--iron-overlay-backdrop-opacity, 0.6);
        pointer-events: auto;
        @apply --iron-overlay-backdrop-opened;
      }
    </style>

    <slot></slot>
`,is:"iron-overlay-backdrop",properties:{opened:{reflectToAttribute:!0,type:Boolean,value:!1,observer:"_openedChanged"}},listeners:{transitionend:"_onTransitionend"},created:function(){this.__openedRaf=null},attached:function(){this.opened&&this._openedChanged(this.opened)},prepare:function(){this.opened&&!this.parentNode&&Yi(document.body).appendChild(this)},open:function(){this.opened=!0},close:function(){this.opened=!1},complete:function(){this.opened||this.parentNode!==document.body||Yi(this.parentNode).removeChild(this)},_onTransitionend:function(t){t&&t.target===this&&this.complete()},_openedChanged:function(t){if(t)this.prepare();else{var e=window.getComputedStyle(this);"0s"!==e.transitionDuration&&0!=e.opacity||this.complete()}this.isAttached&&(this.__openedRaf&&(window.cancelAnimationFrame(this.__openedRaf),this.__openedRaf=null),this.scrollTop=this.scrollTop,this.__openedRaf=window.requestAnimationFrame(function(){this.__openedRaf=null,this.toggleClass("opened",this.opened)}.bind(this)))}});const _a=new
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
class{constructor(){this._overlays=[],this._minimumZ=101,this._backdropElement=null,ii(document.documentElement,"tap",(function(){})),document.addEventListener("tap",this._onCaptureClick.bind(this),!0),document.addEventListener("focus",this._onCaptureFocus.bind(this),!0),document.addEventListener("keydown",this._onCaptureKeyDown.bind(this),!0)}get backdropElement(){return this._backdropElement||(this._backdropElement=document.createElement("iron-overlay-backdrop")),this._backdropElement}get deepActiveElement(){var t=document.activeElement;for(t&&t instanceof Element!=0||(t=document.body);t.root&&Yi(t.root).activeElement;)t=Yi(t.root).activeElement;return t}_bringOverlayAtIndexToFront(t){var e=this._overlays[t];if(e){var n=this._overlays.length-1,i=this._overlays[n];if(i&&this._shouldBeBehindOverlay(e,i)&&n--,!(t>=n)){var r=Math.max(this.currentOverlayZ(),this._minimumZ);for(this._getZ(e)<=r&&this._applyOverlayZ(e,r);t<n;)this._overlays[t]=this._overlays[t+1],t++;this._overlays[n]=e}}}addOrRemoveOverlay(t){t.opened?this.addOverlay(t):this.removeOverlay(t)}addOverlay(t){var e=this._overlays.indexOf(t);if(e>=0)return this._bringOverlayAtIndexToFront(e),void this.trackBackdrop();var n=this._overlays.length,i=this._overlays[n-1],r=Math.max(this._getZ(i),this._minimumZ),o=this._getZ(t);i&&this._shouldBeBehindOverlay(t,i)&&(this._applyOverlayZ(i,r),n--,r=Math.max(this._getZ(this._overlays[n-1]),this._minimumZ)),o<=r&&this._applyOverlayZ(t,r),this._overlays.splice(n,0,t),this.trackBackdrop()}removeOverlay(t){var e=this._overlays.indexOf(t);-1!==e&&(this._overlays.splice(e,1),this.trackBackdrop())}currentOverlay(){return this._overlays[this._overlays.length-1]}currentOverlayZ(){return this._getZ(this.currentOverlay())}ensureMinimumZ(t){this._minimumZ=Math.max(this._minimumZ,t)}focusOverlay(){var t=this.currentOverlay();t&&t._applyFocus()}trackBackdrop(){var t=this._overlayWithBackdrop();(t||this._backdropElement)&&(this.backdropElement.style.zIndex=this._getZ(t)-1,this.backdropElement.opened=!!t,this.backdropElement.prepare())}getBackdrops(){for(var t=[],e=0;e<this._overlays.length;e++)this._overlays[e].withBackdrop&&t.push(this._overlays[e]);return t}backdropZ(){return this._getZ(this._overlayWithBackdrop())-1}_overlayWithBackdrop(){for(var t=this._overlays.length-1;t>=0;t--)if(this._overlays[t].withBackdrop)return this._overlays[t]}_getZ(t){var e=this._minimumZ;if(t){var n=Number(t.style.zIndex||window.getComputedStyle(t).zIndex);n==n&&(e=n)}return e}_setZ(t,e){t.style.zIndex=e}_applyOverlayZ(t,e){this._setZ(t,e+2)}_overlayInPath(t){t=t||[];for(var e=0;e<t.length;e++)if(t[e]._manager===this)return t[e]}_onCaptureClick(t){var e=this._overlays.length-1;if(-1!==e)for(var n,i=Yi(t).path;(n=this._overlays[e])&&this._overlayInPath(i)!==n&&(n._onCaptureClick(t),n.allowClickThrough);)e--}_onCaptureFocus(t){var e=this.currentOverlay();e&&e._onCaptureFocus(t)}_onCaptureKeyDown(t){var e=this.currentOverlay();e&&(zo.keyboardEventMatchesKeys(t,"esc")?e._onCaptureEsc(t):zo.keyboardEventMatchesKeys(t,"tab")&&e._onCaptureTab(t))}_shouldBeBehindOverlay(t,e){return!t.alwaysOnTop&&e.alwaysOnTop}};
/**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */var ya,va,ba={pageX:0,pageY:0},xa=null,wa=[],Sa=["wheel","mousewheel","DOMMouseScroll","touchstart","touchmove"];function Ma(t){Ea.indexOf(t)>=0||(0===Ea.length&&(function e(){ya=ya||Ta.bind(void 0);for(var t=0,e=Sa.length;t<e;t++)document.addEventListener(Sa[t],ya,{capture:!0,passive:!1})})(),Ea.push(t),va=Ea[Ea.length-1])}const Ea=[];function Ta(t){if(t.cancelable&&(function e(t){var e=Yi(t).rootTarget;if("touchmove"!==t.type&&xa!==e&&(xa=e,wa=(function n(t){for(var e=[],n=t.indexOf(va),i=0;i<=n;i++)if(t[i].nodeType===Node.ELEMENT_NODE){var r=t[i],o=r.style;"scroll"!==o.overflow&&"auto"!==o.overflow&&(o=window.getComputedStyle(r)),"scroll"!==o.overflow&&"auto"!==o.overflow||e.push(r)}return e})(Yi(t).path)),!wa.length)return!0;if("touchstart"===t.type)return!1;var i=(function r(t){var e={deltaX:t.deltaX,deltaY:t.deltaY};if("deltaX"in t);else if("wheelDeltaX"in t&&"wheelDeltaY"in t)e.deltaX=-t.wheelDeltaX,e.deltaY=-t.wheelDeltaY;else if("wheelDelta"in t)e.deltaX=0,e.deltaY=-t.wheelDelta;else if("axis"in t)e.deltaX=1===t.axis?t.detail:0,e.deltaY=2===t.axis?t.detail:0;else if(t.targetTouches){var n=t.targetTouches[0];e.deltaX=ba.pageX-n.pageX,e.deltaY=ba.pageY-n.pageY}return e}
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */)(t);return!(function o(t,e,n){if(e||n)for(var i=Math.abs(n)>=Math.abs(e),r=0;r<t.length;r++){var o=t[r];if(i?n<0?o.scrollTop>0:o.scrollTop<o.scrollHeight-o.clientHeight:e<0?o.scrollLeft>0:o.scrollLeft<o.scrollWidth-o.clientWidth)return o}})(wa,i.deltaX,i.deltaY)})(t)&&t.preventDefault(),t.targetTouches){var n=t.targetTouches[0];ba.pageX=n.pageX,ba.pageY=n.pageY}}const Ca={properties:{opened:{observer:"_openedChanged",type:Boolean,value:!1,notify:!0},canceled:{observer:"_canceledChanged",readOnly:!0,type:Boolean,value:!1},withBackdrop:{observer:"_withBackdropChanged",type:Boolean},noAutoFocus:{type:Boolean,value:!1},noCancelOnEscKey:{type:Boolean,value:!1},noCancelOnOutsideClick:{type:Boolean,value:!1},closingReason:{type:Object},restoreFocusOnClose:{type:Boolean,value:!1},allowClickThrough:{type:Boolean},alwaysOnTop:{type:Boolean},scrollAction:{type:String},_manager:{type:Object,value:_a},_focusedChild:{type:Object}},listeners:{"iron-resize":"_onIronResize"},observers:["__updateScrollObservers(isAttached, opened, scrollAction)"],get backdropElement(){return this._manager.backdropElement},get _focusNode(){return this._focusedChild||Yi(this).querySelector("[autofocus]")||this},get _focusableNodes(){return ga.getTabbableNodes(this)},ready:function(){this.__isAnimating=!1,this.__shouldRemoveTabIndex=!1,this.__firstFocusableNode=this.__lastFocusableNode=null,this.__rafs={},this.__restoreFocusNode=null,this.__scrollTop=this.__scrollLeft=null,this.__onCaptureScroll=this.__onCaptureScroll.bind(this),this.__rootNodes=null,this._ensureSetup()},attached:function(){this.opened&&this._openedChanged(this.opened),this._observer=Yi(this).observeNodes(this._onNodesChange)},detached:function(){for(var t in this._observer&&Yi(this).unobserveNodes(this._observer),this._observer=null,this.__rafs)null!==this.__rafs[t]&&cancelAnimationFrame(this.__rafs[t]);this.__rafs={},this._manager.removeOverlay(this),this.__isAnimating&&(this.opened?this._finishRenderOpened():(this._applyFocus(),this._finishRenderClosed()))},toggle:function(){this._setCanceled(!1),this.opened=!this.opened},open:function(){this._setCanceled(!1),this.opened=!0},close:function(){this._setCanceled(!1),this.opened=!1},cancel:function(t){this.fire("iron-overlay-canceled",t,{cancelable:!0}).defaultPrevented||(this._setCanceled(!0),this.opened=!1)},invalidateTabbables:function(){this.__firstFocusableNode=this.__lastFocusableNode=null},_ensureSetup:function(){this._overlaySetup||(this._overlaySetup=!0,this.style.outline="none",this.style.display="none")},_openedChanged:function(t){t?this.removeAttribute("aria-hidden"):this.setAttribute("aria-hidden","true"),this.isAttached&&(this.__isAnimating=!0,this.__deraf("__openedChanged",this.__openedChanged))},_canceledChanged:function(){this.closingReason=this.closingReason||{},this.closingReason.canceled=this.canceled},_withBackdropChanged:function(){this.withBackdrop&&!this.hasAttribute("tabindex")?(this.setAttribute("tabindex","-1"),this.__shouldRemoveTabIndex=!0):this.__shouldRemoveTabIndex&&(this.removeAttribute("tabindex"),this.__shouldRemoveTabIndex=!1),this.opened&&this.isAttached&&this._manager.trackBackdrop()},_prepareRenderOpened:function(){this.__restoreFocusNode=this._manager.deepActiveElement,this._preparePositioning(),this.refit(),this._finishPositioning(),this.noAutoFocus&&document.activeElement===this._focusNode&&(this._focusNode.blur(),this.__restoreFocusNode.focus())},_renderOpened:function(){this._finishRenderOpened()},_renderClosed:function(){this._finishRenderClosed()},_finishRenderOpened:function(){this.notifyResize(),this.__isAnimating=!1,this.fire("iron-overlay-opened")},_finishRenderClosed:function(){this.style.display="none",this.style.zIndex="",this.notifyResize(),this.__isAnimating=!1,this.fire("iron-overlay-closed",this.closingReason)},_preparePositioning:function(){this.style.transition=this.style.webkitTransition="none",this.style.transform=this.style.webkitTransform="none",this.style.display=""},_finishPositioning:function(){this.style.display="none",this.scrollTop=this.scrollTop,this.style.transition=this.style.webkitTransition="",this.style.transform=this.style.webkitTransform="",this.style.display="",this.scrollTop=this.scrollTop},_applyFocus:function(){if(this.opened)this.noAutoFocus||this._focusNode.focus();else{if(this.restoreFocusOnClose&&this.__restoreFocusNode){var t=this._manager.deepActiveElement;(t===document.body||Aa(this,t))&&this.__restoreFocusNode.focus()}this.__restoreFocusNode=null,this._focusNode.blur(),this._focusedChild=null}},_onCaptureClick:function(t){this.noCancelOnOutsideClick||this.cancel(t)},_onCaptureFocus:function(t){if(this.withBackdrop){var e=Yi(t).path;-1===e.indexOf(this)?(t.stopPropagation(),this._applyFocus()):this._focusedChild=e[0]}},_onCaptureEsc:function(t){this.noCancelOnEscKey||this.cancel(t)},_onCaptureTab:function(t){if(this.withBackdrop){this.__ensureFirstLastFocusables();var e=t.shiftKey,n=e?this.__firstFocusableNode:this.__lastFocusableNode,i=e?this.__lastFocusableNode:this.__firstFocusableNode,r=!1;if(n===i)r=!0;else{var o=this._manager.deepActiveElement;r=o===n||o===this}r&&(t.preventDefault(),this._focusedChild=i,this._applyFocus())}},_onIronResize:function(){this.opened&&!this.__isAnimating&&this.__deraf("refit",this.refit)},_onNodesChange:function(){this.opened&&!this.__isAnimating&&(this.invalidateTabbables(),this.notifyResize())},__ensureFirstLastFocusables:function(){var t=this._focusableNodes;this.__firstFocusableNode=t[0],this.__lastFocusableNode=t[t.length-1]},__openedChanged:function(){this.opened?(this._prepareRenderOpened(),this._manager.addOverlay(this),this._applyFocus(),this._renderOpened()):(this._manager.removeOverlay(this),this._applyFocus(),this._renderClosed())},__deraf:function(t,e){var n=this.__rafs;null!==n[t]&&cancelAnimationFrame(n[t]),n[t]=requestAnimationFrame(function i(){n[t]=null,e.call(this)}.bind(this))},__updateScrollObservers:function(t,e,n){t&&e&&this.__isValidScrollAction(n)?("lock"===n&&(this.__saveScrollPosition(),Ma(this)),this.__addScrollListeners()):((function i(t){var e=Ea.indexOf(t);-1!==e&&(Ea.splice(e,1),va=Ea[Ea.length-1],0===Ea.length&&(function n(){for(var t=0,e=Sa.length;t<e;t++)document.removeEventListener(Sa[t],ya,{capture:!0,passive:!1})})())})(this),this.__removeScrollListeners())},__addScrollListeners:function(){if(!this.__rootNodes){if(this.__rootNodes=[],m)for(var t=this;t;)t.nodeType===Node.DOCUMENT_FRAGMENT_NODE&&t.host&&this.__rootNodes.push(t),t=t.host||t.assignedSlot||t.parentNode;this.__rootNodes.push(document)}this.__rootNodes.forEach((function(t){t.addEventListener("scroll",this.__onCaptureScroll,{capture:!0,passive:!0})}),this)},__removeScrollListeners:function(){this.__rootNodes&&this.__rootNodes.forEach((function(t){t.removeEventListener("scroll",this.__onCaptureScroll,{capture:!0,passive:!0})}),this),this.isAttached||(this.__rootNodes=null)},__isValidScrollAction:function(t){return"lock"===t||"refit"===t||"cancel"===t},__onCaptureScroll:function(t){if(!(this.__isAnimating||Yi(t).path.indexOf(this)>=0))switch(this.scrollAction){case"lock":this.__restoreScrollPosition();break;case"refit":this.__deraf("refit",this.refit);break;case"cancel":this.cancel(t)}},__saveScrollPosition:function(){document.scrollingElement?(this.__scrollTop=document.scrollingElement.scrollTop,this.__scrollLeft=document.scrollingElement.scrollLeft):(this.__scrollTop=Math.max(document.documentElement.scrollTop,document.body.scrollTop),this.__scrollLeft=Math.max(document.documentElement.scrollLeft,document.body.scrollLeft))},__restoreScrollPosition:function(){document.scrollingElement?(document.scrollingElement.scrollTop=this.__scrollTop,document.scrollingElement.scrollLeft=this.__scrollLeft):(document.documentElement.scrollTop=document.body.scrollTop=this.__scrollTop,document.documentElement.scrollLeft=document.body.scrollLeft=this.__scrollLeft)}},Aa=(t,e)=>{for(let i=e;i;i=(n=i).assignedSlot||n.parentNode||n.host)if(i===t)return!0;var n;return!1},ka=[pa,go,Ca],La={hostAttributes:{role:"dialog",tabindex:"-1"},properties:{modal:{type:Boolean,value:!1},__readied:{type:Boolean,value:!1}},observers:["_modalChanged(modal, __readied)"],listeners:{tap:"_onDialogClick"},ready:function(){this.__prevNoCancelOnOutsideClick=this.noCancelOnOutsideClick,this.__prevNoCancelOnEscKey=this.noCancelOnEscKey,this.__prevWithBackdrop=this.withBackdrop,this.__readied=!0},_modalChanged:function(t,e){e&&(t?(this.__prevNoCancelOnOutsideClick=this.noCancelOnOutsideClick,this.__prevNoCancelOnEscKey=this.noCancelOnEscKey,this.__prevWithBackdrop=this.withBackdrop,this.noCancelOnOutsideClick=!0,this.noCancelOnEscKey=!0,this.withBackdrop=!0):(this.noCancelOnOutsideClick=this.noCancelOnOutsideClick&&this.__prevNoCancelOnOutsideClick,this.noCancelOnEscKey=this.noCancelOnEscKey&&this.__prevNoCancelOnEscKey,this.withBackdrop=this.withBackdrop&&this.__prevWithBackdrop))},_updateClosingReasonConfirmed:function(t){this.closingReason=this.closingReason||{},this.closingReason.confirmed=t},_onDialogClick:function(t){for(var e=Yi(t).path,n=0,i=e.indexOf(this);n<i;n++){var r=e[n];if(r.hasAttribute&&(r.hasAttribute("dialog-dismiss")||r.hasAttribute("dialog-confirm"))){this._updateClosingReasonConfirmed(r.hasAttribute("dialog-confirm")),this.close(),t.stopPropagation();break}}}},Pa=[ka,La];
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
if(
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({_template:_e`
    <style>

      :host {
        display: block;
        @apply --layout-relative;
      }

      :host(.is-scrolled:not(:first-child))::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 1px;
        background: var(--divider-color);
      }

      :host(.can-scroll:not(.scrolled-to-bottom):not(:last-child))::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 1px;
        background: var(--divider-color);
      }

      .scrollable {
        padding: 0 24px;

        @apply --layout-scroll;
        @apply --paper-dialog-scrollable;
      }

      .fit {
        @apply --layout-fit;
      }
    </style>

    <div id="scrollable" class="scrollable" on-scroll="updateScrollState">
      <slot></slot>
    </div>
`,is:"paper-dialog-scrollable",properties:{dialogElement:{type:Object}},get scrollTarget(){return this.$.scrollable},ready:function(){this._ensureTarget(),this.classList.add("no-padding")},attached:function(){this._ensureTarget(),requestAnimationFrame(this.updateScrollState.bind(this))},updateScrollState:function(){this.toggleClass("is-scrolled",this.scrollTarget.scrollTop>0),this.toggleClass("can-scroll",this.scrollTarget.offsetHeight<this.scrollTarget.scrollHeight),this.toggleClass("scrolled-to-bottom",this.scrollTarget.scrollTop+this.scrollTarget.offsetHeight>=this.scrollTarget.scrollHeight)},_ensureTarget:function(){this.dialogElement=this.dialogElement||this.parentElement,this.dialogElement&&this.dialogElement.behaviors&&this.dialogElement.behaviors.indexOf(La)>=0?(this.dialogElement.sizingTarget=this.scrollTarget,this.scrollTarget.classList.remove("fit")):this.dialogElement&&this.scrollTarget.classList.add("fit")}}),!window.polymerSkipLoadingFontRoboto){const t=document.createElement("link");t.rel="stylesheet",t.type="text/css",t.crossOrigin="anonymous",t.href="https://fonts.googleapis.com/css?family=Roboto+Mono:400,700|Roboto:400,300,300italic,400italic,500,500italic,700,700italic",document.head.appendChild(t)}
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */const Na=_e`<custom-style>
  <style is="custom-style">
    html {

      /* Shared Styles */
      --paper-font-common-base: {
        font-family: 'Roboto', 'Noto', sans-serif;
        -webkit-font-smoothing: antialiased;
      };

      --paper-font-common-code: {
        font-family: 'Roboto Mono', 'Consolas', 'Menlo', monospace;
        -webkit-font-smoothing: antialiased;
      };

      --paper-font-common-expensive-kerning: {
        text-rendering: optimizeLegibility;
      };

      --paper-font-common-nowrap: {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
      };

      /* Material Font Styles */

      --paper-font-display4: {
        @apply --paper-font-common-base;
        @apply --paper-font-common-nowrap;

        font-size: 112px;
        font-weight: 300;
        letter-spacing: -.044em;
        line-height: 120px;
      };

      --paper-font-display3: {
        @apply --paper-font-common-base;
        @apply --paper-font-common-nowrap;

        font-size: 56px;
        font-weight: 400;
        letter-spacing: -.026em;
        line-height: 60px;
      };

      --paper-font-display2: {
        @apply --paper-font-common-base;

        font-size: 45px;
        font-weight: 400;
        letter-spacing: -.018em;
        line-height: 48px;
      };

      --paper-font-display1: {
        @apply --paper-font-common-base;

        font-size: 34px;
        font-weight: 400;
        letter-spacing: -.01em;
        line-height: 40px;
      };

      --paper-font-headline: {
        @apply --paper-font-common-base;

        font-size: 24px;
        font-weight: 400;
        letter-spacing: -.012em;
        line-height: 32px;
      };

      --paper-font-title: {
        @apply --paper-font-common-base;
        @apply --paper-font-common-nowrap;

        font-size: 20px;
        font-weight: 500;
        line-height: 28px;
      };

      --paper-font-subhead: {
        @apply --paper-font-common-base;

        font-size: 16px;
        font-weight: 400;
        line-height: 24px;
      };

      --paper-font-body2: {
        @apply --paper-font-common-base;

        font-size: 14px;
        font-weight: 500;
        line-height: 24px;
      };

      --paper-font-body1: {
        @apply --paper-font-common-base;

        font-size: 14px;
        font-weight: 400;
        line-height: 20px;
      };

      --paper-font-caption: {
        @apply --paper-font-common-base;
        @apply --paper-font-common-nowrap;

        font-size: 12px;
        font-weight: 400;
        letter-spacing: 0.011em;
        line-height: 20px;
      };

      --paper-font-menu: {
        @apply --paper-font-common-base;
        @apply --paper-font-common-nowrap;

        font-size: 13px;
        font-weight: 500;
        line-height: 24px;
      };

      --paper-font-button: {
        @apply --paper-font-common-base;
        @apply --paper-font-common-nowrap;

        font-size: 14px;
        font-weight: 500;
        letter-spacing: 0.018em;
        line-height: 24px;
        text-transform: uppercase;
      };

      --paper-font-code2: {
        @apply --paper-font-common-code;

        font-size: 14px;
        font-weight: 700;
        line-height: 20px;
      };

      --paper-font-code1: {
        @apply --paper-font-common-code;

        font-size: 14px;
        font-weight: 500;
        line-height: 20px;
      };

    }

  </style>
</custom-style>`;Na.setAttribute("style","display: none;"),document.head.appendChild(Na.content);
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const Ia=document.createElement("template");Ia.setAttribute("style","display: none;"),Ia.innerHTML='<dom-module id="paper-dialog-shared-styles">\n  <template>\n    <style>\n      :host {\n        display: block;\n        margin: 24px 40px;\n\n        background: var(--paper-dialog-background-color, var(--primary-background-color));\n        color: var(--paper-dialog-color, var(--primary-text-color));\n\n        @apply --paper-font-body1;\n        @apply --shadow-elevation-16dp;\n        @apply --paper-dialog;\n      }\n\n      :host > ::slotted(*) {\n        margin-top: 20px;\n        padding: 0 24px;\n      }\n\n      :host > ::slotted(.no-padding) {\n        padding: 0;\n      }\n\n      \n      :host > ::slotted(*:first-child) {\n        margin-top: 24px;\n      }\n\n      :host > ::slotted(*:last-child) {\n        margin-bottom: 24px;\n      }\n\n      /* In 1.x, this selector was `:host > ::content h2`. In 2.x <slot> allows\n      to select direct children only, which increases the weight of this\n      selector, so we have to re-define first-child/last-child margins below. */\n      :host > ::slotted(h2) {\n        position: relative;\n        margin: 0;\n\n        @apply --paper-font-title;\n        @apply --paper-dialog-title;\n      }\n\n      /* Apply mixin again, in case it sets margin-top. */\n      :host > ::slotted(h2:first-child) {\n        margin-top: 24px;\n        @apply --paper-dialog-title;\n      }\n\n      /* Apply mixin again, in case it sets margin-bottom. */\n      :host > ::slotted(h2:last-child) {\n        margin-bottom: 24px;\n        @apply --paper-dialog-title;\n      }\n\n      :host > ::slotted(.paper-dialog-buttons),\n      :host > ::slotted(.buttons) {\n        position: relative;\n        padding: 8px 8px 8px 24px;\n        margin: 0;\n\n        color: var(--paper-dialog-button-color, var(--primary-color));\n\n        @apply --layout-horizontal;\n        @apply --layout-end-justified;\n      }\n    </style>\n  </template>\n</dom-module>',document.head.appendChild(Ia.content);
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const Ra=[{properties:{animationConfig:{type:Object},entryAnimation:{observer:"_entryAnimationChanged",type:String},exitAnimation:{observer:"_exitAnimationChanged",type:String}},_entryAnimationChanged:function(){this.animationConfig=this.animationConfig||{},this.animationConfig.entry=[{name:this.entryAnimation,node:this}]},_exitAnimationChanged:function(){this.animationConfig=this.animationConfig||{},this.animationConfig.exit=[{name:this.exitAnimation,node:this}]},_copyProperties:function(t,e){for(var n in e)t[n]=e[n]},_cloneConfig:function(t){var e={isClone:!0};return this._copyProperties(e,t),e},_getAnimationConfigRecursive:function(t,e,n){var i;if(this.animationConfig)if(this.animationConfig.value&&"function"==typeof this.animationConfig.value)this._warn(this._logf("playAnimation","Please put 'animationConfig' inside of your components 'properties' object instead of outside of it."));else if(i=t?this.animationConfig[t]:this.animationConfig,Array.isArray(i)||(i=[i]),i)for(var r,o=0;r=i[o];o++)if(r.animatable)r.animatable._getAnimationConfigRecursive(r.type||t,e,n);else if(r.id){var a=e[r.id];a?(a.isClone||(e[r.id]=this._cloneConfig(a),a=e[r.id]),this._copyProperties(a,r)):e[r.id]=r}else n.push(r)},getAnimationConfig:function(t){var e={},n=[];for(var i in this._getAnimationConfigRecursive(t,e,n),e)n.push(e[i]);return n}},{_configureAnimations:function(t){var e=[],n=[];if(t.length>0)for(let e,i=0;e=t[i];i++){let t=document.createElement(e.name);if(t.isNeonAnimation){let i=null;t.configure||(t.configure=function(t){return null}),i=t.configure(e),n.push({result:i,config:e,neonAnimation:t})}else console.warn(this.is+":",e.name,"not found!")}for(var i=0;i<n.length;i++){let t=n[i].result,r=n[i].config,o=n[i].neonAnimation;try{"function"!=typeof t.cancel&&(t=document.timeline.play(t))}catch(e){t=null,console.warn("Couldnt play","(",r.name,").",e)}t&&e.push({neonAnimation:o,config:r,animation:t})}return e},_shouldComplete:function(t){for(var e=!0,n=0;n<t.length;n++)if("finished"!=t[n].animation.playState){e=!1;break}return e},_complete:function(t){for(var e=0;e<t.length;e++)t[e].neonAnimation.complete(t[e].config);for(e=0;e<t.length;e++)t[e].animation.cancel()},playAnimation:function(t,e){var n=this.getAnimationConfig(t);if(n){this._active=this._active||{},this._active[t]&&(this._complete(this._active[t]),delete this._active[t]);var i=this._configureAnimations(n);if(0!=i.length){this._active[t]=i;for(var r=0;r<i.length;r++)i[r].animation.onfinish=function(){this._shouldComplete(i)&&(this._complete(i),delete this._active[t],this.fire("neon-animation-finish",e,{bubbles:!1}))}.bind(this)}else this.fire("neon-animation-finish",e,{bubbles:!1})}},cancelAnimation:function(){for(var t in this._active){var e=this._active[t];for(var n in e)e[n].animation.cancel()}this._active={}}}];
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({_template:_e`
    <style include="paper-dialog-shared-styles"></style>
    <slot></slot>
`,is:"paper-dialog",behaviors:[Pa,Ra],listeners:{"neon-animation-finish":"_onNeonAnimationFinish"},_renderOpened:function(){this.cancelAnimation(),this.playAnimation("entry")},_renderClosed:function(){this.cancelAnimation(),this.playAnimation("exit")},_onNeonAnimationFinish:function(){this.opened?this._finishRenderOpened():this._finishRenderClosed()}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const Oa=Rr({_template:_e`
    <style>
      :host {
        display: inline-block;
        position: fixed;
        clip: rect(0px,0px,0px,0px);
      }
    </style>
    <div aria-live$="[[mode]]">[[_text]]</div>
`,is:"iron-a11y-announcer",properties:{mode:{type:String,value:"polite"},timeout:{type:Number,value:150},_text:{type:String,value:""}},created:function(){Oa.instance||(Oa.instance=this),document.addEventListener("iron-announce",this._onIronAnnounce.bind(this))},announce:function(t){this._text="",this.async((function(){this._text=t}),this.timeout)},_onIronAnnounce:function(t){t.detail&&t.detail.text&&this.announce(t.detail.text)}});Oa.instance=null,Oa.requestAvailability=function(){Oa.instance||(Oa.instance=document.createElement("iron-a11y-announcer")),document.body?document.body.appendChild(Oa.instance):document.addEventListener("load",(function(){document.body.appendChild(Oa.instance)}))},
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({_template:_e`
    <style>
      :host {
        display: inline-block;
      }
    </style>
    <slot id="content"></slot>
`,is:"iron-input",behaviors:[aa],properties:{bindValue:{type:String,value:""},value:{type:String,computed:"_computeValue(bindValue)"},allowedPattern:{type:String},autoValidate:{type:Boolean,value:!1},_inputElement:Object},observers:["_bindValueChanged(bindValue, _inputElement)"],listeners:{input:"_onInput",keypress:"_onKeypress"},created:function(){Oa.requestAvailability(),this._previousValidInput="",this._patternAlreadyChecked=!1},attached:function(){this._observer=Yi(this).observeNodes(function(t){this._initSlottedInput()}.bind(this))},detached:function(){this._observer&&(Yi(this).unobserveNodes(this._observer),this._observer=null)},get inputElement(){return this._inputElement},_initSlottedInput:function(){this._inputElement=this.getEffectiveChildren()[0],this.inputElement&&this.inputElement.value&&(this.bindValue=this.inputElement.value),this.fire("iron-input-ready")},get _patternRegExp(){var t;if(this.allowedPattern)t=new RegExp(this.allowedPattern);else switch(this.inputElement.type){case"number":t=/[0-9.,e-]/}return t},_bindValueChanged:function(t,e){e&&(void 0===t?e.value=null:t!==e.value&&(this.inputElement.value=t),this.autoValidate&&this.validate(),this.fire("bind-value-changed",{value:t}))},_onInput:function(){this.allowedPattern&&!this._patternAlreadyChecked&&(this._checkPatternValidity()||(this._announceInvalidCharacter("Invalid string of characters not entered."),this.inputElement.value=this._previousValidInput)),this.bindValue=this._previousValidInput=this.inputElement.value,this._patternAlreadyChecked=!1},_isPrintable:function(t){return!(8==t.keyCode||9==t.keyCode||13==t.keyCode||27==t.keyCode||0==t.charCode&&(19==t.keyCode||20==t.keyCode||45==t.keyCode||46==t.keyCode||144==t.keyCode||145==t.keyCode||t.keyCode>32&&t.keyCode<41||t.keyCode>111&&t.keyCode<124))},_onKeypress:function(t){if(this.allowedPattern||"number"===this.inputElement.type){var e=this._patternRegExp;if(e&&!(t.metaKey||t.ctrlKey||t.altKey)){this._patternAlreadyChecked=!0;var n=String.fromCharCode(t.charCode);this._isPrintable(t)&&!e.test(n)&&(t.preventDefault(),this._announceInvalidCharacter("Invalid character "+n+" not entered."))}}},_checkPatternValidity:function(){var t=this._patternRegExp;if(!t)return!0;for(var e=0;e<this.inputElement.value.length;e++)if(!t.test(this.inputElement.value[e]))return!1;return!0},validate:function(){if(!this.inputElement)return this.invalid=!1,!0;var t=this.inputElement.checkValidity();return t&&(this.required&&""===this.bindValue?t=!1:this.hasValidator()&&(t=aa.validate.call(this,this.bindValue))),this.invalid=!t,this.fire("iron-input-validate"),t},_announceInvalidCharacter:function(t){this.fire("iron-announce",{text:t})},_computeValue:function(t){return t}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const za={attached:function(){this.fire("addon-attached")},update:function(t){}};
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */Rr({_template:_e`
    <style>
      :host {
        display: inline-block;
        float: right;

        @apply --paper-font-caption;
        @apply --paper-input-char-counter;
      }

      :host([hidden]) {
        display: none !important;
      }

      :host(:dir(rtl)) {
        float: left;
      }
    </style>

    <span>[[_charCounterStr]]</span>
`,is:"paper-input-char-counter",behaviors:[za],properties:{_charCounterStr:{type:String,value:"0"}},update:function(t){if(t.inputElement){t.value=t.value||"";var e=t.value.toString().length.toString();t.inputElement.hasAttribute("maxlength")&&(e+="/"+t.inputElement.getAttribute("maxlength")),this._charCounterStr=e}}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const Da=_e`
<custom-style>
  <style is="custom-style">
    html {
      --paper-input-container-shared-input-style: {
        position: relative; /* to make a stacking context */
        outline: none;
        box-shadow: none;
        padding: 0;
        margin: 0;
        width: 100%;
        max-width: 100%;
        background: transparent;
        border: none;
        color: var(--paper-input-container-input-color, var(--primary-text-color));
        -webkit-appearance: none;
        text-align: inherit;
        vertical-align: var(--paper-input-container-input-align, bottom);

        @apply --paper-font-subhead;
      };
    }
  </style>
</custom-style>
`;Da.setAttribute("style","display: none;"),document.head.appendChild(Da.content),Rr({_template:_e`
    <style>
      :host {
        display: block;
        padding: 8px 0;
        @apply --paper-input-container;
      }

      :host([inline]) {
        display: inline-block;
      }

      :host([disabled]) {
        pointer-events: none;
        opacity: 0.33;

        @apply --paper-input-container-disabled;
      }

      :host([hidden]) {
        display: none !important;
      }

      [hidden] {
        display: none !important;
      }

      .floated-label-placeholder {
        @apply --paper-font-caption;
      }

      .underline {
        height: 2px;
        position: relative;
      }

      .focused-line {
        @apply --layout-fit;
        border-bottom: 2px solid var(--paper-input-container-focus-color, var(--primary-color));

        -webkit-transform-origin: center center;
        transform-origin: center center;
        -webkit-transform: scale3d(0,1,1);
        transform: scale3d(0,1,1);

        @apply --paper-input-container-underline-focus;
      }

      .underline.is-highlighted .focused-line {
        -webkit-transform: none;
        transform: none;
        -webkit-transition: -webkit-transform 0.25s;
        transition: transform 0.25s;

        @apply --paper-transition-easing;
      }

      .underline.is-invalid .focused-line {
        border-color: var(--paper-input-container-invalid-color, var(--error-color));
        -webkit-transform: none;
        transform: none;
        -webkit-transition: -webkit-transform 0.25s;
        transition: transform 0.25s;

        @apply --paper-transition-easing;
      }

      .unfocused-line {
        @apply --layout-fit;
        border-bottom: 1px solid var(--paper-input-container-color, var(--secondary-text-color));
        @apply --paper-input-container-underline;
      }

      :host([disabled]) .unfocused-line {
        border-bottom: 1px dashed;
        border-color: var(--paper-input-container-color, var(--secondary-text-color));
        @apply --paper-input-container-underline-disabled;
      }

      .input-wrapper {
        @apply --layout-horizontal;
        @apply --layout-center;
        position: relative;
      }

      .input-content {
        @apply --layout-flex-auto;
        @apply --layout-relative;
        max-width: 100%;
      }

      .input-content ::slotted(label),
      .input-content ::slotted(.paper-input-label) {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        font: inherit;
        color: var(--paper-input-container-color, var(--secondary-text-color));
        -webkit-transition: -webkit-transform 0.25s, width 0.25s;
        transition: transform 0.25s, width 0.25s;
        -webkit-transform-origin: left top;
        transform-origin: left top;
        /* Fix for safari not focusing 0-height date/time inputs with -webkit-apperance: none; */
        min-height: 1px;

        @apply --paper-font-common-nowrap;
        @apply --paper-font-subhead;
        @apply --paper-input-container-label;
        @apply --paper-transition-easing;
      }


      .input-content ::slotted(label):before,
      .input-content ::slotted(.paper-input-label):before {
        @apply --paper-input-container-label-before;
      }

      .input-content ::slotted(label):after,
      .input-content ::slotted(.paper-input-label):after {
        @apply --paper-input-container-label-after;
      }

      .input-content.label-is-floating ::slotted(label),
      .input-content.label-is-floating ::slotted(.paper-input-label) {
        -webkit-transform: translateY(-75%) scale(0.75);
        transform: translateY(-75%) scale(0.75);

        /* Since we scale to 75/100 of the size, we actually have 100/75 of the
        original space now available */
        width: 133%;

        @apply --paper-input-container-label-floating;
      }

      :host(:dir(rtl)) .input-content.label-is-floating ::slotted(label),
      :host(:dir(rtl)) .input-content.label-is-floating ::slotted(.paper-input-label) {
        right: 0;
        left: auto;
        -webkit-transform-origin: right top;
        transform-origin: right top;
      }

      .input-content.label-is-highlighted ::slotted(label),
      .input-content.label-is-highlighted ::slotted(.paper-input-label) {
        color: var(--paper-input-container-focus-color, var(--primary-color));

        @apply --paper-input-container-label-focus;
      }

      .input-content.is-invalid ::slotted(label),
      .input-content.is-invalid ::slotted(.paper-input-label) {
        color: var(--paper-input-container-invalid-color, var(--error-color));
      }

      .input-content.label-is-hidden ::slotted(label),
      .input-content.label-is-hidden ::slotted(.paper-input-label) {
        visibility: hidden;
      }

      .input-content ::slotted(input),
      .input-content ::slotted(iron-input),
      .input-content ::slotted(textarea),
      .input-content ::slotted(iron-autogrow-textarea),
      .input-content ::slotted(.paper-input-input) {
        @apply --paper-input-container-shared-input-style;
        /* The apply shim doesn't apply the nested color custom property,
          so we have to re-apply it here. */
        color: var(--paper-input-container-input-color, var(--primary-text-color));
        @apply --paper-input-container-input;
      }

      .input-content ::slotted(input)::-webkit-outer-spin-button,
      .input-content ::slotted(input)::-webkit-inner-spin-button {
        @apply --paper-input-container-input-webkit-spinner;
      }

      .input-content.focused ::slotted(input),
      .input-content.focused ::slotted(iron-input),
      .input-content.focused ::slotted(textarea),
      .input-content.focused ::slotted(iron-autogrow-textarea),
      .input-content.focused ::slotted(.paper-input-input) {
        @apply --paper-input-container-input-focus;
      }

      .input-content.is-invalid ::slotted(input),
      .input-content.is-invalid ::slotted(iron-input),
      .input-content.is-invalid ::slotted(textarea),
      .input-content.is-invalid ::slotted(iron-autogrow-textarea),
      .input-content.is-invalid ::slotted(.paper-input-input) {
        @apply --paper-input-container-input-invalid;
      }

      .prefix ::slotted(*) {
        display: inline-block;
        @apply --paper-font-subhead;
        @apply --layout-flex-none;
        @apply --paper-input-prefix;
      }

      .suffix ::slotted(*) {
        display: inline-block;
        @apply --paper-font-subhead;
        @apply --layout-flex-none;

        @apply --paper-input-suffix;
      }

      /* Firefox sets a min-width on the input, which can cause layout issues */
      .input-content ::slotted(input) {
        min-width: 0;
      }

      .input-content ::slotted(textarea) {
        resize: none;
      }

      .add-on-content {
        position: relative;
      }

      .add-on-content.is-invalid ::slotted(*) {
        color: var(--paper-input-container-invalid-color, var(--error-color));
      }

      .add-on-content.is-highlighted ::slotted(*) {
        color: var(--paper-input-container-focus-color, var(--primary-color));
      }
    </style>

    <div class="floated-label-placeholder" aria-hidden="true" hidden="[[noLabelFloat]]">&nbsp;</div>

    <div class="input-wrapper">
      <span class="prefix"><slot name="prefix"></slot></span>

      <div class$="[[_computeInputContentClass(noLabelFloat,alwaysFloatLabel,focused,invalid,_inputHasContent)]]" id="labelAndInputContainer">
        <slot name="label"></slot>
        <slot name="input"></slot>
      </div>

      <span class="suffix"><slot name="suffix"></slot></span>
    </div>

    <div class$="[[_computeUnderlineClass(focused,invalid)]]">
      <div class="unfocused-line"></div>
      <div class="focused-line"></div>
    </div>

    <div class$="[[_computeAddOnContentClass(focused,invalid)]]">
      <slot name="add-on"></slot>
    </div>
`,is:"paper-input-container",properties:{noLabelFloat:{type:Boolean,value:!1},alwaysFloatLabel:{type:Boolean,value:!1},attrForValue:{type:String,value:"bind-value"},autoValidate:{type:Boolean,value:!1},invalid:{observer:"_invalidChanged",type:Boolean,value:!1},focused:{readOnly:!0,type:Boolean,value:!1,notify:!0},_addons:{type:Array},_inputHasContent:{type:Boolean,value:!1},_inputSelector:{type:String,value:"input,iron-input,textarea,.paper-input-input"},_boundOnFocus:{type:Function,value:function(){return this._onFocus.bind(this)}},_boundOnBlur:{type:Function,value:function(){return this._onBlur.bind(this)}},_boundOnInput:{type:Function,value:function(){return this._onInput.bind(this)}},_boundValueChanged:{type:Function,value:function(){return this._onValueChanged.bind(this)}}},listeners:{"addon-attached":"_onAddonAttached","iron-input-validate":"_onIronInputValidate"},get _valueChangedEvent(){return this.attrForValue+"-changed"},get _propertyForValue(){return st(this.attrForValue)},get _inputElement(){return Yi(this).querySelector(this._inputSelector)},get _inputElementValue(){return this._inputElement[this._propertyForValue]||this._inputElement.value},ready:function(){this.__isFirstValueUpdate=!0,this._addons||(this._addons=[]),this.addEventListener("focus",this._boundOnFocus,!0),this.addEventListener("blur",this._boundOnBlur,!0)},attached:function(){this.attrForValue?this._inputElement.addEventListener(this._valueChangedEvent,this._boundValueChanged):this.addEventListener("input",this._onInput),this._inputElementValue&&""!=this._inputElementValue?this._handleValueAndAutoValidate(this._inputElement):this._handleValue(this._inputElement)},_onAddonAttached:function(t){this._addons||(this._addons=[]);var e=t.target;-1===this._addons.indexOf(e)&&(this._addons.push(e),this.isAttached&&this._handleValue(this._inputElement))},_onFocus:function(){this._setFocused(!0)},_onBlur:function(){this._setFocused(!1),this._handleValueAndAutoValidate(this._inputElement)},_onInput:function(t){this._handleValueAndAutoValidate(t.target)},_onValueChanged:function(t){var e=t.target;this.__isFirstValueUpdate&&(this.__isFirstValueUpdate=!1,void 0===e.value||""===e.value)||this._handleValueAndAutoValidate(t.target)},_handleValue:function(t){var e=this._inputElementValue;this._inputHasContent=!(!e&&0!==e&&("number"!==t.type||t.checkValidity())),this.updateAddons({inputElement:t,value:e,invalid:this.invalid})},_handleValueAndAutoValidate:function(t){var e;this.autoValidate&&t&&(e=t.validate?t.validate(this._inputElementValue):t.checkValidity(),this.invalid=!e),this._handleValue(t)},_onIronInputValidate:function(t){this.invalid=this._inputElement.invalid},_invalidChanged:function(){this._addons&&this.updateAddons({invalid:this.invalid})},updateAddons:function(t){for(var e,n=0;e=this._addons[n];n++)e.update(t)},_computeInputContentClass:function(t,e,n,i,r){var o="input-content";if(t)r&&(o+=" label-is-hidden"),i&&(o+=" is-invalid");else{var a=this.querySelector("label");e||r?(o+=" label-is-floating",this.$.labelAndInputContainer.style.position="static",i?o+=" is-invalid":n&&(o+=" label-is-highlighted")):(a&&(this.$.labelAndInputContainer.style.position="relative"),i&&(o+=" is-invalid"))}return n&&(o+=" focused"),o},_computeUnderlineClass:function(t,e){var n="underline";return e?n+=" is-invalid":t&&(n+=" is-highlighted"),n},_computeAddOnContentClass:function(t,e){var n="add-on-content";return e?n+=" is-invalid":t&&(n+=" is-highlighted"),n}}),
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({_template:_e`
    <style>
      :host {
        display: inline-block;
        visibility: hidden;

        color: var(--paper-input-container-invalid-color, var(--error-color));

        @apply --paper-font-caption;
        @apply --paper-input-error;
        position: absolute;
        left:0;
        right:0;
      }

      :host([invalid]) {
        visibility: visible;
      }

      #a11yWrapper {
        visibility: hidden;
      }

      :host([invalid]) #a11yWrapper {
        visibility: visible;
      }
    </style>

    <!--
    If the paper-input-error element is directly referenced by an
    \`aria-describedby\` attribute, such as when used as a paper-input add-on,
    then applying \`visibility: hidden;\` to the paper-input-error element itself
    does not hide the error.

    For more information, see:
    https://www.w3.org/TR/accname-1.1/#mapping_additional_nd_description
    -->
    <div id="a11yWrapper">
      <slot></slot>
    </div>
`,is:"paper-input-error",behaviors:[za],properties:{invalid:{readOnly:!0,reflectToAttribute:!0,type:Boolean}},update:function(t){this._setInvalid(t.invalid)}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const Ba={NextLabelID:1,NextAddonID:1,NextInputID:1},Ha={properties:{label:{type:String},value:{notify:!0,type:String},disabled:{type:Boolean,value:!1},invalid:{type:Boolean,value:!1,notify:!0},allowedPattern:{type:String},type:{type:String},list:{type:String},pattern:{type:String},required:{type:Boolean,value:!1},errorMessage:{type:String},charCounter:{type:Boolean,value:!1},noLabelFloat:{type:Boolean,value:!1},alwaysFloatLabel:{type:Boolean,value:!1},autoValidate:{type:Boolean,value:!1},validator:{type:String},autocomplete:{type:String,value:"off"},autofocus:{type:Boolean,observer:"_autofocusChanged"},inputmode:{type:String},minlength:{type:Number},maxlength:{type:Number},min:{type:String},max:{type:String},step:{type:String},name:{type:String},placeholder:{type:String,value:""},readonly:{type:Boolean,value:!1},size:{type:Number},autocapitalize:{type:String,value:"none"},autocorrect:{type:String,value:"off"},autosave:{type:String},results:{type:Number},accept:{type:String},multiple:{type:Boolean},_ariaDescribedBy:{type:String,value:""},_ariaLabelledBy:{type:String,value:""},_inputId:{type:String,value:""}},listeners:{"addon-attached":"_onAddonAttached"},keyBindings:{"shift+tab:keydown":"_onShiftTabDown"},hostAttributes:{tabindex:0},get inputElement(){return this.$||(this.$={}),this.$.input||(this._generateInputId(),this.$.input=this.$$("#"+this._inputId)),this.$.input},get _focusableElement(){return this.inputElement},created:function(){this._typesThatHaveText=["date","datetime","datetime-local","month","time","week","file"]},attached:function(){this._updateAriaLabelledBy(),!ye&&this.inputElement&&-1!==this._typesThatHaveText.indexOf(this.inputElement.type)&&(this.alwaysFloatLabel=!0)},_appendStringWithSpace:function(t,e){return t?t+" "+e:e},_onAddonAttached:function(t){var e=Yi(t).rootTarget;if(e.id)this._ariaDescribedBy=this._appendStringWithSpace(this._ariaDescribedBy,e.id);else{var n="paper-input-add-on-"+Ba.NextAddonID++;e.id=n,this._ariaDescribedBy=this._appendStringWithSpace(this._ariaDescribedBy,n)}},validate:function(){return this.inputElement.validate()},_focusBlurHandler:function(t){qo._focusBlurHandler.call(this,t),this.focused&&!this._shiftTabPressed&&this._focusableElement&&this._focusableElement.focus()},_onShiftTabDown:function(t){var e=this.getAttribute("tabindex");this._shiftTabPressed=!0,this.setAttribute("tabindex","-1"),this.async((function(){this.setAttribute("tabindex",e),this._shiftTabPressed=!1}),1)},_handleAutoValidate:function(){this.autoValidate&&this.validate()},updateValueAndPreserveCaret:function(t){try{var e=this.inputElement.selectionStart;this.value=t,this.inputElement.selectionStart=e,this.inputElement.selectionEnd=e}catch(e){this.value=t}},_computeAlwaysFloatLabel:function(t,e){return e||t},_updateAriaLabelledBy:function(){var t,e=Yi(this.root).querySelector("label");e?(e.id?t=e.id:(t="paper-input-label-"+Ba.NextLabelID++,e.id=t),this._ariaLabelledBy=t):this._ariaLabelledBy=""},_generateInputId:function(){this._inputId&&""!==this._inputId||(this._inputId="input-"+Ba.NextInputID++)},_onChange:function(t){this.shadowRoot&&this.fire(t.type,{sourceEvent:t},{node:this,bubbles:t.bubbles,cancelable:t.cancelable})},_autofocusChanged:function(){if(this.autofocus&&this._focusableElement){var t=document.activeElement;t instanceof HTMLElement&&t!==document.body&&t!==document.documentElement||this._focusableElement.focus()}}},Fa=[qo,zo,Ha];
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({is:"paper-input",_template:_e`
    <style>
      :host {
        display: block;
      }

      :host([focused]) {
        outline: none;
      }

      :host([hidden]) {
        display: none !important;
      }

      input {
        /* Firefox sets a min-width on the input, which can cause layout issues */
        min-width: 0;
      }

      /* In 1.x, the <input> is distributed to paper-input-container, which styles it.
      In 2.x the <iron-input> is distributed to paper-input-container, which styles
      it, but in order for this to work correctly, we need to reset some
      of the native input's properties to inherit (from the iron-input) */
      iron-input > input {
        @apply --paper-input-container-shared-input-style;
        font-family: inherit;
        font-weight: inherit;
        font-size: inherit;
        letter-spacing: inherit;
        word-spacing: inherit;
        line-height: inherit;
        text-shadow: inherit;
        color: inherit;
        cursor: inherit;
      }

      input:disabled {
        @apply --paper-input-container-input-disabled;
      }

      input::-webkit-outer-spin-button,
      input::-webkit-inner-spin-button {
        @apply --paper-input-container-input-webkit-spinner;
      }

      input::-webkit-clear-button {
        @apply --paper-input-container-input-webkit-clear;
      }

      input::-webkit-calendar-picker-indicator {
        @apply --paper-input-container-input-webkit-calendar-picker-indicator;
      }

      input::-webkit-input-placeholder {
        color: var(--paper-input-container-color, var(--secondary-text-color));
      }

      input:-moz-placeholder {
        color: var(--paper-input-container-color, var(--secondary-text-color));
      }

      input::-moz-placeholder {
        color: var(--paper-input-container-color, var(--secondary-text-color));
      }

      input::-ms-clear {
        @apply --paper-input-container-ms-clear;
      }

      input::-ms-reveal {
        @apply --paper-input-container-ms-reveal;
      }

      input:-ms-input-placeholder {
        color: var(--paper-input-container-color, var(--secondary-text-color));
      }

      label {
        pointer-events: none;
      }
    </style>

    <paper-input-container id="container" no-label-float="[[noLabelFloat]]" always-float-label="[[_computeAlwaysFloatLabel(alwaysFloatLabel,placeholder)]]" auto-validate$="[[autoValidate]]" disabled$="[[disabled]]" invalid="[[invalid]]">

      <slot name="prefix" slot="prefix"></slot>

      <label hidden$="[[!label]]" aria-hidden="true" for$="[[_inputId]]" slot="label">[[label]]</label>

      <!-- Need to bind maxlength so that the paper-input-char-counter works correctly -->
      <iron-input bind-value="{{value}}" slot="input" class="input-element" id$="[[_inputId]]" maxlength$="[[maxlength]]" allowed-pattern="[[allowedPattern]]" invalid="{{invalid}}" validator="[[validator]]">
        <input aria-labelledby$="[[_ariaLabelledBy]]" aria-describedby$="[[_ariaDescribedBy]]" disabled$="[[disabled]]" title$="[[title]]" type$="[[type]]" pattern$="[[pattern]]" required$="[[required]]" autocomplete$="[[autocomplete]]" autofocus$="[[autofocus]]" inputmode$="[[inputmode]]" minlength$="[[minlength]]" maxlength$="[[maxlength]]" min$="[[min]]" max$="[[max]]" step$="[[step]]" name$="[[name]]" placeholder$="[[placeholder]]" readonly$="[[readonly]]" list$="[[list]]" size$="[[size]]" autocapitalize$="[[autocapitalize]]" autocorrect$="[[autocorrect]]" on-change="_onChange" tabindex$="[[tabIndex]]" autosave$="[[autosave]]" results$="[[results]]" accept$="[[accept]]" multiple$="[[multiple]]" role$="[[inputRole]]" aria-haspopup$="[[inputAriaHaspopup]]">
      </iron-input>

      <slot name="suffix" slot="suffix"></slot>

      <template is="dom-if" if="[[errorMessage]]">
        <paper-input-error aria-live="assertive" slot="add-on">[[errorMessage]]</paper-input-error>
      </template>

      <template is="dom-if" if="[[charCounter]]">
        <paper-input-char-counter slot="add-on"></paper-input-char-counter>
      </template>

    </paper-input-container>
  `,behaviors:[Fa,ra],properties:{value:{type:String},inputRole:{type:String,value:void 0},inputAriaHaspopup:{type:String,value:void 0}},get _focusableElement(){return this.inputElement._inputElement},listeners:{"iron-input-ready":"_onIronInputReady"},_onIronInputReady:function(){this.$.nativeInput||(this.$.nativeInput=this.$$("input")),this.inputElement&&-1!==this._typesThatHaveText.indexOf(this.$.nativeInput.type)&&(this.alwaysFloatLabel=!0),this.inputElement.bindValue&&this.$.container._handleValueAndAutoValidate(this.inputElement)}}),
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({_template:_e`
    <style>
      :host {
        position: fixed;
      }

      #contentWrapper ::slotted(*) {
        overflow: auto;
      }

      #contentWrapper.animating ::slotted(*) {
        overflow: hidden;
        pointer-events: none;
      }
    </style>

    <div id="contentWrapper">
      <slot id="content" name="dropdown-content"></slot>
    </div>
`,is:"iron-dropdown",behaviors:[qo,zo,ka,Ra],properties:{horizontalAlign:{type:String,value:"left",reflectToAttribute:!0},verticalAlign:{type:String,value:"top",reflectToAttribute:!0},openAnimationConfig:{type:Object},closeAnimationConfig:{type:Object},focusTarget:{type:Object},noAnimations:{type:Boolean,value:!1},allowOutsideScroll:{type:Boolean,value:!1,observer:"_allowOutsideScrollChanged"}},listeners:{"neon-animation-finish":"_onNeonAnimationFinish"},observers:["_updateOverlayPosition(positionTarget, verticalAlign, horizontalAlign, verticalOffset, horizontalOffset)"],get containedElement(){for(var t=Yi(this.$.content).getDistributedNodes(),e=0,n=t.length;e<n;e++)if(t[e].nodeType===Node.ELEMENT_NODE)return t[e]},ready:function(){this.scrollAction||(this.scrollAction=this.allowOutsideScroll?"refit":"lock"),this._readied=!0},attached:function(){this.sizingTarget&&this.sizingTarget!==this||(this.sizingTarget=this.containedElement||this)},detached:function(){this.cancelAnimation()},_openedChanged:function(){this.opened&&this.disabled?this.cancel():(this.cancelAnimation(),this._updateAnimationConfig(),Ca._openedChanged.apply(this,arguments))},_renderOpened:function(){!this.noAnimations&&this.animationConfig.open?(this.$.contentWrapper.classList.add("animating"),this.playAnimation("open")):Ca._renderOpened.apply(this,arguments)},_renderClosed:function(){!this.noAnimations&&this.animationConfig.close?(this.$.contentWrapper.classList.add("animating"),this.playAnimation("close")):Ca._renderClosed.apply(this,arguments)},_onNeonAnimationFinish:function(){this.$.contentWrapper.classList.remove("animating"),this.opened?this._finishRenderOpened():this._finishRenderClosed()},_updateAnimationConfig:function(){for(var t=this.containedElement,e=[].concat(this.openAnimationConfig||[]).concat(this.closeAnimationConfig||[]),n=0;n<e.length;n++)e[n].node=t;this.animationConfig={open:this.openAnimationConfig,close:this.closeAnimationConfig}},_updateOverlayPosition:function(){this.isAttached&&this.notifyResize()},_allowOutsideScrollChanged:function(t){this._readied&&(t?this.scrollAction&&"lock"!==this.scrollAction||(this.scrollAction="refit"):this.scrollAction="lock")},_applyFocus:function(){var t=this.focusTarget||this.containedElement;t&&this.opened&&!this.noAutoFocus?t.focus():Ca._applyFocus.apply(this,arguments)}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const Va={properties:{animationTiming:{type:Object,value:function(){return{duration:500,easing:"cubic-bezier(0.4, 0, 0.2, 1)",fill:"both"}}}},isNeonAnimation:!0,created:function(){document.body.animate||console.warn("No web animations detected. This element will not function without a web animations polyfill.")},timingFromConfig:function(t){if(t.timing)for(var e in t.timing)this.animationTiming[e]=t.timing[e];return this.animationTiming},setPrefixedProperty:function(t,e,n){for(var i,r={transform:["webkitTransform"],transformOrigin:["mozTransformOrigin","webkitTransformOrigin"]}[e],o=0;i=r[o];o++)t.style[i]=n;t.style[e]=n},complete:function(t){}};
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */Rr({is:"fade-in-animation",behaviors:[Va],configure:function(t){return this._effect=new KeyframeEffect(t.node,[{opacity:"0"},{opacity:"1"}],this.timingFromConfig(t)),this._effect}}),
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({is:"fade-out-animation",behaviors:[Va],configure:function(t){return this._effect=new KeyframeEffect(t.node,[{opacity:"1"},{opacity:"0"}],this.timingFromConfig(t)),this._effect}}),
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({is:"paper-menu-grow-height-animation",_template:null,behaviors:[Va],configure:function(t){var e=t.node,n=e.getBoundingClientRect().height;return this._effect=new KeyframeEffect(e,[{height:n/2+"px"},{height:n+"px"}],this.timingFromConfig(t)),this._effect}}),Rr({is:"paper-menu-grow-width-animation",_template:null,behaviors:[Va],configure:function(t){var e=t.node,n=e.getBoundingClientRect().width;return this._effect=new KeyframeEffect(e,[{width:n/2+"px"},{width:n+"px"}],this.timingFromConfig(t)),this._effect}}),Rr({is:"paper-menu-shrink-width-animation",_template:null,behaviors:[Va],configure:function(t){var e=t.node,n=e.getBoundingClientRect().width;return this._effect=new KeyframeEffect(e,[{width:n+"px"},{width:n-n/20+"px"}],this.timingFromConfig(t)),this._effect}}),Rr({is:"paper-menu-shrink-height-animation",_template:null,behaviors:[Va],configure:function(t){var e=t.node,n=e.getBoundingClientRect().height;return this.setPrefixedProperty(e,"transformOrigin","0 0"),this._effect=new KeyframeEffect(e,[{height:n+"px",transform:"translateY(0)"},{height:n/2+"px",transform:"translateY(-20px)"}],this.timingFromConfig(t)),this._effect}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
var Ua={ANIMATION_CUBIC_BEZIER:"cubic-bezier(.3,.95,.5,1)",MAX_ANIMATION_TIME_MS:400};const ja=Rr({_template:_e`
    <style>
      :host {
        display: inline-block;
        position: relative;
        padding: 8px;
        outline: none;

        @apply --paper-menu-button;
      }

      :host([disabled]) {
        cursor: auto;
        color: var(--disabled-text-color);

        @apply --paper-menu-button-disabled;
      }

      iron-dropdown {
        @apply --paper-menu-button-dropdown;
      }

      .dropdown-content {
        @apply --shadow-elevation-2dp;

        position: relative;
        border-radius: 2px;
        background-color: var(--paper-menu-button-dropdown-background, var(--primary-background-color));

        @apply --paper-menu-button-content;
      }

      :host([vertical-align="top"]) .dropdown-content {
        margin-bottom: 20px;
        margin-top: -10px;
        top: 10px;
      }

      :host([vertical-align="bottom"]) .dropdown-content {
        bottom: 10px;
        margin-bottom: -10px;
        margin-top: 20px;
      }

      #trigger {
        cursor: pointer;
      }
    </style>

    <div id="trigger" on-tap="toggle">
      <slot name="dropdown-trigger"></slot>
    </div>

    <iron-dropdown id="dropdown" opened="{{opened}}" horizontal-align="[[horizontalAlign]]" vertical-align="[[verticalAlign]]" dynamic-align="[[dynamicAlign]]" horizontal-offset="[[horizontalOffset]]" vertical-offset="[[verticalOffset]]" no-overlap="[[noOverlap]]" open-animation-config="[[openAnimationConfig]]" close-animation-config="[[closeAnimationConfig]]" no-animations="[[noAnimations]]" focus-target="[[_dropdownContent]]" allow-outside-scroll="[[allowOutsideScroll]]" restore-focus-on-close="[[restoreFocusOnClose]]" on-iron-overlay-canceled="__onIronOverlayCanceled" expand-sizing-target-for-scrollbars="[[expandSizingTargetForScrollbars]]">
      <div slot="dropdown-content" class="dropdown-content">
        <slot id="content" name="dropdown-content"></slot>
      </div>
    </iron-dropdown>
`,is:"paper-menu-button",behaviors:[zo,qo],properties:{opened:{type:Boolean,value:!1,notify:!0,observer:"_openedChanged"},horizontalAlign:{type:String,value:"left",reflectToAttribute:!0},verticalAlign:{type:String,value:"top",reflectToAttribute:!0},dynamicAlign:{type:Boolean},horizontalOffset:{type:Number,value:0,notify:!0},verticalOffset:{type:Number,value:0,notify:!0},noOverlap:{type:Boolean},noAnimations:{type:Boolean,value:!1},ignoreSelect:{type:Boolean,value:!1},closeOnActivate:{type:Boolean,value:!1},openAnimationConfig:{type:Object,value:function(){return[{name:"fade-in-animation",timing:{delay:100,duration:200}},{name:"paper-menu-grow-width-animation",timing:{delay:100,duration:150,easing:Ua.ANIMATION_CUBIC_BEZIER}},{name:"paper-menu-grow-height-animation",timing:{delay:100,duration:275,easing:Ua.ANIMATION_CUBIC_BEZIER}}]}},closeAnimationConfig:{type:Object,value:function(){return[{name:"fade-out-animation",timing:{duration:150}},{name:"paper-menu-shrink-width-animation",timing:{delay:100,duration:50,easing:Ua.ANIMATION_CUBIC_BEZIER}},{name:"paper-menu-shrink-height-animation",timing:{duration:200,easing:"ease-in"}}]}},allowOutsideScroll:{type:Boolean,value:!1},restoreFocusOnClose:{type:Boolean,value:!0},expandSizingTargetForScrollbars:{type:Boolean,value:!1},_dropdownContent:{type:Object}},hostAttributes:{role:"group","aria-haspopup":"true"},listeners:{"iron-activate":"_onIronActivate","iron-select":"_onIronSelect"},get contentElement(){for(var t=Yi(this.$.content).getDistributedNodes(),e=0,n=t.length;e<n;e++)if(t[e].nodeType===Node.ELEMENT_NODE)return t[e]},toggle:function(){this.opened?this.close():this.open()},open:function(){this.disabled||this.$.dropdown.open()},close:function(){this.$.dropdown.close()},_onIronSelect:function(t){this.ignoreSelect||this.close()},_onIronActivate:function(t){this.closeOnActivate&&this.close()},_openedChanged:function(t,e){t?(this._dropdownContent=this.contentElement,this.fire("paper-dropdown-open")):null!=e&&this.fire("paper-dropdown-close")},_disabledChanged:function(t){qo._disabledChanged.apply(this,arguments),t&&this.opened&&this.close()},__onIronOverlayCanceled:function(t){var e=this.$.trigger;Yi(t.detail).path.indexOf(e)>-1&&t.preventDefault()}});Object.keys(Ua).forEach((function(t){ja[t]=Ua[t]}));
/**
    @license
    Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const Ga=document.createElement("template");Ga.setAttribute("style","display: none;"),Ga.innerHTML='<iron-iconset-svg name="paper-dropdown-menu" size="24">\n<svg><defs>\n<g id="arrow-drop-down"><path d="M7 10l5 5 5-5z"></path></g>\n</defs></svg>\n</iron-iconset-svg>',document.head.appendChild(Ga.content);
/**
    @license
    Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const Wa=document.createElement("template");Wa.setAttribute("style","display: none;"),Wa.innerHTML='<dom-module id="paper-dropdown-menu-shared-styles">\n  <template>\n    <style>\n      :host {\n        display: inline-block;\n        position: relative;\n        text-align: left;\n\n        /* NOTE(cdata): Both values are needed, since some phones require the\n         * value to be `transparent`.\n         */\n        -webkit-tap-highlight-color: rgba(0,0,0,0);\n        -webkit-tap-highlight-color: transparent;\n\n        --paper-input-container-input: {\n          overflow: hidden;\n          white-space: nowrap;\n          text-overflow: ellipsis;\n          max-width: 100%;\n          box-sizing: border-box;\n          cursor: pointer;\n        };\n\n        @apply --paper-dropdown-menu;\n      }\n\n      /* paper-dropdown-menu and paper-dropdown-menu-light both delegate focus\n       * to other internal elements which manage focus styling. */\n      :host(:focus) {\n        outline: none;\n      }\n\n      :host(:dir(rtl)) {\n        text-align: right;\n\n        @apply(--paper-dropdown-menu);\n      }\n\n      :host([disabled]) {\n        @apply --paper-dropdown-menu-disabled;\n      }\n\n      :host([noink]) paper-ripple {\n        display: none;\n      }\n\n      :host([no-label-float]) paper-ripple {\n        top: 8px;\n      }\n\n      paper-ripple {\n        top: 12px;\n        left: 0px;\n        bottom: 8px;\n        right: 0px;\n\n        @apply --paper-dropdown-menu-ripple;\n      }\n\n      paper-menu-button {\n        display: block;\n        padding: 0;\n\n        @apply --paper-dropdown-menu-button;\n      }\n\n      paper-input {\n        @apply --paper-dropdown-menu-input;\n      }\n\n      iron-icon {\n        color: var(--disabled-text-color);\n\n        @apply --paper-dropdown-menu-icon;\n      }\n    </style>\n  </template>\n</dom-module>',document.head.appendChild(Wa.content);
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const qa=er(HTMLElement);Rr({_template:_e`
    <style include="paper-dropdown-menu-shared-styles"></style>

    <paper-menu-button id="menuButton" vertical-align="[[verticalAlign]]" horizontal-align="[[horizontalAlign]]" dynamic-align="[[dynamicAlign]]" vertical-offset="[[_computeMenuVerticalOffset(noLabelFloat, verticalOffset)]]" disabled="[[disabled]]" no-animations="[[noAnimations]]" on-iron-select="_onIronSelect" on-iron-deselect="_onIronDeselect" opened="{{opened}}" close-on-activate allow-outside-scroll="[[allowOutsideScroll]]" restore-focus-on-close="[[restoreFocusOnClose]]" expand-sizing-target-for-scrollbars="[[expandSizingTargetForScrollbars]]">
      <!-- support hybrid mode: user might be using paper-menu-button 1.x which distributes via <content> -->
      <div class="dropdown-trigger" slot="dropdown-trigger">
        <paper-ripple></paper-ripple>
        <!-- paper-input has type="text" for a11y, do not remove -->
        <paper-input id="input" type="text" invalid="[[invalid]]" readonly disabled="[[disabled]]" value="[[value]]" placeholder="[[placeholder]]" error-message="[[errorMessage]]" always-float-label="[[alwaysFloatLabel]]" no-label-float="[[noLabelFloat]]" label="[[label]]" input-role="button" input-aria-haspopup="listbox" autocomplete="off">
          <!-- support hybrid mode: user might be using paper-input 1.x which distributes via <content> -->
          <iron-icon icon="paper-dropdown-menu:arrow-drop-down" suffix slot="suffix"></iron-icon>
        </paper-input>
      </div>
      <slot id="content" name="dropdown-content" slot="dropdown-content"></slot>
    </paper-menu-button>
`,is:"paper-dropdown-menu",behaviors:[Xo,qo,ra,aa],properties:{selectedItemLabel:{type:String,notify:!0,readOnly:!0},selectedItem:{type:Object,notify:!0,readOnly:!0},value:{type:String,notify:!0},label:{type:String},placeholder:{type:String},errorMessage:{type:String},opened:{type:Boolean,notify:!0,value:!1,observer:"_openedChanged"},allowOutsideScroll:{type:Boolean,value:!1},noLabelFloat:{type:Boolean,value:!1,reflectToAttribute:!0},alwaysFloatLabel:{type:Boolean,value:!1},noAnimations:{type:Boolean,value:!1},horizontalAlign:{type:String,value:"right"},verticalAlign:{type:String,value:"top"},verticalOffset:Number,dynamicAlign:{type:Boolean},restoreFocusOnClose:{type:Boolean,value:!0},expandSizingTargetForScrollbars:{type:Boolean,value:!1}},listeners:{tap:"_onTap"},keyBindings:{"up down":"open",esc:"close"},observers:["_selectedItemChanged(selectedItem)"],_attachDom(t){const e=Y(this);return e.attachShadow({mode:"open",delegatesFocus:!0,shadyUpgradeFragment:t}),e.shadowRoot.appendChild(t),qa.prototype._attachDom.call(this,t)},focus(){this.$.input._focusableElement.focus()},attached:function(){var t=this.contentElement;t&&t.selectedItem&&this._setSelectedItem(t.selectedItem)},get contentElement(){for(var t=Yi(this.$.content).getDistributedNodes(),e=0,n=t.length;e<n;e++)if(t[e].nodeType===Node.ELEMENT_NODE)return t[e]},open:function(){this.$.menuButton.open()},close:function(){this.$.menuButton.close()},_onIronSelect:function(t){this._setSelectedItem(t.detail.item)},_onIronDeselect:function(t){this._setSelectedItem(null)},_onTap:function(t){di(t)===this&&this.open()},_selectedItemChanged:function(t){var e;e=t?t.label||t.getAttribute("label")||t.textContent.trim():"",this.value=e,this._setSelectedItemLabel(e)},_computeMenuVerticalOffset:function(t,e){return e||(t?-4:8)},_getValidity:function(t){return this.disabled||!this.required||this.required&&!!this.value},_openedChanged:function(){var t=this.contentElement;t&&t.setAttribute("aria-expanded",this.opened?"true":"false")}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
var Ya={outerScroll:{scroll:!0},shadowMode:{standard:2,waterfall:1,"waterfall-tall":1},tallMode:{"waterfall-tall":!0}};Rr({_template:_e`
    <style>
      :host {
        @apply --layout-vertical;
        position: relative;
        height: 100%;
        @apply --paper-header-panel;
      }

      #mainContainer {
        @apply --layout-flex;
        position: relative;
        overflow-y: auto;
        overflow-x: hidden;
        -webkit-overflow-scrolling: touch;
      }

      #mainPanel {
        @apply --layout-vertical;
        @apply --layout-flex;
        position: relative;
        min-height: 0;
        @apply --paper-header-panel-body;
      }

      #mainContainer {
        @apply --paper-header-panel-container;
      }

      /*
       * mode: scroll
       */
      :host([mode=scroll]) #mainContainer {
        @apply --paper-header-panel-scroll-container;
        overflow: visible;
      }

      :host([mode=scroll]) {
        overflow-y: auto;
        overflow-x: hidden;
        -webkit-overflow-scrolling: touch;
      }

      /*
       * mode: cover
       */
      :host([mode=cover]) #mainContainer {
        @apply --paper-header-panel-cover-container;
        position: absolute;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
      }

      :host([mode=cover]) #mainPanel {
        position: static;
      }

      /*
       * mode: standard
       */
      :host([mode=standard]) #mainContainer {
        @apply --paper-header-panel-standard-container;
      }

      /*
       * mode: seamed
       */
      :host([mode=seamed]) #mainContainer {
        @apply --paper-header-panel-seamed-container;
      }


      /*
       * mode: waterfall
       */
      :host([mode=waterfall]) #mainContainer {
        @apply --paper-header-panel-waterfall-container;
      }

      /*
       * mode: waterfall-tall
       */
      :host([mode=waterfall-tall]) #mainContainer {
        @apply --paper-header-panel-waterfall-tall-container;
      }

      #dropShadow {
        transition: opacity 0.5s;
        height: 6px;
        box-shadow: inset 0px 5px 6px -3px rgba(0, 0, 0, 0.4);
        @apply --paper-header-panel-shadow;
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        opacity: 0;
        pointer-events: none;
      }

      #dropShadow.has-shadow {
        opacity: 1;
      }

      #mainContainer > ::slotted(.fit) {
        @apply --layout-fit;
      }

    </style>

    <slot id="headerSlot" name="header"></slot>

    <div id="mainPanel">
      <div id="mainContainer" class\$="[[_computeMainContainerClass(mode)]]">
        <slot></slot>
      </div>
      <div id="dropShadow"></div>
    </div>
`,is:"paper-header-panel",properties:{mode:{type:String,value:"standard",observer:"_modeChanged",reflectToAttribute:!0},shadow:{type:Boolean,value:!1},tallClass:{type:String,value:"tall"},atTop:{type:Boolean,value:!0,notify:!0,readOnly:!0,reflectToAttribute:!0}},observers:["_computeDropShadowHidden(atTop, mode, shadow)"],attached:function(){this._addListener(),this._keepScrollingState()},detached:function(){this._removeListener()},ready:function(){this.scrollHandler=this._scroll.bind(this),console.warn(this.is,"is deprecated. Please use app-layout instead!")},get header(){return Yi(this.$.headerSlot).getDistributedNodes()[0]},get scroller(){return this._getScrollerForMode(this.mode)},get visibleShadow(){return this.$.dropShadow.classList.contains("has-shadow")},_computeDropShadowHidden:function(t,e,n){var i=Ya.shadowMode[e];this.toggleClass("has-shadow",!!this.shadow||2===i||1===i&&!t,this.$.dropShadow)},_computeMainContainerClass:function(t){var e={};return e.flex="cover"!==t,Object.keys(e).filter((function(t){return e[t]})).join(" ")},_addListener:function(){this.scroller.addEventListener("scroll",this.scrollHandler)},_removeListener:function(){this.scroller.removeEventListener("scroll",this.scrollHandler)},_modeChanged:function(t,e){var n=Ya,i=this.header;i&&(n.tallMode[e]&&!n.tallMode[t]?(i.classList.remove(this.tallClass),this.async((function(){i.classList.remove("animate")}),200)):this.toggleClass("animate",n.tallMode[t],i)),this._keepScrollingState()},_keepScrollingState:function(){var t=this.scroller,e=this.header;this._setAtTop(0===t.scrollTop),e&&this.tallClass&&Ya.tallMode[this.mode]&&this.toggleClass(this.tallClass,this.atTop||e.classList.contains(this.tallClass)&&t.scrollHeight<this.offsetHeight,e)},_scroll:function(){this._keepScrollingState(),this.fire("content-scroll",{target:this.scroller},{bubbles:!1})},_getScrollerForMode:function(t){return Ya.outerScroll[t]?this:this.$.mainContainer}}),
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({is:"paper-icon-button",_template:_e`
    <style>
      :host {
        display: inline-block;
        position: relative;
        padding: 8px;
        outline: none;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
        cursor: pointer;
        z-index: 0;
        line-height: 1;

        width: 40px;
        height: 40px;

        /*
          NOTE: Both values are needed, since some phones require the value to
          be \`transparent\`.
        */
        -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
        -webkit-tap-highlight-color: transparent;

        /* Because of polymer/2558, this style has lower specificity than * */
        box-sizing: border-box !important;

        @apply --paper-icon-button;
      }

      :host #ink {
        color: var(--paper-icon-button-ink-color, var(--primary-text-color));
        opacity: 0.6;
      }

      :host([disabled]) {
        color: var(--paper-icon-button-disabled-text, var(--disabled-text-color));
        pointer-events: none;
        cursor: auto;

        @apply --paper-icon-button-disabled;
      }

      :host([hidden]) {
        display: none !important;
      }

      :host(:hover) {
        @apply --paper-icon-button-hover;
      }

      iron-icon {
        --iron-icon-width: 100%;
        --iron-icon-height: 100%;
      }
    </style>

    <iron-icon id="icon" src="[[src]]" icon="[[icon]]"
               alt$="[[alt]]"></iron-icon>
  `,hostAttributes:{role:"button",tabindex:"0"},behaviors:[ca],registered:function(){this._template.setAttribute("strip-whitespace","")},properties:{src:{type:String},icon:{type:String},alt:{type:String,observer:"_altChanged"}},_altChanged:function(t,e){var n=this.getAttribute("aria-label");n&&e!=n||this.setAttribute("aria-label",t)}}),
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({_template:_e`
    <style>
      :host {
        display: inline-block;
        position: relative;
        width: 400px;
        border: 1px solid;
        padding: 2px;
        -moz-appearance: textarea;
        -webkit-appearance: textarea;
        overflow: hidden;
      }

      .mirror-text {
        visibility: hidden;
        word-wrap: break-word;
        @apply --iron-autogrow-textarea;
      }

      .fit {
        @apply --layout-fit;
      }

      textarea {
        position: relative;
        outline: none;
        border: none;
        resize: none;
        background: inherit;
        color: inherit;
        /* see comments in template */
        width: 100%;
        height: 100%;
        font-size: inherit;
        font-family: inherit;
        line-height: inherit;
        text-align: inherit;
        @apply --iron-autogrow-textarea;
      }

      textarea::-webkit-input-placeholder {
        @apply --iron-autogrow-textarea-placeholder;
      }

      textarea:-moz-placeholder {
        @apply --iron-autogrow-textarea-placeholder;
      }

      textarea::-moz-placeholder {
        @apply --iron-autogrow-textarea-placeholder;
      }

      textarea:-ms-input-placeholder {
        @apply --iron-autogrow-textarea-placeholder;
      }
    </style>

    <!-- the mirror sizes the input/textarea so it grows with typing -->
    <!-- use &#160; instead &nbsp; of to allow this element to be used in XHTML -->
    <div id="mirror" class="mirror-text" aria-hidden="true">&nbsp;</div>

    <!-- size the input/textarea with a div, because the textarea has intrinsic size in ff -->
    <div class="textarea-container fit">
      <textarea id="textarea" name$="[[name]]" aria-label$="[[label]]" autocomplete$="[[autocomplete]]" autofocus$="[[autofocus]]" autocapitalize$="[[autocapitalize]]" inputmode$="[[inputmode]]" placeholder$="[[placeholder]]" readonly$="[[readonly]]" required$="[[required]]" disabled$="[[disabled]]" rows$="[[rows]]" minlength$="[[minlength]]" maxlength$="[[maxlength]]"></textarea>
    </div>
`,is:"iron-autogrow-textarea",behaviors:[aa,qo],properties:{value:{observer:"_valueChanged",type:String,notify:!0},bindValue:{observer:"_bindValueChanged",type:String,notify:!0},rows:{type:Number,value:1,observer:"_updateCached"},maxRows:{type:Number,value:0,observer:"_updateCached"},autocomplete:{type:String,value:"off"},autofocus:{type:Boolean,value:!1},autocapitalize:{type:String,value:"none"},inputmode:{type:String},placeholder:{type:String},readonly:{type:String},required:{type:Boolean},minlength:{type:Number},maxlength:{type:Number},label:{type:String}},listeners:{input:"_onInput"},get textarea(){return this.$.textarea},get selectionStart(){return this.$.textarea.selectionStart},get selectionEnd(){return this.$.textarea.selectionEnd},set selectionStart(t){this.$.textarea.selectionStart=t},set selectionEnd(t){this.$.textarea.selectionEnd=t},attached:function(){navigator.userAgent.match(/iP(?:[oa]d|hone)/)&&!navigator.userAgent.match(/OS 1[3456789]/)&&(this.$.textarea.style.marginLeft="-3px")},validate:function(){var t=this.$.textarea.validity.valid;return t&&(this.required&&""===this.value?t=!1:this.hasValidator()&&(t=aa.validate.call(this,this.value))),this.invalid=!t,this.fire("iron-input-validate"),t},_bindValueChanged:function(t){this.value=t},_valueChanged:function(t){var e=this.textarea;e&&(e.value!==t&&(e.value=t||0===t?t:""),this.bindValue=t,this.$.mirror.innerHTML=this._valueForMirror(),this.fire("bind-value-changed",{value:this.bindValue}))},_onInput:function(t){var e=Yi(t).path;this.value=e?e[0].value:t.target.value},_constrain:function(t){var e;for(t=t||[""],e=this.maxRows>0&&t.length>this.maxRows?t.slice(0,this.maxRows):t.slice(0);this.rows>0&&e.length<this.rows;)e.push("");return e.join("<br/>")+"&#160;"},_valueForMirror:function(){var t=this.textarea;if(t)return this.tokens=t&&t.value?t.value.replace(/&/gm,"&amp;").replace(/"/gm,"&quot;").replace(/'/gm,"&#39;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").split("\n"):[""],this._constrain(this.tokens)},_updateCached:function(){this.$.mirror.innerHTML=this._constrain(this.tokens)}}),
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({_template:_e`
    <style>
      :host {
        display: block;
      }

      :host([hidden]) {
        display: none !important;
      }

      label {
        pointer-events: none;
      }
    </style>

    <paper-input-container no-label-float$="[[noLabelFloat]]" always-float-label="[[_computeAlwaysFloatLabel(alwaysFloatLabel,placeholder)]]" auto-validate$="[[autoValidate]]" disabled$="[[disabled]]" invalid="[[invalid]]">

      <label hidden$="[[!label]]" aria-hidden="true" for$="[[_inputId]]" slot="label">[[label]]</label>

      <iron-autogrow-textarea class="paper-input-input" slot="input" id$="[[_inputId]]" aria-labelledby$="[[_ariaLabelledBy]]" aria-describedby$="[[_ariaDescribedBy]]" bind-value="{{value}}" invalid="{{invalid}}" validator$="[[validator]]" disabled$="[[disabled]]" autocomplete$="[[autocomplete]]" autofocus$="[[autofocus]]" inputmode$="[[inputmode]]" name$="[[name]]" placeholder$="[[placeholder]]" readonly$="[[readonly]]" required$="[[required]]" minlength$="[[minlength]]" maxlength$="[[maxlength]]" autocapitalize$="[[autocapitalize]]" rows$="[[rows]]" max-rows$="[[maxRows]]" on-change="_onChange"></iron-autogrow-textarea>

      <template is="dom-if" if="[[errorMessage]]">
        <paper-input-error aria-live="assertive" slot="add-on">[[errorMessage]]</paper-input-error>
      </template>

      <template is="dom-if" if="[[charCounter]]">
        <paper-input-char-counter slot="add-on"></paper-input-char-counter>
      </template>

    </paper-input-container>
`,is:"paper-textarea",behaviors:[Fa,ra],properties:{_ariaLabelledBy:{observer:"_ariaLabelledByChanged",type:String},_ariaDescribedBy:{observer:"_ariaDescribedByChanged",type:String},value:{type:String},rows:{type:Number,value:1},maxRows:{type:Number,value:0}},get selectionStart(){return this.$.input.textarea.selectionStart},set selectionStart(t){this.$.input.textarea.selectionStart=t},get selectionEnd(){return this.$.input.textarea.selectionEnd},set selectionEnd(t){this.$.input.textarea.selectionEnd=t},_ariaLabelledByChanged:function(t){this._focusableElement.setAttribute("aria-labelledby",t)},_ariaDescribedByChanged:function(t){this._focusableElement.setAttribute("aria-describedby",t)},get _focusableElement(){return this.inputElement.textarea}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const Xa=document.createElement("template");Xa.setAttribute("style","display: none;"),Xa.innerHTML="<dom-module id=\"paper-item-shared-styles\">\n  <template>\n    <style>\n      :host, .paper-item {\n        display: block;\n        position: relative;\n        min-height: var(--paper-item-min-height, 48px);\n        padding: 0px 16px;\n      }\n\n      .paper-item {\n        @apply --paper-font-subhead;\n        border:none;\n        outline: none;\n        background: white;\n        width: 100%;\n        text-align: left;\n      }\n\n      :host([hidden]), .paper-item[hidden] {\n        display: none !important;\n      }\n\n      :host(.iron-selected), .paper-item.iron-selected {\n        font-weight: var(--paper-item-selected-weight, bold);\n\n        @apply --paper-item-selected;\n      }\n\n      :host([disabled]), .paper-item[disabled] {\n        color: var(--paper-item-disabled-color, var(--disabled-text-color));\n\n        @apply --paper-item-disabled;\n      }\n\n      :host(:focus), .paper-item:focus {\n        position: relative;\n        outline: 0;\n\n        @apply --paper-item-focused;\n      }\n\n      :host(:focus):before, .paper-item:focus:before {\n        @apply --layout-fit;\n\n        background: currentColor;\n        content: '';\n        opacity: var(--dark-divider-opacity);\n        pointer-events: none;\n\n        @apply --paper-item-focused-before;\n      }\n    </style>\n  </template>\n</dom-module>",document.head.appendChild(Xa.content);
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const $a=[Xo,qo,{hostAttributes:{role:"option",tabindex:"0"}}];
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({_template:_e`
    <style include="paper-item-shared-styles">
      :host {
        @apply --layout-horizontal;
        @apply --layout-center;
        @apply --paper-font-subhead;

        @apply --paper-item;
      }
    </style>
    <slot></slot>
`,is:"paper-item",behaviors:[$a]}),
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({_template:_e`
    <style>
      :host {
        overflow: hidden; /* needed for text-overflow: ellipsis to work on ff */
        @apply --layout-vertical;
        @apply --layout-center-justified;
        @apply --layout-flex;
      }

      :host([two-line]) {
        min-height: var(--paper-item-body-two-line-min-height, 72px);
      }

      :host([three-line]) {
        min-height: var(--paper-item-body-three-line-min-height, 88px);
      }

      :host > ::slotted(*) {
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
      }

      :host > ::slotted([secondary]) {
        @apply --paper-font-body1;

        color: var(--paper-item-body-secondary-color, var(--secondary-text-color));

        @apply --paper-item-body-secondary;
      }
    </style>

    <slot></slot>
`,is:"paper-item-body"}),
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({_template:_e`
    <style include="paper-item-shared-styles"></style>
    <style>
      :host {
        @apply --layout-horizontal;
        @apply --layout-center;
        @apply --paper-font-subhead;

        @apply --paper-item;
        @apply --paper-icon-item;
      }

      .content-icon {
        @apply --layout-horizontal;
        @apply --layout-center;

        width: var(--paper-item-icon-width, 56px);
        @apply --paper-item-icon;
      }
    </style>

    <div id="contentIcon" class="content-icon">
      <slot name="item-icon"></slot>
    </div>
    <slot></slot>
`,is:"paper-icon-item",behaviors:[$a]});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const Ka={properties:{multi:{type:Boolean,value:!1,observer:"multiChanged"},selectedValues:{type:Array,notify:!0,value:function(){return[]}},selectedItems:{type:Array,readOnly:!0,notify:!0,value:function(){return[]}}},observers:["_updateSelected(selectedValues.splices)"],select:function(t){this.multi?this._toggleSelected(t):this.selected=t},multiChanged:function(t){this._selection.multi=t,this._updateSelected()},get _shouldUpdateSelection(){return null!=this.selected||null!=this.selectedValues&&this.selectedValues.length},_updateAttrForSelected:function(){this.multi?this.selectedItems&&this.selectedItems.length>0&&(this.selectedValues=this.selectedItems.map((function(t){return this._indexToValue(this.indexOf(t))}),this).filter((function(t){return null!=t}),this)):jo._updateAttrForSelected.apply(this)},_updateSelected:function(){this.multi?this._selectMulti(this.selectedValues):this._selectSelected(this.selected)},_selectMulti:function(t){var e=(this._valuesToItems(t=t||[])||[]).filter((function(t){return null!=t}));this._selection.clear(e);for(var n=0;n<e.length;n++)this._selection.setItemSelected(e[n],!0);this.fallbackSelection&&!this._selection.get().length&&this._valueToItem(this.fallbackSelection)&&this.select(this.fallbackSelection)},_selectionChange:function(){var t=this._selection.get();this.multi?(this._setSelectedItems(t),this._setSelectedItem(t.length?t[0]:null)):null!=t?(this._setSelectedItems([t]),this._setSelectedItem(t)):(this._setSelectedItems([]),this._setSelectedItem(null))},_toggleSelected:function(t){var e=this.selectedValues.indexOf(t);e<0?this.push("selectedValues",t):this.splice("selectedValues",e,1)},_valuesToItems:function(t){return null==t?null:t.map((function(t){return this._valueToItem(t)}),this)}},Za={properties:{focusedItem:{observer:"_focusedItemChanged",readOnly:!0,type:Object},attrForItemTitle:{type:String},disabled:{type:Boolean,value:!1,observer:"_disabledChanged"}},_MODIFIER_KEYS:["Alt","AltGraph","CapsLock","Control","Fn","FnLock","Hyper","Meta","NumLock","OS","ScrollLock","Shift","Super","Symbol","SymbolLock"],_SEARCH_RESET_TIMEOUT_MS:1e3,_previousTabIndex:0,hostAttributes:{role:"menu"},observers:["_updateMultiselectable(multi)"],listeners:{focus:"_onFocus",keydown:"_onKeydown","iron-items-changed":"_onIronItemsChanged"},keyBindings:{up:"_onUpKey",down:"_onDownKey",esc:"_onEscKey","shift+tab:keydown":"_onShiftTabDown"},attached:function(){this._resetTabindices()},select:function(t){this._defaultFocusAsync&&(this.cancelAsync(this._defaultFocusAsync),this._defaultFocusAsync=null);var e=this._valueToItem(t);e&&e.hasAttribute("disabled")||(this._setFocusedItem(e),Ka.select.apply(this,arguments))},_resetTabindices:function(){var t=this.multi?this.selectedItems&&this.selectedItems[0]:this.selectedItem;this.items.forEach((function(e){e.setAttribute("tabindex",e===t?"0":"-1"),e.setAttribute("aria-selected",this._selection.isSelected(e))}),this)},_updateMultiselectable:function(t){t?this.setAttribute("aria-multiselectable","true"):this.removeAttribute("aria-multiselectable")},_focusWithKeyboardEvent:function(t){if(-1===this._MODIFIER_KEYS.indexOf(t.key)){this.cancelDebouncer("_clearSearchText");for(var e,n=this._searchText||"",i=(n+=(t.key&&1==t.key.length?t.key:String.fromCharCode(t.keyCode)).toLocaleLowerCase()).length,r=0;e=this.items[r];r++)if(!e.hasAttribute("disabled")){var o=this.attrForItemTitle||"textContent",a=(e[o]||e.getAttribute(o)||"").trim();if(!(a.length<i)&&a.slice(0,i).toLocaleLowerCase()==n){this._setFocusedItem(e);break}}this._searchText=n,this.debounce("_clearSearchText",this._clearSearchText,this._SEARCH_RESET_TIMEOUT_MS)}},_clearSearchText:function(){this._searchText=""},_focusPrevious:function(){for(var t=this.items.length,e=Number(this.indexOf(this.focusedItem)),n=1;n<t+1;n++){var i=this.items[(e-n+t)%t];if(!i.hasAttribute("disabled")){var r=Yi(i).getOwnerRoot()||document;if(this._setFocusedItem(i),Yi(r).activeElement==i)return}}},_focusNext:function(){for(var t=this.items.length,e=Number(this.indexOf(this.focusedItem)),n=1;n<t+1;n++){var i=this.items[(e+n)%t];if(!i.hasAttribute("disabled")){var r=Yi(i).getOwnerRoot()||document;if(this._setFocusedItem(i),Yi(r).activeElement==i)return}}},_applySelection:function(t,e){t.setAttribute("aria-selected",e?"true":"false"),jo._applySelection.apply(this,arguments)},_focusedItemChanged:function(t,e){e&&e.setAttribute("tabindex","-1"),!t||t.hasAttribute("disabled")||this.disabled||(t.setAttribute("tabindex","0"),t.focus())},_onIronItemsChanged:function(t){t.detail.addedNodes.length&&this._resetTabindices()},_onShiftTabDown:function(t){var e=this.getAttribute("tabindex");Za._shiftTabPressed=!0,this._setFocusedItem(null),this.setAttribute("tabindex","-1"),this.async((function(){this.setAttribute("tabindex",e),Za._shiftTabPressed=!1}),1)},_onFocus:function(t){if(!Za._shiftTabPressed){var e=Yi(t).rootTarget;(e===this||void 0===e.tabIndex||this.isLightDescendant(e))&&(this._defaultFocusAsync=this.async((function(){var t=this.multi?this.selectedItems&&this.selectedItems[0]:this.selectedItem;this._setFocusedItem(null),t?this._setFocusedItem(t):this.items[0]&&this._focusNext()})))}},_onUpKey:function(t){this._focusPrevious(),t.detail.keyboardEvent.preventDefault()},_onDownKey:function(t){this._focusNext(),t.detail.keyboardEvent.preventDefault()},_onEscKey:function(t){var e=this.focusedItem;e&&e.blur()},_onKeydown:function(t){this.keyboardEventMatchesKeys(t,"up down esc")||this._focusWithKeyboardEvent(t),t.stopPropagation()},_activateHandler:function(t){jo._activateHandler.call(this,t),t.stopPropagation()},_disabledChanged:function(t){t?(this._previousTabIndex=this.hasAttribute("tabindex")?this.tabIndex:0,this.removeAttribute("tabindex")):this.hasAttribute("tabindex")||this.setAttribute("tabindex",this._previousTabIndex)},_shiftTabPressed:!1},Ja=[[jo,Ka],zo,Za];
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({_template:_e`
    <style>
      :host {
        display: block;
        padding: 8px 0;

        background: var(--paper-listbox-background-color, var(--primary-background-color));
        color: var(--paper-listbox-color, var(--primary-text-color));

        @apply --paper-listbox;
      }
    </style>

    <slot></slot>
`,is:"paper-listbox",behaviors:[Ja],hostAttributes:{role:"listbox"}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const Qa=_e`
<dom-module id="paper-material-shared-styles">
  <template>
    <style>
      :host {
        display: block;
        position: relative;
      }

      :host([elevation="1"]) {
        @apply --shadow-elevation-2dp;
      }

      :host([elevation="2"]) {
        @apply --shadow-elevation-4dp;
      }

      :host([elevation="3"]) {
        @apply --shadow-elevation-6dp;
      }

      :host([elevation="4"]) {
        @apply --shadow-elevation-8dp;
      }

      :host([elevation="5"]) {
        @apply --shadow-elevation-16dp;
      }
    </style>
  </template>
</dom-module>
`;Qa.setAttribute("style","display: none;"),document.body.appendChild(Qa.content),
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({_template:_e`
    <style include="paper-material-shared-styles"></style>
    <style>
      :host([animated]) {
        @apply --shadow-transition;
      }
      :host {
        @apply --paper-material;
      }
    </style>

    <slot></slot>
`,is:"paper-material",properties:{elevation:{type:Number,reflectToAttribute:!0,value:1},animated:{type:Boolean,reflectToAttribute:!0,value:!1}}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const ts={properties:{value:{type:Number,value:0,notify:!0,reflectToAttribute:!0},min:{type:Number,value:0,notify:!0},max:{type:Number,value:100,notify:!0},step:{type:Number,value:1,notify:!0},ratio:{type:Number,value:0,readOnly:!0,notify:!0}},observers:["_update(value, min, max, step)"],_calcRatio:function(t){return(this._clampValue(t)-this.min)/(this.max-this.min)},_clampValue:function(t){return Math.min(this.max,Math.max(this.min,this._calcStep(t)))},_calcStep:function(t){if(t=parseFloat(t),!this.step)return t;var e=Math.round((t-this.min)/this.step);return this.step<1?e/(1/this.step)+this.min:e*this.step+this.min},_validateValue:function(){var t=this._clampValue(this.value);return this.value=this.oldValue=isNaN(t)?this.oldValue:t,this.value!==t},_update:function(){this._validateValue(),this._setRatio(100*this._calcRatio(this.value))}};
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */Rr({_template:_e`
    <style>
      :host {
        display: block;
        width: 200px;
        position: relative;
        overflow: hidden;
      }

      :host([hidden]), [hidden] {
        display: none !important;
      }

      #progressContainer {
        @apply --paper-progress-container;
        position: relative;
      }

      #progressContainer,
      /* the stripe for the indeterminate animation*/
      .indeterminate::after {
        height: var(--paper-progress-height, 4px);
      }

      #primaryProgress,
      #secondaryProgress,
      .indeterminate::after {
        @apply --layout-fit;
      }

      #progressContainer,
      .indeterminate::after {
        background: var(--paper-progress-container-color, var(--google-grey-300));
      }

      :host(.transiting) #primaryProgress,
      :host(.transiting) #secondaryProgress {
        -webkit-transition-property: -webkit-transform;
        transition-property: transform;

        /* Duration */
        -webkit-transition-duration: var(--paper-progress-transition-duration, 0.08s);
        transition-duration: var(--paper-progress-transition-duration, 0.08s);

        /* Timing function */
        -webkit-transition-timing-function: var(--paper-progress-transition-timing-function, ease);
        transition-timing-function: var(--paper-progress-transition-timing-function, ease);

        /* Delay */
        -webkit-transition-delay: var(--paper-progress-transition-delay, 0s);
        transition-delay: var(--paper-progress-transition-delay, 0s);
      }

      #primaryProgress,
      #secondaryProgress {
        @apply --layout-fit;
        -webkit-transform-origin: left center;
        transform-origin: left center;
        -webkit-transform: scaleX(0);
        transform: scaleX(0);
        will-change: transform;
      }

      #primaryProgress {
        background: var(--paper-progress-active-color, var(--google-green-500));
      }

      #secondaryProgress {
        background: var(--paper-progress-secondary-color, var(--google-green-100));
      }

      :host([disabled]) #primaryProgress {
        background: var(--paper-progress-disabled-active-color, var(--google-grey-500));
      }

      :host([disabled]) #secondaryProgress {
        background: var(--paper-progress-disabled-secondary-color, var(--google-grey-300));
      }

      :host(:not([disabled])) #primaryProgress.indeterminate {
        -webkit-transform-origin: right center;
        transform-origin: right center;
        -webkit-animation: indeterminate-bar var(--paper-progress-indeterminate-cycle-duration, 2s) linear infinite;
        animation: indeterminate-bar var(--paper-progress-indeterminate-cycle-duration, 2s) linear infinite;
      }

      :host(:not([disabled])) #primaryProgress.indeterminate::after {
        content: "";
        -webkit-transform-origin: center center;
        transform-origin: center center;

        -webkit-animation: indeterminate-splitter var(--paper-progress-indeterminate-cycle-duration, 2s) linear infinite;
        animation: indeterminate-splitter var(--paper-progress-indeterminate-cycle-duration, 2s) linear infinite;
      }

      @-webkit-keyframes indeterminate-bar {
        0% {
          -webkit-transform: scaleX(1) translateX(-100%);
        }
        50% {
          -webkit-transform: scaleX(1) translateX(0%);
        }
        75% {
          -webkit-transform: scaleX(1) translateX(0%);
          -webkit-animation-timing-function: cubic-bezier(.28,.62,.37,.91);
        }
        100% {
          -webkit-transform: scaleX(0) translateX(0%);
        }
      }

      @-webkit-keyframes indeterminate-splitter {
        0% {
          -webkit-transform: scaleX(.75) translateX(-125%);
        }
        30% {
          -webkit-transform: scaleX(.75) translateX(-125%);
          -webkit-animation-timing-function: cubic-bezier(.42,0,.6,.8);
        }
        90% {
          -webkit-transform: scaleX(.75) translateX(125%);
        }
        100% {
          -webkit-transform: scaleX(.75) translateX(125%);
        }
      }

      @keyframes indeterminate-bar {
        0% {
          transform: scaleX(1) translateX(-100%);
        }
        50% {
          transform: scaleX(1) translateX(0%);
        }
        75% {
          transform: scaleX(1) translateX(0%);
          animation-timing-function: cubic-bezier(.28,.62,.37,.91);
        }
        100% {
          transform: scaleX(0) translateX(0%);
        }
      }

      @keyframes indeterminate-splitter {
        0% {
          transform: scaleX(.75) translateX(-125%);
        }
        30% {
          transform: scaleX(.75) translateX(-125%);
          animation-timing-function: cubic-bezier(.42,0,.6,.8);
        }
        90% {
          transform: scaleX(.75) translateX(125%);
        }
        100% {
          transform: scaleX(.75) translateX(125%);
        }
      }
    </style>

    <div id="progressContainer">
      <div id="secondaryProgress" hidden\$="[[_hideSecondaryProgress(secondaryRatio)]]"></div>
      <div id="primaryProgress"></div>
    </div>
`,is:"paper-progress",behaviors:[ts],properties:{secondaryProgress:{type:Number,value:0},secondaryRatio:{type:Number,value:0,readOnly:!0},indeterminate:{type:Boolean,value:!1,observer:"_toggleIndeterminate"},disabled:{type:Boolean,value:!1,reflectToAttribute:!0,observer:"_disabledChanged"}},observers:["_progressChanged(secondaryProgress, value, min, max, indeterminate)"],hostAttributes:{role:"progressbar"},_toggleIndeterminate:function(t){this.toggleClass("indeterminate",t,this.$.primaryProgress)},_transformProgress:function(t,e){t.style.transform=t.style.webkitTransform="scaleX("+e/100+")"},_mainRatioChanged:function(t){this._transformProgress(this.$.primaryProgress,t)},_progressChanged:function(t,e,n,i,r){t=this._clampValue(t),e=this._clampValue(e);var o=100*this._calcRatio(t),a=100*this._calcRatio(e);this._setSecondaryRatio(o),this._transformProgress(this.$.secondaryProgress,o),this._transformProgress(this.$.primaryProgress,a),this.secondaryProgress=t,r?this.removeAttribute("aria-valuenow"):this.setAttribute("aria-valuenow",e),this.setAttribute("aria-valuemin",n),this.setAttribute("aria-valuemax",i)},_disabledChanged:function(t){this.setAttribute("aria-disabled",t?"true":"false")},_hideSecondaryProgress:function(t){return 0===t}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
const es=_e`
<style>
  :host {
    display: inline-block;
    line-height: 0;
    white-space: nowrap;
    cursor: pointer;
    @apply --paper-font-common-base;
    --calculated-paper-radio-button-size: var(--paper-radio-button-size, 16px);
    /* -1px is a sentinel for the default and is replace in \`attached\`. */
    --calculated-paper-radio-button-ink-size: var(--paper-radio-button-ink-size, -1px);
  }

  :host(:focus) {
    outline: none;
  }

  #radioContainer {
    @apply --layout-inline;
    @apply --layout-center-center;
    position: relative;
    width: var(--calculated-paper-radio-button-size);
    height: var(--calculated-paper-radio-button-size);
    vertical-align: middle;

    @apply --paper-radio-button-radio-container;
  }

  #ink {
    position: absolute;
    top: 50%;
    left: 50%;
    right: auto;
    width: var(--calculated-paper-radio-button-ink-size);
    height: var(--calculated-paper-radio-button-ink-size);
    color: var(--paper-radio-button-unchecked-ink-color, var(--primary-text-color));
    opacity: 0.6;
    pointer-events: none;
    -webkit-transform: translate(-50%, -50%);
    transform: translate(-50%, -50%);
  }

  #ink[checked] {
    color: var(--paper-radio-button-checked-ink-color, var(--primary-color));
  }

  #offRadio, #onRadio {
    position: absolute;
    box-sizing: border-box;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    border-radius: 50%;
  }

  #offRadio {
    border: 2px solid var(--paper-radio-button-unchecked-color, var(--primary-text-color));
    background-color: var(--paper-radio-button-unchecked-background-color, transparent);
    transition: border-color 0.28s;
  }

  #onRadio {
    background-color: var(--paper-radio-button-checked-color, var(--primary-color));
    -webkit-transform: scale(0);
    transform: scale(0);
    transition: -webkit-transform ease 0.28s;
    transition: transform ease 0.28s;
    will-change: transform;
  }

  :host([checked]) #offRadio {
    border-color: var(--paper-radio-button-checked-color, var(--primary-color));
  }

  :host([checked]) #onRadio {
    -webkit-transform: scale(0.5);
    transform: scale(0.5);
  }

  #radioLabel {
    line-height: normal;
    position: relative;
    display: inline-block;
    vertical-align: middle;
    margin-left: var(--paper-radio-button-label-spacing, 10px);
    white-space: normal;
    color: var(--paper-radio-button-label-color, var(--primary-text-color));

    @apply --paper-radio-button-label;
  }

  :host([checked]) #radioLabel {
    @apply --paper-radio-button-label-checked;
  }

  #radioLabel:dir(rtl) {
    margin-left: 0;
    margin-right: var(--paper-radio-button-label-spacing, 10px);
  }

  #radioLabel[hidden] {
    display: none;
  }

  /* disabled state */

  :host([disabled]) #offRadio {
    border-color: var(--paper-radio-button-unchecked-color, var(--primary-text-color));
    opacity: 0.5;
  }

  :host([disabled][checked]) #onRadio {
    background-color: var(--paper-radio-button-unchecked-color, var(--primary-text-color));
    opacity: 0.5;
  }

  :host([disabled]) #radioLabel {
    /* slightly darker than the button, so that it's readable */
    opacity: 0.65;
  }
</style>

<div id="radioContainer">
  <div id="offRadio"></div>
  <div id="onRadio"></div>
</div>

<div id="radioLabel"><slot></slot></div>`;es.setAttribute("strip-whitespace",""),Rr({_template:es,is:"paper-radio-button",behaviors:[ua],hostAttributes:{role:"radio","aria-checked":!1,tabindex:0},properties:{ariaActiveAttribute:{type:String,value:"aria-checked"}},ready:function(){this._rippleContainer=this.$.radioContainer},attached:function(){Li(this,(function(){if("-1px"===this.getComputedStyleValue("--calculated-paper-radio-button-ink-size").trim()){var t=parseFloat(this.getComputedStyleValue("--calculated-paper-radio-button-size").trim()),e=Math.floor(3*t);e%2!=t%2&&e++,this.updateStyles({"--paper-radio-button-ink-size":e+"px"})}}))}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const ns={hostAttributes:{role:"menubar"},keyBindings:{left:"_onLeftKey",right:"_onRightKey"},_onUpKey:function(t){this.focusedItem.click(),t.detail.keyboardEvent.preventDefault()},_onDownKey:function(t){this.focusedItem.click(),t.detail.keyboardEvent.preventDefault()},get _isRTL(){return"rtl"===window.getComputedStyle(this).direction},_onLeftKey:function(t){this._isRTL?this._focusNext():this._focusPrevious(),t.detail.keyboardEvent.preventDefault()},_onRightKey:function(t){this._isRTL?this._focusPrevious():this._focusNext(),t.detail.keyboardEvent.preventDefault()},_onKeydown:function(t){this.keyboardEventMatchesKeys(t,"up down left right esc")||this._focusWithKeyboardEvent(t)}},is=[Ja,ns];
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({_template:_e`
    <style>
      :host {
        display: inline-block;
      }

      :host ::slotted(*) {
        padding: var(--paper-radio-group-item-padding, 12px);
      }
    </style>

    <slot></slot>
`,is:"paper-radio-group",behaviors:[is],hostAttributes:{role:"radiogroup"},properties:{attrForSelected:{type:String,value:"name"},selectedAttribute:{type:String,value:"checked"},selectable:{type:String,value:"paper-radio-button"},allowEmptySelection:{type:Boolean,value:!1}},select:function(t){var e=this._valueToItem(t);if(!e||!e.hasAttribute("disabled")){if(this.selected){var n=this._valueToItem(this.selected);if(this.selected==t){if(!this.allowEmptySelection)return void(n&&(n.checked=!0));t=""}n&&(n.checked=!1)}jo.select.apply(this,[t]),this.fire("paper-radio-group-changed")}},_activateFocusedItem:function(){this._itemActivate(this._valueForItem(this.focusedItem),this.focusedItem)},_onUpKey:function(t){this._focusPrevious(),t.preventDefault(),this._activateFocusedItem()},_onDownKey:function(t){this._focusNext(),t.preventDefault(),this._activateFocusedItem()},_onLeftKey:function(t){ns._onLeftKey.apply(this,arguments),this._activateFocusedItem()},_onRightKey:function(t){ns._onRightKey.apply(this,arguments),this._activateFocusedItem()}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const rs=_e`
  <style>
    :host {
      @apply --layout;
      @apply --layout-justified;
      @apply --layout-center;
      width: 200px;
      cursor: default;
      -webkit-user-select: none;
      -moz-user-select: none;
      -ms-user-select: none;
      user-select: none;
      -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
      --paper-progress-active-color: var(--paper-slider-active-color, var(--google-blue-700));
      --paper-progress-secondary-color: var(--paper-slider-secondary-color, var(--google-blue-300));
      --paper-progress-disabled-active-color: var(--paper-slider-disabled-active-color, var(--paper-grey-400));
      --paper-progress-disabled-secondary-color: var(--paper-slider-disabled-secondary-color, var(--paper-grey-400));
      --calculated-paper-slider-height: var(--paper-slider-height, 2px);
    }

    /* focus shows the ripple */
    :host(:focus) {
      outline: none;
    }

    /**
      * NOTE(keanulee): Though :host-context is not universally supported, some pages
      * still rely on paper-slider being flipped when dir="rtl" is set on body. For full
      * compatibility, dir="rtl" must be explicitly set on paper-slider.
      */
    :dir(rtl) #sliderContainer {
      -webkit-transform: scaleX(-1);
      transform: scaleX(-1);
    }

    /**
      * NOTE(keanulee): This is separate from the rule above because :host-context may
      * not be recognized.
      */
    :host([dir="rtl"]) #sliderContainer {
      -webkit-transform: scaleX(-1);
      transform: scaleX(-1);
    }

    /**
      * NOTE(keanulee): Needed to override the :host-context rule (where supported)
      * to support LTR sliders in RTL pages.
      */
    :host([dir="ltr"]) #sliderContainer {
      -webkit-transform: scaleX(1);
      transform: scaleX(1);
    }

    #sliderContainer {
      position: relative;
      width: 100%;
      height: calc(30px + var(--calculated-paper-slider-height));
      margin-left: calc(15px + var(--calculated-paper-slider-height)/2);
      margin-right: calc(15px + var(--calculated-paper-slider-height)/2);
    }

    #sliderContainer:focus {
      outline: 0;
    }

    #sliderContainer.editable {
      margin-top: 12px;
      margin-bottom: 12px;
    }

    .bar-container {
      position: absolute;
      top: 0;
      bottom: 0;
      left: 0;
      right: 0;
      overflow: hidden;
    }

    .ring > .bar-container {
      left: calc(5px + var(--calculated-paper-slider-height)/2);
      transition: left 0.18s ease;
    }

    .ring.expand.dragging > .bar-container {
      transition: none;
    }

    .ring.expand:not(.pin) > .bar-container {
      left: calc(8px + var(--calculated-paper-slider-height)/2);
    }

    #sliderBar {
      padding: 15px 0;
      width: 100%;
      background-color: var(--paper-slider-bar-color, transparent);
      --paper-progress-container-color: var(--paper-slider-container-color, var(--paper-grey-400));
      --paper-progress-height: var(--calculated-paper-slider-height);
    }

    .slider-markers {
      position: absolute;
      /* slider-knob is 30px + the slider-height so that the markers should start at a offset of 15px*/
      top: 15px;
      height: var(--calculated-paper-slider-height);
      left: 0;
      right: -1px;
      box-sizing: border-box;
      pointer-events: none;
      @apply --layout-horizontal;
    }

    .slider-marker {
      @apply --layout-flex;
    }
    .slider-markers::after,
    .slider-marker::after {
      content: "";
      display: block;
      margin-left: -1px;
      width: 2px;
      height: var(--calculated-paper-slider-height);
      border-radius: 50%;
      background-color: var(--paper-slider-markers-color, #000);
    }

    .slider-knob {
      position: absolute;
      left: 0;
      top: 0;
      margin-left: calc(-15px - var(--calculated-paper-slider-height)/2);
      width: calc(30px + var(--calculated-paper-slider-height));
      height: calc(30px + var(--calculated-paper-slider-height));
    }

    .transiting > .slider-knob {
      transition: left 0.08s ease;
    }

    .slider-knob:focus {
      outline: none;
    }

    .slider-knob.dragging {
      transition: none;
    }

    .snaps > .slider-knob.dragging {
      transition: -webkit-transform 0.08s ease;
      transition: transform 0.08s ease;
    }

    .slider-knob-inner {
      margin: 10px;
      width: calc(100% - 20px);
      height: calc(100% - 20px);
      background-color: var(--paper-slider-knob-color, var(--google-blue-700));
      border: 2px solid var(--paper-slider-knob-color, var(--google-blue-700));
      border-radius: 50%;

      -moz-box-sizing: border-box;
      box-sizing: border-box;

      transition-property: -webkit-transform, background-color, border;
      transition-property: transform, background-color, border;
      transition-duration: 0.18s;
      transition-timing-function: ease;
    }

    .expand:not(.pin) > .slider-knob > .slider-knob-inner {
      -webkit-transform: scale(1.5);
      transform: scale(1.5);
    }

    .ring > .slider-knob > .slider-knob-inner {
      background-color: var(--paper-slider-knob-start-color, transparent);
      border: 2px solid var(--paper-slider-knob-start-border-color, var(--paper-grey-400));
    }

    .slider-knob-inner::before {
      background-color: var(--paper-slider-pin-color, var(--google-blue-700));
    }

    .pin > .slider-knob > .slider-knob-inner::before {
      content: "";
      position: absolute;
      top: 0;
      left: 50%;
      margin-left: -13px;
      width: 26px;
      height: 26px;
      border-radius: 50% 50% 50% 0;

      -webkit-transform: rotate(-45deg) scale(0) translate(0);
      transform: rotate(-45deg) scale(0) translate(0);
    }

    .slider-knob-inner::before,
    .slider-knob-inner::after {
      transition: -webkit-transform .18s ease, background-color .18s ease;
      transition: transform .18s ease, background-color .18s ease;
    }

    .pin.ring > .slider-knob > .slider-knob-inner::before {
      background-color: var(--paper-slider-pin-start-color, var(--paper-grey-400));
    }

    .pin.expand > .slider-knob > .slider-knob-inner::before {
      -webkit-transform: rotate(-45deg) scale(1) translate(17px, -17px);
      transform: rotate(-45deg) scale(1) translate(17px, -17px);
    }

    .pin > .slider-knob > .slider-knob-inner::after {
      content: attr(value);
      position: absolute;
      top: 0;
      left: 50%;
      margin-left: -16px;
      width: 32px;
      height: 26px;
      text-align: center;
      color: var(--paper-slider-font-color, #fff);
      font-size: 10px;

      -webkit-transform: scale(0) translate(0);
      transform: scale(0) translate(0);
    }

    .pin.expand > .slider-knob > .slider-knob-inner::after {
      -webkit-transform: scale(1) translate(0, -17px);
      transform: scale(1) translate(0, -17px);
    }

    /* paper-input */
    .slider-input {
      width: 50px;
      overflow: hidden;
      --paper-input-container-input: {
        text-align: center;
        @apply --paper-slider-input-container-input;
      };
      @apply --paper-slider-input;
    }

    /* disabled state */
    #sliderContainer.disabled {
      pointer-events: none;
    }

    .disabled > .slider-knob > .slider-knob-inner {
      background-color: var(--paper-slider-disabled-knob-color, var(--paper-grey-400));
      border: 2px solid var(--paper-slider-disabled-knob-color, var(--paper-grey-400));
      -webkit-transform: scale3d(0.75, 0.75, 1);
      transform: scale3d(0.75, 0.75, 1);
    }

    .disabled.ring > .slider-knob > .slider-knob-inner {
      background-color: var(--paper-slider-knob-start-color, transparent);
      border: 2px solid var(--paper-slider-knob-start-border-color, var(--paper-grey-400));
    }

    paper-ripple {
      color: var(--paper-slider-knob-color, var(--google-blue-700));
    }
  </style>

  <div id="sliderContainer" class\$="[[_getClassNames(disabled, pin, snaps, immediateValue, min, expand, dragging, transiting, editable)]]">
    <div class="bar-container">
      <paper-progress disabled\$="[[disabled]]" id="sliderBar" aria-hidden="true" min="[[min]]" max="[[max]]" step="[[step]]" value="[[immediateValue]]" secondary-progress="[[secondaryProgress]]" on-down="_bardown" on-up="_resetKnob" on-track="_bartrack" on-tap="_barclick">
      </paper-progress>
    </div>

    <template is="dom-if" if="[[snaps]]">
      <div class="slider-markers">
        <template is="dom-repeat" items="[[markers]]">
          <div class="slider-marker"></div>
        </template>
      </div>
    </template>

    <div id="sliderKnob" class="slider-knob" on-down="_knobdown" on-up="_resetKnob" on-track="_onTrack" on-transitionend="_knobTransitionEnd">
        <div class="slider-knob-inner" value\$="[[immediateValue]]"></div>
    </div>
  </div>

  <template is="dom-if" if="[[editable]]">
    <paper-input id="input" type="number" step="[[step]]" min="[[min]]" max="[[max]]" class="slider-input" disabled\$="[[disabled]]" value="[[immediateValue]]" on-change="_changeValue" on-keydown="_inputKeyDown" no-label-float>
    </paper-input>
  </template>
`;rs.setAttribute("strip-whitespace",""),Rr({_template:rs,is:"paper-slider",behaviors:[zo,ra,ca,ts],properties:{value:{type:Number,value:0},snaps:{type:Boolean,value:!1,notify:!0},pin:{type:Boolean,value:!1,notify:!0},secondaryProgress:{type:Number,value:0,notify:!0,observer:"_secondaryProgressChanged"},editable:{type:Boolean,value:!1},immediateValue:{type:Number,value:0,readOnly:!0,notify:!0},maxMarkers:{type:Number,value:0,notify:!0},expand:{type:Boolean,value:!1,readOnly:!0},ignoreBarTouch:{type:Boolean,value:!1},dragging:{type:Boolean,value:!1,readOnly:!0,notify:!0},transiting:{type:Boolean,value:!1,readOnly:!0},markers:{type:Array,readOnly:!0,value:function(){return[]}}},observers:["_updateKnob(value, min, max, snaps, step)","_valueChanged(value)","_immediateValueChanged(immediateValue)","_updateMarkers(maxMarkers, min, max, snaps)"],hostAttributes:{role:"slider",tabindex:0},keyBindings:{left:"_leftKey",right:"_rightKey","down pagedown home":"_decrementKey","up pageup end":"_incrementKey"},ready:function(){this.ignoreBarTouch&&oi(this.$.sliderBar,"auto")},increment:function(){this.value=this._clampValue(this.value+this.step)},decrement:function(){this.value=this._clampValue(this.value-this.step)},_updateKnob:function(t,e,n,i,r){this.setAttribute("aria-valuemin",e),this.setAttribute("aria-valuemax",n),this.setAttribute("aria-valuenow",t),this._positionKnob(100*this._calcRatio(t))},_valueChanged:function(){this.fire("value-change",{composed:!0})},_immediateValueChanged:function(){this.dragging?this.fire("immediate-value-change",{composed:!0}):this.value=this.immediateValue},_secondaryProgressChanged:function(){this.secondaryProgress=this._clampValue(this.secondaryProgress)},_expandKnob:function(){this._setExpand(!0)},_resetKnob:function(){this.cancelDebouncer("expandKnob"),this._setExpand(!1)},_positionKnob:function(t){this._setImmediateValue(this._calcStep(this._calcKnobPosition(t))),this._setRatio(100*this._calcRatio(this.immediateValue)),this.$.sliderKnob.style.left=this.ratio+"%",this.dragging&&(this._knobstartx=this.ratio*this._w/100,this.translate3d(0,0,0,this.$.sliderKnob))},_calcKnobPosition:function(t){return(this.max-this.min)*t/100+this.min},_onTrack:function(t){switch(t.stopPropagation(),t.detail.state){case"start":this._trackStart(t);break;case"track":this._trackX(t);break;case"end":this._trackEnd()}},_trackStart:function(t){this._setTransiting(!1),this._w=this.$.sliderBar.offsetWidth,this._x=this.ratio*this._w/100,this._startx=this._x,this._knobstartx=this._startx,this._minx=-this._startx,this._maxx=this._w-this._startx,this.$.sliderKnob.classList.add("dragging"),this._setDragging(!0)},_trackX:function(t){this.dragging||this._trackStart(t);var e=Math.min(this._maxx,Math.max(this._minx,t.detail.dx*(this._isRTL?-1:1)));this._x=this._startx+e;var n=this._calcStep(this._calcKnobPosition(this._x/this._w*100));this._setImmediateValue(n);var i=this._calcRatio(this.immediateValue)*this._w-this._knobstartx;this.translate3d(i+"px",0,0,this.$.sliderKnob)},_trackEnd:function(){var t=this.$.sliderKnob.style;this.$.sliderKnob.classList.remove("dragging"),this._setDragging(!1),this._resetKnob(),this.value=this.immediateValue,t.transform=t.webkitTransform="",this.fire("change",{composed:!0})},_knobdown:function(t){this._expandKnob(),t.preventDefault(),this.focus()},_bartrack:function(t){this._allowBarEvent(t)&&this._onTrack(t)},_barclick:function(t){this._w=this.$.sliderBar.offsetWidth;var e=this.$.sliderBar.getBoundingClientRect(),n=(t.detail.x-e.left)/this._w*100;this._isRTL&&(n=100-n);var i=this.ratio;this._setTransiting(!0),this._positionKnob(n),i===this.ratio&&this._setTransiting(!1),this.async((function(){this.fire("change",{composed:!0})})),t.preventDefault(),this.focus()},_bardown:function(t){this._allowBarEvent(t)&&(this.debounce("expandKnob",this._expandKnob,60),this._barclick(t))},_knobTransitionEnd:function(t){t.target===this.$.sliderKnob&&this._setTransiting(!1)},_updateMarkers:function(t,e,n,i){i||this._setMarkers([]);var r=Math.round((n-e)/this.step);r>t&&(r=t),(r<0||!isFinite(r))&&(r=0),this._setMarkers(new Array(r))},_mergeClasses:function(t){return Object.keys(t).filter((function(e){return t[e]})).join(" ")},_getClassNames:function(){return this._mergeClasses({disabled:this.disabled,pin:this.pin,snaps:this.snaps,ring:this.immediateValue<=this.min,expand:this.expand,dragging:this.dragging,transiting:this.transiting,editable:this.editable})},_allowBarEvent:function(t){return!this.ignoreBarTouch||t.detail.sourceEvent instanceof MouseEvent},get _isRTL(){return void 0===this.__isRTL&&(this.__isRTL="rtl"===window.getComputedStyle(this).direction),this.__isRTL},_leftKey:function(t){this._isRTL?this._incrementKey(t):this._decrementKey(t)},_rightKey:function(t){this._isRTL?this._decrementKey(t):this._incrementKey(t)},_incrementKey:function(t){this.disabled||("end"===t.detail.key?this.value=this.max:this.increment(),this.fire("change"),t.preventDefault())},_decrementKey:function(t){this.disabled||("home"===t.detail.key?this.value=this.min:this.decrement(),this.fire("change"),t.preventDefault())},_changeValue:function(t){this.value=t.target.value,this.fire("change",{composed:!0})},_inputKeyDown:function(t){t.stopPropagation()},_createRipple:function(){return this._rippleContainer=this.$.sliderKnob,la._createRipple.call(this)},_focusedChanged:function(t){t&&this.ensureRipple(),this.hasRipple()&&(this._ripple.style.display=t?"":"none",this._ripple.holdDown=t)}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const os=document.createElement("template");os.setAttribute("style","display: none;"),os.innerHTML="<dom-module id=\"paper-spinner-styles\">\n  <template>\n    <style>\n      /*\n      /**************************/\n      /* STYLES FOR THE SPINNER */\n      /**************************/\n\n      /*\n       * Constants:\n       *      ARCSIZE     = 270 degrees (amount of circle the arc takes up)\n       *      ARCTIME     = 1333ms (time it takes to expand and contract arc)\n       *      ARCSTARTROT = 216 degrees (how much the start location of the arc\n       *                                should rotate each time, 216 gives us a\n       *                                5 pointed star shape (it's 360/5 * 3).\n       *                                For a 7 pointed star, we might do\n       *                                360/7 * 3 = 154.286)\n       *      SHRINK_TIME = 400ms\n       */\n\n      :host {\n        display: inline-block;\n        position: relative;\n        width: 28px;\n        height: 28px;\n\n        /* 360 * ARCTIME / (ARCSTARTROT + (360-ARCSIZE)) */\n        --paper-spinner-container-rotation-duration: 1568ms;\n\n        /* ARCTIME */\n        --paper-spinner-expand-contract-duration: 1333ms;\n\n        /* 4 * ARCTIME */\n        --paper-spinner-full-cycle-duration: 5332ms;\n\n        /* SHRINK_TIME */\n        --paper-spinner-cooldown-duration: 400ms;\n      }\n\n      #spinnerContainer {\n        width: 100%;\n        height: 100%;\n\n        /* The spinner does not have any contents that would have to be\n         * flipped if the direction changes. Always use ltr so that the\n         * style works out correctly in both cases. */\n        direction: ltr;\n      }\n\n      #spinnerContainer.active {\n        -webkit-animation: container-rotate var(--paper-spinner-container-rotation-duration) linear infinite;\n        animation: container-rotate var(--paper-spinner-container-rotation-duration) linear infinite;\n      }\n\n      @-webkit-keyframes container-rotate {\n        to { -webkit-transform: rotate(360deg) }\n      }\n\n      @keyframes container-rotate {\n        to { transform: rotate(360deg) }\n      }\n\n      .spinner-layer {\n        position: absolute;\n        width: 100%;\n        height: 100%;\n        opacity: 0;\n        white-space: nowrap;\n        color: var(--paper-spinner-color, var(--google-blue-500));\n      }\n\n      .layer-1 {\n        color: var(--paper-spinner-layer-1-color, var(--google-blue-500));\n      }\n\n      .layer-2 {\n        color: var(--paper-spinner-layer-2-color, var(--google-red-500));\n      }\n\n      .layer-3 {\n        color: var(--paper-spinner-layer-3-color, var(--google-yellow-500));\n      }\n\n      .layer-4 {\n        color: var(--paper-spinner-layer-4-color, var(--google-green-500));\n      }\n\n      /**\n       * IMPORTANT NOTE ABOUT CSS ANIMATION PROPERTIES (keanulee):\n       *\n       * iOS Safari (tested on iOS 8.1) does not handle animation-delay very well - it doesn't\n       * guarantee that the animation will start _exactly_ after that value. So we avoid using\n       * animation-delay and instead set custom keyframes for each color (as layer-2undant as it\n       * seems).\n       */\n      .active .spinner-layer {\n        -webkit-animation-name: fill-unfill-rotate;\n        -webkit-animation-duration: var(--paper-spinner-full-cycle-duration);\n        -webkit-animation-timing-function: cubic-bezier(0.4, 0.0, 0.2, 1);\n        -webkit-animation-iteration-count: infinite;\n        animation-name: fill-unfill-rotate;\n        animation-duration: var(--paper-spinner-full-cycle-duration);\n        animation-timing-function: cubic-bezier(0.4, 0.0, 0.2, 1);\n        animation-iteration-count: infinite;\n        opacity: 1;\n      }\n\n      .active .spinner-layer.layer-1 {\n        -webkit-animation-name: fill-unfill-rotate, layer-1-fade-in-out;\n        animation-name: fill-unfill-rotate, layer-1-fade-in-out;\n      }\n\n      .active .spinner-layer.layer-2 {\n        -webkit-animation-name: fill-unfill-rotate, layer-2-fade-in-out;\n        animation-name: fill-unfill-rotate, layer-2-fade-in-out;\n      }\n\n      .active .spinner-layer.layer-3 {\n        -webkit-animation-name: fill-unfill-rotate, layer-3-fade-in-out;\n        animation-name: fill-unfill-rotate, layer-3-fade-in-out;\n      }\n\n      .active .spinner-layer.layer-4 {\n        -webkit-animation-name: fill-unfill-rotate, layer-4-fade-in-out;\n        animation-name: fill-unfill-rotate, layer-4-fade-in-out;\n      }\n\n      @-webkit-keyframes fill-unfill-rotate {\n        12.5% { -webkit-transform: rotate(135deg) } /* 0.5 * ARCSIZE */\n        25%   { -webkit-transform: rotate(270deg) } /* 1   * ARCSIZE */\n        37.5% { -webkit-transform: rotate(405deg) } /* 1.5 * ARCSIZE */\n        50%   { -webkit-transform: rotate(540deg) } /* 2   * ARCSIZE */\n        62.5% { -webkit-transform: rotate(675deg) } /* 2.5 * ARCSIZE */\n        75%   { -webkit-transform: rotate(810deg) } /* 3   * ARCSIZE */\n        87.5% { -webkit-transform: rotate(945deg) } /* 3.5 * ARCSIZE */\n        to    { -webkit-transform: rotate(1080deg) } /* 4   * ARCSIZE */\n      }\n\n      @keyframes fill-unfill-rotate {\n        12.5% { transform: rotate(135deg) } /* 0.5 * ARCSIZE */\n        25%   { transform: rotate(270deg) } /* 1   * ARCSIZE */\n        37.5% { transform: rotate(405deg) } /* 1.5 * ARCSIZE */\n        50%   { transform: rotate(540deg) } /* 2   * ARCSIZE */\n        62.5% { transform: rotate(675deg) } /* 2.5 * ARCSIZE */\n        75%   { transform: rotate(810deg) } /* 3   * ARCSIZE */\n        87.5% { transform: rotate(945deg) } /* 3.5 * ARCSIZE */\n        to    { transform: rotate(1080deg) } /* 4   * ARCSIZE */\n      }\n\n      @-webkit-keyframes layer-1-fade-in-out {\n        0% { opacity: 1 }\n        25% { opacity: 1 }\n        26% { opacity: 0 }\n        89% { opacity: 0 }\n        90% { opacity: 1 }\n        to { opacity: 1 }\n      }\n\n      @keyframes layer-1-fade-in-out {\n        0% { opacity: 1 }\n        25% { opacity: 1 }\n        26% { opacity: 0 }\n        89% { opacity: 0 }\n        90% { opacity: 1 }\n        to { opacity: 1 }\n      }\n\n      @-webkit-keyframes layer-2-fade-in-out {\n        0% { opacity: 0 }\n        15% { opacity: 0 }\n        25% { opacity: 1 }\n        50% { opacity: 1 }\n        51% { opacity: 0 }\n        to { opacity: 0 }\n      }\n\n      @keyframes layer-2-fade-in-out {\n        0% { opacity: 0 }\n        15% { opacity: 0 }\n        25% { opacity: 1 }\n        50% { opacity: 1 }\n        51% { opacity: 0 }\n        to { opacity: 0 }\n      }\n\n      @-webkit-keyframes layer-3-fade-in-out {\n        0% { opacity: 0 }\n        40% { opacity: 0 }\n        50% { opacity: 1 }\n        75% { opacity: 1 }\n        76% { opacity: 0 }\n        to { opacity: 0 }\n      }\n\n      @keyframes layer-3-fade-in-out {\n        0% { opacity: 0 }\n        40% { opacity: 0 }\n        50% { opacity: 1 }\n        75% { opacity: 1 }\n        76% { opacity: 0 }\n        to { opacity: 0 }\n      }\n\n      @-webkit-keyframes layer-4-fade-in-out {\n        0% { opacity: 0 }\n        65% { opacity: 0 }\n        75% { opacity: 1 }\n        90% { opacity: 1 }\n        to { opacity: 0 }\n      }\n\n      @keyframes layer-4-fade-in-out {\n        0% { opacity: 0 }\n        65% { opacity: 0 }\n        75% { opacity: 1 }\n        90% { opacity: 1 }\n        to { opacity: 0 }\n      }\n\n      .circle-clipper {\n        display: inline-block;\n        position: relative;\n        width: 50%;\n        height: 100%;\n        overflow: hidden;\n      }\n\n      /**\n       * Patch the gap that appear between the two adjacent div.circle-clipper while the\n       * spinner is rotating (appears on Chrome 50, Safari 9.1.1, and Edge).\n       */\n      .spinner-layer::after {\n        content: '';\n        left: 45%;\n        width: 10%;\n        border-top-style: solid;\n      }\n\n      .spinner-layer::after,\n      .circle-clipper .circle {\n        box-sizing: border-box;\n        position: absolute;\n        top: 0;\n        border-width: var(--paper-spinner-stroke-width, 3px);\n        border-radius: 50%;\n      }\n\n      .circle-clipper .circle {\n        bottom: 0;\n        width: 200%;\n        border-style: solid;\n        border-bottom-color: transparent !important;\n      }\n\n      .circle-clipper.left .circle {\n        left: 0;\n        border-right-color: transparent !important;\n        -webkit-transform: rotate(129deg);\n        transform: rotate(129deg);\n      }\n\n      .circle-clipper.right .circle {\n        left: -100%;\n        border-left-color: transparent !important;\n        -webkit-transform: rotate(-129deg);\n        transform: rotate(-129deg);\n      }\n\n      .active .gap-patch::after,\n      .active .circle-clipper .circle {\n        -webkit-animation-duration: var(--paper-spinner-expand-contract-duration);\n        -webkit-animation-timing-function: cubic-bezier(0.4, 0.0, 0.2, 1);\n        -webkit-animation-iteration-count: infinite;\n        animation-duration: var(--paper-spinner-expand-contract-duration);\n        animation-timing-function: cubic-bezier(0.4, 0.0, 0.2, 1);\n        animation-iteration-count: infinite;\n      }\n\n      .active .circle-clipper.left .circle {\n        -webkit-animation-name: left-spin;\n        animation-name: left-spin;\n      }\n\n      .active .circle-clipper.right .circle {\n        -webkit-animation-name: right-spin;\n        animation-name: right-spin;\n      }\n\n      @-webkit-keyframes left-spin {\n        0% { -webkit-transform: rotate(130deg) }\n        50% { -webkit-transform: rotate(-5deg) }\n        to { -webkit-transform: rotate(130deg) }\n      }\n\n      @keyframes left-spin {\n        0% { transform: rotate(130deg) }\n        50% { transform: rotate(-5deg) }\n        to { transform: rotate(130deg) }\n      }\n\n      @-webkit-keyframes right-spin {\n        0% { -webkit-transform: rotate(-130deg) }\n        50% { -webkit-transform: rotate(5deg) }\n        to { -webkit-transform: rotate(-130deg) }\n      }\n\n      @keyframes right-spin {\n        0% { transform: rotate(-130deg) }\n        50% { transform: rotate(5deg) }\n        to { transform: rotate(-130deg) }\n      }\n\n      #spinnerContainer.cooldown {\n        -webkit-animation: container-rotate var(--paper-spinner-container-rotation-duration) linear infinite, fade-out var(--paper-spinner-cooldown-duration) cubic-bezier(0.4, 0.0, 0.2, 1);\n        animation: container-rotate var(--paper-spinner-container-rotation-duration) linear infinite, fade-out var(--paper-spinner-cooldown-duration) cubic-bezier(0.4, 0.0, 0.2, 1);\n      }\n\n      @-webkit-keyframes fade-out {\n        0% { opacity: 1 }\n        to { opacity: 0 }\n      }\n\n      @keyframes fade-out {\n        0% { opacity: 1 }\n        to { opacity: 0 }\n      }\n    </style>\n  </template>\n</dom-module>",document.head.appendChild(os.content);
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const as={properties:{active:{type:Boolean,value:!1,reflectToAttribute:!0,observer:"__activeChanged"},alt:{type:String,value:"loading",observer:"__altChanged"},__coolingDown:{type:Boolean,value:!1}},__computeContainerClasses:function(t,e){return[t||e?"active":"",e?"cooldown":""].join(" ")},__activeChanged:function(t,e){this.__setAriaHidden(!t),this.__coolingDown=!t&&e},__altChanged:function(t){"loading"===t?this.alt=this.getAttribute("aria-label")||t:(this.__setAriaHidden(""===t),this.setAttribute("aria-label",t))},__setAriaHidden:function(t){var e="aria-hidden";t?this.setAttribute(e,"true"):this.removeAttribute(e)},__reset:function(){this.active=!1,this.__coolingDown=!1}},ss=_e`
  <style include="paper-spinner-styles"></style>

  <div id="spinnerContainer" class-name="[[__computeContainerClasses(active, __coolingDown)]]" on-animationend="__reset" on-webkit-animation-end="__reset">
    <div class="spinner-layer">
      <div class="circle-clipper left">
        <div class="circle"></div>
      </div>
      <div class="circle-clipper right">
        <div class="circle"></div>
      </div>
    </div>
  </div>
`;
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */ss.setAttribute("strip-whitespace",""),Rr({_template:ss,is:"paper-spinner-lite",behaviors:[as]});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
const ls=_e`
  <style include="paper-spinner-styles"></style>

  <div id="spinnerContainer" class-name="[[__computeContainerClasses(active, __coolingDown)]]" on-animationend="__reset" on-webkit-animation-end="__reset">
    <div class="spinner-layer layer-1">
      <div class="circle-clipper left">
        <div class="circle"></div>
      </div>
      <div class="circle-clipper right">
        <div class="circle"></div>
      </div>
    </div>

    <div class="spinner-layer layer-2">
      <div class="circle-clipper left">
        <div class="circle"></div>
      </div>
      <div class="circle-clipper right">
        <div class="circle"></div>
      </div>
    </div>

    <div class="spinner-layer layer-3">
      <div class="circle-clipper left">
        <div class="circle"></div>
      </div>
      <div class="circle-clipper right">
        <div class="circle"></div>
      </div>
    </div>

    <div class="spinner-layer layer-4">
      <div class="circle-clipper left">
        <div class="circle"></div>
      </div>
      <div class="circle-clipper right">
        <div class="circle"></div>
      </div>
    </div>
  </div>
`;ls.setAttribute("strip-whitespace",""),Rr({_template:ls,is:"paper-spinner",behaviors:[as]});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
const cs=_e`<iron-iconset-svg name="paper-tabs" size="24">
<svg><defs>
<g id="chevron-left"><path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"></path></g>
<g id="chevron-right"><path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"></path></g>
</defs></svg>
</iron-iconset-svg>`;document.head.appendChild(cs.content),
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
Rr({_template:_e`
    <style>
      :host {
        @apply --layout-inline;
        @apply --layout-center;
        @apply --layout-center-justified;
        @apply --layout-flex-auto;

        position: relative;
        padding: 0 12px;
        overflow: hidden;
        cursor: pointer;
        vertical-align: middle;

        @apply --paper-font-common-base;
        @apply --paper-tab;
      }

      :host(:focus) {
        outline: none;
      }

      :host([link]) {
        padding: 0;
      }

      .tab-content {
        height: 100%;
        transform: translateZ(0);
          -webkit-transform: translateZ(0);
        transition: opacity 0.1s cubic-bezier(0.4, 0.0, 1, 1);
        @apply --layout-horizontal;
        @apply --layout-center-center;
        @apply --layout-flex-auto;
        @apply --paper-tab-content;
      }

      :host(:not(.iron-selected)) > .tab-content {
        opacity: 0.8;

        @apply --paper-tab-content-unselected;
      }

      :host(:focus) .tab-content {
        opacity: 1;
        font-weight: 700;

        @apply --paper-tab-content-focused;
      }

      paper-ripple {
        color: var(--paper-tab-ink, var(--paper-yellow-a100));
      }

      .tab-content > ::slotted(a) {
        @apply --layout-flex-auto;

        height: 100%;
      }
    </style>

    <div class="tab-content">
      <slot></slot>
    </div>
`,is:"paper-tab",behaviors:[qo,Xo,Jo],properties:{link:{type:Boolean,value:!1,reflectToAttribute:!0}},hostAttributes:{role:"tab"},listeners:{down:"_updateNoink",tap:"_onTap"},attached:function(){this._updateNoink()},get _parentNoink(){var t=Yi(this).parentNode;return!!t&&!!t.noink},_updateNoink:function(){this.noink=!!this.noink||!!this._parentNoink},_onTap:function(t){if(this.link){var e=this.queryEffectiveChildren("a");if(!e)return;if(t.target===e)return;e.click()}}}),
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
Rr({_template:_e`
    <style>
      :host {
        @apply --layout;
        @apply --layout-center;

        height: 48px;
        font-size: 14px;
        font-weight: 500;
        overflow: hidden;
        -moz-user-select: none;
        -ms-user-select: none;
        -webkit-user-select: none;
        user-select: none;

        /* NOTE: Both values are needed, since some phones require the value to be \`transparent\`. */
        -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
        -webkit-tap-highlight-color: transparent;

        @apply --paper-tabs;
      }

      :host(:dir(rtl)) {
        @apply --layout-horizontal-reverse;
      }

      #tabsContainer {
        position: relative;
        height: 100%;
        white-space: nowrap;
        overflow: hidden;
        @apply --layout-flex-auto;
        @apply --paper-tabs-container;
      }

      #tabsContent {
        height: 100%;
        -moz-flex-basis: auto;
        -ms-flex-basis: auto;
        flex-basis: auto;
        @apply --paper-tabs-content;
      }

      #tabsContent.scrollable {
        position: absolute;
        white-space: nowrap;
      }

      #tabsContent:not(.scrollable),
      #tabsContent.scrollable.fit-container {
        @apply --layout-horizontal;
      }

      #tabsContent.scrollable.fit-container {
        min-width: 100%;
      }

      #tabsContent.scrollable.fit-container > ::slotted(*) {
        /* IE - prevent tabs from compressing when they should scroll. */
        -ms-flex: 1 0 auto;
        -webkit-flex: 1 0 auto;
        flex: 1 0 auto;
      }

      .hidden {
        display: none;
      }

      .not-visible {
        opacity: 0;
        cursor: default;
      }

      paper-icon-button {
        width: 48px;
        height: 48px;
        padding: 12px;
        margin: 0 4px;
      }

      #selectionBar {
        position: absolute;
        height: 0;
        bottom: 0;
        left: 0;
        right: 0;
        border-bottom: 2px solid var(--paper-tabs-selection-bar-color, var(--paper-yellow-a100));
          -webkit-transform: scale(0);
        transform: scale(0);
          -webkit-transform-origin: left center;
        transform-origin: left center;
          transition: -webkit-transform;
        transition: transform;

        @apply --paper-tabs-selection-bar;
      }

      #selectionBar.align-bottom {
        top: 0;
        bottom: auto;
      }

      #selectionBar.expand {
        transition-duration: 0.15s;
        transition-timing-function: cubic-bezier(0.4, 0.0, 1, 1);
      }

      #selectionBar.contract {
        transition-duration: 0.18s;
        transition-timing-function: cubic-bezier(0.0, 0.0, 0.2, 1);
      }

      #tabsContent > ::slotted(:not(#selectionBar)) {
        height: 100%;
      }
    </style>

    <paper-icon-button icon="paper-tabs:chevron-left" class$="[[_computeScrollButtonClass(_leftHidden, scrollable, hideScrollButtons)]]" on-up="_onScrollButtonUp" on-down="_onLeftScrollButtonDown" tabindex="-1"></paper-icon-button>

    <div id="tabsContainer" on-track="_scroll" on-down="_down">
      <div id="tabsContent" class$="[[_computeTabsContentClass(scrollable, fitContainer)]]">
        <div id="selectionBar" class$="[[_computeSelectionBarClass(noBar, alignBottom)]]" on-transitionend="_onBarTransitionEnd"></div>
        <slot></slot>
      </div>
    </div>

    <paper-icon-button icon="paper-tabs:chevron-right" class$="[[_computeScrollButtonClass(_rightHidden, scrollable, hideScrollButtons)]]" on-up="_onScrollButtonUp" on-down="_onRightScrollButtonDown" tabindex="-1"></paper-icon-button>
`,is:"paper-tabs",behaviors:[go,is],properties:{noink:{type:Boolean,value:!1,observer:"_noinkChanged"},noBar:{type:Boolean,value:!1},noSlide:{type:Boolean,value:!1},scrollable:{type:Boolean,value:!1},fitContainer:{type:Boolean,value:!1},disableDrag:{type:Boolean,value:!1},hideScrollButtons:{type:Boolean,value:!1},alignBottom:{type:Boolean,value:!1},selectable:{type:String,value:"paper-tab"},autoselect:{type:Boolean,value:!1},autoselectDelay:{type:Number,value:0},_step:{type:Number,value:10},_holdDelay:{type:Number,value:1},_leftHidden:{type:Boolean,value:!1},_rightHidden:{type:Boolean,value:!1},_previousTab:{type:Object}},hostAttributes:{role:"tablist"},listeners:{"iron-resize":"_onTabSizingChanged","iron-items-changed":"_onTabSizingChanged","iron-select":"_onIronSelect","iron-deselect":"_onIronDeselect"},keyBindings:{"left:keyup right:keyup":"_onArrowKeyup"},created:function(){this._holdJob=null,this._pendingActivationItem=void 0,this._pendingActivationTimeout=void 0,this._bindDelayedActivationHandler=this._delayedActivationHandler.bind(this),this.addEventListener("blur",this._onBlurCapture.bind(this),!0)},ready:function(){this.setScrollDirection("y",this.$.tabsContainer)},detached:function(){this._cancelPendingActivation()},_noinkChanged:function(t){Yi(this).querySelectorAll("paper-tab").forEach(t?this._setNoinkAttribute:this._removeNoinkAttribute)},_setNoinkAttribute:function(t){t.setAttribute("noink","")},_removeNoinkAttribute:function(t){t.removeAttribute("noink")},_computeScrollButtonClass:function(t,e,n){return!e||n?"hidden":t?"not-visible":""},_computeTabsContentClass:function(t,e){return t?"scrollable"+(e?" fit-container":""):" fit-container"},_computeSelectionBarClass:function(t,e){return t?"hidden":e?"align-bottom":""},_onTabSizingChanged:function(){this.debounce("_onTabSizingChanged",(function(){this._scroll(),this._tabChanged(this.selectedItem)}),10)},_onIronSelect:function(t){this._tabChanged(t.detail.item,this._previousTab),this._previousTab=t.detail.item,this.cancelDebouncer("tab-changed")},_onIronDeselect:function(t){this.debounce("tab-changed",(function(){this._tabChanged(null,this._previousTab),this._previousTab=null}),1)},_activateHandler:function(){this._cancelPendingActivation(),Za._activateHandler.apply(this,arguments)},_scheduleActivation:function(t,e){this._pendingActivationItem=t,this._pendingActivationTimeout=this.async(this._bindDelayedActivationHandler,e)},_delayedActivationHandler:function(){var t=this._pendingActivationItem;this._pendingActivationItem=void 0,this._pendingActivationTimeout=void 0,t.fire(this.activateEvent,null,{bubbles:!0,cancelable:!0})},_cancelPendingActivation:function(){void 0!==this._pendingActivationTimeout&&(this.cancelAsync(this._pendingActivationTimeout),this._pendingActivationItem=void 0,this._pendingActivationTimeout=void 0)},_onArrowKeyup:function(t){this.autoselect&&this._scheduleActivation(this.focusedItem,this.autoselectDelay)},_onBlurCapture:function(t){t.target===this._pendingActivationItem&&this._cancelPendingActivation()},get _tabContainerScrollSize(){return Math.max(0,this.$.tabsContainer.scrollWidth-this.$.tabsContainer.offsetWidth)},_scroll:function(t,e){this.scrollable&&this._affectScroll(e&&-e.ddx||0)},_down:function(t){this.async((function(){this._defaultFocusAsync&&(this.cancelAsync(this._defaultFocusAsync),this._defaultFocusAsync=null)}),1)},_affectScroll:function(t){this.$.tabsContainer.scrollLeft+=t;var e=this.$.tabsContainer.scrollLeft;this._leftHidden=0===e,this._rightHidden=e===this._tabContainerScrollSize},_onLeftScrollButtonDown:function(){this._scrollToLeft(),this._holdJob=setInterval(this._scrollToLeft.bind(this),this._holdDelay)},_onRightScrollButtonDown:function(){this._scrollToRight(),this._holdJob=setInterval(this._scrollToRight.bind(this),this._holdDelay)},_onScrollButtonUp:function(){clearInterval(this._holdJob),this._holdJob=null},_scrollToLeft:function(){this._affectScroll(-this._step)},_scrollToRight:function(){this._affectScroll(this._step)},_tabChanged:function(t,e){if(!t)return this.$.selectionBar.classList.remove("expand"),this.$.selectionBar.classList.remove("contract"),void this._positionBar(0,0);var n=this.$.tabsContent.getBoundingClientRect(),i=n.width,r=t.getBoundingClientRect(),o=r.left-n.left;if(this._pos={width:this._calcPercent(r.width,i),left:this._calcPercent(o,i)},this.noSlide||null==e)return this.$.selectionBar.classList.remove("expand"),this.$.selectionBar.classList.remove("contract"),void this._positionBar(this._pos.width,this._pos.left);var a=e.getBoundingClientRect(),s=this.items.indexOf(e),l=this.items.indexOf(t);this.$.selectionBar.classList.add("expand");var c=s<l;this._isRTL&&(c=!c),c?this._positionBar(this._calcPercent(r.left+r.width-a.left,i)-5,this._left):this._positionBar(this._calcPercent(a.left+a.width-r.left,i)-5,this._calcPercent(o,i)+5),this.scrollable&&this._scrollToSelectedIfNeeded(r.width,o)},_scrollToSelectedIfNeeded:function(t,e){var n=e-this.$.tabsContainer.scrollLeft;(n<0||(n+=t-this.$.tabsContainer.offsetWidth)>0)&&(this.$.tabsContainer.scrollLeft+=n)},_calcPercent:function(t,e){return 100*t/e},_positionBar:function(t,e){e=e||0,this._width=t=t||0,this._left=e,this.transform("translateX("+e+"%) scaleX("+t/100+")",this.$.selectionBar)},_onBarTransitionEnd:function(t){var e=this.$.selectionBar.classList;e.contains("expand")?(e.remove("expand"),e.add("contract"),this._positionBar(this._pos.width,this._pos.left)):e.contains("contract")&&e.remove("contract")}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
var us=null;Rr({_template:_e`
    <style>
      :host {
        display: block;
        position: fixed;
        background-color: var(--paper-toast-background-color, #323232);
        color: var(--paper-toast-color, #f1f1f1);
        min-height: 48px;
        min-width: 288px;
        padding: 16px 24px;
        box-sizing: border-box;
        box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.26);
        border-radius: 2px;
        margin: 12px;
        font-size: 14px;
        cursor: default;
        -webkit-transition: -webkit-transform 0.3s, opacity 0.3s;
        transition: transform 0.3s, opacity 0.3s;
        opacity: 0;
        -webkit-transform: translateY(100px);
        transform: translateY(100px);
        @apply --paper-font-common-base;
      }

      :host(.capsule) {
        border-radius: 24px;
      }

      :host(.fit-bottom) {
        width: 100%;
        min-width: 0;
        border-radius: 0;
        margin: 0;
      }

      :host(.paper-toast-open) {
        opacity: 1;
        -webkit-transform: translateY(0px);
        transform: translateY(0px);
      }
    </style>

    <span id="label">{{text}}</span>
    <slot></slot>
`,is:"paper-toast",behaviors:[ka],properties:{fitInto:{type:Object,value:window,observer:"_onFitIntoChanged"},horizontalAlign:{type:String,value:"left"},verticalAlign:{type:String,value:"bottom"},duration:{type:Number,value:3e3},text:{type:String,value:""},noCancelOnOutsideClick:{type:Boolean,value:!0},noAutoFocus:{type:Boolean,value:!0}},listeners:{transitionend:"__onTransitionEnd"},get visible(){return fo._warn("`visible` is deprecated, use `opened` instead"),this.opened},get _canAutoClose(){return this.duration>0&&this.duration!==1/0},created:function(){this._autoClose=null,Oa.requestAvailability()},show:function(t){for(var e in"string"==typeof t&&(t={text:t}),t)0===e.indexOf("_")?fo._warn('The property "'+e+'" is private and was not set.'):e in this?this[e]=t[e]:fo._warn('The property "'+e+'" is not valid.');this.open()},hide:function(){this.close()},__onTransitionEnd:function(t){t&&t.target===this&&"opacity"===t.propertyName&&(this.opened?this._finishRenderOpened():this._finishRenderClosed())},_openedChanged:function(){null!==this._autoClose&&(this.cancelAsync(this._autoClose),this._autoClose=null),this.opened?(us&&us!==this&&us.close(),us=this,this.fire("iron-announce",{text:this.text}),this._canAutoClose&&(this._autoClose=this.async(this.close,this.duration))):us===this&&(us=null),Ca._openedChanged.apply(this,arguments)},_renderOpened:function(){this.classList.add("paper-toast-open")},_renderClosed:function(){this.classList.remove("paper-toast-open")},_onFitIntoChanged:function(t){this.positionTarget=t}});
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
const hs=_e`

    <style>
      :host {
        display: inline-block;
        @apply --layout-horizontal;
        @apply --layout-center;
        @apply --paper-font-common-base;
      }

      :host([disabled]) {
        pointer-events: none;
      }

      :host(:focus) {
        outline:none;
      }

      .toggle-bar {
        position: absolute;
        height: 100%;
        width: 100%;
        border-radius: 8px;
        pointer-events: none;
        opacity: 0.4;
        transition: background-color linear .08s;
        background-color: var(--paper-toggle-button-unchecked-bar-color, #000000);

        @apply --paper-toggle-button-unchecked-bar;
      }

      .toggle-button {
        position: absolute;
        top: -3px;
        left: 0;
        height: 20px;
        width: 20px;
        border-radius: 50%;
        box-shadow: 0 1px 5px 0 rgba(0, 0, 0, 0.6);
        transition: -webkit-transform linear .08s, background-color linear .08s;
        transition: transform linear .08s, background-color linear .08s;
        will-change: transform;
        background-color: var(--paper-toggle-button-unchecked-button-color, var(--paper-grey-50));

        @apply --paper-toggle-button-unchecked-button;
      }

      .toggle-button.dragging {
        -webkit-transition: none;
        transition: none;
      }

      :host([checked]:not([disabled])) .toggle-bar {
        opacity: 0.5;
        background-color: var(--paper-toggle-button-checked-bar-color, var(--primary-color));

        @apply --paper-toggle-button-checked-bar;
      }

      :host([disabled]) .toggle-bar {
        background-color: #000;
        opacity: 0.12;
      }

      :host([checked]) .toggle-button {
        -webkit-transform: translate(16px, 0);
        transform: translate(16px, 0);
      }

      :host([checked]:not([disabled])) .toggle-button {
        background-color: var(--paper-toggle-button-checked-button-color, var(--primary-color));

        @apply --paper-toggle-button-checked-button;
      }

      :host([disabled]) .toggle-button {
        background-color: #bdbdbd;
        opacity: 1;
      }

      .toggle-ink {
        position: absolute;
        top: -14px;
        left: -14px;
        right: auto;
        bottom: auto;
        width: 48px;
        height: 48px;
        opacity: 0.5;
        pointer-events: none;
        color: var(--paper-toggle-button-unchecked-ink-color, var(--primary-text-color));

        @apply --paper-toggle-button-unchecked-ink;
      }

      :host([checked]) .toggle-ink {
        color: var(--paper-toggle-button-checked-ink-color, var(--primary-color));

        @apply --paper-toggle-button-checked-ink;
      }

      .toggle-container {
        display: inline-block;
        position: relative;
        width: 36px;
        height: 14px;
        /* The toggle button has an absolute position of -3px; The extra 1px
        /* accounts for the toggle button shadow box. */
        margin: 4px 1px;
      }

      .toggle-label {
        position: relative;
        display: inline-block;
        vertical-align: middle;
        padding-left: var(--paper-toggle-button-label-spacing, 8px);
        pointer-events: none;
        color: var(--paper-toggle-button-label-color, var(--primary-text-color));
      }

      /* invalid state */
      :host([invalid]) .toggle-bar {
        background-color: var(--paper-toggle-button-invalid-bar-color, var(--error-color));
      }

      :host([invalid]) .toggle-button {
        background-color: var(--paper-toggle-button-invalid-button-color, var(--error-color));
      }

      :host([invalid]) .toggle-ink {
        color: var(--paper-toggle-button-invalid-ink-color, var(--error-color));
      }
    </style>

    <div class="toggle-container">
      <div id="toggleBar" class="toggle-bar"></div>
      <div id="toggleButton" class="toggle-button"></div>
    </div>

    <div class="toggle-label"><slot></slot></div>

  `;hs.setAttribute("strip-whitespace",""),Rr({_template:hs,is:"paper-toggle-button",behaviors:[ua],hostAttributes:{role:"button","aria-pressed":"false",tabindex:0},properties:{},listeners:{track:"_ontrack"},attached:function(){Li(this,(function(){oi(this,"pan-y")}))},_ontrack:function(t){var e=t.detail;"start"===e.state?this._trackStart(e):"track"===e.state?this._trackMove(e):"end"===e.state&&this._trackEnd(e)},_trackStart:function(t){this._width=this.$.toggleBar.offsetWidth/2,this._trackChecked=this.checked,this.$.toggleButton.classList.add("dragging")},_trackMove:function(t){var e=t.dx;this._x=Math.min(this._width,Math.max(0,this._trackChecked?this._width+e:e)),this.translate3d(this._x+"px",0,0,this.$.toggleButton),this._userActivate(this._x>this._width/2)},_trackEnd:function(t){this.$.toggleButton.classList.remove("dragging"),this.transform("",this.$.toggleButton)},_createRipple:function(){this._rippleContainer=this.$.toggleButton;var t=Jo._createRipple();return t.id="ink",t.setAttribute("recenters",""),t.classList.add("circle","toggle-ink"),t}}),
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({_template:_e`
    <style>
      :host {
        --calculated-paper-toolbar-height: var(--paper-toolbar-height, 64px);
        --calculated-paper-toolbar-sm-height: var(--paper-toolbar-sm-height, 56px);
        display: block;
        position: relative;
        box-sizing: border-box;
        -moz-box-sizing: border-box;
        height: var(--calculated-paper-toolbar-height);
        background: var(--paper-toolbar-background, var(--primary-color));
        color: var(--paper-toolbar-color, var(--dark-theme-text-color));
        @apply --paper-toolbar;
      }

      :host(.animate) {
        transition: var(--paper-toolbar-transition, height 0.18s ease-in);
      }

      :host(.medium-tall) {
        height: calc(var(--calculated-paper-toolbar-height) * 2);
        @apply --paper-toolbar-medium;
      }

      :host(.tall) {
        height: calc(var(--calculated-paper-toolbar-height) * 3);
        @apply --paper-toolbar-tall;
      }

      .toolbar-tools {
        position: relative;
        height: var(--calculated-paper-toolbar-height);
        padding: 0 16px;
        pointer-events: none;
        @apply --layout-horizontal;
        @apply --layout-center;
        @apply --paper-toolbar-content;
      }

      /*
       * TODO: Where should media query breakpoints live so they can be shared between elements?
       */

      @media (max-width: 600px) {
        :host {
          height: var(--calculated-paper-toolbar-sm-height);
        }

        :host(.medium-tall) {
          height: calc(var(--calculated-paper-toolbar-sm-height) * 2);
        }

        :host(.tall) {
          height: calc(var(--calculated-paper-toolbar-sm-height) * 3);
        }

        .toolbar-tools {
          height: var(--calculated-paper-toolbar-sm-height);
        }
      }

      #topBar {
        position: relative;
      }

      /* middle bar */
      #middleBar {
        position: absolute;
        top: 0;
        right: 0;
        left: 0;
      }

      :host(.tall) #middleBar,
      :host(.medium-tall) #middleBar {
        -webkit-transform: translateY(100%);
        transform: translateY(100%);
      }

      /* bottom bar */
      #bottomBar {
        position: absolute;
        right: 0;
        bottom: 0;
        left: 0;
      }

      /*
       * make elements (e.g. buttons) respond to mouse/touch events
       *
       * \`.toolbar-tools\` disables touch events so multiple toolbars can stack and not
       * absorb events. All children must have pointer events re-enabled to work as
       * expected.
       */
      .toolbar-tools > ::slotted(*:not([disabled])) {
        pointer-events: auto;
      }

      .toolbar-tools > ::slotted(.title) {
        @apply --paper-font-common-base;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        font-size: 20px;
        font-weight: 400;
        line-height: 1;
        pointer-events: none;
        @apply --layout-flex;
      }

      .toolbar-tools > ::slotted(.title) {
        margin-left: 56px;
      }

      .toolbar-tools > ::slotted(paper-icon-button + .title) {
        margin-left: 0;
      }

      /**
       * The --paper-toolbar-title mixin is applied here instead of above to
       * fix the issue with margin-left being ignored due to css ordering.
       */
      .toolbar-tools > ::slotted(.title) {
        @apply --paper-toolbar-title;
      }

      .toolbar-tools > ::slotted(paper-icon-button[icon=menu]) {
        margin-right: 24px;
      }

      .toolbar-tools > ::slotted(.fit) {
        position: absolute;
        top: auto;
        right: 0;
        bottom: 0;
        left: 0;
        width: auto;
        margin: 0;
      }

      /* TODO(noms): Until we have a better solution for classes that don't use
       * /deep/ create our own.
       */
      .start-justified {
        @apply --layout-start-justified;
      }

      .center-justified {
        @apply --layout-center-justified;
      }

      .end-justified {
        @apply --layout-end-justified;
      }

      .around-justified {
        @apply --layout-around-justified;
      }

      .justified {
        @apply --layout-justified;
      }
    </style>

    <div id="topBar" class\$="toolbar-tools [[_computeBarExtraClasses(justify)]]">
      <slot name="top"></slot>
    </div>

    <div id="middleBar" class\$="toolbar-tools [[_computeBarExtraClasses(middleJustify)]]">
      <slot name="middle"></slot>
    </div>

    <div id="bottomBar" class\$="toolbar-tools [[_computeBarExtraClasses(bottomJustify)]]">
      <slot name="bottom"></slot>
    </div>
`,is:"paper-toolbar",hostAttributes:{role:"toolbar"},properties:{bottomJustify:{type:String,value:""},justify:{type:String,value:""},middleJustify:{type:String,value:""}},ready:function(){console.warn(this.is,"is deprecated. Please use app-layout instead!")},attached:function(){this._observer=this._observe(this),this._updateAriaLabelledBy()},detached:function(){this._observer&&this._observer.disconnect()},_observe:function(t){var e=new MutationObserver(function(){this._updateAriaLabelledBy()}.bind(this));return e.observe(t,{childList:!0,subtree:!0}),e},_updateAriaLabelledBy:function(){Di();for(var t,e=[],n=Array.prototype.slice.call(Yi(this.root).querySelectorAll("slot")).concat(Array.prototype.slice.call(Yi(this.root).querySelectorAll("content"))),i=0;t=n[i];i++)for(var r,o=Yi(t).getDistributedNodes(),a=0;r=o[a];a++)if(r.classList&&r.classList.contains("title"))if(r.id)e.push(r.id);else{var s="paper-toolbar-label-"+Math.floor(1e4*Math.random());r.id=s,e.push(s)}e.length>0&&this.setAttribute("aria-labelledby",e.join(" "))},_computeBarExtraClasses:function(t){return t?t+("justified"===t?"":"-justified"):""}}),
/**
    @license
    Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at
    http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
    http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
    found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
    part of the polymer project is also subject to an additional IP rights grant
    found at http://polymer.github.io/PATENTS.txt
    */
Rr({_template:_e`
    <style>
      :host {
        display: block;
        position: absolute;
        outline: none;
        z-index: 1002;
        -moz-user-select: none;
        -ms-user-select: none;
        -webkit-user-select: none;
        user-select: none;
        cursor: default;
      }

      #tooltip {
        display: block;
        outline: none;
        @apply --paper-font-common-base;
        font-size: 10px;
        line-height: 1;
        background-color: var(--paper-tooltip-background, #616161);
        color: var(--paper-tooltip-text-color, white);
        padding: 8px;
        border-radius: 2px;
        @apply --paper-tooltip;
      }

      @keyframes keyFrameScaleUp {
        0% {
          transform: scale(0.0);
        }
        100% {
          transform: scale(1.0);
        }
      }

      @keyframes keyFrameScaleDown {
        0% {
          transform: scale(1.0);
        }
        100% {
          transform: scale(0.0);
        }
      }

      @keyframes keyFrameFadeInOpacity {
        0% {
          opacity: 0;
        }
        100% {
          opacity: var(--paper-tooltip-opacity, 0.9);
        }
      }

      @keyframes keyFrameFadeOutOpacity {
        0% {
          opacity: var(--paper-tooltip-opacity, 0.9);
        }
        100% {
          opacity: 0;
        }
      }

      @keyframes keyFrameSlideDownIn {
        0% {
          transform: translateY(-2000px);
          opacity: 0;
        }
        10% {
          opacity: 0.2;
        }
        100% {
          transform: translateY(0);
          opacity: var(--paper-tooltip-opacity, 0.9);
        }
      }

      @keyframes keyFrameSlideDownOut {
        0% {
          transform: translateY(0);
          opacity: var(--paper-tooltip-opacity, 0.9);
        }
        10% {
          opacity: 0.2;
        }
        100% {
          transform: translateY(-2000px);
          opacity: 0;
        }
      }

      .fade-in-animation {
        opacity: 0;
        animation-delay: var(--paper-tooltip-delay-in, 500ms);
        animation-name: keyFrameFadeInOpacity;
        animation-iteration-count: 1;
        animation-timing-function: ease-in;
        animation-duration: var(--paper-tooltip-duration-in, 500ms);
        animation-fill-mode: forwards;
        @apply --paper-tooltip-animation;
      }

      .fade-out-animation {
        opacity: var(--paper-tooltip-opacity, 0.9);
        animation-delay: var(--paper-tooltip-delay-out, 0ms);
        animation-name: keyFrameFadeOutOpacity;
        animation-iteration-count: 1;
        animation-timing-function: ease-in;
        animation-duration: var(--paper-tooltip-duration-out, 500ms);
        animation-fill-mode: forwards;
        @apply --paper-tooltip-animation;
      }

      .scale-up-animation {
        transform: scale(0);
        opacity: var(--paper-tooltip-opacity, 0.9);
        animation-delay: var(--paper-tooltip-delay-in, 500ms);
        animation-name: keyFrameScaleUp;
        animation-iteration-count: 1;
        animation-timing-function: ease-in;
        animation-duration: var(--paper-tooltip-duration-in, 500ms);
        animation-fill-mode: forwards;
        @apply --paper-tooltip-animation;
      }

      .scale-down-animation {
        transform: scale(1);
        opacity: var(--paper-tooltip-opacity, 0.9);
        animation-delay: var(--paper-tooltip-delay-out, 500ms);
        animation-name: keyFrameScaleDown;
        animation-iteration-count: 1;
        animation-timing-function: ease-in;
        animation-duration: var(--paper-tooltip-duration-out, 500ms);
        animation-fill-mode: forwards;
        @apply --paper-tooltip-animation;
      }

      .slide-down-animation {
        transform: translateY(-2000px);
        opacity: 0;
        animation-delay: var(--paper-tooltip-delay-out, 500ms);
        animation-name: keyFrameSlideDownIn;
        animation-iteration-count: 1;
        animation-timing-function: cubic-bezier(0.0, 0.0, 0.2, 1);
        animation-duration: var(--paper-tooltip-duration-out, 500ms);
        animation-fill-mode: forwards;
        @apply --paper-tooltip-animation;
      }

      .slide-down-animation-out {
        transform: translateY(0);
        opacity: var(--paper-tooltip-opacity, 0.9);
        animation-delay: var(--paper-tooltip-delay-out, 500ms);
        animation-name: keyFrameSlideDownOut;
        animation-iteration-count: 1;
        animation-timing-function: cubic-bezier(0.4, 0.0, 1, 1);
        animation-duration: var(--paper-tooltip-duration-out, 500ms);
        animation-fill-mode: forwards;
        @apply --paper-tooltip-animation;
      }

      .cancel-animation {
        animation-delay: -30s !important;
      }

      /* Thanks IE 10. */

      .hidden {
        display: none !important;
      }
    </style>

    <div id="tooltip" class="hidden">
      <slot></slot>
    </div>
`,is:"paper-tooltip",hostAttributes:{role:"tooltip",tabindex:-1},properties:{for:{type:String,observer:"_findTarget"},manualMode:{type:Boolean,value:!1,observer:"_manualModeChanged"},position:{type:String,value:"bottom"},fitToVisibleBounds:{type:Boolean,value:!1},offset:{type:Number,value:14},marginTop:{type:Number,value:14},animationDelay:{type:Number,value:500,observer:"_delayChange"},animationEntry:{type:String,value:""},animationExit:{type:String,value:""},animationConfig:{type:Object,value:function(){return{entry:[{name:"fade-in-animation",node:this,timing:{delay:0}}],exit:[{name:"fade-out-animation",node:this}]}}},_showing:{type:Boolean,value:!1}},listeners:{webkitAnimationEnd:"_onAnimationEnd"},get target(){var t=Yi(this).parentNode,e=Yi(this).getOwnerRoot();return this.for?Yi(e).querySelector("#"+this.for):t.nodeType==Node.DOCUMENT_FRAGMENT_NODE?e.host:t},attached:function(){this._findTarget()},detached:function(){this.manualMode||this._removeListeners()},playAnimation:function(t){"entry"===t?this.show():"exit"===t&&this.hide()},cancelAnimation:function(){this.$.tooltip.classList.add("cancel-animation")},show:function(){if(!this._showing){if(""===Yi(this).textContent.trim()){for(var t=!0,e=Yi(this).getEffectiveChildNodes(),n=0;n<e.length;n++)if(""!==e[n].textContent.trim()){t=!1;break}if(t)return}this._showing=!0,this.$.tooltip.classList.remove("hidden"),this.$.tooltip.classList.remove("cancel-animation"),this.$.tooltip.classList.remove(this._getAnimationType("exit")),this.updatePosition(),this._animationPlaying=!0,this.$.tooltip.classList.add(this._getAnimationType("entry"))}},hide:function(){if(this._showing){if(this._animationPlaying)return this._showing=!1,void this._cancelAnimation();this._onAnimationFinish(),this._showing=!1,this._animationPlaying=!0}},updatePosition:function(){if(this._target&&this.offsetParent){var t=this.offset;14!=this.marginTop&&14==this.offset&&(t=this.marginTop);var e,n,i=this.offsetParent.getBoundingClientRect(),r=this._target.getBoundingClientRect(),o=this.getBoundingClientRect(),a=(r.width-o.width)/2,s=(r.height-o.height)/2,l=r.left-i.left,c=r.top-i.top;switch(this.position){case"top":e=l+a,n=c-o.height-t;break;case"bottom":e=l+a,n=c+r.height+t;break;case"left":e=l-o.width-t,n=c+s;break;case"right":e=l+r.width+t,n=c+s}this.fitToVisibleBounds?(i.left+e+o.width>window.innerWidth?(this.style.right="0px",this.style.left="auto"):(this.style.left=Math.max(0,e)+"px",this.style.right="auto"),i.top+n+o.height>window.innerHeight?(this.style.bottom=i.height-c+t+"px",this.style.top="auto"):(this.style.top=Math.max(-i.top,n)+"px",this.style.bottom="auto")):(this.style.left=e+"px",this.style.top=n+"px")}},_addListeners:function(){this._target&&(this.listen(this._target,"mouseenter","show"),this.listen(this._target,"focus","show"),this.listen(this._target,"mouseleave","hide"),this.listen(this._target,"blur","hide"),this.listen(this._target,"tap","hide")),this.listen(this.$.tooltip,"animationend","_onAnimationEnd"),this.listen(this,"mouseenter","hide")},_findTarget:function(){this.manualMode||this._removeListeners(),this._target=this.target,this.manualMode||this._addListeners()},_delayChange:function(t){500!==t&&this.updateStyles({"--paper-tooltip-delay-in":t+"ms"})},_manualModeChanged:function(){this.manualMode?this._removeListeners():this._addListeners()},_cancelAnimation:function(){this.$.tooltip.classList.remove(this._getAnimationType("entry")),this.$.tooltip.classList.remove(this._getAnimationType("exit")),this.$.tooltip.classList.remove("cancel-animation"),this.$.tooltip.classList.add("hidden")},_onAnimationFinish:function(){this._showing&&(this.$.tooltip.classList.remove(this._getAnimationType("entry")),this.$.tooltip.classList.remove("cancel-animation"),this.$.tooltip.classList.add(this._getAnimationType("exit")))},_onAnimationEnd:function(){this._animationPlaying=!1,this._showing||(this.$.tooltip.classList.remove(this._getAnimationType("exit")),this.$.tooltip.classList.add("hidden"))},_getAnimationType:function(t){if("entry"===t&&""!==this.animationEntry)return this.animationEntry;if("exit"===t&&""!==this.animationExit)return this.animationExit;if(this.animationConfig[t]&&"string"==typeof this.animationConfig[t][0].name){if(this.animationConfig[t][0].timing&&this.animationConfig[t][0].timing.delay&&0!==this.animationConfig[t][0].timing.delay){var e=this.animationConfig[t][0].timing.delay;"entry"===t?this.updateStyles({"--paper-tooltip-delay-in":e+"ms"}):"exit"===t&&this.updateStyles({"--paper-tooltip-delay-out":e+"ms"})}return this.animationConfig[t][0].name}},_removeListeners:function(){this._target&&(this.unlisten(this._target,"mouseenter","show"),this.unlisten(this._target,"focus","show"),this.unlisten(this._target,"mouseleave","hide"),this.unlisten(this._target,"blur","hide"),this.unlisten(this._target,"tap","hide")),this.unlisten(this.$.tooltip,"animationend","_onAnimationEnd"),this.unlisten(this,"mouseenter","hide")}});class ds{constructor(t){this.listener=t}}const ps=new Set,fs=new Set;function ms(t){const e=new ds(t);return ps.add(e),e}function gs(t){const e=new ds(t);return fs.add(e),e}function _s(){fs.forEach((t=>t.listener()))}function ys(t){ps.delete(t)}function vs(t){fs.delete(t)}window.addEventListener("hashchange",(()=>{ps.forEach((t=>t.listener()))})),window.addEventListener("storage",(()=>{fs.forEach((t=>t.listener()))}));let bs=!1;function xs(){return bs}let ws="";function Ss(t){ws=t}function Ms(){return ws}var Es=Object.freeze({__proto__:null,setUseHash:function Ts(t){bs=t},useHash:xs,setFakeHash:Ss,getFakeHash:Ms});let Cs={};function As(){return xs()?window.location.hash.slice(1):Ms()}function ks(t){const e={};return t.split("&").forEach((t=>{const n=t.split("=");1===n.length?e.__tab__=n[0]:2===n.length&&(e[decodeURIComponent(n[0])]=decodeURIComponent(n[1]))})),e}function Ls(t,e=!1){if(xs())if(e){const e=new URL(window.location.href);e.hash=t,window.history.replaceState(null,"",e.toString())}else window.location.hash=t;else Ss(t)}function Ps(t){let e="";void 0!==t.__tab__&&(e+=t.__tab__);const n=Object.keys(t).map((e=>[e,t[e]])).filter((t=>"__tab__"!==t[0])).map((t=>encodeURIComponent(t[0])+"="+encodeURIComponent(t[1]))).join("&");return n.length>0?e+"&"+n:e}ms((()=>{Cs=ks(As())}));const{get:Ns,set:Is,getInitializer:Rs,getObserver:Os,disposeBinding:zs}=Js((t=>t),(t=>t)),{get:Ds,set:Bs,getInitializer:Hs,getObserver:Fs,disposeBinding:Vs}=Js((t=>"true"===t||"false"!==t&&void 0),(t=>t.toString())),{get:Us,set:js,getInitializer:Gs,getObserver:Ws,disposeBinding:qs}=Js((t=>+t),(t=>t.toString())),{get:Ys,set:Xs,getInitializer:$s,getObserver:Ks,disposeBinding:Zs}=Js((t=>JSON.parse(atob(t))),(t=>btoa(JSON.stringify(t))));function Js(t,e){const n=[],i=[];function r(e,n={}){const{defaultValue:i,useLocalStorage:r=!1}=n,o=r?window.localStorage.getItem(e):ks(As())[e];return null==o?Se.exports.cloneDeep(i):t(o)}function o(t,n,i={}){const{defaultValue:o,useLocalStorage:a=!1,useLocationReplace:s=!1}=i,l=e(n);if(a)window.localStorage.setItem(t,l),_s();else if(!Se.exports.isEqual(n,r(t,{useLocalStorage:a})))if(Se.exports.isEqual(n,o))!(function c(t){const e=ks(As());delete e[t],Ls(Ps(e))})(t);else{const e=ks(As());e[t]=l,Ls(Ps(e),s)}}return{get:r,set:o,getInitializer:function a(t,e){const o=Object.assign({defaultValue:e.defaultValue,polymerProperty:t,useLocalStorage:!1},e);return function(){const e=Qs(this,t),a=()=>{const t=r(e,o);Se.exports.isEqual(t,this[o.polymerProperty])||(this[o.polymerProperty]=t)},s=(o.useLocalStorage?gs:ms)((()=>a()));return o.useLocalStorage?i.push(s):n.push(s),a(),this[o.polymerProperty]}},getObserver:function s(t,e){const n=Object.assign({defaultValue:e.defaultValue,polymerProperty:t,useLocalStorage:!1},e);return function(){o(Qs(this,t),this[n.polymerProperty],n)}},disposeBinding:function l(){n.forEach((t=>ys(t))),i.forEach((t=>vs(t)))}}}function Qs(t,e){const n=t.disambiguator;return(null==n?[e]:[n,e]).join(".")}let tl=class extends ye{constructor(){super(...arguments),this._tagFilter=Rs("tagFilter",{defaultValue:"",useLocalStorage:!1,polymerProperty:"_tagFilter"}).call(this),this._tagFilterObserver=Os("tagFilter",{defaultValue:"",useLocalStorage:!1,polymerProperty:"_tagFilter"})}_computeTagFilter(){return this._tagFilter}};function el(t){const{moduleName:e,styleContent:n}=t,i=document.createElement("dom-module"),r=document.createElement("template"),o=[];t.styleDependencies&&t.styleDependencies.forEach((t=>{const e=document.createElement("style");e.setAttribute("include",t),o.push(e)}));const a=document.createElement("style");Object.assign(a,{textContent:n}),o.forEach((t=>{r.content.appendChild(t)})),r.content.appendChild(a),i.appendChild(r),i.register(e)}tl.template=_e`
    <paper-input
      no-label-float=""
      label="Filter tags (regular expressions supported)"
      value="{{_tagFilter}}"
      class="search-input"
    >
      <iron-icon prefix="" icon="search" slot="prefix"></iron-icon>
    </paper-input>
    <style>
      :host {
        display: block;
        margin: 10px 5px 10px 10px;
      }
    </style>
  `,t([o({type:String,notify:!0,computed:"_computeTagFilter(_tagFilter)"}),e("design:type",String)],tl.prototype,"tagFilter",void 0),t([o({type:String,observer:"_tagFilterObserver"}),e("design:type",String)],tl.prototype,"_tagFilter",void 0),tl=t([i("tf-tag-filterer")],tl),el({moduleName:"dashboard-style",styleDependencies:["iron-flex"],styleContent:"\n      :host {\n        --sidebar-vertical-padding: 15px;\n        --sidebar-left-padding: 30px;\n      }\n\n      [slot='sidebar'] {\n        box-sizing: border-box;\n        display: flex;\n        flex-direction: column;\n        height: 100%;\n        margin-right: 10px;\n        overflow-x: hidden;\n        padding: 5px 0;\n        text-overflow: ellipsis;\n      }\n\n      .settings {\n        min-height: 50px;\n        overflow-x: hidden;\n        overflow-y: auto;\n        will-change: transform;\n      }\n\n      .runs-selector {\n        display: flex;\n        flex-grow: 1;\n        min-height: 200px;\n      }\n\n      tf-runs-selector {\n        flex-grow: 1;\n        flex-shrink: 1;\n        left: var(--sidebar-left-padding);\n        max-height: calc(100% - var(--sidebar-vertical-padding) * 2);\n        overflow: hidden;\n        position: absolute;\n        right: 0;\n      }\n\n      .search-input {\n        margin: 10px 5px 0 10px;\n      }\n\n      .sidebar-section {\n        border-top: solid 1px var(--tb-ui-border);\n        margin-right: 10px;\n        padding: var(--sidebar-vertical-padding) 0\n          var(--sidebar-vertical-padding) var(--sidebar-left-padding);\n        position: relative;\n        overflow: hidden;\n      }\n\n      .sidebar-section:first-of-type {\n        border: none;\n      }\n\n      .sidebar-section paper-button {\n        margin: 5px;\n      }\n\n      .sidebar-section paper-button:first-of-type {\n        margin-left: 0 !important;\n      }\n\n      .sidebar-section paper-button:last-of-type {\n        margin-right: 0 !important;\n      }\n\n      .sidebar-section > :first-child {\n        margin-top: 0;\n        padding-top: 0;\n      }\n\n      .sidebar-section > :last-child {\n        margin-bottom: 0;\n        padding-bottom: 0;\n      }\n\n      .sidebar-section h3 {\n        color: var(--tb-secondary-text-color);\n        display: block;\n        font-size: 14px;\n        font-weight: normal;\n        margin: 10px 0 5px;\n        pointer-events: none;\n      }\n\n      paper-checkbox {\n        --paper-checkbox-checked-color: var(--tb-ui-dark-accent);\n        --paper-checkbox-unchecked-color: var(--tb-ui-dark-accent);\n        font-size: 15px;\n        margin-top: 5px;\n      }\n\n      a {\n        color: var(--tb-link);\n      }\n\n      a:visited {\n        color: var(--tb-link-visited);\n      }\n  "});const nl=document.createElement("style");function il(t){return class extends t{connectedCallback(){super.connectedCallback(),this._maybeSetDarkMode(),this.observer=new MutationObserver((t=>{t.some((t=>"class"===t.attributeName))&&this._maybeSetDarkMode()})),this.observer.observe(document.body,{attributes:!0})}disconnectedCallback(){var t;super.disconnectedCallback(),null===(t=this.observer)||void 0===t||t.disconnect()}_maybeSetDarkMode(){this.classList.toggle("dark-mode",document.body.classList.contains("dark-mode"))}}}nl.setAttribute("is","custom-style"),nl.textContent="\n  :root {\n    --tb-orange-weak: #ffa726;\n    --tb-orange-strong: #f57c00;\n    --tb-orange-dark: #dc7320;\n    --tb-grey-darker: #e2e2e2;\n    --tb-grey-lighter: #f3f3f3;\n    --tb-ui-dark-accent: #757575;\n    --tb-ui-light-accent: #e0e0e0;\n    --tb-ui-border: var(--paper-grey-300);\n    --tb-graph-faded: #e0d4b3;\n    --tb-secondary-text-color: var(--paper-grey-800);\n    --tb-raised-button-shadow-color: rgba(0, 0, 0, 0.2);\n    --primary-background-color: #fff;\n    --secondary-background-color: #e9e9e9;\n    --tb-layout-background-color: #f5f5f5;\n    --tb-link: #1976d2; /* material blue 700. */\n    --tb-link-visited: #7b1fa2; /* material purple 700. */\n  }\n\n  :root .dark-mode {\n    --tb-ui-border: var(--paper-grey-700);\n    --tb-ui-dark-accent: var(--paper-grey-400);\n    --tb-ui-light-accent: var(--paper-grey-600);\n    --tb-secondary-text-color: var(--paper-grey-400);\n    --tb-raised-button-shadow-color: rgba(255, 255, 255, 0.5);\n    --primary-text-color: #fff;\n    --secondary-text-color: var(--paper-grey-400);\n    --primary-background-color: #303030;  /* material grey A400. */\n    --secondary-background-color: #3a3a3a;\n    --tb-layout-background-color: #3a3a3a;\n    --tb-link: #42a5f5; /* material blue 400. */\n    --tb-link-visited: #ba68c8; /* material purple 300. */\n    /* Overrides paper-material */\n    --shadow-elevation-2dp_-_box-shadow: 0 2px 2px 0 rgba(255, 255, 255, 0.14),\n      0 1px 5px 0 rgba(255, 255, 255, 0.12),\n      0 3px 1px -2px rgba(255, 255, 255, 0.2);\n  }\n",document.head.appendChild(nl),el({moduleName:"scrollbar-style",styleContent:"\n    .scrollbar::-webkit-scrollbar-track {\n      visibility: hidden;\n    }\n\n    .scrollbar::-webkit-scrollbar {\n      width: 10px;\n    }\n\n    .scrollbar::-webkit-scrollbar-thumb {\n      border-radius: 10px;\n      -webkit-box-shadow: inset 0 0 2px rgba(0, 0, 0, 0.3);\n      background-color: var(--paper-grey-500);\n      color: var(--paper-grey-900);\n    }\n    .scrollbar {\n      box-sizing: border-box;\n    }\n  "});let rl=class extends(il(ye)){};rl.template=_e`
    <div id="sidebar">
      <slot name="sidebar"></slot>
    </div>

    <div id="center">
      <slot name="center" class="scollbar"></slot>
    </div>
    <style include="scrollbar-style"></style>
    <style>
      :host {
        background-color: #f5f5f5;
        display: flex;
        flex-direction: row;
        height: 100%;
      }

      :host(.dark-mode) {
        background-color: var(--secondary-background-color);
      }

      #sidebar {
        flex: 0 0 var(--tf-dashboard-layout-sidebar-basis, 25%);
        height: 100%;
        max-width: var(--tf-dashboard-layout-sidebar-max-width, 350px);
        min-width: var(--tf-dashboard-layout-sidebar-min-width, 270px);
        overflow-y: auto;
        text-overflow: ellipsis;
      }

      #center {
        flex-grow: 1;
        flex-shrink: 1;
        height: 100%;
        overflow: hidden;
      }

      ::slotted([slot='center']) {
        contain: strict;
        height: 100%;
        overflow-x: hidden;
        overflow-y: auto;
        width: 100%;
        will-change: transform;
      }

      .tf-graph-dashboard #center {
        background: #fff;
      }
    </style>
  `,rl=t([i("tf-dashboard-layout")],rl);const ol="TF.TensorBoard.PaginatedView.limit";let al=null;const sl=new Set;function ll(t){sl.add(t)}function cl(t){sl.delete(t)}function ul(){return null==al&&(al=Us(ol,{useLocalStorage:!0}),(null==al||!isFinite(al)||al<=0)&&(al=12)),al}class hl extends ye{updateArrayProp(t,e,n){let i=this.get(t);const r=e;if(!Array.isArray(r))throw RangeError(`Expected new value to '${t}' to be an array.`);Array.isArray(i)||(i=[],this.set(t,i));const o=new Set(r.map(((t,e)=>n(t,e))));let a=0,s=0;for(;a<i.length&&s<r.length;)o.has(n(i[a],a))?(n(i[a],a)==n(r[s],s)?this.set(`${t}.${a}`,r[s]):this.splice(t,a,0,r[s]),s++,a++):this.splice(t,a,1);a<i.length&&this.splice(t,a),s<r.length&&this.push(t,...r.slice(s))}}class dl extends hl{constructor(){super(...arguments),this.as="item",this._contentActive=!0,this._domBootstrapped=!1,this._ctor=null,this._renderedItems=[],this._renderedTemplateInst=new Map,this._lruCachedItems=new Map,this._cacheSize=10,this._getItemKey=t=>JSON.stringify(t),this._isConnected=!1}connectedCallback(){super.connectedCallback(),this._isConnected=!0}setCacheSize(t){this._cacheSize=t}setGetItemKey(t){this._getItemKey=t}updateDom(t){this.updateArrayProp("_renderedItems",t,this._getItemKey)}_ensureTemplatized(){if(!this.isConnected)return!1;if(!this._ctor){const t=this.querySelector("template");this._ctor=$r(t,this,{parentModel:!0,instanceProps:{[this.as]:!0,active:this._contentActive},forwardHostProp:function(t,e){this._renderedTemplateInst.forEach((n=>{n.forwardHostProp(t,e)}))}})}return!0}_bootstrapDom(){this._ensureTemplatized()&&!this._domBootstrapped&&(new MutationObserver((t=>{for(const e of t)if("childList"===e.type)for(const t of Array.from(e.addedNodes))t instanceof Element&&t.setAttribute("slot","items")})).observe(this,{childList:!0}),Array.from(this.children).forEach((t=>{this.removeChild(t)})),this._lruCachedItems.clear(),this._renderedItems.forEach(((t,e)=>this._insertItem(t,e))),this._domBootstrapped=!0)}_updateActive(){this._domBootstrapped&&Array.from(this._renderedTemplateInst.values()).forEach((t=>{t.notifyPath("active",this._contentActive)}))}_updateDom(t){if(this._domBootstrapped&&"_renderedItems"!=t.path&&"_renderedItems.length"!=t.path)if("_renderedItems.splices"===t.path)t.value.indexSplices.forEach((t=>{const{index:e,addedCount:n,object:i,removed:r}=t;r.forEach((t=>{this._removeItem(t,this.children[e])})),i.slice(e,e+n).forEach(((t,n)=>this._insertItem(t,e+n))),this._trimCache()}));else{const e=this._getItemKey(t.value);this._renderedTemplateInst.has(e)?this._renderedTemplateInst.get(e).notifyPath(this.as,t.value):console.warn(`Expected '${e}' to exist in the DOM but could not find one.`)}}_insertItem(t,e){if(!this._ensureTemplatized())throw new Error("Expected templatized before inserting an item");let n;const i=this._getItemKey(t);if(this._lruCachedItems.has(i))n=this._lruCachedItems.get(i),this._lruCachedItems.delete(i),this._renderedTemplateInst.get(i).notifyPath("active",this._contentActive);else{const e=new this._ctor({[this.as]:t,active:this._contentActive});n=e.root,this._renderedTemplateInst.set(i,e)}this.children[e]?this.insertBefore(n,this.children[e]):((n.nodeType==Node.DOCUMENT_FRAGMENT_NODE?Array.from(n.children):[n]).forEach((t=>t.setAttribute("slot","items"))),this.appendChild(n))}_removeItem(t,e){e.parentNode&&e.parentNode.removeChild(e);const n=this._getItemKey(t);this._lruCachedItems.set(n,e),this._renderedTemplateInst.get(n).notifyPath("active",!1)}_trimCache(){for(;this._lruCachedItems.size>this._cacheSize;){const[t]=this._lruCachedItems.keys();this._lruCachedItems.delete(t),this._renderedTemplateInst.delete(t)}}}t([o({type:String}),e("design:type",Object)],dl.prototype,"as",void 0),t([o({type:Array}),e("design:type",Array)],dl.prototype,"items",void 0),t([o({type:Boolean}),e("design:type",Boolean)],dl.prototype,"_contentActive",void 0),t([o({type:Boolean}),e("design:type",Object)],dl.prototype,"_domBootstrapped",void 0),t([o({type:Object}),e("design:type",Object)],dl.prototype,"_ctor",void 0),t([o({type:Array}),e("design:type",Array)],dl.prototype,"_renderedItems",void 0),t([o({type:Object}),e("design:type",Object)],dl.prototype,"_renderedTemplateInst",void 0),t([o({type:Object}),e("design:type",Object)],dl.prototype,"_lruCachedItems",void 0),t([o({type:Number}),e("design:type",Object)],dl.prototype,"_cacheSize",void 0),t([o({type:Object}),e("design:type",Object)],dl.prototype,"_getItemKey",void 0),t([o({type:Boolean}),e("design:type",Object)],dl.prototype,"_isConnected",void 0),t([a("_isConnected"),e("design:type",Function),e("design:paramtypes",[]),e("design:returntype",void 0)],dl.prototype,"_bootstrapDom",null),t([a("_contentActive"),e("design:type",Function),e("design:paramtypes",[]),e("design:returntype",void 0)],dl.prototype,"_updateActive",null),t([a("_renderedItems.*","_domBootstrapped"),e("design:type",Function),e("design:paramtypes",[Object]),e("design:returntype",void 0)],dl.prototype,"_updateDom",null),t([a("_cacheSize"),e("design:type",Function),e("design:paramtypes",[]),e("design:returntype",void 0)],dl.prototype,"_trimCache",null);let pl=class extends dl{constructor(){super(...arguments),this.disablePagination=!1,this.getCategoryItemKey=t=>JSON.stringify(t),this._limit=12,this._activeIndex=0,this._pageInputRawValue="",this._pageInputFocused=!1}_computeCount(){return this.category.items.length}get _hasMultiple(){return this._count>1}_togglePane(){this.opened=!this.opened}_changeContentActive(t){this._contentActive=t}_onPaneRenderedChanged(t,e){t&&t!==e&&this.$.ifRendered.render()}_computePaneRendered(t){return!(t.metadata.type===br.SEARCH_RESULTS&&""===t.name)}get _itemsRendered(){return this._paneRendered&&this.opened}_computeIsSearchResults(t){return t===br.SEARCH_RESULTS}_computeIsInvalidSearchResults(t){return t.type===br.SEARCH_RESULTS&&!t.validRegex}_computeIsUniversalSearchQuery(t){return t.type===br.SEARCH_RESULTS&&t.universalRegex}_isCompositeSearch(){const{type:t,compositeSearch:e}=this.category.metadata;return e&&t===br.SEARCH_RESULTS}ready(){super.ready(),this.opened=null==this.initialOpened||this.initialOpened,this._limitListener=()=>{this.set("_limit",ul())},ll(this._limitListener),this._limitListener()}detached(){cl(this._limitListener)}_updateRenderedItems(){var t=this._limit,e=this.disablePagination;if(!this._itemsRendered)return;const n=Math.floor(this._activeIndex/t),i=this.category.items||[],r=e?i:i.slice(n*t,(n+1)*t);this.updateDom(r)}_limitChanged(t){this.setCacheSize(2*t)}_getCategoryItemKeyChanged(){this.setGetItemKey(this.getCategoryItemKey)}get _currentPage(){return Math.floor(this._activeIndex/this._limit)+1}_computePageCount(t,e){return this.category?Math.ceil(this.category.items.length/e):0}get _multiplePagesExist(){return!this.disablePagination&&this._pageCount>1}get _hasPreviousPage(){return this._currentPage>1}get _hasNextPage(){return this._currentPage<this._pageCount}_computeInputWidth(t){return`calc(${t.toString().length}em + 20px)`}_setActiveIndex(t){const e=(this.category.items||[]).length-1;t>e&&(t=e),t<0&&(t=0),this.set("_activeIndex",t)}_clampActiveIndex(){this._setActiveIndex(this._activeIndex)}_performPreviousPage(){this._setActiveIndex(this._activeIndex-this._limit)}_performNextPage(){this._setActiveIndex(this._activeIndex+this._limit)}_computePageInputValue(t,e,n){return t?e:n.toString()}_handlePageInputEvent(t){this.set("_pageInputRawValue",t.target.value);const e=Number(t.target.value||NaN);if(isNaN(e))return;const n=Math.max(1,Math.min(e,this._pageCount))-1;this._setActiveIndex(this._limit*n)}_handlePageChangeEvent(){this.set("_pageInputRawValue",this._currentPage.toString())}_handlePageFocusEvent(){this.set("_pageInputRawValue",this._pageInputValue),this.set("_pageInputFocused",!0)}_handlePageBlurEvent(){this.set("_pageInputFocused",!1)}_updatePageInputValue(t){const e=this.shadowRoot.querySelector("#page-input input");e&&(e.value=t)}_updateInputWidth(){this.updateStyles({"--tf-category-paginated-view-page-input-width":this._inputWidth})}};pl.template=_e`
    <template is="dom-if" if="[[_paneRendered]]" id="ifRendered">
      <button class="heading" on-tap="_togglePane" open-button$="[[opened]]">
        <span class="name">
          <template is="dom-if" if="[[_isSearchResults]]">
            <template is="dom-if" if="[[_isCompositeSearch(category)]]">
              <span>Tags matching multiple experiments</span>
              <template is="dom-if" if="[[_isInvalidSearchResults]]">
                <span
                  >&nbsp;<strong>(malformed regular expression)</strong></span
                >
              </template>
            </template>
            <template is="dom-if" if="[[!_isCompositeSearch(category)]]">
              <span class="light">Tags matching /</span>
              <span class="category-name" title$="[[category.name]]"
                >[[category.name]]</span
              >
              <span class="light">/</span>
              <template is="dom-if" if="[[_isUniversalSearchQuery]]">
                <span> (all tags)</span>
              </template>
              <template is="dom-if" if="[[_isInvalidSearchResults]]">
                <span> <strong>(malformed regular expression)</strong></span>
              </template>
            </template>
          </template>
          <template is="dom-if" if="[[!_isSearchResults]]">
            <span class="category-name" title$="[[category.name]]"
              >[[category.name]]</span
            >
          </template>
        </span>
        <span class="count">
          <template is="dom-if" if="[[_hasMultiple]]">
            <span>[[_count]]</span>
          </template>
          <iron-icon icon="expand-more" class="expand-arrow"></iron-icon>
        </span>
      </button>
      <!-- TODO(stephanwlee): investigate further. For some reason,
        transitionend that the iron-collapse relies on sometimes does not
        trigger when rendering a chart with a spinner. A toy example cannot
        reproduce this bug. -->
      <iron-collapse opened="[[opened]]" no-animation="">
        <div class="content">
          <span id="top-of-container"></span>
          <template is="dom-if" if="[[_multiplePagesExist]]">
            <div class="big-page-buttons" style="margin-bottom: 10px;">
              <paper-button
                on-tap="_performPreviousPage"
                disabled$="[[!_hasPreviousPage]]"
                >Previous page</paper-button
              >
              <paper-button
                on-tap="_performNextPage"
                disabled$="[[!_hasNextPage]]"
                >Next page</paper-button
              >
            </div>
          </template>

          <div id="items">
            <slot name="items"></slot>
          </div>
          <template is="dom-if" if="[[_multiplePagesExist]]">
            <div id="controls-container">
              <div style="display: inline-block; padding: 0 5px">
                Page
                <paper-input
                  id="page-input"
                  type="number"
                  no-label-float=""
                  min="1"
                  max="[[_pageCount]]"
                  value="[[_pageInputValue]]"
                  on-input="_handlePageInputEvent"
                  on-change="_handlePageChangeEvent"
                  on-focus="_handlePageFocusEvent"
                  on-blur="_handlePageBlurEvent"
                ></paper-input>
                of [[_pageCount]]
              </div>
            </div>

            <div class="big-page-buttons" style="margin-top: 10px;">
              <paper-button
                on-tap="_performPreviousPage"
                disabled$="[[!_hasPreviousPage]]"
                >Previous page</paper-button
              >
              <paper-button
                on-tap="_performNextPage"
                disabled$="[[!_hasNextPage]]"
                >Next page</paper-button
              >
            </div>
          </template>
        </div>
      </iron-collapse>
    </template>
    <style>
      :host {
        display: block;
        margin: 0 5px 1px 10px;
      }

      :host(:first-of-type) {
        margin-top: 10px;
      }

      :host(:last-of-type) {
        margin-bottom: 20px;
      }

      .heading {
        background-color: var(--primary-background-color);
        border: none;
        color: inherit;
        cursor: pointer;
        width: 100%;
        font-size: 15px;
        line-height: 1;
        box-shadow: 0 1px 5px var(--tb-raised-button-shadow-color);
        padding: 10px 15px;
        display: flex;
        align-items: center;
        justify-content: space-between;
      }

      .heading::-moz-focus-inner {
        padding: 10px 15px;
      }

      [open-button] {
        border-bottom-left-radius: 0 !important;
        border-bottom-right-radius: 0 !important;
      }

      [open-button] .expand-arrow {
        transform: rotateZ(180deg);
      }

      .name {
        display: inline-flex;
        overflow: hidden;
      }

      .light {
        color: var(--paper-grey-500);
      }

      .category-name {
        white-space: pre;
        overflow: hidden;
        text-overflow: ellipsis;
        padding: 2px 0;
      }

      .count {
        margin: 0 5px;
        font-size: 12px;
        color: var(--paper-grey-500);
        display: flex;
        align-items: center;
        flex: none;
      }

      .heading::-moz-focus-inner {
        padding: 10px 15px;
      }

      .content {
        display: flex;
        flex-direction: column;
        background-color: var(--primary-background-color);
        border-bottom-left-radius: 2px;
        border-bottom-right-radius: 2px;
        border-top: none;
        border: 1px solid #dedede;
        padding: 15px;
      }

      .light {
        color: var(--paper-grey-500);
      }

      #controls-container {
        justify-content: center;
        display: flex;
        flex-direction: row;
        flex-grow: 0;
        flex-shrink: 0;
        width: 100%;
      }

      #controls-container paper-button {
        display: inline-block;
      }

      .big-page-buttons {
        display: flex;
      }

      .big-page-buttons paper-button {
        background-color: var(--tb-ui-light-accent);
        color: var(--tb-ui-dark-accent);
        display: inline-block;
        flex-basis: 0;
        flex-grow: 1;
        flex-shrink: 1;
        font-size: 13px;
      }

      .big-page-buttons paper-button[disabled] {
        background: none;
      }

      slot {
        display: flex;
        flex-direction: row;
        flex-wrap: wrap;
      }

      ::slotted([slot='items']) {
        /* Tooltip for descriptions and others break with more strict ones. */
        contain: style;
      }

      #page-input {
        display: inline-block;
        width: var(--tf-category-paginated-view-page-input-width, 100%);
      }
    </style>
  `,t([o({type:Object}),e("design:type",Object)],pl.prototype,"category",void 0),t([o({type:Boolean}),e("design:type",Boolean)],pl.prototype,"initialOpened",void 0),t([o({type:Boolean,notify:!0}),e("design:type",Boolean)],pl.prototype,"opened",void 0),t([o({type:Boolean}),e("design:type",Boolean)],pl.prototype,"disablePagination",void 0),t([o({type:Number,computed:"_computeCount(category.items.*)"}),e("design:type",Number)],pl.prototype,"_count",void 0),t([o({type:Boolean,computed:"_computePaneRendered(category)",observer:"_onPaneRenderedChanged"}),e("design:type",Boolean)],pl.prototype,"_paneRendered",void 0),t([o({type:Boolean,computed:"_computeIsSearchResults(category.metadata.type)"}),e("design:type",Boolean)],pl.prototype,"_isSearchResults",void 0),t([o({type:Boolean,computed:"_computeIsInvalidSearchResults(category.metadata)"}),e("design:type",Boolean)],pl.prototype,"_isInvalidSearchResults",void 0),t([o({type:Boolean,computed:"_computeIsUniversalSearchQuery(category.metadata)"}),e("design:type",Boolean)],pl.prototype,"_isUniversalSearchQuery",void 0),t([o({type:Object,observer:"_getCategoryItemKeyChanged"}),e("design:type",Object)],pl.prototype,"getCategoryItemKey",void 0),t([o({type:Number,observer:"_limitChanged"}),e("design:type",Number)],pl.prototype,"_limit",void 0),t([o({type:Number}),e("design:type",Number)],pl.prototype,"_activeIndex",void 0),t([o({type:Number,computed:"_computePageCount(category.items.*, _limit)"}),e("design:type",Number)],pl.prototype,"_pageCount",void 0),t([o({type:String,computed:"_computeInputWidth(_pageCount)",observer:"_updateInputWidth"}),e("design:type",String)],pl.prototype,"_inputWidth",void 0),t([o({type:String,computed:"_computePageInputValue(_pageInputFocused, _pageInputRawValue, _currentPage)",observer:"_updatePageInputValue"}),e("design:type",String)],pl.prototype,"_pageInputValue",void 0),t([o({type:String}),e("design:type",String)],pl.prototype,"_pageInputRawValue",void 0),t([o({type:Boolean}),e("design:type",Boolean)],pl.prototype,"_pageInputFocused",void 0),t([s("_count"),e("design:type",Boolean),e("design:paramtypes",[])],pl.prototype,"_hasMultiple",null),t([a("opened"),e("design:type",Function),e("design:paramtypes",[Boolean]),e("design:returntype",void 0)],pl.prototype,"_changeContentActive",null),t([s("opened","_paneRendered"),e("design:type",Boolean),e("design:paramtypes",[])],pl.prototype,"_itemsRendered",null),t([a("_itemsRendered","category.items.*","_limit","_activeIndex","_pageCount","disablePagination"),e("design:type",Function),e("design:paramtypes",[]),e("design:returntype",void 0)],pl.prototype,"_updateRenderedItems",null),t([s("_limit","_activeIndex"),e("design:type",Number),e("design:paramtypes",[])],pl.prototype,"_currentPage",null),t([s("_pageCount","disablePagination"),e("design:type",Boolean),e("design:paramtypes",[])],pl.prototype,"_multiplePagesExist",null),t([s("_currentPage"),e("design:type",Boolean),e("design:paramtypes",[])],pl.prototype,"_hasPreviousPage",null),t([s("_currentPage","_pageCount"),e("design:type",Boolean),e("design:paramtypes",[])],pl.prototype,"_hasNextPage",null),t([a("category.items.*"),e("design:type",Function),e("design:paramtypes",[]),e("design:returntype",void 0)],pl.prototype,"_clampActiveIndex",null),pl=t([i("tf-category-paginated-view")],pl);class fl{constructor(t){this.listener=t}}class ml{constructor(){this.requestManager=new dr(1),this._listeners=new Set,this.initialized=!1}refresh(){return this.load().then((()=>{this.initialized=!0}))}addListener(t){const e=new fl(t);return this._listeners.add(e),e}removeListenerByKey(t){this._listeners.delete(t)}emitChange(){this._listeners.forEach((t=>{try{t.listener()}catch(t){}}))}}class gl extends ml{load(){const t=_r().environment();return this.requestManager.request(t).then((t=>{const e={dataLocation:t.data_location,windowTitle:t.window_title};void 0!==t.experiment_name&&(e.experimentName=t.experiment_name),void 0!==t.experiment_description&&(e.experimentDescription=t.experiment_description),void 0!==t.creation_time&&(e.creationTime=t.creation_time),Se.exports.isEqual(this.environment,e)||(this.environment=e,this.emitChange())}))}getDataLocation(){return this.environment?this.environment.dataLocation:""}getWindowTitle(){return this.environment?this.environment.windowTitle:""}getExperimentName(){return this.environment?this.environment.experimentName:""}getExperimentDescription(){return this.environment?this.environment.experimentDescription:""}getCreationTime(){return this.environment?this.environment.creationTime:null}}const _l=new gl;class yl extends ml{constructor(){super(...arguments),this._runs=[]}load(){const t=_r().runs();return this.requestManager.request(t).then((t=>{Se.exports.isEqual(this._runs,t)||(this._runs=t,this.emitChange())}))}getRuns(){return this._runs.slice()}}const vl=new yl;function bl(t,e){return t<e?-1:t>e?1:t>=e?0:NaN}function xl(t){return 1===t.length&&(t=(function e(t){return function(e,n){return bl(t(e),n)}})(t)),{left:function(e,n,i,r){for(null==i&&(i=0),null==r&&(r=e.length);i<r;){var o=i+r>>>1;t(e[o],n)<0?i=o+1:r=o}return i},right:function(e,n,i,r){for(null==i&&(i=0),null==r&&(r=e.length);i<r;){var o=i+r>>>1;t(e[o],n)>0?r=o:i=o+1}return i}}}var wl=xl(bl),Sl=wl.right,Ml=wl.left;function El(t,e){return[t,e]}function Tl(t,e,n){var i,r,o,a,s=t.length,l=e.length,c=new Array(s*l);for(null==n&&(n=El),i=o=0;i<s;++i)for(a=t[i],r=0;r<l;++r,++o)c[o]=n(a,e[r]);return c}function Cl(t){return null===t?NaN:+t}function Al(t,e){var n,i,r=t.length,o=0,a=-1,s=0,l=0;if(null==e)for(;++a<r;)isNaN(n=Cl(t[a]))||(l+=(i=n-s)*(n-(s+=i/++o)));else for(;++a<r;)isNaN(n=Cl(e(t[a],a,t)))||(l+=(i=n-s)*(n-(s+=i/++o)));if(o>1)return l/(o-1)}function kl(t,e){var n=Al(t,e);return n?Math.sqrt(n):n}function Ll(t,e){var n,i,r,o=t.length,a=-1;if(null==e){for(;++a<o;)if(null!=(n=t[a])&&n>=n)for(i=r=n;++a<o;)null!=(n=t[a])&&(i>n&&(i=n),r<n&&(r=n))}else for(;++a<o;)if(null!=(n=e(t[a],a,t))&&n>=n)for(i=r=n;++a<o;)null!=(n=e(t[a],a,t))&&(i>n&&(i=n),r<n&&(r=n));return[i,r]}var Pl=Array.prototype,Nl=Pl.slice,Il=Pl.map;function Rl(t){return function(){return t}}function Ol(t){return t}function zl(t,e,n){t=+t,e=+e,n=(r=arguments.length)<2?(e=t,t=0,1):r<3?1:+n;for(var i=-1,r=0|Math.max(0,Math.ceil((e-t)/n)),o=new Array(r);++i<r;)o[i]=t+i*n;return o}var Dl=Math.sqrt(50),Bl=Math.sqrt(10),Hl=Math.sqrt(2);function Fl(t,e,n){var i,r,o,a,s=-1;if(n=+n,(t=+t)==(e=+e)&&n>0)return[t];if((i=e<t)&&(r=t,t=e,e=r),0===(a=Vl(t,e,n))||!isFinite(a))return[];if(a>0)for(t=Math.ceil(t/a),e=Math.floor(e/a),o=new Array(r=Math.ceil(e-t+1));++s<r;)o[s]=(t+s)*a;else for(t=Math.floor(t*a),e=Math.ceil(e*a),o=new Array(r=Math.ceil(t-e+1));++s<r;)o[s]=(t-s)/a;return i&&o.reverse(),o}function Vl(t,e,n){var i=(e-t)/Math.max(0,n),r=Math.floor(Math.log(i)/Math.LN10),o=i/Math.pow(10,r);return r>=0?(o>=Dl?10:o>=Bl?5:o>=Hl?2:1)*Math.pow(10,r):-Math.pow(10,-r)/(o>=Dl?10:o>=Bl?5:o>=Hl?2:1)}function Ul(t,e,n){var i=Math.abs(e-t)/Math.max(0,n),r=Math.pow(10,Math.floor(Math.log(i)/Math.LN10)),o=i/r;return o>=Dl?r*=10:o>=Bl?r*=5:o>=Hl&&(r*=2),e<t?-r:r}function jl(t){return Math.ceil(Math.log(t.length)/Math.LN2)+1}function Gl(t,e,n){if(null==n&&(n=Cl),i=t.length){if((e=+e)<=0||i<2)return+n(t[0],0,t);if(e>=1)return+n(t[i-1],i-1,t);var i,r=(i-1)*e,o=Math.floor(r),a=+n(t[o],o,t);return a+(+n(t[o+1],o+1,t)-a)*(r-o)}}function Wl(t,e){var n,i,r=t.length,o=-1;if(null==e){for(;++o<r;)if(null!=(n=t[o])&&n>=n)for(i=n;++o<r;)null!=(n=t[o])&&n>i&&(i=n)}else for(;++o<r;)if(null!=(n=e(t[o],o,t))&&n>=n)for(i=n;++o<r;)null!=(n=e(t[o],o,t))&&n>i&&(i=n);return i}function ql(t){for(var e,n,i,r=t.length,o=-1,a=0;++o<r;)a+=t[o].length;for(n=new Array(a);--r>=0;)for(e=(i=t[r]).length;--e>=0;)n[--a]=i[e];return n}function Yl(t,e){var n,i,r=t.length,o=-1;if(null==e){for(;++o<r;)if(null!=(n=t[o])&&n>=n)for(i=n;++o<r;)null!=(n=t[o])&&i>n&&(i=n)}else for(;++o<r;)if(null!=(n=e(t[o],o,t))&&n>=n)for(i=n;++o<r;)null!=(n=e(t[o],o,t))&&i>n&&(i=n);return i}function Xl(t){if(!(r=t.length))return[];for(var e=-1,n=Yl(t,$l),i=new Array(n);++e<n;)for(var r,o=-1,a=i[e]=new Array(r);++o<r;)a[o]=t[o][e];return i}function $l(t){return t.length}var Kl=Array.prototype.slice;function Zl(t){return t}var Jl=1e-6;function Ql(t){return"translate("+(t+.5)+",0)"}function tc(t){return"translate(0,"+(t+.5)+")"}function ec(t){return function(e){return+t(e)}}function nc(t){var e=Math.max(0,t.bandwidth()-1)/2;return t.round()&&(e=Math.round(e)),function(n){return+t(n)+e}}function ic(){return!this.__axis}function rc(t,e){var n=[],i=null,r=null,o=6,a=6,s=3,l=1===t||4===t?-1:1,c=4===t||2===t?"x":"y",u=1===t||3===t?Ql:tc;function h(h){var d=null==i?e.ticks?e.ticks.apply(e,n):e.domain():i,p=null==r?e.tickFormat?e.tickFormat.apply(e,n):Zl:r,f=Math.max(o,0)+s,m=e.range(),g=+m[0]+.5,_=+m[m.length-1]+.5,y=(e.bandwidth?nc:ec)(e.copy()),v=h.selection?h.selection():h,b=v.selectAll(".domain").data([null]),x=v.selectAll(".tick").data(d,e).order(),w=x.exit(),S=x.enter().append("g").attr("class","tick"),M=x.select("line"),E=x.select("text");b=b.merge(b.enter().insert("path",".tick").attr("class","domain").attr("stroke","currentColor")),x=x.merge(S),M=M.merge(S.append("line").attr("stroke","currentColor").attr(c+"2",l*o)),E=E.merge(S.append("text").attr("fill","currentColor").attr(c,l*f).attr("dy",1===t?"0em":3===t?"0.71em":"0.32em")),h!==v&&(b=b.transition(h),x=x.transition(h),M=M.transition(h),E=E.transition(h),w=w.transition(h).attr("opacity",Jl).attr("transform",(function(t){return isFinite(t=y(t))?u(t):this.getAttribute("transform")})),S.attr("opacity",Jl).attr("transform",(function(t){var e=this.parentNode.__axis;return u(e&&isFinite(e=e(t))?e:y(t))}))),w.remove(),b.attr("d",4===t||2==t?a?"M"+l*a+","+g+"H0.5V"+_+"H"+l*a:"M0.5,"+g+"V"+_:a?"M"+g+","+l*a+"V0.5H"+_+"V"+l*a:"M"+g+",0.5H"+_),x.attr("opacity",1).attr("transform",(function(t){return u(y(t))})),M.attr(c+"2",l*o),E.attr(c,l*f).text(p),v.filter(ic).attr("fill","none").attr("font-size",10).attr("font-family","sans-serif").attr("text-anchor",2===t?"start":4===t?"end":"middle"),v.each((function(){this.__axis=y}))}return h.scale=function(t){return arguments.length?(e=t,h):e},h.ticks=function(){return n=Kl.call(arguments),h},h.tickArguments=function(t){return arguments.length?(n=null==t?[]:Kl.call(t),h):n.slice()},h.tickValues=function(t){return arguments.length?(i=null==t?null:Kl.call(t),h):i&&i.slice()},h.tickFormat=function(t){return arguments.length?(r=t,h):r},h.tickSize=function(t){return arguments.length?(o=a=+t,h):o},h.tickSizeInner=function(t){return arguments.length?(o=+t,h):o},h.tickSizeOuter=function(t){return arguments.length?(a=+t,h):a},h.tickPadding=function(t){return arguments.length?(s=+t,h):s},h}function oc(t){return rc(3,t)}function ac(t){return rc(4,t)}var sc={value:function(){}};function lc(){for(var t,e=0,n=arguments.length,i={};e<n;++e){if(!(t=arguments[e]+"")||t in i||/[\s.]/.test(t))throw new Error("illegal type: "+t);i[t]=[]}return new cc(i)}function cc(t){this._=t}function uc(t,e){return t.trim().split(/^|\s+/).map((function(t){var n="",i=t.indexOf(".");if(i>=0&&(n=t.slice(i+1),t=t.slice(0,i)),t&&!e.hasOwnProperty(t))throw new Error("unknown type: "+t);return{type:t,name:n}}))}function hc(t,e){for(var n,i=0,r=t.length;i<r;++i)if((n=t[i]).name===e)return n.value}function dc(t,e,n){for(var i=0,r=t.length;i<r;++i)if(t[i].name===e){t[i]=sc,t=t.slice(0,i).concat(t.slice(i+1));break}return null!=n&&t.push({name:e,value:n}),t}cc.prototype=lc.prototype={constructor:cc,on:function(t,e){var n,i=this._,r=uc(t+"",i),o=-1,a=r.length;if(!(arguments.length<2)){if(null!=e&&"function"!=typeof e)throw new Error("invalid callback: "+e);for(;++o<a;)if(n=(t=r[o]).type)i[n]=dc(i[n],t.name,e);else if(null==e)for(n in i)i[n]=dc(i[n],t.name,null);return this}for(;++o<a;)if((n=(t=r[o]).type)&&(n=hc(i[n],t.name)))return n},copy:function(){var t={},e=this._;for(var n in e)t[n]=e[n].slice();return new cc(t)},call:function(t,e){if((n=arguments.length-2)>0)for(var n,i,r=new Array(n),o=0;o<n;++o)r[o]=arguments[o+2];if(!this._.hasOwnProperty(t))throw new Error("unknown type: "+t);for(o=0,n=(i=this._[t]).length;o<n;++o)i[o].value.apply(e,r)},apply:function(t,e,n){if(!this._.hasOwnProperty(t))throw new Error("unknown type: "+t);for(var i=this._[t],r=0,o=i.length;r<o;++r)i[r].value.apply(e,n)}};var pc="http://www.w3.org/1999/xhtml",fc={svg:"http://www.w3.org/2000/svg",xhtml:pc,xlink:"http://www.w3.org/1999/xlink",xml:"http://www.w3.org/XML/1998/namespace",xmlns:"http://www.w3.org/2000/xmlns/"};function mc(t){var e=t+="",n=e.indexOf(":");return n>=0&&"xmlns"!==(e=t.slice(0,n))&&(t=t.slice(n+1)),fc.hasOwnProperty(e)?{space:fc[e],local:t}:t}function gc(t){return function(){var e=this.ownerDocument,n=this.namespaceURI;return n===pc&&e.documentElement.namespaceURI===pc?e.createElement(t):e.createElementNS(n,t)}}function _c(t){return function(){return this.ownerDocument.createElementNS(t.space,t.local)}}function yc(t){var e=mc(t);return(e.local?_c:gc)(e)}function vc(){}function bc(t){return null==t?vc:function(){return this.querySelector(t)}}function xc(){return[]}function wc(t){return null==t?xc:function(){return this.querySelectorAll(t)}}function Sc(t){return function(){return this.matches(t)}}function Mc(t){return new Array(t.length)}function Ec(t,e){this.ownerDocument=t.ownerDocument,this.namespaceURI=t.namespaceURI,this._next=null,this._parent=t,this.__data__=e}function Tc(t,e,n,i,r,o){for(var a,s=0,l=e.length,c=o.length;s<c;++s)(a=e[s])?(a.__data__=o[s],i[s]=a):n[s]=new Ec(t,o[s]);for(;s<l;++s)(a=e[s])&&(r[s]=a)}function Cc(t,e,n,i,r,o,a){var s,l,c,u={},h=e.length,d=o.length,p=new Array(h);for(s=0;s<h;++s)(l=e[s])&&(p[s]=c="$"+a.call(l,l.__data__,s,e),c in u?r[s]=l:u[c]=l);for(s=0;s<d;++s)(l=u[c="$"+a.call(t,o[s],s,o)])?(i[s]=l,l.__data__=o[s],u[c]=null):n[s]=new Ec(t,o[s]);for(s=0;s<h;++s)(l=e[s])&&u[p[s]]===l&&(r[s]=l)}function Ac(t,e){return t<e?-1:t>e?1:t>=e?0:NaN}function kc(t){return function(){this.removeAttribute(t)}}function Lc(t){return function(){this.removeAttributeNS(t.space,t.local)}}function Pc(t,e){return function(){this.setAttribute(t,e)}}function Nc(t,e){return function(){this.setAttributeNS(t.space,t.local,e)}}function Ic(t,e){return function(){var n=e.apply(this,arguments);null==n?this.removeAttribute(t):this.setAttribute(t,n)}}function Rc(t,e){return function(){var n=e.apply(this,arguments);null==n?this.removeAttributeNS(t.space,t.local):this.setAttributeNS(t.space,t.local,n)}}function Oc(t){return t.ownerDocument&&t.ownerDocument.defaultView||t.document&&t||t.defaultView}function zc(t){return function(){this.style.removeProperty(t)}}function Dc(t,e,n){return function(){this.style.setProperty(t,e,n)}}function Bc(t,e,n){return function(){var i=e.apply(this,arguments);null==i?this.style.removeProperty(t):this.style.setProperty(t,i,n)}}function Hc(t,e){return t.style.getPropertyValue(e)||Oc(t).getComputedStyle(t,null).getPropertyValue(e)}function Fc(t){return function(){delete this[t]}}function Vc(t,e){return function(){this[t]=e}}function Uc(t,e){return function(){var n=e.apply(this,arguments);null==n?delete this[t]:this[t]=n}}function jc(t){return t.trim().split(/^|\s+/)}function Gc(t){return t.classList||new Wc(t)}function Wc(t){this._node=t,this._names=jc(t.getAttribute("class")||"")}function qc(t,e){for(var n=Gc(t),i=-1,r=e.length;++i<r;)n.add(e[i])}function Yc(t,e){for(var n=Gc(t),i=-1,r=e.length;++i<r;)n.remove(e[i])}function Xc(t){return function(){qc(this,t)}}function $c(t){return function(){Yc(this,t)}}function Kc(t,e){return function(){(e.apply(this,arguments)?qc:Yc)(this,t)}}function Zc(){this.textContent=""}function Jc(t){return function(){this.textContent=t}}function Qc(t){return function(){var e=t.apply(this,arguments);this.textContent=null==e?"":e}}function tu(){this.innerHTML=""}function eu(t){return function(){this.innerHTML=t}}function nu(t){return function(){var e=t.apply(this,arguments);this.innerHTML=null==e?"":e}}function iu(){this.nextSibling&&this.parentNode.appendChild(this)}function ru(){this.previousSibling&&this.parentNode.insertBefore(this,this.parentNode.firstChild)}function ou(){return null}function au(){var t=this.parentNode;t&&t.removeChild(this)}function su(){var t=this.cloneNode(!1),e=this.parentNode;return e?e.insertBefore(t,this.nextSibling):t}function lu(){var t=this.cloneNode(!0),e=this.parentNode;return e?e.insertBefore(t,this.nextSibling):t}Ec.prototype={constructor:Ec,appendChild:function(t){return this._parent.insertBefore(t,this._next)},insertBefore:function(t,e){return this._parent.insertBefore(t,e)},querySelector:function(t){return this._parent.querySelector(t)},querySelectorAll:function(t){return this._parent.querySelectorAll(t)}},Wc.prototype={add:function(t){this._names.indexOf(t)<0&&(this._names.push(t),this._node.setAttribute("class",this._names.join(" ")))},remove:function(t){var e=this._names.indexOf(t);e>=0&&(this._names.splice(e,1),this._node.setAttribute("class",this._names.join(" ")))},contains:function(t){return this._names.indexOf(t)>=0}};var cu={},uu=null;function hu(t,e,n){return t=du(t,e,n),function(e){var n=e.relatedTarget;n&&(n===this||8&n.compareDocumentPosition(this))||t.call(this,e)}}function du(t,e,n){return function(i){var r=uu;uu=i;try{t.call(this,this.__data__,e,n)}finally{uu=r}}}function pu(t){return t.trim().split(/^|\s+/).map((function(t){var e="",n=t.indexOf(".");return n>=0&&(e=t.slice(n+1),t=t.slice(0,n)),{type:t,name:e}}))}function fu(t){return function(){var e=this.__on;if(e){for(var n,i=0,r=-1,o=e.length;i<o;++i)n=e[i],t.type&&n.type!==t.type||n.name!==t.name?e[++r]=n:this.removeEventListener(n.type,n.listener,n.capture);++r?e.length=r:delete this.__on}}}function mu(t,e,n){var i=cu.hasOwnProperty(t.type)?hu:du;return function(r,o,a){var s,l=this.__on,c=i(e,o,a);if(l)for(var u=0,h=l.length;u<h;++u)if((s=l[u]).type===t.type&&s.name===t.name)return this.removeEventListener(s.type,s.listener,s.capture),this.addEventListener(s.type,s.listener=c,s.capture=n),void(s.value=e);this.addEventListener(t.type,c,n),s={type:t.type,name:t.name,value:e,listener:c,capture:n},l?l.push(s):this.__on=[s]}}function gu(t,e,n,i){var r=uu;t.sourceEvent=uu,uu=t;try{return e.apply(n,i)}finally{uu=r}}function _u(t,e,n){var i=Oc(t),r=i.CustomEvent;"function"==typeof r?r=new r(e,n):(r=i.document.createEvent("Event"),n?(r.initEvent(e,n.bubbles,n.cancelable),r.detail=n.detail):r.initEvent(e,!1,!1)),t.dispatchEvent(r)}function yu(t,e){return function(){return _u(this,t,e)}}function vu(t,e){return function(){return _u(this,t,e.apply(this,arguments))}}"undefined"!=typeof document&&("onmouseenter"in document.documentElement||(cu={mouseenter:"mouseover",mouseleave:"mouseout"}));var bu=[null];function xu(t,e){this._groups=t,this._parents=e}function wu(){return new xu([[document.documentElement]],bu)}function Su(t){return"string"==typeof t?new xu([[document.querySelector(t)]],[document.documentElement]):new xu([[t]],bu)}xu.prototype=wu.prototype={constructor:xu,select:function Mu(t){"function"!=typeof t&&(t=bc(t));for(var e=this._groups,n=e.length,i=new Array(n),r=0;r<n;++r)for(var o,a,s=e[r],l=s.length,c=i[r]=new Array(l),u=0;u<l;++u)(o=s[u])&&(a=t.call(o,o.__data__,u,s))&&("__data__"in o&&(a.__data__=o.__data__),c[u]=a);return new xu(i,this._parents)},selectAll:function Eu(t){"function"!=typeof t&&(t=wc(t));for(var e=this._groups,n=e.length,i=[],r=[],o=0;o<n;++o)for(var a,s=e[o],l=s.length,c=0;c<l;++c)(a=s[c])&&(i.push(t.call(a,a.__data__,c,s)),r.push(a));return new xu(i,r)},filter:function Tu(t){"function"!=typeof t&&(t=Sc(t));for(var e=this._groups,n=e.length,i=new Array(n),r=0;r<n;++r)for(var o,a=e[r],s=a.length,l=i[r]=[],c=0;c<s;++c)(o=a[c])&&t.call(o,o.__data__,c,a)&&l.push(o);return new xu(i,this._parents)},data:function Cu(t,e){if(!t)return f=new Array(this.size()),u=-1,this.each((function(t){f[++u]=t})),f;var n=e?Cc:Tc,i=this._parents,r=this._groups;"function"!=typeof t&&(t=(function o(t){return function(){return t}})(t));for(var a=r.length,s=new Array(a),l=new Array(a),c=new Array(a),u=0;u<a;++u){var h=i[u],d=r[u],p=d.length,f=t.call(h,h&&h.__data__,u,i),m=f.length,g=l[u]=new Array(m),_=s[u]=new Array(m);n(h,d,g,_,c[u]=new Array(p),f,e);for(var y,v,b=0,x=0;b<m;++b)if(y=g[b]){for(b>=x&&(x=b+1);!(v=_[x])&&++x<m;);y._next=v||null}}return(s=new xu(s,i))._enter=l,s._exit=c,s},enter:function Au(){return new xu(this._enter||this._groups.map(Mc),this._parents)},exit:function ku(){return new xu(this._exit||this._groups.map(Mc),this._parents)},join:function Lu(t,e,n){var i=this.enter(),r=this,o=this.exit();return i="function"==typeof t?t(i):i.append(t+""),null!=e&&(r=e(r)),null==n?o.remove():n(o),i&&r?i.merge(r).order():r},merge:function Pu(t){for(var e=this._groups,n=t._groups,i=e.length,r=Math.min(i,n.length),o=new Array(i),a=0;a<r;++a)for(var s,l=e[a],c=n[a],u=l.length,h=o[a]=new Array(u),d=0;d<u;++d)(s=l[d]||c[d])&&(h[d]=s);for(;a<i;++a)o[a]=e[a];return new xu(o,this._parents)},order:function Nu(){for(var t=this._groups,e=-1,n=t.length;++e<n;)for(var i,r=t[e],o=r.length-1,a=r[o];--o>=0;)(i=r[o])&&(a&&4^i.compareDocumentPosition(a)&&a.parentNode.insertBefore(i,a),a=i);return this},sort:function Iu(t){function e(e,n){return e&&n?t(e.__data__,n.__data__):!e-!n}t||(t=Ac);for(var n=this._groups,i=n.length,r=new Array(i),o=0;o<i;++o){for(var a,s=n[o],l=s.length,c=r[o]=new Array(l),u=0;u<l;++u)(a=s[u])&&(c[u]=a);c.sort(e)}return new xu(r,this._parents).order()},call:function Ru(){var t=arguments[0];return arguments[0]=this,t.apply(null,arguments),this},nodes:function Ou(){var t=new Array(this.size()),e=-1;return this.each((function(){t[++e]=this})),t},node:function zu(){for(var t=this._groups,e=0,n=t.length;e<n;++e)for(var i=t[e],r=0,o=i.length;r<o;++r){var a=i[r];if(a)return a}return null},size:function Du(){var t=0;return this.each((function(){++t})),t},empty:function Bu(){return!this.node()},each:function Hu(t){for(var e=this._groups,n=0,i=e.length;n<i;++n)for(var r,o=e[n],a=0,s=o.length;a<s;++a)(r=o[a])&&t.call(r,r.__data__,a,o);return this},attr:function Fu(t,e){var n=mc(t);if(arguments.length<2){var i=this.node();return n.local?i.getAttributeNS(n.space,n.local):i.getAttribute(n)}return this.each((null==e?n.local?Lc:kc:"function"==typeof e?n.local?Rc:Ic:n.local?Nc:Pc)(n,e))},style:function Vu(t,e,n){return arguments.length>1?this.each((null==e?zc:"function"==typeof e?Bc:Dc)(t,e,null==n?"":n)):Hc(this.node(),t)},property:function Uu(t,e){return arguments.length>1?this.each((null==e?Fc:"function"==typeof e?Uc:Vc)(t,e)):this.node()[t]},classed:function ju(t,e){var n=jc(t+"");if(arguments.length<2){for(var i=Gc(this.node()),r=-1,o=n.length;++r<o;)if(!i.contains(n[r]))return!1;return!0}return this.each(("function"==typeof e?Kc:e?Xc:$c)(n,e))},text:function Gu(t){return arguments.length?this.each(null==t?Zc:("function"==typeof t?Qc:Jc)(t)):this.node().textContent},html:function Wu(t){return arguments.length?this.each(null==t?tu:("function"==typeof t?nu:eu)(t)):this.node().innerHTML},raise:function qu(){return this.each(iu)},lower:function Yu(){return this.each(ru)},append:function Xu(t){var e="function"==typeof t?t:yc(t);return this.select((function(){return this.appendChild(e.apply(this,arguments))}))},insert:function $u(t,e){var n="function"==typeof t?t:yc(t),i=null==e?ou:"function"==typeof e?e:bc(e);return this.select((function(){return this.insertBefore(n.apply(this,arguments),i.apply(this,arguments)||null)}))},remove:function Ku(){return this.each(au)},clone:function Zu(t){return this.select(t?lu:su)},datum:function Ju(t){return arguments.length?this.property("__data__",t):this.node().__data__},on:function Qu(t,e,n){var i,r,o=pu(t+""),a=o.length;if(!(arguments.length<2)){for(s=e?mu:fu,null==n&&(n=!1),i=0;i<a;++i)this.each(s(o[i],e,n));return this}var s=this.node().__on;if(s)for(var l,c=0,u=s.length;c<u;++c)for(i=0,l=s[c];i<a;++i)if((r=o[i]).type===l.type&&r.name===l.name)return l.value},dispatch:function th(t,e){return this.each(("function"==typeof e?vu:yu)(t,e))}};var eh=0;function nh(){return new ih}function ih(){this._="@"+(++eh).toString(36)}function rh(){for(var t,e=uu;t=e.sourceEvent;)e=t;return e}function oh(t,e){var n=t.ownerSVGElement||t;if(n.createSVGPoint){var i=n.createSVGPoint();return i.x=e.clientX,i.y=e.clientY,[(i=i.matrixTransform(t.getScreenCTM().inverse())).x,i.y]}var r=t.getBoundingClientRect();return[e.clientX-r.left-t.clientLeft,e.clientY-r.top-t.clientTop]}function ah(t){var e=rh();return e.changedTouches&&(e=e.changedTouches[0]),oh(t,e)}function sh(t){return"string"==typeof t?new xu([document.querySelectorAll(t)],[document.documentElement]):new xu([null==t?[]:t],bu)}function lh(t,e,n){arguments.length<3&&(n=e,e=rh().changedTouches);for(var i,r=0,o=e?e.length:0;r<o;++r)if((i=e[r]).identifier===n)return oh(t,i);return null}function ch(){uu.stopImmediatePropagation()}function uh(){uu.preventDefault(),uu.stopImmediatePropagation()}function hh(t){var e=t.document.documentElement,n=Su(t).on("dragstart.drag",uh,!0);"onselectstart"in e?n.on("selectstart.drag",uh,!0):(e.__noselect=e.style.MozUserSelect,e.style.MozUserSelect="none")}function dh(t,e){var n=t.document.documentElement,i=Su(t).on("dragstart.drag",null);e&&(i.on("click.drag",uh,!0),setTimeout((function(){i.on("click.drag",null)}),0)),"onselectstart"in n?i.on("selectstart.drag",null):(n.style.MozUserSelect=n.__noselect,delete n.__noselect)}function ph(t){return function(){return t}}function fh(t,e,n,i,r,o,a,s,l,c){this.target=t,this.type=e,this.subject=n,this.identifier=i,this.active=r,this.x=o,this.y=a,this.dx=s,this.dy=l,this._=c}function mh(){return!uu.ctrlKey&&!uu.button}function gh(){return this.parentNode}function _h(t){return null==t?{x:uu.x,y:uu.y}:t}function yh(){return navigator.maxTouchPoints||"ontouchstart"in this}function vh(){var t,e,n,i,r=mh,o=gh,a=_h,s=yh,l={},c=lc("start","drag","end"),u=0,h=0;function d(t){t.on("mousedown.drag",p).filter(s).on("touchstart.drag",g).on("touchmove.drag",_).on("touchend.drag touchcancel.drag",y).style("touch-action","none").style("-webkit-tap-highlight-color","rgba(0,0,0,0)")}function p(){if(!i&&r.apply(this,arguments)){var a=v("mouse",o.apply(this,arguments),ah,this,arguments);a&&(Su(uu.view).on("mousemove.drag",f,!0).on("mouseup.drag",m,!0),hh(uu.view),ch(),n=!1,t=uu.clientX,e=uu.clientY,a("start"))}}function f(){if(uh(),!n){var i=uu.clientX-t,r=uu.clientY-e;n=i*i+r*r>h}l.mouse("drag")}function m(){Su(uu.view).on("mousemove.drag mouseup.drag",null),dh(uu.view,n),uh(),l.mouse("end")}function g(){if(r.apply(this,arguments)){var t,e,n=uu.changedTouches,i=o.apply(this,arguments),a=n.length;for(t=0;t<a;++t)(e=v(n[t].identifier,i,lh,this,arguments))&&(ch(),e("start"))}}function _(){var t,e,n=uu.changedTouches,i=n.length;for(t=0;t<i;++t)(e=l[n[t].identifier])&&(uh(),e("drag"))}function y(){var t,e,n=uu.changedTouches,r=n.length;for(i&&clearTimeout(i),i=setTimeout((function(){i=null}),500),t=0;t<r;++t)(e=l[n[t].identifier])&&(ch(),e("end"))}function v(t,e,n,i,r){var o,s,h,p=n(e,t),f=c.copy();if(gu(new fh(d,"beforestart",o,t,u,p[0],p[1],0,0,f),(function(){return null!=(uu.subject=o=a.apply(i,r))&&(s=o.x-p[0]||0,h=o.y-p[1]||0,!0)})))return function a(c){var m,g=p;switch(c){case"start":l[t]=a,m=u++;break;case"end":delete l[t],--u;case"drag":p=n(e,t),m=u}gu(new fh(d,c,o,t,m,p[0]+s,p[1]+h,p[0]-g[0],p[1]-g[1],f),f.apply,f,[c,i,r])}}return d.filter=function(t){return arguments.length?(r="function"==typeof t?t:ph(!!t),d):r},d.container=function(t){return arguments.length?(o="function"==typeof t?t:ph(t),d):o},d.subject=function(t){return arguments.length?(a="function"==typeof t?t:ph(t),d):a},d.touchable=function(t){return arguments.length?(s="function"==typeof t?t:ph(!!t),d):s},d.on=function(){var t=c.on.apply(c,arguments);return t===c?d:t},d.clickDistance=function(t){return arguments.length?(h=(t=+t)*t,d):Math.sqrt(h)},d}function bh(t,e,n){t.prototype=e.prototype=n,n.constructor=t}function xh(t,e){var n=Object.create(t.prototype);for(var i in e)n[i]=e[i];return n}function wh(){}ih.prototype=nh.prototype={constructor:ih,get:function(t){for(var e=this._;!(e in t);)if(!(t=t.parentNode))return;return t[e]},set:function(t,e){return t[this._]=e},remove:function(t){return this._ in t&&delete t[this._]},toString:function(){return this._}},fh.prototype.on=function(){var t=this._.on.apply(this._,arguments);return t===this._?this:t};var Sh=.7,Mh=1/Sh,Eh="\\s*([+-]?\\d+)\\s*",Th="\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)\\s*",Ch="\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)%\\s*",Ah=/^#([0-9a-f]{3,8})$/,kh=new RegExp("^rgb\\("+[Eh,Eh,Eh]+"\\)$"),Lh=new RegExp("^rgb\\("+[Ch,Ch,Ch]+"\\)$"),Ph=new RegExp("^rgba\\("+[Eh,Eh,Eh,Th]+"\\)$"),Nh=new RegExp("^rgba\\("+[Ch,Ch,Ch,Th]+"\\)$"),Ih=new RegExp("^hsl\\("+[Th,Ch,Ch]+"\\)$"),Rh=new RegExp("^hsla\\("+[Th,Ch,Ch,Th]+"\\)$"),Oh={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074};function zh(){return this.rgb().formatHex()}function Dh(){return this.rgb().formatRgb()}function Bh(t){var e,n;return t=(t+"").trim().toLowerCase(),(e=Ah.exec(t))?(n=e[1].length,e=parseInt(e[1],16),6===n?Hh(e):3===n?new jh(e>>8&15|e>>4&240,e>>4&15|240&e,(15&e)<<4|15&e,1):8===n?Fh(e>>24&255,e>>16&255,e>>8&255,(255&e)/255):4===n?Fh(e>>12&15|e>>8&240,e>>8&15|e>>4&240,e>>4&15|240&e,((15&e)<<4|15&e)/255):null):(e=kh.exec(t))?new jh(e[1],e[2],e[3],1):(e=Lh.exec(t))?new jh(255*e[1]/100,255*e[2]/100,255*e[3]/100,1):(e=Ph.exec(t))?Fh(e[1],e[2],e[3],e[4]):(e=Nh.exec(t))?Fh(255*e[1]/100,255*e[2]/100,255*e[3]/100,e[4]):(e=Ih.exec(t))?Yh(e[1],e[2]/100,e[3]/100,1):(e=Rh.exec(t))?Yh(e[1],e[2]/100,e[3]/100,e[4]):Oh.hasOwnProperty(t)?Hh(Oh[t]):"transparent"===t?new jh(NaN,NaN,NaN,0):null}function Hh(t){return new jh(t>>16&255,t>>8&255,255&t,1)}function Fh(t,e,n,i){return i<=0&&(t=e=n=NaN),new jh(t,e,n,i)}function Vh(t){return t instanceof wh||(t=Bh(t)),t?new jh((t=t.rgb()).r,t.g,t.b,t.opacity):new jh}function Uh(t,e,n,i){return 1===arguments.length?Vh(t):new jh(t,e,n,null==i?1:i)}function jh(t,e,n,i){this.r=+t,this.g=+e,this.b=+n,this.opacity=+i}function Gh(){return"#"+qh(this.r)+qh(this.g)+qh(this.b)}function Wh(){var t=this.opacity;return(1===(t=isNaN(t)?1:Math.max(0,Math.min(1,t)))?"rgb(":"rgba(")+Math.max(0,Math.min(255,Math.round(this.r)||0))+", "+Math.max(0,Math.min(255,Math.round(this.g)||0))+", "+Math.max(0,Math.min(255,Math.round(this.b)||0))+(1===t?")":", "+t+")")}function qh(t){return((t=Math.max(0,Math.min(255,Math.round(t)||0)))<16?"0":"")+t.toString(16)}function Yh(t,e,n,i){return i<=0?t=e=n=NaN:n<=0||n>=1?t=e=NaN:e<=0&&(t=NaN),new Kh(t,e,n,i)}function Xh(t){if(t instanceof Kh)return new Kh(t.h,t.s,t.l,t.opacity);if(t instanceof wh||(t=Bh(t)),!t)return new Kh;if(t instanceof Kh)return t;var e=(t=t.rgb()).r/255,n=t.g/255,i=t.b/255,r=Math.min(e,n,i),o=Math.max(e,n,i),a=NaN,s=o-r,l=(o+r)/2;return s?(a=e===o?(n-i)/s+6*(n<i):n===o?(i-e)/s+2:(e-n)/s+4,s/=l<.5?o+r:2-o-r,a*=60):s=l>0&&l<1?0:a,new Kh(a,s,l,t.opacity)}function $h(t,e,n,i){return 1===arguments.length?Xh(t):new Kh(t,e,n,null==i?1:i)}function Kh(t,e,n,i){this.h=+t,this.s=+e,this.l=+n,this.opacity=+i}function Zh(t,e,n){return 255*(t<60?e+(n-e)*t/60:t<180?n:t<240?e+(n-e)*(240-t)/60:e)}bh(wh,Bh,{copy:function(t){return Object.assign(new this.constructor,this,t)},displayable:function(){return this.rgb().displayable()},hex:zh,formatHex:zh,formatHsl:function Jh(){return Xh(this).formatHsl()},formatRgb:Dh,toString:Dh}),bh(jh,Uh,xh(wh,{brighter:function(t){return t=null==t?Mh:Math.pow(Mh,t),new jh(this.r*t,this.g*t,this.b*t,this.opacity)},darker:function(t){return t=null==t?Sh:Math.pow(Sh,t),new jh(this.r*t,this.g*t,this.b*t,this.opacity)},rgb:function(){return this},displayable:function(){return-.5<=this.r&&this.r<255.5&&-.5<=this.g&&this.g<255.5&&-.5<=this.b&&this.b<255.5&&0<=this.opacity&&this.opacity<=1},hex:Gh,formatHex:Gh,formatRgb:Wh,toString:Wh})),bh(Kh,$h,xh(wh,{brighter:function(t){return t=null==t?Mh:Math.pow(Mh,t),new Kh(this.h,this.s,this.l*t,this.opacity)},darker:function(t){return t=null==t?Sh:Math.pow(Sh,t),new Kh(this.h,this.s,this.l*t,this.opacity)},rgb:function(){var t=this.h%360+360*(this.h<0),e=isNaN(t)||isNaN(this.s)?0:this.s,n=this.l,i=n+(n<.5?n:1-n)*e,r=2*n-i;return new jh(Zh(t>=240?t-240:t+120,r,i),Zh(t,r,i),Zh(t<120?t+240:t-120,r,i),this.opacity)},displayable:function(){return(0<=this.s&&this.s<=1||isNaN(this.s))&&0<=this.l&&this.l<=1&&0<=this.opacity&&this.opacity<=1},formatHsl:function(){var t=this.opacity;return(1===(t=isNaN(t)?1:Math.max(0,Math.min(1,t)))?"hsl(":"hsla(")+(this.h||0)+", "+100*(this.s||0)+"%, "+100*(this.l||0)+"%"+(1===t?")":", "+t+")")}}));var Qh=Math.PI/180,td=180/Math.PI,ed=.96422,nd=.82521,id=4/29,rd=6/29,od=3*rd*rd;function ad(t){if(t instanceof ld)return new ld(t.l,t.a,t.b,t.opacity);if(t instanceof md)return gd(t);t instanceof jh||(t=Vh(t));var e,n,i=dd(t.r),r=dd(t.g),o=dd(t.b),a=cd((.2225045*i+.7168786*r+.0606169*o)/1);return i===r&&r===o?e=n=a:(e=cd((.4360747*i+.3850649*r+.1430804*o)/ed),n=cd((.0139322*i+.0971045*r+.7141733*o)/nd)),new ld(116*a-16,500*(e-a),200*(a-n),t.opacity)}function sd(t,e,n,i){return 1===arguments.length?ad(t):new ld(t,e,n,null==i?1:i)}function ld(t,e,n,i){this.l=+t,this.a=+e,this.b=+n,this.opacity=+i}function cd(t){return t>.008856451679035631?Math.pow(t,1/3):t/od+id}function ud(t){return t>rd?t*t*t:od*(t-id)}function hd(t){return 255*(t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055)}function dd(t){return(t/=255)<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function pd(t){if(t instanceof md)return new md(t.h,t.c,t.l,t.opacity);if(t instanceof ld||(t=ad(t)),0===t.a&&0===t.b)return new md(NaN,0<t.l&&t.l<100?0:NaN,t.l,t.opacity);var e=Math.atan2(t.b,t.a)*td;return new md(e<0?e+360:e,Math.sqrt(t.a*t.a+t.b*t.b),t.l,t.opacity)}function fd(t,e,n,i){return 1===arguments.length?pd(t):new md(t,e,n,null==i?1:i)}function md(t,e,n,i){this.h=+t,this.c=+e,this.l=+n,this.opacity=+i}function gd(t){if(isNaN(t.h))return new ld(t.l,0,0,t.opacity);var e=t.h*Qh;return new ld(t.l,Math.cos(e)*t.c,Math.sin(e)*t.c,t.opacity)}bh(ld,sd,xh(wh,{brighter:function(t){return new ld(this.l+18*(null==t?1:t),this.a,this.b,this.opacity)},darker:function(t){return new ld(this.l-18*(null==t?1:t),this.a,this.b,this.opacity)},rgb:function(){var t=(this.l+16)/116,e=isNaN(this.a)?t:t+this.a/500,n=isNaN(this.b)?t:t-this.b/200;return new jh(hd(3.1338561*(e=ed*ud(e))-1.6168667*(t=1*ud(t))-.4906146*(n=nd*ud(n))),hd(-.9787684*e+1.9161415*t+.033454*n),hd(.0719453*e-.2289914*t+1.4052427*n),this.opacity)}})),bh(md,fd,xh(wh,{brighter:function(t){return new md(this.h,this.c,this.l+18*(null==t?1:t),this.opacity)},darker:function(t){return new md(this.h,this.c,this.l-18*(null==t?1:t),this.opacity)},rgb:function(){return gd(this).rgb()}}));var _d=-.29227,yd=-.90649,vd=1.97294;function bd(t){if(t instanceof wd)return new wd(t.h,t.s,t.l,t.opacity);t instanceof jh||(t=Vh(t));var e=t.g/255,n=t.b/255,i=(-.6557636667999999*n+t.r/255*-1.7884503806-3.5172982438*e)/-5.9615122912,r=n-i,o=(vd*(e-i)-_d*r)/yd,a=Math.sqrt(o*o+r*r)/(vd*i*(1-i)),s=a?Math.atan2(o,r)*td-120:NaN;return new wd(s<0?s+360:s,a,i,t.opacity)}function xd(t,e,n,i){return 1===arguments.length?bd(t):new wd(t,e,n,null==i?1:i)}function wd(t,e,n,i){this.h=+t,this.s=+e,this.l=+n,this.opacity=+i}function Sd(t,e,n,i,r){var o=t*t,a=o*t;return((1-3*t+3*o-a)*e+(4-6*o+3*a)*n+(1+3*t+3*o-3*a)*i+a*r)/6}function Md(t){var e=t.length-1;return function(n){var i=n<=0?n=0:n>=1?(n=1,e-1):Math.floor(n*e),r=t[i],o=t[i+1];return Sd((n-i/e)*e,i>0?t[i-1]:2*r-o,r,o,i<e-1?t[i+2]:2*o-r)}}function Ed(t){var e=t.length;return function(n){var i=Math.floor(((n%=1)<0?++n:n)*e);return Sd((n-i/e)*e,t[(i+e-1)%e],t[i%e],t[(i+1)%e],t[(i+2)%e])}}function Td(t){return function(){return t}}function Cd(t,e){return function(n){return t+n*e}}function Ad(t,e){var n=e-t;return n?Cd(t,n>180||n<-180?n-360*Math.round(n/360):n):Td(isNaN(t)?e:t)}function kd(t,e){var n=e-t;return n?Cd(t,n):Td(isNaN(t)?e:t)}bh(wd,xd,xh(wh,{brighter:function(t){return t=null==t?Mh:Math.pow(Mh,t),new wd(this.h,this.s,this.l*t,this.opacity)},darker:function(t){return t=null==t?Sh:Math.pow(Sh,t),new wd(this.h,this.s,this.l*t,this.opacity)},rgb:function(){var t=isNaN(this.h)?0:(this.h+120)*Qh,e=+this.l,n=isNaN(this.s)?0:this.s*e*(1-e),i=Math.cos(t),r=Math.sin(t);return new jh(255*(e+n*(-.14861*i+1.78277*r)),255*(e+n*(_d*i+yd*r)),255*(e+n*(vd*i)),this.opacity)}}));var Ld=(function t(e){var n=(function i(t){return 1==(t=+t)?kd:function(e,n){return n-e?(function i(t,e,n){return t=Math.pow(t,n),e=Math.pow(e,n)-t,n=1/n,function(i){return Math.pow(t+i*e,n)}})(e,n,t):Td(isNaN(e)?n:e)}})(e);function r(t,e){var i=n((t=Uh(t)).r,(e=Uh(e)).r),r=n(t.g,e.g),o=n(t.b,e.b),a=kd(t.opacity,e.opacity);return function(e){return t.r=i(e),t.g=r(e),t.b=o(e),t.opacity=a(e),t+""}}return r.gamma=t,r})(1);function Pd(t){return function(e){var n,i,r=e.length,o=new Array(r),a=new Array(r),s=new Array(r);for(n=0;n<r;++n)i=Uh(e[n]),o[n]=i.r||0,a[n]=i.g||0,s[n]=i.b||0;return o=t(o),a=t(a),s=t(s),i.opacity=1,function(t){return i.r=o(t),i.g=a(t),i.b=s(t),i+""}}}var Nd=Pd(Md),Id=Pd(Ed);function Rd(t,e){e||(e=[]);var n,i=t?Math.min(e.length,t.length):0,r=e.slice();return function(o){for(n=0;n<i;++n)r[n]=t[n]*(1-o)+e[n]*o;return r}}function Od(t){return ArrayBuffer.isView(t)&&!(t instanceof DataView)}function zd(t,e){var n,i=e?e.length:0,r=t?Math.min(i,t.length):0,o=new Array(r),a=new Array(i);for(n=0;n<r;++n)o[n]=jd(t[n],e[n]);for(;n<i;++n)a[n]=e[n];return function(t){for(n=0;n<r;++n)a[n]=o[n](t);return a}}function Dd(t,e){var n=new Date;return t=+t,e=+e,function(i){return n.setTime(t*(1-i)+e*i),n}}function Bd(t,e){return t=+t,e=+e,function(n){return t*(1-n)+e*n}}function Hd(t,e){var n,i={},r={};for(n in null!==t&&"object"==typeof t||(t={}),null!==e&&"object"==typeof e||(e={}),e)n in t?i[n]=jd(t[n],e[n]):r[n]=e[n];return function(t){for(n in i)r[n]=i[n](t);return r}}var Fd=/[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,Vd=new RegExp(Fd.source,"g");function Ud(t,e){var n,i,r,o=Fd.lastIndex=Vd.lastIndex=0,a=-1,s=[],l=[];for(t+="",e+="";(n=Fd.exec(t))&&(i=Vd.exec(e));)(r=i.index)>o&&(r=e.slice(o,r),s[a]?s[a]+=r:s[++a]=r),(n=n[0])===(i=i[0])?s[a]?s[a]+=i:s[++a]=i:(s[++a]=null,l.push({i:a,x:Bd(n,i)})),o=Vd.lastIndex;return o<e.length&&(r=e.slice(o),s[a]?s[a]+=r:s[++a]=r),s.length<2?l[0]?(function c(t){return function(e){return t(e)+""}})(l[0].x):(function u(t){return function(){return t}})(e):(e=l.length,function(t){for(var n,i=0;i<e;++i)s[(n=l[i]).i]=n.x(t);return s.join("")})}function jd(t,e){var n,i=typeof e;return null==e||"boolean"===i?Td(e):("number"===i?Bd:"string"===i?(n=Bh(e))?(e=n,Ld):Ud:e instanceof Bh?Ld:e instanceof Date?Dd:Od(e)?Rd:Array.isArray(e)?zd:"function"!=typeof e.valueOf&&"function"!=typeof e.toString||isNaN(e)?Hd:Bd)(t,e)}function Gd(t,e){return t=+t,e=+e,function(n){return Math.round(t*(1-n)+e*n)}}var Wd,qd,Yd,Xd,$d=180/Math.PI,Kd={translateX:0,translateY:0,rotate:0,skewX:0,scaleX:1,scaleY:1};function Zd(t,e,n,i,r,o){var a,s,l;return(a=Math.sqrt(t*t+e*e))&&(t/=a,e/=a),(l=t*n+e*i)&&(n-=t*l,i-=e*l),(s=Math.sqrt(n*n+i*i))&&(n/=s,i/=s,l/=s),t*i<e*n&&(t=-t,e=-e,l=-l,a=-a),{translateX:r,translateY:o,rotate:Math.atan2(e,t)*$d,skewX:Math.atan(l)*$d,scaleX:a,scaleY:s}}function Jd(t,e,n,i){function r(t){return t.length?t.pop()+" ":""}return function(o,a){var s=[],l=[];return o=t(o),a=t(a),(function c(t,i,r,o,a,s){if(t!==r||i!==o){var l=a.push("translate(",null,e,null,n);s.push({i:l-4,x:Bd(t,r)},{i:l-2,x:Bd(i,o)})}else(r||o)&&a.push("translate("+r+e+o+n)})(o.translateX,o.translateY,a.translateX,a.translateY,s,l),(function u(t,e,n,o){t!==e?(t-e>180?e+=360:e-t>180&&(t+=360),o.push({i:n.push(r(n)+"rotate(",null,i)-2,x:Bd(t,e)})):e&&n.push(r(n)+"rotate("+e+i)})(o.rotate,a.rotate,s,l),(function h(t,e,n,o){t!==e?o.push({i:n.push(r(n)+"skewX(",null,i)-2,x:Bd(t,e)}):e&&n.push(r(n)+"skewX("+e+i)})(o.skewX,a.skewX,s,l),(function d(t,e,n,i,o,a){if(t!==n||e!==i){var s=o.push(r(o)+"scale(",null,",",null,")");a.push({i:s-4,x:Bd(t,n)},{i:s-2,x:Bd(e,i)})}else 1===n&&1===i||o.push(r(o)+"scale("+n+","+i+")")})(o.scaleX,o.scaleY,a.scaleX,a.scaleY,s,l),o=a=null,function(t){for(var e,n=-1,i=l.length;++n<i;)s[(e=l[n]).i]=e.x(t);return s.join("")}}}var Qd=Jd((function tp(t){return"none"===t?Kd:(Wd||(Wd=document.createElement("DIV"),qd=document.documentElement,Yd=document.defaultView),Wd.style.transform=t,t=Yd.getComputedStyle(qd.appendChild(Wd),null).getPropertyValue("transform"),qd.removeChild(Wd),Zd(+(t=t.slice(7,-1).split(","))[0],+t[1],+t[2],+t[3],+t[4],+t[5]))}),"px, ","px)","deg)"),ep=Jd((function np(t){return null==t?Kd:(Xd||(Xd=document.createElementNS("http://www.w3.org/2000/svg","g")),Xd.setAttribute("transform",t),(t=Xd.transform.baseVal.consolidate())?Zd((t=t.matrix).a,t.b,t.c,t.d,t.e,t.f):Kd)}),", ",")",")"),ip=Math.SQRT2;function rp(t){return((t=Math.exp(t))+1/t)/2}function op(t,e){var n,i,r=t[0],o=t[1],a=t[2],s=e[2],l=e[0]-r,c=e[1]-o,u=l*l+c*c;if(u<1e-12)i=Math.log(s/a)/ip,n=function(t){return[r+t*l,o+t*c,a*Math.exp(ip*t*i)]};else{var h=Math.sqrt(u),d=(s*s-a*a+4*u)/(2*a*2*h),p=(s*s-a*a-4*u)/(2*s*2*h),f=Math.log(Math.sqrt(d*d+1)-d),m=Math.log(Math.sqrt(p*p+1)-p);i=(m-f)/ip,n=function(t){var e=t*i,n=rp(f),s=a/(2*h)*(n*(function u(t){return((t=Math.exp(2*t))-1)/(t+1)})(ip*e+f)-(function d(t){return((t=Math.exp(t))-1/t)/2})(f));return[r+s*l,o+s*c,a*n/rp(ip*e+f)]}}return n.duration=1e3*i,n}function ap(t){return function(e,n){var i=t((e=$h(e)).h,(n=$h(n)).h),r=kd(e.s,n.s),o=kd(e.l,n.l),a=kd(e.opacity,n.opacity);return function(t){return e.h=i(t),e.s=r(t),e.l=o(t),e.opacity=a(t),e+""}}}var sp=ap(Ad),lp=ap(kd);function cp(t,e){var n=kd((t=sd(t)).l,(e=sd(e)).l),i=kd(t.a,e.a),r=kd(t.b,e.b),o=kd(t.opacity,e.opacity);return function(e){return t.l=n(e),t.a=i(e),t.b=r(e),t.opacity=o(e),t+""}}function up(t){return function(e,n){var i=t((e=fd(e)).h,(n=fd(n)).h),r=kd(e.c,n.c),o=kd(e.l,n.l),a=kd(e.opacity,n.opacity);return function(t){return e.h=i(t),e.c=r(t),e.l=o(t),e.opacity=a(t),e+""}}}var hp=up(Ad),dp=up(kd);function pp(t){return(function e(n){function i(e,i){var r=t((e=xd(e)).h,(i=xd(i)).h),o=kd(e.s,i.s),a=kd(e.l,i.l),s=kd(e.opacity,i.opacity);return function(t){return e.h=r(t),e.s=o(t),e.l=a(Math.pow(t,n)),e.opacity=s(t),e+""}}return n=+n,i.gamma=e,i})(1)}var fp,mp,gp=pp(Ad),_p=pp(kd),yp=0,vp=0,bp=0,xp=0,wp=0,Sp=0,Mp="object"==typeof performance&&performance.now?performance:Date,Ep="object"==typeof window&&window.requestAnimationFrame?window.requestAnimationFrame.bind(window):function(t){setTimeout(t,17)};function Tp(){return wp||(Ep(Cp),wp=Mp.now()+Sp)}function Cp(){wp=0}function Ap(){this._call=this._time=this._next=null}function kp(t,e,n){var i=new Ap;return i.restart(t,e,n),i}function Lp(){Tp(),++yp;for(var t,e=fp;e;)(t=wp-e._time)>=0&&e._call.call(null,t),e=e._next;--yp}function Pp(){wp=(xp=Mp.now())+Sp,yp=vp=0;try{Lp()}finally{yp=0,(function t(){for(var t,e,n=fp,i=1/0;n;)n._call?(i>n._time&&(i=n._time),t=n,n=n._next):(e=n._next,n._next=null,n=t?t._next=e:fp=e);mp=t,Ip(i)})(),wp=0}}function Np(){var t=Mp.now(),e=t-xp;e>1e3&&(Sp-=e,xp=t)}function Ip(t){yp||(vp&&(vp=clearTimeout(vp)),t-wp>24?(t<1/0&&(vp=setTimeout(Pp,t-Mp.now()-Sp)),bp&&(bp=clearInterval(bp))):(bp||(xp=Mp.now(),bp=setInterval(Np,1e3)),yp=1,Ep(Pp)))}function Rp(t,e,n){var i=new Ap;return i.restart((function(n){i.stop(),t(n+e)}),e=null==e?0:+e,n),i}Ap.prototype=kp.prototype={constructor:Ap,restart:function(t,e,n){if("function"!=typeof t)throw new TypeError("callback is not a function");n=(null==n?Tp():+n)+(null==e?0:+e),this._next||mp===this||(mp?mp._next=this:fp=this,mp=this),this._call=t,this._time=n,Ip()},stop:function(){this._call&&(this._call=null,this._time=1/0,Ip())}};var Op=lc("start","end","cancel","interrupt"),zp=[];function Dp(t,e,n,i,r,o){var a=t.__transition;if(a){if(n in a)return}else t.__transition={};!(function s(t,e,n){var i,r=t.__transition;function o(l){var c,u,h,d;if(1!==n.state)return s();for(c in r)if((d=r[c]).name===n.name){if(3===d.state)return Rp(o);4===d.state?(d.state=6,d.timer.stop(),d.on.call("interrupt",t,t.__data__,d.index,d.group),delete r[c]):+c<e&&(d.state=6,d.timer.stop(),d.on.call("cancel",t,t.__data__,d.index,d.group),delete r[c])}if(Rp((function(){3===n.state&&(n.state=4,n.timer.restart(a,n.delay,n.time),a(l))})),n.state=2,n.on.call("start",t,t.__data__,n.index,n.group),2===n.state){for(n.state=3,i=new Array(h=n.tween.length),c=0,u=-1;c<h;++c)(d=n.tween[c].value.call(t,t.__data__,n.index,n.group))&&(i[++u]=d);i.length=u+1}}function a(e){for(var r=e<n.duration?n.ease.call(null,e/n.duration):(n.timer.restart(s),n.state=5,1),o=-1,a=i.length;++o<a;)i[o].call(t,r);5===n.state&&(n.on.call("end",t,t.__data__,n.index,n.group),s())}function s(){for(var i in n.state=6,n.timer.stop(),delete r[e],r)return;delete t.__transition}r[e]=n,n.timer=kp((function l(t){n.state=1,n.timer.restart(o,n.delay,n.time),n.delay<=t&&o(t-n.delay)}),0,n.time)})(t,n,{name:e,index:i,group:r,on:Op,tween:zp,time:o.time,delay:o.delay,duration:o.duration,ease:o.ease,timer:null,state:0})}function Bp(t,e){var n=Fp(t,e);if(n.state>0)throw new Error("too late; already scheduled");return n}function Hp(t,e){var n=Fp(t,e);if(n.state>3)throw new Error("too late; already running");return n}function Fp(t,e){var n=t.__transition;if(!n||!(n=n[e]))throw new Error("transition not found");return n}function Vp(t,e){var n,i,r,o=t.__transition,a=!0;if(o){for(r in e=null==e?null:e+"",o)(n=o[r]).name===e?(i=n.state>2&&n.state<5,n.state=6,n.timer.stop(),n.on.call(i?"interrupt":"cancel",t,t.__data__,n.index,n.group),delete o[r]):a=!1;a&&delete t.__transition}}function Up(t,e){var n,i;return function(){var r=Hp(this,t),o=r.tween;if(o!==n)for(var a=0,s=(i=n=o).length;a<s;++a)if(i[a].name===e){(i=i.slice()).splice(a,1);break}r.tween=i}}function jp(t,e,n){var i,r;if("function"!=typeof n)throw new Error;return function(){var o=Hp(this,t),a=o.tween;if(a!==i){r=(i=a).slice();for(var s={name:e,value:n},l=0,c=r.length;l<c;++l)if(r[l].name===e){r[l]=s;break}l===c&&r.push(s)}o.tween=r}}function Gp(t,e,n){var i=t._id;return t.each((function(){var t=Hp(this,i);(t.value||(t.value={}))[e]=n.apply(this,arguments)})),function(t){return Fp(t,i).value[e]}}function Wp(t,e){var n;return("number"==typeof e?Bd:e instanceof Bh?Ld:(n=Bh(e))?(e=n,Ld):Ud)(t,e)}function qp(t){return function(){this.removeAttribute(t)}}function Yp(t){return function(){this.removeAttributeNS(t.space,t.local)}}function Xp(t,e,n){var i,r,o=n+"";return function(){var a=this.getAttribute(t);return a===o?null:a===i?r:r=e(i=a,n)}}function $p(t,e,n){var i,r,o=n+"";return function(){var a=this.getAttributeNS(t.space,t.local);return a===o?null:a===i?r:r=e(i=a,n)}}function Kp(t,e,n){var i,r,o;return function(){var a,s,l=n(this);if(null!=l)return(a=this.getAttribute(t))===(s=l+"")?null:a===i&&s===r?o:(r=s,o=e(i=a,l));this.removeAttribute(t)}}function Zp(t,e,n){var i,r,o;return function(){var a,s,l=n(this);if(null!=l)return(a=this.getAttributeNS(t.space,t.local))===(s=l+"")?null:a===i&&s===r?o:(r=s,o=e(i=a,l));this.removeAttributeNS(t.space,t.local)}}function Jp(t,e){return function(n){this.setAttribute(t,e.call(this,n))}}function Qp(t,e){return function(n){this.setAttributeNS(t.space,t.local,e.call(this,n))}}function tf(t,e){var n,i;function r(){var r=e.apply(this,arguments);return r!==i&&(n=(i=r)&&Qp(t,r)),n}return r._value=e,r}function ef(t,e){var n,i;function r(){var r=e.apply(this,arguments);return r!==i&&(n=(i=r)&&Jp(t,r)),n}return r._value=e,r}function nf(t,e){return function(){Bp(this,t).delay=+e.apply(this,arguments)}}function rf(t,e){return e=+e,function(){Bp(this,t).delay=e}}function of(t,e){return function(){Hp(this,t).duration=+e.apply(this,arguments)}}function af(t,e){return e=+e,function(){Hp(this,t).duration=e}}function sf(t,e){if("function"!=typeof e)throw new Error;return function(){Hp(this,t).ease=e}}function lf(t,e,n){var i,r,o=(function a(t){return(t+"").trim().split(/^|\s+/).every((function(t){var e=t.indexOf(".");return e>=0&&(t=t.slice(0,e)),!t||"start"===t}))})(e)?Bp:Hp;return function(){var a=o(this,t),s=a.on;s!==i&&(r=(i=s).copy()).on(e,n),a.on=r}}var cf=wu.prototype.constructor;function uf(t){return function(){this.style.removeProperty(t)}}function hf(t,e,n){return function(i){this.style.setProperty(t,e.call(this,i),n)}}function df(t,e,n){var i,r;function o(){var o=e.apply(this,arguments);return o!==r&&(i=(r=o)&&hf(t,o,n)),i}return o._value=e,o}function pf(t){return function(e){this.textContent=t.call(this,e)}}function ff(t){var e,n;function i(){var i=t.apply(this,arguments);return i!==n&&(e=(n=i)&&pf(i)),e}return i._value=t,i}var mf=0;function gf(t,e,n,i){this._groups=t,this._parents=e,this._name=n,this._id=i}function _f(t){return wu().transition(t)}function yf(){return++mf}var vf=wu.prototype;function bf(t){return+t}function xf(t){return t*t}function wf(t){return t*(2-t)}function Sf(t){return((t*=2)<=1?t*t:--t*(2-t)+1)/2}function Mf(t){return t*t*t}function Ef(t){return--t*t*t+1}function Tf(t){return((t*=2)<=1?t*t*t:(t-=2)*t*t+2)/2}gf.prototype=_f.prototype={constructor:gf,select:function Cf(t){var e=this._name,n=this._id;"function"!=typeof t&&(t=bc(t));for(var i=this._groups,r=i.length,o=new Array(r),a=0;a<r;++a)for(var s,l,c=i[a],u=c.length,h=o[a]=new Array(u),d=0;d<u;++d)(s=c[d])&&(l=t.call(s,s.__data__,d,c))&&("__data__"in s&&(l.__data__=s.__data__),h[d]=l,Dp(h[d],e,n,d,h,Fp(s,n)));return new gf(o,this._parents,e,n)},selectAll:function Af(t){var e=this._name,n=this._id;"function"!=typeof t&&(t=wc(t));for(var i=this._groups,r=i.length,o=[],a=[],s=0;s<r;++s)for(var l,c=i[s],u=c.length,h=0;h<u;++h)if(l=c[h]){for(var d,p=t.call(l,l.__data__,h,c),f=Fp(l,n),m=0,g=p.length;m<g;++m)(d=p[m])&&Dp(d,e,n,m,p,f);o.push(p),a.push(l)}return new gf(o,a,e,n)},filter:function kf(t){"function"!=typeof t&&(t=Sc(t));for(var e=this._groups,n=e.length,i=new Array(n),r=0;r<n;++r)for(var o,a=e[r],s=a.length,l=i[r]=[],c=0;c<s;++c)(o=a[c])&&t.call(o,o.__data__,c,a)&&l.push(o);return new gf(i,this._parents,this._name,this._id)},merge:function Lf(t){if(t._id!==this._id)throw new Error;for(var e=this._groups,n=t._groups,i=e.length,r=Math.min(i,n.length),o=new Array(i),a=0;a<r;++a)for(var s,l=e[a],c=n[a],u=l.length,h=o[a]=new Array(u),d=0;d<u;++d)(s=l[d]||c[d])&&(h[d]=s);for(;a<i;++a)o[a]=e[a];return new gf(o,this._parents,this._name,this._id)},selection:function Pf(){return new cf(this._groups,this._parents)},transition:function Nf(){for(var t=this._name,e=this._id,n=yf(),i=this._groups,r=i.length,o=0;o<r;++o)for(var a,s=i[o],l=s.length,c=0;c<l;++c)if(a=s[c]){var u=Fp(a,e);Dp(a,t,n,c,s,{time:u.time+u.delay+u.duration,delay:0,duration:u.duration,ease:u.ease})}return new gf(i,this._parents,t,n)},call:vf.call,nodes:vf.nodes,node:vf.node,size:vf.size,empty:vf.empty,each:vf.each,on:function If(t,e){var n=this._id;return arguments.length<2?Fp(this.node(),n).on.on(t):this.each(lf(n,t,e))},attr:function Rf(t,e){var n=mc(t),i="transform"===n?ep:Wp;return this.attrTween(t,"function"==typeof e?(n.local?Zp:Kp)(n,i,Gp(this,"attr."+t,e)):null==e?(n.local?Yp:qp)(n):(n.local?$p:Xp)(n,i,e))},attrTween:function Of(t,e){var n="attr."+t;if(arguments.length<2)return(n=this.tween(n))&&n._value;if(null==e)return this.tween(n,null);if("function"!=typeof e)throw new Error;var i=mc(t);return this.tween(n,(i.local?tf:ef)(i,e))},style:function zf(t,e,n){var i="transform"==(t+="")?Qd:Wp;return null==e?this.styleTween(t,(function r(t,e){var n,i,r;return function(){var o=Hc(this,t),a=(this.style.removeProperty(t),Hc(this,t));return o===a?null:o===n&&a===i?r:r=e(n=o,i=a)}})(t,i)).on("end.style."+t,uf(t)):"function"==typeof e?this.styleTween(t,(function a(t,e,n){var i,r,o;return function(){var a=Hc(this,t),s=n(this),l=s+"";return null==s&&(this.style.removeProperty(t),l=s=Hc(this,t)),a===l?null:a===i&&l===r?o:(r=l,o=e(i=a,s))}})(t,i,Gp(this,"style."+t,e))).each((function o(t,e){var n,i,r,o,a="style."+e,s="end."+a;return function(){var l=Hp(this,t),c=l.on,u=null==l.value[a]?o||(o=uf(e)):void 0;c===n&&r===u||(i=(n=c).copy()).on(s,r=u),l.on=i}})(this._id,t)):this.styleTween(t,(function s(t,e,n){var i,r,o=n+"";return function(){var a=Hc(this,t);return a===o?null:a===i?r:r=e(i=a,n)}})(t,i,e),n).on("end.style."+t,null)},styleTween:function Df(t,e,n){var i="style."+(t+="");if(arguments.length<2)return(i=this.tween(i))&&i._value;if(null==e)return this.tween(i,null);if("function"!=typeof e)throw new Error;return this.tween(i,df(t,e,null==n?"":n))},text:function Bf(t){return this.tween("text","function"==typeof t?(function e(t){return function(){var e=t(this);this.textContent=null==e?"":e}})(Gp(this,"text",t)):(function n(t){return function(){this.textContent=t}})(null==t?"":t+""))},textTween:function Hf(t){var e="text";if(arguments.length<1)return(e=this.tween(e))&&e._value;if(null==t)return this.tween(e,null);if("function"!=typeof t)throw new Error;return this.tween(e,ff(t))},remove:function Ff(){return this.on("end.remove",(function t(e){return function(){var t=this.parentNode;for(var n in this.__transition)if(+n!==e)return;t&&t.removeChild(this)}})(this._id))},tween:function Vf(t,e){var n=this._id;if(t+="",arguments.length<2){for(var i,r=Fp(this.node(),n).tween,o=0,a=r.length;o<a;++o)if((i=r[o]).name===t)return i.value;return null}return this.each((null==e?Up:jp)(n,t,e))},delay:function Uf(t){var e=this._id;return arguments.length?this.each(("function"==typeof t?nf:rf)(e,t)):Fp(this.node(),e).delay},duration:function jf(t){var e=this._id;return arguments.length?this.each(("function"==typeof t?of:af)(e,t)):Fp(this.node(),e).duration},ease:function Gf(t){var e=this._id;return arguments.length?this.each(sf(e,t)):Fp(this.node(),e).ease},end:function Wf(){var t,e,n=this,i=n._id,r=n.size();return new Promise((function(o,a){var s={value:a},l={value:function(){0==--r&&o()}};n.each((function(){var n=Hp(this,i),r=n.on;r!==t&&((e=(t=r).copy())._.cancel.push(s),e._.interrupt.push(s),e._.end.push(l)),n.on=e}))}))}};var qf=(function t(e){function n(t){return Math.pow(t,e)}return e=+e,n.exponent=t,n})(3),Yf=(function t(e){function n(t){return 1-Math.pow(1-t,e)}return e=+e,n.exponent=t,n})(3),Xf=(function t(e){function n(t){return((t*=2)<=1?Math.pow(t,e):2-Math.pow(2-t,e))/2}return e=+e,n.exponent=t,n})(3),$f=Math.PI,Kf=$f/2;function Zf(t){return 1==+t?1:1-Math.cos(t*Kf)}function Jf(t){return Math.sin(t*Kf)}function Qf(t){return(1-Math.cos($f*t))/2}function tm(t){return 1.0009775171065494*(Math.pow(2,-10*t)-.0009765625)}function em(t){return tm(1-+t)}function nm(t){return 1-tm(t)}function im(t){return((t*=2)<=1?tm(1-t):2-tm(t-1))/2}function rm(t){return 1-Math.sqrt(1-t*t)}function om(t){return Math.sqrt(1- --t*t)}function am(t){return((t*=2)<=1?1-Math.sqrt(1-t*t):Math.sqrt(1-(t-=2)*t)+1)/2}var sm=7.5625;function lm(t){return 1-cm(1-t)}function cm(t){return(t=+t)<.36363636363636365?sm*t*t:t<.7272727272727273?sm*(t-=.5454545454545454)*t+.75:t<.9090909090909091?sm*(t-=.8181818181818182)*t+.9375:sm*(t-=.9545454545454546)*t+.984375}function um(t){return((t*=2)<=1?1-cm(1-t):cm(t-1)+1)/2}var hm=1.70158,dm=(function t(e){function n(t){return(t=+t)*t*(e*(t-1)+t)}return e=+e,n.overshoot=t,n})(hm),pm=(function t(e){function n(t){return--t*t*((t+1)*e+t)+1}return e=+e,n.overshoot=t,n})(hm),fm=(function t(e){function n(t){return((t*=2)<1?t*t*((e+1)*t-e):(t-=2)*t*((e+1)*t+e)+2)/2}return e=+e,n.overshoot=t,n})(hm),mm=2*Math.PI,gm=(function t(e,n){var i=Math.asin(1/(e=Math.max(1,e)))*(n/=mm);function r(t){return e*tm(- --t)*Math.sin((i-t)/n)}return r.amplitude=function(e){return t(e,n*mm)},r.period=function(n){return t(e,n)},r})(1,.3),_m=(function t(e,n){var i=Math.asin(1/(e=Math.max(1,e)))*(n/=mm);function r(t){return 1-e*tm(t=+t)*Math.sin((t+i)/n)}return r.amplitude=function(e){return t(e,n*mm)},r.period=function(n){return t(e,n)},r})(1,.3),ym=(function t(e,n){var i=Math.asin(1/(e=Math.max(1,e)))*(n/=mm);function r(t){return((t=2*t-1)<0?e*tm(-t)*Math.sin((i-t)/n):2-e*tm(t)*Math.sin((i+t)/n))/2}return r.amplitude=function(e){return t(e,n*mm)},r.period=function(n){return t(e,n)},r})(1,.3),vm=Object.freeze({__proto__:null,easeLinear:bf,easeQuad:Sf,easeQuadIn:xf,easeQuadOut:wf,easeQuadInOut:Sf,easeCubic:Tf,easeCubicIn:Mf,easeCubicOut:Ef,easeCubicInOut:Tf,easePoly:Xf,easePolyIn:qf,easePolyOut:Yf,easePolyInOut:Xf,easeSin:Qf,easeSinIn:Zf,easeSinOut:Jf,easeSinInOut:Qf,easeExp:im,easeExpIn:em,easeExpOut:nm,easeExpInOut:im,easeCircle:am,easeCircleIn:rm,easeCircleOut:om,easeCircleInOut:am,easeBounce:cm,easeBounceIn:lm,easeBounceOut:cm,easeBounceInOut:um,easeBack:fm,easeBackIn:dm,easeBackOut:pm,easeBackInOut:fm,easeElastic:_m,easeElasticIn:gm,easeElasticOut:_m,easeElasticInOut:ym}),bm={time:null,delay:0,duration:250,ease:Tf};function xm(t,e){for(var n;!(n=t.__transition)||!(n=n[e]);)if(!(t=t.parentNode))return bm.time=Tp(),bm;return n}wu.prototype.interrupt=function wm(t){return this.each((function(){Vp(this,t)}))},wu.prototype.transition=function Sm(t){var e,n;t instanceof gf?(e=t._id,t=t._name):(e=yf(),(n=bm).time=Tp(),t=null==t?null:t+"");for(var i=this._groups,r=i.length,o=0;o<r;++o)for(var a,s=i[o],l=s.length,c=0;c<l;++c)(a=s[c])&&Dp(a,t,e,c,s,n||xm(a,e));return new gf(i,this._parents,t,e)};var Mm=[null];function Em(t){return function(){return t}}function Tm(t,e,n){this.target=t,this.type=e,this.selection=n}function Cm(){uu.stopImmediatePropagation()}function Am(){uu.preventDefault(),uu.stopImmediatePropagation()}var km={name:"drag"},Lm={name:"space"},Pm={name:"handle"},Nm={name:"center"};function Im(t){return[+t[0],+t[1]]}function Rm(t){return[Im(t[0]),Im(t[1])]}function Om(t){return function(e){return lh(e,uu.touches,t)}}var zm={name:"x",handles:["w","e"].map(Gm),input:function(t,e){return null==t?null:[[+t[0],e[0][1]],[+t[1],e[1][1]]]},output:function(t){return t&&[t[0][0],t[1][0]]}},Dm={name:"y",handles:["n","s"].map(Gm),input:function(t,e){return null==t?null:[[e[0][0],+t[0]],[e[1][0],+t[1]]]},output:function(t){return t&&[t[0][1],t[1][1]]}},Bm={name:"xy",handles:["n","w","e","s","nw","ne","sw","se"].map(Gm),input:function(t){return null==t?null:Rm(t)},output:function(t){return t}},Hm={overlay:"crosshair",selection:"move",n:"ns-resize",e:"ew-resize",s:"ns-resize",w:"ew-resize",nw:"nwse-resize",ne:"nesw-resize",se:"nwse-resize",sw:"nesw-resize"},Fm={e:"w",w:"e",nw:"ne",ne:"nw",se:"sw",sw:"se"},Vm={n:"s",s:"n",nw:"sw",ne:"se",se:"ne",sw:"nw"},Um={overlay:1,selection:1,n:null,e:1,s:null,w:-1,nw:-1,ne:1,se:1,sw:-1},jm={overlay:1,selection:1,n:-1,e:null,s:1,w:null,nw:-1,ne:-1,se:1,sw:1};function Gm(t){return{type:t}}function Wm(){return!uu.ctrlKey&&!uu.button}function qm(){var t=this.ownerSVGElement||this;return t.hasAttribute("viewBox")?[[(t=t.viewBox.baseVal).x,t.y],[t.x+t.width,t.y+t.height]]:[[0,0],[t.width.baseVal.value,t.height.baseVal.value]]}function Ym(){return navigator.maxTouchPoints||"ontouchstart"in this}function Xm(t){for(;!t.__brush;)if(!(t=t.parentNode))return;return t.__brush}function $m(t){return t[0][0]===t[1][0]||t[0][1]===t[1][1]}function Km(t){var e=t.__brush;return e?e.dim.output(e.selection):null}function Zm(){return Qm(Dm)}function Jm(){return Qm(Bm)}function Qm(t){var e,n=qm,i=Wm,r=Ym,o=!0,a=lc("start","brush","end"),s=6;function l(e){var n=e.property("__brush",m).selectAll(".overlay").data([Gm("overlay")]);n.enter().append("rect").attr("class","overlay").attr("pointer-events","all").attr("cursor",Hm.overlay).merge(n).each((function(){var t=Xm(this).extent;Su(this).attr("x",t[0][0]).attr("y",t[0][1]).attr("width",t[1][0]-t[0][0]).attr("height",t[1][1]-t[0][1])})),e.selectAll(".selection").data([Gm("selection")]).enter().append("rect").attr("class","selection").attr("cursor",Hm.selection).attr("fill","#777").attr("fill-opacity",.3).attr("stroke","#fff").attr("shape-rendering","crispEdges");var i=e.selectAll(".handle").data(t.handles,(function(t){return t.type}));i.exit().remove(),i.enter().append("rect").attr("class",(function(t){return"handle handle--"+t.type})).attr("cursor",(function(t){return Hm[t.type]})),e.each(c).attr("fill","none").attr("pointer-events","all").on("mousedown.brush",d).filter(r).on("touchstart.brush",d).on("touchmove.brush",p).on("touchend.brush touchcancel.brush",f).style("touch-action","none").style("-webkit-tap-highlight-color","rgba(0,0,0,0)")}function c(){var t=Su(this),e=Xm(this).selection;e?(t.selectAll(".selection").style("display",null).attr("x",e[0][0]).attr("y",e[0][1]).attr("width",e[1][0]-e[0][0]).attr("height",e[1][1]-e[0][1]),t.selectAll(".handle").style("display",null).attr("x",(function(t){return"e"===t.type[t.type.length-1]?e[1][0]-s/2:e[0][0]-s/2})).attr("y",(function(t){return"s"===t.type[0]?e[1][1]-s/2:e[0][1]-s/2})).attr("width",(function(t){return"n"===t.type||"s"===t.type?e[1][0]-e[0][0]+s:s})).attr("height",(function(t){return"e"===t.type||"w"===t.type?e[1][1]-e[0][1]+s:s}))):t.selectAll(".selection,.handle").style("display","none").attr("x",null).attr("y",null).attr("width",null).attr("height",null)}function u(t,e,n){var i=t.__brush.emitter;return!i||n&&i.clean?new h(t,e,n):i}function h(t,e,n){this.that=t,this.args=e,this.state=t.__brush,this.active=0,this.clean=n}function d(){if((!e||uu.touches)&&i.apply(this,arguments)){var n,r,a,s,l,h,d,p,f,m,g,_=this,y=uu.target.__data__.type,v="selection"===(o&&uu.metaKey?y="overlay":y)?km:o&&uu.altKey?Nm:Pm,b=t===Dm?null:Um[y],x=t===zm?null:jm[y],w=Xm(_),S=w.extent,M=w.selection,E=S[0][0],T=S[0][1],C=S[1][0],A=S[1][1],k=0,L=0,P=b&&x&&o&&uu.shiftKey,N=uu.touches?Om(uu.changedTouches[0].identifier):ah,I=N(_),R=I,O=u(_,arguments,!0).beforestart();"overlay"===y?(M&&(f=!0),w.selection=M=[[n=t===Dm?E:I[0],a=t===zm?T:I[1]],[l=t===Dm?C:n,d=t===zm?A:a]]):(n=M[0][0],a=M[0][1],l=M[1][0],d=M[1][1]),r=n,s=a,h=l,p=d;var z=Su(_).attr("pointer-events","none"),D=z.selectAll(".overlay").attr("cursor",Hm[y]);if(uu.touches)O.moved=H,O.ended=V;else{var B=Su(uu.view).on("mousemove.brush",H,!0).on("mouseup.brush",V,!0);o&&B.on("keydown.brush",U,!0).on("keyup.brush",j,!0),hh(uu.view)}Cm(),Vp(_),c.call(_),O.start()}function H(){var t=N(_);!P||m||g||(Math.abs(t[0]-R[0])>Math.abs(t[1]-R[1])?g=!0:m=!0),R=t,f=!0,Am(),F()}function F(){var t;switch(k=R[0]-I[0],L=R[1]-I[1],v){case Lm:case km:b&&(k=Math.max(E-n,Math.min(C-l,k)),r=n+k,h=l+k),x&&(L=Math.max(T-a,Math.min(A-d,L)),s=a+L,p=d+L);break;case Pm:b<0?(k=Math.max(E-n,Math.min(C-n,k)),r=n+k,h=l):b>0&&(k=Math.max(E-l,Math.min(C-l,k)),r=n,h=l+k),x<0?(L=Math.max(T-a,Math.min(A-a,L)),s=a+L,p=d):x>0&&(L=Math.max(T-d,Math.min(A-d,L)),s=a,p=d+L);break;case Nm:b&&(r=Math.max(E,Math.min(C,n-k*b)),h=Math.max(E,Math.min(C,l+k*b))),x&&(s=Math.max(T,Math.min(A,a-L*x)),p=Math.max(T,Math.min(A,d+L*x)))}h<r&&(b*=-1,t=n,n=l,l=t,t=r,r=h,h=t,y in Fm&&D.attr("cursor",Hm[y=Fm[y]])),p<s&&(x*=-1,t=a,a=d,d=t,t=s,s=p,p=t,y in Vm&&D.attr("cursor",Hm[y=Vm[y]])),w.selection&&(M=w.selection),m&&(r=M[0][0],h=M[1][0]),g&&(s=M[0][1],p=M[1][1]),M[0][0]===r&&M[0][1]===s&&M[1][0]===h&&M[1][1]===p||(w.selection=[[r,s],[h,p]],c.call(_),O.brush())}function V(){if(Cm(),uu.touches){if(uu.touches.length)return;e&&clearTimeout(e),e=setTimeout((function(){e=null}),500)}else dh(uu.view,f),B.on("keydown.brush keyup.brush mousemove.brush mouseup.brush",null);z.attr("pointer-events","all"),D.attr("cursor",Hm.overlay),w.selection&&(M=w.selection),$m(M)&&(w.selection=null,c.call(_)),O.end()}function U(){switch(uu.keyCode){case 16:P=b&&x;break;case 18:v===Pm&&(b&&(l=h-k*b,n=r+k*b),x&&(d=p-L*x,a=s+L*x),v=Nm,F());break;case 32:v!==Pm&&v!==Nm||(b<0?l=h-k:b>0&&(n=r-k),x<0?d=p-L:x>0&&(a=s-L),v=Lm,D.attr("cursor",Hm.selection),F());break;default:return}Am()}function j(){switch(uu.keyCode){case 16:P&&(m=g=P=!1,F());break;case 18:v===Nm&&(b<0?l=h:b>0&&(n=r),x<0?d=p:x>0&&(a=s),v=Pm,F());break;case 32:v===Lm&&(uu.altKey?(b&&(l=h-k*b,n=r+k*b),x&&(d=p-L*x,a=s+L*x),v=Nm):(b<0?l=h:b>0&&(n=r),x<0?d=p:x>0&&(a=s),v=Pm),D.attr("cursor",Hm[y]),F());break;default:return}Am()}}function p(){u(this,arguments).moved()}function f(){u(this,arguments).ended()}function m(){var e=this.__brush||{selection:null};return e.extent=Rm(n.apply(this,arguments)),e.dim=t,e}return l.move=function(e,n){e.selection?e.on("start.brush",(function(){u(this,arguments).beforestart().start()})).on("interrupt.brush end.brush",(function(){u(this,arguments).end()})).tween("brush",(function(){var e=this,i=e.__brush,r=u(e,arguments),o=i.selection,a=t.input("function"==typeof n?n.apply(this,arguments):n,i.extent),s=jd(o,a);function l(t){i.selection=1===t&&null===a?null:s(t),c.call(e),r.brush()}return null!==o&&null!==a?l:l(1)})):e.each((function(){var e=this,i=arguments,r=e.__brush,o=t.input("function"==typeof n?n.apply(e,i):n,r.extent),a=u(e,i).beforestart();Vp(e),r.selection=null===o?null:o,c.call(e),a.start().brush().end()}))},l.clear=function(t){l.move(t,null)},h.prototype={beforestart:function(){return 1==++this.active&&(this.state.emitter=this,this.starting=!0),this},start:function(){return this.starting?(this.starting=!1,this.emit("start")):this.emit("brush"),this},brush:function(){return this.emit("brush"),this},end:function(){return 0==--this.active&&(delete this.state.emitter,this.emit("end")),this},emit:function(e){gu(new Tm(l,e,t.output(this.state.selection)),a.apply,a,[e,this.that,this.args])}},l.extent=function(t){return arguments.length?(n="function"==typeof t?t:Em(Rm(t)),l):n},l.filter=function(t){return arguments.length?(i="function"==typeof t?t:Em(!!t),l):i},l.touchable=function(t){return arguments.length?(r="function"==typeof t?t:Em(!!t),l):r},l.handleSize=function(t){return arguments.length?(s=+t,l):s},l.keyModifiers=function(t){return arguments.length?(o=!!t,l):o},l.on=function(){var t=a.on.apply(a,arguments);return t===a?l:t},l}var tg=Math.cos,eg=Math.sin,ng=Math.PI,ig=ng/2,rg=2*ng,og=Math.max;function ag(t){return function(e,n){return t(e.source.value+e.target.value,n.source.value+n.target.value)}}var sg=Array.prototype.slice;function lg(t){return function(){return t}}var cg=Math.PI,ug=2*cg,hg=1e-6,dg=ug-hg;function pg(){this._x0=this._y0=this._x1=this._y1=null,this._=""}function fg(){return new pg}function mg(t){return t.source}function gg(t){return t.target}function _g(t){return t.radius}function yg(t){return t.startAngle}function vg(t){return t.endAngle}pg.prototype=fg.prototype={constructor:pg,moveTo:function(t,e){this._+="M"+(this._x0=this._x1=+t)+","+(this._y0=this._y1=+e)},closePath:function(){null!==this._x1&&(this._x1=this._x0,this._y1=this._y0,this._+="Z")},lineTo:function(t,e){this._+="L"+(this._x1=+t)+","+(this._y1=+e)},quadraticCurveTo:function(t,e,n,i){this._+="Q"+ +t+","+ +e+","+(this._x1=+n)+","+(this._y1=+i)},bezierCurveTo:function(t,e,n,i,r,o){this._+="C"+ +t+","+ +e+","+ +n+","+ +i+","+(this._x1=+r)+","+(this._y1=+o)},arcTo:function(t,e,n,i,r){var o=this._x1,a=this._y1,s=(n=+n)-(t=+t),l=(i=+i)-(e=+e),c=o-t,u=a-e,h=c*c+u*u;if((r=+r)<0)throw new Error("negative radius: "+r);if(null===this._x1)this._+="M"+(this._x1=t)+","+(this._y1=e);else if(h>hg)if(Math.abs(u*s-l*c)>hg&&r){var d=n-o,p=i-a,f=s*s+l*l,m=d*d+p*p,g=Math.sqrt(f),_=Math.sqrt(h),y=r*Math.tan((cg-Math.acos((f+h-m)/(2*g*_)))/2),v=y/_,b=y/g;Math.abs(v-1)>hg&&(this._+="L"+(t+v*c)+","+(e+v*u)),this._+="A"+r+","+r+",0,0,"+ +(u*d>c*p)+","+(this._x1=t+b*s)+","+(this._y1=e+b*l)}else this._+="L"+(this._x1=t)+","+(this._y1=e)},arc:function(t,e,n,i,r,o){t=+t,e=+e,o=!!o;var a=(n=+n)*Math.cos(i),s=n*Math.sin(i),l=t+a,c=e+s,u=1^o,h=o?i-r:r-i;if(n<0)throw new Error("negative radius: "+n);null===this._x1?this._+="M"+l+","+c:(Math.abs(this._x1-l)>hg||Math.abs(this._y1-c)>hg)&&(this._+="L"+l+","+c),n&&(h<0&&(h=h%ug+ug),h>dg?this._+="A"+n+","+n+",0,1,"+u+","+(t-a)+","+(e-s)+"A"+n+","+n+",0,1,"+u+","+(this._x1=l)+","+(this._y1=c):h>hg&&(this._+="A"+n+","+n+",0,"+ +(h>=cg)+","+u+","+(this._x1=t+n*Math.cos(r))+","+(this._y1=e+n*Math.sin(r))))},rect:function(t,e,n,i){this._+="M"+(this._x0=this._x1=+t)+","+(this._y0=this._y1=+e)+"h"+ +n+"v"+ +i+"h"+-n+"Z"},toString:function(){return this._}};var bg="$";function xg(){}function wg(t,e){var n=new xg;if(t instanceof xg)t.each((function(t,e){n.set(e,t)}));else if(Array.isArray(t)){var i,r=-1,o=t.length;if(null==e)for(;++r<o;)n.set(r,t[r]);else for(;++r<o;)n.set(e(i=t[r],r,t),i)}else if(t)for(var a in t)n.set(a,t[a]);return n}function Sg(){return{}}function Mg(t,e,n){t[e]=n}function Eg(){return wg()}function Tg(t,e,n){t.set(e,n)}function Cg(){}xg.prototype=wg.prototype={constructor:xg,has:function(t){return bg+t in this},get:function(t){return this[bg+t]},set:function(t,e){return this[bg+t]=e,this},remove:function(t){var e=bg+t;return e in this&&delete this[e]},clear:function(){for(var t in this)t[0]===bg&&delete this[t]},keys:function(){var t=[];for(var e in this)e[0]===bg&&t.push(e.slice(1));return t},values:function(){var t=[];for(var e in this)e[0]===bg&&t.push(this[e]);return t},entries:function(){var t=[];for(var e in this)e[0]===bg&&t.push({key:e.slice(1),value:this[e]});return t},size:function(){var t=0;for(var e in this)e[0]===bg&&++t;return t},empty:function(){for(var t in this)if(t[0]===bg)return!1;return!0},each:function(t){for(var e in this)e[0]===bg&&t(this[e],e.slice(1),this)}};var Ag=wg.prototype;function kg(t,e){var n=new Cg;if(t instanceof Cg)t.each((function(t){n.add(t)}));else if(t){var i=-1,r=t.length;if(null==e)for(;++i<r;)n.add(t[i]);else for(;++i<r;)n.add(e(t[i],i,t))}return n}function Lg(t){var e=[];for(var n in t)e.push(n);return e}Cg.prototype=kg.prototype={constructor:Cg,has:Ag.has,add:function(t){return this[bg+(t+="")]=t,this},remove:Ag.remove,clear:Ag.clear,values:Ag.keys,size:Ag.size,empty:Ag.empty,each:Ag.each};var Pg=Array.prototype.slice;function Ng(t,e){return t-e}function Ig(t){return function(){return t}}function Rg(t,e){for(var n,i=-1,r=e.length;++i<r;)if(n=Og(t,e[i]))return n;return 0}function Og(t,e){for(var n=e[0],i=e[1],r=-1,o=0,a=t.length,s=a-1;o<a;s=o++){var l=t[o],c=l[0],u=l[1],h=t[s],d=h[0],p=h[1];if(zg(l,h,e))return 0;u>i!=p>i&&n<(d-c)*(i-u)/(p-u)+c&&(r=-r)}return r}function zg(t,e,n){var i;return(function r(t,e,n){return(e[0]-t[0])*(n[1]-t[1])==(n[0]-t[0])*(e[1]-t[1])})(t,e,n)&&(function o(t,e,n){return t<=e&&e<=n||n<=e&&e<=t})(t[i=+(t[0]===e[0])],n[i],e[i])}function Dg(){}var Bg=[[],[[[1,1.5],[.5,1]]],[[[1.5,1],[1,1.5]]],[[[1.5,1],[.5,1]]],[[[1,.5],[1.5,1]]],[[[1,1.5],[.5,1]],[[1,.5],[1.5,1]]],[[[1,.5],[1,1.5]]],[[[1,.5],[.5,1]]],[[[.5,1],[1,.5]]],[[[1,1.5],[1,.5]]],[[[.5,1],[1,.5]],[[1.5,1],[1,1.5]]],[[[1.5,1],[1,.5]]],[[[.5,1],[1.5,1]]],[[[1,1.5],[1.5,1]]],[[[.5,1],[1,1.5]]],[]];function Hg(){var t=1,e=1,n=jl,i=s;function r(t){var e=n(t);if(Array.isArray(e))e=e.slice().sort(Ng);else{var i=Ll(t),r=i[0],a=i[1];e=Ul(r,a,e),e=zl(Math.floor(r/e)*e,Math.floor(a/e)*e,e)}return e.map((function(e){return o(t,e)}))}function o(n,r){var o=[],s=[];return(function l(n,i,r){var o,s,l,c,u,h=new Array,d=new Array;for(o=s=-1,Bg[(l=n[0]>=i)<<1].forEach(p);++o<t-1;)Bg[l|(l=n[o+1]>=i)<<1].forEach(p);for(Bg[l<<0].forEach(p);++s<e-1;){for(o=-1,Bg[(l=n[s*t+t]>=i)<<1|(c=n[s*t]>=i)<<2].forEach(p);++o<t-1;)u=c,Bg[l|(l=n[s*t+t+o+1]>=i)<<1|(c=n[s*t+o+1]>=i)<<2|u<<3].forEach(p);Bg[l|c<<3].forEach(p)}for(o=-1,Bg[(c=n[s*t]>=i)<<2].forEach(p);++o<t-1;)u=c,Bg[(c=n[s*t+o+1]>=i)<<2|u<<3].forEach(p);function p(t){var e,n,i=[t[0][0]+o,t[0][1]+s],l=[t[1][0]+o,t[1][1]+s],c=a(i),u=a(l);(e=d[c])?(n=h[u])?(delete d[e.end],delete h[n.start],e===n?(e.ring.push(l),r(e.ring)):h[e.start]=d[n.end]={start:e.start,end:n.end,ring:e.ring.concat(n.ring)}):(delete d[e.end],e.ring.push(l),d[e.end=u]=e):(e=h[u])?(n=d[c])?(delete h[e.start],delete d[n.end],e===n?(e.ring.push(l),r(e.ring)):h[n.start]=d[e.end]={start:n.start,end:e.end,ring:n.ring.concat(e.ring)}):(delete h[e.start],e.ring.unshift(i),h[e.start=c]=e):h[c]=d[u]={start:c,end:u,ring:[i,l]}}Bg[c<<3].forEach(p)})(n,r,(function(t){i(t,n,r),(function e(t){for(var e=0,n=t.length,i=t[n-1][1]*t[0][0]-t[n-1][0]*t[0][1];++e<n;)i+=t[e-1][1]*t[e][0]-t[e-1][0]*t[e][1];return i})(t)>0?o.push([t]):s.push(t)})),s.forEach((function(t){for(var e,n=0,i=o.length;n<i;++n)if(-1!==Rg((e=o[n])[0],t))return void e.push(t)})),{type:"MultiPolygon",value:r,coordinates:o}}function a(e){return 2*e[0]+e[1]*(t+1)*4}function s(n,i,r){n.forEach((function(n){var o,a=n[0],s=n[1],l=0|a,c=0|s,u=i[c*t+l];a>0&&a<t&&l===a&&(n[0]=a+(r-(o=i[c*t+l-1]))/(u-o)-.5),s>0&&s<e&&c===s&&(n[1]=s+(r-(o=i[(c-1)*t+l]))/(u-o)-.5)}))}return r.contour=o,r.size=function(n){if(!arguments.length)return[t,e];var i=Math.ceil(n[0]),o=Math.ceil(n[1]);if(!(i>0&&o>0))throw new Error("invalid size");return t=i,e=o,r},r.thresholds=function(t){return arguments.length?(n="function"==typeof t?t:Array.isArray(t)?Ig(Pg.call(t)):Ig(t),r):n},r.smooth=function(t){return arguments.length?(i=t?s:Dg,r):i===s},r}function Fg(t,e,n){for(var i=t.width,r=t.height,o=1+(n<<1),a=0;a<r;++a)for(var s=0,l=0;s<i+n;++s)s<i&&(l+=t.data[s+a*i]),s>=n&&(s>=o&&(l-=t.data[s-o+a*i]),e.data[s-n+a*i]=l/Math.min(s+1,i-1+o-s,o))}function Vg(t,e,n){for(var i=t.width,r=t.height,o=1+(n<<1),a=0;a<i;++a)for(var s=0,l=0;s<r+n;++s)s<r&&(l+=t.data[a+s*i]),s>=n&&(s>=o&&(l-=t.data[a+(s-o)*i]),e.data[a+(s-n)*i]=l/Math.min(s+1,r-1+o-s,o))}function Ug(t){return t[0]}function jg(t){return t[1]}function Gg(){return 1}var Wg={},qg={};function Yg(t){return new Function("d","return {"+t.map((function(t,e){return JSON.stringify(t)+": d["+e+'] || ""'})).join(",")+"}")}function Xg(t){var e=Object.create(null),n=[];return t.forEach((function(t){for(var i in t)i in e||n.push(e[i]=i)})),n}function $g(t,e){var n=t+"",i=n.length;return i<e?new Array(e-i+1).join(0)+n:n}function Kg(t){var e=new RegExp('["'+t+"\n\r]"),n=t.charCodeAt(0);function i(t,e){var i,r=[],o=t.length,a=0,s=0,l=o<=0,c=!1;function u(){if(l)return qg;if(c)return c=!1,Wg;var e,i,r=a;if(34===t.charCodeAt(r)){for(;a++<o&&34!==t.charCodeAt(a)||34===t.charCodeAt(++a););return(e=a)>=o?l=!0:10===(i=t.charCodeAt(a++))?c=!0:13===i&&(c=!0,10===t.charCodeAt(a)&&++a),t.slice(r+1,e-1).replace(/""/g,'"')}for(;a<o;){if(10===(i=t.charCodeAt(e=a++)))c=!0;else if(13===i)c=!0,10===t.charCodeAt(a)&&++a;else if(i!==n)continue;return t.slice(r,e)}return l=!0,t.slice(r,o)}for(10===t.charCodeAt(o-1)&&--o,13===t.charCodeAt(o-1)&&--o;(i=u())!==qg;){for(var h=[];i!==Wg&&i!==qg;)h.push(i),i=u();e&&null==(h=e(h,s++))||r.push(h)}return r}function r(e,n){return e.map((function(e){return n.map((function(t){return a(e[t])})).join(t)}))}function o(e){return e.map(a).join(t)}function a(t){return null==t?"":t instanceof Date?(function n(t){var e=t.getUTCHours(),n=t.getUTCMinutes(),i=t.getUTCSeconds(),r=t.getUTCMilliseconds();return isNaN(t)?"Invalid Date":(function o(t){return t<0?"-"+$g(-t,6):t>9999?"+"+$g(t,6):$g(t,4)})(t.getUTCFullYear())+"-"+$g(t.getUTCMonth()+1,2)+"-"+$g(t.getUTCDate(),2)+(r?"T"+$g(e,2)+":"+$g(n,2)+":"+$g(i,2)+"."+$g(r,3)+"Z":i?"T"+$g(e,2)+":"+$g(n,2)+":"+$g(i,2)+"Z":n||e?"T"+$g(e,2)+":"+$g(n,2)+"Z":"")})(t):e.test(t+="")?'"'+t.replace(/"/g,'""')+'"':t}return{parse:function s(t,e){var n,r,o=i(t,(function(t,i){if(n)return n(t,i-1);r=t,n=e?(function o(t,e){var n=Yg(t);return function(i,r){return e(n(i),r,t)}})(t,e):Yg(t)}));return o.columns=r||[],o},parseRows:i,format:function l(e,n){return null==n&&(n=Xg(e)),[n.map(a).join(t)].concat(r(e,n)).join("\n")},formatBody:function c(t,e){return null==e&&(e=Xg(t)),r(t,e).join("\n")},formatRows:function u(t){return t.map(o).join("\n")},formatRow:o,formatValue:a}}var Zg=Kg(","),Jg=Zg.parse,Qg=Zg.parseRows,t_=Zg.format,e_=Zg.formatBody,n_=Zg.formatRows,i_=Zg.formatRow,r_=Zg.formatValue,o_=Kg("\t"),a_=o_.parse,s_=o_.parseRows,l_=o_.format,c_=o_.formatBody,u_=o_.formatRows,h_=o_.formatRow,d_=o_.formatValue,p_=new Date("2019-01-01T00:00").getHours()||new Date("2019-07-01T00:00").getHours();function f_(t){if(!t.ok)throw new Error(t.status+" "+t.statusText);return t.blob()}function m_(t){if(!t.ok)throw new Error(t.status+" "+t.statusText);return t.arrayBuffer()}function g_(t){if(!t.ok)throw new Error(t.status+" "+t.statusText);return t.text()}function __(t,e){return fetch(t,e).then(g_)}function y_(t){return function(e,n,i){return 2===arguments.length&&"function"==typeof n&&(i=n,n=void 0),__(e,n).then((function(e){return t(e,i)}))}}var v_=y_(Jg),b_=y_(a_);function x_(t){if(!t.ok)throw new Error(t.status+" "+t.statusText);if(204!==t.status&&205!==t.status)return t.json()}function w_(t){return function(e,n){return __(e,n).then((function(e){return(new DOMParser).parseFromString(e,t)}))}}var S_=w_("application/xml"),M_=w_("text/html"),E_=w_("image/svg+xml");function T_(t){return function(){return t}}function C_(){return 1e-6*(Math.random()-.5)}function A_(t,e,n,i){if(isNaN(e)||isNaN(n))return t;var r,o,a,s,l,c,u,h,d,p=t._root,f={data:i},m=t._x0,g=t._y0,_=t._x1,y=t._y1;if(!p)return t._root=f,t;for(;p.length;)if((c=e>=(o=(m+_)/2))?m=o:_=o,(u=n>=(a=(g+y)/2))?g=a:y=a,r=p,!(p=p[h=u<<1|c]))return r[h]=f,t;if(s=+t._x.call(null,p.data),l=+t._y.call(null,p.data),e===s&&n===l)return f.next=p,r?r[h]=f:t._root=f,t;do{r=r?r[h]=new Array(4):t._root=new Array(4),(c=e>=(o=(m+_)/2))?m=o:_=o,(u=n>=(a=(g+y)/2))?g=a:y=a}while((h=u<<1|c)==(d=(l>=a)<<1|s>=o));return r[d]=p,r[h]=f,t}function k_(t,e,n,i,r){this.node=t,this.x0=e,this.y0=n,this.x1=i,this.y1=r}function L_(t){return t[0]}function P_(t){return t[1]}function N_(t,e,n){var i=new I_(null==e?L_:e,null==n?P_:n,NaN,NaN,NaN,NaN);return null==t?i:i.addAll(t)}function I_(t,e,n,i,r,o){this._x=t,this._y=e,this._x0=n,this._y0=i,this._x1=r,this._y1=o,this._root=void 0}function R_(t){for(var e={data:t.data},n=e;t=t.next;)n=n.next={data:t.data};return e}var O_=N_.prototype=I_.prototype;function z_(t){return t.x+t.vx}function D_(t){return t.y+t.vy}function B_(t){return t.index}function H_(t,e){var n=t.get(e);if(!n)throw new Error("missing: "+e);return n}function F_(t){return t.x}function V_(t){return t.y}O_.copy=function(){var t,e,n=new I_(this._x,this._y,this._x0,this._y0,this._x1,this._y1),i=this._root;if(!i)return n;if(!i.length)return n._root=R_(i),n;for(t=[{source:i,target:n._root=new Array(4)}];i=t.pop();)for(var r=0;r<4;++r)(e=i.source[r])&&(e.length?t.push({source:e,target:i.target[r]=new Array(4)}):i.target[r]=R_(e));return n},O_.add=function U_(t){var e=+this._x.call(null,t),n=+this._y.call(null,t);return A_(this.cover(e,n),e,n,t)},O_.addAll=function j_(t){var e,n,i,r,o=t.length,a=new Array(o),s=new Array(o),l=1/0,c=1/0,u=-1/0,h=-1/0;for(n=0;n<o;++n)isNaN(i=+this._x.call(null,e=t[n]))||isNaN(r=+this._y.call(null,e))||(a[n]=i,s[n]=r,i<l&&(l=i),i>u&&(u=i),r<c&&(c=r),r>h&&(h=r));if(l>u||c>h)return this;for(this.cover(l,c).cover(u,h),n=0;n<o;++n)A_(this,a[n],s[n],t[n]);return this},O_.cover=function G_(t,e){if(isNaN(t=+t)||isNaN(e=+e))return this;var n=this._x0,i=this._y0,r=this._x1,o=this._y1;if(isNaN(n))r=(n=Math.floor(t))+1,o=(i=Math.floor(e))+1;else{for(var a,s,l=r-n,c=this._root;n>t||t>=r||i>e||e>=o;)switch(s=(e<i)<<1|t<n,(a=new Array(4))[s]=c,c=a,l*=2,s){case 0:r=n+l,o=i+l;break;case 1:n=r-l,o=i+l;break;case 2:r=n+l,i=o-l;break;case 3:n=r-l,i=o-l}this._root&&this._root.length&&(this._root=c)}return this._x0=n,this._y0=i,this._x1=r,this._y1=o,this},O_.data=function W_(){var t=[];return this.visit((function(e){if(!e.length)do{t.push(e.data)}while(e=e.next)})),t},O_.extent=function q_(t){return arguments.length?this.cover(+t[0][0],+t[0][1]).cover(+t[1][0],+t[1][1]):isNaN(this._x0)?void 0:[[this._x0,this._y0],[this._x1,this._y1]]},O_.find=function Y_(t,e,n){var i,r,o,a,s,l,c,u=this._x0,h=this._y0,d=this._x1,p=this._y1,f=[],m=this._root;for(m&&f.push(new k_(m,u,h,d,p)),null==n?n=1/0:(u=t-n,h=e-n,d=t+n,p=e+n,n*=n);l=f.pop();)if(!(!(m=l.node)||(r=l.x0)>d||(o=l.y0)>p||(a=l.x1)<u||(s=l.y1)<h))if(m.length){var g=(r+a)/2,_=(o+s)/2;f.push(new k_(m[3],g,_,a,s),new k_(m[2],r,_,g,s),new k_(m[1],g,o,a,_),new k_(m[0],r,o,g,_)),(c=(e>=_)<<1|t>=g)&&(l=f[f.length-1],f[f.length-1]=f[f.length-1-c],f[f.length-1-c]=l)}else{var y=t-+this._x.call(null,m.data),v=e-+this._y.call(null,m.data),b=y*y+v*v;if(b<n){var x=Math.sqrt(n=b);u=t-x,h=e-x,d=t+x,p=e+x,i=m.data}}return i},O_.remove=function X_(t){if(isNaN(o=+this._x.call(null,t))||isNaN(a=+this._y.call(null,t)))return this;var e,n,i,r,o,a,s,l,c,u,h,d,p=this._root,f=this._x0,m=this._y0,g=this._x1,_=this._y1;if(!p)return this;if(p.length)for(;;){if((c=o>=(s=(f+g)/2))?f=s:g=s,(u=a>=(l=(m+_)/2))?m=l:_=l,e=p,!(p=p[h=u<<1|c]))return this;if(!p.length)break;(e[h+1&3]||e[h+2&3]||e[h+3&3])&&(n=e,d=h)}for(;p.data!==t;)if(i=p,!(p=p.next))return this;return(r=p.next)&&delete p.next,i?(r?i.next=r:delete i.next,this):e?(r?e[h]=r:delete e[h],(p=e[0]||e[1]||e[2]||e[3])&&p===(e[3]||e[2]||e[1]||e[0])&&!p.length&&(n?n[d]=p:this._root=p),this):(this._root=r,this)},O_.removeAll=function $_(t){for(var e=0,n=t.length;e<n;++e)this.remove(t[e]);return this},O_.root=function K_(){return this._root},O_.size=function Z_(){var t=0;return this.visit((function(e){if(!e.length)do{++t}while(e=e.next)})),t},O_.visit=function J_(t){var e,n,i,r,o,a,s=[],l=this._root;for(l&&s.push(new k_(l,this._x0,this._y0,this._x1,this._y1));e=s.pop();)if(!t(l=e.node,i=e.x0,r=e.y0,o=e.x1,a=e.y1)&&l.length){var c=(i+o)/2,u=(r+a)/2;(n=l[3])&&s.push(new k_(n,c,u,o,a)),(n=l[2])&&s.push(new k_(n,i,u,c,a)),(n=l[1])&&s.push(new k_(n,c,r,o,u)),(n=l[0])&&s.push(new k_(n,i,r,c,u))}return this},O_.visitAfter=function Q_(t){var e,n=[],i=[];for(this._root&&n.push(new k_(this._root,this._x0,this._y0,this._x1,this._y1));e=n.pop();){var r=e.node;if(r.length){var o,a=e.x0,s=e.y0,l=e.x1,c=e.y1,u=(a+l)/2,h=(s+c)/2;(o=r[0])&&n.push(new k_(o,a,s,u,h)),(o=r[1])&&n.push(new k_(o,u,s,l,h)),(o=r[2])&&n.push(new k_(o,a,h,u,c)),(o=r[3])&&n.push(new k_(o,u,h,l,c))}i.push(e)}for(;e=i.pop();)t(e.node,e.x0,e.y0,e.x1,e.y1);return this},O_.x=function ty(t){return arguments.length?(this._x=t,this):this._x},O_.y=function ey(t){return arguments.length?(this._y=t,this):this._y};var ny=Math.PI*(3-Math.sqrt(5));function iy(t,e){if((n=(t=e?t.toExponential(e-1):t.toExponential()).indexOf("e"))<0)return null;var n,i=t.slice(0,n);return[i.length>1?i[0]+i.slice(2):i,+t.slice(n+1)]}function ry(t){return(t=iy(Math.abs(t)))?t[1]:NaN}var oy,ay=/^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;function sy(t){if(!(e=ay.exec(t)))throw new Error("invalid format: "+t);var e;return new ly({fill:e[1],align:e[2],sign:e[3],symbol:e[4],zero:e[5],width:e[6],comma:e[7],precision:e[8]&&e[8].slice(1),trim:e[9],type:e[10]})}function ly(t){this.fill=void 0===t.fill?" ":t.fill+"",this.align=void 0===t.align?">":t.align+"",this.sign=void 0===t.sign?"-":t.sign+"",this.symbol=void 0===t.symbol?"":t.symbol+"",this.zero=!!t.zero,this.width=void 0===t.width?void 0:+t.width,this.comma=!!t.comma,this.precision=void 0===t.precision?void 0:+t.precision,this.trim=!!t.trim,this.type=void 0===t.type?"":t.type+""}function cy(t,e){var n=iy(t,e);if(!n)return t+"";var i=n[0],r=n[1];return r<0?"0."+new Array(-r).join("0")+i:i.length>r+1?i.slice(0,r+1)+"."+i.slice(r+1):i+new Array(r-i.length+2).join("0")}sy.prototype=ly.prototype,ly.prototype.toString=function(){return this.fill+this.align+this.sign+this.symbol+(this.zero?"0":"")+(void 0===this.width?"":Math.max(1,0|this.width))+(this.comma?",":"")+(void 0===this.precision?"":"."+Math.max(0,0|this.precision))+(this.trim?"~":"")+this.type};var uy={"%":function(t,e){return(100*t).toFixed(e)},b:function(t){return Math.round(t).toString(2)},c:function(t){return t+""},d:function hy(t){return Math.abs(t=Math.round(t))>=1e21?t.toLocaleString("en").replace(/,/g,""):t.toString(10)},e:function(t,e){return t.toExponential(e)},f:function(t,e){return t.toFixed(e)},g:function(t,e){return t.toPrecision(e)},o:function(t){return Math.round(t).toString(8)},p:function(t,e){return cy(100*t,e)},r:cy,s:function dy(t,e){var n=iy(t,e);if(!n)return t+"";var i=n[0],r=n[1],o=r-(oy=3*Math.max(-8,Math.min(8,Math.floor(r/3))))+1,a=i.length;return o===a?i:o>a?i+new Array(o-a+1).join("0"):o>0?i.slice(0,o)+"."+i.slice(o):"0."+new Array(1-o).join("0")+iy(t,Math.max(0,e+o-1))[0]},X:function(t){return Math.round(t).toString(16).toUpperCase()},x:function(t){return Math.round(t).toString(16)}};function py(t){return t}var fy,my,gy,_y=Array.prototype.map,yy=["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"];function vy(t){var e=void 0===t.grouping||void 0===t.thousands?py:(function n(t,e){return function(n,i){for(var r=n.length,o=[],a=0,s=t[0],l=0;r>0&&s>0&&(l+s+1>i&&(s=Math.max(1,i-l)),o.push(n.substring(r-=s,r+s)),!((l+=s+1)>i));)s=t[a=(a+1)%t.length];return o.reverse().join(e)}})(_y.call(t.grouping,Number),t.thousands+""),i=void 0===t.currency?"":t.currency[0]+"",r=void 0===t.currency?"":t.currency[1]+"",o=void 0===t.decimal?".":t.decimal+"",a=void 0===t.numerals?py:(function s(t){return function(e){return e.replace(/[0-9]/g,(function(e){return t[+e]}))}})(_y.call(t.numerals,String)),l=void 0===t.percent?"%":t.percent+"",c=void 0===t.minus?"-":t.minus+"",u=void 0===t.nan?"NaN":t.nan+"";function h(t){var n=(t=sy(t)).fill,s=t.align,h=t.sign,d=t.symbol,p=t.zero,f=t.width,m=t.comma,g=t.precision,_=t.trim,y=t.type;"n"===y?(m=!0,y="g"):uy[y]||(void 0===g&&(g=12),_=!0,y="g"),(p||"0"===n&&"="===s)&&(p=!0,n="0",s="=");var v="$"===d?i:"#"===d&&/[boxX]/.test(y)?"0"+y.toLowerCase():"",b="$"===d?r:/[%p]/.test(y)?l:"",x=uy[y],w=/[defgprs%]/.test(y);function S(t){var i,r,l,d=v,S=b;if("c"===y)S=x(t)+S,t="";else{var M=(t=+t)<0||1/t<0;if(t=isNaN(t)?u:x(Math.abs(t),g),_&&(t=(function E(t){t:for(var e,n=t.length,i=1,r=-1;i<n;++i)switch(t[i]){case".":r=e=i;break;case"0":0===r&&(r=i),e=i;break;default:if(!+t[i])break t;r>0&&(r=0)}return r>0?t.slice(0,r)+t.slice(e+1):t})(t)),M&&0==+t&&"+"!==h&&(M=!1),d=(M?"("===h?h:c:"-"===h||"("===h?"":h)+d,S=("s"===y?yy[8+oy/3]:"")+S+(M&&"("===h?")":""),w)for(i=-1,r=t.length;++i<r;)if(48>(l=t.charCodeAt(i))||l>57){S=(46===l?o+t.slice(i+1):t.slice(i))+S,t=t.slice(0,i);break}}m&&!p&&(t=e(t,1/0));var T=d.length+t.length+S.length,C=T<f?new Array(f-T+1).join(n):"";switch(m&&p&&(t=e(C+t,C.length?f-S.length:1/0),C=""),s){case"<":t=d+t+S+C;break;case"=":t=d+C+t+S;break;case"^":t=C.slice(0,T=C.length>>1)+d+t+S+C.slice(T);break;default:t=C+d+t+S}return a(t)}return g=void 0===g?6:/[gprs]/.test(y)?Math.max(1,Math.min(21,g)):Math.max(0,Math.min(20,g)),S.toString=function(){return t+""},S}return{format:h,formatPrefix:function d(t,e){var n=h(((t=sy(t)).type="f",t)),i=3*Math.max(-8,Math.min(8,Math.floor(ry(e)/3))),r=Math.pow(10,-i),o=yy[8+i/3];return function(t){return n(r*t)+o}}}}function by(t){return fy=vy(t),my=fy.format,gy=fy.formatPrefix,fy}function xy(t){return Math.max(0,-ry(Math.abs(t)))}function wy(t,e){return Math.max(0,3*Math.max(-8,Math.min(8,Math.floor(ry(e)/3)))-ry(Math.abs(t)))}function Sy(t,e){return t=Math.abs(t),e=Math.abs(e)-t,Math.max(0,ry(e)-ry(t))+1}function My(){return new Ey}function Ey(){this.reset()}by({decimal:".",thousands:",",grouping:[3],currency:["$",""],minus:"-"}),Ey.prototype={constructor:Ey,reset:function(){this.s=this.t=0},add:function(t){Cy(Ty,t,this.t),Cy(this,Ty.s,this.s),this.s?this.t+=Ty.t:this.s=Ty.t},valueOf:function(){return this.s}};var Ty=new Ey;function Cy(t,e,n){var i=t.s=e+n,r=i-e;t.t=e-(i-r)+(n-r)}var Ay=1e-6,ky=1e-12,Ly=Math.PI,Py=Ly/2,Ny=Ly/4,Iy=2*Ly,Ry=180/Ly,Oy=Ly/180,zy=Math.abs,Dy=Math.atan,By=Math.atan2,Hy=Math.cos,Fy=Math.ceil,Vy=Math.exp,Uy=Math.log,jy=Math.pow,Gy=Math.sin,Wy=Math.sign||function(t){return t>0?1:t<0?-1:0},qy=Math.sqrt,Yy=Math.tan;function Xy(t){return t>1?0:t<-1?Ly:Math.acos(t)}function $y(t){return t>1?Py:t<-1?-Py:Math.asin(t)}function Ky(t){return(t=Gy(t/2))*t}function Zy(){}function Jy(t,e){t&&tv.hasOwnProperty(t.type)&&tv[t.type](t,e)}var Qy={Feature:function(t,e){Jy(t.geometry,e)},FeatureCollection:function(t,e){for(var n=t.features,i=-1,r=n.length;++i<r;)Jy(n[i].geometry,e)}},tv={Sphere:function(t,e){e.sphere()},Point:function(t,e){e.point((t=t.coordinates)[0],t[1],t[2])},MultiPoint:function(t,e){for(var n=t.coordinates,i=-1,r=n.length;++i<r;)e.point((t=n[i])[0],t[1],t[2])},LineString:function(t,e){ev(t.coordinates,e,0)},MultiLineString:function(t,e){for(var n=t.coordinates,i=-1,r=n.length;++i<r;)ev(n[i],e,0)},Polygon:function(t,e){nv(t.coordinates,e)},MultiPolygon:function(t,e){for(var n=t.coordinates,i=-1,r=n.length;++i<r;)nv(n[i],e)},GeometryCollection:function(t,e){for(var n=t.geometries,i=-1,r=n.length;++i<r;)Jy(n[i],e)}};function ev(t,e,n){var i,r=-1,o=t.length-n;for(e.lineStart();++r<o;)e.point((i=t[r])[0],i[1],i[2]);e.lineEnd()}function nv(t,e){var n=-1,i=t.length;for(e.polygonStart();++n<i;)ev(t[n],e,1);e.polygonEnd()}function iv(t,e){t&&Qy.hasOwnProperty(t.type)?Qy[t.type](t,e):Jy(t,e)}var rv,ov,av,sv,lv,cv=My(),uv=My(),hv={point:Zy,lineStart:Zy,lineEnd:Zy,polygonStart:function(){cv.reset(),hv.lineStart=dv,hv.lineEnd=pv},polygonEnd:function(){var t=+cv;uv.add(t<0?Iy+t:t),this.lineStart=this.lineEnd=this.point=Zy},sphere:function(){uv.add(Iy)}};function dv(){hv.point=fv}function pv(){mv(rv,ov)}function fv(t,e){hv.point=mv,rv=t,ov=e,av=t*=Oy,sv=Hy(e=(e*=Oy)/2+Ny),lv=Gy(e)}function mv(t,e){var n=(t*=Oy)-av,i=n>=0?1:-1,r=i*n,o=Hy(e=(e*=Oy)/2+Ny),a=Gy(e),s=lv*a,l=sv*o+s*Hy(r),c=s*i*Gy(r);cv.add(By(c,l)),av=t,sv=o,lv=a}function gv(t){return[By(t[1],t[0]),$y(t[2])]}function _v(t){var e=t[0],n=t[1],i=Hy(n);return[i*Hy(e),i*Gy(e),Gy(n)]}function yv(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]}function vv(t,e){return[t[1]*e[2]-t[2]*e[1],t[2]*e[0]-t[0]*e[2],t[0]*e[1]-t[1]*e[0]]}function bv(t,e){t[0]+=e[0],t[1]+=e[1],t[2]+=e[2]}function xv(t,e){return[t[0]*e,t[1]*e,t[2]*e]}function wv(t){var e=qy(t[0]*t[0]+t[1]*t[1]+t[2]*t[2]);t[0]/=e,t[1]/=e,t[2]/=e}var Sv,Mv,Ev,Tv,Cv,Av,kv,Lv,Pv,Nv,Iv,Rv,Ov,zv,Dv,Bv,Hv,Fv,Vv,Uv,jv,Gv,Wv,qv,Yv,Xv,$v=My(),Kv={point:Zv,lineStart:Qv,lineEnd:tb,polygonStart:function(){Kv.point=eb,Kv.lineStart=nb,Kv.lineEnd=ib,$v.reset(),hv.polygonStart()},polygonEnd:function(){hv.polygonEnd(),Kv.point=Zv,Kv.lineStart=Qv,Kv.lineEnd=tb,cv<0?(Sv=-(Ev=180),Mv=-(Tv=90)):$v>Ay?Tv=90:$v<-1e-6&&(Mv=-90),Nv[0]=Sv,Nv[1]=Ev},sphere:function(){Sv=-(Ev=180),Mv=-(Tv=90)}};function Zv(t,e){Pv.push(Nv=[Sv=t,Ev=t]),e<Mv&&(Mv=e),e>Tv&&(Tv=e)}function Jv(t,e){var n=_v([t*Oy,e*Oy]);if(Lv){var i=vv(Lv,n),r=vv([i[1],-i[0],0],i);wv(r),r=gv(r);var o,a=t-Cv,s=a>0?1:-1,l=r[0]*Ry*s,c=zy(a)>180;c^(s*Cv<l&&l<s*t)?(o=r[1]*Ry)>Tv&&(Tv=o):c^(s*Cv<(l=(l+360)%360-180)&&l<s*t)?(o=-r[1]*Ry)<Mv&&(Mv=o):(e<Mv&&(Mv=e),e>Tv&&(Tv=e)),c?t<Cv?rb(Sv,t)>rb(Sv,Ev)&&(Ev=t):rb(t,Ev)>rb(Sv,Ev)&&(Sv=t):Ev>=Sv?(t<Sv&&(Sv=t),t>Ev&&(Ev=t)):t>Cv?rb(Sv,t)>rb(Sv,Ev)&&(Ev=t):rb(t,Ev)>rb(Sv,Ev)&&(Sv=t)}else Pv.push(Nv=[Sv=t,Ev=t]);e<Mv&&(Mv=e),e>Tv&&(Tv=e),Lv=n,Cv=t}function Qv(){Kv.point=Jv}function tb(){Nv[0]=Sv,Nv[1]=Ev,Kv.point=Zv,Lv=null}function eb(t,e){if(Lv){var n=t-Cv;$v.add(zy(n)>180?n+(n>0?360:-360):n)}else Av=t,kv=e;hv.point(t,e),Jv(t,e)}function nb(){hv.lineStart()}function ib(){eb(Av,kv),hv.lineEnd(),zy($v)>Ay&&(Sv=-(Ev=180)),Nv[0]=Sv,Nv[1]=Ev,Lv=null}function rb(t,e){return(e-=t)<0?e+360:e}function ob(t,e){return t[0]-e[0]}function ab(t,e){return t[0]<=t[1]?t[0]<=e&&e<=t[1]:e<t[0]||t[1]<e}var sb={sphere:Zy,point:lb,lineStart:ub,lineEnd:pb,polygonStart:function(){sb.lineStart=fb,sb.lineEnd=mb},polygonEnd:function(){sb.lineStart=ub,sb.lineEnd=pb}};function lb(t,e){t*=Oy;var n=Hy(e*=Oy);cb(n*Hy(t),n*Gy(t),Gy(e))}function cb(t,e,n){++Iv,Ov+=(t-Ov)/Iv,zv+=(e-zv)/Iv,Dv+=(n-Dv)/Iv}function ub(){sb.point=hb}function hb(t,e){t*=Oy;var n=Hy(e*=Oy);qv=n*Hy(t),Yv=n*Gy(t),Xv=Gy(e),sb.point=db,cb(qv,Yv,Xv)}function db(t,e){t*=Oy;var n=Hy(e*=Oy),i=n*Hy(t),r=n*Gy(t),o=Gy(e),a=By(qy((a=Yv*o-Xv*r)*a+(a=Xv*i-qv*o)*a+(a=qv*r-Yv*i)*a),qv*i+Yv*r+Xv*o);Rv+=a,Bv+=a*(qv+(qv=i)),Hv+=a*(Yv+(Yv=r)),Fv+=a*(Xv+(Xv=o)),cb(qv,Yv,Xv)}function pb(){sb.point=lb}function fb(){sb.point=gb}function mb(){_b(Gv,Wv),sb.point=lb}function gb(t,e){Gv=t,Wv=e,t*=Oy,e*=Oy,sb.point=_b;var n=Hy(e);qv=n*Hy(t),Yv=n*Gy(t),Xv=Gy(e),cb(qv,Yv,Xv)}function _b(t,e){t*=Oy;var n=Hy(e*=Oy),i=n*Hy(t),r=n*Gy(t),o=Gy(e),a=Yv*o-Xv*r,s=Xv*i-qv*o,l=qv*r-Yv*i,c=qy(a*a+s*s+l*l),u=$y(c),h=c&&-u/c;Vv+=h*a,Uv+=h*s,jv+=h*l,Rv+=u,Bv+=u*(qv+(qv=i)),Hv+=u*(Yv+(Yv=r)),Fv+=u*(Xv+(Xv=o)),cb(qv,Yv,Xv)}function yb(t){return function(){return t}}function vb(t,e){function n(n,i){return n=t(n,i),e(n[0],n[1])}return t.invert&&e.invert&&(n.invert=function(n,i){return(n=e.invert(n,i))&&t.invert(n[0],n[1])}),n}function bb(t,e){return[zy(t)>Ly?t+Math.round(-t/Iy)*Iy:t,e]}function xb(t,e,n){return(t%=Iy)?e||n?vb(Sb(t),Mb(e,n)):Sb(t):e||n?Mb(e,n):bb}function wb(t){return function(e,n){return[(e+=t)>Ly?e-Iy:e<-Ly?e+Iy:e,n]}}function Sb(t){var e=wb(t);return e.invert=wb(-t),e}function Mb(t,e){var n=Hy(t),i=Gy(t),r=Hy(e),o=Gy(e);function a(t,e){var a=Hy(e),s=Hy(t)*a,l=Gy(t)*a,c=Gy(e),u=c*n+s*i;return[By(l*r-u*o,s*n-c*i),$y(u*r+l*o)]}return a.invert=function(t,e){var a=Hy(e),s=Hy(t)*a,l=Gy(t)*a,c=Gy(e),u=c*r-l*o;return[By(l*r+c*o,s*n+u*i),$y(u*n-s*i)]},a}function Eb(t){function e(e){return(e=t(e[0]*Oy,e[1]*Oy))[0]*=Ry,e[1]*=Ry,e}return t=xb(t[0]*Oy,t[1]*Oy,t.length>2?t[2]*Oy:0),e.invert=function(e){return(e=t.invert(e[0]*Oy,e[1]*Oy))[0]*=Ry,e[1]*=Ry,e},e}function Tb(t,e,n,i,r,o){if(n){var a=Hy(e),s=Gy(e),l=i*n;null==r?(r=e+i*Iy,o=e-l/2):(r=Cb(a,r),o=Cb(a,o),(i>0?r<o:r>o)&&(r+=i*Iy));for(var c,u=r;i>0?u>o:u<o;u-=l)c=gv([a,-s*Hy(u),-s*Gy(u)]),t.point(c[0],c[1])}}function Cb(t,e){(e=_v(e))[0]-=t,wv(e);var n=Xy(-e[1]);return((-e[2]<0?-n:n)+Iy-Ay)%Iy}function Ab(){var t,e=[];return{point:function(e,n,i){t.push([e,n,i])},lineStart:function(){e.push(t=[])},lineEnd:Zy,rejoin:function(){e.length>1&&e.push(e.pop().concat(e.shift()))},result:function(){var n=e;return e=[],t=null,n}}}function kb(t,e){return zy(t[0]-e[0])<Ay&&zy(t[1]-e[1])<Ay}function Lb(t,e,n,i){this.x=t,this.z=e,this.o=n,this.e=i,this.v=!1,this.n=this.p=null}function Pb(t,e,n,i,r){var o,a,s=[],l=[];if(t.forEach((function(t){if(!((e=t.length-1)<=0)){var e,n,i=t[0],a=t[e];if(kb(i,a)){if(!i[2]&&!a[2]){for(r.lineStart(),o=0;o<e;++o)r.point((i=t[o])[0],i[1]);return void r.lineEnd()}a[0]+=2e-6}s.push(n=new Lb(i,t,null,!0)),l.push(n.o=new Lb(i,null,n,!1)),s.push(n=new Lb(a,t,null,!1)),l.push(n.o=new Lb(a,null,n,!0))}})),s.length){for(l.sort(e),Nb(s),Nb(l),o=0,a=l.length;o<a;++o)l[o].e=n=!n;for(var c,u,h=s[0];;){for(var d=h,p=!0;d.v;)if((d=d.n)===h)return;c=d.z,r.lineStart();do{if(d.v=d.o.v=!0,d.e){if(p)for(o=0,a=c.length;o<a;++o)r.point((u=c[o])[0],u[1]);else i(d.x,d.n.x,1,r);d=d.n}else{if(p)for(o=(c=d.p.z).length-1;o>=0;--o)r.point((u=c[o])[0],u[1]);else i(d.x,d.p.x,-1,r);d=d.p}c=(d=d.o).z,p=!p}while(!d.v);r.lineEnd()}}}function Nb(t){if(e=t.length){for(var e,n,i=0,r=t[0];++i<e;)r.n=n=t[i],n.p=r,r=n;r.n=n=t[0],n.p=r}}bb.invert=bb;var Ib=My();function Rb(t){return zy(t[0])<=Ly?t[0]:Wy(t[0])*((zy(t[0])+Ly)%Iy-Ly)}function Ob(t,e){var n=Rb(e),i=e[1],r=Gy(i),o=[Gy(n),-Hy(n),0],a=0,s=0;Ib.reset(),1===r?i=Py+Ay:-1===r&&(i=-Py-Ay);for(var l=0,c=t.length;l<c;++l)if(h=(u=t[l]).length)for(var u,h,d=u[h-1],p=Rb(d),f=d[1]/2+Ny,m=Gy(f),g=Hy(f),_=0;_<h;++_,p=v,m=x,g=w,d=y){var y=u[_],v=Rb(y),b=y[1]/2+Ny,x=Gy(b),w=Hy(b),S=v-p,M=S>=0?1:-1,E=M*S,T=E>Ly,C=m*x;if(Ib.add(By(C*M*Gy(E),g*w+C*Hy(E))),a+=T?S+M*Iy:S,T^p>=n^v>=n){var A=vv(_v(d),_v(y));wv(A);var k=vv(o,A);wv(k);var L=(T^S>=0?-1:1)*$y(k[2]);(i>L||i===L&&(A[0]||A[1]))&&(s+=T^S>=0?1:-1)}}return(a<-1e-6||a<Ay&&Ib<-1e-6)^1&s}function zb(t,e,n,i){return function(r){var o,a,s,l=e(r),c=Ab(),u=e(c),h=!1,d={point:p,lineStart:m,lineEnd:g,polygonStart:function(){d.point=_,d.lineStart=y,d.lineEnd=v,a=[],o=[]},polygonEnd:function(){d.point=p,d.lineStart=m,d.lineEnd=g,a=ql(a);var t=Ob(o,i);a.length?(h||(r.polygonStart(),h=!0),Pb(a,Bb,t,n,r)):t&&(h||(r.polygonStart(),h=!0),r.lineStart(),n(null,null,1,r),r.lineEnd()),h&&(r.polygonEnd(),h=!1),a=o=null},sphere:function(){r.polygonStart(),r.lineStart(),n(null,null,1,r),r.lineEnd(),r.polygonEnd()}};function p(e,n){t(e,n)&&r.point(e,n)}function f(t,e){l.point(t,e)}function m(){d.point=f,l.lineStart()}function g(){d.point=p,l.lineEnd()}function _(t,e){s.push([t,e]),u.point(t,e)}function y(){u.lineStart(),s=[]}function v(){_(s[0][0],s[0][1]),u.lineEnd();var t,e,n,i,l=u.clean(),d=c.result(),p=d.length;if(s.pop(),o.push(s),s=null,p)if(1&l){if((e=(n=d[0]).length-1)>0){for(h||(r.polygonStart(),h=!0),r.lineStart(),t=0;t<e;++t)r.point((i=n[t])[0],i[1]);r.lineEnd()}}else p>1&&2&l&&d.push(d.pop().concat(d.shift())),a.push(d.filter(Db))}return d}}function Db(t){return t.length>1}function Bb(t,e){return((t=t.x)[0]<0?t[1]-Py-Ay:Py-t[1])-((e=e.x)[0]<0?e[1]-Py-Ay:Py-e[1])}var Hb=zb((function(){return!0}),(function Fb(t){var e,n=NaN,i=NaN,r=NaN;return{lineStart:function(){t.lineStart(),e=1},point:function(o,a){var s=o>0?Ly:-Ly,l=zy(o-n);zy(l-Ly)<Ay?(t.point(n,i=(i+a)/2>0?Py:-Py),t.point(r,i),t.lineEnd(),t.lineStart(),t.point(s,i),t.point(o,i),e=0):r!==s&&l>=Ly&&(zy(n-r)<Ay&&(n-=r*Ay),zy(o-s)<Ay&&(o-=s*Ay),i=(function c(t,e,n,i){var r,o,a=Gy(t-n);return zy(a)>Ay?Dy((Gy(e)*(o=Hy(i))*Gy(n)-Gy(i)*(r=Hy(e))*Gy(t))/(r*o*a)):(e+i)/2})(n,i,o,a),t.point(r,i),t.lineEnd(),t.lineStart(),t.point(s,i),e=0),t.point(n=o,i=a),r=s},lineEnd:function(){t.lineEnd(),n=i=NaN},clean:function(){return 2-e}}}),(function Vb(t,e,n,i){var r;if(null==t)i.point(-Ly,r=n*Py),i.point(0,r),i.point(Ly,r),i.point(Ly,0),i.point(Ly,-r),i.point(0,-r),i.point(-Ly,-r),i.point(-Ly,0),i.point(-Ly,r);else if(zy(t[0]-e[0])>Ay){var o=t[0]<e[0]?Ly:-Ly;i.point(-o,r=n*o/2),i.point(0,r),i.point(o,r)}else i.point(e[0],e[1])}),[-Ly,-Py]);function Ub(t){var e=Hy(t),n=6*Oy,i=e>0,r=zy(e)>Ay;function o(t,n){return Hy(t)*Hy(n)>e}function a(t,n,i){var r=[1,0,0],o=vv(_v(t),_v(n)),a=yv(o,o),s=o[0],l=a-s*s;if(!l)return!i&&t;var c=e*a/l,u=-e*s/l,h=vv(r,o),d=xv(r,c);bv(d,xv(o,u));var p=h,f=yv(d,p),m=yv(p,p),g=f*f-m*(yv(d,d)-1);if(!(g<0)){var _=qy(g),y=xv(p,(-f-_)/m);if(bv(y,d),y=gv(y),!i)return y;var v,b=t[0],x=n[0],w=t[1],S=n[1];x<b&&(v=b,b=x,x=v);var M=x-b,E=zy(M-Ly)<Ay;if(!E&&S<w&&(v=w,w=S,S=v),E||M<Ay?E?w+S>0^y[1]<(zy(y[0]-b)<Ay?w:S):w<=y[1]&&y[1]<=S:M>Ly^(b<=y[0]&&y[0]<=x)){var T=xv(p,(-f+_)/m);return bv(T,d),[y,gv(T)]}}}function s(e,n){var r=i?t:Ly-t,o=0;return e<-r?o|=1:e>r&&(o|=2),n<-r?o|=4:n>r&&(o|=8),o}return zb(o,(function l(t){var e,n,l,c,u;return{lineStart:function(){c=l=!1,u=1},point:function(h,d){var p,f=[h,d],m=o(h,d),g=i?m?0:s(h,d):m?s(h+(h<0?Ly:-Ly),d):0;if(!e&&(c=l=m)&&t.lineStart(),m!==l&&(!(p=a(e,f))||kb(e,p)||kb(f,p))&&(f[2]=1),m!==l)u=0,m?(t.lineStart(),p=a(f,e),t.point(p[0],p[1])):(p=a(e,f),t.point(p[0],p[1],2),t.lineEnd()),e=p;else if(r&&e&&i^m){var _;g&n||!(_=a(f,e,!0))||(u=0,i?(t.lineStart(),t.point(_[0][0],_[0][1]),t.point(_[1][0],_[1][1]),t.lineEnd()):(t.point(_[1][0],_[1][1]),t.lineEnd(),t.lineStart(),t.point(_[0][0],_[0][1],3)))}!m||e&&kb(e,f)||t.point(f[0],f[1]),e=f,l=m,n=g},lineEnd:function(){l&&t.lineEnd(),e=null},clean:function(){return u|(c&&l)<<1}}}),(function c(e,i,r,o){Tb(o,t,n,r,e,i)}),i?[0,-t]:[-Ly,t-Ly])}var jb=1e9,Gb=-jb;function Wb(t,e,n,i){function r(r,o){return t<=r&&r<=n&&e<=o&&o<=i}function o(r,o,s,c){var u=0,h=0;if(null==r||(u=a(r,s))!==(h=a(o,s))||l(r,o)<0^s>0)do{c.point(0===u||3===u?t:n,u>1?i:e)}while((u=(u+s+4)%4)!==h);else c.point(o[0],o[1])}function a(i,r){return zy(i[0]-t)<Ay?r>0?0:3:zy(i[0]-n)<Ay?r>0?2:1:zy(i[1]-e)<Ay?r>0?1:0:r>0?3:2}function s(t,e){return l(t.x,e.x)}function l(t,e){var n=a(t,1),i=a(e,1);return n!==i?n-i:0===n?e[1]-t[1]:1===n?t[0]-e[0]:2===n?t[1]-e[1]:e[0]-t[0]}return function(a){var l,c,u,h,d,p,f,m,g,_,y,v=a,b=Ab(),x={point:T,lineStart:function w(){x.point=C,c&&c.push(u=[]),_=!0,g=!1,f=m=NaN},lineEnd:function S(){l&&(C(h,d),p&&g&&b.rejoin(),l.push(b.result())),x.point=T,g&&v.lineEnd()},polygonStart:function M(){v=b,l=[],c=[],y=!0},polygonEnd:function E(){var e=(function n(){for(var e=0,n=0,r=c.length;n<r;++n)for(var o,a,s=c[n],l=1,u=s.length,h=s[0],d=h[0],p=h[1];l<u;++l)o=d,a=p,d=(h=s[l])[0],p=h[1],a<=i?p>i&&(d-o)*(i-a)>(p-a)*(t-o)&&++e:p<=i&&(d-o)*(i-a)<(p-a)*(t-o)&&--e;return e})(),r=y&&e,h=(l=ql(l)).length;(r||h)&&(a.polygonStart(),r&&(a.lineStart(),o(null,null,1,a),a.lineEnd()),h&&Pb(l,s,e,o,a),a.polygonEnd()),v=a,l=c=u=null}};function T(t,e){r(t,e)&&v.point(t,e)}function C(o,a){var s=r(o,a);if(c&&u.push([o,a]),_)h=o,d=a,p=s,_=!1,s&&(v.lineStart(),v.point(o,a));else if(s&&g)v.point(o,a);else{var l=[f=Math.max(Gb,Math.min(jb,f)),m=Math.max(Gb,Math.min(jb,m))],b=[o=Math.max(Gb,Math.min(jb,o)),a=Math.max(Gb,Math.min(jb,a))];!(function x(t,e,n,i,r,o){var a,s=t[0],l=t[1],c=0,u=1,h=e[0]-s,d=e[1]-l;if(a=n-s,h||!(a>0)){if(a/=h,h<0){if(a<c)return;a<u&&(u=a)}else if(h>0){if(a>u)return;a>c&&(c=a)}if(a=r-s,h||!(a<0)){if(a/=h,h<0){if(a>u)return;a>c&&(c=a)}else if(h>0){if(a<c)return;a<u&&(u=a)}if(a=i-l,d||!(a>0)){if(a/=d,d<0){if(a<c)return;a<u&&(u=a)}else if(d>0){if(a>u)return;a>c&&(c=a)}if(a=o-l,d||!(a<0)){if(a/=d,d<0){if(a>u)return;a>c&&(c=a)}else if(d>0){if(a<c)return;a<u&&(u=a)}return c>0&&(t[0]=s+c*h,t[1]=l+c*d),u<1&&(e[0]=s+u*h,e[1]=l+u*d),!0}}}}})(l,b,t,e,n,i)?s&&(v.lineStart(),v.point(o,a),y=!1):(g||(v.lineStart(),v.point(l[0],l[1])),v.point(b[0],b[1]),s||v.lineEnd(),y=!1)}f=o,m=a,g=s}return x}}var qb,Yb,Xb,$b=My(),Kb={sphere:Zy,point:Zy,lineStart:function Zb(){Kb.point=Qb,Kb.lineEnd=Jb},lineEnd:Zy,polygonStart:Zy,polygonEnd:Zy};function Jb(){Kb.point=Kb.lineEnd=Zy}function Qb(t,e){qb=t*=Oy,Yb=Gy(e*=Oy),Xb=Hy(e),Kb.point=tx}function tx(t,e){t*=Oy;var n=Gy(e*=Oy),i=Hy(e),r=zy(t-qb),o=Hy(r),a=i*Gy(r),s=Xb*n-Yb*i*o,l=Yb*n+Xb*i*o;$b.add(By(qy(a*a+s*s),l)),qb=t,Yb=n,Xb=i}function ex(t){return $b.reset(),iv(t,Kb),+$b}var nx=[null,null],ix={type:"LineString",coordinates:nx};function rx(t,e){return nx[0]=t,nx[1]=e,ex(ix)}var ox={Feature:function(t,e){return sx(t.geometry,e)},FeatureCollection:function(t,e){for(var n=t.features,i=-1,r=n.length;++i<r;)if(sx(n[i].geometry,e))return!0;return!1}},ax={Sphere:function(){return!0},Point:function(t,e){return lx(t.coordinates,e)},MultiPoint:function(t,e){for(var n=t.coordinates,i=-1,r=n.length;++i<r;)if(lx(n[i],e))return!0;return!1},LineString:function(t,e){return cx(t.coordinates,e)},MultiLineString:function(t,e){for(var n=t.coordinates,i=-1,r=n.length;++i<r;)if(cx(n[i],e))return!0;return!1},Polygon:function(t,e){return ux(t.coordinates,e)},MultiPolygon:function(t,e){for(var n=t.coordinates,i=-1,r=n.length;++i<r;)if(ux(n[i],e))return!0;return!1},GeometryCollection:function(t,e){for(var n=t.geometries,i=-1,r=n.length;++i<r;)if(sx(n[i],e))return!0;return!1}};function sx(t,e){return!(!t||!ax.hasOwnProperty(t.type))&&ax[t.type](t,e)}function lx(t,e){return 0===rx(t,e)}function cx(t,e){for(var n,i,r,o=0,a=t.length;o<a;o++){if(0===(i=rx(t[o],e)))return!0;if(o>0&&(r=rx(t[o],t[o-1]))>0&&n<=r&&i<=r&&(n+i-r)*(1-Math.pow((n-i)/r,2))<ky*r)return!0;n=i}return!1}function ux(t,e){return!!Ob(t.map(hx),dx(e))}function hx(t){return(t=t.map(dx)).pop(),t}function dx(t){return[t[0]*Oy,t[1]*Oy]}function px(t,e,n){var i=zl(t,e-Ay,n).concat(e);return function(t){return i.map((function(e){return[t,e]}))}}function fx(t,e,n){var i=zl(t,e-Ay,n).concat(e);return function(t){return i.map((function(e){return[e,t]}))}}function mx(){var t,e,n,i,r,o,a,s,l,c,u,h,d=10,p=d,f=90,m=360,g=2.5;function _(){return{type:"MultiLineString",coordinates:y()}}function y(){return zl(Fy(i/f)*f,n,f).map(u).concat(zl(Fy(s/m)*m,a,m).map(h)).concat(zl(Fy(e/d)*d,t,d).filter((function(t){return zy(t%f)>Ay})).map(l)).concat(zl(Fy(o/p)*p,r,p).filter((function(t){return zy(t%m)>Ay})).map(c))}return _.lines=function(){return y().map((function(t){return{type:"LineString",coordinates:t}}))},_.outline=function(){return{type:"Polygon",coordinates:[u(i).concat(h(a).slice(1),u(n).reverse().slice(1),h(s).reverse().slice(1))]}},_.extent=function(t){return arguments.length?_.extentMajor(t).extentMinor(t):_.extentMinor()},_.extentMajor=function(t){return arguments.length?(s=+t[0][1],a=+t[1][1],(i=+t[0][0])>(n=+t[1][0])&&(t=i,i=n,n=t),s>a&&(t=s,s=a,a=t),_.precision(g)):[[i,s],[n,a]]},_.extentMinor=function(n){return arguments.length?(o=+n[0][1],r=+n[1][1],(e=+n[0][0])>(t=+n[1][0])&&(n=e,e=t,t=n),o>r&&(n=o,o=r,r=n),_.precision(g)):[[e,o],[t,r]]},_.step=function(t){return arguments.length?_.stepMajor(t).stepMinor(t):_.stepMinor()},_.stepMajor=function(t){return arguments.length?(f=+t[0],m=+t[1],_):[f,m]},_.stepMinor=function(t){return arguments.length?(d=+t[0],p=+t[1],_):[d,p]},_.precision=function(d){return arguments.length?(g=+d,l=px(o,r,90),c=fx(e,t,g),u=px(s,a,90),h=fx(i,n,g),_):g},_.extentMajor([[-180,-89.999999],[180,89.999999]]).extentMinor([[-180,-80.000001],[180,80.000001]])}function gx(t){return t}var _x,yx,vx,bx,xx=My(),wx=My(),Sx={point:Zy,lineStart:Zy,lineEnd:Zy,polygonStart:function(){Sx.lineStart=Mx,Sx.lineEnd=Cx},polygonEnd:function(){Sx.lineStart=Sx.lineEnd=Sx.point=Zy,xx.add(zy(wx)),wx.reset()},result:function(){var t=xx/2;return xx.reset(),t}};function Mx(){Sx.point=Ex}function Ex(t,e){Sx.point=Tx,_x=vx=t,yx=bx=e}function Tx(t,e){wx.add(bx*t-vx*e),vx=t,bx=e}function Cx(){Tx(_x,yx)}var Ax,kx,Lx,Px,Nx=Sx,Ix=1/0,Rx=Ix,Ox=-Ix,zx=Ox,Dx={point:function Bx(t,e){t<Ix&&(Ix=t),t>Ox&&(Ox=t),e<Rx&&(Rx=e),e>zx&&(zx=e)},lineStart:Zy,lineEnd:Zy,polygonStart:Zy,polygonEnd:Zy,result:function(){var t=[[Ix,Rx],[Ox,zx]];return Ox=zx=-(Rx=Ix=1/0),t}},Hx=0,Fx=0,Vx=0,Ux=0,jx=0,Gx=0,Wx=0,qx=0,Yx=0,Xx={point:$x,lineStart:Kx,lineEnd:Qx,polygonStart:function(){Xx.lineStart=tw,Xx.lineEnd=ew},polygonEnd:function(){Xx.point=$x,Xx.lineStart=Kx,Xx.lineEnd=Qx},result:function(){var t=Yx?[Wx/Yx,qx/Yx]:Gx?[Ux/Gx,jx/Gx]:Vx?[Hx/Vx,Fx/Vx]:[NaN,NaN];return Hx=Fx=Vx=Ux=jx=Gx=Wx=qx=Yx=0,t}};function $x(t,e){Hx+=t,Fx+=e,++Vx}function Kx(){Xx.point=Zx}function Zx(t,e){Xx.point=Jx,$x(Lx=t,Px=e)}function Jx(t,e){var n=t-Lx,i=e-Px,r=qy(n*n+i*i);Ux+=r*(Lx+t)/2,jx+=r*(Px+e)/2,Gx+=r,$x(Lx=t,Px=e)}function Qx(){Xx.point=$x}function tw(){Xx.point=nw}function ew(){iw(Ax,kx)}function nw(t,e){Xx.point=iw,$x(Ax=Lx=t,kx=Px=e)}function iw(t,e){var n=t-Lx,i=e-Px,r=qy(n*n+i*i);Ux+=r*(Lx+t)/2,jx+=r*(Px+e)/2,Gx+=r,Wx+=(r=Px*t-Lx*e)*(Lx+t),qx+=r*(Px+e),Yx+=3*r,$x(Lx=t,Px=e)}var rw=Xx;function ow(t){this._context=t}ow.prototype={_radius:4.5,pointRadius:function(t){return this._radius=t,this},polygonStart:function(){this._line=0},polygonEnd:function(){this._line=NaN},lineStart:function(){this._point=0},lineEnd:function(){0===this._line&&this._context.closePath(),this._point=NaN},point:function(t,e){switch(this._point){case 0:this._context.moveTo(t,e),this._point=1;break;case 1:this._context.lineTo(t,e);break;default:this._context.moveTo(t+this._radius,e),this._context.arc(t,e,this._radius,0,Iy)}},result:Zy};var aw,sw,lw,cw,uw,hw=My(),dw={point:Zy,lineStart:function(){dw.point=pw},lineEnd:function(){aw&&fw(sw,lw),dw.point=Zy},polygonStart:function(){aw=!0},polygonEnd:function(){aw=null},result:function(){var t=+hw;return hw.reset(),t}};function pw(t,e){dw.point=fw,sw=cw=t,lw=uw=e}function fw(t,e){hw.add(qy((cw-=t)*cw+(uw-=e)*uw)),cw=t,uw=e}var mw=dw;function gw(){this._string=[]}function _w(t){return"m0,"+t+"a"+t+","+t+" 0 1,1 0,"+-2*t+"a"+t+","+t+" 0 1,1 0,"+2*t+"z"}function yw(t){return function(e){var n=new vw;for(var i in t)n[i]=t[i];return n.stream=e,n}}function vw(){}function bw(t,e,n){var i=t.clipExtent&&t.clipExtent();return t.scale(150).translate([0,0]),null!=i&&t.clipExtent(null),iv(n,t.stream(Dx)),e(Dx.result()),null!=i&&t.clipExtent(i),t}function xw(t,e,n){return bw(t,(function(n){var i=e[1][0]-e[0][0],r=e[1][1]-e[0][1],o=Math.min(i/(n[1][0]-n[0][0]),r/(n[1][1]-n[0][1])),a=+e[0][0]+(i-o*(n[1][0]+n[0][0]))/2,s=+e[0][1]+(r-o*(n[1][1]+n[0][1]))/2;t.scale(150*o).translate([a,s])}),n)}function ww(t,e,n){return xw(t,[[0,0],e],n)}function Sw(t,e,n){return bw(t,(function(n){var i=+e,r=i/(n[1][0]-n[0][0]),o=(i-r*(n[1][0]+n[0][0]))/2,a=-r*n[0][1];t.scale(150*r).translate([o,a])}),n)}function Mw(t,e,n){return bw(t,(function(n){var i=+e,r=i/(n[1][1]-n[0][1]),o=-r*n[0][0],a=(i-r*(n[1][1]+n[0][1]))/2;t.scale(150*r).translate([o,a])}),n)}gw.prototype={_radius:4.5,_circle:_w(4.5),pointRadius:function(t){return(t=+t)!==this._radius&&(this._radius=t,this._circle=null),this},polygonStart:function(){this._line=0},polygonEnd:function(){this._line=NaN},lineStart:function(){this._point=0},lineEnd:function(){0===this._line&&this._string.push("Z"),this._point=NaN},point:function(t,e){switch(this._point){case 0:this._string.push("M",t,",",e),this._point=1;break;case 1:this._string.push("L",t,",",e);break;default:null==this._circle&&(this._circle=_w(this._radius)),this._string.push("M",t,",",e,this._circle)}},result:function(){if(this._string.length){var t=this._string.join("");return this._string=[],t}return null}},vw.prototype={constructor:vw,point:function(t,e){this.stream.point(t,e)},sphere:function(){this.stream.sphere()},lineStart:function(){this.stream.lineStart()},lineEnd:function(){this.stream.lineEnd()},polygonStart:function(){this.stream.polygonStart()},polygonEnd:function(){this.stream.polygonEnd()}};var Ew=Hy(30*Oy);function Tw(t,e){return+e?(function n(t,e){function n(i,r,o,a,s,l,c,u,h,d,p,f,m,g){var _=c-i,y=u-r,v=_*_+y*y;if(v>4*e&&m--){var b=a+d,x=s+p,w=l+f,S=qy(b*b+x*x+w*w),M=$y(w/=S),E=zy(zy(w)-1)<Ay||zy(o-h)<Ay?(o+h)/2:By(x,b),T=t(E,M),C=T[0],A=T[1],k=C-i,L=A-r,P=y*k-_*L;(P*P/v>e||zy((_*k+y*L)/v-.5)>.3||a*d+s*p+l*f<Ew)&&(n(i,r,o,a,s,l,C,A,E,b/=S,x/=S,w,m,g),g.point(C,A),n(C,A,E,b,x,w,c,u,h,d,p,f,m,g))}}return function(e){var i,r,o,a,s,l,c,u,h,d,p,f,m={point:g,lineStart:_,lineEnd:v,polygonStart:function(){e.polygonStart(),m.lineStart=b},polygonEnd:function(){e.polygonEnd(),m.lineStart=_}};function g(n,i){n=t(n,i),e.point(n[0],n[1])}function _(){u=NaN,m.point=y,e.lineStart()}function y(i,r){var o=_v([i,r]),a=t(i,r);n(u,h,c,d,p,f,u=a[0],h=a[1],c=i,d=o[0],p=o[1],f=o[2],16,e),e.point(u,h)}function v(){m.point=g,e.lineEnd()}function b(){_(),m.point=x,m.lineEnd=w}function x(t,e){y(i=t,e),r=u,o=h,a=d,s=p,l=f,m.point=y}function w(){n(u,h,c,d,p,f,r,o,i,a,s,l,16,e),m.lineEnd=v,v()}return m}})(t,e):(function i(t){return yw({point:function(e,n){e=t(e,n),this.stream.point(e[0],e[1])}})})(t)}var Cw=yw({point:function(t,e){this.stream.point(t*Oy,e*Oy)}});function Aw(t,e,n,i,r){function o(o,a){return[e+t*(o*=i),n-t*(a*=r)]}return o.invert=function(o,a){return[(o-e)/t*i,(n-a)/t*r]},o}function kw(t,e,n,i,r,o){var a=Hy(o),s=Gy(o),l=a*t,c=s*t,u=a/t,h=s/t,d=(s*n-a*e)/t,p=(s*e+a*n)/t;function f(t,o){return[l*(t*=i)-c*(o*=r)+e,n-c*t-l*o]}return f.invert=function(t,e){return[i*(u*t-h*e+d),r*(p-h*t-u*e)]},f}function Lw(t){return Pw((function(){return t}))()}function Pw(t){var e,n,i,r,o,a,s,l,c,u,h=150,d=480,p=250,f=0,m=0,g=0,_=0,y=0,v=0,b=1,x=1,w=null,S=Hb,M=null,E=gx,T=.5;function C(t){return l(t[0]*Oy,t[1]*Oy)}function A(t){return(t=l.invert(t[0],t[1]))&&[t[0]*Ry,t[1]*Ry]}function k(){var t=kw(h,0,0,b,x,v).apply(null,e(f,m)),i=(v?kw:Aw)(h,d-t[0],p-t[1],b,x,v);return n=xb(g,_,y),s=vb(e,i),l=vb(n,s),a=Tw(s,T),L()}function L(){return c=u=null,C}return C.stream=function(t){return c&&u===t?c:c=Cw((function e(t){return yw({point:function(e,n){var i=t(e,n);return this.stream.point(i[0],i[1])}})})(n)(S(a(E(u=t)))))},C.preclip=function(t){return arguments.length?(S=t,w=void 0,L()):S},C.postclip=function(t){return arguments.length?(E=t,M=i=r=o=null,L()):E},C.clipAngle=function(t){return arguments.length?(S=+t?Ub(w=t*Oy):(w=null,Hb),L()):w*Ry},C.clipExtent=function(t){return arguments.length?(E=null==t?(M=i=r=o=null,gx):Wb(M=+t[0][0],i=+t[0][1],r=+t[1][0],o=+t[1][1]),L()):null==M?null:[[M,i],[r,o]]},C.scale=function(t){return arguments.length?(h=+t,k()):h},C.translate=function(t){return arguments.length?(d=+t[0],p=+t[1],k()):[d,p]},C.center=function(t){return arguments.length?(f=t[0]%360*Oy,m=t[1]%360*Oy,k()):[f*Ry,m*Ry]},C.rotate=function(t){return arguments.length?(g=t[0]%360*Oy,_=t[1]%360*Oy,y=t.length>2?t[2]%360*Oy:0,k()):[g*Ry,_*Ry,y*Ry]},C.angle=function(t){return arguments.length?(v=t%360*Oy,k()):v*Ry},C.reflectX=function(t){return arguments.length?(b=t?-1:1,k()):b<0},C.reflectY=function(t){return arguments.length?(x=t?-1:1,k()):x<0},C.precision=function(t){return arguments.length?(a=Tw(s,T=t*t),L()):qy(T)},C.fitExtent=function(t,e){return xw(C,t,e)},C.fitSize=function(t,e){return ww(C,t,e)},C.fitWidth=function(t,e){return Sw(C,t,e)},C.fitHeight=function(t,e){return Mw(C,t,e)},function(){return e=t.apply(this,arguments),C.invert=e.invert&&A,k()}}function Nw(t){var e=0,n=Ly/3,i=Pw(t),r=i(e,n);return r.parallels=function(t){return arguments.length?i(e=t[0]*Oy,n=t[1]*Oy):[e*Ry,n*Ry]},r}function Iw(t,e){var n=Gy(t),i=(n+Gy(e))/2;if(zy(i)<Ay)return(function r(t){var e=Hy(t);function n(t,n){return[t*e,Gy(n)/e]}return n.invert=function(t,n){return[t/e,$y(n*e)]},n})(t);var o=1+n*(2*i-n),a=qy(o)/i;function s(t,e){var n=qy(o-2*i*Gy(e))/i;return[n*Gy(t*=i),a-n*Hy(t)]}return s.invert=function(t,e){var n=a-e,r=By(t,zy(n))*Wy(n);return n*i<0&&(r-=Ly*Wy(t)*Wy(n)),[r/i,$y((o-(t*t+n*n)*i*i)/(2*i))]},s}function Rw(){return Nw(Iw).scale(155.424).center([0,33.6442])}function Ow(){return Rw().parallels([29.5,45.5]).scale(1070).translate([480,250]).rotate([96,0]).center([-.6,38.7])}function zw(t){return function(e,n){var i=Hy(e),r=Hy(n),o=t(i*r);return[o*r*Gy(e),o*Gy(n)]}}function Dw(t){return function(e,n){var i=qy(e*e+n*n),r=t(i),o=Gy(r),a=Hy(r);return[By(e*o,i*a),$y(i&&n*o/i)]}}var Bw=zw((function(t){return qy(2/(1+t))}));Bw.invert=Dw((function(t){return 2*$y(t/2)}));var Hw=zw((function(t){return(t=Xy(t))&&t/Gy(t)}));function Fw(t,e){return[t,Uy(Yy((Py+e)/2))]}function Vw(t){var e,n,i,r=Lw(t),o=r.center,a=r.scale,s=r.translate,l=r.clipExtent,c=null;function u(){var o=Ly*a(),s=r(Eb(r.rotate()).invert([0,0]));return l(null==c?[[s[0]-o,s[1]-o],[s[0]+o,s[1]+o]]:t===Fw?[[Math.max(s[0]-o,c),e],[Math.min(s[0]+o,n),i]]:[[c,Math.max(s[1]-o,e)],[n,Math.min(s[1]+o,i)]])}return r.scale=function(t){return arguments.length?(a(t),u()):a()},r.translate=function(t){return arguments.length?(s(t),u()):s()},r.center=function(t){return arguments.length?(o(t),u()):o()},r.clipExtent=function(t){return arguments.length?(null==t?c=e=n=i=null:(c=+t[0][0],e=+t[0][1],n=+t[1][0],i=+t[1][1]),u()):null==c?null:[[c,e],[n,i]]},u()}function Uw(t){return Yy((Py+t)/2)}function jw(t,e){var n=Hy(t),i=t===e?Gy(t):Uy(n/Hy(e))/Uy(Uw(e)/Uw(t)),r=n*jy(Uw(t),i)/i;if(!i)return Fw;function o(t,e){r>0?e<-Py+Ay&&(e=-Py+Ay):e>Py-Ay&&(e=Py-Ay);var n=r/jy(Uw(e),i);return[n*Gy(i*t),r-n*Hy(i*t)]}return o.invert=function(t,e){var n=r-e,o=Wy(i)*qy(t*t+n*n),a=By(t,zy(n))*Wy(n);return n*i<0&&(a-=Ly*Wy(t)*Wy(n)),[a/i,2*Dy(jy(r/o,1/i))-Py]},o}function Gw(t,e){return[t,e]}function Ww(t,e){var n=Hy(t),i=t===e?Gy(t):(n-Hy(e))/(e-t),r=n/i+t;if(zy(i)<Ay)return Gw;function o(t,e){var n=r-e,o=i*t;return[n*Gy(o),r-n*Hy(o)]}return o.invert=function(t,e){var n=r-e,o=By(t,zy(n))*Wy(n);return n*i<0&&(o-=Ly*Wy(t)*Wy(n)),[o/i,r-Wy(i)*qy(t*t+n*n)]},o}Hw.invert=Dw((function(t){return t})),Fw.invert=function(t,e){return[t,2*Dy(Vy(e))-Py]},Gw.invert=Gw;var qw=1.340264,Yw=-.081106,Xw=893e-6,$w=.003796,Kw=qy(3)/2;function Zw(t,e){var n=$y(Kw*Gy(e)),i=n*n,r=i*i*i;return[t*Hy(n)/(Kw*(qw+3*Yw*i+r*(7*Xw+9*$w*i))),n*(qw+Yw*i+r*(Xw+$w*i))]}function Jw(t,e){var n=Hy(e),i=Hy(t)*n;return[n*Gy(t)/i,Gy(e)/i]}function Qw(t,e){var n=e*e,i=n*n;return[t*(.8707-.131979*n+i*(i*(.003971*n-.001529*i)-.013791)),e*(1.007226+n*(.015085+i*(.028874*n-.044475-.005916*i)))]}function tS(t,e){return[Hy(e)*Gy(t),Gy(e)]}function eS(t,e){var n=Hy(e),i=1+Hy(t)*n;return[n*Gy(t)/i,Gy(e)/i]}function nS(t,e){return[Uy(Yy((Py+e)/2)),-t]}function iS(t,e){return t.parent===e.parent?1:2}function rS(t,e){return t+e.x}function oS(t,e){return Math.max(t,e.y)}function aS(t){var e=0,n=t.children,i=n&&n.length;if(i)for(;--i>=0;)e+=n[i].value;else e=1;t.value=e}function sS(t,e){var n,i,r,o,a,s=new hS(t),l=+t.value&&(s.value=t.value),c=[s];for(null==e&&(e=lS);n=c.pop();)if(l&&(n.value=+n.data.value),(r=e(n.data))&&(a=r.length))for(n.children=new Array(a),o=a-1;o>=0;--o)c.push(i=n.children[o]=new hS(r[o])),i.parent=n,i.depth=n.depth+1;return s.eachBefore(uS)}function lS(t){return t.children}function cS(t){t.data=t.data.data}function uS(t){var e=0;do{t.height=e}while((t=t.parent)&&t.height<++e)}function hS(t){this.data=t,this.depth=this.height=0,this.parent=null}Zw.invert=function(t,e){for(var n,i=e,r=i*i,o=r*r*r,a=0;a<12&&(o=(r=(i-=n=(i*(qw+Yw*r+o*(Xw+$w*r))-e)/(qw+3*Yw*r+o*(7*Xw+9*$w*r)))*i)*r*r,!(zy(n)<ky));++a);return[Kw*t*(qw+3*Yw*r+o*(7*Xw+9*$w*r))/Hy(i),$y(Gy(i)/Kw)]},Jw.invert=Dw(Dy),Qw.invert=function(t,e){var n,i=e,r=25;do{var o=i*i,a=o*o;i-=n=(i*(1.007226+o*(.015085+a*(.028874*o-.044475-.005916*a)))-e)/(1.007226+o*(.045255+a*(.259866*o-.311325-.005916*11*a)))}while(zy(n)>Ay&&--r>0);return[t/(.8707+(o=i*i)*(o*(o*o*o*(.003971-.001529*o)-.013791)-.131979)),i]},tS.invert=Dw($y),eS.invert=Dw((function(t){return 2*Dy(t)})),nS.invert=function(t,e){return[-e,2*Dy(Vy(t))-Py]},hS.prototype=sS.prototype={constructor:hS,count:function dS(){return this.eachAfter(aS)},each:function pS(t){var e,n,i,r,o=this,a=[o];do{for(e=a.reverse(),a=[];o=e.pop();)if(t(o),n=o.children)for(i=0,r=n.length;i<r;++i)a.push(n[i])}while(a.length);return this},eachAfter:function fS(t){for(var e,n,i,r=this,o=[r],a=[];r=o.pop();)if(a.push(r),e=r.children)for(n=0,i=e.length;n<i;++n)o.push(e[n]);for(;r=a.pop();)t(r);return this},eachBefore:function mS(t){for(var e,n,i=this,r=[i];i=r.pop();)if(t(i),e=i.children)for(n=e.length-1;n>=0;--n)r.push(e[n]);return this},sum:function gS(t){return this.eachAfter((function(e){for(var n=+t(e.data)||0,i=e.children,r=i&&i.length;--r>=0;)n+=i[r].value;e.value=n}))},sort:function _S(t){return this.eachBefore((function(e){e.children&&e.children.sort(t)}))},path:function yS(t){for(var e=this,n=(function i(t,e){if(t===e)return t;var n=t.ancestors(),i=e.ancestors(),r=null;for(t=n.pop(),e=i.pop();t===e;)r=t,t=n.pop(),e=i.pop();return r})(e,t),r=[e];e!==n;)r.push(e=e.parent);for(var o=r.length;t!==n;)r.splice(o,0,t),t=t.parent;return r},ancestors:function vS(){for(var t=this,e=[t];t=t.parent;)e.push(t);return e},descendants:function bS(){var t=[];return this.each((function(e){t.push(e)})),t},leaves:function xS(){var t=[];return this.eachBefore((function(e){e.children||t.push(e)})),t},links:function wS(){var t=this,e=[];return t.each((function(n){n!==t&&e.push({source:n.parent,target:n})})),e},copy:function SS(){return sS(this).eachBefore(cS)}};var MS=Array.prototype.slice;function ES(t){for(var e,n,i=0,r=(t=(function o(t){for(var e,n,i=t.length;i;)n=Math.random()*i--|0,e=t[i],t[i]=t[n],t[n]=e;return t})(MS.call(t))).length,a=[];i<r;)e=t[i],n&&AS(n,e)?++i:(n=LS(a=TS(a,e)),i=0);return n}function TS(t,e){var n,i;if(kS(e,t))return[e];for(n=0;n<t.length;++n)if(CS(e,t[n])&&kS(PS(t[n],e),t))return[t[n],e];for(n=0;n<t.length-1;++n)for(i=n+1;i<t.length;++i)if(CS(PS(t[n],t[i]),e)&&CS(PS(t[n],e),t[i])&&CS(PS(t[i],e),t[n])&&kS(NS(t[n],t[i],e),t))return[t[n],t[i],e];throw new Error}function CS(t,e){var n=t.r-e.r,i=e.x-t.x,r=e.y-t.y;return n<0||n*n<i*i+r*r}function AS(t,e){var n=t.r-e.r+1e-6,i=e.x-t.x,r=e.y-t.y;return n>0&&n*n>i*i+r*r}function kS(t,e){for(var n=0;n<e.length;++n)if(!AS(t,e[n]))return!1;return!0}function LS(t){switch(t.length){case 1:return(function e(t){return{x:t.x,y:t.y,r:t.r}})(t[0]);case 2:return PS(t[0],t[1]);case 3:return NS(t[0],t[1],t[2])}}function PS(t,e){var n=t.x,i=t.y,r=t.r,o=e.x,a=e.y,s=e.r,l=o-n,c=a-i,u=s-r,h=Math.sqrt(l*l+c*c);return{x:(n+o+l/h*u)/2,y:(i+a+c/h*u)/2,r:(h+r+s)/2}}function NS(t,e,n){var i=t.x,r=t.y,o=t.r,a=e.x,s=e.y,l=e.r,c=n.x,u=n.y,h=n.r,d=i-a,p=i-c,f=r-s,m=r-u,g=l-o,_=h-o,y=i*i+r*r-o*o,v=y-a*a-s*s+l*l,b=y-c*c-u*u+h*h,x=p*f-d*m,w=(f*b-m*v)/(2*x)-i,S=(m*g-f*_)/x,M=(p*v-d*b)/(2*x)-r,E=(d*_-p*g)/x,T=S*S+E*E-1,C=2*(o+w*S+M*E),A=w*w+M*M-o*o,k=-(T?(C+Math.sqrt(C*C-4*T*A))/(2*T):A/C);return{x:i+w+S*k,y:r+M+E*k,r:k}}function IS(t,e,n){var i,r,o,a,s=t.x-e.x,l=t.y-e.y,c=s*s+l*l;c?(r=e.r+n.r,a=t.r+n.r,(r*=r)>(a*=a)?(i=(c+a-r)/(2*c),o=Math.sqrt(Math.max(0,a/c-i*i)),n.x=t.x-i*s-o*l,n.y=t.y-i*l+o*s):(i=(c+r-a)/(2*c),o=Math.sqrt(Math.max(0,r/c-i*i)),n.x=e.x+i*s-o*l,n.y=e.y+i*l+o*s)):(n.x=e.x+n.r,n.y=e.y)}function RS(t,e){var n=t.r+e.r-1e-6,i=e.x-t.x,r=e.y-t.y;return n>0&&n*n>i*i+r*r}function OS(t){var e=t._,n=t.next._,i=e.r+n.r,r=(e.x*n.r+n.x*e.r)/i,o=(e.y*n.r+n.y*e.r)/i;return r*r+o*o}function zS(t){this._=t,this.next=null,this.previous=null}function DS(t){if(!(r=t.length))return 0;var e,n,i,r,o,a,s,l,c,u,h;if((e=t[0]).x=0,e.y=0,!(r>1))return e.r;if(e.x=-(n=t[1]).r,n.x=e.r,n.y=0,!(r>2))return e.r+n.r;IS(n,e,i=t[2]),e=new zS(e),n=new zS(n),i=new zS(i),e.next=i.previous=n,n.next=e.previous=i,i.next=n.previous=e;t:for(s=3;s<r;++s){IS(e._,n._,i=t[s]),i=new zS(i),l=n.next,c=e.previous,u=n._.r,h=e._.r;do{if(u<=h){if(RS(l._,i._)){e.next=n=l,n.previous=e,--s;continue t}u+=l._.r,l=l.next}else{if(RS(c._,i._)){(e=c).next=n,n.previous=e,--s;continue t}h+=c._.r,c=c.previous}}while(l!==c.next);for(i.previous=e,i.next=n,e.next=n.previous=n=i,o=OS(e);(i=i.next)!==n;)(a=OS(i))<o&&(e=i,o=a);n=e.next}for(e=[n._],i=n;(i=i.next)!==n;)e.push(i._);for(i=ES(e),s=0;s<r;++s)(e=t[s]).x-=i.x,e.y-=i.y;return i.r}function BS(t){return null==t?null:HS(t)}function HS(t){if("function"!=typeof t)throw new Error;return t}function FS(){return 0}function VS(t){return function(){return t}}function US(t){return Math.sqrt(t.value)}function jS(t){return function(e){e.children||(e.r=Math.max(0,+t(e)||0))}}function GS(t,e){return function(n){if(i=n.children){var i,r,o,a=i.length,s=t(n)*e||0;if(s)for(r=0;r<a;++r)i[r].r+=s;if(o=DS(i),s)for(r=0;r<a;++r)i[r].r-=s;n.r=o+s}}}function WS(t){return function(e){var n=e.parent;e.r*=t,n&&(e.x=n.x+t*e.x,e.y=n.y+t*e.y)}}function qS(t){t.x0=Math.round(t.x0),t.y0=Math.round(t.y0),t.x1=Math.round(t.x1),t.y1=Math.round(t.y1)}function YS(t,e,n,i,r){for(var o,a=t.children,s=-1,l=a.length,c=t.value&&(i-e)/t.value;++s<l;)(o=a[s]).y0=n,o.y1=r,o.x0=e,o.x1=e+=o.value*c}var XS={depth:-1},$S={};function KS(t){return t.id}function ZS(t){return t.parentId}function JS(t,e){return t.parent===e.parent?1:2}function QS(t){var e=t.children;return e?e[0]:t.t}function tM(t){var e=t.children;return e?e[e.length-1]:t.t}function eM(t,e,n){var i=n/(e.i-t.i);e.c-=i,e.s+=n,t.c+=i,e.z+=n,e.m+=n}function nM(t,e,n){return t.a.parent===e.parent?t.a:n}function iM(t,e){this._=t,this.parent=null,this.children=null,this.A=null,this.a=this,this.z=0,this.m=0,this.c=0,this.s=0,this.t=null,this.i=e}function rM(t,e,n,i,r){for(var o,a=t.children,s=-1,l=a.length,c=t.value&&(r-n)/t.value;++s<l;)(o=a[s]).x0=e,o.x1=i,o.y0=n,o.y1=n+=o.value*c}iM.prototype=Object.create(hS.prototype);var oM=(1+Math.sqrt(5))/2;function aM(t,e,n,i,r,o){for(var a,s,l,c,u,h,d,p,f,m,g,_=[],y=e.children,v=0,b=0,x=y.length,w=e.value;v<x;){l=r-n,c=o-i;do{u=y[b++].value}while(!u&&b<x);for(h=d=u,g=u*u*(m=Math.max(c/l,l/c)/(w*t)),f=Math.max(d/g,g/h);b<x;++b){if(u+=s=y[b].value,s<h&&(h=s),s>d&&(d=s),g=u*u*m,(p=Math.max(d/g,g/h))>f){u-=s;break}f=p}_.push(a={value:u,dice:l<c,children:y.slice(v,b)}),a.dice?YS(a,n,i,r,w?i+=c*u/w:o):rM(a,n,i,w?n+=l*u/w:r,o),w-=u,v=b}return _}var sM=(function t(e){function n(t,n,i,r,o){aM(e,t,n,i,r,o)}return n.ratio=function(e){return t((e=+e)>1?e:1)},n})(oM),lM=(function t(e){function n(t,n,i,r,o){if((a=t._squarify)&&a.ratio===e)for(var a,s,l,c,u,h=-1,d=a.length,p=t.value;++h<d;){for(l=(s=a[h]).children,c=s.value=0,u=l.length;c<u;++c)s.value+=l[c].value;s.dice?YS(s,n,i,r,i+=(o-i)*s.value/p):rM(s,n,i,n+=(r-n)*s.value/p,o),p-=s.value}else t._squarify=a=aM(e,t,n,i,r,o),a.ratio=e}return n.ratio=function(e){return t((e=+e)>1?e:1)},n})(oM);function cM(t,e,n){return(e[0]-t[0])*(n[1]-t[1])-(e[1]-t[1])*(n[0]-t[0])}function uM(t,e){return t[0]-e[0]||t[1]-e[1]}function hM(t){for(var e=t.length,n=[0,1],i=2,r=2;r<e;++r){for(;i>1&&cM(t[n[i-2]],t[n[i-1]],t[r])<=0;)--i;n[i++]=r}return n.slice(0,i)}function dM(){return Math.random()}var pM=(function t(e){function n(t,n){return t=null==t?0:+t,n=null==n?1:+n,1===arguments.length?(n=t,t=0):n-=t,function(){return e()*n+t}}return n.source=t,n})(dM),fM=(function t(e){function n(t,n){var i,r;return t=null==t?0:+t,n=null==n?1:+n,function(){var o;if(null!=i)o=i,i=null;else do{i=2*e()-1,o=2*e()-1,r=i*i+o*o}while(!r||r>1);return t+n*o*Math.sqrt(-2*Math.log(r)/r)}}return n.source=t,n})(dM),mM=(function t(e){function n(){var t=fM.source(e).apply(this,arguments);return function(){return Math.exp(t())}}return n.source=t,n})(dM),gM=(function t(e){function n(t){return function(){for(var n=0,i=0;i<t;++i)n+=e();return n}}return n.source=t,n})(dM),_M=(function t(e){function n(t){var n=gM.source(e)(t);return function(){return n()/t}}return n.source=t,n})(dM),yM=(function t(e){function n(t){return function(){return-Math.log(1-e())/t}}return n.source=t,n})(dM);function vM(t,e){switch(arguments.length){case 0:break;case 1:this.range(t);break;default:this.range(e).domain(t)}return this}function bM(t,e){switch(arguments.length){case 0:break;case 1:this.interpolator(t);break;default:this.interpolator(e).domain(t)}return this}var xM=Array.prototype,wM=xM.map,SM=xM.slice,MM={name:"implicit"};function EM(){var t=wg(),e=[],n=[],i=MM;function r(r){var o=r+"",a=t.get(o);if(!a){if(i!==MM)return i;t.set(o,a=e.push(r))}return n[(a-1)%n.length]}return r.domain=function(n){if(!arguments.length)return e.slice();e=[],t=wg();for(var i,o,a=-1,s=n.length;++a<s;)t.has(o=(i=n[a])+"")||t.set(o,e.push(i));return r},r.range=function(t){return arguments.length?(n=SM.call(t),r):n.slice()},r.unknown=function(t){return arguments.length?(i=t,r):i},r.copy=function(){return EM(e,n).unknown(i)},vM.apply(r,arguments),r}function TM(){var t,e,n=EM().unknown(void 0),i=n.domain,r=n.range,o=[0,1],a=!1,s=0,l=0,c=.5;function u(){var n=i().length,u=o[1]<o[0],h=o[u-0],d=o[1-u];t=(d-h)/Math.max(1,n-s+2*l),a&&(t=Math.floor(t)),h+=(d-h-t*(n-s))*c,e=t*(1-s),a&&(h=Math.round(h),e=Math.round(e));var p=zl(n).map((function(e){return h+t*e}));return r(u?p.reverse():p)}return delete n.unknown,n.domain=function(t){return arguments.length?(i(t),u()):i()},n.range=function(t){return arguments.length?(o=[+t[0],+t[1]],u()):o.slice()},n.rangeRound=function(t){return o=[+t[0],+t[1]],a=!0,u()},n.bandwidth=function(){return e},n.step=function(){return t},n.round=function(t){return arguments.length?(a=!!t,u()):a},n.padding=function(t){return arguments.length?(s=Math.min(1,l=+t),u()):s},n.paddingInner=function(t){return arguments.length?(s=Math.min(1,t),u()):s},n.paddingOuter=function(t){return arguments.length?(l=+t,u()):l},n.align=function(t){return arguments.length?(c=Math.max(0,Math.min(1,t)),u()):c},n.copy=function(){return TM(i(),o).round(a).paddingInner(s).paddingOuter(l).align(c)},vM.apply(u(),arguments)}function CM(t){var e=t.copy;return t.padding=t.paddingOuter,delete t.paddingInner,delete t.paddingOuter,t.copy=function(){return CM(e())},t}function AM(){return CM(TM.apply(null,arguments).paddingInner(1))}function kM(t){return+t}var LM=[0,1];function PM(t){return t}function NM(t,e){return(e-=t=+t)?function(n){return(n-t)/e}:(function n(t){return function(){return t}})(isNaN(e)?NaN:.5)}function IM(t){var e,n=t[0],i=t[t.length-1];return n>i&&(e=n,n=i,i=e),function(t){return Math.max(n,Math.min(i,t))}}function RM(t,e,n){var i=t[0],r=t[1],o=e[0],a=e[1];return r<i?(i=NM(r,i),o=n(a,o)):(i=NM(i,r),o=n(o,a)),function(t){return o(i(t))}}function OM(t,e,n){var i=Math.min(t.length,e.length)-1,r=new Array(i),o=new Array(i),a=-1;for(t[i]<t[0]&&(t=t.slice().reverse(),e=e.slice().reverse());++a<i;)r[a]=NM(t[a],t[a+1]),o[a]=n(e[a],e[a+1]);return function(e){var n=Sl(t,e,1,i)-1;return o[n](r[n](e))}}function zM(t,e){return e.domain(t.domain()).range(t.range()).interpolate(t.interpolate()).clamp(t.clamp()).unknown(t.unknown())}function DM(){var t,e,n,i,r,o,a=LM,s=LM,l=jd,c=PM;function u(){return i=Math.min(a.length,s.length)>2?OM:RM,r=o=null,h}function h(e){return isNaN(e=+e)?n:(r||(r=i(a.map(t),s,l)))(t(c(e)))}return h.invert=function(n){return c(e((o||(o=i(s,a.map(t),Bd)))(n)))},h.domain=function(t){return arguments.length?(a=wM.call(t,kM),c===PM||(c=IM(a)),u()):a.slice()},h.range=function(t){return arguments.length?(s=SM.call(t),u()):s.slice()},h.rangeRound=function(t){return s=SM.call(t),l=Gd,u()},h.clamp=function(t){return arguments.length?(c=t?IM(a):PM,h):c!==PM},h.interpolate=function(t){return arguments.length?(l=t,u()):l},h.unknown=function(t){return arguments.length?(n=t,h):n},function(n,i){return t=n,e=i,u()}}function BM(t,e){return DM()(t,e)}function HM(t,e,n,i){var r,o=Ul(t,e,n);switch((i=sy(null==i?",f":i)).type){case"s":var a=Math.max(Math.abs(t),Math.abs(e));return null!=i.precision||isNaN(r=wy(o,a))||(i.precision=r),gy(i,a);case"":case"e":case"g":case"p":case"r":null!=i.precision||isNaN(r=Sy(o,Math.max(Math.abs(t),Math.abs(e))))||(i.precision=r-("e"===i.type));break;case"f":case"%":null!=i.precision||isNaN(r=xy(o))||(i.precision=r-2*("%"===i.type))}return my(i)}function FM(t){var e=t.domain;return t.ticks=function(t){var n=e();return Fl(n[0],n[n.length-1],null==t?10:t)},t.tickFormat=function(t,n){var i=e();return HM(i[0],i[i.length-1],null==t?10:t,n)},t.nice=function(n){null==n&&(n=10);var i,r=e(),o=0,a=r.length-1,s=r[o],l=r[a];return l<s&&(i=s,s=l,l=i,i=o,o=a,a=i),(i=Vl(s,l,n))>0?i=Vl(s=Math.floor(s/i)*i,l=Math.ceil(l/i)*i,n):i<0&&(i=Vl(s=Math.ceil(s*i)/i,l=Math.floor(l*i)/i,n)),i>0?(r[o]=Math.floor(s/i)*i,r[a]=Math.ceil(l/i)*i,e(r)):i<0&&(r[o]=Math.ceil(s*i)/i,r[a]=Math.floor(l*i)/i,e(r)),t},t}function VM(){var t=BM(PM,PM);return t.copy=function(){return zM(t,VM())},vM.apply(t,arguments),FM(t)}function UM(t,e){var n,i=0,r=(t=t.slice()).length-1,o=t[i],a=t[r];return a<o&&(n=i,i=r,r=n,n=o,o=a,a=n),t[i]=e.floor(o),t[r]=e.ceil(a),t}function jM(t){return Math.log(t)}function GM(t){return Math.exp(t)}function WM(t){return-Math.log(-t)}function qM(t){return-Math.exp(-t)}function YM(t){return isFinite(t)?+("1e"+t):t<0?0:t}function XM(t){return function(e){return-t(-e)}}function $M(t){var e,n,i=t(jM,GM),r=i.domain,o=10;function a(){return e=(function a(t){return t===Math.E?Math.log:10===t&&Math.log10||2===t&&Math.log2||(t=Math.log(t),function(e){return Math.log(e)/t})})(o),n=(function s(t){return 10===t?YM:t===Math.E?Math.exp:function(e){return Math.pow(t,e)}})(o),r()[0]<0?(e=XM(e),n=XM(n),t(WM,qM)):t(jM,GM),i}return i.base=function(t){return arguments.length?(o=+t,a()):o},i.domain=function(t){return arguments.length?(r(t),a()):r()},i.ticks=function(t){var i,a=r(),s=a[0],l=a[a.length-1];(i=l<s)&&(d=s,s=l,l=d);var c,u,h,d=e(s),p=e(l),f=null==t?10:+t,m=[];if(!(o%1)&&p-d<f){if(d=Math.round(d)-1,p=Math.round(p)+1,s>0){for(;d<p;++d)for(u=1,c=n(d);u<o;++u)if(!((h=c*u)<s)){if(h>l)break;m.push(h)}}else for(;d<p;++d)for(u=o-1,c=n(d);u>=1;--u)if(!((h=c*u)<s)){if(h>l)break;m.push(h)}}else m=Fl(d,p,Math.min(p-d,f)).map(n);return i?m.reverse():m},i.tickFormat=function(t,r){if(null==r&&(r=10===o?".0e":","),"function"!=typeof r&&(r=my(r)),t===1/0)return r;null==t&&(t=10);var a=Math.max(1,o*t/i.ticks().length);return function(t){var i=t/n(Math.round(e(t)));return i*o<o-.5&&(i*=o),i<=a?r(t):""}},i.nice=function(){return r(UM(r(),{floor:function(t){return n(Math.floor(e(t)))},ceil:function(t){return n(Math.ceil(e(t)))}}))},i}function KM(){var t=$M(DM()).domain([1,10]);return t.copy=function(){return zM(t,KM()).base(t.base())},vM.apply(t,arguments),t}function ZM(t){return function(e){return Math.sign(e)*Math.log1p(Math.abs(e/t))}}function JM(t){return function(e){return Math.sign(e)*Math.expm1(Math.abs(e))*t}}function QM(t){var e=1,n=t(ZM(e),JM(e));return n.constant=function(n){return arguments.length?t(ZM(e=+n),JM(e)):e},FM(n)}function tE(t){return function(e){return e<0?-Math.pow(-e,t):Math.pow(e,t)}}function eE(t){return t<0?-Math.sqrt(-t):Math.sqrt(t)}function nE(t){return t<0?-t*t:t*t}function iE(t){var e=t(PM,PM),n=1;function i(){return 1===n?t(PM,PM):.5===n?t(eE,nE):t(tE(n),tE(1/n))}return e.exponent=function(t){return arguments.length?(n=+t,i()):n},FM(e)}function rE(){var t=iE(DM());return t.copy=function(){return zM(t,rE()).exponent(t.exponent())},vM.apply(t,arguments),t}function oE(){var t,e=[],n=[],i=[];function r(){var t=0,r=Math.max(1,n.length);for(i=new Array(r-1);++t<r;)i[t-1]=Gl(e,t/r);return o}function o(e){return isNaN(e=+e)?t:n[Sl(i,e)]}return o.invertExtent=function(t){var r=n.indexOf(t);return r<0?[NaN,NaN]:[r>0?i[r-1]:e[0],r<i.length?i[r]:e[e.length-1]]},o.domain=function(t){if(!arguments.length)return e.slice();e=[];for(var n,i=0,o=t.length;i<o;++i)null==(n=t[i])||isNaN(n=+n)||e.push(n);return e.sort(bl),r()},o.range=function(t){return arguments.length?(n=SM.call(t),r()):n.slice()},o.unknown=function(e){return arguments.length?(t=e,o):t},o.quantiles=function(){return i.slice()},o.copy=function(){return oE().domain(e).range(n).unknown(t)},vM.apply(o,arguments)}function aE(){var t,e=0,n=1,i=1,r=[.5],o=[0,1];function a(e){return e<=e?o[Sl(r,e,0,i)]:t}function s(){var t=-1;for(r=new Array(i);++t<i;)r[t]=((t+1)*n-(t-i)*e)/(i+1);return a}return a.domain=function(t){return arguments.length?(e=+t[0],n=+t[1],s()):[e,n]},a.range=function(t){return arguments.length?(i=(o=SM.call(t)).length-1,s()):o.slice()},a.invertExtent=function(t){var a=o.indexOf(t);return a<0?[NaN,NaN]:a<1?[e,r[0]]:a>=i?[r[i-1],n]:[r[a-1],r[a]]},a.unknown=function(e){return arguments.length?(t=e,a):a},a.thresholds=function(){return r.slice()},a.copy=function(){return aE().domain([e,n]).range(o).unknown(t)},vM.apply(FM(a),arguments)}var sE=new Date,lE=new Date;function cE(t,e,n,i){function r(e){return t(e=0===arguments.length?new Date:new Date(+e)),e}return r.floor=function(e){return t(e=new Date(+e)),e},r.ceil=function(n){return t(n=new Date(n-1)),e(n,1),t(n),n},r.round=function(t){var e=r(t),n=r.ceil(t);return t-e<n-t?e:n},r.offset=function(t,n){return e(t=new Date(+t),null==n?1:Math.floor(n)),t},r.range=function(n,i,o){var a,s=[];if(n=r.ceil(n),o=null==o?1:Math.floor(o),!(n<i&&o>0))return s;do{s.push(a=new Date(+n)),e(n,o),t(n)}while(a<n&&n<i);return s},r.filter=function(n){return cE((function(e){if(e>=e)for(;t(e),!n(e);)e.setTime(e-1)}),(function(t,i){if(t>=t)if(i<0)for(;++i<=0;)for(;e(t,-1),!n(t););else for(;--i>=0;)for(;e(t,1),!n(t););}))},n&&(r.count=function(e,i){return sE.setTime(+e),lE.setTime(+i),t(sE),t(lE),Math.floor(n(sE,lE))},r.every=function(t){return t=Math.floor(t),isFinite(t)&&t>0?t>1?r.filter(i?function(e){return i(e)%t==0}:function(e){return r.count(0,e)%t==0}):r:null}),r}var uE=cE((function(){}),(function(t,e){t.setTime(+t+e)}),(function(t,e){return e-t}));uE.every=function(t){return t=Math.floor(t),isFinite(t)&&t>0?t>1?cE((function(e){e.setTime(Math.floor(e/t)*t)}),(function(e,n){e.setTime(+e+n*t)}),(function(e,n){return(n-e)/t})):uE:null};var hE=uE,dE=uE.range,pE=1e3,fE=6e4,mE=36e5,gE=864e5,_E=6048e5,yE=cE((function(t){t.setTime(t-t.getMilliseconds())}),(function(t,e){t.setTime(+t+e*pE)}),(function(t,e){return(e-t)/pE}),(function(t){return t.getUTCSeconds()})),vE=yE,bE=yE.range,xE=cE((function(t){t.setTime(t-t.getMilliseconds()-t.getSeconds()*pE)}),(function(t,e){t.setTime(+t+e*fE)}),(function(t,e){return(e-t)/fE}),(function(t){return t.getMinutes()})),wE=xE,SE=xE.range,ME=cE((function(t){t.setTime(t-t.getMilliseconds()-t.getSeconds()*pE-t.getMinutes()*fE)}),(function(t,e){t.setTime(+t+e*mE)}),(function(t,e){return(e-t)/mE}),(function(t){return t.getHours()})),EE=ME,TE=ME.range,CE=cE((function(t){t.setHours(0,0,0,0)}),(function(t,e){t.setDate(t.getDate()+e)}),(function(t,e){return(e-t-(e.getTimezoneOffset()-t.getTimezoneOffset())*fE)/gE}),(function(t){return t.getDate()-1})),AE=CE,kE=CE.range;function LE(t){return cE((function(e){e.setDate(e.getDate()-(e.getDay()+7-t)%7),e.setHours(0,0,0,0)}),(function(t,e){t.setDate(t.getDate()+7*e)}),(function(t,e){return(e-t-(e.getTimezoneOffset()-t.getTimezoneOffset())*fE)/_E}))}var PE=LE(0),NE=LE(1),IE=LE(2),RE=LE(3),OE=LE(4),zE=LE(5),DE=LE(6),BE=PE.range,HE=NE.range,FE=IE.range,VE=RE.range,UE=OE.range,jE=zE.range,GE=DE.range,WE=cE((function(t){t.setDate(1),t.setHours(0,0,0,0)}),(function(t,e){t.setMonth(t.getMonth()+e)}),(function(t,e){return e.getMonth()-t.getMonth()+12*(e.getFullYear()-t.getFullYear())}),(function(t){return t.getMonth()})),qE=WE,YE=WE.range,XE=cE((function(t){t.setMonth(0,1),t.setHours(0,0,0,0)}),(function(t,e){t.setFullYear(t.getFullYear()+e)}),(function(t,e){return e.getFullYear()-t.getFullYear()}),(function(t){return t.getFullYear()}));XE.every=function(t){return isFinite(t=Math.floor(t))&&t>0?cE((function(e){e.setFullYear(Math.floor(e.getFullYear()/t)*t),e.setMonth(0,1),e.setHours(0,0,0,0)}),(function(e,n){e.setFullYear(e.getFullYear()+n*t)})):null};var $E=XE,KE=XE.range,ZE=cE((function(t){t.setUTCSeconds(0,0)}),(function(t,e){t.setTime(+t+e*fE)}),(function(t,e){return(e-t)/fE}),(function(t){return t.getUTCMinutes()})),JE=ZE,QE=ZE.range,tT=cE((function(t){t.setUTCMinutes(0,0,0)}),(function(t,e){t.setTime(+t+e*mE)}),(function(t,e){return(e-t)/mE}),(function(t){return t.getUTCHours()})),eT=tT,nT=tT.range,iT=cE((function(t){t.setUTCHours(0,0,0,0)}),(function(t,e){t.setUTCDate(t.getUTCDate()+e)}),(function(t,e){return(e-t)/gE}),(function(t){return t.getUTCDate()-1})),rT=iT,oT=iT.range;function aT(t){return cE((function(e){e.setUTCDate(e.getUTCDate()-(e.getUTCDay()+7-t)%7),e.setUTCHours(0,0,0,0)}),(function(t,e){t.setUTCDate(t.getUTCDate()+7*e)}),(function(t,e){return(e-t)/_E}))}var sT=aT(0),lT=aT(1),cT=aT(2),uT=aT(3),hT=aT(4),dT=aT(5),pT=aT(6),fT=sT.range,mT=lT.range,gT=cT.range,_T=uT.range,yT=hT.range,vT=dT.range,bT=pT.range,xT=cE((function(t){t.setUTCDate(1),t.setUTCHours(0,0,0,0)}),(function(t,e){t.setUTCMonth(t.getUTCMonth()+e)}),(function(t,e){return e.getUTCMonth()-t.getUTCMonth()+12*(e.getUTCFullYear()-t.getUTCFullYear())}),(function(t){return t.getUTCMonth()})),wT=xT,ST=xT.range,MT=cE((function(t){t.setUTCMonth(0,1),t.setUTCHours(0,0,0,0)}),(function(t,e){t.setUTCFullYear(t.getUTCFullYear()+e)}),(function(t,e){return e.getUTCFullYear()-t.getUTCFullYear()}),(function(t){return t.getUTCFullYear()}));MT.every=function(t){return isFinite(t=Math.floor(t))&&t>0?cE((function(e){e.setUTCFullYear(Math.floor(e.getUTCFullYear()/t)*t),e.setUTCMonth(0,1),e.setUTCHours(0,0,0,0)}),(function(e,n){e.setUTCFullYear(e.getUTCFullYear()+n*t)})):null};var ET=MT,TT=MT.range;function CT(t){if(0<=t.y&&t.y<100){var e=new Date(-1,t.m,t.d,t.H,t.M,t.S,t.L);return e.setFullYear(t.y),e}return new Date(t.y,t.m,t.d,t.H,t.M,t.S,t.L)}function AT(t){if(0<=t.y&&t.y<100){var e=new Date(Date.UTC(-1,t.m,t.d,t.H,t.M,t.S,t.L));return e.setUTCFullYear(t.y),e}return new Date(Date.UTC(t.y,t.m,t.d,t.H,t.M,t.S,t.L))}function kT(t,e,n){return{y:t,m:e,d:n,H:0,M:0,S:0,L:0}}function LT(t){var e=t.dateTime,n=t.date,i=t.time,r=t.periods,o=t.days,a=t.shortDays,s=t.months,l=t.shortMonths,c=UT(r),u=jT(r),h=UT(o),d=jT(o),p=UT(a),f=jT(a),m=UT(s),g=jT(s),_=UT(l),y=jT(l),v={a:function b(t){return a[t.getDay()]},A:function x(t){return o[t.getDay()]},b:function w(t){return l[t.getMonth()]},B:function S(t){return s[t.getMonth()]},c:null,d:uC,e:uC,f:mC,g:TC,G:AC,H:hC,I:dC,j:pC,L:fC,m:gC,M:_C,p:function M(t){return r[+(t.getHours()>=12)]},q:function E(t){return 1+~~(t.getMonth()/3)},Q:ZC,s:JC,S:yC,u:vC,U:bC,V:wC,w:SC,W:MC,x:null,X:null,y:EC,Y:CC,Z:kC,"%":KC},T={a:function C(t){return a[t.getUTCDay()]},A:function A(t){return o[t.getUTCDay()]},b:function k(t){return l[t.getUTCMonth()]},B:function L(t){return s[t.getUTCMonth()]},c:null,d:LC,e:LC,f:OC,g:qC,G:XC,H:PC,I:NC,j:IC,L:RC,m:zC,M:DC,p:function P(t){return r[+(t.getUTCHours()>=12)]},q:function N(t){return 1+~~(t.getUTCMonth()/3)},Q:ZC,s:JC,S:BC,u:HC,U:FC,V:UC,w:jC,W:GC,x:null,X:null,y:WC,Y:YC,Z:$C,"%":KC},I={a:function R(t,e,n){var i=p.exec(e.slice(n));return i?(t.w=f[i[0].toLowerCase()],n+i[0].length):-1},A:function O(t,e,n){var i=h.exec(e.slice(n));return i?(t.w=d[i[0].toLowerCase()],n+i[0].length):-1},b:function z(t,e,n){var i=_.exec(e.slice(n));return i?(t.m=y[i[0].toLowerCase()],n+i[0].length):-1},B:function D(t,e,n){var i=m.exec(e.slice(n));return i?(t.m=g[i[0].toLowerCase()],n+i[0].length):-1},c:function B(t,n,i){return G(t,e,n,i)},d:tC,e:tC,f:aC,g:KT,G:$T,H:nC,I:nC,j:eC,L:oC,m:QT,M:iC,p:function H(t,e,n){var i=c.exec(e.slice(n));return i?(t.p=u[i[0].toLowerCase()],n+i[0].length):-1},q:JT,Q:lC,s:cC,S:rC,u:WT,U:qT,V:YT,w:GT,W:XT,x:function F(t,e,i){return G(t,n,e,i)},X:function V(t,e,n){return G(t,i,e,n)},y:KT,Y:$T,Z:ZT,"%":sC};function U(t,e){return function(n){var i,r,o,a=[],s=-1,l=0,c=t.length;for(n instanceof Date||(n=new Date(+n));++s<c;)37===t.charCodeAt(s)&&(a.push(t.slice(l,s)),null!=(r=zT[i=t.charAt(++s)])?i=t.charAt(++s):r="e"===i?" ":"0",(o=e[i])&&(i=o(n,r)),a.push(i),l=s+1);return a.push(t.slice(l,s)),a.join("")}}function j(t,e){return function(n){var i,r,o=kT(1900,void 0,1);if(G(o,t,n+="",0)!=n.length)return null;if("Q"in o)return new Date(o.Q);if("s"in o)return new Date(1e3*o.s+("L"in o?o.L:0));if(e&&!("Z"in o)&&(o.Z=0),"p"in o&&(o.H=o.H%12+12*o.p),void 0===o.m&&(o.m="q"in o?o.q:0),"V"in o){if(o.V<1||o.V>53)return null;"w"in o||(o.w=1),"Z"in o?(r=(i=AT(kT(o.y,0,1))).getUTCDay(),i=r>4||0===r?lT.ceil(i):lT(i),i=rT.offset(i,7*(o.V-1)),o.y=i.getUTCFullYear(),o.m=i.getUTCMonth(),o.d=i.getUTCDate()+(o.w+6)%7):(r=(i=CT(kT(o.y,0,1))).getDay(),i=r>4||0===r?NE.ceil(i):NE(i),i=AE.offset(i,7*(o.V-1)),o.y=i.getFullYear(),o.m=i.getMonth(),o.d=i.getDate()+(o.w+6)%7)}else("W"in o||"U"in o)&&("w"in o||(o.w="u"in o?o.u%7:"W"in o?1:0),r="Z"in o?AT(kT(o.y,0,1)).getUTCDay():CT(kT(o.y,0,1)).getDay(),o.m=0,o.d="W"in o?(o.w+6)%7+7*o.W-(r+5)%7:o.w+7*o.U-(r+6)%7);return"Z"in o?(o.H+=o.Z/100|0,o.M+=o.Z%100,AT(o)):CT(o)}}function G(t,e,n,i){for(var r,o,a=0,s=e.length,l=n.length;a<s;){if(i>=l)return-1;if(37===(r=e.charCodeAt(a++))){if(r=e.charAt(a++),!(o=I[r in zT?e.charAt(a++):r])||(i=o(t,n,i))<0)return-1}else if(r!=n.charCodeAt(i++))return-1}return i}return v.x=U(n,v),v.X=U(i,v),v.c=U(e,v),T.x=U(n,T),T.X=U(i,T),T.c=U(e,T),{format:function(t){var e=U(t+="",v);return e.toString=function(){return t},e},parse:function(t){var e=j(t+="",!1);return e.toString=function(){return t},e},utcFormat:function(t){var e=U(t+="",T);return e.toString=function(){return t},e},utcParse:function(t){var e=j(t+="",!0);return e.toString=function(){return t},e}}}var PT,NT,IT,RT,OT,zT={"-":"",_:" ",0:"0"},DT=/^\s*\d+/,BT=/^%/,HT=/[\\^$*+?|[\]().{}]/g;function FT(t,e,n){var i=t<0?"-":"",r=(i?-t:t)+"",o=r.length;return i+(o<n?new Array(n-o+1).join(e)+r:r)}function VT(t){return t.replace(HT,"\\$&")}function UT(t){return new RegExp("^(?:"+t.map(VT).join("|")+")","i")}function jT(t){for(var e={},n=-1,i=t.length;++n<i;)e[t[n].toLowerCase()]=n;return e}function GT(t,e,n){var i=DT.exec(e.slice(n,n+1));return i?(t.w=+i[0],n+i[0].length):-1}function WT(t,e,n){var i=DT.exec(e.slice(n,n+1));return i?(t.u=+i[0],n+i[0].length):-1}function qT(t,e,n){var i=DT.exec(e.slice(n,n+2));return i?(t.U=+i[0],n+i[0].length):-1}function YT(t,e,n){var i=DT.exec(e.slice(n,n+2));return i?(t.V=+i[0],n+i[0].length):-1}function XT(t,e,n){var i=DT.exec(e.slice(n,n+2));return i?(t.W=+i[0],n+i[0].length):-1}function $T(t,e,n){var i=DT.exec(e.slice(n,n+4));return i?(t.y=+i[0],n+i[0].length):-1}function KT(t,e,n){var i=DT.exec(e.slice(n,n+2));return i?(t.y=+i[0]+(+i[0]>68?1900:2e3),n+i[0].length):-1}function ZT(t,e,n){var i=/^(Z)|([+-]\d\d)(?::?(\d\d))?/.exec(e.slice(n,n+6));return i?(t.Z=i[1]?0:-(i[2]+(i[3]||"00")),n+i[0].length):-1}function JT(t,e,n){var i=DT.exec(e.slice(n,n+1));return i?(t.q=3*i[0]-3,n+i[0].length):-1}function QT(t,e,n){var i=DT.exec(e.slice(n,n+2));return i?(t.m=i[0]-1,n+i[0].length):-1}function tC(t,e,n){var i=DT.exec(e.slice(n,n+2));return i?(t.d=+i[0],n+i[0].length):-1}function eC(t,e,n){var i=DT.exec(e.slice(n,n+3));return i?(t.m=0,t.d=+i[0],n+i[0].length):-1}function nC(t,e,n){var i=DT.exec(e.slice(n,n+2));return i?(t.H=+i[0],n+i[0].length):-1}function iC(t,e,n){var i=DT.exec(e.slice(n,n+2));return i?(t.M=+i[0],n+i[0].length):-1}function rC(t,e,n){var i=DT.exec(e.slice(n,n+2));return i?(t.S=+i[0],n+i[0].length):-1}function oC(t,e,n){var i=DT.exec(e.slice(n,n+3));return i?(t.L=+i[0],n+i[0].length):-1}function aC(t,e,n){var i=DT.exec(e.slice(n,n+6));return i?(t.L=Math.floor(i[0]/1e3),n+i[0].length):-1}function sC(t,e,n){var i=BT.exec(e.slice(n,n+1));return i?n+i[0].length:-1}function lC(t,e,n){var i=DT.exec(e.slice(n));return i?(t.Q=+i[0],n+i[0].length):-1}function cC(t,e,n){var i=DT.exec(e.slice(n));return i?(t.s=+i[0],n+i[0].length):-1}function uC(t,e){return FT(t.getDate(),e,2)}function hC(t,e){return FT(t.getHours(),e,2)}function dC(t,e){return FT(t.getHours()%12||12,e,2)}function pC(t,e){return FT(1+AE.count($E(t),t),e,3)}function fC(t,e){return FT(t.getMilliseconds(),e,3)}function mC(t,e){return fC(t,e)+"000"}function gC(t,e){return FT(t.getMonth()+1,e,2)}function _C(t,e){return FT(t.getMinutes(),e,2)}function yC(t,e){return FT(t.getSeconds(),e,2)}function vC(t){var e=t.getDay();return 0===e?7:e}function bC(t,e){return FT(PE.count($E(t)-1,t),e,2)}function xC(t){var e=t.getDay();return e>=4||0===e?OE(t):OE.ceil(t)}function wC(t,e){return t=xC(t),FT(OE.count($E(t),t)+(4===$E(t).getDay()),e,2)}function SC(t){return t.getDay()}function MC(t,e){return FT(NE.count($E(t)-1,t),e,2)}function EC(t,e){return FT(t.getFullYear()%100,e,2)}function TC(t,e){return FT((t=xC(t)).getFullYear()%100,e,2)}function CC(t,e){return FT(t.getFullYear()%1e4,e,4)}function AC(t,e){var n=t.getDay();return FT((t=n>=4||0===n?OE(t):OE.ceil(t)).getFullYear()%1e4,e,4)}function kC(t){var e=t.getTimezoneOffset();return(e>0?"-":(e*=-1,"+"))+FT(e/60|0,"0",2)+FT(e%60,"0",2)}function LC(t,e){return FT(t.getUTCDate(),e,2)}function PC(t,e){return FT(t.getUTCHours(),e,2)}function NC(t,e){return FT(t.getUTCHours()%12||12,e,2)}function IC(t,e){return FT(1+rT.count(ET(t),t),e,3)}function RC(t,e){return FT(t.getUTCMilliseconds(),e,3)}function OC(t,e){return RC(t,e)+"000"}function zC(t,e){return FT(t.getUTCMonth()+1,e,2)}function DC(t,e){return FT(t.getUTCMinutes(),e,2)}function BC(t,e){return FT(t.getUTCSeconds(),e,2)}function HC(t){var e=t.getUTCDay();return 0===e?7:e}function FC(t,e){return FT(sT.count(ET(t)-1,t),e,2)}function VC(t){var e=t.getUTCDay();return e>=4||0===e?hT(t):hT.ceil(t)}function UC(t,e){return t=VC(t),FT(hT.count(ET(t),t)+(4===ET(t).getUTCDay()),e,2)}function jC(t){return t.getUTCDay()}function GC(t,e){return FT(lT.count(ET(t)-1,t),e,2)}function WC(t,e){return FT(t.getUTCFullYear()%100,e,2)}function qC(t,e){return FT((t=VC(t)).getUTCFullYear()%100,e,2)}function YC(t,e){return FT(t.getUTCFullYear()%1e4,e,4)}function XC(t,e){var n=t.getUTCDay();return FT((t=n>=4||0===n?hT(t):hT.ceil(t)).getUTCFullYear()%1e4,e,4)}function $C(){return"+0000"}function KC(){return"%"}function ZC(t){return+t}function JC(t){return Math.floor(+t/1e3)}function QC(t){return PT=LT(t),NT=PT.format,IT=PT.parse,RT=PT.utcFormat,OT=PT.utcParse,PT}QC({dateTime:"%x, %X",date:"%-m/%-d/%Y",time:"%-I:%M:%S %p",periods:["AM","PM"],days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],shortDays:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]});var tA="%Y-%m-%dT%H:%M:%S.%LZ",eA=Date.prototype.toISOString?function nA(t){return t.toISOString()}:RT(tA),iA=+new Date("2000-01-01T00:00:00.000Z")?function rA(t){var e=new Date(t);return isNaN(e)?null:e}:OT(tA),oA=31536e6;function aA(t){return new Date(t)}function sA(t){return t instanceof Date?+t:+new Date(+t)}function lA(t,e,n,i,r,o,a,s,l){var c=BM(PM,PM),u=c.invert,h=c.domain,d=l(".%L"),p=l(":%S"),f=l("%I:%M"),m=l("%I %p"),g=l("%a %d"),_=l("%b %d"),y=l("%B"),v=l("%Y"),b=[[a,1,1e3],[a,5,5e3],[a,15,15e3],[a,30,3e4],[o,1,6e4],[o,5,3e5],[o,15,9e5],[o,30,18e5],[r,1,36e5],[r,3,108e5],[r,6,216e5],[r,12,432e5],[i,1,864e5],[i,2,1728e5],[n,1,6048e5],[e,1,2592e6],[e,3,7776e6],[t,1,oA]];function x(s){return(a(s)<s?d:o(s)<s?p:r(s)<s?f:i(s)<s?m:e(s)<s?n(s)<s?g:_:t(s)<s?y:v)(s)}function w(e,n,i,r){if(null==e&&(e=10),"number"==typeof e){var o=Math.abs(i-n)/e,a=xl((function(t){return t[2]})).right(b,o);a===b.length?(r=Ul(n/oA,i/oA,e),e=t):a?(r=(a=b[o/b[a-1][2]<b[a][2]/o?a-1:a])[1],e=a[0]):(r=Math.max(Ul(n,i,e),1),e=s)}return null==r?e:e.every(r)}return c.invert=function(t){return new Date(u(t))},c.domain=function(t){return arguments.length?h(wM.call(t,sA)):h().map(aA)},c.ticks=function(t,e){var n,i=h(),r=i[0],o=i[i.length-1],a=o<r;return a&&(n=r,r=o,o=n),n=(n=w(t,r,o,e))?n.range(r,o+1):[],a?n.reverse():n},c.tickFormat=function(t,e){return null==e?x:l(e)},c.nice=function(t,e){var n=h();return(t=w(t,n[0],n[n.length-1],e))?h(UM(n,t)):c},c.copy=function(){return zM(c,lA(t,e,n,i,r,o,a,s,l))},c}function cA(){return vM.apply(lA($E,qE,PE,AE,EE,wE,vE,hE,NT).domain([new Date(2e3,0,1),new Date(2e3,0,2)]),arguments)}function uA(){var t,e,n,i,r,o=0,a=1,s=PM,l=!1;function c(e){return isNaN(e=+e)?r:s(0===n?.5:(e=(i(e)-t)*n,l?Math.max(0,Math.min(1,e)):e))}return c.domain=function(r){return arguments.length?(t=i(o=+r[0]),e=i(a=+r[1]),n=t===e?0:1/(e-t),c):[o,a]},c.clamp=function(t){return arguments.length?(l=!!t,c):l},c.interpolator=function(t){return arguments.length?(s=t,c):s},c.unknown=function(t){return arguments.length?(r=t,c):r},function(r){return i=r,t=r(o),e=r(a),n=t===e?0:1/(e-t),c}}function hA(t,e){return e.domain(t.domain()).interpolator(t.interpolator()).clamp(t.clamp()).unknown(t.unknown())}function dA(){var t=iE(uA());return t.copy=function(){return hA(t,dA()).exponent(t.exponent())},bM.apply(t,arguments)}function pA(){var t,e,n,i,r,o,a,s=0,l=.5,c=1,u=PM,h=!1;function d(t){return isNaN(t=+t)?a:(t=.5+((t=+o(t))-e)*(t<e?i:r),u(h?Math.max(0,Math.min(1,t)):t))}return d.domain=function(a){return arguments.length?(t=o(s=+a[0]),e=o(l=+a[1]),n=o(c=+a[2]),i=t===e?0:.5/(e-t),r=e===n?0:.5/(n-e),d):[s,l,c]},d.clamp=function(t){return arguments.length?(h=!!t,d):h},d.interpolator=function(t){return arguments.length?(u=t,d):u},d.unknown=function(t){return arguments.length?(a=t,d):a},function(a){return o=a,t=a(s),e=a(l),n=a(c),i=t===e?0:.5/(e-t),r=e===n?0:.5/(n-e),d}}function fA(){var t=iE(pA());return t.copy=function(){return hA(t,fA()).exponent(t.exponent())},bM.apply(t,arguments)}function mA(t){for(var e=t.length/6|0,n=new Array(e),i=0;i<e;)n[i]="#"+t.slice(6*i,6*++i);return n}var gA=mA("1f77b4ff7f0e2ca02cd627289467bd8c564be377c27f7f7fbcbd2217becf"),_A=mA("7fc97fbeaed4fdc086ffff99386cb0f0027fbf5b17666666"),yA=mA("1b9e77d95f027570b3e7298a66a61ee6ab02a6761d666666"),vA=mA("a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9affff99b15928"),bA=mA("fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bdfddaecf2f2f2"),xA=mA("b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2aef1e2cccccccc"),wA=mA("e41a1c377eb84daf4a984ea3ff7f00ffff33a65628f781bf999999"),SA=mA("66c2a5fc8d628da0cbe78ac3a6d854ffd92fe5c494b3b3b3"),MA=mA("8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bdccebc5ffed6f"),EA=mA("4e79a7f28e2ce1575976b7b259a14fedc949af7aa1ff9da79c755fbab0ab");function TA(t){return Nd(t[t.length-1])}var CA=new Array(3).concat("d8b365f5f5f55ab4ac","a6611adfc27d80cdc1018571","a6611adfc27df5f5f580cdc1018571","8c510ad8b365f6e8c3c7eae55ab4ac01665e","8c510ad8b365f6e8c3f5f5f5c7eae55ab4ac01665e","8c510abf812ddfc27df6e8c3c7eae580cdc135978f01665e","8c510abf812ddfc27df6e8c3f5f5f5c7eae580cdc135978f01665e","5430058c510abf812ddfc27df6e8c3c7eae580cdc135978f01665e003c30","5430058c510abf812ddfc27df6e8c3f5f5f5c7eae580cdc135978f01665e003c30").map(mA),AA=TA(CA),kA=new Array(3).concat("af8dc3f7f7f77fbf7b","7b3294c2a5cfa6dba0008837","7b3294c2a5cff7f7f7a6dba0008837","762a83af8dc3e7d4e8d9f0d37fbf7b1b7837","762a83af8dc3e7d4e8f7f7f7d9f0d37fbf7b1b7837","762a839970abc2a5cfe7d4e8d9f0d3a6dba05aae611b7837","762a839970abc2a5cfe7d4e8f7f7f7d9f0d3a6dba05aae611b7837","40004b762a839970abc2a5cfe7d4e8d9f0d3a6dba05aae611b783700441b","40004b762a839970abc2a5cfe7d4e8f7f7f7d9f0d3a6dba05aae611b783700441b").map(mA),LA=TA(kA),PA=new Array(3).concat("e9a3c9f7f7f7a1d76a","d01c8bf1b6dab8e1864dac26","d01c8bf1b6daf7f7f7b8e1864dac26","c51b7de9a3c9fde0efe6f5d0a1d76a4d9221","c51b7de9a3c9fde0eff7f7f7e6f5d0a1d76a4d9221","c51b7dde77aef1b6dafde0efe6f5d0b8e1867fbc414d9221","c51b7dde77aef1b6dafde0eff7f7f7e6f5d0b8e1867fbc414d9221","8e0152c51b7dde77aef1b6dafde0efe6f5d0b8e1867fbc414d9221276419","8e0152c51b7dde77aef1b6dafde0eff7f7f7e6f5d0b8e1867fbc414d9221276419").map(mA),NA=TA(PA),IA=new Array(3).concat("998ec3f7f7f7f1a340","5e3c99b2abd2fdb863e66101","5e3c99b2abd2f7f7f7fdb863e66101","542788998ec3d8daebfee0b6f1a340b35806","542788998ec3d8daebf7f7f7fee0b6f1a340b35806","5427888073acb2abd2d8daebfee0b6fdb863e08214b35806","5427888073acb2abd2d8daebf7f7f7fee0b6fdb863e08214b35806","2d004b5427888073acb2abd2d8daebfee0b6fdb863e08214b358067f3b08","2d004b5427888073acb2abd2d8daebf7f7f7fee0b6fdb863e08214b358067f3b08").map(mA),RA=TA(IA),OA=new Array(3).concat("ef8a62f7f7f767a9cf","ca0020f4a58292c5de0571b0","ca0020f4a582f7f7f792c5de0571b0","b2182bef8a62fddbc7d1e5f067a9cf2166ac","b2182bef8a62fddbc7f7f7f7d1e5f067a9cf2166ac","b2182bd6604df4a582fddbc7d1e5f092c5de4393c32166ac","b2182bd6604df4a582fddbc7f7f7f7d1e5f092c5de4393c32166ac","67001fb2182bd6604df4a582fddbc7d1e5f092c5de4393c32166ac053061","67001fb2182bd6604df4a582fddbc7f7f7f7d1e5f092c5de4393c32166ac053061").map(mA),zA=TA(OA),DA=new Array(3).concat("ef8a62ffffff999999","ca0020f4a582bababa404040","ca0020f4a582ffffffbababa404040","b2182bef8a62fddbc7e0e0e09999994d4d4d","b2182bef8a62fddbc7ffffffe0e0e09999994d4d4d","b2182bd6604df4a582fddbc7e0e0e0bababa8787874d4d4d","b2182bd6604df4a582fddbc7ffffffe0e0e0bababa8787874d4d4d","67001fb2182bd6604df4a582fddbc7e0e0e0bababa8787874d4d4d1a1a1a","67001fb2182bd6604df4a582fddbc7ffffffe0e0e0bababa8787874d4d4d1a1a1a").map(mA),BA=TA(DA),HA=new Array(3).concat("fc8d59ffffbf91bfdb","d7191cfdae61abd9e92c7bb6","d7191cfdae61ffffbfabd9e92c7bb6","d73027fc8d59fee090e0f3f891bfdb4575b4","d73027fc8d59fee090ffffbfe0f3f891bfdb4575b4","d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4","d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4","a50026d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4313695","a50026d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4313695").map(mA),FA=TA(HA),VA=new Array(3).concat("fc8d59ffffbf91cf60","d7191cfdae61a6d96a1a9641","d7191cfdae61ffffbfa6d96a1a9641","d73027fc8d59fee08bd9ef8b91cf601a9850","d73027fc8d59fee08bffffbfd9ef8b91cf601a9850","d73027f46d43fdae61fee08bd9ef8ba6d96a66bd631a9850","d73027f46d43fdae61fee08bffffbfd9ef8ba6d96a66bd631a9850","a50026d73027f46d43fdae61fee08bd9ef8ba6d96a66bd631a9850006837","a50026d73027f46d43fdae61fee08bffffbfd9ef8ba6d96a66bd631a9850006837").map(mA),UA=TA(VA),jA=new Array(3).concat("fc8d59ffffbf99d594","d7191cfdae61abdda42b83ba","d7191cfdae61ffffbfabdda42b83ba","d53e4ffc8d59fee08be6f59899d5943288bd","d53e4ffc8d59fee08bffffbfe6f59899d5943288bd","d53e4ff46d43fdae61fee08be6f598abdda466c2a53288bd","d53e4ff46d43fdae61fee08bffffbfe6f598abdda466c2a53288bd","9e0142d53e4ff46d43fdae61fee08be6f598abdda466c2a53288bd5e4fa2","9e0142d53e4ff46d43fdae61fee08bffffbfe6f598abdda466c2a53288bd5e4fa2").map(mA),GA=TA(jA),WA=new Array(3).concat("e5f5f999d8c92ca25f","edf8fbb2e2e266c2a4238b45","edf8fbb2e2e266c2a42ca25f006d2c","edf8fbccece699d8c966c2a42ca25f006d2c","edf8fbccece699d8c966c2a441ae76238b45005824","f7fcfde5f5f9ccece699d8c966c2a441ae76238b45005824","f7fcfde5f5f9ccece699d8c966c2a441ae76238b45006d2c00441b").map(mA),qA=TA(WA),YA=new Array(3).concat("e0ecf49ebcda8856a7","edf8fbb3cde38c96c688419d","edf8fbb3cde38c96c68856a7810f7c","edf8fbbfd3e69ebcda8c96c68856a7810f7c","edf8fbbfd3e69ebcda8c96c68c6bb188419d6e016b","f7fcfde0ecf4bfd3e69ebcda8c96c68c6bb188419d6e016b","f7fcfde0ecf4bfd3e69ebcda8c96c68c6bb188419d810f7c4d004b").map(mA),XA=TA(YA),$A=new Array(3).concat("e0f3dba8ddb543a2ca","f0f9e8bae4bc7bccc42b8cbe","f0f9e8bae4bc7bccc443a2ca0868ac","f0f9e8ccebc5a8ddb57bccc443a2ca0868ac","f0f9e8ccebc5a8ddb57bccc44eb3d32b8cbe08589e","f7fcf0e0f3dbccebc5a8ddb57bccc44eb3d32b8cbe08589e","f7fcf0e0f3dbccebc5a8ddb57bccc44eb3d32b8cbe0868ac084081").map(mA),KA=TA($A),ZA=new Array(3).concat("fee8c8fdbb84e34a33","fef0d9fdcc8afc8d59d7301f","fef0d9fdcc8afc8d59e34a33b30000","fef0d9fdd49efdbb84fc8d59e34a33b30000","fef0d9fdd49efdbb84fc8d59ef6548d7301f990000","fff7ecfee8c8fdd49efdbb84fc8d59ef6548d7301f990000","fff7ecfee8c8fdd49efdbb84fc8d59ef6548d7301fb300007f0000").map(mA),JA=TA(ZA),QA=new Array(3).concat("ece2f0a6bddb1c9099","f6eff7bdc9e167a9cf02818a","f6eff7bdc9e167a9cf1c9099016c59","f6eff7d0d1e6a6bddb67a9cf1c9099016c59","f6eff7d0d1e6a6bddb67a9cf3690c002818a016450","fff7fbece2f0d0d1e6a6bddb67a9cf3690c002818a016450","fff7fbece2f0d0d1e6a6bddb67a9cf3690c002818a016c59014636").map(mA),tk=TA(QA),ek=new Array(3).concat("ece7f2a6bddb2b8cbe","f1eef6bdc9e174a9cf0570b0","f1eef6bdc9e174a9cf2b8cbe045a8d","f1eef6d0d1e6a6bddb74a9cf2b8cbe045a8d","f1eef6d0d1e6a6bddb74a9cf3690c00570b0034e7b","fff7fbece7f2d0d1e6a6bddb74a9cf3690c00570b0034e7b","fff7fbece7f2d0d1e6a6bddb74a9cf3690c00570b0045a8d023858").map(mA),nk=TA(ek),ik=new Array(3).concat("e7e1efc994c7dd1c77","f1eef6d7b5d8df65b0ce1256","f1eef6d7b5d8df65b0dd1c77980043","f1eef6d4b9dac994c7df65b0dd1c77980043","f1eef6d4b9dac994c7df65b0e7298ace125691003f","f7f4f9e7e1efd4b9dac994c7df65b0e7298ace125691003f","f7f4f9e7e1efd4b9dac994c7df65b0e7298ace125698004367001f").map(mA),rk=TA(ik),ok=new Array(3).concat("fde0ddfa9fb5c51b8a","feebe2fbb4b9f768a1ae017e","feebe2fbb4b9f768a1c51b8a7a0177","feebe2fcc5c0fa9fb5f768a1c51b8a7a0177","feebe2fcc5c0fa9fb5f768a1dd3497ae017e7a0177","fff7f3fde0ddfcc5c0fa9fb5f768a1dd3497ae017e7a0177","fff7f3fde0ddfcc5c0fa9fb5f768a1dd3497ae017e7a017749006a").map(mA),ak=TA(ok),sk=new Array(3).concat("edf8b17fcdbb2c7fb8","ffffcca1dab441b6c4225ea8","ffffcca1dab441b6c42c7fb8253494","ffffccc7e9b47fcdbb41b6c42c7fb8253494","ffffccc7e9b47fcdbb41b6c41d91c0225ea80c2c84","ffffd9edf8b1c7e9b47fcdbb41b6c41d91c0225ea80c2c84","ffffd9edf8b1c7e9b47fcdbb41b6c41d91c0225ea8253494081d58").map(mA),lk=TA(sk),ck=new Array(3).concat("f7fcb9addd8e31a354","ffffccc2e69978c679238443","ffffccc2e69978c67931a354006837","ffffccd9f0a3addd8e78c67931a354006837","ffffccd9f0a3addd8e78c67941ab5d238443005a32","ffffe5f7fcb9d9f0a3addd8e78c67941ab5d238443005a32","ffffe5f7fcb9d9f0a3addd8e78c67941ab5d238443006837004529").map(mA),uk=TA(ck),hk=new Array(3).concat("fff7bcfec44fd95f0e","ffffd4fed98efe9929cc4c02","ffffd4fed98efe9929d95f0e993404","ffffd4fee391fec44ffe9929d95f0e993404","ffffd4fee391fec44ffe9929ec7014cc4c028c2d04","ffffe5fff7bcfee391fec44ffe9929ec7014cc4c028c2d04","ffffe5fff7bcfee391fec44ffe9929ec7014cc4c02993404662506").map(mA),dk=TA(hk),pk=new Array(3).concat("ffeda0feb24cf03b20","ffffb2fecc5cfd8d3ce31a1c","ffffb2fecc5cfd8d3cf03b20bd0026","ffffb2fed976feb24cfd8d3cf03b20bd0026","ffffb2fed976feb24cfd8d3cfc4e2ae31a1cb10026","ffffccffeda0fed976feb24cfd8d3cfc4e2ae31a1cb10026","ffffccffeda0fed976feb24cfd8d3cfc4e2ae31a1cbd0026800026").map(mA),fk=TA(pk),mk=new Array(3).concat("deebf79ecae13182bd","eff3ffbdd7e76baed62171b5","eff3ffbdd7e76baed63182bd08519c","eff3ffc6dbef9ecae16baed63182bd08519c","eff3ffc6dbef9ecae16baed64292c62171b5084594","f7fbffdeebf7c6dbef9ecae16baed64292c62171b5084594","f7fbffdeebf7c6dbef9ecae16baed64292c62171b508519c08306b").map(mA),gk=TA(mk),_k=new Array(3).concat("e5f5e0a1d99b31a354","edf8e9bae4b374c476238b45","edf8e9bae4b374c47631a354006d2c","edf8e9c7e9c0a1d99b74c47631a354006d2c","edf8e9c7e9c0a1d99b74c47641ab5d238b45005a32","f7fcf5e5f5e0c7e9c0a1d99b74c47641ab5d238b45005a32","f7fcf5e5f5e0c7e9c0a1d99b74c47641ab5d238b45006d2c00441b").map(mA),yk=TA(_k),vk=new Array(3).concat("f0f0f0bdbdbd636363","f7f7f7cccccc969696525252","f7f7f7cccccc969696636363252525","f7f7f7d9d9d9bdbdbd969696636363252525","f7f7f7d9d9d9bdbdbd969696737373525252252525","fffffff0f0f0d9d9d9bdbdbd969696737373525252252525","fffffff0f0f0d9d9d9bdbdbd969696737373525252252525000000").map(mA),bk=TA(vk),xk=new Array(3).concat("efedf5bcbddc756bb1","f2f0f7cbc9e29e9ac86a51a3","f2f0f7cbc9e29e9ac8756bb154278f","f2f0f7dadaebbcbddc9e9ac8756bb154278f","f2f0f7dadaebbcbddc9e9ac8807dba6a51a34a1486","fcfbfdefedf5dadaebbcbddc9e9ac8807dba6a51a34a1486","fcfbfdefedf5dadaebbcbddc9e9ac8807dba6a51a354278f3f007d").map(mA),wk=TA(xk),Sk=new Array(3).concat("fee0d2fc9272de2d26","fee5d9fcae91fb6a4acb181d","fee5d9fcae91fb6a4ade2d26a50f15","fee5d9fcbba1fc9272fb6a4ade2d26a50f15","fee5d9fcbba1fc9272fb6a4aef3b2ccb181d99000d","fff5f0fee0d2fcbba1fc9272fb6a4aef3b2ccb181d99000d","fff5f0fee0d2fcbba1fc9272fb6a4aef3b2ccb181da50f1567000d").map(mA),Mk=TA(Sk),Ek=new Array(3).concat("fee6cefdae6be6550d","feeddefdbe85fd8d3cd94701","feeddefdbe85fd8d3ce6550da63603","feeddefdd0a2fdae6bfd8d3ce6550da63603","feeddefdd0a2fdae6bfd8d3cf16913d948018c2d04","fff5ebfee6cefdd0a2fdae6bfd8d3cf16913d948018c2d04","fff5ebfee6cefdd0a2fdae6bfd8d3cf16913d94801a636037f2704").map(mA),Tk=TA(Ek),Ck=_p(xd(300,.5,0),xd(-240,.5,1)),Ak=_p(xd(-100,.75,.35),xd(80,1.5,.8)),kk=_p(xd(260,.75,.35),xd(80,1.5,.8)),Lk=xd(),Pk=Uh(),Nk=Math.PI/3,Ik=2*Math.PI/3;function Rk(t){var e=t.length;return function(n){return t[Math.max(0,Math.min(e-1,Math.floor(n*e)))]}}var Ok=Rk(mA("44015444025645045745055946075a46085c460a5d460b5e470d60470e6147106347116447136548146748166848176948186a481a6c481b6d481c6e481d6f481f70482071482173482374482475482576482677482878482979472a7a472c7a472d7b472e7c472f7d46307e46327e46337f463480453581453781453882443983443a83443b84433d84433e85423f854240864241864142874144874045884046883f47883f48893e49893e4a893e4c8a3d4d8a3d4e8a3c4f8a3c508b3b518b3b528b3a538b3a548c39558c39568c38588c38598c375a8c375b8d365c8d365d8d355e8d355f8d34608d34618d33628d33638d32648e32658e31668e31678e31688e30698e306a8e2f6b8e2f6c8e2e6d8e2e6e8e2e6f8e2d708e2d718e2c718e2c728e2c738e2b748e2b758e2a768e2a778e2a788e29798e297a8e297b8e287c8e287d8e277e8e277f8e27808e26818e26828e26828e25838e25848e25858e24868e24878e23888e23898e238a8d228b8d228c8d228d8d218e8d218f8d21908d21918c20928c20928c20938c1f948c1f958b1f968b1f978b1f988b1f998a1f9a8a1e9b8a1e9c891e9d891f9e891f9f881fa0881fa1881fa1871fa28720a38620a48621a58521a68522a78522a88423a98324aa8325ab8225ac8226ad8127ad8128ae8029af7f2ab07f2cb17e2db27d2eb37c2fb47c31b57b32b67a34b67935b77937b87838b9773aba763bbb753dbc743fbc7340bd7242be7144bf7046c06f48c16e4ac16d4cc26c4ec36b50c46a52c56954c56856c66758c7655ac8645cc8635ec96260ca6063cb5f65cb5e67cc5c69cd5b6ccd5a6ece5870cf5773d05675d05477d1537ad1517cd2507fd34e81d34d84d44b86d54989d5488bd6468ed64590d74393d74195d84098d83e9bd93c9dd93ba0da39a2da37a5db36a8db34aadc32addc30b0dd2fb2dd2db5de2bb8de29bade28bddf26c0df25c2df23c5e021c8e020cae11fcde11dd0e11cd2e21bd5e21ad8e219dae319dde318dfe318e2e418e5e419e7e419eae51aece51befe51cf1e51df4e61ef6e620f8e621fbe723fde725")),zk=Rk(mA("00000401000501010601010802010902020b02020d03030f03031204041405041606051806051a07061c08071e0907200a08220b09240c09260d0a290e0b2b100b2d110c2f120d31130d34140e36150e38160f3b180f3d19103f1a10421c10441d11471e114920114b21114e22115024125325125527125829115a2a115c2c115f2d11612f116331116533106734106936106b38106c390f6e3b0f703d0f713f0f72400f74420f75440f764510774710784910784a10794c117a4e117b4f127b51127c52137c54137d56147d57157e59157e5a167e5c167f5d177f5f187f601880621980641a80651a80671b80681c816a1c816b1d816d1d816e1e81701f81721f817320817521817621817822817922827b23827c23827e24828025828125818326818426818627818827818928818b29818c29818e2a81902a81912b81932b80942c80962c80982d80992d809b2e7f9c2e7f9e2f7fa02f7fa1307ea3307ea5317ea6317da8327daa337dab337cad347cae347bb0357bb2357bb3367ab5367ab73779b83779ba3878bc3978bd3977bf3a77c03a76c23b75c43c75c53c74c73d73c83e73ca3e72cc3f71cd4071cf4070d0416fd2426fd3436ed5446dd6456cd8456cd9466bdb476adc4869de4968df4a68e04c67e24d66e34e65e44f64e55064e75263e85362e95462ea5661eb5760ec5860ed5a5fee5b5eef5d5ef05f5ef1605df2625df2645cf3655cf4675cf4695cf56b5cf66c5cf66e5cf7705cf7725cf8745cf8765cf9785df9795df97b5dfa7d5efa7f5efa815ffb835ffb8560fb8761fc8961fc8a62fc8c63fc8e64fc9065fd9266fd9467fd9668fd9869fd9a6afd9b6bfe9d6cfe9f6dfea16efea36ffea571fea772fea973feaa74feac76feae77feb078feb27afeb47bfeb67cfeb77efeb97ffebb81febd82febf84fec185fec287fec488fec68afec88cfeca8dfecc8ffecd90fecf92fed194fed395fed597fed799fed89afdda9cfddc9efddea0fde0a1fde2a3fde3a5fde5a7fde7a9fde9aafdebacfcecaefceeb0fcf0b2fcf2b4fcf4b6fcf6b8fcf7b9fcf9bbfcfbbdfcfdbf")),Dk=Rk(mA("00000401000501010601010802010a02020c02020e03021004031204031405041706041907051b08051d09061f0a07220b07240c08260d08290e092b10092d110a30120a32140b34150b37160b39180c3c190c3e1b0c411c0c431e0c451f0c48210c4a230c4c240c4f260c51280b53290b552b0b572d0b592f0a5b310a5c320a5e340a5f3609613809623909633b09643d09653e0966400a67420a68440a68450a69470b6a490b6a4a0c6b4c0c6b4d0d6c4f0d6c510e6c520e6d540f6d550f6d57106e59106e5a116e5c126e5d126e5f136e61136e62146e64156e65156e67166e69166e6a176e6c186e6d186e6f196e71196e721a6e741a6e751b6e771c6d781c6d7a1d6d7c1d6d7d1e6d7f1e6c801f6c82206c84206b85216b87216b88226a8a226a8c23698d23698f24699025689225689326679526679727669827669a28659b29649d29649f2a63a02a63a22b62a32c61a52c60a62d60a82e5fa92e5eab2f5ead305dae305cb0315bb1325ab3325ab43359b63458b73557b93556ba3655bc3754bd3853bf3952c03a51c13a50c33b4fc43c4ec63d4dc73e4cc83f4bca404acb4149cc4248ce4347cf4446d04545d24644d34743d44842d54a41d74b3fd84c3ed94d3dda4e3cdb503bdd513ade5238df5337e05536e15635e25734e35933e45a31e55c30e65d2fe75e2ee8602de9612bea632aeb6429eb6628ec6726ed6925ee6a24ef6c23ef6e21f06f20f1711ff1731df2741cf3761bf37819f47918f57b17f57d15f67e14f68013f78212f78410f8850ff8870ef8890cf98b0bf98c0af98e09fa9008fa9207fa9407fb9606fb9706fb9906fb9b06fb9d07fc9f07fca108fca309fca50afca60cfca80dfcaa0ffcac11fcae12fcb014fcb216fcb418fbb61afbb81dfbba1ffbbc21fbbe23fac026fac228fac42afac62df9c72ff9c932f9cb35f8cd37f8cf3af7d13df7d340f6d543f6d746f5d949f5db4cf4dd4ff4df53f4e156f3e35af3e55df2e661f2e865f2ea69f1ec6df1ed71f1ef75f1f179f2f27df2f482f3f586f3f68af4f88ef5f992f6fa96f8fb9af9fc9dfafda1fcffa4")),Bk=Rk(mA("0d088710078813078916078a19068c1b068d1d068e20068f2206902406912605912805922a05932c05942e05952f059631059733059735049837049938049a3a049a3c049b3e049c3f049c41049d43039e44039e46039f48039f4903a04b03a14c02a14e02a25002a25102a35302a35502a45601a45801a45901a55b01a55c01a65e01a66001a66100a76300a76400a76600a76700a86900a86a00a86c00a86e00a86f00a87100a87201a87401a87501a87701a87801a87a02a87b02a87d03a87e03a88004a88104a78305a78405a78606a68707a68808a68a09a58b0aa58d0ba58e0ca48f0da4910ea3920fa39410a29511a19613a19814a099159f9a169f9c179e9d189d9e199da01a9ca11b9ba21d9aa31e9aa51f99a62098a72197a82296aa2395ab2494ac2694ad2793ae2892b02991b12a90b22b8fb32c8eb42e8db52f8cb6308bb7318ab83289ba3388bb3488bc3587bd3786be3885bf3984c03a83c13b82c23c81c33d80c43e7fc5407ec6417dc7427cc8437bc9447aca457acb4679cc4778cc4977cd4a76ce4b75cf4c74d04d73d14e72d24f71d35171d45270d5536fd5546ed6556dd7566cd8576bd9586ada5a6ada5b69db5c68dc5d67dd5e66de5f65de6164df6263e06363e16462e26561e26660e3685fe4695ee56a5de56b5de66c5ce76e5be76f5ae87059e97158e97257ea7457eb7556eb7655ec7754ed7953ed7a52ee7b51ef7c51ef7e50f07f4ff0804ef1814df1834cf2844bf3854bf3874af48849f48948f58b47f58c46f68d45f68f44f79044f79143f79342f89441f89540f9973ff9983ef99a3efa9b3dfa9c3cfa9e3bfb9f3afba139fba238fca338fca537fca636fca835fca934fdab33fdac33fdae32fdaf31fdb130fdb22ffdb42ffdb52efeb72dfeb82cfeba2cfebb2bfebd2afebe2afec029fdc229fdc328fdc527fdc627fdc827fdca26fdcb26fccd25fcce25fcd025fcd225fbd324fbd524fbd724fad824fada24f9dc24f9dd25f8df25f8e125f7e225f7e425f6e626f6e826f5e926f5eb27f4ed27f3ee27f3f027f2f227f1f426f1f525f0f724f0f921"));function Hk(t){return function e(){return t}}var Fk=Math.abs,Vk=Math.atan2,Uk=Math.cos,jk=Math.max,Gk=Math.min,Wk=Math.sin,qk=Math.sqrt,Yk=1e-12,Xk=Math.PI,$k=Xk/2,Kk=2*Xk;function Zk(t){return t>1?0:t<-1?Xk:Math.acos(t)}function Jk(t){return t>=1?$k:t<=-1?-$k:Math.asin(t)}function Qk(t){return t.innerRadius}function tL(t){return t.outerRadius}function eL(t){return t.startAngle}function nL(t){return t.endAngle}function iL(t){return t&&t.padAngle}function rL(t,e,n,i,r,o,a,s){var l=n-t,c=i-e,u=a-r,h=s-o,d=h*l-u*c;if(!(d*d<Yk))return[t+(d=(u*(e-o)-h*(t-r))/d)*l,e+d*c]}function oL(t,e,n,i,r,o,a){var s=t-n,l=e-i,c=(a?o:-o)/qk(s*s+l*l),u=c*l,h=-c*s,d=t+u,p=e+h,f=n+u,m=i+h,g=(d+f)/2,_=(p+m)/2,y=f-d,v=m-p,b=y*y+v*v,x=r-o,w=d*m-f*p,S=(v<0?-1:1)*qk(jk(0,x*x*b-w*w)),M=(w*v-y*S)/b,E=(-w*y-v*S)/b,T=(w*v+y*S)/b,C=(-w*y+v*S)/b,A=M-g,k=E-_,L=T-g,P=C-_;return A*A+k*k>L*L+P*P&&(M=T,E=C),{cx:M,cy:E,x01:-u,y01:-h,x11:M*(r/x-1),y11:E*(r/x-1)}}function aL(t){this._context=t}function sL(t){return new aL(t)}function lL(t){return t[0]}function cL(t){return t[1]}function uL(){var t=lL,e=cL,n=Hk(!0),i=null,r=sL,o=null;function a(a){var s,l,c,u=a.length,h=!1;for(null==i&&(o=r(c=fg())),s=0;s<=u;++s)!(s<u&&n(l=a[s],s,a))===h&&((h=!h)?o.lineStart():o.lineEnd()),h&&o.point(+t(l,s,a),+e(l,s,a));if(c)return o=null,c+""||null}return a.x=function(e){return arguments.length?(t="function"==typeof e?e:Hk(+e),a):t},a.y=function(t){return arguments.length?(e="function"==typeof t?t:Hk(+t),a):e},a.defined=function(t){return arguments.length?(n="function"==typeof t?t:Hk(!!t),a):n},a.curve=function(t){return arguments.length?(r=t,null!=i&&(o=r(i)),a):r},a.context=function(t){return arguments.length?(null==t?i=o=null:o=r(i=t),a):i},a}function hL(){var t=lL,e=null,n=Hk(0),i=cL,r=Hk(!0),o=null,a=sL,s=null;function l(l){var c,u,h,d,p,f=l.length,m=!1,g=new Array(f),_=new Array(f);for(null==o&&(s=a(p=fg())),c=0;c<=f;++c){if(!(c<f&&r(d=l[c],c,l))===m)if(m=!m)u=c,s.areaStart(),s.lineStart();else{for(s.lineEnd(),s.lineStart(),h=c-1;h>=u;--h)s.point(g[h],_[h]);s.lineEnd(),s.areaEnd()}m&&(g[c]=+t(d,c,l),_[c]=+n(d,c,l),s.point(e?+e(d,c,l):g[c],i?+i(d,c,l):_[c]))}if(p)return s=null,p+""||null}function c(){return uL().defined(r).curve(a).context(o)}return l.x=function(n){return arguments.length?(t="function"==typeof n?n:Hk(+n),e=null,l):t},l.x0=function(e){return arguments.length?(t="function"==typeof e?e:Hk(+e),l):t},l.x1=function(t){return arguments.length?(e=null==t?null:"function"==typeof t?t:Hk(+t),l):e},l.y=function(t){return arguments.length?(n="function"==typeof t?t:Hk(+t),i=null,l):n},l.y0=function(t){return arguments.length?(n="function"==typeof t?t:Hk(+t),l):n},l.y1=function(t){return arguments.length?(i=null==t?null:"function"==typeof t?t:Hk(+t),l):i},l.lineX0=l.lineY0=function(){return c().x(t).y(n)},l.lineY1=function(){return c().x(t).y(i)},l.lineX1=function(){return c().x(e).y(n)},l.defined=function(t){return arguments.length?(r="function"==typeof t?t:Hk(!!t),l):r},l.curve=function(t){return arguments.length?(a=t,null!=o&&(s=a(o)