from django.db import models
import random  
import string
from django.contrib.auth.models import User
# Create your models here.
from django.contrib.auth.models import AbstractUser
from django.utils.translation import gettext as _

RISK = (
    ('1', "Green"),
    ('2', "Yellow"),
    ('3', "Red"),
)

class company(models.Model):
	"""
	This model is used to store the information of company.
	"""
	userTableID = models.CharField(max_length = 50, null = True, blank = True)
	userUniqueID = models.CharField(max_length = 50, null = True, blank = True)
	companyStripeId = models.CharField(max_length = 50, null = True, blank = True,default = '')
	risk = models.CharField(max_length = 20,choices = RISK,default = '3')
	token = models.CharField(max_length = 200, null = True, blank = True)
	name = models.CharField(max_length = 50, null = True, blank = True)
	email = models.CharField(max_length = 50, unique = True, null = True, blank = True)
	countrycode = models.CharField(max_length = 50, null = True, blank = True)
	phone = models.CharField(max_length = 50, blank = True, null = True)
	image = models.FileField(upload_to='Profile', blank = True, null = True)
	state = models.CharField(max_length = 50, blank = True, null = True)
	age = models.CharField(max_length = 50, blank = True, null = True)
	dob = models.DateField(max_length=50,blank=True,null=True)
	description = models.TextField(blank = True)
	address = models.TextField(blank = True)
	latitude = models.CharField(max_length = 50, blank = True, null = True)
	longitude = models.CharField(max_length = 50, blank = True, null = True)
	fbURL = models.CharField(max_length = 200, blank = True, null = True)
	instaURL = models.CharField(max_length = 200, blank = True, null = True)
	webURL = models.CharField(max_length = 200, blank = True, null = True)
	fcmtoken = models.CharField(max_length = 200, blank = True, null = True)
	signupOtp = models.CharField(max_length = 50, blank = True, null = True)
	signupOtpVerfied = models.BooleanField(default = False)
	emailverificationlink = models.CharField(max_length = 100, blank = True, null = True)
	emailverified = models.BooleanField(default = False)
	phoneVerifiedOtp = models.CharField(max_length = 50, blank = True, null = True)
	phoneverified = models.BooleanField(default = False)
	socialId = models.CharField(max_length = 70, blank = True, null = True)
	deviceId = models.CharField(max_length = 70, blank = True, null = True)
	deviceType = models.CharField(max_length = 50, blank = True, null = True)
	registerType = models.CharField(max_length = 50, blank = True, null = True)
	userReferalCode = models.CharField(max_length = 50, blank = True, null = True)
	referalByCode = models.CharField(max_length = 50, blank = True, null = True)
	forgotPasswordOTP = models.CharField(max_length=20,blank=True,null=True)
	accountverified = models.BooleanField(default = False)
	accountapproved = models.BooleanField(default = False)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.name)+'-'+str(self.userUniqueID))

DOC_TYPES = (
    ('1', "Passport"),
    ('2', "Licence"),
    ('3', "National ID"),
    ('4', "Registration ID"),
    ('5', "Other"),
)

DOC_STATUS = (
    ('1', "Pending"),
    ('2', "Accepted"),
    ('3', "Rejected"),
)

class companydocuments(models.Model):
	doctType = models.CharField(max_length = 20,choices = DOC_TYPES,default = '5')
	userTableID = models.CharField(max_length = 50, null = True, blank = True)
	userUniqueID = models.CharField(max_length = 50, null = True, blank = True)
	document = models.FileField(upload_to ='Documents', null=True ,blank=True)
	theStatus=models.CharField(max_length = 20,choices = DOC_STATUS,default = '1')
	rejectMessage = models.TextField(null = True, blank = True)
	isApproved = models.BooleanField(default = False)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.userUniqueID)+' - '+str(self.doctType))

class adminaccess(models.Model):
	token = models.CharField(max_length = 50, null = True, blank = True)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.token))

class companytimings(models.Model):
	userTableID = models.CharField(max_length = 20, null = True, blank = True)
	userUniqueID = models.CharField(max_length = 20, null = True, blank = True)
	openingTime = models.TimeField(null = True,blank = True)
	closingTime = models.TimeField(null = True,blank = True)
	monday = models.BooleanField(default = True)
	tuesday = models.BooleanField(default = True)
	wednesday = models.BooleanField(default = True)
	thursday = models.BooleanField(default = True)
	friday = models.BooleanField(default = True)
	saturday = models.BooleanField(default = True)
	sunday = models.BooleanField(default = True)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.userUniqueID)+'-'+str(self.monday)+'-'+str(self.sunday))

class companycard(models.Model):
	companyID = models.CharField(max_length = 50, null = True, blank = True,default = '')
	cardID = models.CharField(max_length = 50, null = True, blank = True,default = '')
	expMonth = models.CharField(max_length = 50, null = True, blank = True,default = '')
	expYear = models.CharField(max_length = 50, null = True, blank = True,default = '')
	theCustomer=models.CharField(max_length = 50, null = True, blank = True,default = '')
	lastDigit=models.CharField(max_length = 50, null = True, blank = True,default = '')
	isdefault = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.customerID)+'-'+str(self.cardID))

class companywallet(models.Model):
	companyID = models.CharField(max_length = 20,blank = True,default = '')
	balance = models.CharField(max_length = 50,blank = True,default = '0.0')
	totalearning = models.CharField(max_length = 50,blank = True,default = '0.0')
	totalWithdrawl = models.CharField(max_length = 50,blank = True,default = '0.0')
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.companyID)+'-'+str(self.balance))

class companyearning(models.Model):
	companyID = models.CharField(max_length = 20,blank = True,default = '')
	storeID = models.CharField(max_length = 20,blank = True,default = '')
	amount = models.CharField(max_length = 50,blank = True,default = '0.0')
	title = models.CharField(max_length = 100,blank = True,default = '')
	description = models.TextField(blank = True)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.companyID)+'-'+str(self.amount))

class storewallet(models.Model):
	companyID = models.CharField(max_length = 20,blank = True,default = '')
	storeID = models.CharField(max_length = 20,blank = True,default = '')
	balance = models.CharField(max_length = 50,blank = True,default = '0.0')
	totalearning = models.CharField(max_length = 50,blank = True,default = '0.0')
	totalWithdrawl = models.CharField(max_length = 50,blank = True,default = '0.0')
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.storeID)+'-'+str(self.balance))

class companynotifications(models.Model):
	companyID = models.CharField(max_length = 20,blank = True,default = '')
	image = models.CharField(max_length = 200, blank = True,default = '')
	userType = models.CharField(max_length = 200, blank = True,default = '')
	notificationType = models.CharField(max_length = 200, blank = True,default = '')
	userID = models.CharField(max_length = 200, blank = True,default = '')
	title = models.CharField(max_length = 50, blank = True,default = '')
	description = models.TextField(null = True, blank = True)
	created_at = models.DateField(auto_now_add = True)

	def __str__(self):
		return str(str(self.title)+'-'+str(self.userID))