from rest_framework import serializers
from .models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from django.conf import settings

class GetCompanyData(serializers.ModelSerializer):
	image =  serializers.SerializerMethodField(source='get_image')
	documents = serializers.SerializerMethodField(source='get_documents')

	class Meta:
		model = company
		fields = ['documents','token','risk','userUniqueID', 'name', 'email','phone','countrycode','socialId','image','phoneverified','userReferalCode','description','fbURL','instaURL','webURL','state']

	def get_image(self, obj):
		return str(obj.image.name)
	
	def get_documents(self,obj):
		allData=[]
		theCompDocs=companydocuments.objects.filter(userUniqueID=obj.userUniqueID)
		for doc in theCompDocs:
			doctType=''
			if doc.doctType == '1':
				doctType='Passport'
			elif doc.doctType == '2':
				doctType='Licence'
			elif doc.doctType == '3':
				doctType='National ID'
			elif doc.doctType == '4':
				doctType='Registration ID'
			elif doc.doctType == '5':
				doctType='Other'
			else:
				doctType='Other'
			theImage=str(doc.document.name)
			allData.append({'id':doc.id,
				            'theDocType':doctType,
				            'document':theImage,
				            'status':doc.theStatus,
							'rejectReason':doc.rejectMessage,})
		return allData

class GetCompanyDataNew(serializers.ModelSerializer):
	documents = serializers.SerializerMethodField(source='get_documents')
	class Meta:
		model = company
		fields = ['documents','token','risk','userUniqueID', 'name', 'email','phone','countrycode','socialId','image','phoneverified','userReferalCode','description','fbURL','instaURL','webURL','state']
	
	def get_documents(self,obj):
		allData=[]
		theCompDocs=companydocuments.objects.filter(userUniqueID=obj.userUniqueID)
		for doc in theCompDocs:
			doctType=''
			if doc.doctType == '1':
				doctType='Passport'
			elif doc.doctType == '2':
				doctType='Licence'
			elif doc.doctType == '3':
				doctType='National ID'
			elif doc.doctType == '4':
				doctType='Registration ID'
			elif doc.doctType == '5':
				doctType='Other'
			else:
				doctType='Other'
			theImage=str(doc.document.name)
			allData.append({'id':doc.id,
				            'theDocType':doctType,
				            'document':theImage,
				            'status':doc.theStatus,})
		return allData