from django.contrib import admin
from django.urls import path
from django.conf.urls import url, include
from django.views.static import serve
from django.conf import settings
from django.conf.urls import handler400, handler403, handler404, handler500
from .views import *
from . import views
urlpatterns = [
   url(r'^$',Index, name='index'),
   path('getStateList/', getStateList.as_view(), name = 'getStateList'),
   path('register/', register.as_view(), name = 'register'),
   path('veifySignupOTP/', veifySignupOTP.as_view(), name = 'veifySignupOTP'),
   path('login/', Login.as_view(), name = 'Login'),
   url(r'^checkAuthentication/$', checkAuthentication.as_view(), name='checkAuthentication'),
   path('forgotPassword/', forgotPassword.as_view(), name = 'forgotPassword'),
   url(r'^forgotPasswordVerifyOtp/$', forgotPasswordVerifyOtp.as_view(), name='forgotPasswordVerifyOtp'),
   url(r'^updatePassword/$', updatePassword.as_view(), name='updatePassword'),
   url(r'^getProfile/$', getProfile.as_view(), name='getProfile'),
   url(r'^updateProfile/$', updateProfile.as_view(), name='updateProfile'),
   url(r'^changePassword/$', changePassword.as_view(), name='changePassword'),
   url(r'^logout/$', logout.as_view(), name='logout'),
   url(r'^updateDocuments/$', updateDocuments.as_view(), name='updateDocuments'),
   path('getEarningList/',getEarningList.as_view()),
   path('getDriversCompletedOrdersList/',getDriversCompletedOrdersList.as_view()),

   # Card
   path('addCard/',addCard.as_view()),
   path('setDefaultCard/',setDefaultCard.as_view()),
   path('deleteCard/',deleteCard.as_view()),
   path('getCardList/',getCardList.as_view()),

   # Send Notification
   url(r'^sendNotification/$', sendNotification.as_view(), name='sendNotification'),
   path('compNotify/',compNotify.as_view()),
   path('getNotifications/',getNotifications.as_view()),
   path('deleteNotification/',deleteNotification.as_view()),
   path('deleteNotificationList/',deleteNotificationList.as_view()),
   path('filterNotifications/',filterNotifications.as_view()),
   path('getDashboardData/',getDashboardData.as_view()),
   path('requestPayout/', requestPayout.as_view()),
   path('linkAccount/', linkAccount.as_view()),
   path('getStripeLoginLink/', getStripeLoginLink.as_view()),
   path('addDebitCard/', addDebitCard.as_view()),
   path('deleteDebitCard/', deleteDebitCard.as_view()),

]
