from django.shortcuts import render
from rest_framework.views import APIView
from django.http import JsonResponse
from django.views.decorators.csrf import csrf_exempt
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from .models import *
from pyfcm import FCMNotification
import math, random, datetime, pytz, string
from django.conf import settings
import requests, json
from django.contrib.auth.hashers import make_password
from django.db.models import Q
from .serializers import *
from django.http import HttpResponse
from rest_framework.response import Response
from django.contrib.auth import authenticate, login
from django.core.files.storage import FileSystemStorage
from django.template.loader import render_to_string
from django.core.mail import EmailMessage
import datetime
import stripe


import boto
import boto.exception
import boto.sns
import pprint
import re

def notifyAdmin(body,ntype,notifyCheckType,title,theUserID):
	import requests
	url=str(settings.ADMIN_ACCESS_URL)+'superadmin/auth/adminNotify/'
	# url = "http://18.117.53.164:8001/superadmin/auth/adminNotify/"
	payload={'body':str(body),
	'title':str(title),
	'userID':str(theUserID),
	'userType':'Company',
	'notifyCheckType':notifyCheckType,
	'type':str(ntype)}
	response = requests.request("POST", url ,data=payload)
	print(response.text)


def Index(request):
	return HttpResponse("<h4>Admin Basic Details</h4>")

def setTokenInAdminStore(token):
	print("in funct",token)
	url = str(settings.STORE_ACCESS_URL)+'companyLoginToken/'
	print(url)
	payload={'AccessKey': token}
	print(payload)
	apiResponse = requests.request("POST", url,data=payload)
	print(apiResponse)
	r=apiResponse.json()
	print(r)
	return r['status_code']

def setTokenInAdminHelpSupportCompany(token,companyID):
	print("in funct",token)
	url = str(settings.CHS_ACCESS_URL)+'company/support/auth/companyLoginToken/'
	print(url)
	payload={'AccessKey': token,
			 'companyID':companyID,}
	print(payload)
	apiResponse = requests.request("POST", url,data=payload)
	print(apiResponse)
	r=apiResponse.json()
	print(r)
	# return r
	return r['status_code']

def setTokenInDriver(token):
	print("in funct",token)
	url = str(settings.DRIVER_ACCESS_URL)+'companyLoginToken/'
	print(url)
	payload={'AccessKey': token}
	print(payload)
	apiResponse = requests.request("POST", url,data=payload)
	print(apiResponse)
	r=apiResponse.json()
	print(r)
	return r['status_code']

def setTokenInDriverLogout(token):
	url = str(settings.DRIVER_ACCESS_URL)+'companyLogoutToken/'
	payload={'AccessKey': token}
	apiResponse = requests.request("POST", url,data=payload)
	r=apiResponse.json()
	return r['status_code']

def setTokenInAdminStoreLogout(token):
	url = str(settings.STORE_ACCESS_URL)+'companyLogoutToken/'
	payload={'AccessKey': token}
	apiResponse = requests.request("POST", url,data=payload)
	r=apiResponse.json()
	return r['status_code']

def setTokenInHelpSupportLogout(token):
	url = str(settings.CHS_ACCESS_URL)+'/company/support/auth/companyLogoutToken/'
	payload={'AccessKey': token}
	apiResponse = requests.request("POST", url,data=payload)
	r=apiResponse.json()
	return r['status_code']

def referralCode():
	try:
		Referal=''
		digits2 = "rba2cqq4skyhz7meizjk"
		for i in range(8): 
		  Referal += digits2[math.floor(random.random() * 15)]
		print(Referal)
	except Exception as e:
		print(e)
	return str(Referal)

def GernateOTP():
	digits = "0123456789"
	OTP = ""
	for i in range(4) :
		OTP += digits[math.floor(random.random() * 10)]
	return OTP

def randomStringFunction():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(8)))
	str1 += ''.join((random.choice(string.digits) for x in range(4)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

def randomStringFunctionForImage():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(10)))
	str1 += ''.join((random.choice(string.digits) for x in range(6)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

# def uploadDocumentImages(image,thePath):
# 	import os
# 	fullPath='media/'+str(thePath)+'/'
# 	fs = FileSystemStorage(location=fullPath)
# 	beforename = os.path.splitext(image.name)[0]
# 	beforename = beforename.replace(" ","")
# 	filetype = os.path.splitext(image.name)[1]
# 	theName=randomStringFunctionForImage()
# 	theImageName=str(theName)+str(filetype)
# 	filename = fs.save(theImageName, image)
# 	# filename = fs.url(filename)
# 	return str(fullPath)+'/'+filename

def uploadDocumentImages(image,thePath):
	import os
	import boto3
	from botocore.exceptions import NoCredentialsError
	try:
		bucket=str(settings.AWS_BUCKET_NAME)
		thePath=thePath.lower()
		ACCESS_KEY=str(settings.AWS_ACCESS_KEY_ID)
		SECRET_KEY=str(settings.AWS_SECRET_ACCESS_KEY)
		s3 = boto3.client('s3', aws_access_key_id=ACCESS_KEY,
					  aws_secret_access_key=SECRET_KEY)
		try:
			filetype = os.path.splitext(image.name)[1]
			imageName=randomStringFunctionForImage()
			thePath=thePath+'/'+imageName+'.'+filetype
			thePath=str(thePath)
			theFile=s3.upload_fileobj(image,bucket,thePath)
			print("Upload Successful")
			filename=str(settings.AWS_BUCKET_URL_1)+str(bucket)+str(settings.AWS_BUCKET_URL_2)+thePath
			return filename
		except FileNotFoundError as e:
			print("The file was not found")
			return ''
		except NoCredentialsError:
			print("Credentials not available")
			return ''
	except Exception as e:
		print(e)
		return ''

class register(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		data=request.data
		try:

			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)
			if not data.get('name'):
				response['status_code']=400
				response['status_message']='Name required'
				return Response(response)
			if not data.get('phone'):
				response['status_code']=400
				response['status_message']='Phone required'
				return Response(response)
			if not data.get('countrycode'):
				response['status_code']=400
				response['status_message']='Country code required'
				return Response(response)
			if not data.get('password'):
				response['status_code']=400
				response['status_message']='Password required'
				return Response(response)
			if not data.get('state'):
				response['status_code']=400
				response['status_message']='State required'
				return Response(response)
			# if not data.get('age'):
			#     response['status_code']=400
			#     response['status_message']='Age required'
			#     return Response(response)
			# print("secons")
			# if not data.get('dob'):
			#     response['status_code']=400
			#     response['status_message']='D.O.B required'
			#     return Response(response)
			if not request.FILES.get('passportImage'):
				response['status_code']=400
				response['status_message']='Passport image required'
				return Response(response)
			if not request.FILES.get('licenceImage'):
				response['status_code']=400
				response['status_message']='Licence image required'
				return Response(response)
			if not request.FILES.get('nationalID'):
				response['status_code']=400
				response['status_message']='National id required'
				return Response(response)
			if not request.FILES.get('registrationProof'):
				response['status_code']=400
				response['status_message']='Registeration proof required'
				return Response(response)

			otp=GernateOTP()
			theDocuments = request.FILES.getlist("documents")
			userOBJ = User.objects.filter(username = data.get('email')).first()
			if userOBJ:
				response['status_code']=400
				response['status_message']='Email already exist'
				return Response(response)
			phnExist=company.objects.filter(phone=data.get('phone'))
			if phnExist:
				response['status_code']=400
				response['status_message']='Phone number already exist'
				return Response(response)
			userOBJ = User.objects.create_user(username = data.get('email'), password = data.get('password'))
			userObjId=userOBJ.id
			beforeNameOfCompany=data.get('name')
			name3Letter=beforeNameOfCompany[0:3]
			name3Letter=name3Letter.upper()
			latExt=company.objects.all().last()
			if latExt:
				lastId=latExt.userUniqueID
				last5Number=lastId[3:]
				last5Number=int(last5Number)
				new5Number=last5Number+1
				new5Number=str(new5Number)
				new5Number = new5Number.zfill(5)
				theUniqueID=str(name3Letter)+str(new5Number)
			else:
				theUniqueID=str(name3Letter)+str('00001')
			# theUniqueID=randomStringFunction()
			adminObj = company.objects.create(state=data.get('state'),userUniqueID=theUniqueID,userTableID=userObjId, name = data.get('name'),email = data.get('email'),registerType='Normal',countrycode=data.get('countrycode'),phone=data.get('phone'), signupOtp = otp,userReferalCode=referralCode())
			if not adminObj.companyStripeId:
				theStripeCusId=createCustomerOnStripe()
				adminObj.companyStripeId=theStripeCusId
				adminObj.save()
			passportImage=request.FILES.get('passportImage')
			if passportImage:
				filename=uploadDocumentImages(passportImage,'Documents')
				ownerDocs=companydocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='1')
			licenceImage=request.FILES.get('licenceImage')
			if licenceImage:
				filename=uploadDocumentImages(licenceImage,'Documents')
				ownerDocs=companydocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='2')
			nationalID=request.FILES.get('nationalID')
			if nationalID:
				filename=uploadDocumentImages(nationalID,'Documents')
				ownerDocs=companydocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='3')
			registrationProof=request.FILES.get('registrationProof')
			if registrationProof:
				filename=uploadDocumentImages(registrationProof,'Documents')
				ownerDocs=companydocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='4')
			if theDocuments:
				for count, image in enumerate(theDocuments):
					filename=uploadDocumentImages(image,'Documents')
					ownerDocs=companydocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='5')
			
			companytimings.objects.create(userTableID=userObjId,userUniqueID=theUniqueID)
			companywallet.objects.create(companyID=theUniqueID)
			try:
				subject='Signup'
				message = render_to_string('companySignupOTPMail.html', {
					'otp': otp,
					'name': data.get('name'),
				})
				from_email = settings.EMAIL_HOST_USER
				to_email = data.get('email')
				message = EmailMessage(subject, message, from_email, [to_email])
				message.content_subtype = 'html'
				message.send()
			except Exception as e:
				print(e)
			
			response['status_code']=200
			response['status_message']='Sucessfully register'
		except Exception as e:
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class veifySignupOTP(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		data = request.data
		try:
			if not data.get('otp'):
				response['status_code']=400
				response['status_message']='OTP required'
				return Response(response)
			if not data.get('email'):
				if not data.get('phone'):
					response['status_code']=400
					response['status_message']='Email or Phone required'
					return Response(response)
				if not data.get('countrycode'):
					response['status_code']=400
					response['status_message']='Country code required'
					return Response(response)
				ownerEmailObject = company.objects.filter(phone = data.get('phone'), signupOtpVerfied = False,accountverified=False,countrycode=data.get('countrycode'),signupOtp=data.get('otp')).first()
			else:
				ownerEmailObject = company.objects.filter(email = data.get('email'), signupOtpVerfied = False,accountverified=False,signupOtp=data.get('otp')).first()
			if not ownerEmailObject:
				response['status_code']=400
				response['status_message']='OTP not matched'
			else:
				ownerEmailObject.signupOtpVerfied=True
				ownerEmailObject.accountverified=True
				ownerEmailObject.phoneverified=True
				ownerEmailObject.save()
				theOwnerData = GetCompanyData(ownerEmailObject)
				response['status_code']=200
				response['status_message']='User Verified Successfully'
				response['data']=theOwnerData.data
				

				adminBodySend='New company '+str(ownerEmailObject.name)+ ' has been register'
				adminTypeSend='push'
				adminTitleSend='New Company'
				adminUserID=ownerEmailObject.userUniqueID
				notifyAdmin(adminBodySend,adminTypeSend,'new_company',adminTitleSend,adminUserID)

				try:
					subject='Welcome'
					message = render_to_string('welcomeEmailOfCompany.html', {
						'name': ownerEmailObject.name,
					})
					from_email = settings.EMAIL_HOST_USER
					to_email = data.get('email')
					message = EmailMessage(subject, message, from_email, [to_email])
					message.content_subtype = 'html'
					message.send()
				except Exception as e:
					print(e)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class veifySignupOTPNew(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		data = request.data
		try:
			if not data.get('email'):
				ownerEmailObject = company.objects.filter(phone = data.get('phone'), signupOtpVerfied = False,accountverified=False,countrycode=data.get('countrycode'),signupOtp=data.get('otp')).first()
			else:
				ownerEmailObject = company.objects.filter(email = data.get('email'), signupOtpVerfied = False,accountverified=False,signupOtp=data.get('otp')).first()
			if not ownerEmailObject:
				response['status_code']=400
				response['status_message']='OTP not matched'
			else:
				ownerEmailObject.signupOtpVerfied=True
				ownerEmailObject.accountverified=True
				ownerEmailObject.phoneverified=True
				ownerEmailObject.save()
				theOwnerData = GetCompanyDataNew(ownerEmailObject)
				response['status_code']=200
				response['status_message']='User Verified Successfully'
				response['data']=theOwnerData.data
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)



def getToken(obj):
		userObject=User.objects.filter(id=obj.userTableID).first()
		token,status = Token.objects.get_or_create(user = userObject)
		tokenKey=token.key
		return tokenKey

def createCustomerOnStripe():
	customerStripeID = ""
	try:
		stripe.api_key  = settings.STRIPE_SECRET_KEY
		createStripeCusObject = stripe.Customer.create(description="Customer for stripe card")
		# create_cus = json.loads(create_cus)
		if createStripeCusObject:
			customerStripeID = createStripeCusObject['id']
	except Exception as e:
		print("Exception",e)
	return customerStripeID

class Login(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)
			if not data.get('password'):
				response['status_code']=400
				response['status_message']='Password required'
				return Response(response)
			
			if not data.get('fcmtoken'):
				fcmtoken=''
			else:
				fcmtoken=data.get('fcmtoken')
			
			if not data.get('deviceType'):
				deviceType=''
			else:
				deviceType=data.get('deviceType')

			user = authenticate(username = data.get('email'), password = data.get('password'))
			if not user:
				response['verified']=True
				response['status_code']=400
				response['status_message']='Invalid Credentials1'
				return Response(response)
			adminObjects=company.objects.filter(userTableID=user.id).first()
			print(adminObjects)
			if not adminObjects:
				response['verified']=True
				response['status_code']=400
				response['status_message']='Invalid Credentials2'
				return Response(response)
			print(adminObjects.accountverified)
			print(adminObjects.signupOtpVerfied)
			if adminObjects.accountverified==False or adminObjects.signupOtpVerfied==False:
				response['status_code']=400
				response['status_message']='Please verify your account first.'
				otp=GernateOTP()
				response['otp']=otp
				response['verified']=False
				adminObjects.signupOtp=otp
				adminObjects.save()
				return Response(response)
			if adminObjects.isdisabled==True:
				response['verified']=True
				response['status_code']=400
				response['status_message']='Your account has been disabled by admin.'
				return Response(response)
			theToken=getToken(adminObjects)
			if not adminObjects.companyStripeId:
				theStripeCusId=createCustomerOnStripe()
				adminObjects.companyStripeId=theStripeCusId
			adminObjects.token=theToken
			adminObjects.fcmtoken=fcmtoken
			adminObjects.deviceType=deviceType
			adminObjects.save()
			theData=GetCompanyData(adminObjects)
			response['status_code']=200
			response['verified']=True
			response['status_message']='Sucessfully login'
			response['data']=theData.data
			print(response['data']['token'])
			theToken=response['data']['token']
			try:
				theResponse=setTokenInAdminStore(theToken)
				print(theResponse)
				if theResponse!=200:
					response['status_code']=400
					response['status_message']='Oops! Something went wrong'
			except Exception as e:
				print(e)
			
			try:
				theResponse=setTokenInAdminHelpSupportCompany(theToken,theData['userUniqueID'])
				print(theResponse)
				# return Response(theResponse.json())
				if theResponse!=200:
					response['status_code']=400
					response['status_message']='Oops! Something went wrong'
			except Exception as e:
				print(e)

			try:
				theResponse=setTokenInDriver(theToken)
				if theResponse!=200:
					response['status_code']=400
					response['status_message']='Oops! Something went wrong'
			except Exception as e:
				print(e)
			
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class forgotPassword(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'

			adminObj = company.objects.filter(email = data.get('email')).first()
			if not adminObj:
				response['status_code']=400
				response['status_message']='Email not exist'
				return Response(response)
			OTP=GernateOTP()
			adminObj.forgotPasswordOTP=OTP
			adminObj.save()
			response['status_code']=200
			response['status_message']='OTP send on Your Mobile'
			response['OTP']=OTP
			try:
				subject='Forgot Password'
				message = render_to_string('forgotPasswordEmail.html', {
					'name': adminObj.name,
					'otp': OTP,
				})
				from_email = settings.EMAIL_HOST_USER
				to_email = data.get('email')
				message = EmailMessage(subject, message, from_email, [to_email])
				message.content_subtype = 'html'
				message.send()
			except Exception as e:
				print(e)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class forgotPasswordNew(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObj = company.objects.filter(email = data.get('email')).first()
			if not adminObj:
				response['status_code']=400
				response['status_message']='Email not exist'
				return Response(response)
			OTP=GernateOTP()
			startTime=datetime.datetime.now()
			expireTime=datetime.datetime.now()+timedelta(minutes=10)
			adminObj.forgotPasswordOTP=OTP
			adminObj.starttime=startTime
			adminObj.expiretime=expireTime
			adminObj.save()
			response['status_code']=200
			response['status_message']='OTP send on Your Mobile'
			response['OTP']=OTP
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class forgotPasswordVerifyOtp(APIView):

	def post(self, request, *args, **kwargs):
		response={}
		try:
			response['status_code']=200
			response['status_message']='OTP verified'
			data=request.data
			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)
			if not data.get('otp'):
				response['status_code']=400
				response['status_message']='OTP required'
				return Response(response)
			adminObj = company.objects.filter(email = data.get('email'),forgotPasswordOTP=data.get('otp')).first()
			if not adminObj:
				response['status_code']=400
				response['status_message']='Verification Failed, OTP not matched'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class updatePassword(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)

			if not data.get('otp'):
				response['status_code']=400
				response['status_message']='OTP required'
				return Response(response)

			if not data.get('password'):
				response['status_code']=400
				response['status_message']='Password required'
				return Response(response)

			adminObj = company.objects.filter(email = data.get('email'),forgotPasswordOTP=data.get('otp')).first()
			if not adminObj:
				response['status_code']=400
				response['status_message']='invalid otp.'
				return Response(response)
			userObj=User.objects.filter(id=adminObj.userTableID).first()
			userObj.set_password(data.get('password'))
			userObj.save()
			response['status_code']=200
			response['status_message']='Password Update Successfully'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)



def validateToken(theToken):
	returnId='0'
	tokenOBJ = Token.objects.filter(key = theToken).first()
	if tokenOBJ:
		user = User.objects.get(id = tokenOBJ.user_id)
	if user:
		returnId=user.id
	return returnId

def uploadImage(image):
	fs = FileSystemStorage()
	filename = fs.save(image.name, image)
	filename = fs.url(filename)
	return filename

class getProfile(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			adminObjects=company.objects.filter(token=session_token).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			theData=GetCompanyData(adminObjects)
			response['status_code']=200
			response['status_message']='Sucessfully login'
			response['data']=theData.data
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)


class getProfileNew(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			# userID=validateToken(data.get('session_token'))
			# if userID == '0':
			# 	response['status_code']=400
			# 	response['status_message']='Invalid Credentials1'
			# 	return Response(response)
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			adminObjects=company.objects.filter(token=session_token).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials2'
				return Response(response)
			theData=GetCompanyDataNew(adminObjects)
			response['status_code']=200
			response['status_message']='Sucessfully login'
			response['data']=theData.data
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class updateProfile(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			userID=validateToken(data.get('session_token'))
			if userID == '0':
				response['status_code']=400
				response['status_message']='Invalid Credentials1'
				return Response(response)
			adminObjects=company.objects.filter(userTableID=userID).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials2'
				return Response(response)
			if data.get('name'):
				adminObjects.name=data.get('name')
			if data.get('phone'):
				adminObjects.phone=data.get('phone')
			if data.get('countrycode'):
				adminObjects.countrycode=data.get('countrycode')
			if data.get('state'):
				adminObjects.state=data.get('state')
			if data.get('fbURL'):
				adminObjects.fbURL=data.get('fbURL')
			if data.get('instaURL'):
				adminObjects.instaURL=data.get('instaURL')
			theImage = request.FILES.get("image")
			if theImage:
				filename=uploadDocumentImages(theImage,'Profile')
				adminObjects.image=filename
			adminObjects.save()
			response['status_code']=200
			response['status_message']='Profile update'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)


class changePassword(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			if not data.get('oldPassword'):
				response['status_code']=400
				response['status_message']='Old password required'
				return Response(response)
			if not data.get('newPassword'):
				response['status_code']=400
				response['status_message']='New password required'
			tokenOBJ = Token.objects.filter(key = session_token).first()
			if not tokenOBJ:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			user = User.objects.get(id = tokenOBJ.user_id)
			if not user:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			userObj = authenticate(username = user.username, password = data.get('oldPassword'))
			# userObj=User.objects.filter(id=adminObj.userTableID).first()
			userObj.set_password(data.get('newPassword'))
			userObj.save()
			response['status_code']=200
			response['status_message']='Password Update Successfully'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class logout(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			
			tokenOBJ = Token.objects.filter(key = session_token).first()
			if not tokenOBJ:
				response['status_code']=400
				response['status_message']='Invalid Session Token'
			userOBJ = User.objects.get(id = tokenOBJ.user_id)
			companyOBJ = company.objects.filter(userTableID = userOBJ.id).first()
			if not companyOBJ:
				response['status_code']=400
				response['status_message']='Not a valid customer'
			else:
				companyOBJ.token=''
				companyOBJ.fcmtoken=''
				companyOBJ.save()
				userOBJ.auth_token.delete()
				response['status_code']=200
				response['status_message']='Logout successfully'
			try:
				theResponse=setTokenInAdminStoreLogout(data.get('session_token'))
				if theResponse!=200:
					response['status_code']=400
					response['status_message']='Oops! Something went wrong'
					return Response(response)
			except Exception as e:
				print(e)
			try:
				theResponse=setTokenInHelpSupportLogout(data.get('session_token'))
				if theResponse!=200:
					response['status_code']=400
					response['status_message']='Oops! Something went wrong'
					return Response(response)
			except Exception as e:
				print(e)
			try:
				theResponse=setTokenInDriverLogout(data.get('session_token'))
				if theResponse!=200:
					response['status_code']=400
					response['status_message']='Oops! Something went wrong'
					return Response(response)
			except Exception as e:
				print(e)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updateDocuments(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			compObjects=company.objects.filter(token=session_token).first()
			if not compObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			theIDS = request.POST.getlist("ids")
			theDocuments = request.FILES.getlist("documents")
			passportImage=request.FILES.get('passportImage')
			if passportImage:
				passportImageID=request.POST.get('passportImageID')
				if passportImageID == '0':
					filename=uploadDocumentImages(passportImage,'Documents')
					ownerDocs=companydocuments.objects.create(userTableID=compObjects.userTableID,userUniqueID=compObjects.userUniqueID,document=filename,doctType='1')
				else:
					filename=uploadDocumentImages(passportImage,'Documents')
					ownerDocs=companydocuments.objects.filter(userTableID=compObjects.userTableID,userUniqueID=compObjects.userUniqueID,id=passportImageID,doctType='1').first()
					if ownerDocs:
						ownerDocs.document=filename
						ownerDocs.theStatus='1'
						ownerDocs.save()
			licenceImage=request.FILES.get('licenceImage')
			if licenceImage:
				licenceImageID=request.POST.get('licenceImageID')
				if licenceImageID == '0':
					filename=uploadDocumentImages(licenceImage,'Documents')
					ownerDocs=companydocuments.objects.create(userTableID=compObjects.userTableID,userUniqueID=compObjects.userUniqueID,document=filename,doctType='2')
				else:
					filename=uploadDocumentImages(licenceImage,'Documents')
					ownerDocs=companydocuments.objects.filter(userTableID=compObjects.userTableID,userUniqueID=compObjects.userUniqueID,id=licenceImageID,doctType='2').first()
					if ownerDocs:
						ownerDocs.document=filename
						ownerDocs.theStatus='1'
						ownerDocs.save()
			nationalID=request.FILES.get('nationalID')
			if nationalID:
				nationalProofID=request.POST.get('nationalProofID')
				if nationalProofID == '0':
					filename=uploadDocumentImages(nationalID,'Documents')
					ownerDocs=companydocuments.objects.create(userTableID=compObjects.userTableID,userUniqueID=compObjects.userUniqueID,document=filename,doctType='3')
				else:
					filename=uploadDocumentImages(nationalID,'Documents')
					ownerDocs=companydocuments.objects.filter(userTableID=compObjects.userTableID,userUniqueID=compObjects.userUniqueID,id=nationalProofID,doctType='3').first()
					if ownerDocs:
						ownerDocs.document=filename
						ownerDocs.theStatus='1'
						ownerDocs.save()
			registrationProof=request.FILES.get('registrationProof')
			if registrationProof:
				registrationProofID=request.POST.get('registrationProofID')
				if registrationProofID == '0':
					filename=uploadDocumentImages(registrationProof,'Documents')
					ownerDocs=companydocuments.objects.create(userTableID=compObjects.userTableID,userUniqueID=compObjects.userUniqueID,document=filename,doctType='4')
				else:
					filename=uploadDocumentImages(registrationProof,'Documents')
					ownerDocs=companydocuments.objects.filter(userTableID=compObjects.userTableID,userUniqueID=compObjects.userUniqueID,id=registrationProofID,doctType='4').first()
					if ownerDocs:
						ownerDocs.document=filename
						ownerDocs.theStatus='1'
						ownerDocs.save()
			for count, image in enumerate(theDocuments):
				if theIDS[count] == '0':
					filename=uploadDocumentImages(image,'Documents')
					ownerDocs=companydocuments.objects.create(userTableID=compObjects.userTableID,userUniqueID=compObjects.userUniqueID,document=filename,doctType='5')
				else:
					alreadyDoc=companydocuments.objects.filter(userTableID=compObjects.userTableID,id=theIDS[count]).first()
					if alreadyDoc:
						filename=uploadDocumentImages(image,'Documents')
						alreadyDoc.document=filename
						alreadyDoc.theStatus='1'
						alreadyDoc.save()
			response['status_code']=200
			response['status_message']='Documents Updated Successfully'
			
			adminBodySend=str(compObjects.name)+ ' has been updated there documents'
			adminTypeSend='push'
			adminTitleSend='Documents Updated'
			adminUserID=compObjects.userUniqueID
			notifyAdmin(adminBodySend,adminTypeSend,'document_updated',adminTitleSend,adminUserID)

		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getStateList(APIView):
	def get(self, request):
		response={}
		try:
			url = str(settings.ADMIN_ACCESS_URL)+"superadmin/setting/getStatesForOthers/"
			headers = {
			'Authorization': 'Token '+str(settings.ADMIN_ACCESS_KEY)+'',
			}
			r = requests.request("POST", url, headers=headers)
			
			print(r)
			return Response(r.json())
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class addCard(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			# session_token = request.META.get('HTTP_AUTHORIZATION')
			# if not session_token:
			# 	response['status_code']=401
			# 	response['status_message']='Session token required'
			# 	return Response(response,status=response['status_code'])


			if not data.get('sourceToken'):
				response['status_code']=400
				response['status_message']='sourceToken required'
				return Response(response)

			# session_token = session_token.replace("Token ", "")
			

			compObjects=company.objects.filter(token=session_token).first()
			if not compObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)

			# customerObjects=Customer.objects.filter(userToken=session_token).first()
			# if not customerObjects:
			# 	response['status_code']=401
			# 	response['status_message']='Invalid token'
			# 	return Response(response,status=response['status_code'])
			# print("==1==")
			if compObjects.companyStripeId:
				customerId = compObjects.companyStripeId
				sourceToken=data.get('sourceToken')
				stripe.api_key = settings.STRIPE_SECRET_KEY
				createCard = stripe.Customer.create_source(customerId,source=sourceToken)
				print("createCard================>",createCard)
				if createCard:
					print("==3==")
					alreadyAdefaultCardPresent=companycard.objects.filter(companyID=compObjects.userUniqueID,isdefault=True).first()
					if alreadyAdefaultCardPresent:
						theDefault=False
					else:
						theDefault=True
					createCardObject = companycard.objects.create(companyID=compObjects.userUniqueID,cardID=createCard['id'],expMonth=createCard['exp_month'],expYear=createCard['exp_year'],theCustomer=createCard['customer'],lastDigit=createCard['last4'],isdefault=theDefault)
					response['status_code'] = 200
					response['status_message'] = 'Success'
				else:
					print("==4==")
					response['status_code'] = 400
					response['status_message'] = 'Oops! Something went wrong'
			else:
				print("==5==")
				response['status_code'] = 400
				response['status_message'] = "You don't have a stripe Id"
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class setDefaultCard(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			
			compObjects=company.objects.filter(token=session_token).first()
			if not compObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)

			if not data.get('cardID'):
				response['status_code']=400
				response['status_message']='cardID required'
				return Response(response)

			# session_token = session_token.replace("Token ", "")
			# customerObjects=Customer.objects.filter(userToken=session_token).first()
			# if not compObjects:
			# 	response['status_code']=400
			# 	response['status_message']='Invalid token'
			# 	return Response(response)
			
			theCard=companycard.objects.filter(companyID=compObjects.userUniqueID,cardID=data.get('cardID')).first()
			if not theCard:
				response['status_code']=400
				response['status_message']='Invalid card selection'
				return Response(response)
			oldDefaultCard=companycard.objects.filter(companyID=compObjects.userUniqueID,isdefault=True).first()
			if oldDefaultCard:
				oldDefaultCard.isdefault=False
				oldDefaultCard.save()
			theCard.isdefault=True
			theCard.save()
			response['status_code'] = 200
			response['status_message'] = 'Card set default'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)
	
class deleteCard(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			
			compObjects=company.objects.filter(token=session_token).first()
			if not compObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)

			if not data.get('cardID'):
				response['status_code']=400
				response['status_message']='cardID required'
				return Response(response)
			
			theCard=companycard.objects.filter(companyID=compObjects.userUniqueID,cardID=data.get('cardID')).first()
			if not theCard:
				response['status_code']=400
				response['status_message']='Invalid card selection'
				return Response(response)
			if theCard.isdefault==True:
				response['status_code']=400
				response['status_message']='You can not delete a default card'
				return Response(response)
			stripe.api_key = settings.STRIPE_SECRET_KEY
			respo=stripe.Customer.delete_source(
				str(theCard.theCustomer),
				str(data.get('cardID')),
				)
			print(respo)
			if respo['deleted']==True:
				theCard.delete()
			response['status_code'] = 200
			response['status_message'] = 'Card Deleted'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getCardList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData=[]
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			
			compObjects=company.objects.filter(token=session_token).first()
			if not compObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)

			theCards=companycard.objects.filter(companyID=compObjects.userUniqueID)
			for card in theCards:
				context = {}
				context['cardCustomerID'] = card.theCustomer
				context['lastDigit'] =card.lastDigit
				context['expMonth'] = card.expMonth
				context['expYear'] = card.expYear
				context['cardID'] = card.cardID
				context['cardObjectID'] = card.id
				context['isdefault'] = card.isdefault
				allData.append(context)
			response['data']=allData
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class checkAuthentication(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=company.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Unauthenticated'
				return Response(response)
			response['status_code']=200
			response['status_message']='Authenticated'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
			return Response(response)

def sendDriverPushNotfications(title,body,notificationType):
	import requests
	url=str(settings.DRIVER_ACCESS_URL)+'driver/auth/driverNotify/'
	payload={'body':str(body),
			 'title':str(title),
			 'notificationType':str(notificationType)}
	response = requests.request("POST", url ,data=payload)
	print(response.text)

def sendStorePushNotfications(title,body,notificationType):
	print("=1=")
	import requests
	print("=2=")
	url=str(settings.STORE_ACCESS_URL)+'store/auth/storeNotify/'
	print("=3=")
	payload={'body':str(body),
	'title':str(title),
	'notificationType':str(notificationType)}
	print("=4=")
	response = requests.request("POST", url ,data=payload)
	print("=5=")
	print(response.text)

def sendDriverEmailNotfications(title,body,notificationType):
	import requests
	url=str(settings.DRIVER_ACCESS_URL)+'driver/auth/driverNotify/'
	payload={'body':str(body),
	'title':str(title),
	'notificationType':str(notificationType)}
	response = requests.request("POST", url ,data=payload)
	print(response.text)

def sendStoreEmailNotfications(title,body,notificationType):
	import requests
	url=str(settings.STORE_ACCESS_URL)+'store/auth/storeNotify/'
	payload={'body':str(body),
	'title':str(title),
	'notificationType':str(notificationType)}
	response = requests.request("POST", url ,data=payload)
	print(response.text)

class sendNotification(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			if not data.get('userType'):
				response['status_code']=400
				response['status_message']='User type required'
				return Response(response)
			if not data.get('notificationType'):
				response['status_code']=400
				response['status_message']='Notification type required'
				return Response(response)
			if not data.get('title'):
				response['status_code']=400
				response['status_message']='Title required'
				return Response(response)
			if not data.get('message'):
				response['status_code']=400
				response['status_message']='Message required'
				return Response(response)
			adminObjects=company.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Unauthenticated'
				return Response(response)

			if data.get('notificationType')=='email':
				print("Yes we are sending email")
				if data.get('userType')=='Driver':
					print("To Driver")
					sendDriverEmailNotfications(data.get('title'),data.get('message'),'email')
				elif data.get('userType')=='Store':
					print("To Strore")
					sendStoreEmailNotfications(data.get('title'),data.get('message'),'email')
				else:
					print("To Pass")
					pass
				response['status_code']=200
				response['status_message']='Success'
				return Response(response)
			elif data.get('notificationType')=='push':
				print("Yes we are sending push")
				if data.get('userType')=='Driver':
					print("To Driver")
					sendDriverPushNotfications(data.get('title'),data.get('message'),'push')
				elif data.get('userType')=='Store':
					print("To Strore")
					sendStorePushNotfications(data.get('title'),data.get('message'),'push')
				else:
					print("To Pass")
					pass
				response['status_code']=200
				response['status_message']='Success'
				return Response(response)
			else:
				print("To Pass Outter")
				pass
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getEarningList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData=[]
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			
			compObjects=company.objects.filter(token=session_token).first()
			if not compObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			earningData=[]
			theCompanyWalletObject=companywallet.objects.filter(companyID=compObjects.userUniqueID).first()
			theEarningListObject=companyearning.objects.filter(companyID=compObjects.userUniqueID)
			for earning in theEarningListObject:
				earningData.append({'storeID':earning.storeID,'amount':earning.amount,'title':earning.title,'description':earning.description})
			totalDriversEarning=float(0)
			try:
				url = str(settings.DRIVER_ACCESS_URL_BASE)+'driver/earnings/getDriverEarningDataForCompany/'
				print(url)
				payload={'AccessKey': str(settings.DRIVER_ACCESS_KEY),
						 'companyId': str(compObjects.userUniqueID)}
				apiResponse = requests.request("POST", url,data=payload)
				r=apiResponse.json()
				print("RESPONSE",r)
				totalDriversEarning=r['allDriverEarnings']
			except Exception as e:
				print(e)
			response['accountLinked']=False
			response['debitCardAdded']=False
			response['cardData']={}
			try:
				payload={}
				payload['AccessKey']=str(settings.ADMIN_ACCESS_KEY)
				payload['userId']=compObjects.userUniqueID
				payload['userEmail']=compObjects.email
				
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/auth/checkButtonStatus/"
				res = requests.request("POST",url,data=payload)
				res=res.json()
				if res['status_code']!=200:
					return Response(res)
				response['cardData']=res['cardData']
				response['accountLinked']=res['accountLinked']
				response['debitCardAdded']=res['debitCardAdded']
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)

			myTotalEarning=float(0)
			totalStoresEarning=float(0)
			allStoreWallet=storewallet.objects.filter(companyID=compObjects.userUniqueID)
			if allStoreWallet:
				for store in allStoreWallet:
					totalStoresEarning=float(totalStoresEarning)+(store.balance)
			myTotalEarning=float(totalStoresEarning)+float(totalDriversEarning)

			myTotalEarning=float(myTotalEarning)
			myTotalEarning="{:.2f}".format(myTotalEarning)
			totalDriversEarning=float(totalDriversEarning)
			totalDriversEarning="{:.2f}".format(totalDriversEarning)
			totalStoresEarning=float(totalStoresEarning)
			totalStoresEarning="{:.2f}".format(totalStoresEarning)
			walletBalance=float(theCompanyWalletObject.balance)
			walletBalance="{:.2f}".format(walletBalance)

			response['myTotalEarning']=myTotalEarning
			response['totalDriversEarning']=totalDriversEarning
			response['totalStoresEarning']=totalStoresEarning
			response['walletBalance']=walletBalance
			response['earningList']=earningData
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def sendPush(device_id, body):
	region = [r for r in boto.sns.regions() if r.name==u'us-east-1'][0]
	sns = boto.sns.SNSConnection(
		aws_access_key_id=str(settings.AWS_ACCESS_KEY_ID),
		aws_secret_access_key=str(settings.AWS_SECRET_ACCESS_KEY),
		region=region,
	)
	try:
		endpoint_response = sns.create_platform_endpoint(
			platform_application_arn='arn:aws:sns:us-east-1:432363816440:app/GCM/Cannabis',
			token=device_id,
		)   
		endpoint_arn = endpoint_response['CreatePlatformEndpointResponse']['CreatePlatformEndpointResult']['EndpointArn']
	except boto.exception.BotoServerError as err:
		result_re = re.compile(r'Endpoint(.*)already', re.IGNORECASE)
		result = result_re.search(err.message)
		if result:
			endpoint_arn = result.group(0).replace('Endpoint ','').replace(' already','')
		else:
			raise
	print("ARN:", endpoint_arn)
	publish_result = sns.publish(
		target_arn=endpoint_arn,
		message=json.dumps(body),
		# message_structure='json'
	)
	print("PUBLISH")
	pprint.pprint(publish_result)

def sendCommonGmail(theList,themessage):
	for email in theList:
		try:
			fromEmail = settings.EMAIL_HOST_USER
			message = EmailMessage(themessage['title'], themessage['body'], fromEmail, [email])
			message.content_subtype = 'html'
			message.send()
		except Exception as e:
			print(e)

class compNotify(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('companyID'):
				response['status_code']=400
				response['status_message']='companyID required.'
				return Response(response)
			
			if not data.get('notifyCheckType'):
				response['status_code']=400
				response['status_message']='notifyCheckType required.'
				return Response(response)
			
			companyObject = company.objects.filter(userUniqueID=data.get('companyID')).first()

			if not data.get('body'):
				body=''
			else:
				body=data.get('body')
			
			if not data.get('image'):
				image='https://cannabisadmin.s3.amazonaws.com/logo-d+(1).png'
			else:
				image=data.get('image')
			
			if not data.get('notifyType'):
				notifyType=''
			else:
				notifyType=data.get('notifyType')
			
			if not data.get('title'):
				title=''
			else:
				title=data.get('title')

			
			if not data.get('userType'):
				userType=''
			else:
				userType=data.get('userType')
				
			
			if not data.get('userID'):
				userID=''
			else:
				userID=data.get('userID')
			
			messageBody={}
			messageBody['body']=body
			messageBody['icon']=image
			messageBody['image']=image
			messageBody['type']=notifyType
			messageBody['title']=title
			messageBody['userType']=userType
			messageBody['userID']=userID
			
			try:
				notifications.objects.create(companyID=data.get('companyID'),userType=messageBody['userType'],notificationType=data.get('notifyCheckType'),userID=messageBody['userID'],title=messageBody['title'],description=messageBody['body'])
				# notifications.objects.create(userType=messageBody['userType'],userID=messageBody['userID'],image=messageBody['data']['image'],title=messageBody['title'],description=messageBody['body'])
				theReturnOfPush=sendPush(companyObject.fcmtoken,messageBody)				
			except Exception as e:
				print(e)
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

#old one working properly
# class getNotifications(APIView):
# 	def post(self, request, *args, **kwargs):
# 		response={}
# 		try:
# 			allData=[]
# 			data=request.data
# 			session_token = request.META.get('HTTP_AUTHORIZATION')
# 			if not session_token:
# 				if not data.get('session_token'):
# 					response['status_code']=400
# 					response['status_message']='Session token required'
# 					return Response(response)
# 				session_token=data.get('session_token')
# 			else:
# 				session_token = session_token.replace("Token ", "")
			
# 			compObjects=company.objects.filter(token=session_token).first()
# 			if not compObjects:
# 				response['status_code']=400
# 				response['status_message']='Invalid token'
# 				return Response(response)

# 			allNotifications=companynotifications.objects.filter(companyID=compObjects.userUniqueID)
# 			for n in allNotifications:
# 				allData.append({'userType':n.userType,
# 								'notificationType':n.notificationType,
# 								'userID':n.userID,
# 								'title':n.title,
# 								'description':n.description,})
# 			response['data']=allData
# 			response['status_code']=200
# 			response['status_message']='Success'
# 			return Response(response)
# 		except Exception as e:
# 			response['status_code']=500
# 			response['status_message']=str(e)
# 		return Response(response)

#new one created by john
class getNotifications(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData=[]
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			compObjects=company.objects.filter(token=session_token).first()
			if not compObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)

			allNotifications=companynotifications.objects.filter(companyID=compObjects.userUniqueID)
			for n in allNotifications:
				allData.append({'userType':n.userType,
								'id':n.id,
								'notificationType':n.notificationType,
								'userID':n.userID,
								'title':n.title,
								'description':n.description,
								'date': n.created_at, 
								})
			response['data']=allData
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


#Old one delete notification proper working
# class deleteNotification(APIView):
# 	def post(self, request, *args, **kwargs):
# 		response={}
# 		try:
# 			data=request.data
# 			session_token = request.META.get('HTTP_AUTHORIZATION')
# 			if not session_token:
# 				if not data.get('session_token'):
# 					response['status_code']=400
# 					response['status_message']='Session token required'
# 					return Response(response)
# 				session_token=data.get('session_token')
# 			else:
# 				session_token = session_token.replace("Token ", "")
			
# 			compObjects=company.objects.filter(token=session_token).first()
# 			if not compObjects:
# 				response['status_code']=400
# 				response['status_message']='Invalid token'
# 				return Response(response)

# 			if not data.get('id'):
# 				response['status_code']=400
# 				response['status_message']='Notification id required'
# 				return Response(response)
# 			theNotificationObject=companynotifications.objects.filter(id=data.get('id')).first()
# 			if theNotificationObject:
# 				theNotificationObject.delete()
# 			else:
# 				response['status_code']=400
# 				response['status_message']='Invalid notification id'
# 				return Response(response)
# 			response['status_code']=200
# 			response['status_message']='Success'
# 			return Response(response)
# 		except Exception as e:
# 			response['status_code']=500
# 			response['status_message']=str(e)
# 		return Response(response)


#New one created by johan 
class deleteNotification(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			
			compObjects=company.objects.filter(token=session_token).first()
			if not compObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			print('ejhfoiuehfiuhicheducefh')

			if not data.get('id'):
				response['status_code']=400
				response['status_message']='Notification id required'
				return Response(response)
			print('ejhfoiuehfiuhicheducefh')
			theNotificationObject=companynotifications.objects.filter(id=data.get('id')).first()
			print('theNotificationObject',theNotificationObject)
			if theNotificationObject:
				theNotificationObject.delete()
			else:
				response['status_code']=400
				response['status_message']='Invalid notification id'
				return Response(response)
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class getDashboardData(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData=[]
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			
			compObjects=company.objects.filter(token=session_token).first()
			if not compObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)

			totalEarning=float(0)
			theCompanyWalletObject=companywallet.objects.filter(companyID=compObjects.userUniqueID).first()
			if theCompanyWalletObject:
				totalEarning=float(theCompanyWalletObject.totalearning)
				totalEarning="{:.2f}".format(totalEarning)
			
			totalDrivers=0
			try:
				url = str(settings.DRIVER_ACCESS_URL)+'totalDriversForCompany/'
				print(url)
				payload={'AccessKey': str(settings.DRIVER_ACCESS_KEY),
						 'companyId': str(compObjects.userUniqueID)}
				apiResponse = requests.request("POST", url,data=payload)
				r=apiResponse.json()
				print("RESPONSE",r)
				totalDrivers=r['count']
			except Exception as e:
				print(e)
			
			totalStores=0
			try:
				url = str(settings.STORE_ACCESS_URL_BASE)+'store/get/getTotalStoreCountForCompany/'
				payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
						 'companyId': str(compObjects.userUniqueID)}
				apiResponse = requests.request("POST", url,data=payload)
				r=apiResponse.json()
				totalStores=r['count']
			except Exception as e:
				print(e)
			
			totalOrders=0
			recentOrders=[]
			ordersSeries=[]
			try:
				url = str(settings.CUSTOMER_ACCESS_URL)+'customer/order/getTotalOrdersCount/'
				# print(url)
				payload={'AccessKey': str(settings.CUSTOMER_ACCESS_KEY),
						 'companyId': str(compObjects.userUniqueID)}
				apiResponse = requests.request("POST", url,data=payload)
				r=apiResponse.json()
				ordersSeries=r['ordersSeries']
				totalOrders=r['count']
				recentOrders=r['recentOrders']
			except Exception as e:
				print(e)
			
			earningSeries=[]
			try:
				import datetime as ddd
				import dateutil.relativedelta
				for count in range(0,6):
					d = ddd.datetime.now()
					print(d.month,d.year)
					d2 = d - dateutil.relativedelta.relativedelta(months=count)
					print(d2.month,d2.year)
					theDateValue=d2.strftime("%b, %Y")
					allEarnings=companyearning.objects.filter(Q(companyID=compObjects.userUniqueID) & Q(created_at__month=d2.month) & Q(created_at__year=d2.year))
					tempEarning=float(0)
					for earning in allEarnings:
						tempEarning=float(tempEarning)+float(earning.amount)
					tempEarning="{:.2f}".format(tempEarning)
					earningSeries.append({'value':tempEarning,
										'name':theDateValue,})
			except Exception as e:
				print(e)
			response['ordersSeries']=ordersSeries
			response['earningSeries']=earningSeries

			response['recentOrders']=recentOrders
			response['totalEarning']=totalEarning
			response['totalDrivers']=totalDrivers
			response['totalStores']=totalStores
			response['totalOrders']=totalOrders

			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getDriversCompletedOrdersList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			compObjects=company.objects.filter(token=session_token).first()
			if not compObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='driverID is required'
				return Response(response)
			try:
				url = str(settings.DRIVER_ACCESS_URL_BASE)+'driver/earnings/getEarningListOfADriverForAdmin/'
				payload={'AccessKey': str(settings.DRIVER_ACCESS_KEY),
						 'driverID': str(data.get('driverID'))}
				apiResponse = requests.request("POST", url,data=payload)
				r=apiResponse.json()
				return Response(r)
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class requestPayout(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			compObjects=company.objects.filter(token=session_token).first()
			if not compObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			
			if not compObjects:
				response['status_code']=400
				response['status_message']='Company Not Exist'
				return Response(response)

			if not data.get('requestedAmount'):
				response['status_code']=400
				response['status_message']='requestedAmount required'
				return Response(response)
			
			walletObject=companywallet.objects.filter(companyID=compObjects.userUniqueID).first()
			if not walletObject:
				response['status_code']=400
				response['status_message']='You have no amount in wallet'
				return Response(response)
			if float(data.get('requestedAmount'))>=float(walletObject.balance):
				response['status_code']=400
				response['status_message']='Not enough amount in wallet'
				return Response(response)
			try:
				payload={}
				payload['AccessKey']=str(settings.ADMIN_ACCESS_KEY)
				payload['payoutUserType']="Company"
				payload['payoutUserId']=compObjects.userUniqueID
				payload['payoutUserName']=compObjects.name
				payload['payoutUserEmail']=compObjects.email
				payload['payoutUserImage']=compObjects.image.name
				payload['payoutAmount']=data.get('requestedAmount')
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/auth/addPayoutRequests/"
				res = requests.request("POST",url,data=payload)
				res=res.json()
				if res['status_code']!=200:
					return Response(res)
				theBal=float(walletObject.balance)
				theBal=float(theBal)-float(data.get('requestedAmount'))
				walletObject.balance=float(theBal)
				walletObject.save()
				response['url']=res['url']
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			# thePayout=payout.objects.create(driverID=driverObj.userUniqueID)
			# thePayout.requestedAmount=float(data.get('requestedAmount'))
			# thePayout.availablebalance=float(walletObject.availablebalance)
			# thePayout.save()
			
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getStripeLoginLink(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			compObjects=company.objects.filter(token=session_token).first()
			if not compObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			
			if not compObjects:
				response['status_code']=400
				response['status_message']='Company Not Exist'
				return Response(response)
			try:
				payload={}
				payload['AccessKey']=str(settings.ADMIN_ACCESS_KEY)
				payload['payoutUserId']=compObjects.userUniqueID
				
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/auth/getStripeLoginLinkInCompany/"
				res = requests.request("POST",url,data=payload)
				res=res.json()
				if res['status_code']!=200:
					return Response(res)
				response['loginUrl']=res['loginUrl']
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class linkAccount(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			compObjects=company.objects.filter(token=session_token).first()
			if not compObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			
			if not compObjects:
				response['status_code']=400
				response['status_message']='Company Not Exist'
				return Response(response)
			try:
				payload={}
				payload['AccessKey']=str(settings.ADMIN_ACCESS_KEY)
				payload['payoutUserId']=compObjects.userUniqueID
				payload['payoutUserEmail']=compObjects.email
				
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/auth/linkPayoutAccount/"
				res = requests.request("POST",url,data=payload)
				res=res.json()
				if res['status_code']!=200:
					return Response(res)
				response['url']=res['url']
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class addDebitCard(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			compObjects=company.objects.filter(token=session_token).first()
			if not compObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			if not compObjects:
				response['status_code']=400
				response['status_message']='Company Not Exist'
				return Response(response)
			
			if not data.get('cardToken'):
				response['status_code']=400
				response['status_message']='cardToken is required'
				return Response(response)
			try:
				payload={}
				payload['AccessKey']=str(settings.ADMIN_ACCESS_KEY)
				payload['payoutUserId']=compObjects.userUniqueID
				payload['cardToken']=data.get('cardToken')
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/auth/addDebitCart/"
				res = requests.request("POST",url,data=payload)
				res=res.json()
				if res['status_code']!=200:
					return Response(res)
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class deleteDebitCard(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			compObjects=company.objects.filter(token=session_token).first()
			if not compObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			if not compObjects:
				response['status_code']=400
				response['status_message']='Company Not Exist'
				return Response(response)
			
			if not data.get('cardId'):
				response['status_code']=400
				response['status_message']='cardId is required'
				return Response(response)
			try:
				payload={}
				payload['AccessKey']=str(settings.ADMIN_ACCESS_KEY)
				payload['payoutUserId']=compObjects.userUniqueID
				payload['cardId']=data.get('cardId')
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/auth/deleteDebitCart/"
				res = requests.request("POST",url,data=payload)
				res=res.json()
				if res['status_code']!=200:
					return Response(res)
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


#old one working properly
# class deleteNotificationList(APIView):
# 	def post(self, request, *args, **kwargs):
# 		response={}
# 		try:
# 			data=request.data
# 			session_token = request.META.get('HTTP_AUTHORIZATION')
# 			if not session_token:
# 				if not data.get('session_token'):
# 					response['status_code']=400
# 					response['status_message']='Session token required'
# 					return Response(response)
# 				session_token=data.get('session_token')
# 			else:
# 				session_token = session_token.replace("Token ", "")
			
# 			compObjects=company.objects.filter(token=session_token).first()
# 			if not compObjects:
# 				response['status_code']=400
# 				response['status_message']='Invalid token'
# 				return Response(response)
			
# 			if not data.getlist('idlist'):
# 				response['status_code']=400
# 				response['status_message']='Notification id list is required'
# 				return Response(response)
# 			theidLists=data.getlist('idlist')
# 			for l in theidLists:
# 				theNotificationObject=companynotifications.objects.filter(id=l).first()
# 				if theNotificationObject:
# 					theNotificationObject.delete()
					
# 			response['status_code']=200
# 			response['status_message']='Success'
# 			return Response(response)
# 		except Exception as e:
# 			response['status_code']=500
# 			response['status_message']=str(e)
# 		return Response(response)


#This is new created by johan
class deleteNotificationList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			print('data',data)
			session_token = request.META.get('HTTP_AUTHORIZATION')
			print('session_token',session_token)
			
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			
			compObjects=company.objects.filter(token=session_token).first()
			print('compObjects',compObjects)

			if not compObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			
			if not data.get('idlist'):
				print('theidLists',theidLists)
				response['status_code']=400
				response['status_message']='Notification id list is required'
				return Response(response)
			theidLists=data.get('idlist')
			for l in theidLists:
				theNotificationObject=companynotifications.objects.filter(id=l).first()
				if theNotificationObject:
					theNotificationObject.delete()
					
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


#its for filter  date notification
class filterNotifications(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		data = request.data
		print('data====',data)
		try:
			allData=[]
			session_token = request.META.get('HTTP_AUTHORIZATION')
			start_date = data.get('start_date',None)
			end_date = data.get('end_date', None)
			if start_date is not None and start_date != '':
				pass
			else:	
				response['status_code'] = 400
				response['status_message'] = 'start date required'
				return Response(response)
			
			if end_date is None or end_date == '':
				from datetime import timedelta
				end_date = datetime.date.today() + timedelta(days=1)
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			print('#####3')
			compObjects=company.objects.filter(token=session_token).first()
			print(compObjects)
			print(start_date)
			print(end_date)
			if not compObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			
			allNotifications = companynotifications.objects.filter(companyID=compObjects.userUniqueID, created_at__range=(start_date, end_date))
			# allNotifications = companynotifications.objects.filter(companyID=compObjects.userUniqueID, created_at__range=[start_date, end_date])
			# allNotifications = companynotifications.objects.filter(companyID=compObjects.userUniqueID, created_at__range= [start_date, end_date])
			print(allNotifications)					
			# allNotifications=companynotifications.objects.filter(created_at__gte=start_date, created_at__lte = end_date)
			for n in allNotifications:
				allData.append({'userType':n.userType,
								'notificationType':n.notificationType,
								'userID':n.userID,
								'id':n.id,
								'title':n.title,
								'description':n.description,
								'date':n.created_at,
								})
			response['data']=allData
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


