from rest_framework import serializers
from base.models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from django.conf import settings

class GetCompaniesListForStore(serializers.ModelSerializer):
	class Meta:
		model = company
		fields = ['userUniqueID','name']

class GetCompanyData(serializers.ModelSerializer):
	image = serializers.SerializerMethodField(source='get_image')
	# openingTime = serializers.SerializerMethodField(source='get_openingTime')
	# closingTime = serializers.SerializerMethodField(source='get_closingTime')

	class Meta:
		model = company
		fields = ['state','userUniqueID','risk','name', 'email','phone','countrycode','image','isdisabled']

	def get_image(self,obj):
		if obj.image.name:
			theImage=str(obj.image.name)
		else:
			theImage=''
		return theImage

	# def get_openingTime(self,obj):
	# 	time=''
	# 	theCompTiming=CompanyTimings.objects.filter(userUniqueID=obj.userUniqueID).first()
	# 	if theCompTiming:
	# 		time=theCompTiming.openingTime
	# 	return time

	# def get_closingTime(self,obj):
	# 	time=''
	# 	theCompTiming=CompanyTimings.objects.filter(userUniqueID=obj.userUniqueID).first()
	# 	if theCompTiming:
	# 		time=theCompTiming.closingTime
	# 	return time


class GetCompanyDataNew(serializers.ModelSerializer):
	class Meta:
		model = company
		fields = ['state','token','userUniqueID','risk','name', 'email','phone','countrycode','socialId','image','phoneverified','userReferalCode','description','fbURL','instaURL','webURL']

class GetTimingsData(serializers.ModelSerializer):
	class Meta:
		model = companytimings
		fields = ['openingTime', 'closingTime', 'monday','tuesday','wednesday','thursday','friday','saturday','sunday']

class GetOneCompanyData(serializers.ModelSerializer):
	# timings = serializers.SerializerMethodField(source='get_timings')
	documents = serializers.SerializerMethodField(source='get_documents')
	image = serializers.SerializerMethodField(source='get_image')
	
	class Meta:
		model = company
		fields = ['state','documents','userUniqueID','risk','name', 'email','phone','countrycode','image','isdisabled','description','address','latitude','longitude','fbURL','instaURL','webURL']

	# def get_timings(self,obj):
	# 	allData={}
	# 	theCompTiming=CompanyTimings.objects.filter(userUniqueID=obj.userUniqueID).first()
	# 	if theCompTiming:
	# 		theData=GetTimingsData(theCompTiming)
	# 		return theData.data
	# 	return allData

	def get_image(self,obj):
		if obj.image.name != '':
			theImage=str(obj.image)
		else:
			theImage=''
		return theImage

	def get_documents(self,obj):
		allData=[]
		theCompDocs=companydocuments.objects.filter(userUniqueID=obj.userUniqueID)
		for doc in theCompDocs:
			doctType=''
			if doc.doctType == '1':
				doctType='Passport'
			elif doc.doctType == '2':
				doctType='Licence'
			elif doc.doctType == '3':
				doctType='National ID'
			elif doc.doctType == '4':
				doctType='Registration ID'
			elif doc.doctType == '5':
				doctType='Other'
			else:
				doctType='Other'
			theImage=str(doc.document.name)
			allData.append({'id':doc.id,
				            'theDocType':doctType,
				            'document':theImage,
				            'status':doc.theStatus,})
		return allData

class GetOneCompanyDataNew(serializers.ModelSerializer):
	# timings = serializers.SerializerMethodField(source='get_timings')
	
	class Meta:
		model = company
		fields = ['state','token','userUniqueID','risk','name', 'email','phone','countrycode','socialId','image','phoneverified','userReferalCode','description','fbURL','instaURL','webURL']

	# def get_timings(self,obj):
	# 	allData={}
	# 	theCompTiming=CompanyTimings.objects.filter(userUniqueID=obj.userUniqueID).first()
	# 	if theCompTiming:
	# 		theData=GetTimingsData(theCompTiming)
	# 		return theData.data
	# 	return allData