from django.shortcuts import render
from rest_framework.views import APIView
from django.http import JsonResponse
from django.views.decorators.csrf import csrf_exempt
from base.models import *
from django.conf import settings
from django.db.models import Avg
from django.db.models import Q
from .serializers import *
from subscriptions.models import *
from django.http import HttpResponse
from rest_framework.response import Response
import environ
from django.core.files.storage import FileSystemStorage
import math, random, datetime, pytz, string
from django.template.loader import render_to_string
from django.core.mail import EmailMessage
from django.core import mail
import requests


import boto
import boto.exception
import boto.sns
import pprint
import re

class adminLoginToken(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			theAdmin=adminaccess.objects.all().first()
			if theAdmin:
				theAdmin.token=data.get('AccessKey')
				theAdmin.save()
			else:
				adminaccess.objects.create(token=data.get('AccessKey'))
			# import os
			# import dotenv

			
			
			# dotenv_file = dotenv.find_dotenv()
			# dotenv.load_dotenv(dotenv_file)
			
			# ACCESS_TOKEN=os.environ.get('ACCESS_TOKEN')
			# os.environ['ACCESS_TOKEN'] = data.get('AccessKey')

			# dotenv.set_key(dotenv_file, "ACCESS_TOKEN", os.environ["ACCESS_TOKEN"])
			response['status_code']=200
			response['status_message']='Done'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class adminLogoutToken(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			theAdmin=adminaccess.objects.all().first()
			if theAdmin:
				theAdmin.token=''
				theAdmin.save()
			# import os
			# import dotenv
			
			# dotenv_file = dotenv.find_dotenv()
			# dotenv.load_dotenv(dotenv_file)
			
			# ACCESS_TOKEN=os.environ.get('ACCESS_TOKEN')
			# os.environ['ACCESS_TOKEN'] = 'A4D5M8I6N3L3O5G2O0U8T'

			# dotenv.set_key(dotenv_file, "ACCESS_TOKEN", os.environ["ACCESS_TOKEN"])
			# response['status_code']=200
			# response['status_message']='Done'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getComapniesListForBackend(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			# env = environ.Env()
			# environ.Env.read_env()
			# theKey = env("ACCESS_TOKEN")
			# if data.get('AccessKey') != theKey:
			# 	response['status_code']=403
			# 	response['status_message']='You dont have access to this api.'
			# 	return Response(response)

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			theAdmin=adminaccess.objects.filter(token=AccessKey).first()
			if not theAdmin:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			
			if not data.get('search'):
				theSearch=''
			else:
				theSearch=data.get('search')
			if not data.get('filterType'):
				filterType='All'
			else:
				filterType=data.get('filterType')
				if filterType=='Enable':
					filterValue=False
				else:
					filterValue=True

			if filterType=='All':
				if theSearch=='':
					allComps=company.objects.all().order_by('-id')
				else:
					allComps=company.objects.filter(name__icontains=theSearch).order_by('-id')
			else:
				if theSearch=='':
					allComps=company.objects.filter(isdisabled=filterValue).order_by('-id')
				else:
					allComps=company.objects.filter(name__icontains=theSearch,isdisabled=filterValue).order_by('-id')

			# allComps=Company.objects.all().order_by('-id')
			if not allComps:
				response['status_code']=400
				response['status_message']='No Data Found'
				return Response(response)
			else:
				theData=GetCompanyData(allComps, many=True)
				response['status_code']=200
				response['status_message']='Data found'
				response['data']=theData.data
		except Exception as e:
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getCompanyData(APIView):
	def post(self, request,*args,**kwargs):
		response={}
		try:
			
			data=request.data
			# env = environ.Env()
			# environ.Env.read_env()
			# theKey = env("ACCESS_TOKEN")
			# if data.get('AccessKey') != theKey:
			# 	response['status_code']=403
			# 	response['status_message']='You dont have access to this api.'
			# 	return Response(response)

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			theAdmin=adminaccess.objects.filter(token=AccessKey).first()
			if not theAdmin:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theCompObj=company.objects.filter(userUniqueID=data.get('companyID')).first()
			if not theCompObj:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			theData=GetOneCompanyData(theCompObj)
			response['status_code']=200
			response['status_message']='Data found'
			response['data']=theData.data
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class changeStatusOfCompany(APIView):
	def post(self,request,*args,**kwargs):
		response={}
		try:
			data=request.data
			# env=environ.Env()
			# environ.Env.read_env()
			# theKey=env('ACCESS_TOKEN')
			# if theKey != data.get('AccessKey'):
			# 	response['status_code']=401
			# 	response['status_message']='You dont have access to this api'

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")


			theAdmin=adminaccess.objects.filter(token=AccessKey).first()
			if not theAdmin:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theCompObj=company.objects.filter(userUniqueID=data.get('companyID')).first()
			if theCompObj:
				if data.get('theStatus') == True:
					theCompObj.isdisabled=False
				else:
					theCompObj.isdisabled=True
				theCompObj.save()
				response['status_code']=200
				response['status_message']='Status updated'
			else:
				response['status_code']=400
				response['status_message']='Not a valid country ID'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def randomStringFunctionForImage():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(10)))
	str1 += ''.join((random.choice(string.digits) for x in range(6)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

# def uploadDocumentImages(image,thePath):
# 	import os
# 	fullPath='media/'+str(thePath)+'/'
# 	fs = FileSystemStorage(location=fullPath)
# 	beforename = os.path.splitext(image.name)[0]
# 	beforename=beforename.replace(' ','')
# 	filetype = os.path.splitext(image.name)[1]
# 	theName=randomStringFunctionForImage()
# 	theImageName=str(theName)+str(filetype)
# 	filename = fs.save(theImageName, image)
# 	return str(fullPath)+'/'+filename

def uploadDocumentImages(image,thePath):
	import os
	import boto3
	from botocore.exceptions import NoCredentialsError
	try:
		bucket=str(settings.AWS_BUCKET_NAME)
		thePath=thePath.lower()
		ACCESS_KEY=str(settings.AWS_ACCESS_KEY_ID)
		SECRET_KEY=str(settings.AWS_SECRET_ACCESS_KEY)
		s3 = boto3.client('s3', aws_access_key_id=ACCESS_KEY,
					  aws_secret_access_key=SECRET_KEY)
		try:
			filetype = os.path.splitext(image.name)[1]
			imageName=randomStringFunctionForImage()
			thePath=thePath+'/'+imageName+'.'+filetype
			thePath=str(thePath)
			theFile=s3.upload_fileobj(image,bucket,thePath)
			print("Upload Successful")
			filename=str(settings.AWS_BUCKET_URL_1)+str(bucket)+str(settings.AWS_BUCKET_URL_2)+thePath
			return filename
		except FileNotFoundError as e:
			print("The file was not found")
			return ''
		except NoCredentialsError:
			print("Credentials not available")
			return ''
	except Exception as e:
		print(e)
		return ''

def findTimeObject(pickupTime):
	from datetime import time
	pickupTimeHour=pickupTime.split(':')[0]
	pickupTimeMinutes=pickupTime.split(':')[1]
	pickupTimeHour=int(pickupTimeHour)
	pickupTimeMinutes=int(pickupTimeMinutes)
	pickupTimeObject = time(hour = pickupTimeHour, minute = pickupTimeMinutes, second = 00)
	return pickupTimeObject

class updateCompany(APIView):
	def post(self, request,*args,**kwargs):
		try:
			response={}
			data=request.data
			# env = environ.Env()
			# environ.Env.read_env()
			# theKey = env("ACCESS_TOKEN")
			# if data.get('AccessKey') != theKey:
			# 	response['status_code']=403
			# 	response['status_message']='You dont have access to this api.'
			# 	return Response(response)

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")


			theAdmin=adminaccess.objects.filter(token=AccessKey).first()
			if not theAdmin:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theCompObj=company.objects.filter(userUniqueID=data.get('companyID')).first()
			if not theCompObj:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			theImage=request.FILES.get('image')

			if theImage:
				filename=uploadDocumentImages(theImage,'Profile')
				theCompObj.image=filename
			if data.get('name'):
				theCompObj.name=data.get('name')
			if data.get('phone'):
				theCompObj.phone=data.get('phone')
			if data.get('countrycode'):
				theCompObj.countrycode=data.get('countrycode')
			if data.get('fbURL'):
				theCompObj.fbURL=data.get('fbURL')
			if data.get('instaURL'):
				theCompObj.instaURL=data.get('instaURL')
			if data.get('webURL'):
				theCompObj.webURL=data.get('webURL')
			if data.get('state'):
				theCompObj.state=data.get('state')
			if data.get('description'):
				theCompObj.description=data.get('description')
			if data.get('address'):
				theCompObj.address=data.get('address')
			if data.get('latitude'):
				theCompObj.latitude=data.get('latitude')
			if data.get('longitude'):
				theCompObj.longitude=data.get('longitude')
			
			# openingTime=findTimeObject(data.get('openingTime'))
			# closingTime=findTimeObject(data.get('closingTime'))
			# theCompTiming=CompanyTimings.objects.filter(userUniqueID=data.get('companyID')).first()
			# if theCompTiming:
			# 	theCompTiming.openingTime=openingTime
			# 	theCompTiming.closingTime=closingTime
			# 	if data.get('monday'):
			# 		if data.get('monday')=='true':
			# 			theCompTiming.monday=True
			# 		else:
			# 			theCompTiming.monday=False
			# 	if data.get('tuesday'):
			# 		if data.get('tuesday')=='true':
			# 			theCompTiming.tuesday=True
			# 		else:
			# 			theCompTiming.tuesday=False
			# 	if data.get('wednesday'):
			# 		if data.get('wednesday')=='true':
			# 			theCompTiming.wednesday=True
			# 		else:
			# 			theCompTiming.wednesday=False

			# 	if data.get('thursday'):
			# 		if data.get('thursday')=='true':
			# 			theCompTiming.thursday=True
			# 		else:
			# 			theCompTiming.thursday=False
			# 	if data.get('friday'):
			# 		if data.get('friday')=='true':
			# 			theCompTiming.friday=True
			# 		else:
			# 			theCompTiming.friday=False
			# 	if data.get('saturday'):
			# 		if data.get('saturday')=='true':
			# 			theCompTiming.saturday=True
			# 		else:
			# 			theCompTiming.saturday=False

			# 	if data.get('sunday'):
			# 		if data.get('sunday')=='true':
			# 			theCompTiming.sunday=True
			# 		else:
			# 			theCompTiming.sunday=False
			# 	theCompTiming.save()
			theCompObj.save()
			response['status_code']=200
			response['status_message']='Data updated'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def randomStringFunction():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(8)))
	str1 += ''.join((random.choice(string.digits) for x in range(4)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

def referralCode():
	try:
		Referal=''
		digits2 = "rba2cqq4skyhz7meizjk"
		for i in range(8): 
		  Referal += digits2[math.floor(random.random() * 15)]
	except Exception as e:
		print(e)
	return str(Referal)

def GernateOTP():
	digits = "0123456789"
	OTP = ""
	for i in range(4) :
		OTP += digits[math.floor(random.random() * 10)]
	return OTP

def createIDwithName(str1,):
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(10)))
	str1 += ''.join((random.choice(string.digits) for x in range(6)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

class addCompany(APIView):
	def post(self, request,*args,**kwargs):
		try:
			print("==start==")
			otp=GernateOTP()
			response={}
			data=request.data
			# env = environ.Env()
			# environ.Env.read_env()
			# theKey = env("ACCESS_TOKEN")
			# if data.get('AccessKey') != theKey:
			# 	response['status_code']=403
			# 	response['status_message']='You dont have access to this api.'
			# 	return Response(response)

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")
			
			print("==1==")
			theAdmin=adminaccess.objects.filter(token=AccessKey).first()
			if not theAdmin:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			userOBJ = User.objects.filter(username = data.get('email')).first()
			if userOBJ:
				response['status_code']=400
				response['status_message']='Email already exist'
				return Response(response)
			phnExist=company.objects.filter(phone=data.get('phone'))
			if phnExist:
				response['status_code']=400
				response['status_message']='Phone number already exist'
				return Response(response)
			print("==2==")
			gernatedPassword=randomStringFunction()
			userOBJ = User.objects.create_user(username = data.get('email'), password = gernatedPassword)
			userObjId=userOBJ.id
			beforeNameOfCompany=data.get('name')
			name3Letter=beforeNameOfCompany[0:3]
			name3Letter=name3Letter.upper()
			latExt=company.objects.all().last()
			if latExt:
				lastId=latExt.userUniqueID
				last5Number=lastId[3:]
				last5Number=int(last5Number)
				new5Number=last5Number+1
				new5Number=str(new5Number)
				new5Number = new5Number.zfill(5)
				theUniqueID=str(name3Letter)+str(new5Number)
			else:
				theUniqueID=str(name3Letter)+str('00001')
			# theUniqueID=randomStringFunction()
			print("==3==")
			theCompObj = company.objects.create(state=data.get('state'),userUniqueID=theUniqueID,userTableID=userObjId, name = data.get('name'),email = data.get('email'),registerType='Normal',phone=data.get('phone'), signupOtp = otp,userReferalCode=referralCode(),signupOtpVerfied=True,emailverified=True,phoneverified=True,accountverified=True,accountapproved=True)
			print("==4==")
			passportImage=request.FILES.get('passportImage')
			print(passportImage)
			if passportImage:
				filename=uploadDocumentImages(passportImage,'Documents')
				ownerDocs=companydocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='1',isApproved=True,theStatus='2')
			licenceImage=request.FILES.get('licenceImage')
			print(licenceImage)

			if licenceImage:
				filename=uploadDocumentImages(licenceImage,'Documents')
				ownerDocs=companydocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='2',isApproved=True,theStatus='2')
			nationalID=request.FILES.get('nationalID')
			print(licenceImage)

			if nationalID:
				filename=uploadDocumentImages(nationalID,'Documents')
				ownerDocs=companydocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='3',isApproved=True,theStatus='2')
			registrationProof=request.FILES.get('registrationProof')
			if registrationProof:
				filename=uploadDocumentImages(registrationProof,'Documents')
				ownerDocs=companydocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='4',isApproved=True,theStatus='2')
			print(registrationProof)
			
			theDocuments = request.FILES.getlist("documents")
			if theDocuments:
				for count, image in enumerate(theDocuments):
					filename=uploadDocumentImages(image,'Documents')
					ownerDocs=companydocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,isApproved=True,theStatus='2')
			print("==5==")
			if not theCompObj:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			theImage=request.FILES.get('image')
			if theImage:
				filename=uploadDocumentImages(theImage,'Profile')
				theCompObj.image=filename
			print(theImage)
			if data.get('name'):
				theCompObj.name=data.get('name')
			if data.get('phone'):
				theCompObj.phone=data.get('phone')
			if data.get('countrycode'):
				theCompObj.countrycode=data.get('countrycode')
			if data.get('fbURL'):
				theCompObj.fbURL=data.get('fbURL')
			if data.get('instaURL'):
				theCompObj.instaURL=data.get('instaURL')
			if data.get('webURL'):
				theCompObj.webURL=data.get('webURL')
			if data.get('state'):
				theCompObj.state=data.get('state')

			if data.get('description'):
				theCompObj.description=data.get('description')
			if data.get('address'):
				theCompObj.address=data.get('address')
			if data.get('latitude'):
				theCompObj.latitude=data.get('latitude')
			if data.get('longitude'):
				theCompObj.longitude=data.get('longitude')

			# openingTime=findTimeObject(data.get('openingTime'))
			# closingTime=findTimeObject(data.get('closingTime'))
			
			# theCompTiming=CompanyTimings.objects.filter(userUniqueID=theUniqueID).first()
			# if not theCompTiming:
			# 	theCompTiming=CompanyTimings.objects.create(userTableID=userObjId,userUniqueID=theUniqueID)
			# if theCompTiming:
			# 	theCompTiming.openingTime=openingTime
			# 	theCompTiming.closingTime=closingTime
			# 	if data.get('monday'):
			# 		if data.get('monday')=='true':
			# 			theCompTiming.monday=True
			# 		else:
			# 			theCompTiming.monday=False
			# 	if data.get('tuesday'):
			# 		if data.get('tuesday')=='true':
			# 			theCompTiming.tuesday=True
			# 		else:
			# 			theCompTiming.tuesday=False
			# 	if data.get('wednesday'):
			# 		if data.get('wednesday')=='true':
			# 			theCompTiming.wednesday=True
			# 		else:
			# 			theCompTiming.wednesday=False

			# 	if data.get('thursday'):
			# 		if data.get('thursday')=='true':
			# 			theCompTiming.thursday=True
			# 		else:
			# 			theCompTiming.thursday=False
			# 	if data.get('friday'):
			# 		if data.get('friday')=='true':
			# 			theCompTiming.friday=True
			# 		else:
			# 			theCompTiming.friday=False
			# 	if data.get('saturday'):
			# 		if data.get('saturday')=='true':
			# 			theCompTiming.saturday=True
			# 		else:
			# 			theCompTiming.saturday=False

			# 	if data.get('sunday'):
			# 		if data.get('sunday')=='true':
			# 			theCompTiming.sunday=True
			# 		else:
			# 			theCompTiming.sunday=False
			# 	theCompTiming.save()
			theCompObj.save()
			companywallet.objects.create(companyID=theUniqueID)
			try:
				subject='Welcome'
				message = render_to_string('companyAddedInformMail.html', {
					'email': data.get('email'),
					'name': data.get('name'),
					'password':str(gernatedPassword),
				})
				from_email = settings.EMAIL_HOST_USER
				to_email = data.get('email')
				message = EmailMessage(subject, message, from_email, [to_email])
				message.content_subtype = 'html'
				message.send()
			except Exception as e:
				print(e)
			response['status_code']=200
			response['status_message']='Registered successfully, Please check your email for password'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updateDocuments(APIView):
	def post(self, request, *args, **kwargs):
		try:
			response={}
			data=request.data
			# env = environ.Env()
			# environ.Env.read_env()
			# theKey = env("ACCESS_TOKEN")
			# if data.get('AccessKey') != theKey:
			# 	response['status_code']=403
			# 	response['status_message']='You dont have access to this api.'
			# 	return Response(response)

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")


			theAdmin=adminaccess.objects.filter(token=AccessKey).first()
			if not theAdmin:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theCompObj=company.objects.filter(userUniqueID=data.get('companyID')).first()
			if not theCompObj:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			userObjId=theCompObj.userTableID
			passportImage=request.FILES.get('passportImage')
			if passportImage:
				passportImageID=request.FILES.get('passportImageID')
				if passportImageID == '0':
					filename=uploadDocumentImages(passportImage,'Documents')
					ownerDocs=companydocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,isApproved=True,doctType='1')
				else:
					filename=uploadDocumentImages(passportImage,'Documents')
					ownerDocs=companydocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=passportImageID,doctType='1')
					ownerDocs.document=filename
					ownerDocs.isApproved=True
					ownerDocs.save()
			licenceImage=request.FILES.get('licenceImage')
			if licenceImage:
				licenceImageID=request.FILES.get('licenceImageID')
				if licenceImageID == '0':
					filename=uploadDocumentImages(licenceImage,'Documents')
					ownerDocs=companydocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,isApproved=True,doctType='2')
				else:
					filename=uploadDocumentImages(licenceImage,'Documents')
					ownerDocs=companydocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=licenceImageID,doctType='2')
					ownerDocs.document=filename
					ownerDocs.isApproved=True
					ownerDocs.save()
			nationalID=request.FILES.get('nationalID')
			if nationalID:
				nationalProofID=request.FILES.get('nationalProofID')
				if nationalProofID == '0':
					filename=uploadDocumentImages(nationalID,'Documents')
					ownerDocs=companydocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,isApproved=True,doctType='3')
				else:
					filename=uploadDocumentImages(nationalID,'Documents')
					ownerDocs=companydocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=nationalProofID,doctType='3')
					ownerDocs.document=filename
					ownerDocs.isApproved=True
					ownerDocs.save()
			registrationProof=request.FILES.get('registrationProof')
			if registrationProof:
				registrationProofID=request.FILES.get('registrationProofID')
				if registrationProofID == '0':
					filename=uploadDocumentImages(registrationProof,'Documents')
					ownerDocs=companydocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='4',isApproved=True)
				else:
					filename=uploadDocumentImages(registrationProof,'Documents')
					ownerDocs=companydocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=registrationProofID,doctType='4')
					ownerDocs.document=filename
					ownerDocs.isApproved=True
					ownerDocs.save()
			theIDS = request.POST.getlist("ids")
			theDocuments = request.FILES.getlist("documents")
			for count, image in enumerate(theDocuments):
				if theIDS[count] == '0':
					filename=uploadDocumentImages(image,'Documents')
					ownerDocs=companydocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,isApproved=True,doctType='5')
				else:
					alreadyDoc=companydocuments.objects.filter(userUniqueID=theUniqueID,id=theIDS[count]).first()
					if alreadyDoc:
						filename=uploadDocumentImages(image,'Documents')
						alreadyDoc.document=filename
						alreadyDoc.isApproved=True
						alreadyDoc.save()
			response['status_code']=200
			response['status_message']='Documents Updated Successfully'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class deleteDocuments(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			
			data=request.data
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			theAdmin=adminaccess.objects.filter(token=AccessKey).first()
			if not theAdmin:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theCompObj=company.objects.filter(userUniqueID=data.get('companyID')).first()
			if not theCompObj:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			compObj=companydocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,id=data.get('documentID'))
			if compObj:
				compObj.delete()
			response['status_code']=200
			response['status_message']='Documents deleted'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def approveDocuments(companyID,docID):
	alreadyDoc=companydocuments.objects.filter(userUniqueID=companyID,id=docID).first()
	if alreadyDoc:
		alreadyDoc.isApproved=True
		alreadyDoc.theStatus='2'
		alreadyDoc.save()

def rejectDocuments(companyID,docID,reason):
	alreadyDoc=companydocuments.objects.filter(userUniqueID=companyID,id=docID).first()
	if alreadyDoc:
		alreadyDoc.isApproved=False
		alreadyDoc.theStatus='3'
		alreadyDoc.rejectMessage=reason
		alreadyDoc.save()

class changeDocumentsStatus(APIView):
	def post(self, request, *args, **kwargs):
		try:
			response={}
			data=request.data
			# env = environ.Env()
			# environ.Env.read_env()
			# theKey = env("ACCESS_TOKEN")
			# if data.get('AccessKey') != theKey:
			# 	response['status_code']=403
			# 	response['status_message']='You dont have access to this api.'
			# 	return Response(response)

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			theAdmin=adminaccess.objects.filter(token=AccessKey).first()
			if not theAdmin:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theCompObj=company.objects.filter(userUniqueID=data.get('companyID')).first()
			if not theCompObj:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			docId = data.get("docID")
			theStatus = data.get("status")
			if theStatus == 'Accept':
				approveDocuments(data.get('companyID'),docId)
			else:
				if not data.get('reason'):
					response['status_code']=400
					response['status_message']='Rejected reason required'
					return Response(response)
				rejectDocuments(data.get('companyID'),docId,data.get('reason'))
			approveCount=0
			totalUplodedCount=0
			presentDocs=companydocuments.objects.filter(userUniqueID=data.get('companyID'))
			for p in presentDocs:
				totalUplodedCount+=1
				if p.isApproved==True:
					approveCount+=1
			if approveCount==0:
				pass
			elif approveCount>=totalUplodedCount:
				theCompObj.risk='1'
				theCompObj.save()
			elif approveCount<totalUplodedCount:
				theCompObj.risk='2'
				theCompObj.save()
			else:
				theCompObj.risk='3'
				theCompObj.save()
			response['status_code']=200
			response['status_message']='Documents '+str(theStatus)+' Successfully'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class totalCompanies(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			# env = environ.Env()
			# environ.Env.read_env()
			# theKey = env("ACCESS_TOKEN")
			# if data.get('AccessKey') != theKey:
			# 	response['status_code']=403
			# 	response['status_message']='You dont have access to this api.'
			# 	return Response(response)
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			theAdmin=adminaccess.objects.filter(token=AccessKey).first()
			if not theAdmin:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			allComps=company.objects.all().count()
			response['status_code']=200
			response['count']=allComps
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class getCompanies(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			accessKey = request.META.get('HTTP_AUTHORIZATION')
			
			if not accessKey:
				response['status_code']=401
				response['status_message']='Unauthorized'
				return Response(response)
			accessKey = accessKey.replace("Token ", "")
			allData=[]
			if accessKey == str(settings.MY_ACCESS_KEY):
				allComps=company.objects.filter(isdisabled=False)
				# theData=GetCompaniesListForStore(allComps,many=True)
				for com in allComps:
					haveSubs=companystats.objects.filter(companyID=com.userUniqueID).first()
					if haveSubs:
						allData.append({'userUniqueID':com.userUniqueID,
									'name':com.name,
									'canAddDriver':haveSubs.canAddDriver,
									'driverLimit':haveSubs.driverLimit,})
				response['status_code']=200
				response['data']=allData
				response['status_message']='Success'
			else:
				response['status_code']=401
				response['status_message']='Unauthorized'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class sendEmailNotificationsToCompanies(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")


			theAdmin=adminaccess.objects.filter(token=AccessKey).first()
			if not theAdmin:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			allUsers=company.objects.filter(isdisabled=False)
			if not allUsers:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			allMails=[]
			for user in allUsers:
				allMails.append(user.email)
			
			try:
				subject=data.get('title')
				message = render_to_string('notifyMailHTML.html', {
				'message': data.get('message'),
				})
				fromEmail = settings.EMAIL_HOST_USER
				message = EmailMessage(subject, message, fromEmail, allMails)
				message.content_subtype = 'html'
				message.send()
			except Exception as e:
				print(e)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def sendPush(device_ids, body):
	import json
	region = [r for r in boto.sns.regions() if r.name==u'us-east-1'][0]
	sns = boto.sns.SNSConnection(
		aws_access_key_id=str(settings.AWS_ACCESS_KEY_ID),
		aws_secret_access_key=str(settings.AWS_SECRET_ACCESS_KEY),
		region=region,
	)
	for device_id in device_ids:
		try:
			print("device id",device_id['token'])
			endpoint_response = sns.create_platform_endpoint(
				platform_application_arn='arn:aws:sns:us-east-1:432363816440:app/GCM/Cannabis',
				token=device_id['token'],
			)   
			endpoint_arn = endpoint_response['CreatePlatformEndpointResponse']['CreatePlatformEndpointResult']['EndpointArn']
		except boto.exception.BotoServerError as err:
			print("if error ", err)
			result_re = re.compile(r'Endpoint(.*)already', re.IGNORECASE)
			result = result_re.search(err.message)
			if result:
				endpoint_arn = result.group(0).replace('Endpoint ','').replace(' already','')
			else:
				raise
		print("ARN:", endpoint_arn)
		publish_result = sns.publish(
			target_arn=endpoint_arn,
			message=json.dumps(body),
			# message_structure='json'
		)
		print("PUBLISH")
		pprint.pprint(publish_result)
		companynotifications.objects.create(companyID=device_id['companyID'],notificationType='push',title=body['title'],description=body['body'])

class sendPushNotificationsToCompanies(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")
			
			theAdmin=adminaccess.objects.filter(token=AccessKey).first()
			if not theAdmin:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			allUsers=company.objects.filter(isdisabled=False)
			if not allUsers:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			allTokens=[]
			for user in allUsers:
				if user.fcmtoken!='':
					if user.fcmtoken:
						allTokens.append({'token':user.fcmtoken,
						                  'companyID':user.userUniqueID,})
			
			try:
				print(allTokens)
				messageJson={'body':data.get('message'),'title':data.get('title')}
				if allTokens:
					sendPush(allTokens,messageJson)
			except Exception as e:
				print(e)
			response['status_code']=200
			response['status_message']='Success'
			response['tokenList']=allTokens
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getListOfPurchasedPlanByCompanies(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData=[]
			data=request.data
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			theAdmin=adminaccess.objects.filter(token=AccessKey).first()
			if not theAdmin:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			
			allPurchase=companypurchase.objects.all()
			for i in allPurchase:
				theCompObject=company.objects.filter(userUniqueID=i.companyID).first()
				if not data.get('search') or data.get('search')=='':
					allData.append({'planName':i.planName,
								'planPrice':i.planPrice,
								'description':i.description,
								'htmlDescription':i.htmlDescription,
								'startDate':i.startDate,
								'expiryDate':i.expiryDate,
								'trialExpiry':i.trialExpiry,
								'isActive':i.isActive,
								'name':theCompObject.name,
								'email':theCompObject.email,
								'image':str(theCompObject.image.name)})
				else:
					searchingName=theCompObject.name
					searchingName=searchingName.lower()
					if data.get('search')==searchingName:
						allData.append({'planName':i.planName,
								'planPrice':i.planPrice,
								'description':i.description,
								'htmlDescription':i.htmlDescription,
								'startDate':i.startDate,
								'expiryDate':i.expiryDate,
								'trialExpiry':i.trialExpiry,
								'isActive':i.isActive,
								'name':theCompObject.name,
								'email':theCompObject.email,
								'image':str(theCompObject.image.name)})
					
			response['status_code']=200
			response['status_message']='Success'
			response['data']=allData
		except Exception as e:
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getOrdersOfCompany(APIView):
	def post(self, request,*args,**kwargs):
		response={}
		try:
			
			data=request.data
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")
			
			if not data.get('companyID'):
				response['status_code']=400
				response['status_message']='companyID required'
				return Response(response)

			theAdmin=adminaccess.objects.filter(token=AccessKey).first()
			if not theAdmin:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theCompObj=company.objects.filter(userUniqueID=data.get('companyID')).first()
			if not theCompObj:
				response['status_code']=400
				response['status_message']='Invalid company id'
				return Response(response)
			
			try:
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/order/getCompanyOrdersForAdmin/"
				payload={
						 'AccessKey': str(settings.CUSTOMER_ACCESS_KEY),
						 'companyID': data.get('companyID')
						 }
				res = requests.request("POST", url,data=payload)
				print("call done")
				print(res)
				res = res.json()
				if res['status_code']==200:
					return Response(res)
					# response['data']=res['data']
				else:
					response['data']=[]
					response['status_code']=400
					response['status_message']='No data found'
					return Response(response)
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class addEarning(APIView):
	def post(self, request,*args,**kwargs):
		try:
			response={}
			data=request.data
			accessKey = data.get('AccessKey')
			if not accessKey:
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if accessKey != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if not data.get('companyID'):
				response['status_code']=400
				response['status_message']='companyID is required'
				return Response(response)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID is required'
				return Response(response)
			if not data.get('amount'):
				response['status_code']=400
				response['status_message']='amount is required'
				return Response(response)
			if not data.get('title'):
				response['status_code']=400
				response['status_message']='title is required'
				return Response(response)
			if not data.get('description'):
				response['status_code']=400
				response['status_message']='description is required'
				return Response(response)
			theCompObject=company.objects.filter(userUniqueID=data.get('companyID')).first()
			if not theCompObject:
				response['status_code']=400
				response['status_message']='Invalid companyID'
				return Response(response)
			walletObject=companywallet.objects.filter(companyID=data.get('companyID')).first()
			if not walletObject:
				walletObject=companywallet.objects.create(companyID=data.get('companyID'))
			
			storewalletObject=storewallet.objects.filter(companyID=data.get('companyID'),storeID=data.get('storeID')).first()
			if not storewalletObject:
				storewalletObject=storewallet.objects.create(companyID=data.get('companyID'),storeID=data.get('storeID'))
				
			beforeAmount=float(walletObject.balance)
			beforeAmount=float(beforeAmount)+float(data.get('amount'))
			beforeAmount="{:.2f}".format(beforeAmount)
			walletObject.balance=beforeAmount
			beforeTotalEarning=float(walletObject.totalearning)
			beforeTotalEarning=float(beforeTotalEarning)+float(data.get('amount'))
			beforeTotalEarning="{:.2f}".format(beforeTotalEarning)
			walletObject.totalearning=beforeTotalEarning
			walletObject.save()

			beforeAmount2=float(storewalletObject.balance)
			beforeAmount2=float(beforeAmount2)+float(data.get('amount'))
			beforeAmount2="{:.2f}".format(beforeAmount2)
			storewalletObject.balance=beforeAmount2
			beforeTotalEarning2=float(storewalletObject.totalearning)
			beforeTotalEarning2=float(beforeTotalEarning2)+float(data.get('amount'))
			beforeTotalEarning2="{:.2f}".format(beforeTotalEarning2)
			storewalletObject.totalearning=beforeTotalEarning2
			storewalletObject.save()


			companyearning.objects.create(companyID=data.get('companyID'),storeID=data.get('storeID'),amount=data.get('amount'),title=data.get('title'),description=data.get('description'))
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getStoreEarning(APIView):
	def post(self, request,*args,**kwargs):
		try:
			response={}
			data=request.data
			accessKey = data.get('AccessKey')
			if not accessKey:
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if accessKey != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID is required'
				return Response(response)
			allData=[]
			totalEarning=float(0)
			allEarningObjects=companyearning.objects.filter(storeID=data.get('storeID'))
			for earn in allEarningObjects:
				totalEarning=float(totalEarning)+float(earn.amount)
				allData.append({'companyID':earn.companyID,
								'amount':earn.amount,
								'title':earn.title,
								'description':earn.description,})
			totalEarning="{:.2f}".format(totalEarning)

			earningSeries=[]
			try:
				import datetime as ddd
				import dateutil.relativedelta
				for count in range(0,6):
					d = ddd.datetime.now()
					print(d.month,d.year)
					d2 = d - dateutil.relativedelta.relativedelta(months=count)
					print(d2.month,d2.year)
					theDateValue=d2.strftime("%b, %Y")
					allEarnings=companyearning.objects.filter(Q(storeID=data.get('storeID')) & Q(created_at__month=d2.month) & Q(created_at__year=d2.year))
					tempEarning=float(0)
					for earning in allEarnings:
						tempEarning=float(tempEarning)+float(earning.amount)
					tempEarning="{:.2f}".format(tempEarning)
					earningSeries.append({'value':tempEarning,
										'name':theDateValue,})
			except Exception as e:
				print(e)
			response['earningSeries']=earningSeries
			response['totalEarning']=totalEarning
			response['data']=allData
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getTotalCompanyEarningForAdmin(APIView):
	def post(self, request,*args,**kwargs):
		try:
			response={}
			data=request.data
			accessKey = data.get('AccessKey')
			if not accessKey:
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if accessKey != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			
			totalCompaniesEarning=float(0)
			allData=[]
			allCompaniesWallet=companywallet.objects.all().order_by('-id')
			if allCompaniesWallet:
				for earn in allCompaniesWallet:
					theCompObj=company.objects.filter(userUniqueID=earn.companyID).first()
					totalCompaniesEarning=float(totalCompaniesEarning)+float(earn.balance)
					allData.append({'companyID':earn.companyID,
									'balance':earn.balance,
									'totalearning':earn.totalearning,
									'totalWithdrawl':earn.totalWithdrawl,
									'name':theCompObj.name,
									'email':theCompObj.email,
									'image':theCompObj.image.name,})
			response['data']=allData
			response['totalCompaniesEarning']=totalCompaniesEarning
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def createCSVCompanies(allCompanies):
	import csv
	rows=[]
	fields = ['Id', 'Name', 'Email', 'Phone', 'State', 'Status']
	for company in allCompanies:
		innerRow=[]
		innerRow.append(company['userUniqueID'])
		innerRow.append(company['name'])
		innerRow.append(company['email'])
		tempPhone=str(company['countrycode'])+str(company['phone']) 
		innerRow.append(tempPhone) 
		innerRow.append(company['state'])
		if company['isdisabled']==True:
			theStatus='In Active'
		else:
			theStatus='Active'
		innerRow.append(theStatus)
		rows.append(innerRow)
	fname=randomStringFunctionForImage()
	filename = "/var/www/html/company/media/Reports/companies_"+str(fname)+".csv"
	url=str(settings.BASE_URL)+"media/Reports/companies_"+str(fname)+".csv"
	with open(filename, 'w') as csvfile:
		csvwriter = csv.writer(csvfile) 
		csvwriter.writerow(fields)
		csvwriter.writerows(rows)
	return url

class getReportCompanies(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			theAdmin=adminaccess.objects.filter(token=AccessKey).first()
			if not theAdmin:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			
			if not data.get('filterType'):
				response['status_code']=400
				response['status_message']='filterType is required'
				return Response(response)
			filterType=data.get('filterType')
			if filterType=='Enable':
				filterValue=False
			elif filterType=='Disable':
				filterValue=True
			else:
				filterValue='All'
			
			if not data.get('fromDate'):
				response['status_code']=400
				response['status_message']='fromDate is required'
				return Response(response)
			
			if not data.get('toDate'):
				response['status_code']=400
				response['status_message']='toDate is required'
				return Response(response)

			try:
				from datetime import datetime
				dat=data.get('fromDate')
				fromDate=datetime.strptime(dat, "%Y/%m/%d").date()
				dat2=data.get('toDate')
				toDate=datetime.strptime(dat2, "%Y/%m/%d").date()
			except Exception as e:
				print(e)
			
			if filterType=='All':
				allComps=company.objects.filter(Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-id')
			else:
				allComps=company.objects.filter(Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate) & Q(isdisabled=filterValue)).order_by('-id')
			
			if not allComps:
				response['status_code']=400
				response['status_message']='No records found'
				return Response(response)
			else:
				theData=GetCompanyData(allComps, many=True)
				downloadLink=createCSVCompanies(theData.data)
				response['status_code']=200
				response['status_message']='Success'
				response['downloadLink']=downloadLink
		except Exception as e:
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)