from rest_framework.views import APIView
from rest_framework.response import Response
from django.contrib.auth import login,authenticate
from base.models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
import datetime
from django.template.loader import render_to_string
from django.core.mail import EmailMessage
import math, random, datetime, pytz, string
from datetime import datetime
from datetime import timedelta
import requests
from django.conf import settings

class getQuantityList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			companyObjects=company.objects.filter(token=session_token).first()
			if not companyObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			try:
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/setting/getQuantitiesForOthers/"
				payload={'AccessKey': str(settings.ADMIN_ACCESS_KEY)}
				res = requests.request("POST", url,data=payload)
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)


class addGift(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			companyObjects=company.objects.filter(token=session_token).first()
			if not companyObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			
			if not data.get('giftName'):
				response['status_code']=400
				response['status_message']='giftName required'
				return Response(response)
			if not request.FILES.get('giftImage'):
				response['status_code']=400
				response['status_message']='giftImage required'
				return Response(response)
			if not data.get('giftDescription'):
				response['status_code']=400
				response['status_message']='giftDescription required'
				return Response(response)
			quanList=data.get("giftQuantities")
			if not quanList:
				response['status_code']=400
				response['status_message']='giftQuantities required'
				return Response(response)
			try:
				url = str(settings.STORE_ACCESS_URL_BASE)+"store/products/addGiftForCompany/"
				payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
				'giftName': data.get('giftName'),
				'giftImage': data.get('giftImage'),
				'giftDescription':data.get('giftDescription'),
				'giftQuantities':data.get('giftQuantities'),
				'companyId':companyObjects.userUniqueID
				}
				res = requests.request("POST", url,data=payload)
				print(res.json())
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class getGiftList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			print("==1==")
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			companyObjects=company.objects.filter(token=session_token).first()
			if not companyObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			print("==2==")
			try:
				url = str(settings.STORE_ACCESS_URL_BASE)+"store/products/getGiftsListForCompany/"
				print("==3==")
				payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
				'companyId':companyObjects.userUniqueID
				}
				print("==4==")
				res = requests.request("POST", url,data=payload)
				print("==4.1==")
				print(res)
				print(res.text)
				print(res.json())
				print("==5==")
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class getGiftDetails(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			if not data.get('giftId'):
				response['status_code']=400
				response['status_message']='giftId required'
				return Response(response)

			companyObjects=company.objects.filter(token=session_token).first()
			if not companyObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			try:
				url = str(settings.STORE_ACCESS_URL_BASE)+"store/products/getGiftDetailsForCompany/"
				payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
				'companyId':companyObjects.userUniqueID,
				'giftId':data.get('giftId')
				}
				res = requests.request("POST", url,data=payload)
				print(res.json())
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class updateGift(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			if not data.get('giftId'):
				response['status_code']=400
				response['status_message']='giftId required'
				return Response(response)

			companyObjects=company.objects.filter(token=session_token).first()
			if not companyObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)

			if not data.get('giftId'):
				response['status_code']=400
				response['status_message']='giftId required'
				return Response(response)

			payload={'AccessKey': str(settings.STORE_ACCESS_KEY)}
			payload['giftId']=data.get('giftId')
			if data.get('giftName'):
				payload['giftName']=data.get('giftName')
			if request.FILES.get('giftImage'):
				payload['giftImage']=data.get('giftImage')
			if data.get('giftDescription'):
				payload['giftDescription']=data.get('giftDescription')
			quanList=data.get("giftQuantities")
			if quanList:
				payload['giftQuantities']=quanList


			try:
				url = str(settings.STORE_ACCESS_URL_BASE)+"store/products/updateGiftForCompany/"
				res = requests.request("POST", url,data=payload)
				print(res.json())
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class addProduct(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			companyObjects=company.objects.filter(token=session_token).first()
			if not companyObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			
			if not data.get('productName'):
				response['status_code']=400
				response['status_message']='productName required'
				return Response(response)
			if not data.get('productPrice'):
				response['status_code']=400
				response['status_message']='productPrice required'
				return Response(response)
			if not request.FILES.get('productImage'):
				response['status_code']=400
				response['status_message']='productImage required'
				return Response(response)
			if not data.get('productQuantity'):
				response['status_code']=400
				response['status_message']='productQuantity required'
				return Response(response)
			if not data.get('productDescription'):
				response['status_code']=400
				response['status_message']='productDescription required'
				return Response(response)
			if not data.get('giftId'):
				response['status_code']=400
				response['status_message']='giftId required'
				return Response(response)
			try:
				url = str(settings.STORE_ACCESS_URL_BASE)+"store/products/addProductForCompany/"
				payload={
				'AccessKey': str(settings.STORE_ACCESS_KEY),
				'productName':data.get('productName'),
				'productPrice':data.get('productPrice'),
				'productImage':data.get('productImage'),
				'productQuantity':data.get('productQuantity'),
				'productDescription':data.get('productDescription'),
				'giftId':data.get('giftId'),
				'companyId':companyObjects.userUniqueID,
				}
				res = requests.request("POST", url,data=payload)
				print(res.json())
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class getProductList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			companyObjects=company.objects.filter(token=session_token).first()
			if not companyObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)

			try:
				url = str(settings.STORE_ACCESS_URL_BASE)+"store/products/getProductListForCompany/"
				payload={
				'AccessKey': str(settings.STORE_ACCESS_KEY),
				'companyId':companyObjects.userUniqueID,
				}
				res = requests.request("POST", url,data=payload)
				print(res.json())
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class getProductDetails(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			companyObjects=company.objects.filter(token=session_token).first()
			if not companyObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)

			try:
				url = str(settings.STORE_ACCESS_URL_BASE)+"store/products/viewProductForCompany/"
				payload={
				'AccessKey': str(settings.STORE_ACCESS_KEY),
				'companyId':companyObjects.userUniqueID,
				}
				res = requests.request("POST", url,data=payload)
				print(res.json())
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class updateProduct(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			companyObjects=company.objects.filter(token=session_token).first()
			if not companyObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)

			if not data.get('productId'):
				response['status_code']=400
				response['status_message']='productId required'
				return Response(response)

			payload={'AccessKey': str(settings.STORE_ACCESS_KEY)}
			payload['productId']=data.get('productId')
			payload['companyId']=companyObjects.userUniqueID

			if data.get('productName'):
				payload['productName']=data.get('productName')
			if data.get('productPrice'):
				payload['productPrice']=data.get('productPrice')
			if request.FILES.get('productImage'):
				payload['productImage']=data.get('productImage')
			if data.get('productQuantity'):
				payload['productQuantity']=data.get('productQuantity')
			if data.get('productDescription'):
				payload['productDescription']=data.get('productDescription')
			if data.get('giftId'):
				payload['giftId']=data.get('giftId')


			try:
				url = str(settings.STORE_ACCESS_URL_BASE)+"store/products/updateProductForCompany/"
				res = requests.request("POST", url,data=payload)
				print(res.json())
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)