from django.db import models
from base.models import *
from ckeditor.fields import RichTextField 

RENEWCHOICE = [
    ('AutoRenew', 'AutoRenew'),
    ('OneTime', 'OneTime'),
]


class companypurchase(models.Model):
	companyID = models.CharField(max_length = 25, null = True, blank = True,default='')
	planID = models.CharField(max_length = 25, null = True, blank = True,default='')
	planName = models.CharField(max_length = 25, null = True, blank = True,default='')
	planPrice = models.CharField(max_length = 25, null = True, blank = True,default='')
	description = models.TextField(blank = True)
	htmlDescription = RichTextField(default='')
	startDate = models.DateField(max_length=25,null=True,blank=True)
	expiryDate = models.DateField(max_length=25,null=True,blank=True)
	trialExpiry = models.DateField(max_length=25,null=True,blank=True)
	option = models.CharField(max_length=25,choices=RENEWCHOICE,default='AutoRenew')
	isUsed = models.BooleanField(default = False)
	isActive = models.BooleanField(default = False)
	isTrial = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.planID)+'-'+str(self.companyID))

class currentplan(models.Model):
	myPlan= models.ForeignKey(companypurchase, on_delete=models.CASCADE,default='',null=True)
	planID = models.CharField(max_length = 25, null = True, blank = True,default=1)
	companyID = models.CharField(max_length = 25, null = True, blank = True,default='')
	startDate = models.DateField(max_length=25,null=True,blank=True)
	expiryDate = models.DateField(max_length=25,null=True,blank=True)
	trialExpiry = models.DateField(max_length=25,null=True,blank=True)
	option = models.CharField(max_length=25,choices=RENEWCHOICE,default='AutoRenew')
	isActive = models.BooleanField(default = False)
	isTrial = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.companyID))

class companystats(models.Model):
	companyID = models.CharField(max_length = 25, null = True, blank = True,default='')
	canAddDriver = models.BooleanField(default = False)
	driverLimit = models.CharField(max_length = 25, null = True, blank = True,default='0')
	canAddMoreDriver = models.BooleanField(default = False)
	canAddStore = models.BooleanField(default = False)
	storeLimit = models.CharField(max_length = 25, null = True, blank = True,default='0')
	canAddMoreStore = models.BooleanField(default = False)
	canAddProducts = models.BooleanField(default = False)
	productLimit = models.CharField(max_length = 25, null = True, blank = True,default='0')
	canAddMoreProducts = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.companyID))