from rest_framework import serializers
from .models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
import requests
from django.conf import settings

class GetSubData(serializers.ModelSerializer):
	moduleData =  serializers.SerializerMethodField(source='get_moduleData')
	
	class Meta:
		model = companypurchase
		fields = ['planID','startDate', 'expiryDate', 'trialExpiry','isActive','planName','planPrice','moduleData']
	
	def get_moduleData(self,obj):
		try:
			url = str(settings.ADMIN_ACCESS_URL)+"superadmin/subscriptions/viewPlanForAll/"
			theToken=str(settings.ADMIN_ACCESS_KEY)
			payload={'AccessKey':theToken,
					'userType':'2',
					'planID':str(obj.planID)}
			apiResponse = requests.request("POST", url, data=payload)
			r=apiResponse.json()
			return r['data']['moduleData']
		except Exception as e:
			print(e)
			return ''