from rest_framework.views import APIView
from rest_framework.response import Response
from django.contrib.auth import login,authenticate
from .models import *
from base.models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from .serializers import *
import datetime
from django.template.loader import render_to_string
from django.core.mail import EmailMessage
import math, random, datetime, pytz, string
from datetime import datetime
from datetime import timedelta
import requests
from django.conf import settings
import json
import stripe

def validateToken(theToken):
	returnId='0'
	tokenOBJ = Token.objects.filter(key = theToken).first()
	if tokenOBJ:
		user = User.objects.get(id = tokenOBJ.user_id)
	if user:
		returnId=user.id
	return returnId

class getPlanList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			print("==1==")
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			print(session_token)
			customerObjects=company.objects.filter(token=session_token).first()
			if not customerObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			try:
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/subscriptions/getPlanListForAll/"
				theToken=str(settings.ADMIN_ACCESS_KEY)
				payload={'AccessKey':theToken,
						 'userType':'2'}
				apiResponse = requests.request("POST", url, data=payload)
				r=apiResponse.json()
				response['availablePlanList']=r['data']
			except Exception as e:
				print(e)

			allPlans=companypurchase.objects.filter(companyID=customerObjects.userUniqueID,isdeleted=False,isActive=False)	
			# allPlans=CustomerPurchase.objects.filter(customerID=customerObjects.userUniqueID,isdeleted=False,isActive=False)
			if allPlans:
				theList=[]
				try:
					url = str(settings.ADMIN_ACCESS_URL)+"superadmin/subscriptions/viewPlanWithIDListForAll/"
					theToken=str(settings.ADMIN_ACCESS_KEY)
					for p in allPlans:
						theList.append({'planID':str(p.planID)})
					print("THE LIST",theList)
					print("THE LIST TYPE",type(theList))

					theList = json.dumps(theList)

					# theJson.update({"data":theList})

					payload={"AccessKey":theToken,
							 "planID":theList,
							 "userType":'2'}

					apiResponse = requests.request("POST", url, data=payload )
					apiResponse = apiResponse.json()
					print(apiResponse)
					if apiResponse['status']==200:
						response['myPurchasedPlanList']=apiResponse['data']
					else:
						response['myPurchasedPlanList']=[]
				except Exception as e:
					print(e)
					response['myPurchasedPlanList']=[]
			else:
				response['myPurchasedPlanList']=[]
			
			compObj=companypurchase.objects.filter(companyID=customerObjects.userUniqueID,isdeleted=False,isActive=True).first()
			if compObj:
				theData=GetSubData(compObj)
				response['myCurrentPlan']=theData.data
			else:
				response['myCurrentPlan']={}
			response['availablePlanList']=r['data']
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class getPlan(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=company.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			if not data.get('planID'):
				response['status_code']=400
				response['status_message']='Invalid plan Id'
				return Response(response)
			url = str(settings.ADMIN_ACCESS_URL)+"superadmin/subscriptions/viewPlanForAll/"
			theToken=str(settings.ADMIN_ACCESS_KEY)
			payload={'AccessKey':theToken,
					 'planID':data.get('planID'),
					 'userType':'2'}
			apiResponse = requests.request("POST", url, data=payload)
			r=apiResponse.json()
			response['data']=r
			return Response(r)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class purchaseSubscriptions(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			if not data.get('planID'):
				response['status_code']=400
				response['status_message']='Plan id required'
				return Response(response)
			# if not data.get('cardID'):
			# 	response['status_code']=400
			# 	response['status_message']='cardID required'
			# 	return Response(response)
			idAdmin=company.objects.filter(token=session_token).first()
			if not idAdmin:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			try:
				print("==Before==")
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/subscriptions/viewPlanForAll/"
				theToken=str(settings.ADMIN_ACCESS_KEY)
				payload={'AccessKey':theToken,
						 'planID':data.get('planID'),
						 'userType':'2'}
				print("payload",payload)
				print(url)

				apiResponse = requests.request("POST", url, data=payload)
				print(apiResponse)
				apiResponse = apiResponse.json()
				print(apiResponse)
				if apiResponse['status_code']==200:
					thePlanName=apiResponse['data']['planName']
					thePlanPrice=apiResponse['data']['price']
					theDesc=apiResponse['data']['description']
					theHTMLDesc=apiResponse['data']['htmlDescription']
					theDays=apiResponse['data']['planDurationDays']
					theTrialDays=apiResponse['data']['trialDurationDays']
					theModulesData=apiResponse['data']['moduleData']
				else:
					response['status_code']=400
					response['status_message']='Not valid plan id'
					return Response(response)
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			print("==After==")

			print(theModulesData)
			print(type(theModulesData))

			
			# return Response({'code':'200'})

			allPlansCount=companypurchase.objects.filter(companyID=idAdmin.userUniqueID,isdeleted=False).count()
			print("the count",allPlansCount)
			if allPlansCount==2:
				response['status_code']=400
				response['status_message']='You can only purchase 2 plans at a time'
				return Response(response)
			alreadyPurchased=companypurchase.objects.filter(companyID=idAdmin.userUniqueID,planID=data.get('planID')).first()
			
			if alreadyPurchased:
				response['status_code']=400
				response['status_message']='Plan already purchased'
				return Response(response)

			firstPurchase=True
			alreadyAPlanInActive=True
			currentPlanObj=currentplan.objects.filter(companyID=idAdmin.userUniqueID).first()
			if currentPlanObj:
				firstPurchase=False
				if currentPlanObj.isActive!=True:
					alreadyAPlanInActive=False
			else:
				alreadyAPlanInActive=False
			# compObj=CompanyPurchase.objects.filter(companyID=idAdmin.userUniqueID).first()
			# if compObj:
			# 	firstPurchase=False
			
			theCard=companycard.objects.filter(companyID=idAdmin.userUniqueID,cardID=data.get('cardID')).first()
			if not theCard:
				response['status_code']=400
				response['status_message']='Invalid card selection'
				return Response(response)

			if int(thePlanPrice)>1:
				thePaymentObject=PaymentWithExistingCard(theCard.theCustomer,theCard.cardID,int(thePlanPrice))
				if thePaymentObject['status'] == True :
					response['data'] = thePaymentObject['data']
				else:
					response['status_code'] = 400
					response['status_message'] = 'Something went wrong. Please try again later.'
					return Response(response)

			compObj=companypurchase.objects.create(companyID=idAdmin.userUniqueID)
			compObj.planID=data.get('planID')
			if alreadyAPlanInActive==True:
				compObj.isActive=False
			else:
				compObj.isActive=True
			# alreadyAPlanInActive=True
			# # anyActive=currentPlan.objects.filter(companyID=idAdmin.userUniqueID,isActive=True).first()
			# if not currentPlanObj.isActive=True:
			# 	alreadyAPlanInActive=False
			# 	compObj.isActive=True

			# anyActive=CompanyPurchase.objects.filter(companyID=idAdmin.userUniqueID,isActive=True).first()
			# if not anyActive:
			# 	compObj.isActive=True

			if data.get('oneTime')==True:
				compObj.option='OneTime'

			if firstPurchase==True:
				hoursInDays=int(theDays)*24
				hoursOfTrial=int(theTrialDays)*24
				startDate=datetime.now()
				startDate=startDate.date()
				trialExpiryDate=startDate+timedelta(hours=hoursOfTrial)
				expiryDate=trialExpiryDate+timedelta(hours=hoursInDays)
				compObj.startDate=startDate
				compObj.trialExpiry=trialExpiryDate
				compObj.expiryDate=expiryDate
				compObj.isTrial=True
				compObj.isUsed=True
				compObj.planName=thePlanName
				compObj.planPrice=thePlanPrice
				compObj.description=theDesc
				compObj.htmlDescription=theHTMLDesc
			else:
				hoursInDays=int(theDays)*24
				if alreadyAPlanInActive==True:
					compObj.isUsed=False
					# startDate=datetime.now()
					startDate=str(currentPlanObj.expiryDate)
					print("theObjectDate",startDate)
					import datetime as dv
					startDate=dv.datetime.strptime(startDate, '%Y-%m-%d')
					print(startDate)
					print(type(startDate))
					startDate=startDate.date()
					print(startDate)
					expiryDate=startDate+timedelta(hours=hoursInDays)
				else:
					startDate=datetime.now()
					startDate=startDate.date()
					expiryDate=startDate+timedelta(hours=hoursInDays)
					compObj.isUsed=True
				compObj.startDate=startDate
				compObj.expiryDate=expiryDate
				compObj.isTrial=False
				compObj.planName=thePlanName
				compObj.planPrice=thePlanPrice
				compObj.description=theDesc
				compObj.htmlDescription=theHTMLDesc
			compObj.save()
			if firstPurchase==True:
				currentPlanObj=currentplan.objects.create(companyID=idAdmin.userUniqueID)
				currentPlanObj.myPlan=compObj
				currentPlanObj.startDate=startDate
				currentPlanObj.expiryDate=expiryDate
				if data.get('oneTime')==True:
					currentPlanObj.option='OneTime'
				currentPlanObj.trialExpiry=trialExpiryDate
				currentPlanObj.isTrial=True
				currentPlanObj.isActive=True
				currentPlanObj.save()
				theCompModule=companystats.objects.create(companyID=idAdmin.userUniqueID)
				for tmd in theModulesData['data']:
					print("=A=")
					if tmd['name']=='canAddDriver':
						print("=B=")
						if tmd['value']==True:
							print("=C=")
							theCompModule.canAddDriver=True
						else:
							print("=D=")
							theCompModule.canAddDriver=False
						print("=E=")
					print("=F=")
					if tmd['name']=='addDriverLimit':
						theCompModule.driverLimit=str(tmd['value'])
					print("=G=")
					if tmd['name']=='canAddStore':
						if tmd['value']==True:
							theCompModule.canAddStore=True
						else:
							theCompModule.canAddStore=False
					print("=H=")
					if tmd['name']=='addStoreLimit':
						theCompModule.storeLimit=str(tmd['value'])
					print("=I=")
					if tmd['name']=='canAddProducts':
						if tmd['value']==True:
							theCompModule.canAddProducts=True
						else:
							theCompModule.canAddProducts=False
					print("=J=")
					if tmd['name']=='addProductsLimit':
						theCompModule.productLimit=str(tmd['value'])
				theCompModule.save()
			else:
				if alreadyAPlanInActive==True:
					pass
				else:
					currentPlanObj.myPlan=compObj
					currentPlanObj.startDate=startDate
					currentPlanObj.expiryDate=expiryDate
					if data.get('oneTime')==True:
						currentPlanObj.option='OneTime'
					currentPlanObj.isActive=True
					currentPlanObj.isTrial=False
					currentPlanObj.save()
			
			try:
				print("==After all Purchase adding value in admin earning count==")
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/subscriptions/addSubscriptionEarning/"
				theToken=str(settings.ADMIN_ACCESS_KEY)
				payload={'AccessKey':theToken,
						 'amount':thePlanPrice,}
				print("payload",payload)
				print(url)
				apiResponse = requests.request("POST", url, data=payload)
				print(apiResponse)
				apiResponse = apiResponse.json()
				print(apiResponse)
				if apiResponse['status_code']==200:
					pass
				else:
					return Response(response)
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
				
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)


class purchaseSubscriptionsByChoice(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			if not data.get('planID'):
				response['status_code']=400
				response['status_message']='Plan id required'
				return Response(response)
			idAdmin=company.objects.filter(token=session_token).first()
			if not idAdmin:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			try:
				print("==Before==")
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/subscriptions/viewPlanForAll/"
				theToken=str(settings.ADMIN_ACCESS_KEY)
				payload={'AccessKey':theToken,
						 'planID':data.get('planID'),
						 'userType':'2'}
				print("payload",payload)
				print(url)

				apiResponse = requests.request("POST", url, data=payload)
				print(apiResponse)
				apiResponse = apiResponse.json()
				print(apiResponse)
				if apiResponse['status_code']==200:
					thePlanName=apiResponse['data']['planName']
					thePlanPrice=apiResponse['data']['price']
					theDesc=apiResponse['data']['description']
					theHTMLDesc=apiResponse['data']['htmlDescription']
					theDays=apiResponse['data']['planDurationDays']
					theTrialDays=apiResponse['data']['trialDurationDays']
					theModulesData=apiResponse['data']['moduleData']
				else:
					response['status_code']=400
					response['status_message']='Not valid plan id'
					return Response(response)
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			print("==After==")

			print(theModulesData)
			print(type(theModulesData))

			allPlansCount=companypurchase.objects.filter(companyID=idAdmin.userUniqueID,isdeleted=False).count()
			print("the count",allPlansCount)
			if allPlansCount==2:
				response['status_code']=400
				response['status_message']='You can only purchase 2 plans at a time'
				return Response(response)
			alreadyPurchased=companypurchase.objects.filter(companyID=idAdmin.userUniqueID,planID=data.get('planID')).first()
			
			if alreadyPurchased:
				response['status_code']=400
				response['status_message']='Plan already purchased'
				return Response(response)

			firstPurchase=True
			alreadyAPlanInActive=True
			currentPlanObj=currentplan.objects.filter(companyID=idAdmin.userUniqueID).first()
			if currentPlanObj:
				firstPurchase=False
				if currentPlanObj.isActive!=True:
					alreadyAPlanInActive=False
			else:
				alreadyAPlanInActive=False
			
			if int(thePlanPrice)>1:
				body ={
					"DeviceGuid": data.get('device_guid'),
					"Amount": int(thePlanPrice),
					"Card": {
						"CardNumber": data.get('card_number'),
						"CardHolderName": data.get('holder_name'),
						"Cvv2": data.get('cvv'),
						"ExpirationDate": data.get('expiry_date')
					}
				}
				url ="https://sandbox.choice.dev/api/v1/sales"
				headers = {'UserAuthorization': '3dbab901-f2bc-4d04-ba14-e1c99538e3f9'}
				choiceResponse = requests.request("POST", url,headers=headers,json=body)
				print('choiceResponse',choiceResponse)
				print(choiceResponse.status_code)
				apiResponse = choiceResponse.json()
				# thePaymentObject=PaymentWithExistingCard(theCard.theCustomer,theCard.cardID,int(thePlanPrice))
				if choiceResponse.status_code == 201:
					response['data'] = apiResponse
				else:
					response['status_code'] = 400
					response['status_message'] = apiResponse['message']
					return Response(response)

			compObj=companypurchase.objects.create(companyID=idAdmin.userUniqueID)
			compObj.planID=data.get('planID')
			if alreadyAPlanInActive==True:
				compObj.isActive=False
			else:
				compObj.isActive=True
			if data.get('oneTime')==True:
				compObj.option='OneTime'

			if firstPurchase==True:
				hoursInDays=int(theDays)*24
				hoursOfTrial=int(theTrialDays)*24
				startDate=datetime.now()
				startDate=startDate.date()
				trialExpiryDate=startDate+timedelta(hours=hoursOfTrial)
				expiryDate=trialExpiryDate+timedelta(hours=hoursInDays)
				compObj.startDate=startDate
				compObj.trialExpiry=trialExpiryDate
				compObj.expiryDate=expiryDate
				compObj.isTrial=True
				compObj.isUsed=True
				compObj.planName=thePlanName
				compObj.planPrice=thePlanPrice
				compObj.description=theDesc
				compObj.htmlDescription=theHTMLDesc
			else:
				hoursInDays=int(theDays)*24
				if alreadyAPlanInActive==True:
					compObj.isUsed=False
					startDate=str(currentPlanObj.expiryDate)
					print("theObjectDate",startDate)
					import datetime as dv
					startDate=dv.datetime.strptime(startDate, '%Y-%m-%d')
					print(startDate)
					print(type(startDate))
					startDate=startDate.date()
					print(startDate)
					expiryDate=startDate+timedelta(hours=hoursInDays)
				else:
					startDate=datetime.now()
					startDate=startDate.date()
					expiryDate=startDate+timedelta(hours=hoursInDays)
					compObj.isUsed=True
				compObj.startDate=startDate
				compObj.expiryDate=expiryDate
				compObj.isTrial=False
				compObj.planName=thePlanName
				compObj.planPrice=thePlanPrice
				compObj.description=theDesc
				compObj.htmlDescription=theHTMLDesc
			compObj.save()
			if firstPurchase==True:
				currentPlanObj=currentplan.objects.create(companyID=idAdmin.userUniqueID)
				currentPlanObj.myPlan=compObj
				currentPlanObj.startDate=startDate
				currentPlanObj.expiryDate=expiryDate
				if data.get('oneTime')==True:
					currentPlanObj.option='OneTime'
				currentPlanObj.trialExpiry=trialExpiryDate
				currentPlanObj.isTrial=True
				currentPlanObj.isActive=True
				currentPlanObj.save()
				theCompModule=companystats.objects.create(companyID=idAdmin.userUniqueID)
				for tmd in theModulesData['data']:
					print("=A=")
					if tmd['name']=='canAddDriver':
						print("=B=")
						if tmd['value']==True:
							print("=C=")
							theCompModule.canAddDriver=True
						else:
							print("=D=")
							theCompModule.canAddDriver=False
						print("=E=")
					print("=F=")
					if tmd['name']=='addDriverLimit':
						theCompModule.driverLimit=str(tmd['value'])
					print("=G=")
					if tmd['name']=='canAddStore':
						if tmd['value']==True:
							theCompModule.canAddStore=True
						else:
							theCompModule.canAddStore=False
					print("=H=")
					if tmd['name']=='addStoreLimit':
						theCompModule.storeLimit=str(tmd['value'])
					print("=I=")
					if tmd['name']=='canAddProducts':
						if tmd['value']==True:
							theCompModule.canAddProducts=True
						else:
							theCompModule.canAddProducts=False
					print("=J=")
					if tmd['name']=='addProductsLimit':
						theCompModule.productLimit=str(tmd['value'])
				theCompModule.save()
			else:
				if alreadyAPlanInActive==True:
					pass
				else:
					currentPlanObj.myPlan=compObj
					currentPlanObj.startDate=startDate
					currentPlanObj.expiryDate=expiryDate
					if data.get('oneTime')==True:
						currentPlanObj.option='OneTime'
					currentPlanObj.isActive=True
					currentPlanObj.isTrial=False
					currentPlanObj.save()
			
			try:
				print("==After all Purchase adding value in admin earning count==")
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/subscriptions/addSubscriptionEarning/"
				theToken=str(settings.ADMIN_ACCESS_KEY)
				payload={'AccessKey':theToken,
						 'amount':thePlanPrice,}
				print("payload",payload)
				print(url)
				apiResponse = requests.request("POST", url, data=payload)
				print(apiResponse)
				apiResponse = apiResponse.json()
				print(apiResponse)
				if apiResponse['status_code']==200:
					pass
				else:
					return Response(response)
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
				
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

def PaymentWithExistingCard(cust_id , card_id , total_amount):
    response = {}
    try:
        stripe.api_key  = settings.STRIPE_SECRET_KEY
        stripe_amount_det = stripe.Charge.create(
			currency="USD",
            customer=cust_id,
            card=card_id,
            amount=total_amount*100,
            description="charge from user",
            shipping={
                    'name': 'Jenny Rosen',
                    'address': {
                        'line1': '510 Townsend St',
                        'postal_code': '98140',
                        'city': 'San Francisco',
                        'state': 'CA',
                        'country': 'US',
                        },
                    },
        )
        print(stripe_amount_det)
        if stripe_amount_det:
            response['status'] = True
            response['data'] = stripe_amount_det
    except Exception as e:
        response['status'] = False
        response['message'] = str(e)
    return response

class renewSubscriptions(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			print("==START==")
			allPlanDatas=[]
			todayExpiry=datetime.now()
			todayExpiry=todayExpiry.date()
			allPlans=currentplan.objects.filter(expiryDate=todayExpiry)
			# allPlans=CompanyPurchase.objects.filter(expiryDate=todayExpiry)

			for plan in allPlans:
				nextPlanAvailable=companypurchase.objects.filter(isUsed=False,companyID=plan.companyID).first()
				if nextPlanAvailable:
					allPlanDatas.append({'planObjectID':plan.id,
										'planID':str(nextPlanAvailable.planID),
										'renewType':'NEW',
										'otherPlanObjectID':str(nextPlanAvailable.id),
										})
					pass
				else:
					if plan.option=='OneTime':
						plan.isActive=False
						plan.isdeleted=True
						plan.save()
						theIDS=plan.myPlan.id
						usedPlan=companypurchase.objects.filter(id=theIDS).first()
						
						usedPlan.isdeleted=True
						usedPlan.isActive=False
						usedPlan.save()
					elif plan.option=='AutoRenew':
						allPlanDatas.append({'planObjectID':plan.id,
											'planID':str(plan.myPlan.planID),
											'renewType':'SAME',
											'otherPlanObjectID':'0',
											})
					else:
						pass
			try:
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/subscriptions/viewPlanListDataForRenew/"
				theToken=str(settings.ADMIN_ACCESS_KEY)
				payload={'AccessKey':theToken,
						'planData':json.dumps(allPlanDatas),
						'userType':'2'}
				apiResponse = requests.request("POST", url, data=payload)
				apiResponse = apiResponse.json()
				print(apiResponse)
				print(apiResponse['data'])
				# print(apiResponse['data']['theReturnPlanData'])
				if apiResponse['status_code']==200:
					for plan in apiResponse['data']:
						try:
							thePlanName=plan['theReturnPlanData']['planName']
							thePlanPrice=plan['theReturnPlanData']['price']
							theDesc=plan['theReturnPlanData']['description']
							theHTMLDesc=plan['theReturnPlanData']['htmlDescription']
							theDays=plan['theReturnPlanData']['planDurationDays']
							theTrialDays=plan['theReturnPlanData']['trialDurationDays']
							theModulesData=apiResponse['data']['moduleData']
							theObject=allPlans.get(id=plan['planObjectID'])

							theCard=companycard.objects.filter(companyID=theObject.companyID,isdefault=True).first()
							if not theCard:
								continue
							thePaymentObject=PaymentWithExistingCard(theCard.theCustomer,theCard.cardID,int(thePlanPrice))
							if thePaymentObject['status'] == True :
								pass
							else:
								continue

							if plan['renewType']=='NEW':
								theNewPlan=companypurchase.objects.filter(id=plan['otherPlanObjectID']).first()
								theNewPlan.isActive=True
								theNewPlan.isUsed=True
								theNewPlan.save()
								theObject.myPlan=theNewPlan
								theObject.option=theNewPlan.option
								hoursInDays=int(theDays)*24
								hoursOfTrial=int(theTrialDays)*24
								startDate=datetime.now()
								startDate=startDate.date()
								expiryDate=startDate+timedelta(hours=hoursInDays)
								theObject.startDate=startDate
								theObject.expiryDate=expiryDate
								theObject.isTrial=False
								theObject.save()
							else:
								if theObject.option=='AutoRenew':
									hoursInDays=int(theDays)*24
									hoursOfTrial=int(theTrialDays)*24
									startDate=datetime.now()
									startDate=startDate.date()
									expiryDate=startDate+timedelta(hours=hoursInDays)
									theObject.startDate=startDate
									theObject.expiryDate=expiryDate
									theObject.isTrial=False
									theObject.save()
							theCompModule=companystats.objects.filter(companyID=idAdmin.userUniqueID).first()
							if not theCompModule:
								theCompModule=companystats.objects.create(companyID=idAdmin.userUniqueID)
							for tmd in theModulesData['data']:
								print("=A=")
								if tmd['name']=='canAddDriver':
									print("=B=")
									if tmd['value']==True:
										print("=C=")
										theCompModule.canAddDriver=True
									else:
										print("=D=")
										theCompModule.canAddDriver=False
									print("=E=")
								print("=F=")
								if tmd['name']=='addDriverLimit':
									theCompModule.driverLimit=str(tmd['value'])
								print("=G=")
								if tmd['name']=='canAddStore':
									if tmd['value']==True:
										theCompModule.canAddStore=True
									else:
										theCompModule.canAddStore=False
								print("=H=")
								if tmd['name']=='addStoreLimit':
									theCompModule.storeLimit=str(tmd['value'])
								print("=I=")
								if tmd['name']=='canAddProducts':
									if tmd['value']==True:
										theCompModule.canAddProducts=True
									else:
										theCompModule.canAddProducts=False
								print("=J=")
								if tmd['name']=='addProductsLimit':
									theCompModule.productLimit=str(tmd['value'])
							theCompModule.save()
						except Exception as e:
							print(e)
							response['status_code']=500
							response['status_message']=str(e)
							return Response(response)
				else:
					response['status_code']=400
					response['status_message']='Not valid plan id'
					return Response(response)
				response['status_code']=200
				response['status_message']='Success'
				return Response(response)
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
			return Response(response)


class deleteSubscriptions(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			if not data.get('planID'):
				response['status_code']=400
				response['status_message']='Plan id required'
				return Response(response)

			session_token = session_token.replace("Token ", "")
			
			idAdmin=company.objects.filter(token=session_token).first()
			if not idAdmin:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			compObj=companypurchase.objects.filter(companyID=idAdmin.userUniqueID,planID=data.get('planID')).first()
			if compObj:
				compObj.isdeleted=True
				compObj.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)


class mySubscriptionDetails(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			
			idAdmin=company.objects.filter(token=session_token).first()
			if not idAdmin:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)

			compObj=companypurchase.objects.filter(companyID=idAdmin.userUniqueID,isdeleted=False).first()
			if compObj:
				compObj.save()
				theData=GetSubData(compObj)
				response['data']=theData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)




# activePlan api by Johan bhatti
# class activePlan(APIView):
# 	def post(self, request, *args, **kwargs):
# 		response = {}
# 		try:
# 			data=request.data
# 			print(data,'######')
# 			session_token = request.META.get('HTTP_AUTHORIZATION')
# 			if not session_token:
# 				if not data.get('session_token'):
# 					response['status_code']=400
# 					response['status_message']='Session token required'
# 					return Response(response)
# 				else:
# 					session_token=data.get('session_token')
# 			else:
# 				session_token = session_token.replace("Token ", "")
# 			idAdmin=company.objects.filter(token=session_token).first()
# 			print(idAdmin.userUniqueID,'admin')
# 			if not idAdmin:
# 				response['status_code']=400
# 				response['status_message']='Invalid token'
# 				return Response(response)

# 			if not data.get('planID'):
# 				response['status_code']=400
# 				response['status_message']='Plan id required'
# 				return Response(response)
# 			compObj=companypurchase.objects.filter(companyID=idAdmin.userUniqueID,planID=data.get('planID'),isUsed=False).first()
# 			print('compobj#######3', compObj)
# 			if compObj:
    				
# 				ifCurrentPlan=currentplan.objects.filter(companyID=idAdmin.userUniqueID).first()
# 				if ifCurrentPlan:
# 					oldPlanId=ifCurrentPlan.planID
# 					oldPlanObject=companypurchase.objects.filter(companyID=idAdmin.userUniqueID,planID=oldPlanId).first()
# 					print('oldplan in company', oldPlanObject)
# 					oldPlanObject.isUsed = True
# 					oldPlanObject.save()
# 					ifCurrentPlan.delete()
# 					# hoursInDays=int(compObj.planDuration)*24
# 					# startDate=datetime.now()
# 					# startDate=startDate.date()
# 					# expiryDate=startDate+timedelta(hours=hoursInDays)
# 					# ifCurrentPlan.myPlan=compObj
# 					# ifCurrentPlan.startDate=startDate
# 					# ifCurrentPlan.expiryDate=expiryDate
# 					# ifCurrentPlan.save()
# 					# compObj.isUsed=True
# 					# compObj.save()
# 					# if oldPlanObject:
# 					# 	oldPlanObject.delete()
# 					currentplan.objects.create(
# 							myPlan = compObj,
# 							companyID = compObj.companyID,
# 							planID = compObj.planID,
# 							startDate = compObj.startDate,
# 							expiryDate = compObj.expiryDate,
# 							option = compObj.option,
# 							isActive = True
							
# 						)	
# 				else:
# 					compObj.isUsed=True
# 					compObj.save()
# 					currentplan.objects.create(
# 						myPlan = compObj,
# 						companyID = compObj.companyID,
# 						planID = compObj.planID,
# 						startDate = compObj.startDate,
# 						expiryDate = compObj.expiryDate,
# 						option = compObj.option,
# 						isActive = True
						
# 					)	
				
# 				theData=GetSubData(compObj)
# 				response['data']=theData.data
# 				response['status_code']=200
# 				response['status_message']='Success'
# 			else:
# 				response['status_code']=404
# 				response['status_message']='Invalid plan !!'
# 		except Exception as e:
# 			print(e)
# 			response['status_code']=500
# 			response['status_message']=str(e)
# 		return Response(response)

# by manpreet singh
# class activePlan(APIView):
# 	def post(self, request, *args, **kwargs):
# 		response={}
# 		try:
# 			data=request.data
# 			session_token = request.META.get('HTTP_AUTHORIZATION')
# 			if not session_token:
# 				if not data.get('session_token'):
# 					response['status_code']=400
# 					response['status_message']='Session token required'
# 					return Response(response)
# 				else:
# 					session_token=data.get('session_token')
# 			else:
# 				session_token = session_token.replace("Token ", "")
			
# 			idAdmin=company.objects.filter(token=session_token).first()
# 			if not idAdmin:
# 				response['status_code']=400
# 				response['status_message']='Invalid token'
# 				return Response(response)

# 			if not data.get('planID'):
# 				response['status_code']=400
# 				response['status_message']='Plan id required'
# 				return Response(response)

# 			currentActive=companypurchase.objects.filter(companyID=idAdmin.userUniqueID,isActive=False).first()
# 			if currentActive:
# 				currentActive.isActive=True
# 				currentActive.isdeleted=True
# 				currentActive.save()
# 			compObj=companypurchase.objects.filter(companyID=idAdmin.userUniqueID,planID=data.get('planID'),isdeleted=False).first()
# 			if compObj:
# 				compObj.isActive=True
# 				compObj.save()
# 				theData=GetSubData(compObj)
# 				response['data']=theData.data
# 			response['status_code']=200
# 			response['status_message']='Success'
# 		except Exception as e:
# 			print(e)
# 			response['status_code']=400
# 			response['status_message']=str(e)
# 		return Response(response)

#by manpreet singh
class activePlan(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			idAdmin=company.objects.filter(token=session_token).first()
			print('idAdmin====',idAdmin)
			if not idAdmin:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)

			if not data.get('planID'):
				response['status_code']=400
				response['status_message']='Plan id required'
				return Response(response)
			compObj=companypurchase.objects.filter(companyID=idAdmin.userUniqueID,planID=data.get('planID'),isUsed=False).first()
			# compObj=companypurchase.objects.filter(companyID=idAdmin.userUniqueID,planID=data.get('planID'),isUsed=True).first()
			print('compObj===',compObj)
			if compObj:
				ifCurrentPlan=currentplan.objects.filter(companyID=idAdmin.userUniqueID).first()
				print('ifCurrentPlan=====',ifCurrentPlan)
				if ifCurrentPlan:
					oldPlanId=ifCurrentPlan.myPlan.id
					print('oldPlanId==',oldPlanId)
					# oldPlanObject=companypurchase.objects.filter(companyID=idAdmin.userUniqueID,planID=oldPlanId).first()
					oldPlanObject=companypurchase.objects.filter(companyID=idAdmin.userUniqueID).first()
					print('oldPlanObject===',oldPlanObject)
					# hoursInDays=int(compObj.planDuration)*24
					# print('hoursInDays====',hoursInDays)
					startDate=datetime.now()
					startDate=startDate.date()
					# expiryDate=startDate+timedelta(hours=hoursInDays)
					ifCurrentPlan.myPlan=compObj
					ifCurrentPlan.startDate=startDate
					# ifCurrentPlan.expiryDate=expiryDate
					ifCurrentPlan.save()
					compObj.isUsed=True
					compObj.save()
					if oldPlanObject:
						oldPlanObject.delete()
				compObj.isActive=True
				compObj.save()
				theData=GetSubData(compObj)
				response['data']=theData.data
			response['status_code']=200
			response['status_message']='Success Activate Plan'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class myPurchasedPlanList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			idAdmin=company.objects.filter(token=session_token).first()
			if not idAdmin:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)


			allPlans=companypurchase.objects.filter(companyID=idAdmin.userUniqueID,isdeleted=False)
			if allPlans:
				theData=GetSubData(allPlans,many=True)
				response['data']=theData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class hasSubscriptions(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			idAdmin=company.objects.filter(token=session_token).first()
			if not idAdmin:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)


			havePlan=companypurchase.objects.filter(companyID=idAdmin.userUniqueID,isActive=True).first()
			if havePlan:
				theData=GetSubData(havePlan)
				response['data']=theData.data
				response['hasAccess']=True
			else:
				response['hasAccess']=False
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getCompanyModulesForLimit(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData=[]
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if data.get('AccessKey')!=(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if not data.get('companyID'):
				response['status_code']=400
				response['status_message']='companyID required'
				return Response(response)
			theCompModule=companystats.objects.filter(companyID=data.get('companyID')).first()
			if theCompModule:
				allData.append({'canAddDriver':str(theCompModule.canAddDriver),
				                'driverLimit':theCompModule.driverLimit,
								'canAddStore':str(theCompModule.canAddStore),
								'storeLimit':theCompModule.storeLimit,
								'canAddProducts':str(theCompModule.canAddProducts),
								'productLimit':theCompModule.productLimit,})
				response['data']=allData
				response['status_code']=200
				response['status_message']='Success'
			else:
				response['status_code']=404
				response['status_message']='No data found'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)