from django.db import models
import random  
import string
from django.contrib.auth.models import User
# Create your models here.
from django.contrib.auth.models import AbstractUser
from django.utils.translation import gettext as _

RISK = (
    ('1', "Green"),
    ('2', "Yellow"),
    ('3', "Red"),
)

class Customer(models.Model):
	"""
	This model is used to store the information of Customer.
	"""
	userTableID = models.CharField(max_length = 50, null = True, blank = True)
	userUniqueID = models.CharField(max_length = 50, null = True, blank = True,default = '')
	userToken = models.CharField(max_length = 50, null = True, blank = True,default = '')
	customerStripeId = models.CharField(max_length = 50, null = True, blank = True,default = '')
	risk = models.CharField(max_length = 50,choices = RISK,default = '3')
	name = models.CharField(max_length = 50, null = True, blank = True,default = '')
	email = models.CharField(max_length = 50, unique = True, null = True, blank = True,default = '')
	countrycode = models.CharField(max_length = 50, null = True, blank = True,default = '')
	phone = models.CharField(max_length = 50, blank = True, null = True,default = '')
	image = models.FileField(upload_to='Profile', blank = True, null = True,default = '')
	state = models.CharField(max_length = 20, blank = True, null = True,default = '')
	age = models.CharField(max_length = 20, blank = True, null = True,default = '')
	dob = models.DateField(max_length=25,blank=True,null=True)
	fcmtoken = models.CharField(max_length = 300, blank = True, null = True,default = '')
	signupOtp = models.CharField(max_length = 100, blank = True, null = True)
	signupOtpVerfied = models.BooleanField(default = False)
	emailverificationlink = models.CharField(max_length = 300, blank = True, null = True)
	emailverified = models.BooleanField(default = False)
	phoneVerifiedOtp = models.CharField(max_length = 100, blank = True, null = True)
	phoneverified = models.BooleanField(default = False)
	socialId = models.CharField(max_length = 300, blank = True, null = True,default = '')
	deviceId = models.CharField(max_length = 300, blank = True, null = True,default = '')
	deviceType = models.CharField(max_length = 300, blank = True, null = True,default = '')
	registerType = models.CharField(max_length = 300, blank = True, null = True,default = '')
	userReferalCode = models.CharField(max_length = 300, blank = True, null = True,default = '')
	referalByCode = models.CharField(max_length = 300, blank = True, null = True,default = '')
	forgotPasswordOTP = models.CharField(max_length=100,blank=True,null=True)
	isNotificationSoundOn = models.BooleanField(default = True)
	isNotificationOn = models.BooleanField(default = True)
	accountverified = models.BooleanField(default = False)
	accountapproved = models.BooleanField(default = False)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.name)+'--'+str(self.userUniqueID))


DOC_TYPES = (
    ('1', "Passport"),
    ('2', "Licence"),
    ('3', "National ID"),
    ('4', "Age Proof"),
    ('5', "Other"),
)

DOC_STATUS = (
    ('1', "Pending"),
    ('2', "Accepted"),
    ('3', "Rejected"),
)

class CustomerDocuments(models.Model):
	doctType = models.CharField(max_length = 20,choices = DOC_TYPES,default = '5')
	userTableID = models.CharField(max_length = 20, null = True, blank = True)
	userUniqueID = models.CharField(max_length = 20, null = True, blank = True,default = '')
	document = models.FileField(upload_to ='Documents', null=True ,blank=True,default = '')
	theStatus=models.CharField(max_length = 20,choices = DOC_STATUS,default = '1')
	rejectMessage = models.TextField(null = True, blank = True)
	isApproved = models.BooleanField(default = False)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.userUniqueID)+' - '+str(self.doctType))

class SuperadminAccess(models.Model):
	theID = models.CharField(max_length = 20,null = True, blank = True,default='1')
	AccessKey = models.CharField(max_length = 75, null = True, blank = True,default='')
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.AccessKey))

class CustomerAddress(models.Model):
	customerID = models.CharField(max_length = 50, null = True, blank = True,default = '')
	address = models.TextField(null = True, blank = True)
	latitude = models.CharField(max_length = 50, null = True, blank = True,default = '')
	longitude = models.CharField(max_length = 50, null = True, blank = True,default = '')
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.customerID))

class CustomerCard(models.Model):
	customerID = models.CharField(max_length = 50, null = True, blank = True,default = '')
	cardID = models.CharField(max_length = 50, null = True, blank = True,default = '')
	expMonth = models.CharField(max_length = 50, null = True, blank = True,default = '')
	expYear = models.CharField(max_length = 50, null = True, blank = True,default = '')
	theCustomer=models.CharField(max_length = 50, null = True, blank = True,default = '')
	lastDigit=models.CharField(max_length = 50, null = True, blank = True,default = '')
	isdefault = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.customerID)+'-'+str(self.cardID))

class notifications(models.Model):
	customerID = models.CharField(max_length = 50, null = True, blank = True,default = '')
	image = models.CharField(max_length = 200, null = True, blank = True,default = '')
	title = models.CharField(max_length = 50, null = True, blank = True,default = '')
	description = models.TextField(null = True, blank = True)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.customerID)+'-'+str(self.title))