from rest_framework import serializers
from .models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from django.conf import settings
from subscriptions.models import *

class GetCustomerData(serializers.ModelSerializer):
	documents=serializers.SerializerMethodField(source='get_documents')
	isDocumentsUploded = serializers.SerializerMethodField(source='get_isDocumentsUploded')
	isProfileUpdated = serializers.SerializerMethodField(source='get_isProfileUpdated')
	token =  serializers.SerializerMethodField(source='get_token')
	image =  serializers.SerializerMethodField(source='get_image')
	dob =  serializers.SerializerMethodField(source='get_dob')

	currencySymbol =  serializers.SerializerMethodField(source='get_currencySymbol')
	currencyCode =  serializers.SerializerMethodField(source='get_currencyCode')
	hasActiveSubscription =  serializers.SerializerMethodField(source='get_hasActiveSubscription')
	subscriptionStatus =  serializers.SerializerMethodField(source='get_subscriptionStatus')
	
	class Meta:
		model = Customer
		fields = ['isDocumentsUploded','isProfileUpdated','state','age','dob','subscriptionStatus','token','userUniqueID','risk','name', 'email','phone','countrycode','socialId','image','phoneverified','userReferalCode','isNotificationSoundOn','isNotificationOn','currencySymbol','currencyCode','hasActiveSubscription','documents']

	# def get_image(self, obj):
	#     return str(settings.WEB_BASE_URL)+str(obj.image.name)
	

	def get_image(self, obj):
		if obj.image.name:
			return str(obj.image.name)
		else:
			return ''
	
	def get_dob(self, obj):
		if not obj.dob:
			return ''
		else:
			return obj.dob

	def get_token(self, obj):
		userObject=User.objects.filter(id=obj.userTableID).first()
		token,status = Token.objects.get_or_create(user = userObject)
		tokenKey=token.key
		return tokenKey
	
	def get_isDocumentsUploded(self, obj):
		docExisted=False
		theDocuments=CustomerDocuments.objects.filter(userUniqueID=obj.userUniqueID).count()
		if theDocuments>=4:
			docExisted=True
		return docExisted
	
	def get_isProfileUpdated(self, obj):
		profileUpdated=True
		if obj.age=='':
			profileUpdated=False
		if not obj.dob:
			profileUpdated=False
		if obj.phone=='':
			profileUpdated=False
		if obj.state=='':
			profileUpdated=False
		return profileUpdated
	
	def get_currencySymbol(self, obj):
		return '$'
	
	def get_currencyCode(self, obj):
		return 'USD'
	
	def get_hasActiveSubscription(self, obj):
		hasPlan=CustomerPurchase.objects.filter(customerID=obj.userUniqueID,isActive=True).first()
		if hasPlan:
			hasActiveSubscription=True
		else:
			hasActiveSubscription=False
		return hasActiveSubscription
	
	def get_subscriptionStatus(self, obj):
		try:
			currentPlanObject=currentPlan.objects.filter(customerID=obj.userUniqueID).first()
			if currentPlanObject:
				if currentPlanObject.option=='AutoRenew':
					subscriptionStatus='True'
				else:
					subscriptionStatus='False'
			else:
				subscriptionStatus=''
		except Exception as e:
			print(e)
			subscriptionStatus=''
		return subscriptionStatus
	
	def get_documents(self,obj):
		data=[]
		theDoc=CustomerDocuments.objects.filter(userUniqueID=obj.userUniqueID)
		for doc in theDoc:
			theDocName=str(doc.document.name)
			theDocType=''
			if doc.doctType=='1':
				theDocType='Passport'
			elif doc.doctType=='2':
				theDocType='Licence'
			elif doc.doctType=='3':
				theDocType='National ID'
			elif doc.doctType=='4':
				theDocType='Age Proof'
			else:
				theDocType='Other'

			data.append({'documents':theDocName,
						 'theDocType':theDocType,
						 'status':doc.theStatus,
						 'id':doc.id,})
		return data

class GetCustomerDataNew(serializers.ModelSerializer):
	image =  serializers.SerializerMethodField(source='get_image')
	class Meta:
		model = Customer
		fields = ['userToken','userUniqueID','risk','name', 'email','phone','countrycode','socialId','image','phoneverified','userReferalCode','isNotificationSoundOn','isNotificationOn']

	# def get_image(self, obj):
	#     return str(settings.WEB_BASE_URL)+str(obj.image.name)

	def get_image(self, obj):
		return str(obj.image.name)

class GetCustomerDataForOthers(serializers.ModelSerializer):
	image =  serializers.SerializerMethodField(source='get_image')
	class Meta:
		model = Customer
		fields = ['userUniqueID','risk','name', 'email','phone','countrycode','socialId','image','phoneverified','userReferalCode','isNotificationSoundOn','isNotificationOn']
	
	# def get_image(self, obj):
	#     return str(settings.WEB_BASE_URL)+str(obj.image.name)

	def get_image(self, obj):
		return str(obj.image.name)
		
class UserSerializer(serializers.ModelSerializer):
	class Meta:
		model = User
		fields = '__all__'

	def create(self, validated_data):
		print("validated_data===========================>" , validated_data)
		user = User.objects.create(
			username=validated_data['username'],)
		if user:
			user.set_password(validated_data['password'])
			user.save()
		return user