from django.contrib import admin
from django.urls import path
from django.conf.urls import url, include
from django.views.static import serve
from django.conf import settings
from django.conf.urls import handler400, handler403, handler404, handler500
from .views import *
from . import views
urlpatterns = [
   url(r'^$',Index, name='index'),
   path('getStateList/', getStateList.as_view(), name = 'getStateList'),
   path('checkExistence/', checkExistence.as_view(), name = 'checkExistence'),
   path('register/', registerCustomer.as_view(), name = 'registerCustomer'),
   path('veifySignupOTP/', veifySignupOTP.as_view(), name = 'veifySignupOTP'),
   path('login/', loginCustomer.as_view(), name = 'loginCustomer'),
   url(r'^forgotPassword/$', forgotPassword.as_view(), name='forgotPassword'),
   url(r'^forgotPasswordVerifyOtp/$', forgotPasswordVerifyOtp.as_view(), name='forgotPasswordVerifyOtp'),

   url(r'^updatePassword/$', updatePassword.as_view(), name='updatePassword'),
   path('changePassword/', ChangePassword.as_view(), name = 'ChangePassword'),
   url(r'^resendSignupOTP/$', resendSignupOTP.as_view(), name='resendSignupOTP'),
   url(r'^verifPhoneWithOTP/$', verifPhoneWithOTP.as_view(), name='verifPhoneWithOTP'),
   path('socialLogin/', socialLogin.as_view(), name = 'socialLogin'),
   url(r'^getProfile/$', getProfile.as_view(), name='getProfile'),
   url(r'^updateProfile/$', updateProfile.as_view(), name='updateProfile'),
   url(r'^logout/$', logout.as_view(), name='logout'),
   url(r'^getDocuments/$', getDocuments.as_view(), name='getDocuments'),
   url(r'^updateDocuments/$', updateDocuments.as_view(), name='updateDocuments'),

   path('requestAdmin/', requestAdmin.as_view(), name = 'getSettings'),
   path('getSettings/', getSettings.as_view(), name = 'getSettings'),
   path('deactivateAccount/', deactivateAccount.as_view(), name = 'deactivateAccount'),
   path('notificationSoundStatus/', notificationSoundStatus.as_view(), name = 'notificationSoundStatus'),
   path('notificationStatus/', notificationStatus.as_view(), name = 'notificationStatus'),

   # Notifications
   url(r'^getNotifications/$', getNotifications.as_view(), name='getNotifications'),
   url(r'^deleteNotification/$', deleteNotification.as_view(), name='deleteNotification'),
   # url(r'^deleteNotificationList/$', deleteNotificationList.as_view(), name='deleteNotificationList'),
   # url(r'^filterNotifications/$', filterNotifications.as_view(), name='filterNotifications'),

   path('gernateTwilioToken/',gernateTwilioToken.as_view()),

]
