from django.http import response
from rest_framework.views import APIView
from django.contrib.auth.models import User
from django.contrib.auth import authenticate
from rest_framework.authtoken.models import Token
from .models import *
import math, random, datetime, pytz, string
from django.conf import settings
import requests, json
from pyfcm import FCMNotification
from django.contrib.auth.hashers import make_password
from django.db.models import Q
from .serializers import *
from rest_framework.response import Response
from django.template.loader import render_to_string
from django.core.mail import EmailMessage
from django.core.files.storage import FileSystemStorage
from datetime import datetime
import stripe
from subscriptions.models import *

import boto3
import boto
import boto.exception
import boto.sns
import pprint
import re
import json

def notifyAdmin(body,ntype,notifyCheckType,title,theUserID):
	import requests
	url=str(settings.ADMIN_ACCESS_URL)+'superadmin/auth/adminNotify/'
	# url = "http://18.117.53.164:8001/superadmin/auth/adminNotify/"
	payload={'body':str(body),
	'title':str(title),
	'userID':str(theUserID),
	'userType':'Customer',
	'notifyCheckType':notifyCheckType,
	'type':str(ntype)}
	response = requests.request("POST", url ,data=payload)
	print(response.text)

def Index(request):
	return HttpResponse("<h4>CustomerBasicDetails</h4>")

def referralCode():
	try:
		Referal=''
		digits2 = "rba2cqq4skyhz7meizjk"
		for i in range(8): 
		  Referal += digits2[math.floor(random.random() * 15)]
		print(Referal)
	except Exception as e:
		print(e)
	return str(Referal)

def GernateOTP():
	'''Function for gernate otp'''
	digits = "0123456789"
	OTP = ""
	for i in range(4) :
		OTP += digits[math.floor(random.random() * 10)]
	return OTP

def randomStringFunction():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(8)))
	str1 += ''.join((random.choice(string.digits) for x in range(4)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

def randomStringFunctionForImage():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(8)))
	str1 += ''.join((random.choice(string.digits) for x in range(4)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

# def uploadDocumentImagesOLD(image,thePath):
# 	import os
# 	try:
# 		fullPath='media/'+str(thePath)+'/'
# 		fs = FileSystemStorage(location=fullPath)
# 		beforename = os.path.splitext(image.name)[0]
# 		beforename=beforename.replace(' ','')
# 		filetype = os.path.splitext(image.name)[1]
# 		theName=randomStringFunctionForImage()
# 		theImageName=str(theName)+str(filetype)
# 		filename = fs.save(theImageName, image)
# 		# filename = fs.url(filename)
# 		return str(fullPath)+filename
# 	except Exception as e:
# 		print(e)
# 		return ''

def uploadDocumentImages(image,bucket,thePath):
	import os
	import boto3
	from botocore.exceptions import NoCredentialsError
	try:
		ACCESS_KEY=str(settings.AWS_ACCESS_KEY_ID)
		SECRET_KEY=str(settings.AWS_SECRET_ACCESS_KEY)
		s3 = boto3.client('s3', aws_access_key_id=ACCESS_KEY,
                      aws_secret_access_key=SECRET_KEY)
		try:
			filetype = os.path.splitext(image.name)[1]
			print("==================================filetype===========",filetype)
			print(image)
			imageName=randomStringFunctionForImage()
			thePath=thePath+'/'+imageName+str(filetype)
			thePath=str(thePath)
			theFile=s3.upload_fileobj(image,bucket,thePath)
			print("Upload Successful")
			filename=str(settings.AWS_BUCKET_URL_1)+str(bucket)+str(settings.AWS_BUCKET_URL_2)+thePath
			return filename
		except FileNotFoundError as e:
			print("The file was not found")
			return ''
		except NoCredentialsError:
			print("Credentials not available")
			return ''
	except Exception as e:
		print(e)
		return ''

def getStateListFunction():
	try:
		allStatesData=[]
		response={}
		url = str(settings.ADMIN_ACCESS_URL)+"superadmin/setting/getStatesForOthers/"
		headers = {
		'Authorization': 'Token '+str(settings.ADMIN_ACCESS_KEY)+'',
		}
		r = requests.request("POST", url, headers=headers)
		
		r=r.json()
		# print("the response of states",r)
		print(r)
		print(r['data'])
		for st in r['data']:
			allStatesData.append({'stateName':st['state'],
								  'stateFullAddress':st['fulladdress'],
								  'minimumAge':st['minimumage']})
		print(allStatesData)
		response['status_code']=200
		response['data']=allStatesData
		response['status_message']='All Data'
		# response['status_message']=str(e)
		return response
	except Exception as e:
		response['status_code']=500
		response['status_message']=str(e)
		return response

class getStateList(APIView):
	def get(self, request):
		# response={}
		# try:
		#     url = str(settings.ADMIN_ACCESS_URL)+"superadmin/setting/getStates/"
		#     headers = {
		#     'Authorization': 'Token '+str(settings.ADMIN_ACCESS_KEY)+'',
		#     }
		#     r = requests.request("POST", url, headers=headers)
		#     print(r)
		#     return Response(r.json())
		# except Exception as e:
		#     response['status_code']=500
		#     response['status_message']=str(e)
		#     return Response(response)
		return Response(getStateListFunction())

class checkExistence(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data = request.data

			if data.get('socialId'):
				if not data.get('email'):
					response['status_code']=400
					response['status_message']='Email required'
					return Response(response)
				if not data.get('deviceType'):
					response['status_code']=400
					response['status_message']='Device type required'
					return Response(response)
				if not data.get('fcmtoken'):
					response['status_code']=400
					response['status_message']='FCM token required'
					return Response(response)
				if not data.get('registerType'):
					response['status_code']=400
					response['status_message']='Register type required'
					return Response(response)
				if not data.get('name'):
					response['status_code']=400
					response['status_message']='name required'
					return Response(response)
				customerObj=Customer.objects.filter(socialId = data.get('socialId')).first()
				if customerObj:
					theUser=User.objects.filter(id=customerObj.userTableID)
					theUser=theUser[0]
					token = Token.objects.filter(user = theUser).first()
					if token:
						theUser.auth_token.delete()
					theCustomerSerial = GetCustomerData(customerObj)
					customerObj.userToken = theCustomerSerial.data['token']
					customerObj.fcmtoken = data.get('fcmtoken')
					customerObj.deviceType = data.get('deviceType')
					customerObj.save()
					response['status_code']=200
					response['isExist']=True
					response['status_message']='Success'
					response['data']=theCustomerSerial.data
					return Response(response)
				else:
					digits = "zm1Sc3gK71C9laHpq"
					passCode = ""
					for i in range(15) :
						passCode += digits[math.floor(random.random() * 10)]
					print("created")
					User.objects.create_user(username = data.get('email'), email = data.get('email'), password = passCode)
					print("logging in")
					userObj = authenticate(username = data.get('email'), password = passCode)
					print("log in success")
					userObjId=userObj.id
					print("get id")
					print(userObjId)
					beforeNameOfUser=data.get('name')
					beforeNameOfUser=beforeNameOfUser.replace(' ','')
					name3Letter=beforeNameOfUser[0:3]
					name3Letter=name3Letter.upper()
					latExt=Customer.objects.all().last()
					if latExt:
						lastId=latExt.userUniqueID
						last5Number=lastId[3:]
						last5Number=int(last5Number)
						new5Number=last5Number+1
						new5Number=str(new5Number)
						new5Number = new5Number.zfill(5)
						theUniqueID=str(name3Letter)+str(new5Number)
					else:
						theUniqueID=str(name3Letter)+str('00001')
					customerObj = Customer.objects.create(userUniqueID=theUniqueID,userTableID = userObjId, name = data.get('name'), email = data.get('email'),socialId=data.get('socialId'),deviceType=data.get('deviceType'),registerType=data.get('registerType'),fcmtoken=data.get('fcmtoken'),signupOtpVerfied=True,accountverified=True,emailverified=True)
					token = Token.objects.filter(user = userObj).first()
					if token:
						userObj.auth_token.delete()
					response['status_code']=200
					response['isExist']=False
					response['status_message']='Success'
					theCustomerSerial = GetCustomerData(customerObj)
					customerObj.userToken = theCustomerSerial.data['token']
					customerObj.save()
					response['data']=theCustomerSerial.data
					return Response(response)

			else:
				if not data.get('email'):
					response['status_code']=400
					response['status_message']='Email required'
					return Response(response)
				if not data.get('phone'):
					response['status_code']=400
					response['status_message']='Phone required'
					return Response(response)
				if not data.get('countrycode'):
					response['status_code']=400
					response['status_message']='Country code required'
					return Response(response)
				
				userOBj = User.objects.filter(username = data.get('email')).first()
				if userOBj:
					response['status_code']=400
					response['status_message']='Email already exists.'
					return Response(response)
				phoneExist=Customer.objects.filter(phone = data.get('phone'))
				if phoneExist:
					response['status_code']=400
					response['status_message']='Phone number already exists.'
					return Response(response)
				response['status_code']=200
				response['status_message']='Success'
				return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
		return Response(response)

def createCustomerOnStripe():
	customerStripeID = ""
	try:
		stripe.api_key  = settings.STRIPE_SECRET_KEY
		createStripeCusObject = stripe.Customer.create(description="Customer for stripe card")
		# create_cus = json.loads(create_cus)
		if createStripeCusObject:
			customerStripeID = createStripeCusObject['id']
	except Exception as e:
		print("Exception",e)
	return customerStripeID

# For future use
def sendTemplateMail():
	import boto3
	ses = boto3.client('ses')
	response = ses.send_templated_email(
		Source='EMAIL_ADDRESS',
		Destination={
			'ToAddresses': [
			'EMAIL_ADDRESS',
			],
			'CcAddresses': [
			'EMAIL_ADDRESS',
			]
		},
		ReplyToAddresses=[
			'EMAIL_ADDRESS',
		],
		Template='TEMPLATE_NAME',
		TemplateData='{ \"REPLACEMENT_TAG_NAME\":\"REPLACEMENT_VALUE\" }'
		)
	print(response)

def sendCustomMail(recList,theMessage):
	region = [r for r in boto.sns.regions() if r.name==u'us-east-1'][0]
	client = boto3.client('ses',
        aws_access_key_id=str(settings.AWS_ACCESS_KEY_ID),
        aws_secret_access_key=str(settings.AWS_SECRET_ACCESS_KEY),
        region_name='us-east-2',
    )
	# client = boto3.client('ses')
	response = client.send_email(
		Destination={
			'ToAddresses': ['developeresfera@yopmail.com'],
		},
		Message={
			'Body': {
				'Html': {
					'Charset': 'UTF-8',
					'Data': theMessage,
				},
				'Text': {
					'Charset': 'UTF-8',
					'Data': 'This is for those who cannot read HTML.',
				},
			},
			'Subject': {
				'Charset': 'UTF-8',
				'Data': 'Hello World',
			},
		},
		Source=str(settings.EMAIL_HOST_EMAIL),
	)
	print(response)

class registerCustomer(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			refrence=''
			data = request.data
			print("first")
			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)
			if not data.get('name'):
				response['status_code']=400
				response['status_message']='Name required'
				return Response(response)
			if not data.get('phone'):
				response['status_code']=400
				response['status_message']='Phone required'
				return Response(response)
			if not data.get('countrycode'):
				response['status_code']=400
				response['status_message']='Country code required'
				return Response(response)
			if not data.get('password'):
				response['status_code']=400
				response['status_message']='Password required'
				return Response(response)
			if not data.get('state'):
				response['status_code']=400
				response['status_message']='State required'
				return Response(response)
			if not data.get('age'):
				response['status_code']=400
				response['status_message']='Age required'
				return Response(response)
			print("secons")
			if not data.get('dob'):
				response['status_code']=400
				response['status_message']='D.O.B required'
				return Response(response)
			if not request.FILES.get('passportImage'):
				response['status_code']=400
				response['status_message']='Passport image required'
				return Response(response)
			if not request.FILES.get('licenceImage'):
				response['status_code']=400
				response['status_message']='Licence image required'
				return Response(response)
			if not request.FILES.get('nationalID'):
				response['status_code']=400
				response['status_message']='National id required'
				return Response(response)
			if not request.FILES.get('ageProof'):
				response['status_code']=400
				response['status_message']='Age proof required'
				return Response(response)
			
			print("third")

			if data.get('referalByCode'):
				refrence=data.get('referalByCode')
				checkRefrence=Customer.objects.filter(userReferalCode=data.get('referalByCode'))
				if not checkRefrence:
					response['status_code']=400
					response['status_message']='Not a valid referral Code'
					return Response(response)
			userOBj = User.objects.filter(username = data.get('email')).first()
			if userOBj:
				response['status_code']=400
				response['status_message']='Email already exists.'
				return Response(response)
			phoneExist=Customer.objects.filter(phone = data.get('phone'))
			if phoneExist:
				response['status_code']=400
				response['status_message']='Phone number already exists.'
				return Response(response)
			else:
				userOBj = User.objects.create_user(username = data.get('email'), password = data.get('password'))
				otp=GernateOTP()
				userObjId=userOBj.id
				# theUniqueID=randomStringFunction()


				beforeNameOfUser=data.get('name')
				name3Letter=beforeNameOfUser[0:3]
				name3Letter=name3Letter.upper()
				latExt=Customer.objects.all().last()
				if latExt:
					lastId=latExt.userUniqueID
					last5Number=lastId[3:]
					last5Number=int(last5Number)
					new5Number=last5Number+1
					new5Number=str(new5Number)
					new5Number = new5Number.zfill(5)
					theUniqueID=str(name3Letter)+str(new5Number)
				else:
					theUniqueID=str(name3Letter)+str('00001')

				print("before customer")

				customerObj = Customer.objects.create(state=data.get('state'),age=data.get('age'),userUniqueID=theUniqueID,userTableID=userObjId, name = data.get('name'), email = data.get('email'), countrycode = data.get('countrycode'), phone = data.get('phone'), signupOtp = otp,registerType='Normal',userReferalCode=referralCode(),referalByCode=refrence)
				try:
					dat=data.get('dob')
					dateOfBirth=datetime.strptime(dat, "%Y/%m/%d")
					dateOfBirth=dateOfBirth.date()
					if customerObj:
						customerObj.dob=dateOfBirth
						customerObj.save()
				except Exception as e:
					print(e)
					response['status_code']=500
					response['status_message']=str(e)
					return Response(response)
					
				
			print("fourth")
			passportImage=request.FILES.get('passportImage')
			if passportImage:
				filename=uploadDocumentImages(passportImage,'cannabiscustomer','documents')
				ownerDocs=CustomerDocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='1')
			licenceImage=request.FILES.get('licenceImage')
			if licenceImage:
				filename=uploadDocumentImages(licenceImage,'cannabiscustomer','documents')
				ownerDocs=CustomerDocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='2')
			nationalID=request.FILES.get('nationalID')
			if nationalID:
				filename=uploadDocumentImages(nationalID,'cannabiscustomer','documents')
				ownerDocs=CustomerDocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='3')
			registrationProof=request.FILES.get('ageProof')
			if registrationProof:
				filename=uploadDocumentImages(registrationProof,'cannabiscustomer','documents')
				ownerDocs=CustomerDocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='4')
			theDocuments = request.FILES.getlist("documents")
			if theDocuments:
				for count, image in enumerate(theDocuments):
					filename=uploadDocumentImages(image,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='5')
			try:
				theList=[]
				theList.append(data.get('email'))
				message='<p>Hello '+str(data.get('name'))+', here is your signup otp:-'+str(otp)+' </p>'
				# sendCustomMail(theList,message)
				subject='Signup OTP'
				message = render_to_string('sendSignupOTPMail.html', {
					'otp': otp,
					'name':data.get('name'),
					})
				fromEmail = settings.EMAIL_HOST_USER
				toEmail = data.get('email')
				message = EmailMessage(subject, message, fromEmail, [toEmail])
				message.content_subtype = 'html'
				message.send()
			except Exception as e:
				print(e)
			theStripeCusId=createCustomerOnStripe()
			customerObj.customerStripeId=theStripeCusId
			customerObj.save()    
			response['status_code']=200
			response['otp']=otp
			response['status_message']='OTP has been sent on you registered email successfully.'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
		return Response(response)

class veifySignupOTP(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		data=request.data
		try:
			if not data.get('otp'):
				response['status_code']=400
				response['status_message']='OTP required'
				return Response(response)
			if not data.get('email'):
				if not data.get('phone'):
					response['status_code']=400
					response['status_message']='Email or Phone required.'
					return Response(response)
				else:
					if not data.get('countrycode'):
						response['status_code']=400
						response['status_message']='Country code required'
						return Response(response)
					customerVerify = Customer.objects.filter(phone = data.get('phone'), signupOtpVerfied = False,accountverified=False,countrycode=data.get('countrycode'),signupOtp=data.get('otp')).first()
			else:
				customerVerify = Customer.objects.filter(email = data.get('email'), signupOtpVerfied = False,accountverified=False,signupOtp=data.get('otp')).first()
			if not customerVerify:
				response['status_code']=400
				response['status_message']='OTP not matched.'
			else:
				theCustomerSerial = GetCustomerData(customerVerify)
				customerVerify.userToken = theCustomerSerial.data['token']
				customerVerify.signupOtpVerfied=True
				customerVerify.accountverified=True
				customerVerify.phoneverified=True

				customerVerify.save()
				theCustomerSerial = GetCustomerData(customerVerify)
				response['status_code']=200
				response['status_message']='Success.'
				response['data']=theCustomerSerial.data
				try:
					subject='Welcome'
					message = render_to_string('sendWelcomeMail.html', {
						'name': customerVerify.name,
						'email':customerVerify.email,
						'phone':customerVerify.phone,
						})
					fromEmail = settings.EMAIL_HOST_USER
					toEmail = data.get('email')
					message = EmailMessage(subject, message, fromEmail, [toEmail])
					message.content_subtype = 'html'
					message.send()
				except Exception as e:
					print(e)
				adminBodySend='New customer '+str(customerVerify.name)+' has been register'
				adminTypeSend='push'
				adminTitleSend='New Customer'
				adminUserID=customerVerify.userUniqueID
				notifyAdmin(adminBodySend,adminTypeSend,'new_customer',adminTitleSend,adminUserID)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
		return Response(response)

class loginCustomer(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)

			if not data.get('password'):
				response['status_code']=400
				response['status_message']='Password required'
				return Response(response)

			# if not data.get('fcmtoken'):
				# response['status_code']=400
				# response['status_message']='FCM token required'
				# return Response(response)

			if not data.get('deviceType'):
				response['status_code']=400
				response['status_message']='Device type required'
				return Response(response)

			user = authenticate(username = data.get('email'), password = data.get('password'))
			if not user:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			customerObj=Customer.objects.filter(userTableID=user.id).first()
			print(customerObj)
			if not customerObj:
				response['isDisable']=False
				response['isPhoneVerified']=True
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			if customerObj.signupOtpVerfied == False and customerObj.accountverified==False:
				otp=GernateOTP()
				customerObj.signupOtp=otp
				customerObj.phoneVerifiedOtp=otp
				customerObj.save()
				theCustomerSerial = GetCustomerData(customerObj)
				response['data']=theCustomerSerial.data
				response['status_code']=200
				response['status_message']='Please verify your account first.'
				response['isPhoneVerified']=False
				response['isDisable']=False
				try:
					theList=[]
					theList.append(data.get('email'))
					message='<p>Hello '+str(customerObj.name)+', here is your signup otp:-'+str(otp)+' </p>'
					# sendCustomMail(theList,message)
					subject='Verification'
					message = render_to_string('sendSignupOTPMail.html', {
						'otp': otp,
						'name':customerObj.name,
						})
					fromEmail = settings.EMAIL_HOST_USER
					toEmail = data.get('email')
					message = EmailMessage(subject, message, fromEmail, [toEmail])
					message.content_subtype = 'html'
					message.send()
				except Exception as e:
					print(e)
				return Response(response)
			if customerObj.isdisabled:
				response['customerID']=customerObj.userUniqueID
				response['isDisable']=True
				response['status_code']=400
				response['isPhoneVerified']=True
				response['status_message']='Your account has not been activated, Please contact to admin.'
				return Response(response)
			print(customerObj)
			theCustomerSerial = GetCustomerData(customerObj)
			print(theCustomerSerial.data)
			print(theCustomerSerial.data['token'])
			if not customerObj.customerStripeId:
				theStripeCusId=createCustomerOnStripe()
				customerObj.customerStripeId=theStripeCusId
			customerObj.userToken = theCustomerSerial.data['token']
			if not data.get('fcmtoken'):
				customerObj.fcmtoken = ''
			else:
				customerObj.fcmtoken = data.get('fcmtoken')
			customerObj.deviceType = data.get('deviceType')
			customerObj.save()
			response['isPhoneVerified']=True
			response['isDisable']=False
			response['status_code']=200
			response['status_message']='Success'
			response['data']=theCustomerSerial.data
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class forgotPassword(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('email'):
				if not data.get('phone'):
					response['status_code']=400
					response['status_message']='Email or Phone required.'
					return Response(response)
				else:
					if not data.get('countrycode'):
						response['status_code']=400
						response['status_message']='Country code required'
						return Response(response)
					customerObj = Customer.objects.filter(phone = data.get('phone'),countrycode=data.get('countrycode')).first()
			else:
				customerObj = Customer.objects.filter(email = data.get('email')).first()
				
			if not customerObj:
				response['status_code']=400
				response['status_message']='Customer not exist.'
			else:
				OTP=GernateOTP()
				customerObj.forgotPasswordOTP=OTP
				customerObj.save()
				response['status_code']=200
				response['status_message']='OTP has been sent on you registered email successfully'
				response['OTP']=OTP
			try:
				theList=[]
				theList.append(data.get('email'))
				message='<p>Hello '+str(customerObj.name)+', here is your forgot password:-'+str(OTP)+' </p>'
				# sendCustomMail(theList,message)

				subject='Forgot Password'
				message = render_to_string('sendSignupOTPMail.html', {
					'otp': OTP,
					'name':customerObj.name,
					})
				fromEmail = settings.EMAIL_HOST_USER
				toEmail = data.get('email')
				message = EmailMessage(subject, message, fromEmail, [toEmail])
				message.content_subtype = 'html'
				message.send()
			except Exception as e:
				print(e)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class forgotPasswordVerifyOtp(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('otp'):
				response['status_code']=400
				response['status_message']='OTP required'
				return Response(response)
			if not data.get('email'):
				if not data.get('phone'):
					response['status_code']=400
					response['status_message']='Email or Phone required.'
					return Response(response)
				else:
					if not data.get('countrycode'):
						response['status_code']=400
						response['status_message']='Country code required'
						return Response(response)
					customerObj = Customer.objects.filter(phone = data.get('phone'),countrycode=data.get('countrycode'),forgotPasswordOTP=data.get('otp')).first()
			else:
				customerObj = Customer.objects.filter(email = data.get('email'),forgotPasswordOTP=data.get('otp')).first()
				
			response['status_code']=200
			response['status_message']='OTP verified.'
			if not customerObj:
				response['status_code']=400
				response['status_message']='Verification Failed, OTP not matched.'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class updatePassword(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('otp'):
				response['status_code']=400
				response['status_message']='OTP required.'
				return Response(response)
			if not data.get('password'):
				response['status_code']=400
				response['status_message']='Password required.'
				return Response(response)
			if not data.get('email'):
				if not data.get('phone'):
					response['status_code']=400
					response['status_message']='Email or Phone required.'
					return Response(response)
				else:
					if not data.get('countrycode'):
						response['status_code']=400
						response['status_message']='Country code required'
						return Response(response)
					customerObj = Customer.objects.filter(phone = data.get('phone'),countrycode=data.get('countrycode'),forgotPasswordOTP=data.get('otp')).first()
			else:
				customerObj = Customer.objects.filter(email = data.get('email'),forgotPasswordOTP=data.get('otp')).first()
				
			if not customerObj:
				response['status_code']=400
				response['status_message']='Customer Not Exist'
				return Response(response)
			user=User.objects.filter(id=customerObj.userTableID).first()
			
			if not user:
				response['status_code']=400
				response['status_message']='User Not Exist'

			user.set_password(data.get('password'))
			user.save()
			response['status_code']=200
			response['status_message']='Password Update Successfully'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class ChangePassword(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			tokenObj = Token.objects.filter(key = session_token).first()
			if not tokenObj:
				response['status_code']=401
				response['status_message']='Invalid Session Token'
				return Response(response,status=response['status_code'])
			if not data.get('newPassword'):
				response['status_code']=400
				response['status_message']='New Password required.'
				return Response(response)
			if not data.get('oldPassword'):
				response['status_code']=400
				response['status_message']='Old Password required.'
				return Response(response)
			userObj = User.objects.get(id = tokenObj.user_id)
			response['status_code']=400
			response['status_message']='Current password is incorrect'
			if userObj.check_password(data.get('oldPassword')):
				userObj.password = make_password(data.get('newPassword'))
				userObj.save()
				response['status_code']=400
				response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class resendSignupOTP(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)
			customerObj = Customer.objects.filter(email = data.get('email')).first()
			
			if not customerObj:
				response['status_code']=400
				response['status_message']='Customer not exist.'
				return Response(response)
			otp=GernateOTP()
			customerObj.signupOtp=otp
			customerObj.phoneVerifiedOtp=otp
			customerObj.save()
			response['status_code']=200
			response['status_message']='OTP has been sent on you registered email successfully'
			response['otp']=otp
			try:
				theList=[]
				theList.append(data.get('email'))
				message='<p>Hello '+str(customerObj.name)+', here is your signup otp:-'+str(otp)+' </p>'
				# sendCustomMail(theList,message)

				subject='Signup OTP'
				message = render_to_string('sendSignupOTPMail.html', {
					'otp': otp,
					'name':customerObj.name,
					})
				fromEmail = settings.EMAIL_HOST_USER
				toEmail = data.get('email')
				message = EmailMessage(subject, message, fromEmail, [toEmail])
				message.content_subtype = 'html'
				message.send()
			except Exception as e:
				print(e)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class verifPhoneWithOTP(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			
			data=request.data
			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)
			if not data.get('otp'):
				response['status_code']=400
				response['status_message']='OTP required'
				return Response(response)

			if not data.get('fcmtoken'):
				response['status_code']=400
				response['status_message']='FCM token required'
				return Response(response)
			if not data.get('deviceType'):
				response['status_code']=400
				response['status_message']='Device type required'
				return Response(response)


			customerObj = Customer.objects.filter(email = data.get('email'),phoneVerifiedOtp=data.get('otp')).first()
			if not customerObj:
				response['status_code']=400
				response['status_message']='Verification Failed, OTP not matched'
				return Response(response)

			customerObj.phoneverified=True
			customerObj.signupOtpVerfied=True
			customerObj.accountverified=True
			theCustomerSerial = GetCustomerData(customerObj)
			customerObj.userToken = theCustomerSerial.data['token']
			customerObj.fcmtoken = data.get('fcmtoken')
			customerObj.deviceType = data.get('deviceType')
			customerObj.save()
			response['status_code']=200
			response['status_message']='Success'
			response['data']=theCustomerSerial.data
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class socialLogin(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)
			# if not data.get('phone'):
			#     response['status_code']=400
			#     response['status_message']='Phone required'
			#     return Response(response)
			# if not data.get('countrycode'):
			#     response['status_code']=400
			#     response['status_message']='Country code required'
			#     return Response(response)
			if not data.get('socialId'):
				response['status_code']=400
				response['status_message']='Social id required'
				return Response(response)
			if not data.get('deviceType'):
				response['status_code']=400
				response['status_message']='Device type required'
				return Response(response)
			if not data.get('fcmtoken'):
				response['status_code']=400
				response['status_message']='FCM token required'
				return Response(response)
			if not data.get('registerType'):
				response['status_code']=400
				response['status_message']='Register type required'
				return Response(response)

			if not request.FILES.get('passportImage'):
				response['status_code']=400
				response['status_message']='Passport image required'
				return Response(response)
			if not request.FILES.get('licenceImage'):
				response['status_code']=400
				response['status_message']='Licence image required'
				return Response(response)
			if not request.FILES.get('nationalID'):
				response['status_code']=400
				response['status_message']='National id required'
				return Response(response)
			if not request.FILES.get('ageProof'):
				response['status_code']=400
				response['status_message']='Age proof required'
				return Response(response)

			# alreadySocial=Customer.objects.filter(socialId = data.get('socialId')).first()
			# if alreadySocial:
			#     theUSer=User.objects.filter(id=alreadySocial.userUniqueID)
			#     token = Token.objects.filter(user = theUSer).first()
			#     if token:
			#         alreadySocial.user.auth_token.delete()
			#     theCustomerSerial = GetCustomerData(alreadySocial)
			#     response['status_code']=200
			#     response['status_message']='User login Successfully'
			#     response['data']=theCustomerSerial.data
			#     return Response(response)
			userOBJ = User.objects.filter(username = data.get('email')).first()
			if userOBJ:
				response['status_code']=400
				response['status_message']='Email already exists.'
			else:
				digits = "zm1Sc3gK71C9laHpq"
				passCode = ""
				for i in range(15) :
					passCode += digits[math.floor(random.random() * 10)]

				

				userObj = User.objects.create_user(username = data.get('email'), email = data.get('email'), password = passCode)
				
				userObjId=userOBj.id
				beforeNameOfUser=data.get('name')
				beforeNameOfUser=beforeNameOfUser.replace(' ','')
				name3Letter=beforeNameOfUser[0:3]
				name3Letter=name3Letter.upper()
				latExt=Customer.objects.all().last()
				if latExt:
					lastId=latExt.userUniqueID
					last5Number=lastId[3:]
					last5Number=int(last5Number)
					new5Number=last5Number+1
					new5Number=str(new5Number)
					new5Number = new5Number.zfill(5)
					theUniqueID=str(name3Letter)+str(new5Number)
				else:
					theUniqueID=str(name3Letter)+str('00001')


				customerObj = Customer.objects.create(userUniqueID=theUniqueID,userTableID = userObjId, name = data.get('name'), email = data.get('email'),socialId=data.get('socialId'),deviceType=data.get('deviceType'),registerType=data.get('registerType'),fcmtoken=data.get('fcmtoken'),signupOtpVerfied=True,accountverified=True,emailverified=True)
				token = Token.objects.filter(user = userObj).first()
				if token:
					userObj.auth_token.delete()
				passportImage=request.FILES.get('passportImage')
				if passportImage:
					filename=uploadDocumentImages(passportImage,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='1')
				licenceImage=request.FILES.get('licenceImage')
				if licenceImage:
					filename=uploadDocumentImages(licenceImage,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='2')
				nationalID=request.FILES.get('nationalID')
				if nationalID:
					filename=uploadDocumentImages(nationalID,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='3')
				registrationProof=request.FILES.get('ageProof')
				if registrationProof:
					filename=uploadDocumentImages(registrationProof,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='4')
				theDocuments = request.FILES.getlist("documents")
				if theDocuments:
					for count, image in enumerate(theDocuments):
						filename=uploadDocumentImages(image,'cannabiscustomer','documents')
						ownerDocs=CustomerDocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='5')
				theCustomerSerial = GetCustomerData(customerObj)
				response['status_code']=200
				response['status_message']='Success'
				response['data']=theCustomerSerial.data
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def validateToken(theToken):
	returnId='0'
	tokenOBJ = Token.objects.filter(key = theToken).first()
	if tokenOBJ:
		user = User.objects.get(id = tokenOBJ.user_id)
	if user:
		returnId=user.id
	return returnId

class getProfile(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			# data=request.data
			# tokenObj = Token.objects.filter(key = session_token).first()
			# if not tokenObj:
			#     response['status_code']=400
			#     response['status_message']='Invalid Session Token'
			#     return Response(response)
			# userOBJ = User.objects.get(id = tokenObj.user_id)
			print("Profile data ===================================")
			customerObj = Customer.objects.filter(userToken=session_token).first()
			if not customerObj:
				response['status_code']=400
				response['status_message']='Customer Not Exist'
				return Response(response)
			print("After Profile data ===================================")
			theCustomerSerial = GetCustomerData(customerObj)
			print("Before states ===================================")
			statesData=getStateListFunction()
			print("after states ===================================")
			print("statesData",statesData)
			# print("statesDataType",type(statesData))
			# statesData=statesData.json()
			print("statesData",statesData)
			if statesData['status_code']==200:
				response['states']=statesData['data']
			response['status_code']=200
			response['status_message']='User profile Data'
			response['data']=theCustomerSerial.data
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		print(response)
		return Response(response)

class updateProfile(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])

			session_token = session_token.replace("Token ", "")

			# tokenObj = Token.objects.filter(key = session_token).first()
			# if not tokenObj:
			#     response['status_code']=400
			#     response['status_message']='Invalid Session Token'
			#     return Response(response)

			# userOBJ = User.objects.get(id = tokenObj.user_id)
			customerObj = Customer.objects.filter(userToken = session_token).first()
			if not customerObj:
				response['status_code']=400
				response['status_message']='Customer not exist'
				return Response(response)
			image=request.FILES.get('image')
			print("my image=============>",image)
			filename=''
			if data.get('name'):
				customerObj.name=data.get('name')
			if data.get('state'):
				customerObj.state=data.get('state')
			if data.get('age'):
				customerObj.age=data.get('age')
			if data.get('dob'):
				try:
					dat=data.get('dob')
					dateOfBirth=datetime.strptime(dat, "%Y-%m-%d").date()
					if customerObj:
						customerObj.dob=dateOfBirth
						customerObj.save()
				except Exception as e:
					print(e)
			if image:
				print("before saving")
				filename=uploadDocumentImages(image,'cannabiscustomer','profile')
				print("after saving")
				customerObj.image=filename
			if data.get('countrycode'):
				customerObj.countrycode=data.get('countrycode')
			if data.get('phone'):
				customerObj.phone=data.get('phone')
			customerObj.save()
			theCustomerSerial = GetCustomerData(customerObj)
			response['status_code']=200
			response['status_message']='Update profile successfully'
			response['data']=theCustomerSerial.data
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class logout(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			tokenOBJ = Token.objects.filter(key = session_token).first()
			if not tokenOBJ:
				response['status_code']=401
				response['status_message']='Invalid Session Token'
				return Response(response,status=response['status_code'])
			userOBJ = User.objects.get(id = tokenOBJ.user_id)
			customerObj = Customer.objects.filter(userTableID = userOBJ.id).first()
			if not customerObj:
				response['status_code']=400
				response['status_message']='Not a valid Customer'
			else:
				customerObj.userToken=''
				customerObj.fcmtoken=''
				customerObj.save()
				userOBJ.auth_token.delete()
				response['status_code']=200
				response['status_message']='Customer Logout Successfully'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getDocuments(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData=[]
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			customerObj = Customer.objects.filter(userToken = session_token).first()
			if not customerObj:
				response['status_code']=400
				response['status_message']='Customer not exist'
				return Response(response)
			allDocs=CustomerDocuments.objects.filter(userUniqueID=customerObj.userUniqueID)
			if allDocs:
				for doc in allDocs:
					theName=str(doc.document.name)
					theDocType=''
					imageIDKey=''
					imageKey=''
					if doc.doctType=='1':
						imageIDKey='passportImageID'
						imageKey='passportImage'
						theDocType='Passport'
					elif doc.doctType=='2':
						theDocType='Licence'
						imageIDKey='licenceImageID'
						imageKey='licenceImage'
					elif doc.doctType=='3':
						theDocType='National ID'
						imageIDKey='nationalProofID'
						imageKey='nationalID'
					elif doc.doctType=='4':
						theDocType='Age Proof'
						imageIDKey='ageProofID'
						imageKey='ageProof'
					else:
						theDocType='Others'
						imageIDKey=''
						imageKey=''
					allData.append({'id':doc.id,
									'document':theName,
									'name':theDocType,
									'imageKey':imageKey,
									'imageIDKey':imageIDKey,
									'status':doc.theStatus,})
				response['status_code']=200
				response['status_message']='Success'
				response['data']=allData
			else:
				response['status_code']=400
				response['status_message']='No data found'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class updateDocuments(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			tokenObj = Token.objects.filter(key = session_token).first()
			if not tokenObj:
				response['status_code']=401
				response['status_message']='Invalid Session Token'
				return Response(response,status=response['status_code'])
			userOBJ = User.objects.get(id = tokenObj.user_id)
			customerObj = Customer.objects.filter(userTableID = userOBJ.id).first()
			if not customerObj:
				response['status_code']=400
				response['status_message']='Customer not exist'
				return Response(response)
			userObjId=customerObj.userTableID
			theUniqueID=customerObj.userUniqueID
			print("I am updating passport image===============;;;;;;;;;;;;;;;;;;;;;;====================")
			passportImage=request.FILES.get('passportImage')
			print(passportImage)
			if passportImage:
				print("==1==")
				passportImageID=data.get('passportImageID')
				if passportImageID == '0':
					print("=== if ==")
					filename=uploadDocumentImages(passportImage,'cannabiscustomer','documents')
					print("=- else -=")
					ownerDocs=CustomerDocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='1')
				else:
					print("+++++ELSE++++++")
					print(type(passportImage))
					filename=uploadDocumentImages(passportImage,'cannabiscustomer','documents')
					print(filename)
					ownerDocs=CustomerDocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=passportImageID,doctType='1').first()
					ownerDocs.document=filename
					ownerDocs.theStatus='1'
					ownerDocs.save()
			licenceImage=request.FILES.get('licenceImage')
			if licenceImage:
				licenceImageID=data.get('licenceImageID')
				if licenceImageID == '0':
					filename=uploadDocumentImages(licenceImage,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='2')
				else:
					filename=uploadDocumentImages(licenceImage,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=licenceImageID,doctType='2').first()
					ownerDocs.document=filename
					ownerDocs.theStatus='1'
					ownerDocs.save()
			nationalID=request.FILES.get('nationalID')
			if nationalID:
				nationalProofID=data.get('nationalProofID')
				if nationalProofID == '0':
					filename=uploadDocumentImages(nationalID,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='3')
				else:
					filename=uploadDocumentImages(nationalID,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=nationalProofID,doctType='3').first()
					ownerDocs.document=filename
					ownerDocs.theStatus='1'
					ownerDocs.save()
			registrationProof=request.FILES.get('ageProof')
			if registrationProof:
				registrationProofID=data.get('ageProofID')
				if registrationProofID == '0':
					filename=uploadDocumentImages(registrationProof,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='4')
				else:
					filename=uploadDocumentImages(registrationProof,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=registrationProofID,doctType='4').first()
					ownerDocs.document=filename
					ownerDocs.theStatus='1'
					ownerDocs.save()

			theIDS = request.POST.getlist("ids")
			theDocuments = request.FILES.getlist("documents")
			for count, image in enumerate(theDocuments):
				if theIDS[count] == '0':
					filename=uploadDocumentImages(image,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.create(userTableID=userID,userUniqueID=compObjects.userUniqueID,document=filename,doctType='5')
				else:
					alreadyDoc=CustomerDocuments.objects.filter(userTableID=userID,id=theIDS[count]).first()
					if alreadyDoc:
						filename=uploadDocumentImages(image,'cannabiscustomer','documents')
						alreadyDoc.document=filename
						ownerDocs.theStatus='1'
						alreadyDoc.save()
			adminBodySend=str(customerObj.name)+' has been updated there document'
			adminTypeSend='push'
			adminTitleSend='Documents Updated'
			adminUserID=customerObj.userUniqueID
			notifyAdmin(adminBodySend,adminTypeSend,'document_updated',adminTitleSend,adminUserID)
			response['status_code']=200
			response['status_message']='Documents Updated Successfully'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class notificationSoundStatus(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			tokenObj = Token.objects.filter(key = session_token).first()
			if not tokenObj:
				response['status_code']=401
				response['status_message']='Invalid Session Token'
				return Response(response,status=response['status_code'])
			
			if not data.get('isNotificationSoundOn'):
				response['status_code']=401
				response['status_message']='isNotificationSoundOn required'
				return Response(response)
			
			customerObj = Customer.objects.filter(userToken=session_token).first()
			if not customerObj:
				response['status_code']=400
				response['status_message']='Customer not exist'
				return Response(response)
			
			if data.get('isNotificationSoundOn')=='True':
				customerObj.isNotificationSoundOn=True
			else:
				customerObj.isNotificationSoundOn=False
			customerObj.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class notificationStatus(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			tokenObj = Token.objects.filter(key = session_token).first()
			if not tokenObj:
				response['status_code']=401
				response['status_message']='Invalid Session Token'
				return Response(response,status=response['status_code'])
			
			if not data.get('isNotificationOn'):
				response['status_code']=401
				response['status_message']='isNotificationOn required'
				return Response(response)
			
			customerObj = Customer.objects.filter(userToken=session_token).first()
			if not customerObj:
				response['status_code']=400
				response['status_message']='Customer not exist'
				return Response(response)
			
			if data.get('isNotificationOn')=='True':
				customerObj.isNotificationOn=True
			else:
				customerObj.isNotificationOn=False
			customerObj.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getSettings(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData={}
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			customerObj = Customer.objects.filter(userToken=session_token).first()
			if not customerObj:
				response['status_code']=400
				response['status_message']='Customer Not Exist'
				return Response(response)
			hasPlan=CustomerPurchase.objects.filter(customerID=customerObj.userUniqueID,isActive=True).first()
			if hasPlan:
				hasActiveSubscription=True
			else:
				hasActiveSubscription=False
			currentPlanObject=currentPlan.objects.filter(customerID=customerObj.userUniqueID).first()
			if currentPlanObject:
				if currentPlanObject.option=='AutoRenew':
					subscriptionStatus='True'
				else:
					subscriptionStatus='False'
			else:
				subscriptionStatus=''
			allData['subscriptionStatus']=subscriptionStatus
			allData["currencySymbol"]="$"
			allData["currencyCode"]="USD"
			allData["hasActiveSubscription"]=hasActiveSubscription
			allData["isNotificationSoundOn"]=customerObj.isNotificationSoundOn
			allData["isNotificationOn"]=customerObj.isNotificationOn
			# theCustomerSerial = GetCustomerData(customerObj)
			response['status_code']=200
			response['status_message']='User profile Data'
			response['data']=allData
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class deactivateAccount(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData={}
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			customerObj = Customer.objects.filter(userToken=session_token).first()
			if not customerObj:
				response['status_code']=400
				response['status_message']='Customer Not Exist'
				return Response(response)
			customerObj.isdisabled=True
			customerObj.save()
			response['status_code']=200
			response['status_message']='Account deactivated successfully'
			response['data']=allData
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class requestAdmin(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			allData={}
			if not data.get('customerID'):
				response['status_code']=400
				response['status_message']='customerID required'
				return Response(response)
			customerObj = Customer.objects.filter(userUniqueID=data.get('customerID')).first()
			if not customerObj:
				response['status_code']=400
				response['status_message']='Customer Not Exist'
				return Response(response)
			response['status_code']=200
			response['status_message']='Request send'
			response['data']=allData
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getNotifications(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			customerObj = Customer.objects.filter(userToken=session_token).first()
			if not customerObj:
				response['status_code']=400
				response['status_message']='Customer Not Exist'
				return Response(response)
			if not data.get('page'):
				response['status_code']=400
				response['status_message']='page required'
				return Response(response)
			allNotifications=notifications.objects.filter(customerID=customerObj.userUniqueID).order_by('-id')
			import humanize
			import datetime as dt

			pageNo=data.get('page')
			pageNo=int(pageNo)
			startPage=0
			endPage=int(settings.PAGE_LIMIT)
			for r in range(1,pageNo):
				startPage=startPage+int(settings.PAGE_LIMIT)
				endPage=endPage+int(settings.PAGE_LIMIT)
			totalRecords=len(allNotifications)
			previousRecords=len(allNotifications[:startPage])
			nextRecords=len(allNotifications[endPage:])
			if previousRecords==0:
				hasPreviousPage=False
			else:
				hasPreviousPage=True
			if nextRecords==0:
				hasNextPage=False
			else:
				hasNextPage=True
			response['hasNextPage']=hasNextPage
			response['hasPreviousPage']=hasPreviousPage
			allNotifications=allNotifications[startPage:endPage]
			# print(humanize.naturalday(dt.datetime.now()))
			alldata=[]
			for n in allNotifications:
				theAgoDate=humanize.naturalday(n.created_at)
				alldata.append({'notificationID':n.id,
								'title':n.title,
								'description':n.description,
								'date':theAgoDate,
								'image':n.image,})
			response['status_code']=200
			response['status_message']='Notification data'
			
			response['data']=alldata
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		print(response)
		return Response(response)

class deleteNotification(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		data=request.data
		try:
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			customerObj = Customer.objects.filter(userToken=session_token).first()
			if not customerObj:
				response['status_code']=400
				response['status_message']='Customer Not Exist'
				return Response(response)
			if not data.get('notificationID'):
				response['status_code']=400
				response['status_message']='notificationID required'
				return Response(response)
			allNotifications=notifications.objects.filter(id=data.get('notificationID'),customerID=customerObj.userUniqueID).first()
			if allNotifications:
				allNotifications.delete()
				response['status_code']=200
				response['status_message']='Notification delete'
			else:
				response['status_code']=400
				response['status_message']='Invalid id'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		print(response)
		return Response(response)

def gernateChatTokenTwilio(identity):
	import twilio
	from twilio.jwt.access_token import AccessToken
	from twilio.jwt.access_token.grants import ChatGrant
	account_sid = str(settings.TWILIO_ACCOUNT_SID)
	api_key = str(settings.TWILIO_API_KEY)
	api_secret = str(settings.TWILIO_API_SECRET)

	# required for Chat grants
	service_sid = str(settings.TWILIO_SERVICE_SID)
	identity = 'user@example.com'

	# Create access token with credentials
	token = AccessToken(account_sid, api_key, api_secret, identity=identity)

	# Create an Chat grant and add to token
	chat_grant = ChatGrant(service_sid=service_sid)
	token.add_grant(chat_grant)

	# Return token info as JSON
	print(token.to_jwt())
	returnToken=token.to_jwt()

	return returnToken

class gernateTwilioToken(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		data=request.data
		try:
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			customerObj = Customer.objects.filter(userToken=session_token).first()
			if not customerObj:
				response['status_code']=400
				response['status_message']='Customer Not Exist'
				return Response(response)
			if not data.get('identity'):
				response['status_code']=400
				response['status_message']='identity required'
				return Response(response)
			twilioToken=gernateChatTokenTwilio(data.get('identity'))
			# theData=GetStoreDetails(storeObj)
			response['status_code']=200
			response['status_message']='Success'
			response['twilioToken']=twilioToken
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		print(response)
		return Response(response)



# #its for filter  date notification
# class filterNotifications(APIView):
# 	def post(self, request, *args, **kwargs):
# 		response={}
# 		data = request.data
# 		try:
# 			allData=[]
# 			session_token = request.META.get('HTTP_AUTHORIZATION')
# 			start_date = data.get('start_date',None)
# 			end_date = data.get('end_date', None)
# 			if start_date is not None and start_date != '':
# 				pass
# 			else:	
# 				response['status_code'] = 400
# 				response['status_message'] = 'start date required'
# 				return Response(response)
			
# 			if end_date is None or end_date == '':
# 				from datetime import timedelta
# 				import datetime
# 				end_date = datetime.date.today() + timedelta(days=1)
# 			if not session_token:
# 				if not data.get('session_token'):
# 					response['status_code']=400
# 					response['status_message']='Session token required'
# 					return Response(response)
# 				session_token=data.get('session_token')
# 			else:
# 				session_token = session_token.replace("Token ", "")

# 			userID=validateToken(session_token)
# 			customerObj = Customer.objects.filter(userToken=session_token).first()
# 			if not customerObj:
# 				response['status_code']=400
# 				response['status_message']='Invalid token'
# 				return Response(response)
# 			allNotifications=notifications.objects.filter(customerID=customerObj.userUniqueID, created_at__range=(start_date, end_date)).order_by('-id')
# 			# allNotifications = companynotifications.objects.filter(companyID=compObjects.userUniqueID, created_at__range=[start_date, end_date])
# 			# allNotifications = companynotifications.objects.filter(companyID=compObjects.userUniqueID, created_at__range= [start_date, end_date])
# 			# allNotifications=companynotifications.objects.filter(created_at__gte=start_date, created_at__lte = end_date)
# 			for n in allNotifications:
# 				allData.append({
# 								'title':n.title,
# 								'id':n.id,
# 								'image':n.image,
# 								'description':n.description,
# 								'date':n.created_at,
# 								})
# 			response['data']=allData
# 			response['status_code']=200
# 			response['status_message']='Success'
# 			return Response(response)
# 		except Exception as e:
# 			response['status_code']=500
# 			response['status_message']=str(e)
# 		return Response(response)



# class deleteNotificationList(APIView):
# 	def post(self, request, *args, **kwargs):
# 		response={}
# 		try:
# 			data=request.data
# 			session_token = request.META.get('HTTP_AUTHORIZATION')
# 			if not session_token:
# 				if not data.get('session_token'):
# 					response['status_code']=400
# 					response['status_message']='Session token required'
# 					return Response(response)
# 				session_token=data.get('session_token')
# 			else:
# 				session_token = session_token.replace("Token ", "")
			
# 			customerObj = Customer.objects.filter(userToken=session_token).first()
# 			if not customerObj:
# 				response['status_code']=400
# 				response['status_message']='Invalid token'
# 				return Response(response)
			
# 			if not data.get('idlist'):
# 				response['status_code']=400
# 				response['status_message']='Notification id list is required'
# 				return Response(response)
# 			theidLists=data.get('idlist')
# 			for l in theidLists:
# 				theNotificationObject=notifications.objects.filter(id=l).first()
# 				if theNotificationObject:
# 					theNotificationObject.delete()
					
# 			response['status_code']=200
# 			response['status_message']='Success'
# 			return Response(response)
# 		except Exception as e:
# 			response['status_code']=500
# 			response['status_message']=str(e)
# 		return Response(response)


