from asgiref.sync import async_to_sync
from channels.generic.websocket import AsyncWebsocketConsumer
from channels.db import database_sync_to_async
from tracking.models import trackroom
from django.contrib.auth.models import User
import json


class ChatConsumer(AsyncWebsocketConsumer):
    async def connect(self):
        self.room_name = self.scope["url_route"]["kwargs"]["orderID"]
        self.room_group_name = "chat_%s" % self.room_name
        self.users = await self.get_lat_long(self.room_name)
        self.lat = self.users[0]
        self.long = self.users[1]

        # Join room group
        await self.channel_layer.group_add(self.room_group_name, self.channel_name)

        await self.accept()

    async def disconnect(self, close_code):
        # Leave room group
        await self.channel_layer.group_discard(self.room_group_name, self.channel_name)

    # Receive message from WebSocket
    async def receive(self, text_data):
        text_data_json = json.loads(text_data)
        latitude = text_data_json["latitude"]
        longitude = text_data_json["longitude"]
        # receiver = text_data_json["receiver"]

        if latitude != "" and longitude != "":
            add_coordinates = await self.add_coordinates(self.room_name, latitude, longitude)

        # Send message to room group
        await self.channel_layer.group_send(
            self.room_group_name,
            {
                "type": "track_driver",
                "latitude": latitude,
                "longitude": longitude,
            },
        )

    # Receive message from room group
    async def track_driver(self, event):
        latitude = event["latitude"]

        chat_hist_data = await self.get_coordinates(self.room_name)

        await self.send(text_data=json.dumps({"data": chat_hist_data}))

    # Getting User List
    @database_sync_to_async
    def get_lat_long(self, id):
        # id = int(id)
        c = trackroom.objects.filter(orderID=id)[0]
        l = [c.latitude, c.longitude]

        return l

    # Getting Chats
    @database_sync_to_async
    def get_coordinates(self, id):
        # id = int(id)
        c = trackroom.objects.filter(orderID=id)[0]
        # m = Message.objects.filter(conversation=c)

        chat_hist_data = []
        # for i in m:
        chat_hist_data.append(
            {
                # "conversation": i.conversation.id,
                "orderID": c.orderID,
                "latitude": c.latitude,
                "longitude": c.longitude,
            }
        )

        return chat_hist_data

    @database_sync_to_async
    def add_coordinates(self, id, latitude, longitude):
        # sender = User.objects.filter(username=user1)[0]
        # receiver = User.objects.filter(username=user2)[0]
        c = trackroom.objects.filter(orderID=id)[0]
        c.latitude=latitude
        c.longitude=longitude
        # m = Message.objects.create(
        #     conversation=c, message=message, sender1=sender, receiver1=receiver
        # )

        c.save()

        return "Done"


class ChatConsumerCustomer(AsyncWebsocketConsumer):
    async def connect(self):
        self.room_name = self.scope["url_route"]["kwargs"]["orderID"]
        self.room_group_name = "chat_%s" % self.room_name
        self.users = await self.get_lat_long(self.room_name)
        self.lat = self.users[0]
        self.long = self.users[1]

        # Join room group
        await self.channel_layer.group_add(self.room_group_name, self.channel_name)

        await self.accept()

    async def disconnect(self, close_code):
        # Leave room group
        await self.channel_layer.group_discard(self.room_group_name, self.channel_name)

    # Receive message from WebSocket
    async def receive(self, text_data):
        text_data_json = json.loads(text_data)
        pass
        # latitude = text_data_json["latitude"]
        # longitude = text_data_json["longitude"]
        # receiver = text_data_json["receiver"]

        # if latitude != "" and longitude != "":
            # add_coordinates = await self.add_coordinates(self.room_name, latitude, longitude)

        # Send message to room group
        await self.channel_layer.group_send(
            self.room_group_name,
            {
                "type": "track_driver",
                # "latitude": latitude,
                # "longitude": longitude,
            },
        )

    # Receive message from room group
    async def track_driver(self, event):
        # latitude = event["latitude"]

        chat_hist_data = await self.get_coordinates(self.room_name)

        await self.send(text_data=json.dumps({"data": chat_hist_data}))

    # Getting User List
    @database_sync_to_async
    def get_lat_long(self, id):
        # id = int(id)
        c = trackroom.objects.filter(orderID=id)[0]
        l = [c.latitude, c.longitude]

        return l

    # Getting Chats
    @database_sync_to_async
    def get_coordinates(self, id):
        # id = int(id)
        c = trackroom.objects.filter(orderID=id)[0]
        # m = Message.objects.filter(conversation=c)

        chat_hist_data = []
        # for i in m:
        chat_hist_data.append(
            {
                # "conversation": i.conversation.id,
                "orderID": c.orderID,
                "latitude": c.latitude,
                "longitude": c.longitude,
            }
        )

        return chat_hist_data

    @database_sync_to_async
    def add_coordinates(self, id, latitude, longitude):
        # sender = User.objects.filter(username=user1)[0]
        # receiver = User.objects.filter(username=user2)[0]
        c = trackroom.objects.filter(orderID=id)[0]
        c.latitude=latitude
        c.longitude=longitude
        # m = Message.objects.create(
        #     conversation=c, message=message, sender1=sender, receiver1=receiver
        # )

        c.save()

        return "Done"