"""customer URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/3.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path
from django.conf.urls.static import static
from django.conf.urls import url, include
from django.views.static import serve
from django.conf import settings
from django.conf.urls import handler400, handler403, handler404, handler500
from chat.views import (
    index,
    signup,
    list_chats,
    logIn,
    logOut,
    new_chatroom,
    conversation,
)

urlpatterns = [
    path('admin/', admin.site.urls),
    url(r'^customer/tracking/', include('chat.urls')),
    url(r'^customer/auth/', include('base.urls')),
    url(r'^customer/backend/', include('getdata.urls')),
    url(r'^customer/subscriptions/', include('subscriptions.urls')),
    url(r'^customer/store/', include('storeproducts.urls')),
    url(r'^customer/order/', include('orders.urls')),
    url(r'^customer/content/', include('contentpages.urls')),
    url(r'^customer/discount/', include('discount.urls')),
    url(r'^customer/tickets/', include('support.urls')),

    # path("signup/", signup, name="signup"),
    # path("login/", logIn, name="login"),
    # path("logout/", logOut, name="logout"),
    # path("chat/", list_chats, name="chat"),
    # path("new_chatroom/", new_chatroom, name="new_chatroom"),
    # path("chat/<int:id>/", conversation, name="conversation"),
]
urlpatterns+= static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)