from rest_framework.views import APIView
from rest_framework.response import Response
from storeproducts.models import *
from base.models import *
from .serializers import *
from .models import *
import datetime
from django.conf import settings
import json
from django.db.models import Q

class addCoupon(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if not data.get('couponname'):
				response['status_code']=400
				response['status_message']='couponname required'
				return Response(response)
			if not data.get('couponcode'):
				response['status_code']=400
				response['status_message']='couponcode required'
				return Response(response)
			if not data.get('coupondescription'):
				response['status_code']=400
				response['status_message']='coupondescription required'
				return Response(response)
			if not data.get('discounttype'):
				response['status_code']=400
				response['status_message']='discounttype required'
				return Response(response)
			if not data.get('discount'):
				response['status_code']=400
				response['status_message']='discount required'
				return Response(response)
			if not data.get('minimumamount'):
				response['status_code']=400
				response['status_message']='minimumamount required'
				return Response(response)
			if not data.get('maximumuse'):
				response['status_code']=400
				response['status_message']='maximumuse required'
				return Response(response)
			if not data.get('expirydate'):
				response['status_code']=400
				response['status_message']='expirydate required'
				return Response(response)
			alreadyOBJ=coupon.objects.filter(couponcode=data.get('couponcode')).first()
			if alreadyOBJ:
				response['status_code']=400
				response['status_message']='coupon code is already exist'
				return Response(response)
			theCoupunObject=coupon.objects.create(couponcode=data.get('couponcode'))
			theCoupunObject.couponname=data.get('couponname')
			theCoupunObject.coupondescription=data.get('coupondescription')
			theCoupunObject.discounttype=data.get('discounttype')
			theCoupunObject.discount=data.get('discount')
			theCoupunObject.minimumamount=data.get('minimumamount')
			theCoupunObject.maximumuse=data.get('maximumuse')
			try:
				import datetime as dv
				startDate=data.get('expirydate')
				startDate=dv.datetime.strptime(startDate, '%Y-%m-%d')
				startDate=startDate.date()
				print(startDate)
				print(type(startDate))
				theCoupunObject.expirydate=startDate
			except Exception as e:
				print(e)
			theCoupunObject.save()
			response['status_code']=200
			response['status_message']='Coupon added successfully'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class getCouponListForAdmin(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)

			alreadyOBJ=coupon.objects.all()
			theCoupunSerial=GetCouponData(alreadyOBJ,many=True)
			response['data']=theCoupunSerial.data
			response['status_code']=200
			response['status_message']='Coupon data'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class updateCoupon(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if not data.get('couponcode'):
				response['status_code']=400
				response['status_message']='couponcode required'
				return Response(response)
			
			couponObject=coupon.objects.filter(couponcode=data.get('couponcode')).first()
			if not couponObject:
				response['status_code']=400
				response['status_message']='Invalid coupon code'
				return Response(response)
			

			if data.get('couponname'):
				couponObject.couponname=data.get('couponname')
			if data.get('coupondescription'):
				couponObject.coupondescription=data.get('coupondescription')
			if data.get('discounttype'):
				couponObject.discounttype=data.get('discounttype')
			if data.get('discount'):
				couponObject.discount=data.get('discount')
			if data.get('minimumamount'):
				couponObject.minimumamount=data.get('minimumamount')
			if data.get('maximumuse'):
				couponObject.maximumuse=data.get('maximumuse')
			if data.get('expirydate'):
				try:
					import datetime as dv
					startDate=data.get('expirydate')
					startDate=dv.datetime.strptime(startDate, '%Y-%m-%d')
					startDate=startDate.date()
					print(startDate)
					print(type(startDate))
					couponObject.expirydate=startDate
				except Exception as e:
					print(e)
			couponObject.save()
			response['status_code']=200
			response['status_message']='Updated successfully'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class deleteCoupon(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if not data.get('couponcode'):
				response['status_code']=400
				response['status_message']='couponcode required'
				return Response(response)
			
			couponObject=coupon.objects.filter(couponcode=data.get('couponcode')).first()
			if not couponObject:
				response['status_code']=400
				response['status_message']='Invalid coupon code'
				return Response(response)
			couponObject.delete()
			response['status_code']=200
			response['status_message']='Deleted successfully'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class getCouponList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])

			alreadyOBJ=coupon.objects.all()
			theCoupunSerial=GetCouponData(alreadyOBJ,many=True)
			response['data']=theCoupunSerial.data

			rewardData=[]
			rewardObject=myrewards.objects.filter(customerID=customerObjects.userUniqueID).first()
			if rewardObject:
				response['totalPoints']=int(rewardObject.availablepoints)
				available3rewardsCount=int(rewardObject.availablepoints)/3
				available6rewardsCount=int(rewardObject.availablepoints)/6
				available9rewardsCount=int(rewardObject.availablepoints)/9
				available12rewardsCount=int(rewardObject.availablepoints)/12
				rewardData.append({'type':'reward3',
								'count':int(available3rewardsCount),
								'name':'3 deliveries reward',
								'description':'3 deliveries: $5 off on $100'})
				rewardData.append({'type':'reward6',
								'count':int(available6rewardsCount),
								'name':'6 deliveries reward',
								'description':'6 deliveries: 1/2 off delivery'})
				rewardData.append({'type':'reward9',
								'count':int(available9rewardsCount),
								'name':'9 deliveries reward',
								'description':'9 deliveries: $15/$200'})
				rewardData.append({'type':'reward12',
								'count':int(available12rewardsCount),
								'name':'12 deliveries reward',
								'description':'12 deliveries: Free Pre Roll + 1/2 off delivery'})
			else:
				response['totalPoints']=0	
			response['rewardData']=rewardData
			response['status_code']=200
			response['status_message']='Coupon data'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class applyCoupon(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			
			if not data.get('couponcode'):
				response['status_code']=400
				response['status_message']='couponcode required'
				return Response(response)
			
			if not data.get('totalAmount'):
				response['status_code']=400
				response['status_message']='totalAmount required'
				return Response(response)
			allData=[]
			couponObject=coupon.objects.filter(couponcode=data.get('couponcode')).first()
			if not couponObject:
				response['status_code']=400
				response['status_message']='Invalid coupon code'
				return Response(response)
			totalAmount=float(data.get('totalAmount'))
			if float(couponObject.minimumamount)>float(totalAmount):
				response['status_code']=400
				response['status_message']=str(couponObject.minimumamount)+' amount required to apply coupon code'
			if couponObject.discounttype=='Percentage':
				percent=float(couponObject.discount)/100
				tempAmount=float(totalAmount)*float(percent)
				allData.append({'amountBeforeCoupon':str(totalAmount),
				                'ampuntAfterCoupon':str(tempAmount),
								'discountType':couponObject.discounttype,
								'discount':couponObject.discount,})
			else:
				tempAmount=float(totalAmount)-float(couponObject.discount)
				allData.append({'amountBeforeCoupon':str(totalAmount),
				                'ampuntAfterCoupon':str(tempAmount),
								'discountType':couponObject.discounttype,
								'discount':couponObject.discount,})
			response['data']=allData
			response['status_code']=200
			response['status_message']='Coupon data'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)