from rest_framework import serializers
from base.models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from django.conf import settings

class GetCustomerDataReports(serializers.ModelSerializer):
	documents=serializers.SerializerMethodField(source='get_documents')
	image=serializers.SerializerMethodField(source='get_image')
	
	class Meta:
		model = Customer
		fields = ['userUniqueID','risk','name','state','age','dob','email','phone','countrycode','image','isdisabled','documents']

	
	def get_image(self,obj):
		if obj.image != '':
			return str(obj.image.name)
		else:
			return ''


	def get_documents(self,obj):
		data=[]
		theDoc=CustomerDocuments.objects.filter(userUniqueID=obj.userUniqueID)
		for doc in theDoc:
			theDocName=str(doc.document.name)
			theDocType=''
			if doc.doctType=='1':
				theDocType='Passport'
			elif doc.doctType=='2':
				theDocType='Licence'
			elif doc.doctType=='3':
				theDocType='National ID'
			elif doc.doctType=='4':
				theDocType='Age Proof'
			else:
				theDocType='Other'

			data.append({'documents':theDocName,
				         'theDocType':theDocType,
				         'status':doc.theStatus,
				         'id':doc.id,})
		return data

class GetCustomerDataList(serializers.ModelSerializer):
	documents=serializers.SerializerMethodField(source='get_documents')
	image=serializers.SerializerMethodField(source='get_image')
	
	class Meta:
		model = Customer
		fields = ['userUniqueID','risk','name','state','age','dob','email','phone','countrycode','image','isdisabled','documents']

	
	def get_image(self,obj):
		if obj.image != '':
			return str(obj.image.name)
		else:
			return ''


	def get_documents(self,obj):
		data=[]
		theDoc=CustomerDocuments.objects.filter(userUniqueID=obj.userUniqueID)
		for doc in theDoc:
			theDocName=str(doc.document.name)
			theDocType=''
			if doc.doctType=='1':
				theDocType='Passport'
			elif doc.doctType=='2':
				theDocType='Licence'
			elif doc.doctType=='3':
				theDocType='National ID'
			elif doc.doctType=='4':
				theDocType='Age Proof'
			else:
				theDocType='Other'

			data.append({'documents':theDocName,
				         'theDocType':theDocType,
				         'status':doc.theStatus,
				         'id':doc.id,})
		return data