from django.shortcuts import render
from rest_framework.views import APIView
from django.http import JsonResponse, response
from django.views.decorators.csrf import csrf_exempt
from base.models import *
# from Auth.models import drivercharges
from subscriptions.models import *
from storeproducts.models import *
from django.conf import settings
from django.db.models import Avg
from django.db.models import Q
from .serializers import *
from django.http import HttpResponse
from rest_framework.response import Response
import environ
from django.core.files.storage import FileSystemStorage
from django.core.mail import send_mail
from django.template.loader import render_to_string
from django.core.mail import EmailMessage


import boto
import boto.exception
import boto.sns
import pprint
import re

def sendPush(listOfDevices, body):
	import json 
	region = [r for r in boto.sns.regions() if r.name==u'us-east-1'][0]
	sns = boto.sns.SNSConnection(
		aws_access_key_id=str(settings.AWS_ACCESS_KEY_ID),
		aws_secret_access_key=str(settings.AWS_SECRET_ACCESS_KEY),
		region=region,
	)
	for device in listOfDevices:
		try:
			endpoint_response = sns.create_platform_endpoint(
				platform_application_arn='arn:aws:sns:us-east-1:432363816440:app/GCM/Cannabis',
				token=device['token'],
			)   
			endpoint_arn = endpoint_response['CreatePlatformEndpointResponse']['CreatePlatformEndpointResult']['EndpointArn']
		except boto.exception.BotoServerError as err:
			result_re = re.compile(r'Endpoint(.*)already', re.IGNORECASE)
			result = result_re.search(err.message)
			if result:
				endpoint_arn = result.group(0).replace('Endpoint ','').replace(' already','')
			else:
				raise
		print("ARN:", endpoint_arn)
		publish_result = sns.publish(
			target_arn=endpoint_arn,
			message=json.dumps(body),
			# message_structure='json'
		)
		print("PUBLISH")
		pprint.pprint(publish_result)
		notifications.objects.create(customerID=device['customerID'],title=body['title'],description=body['body'])

class adminLoginToken(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			# import os
			# import dotenv

			# data=request.data
			
			# dotenv_file = dotenv.find_dotenv()
			# dotenv.load_dotenv(dotenv_file)
			
			# ACCESS_TOKEN=os.environ.get('ACCESS_TOKEN')
			# print(ACCESS_TOKEN)
			# os.environ['ACCESS_TOKEN'] = data.get('AccessKey')

			# dotenv.set_key(dotenv_file, "ACCESS_TOKEN", os.environ["ACCESS_TOKEN"])
			print("before set token")
			ifAlready=SuperadminAccess.objects.filter(theID='1').first()
			if ifAlready:
				ifAlready.AccessKey=data.get('AccessKey')
				ifAlready.save()
			else:
				print("set token first time")
				SuperadminAccess.objects.create(theID='1',AccessKey=data.get('AccessKey'))
			response['status_code']=200
			response['status_message']='Done'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class adminLogoutToken(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			# import os
			# import dotenv

			data=request.data
			
			# dotenv_file = dotenv.find_dotenv()
			# dotenv.load_dotenv(dotenv_file)
			
			# ACCESS_TOKEN=os.environ.get('ACCESS_TOKEN')
			# print(ACCESS_TOKEN)
			# os.environ['ACCESS_TOKEN'] = 'A4D5M8I6N3L3O5G2O0U8T'

			# dotenv.set_key(dotenv_file, "ACCESS_TOKEN", os.environ["ACCESS_TOKEN"])
			ifAlready=SuperadminAccess.objects.filter(theID='1').first()
			if ifAlready:
				ifAlready.AccessKey=''
				ifAlready.save()
			response['status_code']=200
			response['status_message']='Done'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getCustomerList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			# env = environ.Env()
			# environ.Env.read_env()
			# theKey = env("ACCESS_TOKEN")
			# if data.get('AccessKey') != theKey:
			# 	response['status_code']=403
			# 	response['status_message']='You dont have access to this api.'
			# 	return Response(response)
			haveAccess=SuperadminAccess.objects.filter(AccessKey=AccessKey).first()
			if not haveAccess:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			if not data.get('search'):
				theSearch=''
			else:
				theSearch=data.get('search')
			if not data.get('filterType'):
				filterType='All'
			else:
				filterType=data.get('filterType')
				if filterType=='Enable':
					filterValue=False
				else:
					filterValue=True
			if filterType=='All':
				if theSearch=='':
					allCustms=Customer.objects.all().order_by('-id')
				else:
					allCustms=Customer.objects.filter(name__icontains=theSearch).order_by('-id')
			else:
				if theSearch=='':
					allCustms=Customer.objects.filter(isdisabled=filterValue).order_by('-id')
				else:
					allCustms=Customer.objects.filter(name__icontains=theSearch,isdisabled=filterValue).order_by('-id')
			# allCustms=Customer.objects.all().order_by('-id')
			if not allCustms:
				response['status_code']=400
				response['status_message']='No Data Found'
				return Response(response)
			else:
				theData=GetCustomerDataList(allCustms, many=True)
				response['status_code']=200
				response['status_message']='Data found'
				response['data']=theData.data
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getCustomerData(APIView):
	def post(self, request,*args,**kwargs):
		response={}
		try:
			data=request.data
			
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			haveAccess=SuperadminAccess.objects.filter(AccessKey=AccessKey).first()
			if not haveAccess:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theCosmObj=Customer.objects.filter(userUniqueID=data.get('customerID')).first()
			if not theCosmObj:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			theData=GetCustomerDataList(theCosmObj)
			response['status_code']=200
			response['status_message']='Data found'
			response['data']=theData.data
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class changeStatusOfCustomer(APIView):
	def post(self,request,*args,**kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			haveAccess=SuperadminAccess.objects.filter(AccessKey=AccessKey).first()
			if not haveAccess:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theCompObj=Customer.objects.filter(userUniqueID=data.get('customerID')).first()
			if theCompObj:
				if data.get('theStatus') == True:
					theCompObj.isdisabled=False
				else:
					theCompObj.isdisabled=True
				theCompObj.save()
				response['status_code']=200
				response['status_message']='Status updated'
			else:
				response['status_code']=400
				response['status_message']='Not a valid Customer ID'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def randomStringFunctionForImage():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(10)))
	str1 += ''.join((random.choice(string.digits) for x in range(6)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

# def uploadDocumentImages(image,thePath):
# 	import os
# 	fullPath='media/'+str(thePath)+'/'
# 	fs = FileSystemStorage(location=fullPath)
# 	beforename = os.path.splitext(image.name)[0]
# 	filetype = os.path.splitext(image.name)[1]
# 	theName=randomStringFunctionForImage()
# 	theImageName=str(theName)+str(filetype)
# 	filename = fs.save(theImageName, image)
# 	return '/'+str(thePath)+'/'+filename

def uploadDocumentImages(image,bucket,thePath):
	import os
	import boto3
	from botocore.exceptions import NoCredentialsError
	try:
		ACCESS_KEY=str(settings.AWS_ACCESS_KEY_ID)
		SECRET_KEY=str(settings.AWS_SECRET_ACCESS_KEY)
		s3 = boto3.client('s3', aws_access_key_id=ACCESS_KEY,
					  aws_secret_access_key=SECRET_KEY)
		try:
			filetype = os.path.splitext(image.name)[1]
			imageName=randomStringFunctionForImage()
			thePath=thePath+'/'+imageName+'.'+filetype
			thePath=str(thePath)
			theFile=s3.upload_fileobj(image,bucket,thePath)
			print("Upload Successful")
			filename=str(settings.AWS_BUCKET_URL_1)+str(bucket)+str(settings.AWS_BUCKET_URL_2)+thePath
			return filename
		except FileNotFoundError as e:
			print("The file was not found")
			return ''
		except NoCredentialsError:
			print("Credentials not available")
			return ''
	except Exception as e:
		print(e)
		return ''

def findTimeObject(pickupTime):
	from datetime import time
	pickupTimeHour=pickupTime.split(':')[0]
	pickupTimeMinutes=pickupTime.split(':')[1]
	pickupTimeHour=int(pickupTimeHour)
	pickupTimeMinutes=int(pickupTimeMinutes)
	pickupTimeObject = time(hour = pickupTimeHour, minute = pickupTimeMinutes, second = 00)
	return pickupTimeObject

class updateDocuments(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")


			haveAccess=SuperadminAccess.objects.filter(AccessKey=AccessKey).first()
			if not haveAccess:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			customerObj=Customer.objects.filter(userUniqueID=data.get('customerID')).first()
			if not customerObj:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			userObjId=customerObj.userTableID
			theUniqueID=customerObj.userUniqueID
			passportImage=request.FILES.get('passportImage')
			if passportImage:
				passportImageID=request.FILES.get('passportImageID')
				if passportImageID == '0':
					filename=uploadDocumentImages(passportImage,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType=1,isApproved=True)
				else:
					filename=uploadDocumentImages(passportImage,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=passportImageID,doctType=1)
					ownerDocs.document=filename
					ownerDocs.isApproved=True
					ownerDocs.save()
			licenceImage=request.FILES.get('licenceImage')
			if licenceImage:
				licenceImageID=request.FILES.get('licenceImageID')
				if licenceImageID == '0':
					filename=uploadDocumentImages(licenceImage,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType=2,isApproved=True)
				else:
					filename=uploadDocumentImages(licenceImage,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=licenceImageID,doctType=2)
					ownerDocs.document=filename
					ownerDocs.isApproved=True
					ownerDocs.save()
			nationalID=request.FILES.get('nationalID')
			if nationalID:
				nationalProofID=request.FILES.get('nationalProofID')
				if nationalProofID == '0':
					filename=uploadDocumentImages(nationalID,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType=3,isApproved=True)
				else:
					filename=uploadDocumentImages(nationalID,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=nationalProofID,doctType=3)
					ownerDocs.document=filename
					ownerDocs.isApproved=True
					ownerDocs.save()
			registrationProof=request.FILES.get('ageProof')
			if registrationProof:
				registrationProofID=request.FILES.get('ageProofID')
				if registrationProofID == '0':
					filename=uploadDocumentImages(registrationProof,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType=4,isApproved=True)
				else:
					filename=uploadDocumentImages(registrationProof,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=registrationProofID,doctType=4)
					ownerDocs.document=filename
					ownerDocs.isApproved=True
					ownerDocs.save()

			theIDS = request.POST.getlist("ids")
			theDocuments = request.FILES.getlist("documents")
			for count, image in enumerate(theDocuments):
				if theIDS[count] == '0':
					filename=uploadDocumentImages(image,'cannabiscustomer','documents')
					ownerDocs=CustomerDocuments.objects.create(userTableID=userID,userUniqueID=compObjects.userUniqueID,document=filename,doctType=5,isApproved=True)
				else:
					alreadyDoc=CustomerDocuments.objects.filter(userTableID=userID,id=theIDS[count]).first()
					if alreadyDoc:
						filename=uploadDocumentImages(image,'cannabiscustomer','documents')
						alreadyDoc.document=filename
						ownerDocs.isApproved=True
						alreadyDoc.save()
			response['status_code']=200
			response['status_message']='Documents Updated Successfully'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def approveDocuments(customerID,docID):
	try:
		alreadyDoc=CustomerDocuments.objects.filter(userUniqueID=customerID,id=docID).first()
		print("alreadyDoc",alreadyDoc)
		if alreadyDoc:
			alreadyDoc.isApproved=True
			alreadyDoc.theStatus='2'
			alreadyDoc.save()
	except Exception as e:
		print(e)

def rejectDocuments(customerID,docID,rejectReasonOFDoc):
	try:
		alreadyDoc=CustomerDocuments.objects.filter(userUniqueID=customerID,id=docID).first()
		print("alreadyDoc",alreadyDoc)
		if alreadyDoc:
			alreadyDoc.isApproved=False
			alreadyDoc.rejectMessage=rejectReasonOFDoc
			alreadyDoc.theStatus='3'
			alreadyDoc.save()
	except Exception as e:
		print(e)

class changeDocumentsStatus(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			
			
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			haveAccess=SuperadminAccess.objects.filter(AccessKey=AccessKey).first()
			if not haveAccess:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theCompObj=Customer.objects.filter(userUniqueID=data.get('customerID')).first()
			if not theCompObj:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			docID = data.get("docID")
			theStatus = data.get("status")
			print("docID",docID)
			print("theStatus",theStatus)
			print("customerID",data.get('customerID'))
			if theStatus == 'Accept':
				approveDocuments(data.get('customerID'),docID)
			else:
				if not data.get('reason'):
					response['status_code']=400
					response['status_message']='Reject reason required'
					return Response(response)
				rejectDocuments(data.get('customerID'),docID,data.get('reason'))
			approveCount=0
			totalUplodedCount=0
			presentDocs=CustomerDocuments.objects.filter(userUniqueID=data.get('customerID'))
			for p in presentDocs:
				totalUplodedCount+=1
				if p.isApproved==True:
					approveCount+=1
			if approveCount==0:
				pass
			elif approveCount>=totalUplodedCount:
				theCompObj.risk=1
				theCompObj.save()
			elif approveCount<totalUplodedCount:
				theCompObj.risk=2
				theCompObj.save()
			else:
				theCompObj.risk=3
				theCompObj.save()
			response['status_code']=200
			response['status_message']='Documents '+str(theStatus)+' Successfully'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class totalCustomer(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			haveAccess=SuperadminAccess.objects.filter(AccessKey=AccessKey).first()
			if not haveAccess:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			allComps=Customer.objects.all().count()


			import datetime as ddd
			import dateutil.relativedelta
			theUserSeries=[]
			for count in range(0,6):
				d = ddd.datetime.now()
				print(d.month,d.year)
				d2 = d - dateutil.relativedelta.relativedelta(months=count)
				print(d2.month,d2.year)
				theDateValue=d2.strftime("%b, %Y")
				allCount=Customer.objects.filter(Q(created_at__month=d2.month) & Q(created_at__year=d2.year)).count()
				theUserSeries.append({'value':allCount,
									  'name':theDateValue,})
			response['status_code']=200
			response['count']=allComps
			response['theUserSeries']=theUserSeries
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class sendEmailNotificationsToCustomers(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			haveAccess=SuperadminAccess.objects.filter(AccessKey=AccessKey).first()
			if not haveAccess:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			allCustomers=Customer.objects.filter(isdisabled=False)
			if not allCustomers:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			allMails=[]
			for custom in allCustomers:
				allMails.append(custom.email)
			
			try:
				subject=data.get('title')
				message = render_to_string('notifyMailHTML.html', {
				'message': data.get('message'),
				})
				fromEmail = settings.EMAIL_HOST_USER
				message = EmailMessage(subject, message, fromEmail, allMails)
				message.content_subtype = 'html'
				message.send()
			except Exception as e:
				print(e)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class sendPushNotificationsToCustomers(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")
			
			if not data.get('title'):
				response['status_code']=400
				response['status_message']='title required'
				return Response(response)
			if not data.get('message'):
				response['status_code']=400
				response['status_message']='message required'
				return Response(response)

			haveAccess=SuperadminAccess.objects.filter(AccessKey=AccessKey).first()
			if not haveAccess:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			allCustomers=Customer.objects.filter(isdisabled=False)
			if not allCustomers:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			allTokens=[]
			for custom in allCustomers:
				if custom.fcmtoken == '':
					pass
				elif custom.fcmtoken is None:
					pass
				else:
					allTokens.append({'token':custom.fcmtoken,
								  'customerID':custom.userUniqueID})
			messageBody={}
			messageBody['type']='admin_info'
			messageBody['title']=data.get('title')
			messageBody['body']=data.get('message')
			sendPush(allTokens,messageBody)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getListOfPurchasedPlanByCustomers(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData=[]
			data=request.data
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			theAdmin=SuperadminAccess.objects.filter(AccessKey=AccessKey).first()
			if not theAdmin:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			
			allPurchase=CustomerPurchase.objects.all()
			for i in allPurchase:
				theCompObject=Customer.objects.filter(userUniqueID=i.customerID).first()
				if not data.get('search') or data.get('search')=='':
					allData.append({'planName':i.planName,
								'planPrice':i.planPrice,
								'description':i.description,
								'htmlDescription':i.htmlDescription,
								'startDate':i.startDate,
								'expiryDate':i.expiryDate,
								'trialExpiry':i.trialExpiry,
								'isActive':i.isActive,
								'name':theCompObject.name,
								'email':theCompObject.email,
								'image':str(theCompObject.image.name)})
				else:
					searchingName=theCompObject.name
					searchingName=searchingName.lower()
					if data.get('search')==searchingName:
						allData.append({'planName':i.planName,
								'planPrice':i.planPrice,
								'description':i.description,
								'htmlDescription':i.htmlDescription,
								'startDate':i.startDate,
								'expiryDate':i.expiryDate,
								'trialExpiry':i.trialExpiry,
								'isActive':i.isActive,
								'name':theCompObject.name,
								'email':theCompObject.email,
								'image':str(theCompObject.image.name)})
			response['status_code']=200
			response['status_message']='Success'
			response['data']=allData
		except Exception as e:
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class setDriverCharges(APIView):
	def get(self, request):
		response={}
		chargesObject=deliverycharges.objects.all().last()
		if chargesObject:
			response['charges']=chargesObject.charges
		else:
			response['charges']=0
		response['status_code']=200
		response['status_message']='Success'
		return Response(response)

	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")
			
			if not data.get('charges'):
				response['status_code']=400
				response['status_message']='charges required'
				return Response(response)
			haveAccess=SuperadminAccess.objects.filter(AccessKey=AccessKey).first()
			if not haveAccess:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			chargesObject=deliverycharges.objects.all().last()
			if not chargesObject:
				chargesObject=deliverycharges.objects.create(charges=data.get('charges'))
			else:
				chargesObject.charges=data.get('charges')
				chargesObject.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def createCSVCustomer(allCustomers):
	import csv
	rows=[]
	fields = ['Id', 'Name', 'Email', 'State', 'Age', 'Dob', 'Phone', 'Status']
	for customer in allCustomers:
		innerRow=[]
		innerRow.append(customer['userUniqueID'])
		innerRow.append(customer['name']) 
		innerRow.append(customer['email']) 
		innerRow.append(customer['state']) 
		innerRow.append(customer['age']) 
		innerRow.append(customer['dob'])
		tempPhone=str(customer['countrycode'])+str(customer['phone']) 
		innerRow.append(tempPhone)
		if customer['isdisabled']:
			theStatus='In Active'
		else:
			theStatus='Active'
		innerRow.append(theStatus)
		rows.append(innerRow)
	fname=randomStringFunctionForImage()
	filename = "/var/www/html/customer/media/Reports/customer_"+str(fname)+".csv"
	url=str(settings.WEB_BASE_URL)+"media/Reports/customer_"+str(fname)+".csv"
	with open(filename, 'w') as csvfile:
		csvwriter = csv.writer(csvfile) 
		csvwriter.writerow(fields)
		csvwriter.writerows(rows)
	return url

class getReportCustomer(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			haveAccess=SuperadminAccess.objects.filter(AccessKey=AccessKey).first()
			if not haveAccess:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			
			if not data.get('filterType'):
				response['status_code']=400
				response['status_message']='filterType is required'
				return Response(response)
			filterType=data.get('filterType')
			if filterType=='Enable':
				filterValue=False
			elif filterType=='Disable':
				filterValue=True
			else:
				filterValue='All'
			
			if not data.get('fromDate'):
				response['status_code']=400
				response['status_message']='fromDate is required'
				return Response(response)
			
			if not data.get('toDate'):
				response['status_code']=400
				response['status_message']='toDate is required'
				return Response(response)

			try:
				from datetime import datetime
				dat=data.get('fromDate')
				fromDate=datetime.strptime(dat, "%Y/%m/%d").date()
				dat2=data.get('toDate')
				toDate=datetime.strptime(dat2, "%Y/%m/%d").date()
			except Exception as e:
				print(e)
			if filterType=='All':
				allCustms=Customer.objects.filter(Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-id')
			else:
				allCustms=Customer.objects.filter(Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate) & Q(isdisabled=filterValue)).order_by('-id')
			if not allCustms:
				response['status_code']=400
				response['status_message']='No records found'
				return Response(response)
			else:
				theData=GetCustomerDataReports(allCustms, many=True)
				downloadLink=createCSVCustomer(theData.data)
				response['status_code']=200
				response['status_message']='Data found'
				response['downloadLink']=downloadLink
			
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


def createCSVOrders(allOrders):
	import csv
	rows=[]
	fields = ['Id', 'Discount', 'Delivery Fee', 'Service Total', 'Grand Total', 'Date', 'Time', 'Status', 'Customer Id', 'Customer Name', 'Customer Email']
	for order in allOrders:
		innerRow=[]
		innerRow.append(order['orderID'])
		innerRow.append(order['orderDiscount'])
		innerRow.append(order['orderDeliveryFee']) 
		innerRow.append(order['orderServiceTotal']) 
		innerRow.append(order['orderGrandTotal']) 
		innerRow.append(order['orderDate']) 
		innerRow.append(order['orderTime']) 
		innerRow.append(order['orderStatus'])
		innerRow.append(order['customerData']['userUniqueID'])
		innerRow.append(order['customerData']['name'])
		innerRow.append(order['customerData']['email'])
		rows.append(innerRow)
	fname=randomStringFunctionForImage()
	filename = "/var/www/html/customer/media/Reports/orders_"+str(fname)+".csv"
	url=str(settings.WEB_BASE_URL)+"media/Reports/orders_"+str(fname)+".csv"
	with open(filename, 'w') as csvfile:
		csvwriter = csv.writer(csvfile) 
		csvwriter.writerow(fields)
		csvwriter.writerows(rows)
	return url

from orders.serializers import *
class getReportOrders(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			haveAccess=SuperadminAccess.objects.filter(AccessKey=AccessKey).first()
			if not haveAccess:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			
			if not data.get('companyType'):
				companyType='All'
			elif data.get('companyType')=='All':
				companyType='All'
			else:
				companyType=data.get('companyType')
			
			if not data.get('storeType'):
				storeType='All'
			elif data.get('storeType')=='All':
				storeType='All'
			else:
				storeType=data.get('storeType')

			
			filterType=data.get('filterType')
			
			if not data.get('filterType'):
				filterType='All'
			elif data.get('filterType')=='All':
				filterType='All'
			else:
				filterType=data.get('filterType')
			
			if not data.get('fromDate'):
				response['status_code']=400
				response['status_message']='fromDate is required'
				return Response(response)
			
			if not data.get('toDate'):
				response['status_code']=400
				response['status_message']='toDate is required'
				return Response(response)

			try:
				from datetime import datetime
				dat=data.get('fromDate')
				fromDate=datetime.strptime(dat, "%Y/%m/%d").date()
				dat2=data.get('toDate')
				toDate=datetime.strptime(dat2, "%Y/%m/%d").date()
			except Exception as e:
				print(e)
			
			if companyType=='All':
				if storeType=='All':
					if filterType=='All':
						theOrders=orderPack.objects.filter(Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-orderID')
					else:
						theOrders=orderPack.objects.filter(Q(orderStatus=filterType) & Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-orderID')
				else:
					if filterType=='All':
						theOrders=orderPack.objects.filter(Q(relatedID=storeType) & Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-orderID')
					else:
						theOrders=orderPack.objects.filter(Q(relatedID=storeType) & Q(orderStatus=filterType) & Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-orderID')
			else:
				if storeType=='All':
					if filterType=='All':
						theOrders=orderPack.objects.filter(Q(companyID=companyType) & Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-orderID')
					else:
						theOrders=orderPack.objects.filter(Q(companyID=companyType) & Q(orderStatus=filterType) & Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-orderID')
				else:
					if filterType=='All':
						theOrders=orderPack.objects.filter(Q(companyID=companyType) & Q(relatedID=storeType) & Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-orderID')
					else:
						theOrders=orderPack.objects.filter(Q(companyID=companyType) & Q(relatedID=storeType) & Q(orderStatus=filterType) & Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-orderID')
			if not theOrders:
				response['status_code']=400
				response['status_message']='No records found'
				return Response(response)
			else:
				theOrderSerial=GetOrdersData(theOrders,many=True)
				downloadLink=createCSVOrders(theOrderSerial.data)
				response['status_code']=200
				response['status_message']='Success'
				response['downloadLink']=downloadLink
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)


class getReportOrdersForCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")
			
			if not data.get('companyID'):
				response['status_code']=400
				response['status_message']='companyID is required'
				return Response(response)
			# if not data.get('companyType'):
			# 	companyType='All'
			# elif data.get('companyType')=='All':
			# 	companyType='All'
			# else:
			# 	companyType=data.get('companyType')
			
			if not data.get('storeType'):
				storeType='All'
			elif data.get('storeType')=='All':
				storeType='All'
			else:
				storeType=data.get('storeType')

			
			filterType=data.get('filterType')
			
			if not data.get('filterType'):
				filterType='All'
			elif data.get('filterType')=='All':
				filterType='All'
			else:
				filterType=data.get('filterType')
			
			if not data.get('fromDate'):
				response['status_code']=400
				response['status_message']='fromDate is required'
				return Response(response)
			
			if not data.get('toDate'):
				response['status_code']=400
				response['status_message']='toDate is required'
				return Response(response)

			try:
				from datetime import datetime
				dat=data.get('fromDate')
				fromDate=datetime.strptime(dat, "%Y/%m/%d").date()
				dat2=data.get('toDate')
				toDate=datetime.strptime(dat2, "%Y/%m/%d").date()
			except Exception as e:
				print(e)
			
			if storeType=='All':
				if filterType=='All':
					theOrders=orderPack.objects.filter(Q(companyID=data.get('companyID')) & Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-orderID')
				else:
					theOrders=orderPack.objects.filter(Q(companyID=data.get('companyID')) & Q(orderStatus=filterType) & Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-orderID')
			else:
				if filterType=='All':
					theOrders=orderPack.objects.filter(Q(companyID=data.get('companyID')) & Q(relatedID=storeType) & Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-orderID')
				else:
					theOrders=orderPack.objects.filter(Q(companyID=data.get('companyID')) & Q(relatedID=storeType) & Q(orderStatus=filterType) & Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-orderID')
			
			if not theOrders:
				response['status_code']=400
				response['status_message']='No records found'
				return Response(response)
			else:
				theOrderSerial=GetOrdersData(theOrders,many=True)
				downloadLink=createCSVOrders(theOrderSerial.data)
				response['status_code']=200
				response['status_message']='Success'
				response['downloadLink']=downloadLink
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getReportOrdersForStores(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")
			
			if not data.get('companyID'):
				response['status_code']=400
				response['status_message']='companyID is required'
				return Response(response)
			
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID is required'
				return Response(response)
				
			# if not data.get('storeType'):
			# 	storeType='All'
			# elif data.get('storeType')=='All':
			# 	storeType='All'
			# else:
			# 	storeType=data.get('storeType')

			
			filterType=data.get('filterType')
			
			if not data.get('filterType'):
				filterType='All'
			elif data.get('filterType')=='All':
				filterType='All'
			else:
				filterType=data.get('filterType')
			
			if not data.get('fromDate'):
				response['status_code']=400
				response['status_message']='fromDate is required'
				return Response(response)
			
			if not data.get('toDate'):
				response['status_code']=400
				response['status_message']='toDate is required'
				return Response(response)

			try:
				from datetime import datetime
				dat=data.get('fromDate')
				fromDate=datetime.strptime(dat, "%Y/%m/%d").date()
				dat2=data.get('toDate')
				toDate=datetime.strptime(dat2, "%Y/%m/%d").date()
			except Exception as e:
				print(e)
			
			if filterType=='All':
				theOrders=orderPack.objects.filter(Q(companyID=data.get('companyID')) & Q(relatedID=data.get('storeID')) & Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-orderID')
			else:
				theOrders=orderPack.objects.filter(Q(companyID=data.get('companyID')) & Q(relatedID=data.get('storeID')) & Q(orderStatus=filterType) & Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-orderID')
			
			if not theOrders:
				response['status_code']=400
				response['status_message']='No records found'
				return Response(response)
			else:
				theOrderSerial=GetOrdersData(theOrders,many=True)
				downloadLink=createCSVOrders(theOrderSerial.data)
				response['status_code']=200
				response['status_message']='Success'
				response['downloadLink']=downloadLink
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)


class getCustomerDetailsBySupport(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)

			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)

			if not data.get('listData'):
				response['status_code']=403
				response['status_message']='listData is required.'
				return Response(response)
			print("==1==")
			listData=data.getlist('listData')
			print(listData)
			allData=[]
			print("==2==")
			for li in listData:
				theCustomObj=Customer.objects.filter(userUniqueID=li).first()
				if theCustomObj:
					allData.append({'id':theCustomObj.userUniqueID,
				                'name':theCustomObj.name,
								'image':theCustomObj.image.name})
			print("==3==")
			response['status_code']=200
			response['status_message']='Data found'
			response['data']=allData
			print("==4==")
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)


class sendPushNotificationsFromOthers(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)

			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			
			if not data.get('title'):
				response['status_code']=400
				response['status_message']='title required'
				return Response(response)
			if not data.get('message'):
				response['status_code']=400
				response['status_message']='message required'
				return Response(response)
			allCustomers=Customer.objects.filter(isdisabled=False)
			if not allCustomers:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			allTokens=[]
			for custom in allCustomers:
				if custom.fcmtoken == '':
					pass
				elif custom.fcmtoken is None:
					pass
				else:
					allTokens.append({'token':custom.fcmtoken,
								  'customerID':custom.userUniqueID})
			messageBody={}
			messageBody['type']='admin_info'
			messageBody['title']=data.get('title')
			messageBody['body']=data.get('message')
			sendPush(allTokens,messageBody)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)