import re
from rest_framework import serializers
from storeproducts.models import *
import requests
from django.conf import settings
from base.serializers import *
from base.models import *

class GetCustomerAddress(serializers.ModelSerializer):
    class Meta:
        model = deliveryAddress
        fields = ['address','latitude', 'longitude']

class GetProductData(serializers.ModelSerializer):
    productName =  serializers.SerializerMethodField(source='get_productName')
    productImage =  serializers.SerializerMethodField(source='get_productImage')
    productPrice =  serializers.SerializerMethodField(source='get_productPrice')
    productRating =  serializers.SerializerMethodField(source='get_productRating')

    class Meta:
        model = order
        fields = ['productID','orderCount', 'orderTotal','productName','productImage','productPrice','productRating']
    
    def get_productName(self,obj):
        return 'can A2r'
    
    def get_productImage(self,obj):
        return ''
    
    def get_productPrice(self,obj):
        return '42'
    
    def get_productRating(self,obj):
        return '3.5'

class GetOrdersData(serializers.ModelSerializer):
    orderAddress =  serializers.SerializerMethodField(source='get_orderAddress')
    # productData =  serializers.SerializerMethodField(source='get_productData')
    customerData =  serializers.SerializerMethodField(source='get_customerData')
    orderStatusColor = serializers.SerializerMethodField(source='get_orderStatusColor')
    instruction = serializers.SerializerMethodField(source='get_instruction')
    order_btn_status = serializers.SerializerMethodField(source='get_order_btn_status')
    orderDate = serializers.SerializerMethodField(source='get_orderDate')
    orderTime = serializers.SerializerMethodField(source='get_orderTime')
    canCancel = serializers.SerializerMethodField(source='get_canCancel')
    isCanceled = serializers.SerializerMethodField(source='get_isCanceled')


    class Meta:
        model = orderPack
        fields = ['orderID','rewardtype','rewardDiscount','coupounDiscount','freeItemImage','freeItemName','discountOnDelivery','isDriverRated','isCanceled','isRated','canCancel','couponcode','orderDiscount', 'orderDeliveryFee','orderServiceTotal', 'orderGrandTotal','orderOffer','relatedTo','orderAddress','customerData','orderDate','orderTime','orderStatus','order_btn_status','orderStatusColor','driverStatus','orderOffer','instruction','cancelReason','isPaid']

    def get_orderAddress(self,obj):
        theAddressSerial=GetCustomerAddress(obj.deliveryAddress)
        return theAddressSerial.data
    # def get_productData(self,obj):
    #     theOrdersData=order.objects.filter(orderPack=obj)
    #     theProductSerial=GetProductData(theOrdersData,many=True)
    #     return theProductSerial.data

    # def get_productData(self,obj):
    #     allData=[]
    #     if obj.relatedTo=='1':
    #         from store_products.models import order
    #         theOrdersData=order.objects.filter(orderPack=obj)
    #         for order in theOrdersData:
    #             try:
    #                 print("befiore serlizer call")
    #                 url = str(settings.STORE_ACCESS_URL)+"store/get/getProductByCustomerForOneOrderDetails/"
    #                 payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
    #                 'storeID': obj.relatedID,
    #                 'productId': order.productID
    #                 }
    #                 res = requests.request("POST", url,data=payload)
    #                 res = res.json()
    #                 # print(res)
    #                 print("after serlizer call")
    #                 if res['status_code']==200:
    #                     allData.append({'orderCount':res['data']['orderCount'],
    #                                     'orderTotal':res['data']['orderTotal'],
    #                                     'productId':res['data']['innerData']['productId'],
    #                                     'productName':res['data']['innerData']['productName'],
    #                                     'productPrice':res['data']['innerData']['productPrice'],
    #                                     'productImage':res['data']['innerData']['productImage'],
    #                                     'productRating':res['data']['innerData']['productRating'],})
    #             except Exception as e:
    #                 print(e)
    #     return allData
    #     theOrdersData=order.objects.filter(orderPack=obj)
    #     theProductSerial=GetProductData(theOrdersData,many=True)
    #     return theProductSerial.data

    def get_customerData(self,obj):
        customerObject=Customer.objects.filter(userUniqueID=obj.customerID).first()
        theCustomerSerial=GetCustomerDataForOthers(customerObject)
        return theCustomerSerial.data
    
    def get_orderStatusColor(self,obj):
        if obj.orderStatus=='Pending':
            statusColor='F5A06E'
        elif obj.orderStatus=='Accepted':
            statusColor='0FD3A8'
        elif obj.orderStatus=='Rejected':
            statusColor='F6091D'
        elif obj.orderStatus=='Assigned':
            statusColor='F6091D'
        elif obj.orderStatus=='PickedUP':
            statusColor='F6091D'
        elif obj.orderStatus=='Delivered':
            statusColor='0FD3A8'
        else:
            statusColor='F6091D'
        return statusColor
    
    def get_canCancel(self,obj):
        canCancel=True
        if obj.orderStatus=='Pending':
            statusColor='F5A06E'
        elif obj.orderStatus=='Accepted':
            statusColor='0FD3A8'
        elif obj.orderStatus=='Rejected':
            statusColor='F6091D'
        elif obj.orderStatus=='Assigned':
            statusColor='F6091D'
        elif obj.orderStatus=='PickedUP':
            statusColor='F6091D'
            canCancel=False
        elif obj.orderStatus=='Delivered':
            statusColor='0FD3A8'
            canCancel=False
        else:
            statusColor='F6091D'
        return canCancel
    

    def get_isCanceled(self,obj):
        isCanceled=False
        if obj.orderStatus=='Canceled':
            isCanceled=True
        return isCanceled
    
    def get_order_btn_status(self,obj):
        thestatus=obj.orderStatus
        return thestatus.lower()
    
    def get_orderDate(self,obj):
        dat=obj.created_at
        theDate=dat.strftime("%b %d, %Y")
        # theDate=str(obj.created_at.date())
        return theDate
    
    def get_orderTime(self,obj):
        theTime=obj.created_at.strftime('%I:%M:%S')
        # theTime=str(obj.created_at.time())
        return theTime
    
    def get_instruction(self,obj):
        if not obj.instruction:
            return ''
        else:
            return obj.instruction