from django.urls import path
from .views import *
urlpatterns=[
  
  # Customers
  path('addCart/',addCart.as_view()),
  path('checkLocationRadius/',checkLocationRadius.as_view()),
  path('placeOrder/',placeOrder.as_view()),
  path('cancelOrder/',cancelOrder.as_view()),
  path('getListOfOrders/',getListOfOrders.as_view()),
  path('getOrderDetails/',getOrderDetails.as_view()),
  path('getOrderDetailsForReOrder/',getOrderDetailsForReOrder.as_view()),
  path('clearCart/',clearCart.as_view()),
  path('getMyCart/',getMyCart.as_view()),

  # Driver
  path('getHomeScreenOrder/',getHomeScreenOrder.as_view()),
  path('getListOfOrdersOfDriver/',getListOfOrdersOfDriver.as_view()),
  path('getOrderDetailsOfDriver/',getOrderDetailsOfDriver.as_view()),
  path('changeOrderStatusFromDriver/',changeOrderStatusFromDriver.as_view()),

  # Store
  path('getStoreOrdersForCompany/',getStoreOrdersForCompany.as_view()),

  # Store and Company
  path('getOrdersCountForAdmin/',getOrdersCountForAdmin.as_view()),
  path('getTotalOrdersCount/',getTotalOrdersCount.as_view()),

  path('getTotalOrdersCountForStore/',getTotalOrdersCountForStore.as_view()),

  path('getCompanyOrdersForAdmin/',getCompanyOrdersForAdmin.as_view()),
  path('getListOfOrdersForCompany/',getListOfOrdersForCompany.as_view()),
  path('getOrderDetailsForCompany/',getOrderDetailsForCompany.as_view()),
  path('acceptRejectOrder/',acceptRejectOrder.as_view()),
  path('assignDriver/',assignDriver.as_view()),
  path('getSafePlaces/',getSafePlaces.as_view()),

  # Card
  path('addCard/',addCard.as_view()),
  path('setDefaultCard/',setDefaultCard.as_view()),
  path('deleteCard/',deleteCard.as_view()),
  path('getCardList/',getCardList.as_view()),
  path('orderPay/',orderPay.as_view()),
  path('getTransactionHistory/',getTransactionHistory.as_view()),

  # Rewards
  path('getMyRewards/',getMyRewards.as_view()),

  # Chatbot
  path('getOrderDetailsOfChatbot/',getOrderDetailsOfChatbot.as_view()),
]