from django.template.defaultfilters import lower
from rest_framework.views import APIView
from rest_framework.response import Response
from django.contrib.auth import login,authenticate
from storeproducts.models import *
from base.models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
import datetime
from django.template.loader import render_to_string
from django.core.mail import EmailMessage
import math, random, datetime, pytz, string
from datetime import date, datetime
from datetime import timedelta
import requests
from django.conf import settings
import json
from discount.models import *
from .serializers import *
import stripe
from django.db.models import Q

import boto
import boto.exception
import boto.sns
import pprint
import re

def getTheRewardsOfCustomer(customerID):
	response={}
	allData=[]
	rewardObject=myrewards.objects.filter(customerID=customerID).first()
	if rewardObject:
		response['totalPoints']=int(rewardObject.availablepoints)
		available3rewardsCount=int(rewardObject.availablepoints)/3
		available6rewardsCount=int(rewardObject.availablepoints)/6
		available9rewardsCount=int(rewardObject.availablepoints)/9
		available12rewardsCount=int(rewardObject.availablepoints)/12
		if int(available12rewardsCount)>=1:
			itemOBJ=availablefreeitem.objects.all().last()
			freeItemImage=itemOBJ.image
			freeItemName=itemOBJ.name
			allData.append({'type':'reward12',
						'count':int(available12rewardsCount),
						'name':'12 deliveries reward',
						'description':'12 deliveries: Free Pre Roll + 1/2 off delivery',
						'freeItemImage':freeItemImage,
						'freeItemName':freeItemName})
		elif int(available9rewardsCount)>=1:
			allData.append({'type':'reward9',
						'count':int(available9rewardsCount),
						'name':'9 deliveries reward',
						'description':'9 deliveries: $15/$200',
						'freeItemImage':'',
						'freeItemName':'',})
		elif int(available6rewardsCount)>=1:
			allData.append({'type':'reward6',
						'count':int(available6rewardsCount),
						'name':'6 deliveries reward',
						'description':'6 deliveries: 1/2 off delivery',
						'freeItemImage':'',
						'freeItemName':'',})
		elif int(available3rewardsCount)>=1:
			allData.append({'type':'reward3',
						'count':int(available3rewardsCount),
						'name':'3 deliveries reward',
						'description':'3 deliveries: $5 off on $100',
						'freeItemImage':'',
						'freeItemName':''})
		else:
			allData=[]
	else:
		allData=[]
	
	return allData

def sendPush(device_id, body):
	region = [r for r in boto.sns.regions() if r.name==u'us-east-1'][0]
	sns = boto.sns.SNSConnection(
		aws_access_key_id=str(settings.AWS_ACCESS_KEY_ID),
		aws_secret_access_key=str(settings.AWS_SECRET_ACCESS_KEY),
		region=region,
	)
	try:
		endpoint_response = sns.create_platform_endpoint(
			platform_application_arn='arn:aws:sns:us-east-1:432363816440:app/GCM/Cannabis',
			token=device_id,
		)   
		endpoint_arn = endpoint_response['CreatePlatformEndpointResponse']['CreatePlatformEndpointResult']['EndpointArn']
	except boto.exception.BotoServerError as err:
		result_re = re.compile(r'Endpoint(.*)already', re.IGNORECASE)
		result = result_re.search(err.message)
		if result:
			endpoint_arn = result.group(0).replace('Endpoint ','').replace(' already','')
		else:
			raise
	print("ARN:", endpoint_arn)
	publish_result = sns.publish(
		target_arn=endpoint_arn,
		message=json.dumps(body),
		# message_structure='json'
	)
	print("PUBLISH")
	pprint.pprint(publish_result)


def applyCoupon(couponcode,totalAmount):
	allData=[]
	response={}
	couponObject=coupon.objects.filter(couponcode=couponcode).first()
	if not couponObject:
		response['status_code']=400
		response['status_message']='Invalid coupon code'
		return Response(response)
	totalAmount=float(totalAmount)
	if float(couponObject.minimumamount)>float(totalAmount):
		response['status_code']=400
		response['status_message']=str(couponObject.minimumamount)+' minimum amount required to apply coupon code'
	if couponObject.discounttype=='Percentage':
		percent=float(couponObject.discount)/100
		discountedAmount=float(totalAmount)*float(percent)
		tempAmount=float(totalAmount)-float(discountedAmount)
		allData.append({'amountBeforeCoupon':str(totalAmount),
						'ampuntAfterCoupon':str(tempAmount),
						'discountType':couponObject.discounttype,
						'discount':discountedAmount,})
	else:
		tempAmount=float(totalAmount)-float(couponObject.discount)
		allData.append({'amountBeforeCoupon':str(totalAmount),
						'ampuntAfterCoupon':str(tempAmount),
						'discountType':couponObject.discounttype,
						'discount':couponObject.discount,})
	response['data']=allData
	response['status_code']=200
	response['status_message']='Coupon data'
	return response

def applyReward(customerID,rewardType,totalAmount,delveryFee):
	allData=[]
	response={}
	rewardObject=myrewards.objects.filter(customerID=customerID).first()
	if rewardObject:
		if rewardType=='reward3':
			rewardObject.availablepoints=int(rewardObject.availablepoints)-3
			rewardObject.usedpoints=int(rewardObject.usedpoints)+3
			if int(totalAmount)>=100:
				tempAmount=float(totalAmount)-float(5)
				discountOnItem=float(5)
				discountOnDelivery=0
				tempdelveryFee=delveryFee
			else:
				discountOnItem=float(0)
				discountOnDelivery=0
				tempAmount=float(totalAmount)
				tempdelveryFee=delveryFee
			allData.append({'afterAmount':tempAmount,
							'beforeAmount':totalAmount,
							'discountOnDelivery':discountOnDelivery,
							'discountOnItem':discountOnItem,
							'afterDeliveryFee':tempdelveryFee,
							'beforeDeliveryFee':delveryFee,
							'freeItemImage':'',
							'freeItemName':''})
		elif rewardType=='reward6':
			rewardObject.availablepoints=int(rewardObject.availablepoints)-6
			rewardObject.usedpoints=int(rewardObject.usedpoints)+6
			tempAmount=float(totalAmount)
			tempdelveryFee=float(delveryFee)/float(2)
			discountOnItem=float(0)
			discountOnDelivery=tempdelveryFee
			allData.append({'afterAmount':tempAmount,
							'beforeAmount':totalAmount,
							'discountOnDelivery':discountOnDelivery,
							'discountOnItem':discountOnItem,
							'afterDeliveryFee':tempdelveryFee,
							'beforeDeliveryFee':delveryFee,
							'freeItemImage':'',
							'freeItemName':''})
		elif rewardType=='reward9':
			rewardObject.availablepoints=int(rewardObject.availablepoints)-9
			rewardObject.usedpoints=int(rewardObject.usedpoints)+9
			if int(totalAmount)>=200:
				discountOnItem=float(15)
				tempAmount=float(totalAmount)-float(15)
				tempdelveryFee=delveryFee
				discountOnDelivery=0
			else:
				discountOnItem=0
				tempAmount=float(totalAmount)
				tempdelveryFee=delveryFee
				discountOnDelivery=0
			allData.append({'afterAmount':tempAmount,
							'beforeAmount':totalAmount,
							'discountOnDelivery':discountOnDelivery,
							'discountOnItem':discountOnItem,
							'afterDeliveryFee':tempdelveryFee,
							'beforeDeliveryFee':delveryFee,
							'freeItemImage':'',
							'freeItemName':''})
		elif rewardType=='reward12':
			rewardObject.availablepoints=int(rewardObject.availablepoints)-12
			rewardObject.usedpoints=int(rewardObject.usedpoints)+12
			tempAmount=float(totalAmount)
			discountOnItem=float(0)
			tempdelveryFee=float(delveryFee)/float(2)
			discountOnDelivery=tempdelveryFee
			itemOBJ=availablefreeitem.objects.all().last()
			freeItemImage=itemOBJ.image
			freeItemName=itemOBJ.name
			allData.append({'afterAmount':tempAmount,
							'beforeAmount':totalAmount,
							'discountOnDelivery':discountOnDelivery,
							'discountOnItem':discountOnItem,
							'afterDeliveryFee':tempdelveryFee,
							'beforeDeliveryFee':delveryFee,
							'freeItemImage':freeItemImage,
							'freeItemName':freeItemName})
		rewardObject.save()
	else:
		allData.append({'afterAmount':totalAmount,
							'beforeAmount':totalAmount,
							'discountOnDelivery':float(0),
							'discountOnItem':float(0),
							'afterDeliveryFee':delveryFee,
							'beforeDeliveryFee':delveryFee,
							'freeItemImage':'',
							'freeItemName':''})
	response['data']=allData
	response['status_code']=200
	response['status_message']='Coupon data'
	return response

def applyRewardCart(customerID,rewardType,totalAmount,delveryFee):
	allData=[]
	response={}
	rewardObject=myrewards.objects.filter(customerID=customerID).first()
	if rewardObject:
		if rewardType=='reward3':
			if int(totalAmount)>=100:
				tempAmount=float(totalAmount)-float(5)
				discountOnItem=float(5)
				discountOnDelivery=0
				tempdelveryFee=delveryFee
			else:
				discountOnItem=float(0)
				discountOnDelivery=0
				tempAmount=float(totalAmount)
				tempdelveryFee=delveryFee
			allData.append({'afterAmount':tempAmount,
							'beforeAmount':totalAmount,
							'discountOnDelivery':discountOnDelivery,
							'discountOnItem':discountOnItem,
							'afterDeliveryFee':tempdelveryFee,
							'beforeDeliveryFee':delveryFee,
							'freeItemImage':'',
							'freeItemName':''})
		elif rewardType=='reward6':
			tempAmount=float(totalAmount)
			tempdelveryFee=float(delveryFee)/float(2)
			discountOnItem=float(0)
			discountOnDelivery=tempdelveryFee
			allData.append({'afterAmount':tempAmount,
							'beforeAmount':totalAmount,
							'discountOnDelivery':discountOnDelivery,
							'discountOnItem':discountOnItem,
							'afterDeliveryFee':tempdelveryFee,
							'beforeDeliveryFee':delveryFee,
							'freeItemImage':'',
							'freeItemName':''})
		elif rewardType=='reward9':
			if int(totalAmount)>=200:
				discountOnItem=float(15)
				tempAmount=float(totalAmount)-float(15)
				tempdelveryFee=delveryFee
				discountOnDelivery=0
			else:
				discountOnItem=0
				tempAmount=float(totalAmount)
				tempdelveryFee=delveryFee
				discountOnDelivery=0
			allData.append({'afterAmount':tempAmount,
							'beforeAmount':totalAmount,
							'discountOnDelivery':discountOnDelivery,
							'discountOnItem':discountOnItem,
							'afterDeliveryFee':tempdelveryFee,
							'beforeDeliveryFee':delveryFee,
							'freeItemImage':'',
							'freeItemName':''})
		elif rewardType=='reward12':
			tempAmount=float(totalAmount)
			discountOnItem=float(0)
			tempdelveryFee=float(delveryFee)/float(2)
			discountOnDelivery=tempdelveryFee
			itemOBJ=availablefreeitem.objects.all().last()
			freeItemImage=itemOBJ.image
			freeItemName=itemOBJ.name
			allData.append({'afterAmount':tempAmount,
							'beforeAmount':totalAmount,
							'discountOnDelivery':discountOnDelivery,
							'discountOnItem':discountOnItem,
							'afterDeliveryFee':tempdelveryFee,
							'beforeDeliveryFee':delveryFee,
							'freeItemImage':freeItemImage,
							'freeItemName':freeItemName})
	else:
		allData.append({'afterAmount':totalAmount,
							'beforeAmount':totalAmount,
							'discountOnDelivery':float(0),
							'discountOnItem':float(0),
							'afterDeliveryFee':delveryFee,
							'beforeDeliveryFee':delveryFee,
							'freeItemImage':'',
							'freeItemName':''})
	response['data']=allData
	response['status_code']=200
	response['status_message']='Coupon data'
	return response



class addCart(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])

			if not data.get('productData'):
				response['status_code']=400
				response['status_message']='productData required'
				return Response(response)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required.'
				return Response(response)
			if not data.get('latitude'):
				response['status_code']=400
				response['status_message']='latitude required.'
				return Response(response)
			if not data.get('longitude'):
				response['status_code']=400
				response['status_message']='longitude required.'
				return Response(response)
			if data.get('isRewardApply'):
				if data.get('isRewardApply')=='YES':
					if not data.get('rewardType'):
						response['status_code']=400
						response['status_message']='rewardType required'
						return Response(response)
			if data.get('couponcode'):
				couponObject=coupon.objects.filter(couponcode=data.get('couponcode')).first()
				if not couponObject:
					response['status_code']=400
					response['status_message']='Invalid coupon code'
					return Response(response)
			productData=data.get('productData')
			productData=str(productData)
			productData=json.loads(productData)
			try:
				url = str(settings.STORE_ACCESS_URL)+"store/get/getStoreByCustomer/"
				payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
				'storeID': data.get('storeID'),
				}
				res = requests.request("POST", url,data=payload)
				print(res.json())
				# return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			res=res.json()
			theCompanyID=res['data']['companyID']
			totalDeliveryCharges=0
			discountOnItem=0
			itemCount=1
			itemProductPrice=0
			itemGiftPrice=0
			finalItemServiceTotal=0
			finalGrandTotal=0
			cartCalcAlready=cartCalculation.objects.filter(customerID=customerObjects.userUniqueID).first()
			if not cartCalcAlready:
				cartCalcAlready=cartCalculation.objects.create(customerID=customerObjects.userUniqueID)

			innerData=[]
			allData={}
			allCartProducts=cart.objects.filter(finalCalculation=cartCalcAlready)
			for acp in allCartProducts:
				acp.delete()
			for i in productData:
				print(i)
				print(i['productId'])
				print(i['itemCount'])
				print(i['addOnId'])
				productId=i['productId']
				itemCount=i['itemCount']
				itemGiftId=i['addOnId']
				try:
					print("1")
					url2 = str(settings.STORE_ACCESS_URL)+"store/products/viewProductForOthers/"
					print("2")
					payload2={'AccessKey': str(settings.STORE_ACCESS_KEY),
					'storeID': data.get('storeID'),
					'productId': productId
					}
					res2 = requests.request("POST", url2,data=payload2)
					print(res2.json())
					# return Response(res2.json())
				except Exception as e:
					print(e)
					response['status_code']=500
					response['status_message']=str(e)
					return Response(response)			
				res2=res2.json()
				
				itemProductPrice=res2['data']['productPrice']
				for j in res2['data']['giftData']['giftQuantities']:
					if j['addOnId']==itemGiftId:
						itemGiftPrice=j['addOnPrice']
						break

				totalCount=itemCount
				itemProductPrice=int(itemProductPrice)

				itemGiftPrice=int(itemGiftPrice)

				itemCount=int(itemCount)
				if itemCount==1:
					tempPrice=itemGiftPrice+itemProductPrice
					itemServiceTotal=tempPrice*itemCount
				elif itemCount==0:
					itemServiceTotal=0
				elif itemCount>1:
					itemServiceTotal=itemProductPrice*itemCount
					itemServiceTotal=itemServiceTotal+itemGiftPrice
				
				
				finalItemServiceTotal=int(finalItemServiceTotal)+int(itemServiceTotal)
				# finalItemServiceTotal=int(finalItemServiceTotal)+int(itemServiceTotal)
				# alreadyInCart=cart.objects.filter(finalCalculation=cartCalcAlready,productID=productId).first()
				# if not alreadyInCart:
				alreadyInCart=cart.objects.create(finalCalculation=cartCalcAlready,productID=productId)
				alreadyInCart.itemCount=int(itemCount)
				alreadyInCart.itemServiceTotal=int(itemServiceTotal)
				alreadyInCart.itemAddOnId=itemGiftId
				alreadyInCart.relatedID=data.get('storeID')
				alreadyInCart.save()
				innerData.append({'productID':productId,
								  'itemCount':itemCount,
								  'itemAddOnId':itemGiftId})
			km=0
			rewardDiscount=0
			coupounDiscount=0
			try:
				import haversine as hs
				from haversine import Unit
				loc1=(float(res['data']['latitude']),float(res['data']['longitude']))
				loc2=(float(data.get('latitude')),float(data.get('longitude')))
				a=hs.haversine(loc1,loc2,unit=Unit.METERS)
				print(a)
				km=float(a)*float(0.001)
				km=round(km)
				km=int(km)
			except Exception as e:
				print("===-===-===-===-===-===-===-===-===-===-",e)
			theCharges=deliverycharges.objects.all().last()
			chargesOfKM=1
			if theCharges:
				chargesOfKM=int(theCharges.charges)
			totalDeliveryCharges=int(km)*int(chargesOfKM)
			tempDelveryChargesForOnlyFrontend=float(totalDeliveryCharges)
			serviceTotalTemp=0
			serviceTotalTemp=serviceTotalTemp+finalItemServiceTotal
			finalGrandTotalBefore=finalItemServiceTotal+totalDeliveryCharges
			finalGrandTotal=finalItemServiceTotal+totalDeliveryCharges
			if data.get('couponcode'):
				functionResponse=applyCoupon(data.get('couponcode'),finalGrandTotal)
				if functionResponse['status_code']==200:
					discountOnItem=functionResponse['data'][0]['discount']
					finalGrandTotal=functionResponse['data'][0]['ampuntAfterCoupon']
					discountOnItem=float(discountOnItem)
					finalGrandTotal=float(finalGrandTotal)
					coupounDiscount=float(discountOnItem)
					# cartCalcAlready.finalDiscount=discountOnItem
					# cartCalcAlready.finalGrandTotal=finalGrandTotal
					cartCalcAlready.couponcode=data.get('couponcode')
				else:
					return Response(functionResponse)
			theDelveryDiscount=0
			freeItemName=''
			freeItemImage=''
			rewardDiscountonItem=0
			rewardDiscountonDelivery=0
			if data.get('isRewardApply')=='YES':
				print("i am in reward apply =======================================================")
				rewardResponse=applyRewardCart(customerObjects.userUniqueID,data.get('rewardType'),finalItemServiceTotal,totalDeliveryCharges)			
				print(rewardResponse)
				totalDiscount=rewardResponse['data'][0]['discountOnItem']
				rewardDiscountonItem=totalDiscount
				print('rewardDiscountonItem',rewardDiscountonItem)
				totalDiscount=float(totalDiscount)
				discountOnItem=float(discountOnItem)+float(totalDiscount)
				# finalGrandTotal=float(finalGrandTotal)-float(totalDiscount)
				theDelveryDiscount=rewardResponse['data'][0]['discountOnDelivery']
				rewardDiscountonDelivery=theDelveryDiscount
				print('rewardDiscountonDelivery',rewardDiscountonDelivery)
				freeItemImage=rewardResponse['data'][0]['freeItemImage']
				freeItemName=rewardResponse['data'][0]['freeItemName']
				theDelveryDiscount=float(theDelveryDiscount)
				# finalGrandTotal=float(finalGrandTotal)-float(theDelveryDiscount)
				tempDelveryChargesForOnlyFrontend=float(tempDelveryChargesForOnlyFrontend)-float(theDelveryDiscount)
				cartCalcAlready.rewardtype=data.get('rewardType')

				print("i am in reward apply end =======================================================")
			rewardDiscount=rewardDiscountonItem+rewardDiscountonDelivery
			print(rewardDiscount)
			theTotalDiscountOFTotal=float(rewardDiscount)+float(coupounDiscount)
			finalGrandTotal=finalGrandTotal-rewardDiscount
			cartCalcAlready.discountOnDelivery=theDelveryDiscount
			cartCalcAlready.freeItemImage=freeItemImage
			cartCalcAlready.freeItemName=freeItemName
			# cartCalcAlready.finalDiscount=theTotalDiscountOFTotal
			cartCalcAlready.finalDiscount=0
			# cartCalcAlready.finalDiscount=discountOnItem
			# cartCalcAlready.finalGrandTotal=finalGrandTotal
			cartCalcAlready.finalGrandTotal=finalGrandTotalBefore
			cartCalcAlready.finalDeliveryFee=totalDeliveryCharges
			cartCalcAlready.finalServiceTotal=serviceTotalTemp
			cartCalcAlready.companyID=theCompanyID
			cartCalcAlready.relatedID=data.get('storeID')

			cartCalcAlready.rewardDiscount=rewardDiscount
			cartCalcAlready.coupounDiscount=coupounDiscount
			cartCalcAlready.rewardDiscountonItem=rewardDiscountonDelivery
			cartCalcAlready.rewardDiscountonDelivery=rewardDiscountonDelivery
			cartCalcAlready.save()
			theRewardsData=getTheRewardsOfCustomer(customerObjects.userUniqueID)
			allData.update({'products':innerData,
							'giftPrice':str(format(float(itemGiftPrice),".2f")),
							'itemServiceTotal':str(format(float(finalItemServiceTotal),".2f")),
							'itemDiscount':str(format(float(theTotalDiscountOFTotal),".2f")),
							'itemDeliveryFee':str(format(float(tempDelveryChargesForOnlyFrontend),".2f")),
							'discountOnDeliveryFee':str(format(float(theDelveryDiscount),".2f")),
							'grandTotal':str(format(float(finalGrandTotal),".2f")),
							'rewardDiscount':str(format(float(rewardDiscount),".2f")),
							'coupounDiscount':str(format(float(coupounDiscount),".2f")),
							'freeItemImage':str(freeItemImage),
							'freeItemName':str(freeItemName),
							'isRewardApply':data.get('isRewardApply'),
							'rewardData':theRewardsData,})
			
			# response['rewardData']=getTheRewardsOfCustomer(customerObjects.userUniqueID)
			response['status_code']=200
			response['status_message']='Success'
			response['data']=allData
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
		return Response(response)

class checkLocationRadius(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			if not data.get('latitude'):
				response['status_code']=400
				response['status_message']='latitude required'
				return Response(response)
			if not data.get('longitude'):
				response['status_code']=400
				response['status_message']='longitude required'
				return Response(response)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required'
				return Response(response)
			if not data.get('stateName'):
				response['status_code']=400
				response['status_message']='stateName required'
				return Response(response)
			if not data.get('countryName'):
				response['status_code']=400
				response['status_message']='countryName required'
				return Response(response)
			
			isinState=False
			isinRadius=False
			try:
				import requests
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/setting/checkStateIsValid/"
				payload={'countryName': data.get('countryName'),
				        'stateName':data.get('stateName'),}
				resd = requests.request("POST", url, data=payload)
				resd = resd.json()
				if resd['status_code']==400:
					isinState=False
					pass
				else:
					isinState=True
					pass
				# print(response.text)
				# return Response(resd)
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)

			try:
				url = str(settings.STORE_ACCESS_URL)+"store/get/getStoreByCustomer/"
				payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
				'storeID': data.get('storeID'),
				}
				res = requests.request("POST", url,data=payload)
				print(res.json())
				# return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			res=res.json()
			km=0
			try:
				import haversine as hs
				from haversine import Unit
				loc1=(float(res['data']['latitude']),float(res['data']['longitude']))
				loc2=(float(data.get('latitude')),float(data.get('longitude')))
				a=hs.haversine(loc1,loc2,unit=Unit.METERS)
				print(a)
				km=float(a)*float(0.001)
				km=round(km)
				km=int(km)
			except Exception as e:
				km=0
				print("===-===-===-===-===-===-===-===-===-===-",e)
			if km>50:
				isinRadius=False
				# response['status_code']=200
				# response['status_message']='Delivery out side radius'
				# response['isinRadius']=False
			else:
				isinRadius=True
				# response['status_code']=200
				# response['status_message']='Success'
				# response['isinRadius']=True
			response['isinRadius']=isinRadius
			response['isinState']=isinState
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
		return Response(response)

class placeOrder(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			print("==1==")
			allDataNew=[]
			# innerData=[]
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			
			if not data.get('stateName'):
				response['status_code']=400
				response['status_message']='stateName required'
				return Response(response)

			if not data.get('countryName'):
				response['status_code']=400
				response['status_message']='countryName required'
				return Response(response)
			try:
				import requests
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/setting/checkStateIsValid/"
				payload={'countryName': data.get('countryName'),
				        'stateName':data.get('stateName'),}
				resd = requests.request("POST", url, data=payload)
				resd = resd.json()
				if resd['status_code']==400:
					return Response(resd)
				else:
					pass
				# print(response.text)
				# return Response(resd)
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)

			if not data.get('productData'):
				response['status_code']=400
				response['status_message']='productData required'
				return Response(response)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required.'
				return Response(response)
			if not data.get('fullAddress'):
				response['status_code']=400
				response['status_message']='fullAddress required.'
				return Response(response)
			if not data.get('latitude'):
				response['status_code']=400
				response['status_message']='latitude required.'
				return Response(response)
			if not data.get('longitude'):
				response['status_code']=400
				response['status_message']='longitude required.'
				return Response(response)
			if data.get('couponcode'):
				couponObject=coupon.objects.filter(couponcode=data.get('couponcode')).first()
				if not couponObject:
					response['status_code']=400
					response['status_message']='Invalid coupon code'
					return Response(response)
			# if not data.get('companyID'):
			# 	response['status_code']=400
			# 	response['status_message']='longitude required.'
			# 	return Response(response)
			# if not data.get('instruction'):
			# 	response['status_code']=400
			# 	response['status_message']='instruction required.'
			# 	return Response(response)
			productData=data.get('productData')
			productData=str(productData)
			productData=json.loads(productData)
			try:
				url = str(settings.STORE_ACCESS_URL)+"store/get/getStoreByCustomer/"
				payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
				'storeID': data.get('storeID'),
				}
				res = requests.request("POST", url,data=payload)
				print(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			print("==2==")
			res=res.json()
			totalDeliveryCharges=0
			discountOnItem=0
			itemCount=1
			itemProductPrice=0
			itemGiftPrice=0
			finalItemServiceTotal=0
			finalGrandTotal=0
			theCompanyID=res['data']['companyID']
			theNameOfTheStore=res['data']['name']
			theImageOfTheStore=res['data']['image']
			latExt=orderPack.objects.all().last()
			if latExt:
				lastId=latExt.orderID
				last5Number=lastId[3:]
				last5Number=int(last5Number)
				new5Number=last5Number+1
				new5Number=str(new5Number)
				new5Number = new5Number.zfill(5)
				theUniqueID=str('ORD')+str(new5Number)
			else:
				theUniqueID=str('ORD')+str('00001')
			print("==3==")
			orderPackObjects=orderPack.objects.create(customerID=customerObjects.userUniqueID,orderID=theUniqueID)
			print("==4==")
			customerAddressObject=deliveryAddress.objects.create(customerID=customerObjects.userUniqueID)
			customerAddressObject.address=data.get('fullAddress')
			customerAddressObject.latitude=data.get('latitude')
			customerAddressObject.longitude=data.get('longitude')
			customerAddressObject.save()
			innerData=[]
			allData={}
			for i in productData:
				print(i)
				print(i['productId'])
				print(i['itemCount'])
				print(i['addOnId'])
				productId=i['productId']
				itemCount=i['itemCount']
				addOnID=i['addOnId']
				try:
					url2 = str(settings.STORE_ACCESS_URL)+"store/products/viewProductForOthers/"
					payload2={'AccessKey': str(settings.STORE_ACCESS_KEY),
					'storeID': data.get('storeID'),
					'productId': productId
					}
					res2 = requests.request("POST", url2,data=payload2)
					print(res2.json())
				except Exception as e:
					print(e)
					response['status_code']=500
					response['status_message']=str(e)
					return Response(response)			
				res2=res2.json()
				
				itemProductPrice=res2['data']['productPrice']
				for j in res2['data']['giftData']['giftQuantities']:
					if j['addOnId']==addOnID:
						itemGiftPrice=j['addOnPrice']
						break
				totalCount=itemCount
				itemProductPrice=int(itemProductPrice)

				itemGiftPrice=int(itemGiftPrice)

				itemCount=int(itemCount)
				if itemCount==1:
					tempPrice=itemGiftPrice+itemProductPrice
					itemServiceTotal=tempPrice*itemCount
				elif itemCount==0:
					itemServiceTotal=0
				elif itemCount>1:
					itemServiceTotal=itemProductPrice*itemCount
					itemServiceTotal=itemServiceTotal+itemGiftPrice
				
				finalItemServiceTotal=int(finalItemServiceTotal)+int(itemServiceTotal)
				# finalItemServiceTotal=int(finalItemServiceTotal)+int(itemServiceTotal)
				
				orderObjects=order.objects.create(orderPack=orderPackObjects,productID=productId)
				orderObjects.orderCount=int(itemCount)
				orderObjects.orderTotal=int(itemServiceTotal)
				orderObjects.itemAddOnId=addOnID
				orderObjects.save()
				innerData.append({'productID':productId,
								  'itemCount':itemCount,
								  'itemAddOnId':addOnID})
			km=0
			rewardDiscount=0
			coupounDiscount=0
			try:
				import haversine as hs
				from haversine import Unit
				loc1=(float(res['data']['latitude']),float(res['data']['longitude']))
				loc2=(float(data.get('latitude')),float(data.get('longitude')))
				a=hs.haversine(loc1,loc2,unit=Unit.METERS)
				print(a)
				km=float(a)*float(0.001)
				km=round(km)
				km=int(km)
			except Exception as e:
				print("===-===-===-===-===-===-===-===-===-===-",e)
			theCharges=deliverycharges.objects.all().last()
			chargesOfKM=1
			if theCharges:
				chargesOfKM=int(theCharges.charges)
			totalDeliveryCharges=int(km)*int(chargesOfKM)
			tempDelveryChargesForOnlyFrontend=float(totalDeliveryCharges)
			serviceTotalTemp=0
			serviceTotalTemp=serviceTotalTemp+finalItemServiceTotal
			finalGrandTotal=finalItemServiceTotal+totalDeliveryCharges
			if data.get('couponcode'):
				functionResponse=applyCoupon(data.get('couponcode'),finalGrandTotal)
				if functionResponse['status_code']==200:
					discountOnItem=functionResponse['data'][0]['discount']
					finalGrandTotal=functionResponse['data'][0]['ampuntAfterCoupon']
					discountOnItem=float(discountOnItem)
					finalGrandTotal=float(finalGrandTotal)
					coupounDiscount=float(discountOnItem)
					# orderPackObjects.orderDiscount=discountOnItem
					# orderPackObjects.orderGrandTotal=finalGrandTotal
					# orderPackObjects.orderDistance=int(km)
					orderPackObjects.couponcode=data.get('couponcode')
				else:
					return Response(functionResponse)
					
			theDelveryDiscount=0
			freeItemName=''
			freeItemImage=''
			rewardDiscountonItem=0
			rewardDiscountonDelivery=0
			if data.get('isRewardApply')=='YES':
				rewardResponse=applyReward(customerObjects.userUniqueID,data.get('rewardType'),finalItemServiceTotal,totalDeliveryCharges)			
				totalDiscount=rewardResponse['data'][0]['discountOnItem']
				totalDiscount=float(totalDiscount)
				rewardDiscountonItem=totalDiscount
				discountOnItem=float(discountOnItem)+float(totalDiscount)
				# finalGrandTotal=float(finalGrandTotal)-float(totalDiscount)
				theDelveryDiscount=rewardResponse['data'][0]['discountOnDelivery']
				rewardDiscountonDelivery=theDelveryDiscount
				freeItemImage=rewardResponse['data'][0]['freeItemImage']
				freeItemName=rewardResponse['data'][0]['freeItemName']
				# theFreeItem=rewardResponse['data'][0]['freeItem']
				theDelveryDiscount=float(theDelveryDiscount)
				# finalGrandTotal=float(finalGrandTotal)-float(theDelveryDiscount)
				tempDelveryChargesForOnlyFrontend=float(tempDelveryChargesForOnlyFrontend)-float(theDelveryDiscount)
				orderPackObjects.rewardtype=data.get('rewardType')
			rewardDiscount=rewardDiscountonItem+rewardDiscountonDelivery
			theTotalDiscountOFTotal=float(coupounDiscount)+float(rewardDiscount)
			finalGrandTotal=finalGrandTotal-rewardDiscount
			orderPackObjects.orderDiscount=theTotalDiscountOFTotal
			# orderPackObjects.orderDiscount=discountOnItem
			orderPackObjects.orderGrandTotal=finalGrandTotal
			orderPackObjects.discountOnDelivery=theDelveryDiscount
			orderPackObjects.freeItemImage=freeItemImage
			orderPackObjects.freeItemName=freeItemName
			# orderPackObjects.freeItem=theFreeItem
			# finalGrandTotal=finalGrandTotal-discountOnItem
			# orderPackObjects.orderDiscount=discountOnItem
			orderPackObjects.orderDeliveryFee=totalDeliveryCharges
			# orderPackObjects.orderGrandTotal=finalGrandTotal
			orderPackObjects.orderServiceTotal=serviceTotalTemp
			orderPackObjects.deliveryAddress=customerAddressObject
			orderPackObjects.relatedID=data.get('storeID')
			if data.get('instruction'):
				orderPackObjects.instruction=data.get('instruction')
			else:
				orderPackObjects.instruction=''
			orderPackObjects.companyID=theCompanyID

			orderPackObjects.rewardDiscount=rewardDiscount
			orderPackObjects.coupounDiscount=coupounDiscount
			orderPackObjects.rewardDiscountonItem=rewardDiscountonDelivery
			orderPackObjects.rewardDiscountonDelivery=rewardDiscountonDelivery
			orderPackObjects.save()
			allData.update({'products':innerData,
							'itemServiceTotal':str(format(float(finalItemServiceTotal),".2f")),
							'itemDiscount':str(format(float(theTotalDiscountOFTotal),".2f")),
							# 'itemDiscount':str(format(float(discountOnItem),".2f")),
							'itemDeliveryFee':str(format(float(totalDeliveryCharges),".2f")),
							'discountOnDeliveryFee':str(format(float(theDelveryDiscount),".2f")),
							'grandTotal':str(format(float(finalGrandTotal),".2f")),
							'orderID':theUniqueID,
							'rewardDiscount':str(format(float(rewardDiscount),".2f")),
							'coupounDiscount':str(format(float(coupounDiscount),".2f")),
							'freeItemImage':str(freeItemImage),
							'freeItemName':str(freeItemName),})
			allDataOrderListData={}
			# GET DETAILS OF ORDER FROM HERE 
			# for i in orderPackObjects:
			i=orderPackObjects
			storeData=getStoreData(i.relatedID)
			# print(storeData)
			# print(type(storeData))
			# print("data reacived here ")
			theAddressSerial=GetCustomerAddress(i.deliveryAddress)
			addressData=theAddressSerial.data
			if i.orderStatus=='Pending':
				statusOrder='Pending'
				statusColor='F5A06E'
			elif i.orderStatus=='Accepted':
				statusOrder='Accepted'
				statusColor='0FD3A8'
			elif i.orderStatus=='Rejected':
				statusOrder='Rejected'
				statusColor='F6091D'
			elif i.orderStatus=='Assigned':
				statusOrder='Assigned'
				statusColor='0FD3A8'
			elif i.orderStatus=='PickedUP':
				statusOrder='PickedUP'
				statusColor='0FD3A8'
			elif i.orderStatus=='Delivered':
				statusOrder='Delivered'
				statusColor='0FD3A8'
			else:
				statusOrder='Canceled'
				statusColor='F6091D'
			dat=i.created_at
			dateOfOrder=dat.strftime("%b %d, %Y")
			allDataOrderListData['storeName']=storeData['name']
			allDataOrderListData['storeImage']=storeData['image']
			allDataOrderListData['pickupAddress']=storeData['address']
			allDataOrderListData['dropAddress']=addressData['address']
			allDataOrderListData['orderID']=i.orderID
			allDataOrderListData['orderDate']=dateOfOrder
			allDataOrderListData['orderStatus']=str(statusOrder)
			allDataOrderListData['orderStatusColor']=str(statusColor)
			allDataOrderListData['orderGrandTotal']=str(format(float(i.orderGrandTotal),".2f"))
			# allDataOrderListData['orderGrandTotal']=storeData['name']

			# allDataOrderListData.append({'storeName':storeData['name'],
			# 				'storeImage':storeData['image'],
			# 				'pickupAddress':storeData['address'],
			# 				'dropAddress':addressData['address'],
			# 				'orderID':i.orderID,
			# 				'orderDate':dateOfOrder,
			# 				'orderStatus':str(statusOrder),
			# 				'orderStatusColor':str(statusColor),
			# 				'orderGrandTotal':i.orderGrandTotal,
			# 				})

			deviceID=customerObjects.fcmtoken
			messageBody={}
			messageBody['body']='Order successfully placed from '+str(theNameOfTheStore)
			innerData={}

			innerData['orderID']=i.orderID
			innerData['storeName']=theNameOfTheStore
			innerData['image']=theImageOfTheStore
			innerData['storeImage']=theImageOfTheStore

			# innerData['pickupAddress']=storeData['address']
			# innerData['dropAddress']=addressData['address']
			# innerData['orderDate']=dateOfOrder
			innerData['orderStatus']=str(statusOrder)
			innerData['orderStatusColor']=str(statusColor)
			# innerData['orderGrandTotal']=i.orderGrandTotal

			messageBody['data']=innerData
			messageBody['type']='order_placed'
			messageBody['title']='Order Placed'
			# messageBody = {'body':'Booking Accepted successfully', 'data':{"booking_id":"722","doctor_name":"n+oImJo3gjNVEFP7hpXgGw==",'image':'https://www.fda.gov/files/cannabis1.png'}, 'type':'booking_accpted','Title':'Booking Accepted'}
			try:
				theReturnOfPush=sendPush(deviceID,messageBody)
				notifications.objects.create(customerID=customerObjects.userUniqueID,image=messageBody['data']['image'],title=messageBody['title'],description=messageBody['body'])
			
			except Exception as e:
				print(e)

			# john bhatti adding new functionality for sending invoice mail on 25/3/22
			# ---------------------------------------------------------------
			try:
				
				subject='Order placed '
				message = render_to_string('invoice.html', {
					'totalPrice': str(format(float(i.orderGrandTotal),".2f")),
					'name':customerObjects.name,
					})
				fromEmail = settings.EMAIL_HOST_USER
				toEmail = customerObjects.email
				message = EmailMessage(subject, message, fromEmail, [toEmail])
				message.content_subtype = 'html'
				message.send()
			except Exception as e:
				print(e)	


			# ----------------------------------------------

			response['status_code']=200
			response['status_message']='Order placed Successfully'
			response['data']=allDataOrderListData
			response['otherData']=allData

			cartCalcAlready=cartCalculation.objects.filter(customerID=customerObjects.userUniqueID).first()
			if cartCalcAlready:
				for i in productData:
					print(i)
					print(i['productId'])
					print(i['itemCount'])
					print(i['addOnId'])
					productId=i['productId']
					itemCount=i['itemCount']
					addOnID=i['addOnId']
					alreadyInCart=cart.objects.filter(finalCalculation=cartCalcAlready,productID=productId).first()
					if alreadyInCart:
						alreadyInCart.delete()
				cartCalcAlready.delete()

			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
		return Response(response)

class getOrderDetailsForReOrder(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			print("===========1==============")
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			print("===========2==============")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			
			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID required'
				return Response(response)
			print("===========3==============")
			theOrders=orderPack.objects.filter(customerID=customerObjects.userUniqueID,orderID=data.get('orderID')).first()
			
			productData=[]
			if theOrders:
				storeListDataOFDetails={}
				storeData=getStoreData(theOrders.relatedID)

				theStoreID=storeData['storeID']
				theStoreRating=storeData['store_rating']
				theStoreName=storeData['name']
				theStoreImage=storeData['image']
				theStoreAddress=storeData['address']
				storeListDataOFDetails['storeID']=theStoreID
				storeListDataOFDetails['store_rating']=theStoreRating
				storeListDataOFDetails['name']=theStoreName
				storeListDataOFDetails['image']=theStoreImage
				storeListDataOFDetails['address']=theStoreAddress


				# storeListDataOFDetails['storeName']=storeData['name']
				# storeListDataOFDetails['storeImage']=storeData['image']
				# storeListDataOFDetails['pickupAddress']=storeData['address']
				response['storeData']=storeListDataOFDetails
				theInnerOrders=order.objects.filter(orderPack=theOrders)
				for tD in theInnerOrders:
					productData.append({'productId':tD.productID,
										'itemCount':tD.orderCount,
										'addOnId':tD.itemAddOnId,})

				response['storeData']=storeListDataOFDetails
				response['itemServiceTotal']=theOrders.orderServiceTotal
				response['itemDiscount']=theOrders.orderDiscount
				response['itemDeliveryFee']=theOrders.orderDeliveryFee
				response['grandTotal']=theOrders.orderGrandTotal
				response['productData']=productData
				response['fullAddress']=theOrders.deliveryAddress.address
				response['latitude']=theOrders.deliveryAddress.latitude
				response['longitude']=theOrders.deliveryAddress.longitude
				response['storeID']=theOrders.relatedID
				if not theOrders.instruction:
					response['instruction']=''
				else:
					response['instruction']=theOrders.instruction
				response['status_code']=200
				response['status_message']='Success'
			else:
				response['status_code']=400
				response['status_message']='No data found'
			return Response(response)
		except Exception as e:
			print(e)
			import sys, os
			exc_type, exc_obj, exc_tb = sys.exc_info()
			fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
			print(exc_type, fname, exc_tb.tb_lineno)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class getListOfOrdersForCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if data.get('search'):
				if data.get('status'):
					theOrders=orderPack.objects.filter(relatedID=data.get('storeID'),orderID__contains=data.get('search'),orderStatus=data.get('status')).order_by('-orderID')
				else:
					theOrders=orderPack.objects.filter(relatedID=data.get('storeID'),orderID__contains=data.get('search')).order_by('-orderID')
			else:
				if data.get('status'):
					theOrders=orderPack.objects.filter(relatedID=data.get('storeID'),orderStatus=data.get('status')).order_by('-orderID')
				else:
					theOrders=orderPack.objects.filter(relatedID=data.get('storeID')).order_by('-orderID')
				# theOrders=orderPack.objects.filter(relatedID=data.get('storeID')).order_by('-orderID')
			# theOrders=orderPack.objects.filter(relatedID=data.get('storeID')).order_by('-orderID')
			theOrderSerial=GetOrdersData(theOrders,many=True)
			response['data']=theOrderSerial.data
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
		return Response(response)

class getOrderDetailsForCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required'
				return Response(response)
			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			allData=[]
			theOrders=orderPack.objects.filter(relatedID=data.get('storeID'),orderID=data.get('orderID')).first()
			from storeproducts.models import order
			theOrdersData=order.objects.filter(orderPack=theOrders)
			for order in theOrdersData:
				try:
					url = str(settings.STORE_ACCESS_URL)+"store/get/getProductByCustomerForOneOrderDetails/"
					payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
							'storeID': theOrders.relatedID,
							'productId': order.productID,
							'orderCount': order.orderCount,
							'orderTotal': order.orderTotal,
							}
					res = requests.request("POST", url,data=payload)
					res = res.json()
					# print(res)
					if res['status_code']==200:
						allData.append({'orderCount':res['data'][0]['orderCount'],
										'orderTotal':res['data'][0]['orderTotal'],
										'productId':res['data'][0]['innerData']['productId'],
										'productName':res['data'][0]['innerData']['productName'],
										'productPrice':res['data'][0]['innerData']['productPrice'],
										'productImage':res['data'][0]['innerData']['productImage'],
										'productRating':res['data'][0]['innerData']['productRating'],
										'giftData':res['data'][0]['innerData']['giftData'],
										'itemAddOnId':order.itemAddOnId,})
				except Exception as e:
					print(e)
					import sys, os
					exc_type, exc_obj, exc_tb = sys.exc_info()
					fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
					print(exc_type, fname, exc_tb.tb_lineno)
			

			# response['data']=theOrderSerial.data
			theOrderSerial=GetOrdersData(theOrders)
			response['data']=theOrderSerial.data
			response['productData']=allData

			
			if theOrders.driverID!='':
				try:
					url = str(settings.DRIVER_ACCESS_URL)+"driver/order/getDriverDetailsOfOrder/"
					payload={'AccessKey': str(settings.DRIVER_ACCESS_KEY),
							'driverID': theOrders.driverID,
							}
					res = requests.request("POST", url,data=payload)
					res = res.json()
					if res['status_code']==200:
						response['driverData']=res['data']
					else:
						return Response(res)
				except Exception as e:
					response['status_code']=500
					response['status_message']=str(e)
					print(e)
			else:
				theDataOfDriver={}
				theDataOfDriver['name']=''
				theDataOfDriver['image']=''
				theDataOfDriver['phone']=''
				theDataOfDriver['countrycode']=''
				theDataOfDriver['latitude']='0.0'
				theDataOfDriver['longitude']='0.0'
				response['driverData']=theDataOfDriver

			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
		return Response(response)

class acceptRejectOrder(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required'
				return Response(response)
			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID required'
				return Response(response)
			if not data.get('storeName'):
				response['status_code']=400
				response['status_message']='storeName required'
				return Response(response)
			if not data.get('storeImage'):
				response['status_code']=400
				response['status_message']='storeImage required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			
			print("storeID",data.get('storeID'))
			print("orderID",data.get('orderID'))
			print("orderStatus",data.get('orderStatus'))
			print("orderStatus",type(data.get('orderStatus')))

			theOrders=orderPack.objects.filter(relatedID=data.get('storeID'),orderID=data.get('orderID')).first()
			print("theOrders",theOrders)
			
			customerObjects=Customer.objects.filter(userUniqueID=theOrders.customerID).first()
			statusChangeTo=''
			if theOrders:
				if data.get('orderStatus')=='Accept':
					print("Accepted")
					statusChangeTo='Accepted'
					theOrders.orderStatus='Accepted'
					theOrders.save()
				elif data.get('orderStatus')=='Reject':
					print("Rejected")
					statusChangeTo='Rejected'
					theOrders.orderStatus='Rejected'
					theOrders.save()
				else:
					print("Passed")
					pass
				i=theOrders
				statusOrder=''
				statusColor=''
				if i.orderStatus=='Pending':
					statusOrder='Pending'
					statusColor='F5A06E'
				elif i.orderStatus=='Accepted':
					statusOrder='Accepted'
					statusColor='0FD3A8'
				elif i.orderStatus=='Rejected':
					statusOrder='Rejected'
					statusColor='F6091D'
				elif i.orderStatus=='Assigned':
					statusOrder='Assigned'
					statusColor='0FD3A8'
				elif i.orderStatus=='PickedUP':
					statusOrder='PickedUP'
					statusColor='0FD3A8'
				elif i.orderStatus=='Delivered':
					statusOrder='Delivered'
					statusColor='0FD3A8'
				else:
					statusOrder='Canceled'
					statusColor='F6091D'
				deviceID=customerObjects.fcmtoken
				messageBody={}
				messageBody['body']='Order '+str(statusChangeTo)+' by '+str(data.get('storeName'))
				innerData={}

				innerData['orderID']=i.orderID
				innerData['storeName']=data.get('storeName')
				innerData['image']=data.get('storeImage')
				innerData['storeImage']=data.get('storeImage')
				innerData['orderStatus']=str(statusOrder)
				innerData['orderStatusColor']=str(statusColor)

				messageBody['data']=innerData
				messageBody['type']='order_'+lower(statusChangeTo)
				messageBody['title']='Order '+str(statusChangeTo)
				try:
					theReturnOfPush=sendPush(deviceID,messageBody)
				except Exception as e:
					print(e)
				notifications.objects.create(customerID=customerObjects.userUniqueID,image=messageBody['data']['image'],title=messageBody['title'],description=messageBody['body'])
				response['status_code']=200
				response['status_message']='Success'
			else:
				response['status_code']=400
				response['status_message']='Oops! something went wrong'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
		return Response(response)

class assignDriver(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required'
				return Response(response)
			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID required'
				return Response(response)
			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='driverID required'
				return Response(response)
			
			if not data.get('driverName'):
				response['status_code']=400
				response['status_message']='driverName required'
				return Response(response)
			if not data.get('driverImage'):
				response['status_code']=400
				response['status_message']='driverImage required'
				return Response(response)
				
			if not data.get('storeImage'):
				response['status_code']=400
				response['status_message']='storeImage required'
				return Response(response)
			if not data.get('storeName'):
				response['status_code']=400
				response['status_message']='storeName required'
				return Response(response)
			

			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)

			theOrders=orderPack.objects.filter(relatedID=data.get('storeID'),orderID=data.get('orderID')).first()
			if theOrders:
				if data.get('driverID'):
					# theOrders.orderStatus='Assigned'
					theOrders.driverStatus='Assigned'
					theOrders.driverID=data.get('driverID')
					theOrders.save()


					customerObjects=Customer.objects.filter(userUniqueID=theOrders.customerID).first()
					statusChangeTo=''
					if theOrders:
						if data.get('orderStatus')=='Accept':
							print("Accepted")
							statusChangeTo='Accepted'
							theOrders.orderStatus='Accepted'
							theOrders.save()
						elif data.get('orderStatus')=='Reject':
							print("Rejected")
							statusChangeTo='Rejected'
							theOrders.orderStatus='Rejected'
							theOrders.save()
						else:
							print("Passed")
							pass
						# i=theOrders
						# statusOrder=''
						# statusColor=''
						# if i.orderStatus=='Pending':
						# 	statusOrder='Pending'
						# 	statusColor='F5A06E'
						# elif i.orderStatus=='Accepted':
						# 	statusOrder='Accepted'
						# 	statusColor='0FD3A8'
						# elif i.orderStatus=='Rejected':
						# 	statusOrder='Rejected'
						# 	statusColor='F6091D'
						# elif i.orderStatus=='Assigned':
						# 	statusOrder='Assigned'
						# 	statusColor='0FD3A8'
						# elif i.orderStatus=='PickedUP':
						# 	statusOrder='PickedUP'
						# 	statusColor='0FD3A8'
						# elif i.orderStatus=='Delivered':
						# 	statusOrder='Delivered'
						# 	statusColor='0FD3A8'
						# else:
						# 	statusOrder='Canceled'
						# 	statusColor='F6091D'
						# deviceID=customerObjects.fcmtoken
						# messageBody={}
						# messageBody['body']=str(data.get('driverName'))+' driver has been assigned to your order'
						# innerData={}

						# innerData['orderID']=i.orderID
						# innerData['storeName']=data.get('storeName')
						# innerData['image']=data.get('driverImage')
						# innerData['storeImage']=data.get('storeImage')
						# innerData['orderStatus']=str(statusOrder)
						# innerData['orderStatusColor']=str(statusColor)

						# messageBody['data']=innerData
						# messageBody['type']='driver_assigned'
						# messageBody['title']='Driver Assigned'
						# theReturnOfPush=sendPush(deviceID,messageBody)
						# notifications.objects.create(customerID=customerObjects.userUniqueID,image=messageBody['data']['image'],title=messageBody['title'],description=messageBody['body'])
				


					response['status_code']=200
					response['status_message']='Success'
				else:
					response['status_code']=400
					response['status_message']='Driver id required'
				
			else:
				response['status_code']=400
				response['status_message']='Invalid Order Id'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
		return Response(response)

class getSafePlaces(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required'
				return Response(response)
			try:
				url = str(settings.STORE_ACCESS_URL)+"store/order/getSafePlaces/"
				payload={
						 'AccessKey': str(settings.STORE_ACCESS_KEY),
						 'storeID': data.get('storeID')
						 }
				res = requests.request("POST", url,data=payload)
				return Response(res.json())
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
		return Response(response)

def getStoreData(storeId):
	try:
		url = str(settings.STORE_ACCESS_URL)+"store/get/getStoreByCustomer/"
		payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
		'storeID': str(storeId),
		}
		print("storeID",storeId)
		res = requests.request("POST", url,data=payload)
		res=res.json()
		print("json returned drom function")
		print(res)
		print(res['data'])
		return res['data']
	except Exception as e:
		print(e)
		return ''

class getListOfOrders(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			if not data.get('listType'):
				response['status_code']=400
				response['status_message']='listType required'
				return Response(response)
			if not data.get('page'):
				response['status_code']=400
				response['status_message']='page required'
				return Response(response)
			if data.get('listType')=='active':
				theOrders=orderPack.objects.filter(Q(customerID=customerObjects.userUniqueID)& Q(Q(orderStatus='Pending')|Q(orderStatus='Accepted')|Q(orderStatus='Assigned')|Q(orderStatus='PickedUP'))).order_by('-orderID')
				# print("the object",theOrders)
				# theOrderSerial=GetOrdersDataList(theOrders,many=True)
				# response['data']=theOrderSerial.data
			elif data.get('listType')=='history':
				theOrders=orderPack.objects.filter(Q(customerID=customerObjects.userUniqueID) & Q(Q(orderStatus='Delivered')|Q(orderStatus='Canceled')|Q(orderStatus='Rejected'))).order_by('-orderID')
				# print("the object",theOrders)
				# theOrderSerial=GetOrdersDataList(theOrders,many=True)
				# response['data']=theOrderSerial.data
			else:
				response['data']=[]
			response['data']=[]
			allData=[]
			if theOrders:
				for i in theOrders:
					storeData=getStoreData(i.relatedID)
					# print(storeData)
					# print(type(storeData))
					# print("data reacived here ")
					theAddressSerial=GetCustomerAddress(i.deliveryAddress)
					addressData=theAddressSerial.data
					if i.orderStatus=='Pending':
						statusOrder='Pending'
						statusColor='F5A06E'
					elif i.orderStatus=='Accepted':
						statusOrder='Accepted'
						statusColor='0FD3A8'
					elif i.orderStatus=='Rejected':
						statusOrder='Rejected'
						statusColor='F6091D'
					elif i.orderStatus=='Assigned':
						statusOrder='Assigned'
						statusColor='0FD3A8'
					elif i.orderStatus=='PickedUP':
						statusOrder='PickedUP'
						statusColor='0FD3A8'
					elif i.orderStatus=='Delivered':
						statusOrder='Delivered'
						statusColor='0FD3A8'
					else:
						statusOrder='Canceled'
						statusColor='F6091D'
					dat=i.created_at
					dateOfOrder=dat.strftime("%b %d, %Y")
					allData.append({'storeName':storeData['name'],
									'storeImage':storeData['image'],
									'pickupAddress':storeData['address'],
									'dropAddress':addressData['address'],
									'orderID':i.orderID,
									'orderDate':dateOfOrder,
									'orderStatus':str(statusOrder),
									'orderStatusColor':str(statusColor),
									'orderGrandTotal':i.orderGrandTotal,
									})
				pageNo=data.get('page')
				pageNo=int(pageNo)
				startPage=0
				endPage=int(settings.PAGE_LIMIT)
				for r in range(1,pageNo):
					startPage=startPage+int(settings.PAGE_LIMIT)
					endPage=endPage+int(settings.PAGE_LIMIT)
				totalRecords=len(allData)
				previousRecords=len(allData[:startPage])
				nextRecords=len(allData[endPage:])
				if previousRecords==0:
					hasPreviousPage=False
				else:
					hasPreviousPage=True
				if nextRecords==0:
					hasNextPage=False
				else:
					hasNextPage=True
				response['hasNextPage']=hasNextPage
				response['hasPreviousPage']=hasPreviousPage
				response['totalRecords']=totalRecords
				response['data']=allData[startPage:endPage]
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)


class getOrderDetails(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			print("===========1==============")
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			print("===========2==============")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			
			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID required'
				return Response(response)
			print("===========3==============")
			theOrders=orderPack.objects.filter(customerID=customerObjects.userUniqueID,orderID=data.get('orderID')).first()
			theOrderSerial=GetOrdersData(theOrders)
			print("===========4==============")
			print(theOrderSerial.data)


			allData=[]
			# if theOrders.relatedTo=='1':
			if theOrders:
				from storeproducts.models import order
				theOrdersData=order.objects.filter(orderPack=theOrders)
				for order in theOrdersData:
					try:
						url = str(settings.STORE_ACCESS_URL)+"store/get/getProductByCustomerForOneOrderDetails/"
						payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
								'storeID': theOrders.relatedID,
								'productId': order.productID,
								'orderCount': order.orderCount,
								'orderTotal': order.orderTotal,
								}
						res = requests.request("POST", url,data=payload)
						res = res.json()
						# print(res)
						if res['status_code']==200:
							allData.append({'orderCount':res['data'][0]['orderCount'],
											'orderTotal':res['data'][0]['orderTotal'],
											'productId':res['data'][0]['innerData']['productId'],
											'productName':res['data'][0]['innerData']['productName'],
											'productPrice':res['data'][0]['innerData']['productPrice'],
											'productImage':res['data'][0]['innerData']['productImage'],
											'productRating':res['data'][0]['innerData']['productRating'],
											'giftData':res['data'][0]['innerData']['giftData'],
											'itemAddOnId':order.itemAddOnId,})
					except Exception as e:
						print(e)
						import sys, os
						exc_type, exc_obj, exc_tb = sys.exc_info()
						fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
						print(exc_type, fname, exc_tb.tb_lineno)
				storeListDataOFDetails={}
				storeData=getStoreData(theOrders.relatedID)
				theStoreID=storeData['storeID']
				theStoreRating=storeData['store_rating']
				theStoreName=storeData['name']
				theStoreImage=storeData['image']
				theStoreAddress=storeData['address']
				storeListDataOFDetails['latitude']=storeData['latitude']
				storeListDataOFDetails['longitude']=storeData['longitude']
				storeListDataOFDetails['storeID']=theStoreID
				storeListDataOFDetails['store_rating']=theStoreRating
				storeListDataOFDetails['name']=theStoreName
				storeListDataOFDetails['image']=theStoreImage
				storeListDataOFDetails['address']=theStoreAddress

				storeListDataOFDetails['phone']=storeData['phone']
				storeListDataOFDetails['countrycode']=storeData['countrycode']
				response['storeData']=storeListDataOFDetails
			response['data']=theOrderSerial.data
			response['productData']=allData
			response['status_code']=200
			response['status_message']='Success'

			print("getting driver info========================================")
			
			if theOrders.driverID!='':
				try:
					print("1==================")
					url = str(settings.DRIVER_ACCESS_URL)+"driver/order/getDriverDetailsOfOrder/"
					payload={'AccessKey': str(settings.DRIVER_ACCESS_KEY),
							'driverID': theOrders.driverID,
							}
					print("2======================")
					res = requests.request("POST", url,data=payload)
					res = res.json()
					print("3===================")
					print(res)
					if res['status_code']==200:
						# res['data']['latitude']=float(res['data']['latitude'])
						# res['data']['longitude']=float(res['data']['longitude'])
						response['driverData']=res['data']
					else:
						return Response(res)
				except Exception as e:
					response['status_code']=500
					response['status_message']=str(e)
					print(e)
			else:
				theDataOfDriver={}
				theDataOfDriver['name']=''
				theDataOfDriver['image']=''
				theDataOfDriver['phone']=''
				theDataOfDriver['countrycode']=''
				theDataOfDriver['latitude']='0.0'
				theDataOfDriver['longitude']='0.0'
				response['driverData']=theDataOfDriver


			# print(response)
			return Response(response)
		except Exception as e:
			print(e)
			import sys, os
			exc_type, exc_obj, exc_tb = sys.exc_info()
			fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
			print(exc_type, fname, exc_tb.tb_lineno)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class clearCart(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			print("==1==")
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			

			cartCalcAlready=cartCalculation.objects.filter(customerID=customerObjects.userUniqueID).first()
			if cartCalcAlready:
				alreadyInCart=cart.objects.filter(finalCalculation=cartCalcAlready)
				for i in alreadyInCart:
					i.delete()
				cartCalcAlready.delete()
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)



class addCard(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			if not data.get('sourceToken'):
				response['status_code']=400
				response['status_message']='sourceToken required'
				return Response(response)

			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			print("==1==")
			if customerObjects.customerStripeId:
				customerId = customerObjects.customerStripeId
				sourceToken=data.get('sourceToken')
				stripe.api_key = settings.STRIPE_SECRET_KEY
				print("==2==")
				createCard = stripe.Customer.create_source(customerId,source=sourceToken)
				print("createCard================>",createCard)
				# create_card = json.loads(create_card)
				if createCard:
					print("==3==")
					alreadyAdefaultCardPresent=CustomerCard.objects.filter(customerID=customerObjects.userUniqueID,isdefault=True).first()
					if alreadyAdefaultCardPresent:
						theDefault=False
					else:
						theDefault=True
					createCardObject = CustomerCard.objects.create(customerID=customerObjects.userUniqueID,cardID=createCard['id'],expMonth=createCard['exp_month'],expYear=createCard['exp_year'],theCustomer=createCard['customer'],lastDigit=createCard['last4'],isdefault=theDefault)
					response['status_code'] = 200
					response['status_message'] = 'Success'
				else:
					print("==4==")
					response['status_code'] = 400
					response['status_message'] = 'Oops! Something went wrong'
			else:
				print("==5==")
				response['status_code'] = 400
				response['status_message'] = 'Oops! Something went wrong'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getCardList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData=[]
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")

			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			theCards=CustomerCard.objects.filter(customerID=customerObjects.userUniqueID)
			for card in theCards:
				context = {}
				context['cardCustomerID'] = card.theCustomer
				context['lastDigit'] =card.lastDigit
				context['expMonth'] = card.expMonth
				context['expYear'] = card.expYear
				context['cardID'] = card.cardID
				context['cardObjectID'] = card.id
				context['isdefault'] = card.isdefault
				allData.append(context)
			response['data']=allData
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def PaymentWithExistingCard(customerID , cardID , totalAmount):
	response = {}
	try:
		print("==2.1==")
		totalAmount=str(totalAmount)
		totalAmount=float(totalAmount)
		totalAmount=int(totalAmount)
		print("==2.2==")
		totalAmount=totalAmount*100
		print("==2.3==")
		totalAmount=int(totalAmount)
		print("==2.4==")
		stripe.api_key  = settings.STRIPE_SECRET_KEY
		stripeAmountCharges = stripe.Charge.create(
			currency="USD",
			customer=customerID,
			card=cardID,
			amount=totalAmount,
			description = "charge from user",
						shipping={
							'name': 'Jenny Rosen',
							'address': {
								'line1': '510 Townsend St',
								'postal_code': '98140',
								'city': 'San Francisco',
								'state': 'CA',
								'country': 'US',
								},
							},
		)
		print("==2.5==")
		print(stripeAmountCharges)
		if stripeAmountCharges:
			response['status'] = True
			response['data'] = stripeAmountCharges
	except Exception as e:
		response['status'] = False
		response['message'] = str(e)
	return response

class orderPay(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData=[]
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			
			session_token = session_token.replace("Token ", "")
			print("==1==")

			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])

			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID required'
				return Response(response)
			if not data.get('cardID'):
				response['status_code']=400
				response['status_message']='cardID required'
				return Response(response)
				
			theCard=CustomerCard.objects.filter(customerID=customerObjects.userUniqueID,cardID=data.get('cardID')).first()
			if not theCard:
				response['status_code']=400
				response['status_message']='Invalid card selection'
				return Response(response)
			
			
			theOrderObject=orderPack.objects.filter(customerID=customerObjects.userUniqueID,orderID=data.get('orderID')).first()
			if not theOrderObject:
				response['status_code']=400
				response['status_message']='Invalid order id'
				return Response(response)
			print("==2==")
			thePaymentObject=PaymentWithExistingCard(theCard.theCustomer,theCard.cardID,theOrderObject.orderGrandTotal)
			print("==3==")
			if thePaymentObject['status'] == True :
				print("==3.1==")
				customerTransactions = CustomerTransaction.objects.create(relatedTo=theOrderObject.relatedTo,relatedID=theOrderObject.relatedID,customerID=customerObjects.userUniqueID,amount=str(theOrderObject.orderGrandTotal),orderPack=theOrderObject,txnID=thePaymentObject['data']['balance_transaction'],recieptUrl=thePaymentObject['data']['receipt_url'])
				theOrderObject.isPaid=True
				theOrderObject.save()
				response['status_code'] = 200
				response['status_message'] = 'Payment has been done successfully'
				response['data'] = thePaymentObject['data']
			else:
				print("==3.2==")
				response['status_code'] = 400
				response['status_message'] = thePaymentObject['message']
			try:
				print("==4==")
				rewardObject=myrewards.objects.filter(customerID=customerObjects.userUniqueID).first()
				if not rewardObject:
					print("==4.1==")
					rewardObject=myrewards.objects.create(customerID=customerObjects.userUniqueID)
				print("==5==")
				rewardObject.totalpoints=int(rewardObject.totalpoints)+1
				rewardObject.availablepoints=int(rewardObject.availablepoints)+1
				rewardObject.save()
				print("==6==")
			except Exception as e:
				print("==7==")
				print(e)
			try:
				url = str(settings.COMPANY_ACCESS_URL)+"company/backend/addEarning/"
				desc='A customer paid '+str(theOrderObject.orderGrandTotal)+' amount of order.'
				payload={'AccessKey': str(settings.COMPANY_ACCESS_KEY),
				'storeID': data.get('storeID'),
				'companyID': str(theOrderObject.companyID),
				'amount': data.get('amount'),
				'title': 'Order Payment',
				'description': desc,

				}
				res = requests.request("POST", url,data=payload)
				print(res.json())
				# return Response(res.json())
			except Exception as e:
				print(e)
		except Exception as e:
			print(e)
			print("==8==")
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class setDefaultCard(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			if not data.get('cardID'):
				response['status_code']=400
				response['status_message']='cardID required'
				return Response(response)

			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			
			theCard=CustomerCard.objects.filter(customerID=customerObjects.userUniqueID,cardID=data.get('cardID')).first()
			if not theCard:
				response['status_code']=400
				response['status_message']='Invalid card selection'
				return Response(response)
			oldDefaultCard=CustomerCard.objects.filter(customerID=customerObjects.userUniqueID,isdefault=True).first()
			if oldDefaultCard:
				oldDefaultCard.isdefault=False
				oldDefaultCard.save()
			theCard.isdefault=True
			theCard.save()
			response['status_code'] = 200
			response['status_message'] = 'Card set default'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class deleteCard(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			if not data.get('cardID'):
				response['status_code']=400
				response['status_message']='cardID required'
				return Response(response)
			
			# if not data.get('cardObjectID'):
			# 	response['status_code']=400
			# 	response['status_message']='cardObjectID required'
			# 	return Response(response)

			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			
			theCard=CustomerCard.objects.filter(customerID=customerObjects.userUniqueID,cardID=data.get('cardID')).first()
			if not theCard:
				response['status_code']=400
				response['status_message']='Invalid card selection'
				return Response(response)
			if theCard.isdefault==True:
				response['status_code']=400
				response['status_message']='You can not delete a default card'
				return Response(response)
			stripe.api_key = settings.STRIPE_SECRET_KEY
			respo=stripe.Customer.delete_source(
				str(theCard.theCustomer),
				str(data.get('cardID')),
				)
			print(respo)
			if respo['deleted']==True:
				theCard.delete()
			response['status_code'] = 200
			response['status_message'] = 'Card Deleted'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getTransactionHistory(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData=[]
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			if not data.get('page'):
				response['status_code']=400
				response['status_message']='page required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			allTransactions=CustomerTransaction.objects.filter(customerID=customerObjects.userUniqueID)
			for trans in allTransactions:
				if trans.relatedTo == '1':
					dat=trans.created_at
					dateOfTransactions=dat.strftime("%b %d, %Y")
					allData.append({'storeID':trans.relatedID,
									'amount':trans.amount,
									'date':str(dateOfTransactions)})
			print("before call ")
			try:
				url = str(settings.STORE_ACCESS_URL)+"store/order/getTransactionHistoryForCustomer/"
				payload={
						 'AccessKey': str(settings.STORE_ACCESS_KEY),
						 'relatedData': json.dumps(allData),
						 'page': data.get('page')
						 }
				res = requests.request("POST", url,data=payload)
				print("call done")
				print(res)
				res = res.json()
				if res['status_code']==200:
					return Response(res)
					# response['data']=res['data']
				else:
					response['data']=[]
					response['status_code']=400
					response['status_message']='No data found'
					return Response(response)
			except Exception as e:
				print(e)
				response['data']=[]
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class cancelOrder(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			
			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID required'
				return Response(response)
			
			if not data.get('cancelReason'):
				response['status_code']=400
				response['status_message']='cancelReason required'
				return Response(response)

			theOrders=orderPack.objects.filter(customerID=customerObjects.userUniqueID,orderID=data.get('orderID')).first()
			theOrders.orderStatus='Canceled'
			theOrders.cancelReason=data.get('cancelReason')
			theOrders.save()
			theOrderSerial=GetOrdersData(theOrders)
			response['data']=theOrderSerial.data
			response['status_code']=200
			response['status_message']='Order Canceled'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class getCompanyOrdersForAdmin(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if not data.get('companyID'):
				response['status_code']=400
				response['status_message']='companyID required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			theOrders=orderPack.objects.filter(companyID=data.get('companyID')).order_by('-orderID')
			theOrderSerial=GetOrdersData(theOrders,many=True)
			response['data']=theOrderSerial.data
			response['status_code']=200
			response['status_message']='Orders Data'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)



class getListOfOrdersOfDriver(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='driverID required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)

			if not data.get('listType'):
				response['status_code']=400
				response['status_message']='listType required'
				return Response(response)
			if not data.get('page'):
				response['status_code']=400
				response['status_message']='page required'
				return Response(response)
			if data.get('listType')=='active':
				theOrders=orderPack.objects.filter(Q(driverID=data.get('driverID'))& Q(Q(orderStatus='Pending')|Q(orderStatus='Accepted')|Q(orderStatus='Rejected')|Q(orderStatus='Assigned')|Q(orderStatus='PickedUP'))).order_by('-orderID')
			elif data.get('listType')=='history':
				theOrders=orderPack.objects.filter(Q(driverID=data.get('driverID')) & Q(Q(orderStatus='Delivered')|Q(orderStatus='Canceled'))).order_by('-orderID')
			else:
				response['data']=[]
			response['data']=[]
			allData=[]
			if theOrders:
				for i in theOrders:
					storeData=getStoreData(i.relatedID)
					theAddressSerial=GetCustomerAddress(i.deliveryAddress)
					addressData=theAddressSerial.data
					if i.orderStatus=='Pending':
						statusOrder='Pending'
						statusColor='F5A06E'
					elif i.orderStatus=='Accepted':
						statusOrder='Accepted'
						statusColor='0FD3A8'
					elif i.orderStatus=='Rejected':
						statusOrder='Rejected'
						statusColor='F6091D'
					elif i.orderStatus=='Assigned':
						statusOrder='Assigned'
						statusColor='0FD3A8'
					elif i.orderStatus=='PickedUP':
						statusOrder='PickedUP'
						statusColor='0FD3A8'
					elif i.orderStatus=='Delivered':
						statusOrder='Delivered'
						statusColor='0FD3A8'
					else:
						statusOrder='Canceled'
						statusColor='F6091D'
					dat=i.created_at
					dateOfOrder=dat.strftime("%b %d, %Y")
					allData.append({'storeName':storeData['name'],
									'storeImage':storeData['image'],
									'pickupAddress':storeData['address'],
									'dropAddress':addressData['address'],
									'orderID':i.orderID,
									'orderDate':dateOfOrder,
									'orderStatus':str(statusOrder),
									'orderStatusColor':str(statusColor),
									'orderGrandTotal':i.orderGrandTotal,
									})
				pageNo=data.get('page')
				pageNo=int(pageNo)
				startPage=0
				endPage=int(settings.PAGE_LIMIT)
				for r in range(1,pageNo):
					startPage=startPage+int(settings.PAGE_LIMIT)
					endPage=endPage+int(settings.PAGE_LIMIT)
				totalRecords=len(allData)
				previousRecords=len(allData[:startPage])
				nextRecords=len(allData[endPage:])
				if previousRecords==0:
					hasPreviousPage=False
				else:
					hasPreviousPage=True
				if nextRecords==0:
					hasNextPage=False
				else:
					hasNextPage=True
				response['hasNextPage']=hasNextPage
				response['hasPreviousPage']=hasPreviousPage
				response['totalRecords']=totalRecords
				response['data']=allData[startPage:endPage]
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
	
class getOrderDetailsOfDriver(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='driverID required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			
			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID required'
				return Response(response)
			print("===========3==============")
			theOrders=orderPack.objects.filter(driverID=data.get('driverID'),orderID=data.get('orderID')).first()
			theOrderSerial=GetOrdersData(theOrders)
			print("===========4==============")
			print(theOrderSerial.data)


			allData=[]
			if theOrders:
				from storeproducts.models import order
				theOrdersData=order.objects.filter(orderPack=theOrders)
				for order in theOrdersData:
					try:
						url = str(settings.STORE_ACCESS_URL)+"store/get/getProductByCustomerForOneOrderDetails/"
						payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
								'storeID': theOrders.relatedID,
								'productId': order.productID,
								'orderCount': order.orderCount,
								'orderTotal': order.orderTotal,
								}
						res = requests.request("POST", url,data=payload)
						res = res.json()
						# print(res)
						if res['status_code']==200:
							allData.append({'orderCount':res['data'][0]['orderCount'],
											'orderTotal':res['data'][0]['orderTotal'],
											'productId':res['data'][0]['innerData']['productId'],
											'productName':res['data'][0]['innerData']['productName'],
											'productPrice':res['data'][0]['innerData']['productPrice'],
											'productImage':res['data'][0]['innerData']['productImage'],
											'productRating':res['data'][0]['innerData']['productRating'],
											'giftData':res['data'][0]['innerData']['giftData'],
											'itemAddOnId':order.itemAddOnId,})
					except Exception as e:
						print(e)
						import sys, os
						exc_type, exc_obj, exc_tb = sys.exc_info()
						fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
						print(exc_type, fname, exc_tb.tb_lineno)
				storeListDataOFDetails={}
				storeData=getStoreData(theOrders.relatedID)
				theStoreID=storeData['storeID']
				theStoreRating=storeData['store_rating']
				theStoreName=storeData['name']
				theStoreImage=storeData['image']
				theStoreAddress=storeData['address']
				storeListDataOFDetails['longitude']=storeData['longitude']
				storeListDataOFDetails['latitude']=storeData['latitude']

				storeListDataOFDetails['storeID']=theStoreID
				storeListDataOFDetails['store_rating']=theStoreRating
				storeListDataOFDetails['name']=theStoreName
				storeListDataOFDetails['image']=theStoreImage
				storeListDataOFDetails['address']=theStoreAddress
				response['storeData']=storeListDataOFDetails
			response['data']=theOrderSerial.data
			response['productData']=allData
			response['status_code']=200
			response['status_message']='Success'
			print(response)
			return Response(response)
		except Exception as e:
			print(e)
			import sys, os
			exc_type, exc_obj, exc_tb = sys.exc_info()
			fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
			print(exc_type, fname, exc_tb.tb_lineno)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
		

class changeOrderStatusFromDriver(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			print("the data ====>",data)
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='driverID required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID required'
				return Response(response)
			if not data.get('orderStatus'):
				response['status_code']=400
				response['status_message']='orderStatus required'
				return Response(response)
			if not data.get('driverName'):
				response['status_code']=400
				response['status_message']='driverName required'
				return Response(response)

			theOrders=orderPack.objects.filter(driverID=data.get('driverID'),orderID=data.get('orderID')).first()
			customerObjects=Customer.objects.filter(userUniqueID=theOrders.customerID).first()
			statusChangeTo=''
			i=theOrders
			statusOrder=''
			statusColor=''
			if i.orderStatus=='Pending':
				statusOrder='Pending'
				statusColor='F5A06E'
			elif i.orderStatus=='Accepted':
				statusOrder='Accepted'
				statusColor='0FD3A8'
			elif i.orderStatus=='Rejected':
				statusOrder='Rejected'
				statusColor='F6091D'
			elif i.orderStatus=='Assigned':
				statusOrder='Assigned'
				statusColor='0FD3A8'
			elif i.orderStatus=='PickedUP':
				statusOrder='PickedUP'
				statusColor='0FD3A8'
			elif i.orderStatus=='Delivered':
				statusOrder='Delivered'
				statusColor='0FD3A8'
			else:
				statusOrder='Canceled'
				statusColor='F6091D'
			deviceID=customerObjects.fcmtoken
			if data.get('orderStatus')=='Delivered':
				print("customerPic",data.get('customerPicLink'))
				if data.get('customerPicLink'):
					pass
				else:
					response['status_code']=400
					response['status_message']='customerPicLink required'
					return Response(response)
				if data.get('customerIDproofFrontLink'):
					pass
				else:
					response['status_code']=400
					response['status_message']='customerIDproofFrontLink required'
					return Response(response)
				
				if data.get('customerIDproofBackLink'):
					pass
				else:
					response['status_code']=400
					response['status_message']='customerIDproofBackLink required'
					return Response(response)
				if data.get('customerSignLink'):
					pass
				else:
					response['status_code']=400
					response['status_message']='customerSignLink required'
					return Response(response)
				theOrders.customerPic=data.get('customerPicLink')
				theOrders.customerIDproofFront=data.get('customerIDproofFrontLink')
				theOrders.customerIDproofBack=data.get('customerIDproofBackLink')
				theOrders.customerSign=data.get('customerSignLink')
				theOrders.orderStatus='Delivered'
				theOrders.save()

				messageBody={}
				messageBody['body']='Your order has been delivered by '+str(data.get('driverName'))
				innerData={}

				innerData['orderID']=i.orderID
				innerData['storeName']=''
				innerData['image']=''
				innerData['storeImage']=''
				innerData['orderStatus']=str(statusOrder)
				innerData['orderStatusColor']=str(statusColor)

				messageBody['data']=innerData
				messageBody['type']='order_delivered'
				messageBody['title']='Order Delivered'
				try:
					theReturnOfPush=sendPush(deviceID,messageBody)
					notifications.objects.create(customerID=customerObjects.userUniqueID,image=messageBody['data']['image'],title=messageBody['title'],description=messageBody['body'])
				except Exception as e:
					print(e)
			elif data.get('orderStatus')=='PickedUP':
				# try:
				# 	storeData=getStoreData(i.relatedID)
				# 	url = "http://18.117.53.164:8003/customer/tracking/addCoordinates/"
				# 	payload={'orderID': data.get('orderID'),
				# 			 'latitude':storeData['latitude'],
				# 			 'longitude':storeData['longitude']}
				# 	res = requests.request("POST", url,data=payload)

				# 	res = res.json()
				# 	if res['status_code']==200:
				# 		pass
				# 		# return Response(res)
				# 		# response['data']=res['data']
				# 	else:
				# 		return Response(res)
				# except Exception as e:
				# 	print(e)
				# 	response['data']=[]
				# 	response['status_code']=500
				# 	response['status_message']=str(e)
				# 	return Response(response)
				theOrders.orderStatus='PickedUP'
				theOrders.save()
				messageBody={}
				messageBody['body']='Your order has been picked by '+str(data.get('driverName'))
				innerData={}

				innerData['orderID']=i.orderID
				innerData['storeName']=''
				innerData['image']=''
				innerData['storeImage']=''
				innerData['orderStatus']=str(statusOrder)
				innerData['orderStatusColor']=str(statusColor)

				messageBody['data']=innerData
				messageBody['type']='order_pickedup'
				messageBody['title']='Order PickedUP'
				try:
					theReturnOfPush=sendPush(deviceID,messageBody)
					notifications.objects.create(customerID=customerObjects.userUniqueID,image=messageBody['data']['image'],title=messageBody['title'],description=messageBody['body'])
				except Exception as e:
					print(e)
			elif data.get('orderStatus')=='Accepted':
				theOrders.orderStatus='Assigned'
				theOrders.driverStatus='Accepted'
				theOrders.save()
				
				messageBody={}
				messageBody['body']=str(data.get('driverName'))+' driver has been assigned to your order'
				innerData={}

				innerData['orderID']=i.orderID
				innerData['storeName']=''
				innerData['image']=''
				innerData['storeImage']=''
				innerData['orderStatus']=str(statusOrder)
				innerData['orderStatusColor']=str(statusColor)

				messageBody['data']=innerData
				messageBody['type']='driver_assigned'
				messageBody['title']='Driver Assigned'
				try:
					theReturnOfPush=sendPush(deviceID,messageBody)
					notifications.objects.create(customerID=customerObjects.userUniqueID,image=messageBody['data']['image'],title=messageBody['title'],description=messageBody['body'])
				except Exception as e:
					print(e)
			elif data.get('orderStatus')=='Rejected':
				theOrders.orderStatus='Accepted'
				theOrders.driverStatus='Rejected'
				theOrders.save()
			else:
				response['status_code']=400
				response['status_message']='invalid status choice'
				return Response(response)
			theReturnData=[]
			storeData=getStoreData(i.relatedID)
			theAddressSerial=GetCustomerAddress(i.deliveryAddress)
			addressData=theAddressSerial.data
			from datetime import datetime
			now = datetime.now()
			theDat=now.strftime('%b %d, %Y ')
			theTim=now.strftime('%I:%M')
			theReturnData.append({'orderID':i.orderID,
								  'customerID':customerObjects.userUniqueID,
								  'amount':i.orderDeliveryFee,
								  'name':storeData['name'],
								  'image':storeData['image'],
								  'orderDropOff':addressData['address'],
								  'orderTime':theTim,
								  'orderDate':theDat,})
			response['returnData']=theReturnData
			response['status_code']=200
			response['status_message']='Order Status updated'
			print(response)
			return Response(response)
		except Exception as e:
			print(e)
			import sys, os
			exc_type, exc_obj, exc_tb = sys.exc_info()
			fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
			print(exc_type, fname, exc_tb.tb_lineno)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class getStoreOrdersForCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			theOrders=orderPack.objects.filter(relatedID=data.get('storeID')).order_by('-orderID')
			theOrderSerial=GetOrdersData(theOrders,many=True)
			response['data']=theOrderSerial.data
			response['status_code']=200
			response['status_message']='Orders Data'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class getHomeScreenOrder(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='driverID required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			theOrders=orderPack.objects.filter(driverID=data.get('driverID'),driverStatus='Assigned',orderStatus='Accepted').first()
			allData=[]
			if theOrders:
				i=theOrders
				storeData=getStoreData(i.relatedID)
				theAddressSerial=GetCustomerAddress(i.deliveryAddress)
				addressData=theAddressSerial.data
				allData.append({'storeName':storeData['name'],
								'storeImage':storeData['image'],
								'pickupAddress':storeData['address'],
								'dropAddress':addressData['address'],
								'orderID':i.orderID,
								'distance':i.orderDistance,
								'estFare':i.orderDeliveryFee,
								})
				response['data']=allData
			else:
				response['data']=[]
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class getTransactionHistory(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData=[]
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			if not data.get('page'):
				response['status_code']=400
				response['status_message']='page required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			allTransactions=CustomerTransaction.objects.filter(customerID=customerObjects.userUniqueID)
			for trans in allTransactions:
				if trans.relatedTo == '1':
					dat=trans.created_at
					dateOfTransactions=dat.strftime("%b %d, %Y")
					allData.append({'storeID':trans.relatedID,
									'amount':trans.amount,
									'date':str(dateOfTransactions)})
			print("before call ")
			try:
				url = str(settings.STORE_ACCESS_URL)+"store/order/getTransactionHistoryForCustomer/"
				payload={
						 'AccessKey': str(settings.STORE_ACCESS_KEY),
						 'relatedData': json.dumps(allData),
						 'page': data.get('page')
						 }
				res = requests.request("POST", url,data=payload)
				print("call done")
				print(res)
				res = res.json()
				if res['status_code']==200:
					return Response(res)
					# response['data']=res['data']
				else:
					response['data']=[]
					response['status_code']=400
					response['status_message']='No data found'
					return Response(response)
			except Exception as e:
				print(e)
				response['data']=[]
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getMyRewards(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData=[]
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			# if not data.get('page'):
			# 	response['status_code']=400
			# 	response['status_message']='page required'
			# 	return Response(response)
			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])

			rewardObject=myrewards.objects.filter(customerID=customerObjects.userUniqueID).first()
			if rewardObject:
				response['totalPoints']=int(rewardObject.availablepoints)
				available3rewardsCount=int(rewardObject.availablepoints)/3
				available6rewardsCount=int(rewardObject.availablepoints)/6
				available9rewardsCount=int(rewardObject.availablepoints)/9
				available12rewardsCount=int(rewardObject.availablepoints)/12
				if int(available12rewardsCount)>=1:
					allData.append({'type':'reward12',
								'count':int(available12rewardsCount),
								'name':'12 deliveries reward',
								'description':'12 deliveries: Free Pre Roll + 1/2 off delivery'})
				elif int(available9rewardsCount)>=1:
					allData.append({'type':'reward9',
								'count':int(available9rewardsCount),
								'name':'9 deliveries reward',
								'description':'9 deliveries: $15/$200'})
				elif int(available6rewardsCount)>=1:
					allData.append({'type':'reward6',
								'count':int(available6rewardsCount),
								'name':'6 deliveries reward',
								'description':'6 deliveries: 1/2 off delivery'})
				elif int(available3rewardsCount)>=1:
					allData.append({'type':'reward3',
								'count':int(available3rewardsCount),
								'name':'3 deliveries reward',
								'description':'3 deliveries: $5 off on $100'})
				else:
					response['data']=[]
			else:
				response['totalPoints']=0	
			response['data']=allData
			response['status_code']=200
			response['status_message']='All rewards data'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getMyCart(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			allCartItems=[]
			cartObject=cartCalculation.objects.filter(customerID=customerObjects.userUniqueID).first()
			calulation={}
			if cartObject:
				calulation['itemServiceTotal']=str(cartObject.finalServiceTotal)
				calulation['itemDiscount']='0'
				calulation['itemDeliveryFee']=str(cartObject.finalDeliveryFee)
				calulation['discountOnDeliveryFee']='0'
				calulation['grandTotal']=str(cartObject.finalGrandTotal)
				
				try:
					url2 = str(settings.STORE_ACCESS_URL)+"store/get/getStoreByCustomer/"
					payload2={'AccessKey': str(settings.STORE_ACCESS_KEY),
							  'storeID': cartObject.relatedID,}
					res2 = requests.request("POST", url2,data=payload2)
					print(res2.json())
					res2=res2.json()
					if res2['status_code']==200:
						response['storeData']=res2['data']
					else:
						response['storeData']={}
						return Response(res2)
					# return Response(res.json())
				except Exception as e:
					print(e)
					response['status_code']=500
					response['status_message']=str(e)
					return Response(response)
				allCarts=cart.objects.filter(finalCalculation=cartObject)
				if allCarts:
					for c in allCarts:
						try:
							url = str(settings.STORE_ACCESS_URL)+"store/get/getProductDetailsForCart/"
							payload={
									'AccessKey': str(settings.STORE_ACCESS_KEY),
									'productId': c.productID,
									'itemCount':c.itemCount,
									'itemServiceTotal':c.itemServiceTotal,
							        'itemAddOnId':c.itemAddOnId,
									}
							res = requests.request("POST", url,data=payload)
							print("call done")
							print(res.json())
							res = res.json()
							if res['status_code']==200:
								allCartItems.append(res['data'])
						except Exception as e:
							print(e)
							response['status_code']=500
							response['status_message']=str(e)
							return Response(response)
			response['rewardData']=getTheRewardsOfCustomer(customerObjects.userUniqueID)
			response['calculation']=calulation
			response['productData']=allCartItems
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class getOrdersCountForAdmin(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			orderCount=0
			totalOrderEarnings=0
			orderObjects=orderPack.objects.all().order_by('-id')
			recent10=orderObjects[0:10]
			for order in orderObjects:
				totalOrderEarnings=float(totalOrderEarnings)+float(order.orderGrandTotal)
				orderCount+=1
			theOrderSerial=GetOrdersData(recent10,many=True)
			# a_float = 3.14159
			totalOrderEarnings = "{:.2f}".format(totalOrderEarnings)
			response['data']=theOrderSerial.data
			response['count']=orderCount
			response['totalOrderEarnings']=totalOrderEarnings
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class getOrderDetailsOfChatbot(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			# session_token = request.META.get('HTTP_AUTHORIZATION')
			# if not session_token:
			# 	response['status_code']=401
			# 	response['status_message']='Session token required'
			# 	return Response(response,status=response['status_code'])
			# session_token = session_token.replace("Token ", "")
			# customerObjects=Customer.objects.filter(userToken=session_token).first()
			# if not customerObjects:
			# 	response['status_code']=401
			# 	response['status_message']='Invalid token'
			# 	return Response(response,status=response['status_code'])
			if not data.get('customerID'):
				response['status_code']=400
				response['status_message']='customerID is required'
				return Response(response)
			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID is required'
				return Response(response)
			customerObjects=Customer.objects.filter(userUniqueID=data.get('customerID')).first()
			if not customerObjects:
				response['status_code']=400
				response['status_message']='Invalid customer id'
				return Response(response)
			theOrders=orderPack.objects.filter(customerID=customerObjects.userUniqueID,orderID=data.get('orderID')).first()
			if not theOrders:
				response['status_code']=404
				response['status_message']='Invalid order id'
				return Response(response)
			theOrderSerial=GetOrdersData(theOrders)

			response['data']=theOrderSerial.data
			response['status_code']=200
			response['status_message']='Success'
			if theOrders.driverID!='':
				try:
					url = str(settings.DRIVER_ACCESS_URL)+"driver/order/getDriverDetailsOfOrder/"
					payload={'AccessKey': str(settings.DRIVER_ACCESS_KEY),
							'driverID': theOrders.driverID,
							}
					res = requests.request("POST", url,data=payload)
					res = res.json()
					if res['status_code']==200:
						response['driverData']=res['data']
					else:
						return Response(res)
				except Exception as e:
					response['status_code']=500
					response['status_message']=str(e)
					print(e)
			else:
				theDataOfDriver={}
				theDataOfDriver['name']=''
				theDataOfDriver['image']=''
				theDataOfDriver['phone']=''
				theDataOfDriver['countrycode']=''
				theDataOfDriver['latitude']='0.0'
				theDataOfDriver['longitude']='0.0'
				response['driverData']=theDataOfDriver
			return Response(response)
		except Exception as e:
			print(e)
			import sys, os
			exc_type, exc_obj, exc_tb = sys.exc_info()
			fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
			print(exc_type, fname, exc_tb.tb_lineno)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)


class getTotalOrdersCount(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if not data.get('companyId'):
				response['status_code']=400
				response['status_message']='companyId required.'
				return Response(response,status=400)
			recent10Orders=[]
			orderCount=orderPack.objects.filter(companyID=data.get('companyId')).count()
			allOrdersObject=orderPack.objects.filter(companyID=data.get('companyId'))
			for order in allOrdersObject:
				recent10Orders.append(order)
			recent10=[]
			orderObjects=orderPack.objects.filter(companyID=data.get('companyId'))
			recent10=orderObjects[0:10]
			totalOrderEarnings=float(0)
			for order in orderObjects:
				totalOrderEarnings=float(totalOrderEarnings)+float(order.orderGrandTotal)
			theOrderSerial=GetOrdersData(recent10,many=True)
			print(theOrderSerial)
			import datetime as ddd
			import dateutil.relativedelta
			ordersSeries=[]
			try:
				for count in range(0,6):
					d = ddd.datetime.now()
					print(d.month,d.year)
					d2 = d - dateutil.relativedelta.relativedelta(months=count)
					print(d2.month,d2.year)
					theDateValue=d2.strftime("%b, %Y")
					allCount=orderPack.objects.filter(Q(companyID=data.get('companyId')) & Q(created_at__month=d2.month) & Q(created_at__year=d2.year)).count()
					ordersSeries.append({'value':allCount,
										'name':theDateValue,})
			except Exception as e:
				# ordersSeries.append(e)
				print(e)

			response['ordersSeries']=ordersSeries
			response['count']=orderCount
			response['recentOrders']=theOrderSerial.data
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class getTotalOrdersCountForStore(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required.'
				return Response(response,status=400)
			totalOrderEarnings=float(0)
			orderCountMain=orderPack.objects.filter(relatedTo="1",relatedID=data.get('storeID')).count()
			recent10=[]
			orderObjects=orderPack.objects.filter(relatedTo="1",relatedID=data.get('storeID'))
			recent10=orderObjects[0:10]
			for order in orderObjects:
				totalOrderEarnings=float(totalOrderEarnings)+float(order.orderGrandTotal)
			theOrderSerial=GetOrdersData(recent10,many=True)
			
			orderSeries2=[]
			try:
				import datetime as ddd
				import dateutil.relativedelta
				for count in range(0,6):
					d = ddd.datetime.now()
					print(d.month,d.year)
					d2 = d - dateutil.relativedelta.relativedelta(months=count)
					print(d2.month,d2.year)
					theDateValue=d2.strftime("%b, %Y")
					orderCount=orderPack.objects.filter(Q(relatedTo="1") & Q(relatedID=data.get('storeID')) & Q(created_at__month=d2.month) & Q(created_at__year=d2.year)).count()
					# allEarnings=companyearning.objects.filter(Q(companyID=compObjects.userUniqueID) & Q(created_at__month=d2.month) & Q(created_at__year=d2.year))
					# tempEarning=float(0)
					# for earning in allEarnings:
					# 	tempEarning=float(tempEarning)+float(earning.amount)
					# tempEarning="{:.2f}".format(tempEarning)
					orderSeries2.append({'value':orderCount,
										'name':theDateValue,})
			except Exception as e:
				print(e)
			response['orderSeries']=orderSeries2
			response['count']=orderCountMain
			response['recentOrders']=theOrderSerial.data
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)