from django.db import models

# Create your models here.
class deliveryAddress(models.Model):
	customerID = models.CharField(max_length = 50, null = True, blank = True,default = '')
	address = models.TextField(null = True, blank = True)
	latitude = models.CharField(max_length = 50, null = True, blank = True,default = '')
	longitude = models.CharField(max_length = 50, null = True, blank = True,default = '')
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.customerID))

OFFERAPPLY = (
    ('YES', "YES"),
    ('NO', "NO"),
)

RELATEDTO = (
    ('1', "Store"),
    ('2', "Company"),
)

ORDERSTATUS = (
    ('Pending', "Pending"),
    ('Canceled', "Canceled"),
	('Accepted', "Accepted"),
    ('Rejected', "Rejected"),
	('Assigned', "Assigned"),
	('PickedUP', "PickedUP"),
	('Delivered', "Delivered"),
)

DRIVERSTATUS = (
    ('Pending', "Pending"),
    ('Assigned', "Assigned"),
	('Accepted', "Accepted"),
	('Rejected', "Rejected"),
)

PAYMENTSTATUS = (
    ('1', "Pending"),
    ('2', "Paid"),
)



class cartCalculation(models.Model):
	customerID = models.CharField(max_length = 50, null = True, blank = True,default = '')
	companyID = models.CharField(max_length = 50, null = True, blank = True,default = '')
	finalDiscount = models.CharField(max_length = 50, null = True, blank = True,default = '0')
	discountOnDelivery = models.CharField(max_length = 50, null = True, blank = True,default = '0')
	freeItemImage = models.CharField(max_length = 250, null = True, blank = True,default = '')
	freeItemName = models.CharField(max_length = 250, null = True, blank = True,default = '')
	finalDeliveryFee = models.CharField(max_length = 50, null = True, blank = True,default = '0')
	finalGrandTotal = models.CharField(max_length = 50, null = True, blank = True,default = '0')
	finalServiceTotal = models.CharField(max_length = 50, null = True, blank = True,default = '0')
	rewardDiscount = models.CharField(max_length = 50, null = True, blank = True,default = '')
	coupounDiscount = models.CharField(max_length = 50, null = True, blank = True,default = '')
	rewardDiscountonItem = models.CharField(max_length = 50, null = True, blank = True,default = '')
	rewardDiscountonDelivery = models.CharField(max_length = 50, null = True, blank = True,default = '')
	couponcode = models.CharField(max_length = 50, null = True, blank = True,default = '')
	rewardtype = models.CharField(max_length = 50, null = True, blank = True,default = '')
	finalOffer = models.CharField(max_length = 20,choices = OFFERAPPLY,default = 'NO')
	relatedTo = models.CharField(max_length = 20,choices = RELATEDTO,default = '1')
	relatedID = models.CharField(max_length = 50, null = True, blank = True,default = '')
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.customerID))

class cart(models.Model):
	finalCalculation= models.ForeignKey(cartCalculation, on_delete=models.CASCADE,default='')
	productID = models.CharField(max_length = 50, null = True, blank = True,default = '')
	itemCount = models.CharField(max_length = 50, null = True, blank = True,default = '')
	itemServiceTotal = models.CharField(max_length = 50, null = True, blank = True,default = '')
	itemAddOnId = models.CharField(max_length = 50, null = True, blank = True,default = '')
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.productID)) +' '+ str(self.id)

class orderPack(models.Model):
	orderStatus = models.CharField(max_length = 20,choices = ORDERSTATUS,default = 'Pending')
	driverStatus = models.CharField(max_length = 20,choices = DRIVERSTATUS,default = 'Pending')
	payStatus = models.CharField(max_length = 20,choices = PAYMENTSTATUS,default = '1')
	driverID = models.CharField(max_length = 50, null = True, blank = True,default = '')
	customerID = models.CharField(max_length = 50, null = True, blank = True,default = '')
	companyID = models.CharField(max_length = 50, null = True, blank = True,default = '')
	orderID = models.CharField(max_length = 50, null = True, blank = True,default = '')
	orderServiceTotal = models.CharField(max_length = 50, null = True, blank = True,default = '0')
	orderDiscount = models.CharField(max_length = 50, null = True, blank = True,default = '0')
	orderDistance = models.CharField(max_length = 50, null = True, blank = True,default = '0')
	orderDeliveryFee = models.CharField(max_length = 50, null = True, blank = True,default = '0')
	orderGrandTotal = models.CharField(max_length = 50, null = True, blank = True,default = '0')
	discountOnDelivery = models.CharField(max_length = 50, null = True, blank = True,default = '0')
	freeItemImage = models.CharField(max_length = 250, null = True, blank = True,default = '')
	freeItemName = models.CharField(max_length = 250, null = True, blank = True,default = '')
	rewardDiscount = models.CharField(max_length = 50, null = True, blank = True,default = '')
	coupounDiscount = models.CharField(max_length = 50, null = True, blank = True,default = '')
	rewardDiscountonItem = models.CharField(max_length = 50, null = True, blank = True,default = '')
	rewardDiscountonDelivery = models.CharField(max_length = 50, null = True, blank = True,default = '')
	couponcode = models.CharField(max_length = 50, null = True, blank = True,default = '')
	rewardtype = models.CharField(max_length = 50, null = True, blank = True,default = '')
	orderOffer = models.CharField(max_length = 20,choices = OFFERAPPLY,default = 'NO')
	cancelReason = models.TextField(null = True, blank = True)
	instruction = models.TextField(null = True, blank = True)
	relatedTo = models.CharField(max_length = 20,choices = RELATEDTO,default = '1')
	relatedID = models.CharField(max_length = 50, null = True, blank = True,default = '')
	customerPic = models.CharField(max_length = 150, null = True, blank = True,default = '')
	customerIDproofFront = models.CharField(max_length = 150, null = True, blank = True,default = '')
	customerIDproofBack = models.CharField(max_length = 150, null = True, blank = True,default = '')
	customerSign = models.CharField(max_length = 150, null = True, blank = True,default = '')
	deliveryAddress = models.ForeignKey(deliveryAddress, null = True,on_delete=models.CASCADE,default='')
	isPaid = models.BooleanField(default = False)
	isRated = models.BooleanField(default = False)
	isDriverRated = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.customerID)+'-'+str(self.relatedID))

class order(models.Model):
	orderPack= models.ForeignKey(orderPack, on_delete=models.CASCADE,default='')
	productID = models.CharField(max_length = 50, null = True, blank = True,default = '')
	orderCount = models.CharField(max_length = 50, null = True, blank = True,default = '')
	orderTotal = models.CharField(max_length = 50, null = True, blank = True,default = '')
	itemAddOnId = models.CharField(max_length = 50, null = True, blank = True,default = '')
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.productID))

class CustomerTransaction(models.Model):
	orderPack= models.ForeignKey(orderPack, on_delete=models.CASCADE,default='')
	relatedTo = models.CharField(max_length = 20,choices = RELATEDTO,default = '1')
	relatedID = models.CharField(max_length = 50, null = True, blank = True,default = '')
	customerID = models.CharField(max_length = 100, null = True, blank = True,default = '')
	amount = models.CharField(max_length = 50, null = True, blank = True,default = '')
	txnID = models.CharField(max_length = 200, null = True, blank = True,default = '')
	recieptUrl = models.CharField(max_length = 200, null = True, blank = True,default = '')
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.customerID)+'-'+str(self.recieptUrl))

class deliverycharges(models.Model):
	charges = models.CharField(max_length = 50, null = True, blank = True,default = '')
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.charges))

class rewards(models.Model):
	deliveries = models.CharField(max_length = 50, null = True, blank = True,default = '')
	description = models.CharField(max_length = 50, null = True, blank = True,default = '')
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.description))

class myrewards(models.Model):
	customerID = models.CharField(max_length = 100, null = True, blank = True,default = '')
	totalpoints = models.CharField(max_length = 50, null = True, blank = True,default = '0')
	usedpoints = models.CharField(max_length = 50, null = True, blank = True,default = '0')
	availablepoints = models.CharField(max_length = 50, null = True, blank = True,default = '0')
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.availablepoints)+' - points'+str(self.customerID))


class availablefreeitem(models.Model):
	image = models.CharField(max_length = 250, null = True, blank = True,default = '')
	name = models.CharField(max_length = 100, null = True, blank = True,default = '0')
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.name)+' - free item')