import re
from rest_framework.views import APIView
from rest_framework.response import Response
from django.contrib.auth import login,authenticate
from .models import *
from base.models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
import datetime
from django.template.loader import render_to_string
from django.core.mail import EmailMessage
import math, random, datetime, pytz, string
from datetime import datetime
from datetime import timedelta
import requests
from django.conf import settings
import json


class getStoreList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if session_token:
				session_token = session_token.replace("Token ", "")
				customerObjects=Customer.objects.filter(userToken=session_token).first()
				if not customerObjects:
					response['status_code']=401
					response['status_message']='Invalid token'
					return Response(response,status=response['status_code'])

			if not data.get('latitude'):
				response['status_code']=400
				response['status_message']='latitude required.'
				return Response(response)
			if not data.get('longitude'):
				response['status_code']=400
				response['status_message']='longitude required.'
				return Response(response)
			if not data.get('page'):
				response['status_code']=400
				response['status_message']='page required.'
				return Response(response)
			if not data.get('search'):
				search=''
			else:
				if data.get('search')=='':
					search=''
				else:
					search=data.get('search')
			

			# print("ratingStart",data.get('ratingStart'))
			# print("ratingEnd",data.get('ratingEnd'))

			if data.get('ratingStart'):
				if data.get('ratingStart')!='':
					ratingStart=data.get('ratingStart')
				else:
					ratingStart=''
			else:
				ratingStart=''
			
			if data.get('ratingEnd'):
				if data.get('ratingEnd')!='':
					ratingEnd=data.get('ratingEnd')
				else:
					ratingEnd=''
			else:
				ratingEnd=''

			print("ratingStart",ratingStart)
			print("ratingEnd",ratingEnd)
			try:
				url = str(settings.STORE_ACCESS_URL)+"store/get/getStoreListByCustomer/"
				payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
				'latitude': data.get('latitude'),
				'longitude': data.get('longitude'),
				'search': search,
				'ratingStart': ratingStart,
				'ratingEnd': ratingEnd,
				'page': data.get('page'),
				}
				res = requests.request("POST", url,data=payload)
				print(res.json())
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class getStore(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if session_token:
				session_token = session_token.replace("Token ", "")
				customerObjects=Customer.objects.filter(userToken=session_token).first()
				if not customerObjects:
					response['status_code']=401
					response['status_message']='Invalid token'
					return Response(response,status=response['status_code'])

			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required.'
				return Response(response)
			try:
				url = str(settings.STORE_ACCESS_URL)+"store/get/getStoreByCustomer/"
				payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
				'storeID': data.get('storeID'),
				}
				res = requests.request("POST", url,data=payload)
				print(res.json())
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
		return Response(response)

class getProductList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allCartItems=[]
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if session_token:
				session_token = session_token.replace("Token ", "")
				customerObjects=Customer.objects.filter(userToken=session_token).first()
				if not customerObjects:
					response['status_code']=401
					response['status_message']='Invalid token'
					return Response(response,status=response['status_code'])

			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required.'
				return Response(response)
			if not data.get('search'):
				search=''
			else:
				if data.get('search')=='':
					search=''
				else:
					search=data.get('search')
			anotherCartExist=cartCalculation.objects.filter(customerID=customerObjects.userUniqueID).exclude(relatedID=data.get('storeID'))
			print("anotherCartExist",anotherCartExist)
			if anotherCartExist:
				response['anotherStoreCartExist']=True
			else:
				response['anotherStoreCartExist']=False
			cartObject=cartCalculation.objects.filter(customerID=customerObjects.userUniqueID).first()
			if cartObject:
				allCarts=cart.objects.filter(finalCalculation=cartObject)
				if allCarts:
					for c in allCarts:
						allCartItems.append({'productId':c.productID,
							                 'itemCount':c.itemCount,
							                 'itemAddOnId':c.itemAddOnId
							                 })
			response['productsInCart']=allCartItems
			try:
				print("1")
				url = str(settings.STORE_ACCESS_URL)+"store/products/getProductListForOthers/"
				print("2")
				payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
				'storeID': data.get('storeID'),
				'search':search
				}
				res = requests.request("POST", url,data=payload)
				# res=str(res)
				# print(res.json())
				print(type(res))
				print(res)
				res=res.json()
				print((res['status_code']))
				print((res['status_message']))
				if res['status_code']==200:
					response['productData']=res['productData']
				else:
					response['productData']=[]
				try:
					url2 = str(settings.STORE_ACCESS_URL)+"store/get/getStoreByCustomer/"
					payload2={'AccessKey': str(settings.STORE_ACCESS_KEY),
					'storeID': data.get('storeID'),
					}
					res2 = requests.request("POST", url2,data=payload2)
					print(res2.json())
					res2=res2.json()
					# return Response(res.json())
				except Exception as e:
					print(e)
					response['status_code']=500
					response['status_message']=str(e)
				if res2['status_code']==200:
					response['storeData']=res2['data']
				else:
					response['storeData']=[]
				response['status_code']=200
				response['status_message']='Success'
				return Response(response)
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			
			
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
		return Response(response)

class getProduct(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if session_token:
				session_token = session_token.replace("Token ", "")
				customerObjects=Customer.objects.filter(userToken=session_token).first()
				if not customerObjects:
					response['status_code']=401
					response['status_message']='Invalid token'
					return Response(response,status=response['status_code'])

			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required.'
				return Response(response)
			if not data.get('productId'):
				response['status_code']=400
				response['status_message']='productId required.'
				return Response(response)
			try:
				print("1")
				url = str(settings.STORE_ACCESS_URL)+"store/get/getProductByCustomer/"
				print("2")
				payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
				'storeID': data.get('storeID'),
				'productId': data.get('productId')
				}
				res = requests.request("POST", url,data=payload)
				print(res.json())
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
		return Response(response)

class addCart(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])

			if not data.get('productData'):
				response['status_code']=400
				response['status_message']='productData required'
				return Response(response)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required.'
				return Response(response)
			if not data.get('latitude'):
				response['status_code']=400
				response['status_message']='latitude required.'
				return Response(response)
			if not data.get('longitude'):
				response['status_code']=400
				response['status_message']='longitude required.'
				return Response(response)
			productData=data.get('productData')
			productData=str(productData)
			productData=json.loads(productData)
			try:
				url = str(settings.STORE_ACCESS_URL)+"store/get/getStoreByCustomer/"
				payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
				'storeID': data.get('storeID'),
				}
				res = requests.request("POST", url,data=payload)
				print(res.json())
				# return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			res=res.json()
			totalDeliveryCharges=0
			discountOnItem=0
			itemCount=1
			itemProductPrice=0
			itemGiftPrice=0
			finalItemServiceTotal=0
			finalGrandTotal=0
			cartCalcAlready=cartCalculation.objects.filter(customerID=customerObjects.userUniqueID).first()
			if not cartCalcAlready:
				cartCalcAlready=cartCalculation.objects.create(customerID=customerObjects.userUniqueID)

			innerData=[]
			allData=[]
			for i in productData:
				print(i)
				print(i['productId'])
				print(i['itemCount'])
				print(i['addOnId'])
				productId=i['productId']
				itemCount=i['itemCount']
				itemGiftId=i['addOnId']
				try:
					print("1")
					url2 = str(settings.STORE_ACCESS_URL)+"store/products/viewProductForOthers/"
					print("2")
					payload2={'AccessKey': str(settings.STORE_ACCESS_KEY),
					'storeID': data.get('storeID'),
					'productId': productId
					}
					res2 = requests.request("POST", url2,data=payload2)
					print(res2.json())
					# return Response(res2.json())
				except Exception as e:
					print(e)
					response['status_code']=500
					response['status_message']=str(e)
					return Response(response)			
				res2=res2.json()
				
				itemProductPrice=res2['data']['productPrice']
				for j in res2['data']['giftData']['giftQuantities']:
					if j['addOnId']==itemGiftId:
						itemGiftPrice=j['addOnPrice']
						break;

				totalCount=itemCount
				itemProductPrice=int(itemProductPrice)

				itemGiftPrice=int(itemGiftPrice)

				itemCount=int(itemCount)
				if itemCount==1:
					tempPrice=itemGiftPrice+itemProductPrice
					itemServiceTotal=tempPrice*itemCount
				elif itemCount==0:
					itemServiceTotal=0
				elif itemCount>1:
					itemServiceTotal=itemProductPrice*itemCount
					itemServiceTotal=itemServiceTotal+itemGiftPrice
				
				finalItemServiceTotal=int(finalItemServiceTotal)+int(itemServiceTotal)
				finalItemServiceTotal=int(finalItemServiceTotal)+int(itemServiceTotal)
				alreadyInCart=cart.objects.filter(finalCalculation=cartCalcAlready,productID=productId).first()
				if not alreadyInCart:
					alreadyInCart=cart.objects.create(finalCalculation=cartCalcAlready,productID=productId)
				alreadyInCart.itemCount=int(itemCount)
				alreadyInCart.itemServiceTotal=int(itemServiceTotal)
				alreadyInCart.save()
				innerData.append({'productID':productId,
								  'itemCount':itemCount,
								  'itemGiftId':itemGiftId})
			km=0
			try:
				import haversine as hs
				from haversine import Unit
				loc1=(float(res['data']['latitude']),float(res['data']['longitude']))
				loc2=(float(data.get('latitude')),float(data.get('longitude')))
				a=hs.haversine(loc1,loc2,unit=Unit.METERS)
				print(a)
				km=float(a)*float(0.001)
				km=round(km)
				km=int(km)
			except Exception as e:
				print("===-===-===-===-===-===-===-===-===-===-",e)
			totalDeliveryCharges=int(km)*int(50)
			finalGrandTotal=finalItemServiceTotal+totalDeliveryCharges
			finalGrandTotal=finalGrandTotal-discountOnItem
			cartCalcAlready.finalDiscount=discountOnItem
			cartCalcAlready.finalDeliveryFee=totalDeliveryCharges
			cartCalcAlready.finalGrandTotal=finalGrandTotal
			cartCalcAlready.save()

			allData.append({'products':innerData,
							'itemServiceTotal':finalItemServiceTotal,
							'itemDiscount':discountOnItem,
							'itemDeliveryFee':totalDeliveryCharges,
							'grandTotal':finalGrandTotal,})
			response['status_code']=200
			response['status_message']='Success'
			response['data']=allData
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
		return Response(response)

class checkLocationRadius(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])

			if not data.get('latitude'):
				response['status_code']=400
				response['status_message']='latitude required'
				return Response(response)
			if not data.get('longitude'):
				response['status_code']=400
				response['status_message']='longitude required'
				return Response(response)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required'
				return Response(response)
			try:
				url = str(settings.STORE_ACCESS_URL)+"store/get/getStoreByCustomer/"
				payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
				'storeID': data.get('storeID'),
				}
				res = requests.request("POST", url,data=payload)
				print(res.json())
				# return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			res=res.json()
			km=0
			try:
				import haversine as hs
				from haversine import Unit
				loc1=(float(res['data']['latitude']),float(res['data']['longitude']))
				loc2=(float(data.get('latitude')),float(data.get('longitude')))
				a=hs.haversine(loc1,loc2,unit=Unit.METERS)
				print(a)
				km=float(a)*float(0.001)
				km=round(km)
				km=int(km)
			except Exception as e:
				km=0
				print("===-===-===-===-===-===-===-===-===-===-",e)
			if km>50:
				response['status_code']=400
				response['status_message']='Delivery out side radius'
				response['isinRadius']=False
			else:
				response['status_code']=400
				response['status_message']='Success'
				response['isinRadius']=True
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
		return Response(response)

class placeOrder(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			print("==1==")
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])

			if not data.get('productData'):
				response['status_code']=400
				response['status_message']='productData required'
				return Response(response)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required.'
				return Response(response)
			if not data.get('fullAddress'):
				response['status_code']=400
				response['status_message']='fullAddress required.'
				return Response(response)
			if not data.get('latitude'):
				response['status_code']=400
				response['status_message']='latitude required.'
				return Response(response)
			if not data.get('longitude'):
				response['status_code']=400
				response['status_message']='longitude required.'
				return Response(response)
			productData=data.get('productData')
			productData=str(productData)
			productData=json.loads(productData)
			try:
				url = str(settings.STORE_ACCESS_URL)+"store/get/getStoreByCustomer/"
				payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
				'storeID': data.get('storeID'),
				}
				res = requests.request("POST", url,data=payload)
				print(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			print("==2==")
			res=res.json()
			totalDeliveryCharges=0
			discountOnItem=0
			itemCount=1
			itemProductPrice=0
			itemGiftPrice=0
			finalItemServiceTotal=0
			finalGrandTotal=0

			latExt=Customer.objects.all().last()
			if latExt:
				lastId=latExt.userUniqueID
				last5Number=lastId[3:]
				last5Number=int(last5Number)
				new5Number=last5Number+1
				new5Number=str(new5Number)
				new5Number = new5Number.zfill(5)
				theUniqueID=str('ORD')+str(new5Number)
			else:
				theUniqueID=str('ORD')+str('00001')
			print("==3==")
			orderPackObjects=orderPack.objects.create(customerID=customerObjects.userUniqueID,orderID=theUniqueID)
			print("==4==")
			customerAddressObject=deliveryAddress.objects.create(customerID=customerObjects.userUniqueID)
			customerAddressObject.address=data.get('fullAddress')
			customerAddressObject.latitude=data.get('latitude')
			customerAddressObject.longitude=data.get('longitude')
			customerAddressObject.save()
			innerData=[]
			allData=[]
			for i in productData:
				print(i)
				print(i['productId'])
				print(i['itemCount'])
				print(i['addOnId'])
				productId=i['productId']
				itemCount=i['itemCount']
				addOnID=i['addOnId']
				try:
					url2 = str(settings.STORE_ACCESS_URL)+"store/products/viewProductForOthers/"
					payload2={'AccessKey': str(settings.STORE_ACCESS_KEY),
					'storeID': data.get('storeID'),
					'productId': productId
					}
					res2 = requests.request("POST", url2,data=payload2)
					print(res2.json())
				except Exception as e:
					print(e)
					response['status_code']=500
					response['status_message']=str(e)
					return Response(response)			
				res2=res2.json()
				
				itemProductPrice=res2['data']['productPrice']
				for j in res2['data']['giftData']['giftQuantities']:
					if j['addOnId']==addOnID:
						itemGiftPrice=j['addOnPrice']
						break;

				totalCount=itemCount
				itemProductPrice=int(itemProductPrice)

				itemGiftPrice=int(itemGiftPrice)

				itemCount=int(itemCount)
				if itemCount==1:
					tempPrice=itemGiftPrice+itemProductPrice
					itemServiceTotal=tempPrice*itemCount
				elif itemCount==0:
					itemServiceTotal=0
				elif itemCount>1:
					itemServiceTotal=itemProductPrice*itemCount
					itemServiceTotal=itemServiceTotal+itemGiftPrice
				
				finalItemServiceTotal=int(finalItemServiceTotal)+int(itemServiceTotal)
				finalItemServiceTotal=int(finalItemServiceTotal)+int(itemServiceTotal)
				
				orderObjects=order.objects.create(orderPack=orderPackObjects,productID=productId)
				orderObjects.orderCount=int(itemCount)
				orderObjects.orderTotal=int(itemServiceTotal)
				orderObjects.itemAddOnId=addOnID
				orderObjects.save()
				innerData.append({'productID':productId,
								  'itemCount':itemCount,
								  'itemAddOnId':addOnID})
			km=0
			try:
				import haversine as hs
				from haversine import Unit
				loc1=(float(res['data']['latitude']),float(res['data']['longitude']))
				loc2=(float(data.get('latitude')),float(data.get('longitude')))
				a=hs.haversine(loc1,loc2,unit=Unit.METERS)
				print(a)
				km=float(a)*float(0.001)
				km=round(km)
				km=int(km)
			except Exception as e:
				print("===-===-===-===-===-===-===-===-===-===-",e)
			totalDeliveryCharges=int(km)*int(50)
			finalGrandTotal=finalItemServiceTotal+totalDeliveryCharges
			finalGrandTotal=finalGrandTotal-discountOnItem
			orderPackObjects.orderDiscount=discountOnItem
			orderPackObjects.orderDeliveryFee=totalDeliveryCharges
			orderPackObjects.orderGrandTotal=finalGrandTotal
			orderPackObjects.deliveryAddress=customerAddressObject
			orderPackObjects.relatedID=data.get('storeID')
			orderPackObjects.save()

			allData.append({'products':innerData,
							'itemServiceTotal':finalItemServiceTotal,
							'itemDiscount':discountOnItem,
							'itemDeliveryFee':totalDeliveryCharges,
							'grandTotal':finalGrandTotal,})
			response['status_code']=200
			response['status_message']='Success'
			response['data']=allData

			cartCalcAlready=cartCalculation.objects.filter(customerID=customerObjects.userUniqueID).first()
			if cartCalcAlready:
				for i in productData:
					print(i)
					print(i['productId'])
					print(i['itemCount'])
					print(i['addOnId'])
					productId=i['productId']
					itemCount=i['itemCount']
					addOnID=i['addOnId']
					alreadyInCart=cart.objects.filter(finalCalculation=cartCalcAlready,productID=productId).first()
					if alreadyInCart:
						alreadyInCart.delete()
				cartCalcAlready.delete()

			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
		return Response(response)

class addRating(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID required.'
				return Response(response)
			if not data.get('storeRating'):
				response['status_code']=400
				response['status_message']='storeRating required.'
				return Response(response)
			if not data.get('storeReview'):
				response['status_code']=400
				response['status_message']='storeReview required.'
				return Response(response)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required.'
				return Response(response)
			if not data.get('productData'):
				response['status_code']=400
				response['status_message']='productData required.'
				return Response(response)
			productData=data.get('productData')
			productData=str(productData)
			productData=json.loads(productData)
			# if not data.get('productRating'):
			# 	response['status_code']=400
			# 	response['status_message']='productRating required.'
			# 	return Response(response)
			# if not data.get('productReview'):
			# 	response['status_code']=400
			# 	response['status_message']='productReview required.'
			# 	return Response(response)
			# if not data.get('productID'):
			# 	response['status_code']=400
			# 	response['status_message']='productID required.'
			# 	return Response(response)
			thePackObject=orderPack.objects.filter(orderID=data.get('orderID')).first()
			if thePackObject.isRated==True:
				response['status_code']=400
				response['status_message']='Store and product is already rated.'
				return Response(response)
			try:
				url = str(settings.STORE_ACCESS_URL)+"store/auth/addStoreRating/"
				payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
				'storeID': data.get('storeID'),
				'review': data.get('storeReview'),
				'rating': data.get('storeRating'),
				'customerID': customerObjects.userUniqueID,
				'orderID': data.get('orderID'),
				}
				res = requests.request("POST", url,data=payload)
				print(res.json())
				res=res.json()
				if res['status_code']==200:
					pass
				else:
					return Response(res)
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			for i in productData:
				print(i)
				print(i['productID'])
				productRating=i['productRating']
				# productReview=i['productReview']
				productReview=''
				productID=i['productID']
				try:
					
					url = str(settings.STORE_ACCESS_URL)+"store/products/addProductRating/"
					payload={'AccessKey': str(settings.STORE_ACCESS_KEY),
					'productID': productID,
					'review': productReview,
					'rating': productRating,
					'customerID': customerObjects.userUniqueID,
					'orderID': data.get('orderID'),
					}
					res = requests.request("POST", url,data=payload)
					print(res.json())
					res=res.json()
					if res['status_code']==200:
						pass
						# thePackObject.isRated=True
						# thePackObject.save()
						# response['status_code']=200
						# response['status_message']='Rating saved'
						# return Response(response)
					else:
						return Response(res)
					# return Response(res.json())
				except Exception as e:
					print(e)
					response['status_code']=500
					response['status_message']=str(e)
					return Response(response)
			thePackObject.isRated=True
			thePackObject.save()
			response['status_code']=200
			response['status_message']='Rating saved'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class addDriverRating(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID required.'
				return Response(response)
			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='driverID required.'
				return Response(response)
			if not data.get('driverRating'):
				response['status_code']=400
				response['status_message']='driverRating required.'
				return Response(response)
			if not data.get('driverReview'):
				response['status_code']=400
				response['status_message']='driverReview required.'
				return Response(response)
			thePackObject=orderPack.objects.filter(orderID=data.get('orderID')).first()
			if thePackObject.isDriverRated==True:
				response['status_code']=400
				response['status_message']='Driver is already rated.'
				return Response(response)
			else:
				thePackObject.isDriverRated=True
				thePackObject.save()
			try:
				url = str(settings.DRIVER_ACCESS_URL)+"driver/order/addDriverRatings/"
				payload={'AccessKey': str(settings.DRIVER_ACCESS_KEY),
				'driverID': data.get('driverID'),
				'review': data.get('driverReview'),
				'rating': data.get('driverRating'),
				'customerID': customerObjects.userUniqueID,
				'orderID':data.get('orderID'),
				}
				res = requests.request("POST", url,data=payload)
				print(res.json())
				res=res.json()
				return Response(res)
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

def randomStringFunctionForImage():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(8)))
	str1 += ''.join((random.choice(string.digits) for x in range(4)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString
	
def uploadDocumentImages(image,bucket,thePath):
	import os
	import boto3
	from botocore.exceptions import NoCredentialsError
	try:
		ACCESS_KEY=str(settings.AWS_ACCESS_KEY_ID)
		SECRET_KEY=str(settings.AWS_SECRET_ACCESS_KEY)
		s3 = boto3.client('s3', aws_access_key_id=ACCESS_KEY,
                      aws_secret_access_key=SECRET_KEY)
		try:
			filetype = os.path.splitext(image.name)[1]
			print("==================================filetype===========",filetype)
			imageName=randomStringFunctionForImage()
			thePath=thePath+'/'+imageName+'.'+str(filetype)
			thePath=str(thePath)
			theFile=s3.upload_fileobj(image,bucket,thePath)
			print("Upload Successful")
			filename=str(settings.AWS_BUCKET_URL_1)+str(bucket)+str(settings.AWS_BUCKET_URL_2)+thePath
			return filename
		except FileNotFoundError as e:
			print("The file was not found")
			return ''
		except NoCredentialsError:
			print("Credentials not available")
			return ''
	except Exception as e:
		print(e)
		return ''

class addFreeItem(APIView):
	def get(self, request):
		response={}
		try:
			response['image']=''
			response['name']=''
			theOBJ=availablefreeitem.objects.all().last()
			if theOBJ:
				response['image']=theOBJ.image
				response['name']=theOBJ.name
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required.'
				return Response(response)
			if data.get('AccessKey')==str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if not data.get('name'):
				response['status_code']=400
				response['status_message']='name required.'
				return Response(response)
			if not data.get('image'):
				response['status_code']=400
				response['status_message']='image required.'
				return Response(response)
			
			theOBJ=availablefreeitem.objects.all().last()
			if not theOBJ:
				theOBJ=availablefreeitem.objects.create(name=data.get('name'))
			# image=request.FILES.get('image')
			# print("=======================IMAGE",image)
			# if image:
			# 	print("I GOT THE IMAGE")
			# 	filename=uploadDocumentImages(image,'cannabiscustomer','documents')
			# 	print("FILENAME",filename)
			# 	theOBJ.image=filename
			# print("++++++++++++++++++++++DONE")
			theOBJ.image=data.get('image')
			theOBJ.save()
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
	