from django.db import models
from ckeditor.fields import RichTextField

RENEWCHOICE = [
    ('AutoRenew', 'AutoRenew'),
    ('OneTime', 'OneTime'),
]

class CustomerPurchase(models.Model):
	customerID = models.CharField(max_length = 25, null = True, blank = True,default='')
	planID = models.CharField(max_length = 25, null = True, blank = True,default='')
	planName = models.CharField(max_length = 25, null = True, blank = True,default='')
	planPrice = models.CharField(max_length = 25, null = True, blank = True,default='')
	planDuration = models.CharField(max_length = 25, null = True, blank = True,default='')
	description = models.TextField(blank = True)
	htmlDescription = RichTextField(default='')
	startDate = models.DateField(max_length=25,blank=True,null=True)
	expiryDate = models.DateField(max_length=25,blank=True,null=True)
	trialExpiry = models.DateField(max_length=25,blank=True,null=True)
	option = models.CharField(max_length=25,choices=RENEWCHOICE,default='OneTime')
	isUsed = models.BooleanField(default = False)
	isActive = models.BooleanField(default = False)
	isTrial = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.planID)+'-'+str(self.customerID))

class currentPlan(models.Model):
	myPlan= models.ForeignKey(CustomerPurchase, on_delete=models.CASCADE,default='',null=True)
	customerID = models.CharField(max_length = 25, null = True, blank = True,default='')
	startDate = models.DateField(max_length=25,null=True,blank=True)
	expiryDate = models.DateField(max_length=25,null=True,blank=True)
	trialExpiry = models.DateField(max_length=25,null=True,blank=True)
	option = models.CharField(max_length=25,choices=RENEWCHOICE,default='OneTime')
	isActive = models.BooleanField(default = False)
	isTrial = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.customerID))