from rest_framework import serializers
from .models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
import requests
from django.conf import settings

class GetSubData(serializers.ModelSerializer):
	price =  serializers.SerializerMethodField(source='get_price')

	class Meta:
		model = CustomerPurchase
		fields = ['planID','startDate', 'expiryDate', 'trialExpiry','isActive','planName','price','description','htmlDescription']

	def get_price(self,obj):
		return obj.planPrice

class GetCurrentPlanData(serializers.ModelSerializer):
	planID =  serializers.SerializerMethodField(source='get_planID')
	planName =  serializers.SerializerMethodField(source='get_planName')
	price =  serializers.SerializerMethodField(source='get_price')
	description =  serializers.SerializerMethodField(source='get_description')
	htmlDescription =  serializers.SerializerMethodField(source='get_htmlDescription')

	class Meta:
		model = CustomerPurchase
		fields = ['planID','startDate', 'expiryDate','isActive','planName','price','description','htmlDescription']
	
	def get_planID(self,obj):
		return obj.myPlan.planID
	def get_planName(self,obj):
		return obj.myPlan.planName
	def get_price(self,obj):
		return obj.myPlan.planPrice
	def get_description(self,obj):
		return obj.myPlan.description
	def get_htmlDescription(self,obj):
		return obj.myPlan.htmlDescription

class GetSubDataAnother(serializers.ModelSerializer):
	price =  serializers.SerializerMethodField(source='get_price')
	# description =  serializers.SerializerMethodField(source='get_description')

	class Meta:
		model = CustomerPurchase
		fields = ['planID','startDate', 'expiryDate', 'trialExpiry','isActive','planName','price','description','htmlDescription','htmlDescription']

	def get_price(self,obj):
		return obj.planPrice

	# def get_description(self,obj):
	# 	try:
	# 		url = str(settings.ADMIN_ACCESS_URL)+"superadmin/subscriptions/viewPlanForAll/"
	# 		theToken=str(settings.ADMIN_ACCESS_KEY)
	# 		payload={'AccessKey':theToken,
	# 				 'planID':obj.planID,
	# 				 'userType':'1'}
	# 		apiResponse = requests.request("POST", url, data=payload)
	# 		r=apiResponse.json()
	# 		desc=r['data']['description']
	# 		return desc
	# 	except Exception as e:
	# 		return ''
