from rest_framework.views import APIView
from rest_framework.response import Response
from django.contrib.auth import login,authenticate
from .models import *
from base.models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from .serializers import *
import datetime
from django.template.loader import render_to_string
from django.core.mail import EmailMessage
import math, random, datetime, pytz, string
from datetime import datetime
from datetime import timedelta
import requests
from django.conf import settings
import json
import stripe

def validateToken(theToken):
	returnId='0'
	tokenOBJ = Token.objects.filter(key = theToken).first()
	if tokenOBJ:
		user = User.objects.get(id = tokenOBJ.user_id)
	if user:
		returnId=user.id
	return returnId

class getPlanList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			print("==1==")
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			customerObjects=Customer.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			print("==2==")
			try:
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/subscriptions/getPlanListForAll/"
				theToken=str(settings.ADMIN_ACCESS_KEY)
				payload={'AccessKey':theToken,
						 'userType':'1'}
				apiResponse = requests.request("POST", url, data=payload)
				r=apiResponse.json()
				print("the response of admin =====================",r)
			except Exception as e:
				print(e)
			allPlans=CustomerPurchase.objects.filter(customerID=customerObjects.userUniqueID,isdeleted=False,isActive=False)
			print("==3==")
			if allPlans:
				theJson={}
				allData=[]
				theList=[]
				try:
					url = str(settings.ADMIN_ACCESS_URL)+"superadmin/subscriptions/viewPlanWithIDListForAll/"
					theToken=str(settings.ADMIN_ACCESS_KEY)
					print("i am sending the list")
					for p in allPlans:
						theList.append({'planID':str(p.planID)})
					print("THE LIST",theList)
					print("THE LIST TYPE",type(theList))
					theList = json.dumps(theList)
					# theJson.update({"data":theList})
					payload={"AccessKey":theToken,
							 "planID":theList,
							 "userType":'1'}
					apiResponse = requests.request("POST", url, data=payload )
					print("==3.1==")
					apiResponse = apiResponse.json()
					print("==3.2==")
					print(apiResponse)
					# allData.append(apiResponse['data'])
					# theData=GetSubData(allPlans,many=True)
					print("==3.3==")
					if apiResponse['status']==200:
						response['myPurchasedPlanList']=apiResponse['data']
					else:
						response['myPurchasedPlanList']=[]
				except Exception as e:
					print(e)
					response['myPurchasedPlanList']=[]
			else:
				response['myPurchasedPlanList']=[]
			print("==4==")
			compObj=currentPlan.objects.filter(customerID=customerObjects.userUniqueID,isdeleted=False,isActive=True).first()
			if compObj:
				hasActiveSubscription=True
				theData=GetCurrentPlanData(compObj)
				response['myCurrentPlan']=theData.data
			else:
				hasActiveSubscription=False
				response['myCurrentPlan']={}
			print("==5==")
			response["hasActiveSubscription"]=hasActiveSubscription
			response['availablePlanList']=r['data']
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getPlan(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			adminObjects=Customer.objects.filter(userToken=session_token).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			if not data.get('planID'):
				response['status_code']=400
				response['status_message']='Invalid plan Id'
				return Response(response)
			try:
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/subscriptions/viewPlanForAll/"
				theToken=str(settings.ADMIN_ACCESS_KEY)
				payload={'AccessKey':theToken,
						 'planID':data.get('planID'),
						 'userType':'1'}
				apiResponse = requests.request("POST", url, data=payload)
				r=apiResponse.json()
				response['data']=r
				return Response(r)
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

# class purchaseSubscriptions(APIView):
# 	def post(self, request, *args, **kwargs):
# 		response={}
# 		try:
# 			data=request.data
# 			session_token = request.META.get('HTTP_AUTHORIZATION')
# 			if not session_token:
# 				response['status_code']=401
# 				response['status_message']='Session token required'
# 				return Response(response,status=response['status_code'])
# 			session_token = session_token.replace("Token ", "")
# 			if not data.get('planID'):
# 				response['status_code']=400
# 				response['status_message']='Plan id required'
# 				return Response(response)
			
# 			if not data.get('cardID'):
# 				response['status_code']=400
# 				response['status_message']='cardID required'
# 				return Response(response)
# 			idAdmin=Customer.objects.filter(userToken=session_token).first()
# 			if not idAdmin:
# 				response['status_code']=401
# 				response['status_message']='Invalid token'
# 				return Response(response,status=response['status_code'])
# 			try:
# 				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/subscriptions/viewPlanForAll/"
# 				theToken=str(settings.ADMIN_ACCESS_KEY)
# 				payload={'AccessKey':theToken,
# 						 'planID':data.get('planID'),
# 						 'userType':'1'}
# 				apiResponse = requests.request("POST", url, data=payload)
# 				apiResponse = apiResponse.json()
# 				if apiResponse['status_code']==200:
# 					thePlanName=apiResponse['data']['planName']
# 					thePlanPrice=apiResponse['data']['price']
# 					theDesc=apiResponse['data']['description']
# 					theHTMLDesc=apiResponse['data']['htmlDescription']
# 				else:
# 					response['status_code']=400
# 					response['status_message']='Not valid plan id'
# 					return Response(response)
# 			except Exception as e:
# 				response['status_code']=500
# 				response['status_message']=str(e)
# 				return Response(response)
# 			alreadyPurchased=CustomerPurchase.objects.filter(customerID=idAdmin.userUniqueID,planID=data.get('planID')).first()
			
# 			if alreadyPurchased:
# 				response['status_code']=400
# 				response['status_message']='Plan already purchased'
# 				return Response(response)
# 			firstPurchase=True
# 			compObj=CustomerPurchase.objects.filter(customerID=idAdmin.userUniqueID).first()
# 			if not compObj:
# 				firstPurchase=False
# 			compObj=CustomerPurchase.objects.create(customerID=idAdmin.userUniqueID)
# 			compObj.planID=data.get('planID')
# 			anyActive=CustomerPurchase.objects.filter(customerID=idAdmin.userUniqueID,isActive=True).first()
# 			if not anyActive:
# 				compObj.isActive=True
# 			if data.get('oneTime')==True:
# 				compObj.option='OneTime'
# 			if firstPurchase==True:
# 				compObj.planName=thePlanName
# 				compObj.planPrice=thePlanPrice
# 				compObj.description=theDesc
# 				compObj.htmlDescription=theHTMLDesc
# 				hoursInDays=15*24
# 				hoursOfTrial=5*24
# 				startDate=datetime.now()
# 				startDate=startDate.date()
# 				trialExpiryDate=startDate+timedelta(hours=hoursOfTrial)
# 				expiryDate=trialExpiryDate+timedelta(hours=hoursInDays)
# 				compObj.startDate=startDate
# 				compObj.trialExpiry=trialExpiryDate
# 				compObj.expiryDate=expiryDate
# 				compObj.isTrial=True
# 			else:
# 				try:
# 					import stripe
# 					stripe.api_key = "sk_test_4eC39HqLyjWDarjtT1zdp7dc"
# 					theToken=stripe.Token.create(
# 						card={
# 						"number": str(data.get('cardNo')),
# 						"exp_month": data.get('cardMonth'),
# 						"exp_year": data.get('cardYear'),
# 						"cvc": str(data.get('cardCVC')),
# 						},
# 						)
# 					print(theToken["id"])
# 					thePaymentToken=theToken["id"]
# 					payname='Jenny Rosen'
# 					payline='510 Townsend St'
# 					paypostalcode='98140'
# 					payCity='San Francisco'
# 					payState='CA'
# 					payCountry='US'
# 					stripeToken='tok_1IJeLNJDq5hI9lWPZtExZqQF'
# 					# stripe.api_key = "sk_test_51IJPNTCmXKARv8zJErG2EgWZb8RE8gVIs6JgO0GoQzCrZG4Yigwv2Y6TBKFIBlU4QbJrQGlJpe3WB7kBg3Gf3pbX00ABBWaEjH"
# 					totalAmount=float('10')
# 					currency='usd'
# 					totalAmount=math.ceil(totalAmount)
# 					print(totalAmount)
# 					amountToBeCutFromStripe=math.ceil(totalAmount)
# 					charge = stripe.Charge.create(
# 						amount=amountToBeCutFromStripe,
# 						currency=currency,
# 						description='Cannabis company subscription',
# 						source=thePaymentToken,
# 						shipping={
# 						'name': payname,
# 						'address': {
# 						'line1': payline,
# 						'postal_code': paypostalcode,
# 						'city': payCity,
# 						'state': payState,
# 						'country': payCountry,
# 						},
# 					},
# 					)
# 					print(charge)
# 					payment_id = charge.id
# 					receipt_url = charge.receipt_url
# 					refunds_url = charge.refunds.url
# 					payment_method = charge['payment_method_details']['card']['funding']
# 					if payment_method=='credit':
# 						payment_method = 'Credit Card'
# 					elif payment_method == 'debit':
# 						payment_method = 'Debit Card'
# 					lastfourdigits = charge['payment_method_details']['card']['last4']
# 					payData=({
# 						'payment_id':payment_id,
# 						'receipt_url':receipt_url,
# 						'refunds_url':refunds_url,
# 						'payment_method':payment_method,
# 						'lastfourdigits':lastfourdigits,
# 						})
# 					print(payData)
# 				except Exception as e:
# 					print(e)
# 				hoursInDays=15*24
# 				startDate=datetime.now()
# 				startDate=startDate.date()
# 				expiryDate=startDate+timedelta(hours=hoursInDays)
# 				compObj.planName=thePlanName
# 				compObj.planPrice=thePlanPrice
# 				compObj.description=theDesc
# 				compObj.htmlDescription=theHTMLDesc
# 				compObj.startDate=startDate
# 				compObj.expiryDate=expiryDate
# 				compObj.isTrial=False
# 			compObj.save()
# 			response['status_code']=200
# 			response['status_message']='Success'
# 		except Exception as e:
# 			print(e)
# 			response['status_code']=500
# 			response['status_message']=str(e)
# 		return Response(response)

class purchaseSubscriptions(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			if not data.get('planID'):
				response['status_code']=400
				response['status_message']='Plan id required'
				return Response(response)
			if not data.get('cardID'):
				response['status_code']=400
				response['status_message']='cardID required'
				return Response(response)
			idAdmin=Customer.objects.filter(userToken=session_token).first()
			if not idAdmin:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			try:
				print("==Before==")
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/subscriptions/viewPlanForAll/"
				theToken=str(settings.ADMIN_ACCESS_KEY)
				payload={'AccessKey':theToken,
						 'planID':data.get('planID'),
						 'userType':'1'}
				print("payload",payload)
				print(url)
				apiResponse = requests.request("POST", url, data=payload)
				print(apiResponse)
				apiResponse = apiResponse.json()
				print(apiResponse)
				if apiResponse['status_code']==200:
					thePlanName=apiResponse['data']['planName']
					thePlanPrice=apiResponse['data']['price']
					theDesc=apiResponse['data']['description']
					theHTMLDesc=apiResponse['data']['htmlDescription']
					theDays=apiResponse['data']['planDurationDays']
					theTrialDays=apiResponse['data']['trialDurationDays']
				else:
					response['status_code']=400
					response['status_message']='Not valid plan id'
					return Response(response)
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			print("==After==")
			allPlansCount=CustomerPurchase.objects.filter(customerID=idAdmin.userUniqueID,isdeleted=False,isUsed=False).count()
			# allPlansCount=CompanyPurchase.objects.filter(companyID=idAdmin.userUniqueID,isdeleted=False).count()
			print("the count",allPlansCount)
			if allPlansCount==2:
				response['status_code']=400
				response['status_message']='You can only purchase 2 plans at a time'
				return Response(response)
			alreadyPurchased=CustomerPurchase.objects.filter(customerID=idAdmin.userUniqueID,planID=data.get('planID'),isUsed=False).first()
			# alreadyPurchased=CompanyPurchase.objects.filter(companyID=idAdmin.userUniqueID,planID=data.get('planID')).first()
			if alreadyPurchased:
				response['status_code']=400
				response['status_message']='Plan already purchased'
				return Response(response)
			firstPurchase=True
			alreadyAPlanInActive=False
			currentPlanObj=currentPlan.objects.filter(customerID=idAdmin.userUniqueID).first()
			if currentPlanObj:
				firstPurchase=False
				if currentPlanObj.isActive!=True:
					alreadyAPlanInActive=False
			else:
				alreadyAPlanInActive=False
			theCard=CustomerCard.objects.filter(customerID=idAdmin.userUniqueID,cardID=data.get('cardID')).first()
			if not theCard:
				response['status_code']=400
				response['status_message']='Invalid card selection'
				return Response(response)
			print("beforePay")
			thePaymentObject=PaymentWithExistingCard(theCard.theCustomer,theCard.cardID,int(thePlanPrice))
			print(thePaymentObject)
			print("afterPay")
			if thePaymentObject['status'] == True :
				response['data'] = thePaymentObject['data']
			else:
				response['status_code'] = 400
				response['status_message'] = 'Something went wrong. Please try again later.'
				return Response(response)
			compObj=CustomerPurchase.objects.filter(customerID=idAdmin.userUniqueID,planID=data.get('planID')).first()
			if compObj:
				if compObj.isUsed==True:
					compObj.isUsed=False
				else:
					pass
			else:
				compObj=CustomerPurchase.objects.create(customerID=idAdmin.userUniqueID)
			compObj.planID=data.get('planID')
			if alreadyAPlanInActive==True:
				compObj.isActive=False
			else:
				compObj.isActive=True
			# if data.get('oneTime')==True:
				# compObj.option='OneTime'
			if firstPurchase==True:
				hoursInDays=int(theDays)*24
				# hoursOfTrial=int(theTrialDays)*24
				startDate=datetime.now()
				startDate=startDate.date()
				# trialExpiryDate=startDate+timedelta(hours=hoursOfTrial)
				# expiryDate=trialExpiryDate+timedelta(hours=hoursInDays)
				expiryDate=startDate+timedelta(hours=hoursInDays)
				compObj.startDate=startDate
				# compObj.trialExpiry=trialExpiryDate
				compObj.expiryDate=expiryDate
				# compObj.isTrial=True
				compObj.isUsed=True
				compObj.planDuration=theDays
				compObj.planName=thePlanName
				compObj.planPrice=thePlanPrice
				compObj.description=theDesc
				compObj.htmlDescription=theHTMLDesc
			else:
				hoursInDays=int(theDays)*24
				if alreadyAPlanInActive==True:
					compObj.isUsed=False
					# startDate=datetime.now()
					startDate=str(currentPlanObj.expiryDate)
					print("theObjectDate",startDate)
					import datetime as dv
					startDate=dv.datetime.strptime(startDate, '%Y-%m-%d')
					print(startDate)
					print(type(startDate))
					startDate=startDate.date()
					print(startDate)
					expiryDate=startDate+timedelta(hours=hoursInDays)
				else:
					startDate=datetime.now()
					startDate=startDate.date()
					expiryDate=startDate+timedelta(hours=hoursInDays)
					compObj.isUsed=True
				compObj.planDuration=theDays
				compObj.startDate=startDate
				compObj.expiryDate=expiryDate
				compObj.isTrial=False
				compObj.planName=thePlanName
				compObj.planPrice=thePlanPrice
				compObj.description=theDesc
				compObj.htmlDescription=theHTMLDesc
			compObj.save()
			if firstPurchase==True:
				currentPlanObj=currentPlan.objects.create(customerID=idAdmin.userUniqueID)
				currentPlanObj.myPlan=compObj
				currentPlanObj.startDate=startDate
				currentPlanObj.expiryDate=expiryDate
				# if data.get('oneTime')==True:
					# currentPlanObj.option='OneTime'
				# currentPlanObj.trialExpiry=trialExpiryDate
				# currentPlanObj.isTrial=True
				currentPlanObj.isActive=True
				currentPlanObj.save()
			else:
				if alreadyAPlanInActive==True:
					pass
				else:
					currentPlanObj.myPlan=compObj
					currentPlanObj.startDate=startDate
					currentPlanObj.expiryDate=expiryDate
					# if data.get('oneTime')==True:
						# currentPlanObj.option='OneTime'
					currentPlanObj.isActive=True
					currentPlanObj.isTrial=False
					currentPlanObj.save()
			try:
				print("==After all Purchase adding value in admin earning count==")
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/subscriptions/addSubscriptionEarning/"
				theToken=str(settings.ADMIN_ACCESS_KEY)
				payload={'AccessKey':theToken,
						 'amount':thePlanPrice,}
				print("payload",payload)
				print(url)
				apiResponse = requests.request("POST", url, data=payload)
				print(apiResponse)
				apiResponse = apiResponse.json()
				print(apiResponse)
				if apiResponse['status_code']==200:
					pass
				else:
					return Response(response)
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

def PaymentWithExistingCard(cust_id , card_id , total_amount):
    response = {}
    try:
        stripe.api_key  = settings.STRIPE_SECRET_KEY
        stripe_amount_det = stripe.Charge.create(
			currency="USD",
            customer=cust_id,
            card=card_id,
            amount=total_amount*100,
            description="charge from user",
            shipping={
                    'name': 'Jenny Rosen',
                    'address': {
                        'line1': '510 Townsend St',
                        'postal_code': '98140',
                        'city': 'San Francisco',
                        'state': 'CA',
                        'country': 'US',
                        },
                    },
        )
        print(stripe_amount_det)
        if stripe_amount_det:
            response['status'] = True
            response['data'] = stripe_amount_det
    except Exception as e:
        response['status'] = False
        response['message'] = str(e)
    return response

class renewSubscriptions(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			print("==START==")
			allPlanDatas=[]
			todayExpiry=datetime.now()
			todayExpiry=todayExpiry.date()
			allPlans=currentPlan.objects.filter(expiryDate=todayExpiry)
			# allPlans=CompanyPurchase.objects.filter(expiryDate=todayExpiry)
			for plan in allPlans:
				nextPlanAvailable=CustomerPurchase.objects.filter(isUsed=False,customerID=plan.customerID).first()
				if nextPlanAvailable:
					allPlanDatas.append({'planObjectID':plan.id,
										'planID':str(nextPlanAvailable.planID),
										'renewType':'NEW',
										'otherPlanObjectID':str(nextPlanAvailable.id),
										})
					pass
				else:
					if plan.option=='OneTime':
						# plan.isActive=False
						# plan.isdeleted=True
						# plan.save()
						# theIDS=plan.myPlan.id
						# usedPlan=CustomerPurchase.objects.filter(id=theIDS).first()
						
						# usedPlan.isdeleted=True
						# usedPlan.isActive=False
						# usedPlan.save()
						plan.delete()
						pass
					elif plan.option=='AutoRenew':
						allPlanDatas.append({'planObjectID':plan.id,
											'planID':str(plan.myPlan.planID),
											'renewType':'SAME',
											'otherPlanObjectID':'0',
											})
					else:
						pass
			try:
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/subscriptions/viewPlanListDataForRenew/"
				theToken=str(settings.ADMIN_ACCESS_KEY)
				payload={'AccessKey':theToken,
						'planData':json.dumps(allPlanDatas),
						'userType':'1'}
				apiResponse = requests.request("POST", url, data=payload)
				apiResponse = apiResponse.json()
				print(apiResponse)
				print(apiResponse['data'])
				# print(apiResponse['data']['theReturnPlanData'])
				if apiResponse['status_code']==200:
					for plan in apiResponse['data']:
						try:
							thePlanName=plan['theReturnPlanData']['planName']
							thePlanPrice=plan['theReturnPlanData']['price']
							theDesc=plan['theReturnPlanData']['description']
							theHTMLDesc=plan['theReturnPlanData']['htmlDescription']
							theDays=plan['theReturnPlanData']['planDurationDays']
							theTrialDays=plan['theReturnPlanData']['trialDurationDays']
							theObject=allPlans.get(id=plan['planObjectID'])
							theCard=CustomerCard.objects.filter(customerID=theObject.customerID,isdefault=True).first()
							if not theCard:
								continue
							thePaymentObject=PaymentWithExistingCard(theCard.theCustomer,theCard.cardID,int(thePlanPrice))
							if thePaymentObject['status'] == True :
								pass
								# response['data'] = thePaymentObject['data']
							else:
								continue
								# response['status_code'] = 400
								# response['status_message'] = 'Something went wrong. Please try again later.'
								# return Response(response)
							if plan['renewType']=='NEW':
								theNewPlan=CustomerPurchase.objects.filter(id=plan['otherPlanObjectID']).first()
								theNewPlan.isActive=True
								theNewPlan.isUsed=True
								theNewPlan.save()
								oldPlanID=theObject.myPlan.id
								theOLdPlan=CustomerPurchase.objects.filter(id=oldPlanID).first()
								theObject.myPlan=theNewPlan
								# theObject.option=theNewPlan.option
								hoursInDays=int(theDays)*24
								# hoursOfTrial=int(theTrialDays)*24
								startDate=datetime.now()
								startDate=startDate.date()
								expiryDate=startDate+timedelta(hours=hoursInDays)
								theObject.startDate=startDate
								theObject.expiryDate=expiryDate
								theObject.isTrial=False
								theObject.save()
								theOLdPlan.delete()
							else:
								if theObject.option=='AutoRenew':
									hoursInDays=int(theDays)*24
									# hoursOfTrial=int(theTrialDays)*24
									startDate=datetime.now()
									startDate=startDate.date()
									expiryDate=startDate+timedelta(hours=hoursInDays)
									theObject.startDate=startDate
									theObject.expiryDate=expiryDate
									theObject.isTrial=False
									theObject.save()
						except Exception as e:
							print(e)
							response['status_code']=500
							response['status_message']=str(e)
							return Response(response)
				else:
					response['status_code']=400
					response['status_message']='Not valid plan id'
					return Response(response)
				response['status_code']=200
				response['status_message']='Success'
				return Response(response)
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
			return Response(response)

class deleteSubscriptions(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			if not data.get('planID'):
				response['status_code']=400
				response['status_message']='Plan id required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			idAdmin=Customer.objects.filter(userToken=session_token).first()
			if not idAdmin:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			compObj=CustomerPurchase.objects.filter(customerID=idAdmin.userUniqueID,planID=data.get('planID')).first()
			if compObj:
				ifCurrentPlan=currentPlan.objects.filter(myPlan=compObj).first()
				if ifCurrentPlan:
					nextPlan=CustomerPurchase.objects.filter(customerID=idAdmin.userUniqueID,isUsed=False).first()
					if nextPlan:
						hoursInDays=int(nextPlan.planDuration)*24
						startDate=datetime.now()
						startDate=startDate.date()
						expiryDate=startDate+timedelta(hours=hoursInDays)
						ifCurrentPlan.myPlan=nextPlan
						ifCurrentPlan.startDate=startDate
						ifCurrentPlan.expiryDate=expiryDate
						ifCurrentPlan.save()
						nextPlan.isUsed=True
						nextPlan.isActive=True
						nextPlan.save()
				compObj.delete()
				# compObj.isdeleted=True
				# compObj.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class mySubscriptionDetails(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			idAdmin=Customer.objects.filter(userToken=session_token).first()
			if not idAdmin:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			compObj=CustomerPurchase.objects.filter(customerID=idAdmin.userUniqueID,isdeleted=False).first()
			if compObj:
				compObj.save()
				theData=GetSubDataAnother(compObj)
				response['data']=theData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class activePlan(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			idAdmin=Customer.objects.filter(userToken=session_token).first()
			if not idAdmin:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			if not data.get('planID'):
				response['status_code']=400
				response['status_message']='Plan id required'
				return Response(response)
			# currentActive=CustomerPurchase.objects.filter(customerID=idAdmin.userUniqueID,isActive=True).first()
			# if currentActive:
				# currentActive.delete()
			compObj=CustomerPurchase.objects.filter(customerID=idAdmin.userUniqueID,planID=data.get('planID'),isUsed=False).first()
			if compObj:
				ifCurrentPlan=currentPlan.objects.filter(customerID=idAdmin.userUniqueID).first()
				if ifCurrentPlan:
					oldPlanId=ifCurrentPlan.myPlan.id
					oldPlanObject=CustomerPurchase.objects.filter(customerID=idAdmin.userUniqueID,planID=data.get('planID')).first()
					hoursInDays=int(compObj.planDuration)*24
					startDate=datetime.now()
					startDate=startDate.date()
					expiryDate=startDate+timedelta(hours=hoursInDays)
					ifCurrentPlan.myPlan=compObj
					ifCurrentPlan.startDate=startDate
					ifCurrentPlan.expiryDate=expiryDate
					ifCurrentPlan.save()
					compObj.isUsed=True
					compObj.save()
				compObj.isActive=True
				compObj.save()
				theData=GetSubData(compObj)
				# if oldPlanObject:
				# 	oldPlanObject.delete()
				response['data']=theData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class myPurchasedPlanList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			idAdmin=Customer.objects.filter(userToken=session_token).first()
			if not idAdmin:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			allPlans=CustomerPurchase.objects.filter(customerID=idAdmin.userUniqueID,isdeleted=False)
			if allPlans:
				theData=GetSubData(compObj,many=True)
				response['data']=theData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class subscriptionsRenewStatus(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])
			session_token = session_token.replace("Token ", "")
			idAdmin=Customer.objects.filter(userToken=session_token).first()
			if not idAdmin:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			if not data.get('status'):
				response['status_code']=400
				response['status_message']='status required'
				return Response(response)
			if data.get('status')=='True':
				optionValue='AutoRenew'
			else:
				optionValue='OneTime'
			currentPlanObject=currentPlan.objects.filter(customerID=idAdmin.userUniqueID).first()
			if currentPlanObject:
				currentPlanObject.option=optionValue
				currentPlanObject.save()
			response['status_code']=200
			response['status_message']='Status change'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)