from django.template.defaultfilters import lower
from rest_framework.views import APIView
from rest_framework.response import Response
from base.models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from datetime import datetime
from datetime import timedelta
import requests
from django.conf import settings
import json
from django.db.models import Q


class getTicketTypes(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			customerObj = Customer.objects.filter(userToken=session_token).first()
			if not customerObj:
				response['status_code']=401
				response['status_message']='Customer not exist'
				return Response(response,status=response['status_code'])	
			try:
				url = str(settings.AHS_ACCESS_URL)+"superadmin/support/tickets/getRoleByCustomer/"
				res = requests.request("GET", url)
				print(res.json())
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class addTicket(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			customerObj = Customer.objects.filter(userToken=session_token).first()
			if not customerObj:
				response['status_code']=401
				response['status_message']='Customer not exist'
				return Response(response,status=response['status_code'])
			if not data.get('supportRole'):
				response['status_code']=400
				response['status_message']='supportRole required'
				return Response(response)
			if not data.get('supportType'):
				response['status_code']=400
				response['status_message']='supportType required'
				return Response(response)
			if not data.get('title'):
				response['status_code']=400
				response['status_message']='title required'
				return Response(response)
			if not data.get('message'):
				response['status_code']=400
				response['status_message']='message required'
				return Response(response)
			# if not data.get('orderID'):
			# 	response['status_code']=400
			# 	response['status_message']='orderID required'
			# 	return Response(response)
			if not data.get('longitude'):
				response['status_code']=400
				response['status_message']='longitude required'
			if not data.get('latitude'):
				response['status_code']=400
				response['status_message']='latitude required'
				return Response(response)
			if not data.get('messageType'):
				response['status_code']=400
				response['status_message']='messageType required'
				return Response(response)

			if data.get('messageType')=='TEXT':
				pass
			elif data.get('messageType')=='IMAGE':
				pass
			else:
				response['status_code']=400
				response['status_message']='invalid message type'
				return Response(response)

			try:
				payload={}
				payload['supportRole']=data.get('supportRole')
				payload['supportType']=data.get('supportType')
				payload['userID']=customerObj.userUniqueID
				if data.get('orderID'):
					payload['orderID']=data.get('orderID')
				payload['userType']='Customer'
				payload['title']=data.get('title')
				payload['message']=data.get('message')
				payload['longitude']=data.get('longitude')
				payload['latitude']=data.get('latitude')
				payload['messageType']=data.get('messageType')
				if data.get('supportType')=='Admin':
					url = str(settings.AHS_ACCESS_URL)+"superadmin/support/tickets/addTicketByCustomer/"
					payload['AccessKey']=str(settings.AHS_ACCESS_KEY)
				else:
					url = str(settings.CHS_ACCESS_URL)+"company/support/tickets/addTicketByCustomer/"
					payload['AccessKey']=str(settings.CHS_ACCESS_KEY)
				res = requests.request("POST",url,data=payload)
				print(res.json())
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class getTicketList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			customerObj = Customer.objects.filter(userToken=session_token).first()
			if not customerObj:
				response['status_code']=401
				response['status_message']='Customer not exist'
				return Response(response,status=response['status_code'])
			try:
				print("==1==")
				payload={}
				payload['AccessKey']=str(settings.AHS_ACCESS_KEY)
				payload['userID']=customerObj.userUniqueID
				payload['userType']='Customer'
				url = str(settings.AHS_ACCESS_URL)+"superadmin/support/tickets/getTicketByCustomer/"
				res = requests.request("POST",url,data=payload)
				res=res.json()
				if res['status_code']==200:
					print("==1.A==")
					theData=res['data']
					data1=[i for i in theData]
				else:
					print("==1.B==")
					return Response(res)
				print("==2==")
				payload['AccessKey']=str(settings.CHS_ACCESS_KEY)
				url2 = str(settings.CHS_ACCESS_URL)+"company/support/tickets/getTicketByCustomer/"
				
				res2 = requests.request("POST",url2,data=payload)
				res2=res2.json()
				# res2=res2.json()
				if res2['status_code']==200:
					print("==2.A==")
					# theData2=res2['data']
					theData2=res2['data']
					data2=[i for i in theData2]
					data1=data1+data2
				else:
					print("==2.B==")
					return Response(res2)
				print("==3==")
				finalData=data1
				finalData.sort(key=lambda theJson: datetime.strptime(theJson['date'], "%b %d, %Y"))
				finalData.reverse()
				response['status_code']=200
				response['status_message']='All list data'
				response['data']=finalData
				return Response(response)
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class getTicketChat(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			customerObj = Customer.objects.filter(userToken=session_token).first()
			if not customerObj:
				response['status_code']=401
				response['status_message']='Customer not exist'
				return Response(response,status=response['status_code'])
			if not data.get('ticketID'):
				response['status_code']=400
				response['status_message']='ticketID required'
				return Response(response)
			if not data.get('supportType'):
				response['status_code']=400
				response['status_message']='supportType required'
				return Response(response)
			try:
				payload={}
				payload['AccessKey']=str(settings.AHS_ACCESS_KEY)
				payload['ticketID']=data.get('ticketID')
				if data.get('supportType')=='Admin':
					url = str(settings.AHS_ACCESS_URL)+"superadmin/support/tickets/getTicketChatByCustomer/"
					payload['AccessKey']=str(settings.AHS_ACCESS_KEY)
				else:
					url = str(settings.CHS_ACCESS_URL)+"company/support/tickets/getTicketChatByCustomer/"
					payload['AccessKey']=str(settings.CHS_ACCESS_KEY)
				res = requests.request("POST",url,data=payload)
				print(res.json())
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class addMessage(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			customerObj = Customer.objects.filter(userToken=session_token).first()
			if not customerObj:
				response['status_code']=401
				response['status_message']='Customer not exist'
				return Response(response,status=response['status_code'])
			if not data.get('ticketID'):
				response['status_code']=400
				response['status_message']='ticketID required'
				return Response(response)
			if not data.get('supportType'):
				response['status_code']=400
				response['status_message']='supportType required'
				return Response(response)
			if not data.get('message'):
				response['status_code']=400
				response['status_message']='message required'
				return Response(response)
			if not data.get('messageType'):
				response['status_code']=400
				response['status_message']='messageType required'
				return Response(response)

			if data.get('messageType')=='TEXT':
				pass
			elif data.get('messageType')=='IMAGE':
				pass
			else:
				response['status_code']=400
				response['status_message']='Invalid message type'
				return Response(response)
			try:
				payload={}
				payload['AccessKey']=str(settings.AHS_ACCESS_KEY)
				payload['ticketID']=data.get('ticketID')
				payload['message']=data.get('message')
				payload['messageType']=data.get('messageType')
				if data.get('supportType')=='Admin':
					url = str(settings.AHS_ACCESS_URL)+"superadmin/support/tickets/addMessageByCustomer/"
					payload['AccessKey']=str(settings.AHS_ACCESS_KEY)
				else:
					url = str(settings.CHS_ACCESS_URL)+"company/support/tickets/addMessageByCustomer/"
					payload['AccessKey']=str(settings.CHS_ACCESS_KEY)
				res = requests.request("POST",url,data=payload)
				print(res.json())
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
import random,string
def randomStringFunctionForImage():
  str1 = ''.join((random.choice(string.ascii_letters) for x in range(10)))
  str2 = ''.join((random.choice(string.digits) for x in range(6)))
  str2=str2.lower()
  str1=str1+str2
  sam_list = list(str1)
  random.shuffle(sam_list)
  finalString = ''.join(sam_list)
  return finalString

def uploadMessageImage(image):
	import os
	import boto3
	response={}
	from botocore.exceptions import NoCredentialsError
	try:
		ACCESS_KEY=str(settings.AWS_ACCESS_KEY_ID)
		SECRET_KEY=str(settings.AWS_SECRET_ACCESS_KEY)
		s3 = boto3.client('s3', aws_access_key_id=ACCESS_KEY,
                      aws_secret_access_key=SECRET_KEY)
		try:
			bucket='cannabisadminsupport'
			thePath='messagemedia'
			filetype = os.path.splitext(image.name)[1]
			imageName=randomStringFunctionForImage()
			thePath=thePath+'/'+imageName+'.'+filetype
			thePath=thePath.replace('..','.')
			thePath=str(thePath)
			theFile=s3.upload_fileobj(image,bucket,thePath)
			print("Upload Successful")
			filename=str(settings.AWS_BUCKET_URL_1)+str(bucket)+str(settings.AWS_BUCKET_URL_2)+thePath
			response['status_code']=200
			response['status_message']='Image uploded'
			response['imageUrl']=filename
			return response
		except FileNotFoundError as e:
			print("The file was not found")
			response['status_code']=400
			response['status_message']='The file was not found'
			return response
		except NoCredentialsError as e:
			print("Credentials not available")
			response['status_code']=400
			response['status_message']='Credentials not available'
			return response
	except Exception as e:
		print(e)
		response['status_code']=500
		response['status_message']=str(e)
		return response

class uploadMessageAttachment(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			customerObj = Customer.objects.filter(userToken=session_token).first()
			if not customerObj:
				response['status_code']=401
				response['status_message']='Customer not exist'
				return Response(response,status=response['status_code'])
			image=request.FILES.get('image')
			if not image:
				response['status_code']=400
				response['status_message']='image required'
				return Response(response)
			try:
				theReturnJson=uploadMessageImage(image)
				# response['status_code']=200
				# response['status_message']='Image uploded'
				# response['imageUrl']=fileName
				return Response(theReturnJson)
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)