from django.db import models
import random  
import string
from django.contrib.auth.models import User
# Create your models here.
from django.contrib.auth.models import AbstractUser
from django.utils.translation import gettext as _

RISK = (
    ('1', "Green"),
    ('2', "Yellow"),
    ('3', "Red"),
)

class driver(models.Model):
	"""
	This model is used to store the information of Customer.
	"""
	userTableID = models.CharField(max_length = 50, null = True, blank = True)
	userUniqueID = models.CharField(max_length = 50, null = True, blank = True)
	userToken = models.CharField(max_length = 50, null = True, blank = True,default='')
	risk = models.CharField(max_length = 50,choices = RISK,default = '3')
	driverType = models.CharField(max_length = 50,default='Admin', blank = True)
	companyId = models.CharField(max_length = 50, null = True, blank = True)
	name = models.CharField(max_length = 50, null = True, blank = True,default='')
	email = models.CharField(max_length = 50, unique = True, null = True, blank = True,default='')
	countrycode = models.CharField(max_length = 50, null = True, blank = True,default='')
	phone = models.CharField(max_length = 50, blank = True, null = True,default='')
	image = models.CharField(max_length = 200, null = True, blank = True)
	state = models.CharField(max_length = 20, blank = True, null = True,default='')
	age = models.CharField(max_length = 20, blank = True, null = True,default='')
	dob = models.DateField(max_length=25,blank=True,null=True)
	address = models.TextField(null = True, blank = True)
	fcmtoken = models.CharField(max_length = 200, blank = True, null = True,default='')
	signupOtp = models.CharField(max_length = 50, blank = True, null = True,default='')
	signupOtpVerfied = models.BooleanField(default = False)
	emailverificationlink = models.CharField(max_length = 300, blank = True, null = True,default='')
	emailverified = models.BooleanField(default = False)
	phoneVerifiedOtp = models.CharField(max_length = 100, blank = True, null = True)
	phoneverified = models.BooleanField(default = False)
	currentlocation = models.TextField(null = True, blank = True)
	currentlatitude = models.FloatField(max_length = 50, blank = True, null = True)
	currentlongitude = models.FloatField(max_length = 20, blank = True, null = True)
	socialId = models.CharField(max_length = 300, blank = True, null = True,default='')
	deviceId = models.CharField(max_length = 300, blank = True, null = True,default='')
	deviceType = models.CharField(max_length = 300, blank = True, null = True,default='')
	registerType = models.CharField(max_length = 300, blank = True, null = True,default='')
	userReferalCode = models.CharField(max_length = 300, blank = True, null = True,default='')
	referalByCode = models.CharField(max_length = 300, blank = True, null = True,default='')
	forgotPasswordOTP = models.CharField(max_length=100,blank=True,null=True)
	isNotificationSoundOn = models.BooleanField(default = True)
	isNotificationOn = models.BooleanField(default = True)
	accountverified = models.BooleanField(default = False)
	accountapproved = models.BooleanField(default = False)
	isRequested = models.BooleanField(default = False)
	isactive = models.BooleanField(default = False)
	isbooked = models.BooleanField(default = False)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.name)+'--'+str(self.userUniqueID))

class totalratings(models.Model):
	driver= models.ForeignKey(driver, on_delete=models.CASCADE,default='',null=True)
	totalCount = models.CharField(max_length = 20, null = True, blank = True,default='0')
	totalRatingNumbers = models.CharField(max_length = 20, null = True, blank = True,default='0')
	averageRating = models.CharField(max_length = 20, null = True, blank = True,default='0')
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.driver)+' - '+str(self.averageRating))

class ratings(models.Model):
	driver= models.ForeignKey(driver, on_delete=models.CASCADE,default='',null=True)
	totalratings= models.ForeignKey(totalratings, on_delete=models.CASCADE,default='',null=True)
	rating = models.CharField(max_length = 20, null = True, blank = True)
	review = models.TextField(blank = True)
	customerID = models.CharField(max_length = 30, null = True, blank = True)
	orderID = models.CharField(max_length = 30, null = True, blank = True)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.driver)+' - '+str(self.rating))


DOC_TYPES = (
    ('1', "Passport"),
    ('2', "Licence"),
    ('3', "National ID"),
    ('4', "Age Proof"),
    ('5', "Other"),
)

DOC_STATUS = (
    ('1', "Pending"),
    ('2', "Accepted"),
    ('3', "Rejected"),
)

class driverdocuments(models.Model):
	doctType = models.CharField(max_length = 20,choices = DOC_TYPES,default = '5')
	userTableID = models.CharField(max_length = 20, null = True, blank = True)
	userUniqueID = models.CharField(max_length = 20, null = True, blank = True,default = '')
	document = models.CharField(max_length = 200, null = True, blank = True)
	theStatus=models.CharField(max_length = 20,choices = DOC_STATUS,default = '1')
	rejectMessage = models.TextField(null = True, blank = True)
	isApproved = models.BooleanField(default = False)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.userUniqueID)+' - '+str(self.doctType))


class companyaccess(models.Model):
	companyId = models.CharField(max_length = 30,null = True, blank = True,default='')
	token = models.CharField(max_length = 50, null = True, blank = True)
	
	def __str__(self):
		return str(str(self.token))

class superadminaccess(models.Model):
	theID = models.CharField(max_length = 20,null = True, blank = True,default='1')
	token = models.CharField(max_length = 75, null = True, blank = True,default='')

	def __str__(self):
		return str(str(self.token))

class notifications(models.Model):
	driverID = models.CharField(max_length = 50, null = True, blank = True,default = '')
	image = models.CharField(max_length = 200, null = True, blank = True,default = '')
	title = models.CharField(max_length = 50, null = True, blank = True,default = '')
	description = models.TextField(null = True, blank = True)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.driverID)+'-'+str(self.title))