from rest_framework import serializers
from .models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from django.conf import settings
# from Superadmin.models import *
class GetDriverData(serializers.ModelSerializer):
    currencySymbol =  serializers.SerializerMethodField(source='get_currencySymbol')
    currencyCode =  serializers.SerializerMethodField(source='get_currencyCode')

    helpEmail =  serializers.SerializerMethodField(source='get_helpEmail')
    helpCountryCode =  serializers.SerializerMethodField(source='get_helpCountryCode')
    helpNumber =  serializers.SerializerMethodField(source='get_helpNumber')

    token =  serializers.SerializerMethodField(source='get_token')
    image =  serializers.SerializerMethodField(source='get_image')
    dob =  serializers.SerializerMethodField(source='get_dob')

    averageRatings =  serializers.SerializerMethodField(source='get_averageRatings')
    
    class Meta:
        model = driver
        fields = ['helpEmail','state','dob','age','averageRatings','helpCountryCode','helpNumber','token','userUniqueID','risk','name', 'email','phone','countrycode','socialId','image','phoneverified','userReferalCode','isNotificationSoundOn','isNotificationOn','isactive','currencySymbol','currencyCode']

    def get_image(self, obj):
        if obj.image:
            return str(obj.image)
        else:
            return ''
    
    def get_helpEmail(self, obj):
        return 'contact@cannabis.com'

    def get_helpCountryCode(self, obj):
        return '+1'

    def get_helpNumber(self, obj):
        return '0102453252'

    def get_token(self, obj):
        userObject=User.objects.filter(id=obj.userTableID).first()
        token,status = Token.objects.get_or_create(user = userObject)
        tokenKey=token.key
        return tokenKey
    
    def get_currencySymbol(self, obj):
        return '$'
    
    def get_currencyCode(self, obj):
        return 'USD'
    
    def get_dob(self, obj):
        if obj.dob is not None:
            return obj.dob
        else:
            return ''
        
    def get_averageRatings(self, obj):
        theTotalRates=totalratings.objects.filter(driver=obj).first()
        if theTotalRates:
            return str(theTotalRates.averageRating)
        else:
            return str(0)

class GetDriverDataNew(serializers.ModelSerializer):
    currencySymbol =  serializers.SerializerMethodField(source='get_currencySymbol')
    currencyCode =  serializers.SerializerMethodField(source='get_currencyCode')
    averageRatings =  serializers.SerializerMethodField(source='get_averageRatings')
    dob =  serializers.SerializerMethodField(source='get_dob')
    
    class Meta:
        model = driver
        fields = ['token','uuid','userUniqueID','dob','averageRatings','name', 'email','phone','countrycode','socialId','image','phoneverified','userReferalCode','isNotificationSoundOn','isNotificationOn','isactive','currencySymbol','currencyCode']
    
    def get_currencySymbol(self, obj):
        return '$'
    
    def get_currencyCode(self, obj):
        return 'USD'
    
    def get_averageRatings(self, obj):
        theTotalRates=totalratings.objects.filter(driver=obj).first()
        return str(theTotalRates.averageRating)
    
    def get_dob(self, obj):
        if obj.dob is not None:
            return obj.dob
        else:
            return ''