from django.contrib import admin
from django.urls import path
from django.conf.urls import url, include
from django.views.static import serve
from django.conf import settings
from django.conf.urls import handler400, handler403, handler404, handler500
from .views import *
from . import views
urlpatterns = [
   url(r'^$',Index, name='index'),
   path('getBusinessTypeList/', getBusinessTypeList.as_view(), name = 'getBusinessTypeList'),
   path('getStateList/', getStateList.as_view(), name = 'getStateList'),
   path('getCompanyList/', getCompanyList.as_view(), name = 'getCompanyList'),
   path('checkExistence/', checkExistence.as_view(), name = 'checkExistence'),
   path('register/', registerDriver.as_view(), name = 'registerCustomer'),
   path('veifySignupOTP/', veifySignupOTP.as_view(), name = 'veifySignupOTP'),
   path('login/', loginDriver.as_view(), name = 'loginCustomer'),
   url(r'^forgotPassword/$', forgotPassword.as_view(), name='forgotPassword'),
   url(r'^forgotPasswordVerifyOtp/$', forgotPasswordVerifyOtp.as_view(), name='forgotPasswordVerifyOtp'),

   url(r'^updatePassword/$', updatePassword.as_view(), name='updatePassword'),
   path('changePassword/', ChangePassword.as_view(), name = 'ChangePassword'),
   url(r'^resendSignupOTP/$', resendSignupOTP.as_view(), name='resendSignupOTP'),
   url(r'^verifPhoneWithOTP/$', verifPhoneWithOTP.as_view(), name='verifPhoneWithOTP'),
   path('socialLogin/', socialLogin.as_view(), name = 'socialLogin'),
   url(r'^getProfile/$', getProfile.as_view(), name='getProfile'),

   url(r'^onlineOfflineStatus/$', onlineOfflineStatus.as_view(), name='onlineOfflineStatus'),
   
   url(r'^updateProfile/$', updateProfile.as_view(), name='updateProfile'),
   url(r'^logout/$', logout.as_view(), name='logout'),
   url(r'^getDocuments/$', getDocuments.as_view(), name='getDocuments'),
   url(r'^getDocumentsStatus/$', getDocumentsStatus.as_view(), name='getDocuments'),
   url(r'^updateDocuments/$', updateDocuments.as_view(), name='updateDocuments'),
   path('getSettings/', getSettings.as_view(), name = 'getSettings'),
   
   # Others
   url(r'^getNearbyDrivers/$', getNearbyDrivers.as_view(), name='getNearbyDrivers'),
   path('notificationSoundStatus/', notificationSoundStatus.as_view(), name = 'notificationSoundStatus'),
   path('notificationStatus/', notificationStatus.as_view(), name = 'notificationStatus'),
   path('deactivateAccount/', deactivateAccount.as_view(), name = 'deactivateAccount'),
   path('requestAdmin/', requestAdmin.as_view(), name = 'getSettings'),

   # Company
   path('countDriversForLimitCheck/', countDriversForLimitCheck.as_view(), name = 'countDriversForLimitCheck'),

   # Notifications
   url(r'^getNotifications/$', getNotifications.as_view(), name='getNotifications'),
   url(r'^deleteNotification/$', deleteNotification.as_view(), name='deleteNotification'),
   path('gernateTwilioToken/',gernateTwilioToken.as_view()),
   path('driverNotify/',driverNotify.as_view()),

   url(r'^requestPayout/$', requestPayout.as_view(), name='requestPayout'),
]
