from rest_framework.views import APIView
from django.contrib.auth.models import User
from django.contrib.auth import authenticate
from rest_framework.authtoken.models import Token
from .models import *
from pyfcm import FCMNotification
import math, random, datetime, pytz, string
from django.conf import settings
import requests, json
from django.contrib.auth.hashers import make_password
from django.db.models import Q
from .serializers import *
from django.http import HttpResponse
from rest_framework.response import Response
from django.template.loader import render_to_string
from django.core.mail import EmailMessage
from django.core.files.storage import FileSystemStorage
from datetime import datetime

import boto
import boto.exception
import boto.sns
import pprint
import re
import boto3

def sendPush(listOfDevices, body):
	region = [r for r in boto.sns.regions() if r.name==u'us-east-1'][0]
	sns = boto.sns.SNSConnection(
		aws_access_key_id=str(settings.AWS_ACCESS_KEY_ID),
		aws_secret_access_key=str(settings.AWS_SECRET_ACCESS_KEY),
		region=region,
	)
	try:
		endpoint_response = sns.create_platform_endpoint(
			platform_application_arn='arn:aws:sns:us-east-1:432363816440:app/GCM/Cannabis',
			token=listOfDevices,
		)   
		endpoint_arn = endpoint_response['CreatePlatformEndpointResponse']['CreatePlatformEndpointResult']['EndpointArn']
	except boto.exception.BotoServerError as err:
		result_re = re.compile(r'Endpoint(.*)already', re.IGNORECASE)
		result = result_re.search(err.message)
		if result:
			endpoint_arn = result.group(0).replace('Endpoint ','').replace(' already','')
		else:
			raise
	print("ARN:", endpoint_arn)
	publish_result = sns.publish(
		target_arn=endpoint_arn,
		message=json.dumps(body),
		# message_structure='json'
	)
	print("PUBLISH")
	pprint.pprint(publish_result)

# For future use
def sendTemplateMail():
	import boto3
	ses = boto3.client('ses')
	response = ses.send_templated_email(
		Source='EMAIL_ADDRESS',
		Destination={
			'ToAddresses': [
			'EMAIL_ADDRESS',
			],
			'CcAddresses': [
			'EMAIL_ADDRESS',
			]
		},
		ReplyToAddresses=[
			'EMAIL_ADDRESS',
		],
		Template='TEMPLATE_NAME',
		TemplateData='{ \"REPLACEMENT_TAG_NAME\":\"REPLACEMENT_VALUE\" }'
		)
	print(response)

def sendCustomMail(recList,theMessage):
	region = [r for r in boto.sns.regions() if r.name==u'us-east-1'][0]
	client = boto3.client('ses',
		aws_access_key_id=str(settings.AWS_ACCESS_KEY_ID),
		aws_secret_access_key=str(settings.AWS_SECRET_ACCESS_KEY),
		region_name='us-east-2',
	)
	# client = boto3.client('ses')
	response = client.send_email(
		Destination={
			'ToAddresses': ['developeresfera@yopmail.com'],
		},
		Message={
			'Body': {
				'Html': {
					'Charset': 'UTF-8',
					'Data': theMessage,
				},
				'Text': {
					'Charset': 'UTF-8',
					'Data': 'This is for those who cannot read HTML.',
				},
			},
			'Subject': {
				'Charset': 'UTF-8',
				'Data': 'Hello World',
			},
		},
		Source=str(settings.EMAIL_HOST_EMAIL),
	)
	print(response)

class getBusinessTypeList(APIView):
	def get(self, request, *args, **kwargs):
		response={}
		try:
			allData=[]
			allData.append({'businessType':'Company'})
			allData.append({'businessType':'Others'})
			response['status_code']=200
			response['status_message']='Success'
			response['data']=allData
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def Index(request):
	return HttpResponse("<h4>DriverBasicDetails</h4>")

def referralCode():
	try:
		Referal=''
		digits2 = "rba2cqq4skyhz7meizjk"
		for i in range(8): 
		  Referal += digits2[math.floor(random.random() * 15)]
		print(Referal)
	except Exception as e:
		print(e)
	return str(Referal)

def GernateOTP():
	'''Function for gernate otp'''
	digits = "0123456789"
	OTP = ""
	for i in range(4) :
		OTP += digits[math.floor(random.random() * 10)]
	return OTP

def randomStringFunction():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(8)))
	str1 += ''.join((random.choice(string.digits) for x in range(4)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

#Created By AMIT RAJPUT 
def getStateListFunction():
	try:
		# buisnessTypeData=[]
		response={}
		# buisnessTypeData.append({'businessType':'Company'})
		# buisnessTypeData.append({'businessType':'Others'})
		url = str(settings.ADMIN_ACCESS_URL)+"superadmin/setting/getStatesForOthers/"
		headers = {
		'Authorization': 'Token '+str(settings.ADMIN_ACCESS_KEY)+'',
		}
		r = requests.request("POST", url, headers=headers)
		print(r)
		r=r.json()
		allStatesData=[]
		for st in r['data']:
			allStatesData.append({'state':st['state'],
								'fulladdress':st['fulladdress'],
								'minimumage':st['minimumage']})
		print(allStatesData)
		response['status_code']=200
		response['data']=allStatesData
		response['status_message']='All Data'
		# response['status_message']=str(e)
		return response
	except Exception as e:
		response['status_code']=500
		response['status_message']=str(e)
		return response

#End of Code 
class getStateList(APIView):
	def get(self, request):
		response={}
		try:
			buisnessTypeData=[]
			buisnessTypeData.append({'businessType':'Company'})
			buisnessTypeData.append({'businessType':'Others'})
			url = str(settings.ADMIN_ACCESS_URL)+"superadmin/setting/getStatesForOthers/"
			headers = {
			'Authorization': 'Token '+str(settings.ADMIN_ACCESS_KEY)+'',
			}
			r = requests.request("POST", url, headers=headers)
			print(r)
			r=r.json()
			allStatesData=[]
			for st in r['data']:
				allStatesData.append({'stateName':st['state'],
								  'stateFullAddress':st['fulladdress'],
								  'minimumAge':st['minimumage']})
			print(allStatesData)
			response['stateData']=r['data']
			url2 = str(settings.COMPANY_ACCESS_URL)+"company/backend/getCompanies/"
			headers2 = {
			'Authorization': 'Token '+str(settings.COMPANY_ACCESS_KEY)+'',
			}
			r2 = requests.request("POST", url2, headers=headers2)
			r2=r2.json()
			allCompanyData=[]
			for c in r2['data']:
				driverCountOfthisCompany=driver.objects.filter(companyId = c['userUniqueID']).count()
				if int(driverCountOfthisCompany)<int(c['driverLimit']):
					allCompanyData.append(c)

			# response['companyData']=r2['data']
			response['companyData']=allCompanyData
			response['buisnessData']=buisnessTypeData
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getCompanyList(APIView):
	def get(self, request):
		response={}
		try:
			url = str(settings.COMPANY_ACCESS_URL)+"company/backend/getCompanies/"
			headers = {
			'Authorization': 'Token '+str(settings.COMPANY_ACCESS_KEY)+'',
			}
			r = requests.request("POST", url, headers=headers)
			print(r)
			return Response(r.json())
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class checkExistence(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data = request.data

			if data.get('socialId'):
				driverObj=driver.objects.filter(socialId = data.get('socialId')).first()
				theUser=User.objects.filter(id=driverObj.userTableID)
				token = Token.objects.filter(user = theUser).first()
				if token:
					driverObj.user.auth_token.delete()
				theCustomerSerial = GetDriverData(driverObj)
				driverObj.userToken = theCustomerSerial.data['token']
				driverObj.fcmtoken = data.get('fcmtoken')
				driverObj.deviceType = data.get('deviceType')
				driverObj.save()
				response['status_code']=200
				response['status_message']='Success'
				response['data']=theCustomerSerial.data
			else:
				if not data.get('email'):
					response['status_code']=400
					response['status_message']='Email required'
					return Response(response)
				if not data.get('phone'):
					response['status_code']=400
					response['status_message']='Phone required'
					return Response(response)
				if not data.get('countrycode'):
					response['status_code']=400
					response['status_message']='Country code required'
					return Response(response)
				
				userOBj = User.objects.filter(username = data.get('email')).first()
				if userOBj:
					response['status_code']=400
					response['status_message']='Email already exists.'
					return Response(response)
				phoneExist=driver.objects.filter(phone = data.get('phone'))
				if phoneExist:
					response['status_code']=400
					response['status_message']='Phone number already exists.'
					return Response(response)
				response['status_code']=200
				response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def randomStringFunctionForImage():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(8)))
	str1 += ''.join((random.choice(string.digits) for x in range(4)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

# def uploadDocumentImages(image,thePath):
#     import os
#     fullPath='media/'+str(thePath)+'/'
#     fs = FileSystemStorage(location=fullPath)
#     beforename = os.path.splitext(image.name)[0]
#     beforename=beforename.replace(' ','')
#     filetype = os.path.splitext(image.name)[1]
#     theName=randomStringFunctionForImage()
#     theImageName=str(theName)+str(filetype)
#     filename = fs.save(theImageName, image)
#     return str(thePath)+'/'+filename

def uploadDocumentImages(image,thePath):
	import os
	import boto3
	from botocore.exceptions import NoCredentialsError
	try:
		bucket=str(settings.AWS_BUCKET_NAME)
		thePath=thePath.lower()
		ACCESS_KEY=str(settings.AWS_ACCESS_KEY_ID)
		SECRET_KEY=str(settings.AWS_SECRET_ACCESS_KEY)
		s3 = boto3.client('s3', aws_access_key_id=ACCESS_KEY,
					  aws_secret_access_key=SECRET_KEY)
		try:
			filetype = os.path.splitext(image.name)[1]
			filetype=filetype.replace('.','')
			imageName=randomStringFunctionForImage()
			thePath=thePath+'/'+imageName+'.'+filetype
			thePath=str(thePath)
			theFile=s3.upload_fileobj(image,bucket,thePath)
			print("Upload Successful")
			filename=str(settings.AWS_BUCKET_URL_1)+str(bucket)+str(settings.AWS_BUCKET_URL_2)+thePath
			return filename
		except FileNotFoundError as e:
			print("The file was not found")
			return ''
		except NoCredentialsError:
			print("Credentials not available")
			return ''
	except Exception as e:
		print(e)
		return ''

class registerDriver(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			refrence=''
			data = request.data
			print("first")
			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)
			if not data.get('name'):
				response['status_code']=400
				response['status_message']='Name required'
				return Response(response)
			if not data.get('phone'):
				response['status_code']=400
				response['status_message']='Phone required'
				return Response(response)
			if not data.get('countrycode'):
				response['status_code']=400
				response['status_message']='Country code required'
				return Response(response)
			if not data.get('password'):
				response['status_code']=400
				response['status_message']='Password required'
				return Response(response)
			if not data.get('state'):
				response['status_code']=400
				response['status_message']='State required'
				return Response(response)
			if not data.get('age'):
				response['status_code']=400
				response['status_message']='Age required'
				return Response(response)
			print("secons")
			if not data.get('dob'):
				response['status_code']=400
				response['status_message']='D.O.B required'
				return Response(response)

			if not data.get('driverType'):
				response['status_code']=400
				response['status_message']='Driver type required Company or Admin'
				return Response(response)
			else:
				if data.get('driverType')=='Company':
					if not data.get('companyId'):
						response['status_code']=400
						response['status_message']='Company id required'
						return Response(response)

			if not request.FILES.get('passportImage'):
				response['status_code']=400
				response['status_message']='Passport image required'
				return Response(response)
			if not request.FILES.get('licenceImage'):
				response['status_code']=400
				response['status_message']='Licence image required'
				return Response(response)
			if not request.FILES.get('nationalID'):
				response['status_code']=400
				response['status_message']='National id required'
				return Response(response)
			if not request.FILES.get('ageProof'):
				response['status_code']=400
				response['status_message']='Age proof required'
				return Response(response)
			
			print("third")

			if data.get('referalByCode'):
				refrence=data.get('referalByCode')
				checkRefrence=driver.objects.filter(userReferalCode=data.get('referalByCode'))
				if not checkRefrence:
					response['status_code']=400
					response['status_message']='Not a valid referral Code'
					return Response(response)
			userOBj = User.objects.filter(username = data.get('email')).first()
			if userOBj:
				response['status_code']=400
				response['status_message']='Email already exists.'
				return Response(response)
			phoneExist=driver.objects.filter(phone = data.get('phone'))
			if phoneExist:
				response['status_code']=400
				response['status_message']='Phone number already exists.'
				return Response(response)
			else:
				userOBj = User.objects.create_user(username = data.get('email'), password = data.get('password'))
				otp=GernateOTP()
				userObjId=userOBj.id
				# theUniqueID=randomStringFunction()


				beforeNameOfUser=data.get('name')
				beforeNameOfUser=beforeNameOfUser.replace(' ','')
				name3Letter=beforeNameOfUser[0:3]
				name3Letter=name3Letter.upper()
				latExt=driver.objects.all().last()
				if latExt:
					lastId=latExt.userUniqueID
					last5Number=lastId[3:]
					last5Number=int(last5Number)
					new5Number=last5Number+1
					new5Number=str(new5Number)
					new5Number = new5Number.zfill(5)
					theUniqueID=str(name3Letter)+str(new5Number)
				else:
					theUniqueID=str(name3Letter)+str('00001')

				print("before customer")

				driverObj = driver.objects.create(state=data.get('state'),age=data.get('age'),userUniqueID=theUniqueID,userTableID=userObjId, name = data.get('name'), email = data.get('email'), countrycode = data.get('countrycode'), phone = data.get('phone'), signupOtp = otp,registerType='Normal',userReferalCode=referralCode(),referalByCode=refrence,driverType=data.get('driverType'))
				if data.get('driverType')=='Company':
					driverObj.companyId=data.get('companyId')
					driverObj.save()
				try:
					dat=data.get('dob')
					dateOfBirth=datetime.strptime(dat, "%Y/%m/%d").date()
					if driverObj:
						driverObj.dob=dateOfBirth
						driverObj.save()
				except Exception as e:
					print(e)
				
			print("fourth")
			passportImage=request.FILES.get('passportImage')
			if passportImage:
				filename=uploadDocumentImages(passportImage,'Documents')
				ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='1')
			licenceImage=request.FILES.get('licenceImage')
			if licenceImage:
				filename=uploadDocumentImages(licenceImage,'Documents')
				ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='2')
			nationalID=request.FILES.get('nationalID')
			if nationalID:
				filename=uploadDocumentImages(nationalID,'Documents')
				ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='3')
			registrationProof=request.FILES.get('ageProof')
			if registrationProof:
				filename=uploadDocumentImages(registrationProof,'Documents')
				ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='4')
			theDocuments = request.FILES.getlist("documents")
			if theDocuments:
				for count, image in enumerate(theDocuments):
					filename=uploadDocumentImages(image,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='5')
			try:
				theList=[]
				theList.append(data.get('email'))
				message='<p>Hello '+str(driverObj.name)+', here is your forgot password:-'+str(otp)+' </p>'
				# sendCustomMail(theList,message)

				subject='Signup OTP'
				message = render_to_string('sendDriverSignupOTPMail.html', {
					'otp': otp,
					})
				fromEmail = settings.EMAIL_HOST_USER
				toEmail = data.get('email')
				message = EmailMessage(subject, message, fromEmail, [toEmail])
				message.content_subtype = 'html'
				message.send()
			except Exception as e:
				print(e)
			response['status_code']=200
			response['otp']=otp
			response['status_message']='OTP has been sent on you registered email successfully.'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class veifySignupOTP(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		data=request.data
		try:
			if not data.get('otp'):
				response['status_code']=400
				response['status_message']='OTP required'
				return Response(response)
			if not data.get('email'):
				if not data.get('phone'):
					response['status_code']=400
					response['status_message']='Email or Phone required.'
					return Response(response)
				else:
					if not data.get('countrycode'):
						response['status_code']=400
						response['status_message']='Country code required'
						return Response(response)
					driverVerify = driver.objects.filter(phone = data.get('phone'), signupOtpVerfied = False,accountverified=False,countrycode=data.get('countrycode'),signupOtp=data.get('otp')).first()
			else:
				driverVerify = driver.objects.filter(email = data.get('email'), signupOtpVerfied = False,accountverified=False,signupOtp=data.get('otp')).first()
			if not driverVerify:
				response['status_code']=400
				response['status_message']='OTP not matched.'
			else:
				driverVerify.signupOtpVerfied=True
				driverVerify.accountverified=True
				driverVerify.phoneverified=True
				driverVerify.save()
				theCustomerSerial = GetDriverData(driverVerify)
				response['status_code']=200
				response['status_message']='Success.'
				response['data']=theCustomerSerial.data
				try:
					subject='Welcome'
					message = render_to_string('sendDriverWelcomeMail.html', {
						'nothing': 'nothing',
						})
					fromEmail = settings.EMAIL_HOST_USER
					toEmail = data.get('email')
					message = EmailMessage(subject, message, fromEmail, [toEmail])
					message.content_subtype = 'html'
					message.send()
				except Exception as e:
					print(e)
				
				adminBodySend='New driver '+str(driverVerify.name)+ ' has been register'
				adminTypeSend='push'
				adminTitleSend='New Driver'
				adminUserID=driverVerify.userUniqueID
				notifyAdmin(adminBodySend,adminTypeSend,'new_driver',adminTitleSend,adminUserID)

		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def notifyAdmin(body,ntype,notifyCheckType,title,theUserID):
	import requests
	url=str(settings.ADMIN_ACCESS_URL)+'superadmin/auth/adminNotify/'
	# url = "http://18.117.53.164:8001/superadmin/auth/adminNotify/"
	payload={'body':str(body),
	'title':str(title),
	'userID':str(theUserID),
	'notifyCheckType':notifyCheckType,
	'userType':'Driver',
	'type':str(ntype)}
	response = requests.request("POST", url ,data=payload)
	print(response.text)

class loginDriver(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)

			if not data.get('password'):
				response['status_code']=400
				response['status_message']='Password required'
				return Response(response)

			if not data.get('fcmtoken'):
				response['status_code']=400
				response['status_message']='FCM token required'
				return Response(response)

			if not data.get('deviceType'):
				response['status_code']=400
				response['status_message']='Device type required'
				return Response(response)

			user = authenticate(username = data.get('email'), password = data.get('password'))
			if not user:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			driverObj=driver.objects.filter(userTableID=user.id).first()
			print(driverObj)
			if not driverObj:
				response['isDisable']=False
				response['isPhoneVerified']=True
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			if driverObj.signupOtpVerfied == False and driverObj.accountverified==False:
				otp=GernateOTP()
				response['isDisable']=False
				driverObj.signupOtp=otp
				driverObj.phoneVerifiedOtp=otp
				driverObj.save()
				theCustomerSerial = GetDriverData(driverObj)
				response['data']=theCustomerSerial.data
				response['status_code']=200
				response['status_message']='Please verify your account First.'
				response['isPhoneVerified']=False
				try:
					theList=[]
					theList.append(data.get('email'))
					message='<p>Hello '+str(driverObj.name)+', here is your otp:-'+str(otp)+' </p>'
					# sendCustomMail(theList,message)
					subject='Verification'
					message = render_to_string('sendDriverSignupOTPMail.html', {
						'otp': otp,
						})
					fromEmail = settings.EMAIL_HOST_USER
					toEmail = data.get('email')
					message = EmailMessage(subject, message, fromEmail, [toEmail])
					message.content_subtype = 'html'
					message.send()
				except Exception as e:
					print(e)
				return Response(response)
			if driverObj.isdisabled:
				response['driverID']=driverObj.userUniqueID
				response['isDisable']=True
				response['status_code']=400
				response['isPhoneVerified']=True
				response['status_message']='Your account has not been activated, Please contact to admin.'
				return Response(response)
			print(driverObj)
			theCustomerSerial = GetDriverData(driverObj)
			print(theCustomerSerial.data)
			print(theCustomerSerial.data['token'])
			driverObj.userToken = theCustomerSerial.data['token']
			driverObj.fcmtoken = data.get('fcmtoken')
			driverObj.deviceType = data.get('deviceType')
			driverObj.save()
			response['isDisable']=False
			response['isPhoneVerified']=True
			response['status_code']=200
			response['status_message']='Success'
			response['data']=theCustomerSerial.data
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class forgotPassword(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('email'):
				if not data.get('phone'):
					response['status_code']=400
					response['status_message']='Email or Phone required.'
					return Response(response)
				else:
					if not data.get('countrycode'):
						response['status_code']=400
						response['status_message']='Country code required'
						return Response(response)
					driverObj = driver.objects.filter(phone = data.get('phone'),countrycode=data.get('countrycode')).first()
			else:
				driverObj = driver.objects.filter(email = data.get('email')).first()
				
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver not exist.'
			else:
				OTP=GernateOTP()
				driverObj.forgotPasswordOTP=OTP
				driverObj.save()
				response['status_code']=200
				response['status_message']='OTP has been sent on you registered email successfully.'
				response['OTP']=OTP
			try:
				theList=[]
				theList.append(data.get('email'))
				message='<p>Hello '+str(driverObj.name)+', here is your forgot password:-'+str(OTP)+' </p>'
				# sendCustomMail(theList,message)

				subject='Forgot Password'
				message = render_to_string('driverForgotPassword.html', {
					'name': driverObj.name,
					'otp': OTP,
					})
				fromEmail = settings.EMAIL_HOST_USER
				toEmail = data.get('email')
				message = EmailMessage(subject, message, fromEmail, [toEmail])
				message.content_subtype = 'html'
				message.send()
			except Exception as e:
				print(e)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class forgotPasswordVerifyOtp(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('otp'):
				response['status_code']=400
				response['status_message']='OTP required'
				return Response(response)
			if not data.get('email'):
				if not data.get('phone'):
					response['status_code']=400
					response['status_message']='Email or Phone required.'
					return Response(response)
				else:
					if not data.get('countrycode'):
						response['status_code']=400
						response['status_message']='Country code required'
						return Response(response)
					driverObj = driver.objects.filter(phone = data.get('phone'),countrycode=data.get('countrycode'),forgotPasswordOTP=data.get('otp')).first()
			else:
				driverObj = driver.objects.filter(email = data.get('email'),forgotPasswordOTP=data.get('otp')).first()
				
			response['status_code']=200
			response['status_message']='OTP verified.'
			if not driverObj:
				response['status_code']=400
				response['status_message']='Verification Failed, OTP not matched.'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updatePassword(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('otp'):
				response['status_code']=400
				response['status_message']='OTP required.'
				return Response(response)
			if not data.get('password'):
				response['status_code']=400
				response['status_message']='Password required.'
				return Response(response)
			if not data.get('email'):
				if not data.get('phone'):
					response['status_code']=400
					response['status_message']='Email or Phone required.'
					return Response(response)
				else:
					if not data.get('countrycode'):
						response['status_code']=400
						response['status_message']='Country code required'
						return Response(response)
					driverObj = driver.objects.filter(phone = data.get('phone'),countrycode=data.get('countrycode'),forgotPasswordOTP=data.get('otp')).first()
			else:
				driverObj = driver.objects.filter(email = data.get('email'),forgotPasswordOTP=data.get('otp')).first()
				
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver Not Exist'
				return Response(response)
			user=User.objects.filter(id=driverObj.userTableID).first()
			
			if not user:
				response['status_code']=400
				response['status_message']='User Not Exist'

			user.set_password(data.get('password'))
			user.save()
			response['status_code']=200
			response['status_message']='Password Update Successfully'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class ChangePassword(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			tokenObj = Token.objects.filter(key = session_token).first()
			if not tokenObj:
				response['status_code']=400
				response['status_message']='Invalid Session Token'
				return Response(response)
			if not data.get('newPassword'):
				response['status_code']=400
				response['status_message']='New Password required.'
				return Response(response)
			if not data.get('oldPassword'):
				response['status_code']=400
				response['status_message']='Old Password required.'
				return Response(response)
			userObj = User.objects.get(id = tokenObj.user_id)
			response['status_code']=400
			response['status_message']='Current password is incorrect'
			if userObj.check_password(data.get('oldPassword')):
				userObj.password = make_password(data.get('newPassword'))
				userObj.save()
				response['status_code']=200
				response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class resendSignupOTP(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)
			driverObj = driver.objects.filter(email = data.get('email')).first()
			
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver not exist.'
				return Response(response)
			otp=GernateOTP()
			driverObj.signupOtp=otp
			driverObj.phoneVerifiedOtp=otp
			driverObj.save()
			response['status_code']=200
			response['status_message']='OTP has been sent on you registered email successfully'
			response['otp']=otp
			try:
				theList=[]
				theList.append(data.get('email'))
				message='<p>Hello '+str(driverObj.name)+', here is your otp:-'+str(otp)+' </p>'
				# sendCustomMail(theList,message)
				subject='Signup OTP'
				message = render_to_string('sendDriverSignupOTPMail.html', {
					'otp': otp,
					})
				fromEmail = settings.EMAIL_HOST_USER
				toEmail = data.get('email')
				message = EmailMessage(subject, message, fromEmail, [toEmail])
				message.content_subtype = 'html'
				message.send()
			except Exception as e:
				print(e)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class verifPhoneWithOTP(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			
			data=request.data
			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)
			if not data.get('otp'):
				response['status_code']=400
				response['status_message']='OTP required'
				return Response(response)

			if not data.get('fcmtoken'):
				response['status_code']=400
				response['status_message']='FCM token required'
				return Response(response)
			if not data.get('deviceType'):
				response['status_code']=400
				response['status_message']='Device type required'
				return Response(response)


			driverObj = driver.objects.filter(email = data.get('email'),phoneVerifiedOtp=data.get('otp')).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Verification Failed, OTP not matched'
				return Response(response)

			driverObj.phoneverified=True
			driverObj.signupOtpVerfied=True
			driverObj.accountverified=True
			theCustomerSerial = GetDriverData(driverObj)
			driverObj.userToken = theCustomerSerial.data['token']
			driverObj.fcmtoken = data.get('fcmtoken')
			driverObj.deviceType = data.get('deviceType')
			driverObj.save()
			response['status_code']=200
			response['status_message']='Success'
			response['data']=theCustomerSerial.data
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class socialLogin(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)
			if not data.get('socialId'):
				response['status_code']=400
				response['status_message']='Social id required'
				return Response(response)
			if not data.get('deviceType'):
				response['status_code']=400
				response['status_message']='Device type required'
				return Response(response)
			if not data.get('fcmtoken'):
				response['status_code']=400
				response['status_message']='FCM token required'
				return Response(response)
			if not data.get('registerType'):
				response['status_code']=400
				response['status_message']='Register type required'
				return Response(response)
			if not request.FILES.get('passportImage'):
				response['status_code']=400
				response['status_message']='Passport image required'
				return Response(response)
			if not request.FILES.get('licenceImage'):
				response['status_code']=400
				response['status_message']='Licence image required'
				return Response(response)
			if not request.FILES.get('nationalID'):
				response['status_code']=400
				response['status_message']='National id required'
				return Response(response)
			if not request.FILES.get('ageProof'):
				response['status_code']=400
				response['status_message']='Age proof required'
				return Response(response)
			userOBJ = User.objects.filter(username = data.get('email')).first()
			if userOBJ:
				response['status_code']=400
				response['status_message']='Email already exists.'
			else:
				digits = "zm1Sc3gK71C9laHpq"
				passCode = ""
				for i in range(15) :
					passCode += digits[math.floor(random.random() * 10)]

				

				userObj = User.objects.create_user(username = data.get('email'), email = data.get('email'), password = passCode)
				
				userObjId=userOBj.id
				beforeNameOfUser=data.get('name')
				name3Letter=beforeNameOfUser[0:3]
				name3Letter=name3Letter.upper()
				latExt=driver.objects.all().last()
				if latExt:
					lastId=latExt.userUniqueID
					last5Number=lastId[3:]
					last5Number=int(last5Number)
					new5Number=last5Number+1
					new5Number=str(new5Number)
					new5Number = new5Number.zfill(5)
					theUniqueID=str(name3Letter)+str(new5Number)
				else:
					theUniqueID=str(name3Letter)+str('00001')


				driverObj = driver.objects.create(userUniqueID=theUniqueID,userTableID = userObjId, name = data.get('name'), email = data.get('email'),socialId=data.get('socialId'),deviceType=data.get('deviceType'),registerType=data.get('registerType'),fcmtoken=data.get('fcmtoken'),signupOtpVerfied=True,accountverified=True,emailverified=True)
				token = Token.objects.filter(user = userObj).first()
				if token:
					userObj.auth_token.delete()
				passportImage=request.FILES.get('passportImage')
				if passportImage:
					filename=uploadDocumentImages(passportImage,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='1')
				licenceImage=request.FILES.get('licenceImage')
				if licenceImage:
					filename=uploadDocumentImages(licenceImage,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='2')
				nationalID=request.FILES.get('nationalID')
				if nationalID:
					filename=uploadDocumentImages(nationalID,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='3')
				registrationProof=request.FILES.get('ageProof')
				if registrationProof:
					filename=uploadDocumentImages(registrationProof,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='4')
				theDocuments = request.FILES.getlist("documents")
				if theDocuments:
					for count, image in enumerate(theDocuments):
						filename=uploadDocumentImages(image,'Documents')
						ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='5')
				theCustomerSerial = GetDriverData(driverObj)
				response['status_code']=200
				response['status_message']='Success'
				response['data']=theCustomerSerial.data
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def validateToken(theToken):
	returnId='0'
	tokenOBJ = Token.objects.filter(key = theToken).first()
	if tokenOBJ:
		user = User.objects.get(id = tokenOBJ.user_id)
	if user:
		returnId=user.id
	return returnId

class getProfile(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")

			driverObj = driver.objects.filter(userToken=session_token).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver Not Exist'
				return Response(response)
			theCustomerSerial = GetDriverData(driverObj)
			print("Before states ===================================")
			statesData=getStateListFunction()
			print("after states ===================================")
			# print("statesData",statesData)
			# print("statesDataType",type(statesData))
			# statesData=statesData.json()
			# print("statesData",statesData)
			if statesData['status_code']==200:
				response['states']=statesData['data']
			response['status_code']=200
			response['status_message']='User profile Data'
			response['data']=theCustomerSerial.data
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updateProfile(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")

			driverObj = driver.objects.filter(userToken = session_token).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver not exist'
				return Response(response)
			image=request.FILES.get('image')
			print("my image=============>",image)
			filename=''
			if data.get('name'):
				driverObj.name=data.get('name')
			if data.get('state'):
				driverObj.state=data.get('state')
			if data.get('age'):
				driverObj.age=data.get('age')
			if data.get('dob'):
				try:
					dat=data.get('dob')
					dateOfBirth=datetime.strptime(dat, "%Y/%m/%d").date()
					if driverObj:
						driverObj.dob=dateOfBirth
						driverObj.save()
				except Exception as e:
					print(e)
			if image:
				print("before saving")
				filename=uploadDocumentImages(image,'Profile')
				print("after saving")
				driverObj.image=filename
			if data.get('countrycode'):
				driverObj.countrycode=data.get('countrycode')
			if data.get('phone'):
				driverObj.phone=data.get('phone')
			driverObj.save()
			theCustomerSerial = GetDriverData(driverObj)
			response['status_code']=200
			response['status_message']='Success'
			response['data']=theCustomerSerial.data
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class logout(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			tokenOBJ = Token.objects.filter(key = session_token).first()
			if not tokenOBJ:
				response['status_code']=400
				response['status_message']='Invalid Session Token'
			userOBJ = User.objects.get(id = tokenOBJ.user_id)
			driverObj = driver.objects.filter(userTableID = userOBJ.id).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Not a valid Driver'
			else:
				driverObj.userToken=''
				driverObj.fcmtoken=''
				driverObj.save()
				userOBJ.auth_token.delete()
				response['status_code']=200
				response['status_message']='Driver Logout Successfully'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class getDocuments(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			driverObj = driver.objects.filter(userToken = session_token).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Customer not exist'
				return Response(response)
			allDocs=driverdocuments.objects.filter(userUniqueID=driverObj.userUniqueID)
			allData=[]
			if allDocs:
				for doc in allDocs:
					theName=str(doc.document)
					theDocType=''
					if doc.doctType=='1':
						imageIDKey='passportImageID'
						imageKey='passportImage'
						theDocType='Passport'
					elif doc.doctType=='2':
						imageIDKey='licenceImageID'
						imageKey='licenceImage'
						theDocType='Licence'
					elif doc.doctType=='3':
						imageIDKey='nationalProofID'
						imageKey='nationalID'
						theDocType='National ID'
					elif doc.doctType=='4':
						imageIDKey='ageProofID'
						imageKey='ageProof'
						theDocType='Age Proof'
					else:
						theDocType='Others'
						imageIDKey=''
						imageKey=''
					allData.append({'id':doc.id,
									'document':theName,
									'name':theDocType,
									'imageKey':imageKey,
									'imageIDKey':imageIDKey,
									'status':doc.theStatus,})
				response['status_code']=200
				response['status_message']='Success'
				response['data']=allData
			else:
				response['status_code']=400
				response['status_message']='No data found'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

# class getDocuments(APIView):
# 	def post(self, request, *args, **kwargs):
# 		response={}
# 		try:
# 			allData=[]
# 			data=request.data
# 			session_token = request.META.get('HTTP_AUTHORIZATION')
			
# 			if not session_token:
# 				response['status_code']=401
# 				response['status_message']='Session token required'
# 				return Response(response,status=response['status_code'])
# 			session_token = session_token.replace("Token ", "")
# 			customerObj = driver.objects.filter(userToken = session_token).first()
# 			if not customerObj:
# 				response['status_code']=400
# 				response['status_message']='Driver not exist'
# 				return Response(response)
# 			allDocs=driverdocuments.objects.filter(userUniqueID=customerObj.userUniqueID)
# 			if allDocs:
# 				for doc in allDocs:
# 					theName=str(doc.document)
# 					theDocType=''
# 					imageIDKey=''
# 					imageKey=''
# 					if doc.doctType=='1':
# 						imageIDKey='passportImageID'
# 						imageKey='passportImage'
# 						theDocType='Passport'
# 					elif doc.doctType=='2':
# 						theDocType='Licence'
# 						imageIDKey='licenceImageID'
# 						imageKey='licenceImage'
# 					elif doc.doctType=='3':
# 						theDocType='National ID'
# 						imageIDKey='nationalProofID'
# 						imageKey='nationalID'
# 					elif doc.doctType=='4':
# 						theDocType='Age Proof'
# 						imageIDKey='ageProofID'
# 						imageKey='ageProof'
# 					else:
# 						theDocType='Others'
# 						imageIDKey=''
# 						imageKey=''
# 					allData.append({'id':doc.id,
# 									'document':theName,
# 									'name':theDocType,
# 									'imageKey':imageKey,
# 									'imageIDKey':imageIDKey,
# 									'status':doc.theStatus,})
# 				response['status_code']=200
# 				response['status_message']='Success'
# 				response['data']=allData
# 			else:
# 				response['status_code']=400
# 				response['status_message']='No data found'
# 		except Exception as e:
# 			response['status_code']=500
# 			response['status_message']=str(e)
# 		return Response(response)

class updateDocuments(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			print("data======================",data)
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			tokenObj = Token.objects.filter(key = session_token).first()
			if not tokenObj:
				response['status_code']=400
				response['status_message']='Invalid Session Token'
				return Response(response)
			userOBJ = User.objects.get(id = tokenObj.user_id)
			driverObj = driver.objects.filter(userTableID = userOBJ.id).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver not exist'
				return Response(response)
			userObjId=driverObj.userTableID
			theUniqueID=driverObj.userUniqueID
			passportImage=request.FILES.get('passportImage')
			if passportImage:
				passportImageID=data.get('passportImageID')
				if passportImageID == '0':
					filename=uploadDocumentImages(passportImage,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='1')
				else:
					filename=uploadDocumentImages(passportImage,'Documents')
					ownerDocs=driverdocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=passportImageID,doctType='1').first()
					ownerDocs.document=filename
					ownerDocs.theStatus='1'
					ownerDocs.save()
			licenceImage=request.FILES.get('licenceImage')
			if licenceImage:
				licenceImageID=data.get('licenceImageID')
				if licenceImageID == '0':
					filename=uploadDocumentImages(licenceImage,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='2')
				else:
					filename=uploadDocumentImages(licenceImage,'Documents')
					ownerDocs=driverdocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=licenceImageID,doctType='2').first()
					ownerDocs.document=filename
					ownerDocs.theStatus='1'
					ownerDocs.save()
			nationalID=request.FILES.get('nationalID')
			if nationalID:
				print(" i am in m")
				nationalProofID=data.get('nationalProofID')
				if nationalProofID == '0':
					filename=uploadDocumentImages(nationalID,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='3')
				else:
					filename=uploadDocumentImages(nationalID,'Documents')
					ownerDocs=driverdocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=nationalProofID,doctType='3').first()
					ownerDocs.document=filename
					ownerDocs.theStatus='1'
					ownerDocs.save()
			registrationProof=request.FILES.get('ageProof')
			if registrationProof:
				registrationProofID=data.get('ageProofID')
				if registrationProofID == '0':
					filename=uploadDocumentImages(registrationProof,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='4')
				else:
					filename=uploadDocumentImages(registrationProof,'Documents')
					ownerDocs=driverdocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=registrationProofID,doctType='4').first()
					ownerDocs.document=filename
					ownerDocs.theStatus='1'
					ownerDocs.save()

			theIDS = request.POST.getlist("ids")
			theDocuments = request.FILES.getlist("documents")
			for count, image in enumerate(theDocuments):
				if theIDS[count] == '0':
					filename=uploadDocumentImages(image,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userID,userUniqueID=compObjects.userUniqueID,document=filename,doctType='5')
				else:
					alreadyDoc=driverdocuments.objects.filter(userTableID=userID,id=theIDS[count]).first()
					if alreadyDoc:
						filename=uploadDocumentImages(image,'Documents')
						alreadyDoc.document=filename
						alreadyDoc.save()
			
			adminBodySend=str(driverObj.name)+ ' has been updated there documents'
			adminTypeSend='push'
			adminTitleSend='Documents Updated'
			adminUserID=driverObj.userUniqueID
			notifyAdmin(adminBodySend,adminTypeSend,'document_updated',adminTitleSend,adminUserID)
			response['status_code']=200
			response['status_message']='Documents Updated Successfully'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getNearbyDrivers(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)

			if data.get('AccessKey')!=(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			# allDrivers=Driver.objects.all()
			
			if not data.get('latitude'):
				response['status_code']=400
				response['status_message']='latitude required'
				return Response(response)

			if not data.get('longitude'):
				response['status_code']=400
				response['status_message']='longitude required'
				return Response(response)

			lat=data.get('latitude')
			lng=data.get('longitude')
			distanceInMiles=32
			query = "SELECT * FROM (SELECT id, name, phone, (3959 * acos(cos(radians("+str(lat)+")) * cos(radians(currentlatitude)) * cos(radians(currentlongitude) - radians("+str(lng)+")) + sin(radians("+str(lat)+")) * sin(radians(currentlatitude)))) AS distance FROM base_driver) AS distances WHERE distance < "+str(distanceInMiles)+" ORDER BY distance OFFSET 0 LIMIT 20;"
			# if allDrivers:
				# theDriverSerial=GetDriverData(allDrivers,many=True)
				# response['data']=theDriverSerial.data
			# else:
				# response['data']=[]
			allDrivers = driver.objects.raw(query)
			if allDrivers:
				allStoreListData=[i for i in allDrivers if i.isactive==True and i.isbooked==False and i.isdisabled==False]
				print("allStoreListData================================================",allStoreListData)
				# allDrivers=allDrivers.filter(isactive=True,isbooked=False)
				theDriverSerial=GetDriverData(allStoreListData,many=True)
				response['data']=theDriverSerial.data
			else:
				response['data']=[]
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class notificationSoundStatus(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			tokenObj = Token.objects.filter(key = session_token).first()
			if not tokenObj:
				response['status_code']=400
				response['status_message']='Invalid Session Token'
				return Response(response)
			userOBJ = User.objects.get(id = tokenObj.user_id)
			driverObj = driver.objects.filter(userTableID = userOBJ.id).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver not exist'
				return Response(response)
			
			if not data.get('isNotificationSoundOn'):
				response['status_code']=401
				response['status_message']='isNotificationSoundOn required'
				return Response(response)
			
			if data.get('isNotificationSoundOn')=='True':
				driverObj.isNotificationSoundOn=True
			else:
				driverObj.isNotificationSoundOn=False
			driverObj.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class notificationStatus(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			tokenObj = Token.objects.filter(key = session_token).first()
			if not tokenObj:
				response['status_code']=400
				response['status_message']='Invalid Session Token'
				return Response(response)
			userOBJ = User.objects.get(id = tokenObj.user_id)
			driverObj = driver.objects.filter(userTableID = userOBJ.id).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver not exist'
				return Response(response)
			
			if not data.get('isNotificationOn'):
				response['status_code']=401
				response['status_message']='isNotificationOn required'
				return Response(response)
			
			if data.get('isNotificationOn')=='True':
				driverObj.isNotificationOn=True
			else:
				driverObj.isNotificationOn=False
			driverObj.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class countDriversForLimitCheck(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)

			if data.get('AccessKey')!=(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			
			if not data.get('companyID'):
				response['status_code']=400
				response['status_message']='companyID required'
				return Response(response)

			theDriversCount=driver.objects.filter(companyId=data.get('companyID')).count()
			response['totalDrivers']=theDriversCount
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class onlineOfflineStatus(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")

			driverObj = driver.objects.filter(userToken=session_token).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver Not Exist'
				return Response(response)
			if data.get('status')=='True':
				driverObj.isactive=True
			else:
				driverObj.isactive=False
			driverObj.save()
			# theCustomerSerial = GetDriverData(driverObj)
			response['status_code']=200
			response['status_message']='Status updated'
			# response['data']=theCustomerSerial.data
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)
	

class getSettings(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData={}
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			# customerObj = Customer.objects.filter(userToken=session_token).first()
			# if not customerObj:
			#     response['status_code']=400
			#     response['status_message']='Customer Not Exist'
			#     return Response(response)
			
			driverObj = driver.objects.filter(userToken=session_token).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver Not Exist'
				return Response(response)
			allData["helpEmail"]="contact@cannabis.com"
			allData["helpCountryCode"]="+1"
			allData["helpNumber"]="0102453252"

			allData["currencySymbol"]="$"
			allData["currencyCode"]="USD"
			allData["isNotificationSoundOn"]=driverObj.isNotificationSoundOn
			allData["isNotificationOn"]=driverObj.isNotificationOn
			allData["isactive"]=driverObj.isactive
			response['status_code']=200
			response['status_message']='Driver profile Data'
			response['data']=allData
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class deactivateAccount(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData={}
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			driverOBJ = driver.objects.filter(userToken=session_token).first()
			if not driverOBJ:
				response['status_code']=400
				response['status_message']='Driver Not Exist'
				return Response(response)
			driverOBJ.isdisabled=True
			driverOBJ.save()
			response['status_code']=200
			response['status_message']='Account deactivated successfully'
			response['data']=allData
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class requestAdmin(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData={}
			data=request.data
			allData={}
			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='driverID required'
				return Response(response)
			customerObj = driver.objects.filter(userUniqueID=data.get('driverID')).first()
			if not customerObj:
				response['status_code']=400
				response['status_message']='Driver Not Exist'
				return Response(response)
			customerObj.isRequested=True
			customerObj.save()
			response['status_code']=200
			response['status_message']='Request send'
			response['data']=allData
			adminBodySend=str(customerObj.name)+ ' has been requested to activate there account.'
			adminTypeSend='push'
			adminTitleSend='Activate Request'
			adminUserID=customerObj.userUniqueID
			notifyAdmin(adminBodySend,adminTypeSend,'activate_request',adminTitleSend,adminUserID)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getNotifications(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			driverObj = driver.objects.filter(userToken=session_token).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver Not Exist'
				return Response(response)
			if not data.get('page'):
				response['status_code']=400
				response['status_message']='page required'
				return Response(response)
			allNotifications=notifications.objects.filter(driverID=driverObj.userUniqueID).order_by('-id')
			import humanize
			import datetime as dt

			pageNo=data.get('page')
			pageNo=int(pageNo)
			startPage=0
			endPage=int(settings.PAGE_LIMIT)
			for r in range(1,pageNo):
				startPage=startPage+int(settings.PAGE_LIMIT)
				endPage=endPage+int(settings.PAGE_LIMIT)
			totalRecords=len(allNotifications)
			previousRecords=len(allNotifications[:startPage])
			nextRecords=len(allNotifications[endPage:])
			if previousRecords==0:
				hasPreviousPage=False
			else:
				hasPreviousPage=True
			if nextRecords==0:
				hasNextPage=False
			else:
				hasNextPage=True
			response['hasNextPage']=hasNextPage
			response['hasPreviousPage']=hasPreviousPage
			allNotifications=allNotifications[startPage:endPage]
			# print(humanize.naturalday(dt.datetime.now()))
			alldata=[]
			for n in allNotifications:
				theAgoDate=humanize.naturalday(n.created_at)
				alldata.append({'notificationID':n.id,
								'title':n.title,
								'description':n.description,
								'date':theAgoDate,
								'image':n.image,})
			response['status_code']=200
			response['status_message']='Notification data'
			
			response['data']=alldata
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		print(response)
		return Response(response)

class deleteNotification(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		data=request.data
		try:
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			driverObj = driver.objects.filter(userToken=session_token).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver Not Exist'
				return Response(response)
			if not data.get('notificationID'):
				response['status_code']=400
				response['status_message']='notificationID required'
				return Response(response)
			allNotifications=notifications.objects.filter(id=data.get('notificationID'),driverID=driverObj.userUniqueID).first()
			if allNotifications:
				allNotifications.delete()
				response['status_code']=200
				response['status_message']='Notification delete'
			else:
				response['status_code']=400
				response['status_message']='Invalid id'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		print(response)
		return Response(response)

def gernateChatTokenTwilio(identity):
	import twilio
	from twilio.jwt.access_token import AccessToken
	from twilio.jwt.access_token.grants import ChatGrant
	account_sid = str(settings.TWILIO_ACCOUNT_SID)
	api_key = str(settings.TWILIO_API_KEY)
	api_secret = str(settings.TWILIO_API_SECRET)

	# required for Chat grants
	service_sid = str(settings.TWILIO_SERVICE_SID)
	# identity = 'user@example.com'

	# Create access token with credentials
	token = AccessToken(account_sid, api_key, api_secret, identity=identity)

	# Create an Chat grant and add to token
	chat_grant = ChatGrant(service_sid=service_sid)
	token.add_grant(chat_grant)

	# Return token info as JSON
	print(token.to_jwt())
	returnToken=token.to_jwt()

	return returnToken

class gernateTwilioToken(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		data=request.data
		try:
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			customerObj = driver.objects.filter(userToken=session_token).first()
			if not customerObj:
				response['status_code']=400
				response['status_message']='Driver Not Exist'
				return Response(response)
			if not data.get('identity'):
				response['status_code']=400
				response['status_message']='identity required'
				return Response(response)
			twilioToken=gernateChatTokenTwilio(data.get('identity'))
			# theData=GetStoreDetails(storeObj)
			response['status_code']=200
			response['status_message']='Success'
			response['twilioToken']=twilioToken
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		print(response)
		return Response(response)

def sendCommonGmail(theList,themessage):
	for email in theList:
		try:
			fromEmail = settings.EMAIL_HOST_USER
			message = EmailMessage(themessage['title'], themessage['body'], fromEmail, [email])
			message.content_subtype = 'html'
			message.send()
		except Exception as e:
			print(e)

class driverNotify(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('companyId'):
				response['status_code']=400
				response['status_message']='Company ID is required'
				return Response(response)
			if not data.get('title'):
				response['status_code']=400
				response['status_message']='title is required'
				return Response(response)
			if not data.get('body'):
				response['status_code']=400
				response['status_message']='body is required'
				return Response(response)
			if not data.get('notificationType'):
				response['status_code']=400
				response['status_message']='notificationType is required'
				return Response(response)
			driverOBJ = driver.objects.filter(companyId=data.get('companyId'))
			body=data.get('body')
			title=data.get('title')
			if data.get('notificationType')=='push':
				pass
				messageBody={}
				messageBody['body']=body
				# messageBody['icon']=image
				# messageBody['image']=image
				# messageBody['type']=notifyType
				messageBody['title']=title
				# messageBody['userType']=userType
				# messageBody['userID']=userID
				allList=[]
				for d in driverOBJ:
					if d.fcmtoken != '':
						allList.append(d.fcmtoken)
				try:
					theReturnOfPush=sendPush(allList,messageBody)
					# notifications.objects.create(userType='messageBody['userType']',userID=messageBody['userID'],image=messageBody['data']['image'],title=messageBody['title'],description=messageBody['body'])
				except Exception as e:
					print(e)
			elif data.get('notificationType')=='email':
				messageBody={}
				messageBody['body']=body
				messageBody['title']=title
				allList=[]
				for d in driverOBJ:
					if d.fcmtoken != '':
						allList.append(d.fcmtoken)
				try:
					sendCommonGmail(allList,messageBody)
				except Exception as e:
					print(e)
			else:
				pass
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class requestPayout(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")

			driverObj = driver.objects.filter(userToken=session_token).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver Not Exist'
				return Response(response)
			
			if not data.get('payoutAmount'):
				response['status_code']=400
				response['status_message']='payoutAmount is required'
				return Response(response)
			
			try:
				payload={}
				payload['AccessKey']=str(settings.ADMIN_ACCESS_KEY)
				payload['payoutUserType']="Driver"
				payload['payoutUserId']=driverObj.userUniqueID
				payload['payoutUserName']=driverObj.name
				payload['payoutUserEmail']=driverObj.email
				payload['payoutUserImage']=driverObj.image
				payload['payoutAmount']=data.get('payoutAmount')
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/auth/addPayoutRequests/"
				res = requests.request("POST",url,data=payload)
				res=res.json()
				return Response(res)
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getDocumentsStatus(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			driverObj = driver.objects.filter(userToken = session_token).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver not exist'
				return Response(response)
			allDocs=driverdocuments.objects.filter(userUniqueID=driverObj.userUniqueID,theStatus="Rejected")
			if allDocs:
				response['status_code']=200
				response['status_message']='Success'
				response['isDocumentRejected']=True
			else:
				response['status_code']=200
				response['status_message']='Success'
				response['isDocumentRejected']=False
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)