from rest_framework.views import APIView
from rest_framework.response import Response
from django.contrib.auth import login,authenticate
from .models import *
from base.models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
import datetime
from django.template.loader import render_to_string
from django.core.mail import EmailMessage
import math, random, datetime, pytz, string
from django.core.files.storage import FileSystemStorage
from django.conf import settings
from io import BytesIO
from PIL import Image
import json
import requests

class addTermsAndConditions(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)

			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)

			if not data.get('content'):
				response['status_code']=400
				response['status_message']='content required'
				return Response(response)
			
			if not data.get('title'):
				response['status_code']=400
				response['status_message']='title required'
				return Response(response)
			alreadyObject=termsandconditions.objects.all().first()
			if alreadyObject:
				alreadyObject.title=data.get('title')
				alreadyObject.content=data.get('content')
				alreadyObject.save()
			else:
				termsandconditions.objects.create(title=data.get('title'),content=data.get('content'))
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class addPrivacyPolicy(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)

			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)

			if not data.get('content'):
				response['status_code']=400
				response['status_message']='content required'
				return Response(response)
			
			if not data.get('title'):
				response['status_code']=400
				response['status_message']='title required'
				return Response(response)
			
			alreadyObject=privacypolicy.objects.all().first()
			if alreadyObject:
				alreadyObject.title=data.get('title')
				alreadyObject.content=data.get('content')
				alreadyObject.save()
			else:
				privacypolicy.objects.create(title=data.get('title'),content=data.get('content'))
			# privacyPolicy.objects.create(title=data.get('title'),content=data.get('content'))
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getTermsAndConditionsByAdmin(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)

			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			
			tacObject=termsandconditions.objects.all().first()
			if tacObject:
				response['title']=tacObject.title
				response['content']=tacObject.content
			else:
				response['title']=''
				response['content']=''
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getPrivacyPolicyByAdmin(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)

			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			
			ppObject=privacypolicy.objects.all().first()
			if ppObject:
				response['title']=ppObject.title
				response['content']=ppObject.content
			else:
				response['title']=''
				response['content']=''
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getTermsAndConditions(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])

			session_token = session_token.replace("Token ", "")
			customerObjects=driver.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			
			tacObject=termsandconditions.objects.all().first()
			if tacObject:
				response['title']=tacObject.title
				response['content']=tacObject.content
			else:
				response['title']=''
				response['content']=''
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getPrivacyPolicy(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])

			session_token = session_token.replace("Token ", "")
			customerObjects=driver.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			
			ppObject=privacypolicy.objects.all().first()
			if ppObject:
				response['title']=ppObject.title
				response['content']=ppObject.content
			else:
				response['title']=''
				response['content']=''
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class addFAQ(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if not data.get('question'):
				response['status_code']=400
				response['status_message']='question required'
				return Response(response)
			if not data.get('answer'):
				response['status_code']=400
				response['status_message']='answer required'
				return Response(response)
			faqObject=faq.objects.create(question=data.get('question'),answer=data.get('answer'))
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getFAQlist(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			allData=[]
			allFAQs=faq.objects.all()
			for f in allFAQs:
				allData.append({'question':f.question,
				                'answer':f.answer})
			response['data']=allData
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updateFAQ(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if not data.get('faqID'):
				response['status_code']=400
				response['status_message']='faqID required'
				return Response(response)
			faqObject=faq.objects.filter(id=data.get('faqID')).first()
			if not faqObject:
				response['status_code']=400
				response['status_message']='Invalid id'
				return Response(response)
			if data.get('question'):
				faqObject.question=data.get('question')
			if data.get('answer'):
				faqObject.answer=data.get('answer')
			faqObject.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class deleteFAQ(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if not data.get('faqID'):
				response['status_code']=400
				response['status_message']='faqID required'
				return Response(response)
			faqObject=faq.objects.filter(id=data.get('faqID')).first()
			if faqObject:
				faqObject.delete()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getDriverFAQ(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])

			session_token = session_token.replace("Token ", "")
			customerObjects=driver.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			
			allData=[]
			allFAQs=faq.objects.all()
			for f in allFAQs:
				allData.append({'id':f.id,
					            'question':f.question,
				                'answer':f.answer})
			response['data']=allData
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class addHelpSupport(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=401
				response['status_message']='Session token required'
				return Response(response,status=response['status_code'])

			session_token = session_token.replace("Token ", "")
			customerObjects=driver.objects.filter(userToken=session_token).first()
			if not customerObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response,status=response['status_code'])
			
			if not data.get('title'):
				response['status_code']=400
				response['status_message']='title required'
				return Response(response)
			
			if not data.get('message'):
				response['status_code']=400
				response['status_message']='message required'
				return Response(response)
			
			if not data.get('email'):
				response['status_code']=400
				response['status_message']='email required'
				return Response(response)
			
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)