from rest_framework.views import APIView
from django.contrib.auth.models import User
from django.contrib.auth import authenticate
from rest_framework.authtoken.models import Token
from base.models import *
from .models import *
from pyfcm import FCMNotification
import math, random, datetime, pytz, string
from django.conf import settings
import requests, json
from django.contrib.auth.hashers import make_password
from django.db.models import Q
from django.http import HttpResponse
from rest_framework.response import Response
from django.template.loader import render_to_string
from django.core.mail import EmailMessage
from django.core.files.storage import FileSystemStorage
from datetime import datetime

def gernateTranctionID():
	import random, string
	import datetime
	dt=datetime.datetime.now()
	print(dt)
	yr=dt.year
	mn=dt.month

	print(yr)
	print(mn)
	strDate=str(yr)
	strDate=strDate+'CB'
	strMont=str(mn)
	strMont = strMont.zfill(2)
	strDate=strDate+strMont
	strLetters = ''.join((random.choice(string.ascii_letters) for x in range(5)))
	strNumbers = ''.join((random.choice(string.digits) for x in range(3)))
	# sam_list = list(strLetters)
	# random.shuffle(sam_list)
	# finalString = strDate.join(strLetters)
	strLetters=strLetters.lower()
	finalString=strDate+strLetters+str(strNumbers)
	return finalString

class addTransaction(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			allData={}
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			driverObj = driver.objects.filter(userToken=session_token).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver Not Exist'
				return Response(response)
			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID required'
				return Response(response)
			if not data.get('customerID'):
				response['status_code']=400
				response['status_message']='customerID required'
				return Response(response)
			if not data.get('amount'):
				response['status_code']=400
				response['status_message']='amount required'
				return Response(response)
			if not data.get('name'):
				response['status_code']=400
				response['status_message']='name required'
				return Response(response)
			if not data.get('image'):
				response['status_code']=400
				response['status_message']='image required'
				return Response(response)
			if not data.get('description'):
				response['status_code']=400
				response['status_message']='description required'
				return Response(response)
			tranactionID=gernateTranctionID()    
			tranactionsObject=transcations.objects.create(earnID=tranactionID,driverID=driverObj.userUniqueID,orderID=data.get('orderID'),customerID=data.get('customerID'),amount=data.get('amount'),name=data.get('name'),image=data.get('image'),description=data.get('description'))
			walletObject=wallet.objects.filter(driverID=driverObj.userUniqueID).first()
			if not walletObject:
				walletObject=wallet.objects.create(driverID=driverObj.userUniqueID,companyId=driverObj.companyId,driverType=driverObj.driverType)
			walletObject.orderID=data.get('orderID')
			walletObject.customerID=data.get('customerID')
			oldAmount=float(walletObject.amount)
			totalAmount=float(oldAmount)+float(data.get('amount'))
			walletObject.amount=float(totalAmount)
			walletObject.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getEarningList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			allData=[]
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			driverObj = driver.objects.filter(userToken=session_token).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver Not Exist'
				return Response(response)
			allTranObject=earnings.objects.filter(driverID=driverObj.userUniqueID).order_by('-id')
			for trans in allTranObject:
				allData.append({'amount':trans.amount,
								'name':trans.name,
								'image':trans.image,
								'earnID':trans.earnID,
								'orderTime':trans.orderTime,
								'orderDate':trans.orderDate,
								'orderDropOff':trans.orderDropOff,})
			totalearnings=float('0')
			walletObject=wallet.objects.filter(driverID=driverObj.userUniqueID).first()
			if walletObject:
				totalearnings=walletObject.totalearnings
			response['data']=allData
			response['totalearnings']=str(totalearnings)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getWalletDetails(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			allData=[]
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			driverObj = driver.objects.filter(userToken=session_token).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver Not Exist'
				return Response(response)
			totalearnings=float('0')
			availableBalnce=float('0')
			totalwithdrawls=float('0')
			walletObject=wallet.objects.filter(driverID=driverObj.userUniqueID).first()
			if walletObject:
				totalearnings=walletObject.totalearnings
				availableBalnce=walletObject.availablebalance
				totalwithdrawls=walletObject.totalwithdrawls
			earningsData=[]
			# theEarnings=earnings.objects.filter(driverID=driverObj.userUniqueID)
			# for e in theEarnings:
			#     dat=e.created_at
			#     theDate=dat.strftime("%b %d, %Y")
			#     earningsData.append({'name':e.name,
			#                          'image':e.image,
			#                         'date':theDate,
			#                         'amount':e.amount,
			#                         'status':'Request',})
			allPayoutRequested=payout.objects.filter(driverID=driverObj.userUniqueID).order_by('-id')
			allPayouts=[]
			for p in allPayoutRequested:
				dat=p.created_at
				theDate=dat.strftime("%b %d, %Y")
				allPayouts.append({'requestedAmount':p.requestedAmount,
								   'date':theDate,
								  'status':'Requested',})
			response['allPayouts']=allPayouts
			response['tranactionData']=earningsData
			response['totalearnings']=str(totalearnings)
			response['availableBalnce']=str(availableBalnce)
			response['totalwithdrawls']=str(totalwithdrawls)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class requestPayout(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			allData=[]
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			driverObj = driver.objects.filter(userToken=session_token).first()
			if not data.get('requestedAmount'):
				response['status_code']=400
				response['status_message']='requestedAmount required'
				return Response(response)
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver Not Exist'
				return Response(response)
			walletObject=wallet.objects.filter(driverID=driverObj.userUniqueID).first()
			if not walletObject:
				response['status_code']=400
				response['status_message']='You have no amount in wallet'
				return Response(response)
			if float(data.get('requestedAmount'))>=float(walletObject.availablebalance):
				response['status_code']=400
				response['status_message']='Not enough amount in wallet'
				return Response(response)
			try:
				payload={}
				payload['AccessKey']=str(settings.ADMIN_ACCESS_KEY)
				payload['payoutUserType']="Driver"
				payload['payoutUserId']=driverObj.userUniqueID
				payload['payoutUserName']=driverObj.name
				payload['payoutUserEmail']=driverObj.email
				payload['payoutUserImage']=driverObj.image.name
				payload['payoutAmount']=data.get('requestedAmount')
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/auth/addPayoutRequests/"
				res = requests.request("POST",url,data=payload)
				res=res.json()
				if res['status_code']!=200:
					return Response(res)
				theBal=float(walletObject.balance)
				theBal=float(theBal)-float(data.get('requestedAmount'))
				walletObject.balance=float(theBal)
				walletObject.save()
				response['url']=res['url']
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			thePayout=payout.objects.create(driverID=driverObj.userUniqueID)
			thePayout.requestedAmount=float(data.get('requestedAmount'))
			thePayout.availablebalance=float(walletObject.availablebalance)
			thePayout.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class linkAccount(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			allData=[]
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			driverObj = driver.objects.filter(userToken=session_token).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver Not Exist'
				return Response(response)
			try:
				payload={}
				payload['AccessKey']=str(settings.ADMIN_ACCESS_KEY)
				payload['payoutUserId']=driverObj.userUniqueID
				payload['payoutUserEmail']=driverObj.email
				
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/auth/linkPayoutAccount/"
				res = requests.request("POST",url,data=payload)
				res=res.json()
				if res['status_code']!=200:
					return Response(res)
				response['url']=res['url']
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class addDebitCard(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			driverObj = driver.objects.filter(userToken=session_token).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver Not Exist'
				return Response(response)
			if not data.get('cardToken'):
				response['status_code']=400
				response['status_message']='cardToken is required'
				return Response(response)
			try:
				payload={}
				payload['AccessKey']=str(settings.ADMIN_ACCESS_KEY)
				payload['payoutUserId']=driverObj.userUniqueID
				payload['cardToken']=data.get('cardToken')
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/auth/addDebitCart/"
				res = requests.request("POST",url,data=payload)
				res=res.json()
				if res['status_code']!=200:
					return Response(res)
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class deleteDebitCard(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			driverObj = driver.objects.filter(userToken=session_token).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver Not Exist'
				return Response(response)
			if not data.get('cardId'):
				response['status_code']=400
				response['status_message']='cardId is required'
				return Response(response)
			try:
				payload={}
				payload['AccessKey']=str(settings.ADMIN_ACCESS_KEY)
				payload['payoutUserId']=driverObj.userUniqueID
				payload['cardId']=data.get('cardId')
				url = str(settings.ADMIN_ACCESS_URL)+"superadmin/auth/deleteDebitCart/"
				res = requests.request("POST",url,data=payload)
				res=res.json()
				if res['status_code']!=200:
					return Response(res)
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getDriverEarningDataForCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if not data.get('companyId'):
				response['status_code']=400
				response['status_message']='companyId required'
				return Response(response)
			allTranObject=earnings.objects.filter(companyId=data.get('companyId'),driverType="Company").order_by('-id')
			allDriverEarnings=float(0)
			for trans in allTranObject:
				allDriverEarnings=float(allDriverEarnings)+float(trans.availablebalance)
			response['allDriverEarnings']=str(allDriverEarnings)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getDriverEarningDataForAdmin(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			allTranObject=wallet.objects.filter(driverType="Admin").order_by('-id')
			allDriverEarnings=float(0)
			allData=[]
			if allTranObject:
				for trans in allTranObject:
					allDriverEarnings=float(allDriverEarnings)+float(trans.availablebalance)
					theDriverOBJ=driver.objects.filter(userUniqueID=trans.driverID).first()
					allData.append({'driverID':trans.driverID,
					                'totalearnings':trans.totalearnings,
									'totalwithdrawls':trans.totalwithdrawls,
									'availablebalance':trans.availablebalance,
									'name':theDriverOBJ.name,
									'email':theDriverOBJ.email,
									'image':theDriverOBJ.image,})
			response['allData']=allData
			response['allDriverEarnings']=str(allDriverEarnings)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getEarningListOfADriverForAdmin(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='driverID required'
				return Response(response)
			allTranObject=earnings.objects.filter(driverID=data.get('driverID')).order_by('-id')
			allData=[]
			if allTranObject:
				for trans in allTranObject:
					# theDriverOBJ=driver.objects.filter(userUniqueID=trans.driverID).first()
					allData.append({'earnID':trans.earnID,
					                'orderID':trans.orderID,
									'customerID':trans.customerID,
									'amount':trans.amount,
									'name':trans.name,
									'image':trans.image,
									'orderDropOff':trans.orderDropOff,
									'orderTime':trans.orderTime,
									'orderDate':trans.orderDate,})
			response['allData']=allData
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)