from rest_framework import serializers
from base.models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from django.conf import settings
# class GetDriverData(serializers.ModelSerializer):
# 	class Meta:
# 		model = Driver
# 		fields = ['userUniqueID', 'name', 'email','phone','countrycode','image','isdisabled']


class GetDriverData(serializers.ModelSerializer):
	documents=serializers.SerializerMethodField(source='get_documents')
	image=serializers.SerializerMethodField(source='get_image')
	dob =  serializers.SerializerMethodField(source='get_dob')

	class Meta:
		model = driver
		fields = ['documents','userUniqueID','dob','isRequested','state','age','address','name', 'email','phone','countrycode','socialId','image','phoneverified','userReferalCode','isdisabled']

	def get_image(self,obj):
		return str(obj.image)


	def get_documents(self,obj):
		data=[]
		theDoc=driverdocuments.objects.filter(userUniqueID=obj.userUniqueID)
		for doc in theDoc:
			theDocName=str(doc.document)
			theDocType=''
			if doc.doctType=='1':
				theDocType='Passport'
			elif doc.doctType=='2':
				theDocType='Licence'
			elif doc.doctType=='3':
				theDocType='National ID'
			elif doc.doctType=='4':
				theDocType='Age Proof'
			else:
				theDocType='Other'

			data.append({'documents':theDocName,
						 'theDocType':theDocType,
						 'status':doc.theStatus,
						 'id':doc.id,})
		return data
	
	def get_dob(self, obj):
		if obj.dob is not None:
			return obj.dob
		else:
			return ''