from django.shortcuts import render
from rest_framework.views import APIView
from django.http import JsonResponse
from django.views.decorators.csrf import csrf_exempt
from base.models import *
from django.conf import settings
from django.db.models import Avg
from django.db.models import Q
from .serializers import *
from django.http import HttpResponse
from rest_framework.response import Response
import environ
from django.core.files.storage import FileSystemStorage
import math
from django.template.loader import render_to_string
import requests
from django.core.mail import EmailMessage

class adminLoginToken(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			# import os
			# import dotenv

			
			
			# dotenv_file = dotenv.find_dotenv()
			# dotenv.load_dotenv(dotenv_file)
			
			# ACCESS_TOKEN=os.environ.get('ACCESS_TOKEN')
			# print(ACCESS_TOKEN)
			# os.environ['ACCESS_TOKEN'] = data.get('AccessKey')

			# dotenv.set_key(dotenv_file, "ACCESS_TOKEN", os.environ["ACCESS_TOKEN"])

			print("before set token")
			ifAlready=superadminaccess.objects.filter(theID='1').first()
			if ifAlready:
				ifAlready.token=data.get('AccessKey')
				ifAlready.save()
			else:
				print("set token first time")
				superadminaccess.objects.create(theID='1',token=data.get('AccessKey'))

			response['status_code']=200
			response['status_message']='Done'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class adminLogoutToken(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			# import os
			# import dotenv

			
			
			# dotenv_file = dotenv.find_dotenv()
			# dotenv.load_dotenv(dotenv_file)
			
			# ACCESS_TOKEN=os.environ.get('ACCESS_TOKEN')
			# print(ACCESS_TOKEN)
			# os.environ['ACCESS_TOKEN'] = 'A4D5M8I6N3L3O5G2O0U8T'

			# dotenv.set_key(dotenv_file, "ACCESS_TOKEN", os.environ["ACCESS_TOKEN"])
			ifAlready=superadminaccess.objects.filter(theID='1').first()
			if ifAlready:
				ifAlready.token=''
				ifAlready.save()
			response['status_code']=200
			response['status_message']='Done'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class companyLoginToken(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='Access Key required'
				return Response(response)
			theAccess=companyaccess.objects.filter(token=data.get('AccessKey')).first()
			if not theAccess:
				theAccess=companyaccess.objects.create(token=data.get('AccessKey'))
			response['status_code']=200
			response['status_message']='Done'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class companyLogoutToken(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='Access Key required'
				return Response(response)
			theAccess=companyaccess.objects.filter(token=data.get('AccessKey')).first()
			if theAccess:
				theAccess.delete()
			response['status_code']=200
			response['status_message']='Done'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getDriverList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			haveAccess=superadminaccess.objects.filter(token=AccessKey).first()
			if not haveAccess:
				response['status_code']=401
				response['status_message']='You dont have access to this api.'
				return Response(response)

			# env = environ.Env()
			# environ.Env.read_env()
			# theKey = env("ACCESS_TOKEN")
			# if not data.get('AccessKey'):
			# 	response['status_code']=400
			# 	response['status_message']='Access Key required'
			# 	return Response(response)
			# if data.get('AccessKey') != theKey:
			# 	response['status_code']=403
			# 	response['status_message']='You dont have access to this api.'
			# 	return Response(response)
			
			if not data.get('search'):
				theSearch=''
			else:
				theSearch=data.get('search')
			if not data.get('filterType'):
				filterType='All'
			else:
				filterType=data.get('filterType')
				if filterType=='Enable':
					filterValue=False
				else:
					filterValue=True

			if filterType=='All':
				if theSearch=='':
					allDriver=driver.objects.filter(driverType='Admin').order_by('-id')
				else:
					allDriver=driver.objects.filter(name__icontains=theSearch,driverType='Admin').order_by('-id')
			else:
				if theSearch=='':
					allDriver=driver.objects.filter(isdisabled=filterValue,driverType='Admin').order_by('-id')
				else:
					allDriver=driver.objects.filter(name__icontains=theSearch,isdisabled=filterValue,driverType='Admin').order_by('-id')

			# allDriver=Driver.objects.all().order_by('-id')
			if not allDriver:
				response['status_code']=400
				response['status_message']='No Data Found'
				return Response(response)
			else:
				theData=GetDriverData(allDriver, many=True)
				response['status_code']=200
				response['status_message']='Data found'
				response['data']=theData.data
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getDriverListOfCompanyByAdmin(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			haveAccess=superadminaccess.objects.filter(token=AccessKey).first()
			if not haveAccess:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			

			if not data.get('companyID'):
				response['status_code']=400
				response['status_message']='companyID required.'
				return Response(response)
			
			if not data.get('search'):
				theSearch=''
			else:
				theSearch=data.get('search')
			if not data.get('filterType'):
				filterType='All'
			else:
				filterType=data.get('filterType')
				if filterType=='Enable':
					filterValue=False
				else:
					filterValue=True

			if filterType=='All':
				if theSearch=='':
					allDriver=driver.objects.filter(driverType='Company',companyId=data.get('companyID')).order_by('-id')
				else:
					allDriver=driver.objects.filter(name__icontains=theSearch,driverType='Company',companyId=data.get('companyID')).order_by('-id')
			else:
				if theSearch=='':
					allDriver=driver.objects.filter(isdisabled=filterValue,driverType='Company',companyId=data.get('companyID')).order_by('-id')
				else:
					allDriver=driver.objects.filter(name__icontains=theSearch,isdisabled=filterValue,driverType='Company',companyId=data.get('companyID')).order_by('-id')

			if not allDriver:
				response['status_code']=400
				response['status_message']='No Data Found'
				return Response(response)
			else:
				theData=GetDriverData(allDriver, many=True)
				response['status_code']=200
				response['status_message']='Data found'
				response['data']=theData.data
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getDriverData(APIView):
	def post(self, request,*args,**kwargs):
		try:
			response={}
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			haveAccess=superadminaccess.objects.filter(token=AccessKey).first()
			if not haveAccess:
				response['status_code']=401
				response['status_message']='You dont have access to this api.'
				return Response(response)


			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='Driver id required'
				return Response(response)
				
			theDriverObj=driver.objects.filter(userUniqueID=data.get('driverID')).first()
			if not theDriverObj:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			theData=GetDriverData(theDriverObj)
			response['status_code']=200
			response['status_message']='Data found'
			response['data']=theData.data
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class changeStatusOfDriver(APIView):
	def post(self,request,*args,**kwargs):
		try:
			response={}
			data=request.data
			print("the data ",data)
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			haveAccess=superadminaccess.objects.filter(token=AccessKey).first()
			if not haveAccess:
				response['status_code']=401
				response['status_message']='You dont have access to this api.'
				return Response(response)

			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='Driver id required'
				return Response(response)

			# if data.get('theStatus')=='':
			# 	response['status_code']=400
			# 	response['status_message']='Status required'
			# 	return Response(response)
			theDriverObj=driver.objects.filter(userUniqueID=data.get('driverID')).first()
			if theDriverObj:
				if data.get('theStatus') == True:
					theDriverObj.isdisabled=False
					theDriverObj.isRequested=False
				elif data.get('theStatus') == False:
					theDriverObj.isdisabled=True
				else:
					pass
				theDriverObj.save()
				response['status_code']=200
				response['status_message']='Status updated'
			else:
				response['status_code']=400
				response['status_message']='Not a valid Driver ID'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def randomStringFunction():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(10)))
	str1 += ''.join((random.choice(string.digits) for x in range(6)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

def randomStringFunctionForImage():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(10)))
	str1 += ''.join((random.choice(string.digits) for x in range(6)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

# def uploadDocumentImages(image,thePath):
# 	import os
# 	fullPath='media/'+str(thePath)+'/'
# 	fs = FileSystemStorage(location=fullPath)
# 	beforename = os.path.splitext(image.name)[0]
# 	beforename=beforename.replace(' ','')
# 	filetype = os.path.splitext(image.name)[1]
# 	theName=randomStringFunctionForImage()
# 	theImageName=str(theName)+str(filetype)
# 	filename = fs.save(theImageName, image)
# 	return '/'+str(thePath)+'/'+filename

def uploadDocumentImages(image,thePath):
	import os
	import boto3
	from botocore.exceptions import NoCredentialsError
	try:
		bucket=str(settings.AWS_BUCKET_NAME)
		thePath=thePath.lower()
		ACCESS_KEY=str(settings.AWS_ACCESS_KEY_ID)
		SECRET_KEY=str(settings.AWS_SECRET_ACCESS_KEY)
		s3 = boto3.client('s3', aws_access_key_id=ACCESS_KEY,
					  aws_secret_access_key=SECRET_KEY)
		try:
			filetype = os.path.splitext(image.name)[1]
			filetype=filetype.replace('.','')
			imageName=randomStringFunctionForImage()
			thePath=thePath+'/'+imageName+'.'+filetype
			thePath=str(thePath)
			theFile=s3.upload_fileobj(image,bucket,thePath)
			print("Upload Successful")
			filename=str(settings.AWS_BUCKET_URL_1)+str(bucket)+str(settings.AWS_BUCKET_URL_2)+thePath
			return filename
		except FileNotFoundError as e:
			print("The file was not found")
			return ''
		except NoCredentialsError:
			print("Credentials not available")
			return ''
	except Exception as e:
		print(e)
		return ''
		

def findTimeObject(pickupTime):
	from datetime import time
	pickupTimeHour=pickupTime.split(':')[0]
	pickupTimeMinutes=pickupTime.split(':')[1]
	pickupTimeHour=int(pickupTimeHour)
	pickupTimeMinutes=int(pickupTimeMinutes)
	pickupTimeObject = time(hour = pickupTimeHour, minute = pickupTimeMinutes, second = 00)
	return pickupTimeObject

class updateDocuments(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			haveAccess=superadminaccess.objects.filter(token=AccessKey).first()
			if not haveAccess:
				response['status_code']=401
				response['status_message']='You dont have access to this api.'
				return Response(response)

			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='Driver id required'
				return Response(response)

			driverObj=driver.objects.filter(userUniqueID=data.get('driverID')).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			userObjId=driverObj.userTableID
			theUniqueID=driverObj.userUniqueID
			passportImage=request.FILES.get('passportImage')
			if passportImage:
				passportImageID=request.FILES.get('passportImageID')
				if passportImageID == '0':
					filename=uploadDocumentImages(passportImage,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType=1,isApproved=True)
				else:
					filename=uploadDocumentImages(passportImage,'Documents')
					ownerDocs=driverdocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=passportImageID,doctType=1)
					ownerDocs.document=filename
					ownerDocs.isApproved=True
					ownerDocs.save()
			licenceImage=request.FILES.get('licenceImage')
			if licenceImage:
				licenceImageID=request.FILES.get('licenceImageID')
				if licenceImageID == '0':
					filename=uploadDocumentImages(licenceImage,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType=2,isApproved=True)
				else:
					filename=uploadDocumentImages(licenceImage,'Documents')
					ownerDocs=driverdocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=licenceImageID,doctType=2)
					ownerDocs.document=filename
					ownerDocs.isApproved=True
					ownerDocs.save()
			nationalID=request.FILES.get('nationalID')
			if nationalID:
				nationalProofID=request.FILES.get('nationalProofID')
				if nationalProofID == '0':
					filename=uploadDocumentImages(nationalID,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType=3,isApproved=True)
				else:
					filename=uploadDocumentImages(nationalID,'Documents')
					ownerDocs=driverdocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=nationalProofID,doctType=3)
					ownerDocs.document=filename
					ownerDocs.isApproved=True
					ownerDocs.save()
			registrationProof=request.FILES.get('ageProof')
			if registrationProof:
				registrationProofID=request.FILES.get('ageProofID')
				if registrationProofID == '0':
					filename=uploadDocumentImages(registrationProof,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType=4,isApproved=True)
				else:
					filename=uploadDocumentImages(registrationProof,'Documents')
					ownerDocs=driverdocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=registrationProofID,doctType=4)
					ownerDocs.document=filename
					ownerDocs.isApproved=True
					ownerDocs.save()

			theIDS = request.POST.getlist("ids")
			theDocuments = request.FILES.getlist("documents")
			for count, image in enumerate(theDocuments):
				if theIDS[count] == '0':
					filename=uploadDocumentImages(image,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userID,userUniqueID=compObjects.userUniqueID,document=filename,doctType=5,isApproved=True)
				else:
					alreadyDoc=driverdocuments.objects.filter(userTableID=userID,id=theIDS[count]).first()
					if alreadyDoc:
						filename=uploadDocumentImages(image,'Documents')
						alreadyDoc.document=filename
						ownerDocs.isApproved=True
						alreadyDoc.save()
			response['status_code']=200
			response['status_message']='Documents Updated Successfully'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def approveDocuments(driverID,docID):
	alreadyDoc=driverdocuments.objects.filter(userUniqueID=driverID,id=docID).first()
	if alreadyDoc:
		alreadyDoc.isApproved=True
		alreadyDoc.theStatus='2'
		alreadyDoc.save()

def rejectDocuments(driverID,docID,reason):
	alreadyDoc=driverdocuments.objects.filter(userUniqueID=driverID,id=docID).first()
	if alreadyDoc:
		alreadyDoc.isApproved=False
		alreadyDoc.theStatus='3'
		alreadyDoc.rejectMessage=reason
		alreadyDoc.save()

class changeDocumentsStatus(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			haveAccess=superadminaccess.objects.filter(token=AccessKey).first()
			if not haveAccess:
				response['status_code']=401
				response['status_message']='You dont have access to this api.'
				return Response(response)

			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='Driver id required'
				return Response(response)

			if not data.get('docID'):
				response['status_code']=400
				response['status_message']='Document id required'
				return Response(response)

			if not data.get('status'):
				response['status_code']=400
				response['status_message']='Status required'
				return Response(response)
				
			theDriverObj=driver.objects.filter(userUniqueID=data.get('driverID')).first()
			if not theDriverObj:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			docID = data.get("docID")
			theStatus = data.get("status")
			if theStatus == 'Accept':
				approveDocuments(data.get('driverID'),docID)
			else:
				if not data.get('reason'):
					response['status_code']=400
					response['status_message']='Reject reason required'
					return Response(response)
				rejectDocuments(data.get('driverID'),docID,data.get('reason'))
			approveCount=0
			totalUplodedCount=0
			presentDocs=driverdocuments.objects.filter(userUniqueID=data.get('driverID'))
			for p in presentDocs:
				totalUplodedCount+=1
				if p.isApproved==True:
					approveCount+=1
			if approveCount==0:
				pass
			elif approveCount==totalUplodedCount:
				theDriverObj.risk=3
				theDriverObj.save()
			elif approveCount<totalUplodedCount:
				theDriverObj.risk=2
				theDriverObj.save()
			else:
				theDriverObj.risk=1
				theDriverObj.save()
			response['status_code']=200
			response['status_message']='Documents '+str(theStatus)+' Successfully'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def referralCode():
	try:
		Referal=''
		digits2 = "rba2cqq4skyhz7meizjk"
		for i in range(8): 
		  Referal += digits2[math.floor(random.random() * 15)]
		print(Referal)
	except Exception as e:
		print(e)
	return str(Referal)

class addDriver(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			refrence=''
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			haveAccess=superadminaccess.objects.filter(token=AccessKey).first()
			if not haveAccess:
				response['status_code']=401
				response['status_message']='You dont have access to this api.'
				return Response(response)

			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)

			if not data.get('phone'):
				response['status_code']=400
				response['status_message']='Phone required'
				return Response(response)

			if not data.get('countrycode'):
				response['status_code']=400
				response['status_message']='Country code required'
				return Response(response)

			if not data.get('name'):
				response['status_code']=400
				response['status_message']='Name required'
				return Response(response)
			
			if not data.get('dob'):
				response['status_code']=400
				response['status_message']='D.O.B required'
				return Response(response)

			if not data.get('age'):
				response['status_code']=400
				response['status_message']='age required'
				return Response(response)
			
			if not data.get('state'):
				response['status_code']=400
				response['status_message']='state required'
				return Response(response)
			
			if not data.get('address'):
				response['status_code']=400
				response['status_message']='address required'
				return Response(response)
			
			if not request.FILES.get('image'):
				response['status_code']=400
				response['status_message']='image required'
				return Response(response)
			
			if not request.FILES.get('passportImage'):
				response['status_code']=400
				response['status_message']='Passport image required'
				return Response(response)

			if not request.FILES.get('licenceImage'):
				response['status_code']=400
				response['status_message']='Licence image required'
				return Response(response)

			if not request.FILES.get('nationalID'):
				response['status_code']=400
				response['status_message']='National id required'
				return Response(response)

			if not request.FILES.get('ageProof'):
				response['status_code']=400
				response['status_message']='Age proof required'
				return Response(response)


			userOBj = User.objects.filter(username = data.get('email')).first()
			if userOBj:
				response['status_code']=400
				response['status_message']='Email already exists.'
				return Response(response)
			phoneExist=driver.objects.filter(phone = data.get('phone'))
			if phoneExist:
				response['status_code']=400
				response['status_message']='Phone number already exists.'
			else:
				theUserPassword=randomStringFunction()
				userOBj = User.objects.create_user(username = data.get('email'), password = theUserPassword)
				userObjId=userOBj.id


				# theUniqueID=randomStringFunction()
				beforeNameOfUser=data.get('name')
				beforeNameOfUser=beforeNameOfUser.replace(' ','')
				name3Letter=beforeNameOfUser[0:3]
				name3Letter=name3Letter.upper()
				latExt=driver.objects.all().last()
				if latExt:
					lastId=latExt.userUniqueID
					last5Number=lastId[3:]
					last5Number=int(last5Number)
					new5Number=last5Number+1
					new5Number=str(new5Number)
					new5Number = new5Number.zfill(5)
					theUniqueID=str(name3Letter)+str(new5Number)
				else:
					theUniqueID=str(name3Letter)+str('00001')

				
				
				driverObj = driver.objects.create(state=data.get('state'),age=data.get('age'),address=data.get('address'),userUniqueID=theUniqueID,userTableID=userObjId, name = data.get('name'), email = data.get('email'), countrycode = data.get('countrycode'), phone = data.get('phone'),registerType='Normal',userReferalCode=referralCode(),driverType='Admin',signupOtpVerfied=True,accountverified=True,phoneverified=True)
				driverImage=request.FILES.get('image')
				if driverImage:
					filename=uploadDocumentImages(driverImage,'Profile')
					driverObj.image=filename
					driverObj.save()
				try:
					from datetime import datetime
					dat=data.get('dob')
					dateOfBirth=datetime.strptime(dat, "%Y/%m/%d").date()
					if driverObj:
						driverObj.dob=dateOfBirth
						driverObj.save()
				except Exception as e:
					print(e)
				passportImage=request.FILES.get('passportImage')
				if passportImage:
					filename=uploadDocumentImages(passportImage,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='1',theStatus='2')
				licenceImage=request.FILES.get('licenceImage')
				if licenceImage:
					filename=uploadDocumentImages(licenceImage,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='2',isApproved=True,theStatus='2')
				nationalID=request.FILES.get('nationalID')
				if nationalID:
					filename=uploadDocumentImages(nationalID,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='3',isApproved=True,theStatus='2')
				registrationProof=request.FILES.get('ageProof')
				if registrationProof:
					filename=uploadDocumentImages(registrationProof,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='4',isApproved=True,theStatus='2')
				theDocuments = request.FILES.getlist("documents")
				if theDocuments:
					for count, image in enumerate(theDocuments):
						filename=uploadDocumentImages(image,'Documents')
						ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='5',isApproved=True,theStatus='2')
				else:
					theDocuments=request.FILES.get('documents')
					filename=uploadDocumentImages(theDocuments,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='5',isApproved=True,theStatus='2')
				try:
					pass
					subject='Welcome'
					message = render_to_string('informDriverRegisterEmail.html', {
						'name': data.get('name'),
						'email': data.get('email'),
						'password': str(theUserPassword),
						})
					fromEmail = settings.EMAIL_HOST_USER
					toEmail = data.get('email')
					message = EmailMessage(subject, message, fromEmail, [toEmail])
					message.content_subtype = 'html'
					message.send()
				except Exception as e:
					print(e)
				response['status_code']=200
				response['status_message']='Please verify your account by using password send on registered email.'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updateDriver(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			haveAccess=superadminaccess.objects.filter(token=AccessKey).first()
			if not haveAccess:
				response['status_code']=401
				response['status_message']='You dont have access to this api.'
				return Response(response)

			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='Driver id required'
				return Response(response)


			theDriverObj=driver.objects.filter(userUniqueID=data.get('driverID')).first()
			if not theDriverObj:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)

			theImage=request.FILES.get('image')
			if theImage:
				filename=uploadDocumentImages(theImage,'Profile')
				theDriverObj.image=filename
			if data.get('name'):
				theDriverObj.name=data.get('name')
			if data.get('phone'):
				theDriverObj.phone=data.get('phone')
			if data.get('countrycode'):
				theDriverObj.countrycode=data.get('countrycode')
			if data.get('age'):
				theDriverObj.age=data.get('age')
			if data.get('state'):
				theDriverObj.state=data.get('state')
			if data.get('address'):
				theDriverObj.address=data.get('address')
			if data.get('dob'):
				try:
					from datetime import datetime
					dat=data.get('dob')
					dateOfBirth=datetime.strptime(dat, "%Y/%m/%d").date()
					if theDriverObj:
						theDriverObj.dob=dateOfBirth
				except Exception as e:
					print(e)
			theDriverObj.save()
			response['status_code']=200
			response['status_message']='Driver updated Successfully.'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class totalDrivers(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			haveAccess=superadminaccess.objects.filter(token=AccessKey).first()
			if not haveAccess:
				response['status_code']=401
				response['status_message']='You dont have access to this api.'
				return Response(response)


			allDriverOBJ=driver.objects.all().count()
			response['status_code']=200
			response['count']=allDriverOBJ
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getDriverListCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=401
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			theAccess=companyaccess.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=401
				response['status_message']='You dont have access.'
				return Response(response)
			
			if not data.get('companyID'):
				response['status_code']=400
				response['status_message']='companyID required'
				return Response(response)
			
			if not data.get('search') or data.get('search')=='':
				
				if not data.get('status'):
					allDriver=driver.objects.filter(driverType='Company',companyId=data.get('companyID')).order_by('-id')
				elif data.get('status')=='active':
					allDriver=driver.objects.filter(driverType='Company',companyId=data.get('companyID'),isdisabled=False).order_by('-id')
				elif data.get('status')=='inactive':
					allDriver=driver.objects.filter(driverType='Company',companyId=data.get('companyID'),isdisabled=True).order_by('-id')
				else:
					allDriver=driver.objects.filter(driverType='Company',companyId=data.get('companyID')).order_by('-id')
			else:
				search=data.get('search')
				search=search.lower()
				if not data.get('status'):
					allDriver=driver.objects.filter(driverType='Company',companyId=data.get('companyID'),name__icontains=search).order_by('-id')
				elif data.get('status')=='active':
					allDriver=driver.objects.filter(driverType='Company',companyId=data.get('companyID'),name__icontains=search,isdisabled=False).order_by('-id')
				elif data.get('status')=='inactive':
					allDriver=driver.objects.filter(driverType='Company',companyId=data.get('companyID'),name__icontains=search,isdisabled=True).order_by('-id')
				else:
					allDriver=driver.objects.filter(driverType='Company',companyId=data.get('companyID'),name__icontains=search).order_by('-id')

			# allDriver=driver.objects.filter(driverType='Company',companyId=data.get('companyID')).order_by('-id')
			if not allDriver:
				response['status_code']=400
				response['status_message']='No Data Found'
				return Response(response)
			else:
				theData=GetDriverData(allDriver, many=True)
				response['status_code']=200
				response['status_message']='Data found'
				response['data']=theData.data
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)


class getDriverDataCompany(APIView):
	def post(self, request,*args,**kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")


			theAccess=companyaccess.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			theDriverObj=driver.objects.filter(userUniqueID=data.get('driverID')).first()
			if not theDriverObj:
				response['status_code']=400
				response['status_message']='Not found.'
				return Response(response)
			theData=GetDriverData(theDriverObj)
			response['status_code']=200
			response['status_message']='Data found'
			response['data']=theData.data
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class addDriverCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")
			
			theAccess=companyaccess.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)

			if not data.get('companyID'):
				response['status_code']=400
				response['status_message']='companyID required'
				return Response(response)

			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)

			if not data.get('phone'):
				response['status_code']=400
				response['status_message']='Phone required'
				return Response(response)

			if not data.get('countrycode'):
				response['status_code']=400
				response['status_message']='Country code required'
				return Response(response)

			if not data.get('name'):
				response['status_code']=400
				response['status_message']='Name required'
				return Response(response)
			

			if not data.get('dob'):
				response['status_code']=400
				response['status_message']='D.O.B required'
				return Response(response)

			if not data.get('age'):
				response['status_code']=400
				response['status_message']='age required'
				return Response(response)

			if not request.FILES.get('passportImage'):
				response['status_code']=400
				response['status_message']='Passport image required'
				return Response(response)

			if not request.FILES.get('licenceImage'):
				response['status_code']=400
				response['status_message']='Licence image required'
				return Response(response)

			if not request.FILES.get('nationalID'):
				response['status_code']=400
				response['status_message']='National id required'
				return Response(response)

			if not request.FILES.get('ageProof'):
				response['status_code']=400
				response['status_message']='Age proof required'
				return Response(response)
			
			if not request.FILES.get('image'):
				response['status_code']=400
				response['status_message']='image required'
				return Response(response)
			
			theDriversCount=driver.objects.filter(companyId=data.get('companyID')).count()
			try:
				url2 = str(settings.COMPANY_ACCESS_URL)+"company/subscriptions/getCompanyModulesForLimit/"
				payload = {
				'AccessKey':str(settings.COMPANY_ACCESS_KEY),
				'companyID':data.get('companyID'),
				}
				r2 = requests.request("POST", url2, data=payload)
				r2=r2.json()
				if r2['status_code']==200:
					print("the response module of pLAN======",r2['data'][0]['canAddDriver'])
					if r2['data'][0]['canAddDriver']=='True':
						if int(theDriversCount)<int(r2['data'][0]['driverLimit']):
							pass
						else:
							response['status_code']=400
							response['status_message']="You have reach the limit of your plan."
							return Response(response)
					else:
						response['status_code']=400
						response['status_message']="You can not add driver with your current plan."
						return Response(response)
				elif r2['status_code']==404:
					response['status_code']=400
					response['status_message']="You don't have any plan"
					return Response(response)
				else:		
					# response['status_code']=400
					# response['status_message']='Something went wrong'
					return Response(r2)
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)

			theAccess=companyaccess.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			userOBj = User.objects.filter(username = data.get('email')).first()
			if userOBj:
				response['status_code']=400
				response['status_message']='Email already exists.'
				return Response(response)
			phoneExist=driver.objects.filter(phone = data.get('phone'))
			if phoneExist:
				response['status_code']=400
				response['status_message']='Phone number already exists.'
			else:
				theUserPassword=randomStringFunction()
				userOBj = User.objects.create_user(username = data.get('email'), password = theUserPassword)
				userObjId=userOBj.id
				# theUniqueID=randomStringFunction()
				beforeNameOfUser=data.get('name')
				beforeNameOfUser=beforeNameOfUser.replace(' ','')
				name3Letter=beforeNameOfUser[0:3]
				name3Letter=name3Letter.upper()
				latExt=driver.objects.all().last()
				if latExt:
					lastId=latExt.userUniqueID
					last5Number=lastId[3:]
					last5Number=int(last5Number)
					new5Number=last5Number+1
					new5Number=str(new5Number)
					new5Number = new5Number.zfill(5)
					theUniqueID=str(name3Letter)+str(new5Number)
				else:
					theUniqueID=str(name3Letter)+str('00001')
				driverObj = driver.objects.create(companyId=data.get('companyID'),state=data.get('state'),age=data.get('age'),userUniqueID=theUniqueID,userTableID=userObjId, name = data.get('name'), email = data.get('email'), countrycode = data.get('countrycode'), phone = data.get('phone'),registerType='Normal',userReferalCode=referralCode(),driverType='Company',signupOtpVerfied=True,accountverified=True,phoneverified=True)
				driverImage=request.FILES.get('image')
				if driverImage:
					filename=uploadDocumentImages(driverImage,'Profile')
					driverObj.image=filename
					driverObj.save()
				

				if data.get('dob'):
					try:
						from datetime import datetime
						dat=data.get('dob')
						dateOfBirth=datetime.strptime(dat, "%Y/%m/%d").date()
						if driverObj:
							driverObj.dob=dateOfBirth
							driverObj.save()
					except Exception as e:
						print(e)

				passportImage=request.FILES.get('passportImage')
				if passportImage:
					filename=uploadDocumentImages(passportImage,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='1',)
				licenceImage=request.FILES.get('licenceImage')
				if licenceImage:
					filename=uploadDocumentImages(licenceImage,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='2',isApproved=True)
				nationalID=request.FILES.get('nationalID')
				if nationalID:
					filename=uploadDocumentImages(nationalID,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='3',isApproved=True)
				registrationProof=request.FILES.get('ageProof')
				if registrationProof:
					filename=uploadDocumentImages(registrationProof,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='4',isApproved=True)
				theDocuments = request.FILES.getlist("documents")
				if theDocuments:
					for count, image in enumerate(theDocuments):
						filename=uploadDocumentImages(image,'Documents')
						ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType='5',isApproved=True)
				try:
					pass
					subject='Welcome'
					message = render_to_string('informDriverRegisterEmail.html', {
						'name': data.get('name'),
						'email': data.get('email'),
						'password': str(theUserPassword),
						})
					fromEmail = settings.EMAIL_HOST_USER
					toEmail = data.get('email')
					message = EmailMessage(subject, message, fromEmail, [toEmail])
					message.content_subtype = 'html'
					message.send()
				except Exception as e:
					print(e)
				response['status_code']=200
				response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updateDriverCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")


			theAccess=companyaccess.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)

			theDriverObj=driver.objects.filter(userUniqueID=data.get('driverID')).first()
			if not theDriverObj:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)

			theImage=request.FILES.get('image')
			if theImage:
				filename=uploadDocumentImages(theImage,'Profile')
				theDriverObj.image=filename
			if data.get('name'):
				theDriverObj.name=data.get('name')
			if data.get('phone'):
				theDriverObj.phone=data.get('phone')
			if data.get('countrycode'):
				theDriverObj.countrycode=data.get('countrycode')
			if data.get('age'):
				theDriverObj.age=data.get('age')
			if data.get('state'):
				theDriverObj.state=data.get('state')
			if data.get('address'):
				theDriverObj.address=data.get('address')
			if data.get('dob'):
				try:
					from datetime import datetime
					dat=data.get('dob')
					dateOfBirth=datetime.strptime(dat, "%Y/%m/%d").date()
					if theDriverObj:
						theDriverObj.dob=dateOfBirth
				except Exception as e:
					print(e)
			theDriverObj.save()
			response['status_code']=200
			response['status_message']='Driver updated Successfully.'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class changeStatusOfDriverCompany(APIView):
	def post(self,request,*args,**kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			if not data.get('theStatus'):
				response['status_code']=400
				response['status_message']='Status required'
				return Response(response)

			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='Driver id required'
				return Response(response)


			theAccess=companyaccess.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			theDriverObj=driver.objects.filter(userUniqueID=data.get('driverID')).first()
			if theDriverObj:
				if data.get('theStatus') == 'active':
					theDriverObj.isdisabled=False
				elif data.get('theStatus') == 'inactive':
					theDriverObj.isdisabled=True
				else:
					pass
				theDriverObj.save()
				response['status_code']=200
				response['status_message']='Status updated'
				return Response(response)
			else:
				response['status_code']=400
				response['status_message']='Not a valid driver ID'
				return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updateDocumentsCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='Driver id required'
				return Response(response)

			theAccess=companyaccess.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			driverObj=driver.objects.filter(userUniqueID=data.get('driverID')).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			userObjId=driverObj.userTableID
			theUniqueID=driverObj.userUniqueID
			passportImage=request.FILES.get('passportImage')
			if passportImage:
				passportImageID=request.FILES.get('passportImageID')
				if passportImageID == '0':
					filename=uploadDocumentImages(passportImage,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType=1,isApproved=True)
				else:
					filename=uploadDocumentImages(passportImage,'Documents')
					ownerDocs=driverdocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=passportImageID,doctType=1)
					ownerDocs.document=filename
					ownerDocs.isApproved=True
					ownerDocs.save()
			licenceImage=request.FILES.get('licenceImage')
			if licenceImage:
				licenceImageID=request.FILES.get('licenceImageID')
				if licenceImageID == '0':
					filename=uploadDocumentImages(licenceImage,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType=2,isApproved=True)
				else:
					filename=uploadDocumentImages(licenceImage,'Documents')
					ownerDocs=driverdocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=licenceImageID,doctType=2)
					ownerDocs.document=filename
					ownerDocs.isApproved=True
					ownerDocs.save()
			nationalID=request.FILES.get('nationalID')
			if nationalID:
				nationalProofID=request.FILES.get('nationalProofID')
				if nationalProofID == '0':
					filename=uploadDocumentImages(nationalID,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType=3,isApproved=True)
				else:
					filename=uploadDocumentImages(nationalID,'Documents')
					ownerDocs=driverdocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=nationalProofID,doctType=3)
					ownerDocs.document=filename
					ownerDocs.isApproved=True
					ownerDocs.save()
			registrationProof=request.FILES.get('ageProof')
			if registrationProof:
				registrationProofID=request.FILES.get('ageProofID')
				if registrationProofID == '0':
					filename=uploadDocumentImages(registrationProof,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType=4,isApproved=True)
				else:
					filename=uploadDocumentImages(registrationProof,'Documents')
					ownerDocs=driverdocuments.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=registrationProofID,doctType=4)
					ownerDocs.document=filename
					ownerDocs.isApproved=True
					ownerDocs.save()

			theIDS = request.POST.getlist("ids")
			theDocuments = request.FILES.getlist("documents")
			for count, image in enumerate(theDocuments):
				if theIDS[count] == '0':
					filename=uploadDocumentImages(image,'Documents')
					ownerDocs=driverdocuments.objects.create(userTableID=userID,userUniqueID=compObjects.userUniqueID,document=filename,doctType=5,isApproved=True)
				else:
					alreadyDoc=driverdocuments.objects.filter(userTableID=userID,id=theIDS[count]).first()
					if alreadyDoc:
						filename=uploadDocumentImages(image,'Documents')
						alreadyDoc.document=filename
						ownerDocs.isApproved=True
						alreadyDoc.save()
			response['status_code']=200
			response['status_message']='Documents Updated Successfully'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class changeDocumentsStatusCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='Driver id required'
				return Response(response)


			if not data.get('docID'):
				response['status_code']=400
				response['status_message']='Document id required'
				return Response(response)

			if not data.get('status'):
				response['status_code']=400
				response['status_message']='Status required'
				return Response(response)

			theAccess=companyaccess.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			theDriverObj=driver.objects.filter(userUniqueID=data.get('driverID')).first()
			if not theDriverObj:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			docIds = data.get("docID")
			theStatus = data.get("status")
			if theStatus == 'Accept':
				approveDocuments(data.get('driverID'),docIds)
			else:
				if not data.get('reason'):
					response['status_code']=400
					response['status_message']='Reject reason required'
					return Response(response)
				rejectDocuments(data.get('driverID'),docIds,data.get('reason'))
			approveCount=0
			totalUplodedCount=0
			presentDocs=driverdocuments.objects.filter(userUniqueID=data.get('driverID'))
			for p in presentDocs:
				totalUplodedCount+=1
				if p.isApproved==True:
					approveCount+=1
			if approveCount==0:
				pass
			elif approveCount==totalUplodedCount:
				theDriverObj.risk=3
				theDriverObj.save()
			elif approveCount<totalUplodedCount:
				theDriverObj.risk=2
				theDriverObj.save()
			else:
				theDriverObj.risk=1
				theDriverObj.save()
			response['status_code']=200
			response['status_message']='Documents '+str(theStatus)+' Successfully'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class sendEmailNotificationsToDrivers(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			haveAccess=SuperadminAccess.objects.filter(AccessKey=AccessKey).first()
			if not haveAccess:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			allCustomers=Driver.objects.filter(isdisabled=False)
			if not allCustomers:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			allMails=[]
			for custom in allCustomers:
				allMails.append(custom.email)
			
			try:
				subject=data.get('title')
				message = render_to_string('notifyMailHTML.html', {
				'message': data.get('message'),
				})
				fromEmail = settings.EMAIL_HOST_USER
				message = EmailMessage(subject, message, fromEmail, allMails)
				message.content_subtype = 'html'
				message.send()
			except Exception as e:
				print(e)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

import boto
import boto.exception
import boto.sns
import pprint
import re

def sendPush(device_ids, body):
	import json
	region = [r for r in boto.sns.regions() if r.name==u'us-east-1'][0]
	sns = boto.sns.SNSConnection(
		aws_access_key_id=str(settings.AWS_ACCESS_KEY_ID),
		aws_secret_access_key=str(settings.AWS_SECRET_ACCESS_KEY),
		region=region,
	)
	for device_id in device_ids:
		try:
			print("device id",device_id['token'])
			endpoint_response = sns.create_platform_endpoint(
				platform_application_arn='arn:aws:sns:us-east-1:432363816440:app/GCM/Cannabis',
				token=device_id['token'],
			)   
			endpoint_arn = endpoint_response['CreatePlatformEndpointResponse']['CreatePlatformEndpointResult']['EndpointArn']
		except boto.exception.BotoServerError as err:
			print("if error ", err)
			result_re = re.compile(r'Endpoint(.*)already', re.IGNORECASE)
			result = result_re.search(err.message)
			if result:
				endpoint_arn = result.group(0).replace('Endpoint ','').replace(' already','')
			else:
				raise
		print("ARN:", endpoint_arn)
		publish_result = sns.publish(
			target_arn=endpoint_arn,
			message=json.dumps(body),
			# message_structure='json'
		)
		print("PUBLISH")
		pprint.pprint(publish_result)
		notifications.objects.create(driverID=device_id['driverID'],notificationType='push',title=body['title'],description=body['body'])

class sendPushNotificationsToDrivers(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")
			
			if not data.get('title'):
				response['status_code']=400
				response['status_message']='title required'
				return Response(response)
			if not data.get('message'):
				response['status_code']=400
				response['status_message']='message required'
				return Response(response)

			haveAccess=SuperadminAccess.objects.filter(AccessKey=AccessKey).first()
			if not haveAccess:
				response['status_code']=403
				response['status_message']='You dont have access to this api.'
				return Response(response)
			allCustomers=Driver.objects.filter(isdisabled=False)
			if not allCustomers:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			allTokens=[]
			for custom in allCustomers:
				if custom.fcmtoken == '':
					pass
				elif custom.fcmtoken == None:
					pass
				else:
					allTokens.append({'token':custom.fcmtoken,
					                  'driverID':custom.userUniqueID})
			messageBody={}
			messageBody['type']='admin_info'
			messageBody['title']=data.get('title')
			messageBody['body']=data.get('message')
			sendPush(allTokens,messageBody)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class totalDriversForCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			
			if str(settings.MY_ACCESS_KEY)!=str(data.get('AccessKey')):
				response['status_code']=400
				response['status_message']='You dont have access to this api'
				return Response(response)
			
			if not data.get('companyId'):
				response['status_code']=400
				response['status_message']='companyId required'
				return Response(response)

			allDriverOBJ=driver.objects.filter(companyId=data.get('companyId')).count()
			response['status_code']=200
			response['count']=allDriverOBJ
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def createCSVDrivers(allDrivers):
	import csv
	rows=[]
	fields = ['Id', 'Name', 'Email', 'Phone', 'State', 'Age', 'Dob', 'Address', 'Status']
	for driver in allDrivers:
		innerRow=[]
		innerRow.append(driver['userUniqueID'])
		innerRow.append(driver['name'])
		innerRow.append(driver['email'])
		tempPhone=str(driver['countrycode'])+str(driver['phone']) 
		innerRow.append(tempPhone) 
		innerRow.append(driver['state']) 
		innerRow.append(driver['age']) 
		innerRow.append(driver['dob']) 
		innerRow.append(driver['address'])
		if driver['isdisabled']==True:
			theStatus='In Active'
		else:
			theStatus='Active'
		innerRow.append(theStatus)
		rows.append(innerRow)
	fname=randomStringFunctionForImage()
	filename = "/var/www/html/driver/media/Reports/drivers_"+str(fname)+".csv"
	url=str(settings.WEB_BASE_URL)+"media/Reports/drivers_"+str(fname)+".csv"
	with open(filename, 'w') as csvfile:
		csvwriter = csv.writer(csvfile) 
		csvwriter.writerow(fields)
		csvwriter.writerows(rows)
	return url

class getReportDrivers(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			haveAccess=superadminaccess.objects.filter(token=AccessKey).first()
			if not haveAccess:
				response['status_code']=401
				response['status_message']='You dont have access to this api.'
				return Response(response)
			if not data.get('driverType'):
				driverType='All'
			else:
				driverType=data.get('driverType')
			
			if not data.get('filterType'):
				filterType='All'
			elif data.get('filterType')=='All':
				filterType='All'
			else:
				filterType=data.get('filterType')
				if filterType=='Enable':
					filterValue=False
				else:
					filterValue=True
			
			if not data.get('fromDate'):
				response['status_code']=400
				response['status_message']='fromDate is required'
				return Response(response)
			
			if not data.get('toDate'):
				response['status_code']=400
				response['status_message']='toDate is required'
				return Response(response)

			try:
				from datetime import datetime
				dat=data.get('fromDate')
				fromDate=datetime.strptime(dat, "%Y/%m/%d").date()
				dat2=data.get('toDate')
				toDate=datetime.strptime(dat2, "%Y/%m/%d").date()
			except Exception as e:
				print(e)
			
			if driverType=='All':
				if filterType=='All':
					allDriver=driver.objects.filter(Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-id')
				else:
					allDriver=driver.objects.filter(Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate) & Q(isdisabled=filterValue)).order_by('-id')
			elif driverType=='Admin':
				if filterType=='All':
					allDriver=driver.objects.filter(Q(driverType='Admin') & Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-id')
				else:
					allDriver=driver.objects.filter(Q(driverType='Admin') &Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate) & Q(isdisabled=filterValue)).order_by('-id')
			elif driverType=='Company':
				if filterType=='All':
					allDriver=driver.objects.filter(Q(driverType='Company') & Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-id')
				else:
					allDriver=driver.objects.filter(Q(driverType='Company') &Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate) & Q(isdisabled=filterValue)).order_by('-id')
			else:
				if filterType=='All':
					allDriver=driver.objects.filter(Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-id')
				else:
					allDriver=driver.objects.filter(Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate) & Q(isdisabled=filterValue)).order_by('-id')
			if not allDriver:
				response['status_code']=400
				response['status_message']='No records found'
				return Response(response)
			else:
				theData=GetDriverData(allDriver, many=True)
				downloadLink=createCSVDrivers(theData.data)
				response['status_code']=200
				response['status_message']='Success'
				response['downloadLink']=downloadLink
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getReportDriversForCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:

			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			theAccess=companyaccess.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			
			if not data.get('companyID'):
				response['status_code']=400
				response['status_message']='companyID required.'
				return Response(response)

			if not data.get('filterType'):
				filterType='All'
			elif data.get('filterType')=='All':
				filterType='All'
			else:
				filterType=data.get('filterType')
				if filterType=='Enable':
					filterValue=False
				else:
					filterValue=True
			
			if not data.get('fromDate'):
				response['status_code']=400
				response['status_message']='fromDate is required'
				return Response(response)
			
			if not data.get('toDate'):
				response['status_code']=400
				response['status_message']='toDate is required'
				return Response(response)

			try:
				from datetime import datetime
				dat=data.get('fromDate')
				fromDate=datetime.strptime(dat, "%Y/%m/%d").date()
				dat2=data.get('toDate')
				toDate=datetime.strptime(dat2, "%Y/%m/%d").date()
			except Exception as e:
				print(e)
			
			if filterType=='All':
				allDriver=driver.objects.filter(Q(driverType='Company') & Q(companyId=data.get('companyID')) & Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate)).order_by('-id')
			else:
				allDriver=driver.objects.filter(Q(driverType='Company') & Q(companyId=data.get('companyID')) & Q(created_at__date__gte=fromDate) & Q(created_at__date__lte=toDate) & Q(isdisabled=filterValue)).order_by('-id')
			
			if not allDriver:
				response['status_code']=400
				response['status_message']='No records found'
				return Response(response)
			else:
				theData=GetDriverData(allDriver, many=True)
				downloadLink=createCSVDrivers(theData.data)
				response['status_code']=200
				response['status_message']='Success'
				response['downloadLink']=downloadLink
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)