from django.template.defaultfilters import lower
from rest_framework.views import APIView
from rest_framework.response import Response
from base.models import *
from earnings.models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from django.template.loader import render_to_string
from django.core.mail import EmailMessage
import math, random, datetime, pytz, string
from datetime import datetime
from datetime import timedelta
import requests
from django.conf import settings
import json
import stripe
from django.db.models import Q

import boto
import boto.exception
import boto.sns
import pprint
import re

def gernateEarningID():
	strNumbers = ''.join((random.choice(string.digits) for x in range(5)))
	finalString='ERN'+str(strNumbers)
	return finalString

def sendPush(device_id, body):
	region = [r for r in boto.sns.regions() if r.name==u'us-east-1'][0]
	sns = boto.sns.SNSConnection(
		aws_access_key_id=str(settings.AWS_ACCESS_KEY_ID),
		aws_secret_access_key=str(settings.AWS_SECRET_ACCESS_KEY),
		region=region,
	)
	try:
		endpoint_response = sns.create_platform_endpoint(
			platform_application_arn='arn:aws:sns:us-east-1:432363816440:app/GCM/Cannabis',
			token=device_id,
		)   
		endpoint_arn = endpoint_response['CreatePlatformEndpointResponse']['CreatePlatformEndpointResult']['EndpointArn']
	except boto.exception.BotoServerError as err:
		result_re = re.compile(r'Endpoint(.*)already', re.IGNORECASE)
		result = result_re.search(err.message)
		if result:
			endpoint_arn = result.group(0).replace('Endpoint ','').replace(' already','')
		else:
			raise
	print("ARN:", endpoint_arn)
	publish_result = sns.publish(
		target_arn=endpoint_arn,
		message=json.dumps(body),
		# message_structure='json'
	)
	print("PUBLISH")
	pprint.pprint(publish_result)

class getListOfOrders(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")

			if not data.get('listType'):
				response['status_code']=400
				response['status_message']='listType required'
				return Response(response)
			if not data.get('page'):
				response['status_code']=400
				response['status_message']='page required'
				return Response(response)
			driverObj = driver.objects.filter(userToken=session_token).first()
			if not driverObj:
				response['status_code']=401
				response['status_message']='Driver not exist'
				return Response(response,status=response['status_code'])	
			try:
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/order/getListOfOrdersOfDriver/"
				payload={'AccessKey': str(settings.CUSTOMER_ACCESS_KEY),
				'listType': data.get('listType'),
				'page': data.get('page'),
				'driverID': driverObj.userUniqueID,
				}
				res = requests.request("POST", url,data=payload)
				print(res.json())
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
	
class getOrderDetails(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")

			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID required'
				return Response(response)
			driverObj = driver.objects.filter(userToken=session_token).first()
			if not driverObj:
				response['status_code']=401
				response['status_message']='Driver not exist'
				return Response(response,status=response['status_code'])
			
			try:
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/order/getOrderDetailsOfDriver/"
				payload={'AccessKey': str(settings.CUSTOMER_ACCESS_KEY),
				'orderID': data.get('orderID'),
				'driverID': driverObj.userUniqueID,
				}
				res = requests.request("POST", url,data=payload)
				res=res.json()
				if res['status_code']==200:
					rateObj=ratings.objects.filter(orderID=data.get('orderID'),driver=driverObj).first()
					rateData={}
					if rateObj:
						rateData['isRated']=True
						rateData['rating']=str(rateObj.rating)
						rateData['review']=rateObj.review
					else:
						rateData['isRated']=False
						rateData['rating']=str(0)
						rateData['review']=''
					response['ratingsData']=rateData
					response['storeData']=res['storeData']
					response['data']=res['data']
					response['productData']=res['productData']
					# response['productData']=res['productData']
					response['status_code']=200
					response['status_message']='Success'
					return Response(response)
				else:
					print(res)
					return Response(res)
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			import sys, os
			exc_type, exc_obj, exc_tb = sys.exc_info()
			fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
			print(exc_type, fname, exc_tb.tb_lineno)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class bookAssignDriver(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			
			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='driverID required'
				return Response(response)
			
			if not data.get('storeName'):
				response['status_code']=400
				response['status_message']='storeName required'
				return Response(response)
			
			if not data.get('storeImage'):
				response['status_code']=400
				response['status_message']='storeImage required'
				return Response(response)

			driverObj = driver.objects.filter(userUniqueID=data.get('driverID')).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Driver not exist'
				return Response(response)
			driverObj.isbooked=True
			driverObj.save()
			deviceID=driverObj.fcmtoken
			messageBody={}
			messageBody['body']='You have received a order from the store '+str(data.get('storeName'))
			innerData={}

			# innerData['orderID']=i.orderID
			innerData['storeName']=data.get('storeName')
			innerData['image']=data.get('storeImage')
			innerData['storeImage']=data.get('storeImage')
			# innerData['orderStatus']=str(statusOrder)
			# innerData['orderStatusColor']=str(statusColor)

			messageBody['data']=innerData
			messageBody['type']='order_assined'
			messageBody['title']='Order Assigned'

			try:
				theReturnOfPush=sendPush(deviceID,messageBody)
				notifications.objects.create(driverID=driverObj.userUniqueID,image=messageBody['data']['image'],title=messageBody['title'],description=messageBody['body'])
			except Exception as e:
				print(e)	
			response['driverName']=driverObj.name
			response['driverImage']=str(settings.WEB_BASE_URL)+'media/'+str(driverObj.image)
			response['status_code']=200
			response['status_message']='Driver assigned'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def randomStringFunctionForImage():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(8)))
	str1 += ''.join((random.choice(string.digits) for x in range(4)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString
	
# from django.core.files.storage import FileSystemStorage
# def uploadDocumentImages(image,thePath):
#     import os
#     fullPath='media/'+str(thePath)+'/'
#     fs = FileSystemStorage(location=fullPath)
#     beforename = os.path.splitext(image.name)[0]
#     beforename=beforename.replace(' ','')
#     filetype = os.path.splitext(image.name)[1]
#     theName=randomStringFunctionForImage()
#     theImageName=str(theName)+str(filetype)
#     filename = fs.save(theImageName, image)
#     return str(thePath)+'/'+filename

def uploadDocumentImages(image,thePath):
	import os
	import boto3
	from botocore.exceptions import NoCredentialsError
	try:
		bucket='cannabisdriver'
		thePath=thePath.lower()
		ACCESS_KEY=str(settings.AWS_ACCESS_KEY_ID)
		SECRET_KEY=str(settings.AWS_SECRET_ACCESS_KEY)
		s3 = boto3.client('s3', aws_access_key_id=ACCESS_KEY,
					  aws_secret_access_key=SECRET_KEY)
		try:
			filetype = os.path.splitext(image.name)[1]
			imageName=randomStringFunctionForImage()
			thePath=thePath+'/'+imageName+'.'+filetype
			thePath=str(thePath)
			theFile=s3.upload_fileobj(image,bucket,thePath)
			print("Upload Successful")
			filename=str(settings.AWS_BUCKET_URL_1)+str(bucket)+str(settings.AWS_BUCKET_URL_2)+thePath
			return filename
		except FileNotFoundError as e:
			print("The file was not found")
			return ''
		except NoCredentialsError:
			print("Credentials not available")
			return ''
	except Exception as e:
		print(e)
		return ''

class changeOrderStatus(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:

			data=request.data
			# print("Thes data ===>",data)
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")

			driverObj = driver.objects.filter(userToken=session_token).first()
			if not driverObj:
				response['status_code']=401
				response['status_message']='Driver not exist'
				return Response(response,status=response['status_code'])
			
			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID required'
				return Response(response)
			
			if not data.get('orderStatus'):
				response['status_code']=400
				response['status_message']='orderStatus required'
				return Response(response)
			payload={}
			if data.get('orderStatus')=='Delivered':
				if request.FILES.get('customerPic'):
					customerPic=request.FILES.get('customerPic')
					print("customerPic",type(customerPic))
				else:
					response['status_code']=400
					response['status_message']='customerPic required'
					return Response(response)
				if request.FILES.get('customerIDproofFront'):
					customerIDproofFront=request.FILES.get('customerIDproofFront')
					print("customerIDproofFront",type(customerIDproofFront))
				else:
					response['status_code']=400
					response['status_message']='customerIDproofFront required'
					return Response(response)
				
				if request.FILES.get('customerIDproofBack'):
					customerIDproofBack=request.FILES.get('customerIDproofBack')
					print("customerIDproofBack",type(customerIDproofBack))
				else:
					response['status_code']=400
					response['status_message']='customerIDproofBack required'
					return Response(response)

				if request.FILES.get('customerSign'):
					customerSign=request.FILES.get('customerSign')
					print("customerSign",type(customerSign))
				else:
					response['status_code']=400
					response['status_message']='customerSign required'
					return Response(response)
				customerSignLink=uploadDocumentImages(customerSign,'Documents')
				customerSignLink=customerSignLink

				customerIDproofFrontLink=uploadDocumentImages(customerIDproofFront,'Documents')
				customerIDproofFrontLink=customerIDproofFrontLink

				customerIDproofBackLink=uploadDocumentImages(customerIDproofBack,'Documents')
				customerIDproofBackLink=customerIDproofBackLink
				
				customerPicLink=uploadDocumentImages(customerPic,'Documents')
				customerPicLink=customerPicLink

				payload['customerSignLink']=customerSignLink
				payload['customerIDproofFrontLink']=customerIDproofFrontLink
				payload['customerIDproofBackLink']=customerIDproofBackLink
				payload['customerPicLink']=customerPicLink
				
				
			payload['orderID']=data.get('orderID')
			payload['orderStatus']=data.get('orderStatus')
			payload['driverID']=driverObj.userUniqueID
			payload['driverName']=driverObj.name
			payload['driverImage']=driverObj.image
			payload['AccessKey']=str(settings.CUSTOMER_ACCESS_KEY)
			try:
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/order/changeOrderStatusFromDriver/"
				res = requests.request("POST", url,data=payload)
				print(res.json())
				res=res.json()
				if res['status_code']==200:
					if data.get('orderStatus')=='Rejected':
						driverObj.isbooked=False
						driverObj.save()
					if data.get('orderStatus')=='Delivered':
						driverObj.isbooked=False
						driverObj.save()
						earningsObject=earnings.objects.create(earnID=gernateEarningID(),companyId=driverObj.companyId,driverType=driverObj.driverType,driverID=driverObj.userUniqueID,orderID=res['returnData'][0]['orderID'],customerID=res['returnData'][0]['customerID'],amount=res['returnData'][0]['amount'],name=res['returnData'][0]['name'],image=res['returnData'][0]['image'],description='Amount addedd for order complete',orderDropOff=res['returnData'][0]['orderDropOff'],orderTime=res['returnData'][0]['orderTime'],orderDate=res['returnData'][0]['orderDate'])
						walletObject=wallet.objects.filter(driverID=driverObj.userUniqueID).first()
						if walletObject:
							oldAvail=float(walletObject.availablebalance)
							oldEarning=float(walletObject.totalearnings)
						else:
							walletObject=wallet.objects.create(driverID=driverObj.userUniqueID,companyId=driverObj.companyId,driverType=driverObj.driverType)
							oldAvail=float(0)
							oldEarning=float(0)
						# oldAvail=float(walletObject.availablebalance)
						# oldEarning=float(walletObject.totalearnings)
						theReturnDataAmount=res['returnData'][0]['amount']
						availableBalnce=float(oldAvail)+float(theReturnDataAmount)
						totalEarning=float(oldEarning)+float(theReturnDataAmount)
						walletObject.totalearnings=float(totalEarning)
						walletObject.availablebalance=float(availableBalnce)
						walletObject.save()
					deviceID=driverObj.fcmtoken
					messageBody={}
					messageBody['body']='Order has been '+str(data.get('orderStatus'))
					innerData={}

					# innerData['orderID']=i.orderID
					innerData['storeName']=''
					innerData['image']=''
					innerData['storeImage']=''
					# innerData['orderStatus']=str(statusOrder)
					# innerData['orderStatusColor']=str(statusColor)

					messageBody['data']=innerData
					messageBody['type']='order_'+lower(data.get('orderStatus'))
					messageBody['title']='Order '+str(data.get('orderStatus'))
					try:
						theReturnOfPush=sendPush(deviceID,messageBody)
						notifications.objects.create(driverID=driverObj.userUniqueID,image=messageBody['data']['image'],title=messageBody['title'],description=messageBody['body'])
					except Exception as e:
						print(e)
				return Response(res)
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updateLocation(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:

			data=request.data
			# print("Thes data ===>",data)
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			
			if not data.get('currentlocation'):
				response['status_code']=400
				response['status_message']='currentlocation required'
				return Response(response)
			
			if not data.get('currentlatitude'):
				response['status_code']=400
				response['status_message']='currentlatitude required'
				return Response(response)
			
			if not data.get('currentlongitude'):
				response['status_code']=400
				response['status_message']='currentlongitude required'
				return Response(response)
			
			
			session_token = session_token.replace("Token ", "")

			driverObj = driver.objects.filter(userToken=session_token).first()
			if not driverObj:
				response['status_code']=401
				response['status_message']='Driver not exist'
				return Response(response,status=response['status_code'])
			driverObj.currentlocation=data.get('currentlocation')
			driverObj.currentlatitude=data.get('currentlatitude')
			driverObj.currentlongitude=data.get('currentlongitude')
			driverObj.save()
			response['status_code']=200
			response['status_message']='location updated successfully'
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getHomeOrders(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			session_token = session_token.replace("Token ", "")
			driverObj = driver.objects.filter(userToken=session_token).first()
			if not driverObj:
				response['status_code']=401
				response['status_message']='Driver not exist'
				return Response(response,status=response['status_code'])
			
			try:
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/order/getHomeScreenOrder/"
				payload={'AccessKey': str(settings.CUSTOMER_ACCESS_KEY),
				'driverID': driverObj.userUniqueID,
				}
				res = requests.request("POST", url,data=payload)
				print(res.json())
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			import sys, os
			exc_type, exc_obj, exc_tb = sys.exc_info()
			fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
			print(exc_type, fname, exc_tb.tb_lineno)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class getDriverDetailsOfOrder(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:

			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			
			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Invalid access key'
				return Response(response)
			
			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='driverID required'
				return Response(response)
			driverData={}

			driverObj = driver.objects.filter(userUniqueID=data.get('driverID')).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Invalid driver id'
				return Response(response)
			
			driverData['driverID']=driverObj.userUniqueID
			driverData['name']=driverObj.name
			driverData['image']=driverObj.image
			driverData['phone']=driverObj.phone
			driverData['countrycode']=driverObj.countrycode
			driverData['latitude']=str(driverObj.currentlatitude)
			driverData['longitude']=str(driverObj.currentlongitude)
			response['data']=driverData
			response['status_code']=200
			response['status_message']='Driver data'
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class addDriverRatings(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:

			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			
			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Invalid access key'
				return Response(response)
			
			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='driverID required'
				return Response(response)
			if not data.get('review'):
				response['status_code']=400
				response['status_message']='review required'
				return Response(response)
			if not data.get('rating'):
				response['status_code']=400
				response['status_message']='rating required'
				return Response(response)
			
			if not data.get('customerID'):
				response['status_code']=400
				response['status_message']='customerID required'
				return Response(response)
			
			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID required'
				return Response(response)

			driverData={}

			driverObj = driver.objects.filter(userUniqueID=data.get('driverID')).first()
			if not driverObj:
				response['status_code']=400
				response['status_message']='Invalid driver id'
				return Response(response)
			
			totalRates=totalratings.objects.filter(driver=driverObj).first()
			if not totalRates:
				totalRates=totalratings.objects.create(driver=driverObj)
			theTotalCount=int(totalRates.totalCount)+1
			totalRates.totalCount=theTotalCount
			allRates=float(totalRates.totalRatingNumbers)+float(data.get('rating'))
			totalRates.totalRatingNumbers=allRates
			averageRate=float(allRates)/float(theTotalCount)
			totalRates.averageRating=averageRate
			totalRates.save()
			theRate=ratings.objects.create(driver=driverObj)
			theRate.totalratings=totalRates
			theRate.rating=float(data.get('rating'))
			theRate.review=data.get('review')
			theRate.customerID=data.get('customerID')
			theRate.orderID=data.get('orderID')
			theRate.save()
			response['status_code']=200
			response['status_message']='Rating added successfully'
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)