from django.db import models

class storenew(models.Model):
	token = models.CharField(max_length = 50, null = True, blank = True)
	userTableID = models.CharField(max_length = 10, null = True, blank = True)
	userUniqueID = models.CharField(max_length = 25, null = True, blank = True)
	name = models.CharField(max_length = 20, null = True, blank = True)
	email = models.CharField(max_length = 30, unique = True, null = True, blank = True)
	countrycode = models.CharField(max_length = 10, null = True, blank = True)
	phone = models.CharField(max_length = 15, blank = True, null = True)
	image = models.FileField(upload_to='Profile', blank = True, null = True)
	state = models.CharField(max_length = 20, blank = True, null = True)
	companyID = models.CharField(max_length = 25, null = True, blank = True)
	fbURL = models.CharField(max_length = 50, blank = True, null = True)
	instaURL = models.CharField(max_length = 50, blank = True, null = True)
	webURL = models.CharField(max_length = 50, blank = True, null = True)
	signupOtp = models.CharField(max_length = 100, blank = True, null = True)
	signupOtpVerfied = models.BooleanField(default = False)
	forgotPasswordOTP = models.CharField(max_length=20,blank=True,null=True)
	phoneVerifiedOtp = models.CharField(max_length = 100, blank = True, null = True)
	phoneverified = models.BooleanField(default = False)
	accountverified = models.BooleanField(default = False)
	description = models.TextField(blank = True)
	address = models.TextField(blank = True)
	fcmtoken = models.CharField(max_length = 300, blank = True, null = True,default = '')
	deviceType = models.CharField(max_length = 300, blank = True, null = True,default = '')
	latitude = models.FloatField(max_length = 20, blank = True, null = True)
	longitude = models.FloatField(max_length = 20, blank = True, null = True)
	storerating = models.CharField(max_length = 20, null = True, blank = True,default=0)
	distance = models.FloatField(max_length = 30, null = True, blank = True)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.name)+'-'+str(self.userUniqueID))

class companyaccessnew(models.Model):
	token = models.CharField(max_length = 50, null = True, blank = True)
	def __str__(self):
		return str(str(self.token))

class superadminaccessnew(models.Model):
	theId = models.CharField(max_length = 10,unique = True, null = True, blank = True)
	token = models.CharField(max_length = 50, null = True, blank = True)
	def __str__(self):
		return str(str(self.token))

DOC_TYPES = (
    ('1', "Passport"),
    ('2', "Licence"),
    ('3', "National ID"),
    ('4', "Registration Proof"),
    ('5', "Other"),
)

DOC_STATUS = (
    ('1', "Pending"),
    ('2', "Approved"),
    ('3', "Rejected"),
)

class storedocumentsnew(models.Model):
	doctType = models.CharField(max_length = 20,choices = DOC_TYPES,default = '5')
	userUniqueID = models.CharField(max_length = 20, null = True, blank = True)
	document = models.FileField(upload_to ='Documents', null=True ,blank=True)
	isApproved = models.BooleanField(default = False)
	docStatus = models.CharField(max_length = 20,choices = DOC_STATUS,default = '1')
	rejectReason = models.TextField(blank = True)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.userUniqueID)+' - '+str(self.doctType))

class storetimingsnew(models.Model):
	userUniqueID = models.CharField(max_length = 20, null = True, blank = True)
	openingTime = models.TimeField(null = True,blank = True)
	closingTime = models.TimeField(null = True,blank = True)
	monday = models.BooleanField(default = True)
	tuesday = models.BooleanField(default = True)
	wednesday = models.BooleanField(default = True)
	thursday = models.BooleanField(default = True)
	friday = models.BooleanField(default = True)
	saturday = models.BooleanField(default = True)
	sunday = models.BooleanField(default = True)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.userUniqueID)+'-'+str(self.monday)+'-'+str(self.sunday))

class storetimingsnewupdated(models.Model):
	DAYS_TYPE = (
		('Monday', "Monday"),
		('Tuesday', "Tuesday"),
		('Wednesday', "Wednesday"),
		('Thursday', "Thursday"),
		('Friday', "Friday"),
		('Saturday', "Saturday"),
		('Sunday', "Sunday"),
	)
	userUniqueID = models.CharField(max_length = 20, null = True, blank = True)
	openingTime = models.TimeField(null = True,blank = True)
	closingTime = models.TimeField(null = True,blank = True)
	day = models.CharField(max_length = 20,choices = DAYS_TYPE,default = 'Monday')
	theDaysData = models.TextField(blank = True)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.userUniqueID)+'-'+str(self.isdisabled))

class totalratings(models.Model):
	store= models.ForeignKey(storenew, on_delete=models.CASCADE,default='',null=True)
	totalCount = models.CharField(max_length = 20, null = True, blank = True,default='0')
	totalRatingNumbers = models.CharField(max_length = 20, null = True, blank = True,default='0')
	averageRating = models.CharField(max_length = 20, null = True, blank = True,default='0')
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.store)+' - '+str(self.averageRating))

class ratings(models.Model):
	store= models.ForeignKey(storenew, on_delete=models.CASCADE,default='',null=True)
	totalratings= models.ForeignKey(totalratings, on_delete=models.CASCADE,default='',null=True)
	rating = models.CharField(max_length = 20, null = True, blank = True)
	review = models.TextField(blank = True)
	customerID = models.CharField(max_length = 30, null = True, blank = True)
	orderID = models.CharField(max_length = 30, null = True, blank = True)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.store)+' - '+str(self.rating))

RADIUS_UNIT = (
    ('MILES', "MILES"),
    ('KM', "KM"),
    ('METERS', "METERS"),
)

class storeradius(models.Model):
	radius = models.CharField(max_length = 50, null = True, blank = True)
	unit = models.CharField(max_length = 20,choices = DOC_TYPES,default = 'MILES')
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.radius)+' - '+str(self.unit))

class storenotifications(models.Model):
	store= models.ForeignKey(storenew, on_delete=models.CASCADE,default='',null=True)
	image = models.CharField(max_length = 200, blank = True,default = '')
	userType = models.CharField(max_length = 200, blank = True,default = '')
	notificationType = models.CharField(max_length = 200, blank = True,default = '')
	userID = models.CharField(max_length = 200, blank = True,default = '')
	title = models.CharField(max_length = 50, blank = True,default = '')
	description = models.TextField(null = True, blank = True)
	created_at = models.DateField(auto_now_add = True)
	def __str__(self):
		return str(str(self.title)+'-'+str(self.userID))