from rest_framework import serializers
from .models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token


class GetStoreDataReports(serializers.ModelSerializer):
	timings = serializers.SerializerMethodField(source='get_timings')
	totalRating = serializers.SerializerMethodField(source='get_totalRating')
	registerSince = serializers.SerializerMethodField(source='get_registerSince')
	documents = serializers.SerializerMethodField(source='get_documents')
	image = serializers.SerializerMethodField(source='get_image')
	
	class Meta:
		model = storenew
		fields = ['token','companyID','documents','totalRating','registerSince','userUniqueID','name', 'email','phone','countrycode','image','isdisabled','description','timings','address','latitude','longitude','fbURL','instaURL','webURL']

	def get_timings(self,obj):
		allData={}
		timeObj=storetimingsnewupdated.objects.filter(userUniqueID=obj.userUniqueID).first()
		if timeObj:
			return timeObj.theDaysData
		else:
			return allData
		# allData={}
		# theCompTiming=storetimingsnew.objects.filter(userUniqueID=obj.userUniqueID).first()
		# if theCompTiming:
		# 	theData=GetTimingsData(theCompTiming)
		# 	return theData.data
		# return allData

	def get_image(self,obj):
		if obj.image.name!='':
			theImage=str(obj.image.name)
		else:
			theImage=''
		return theImage

	def get_documents(self,obj):
		allData=[]
		theCompDocs=storedocumentsnew.objects.filter(userUniqueID=obj.userUniqueID)
		for doc in theCompDocs:
			doctType=''
			if doc.doctType == '1':
				doctType='Passport'
			elif doc.doctType == '2':
				doctType='Licence'
			elif doc.doctType == '3':
				doctType='National ID'
			elif doc.doctType == '4':
				doctType='Registration ID'
			elif doc.doctType == '5':
				doctType='Other'
			else:
				doctType='Other'
			theImage=str(doc.document.name)
			allData.append({'id':doc.id,
				            'documentType':doctType,
				            'document':theImage,
				            'isApproved':doc.isApproved,
							'rejectReason':doc.rejectReason,})
		return allData
	def get_totalRating(self,obj):
		return obj.storerating

	def get_registerSince(self,obj):
		return obj.created_at.year


class GetStoreData(serializers.ModelSerializer):
	timings = serializers.SerializerMethodField(source='get_timings')
	totalRating = serializers.SerializerMethodField(source='get_totalRating')
	registerSince = serializers.SerializerMethodField(source='get_registerSince')
	documents = serializers.SerializerMethodField(source='get_documents')
	image = serializers.SerializerMethodField(source='get_image')
	
	class Meta:
		model = storenew
		fields = ['token','documents','totalRating','registerSince','userUniqueID','name', 'email','phone','countrycode','image','isdisabled','description','timings','address','latitude','longitude','fbURL','instaURL','webURL']

	def get_timings(self,obj):
		allData={}
		timeObj=storetimingsnewupdated.objects.filter(userUniqueID=obj.userUniqueID).first()
		if timeObj:
			return timeObj.theDaysData
		else:
			return allData
		# allData={}
		# theCompTiming=storetimingsnew.objects.filter(userUniqueID=obj.userUniqueID).first()
		# if theCompTiming:
		# 	theData=GetTimingsData(theCompTiming)
		# 	return theData.data
		# return allData

	def get_image(self,obj):
		if obj.image.name!='':
			theImage=str(obj.image.name)
		else:
			theImage=''
		return theImage

	def get_documents(self,obj):
		allData=[]
		theCompDocs=storedocumentsnew.objects.filter(userUniqueID=obj.userUniqueID)
		for doc in theCompDocs:
			doctType=''
			if doc.doctType == '1':
				doctType='Passport'
			elif doc.doctType == '2':
				doctType='Licence'
			elif doc.doctType == '3':
				doctType='National ID'
			elif doc.doctType == '4':
				doctType='Registration ID'
			elif doc.doctType == '5':
				doctType='Other'
			else:
				doctType='Other'
			theImage=str(doc.document.name)
			allData.append({'id':doc.id,
				            'documentType':doctType,
				            'document':theImage,
				            'isApproved':doc.isApproved,
							'rejectReason':doc.rejectReason,})
		return allData
	def get_totalRating(self,obj):
		return obj.storerating

	def get_registerSince(self,obj):
		return obj.created_at.year

	


class GetStoreDetails(serializers.ModelSerializer):

	# timings =  serializers.SerializerMethodField(source='get_timings')

	class Meta:
		model = storenew
		fields = ['name', 'email','phone','image','countrycode','fbURL','instaURL','storerating']

	# def get_timings(self, obj):
	# 	theTimeObj=storetimingsnew.objects.filter(userUniqueID=obj.userUniqueID).first()
	# 	theTimingData=GetStoreTimings(theTimeObj)
	# 	return theTimingData.data

class GetTimingsData(serializers.ModelSerializer):
	class Meta:
		model = storetimingsnew
		fields = ['openingTime', 'closingTime', 'monday','tuesday','wednesday','thursday','friday','saturday','sunday']