from requests import api
from rest_framework.views import APIView
from rest_framework.response import Response
from django.contrib.auth import login,authenticate
from .models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from .serializers import *
import datetime
from django.template.loader import render_to_string
from django.core.mail import EmailMessage
import math, random, datetime, pytz, string
from django.core.files.storage import FileSystemStorage
from django.conf import settings
import requests


import boto
import boto.exception
import boto.sns
import pprint
import re

def GernateOTP():
	digits = "0123456789"
	OTP = ""
	for i in range(4) :
		OTP += digits[math.floor(random.random() * 10)]
	return OTP

def randomStringFunction():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(8)))
	str1 += ''.join((random.choice(string.digits) for x in range(4)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

def randomStringFunctionForImage():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(8)))
	str1 += ''.join((random.choice(string.digits) for x in range(4)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

# def uploadDocumentImages(image,thePath):
# 	import os
# 	fullPath='media/'+str(thePath)
# 	fs = FileSystemStorage(location=fullPath)
# 	beforename = os.path.splitext(image.name)[0]
# 	beforename=beforename.replace(' ','')
	
# 	filetype = os.path.splitext(image.name)[1]
# 	theName=randomStringFunctionForImage()
# 	theImageName=str(theName)+str(filetype)
# 	filename = fs.save(theImageName, image)
# 	return str(fullPath)+'/'+filename

def uploadDocumentImages(image,thePath):
	import os
	import boto3
	from botocore.exceptions import NoCredentialsError
	try:
		bucket=str(settings.AWS_BUCKET_NAME)
		thePath=thePath.lower()
		ACCESS_KEY=str(settings.AWS_ACCESS_KEY_ID)
		SECRET_KEY=str(settings.AWS_SECRET_ACCESS_KEY)
		s3 = boto3.client('s3', aws_access_key_id=ACCESS_KEY,
					  aws_secret_access_key=SECRET_KEY)
		try:
			filetype = os.path.splitext(image.name)[1]
			imageName=randomStringFunctionForImage()
			thePath=thePath+'/'+imageName+filetype
			thePath=str(thePath)
			theFile=s3.upload_fileobj(image,bucket,thePath)
			print("Upload Successful")
			filename=str(settings.AWS_BUCKET_URL_1)+str(bucket)+str(settings.AWS_BUCKET_URL_2)+thePath
			return filename
		except FileNotFoundError as e:
			print("The file was not found")
			return ''
		except NoCredentialsError:
			print("Credentials not available")
			return ''
	except Exception as e:
		print(e)
		return ''

class getCompanyList(APIView):
	def get(self, request):
		response={}
		try:
			url = str(settings.COMPANY_ACCESS_URL)+"company/backend/getCompanies/"
			headers = {
			'Authorization': 'Token '+str(settings.COMPANY_ACCESS_KEY)+'',
			}
			r = requests.request("POST", url, headers=headers)
			print(r)
			return Response(r.json())
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class register(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data = request.data
			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)

			if not data.get('phone'):
				response['status_code']=400
				response['status_message']='Phone required'
				return Response(response)

			if not data.get('password'):
				response['status_code']=400
				response['status_message']='Password required'
				return Response(response)

			if not data.get('companyID'):
				response['status_code']=400
				response['status_message']='Company id required'
				return Response(response)

			if not data.get('state'):
				response['status_code']=400
				response['status_message']='State required'
				return Response(response)

			if not data.get('name'):
				response['status_code']=400
				response['status_message']='Name required'
				return Response(response)

			if not data.get('countrycode'):
				response['status_code']=400
				response['status_message']='Country code required'
				return Response(response)


			if not request.FILES.get('passportImage'):
				response['status_code']=400
				response['status_message']='passportImage id required'
				return Response(response)

			if not request.FILES.get('licenceImage'):
				response['status_code']=400
				response['status_message']='licenceImage required'
				return Response(response)

			if not request.FILES.get('nationalID'):
				response['status_code']=400
				response['status_message']='nationalID required'
				return Response(response)

			if not request.FILES.get('registrationProof'):
				response['status_code']=400
				response['status_message']='registrationProof required'
				return Response(response)

			userOBj = User.objects.filter(username = data.get('email')).first()
			if userOBj:
				response['status_code']=400
				response['status_message']='Email already exists.'
				return Response(response)
			phoneExist=storenew.objects.filter(phone = data.get('phone'))
			if phoneExist:
				response['status_code']=400
				response['status_message']='Phone number already exists.'
				return Response(response)
			userOBj = User.objects.create_user(username = data.get('email'), password = data.get('password'))
			otp=GernateOTP()
			userObjId=userOBj.id
			beforeNameOfUser=data.get('name')
			name3Letter=beforeNameOfUser[0:3]
			name3Letter=name3Letter.upper()
			latExt=storenew.objects.all().last()
			if latExt:
				lastId=latExt.userUniqueID
				last5Number=lastId[3:]
				last5Number=int(last5Number)
				new5Number=last5Number+1
				new5Number=str(new5Number)
				new5Number = new5Number.zfill(5)
				theUniqueID=str(name3Letter)+str(new5Number)
			else:
				theUniqueID=str(name3Letter)+str('00001')
			# theUniqueID=randomStringFunction()
			storeObj = storenew.objects.create(companyID=data.get('companyID'),state=data.get('state'),userUniqueID=theUniqueID,userTableID=userObjId, name = data.get('name'), email = data.get('email'), countrycode = data.get('countrycode'), phone = data.get('phone'), signupOtp = otp)
			passportImage=request.FILES.get('passportImage')
			if passportImage:
				filename=uploadDocumentImages(passportImage,'Documents')
				ownerDocs=storedocumentsnew.objects.create(userUniqueID=theUniqueID,document=filename,doctType=1)
			licenceImage=request.FILES.get('licenceImage')
			if licenceImage:
				filename=uploadDocumentImages(licenceImage,'Documents')
				ownerDocs=storedocumentsnew.objects.create(userUniqueID=theUniqueID,document=filename,doctType=2)
			nationalID=request.FILES.get('nationalID')
			if nationalID:
				filename=uploadDocumentImages(nationalID,'Documents')
				ownerDocs=storedocumentsnew.objects.create(userUniqueID=theUniqueID,document=filename,doctType=3)
			registrationProof=request.FILES.get('registrationProof')
			if registrationProof:
				filename=uploadDocumentImages(registrationProof,'Documents')
				ownerDocs=storedocumentsnew.objects.create(userUniqueID=theUniqueID,document=filename,doctType=4)
			theDocuments = request.FILES.getlist("documents")
			if theDocuments:
				for count, image in enumerate(theDocuments):
					filename=uploadDocumentImages(image,'Documents')
					ownerDocs=storedocumentsnew.objects.create(userUniqueID=theUniqueID,document=filename,doctType=5)
			try:
				subject='Signup OTP'
				message = render_to_string('sendStoreSignupOTPMail.html', {
					'otp': otp,
					})
				fromEmail = settings.EMAIL_HOST_USER
				toEmail = data.get('email')
				message = EmailMessage(subject, message, fromEmail, [toEmail])
				message.content_subtype = 'html'
				message.send()
			except Exception as e:
				print(e)
			response['status_code']=200
			response['otp']=otp
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class veifySignupOTP(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		data=request.data
		try:
			if not data.get('otp'):
				response['status_code']=400
				response['status_message']='otp required'
				return Response(response)
			if not data.get('email'):
				if not data.get('phone'):
					response['status_code']=400
					response['status_message']='Phone required'
					return Response(response)
				if not data.get('countrycode'):
					response['status_code']=400
					response['status_message']='countrycode required'
					return Response(response)

				storeVerify = storenew.objects.filter(phone = data.get('phone'), signupOtpVerfied = False,accountverified=False,countrycode=data.get('countrycode'),signupOtp=data.get('otp')).first()
			else:
				storeVerify = storenew.objects.filter(email = data.get('email'), signupOtpVerfied = False,accountverified=False,signupOtp=data.get('otp')).first()
			if not storeVerify:
				response['status_code']=400
				response['status_message']='OTP not matched.'
			else:
				storeVerify.signupOtpVerfied=True
				storeVerify.accountverified=True
				storeVerify.phoneverified=True
				storeVerify.save()
				theStoreSerial = GetStoreData(storeVerify)
				response['status_code']=200
				response['status_message']='Verified.'
				response['data']=theStoreSerial.data
				try:
					subject='Welcome'
					message = render_to_string('sendStoreWelcomeMail.html', {
						'name': storeVerify.name,
						})
					fromEmail = settings.EMAIL_HOST_USER
					toEmail = data.get('email')
					message = EmailMessage(subject, message, fromEmail, [toEmail])
					message.content_subtype = 'html'
					message.send()
				except Exception as e:
					print(e)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class login(APIView):
	def post(self,request,*args,**kwargs):
		response={}
		try:
			data=request.data
			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)
			if not data.get('password'):
				response['status_code']=400
				response['status_message']='Password required'
				return Response(response)
			if not data.get('fcmtoken'):
				fcmtoken=''
			else:
				fcmtoken=data.get('fcmtoken')
			
			if not data.get('deviceType'):
				deviceType=''
			else:
				deviceType=data.get('deviceType')

			user = authenticate(username = data.get('email'), password = data.get('password'))
			if not user:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			storeObject=storenew.objects.filter(userTableID=user.id).first()
			if not storeObject:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			if storeObject.isdisabled==True:
				response['status_code']=400
				response['status_message']='Your account is disabled by company'
				return Response(response)
			token,status = Token.objects.get_or_create(user = user)
			if token:
				token.delete()
			token,status = Token.objects.get_or_create(user = user)
			tokenKey=token.key
			storeObject.token=tokenKey
			storeObject.fcmtoken=fcmtoken
			storeObject.deviceType=deviceType
			storeObject.save()
			from .serializers import GetStoreData
			theData=GetStoreData(storeObject)
			response['status_code']=200
			response['status_message']='Done'
			response['data']=theData.data
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class forgotPassword(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)
			storeOBJ = storenew.objects.filter(email = data.get('email')).first()
			if not storeOBJ:
				response['status_code']=400
				response['status_message']='Email not exist'
				return Response(response)
			OTP=GernateOTP()
			storeOBJ.forgotPasswordOTP=OTP
			storeOBJ.save()
			try:
				subject='Forgot Password'
				message = render_to_string('storeForgotPassword.html', {
					'otp': OTP,
					'name':storeOBJ.name,
				})
				from_email = settings.EMAIL_HOST_USER
				to_email = data.get('email')
				message = EmailMessage(subject, message, from_email, [to_email])
				message.content_subtype = 'html'
				message.send()
			except Exception as e:
				print(e)
			response['status_code']=200
			response['status_message']='OTP send on Your Mail'
			response['OTP']=OTP

		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class forgotPasswordVerifyOtp(APIView):

	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)
			if not data.get('otp'):
				response['status_code']=400
				response['status_message']='OTP required'
				return Response(response)
			response['status_code']=200
			response['status_message']='OTP verified'
			data=request.data
			storeObj = storenew.objects.filter(email = data.get('email'),forgotPasswordOTP=data.get('otp')).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='OTP not matched'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updatePassword(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('email'):
				response['status_code']=400
				response['status_message']='email required'
				return Response(response)
			if not data.get('password'):
				response['status_code']=400
				response['status_message']='password required'
				return Response(response)
			if not data.get('otp'):
				response['status_code']=400
				response['status_message']='OTP required'
				return Response(response)
			storeObj = storenew.objects.filter(email = data.get('email'),forgotPasswordOTP=data.get('otp')).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid OTP'
				return Response(response)
			userObj=User.objects.filter(id=storeObj.userTableID).first()
			userObj.set_password(data.get('password'))
			userObj.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def validateToken(theToken):
	returnId='0'
	tokenOBJ = Token.objects.filter(key = theToken).first()
	if tokenOBJ:
		user = User.objects.get(id = tokenOBJ.user_id)
	if user:
		returnId=user.id
	return returnId

def uploadImage(image):
	fs = FileSystemStorage()
	filename = fs.save(image.name, image)
	filename = fs.url(filename)
	return filename

class getProfile(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			userID=validateToken(session_token)
			if userID == '0':
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			storeObj=storenew.objects.filter(userTableID=userID).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			theData=GetStoreDataReports(storeObj)
			response['status_code']=200
			response['status_message']='Success'
			response['data']=theData.data
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)


class updateProfile(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			userID=validateToken(session_token)
			if userID == '0':
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			storeObj=storenew.objects.filter(userTableID=userID).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			if data.get('name'):
				storeObj.name=data.get('name')
			if data.get('phone'):
				storeObj.phone=data.get('phone')
			if data.get('countrycode'):
				storeObj.countrycode=data.get('countrycode')
			theImage = request.FILES.get("image")
			if theImage:
				filename=uploadDocumentImages(theImage,'Profile')
				storeObj.image=filename
			if data.get('description'):
				storeObj.description=data.get('description')
			if data.get('address'):
				storeObj.address=data.get('address')
			if data.get('latitude'):
				storeObj.latitude=data.get('latitude')
			if data.get('longitude'):
				storeObj.longitude=data.get('longitude')
			storeObj.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class changePassword(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			tokenOBJ = Token.objects.filter(key = session_token).first()
			if not tokenOBJ:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			user = User.objects.get(id = tokenOBJ.user_id)
			if not user:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			userObj = authenticate(username = user.username, password = data.get('oldPassword'))
			userObj.set_password( data.get('newPassword'))
			userObj.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class logout(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			tokenOBJ = Token.objects.filter(key = session_token).first()
			if not tokenOBJ:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)
			userOBJ = User.objects.get(id = tokenOBJ.user_id)
			storeObj = storenew.objects.filter(userTableID = userOBJ.id).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Not a valid User'
			else:
				storeObj.token=''
				storeObj.save()
				userOBJ.auth_token.delete()
				response['status_code']=200
				response['status_message']='Logout'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updateDocuments(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
			userObjId=storeObj.userTableID
			theUniqueID=storeObj.userUniqueID
			passportImage=request.FILES.get('passportImage')
			if passportImage:
				passportImageID=request.POST.get('passportImageID')
				if passportImageID == '0':
					filename=uploadDocumentImages(passportImage,'Documents')
					ownerDocs=storedocumentsnew.objects.create(userUniqueID=theUniqueID,document=filename,doctType='1')
				else:
					filename=uploadDocumentImages(passportImage,'Documents')
					ownerDocs=storedocumentsnew.objects.filter(userUniqueID=theUniqueID,id=passportImageID,doctType='1').first()
					ownerDocs.document=filename
					ownerDocs.docStatus='1'
					ownerDocs.save()
			licenceImage=request.FILES.get('licenceImage')
			if licenceImage:
				licenceImageID=request.POST.get('licenceImageID')
				if licenceImageID == '0':
					filename=uploadDocumentImages(licenceImage,'Documents')
					ownerDocs=storedocumentsnew.objects.create(userUniqueID=theUniqueID,document=filename,doctType='2')
				else:
					filename=uploadDocumentImages(licenceImage,'Documents')
					ownerDocs=storedocumentsnew.objects.filter(userUniqueID=theUniqueID,id=licenceImageID,doctType='2')
					ownerDocs.document=filename
					ownerDocs.docStatus='1'
					ownerDocs.save()
			nationalID=request.FILES.get('nationalID')
			if nationalID:
				nationalProofID=request.POST.get('nationalProofID')
				if nationalProofID == '0':
					filename=uploadDocumentImages(nationalID,'Documents')
					ownerDocs=storedocumentsnew.objects.create(userUniqueID=theUniqueID,document=filename,doctType='3')
				else:
					filename=uploadDocumentImages(nationalID,'Documents')
					ownerDocs=storedocumentsnew.objects.filter(userUniqueID=theUniqueID,id=nationalProofID,doctType='3')
					ownerDocs.document=filename
					ownerDocs.docStatus='1'
					ownerDocs.save()
			registrationProof=request.FILES.get('registrationProof')
			if registrationProof:
				registrationProofID=request.POST.get('registrationProofID')
				if registrationProofID == '0':
					filename=uploadDocumentImages(registrationProof,'Documents')
					ownerDocs=storedocumentsnew.objects.create(userUniqueID=theUniqueID,document=filename,doctType='4')
				else:
					filename=uploadDocumentImages(registrationProof,'Documents')
					ownerDocs=storedocumentsnew.objects.filter(userUniqueID=theUniqueID,id=registrationProofID,doctType='4')
					ownerDocs.document=filename
					ownerDocs.docStatus='1'
					ownerDocs.save()
			theIDS = request.POST.getlist("ids")
			theDocuments = request.FILES.getlist("documents")
			for count, image in enumerate(theDocuments):
				if theIDS[count] == '0':
					filename=uploadDocumentImages(image,'Documents')
					ownerDocs=storedocumentsnew.objects.create(userUniqueID=data.get('companyID'),document=filename,doctType='5')
				else:
					alreadyDoc=storedocumentsnew.objects.filter(userUniqueID=data.get('companyID'),id=theIDS[count]).first()
					if alreadyDoc:
						filename=uploadDocumentImages(image,'Documents')
						alreadyDoc.document=filename
						alreadyDoc.docStatus='1'
						alreadyDoc.save()
			adminBodySend=str(storeObj.name)+' has been updated there documents.'
			adminTypeSend='push'
			adminTitleSend='Documents Updated'
			adminUserID=storeObj.userUniqueID
			companyID=storeObj.companyID
			notifyCompany(adminBodySend,adminTypeSend,'new_payment',adminTitleSend,adminUserID,companyID)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

from getdata.serializers import *
class myStoreDetails(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			userID=validateToken(session_token)
			if userID == '0':
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			storeObj=storenew.objects.filter(userTableID=userID).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			
			theData=GetStoreData(storeObj)
			response['status_code']=200
			response['status_message']='Success'
			response['data']=theData.data
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class addStoreRating(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey is required'
				return Response(response)
			
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required'
				return Response(response)
			
			if not data.get('rating'):
				response['status_code']=400
				response['status_message']='rating required'
				return Response(response)
			
			if not data.get('review'):
				response['status_code']=400
				response['status_message']='review required'
				return Response(response)

			if not data.get('customerID'):
				response['status_code']=400
				response['status_message']='customerID required'
				return Response(response)
			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID required'
				return Response(response)
			
			theStore=storenew.objects.filter(userUniqueID=data.get('storeID')).first()
			if not theStore:
				response['status_code']=400
				response['status_message']='invalid store id.'
				return Response(response)
			
			theRating=ratings.objects.filter(store=theStore,customerID=data.get('customerID'),orderID=data.get('orderID')).first()
			if theRating:
				response['status_code']=400
				response['status_message']='Already rated'
				return Response(response)
			theTotalObject=totalratings.objects.filter(store=theStore).first()
			if not theTotalObject:
				theTotalObject=totalratings.objects.create(store=theStore)
			theRating=ratings.objects.create(store=theStore,customerID=data.get('customerID'))
			customerCount=int(theTotalObject.totalCount)+int('1')
			theTotalObject.totalCount=customerCount
			totalRates=float(theTotalObject.totalRatingNumbers)+float(data.get('rating'))
			theTotalObject.totalRatingNumbers=totalRates
			average=float(totalRates)/float(customerCount)
			theTotalObject.averageRating=average
			theTotalObject.save()
			
			theRating.totalratings=theTotalObject
			theRating.orderID=data.get('orderID')
			theRating.rating=float(data.get('rating'))
			theRating.review=data.get('review')
			theRating.save()
			
			theStore.storerating=float(average)
			theStore.save()
			response['status_code']=200
			response['status_message']='Ratings added successfully'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class checkAuthentication(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=storenew.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Unauthenticated'
				return Response(response)
			response['status_code']=200
			response['status_message']='Authenticated'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

def gernateChatTokenTwilio(identity):
	import twilio
	from twilio.jwt.access_token import AccessToken
	from twilio.jwt.access_token.grants import ChatGrant
	account_sid = str(settings.TWILIO_ACCOUNT_SID)
	api_key = str(settings.TWILIO_API_KEY)
	api_secret = str(settings.TWILIO_API_SECRET)

	# required for Chat grants
	service_sid = str(settings.TWILIO_SERVICE_SID)
	# identity = 'user@example.com'

	# Create access token with credentials
	token = AccessToken(account_sid, api_key, api_secret, identity=identity)

	# Create an Chat grant and add to token
	chat_grant = ChatGrant(service_sid=service_sid)
	token.add_grant(chat_grant)

	# Return token info as JSON
	print(token.to_jwt())
	returnToken=token.to_jwt()

	return returnToken

class gernateTwilioToken(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			userID=validateToken(session_token)
			if userID == '0':
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			storeObj=storenew.objects.filter(userTableID=userID).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			if not data.get('identity'):
				response['status_code']=400
				response['status_message']='identity required'
				return Response(response)
			twilioToken=gernateChatTokenTwilio(data.get('identity'))
			# theData=GetStoreDetails(storeObj)
			response['status_code']=200
			response['status_message']='Success'
			response['twilioToken']=twilioToken
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

def sendPush(listOfDevices, body):
	print("==1==")
	region = [r for r in boto.sns.regions() if r.name==u'us-east-1'][0]
	sns = boto.sns.SNSConnection(
		aws_access_key_id=str(settings.AWS_ACCESS_KEY_ID),
		aws_secret_access_key=str(settings.AWS_SECRET_ACCESS_KEY),
		region=region,
	)
	print("==2==")
	try:
		print("==3==")
		endpoint_response = sns.create_platform_endpoint(
			platform_application_arn='arn:aws:sns:us-east-1:432363816440:app/GCM/Cannabis',
			token=listOfDevices,
		)   
		print("==4==")
		endpoint_arn = endpoint_response['CreatePlatformEndpointResponse']['CreatePlatformEndpointResult']['EndpointArn']
	except boto.exception.BotoServerError as err:
		result_re = re.compile(r'Endpoint(.*)already', re.IGNORECASE)
		result = result_re.search(err.message)
		if result:
			endpoint_arn = result.group(0).replace('Endpoint ','').replace(' already','')
		else:
			raise
	print("ARN:", endpoint_arn)
	publish_result = sns.publish(
		target_arn=endpoint_arn,
		message=json.dumps(body),
		# message_structure='json'
	)
	print("PUBLISH")
	pprint.pprint(publish_result)

def notifyCompany(body,ntype,notifyCheckType,title,theUserID,companyID):
	
	url=str(settings.COMPANY_ACCESS_URL)+'company/auth/adminNotify/'
	# url = "http://18.117.53.164:8001/superadmin/auth/adminNotify/"
	payload={'body':str(body),
	'title':str(title),
	'userID':str(theUserID),
	'userType':'Customer',
	'notifyCheckType':notifyCheckType,
	'type':str(ntype),
	'companyID':str(companyID)}
	response = requests.request("POST", url ,data=payload)
	print(response.text)

def sendCommonGmail(theList,themessage):
	for email in theList:
		try:
			fromEmail = settings.EMAIL_HOST_USER
			message = EmailMessage(themessage['title'], themessage['body'], fromEmail, [email])
			message.content_subtype = 'html'
			message.send()
		except Exception as e:
			print(e)
			
class storeNotify(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			driverOBJ = storenew.objects.all()
			if not data.get('body'):
				body=''
			else:
				body=data.get('body')
			if not data.get('title'):
				title=''
			else:
				title=data.get('title')
			messageBody={}
			messageBody['body']=body
			messageBody['title']=title
			allList=[]
			for d in driverOBJ:
				if d.fcmtoken != '':
					allList.append(d.fcmtoken)
			try:
				print("I am sending push")
				theReturnOfPush=sendPush(allList,messageBody)
				print("Push send done")
				# notifications.objects.create(userType='messageBody['userType']',userID=messageBody['userID'],image=messageBody['data']['image'],title=messageBody['title'],description=messageBody['body'])
			except Exception as e:
				print(e)
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getDashboardData(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			userID=validateToken(session_token)
			if userID == '0':
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			storeObj=storenew.objects.filter(userTableID=userID).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)

			# totalEarning=float(0)
			# theCompanyWalletObject=companywallet.objects.filter(companyID=compObjects.userUniqueID).first()
			# if theCompanyWalletObject:
			# 	totalEarning=float(theCompanyWalletObject.totalearning)
			# 	totalEarning="{:.2f}".format(totalEarning)
			
			totalProducts=0
			try:
				totalProducts=product.objects.filter(storeId=storeObj.userUniqueID).count()
			except Exception as e:
				print(e)

			totalOrders=0
			recentOrders=[]
			try:
				url = str(settings.CUSTOMER_ACCESS_URL)+'customer/order/getTotalOrdersCountForStore/'
				payload={'AccessKey': str(settings.CUSTOMER_ACCESS_KEY),
				         'storeID': str(storeObj.userUniqueID)}
				apiResponse = requests.request("POST", url,data=payload)
				r=apiResponse.json()
				totalOrders=r['count']
				recentOrders=r['recentOrders']
				orderSeries=r['orderSeries']
			except Exception as e:
				print(e)
			
			totalEarning=float(0)
			try:
				print("==2==")
				url = str(settings.COMPANY_ACCESS_URL)+'company/backend/getStoreEarning/'
				print(url)
				payload={'AccessKey': str(settings.COMPANY_ACCESS_KEY),
				         'storeID': str(storeObj.userUniqueID)}
				print("==3==")
				apiResponse = requests.request("POST", url,data=payload)
				print("==4==")
				print(apiResponse)
				r=apiResponse.json()
				print("Response=============>",r)
				totalEarning=r['totalEarning']
				earningSeries=r['earningSeries']
				# recentOrders=r['recentOrders']
			except Exception as e:
				print(e)
			
			response['orderSeries']=orderSeries
			response['earningSeries']=earningSeries
			response['recentOrders']=recentOrders
			response['totalEarning']=totalEarning
			response['totalProducts']=totalProducts
			response['totalOrders']=totalOrders

			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)



class getNotifications(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			userID=validateToken(session_token)
			
			if userID == '0':
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			storeObj=storenew.objects.filter(userTableID=userID).first()
			
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Credentials '
				return Response(response)
			allData=[]
			theNotificationObjects=storenotifications.objects.filter(store=storeObj)
			
			print(theNotificationObjects)
			for notify in theNotificationObjects:
				allData.append({'id':notify.id,
								'title':notify.title,
								'description':notify.description,
								'date':notify.created_at })
			response['status_code']=200
			response['status_message']='Success '
			response['data']=allData
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

#manpreet singh 
# class getNotifications(APIView):
# 	def post(self, request, *args, **kwargs):
# 		response={}
# 		try:
# 			data=request.data
# 			session_token = request.META.get('HTTP_AUTHORIZATION')
# 			if not session_token:
# 				if not data.get('session_token'):
# 					response['status_code']=400
# 					response['status_message']='Session token required'
# 					return Response(response)
# 				else:
# 					session_token=data.get('session_token')
# 			else:
# 				session_token = session_token.replace("Token ", "")
# 			userID=validateToken(session_token)
# 			if userID == '0':
# 				response['status_code']=400
# 				response['status_message']='Invalid Credentials'
# 				return Response(response)
# 			storeObj=storenew.objects.filter(userTableID=userID).first()
# 			if not storeObj:
# 				response['status_code']=400
# 				response['status_message']='Invalid Credentials'
# 				return Response(response)
# 			allData=[]
# 			theNotificationObjects=storenotifications.objects.filter(store=storeObj)
# 			for notify in theNotificationObjects:
# 				allData.append({'id':notify.id,
# 				                'title':notify.title,
# 								'description':notify.description,})
# 			response['status_code']=200
# 			response['status_message']='Success'
# 			response['data']=allData
# 		except Exception as e:
# 			print(e)
# 			response['status_code']=400
# 			response['status_message']=str(e)
# 		return Response(response)

class deleteNotification(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
				
			userID=validateToken(session_token)
			if userID == '0':
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			storeObj=storenew.objects.filter(userTableID=userID).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			if not data.get('id'):
				response['status_code']=400
				response['status_message']='Notification id is required'
				return Response(response)
			theNotificationObjects=storenotifications.objects.filter(id=data.get('id')).first()
			if theNotificationObjects:
				theNotificationObjects.delete()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class deleteNotificationList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
				
			userID=validateToken(session_token)
			if userID == '0':
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			storeObj=storenew.objects.filter(userTableID=userID).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			
			if not data.get('idlist'):
				response['status_code']=400
				response['status_message']='Notification id list is required'
				return Response(response)
			theidLists=data.get('idlist')
			for l in theidLists:
				theNotificationObject=storenotifications.objects.filter(id=l).first()
				if theNotificationObject:
					theNotificationObject.delete()

			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)



#its for filter  date notification
class filterNotifications(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		data = request.data
		try:
			allData=[]
			session_token = request.META.get('HTTP_AUTHORIZATION')
			start_date = data.get('start_date',None)
			end_date = data.get('end_date', None)
			if start_date is not None and start_date != '':
				pass
			else:	
				response['status_code'] = 400
				response['status_message'] = 'start date required'
				return Response(response)
			
			if end_date is None or end_date == '':
				from datetime import timedelta
				end_date = datetime.date.today() + timedelta(days=1)
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			userID=validateToken(session_token)
			compObjects=storenew.objects.filter(userTableID=userID).first()
			if not compObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			
			allNotifications = storenotifications.objects.filter(store=compObjects, created_at__range=(start_date, end_date))
			# allNotifications = companynotifications.objects.filter(companyID=compObjects.userUniqueID, created_at__range=[start_date, end_date])
			# allNotifications = companynotifications.objects.filter(companyID=compObjects.userUniqueID, created_at__range= [start_date, end_date])
			# allNotifications=companynotifications.objects.filter(created_at__gte=start_date, created_at__lte = end_date)
			for n in allNotifications:
				allData.append({'userType':n.userType,
								'notificationType':n.notificationType,
								'id':n.id,
								'userID':n.userID,
								'title':n.title,
								'description':n.description,
								'date':n.created_at,
								})
			response['data']=allData
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)






