from rest_framework import serializers
from base.models import *
from products.models import *
from django.conf import settings


class GetProductData(serializers.ModelSerializer):
	productImage =  serializers.SerializerMethodField(source='get_productImage')
	# productRating =  serializers.SerializerMethodField(source='get_productRating')
	giftData =  serializers.SerializerMethodField(source='get_giftData')

	class Meta:
		model = product
		fields = ['productId','productName', 'productPrice', 'productQuantity','productImage','productDescription','giftData','productRating']

	def get_productImage(self, obj):
		return obj.productImage.name

	def get_productRating(self, obj):
		return '3.5'

	def get_giftData(self, obj):
		theGift=gift.objects.filter(giftId=obj.productGiftID).first()
		theSerialData=GetGiftData(theGift)
		return theSerialData.data

# class GetProductData(serializers.ModelSerializer):
# 	productImage =  serializers.SerializerMethodField(source='get_productImage')
# 	giftData =  serializers.SerializerMethodField(source='get_giftData')
# 	productRating = serializers.SerializerMethodField(source='get_productRating')

# 	class Meta:
# 		model = Product
# 		fields = ['productId','productName', 'productPrice', 'productQuantity','productImage','productDescription','giftData','productRating']

# 	def get_productImage(self, obj):

# 		return str(settings.BASE_URL)+str(obj.productImage.name)

# 	def get_giftData(self, obj):
# 		theGift=Gift.objects.filter(giftId=obj.productGiftID).first()
# 		theSerialData=GetGiftData(theGift)
# 		return theSerialData.data
	
# 	def get_productRating(self, obj):
# 		return '4'

class GetGiftData(serializers.ModelSerializer):
	giftImage =  serializers.SerializerMethodField(source='get_giftImage')
	giftQuantities = serializers.SerializerMethodField(source='get_giftQuantities')

	class Meta:
		model = gift
		fields = ['giftId','giftName', 'giftImage','giftDescription','giftQuantities']

	def get_giftImage(self, obj):
		return str(obj.giftImage.name)

	def get_giftQuantities(self, obj):
		allQuantities=addonquantity.objects.filter(forGift=obj)
		theData=GetQuantitesData(allQuantities,many=True)
		return theData.data

class GetQuantitesData(serializers.ModelSerializer):

	class Meta:
		model = addonquantity
		fields = ['addOnId','addOnWeight','addOnUnit', 'addOnPrice']

# class GetGiftData(serializers.ModelSerializer):
# 	giftImage =  serializers.SerializerMethodField(source='get_giftImage')
	
# 	class Meta:
# 		model = Gift
# 		fields = ['giftId','giftName', 'giftImage', 'giftWeight','giftDescription']

# 	def get_giftImage(self, obj):
# 		return str(obj.giftImage.name)


class GetTimingsData(serializers.ModelSerializer):
	class Meta:
		model = storetimingsnew
		fields = ['openingTime', 'closingTime', 'monday','tuesday','wednesday','thursday','friday','saturday','sunday']
class GetUpdatedTimingsData(serializers.ModelSerializer):
	class Meta:
		model = storetimingsnewupdated
		fields = ['userUniqueID', 'day', 'theDaysData','openingTime','closingTime']
class GetStoreList(serializers.ModelSerializer):
	image = serializers.SerializerMethodField(source='get_image')
	openingTime = serializers.SerializerMethodField(source='get_openingTime')
	closingTime = serializers.SerializerMethodField(source='get_closingTime')
	store_rating = serializers.SerializerMethodField(source='get_store_rating')
	storeID = serializers.SerializerMethodField(source='get_storeID')
	totalRating = serializers.SerializerMethodField(source='get_totalRating')
	registerSince = serializers.SerializerMethodField(source='get_registerSince')

	class Meta:
		model = storenew
		fields = ['companyID','description','totalRating','registerSince','storeID','store_rating','openingTime','closingTime','userUniqueID','name', 'email','phone','countrycode','image','isdisabled','address','latitude','longitude']

	def get_image(self,obj):
		if obj.image.name!='':
			theImage=str(obj.image.name)
		else:
			theImage=''
		return theImage

	def get_openingTime(self,obj):
		time=''
		theCompTiming=storetimingsnew.objects.filter(userUniqueID=obj.userUniqueID).first()
		if theCompTiming:
			time=theCompTiming.openingTime
		return time

	def get_closingTime(self,obj):
		time=''
		theCompTiming=storetimingsnew.objects.filter(userUniqueID=obj.userUniqueID).first()
		if theCompTiming:
			time=theCompTiming.closingTime
		return time

	def get_store_rating(self,obj):
		store = float(obj.storerating)
		storeRating = str("{:.1f}".format(store))
		return storeRating

	def get_storeID(self,obj):
		return obj.userUniqueID
	def get_totalRating(self,obj):
		total = float(obj.storerating)
		totalRating = str("{:.1f}".format(total))
		return totalRating

	def get_registerSince(self,obj):
		return obj.created_at.year

class GetSpecialStoreListForCustomer(serializers.ModelSerializer):
	image = serializers.SerializerMethodField(source='get_image')
	timings = serializers.SerializerMethodField(source='get_timings')
	openingTime = serializers.SerializerMethodField(source='get_openingTime')
	closingTime = serializers.SerializerMethodField(source='get_closingTime')
	store_rating = serializers.SerializerMethodField(source='get_store_rating')
	storeID = serializers.SerializerMethodField(source='get_storeID')
	totalRating = serializers.SerializerMethodField(source='get_totalRating')
	registerSince = serializers.SerializerMethodField(source='get_registerSince')

	class Meta:
		model = storenew
		fields = ['companyID','description','totalRating','registerSince','storeID','store_rating','openingTime','closingTime','timings','userUniqueID','name', 'email','phone','countrycode','image','isdisabled','address','latitude','longitude']

	
	def get_image(self,obj):
		if obj.image.name!='':
			theImage=str(obj.image.name)
		else:
			theImage=''
		return theImage

	def get_timings(self,obj):
		allData={}
		theCompTiming=storetimingsnewupdated.objects.filter(userUniqueID=obj.userUniqueID).first()
		# if theCompTiming:
		# 	theData=GetUpdatedTimingsData(theCompTiming)
		# 	return theData.data
		import json
		if theCompTiming:
			theData=GetUpdatedTimingsData(theCompTiming).data
			alldata = theData['theDaysData']
			print('alldata',alldata)
			jsonData = json.loads(alldata)
			print('jsonData',jsonData)
			return jsonData
		return allData


	def get_openingTime(self,obj):
		time=''
		theCompTiming=storetimingsnew.objects.filter(userUniqueID=obj.userUniqueID).first()
		if theCompTiming:
			time=str(theCompTiming.openingTime)
			from datetime import datetime
			d = datetime.strptime(time, "%H:%M:%S")
			time=d.strftime("%I:%M %p")
		return time

	def get_closingTime(self,obj):
		time=''
		theCompTiming=storetimingsnew.objects.filter(userUniqueID=obj.userUniqueID).first()
		if theCompTiming:
			time=str(theCompTiming.closingTime)
			from datetime import datetime
			d = datetime.strptime(time, "%H:%M:%S")
			time=d.strftime("%I:%M %p")
		return time

	def get_store_rating(self,obj):
		store = float(obj.storerating)
		storeRating = str("{:.1f}".format(store))
		return storeRating

	def get_storeID(self,obj):
		return obj.userUniqueID
	def get_totalRating(self,obj):
		total = float(obj.storerating)
		totalRating = str("{:.1f}".format(total))
		return totalRating

	def get_registerSince(self,obj):
		return obj.created_at.year

class GetStoreData(serializers.ModelSerializer):
	timings = serializers.SerializerMethodField(source='get_timings')
	totalRating = serializers.SerializerMethodField(source='get_totalRating')
	registerSince = serializers.SerializerMethodField(source='get_registerSince')
	documents = serializers.SerializerMethodField(source='get_documents')
	image = serializers.SerializerMethodField(source='get_image')
	openingTime = serializers.SerializerMethodField(source='get_openingTime')
	closingTime = serializers.SerializerMethodField(source='get_closingTime')
	
	class Meta:
		model = storenew
		fields = ['documents','openingTime','closingTime','totalRating','registerSince','userUniqueID','name', 'email','phone','countrycode','image','isdisabled','description','timings','address','latitude','longitude','fbURL','instaURL','webURL']

	# def get_timings(self,obj):
	# 	allData={}
	# 	theCompTiming=storetimingsnew.objects.filter(userUniqueID=obj.userUniqueID).first()
	# 	if theCompTiming:
	# 		theData=GetTimingsData(theCompTiming)
	# 		return theData.data
	# 	return allData

	def get_timings(self,obj):
		allData={}
		theCompTiming=storetimingsnewupdated.objects.filter(userUniqueID=obj.userUniqueID).first()
		# if theCompTiming:
		# 	theData=GetUpdatedTimingsData(theCompTiming)
		# 	return theData.data
		import json
		if theCompTiming:
			theData=GetUpdatedTimingsData(theCompTiming).data
			alldata = theData['theDaysData']
			print('alldata',alldata)
			jsonData = json.loads(alldata)
			print('jsonData',jsonData)
			return jsonData
			# allData.append(jsonData)
			# print('allData',allData)
		return allData

	def get_image(self,obj):
		if obj.image.name!='':
			theImage=str(obj.image.name)
		else:
			theImage=''
		return theImage

	def get_documents(self,obj):
		allData=[]
		theCompDocs=storedocumentsnew.objects.filter(userUniqueID=obj.userUniqueID)
		for doc in theCompDocs:
			doctType=''
			if doc.doctType == '1':
				doctType='Passport'
			elif doc.doctType == '2':
				doctType='Licence'
			elif doc.doctType == '3':
				doctType='National ID'
			elif doc.doctType == '4':
				doctType='Registration ID'
			elif doc.doctType == '5':
				doctType='Other'
			else:
				doctType='Other'
			theImage=str(doc.document.name)
			allData.append({'id':doc.id,
			                'docStatus':doc.docStatus,
				            'documentType':doctType,
				            'document':theImage,
				            'isApproved':doc.isApproved,
							'rejectReason':doc.rejectReason,})
		return allData
	def get_totalRating(self,obj):
		return obj.storerating

	def get_registerSince(self,obj):
		return obj.created_at.year
	def get_openingTime(self,obj):
		time=''
		theCompTiming=storetimingsnew.objects.filter(userUniqueID=obj.userUniqueID).first()
		if theCompTiming:
			time=theCompTiming.openingTime
		return time

	def get_closingTime(self,obj):
		time=''
		theCompTiming=storetimingsnew.objects.filter(userUniqueID=obj.userUniqueID).first()
		if theCompTiming:
			time=theCompTiming.closingTime
		return time