from re import search
from rest_framework.views import APIView
from rest_framework.response import Response
import random,string,math
from django.template.loader import render_to_string
from django.core.mail import EmailMessage
from django.contrib.auth.models import User
from base.models import *
from .serializers import *
from django.conf import settings
from django.db.models import Q
from rest_framework.pagination import PageNumberPagination
import requests
class getStoreListByCustomer(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=401
				response['status_message']='AccessKey required.'
				return Response(response,status=401)
			if not data.get('latitude'):
				response['status_code']=400
				response['status_message']='latitude required.'
				return Response(response,status=400)
			if not data.get('longitude'):
				response['status_code']=400
				response['status_message']='longitude required.'
				return Response(response,status=400)
			if not data.get('page'):
				response['status_code']=400
				response['status_message']='page required.'
				return Response(response)
			# if not data.get('search'):
			# 	search=''
			# else:
			# 	search=data.get('search')

			# print("data.get('AccessKey')",data.get('AccessKey'))
			# print("str(settings.MY_ACCESS_KEY",str(settings.MY_ACCESS_KEY))
			pageNo=data.get('page')
			pageNo=int(pageNo)
			startPage=0
			endPage=int(settings.PAGE_LIMIT)
			for r in range(1,pageNo):
				startPage=startPage+int(settings.PAGE_LIMIT)
				endPage=endPage+int(settings.PAGE_LIMIT)
			print("startPage",startPage)
			print("endPage",endPage)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=401
				response['status_message']='You dont have access.'
				return Response(response,status=401)
			try:
				queryset=[]
				lat=data.get('latitude')
				lng=data.get('longitude')
				theRadiusObjects=storeradius.objects.all().last()
				distanceInMiles=1
				if theRadiusObjects:
					distanceInMiles=int(theRadiusObjects.radius)
				print(lat)
				print(lng)
				# 3959 is for miles
				# query = """SELECT * FROM (SELECT id, name, phone, (3959 * acos(cos(radians(28.5)) * cos(radians(latitude)) * cos(radians(longitude) - radians(-81.37)) + sin(radians(28.5)) * sin(radians(latitude)))) AS distance FROM baseapp_storenew) AS distances WHERE distance < 50 ORDER BY distance OFFSET 0 LIMIT 20;"""
				
				
				
				if data.get('ratingStart'):
					if data.get('ratingStart')!='':
						ratingStart=data.get('ratingStart')
					else:
						ratingStart=''
				else:
					ratingStart=''
				
				if data.get('ratingEnd'):
					if data.get('ratingEnd')!='':
						ratingEnd=data.get('ratingEnd')
					else:
						ratingEnd=''
				else:
					ratingEnd=''
				
				
				if not data.get('search'):
					print("search is none")
					query = "SELECT * FROM (SELECT id, name, phone, (3959 * acos(cos(radians("+str(lat)+")) * cos(radians(latitude)) * cos(radians(longitude) - radians("+str(lng)+")) + sin(radians("+str(lat)+")) * sin(radians(latitude)))) AS distance FROM base_storenew) AS distances WHERE distance < "+str(distanceInMiles)+" ORDER BY distance OFFSET 0 LIMIT 20;"
				else:
					if data.get('search')!='':
						print("search is ",data.get('search'))
						search=data.get('search')
						# query = "SELECT * FROM (SELECT id, name, phone, (3959 * acos(cos(radians("+str(lat)+")) * cos(radians(latitude)) * cos(radians(longitude) - radians("+str(lng)+")) + sin(radians("+str(lat)+")) * sin(radians(latitude)))) AS distance FROM baseapp_storenew) AS distances WHERE distance < "+str(distanceInMiles)+" AND name LIKE "+str(search)+" ORDER BY distance OFFSET 0 LIMIT 20;"
						query = "SELECT * FROM (SELECT id, name, phone, (3959 * acos(cos(radians("+str(lat)+")) * cos(radians(latitude)) * cos(radians(longitude) - radians("+str(lng)+")) + sin(radians("+str(lat)+")) * sin(radians(latitude)))) AS distance FROM base_storenew) AS distances WHERE distance < "+str(distanceInMiles)+" AND LOWER(name) ~ LOWER('"+str(search)+"') ORDER BY distance OFFSET 0 LIMIT 20;"
					else:
						print("search is empty")
						query = "SELECT * FROM (SELECT id, name, phone, (3959 * acos(cos(radians("+str(lat)+")) * cos(radians(latitude)) * cos(radians(longitude) - radians("+str(lng)+")) + sin(radians("+str(lat)+")) * sin(radians(latitude)))) AS distance FROM base_storenew) AS distances WHERE distance < "+str(distanceInMiles)+" ORDER BY distance OFFSET 0 LIMIT 20;"
				
				queryset = storenew.objects.raw(query)
				print('queryset',queryset)
				allStoreListData=[]
				if ratingStart!='' and ratingEnd!='':
					for i in queryset:
						ratingStart=float(ratingStart)
						print('ratingStart',ratingStart)
						ratingEnd=float(ratingEnd)
						print('ratingEnd',ratingEnd)
						print("ratinf start",ratingStart)
						print("ratingEnd",ratingEnd)
						print("storeRating",i.storerating)
						if ratingStart<=float(i.storerating) and ratingEnd>=float(i.storerating):
							if i.isdisabled==False:
								allStoreListData.append(i)
					print(allStoreListData)
					# allStoreData=GetStoreList(allStoreListData,many=True)
					# response['data']=allStoreData.data
				else:
					allStoreListData=[i for i in queryset]
					# allStoreData=GetStoreList(allStoreListData,many=True)
				# paginator = PageNumberPagination()
				# paginator.page_size = 2
				# result_page = paginator.paginate_queryset(allStoreListData, request)
				# serializer = GetStoreList(result_page, many=True)
				# print(serializer.data)
				# print((serializer.data))
				# return paginator.get_paginated_response(serializer.data)
				# allStoreListData=allStoreListData[startPage:endPage]
				totalRecords=len(allStoreListData)
				previousRecords=len(allStoreListData[:startPage])
				nextRecords=len(allStoreListData[endPage:])
				if previousRecords==0:
					hasPreviousPage=False
				else:
					hasPreviousPage=True
				if nextRecords==0:
					hasNextPage=False
				else:
					hasNextPage=True
				allStoreListData=allStoreListData[startPage:endPage]
				allStoreData=GetStoreList(allStoreListData,many=True)
				response['data']=allStoreData.data
				response['hasNextPage']=hasNextPage
				response['hasPreviousPage']=hasPreviousPage
				response['totalRecords']=totalRecords
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response,status=500)
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response,status=500)

class getStoreByCustomer(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=401
				response['status_message']='AccessKey required.'
				return Response(response,status=401)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required.'
				return Response(response,status=400)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=401
				response['status_message']='You dont have access.'
				return Response(response,status=401)
			try:
				queryset = storenew.objects.filter(userUniqueID=data.get('storeID')).first()
				allStoreData=GetSpecialStoreListForCustomer(queryset)
				response['data']=allStoreData.data
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response,status=500)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response,status=500)
		return Response(response)


class getStoreList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")
			theAccess=companyaccessnew.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=401
				response['status_message']='You dont have access.'
				return Response(response,status=401)
			if not data.get('companyID'):
				response['status_code']=400
				response['status_message']='companyID required'
				return Response(response)
			# if not data.get('pageIndex'):
			# 	response['status_code']=400
			# 	response['status_message']='pageIndex required.'
			# 	return Response(response)
			# if not data.get('pageSize'):
			# 	response['status_code']=400
			# 	response['status_message']='pageSize required.'
			# 	return Response(response)


			# pageNo=data.get('pageIndex')
			# pagedata=data.get('pageSize')
			# pageNo=int(pageNo)
			# pagedata=int(pagedata)
			# startPage=0
			# print("startPage",startPage)
			
			# allStoreObject = storenew.objects.filter(companyID=data.get('companyID'))
			
			if not data.get('search') or data.get('search')=='':
				
				if not data.get('status'):
					allStoreObject = storenew.objects.filter(companyID=data.get('companyID'))
				elif data.get('status')=='active':
					allStoreObject = storenew.objects.filter(companyID=data.get('companyID'),isdisabled=False)
				elif data.get('status')=='inactive':
					allStoreObject = storenew.objects.filter(companyID=data.get('companyID'),isdisabled=True)
				else:
					allStoreObject = storenew.objects.filter(companyID=data.get('companyID'))
			else:
				search=data.get('search')
				search=search.lower()
				if not data.get('status'):
					allStoreObject = storenew.objects.filter(companyID=data.get('companyID'),name__icontains=search)
				elif data.get('status')=='active':
					allStoreObject = storenew.objects.filter(companyID=data.get('companyID'),name__icontains=search,isdisabled=False)
				elif data.get('status')=='inactive':
					allStoreObject = storenew.objects.filter(companyID=data.get('companyID'),name__icontains=search,isdisabled=True)
				else:
					allStoreObject = storenew.objects.filter(companyID=data.get('companyID'),name__icontains=search)
			# allStoreObject = storenew.objects.all()
			# print('helooo')
			# totalRecords=len(allStoreObject)
			# print('totalRecords',totalRecords)
			# previousRecords=len(allStoreObject[:pageNo])
			# print('previousRecords',previousRecords)
			# allStoreObject=allStoreObject[startPage:pagedata]
			# print('allStoreObject',allStoreObject)
			# teamsData=GetStoreList(allStoreObject,many=True)
			# print('teamsData',teamsData)
			#old
			teamsData=GetStoreList(allStoreObject,many=True)
			response['data']=teamsData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response,status=500)
		return Response(response)

class getStoreByCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			theAccess=companyaccessnew.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=401
				response['status_message']='You dont have access.'
				return Response(response,status=401)
			allStoreObject = storenew.objects.filter(companyID=data.get('companyID'))
			teamsData=GetStoreList(allStoreObject,many=True)
			response['data']=teamsData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response,status=500)
		return Response(response)


class getStore(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")
			theAccess=companyaccessnew.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			storeObject = storenew.objects.filter(userUniqueID=data.get('storeID')).first()
			if not storeObject:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			teamData=GetStoreData(storeObject)
			response['data']=teamData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getProductListByCustomer(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=401
				response['status_message']='AccessKey required.'
				return Response(response,status=401)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required.'
				return Response(response,status=400)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=401
				response['status_message']='You dont have access.'
				return Response(response,status=401)
			storeObject = storenew.objects.filter(userUniqueID=data.get('storeID')).first()
			if storeObject:
				teamData=GetStoreData(storeObject)
				response['storeData']=teamData.data
			if not data.get('search'):
				allProducts=product.objects.filter(storeId=data.get('storeID'),isdeleted=False,isdisabled=False)
			else:
				if data.get('search')=='':
					allProducts=product.objects.filter(storeId=data.get('storeID'),isdeleted=False,isdisabled=False)
				else:
					allProducts=product.objects.filter(storeId=data.get('storeID'),productName__icontains=data.get('search'),isdeleted=False,isdisabled=False)
			if allProducts:
				theSerialData=GetProductData(allProducts,many=True)
				response['productData']=theSerialData.data
				response['status_code']=200
				response['status_message']='Success'
			else:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response,status=500)
		return Response(response)

class getProductByCustomer(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=401
				response['status_message']='AccessKey required.'
				return Response(response,status=401)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required.'
				return Response(response,status=400)
			if not data.get('productId'):
				response['status_code']=400
				response['status_message']='productId required'
				return Response(response,status=400)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=401
				response['status_message']='You dont have access.'
				return Response(response,status=401)
			
			allProducts=product.objects.filter(storeId=data.get('storeID'),productId=data.get('productId'),isdeleted=False).first()
			if allProducts:
				theSerialData=GetProductData(allProducts)
				response['data']=theSerialData.data
				response['status_code']=200
				response['status_message']='Success'
			else:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response,status=400)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response,status=500)
		return Response(response)

class getProductByCustomerForOneOrderDetails(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			finalData=[]
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=401
				response['status_message']='AccessKey required.'
				return Response(response,status=401)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required.'
				return Response(response,status=400)
			if not data.get('productId'):
				response['status_code']=400
				response['status_message']='productId required'
				return Response(response,status=400)
			if not data.get('orderCount'):
				response['status_code']=400
				response['status_message']='orderCount required'
				return Response(response,status=400)
			if not data.get('orderTotal'):
				response['status_code']=400
				response['status_message']='orderTotal required'
				return Response(response,status=400)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=401
				response['status_message']='You dont have access.'
				return Response(response,status=401)
			
			allProducts=product.objects.filter(storeId=data.get('storeID'),productId=data.get('productId'),isdeleted=False).first()
			if allProducts:
				theSerialData=GetProductData(allProducts)
				finalData.append({'innerData':theSerialData.data,
				                  'orderTotal':data.get('orderTotal'),
								  'orderCount':data.get('orderCount'),})
				# response['data']=theSerialData.data
				response['data']=finalData
				response['status_code']=200
				response['status_message']='Success'
			else:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response,status=400)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response,status=500)
		return Response(response)

class getStoreListByAdmin(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			theAccess=superadminaccessnew.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=401
				response['status_message']='You dont have access.'
				return Response(response,status=401)
			if not data.get('companyID'):
				response['status_code']=400
				response['status_message']='companyID required'
				return Response(response)
			allStoreObject = storenew.objects.filter(companyID=data.get('companyID'))
			teamsData=GetStoreList(allStoreObject,many=True)
			response['data']=teamsData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response,status=500)
		return Response(response)

class getStoreOrders(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required1'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required'
				return Response(response)
			theAccess=companyaccessnew.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			storeObject = storenew.objects.filter(userUniqueID=data.get('storeID')).first()
			if not storeObject:
				response['status_code']=400
				response['status_message']='Invalid store id'
				return Response(response)
			try:
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/order/getStoreOrdersForCompany/"
				payload={'AccessKey': str(settings.CUSTOMER_ACCESS_KEY),'storeID': data.get('storeID')}
				res = requests.request("POST", url,data=payload)
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class getProductDetailsForCart(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			finalData=[]
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=401
				response['status_message']='AccessKey required.'
				return Response(response,status=401)
			# if not data.get('storeID'):
			# 	response['status_code']=400
			# 	response['status_message']='storeID required.'
			# 	return Response(response,status=400)
			if not data.get('productId'):
				response['status_code']=400
				response['status_message']='productId required'
				return Response(response,status=400)
			if not data.get('itemCount'):
				response['status_code']=400
				response['status_message']='itemCount required'
				return Response(response,status=400)
			if not data.get('itemAddOnId'):
				response['status_code']=400
				response['status_message']='itemAddOnId required'
				return Response(response,status=400)
			if not data.get('itemServiceTotal'):
				response['status_code']=400
				response['status_message']='itemServiceTotal required'
				return Response(response,status=400)
			# if not data.get('orderCount'):
			# 	response['status_code']=400
			# 	response['status_message']='orderCount required'
			# 	return Response(response,status=400)
			# if not data.get('orderTotal'):
			# 	response['status_code']=400
			# 	response['status_message']='orderTotal required'
			# 	return Response(response,status=400)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=401
				response['status_message']='You dont have access.'
				return Response(response,status=401)
			
			theProduct=product.objects.filter(productId=data.get('productId'),isdeleted=False).first()
			
			if theProduct:
				theSerialData=GetProductData(theProduct)
				theSerialDataList=theSerialData.data
				theSerialDataList['itemCount']=data.get('itemCount')
				theSerialDataList['itemAddOnId']=data.get('itemAddOnId')
				theSerialDataList['itemServiceTotal']=data.get('itemServiceTotal')

				# finalData.append(theSerialDataList)
				# response['data']=theSerialData.data
				response['data']=theSerialDataList
				response['status_code']=200
				response['status_message']='Success'
			else:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response,status=400)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response,status=500)
		return Response(response)


class getTotalStoreCountForCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=401
				response['status_message']='AccessKey required.'
				return Response(response,status=401)
			if not data.get('companyId'):
				response['status_code']=400
				response['status_message']='companyId required.'
				return Response(response,status=400)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=401
				response['status_message']='You dont have access.'
				return Response(response,status=401)
			theCount = storenew.objects.filter(companyID=data.get('companyId')).count()
			response['status_code']=200
			response['status_message']='Success'
			response['count']=theCount
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response,status=500)
		return Response(response)

def randomStringFunctionForImage():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(10)))
	str1 += ''.join((random.choice(string.digits) for x in range(6)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

def createCSVStores(allStores):
	import csv
	rows=[]
	fields = ['Id', 'Name', 'Email', 'Phone', 'Opening Time', 'Closing Time', 'Total Rating', 'Company Id', 'Status']
	for store in allStores:
		innerRow=[]
		innerRow.append(store['userUniqueID'])
		innerRow.append(store['name'])
		innerRow.append(store['email'])
		tempPhone=str(store['countrycode'])+str(store['phone']) 
		innerRow.append(tempPhone) 
		innerRow.append(store['openingTime'])
		innerRow.append(store['closingTime'])
		totalRating=float(store['totalRating'])
		totalRating=int(totalRating)
		innerRow.append(totalRating)
		innerRow.append(store['companyID'])
		if store['isdisabled']==True:
			theStatus='In Active'
		else:
			theStatus='Active'
		innerRow.append(theStatus)
		rows.append(innerRow)
	fname=randomStringFunctionForImage()
	filename = "/var/www/html/store/media/Reports/stores_"+str(fname)+".csv"
	url=str(settings.BASE_URL)+"media/Reports/stores_"+str(fname)+".csv"
	with open(filename, 'w') as csvfile:
		csvwriter = csv.writer(csvfile) 
		csvwriter.writerow(fields)
		csvwriter.writerows(rows)
	return url

class getReportStores(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			theAccess=superadminaccessnew.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=401
				response['status_message']='You dont have access.'
				return Response(response,status=401)
			if not data.get('companyType'):
				companyType='All'
			elif data.get('companyType')=='All':
				companyType='All'
			else:
				companyType=data.get('companyType')
			
			if not data.get('filterType'):
				filterType='All'
			elif data.get('filterType')=='All':
				filterType='All'
			else:
				filterType=data.get('filterType')
				if filterType=='Enable':
					filterValue=False
				else:
					filterValue=True
			
			if not data.get('fromDate'):
				response['status_code']=400
				response['status_message']='fromDate is required'
				return Response(response)
			
			if not data.get('toDate'):
				response['status_code']=400
				response['status_message']='toDate is required'
				return Response(response)

			try:
				from datetime import datetime
				dat=data.get('fromDate')
				fromDate=datetime.strptime(dat, "%Y/%m/%d").date()
				dat2=data.get('toDate')
				toDate=datetime.strptime(dat2, "%Y/%m/%d").date()
			except Exception as e:
				print(e)
			
			if companyType=='All':
				if filterType=='All':
					allStoreObject=storenew.objects.filter(Q(created_at__gte=fromDate) & Q(created_at__lte=toDate)).order_by('-id')
				else:
					allStoreObject=storenew.objects.filter(Q(created_at__gte=fromDate) & Q(created_at__lte=toDate) & Q(isdisabled=filterValue)).order_by('-id')
			else:
				if filterType=='All':
					allStoreObject=storenew.objects.filter(Q(companyID=companyType) & Q(created_at__gte=fromDate) & Q(created_at__lte=toDate)).order_by('-id')
				else:
					allStoreObject=storenew.objects.filter(Q(companyID=companyType) &Q(created_at__gte=fromDate) & Q(created_at__lte=toDate) & Q(isdisabled=filterValue)).order_by('-id')
			if not allStoreObject:
				response['status_code']=400
				response['status_message']='No records found'
				return Response(response)
			teamsData=GetStoreList(allStoreObject,many=True)
			downloadLink=createCSVStores(teamsData.data)
			response['downloadLink']=downloadLink
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response,status=500)
		return Response(response)

class getReportStoresForCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:

			data=request.data
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")
			theAccess=companyaccessnew.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=401
				response['status_message']='You dont have access.'
				return Response(response,status=401)
			if not data.get('companyID'):
				response['status_code']=400
				response['status_message']='companyID required'
				return Response(response)

				
			
			# if not data.get('companyType'):
			# 	companyType='All'
			# elif data.get('companyType')=='All':
			# 	companyType='All'
			# else:
			# 	companyType=data.get('companyType')
			
			if not data.get('filterType'):
				filterType='All'
			elif data.get('filterType')=='All':
				filterType='All'
			else:
				filterType=data.get('filterType')
				if filterType=='Enable':
					filterValue=False
				else:
					filterValue=True
			
			if not data.get('fromDate'):
				response['status_code']=400
				response['status_message']='fromDate is required'
				return Response(response)
			
			if not data.get('toDate'):
				response['status_code']=400
				response['status_message']='toDate is required'
				return Response(response)

			try:
				from datetime import datetime
				dat=data.get('fromDate')
				fromDate=datetime.strptime(dat, "%Y/%m/%d").date()
				dat2=data.get('toDate')
				toDate=datetime.strptime(dat2, "%Y/%m/%d").date()
			except Exception as e:
				print(e)
			
			if filterType=='All':
				allStoreObject=storenew.objects.filter(Q(companyID=data.get('companyID')) & Q(created_at__gte=fromDate) & Q(created_at__lte=toDate)).order_by('-id')
			else:
				allStoreObject=storenew.objects.filter(Q(companyID=data.get('companyID')) &Q(created_at__gte=fromDate) & Q(created_at__lte=toDate) & Q(isdisabled=filterValue)).order_by('-id')
			if not allStoreObject:
				response['status_code']=400
				response['status_message']='No records found'
				return Response(response)
			teamsData=GetStoreList(allStoreObject,many=True)
			downloadLink=createCSVStores(teamsData.data)
			response['downloadLink']=downloadLink
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response,status=500)
		return Response(response)