from rest_framework.views import APIView
from rest_framework.response import Response
from django.contrib.auth import login,authenticate
from .models import *
from base.models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
import datetime
from django.template.loader import render_to_string
from django.core.mail import EmailMessage
import math, random, datetime, pytz, string
from django.core.files.storage import FileSystemStorage
from django.conf import settings
from io import BytesIO
from PIL import Image
import json
import requests
from .serializers import *

class getOrderList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)
			payload={}
			payload['AccessKey']=str(settings.CUSTOMER_ACCESS_KEY)
			payload['storeID']=str(storeObj.userUniqueID)
			if data.get('search'):
				payload['search']=data.get('search')
			if data.get('status'):
				payload['status']=data.get('status')
			try:
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/order/getListOfOrdersForCompany/"
				res = requests.request("POST", url,data=payload)
				return Response(res.json())
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)

		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getOrderDetails(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")


			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID required'
				return Response(response)

			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)
			try:
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/order/getOrderDetailsForCompany/"
				payload={
				         'AccessKey': str(settings.CUSTOMER_ACCESS_KEY),
				         'storeID': str(storeObj.userUniqueID),
				         'orderID': data.get('orderID')
				         }
				res = requests.request("POST", url,data=payload)
				return Response(res.json())
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)

		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class acceptRejectOrder(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")


			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID required'
				return Response(response)
			if not data.get('orderStatus'):
				response['status_code']=400
				response['status_message']='orderStatus required'
				return Response(response)

			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)
			if storeObj.image.name!='':
				theImage=str(storeObj.image)
				print('theImage',theImage)
				theImage=theImage.replace('//media','/media')
			else:
				theImage=''
			try:
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/order/acceptRejectOrder/"
				payload={
				         'AccessKey': str(settings.CUSTOMER_ACCESS_KEY),
				         'storeID': str(storeObj.userUniqueID),
				         'orderID': data.get('orderID'),
				         'orderStatus': data.get('orderStatus'),
						 'storeName': storeObj.name,
						 'storeImage': theImage,
				         }
				res = requests.request("POST", url,data=payload)
				return Response(res.json())
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)

		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class assignDriver(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")


			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID required'
				return Response(response)
			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='driverID required'
				return Response(response)

			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)
			if storeObj.image.name!='':
				theImage=str(settings.BASE_URL)+str(storeObj.image)
				theImage=theImage.replace('//media','/media')
			else:
				theImage=''
			try:
				url = str(settings.DRIVER_ACCESS_URL)+"driver/order/bookAssignDriver/"
				payload={
				         'AccessKey': str(settings.DRIVER_ACCESS_KEY),
				         'driverID': data.get('driverID'),
						 'storeName': storeObj.name,
						 'storeImage': theImage,
				         }
				res = requests.request("POST", url,data=payload)
				res=res.json()
				if res['status_code']==200:
					pass
				else:
					return Response(res)
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			theNameOftheDriver=res['driverName']
			theimageOftheDriver=res['driverImage']
			try:
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/order/assignDriver/"
				payload={
				         'AccessKey': str(settings.CUSTOMER_ACCESS_KEY),
				         'storeID': str(storeObj.userUniqueID),
				         'orderID': data.get('orderID'),
				         'driverID': data.get('driverID'),
						 'storeName': storeObj.name,
						 'storeImage': theImage,
						 'driverName': theNameOftheDriver,
						 'driverImage': theimageOftheDriver,
				         }
				res = requests.request("POST", url,data=payload)
				return Response(res.json())
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)

		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getSafePlaces(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthrized'
				return Response(response)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required'
				return Response(response)
			storeObj = storenew.objects.filter(userUniqueID = data.get('storeID')).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid store id'
				return Response(response)
			allSafePlaces = safeplaces.objects.filter(store=storeObj,isdeleted = False)
			theSafeSerial=GetSafeData(allSafePlaces,many=True)
			response['data']=theSafeSerial.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class addSafePlace(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			
			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)
			
			if not data.get('fullAddress'):
				response['status_code']=400
				response['status_message']='fullAddress required'
				return Response(response)
			
			if not data.get('latitude'):
				response['status_code']=400
				response['status_message']='latitude required'
				return Response(response)
			
			if not data.get('longitude'):
				response['status_code']=400
				response['status_message']='longitude required'
				return Response(response)
				
			theSafePlace = safeplaces.objects.create(store=storeObj)
			if theSafePlace:
				theSafePlace.address=data.get('fullAddress')
				theSafePlace.latitude=data.get('latitude')
				theSafePlace.longitude=data.get('longitude')
				theSafePlace.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class getSafePlacesList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			
			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)
				
			allSafePlaces = safeplaces.objects.filter(store=storeObj,isdeleted = False)
			theSafeSerial=GetSafeData(allSafePlaces,many=True)
			response['data']=theSafeSerial.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class deleteSafePlace(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			
			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)
			
			if not data.get('id'):
				response['status_code']=400
				response['status_message']='id required'
				return Response(response)
				
			theSafePlace = safeplaces.objects.filter(store=storeObj,id=data.get('id')).first()
			if theSafePlace:
				theSafePlace.delete()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getTransactionHistoryForCustomer(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthrized'
				return Response(response)
			if not data.get('relatedData'):
				response['status_code']=400
				response['status_message']='relatedData required'
				return Response(response)
			if not data.get('page'):
				response['status_code']=400
				response['status_message']='page required'
				return Response(response)
			relatedData=data.get('relatedData')
			print(relatedData)
			relatedData=str(relatedData)
			print(relatedData)
			relatedData=json.loads(relatedData)
			print(relatedData)
			allData=[]
			for rD in relatedData:
				storeName=''
				storeImage=''
				storeID=rD['storeID']
				amount=rD['amount']
				date=rD['date']
				storeObj = storenew.objects.filter(userUniqueID = storeID).first()
				if storeObj:
					storeName=storeObj.name
					storeImage=storeObj.image.name
				allData.append({'storeName':storeName,
				                'storeImage':storeImage,
								'amount':amount,
								'date':date,})
			pageNo=data.get('page')
			pageNo=int(pageNo)
			startPage=0
			endPage=int(settings.PAGE_LIMIT)
			for r in range(1,pageNo):
				startPage=startPage+int(settings.PAGE_LIMIT)
				endPage=endPage+int(settings.PAGE_LIMIT)
			allData=allData[startPage:endPage]
			totalRecords=len(allData)
			previousRecords=len(allData[:startPage])
			nextRecords=len(allData[endPage:])
			if previousRecords==0:
				hasPreviousPage=False
			else:
				hasPreviousPage=True
			if nextRecords==0:
				hasNextPage=False
			else:
				hasNextPage=True
			response['hasNextPage']=hasNextPage
			response['hasPreviousPage']=hasPreviousPage
			response['totalRecords']=totalRecords
			response['data']=allData
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getStoreNearestDriver(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)
			try:
				url = str(settings.DRIVER_ACCESS_URL)+"driver/auth/getNearbyDrivers/"
				payload={
				         'AccessKey': str(settings.DRIVER_ACCESS_KEY),
				         'latitude': str(storeObj.latitude),
						 'longitude': str(storeObj.longitude)
				         }
				res = requests.request("POST", url,data=payload)
				return Response(res.json())
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)

		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)