from django.db import models

GIFTRELATION = (
    ('1', "Company"),
    ('2', "Store"),
)

class addongroup(models.Model):
	addOnName = models.CharField(max_length = 50, null = True, blank = True)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.addOnName))

class thecategory(models.Model):
	categoryId = models.CharField(max_length = 50, null = True, blank = True)
	categoryName = models.CharField(max_length = 50, null = True, blank = True)
	categoryImage = models.FileField(upload_to='Category', blank = True, null = True)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.categoryName)+'-'+str(self.categoryId))

class gift(models.Model):
	giftRelated = models.CharField(max_length = 20,choices = GIFTRELATION,default = '2')
	categoryId = models.CharField(max_length = 50, null = True, blank = True)
	giftId = models.CharField(max_length = 50, null = True, blank = True)
	giftName = models.CharField(max_length = 50, null = True, blank = True)
	giftImage = models.FileField(upload_to='Gift', blank = True, null = True)
	giftWeight = models.CharField(max_length = 50, null = True, blank = True)
	giftDescription = models.TextField(blank = True)
	storeId = models.CharField(max_length = 50, null = True, blank = True)
	companyId = models.CharField(max_length = 50, null = True, blank = True)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.giftName)+'-'+str(self.giftId))

class addonquantity(models.Model):
	forGift = models.ForeignKey(gift, on_delete=models.CASCADE,default='')
	addOnId = models.CharField(max_length = 50, null = True, blank = True)
	addOnWeight = models.CharField(max_length = 50, null = True, blank = True)
	addOnUnit = models.CharField(max_length = 50, null = True, blank = True)
	addOnPrice = models.CharField(max_length = 50, null = True, blank = True)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.forGift)+' - '+str(self.addOnWeight))

class product(models.Model):
	productRelated = models.CharField(max_length = 20,choices = GIFTRELATION,default = '2')
	storeId = models.CharField(max_length = 50, null = True, blank = True)
	companyId = models.CharField(max_length = 50, null = True, blank = True)
	productId = models.CharField(max_length = 50, null = True, blank = True)
	productName = models.CharField(max_length = 50, null = True, blank = True)
	productPrice = models.CharField(max_length = 50, null = True, blank = True)
	productQuantity = models.CharField(max_length = 50, null = True, blank = True)
	productImage = models.FileField(upload_to='Product', blank = True, null = True)
	productGiftID = models.CharField(max_length = 50, null = True, blank = True)
	productDescription = models.TextField(blank = True)
	productRating = models.CharField(max_length = 50, null = True, blank = True,default='0')
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.productName)+'-'+str(self.productId))

class perkmcharges(models.Model):
	charges = models.CharField(max_length = 50, null = True, blank = True)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.charges))

class totalratingsproducts(models.Model):
	product= models.ForeignKey(product, on_delete=models.CASCADE,default='',null=True)
	totalCount = models.CharField(max_length = 20, null = True, blank = True,default='0')
	totalRatingNumbers = models.CharField(max_length = 20, null = True, blank = True,default='0')
	averageRating = models.CharField(max_length = 20, null = True, blank = True,default='0')
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.product)+' - '+str(self.averageRating))

class ratingsproducts(models.Model):
	product= models.ForeignKey(product, on_delete=models.CASCADE,default='',null=True)
	totalratings= models.ForeignKey(totalratingsproducts, on_delete=models.CASCADE,default='',null=True)
	rating = models.CharField(max_length = 20, null = True, blank = True)
	review = models.TextField(blank = True)
	customerID = models.CharField(max_length = 30, null = True, blank = True)
	orderID = models.CharField(max_length = 30, null = True, blank = True)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.product)+' - '+str(self.rating))