from rest_framework import serializers
from .models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from django.conf import settings
from base.models import *


class GetTimingsData(serializers.ModelSerializer):
	class Meta:
		model = storetimingsnew
		fields = ['openingTime', 'closingTime', 'monday','tuesday','wednesday','thursday','friday','saturday','sunday']
class GetCategoryData(serializers.ModelSerializer):
	categoryImage =  serializers.SerializerMethodField(source='get_categoryImage')
	class Meta:
		model= thecategory
		fields = ['categoryId','categoryName', 'categoryImage','isdisabled']
	def get_categoryImage(self, obj):
    		return str(obj.categoryImage.name)
class GetProductData(serializers.ModelSerializer):
	productImage =  serializers.SerializerMethodField(source='get_productImage')
	productRating =  serializers.SerializerMethodField(source='get_productRating')
	giftData =  serializers.SerializerMethodField(source='get_giftData')

	class Meta:
		model = product
		fields = ['productId','productName', 'productPrice', 'productQuantity','productImage','productDescription','giftData','productRating','isdisabled']

	def get_productImage(self, obj):
		return str(obj.productImage.name)

	def get_productRating(self, obj):
		return str(obj.productRating)

	def get_giftData(self, obj):
		theGift=gift.objects.filter(giftId=obj.productGiftID).first()
		theSerialData=GetGiftData(theGift)
		return theSerialData.data

class GetGiftData(serializers.ModelSerializer):
	giftImage =  serializers.SerializerMethodField(source='get_giftImage')
	giftQuantities = serializers.SerializerMethodField(source='get_giftQuantities')

	class Meta:
		model = gift
		fields = ['giftId','giftName', 'giftImage','giftDescription','giftQuantities','categoryId','isdisabled']

	def get_giftImage(self, obj):
		return str(obj.giftImage.name)

	def get_giftQuantities(self, obj):
		allQuantities=addonquantity.objects.filter(forGift=obj)
		theData=GetQuantitesData(allQuantities,many=True)
		return theData.data

class GetQuantitesData(serializers.ModelSerializer):

	class Meta:
		model = addonquantity
		fields = ['addOnId','addOnWeight','addOnUnit', 'addOnPrice']

class GetStoreData(serializers.ModelSerializer):
	timings = serializers.SerializerMethodField(source='get_timings')
	totalRating = serializers.SerializerMethodField(source='get_totalRating')
	registerSince = serializers.SerializerMethodField(source='get_registerSince')
	# documents = serializers.SerializerMethodField(source='get_documents')
	image = serializers.SerializerMethodField(source='get_image')
	
	class Meta:
		model = storenew
		fields = ['userUniqueID','name', 'email','phone','countrycode','image','isdisabled','description','timings','address','latitude','longitude','fbURL','instaURL','webURL','totalRating','registerSince']

	def get_timings(self,obj):
		allData={}
		theCompTiming=storetimingsnew.objects.filter(userUniqueID=obj.userUniqueID).first()
		if theCompTiming:
			theData=GetTimingsData(theCompTiming)
			return theData.data
		return allData

	def get_totalRating(self,obj):
		return '37'

	def get_registerSince(self,obj):
		return obj.created_at

	def get_image(self,obj):
		if obj.image.name!='':
			theImage=str(obj.image.name)
		else:
			theImage=''
		return theImage