from rest_framework.views import APIView
from rest_framework.response import Response
from django.contrib.auth import login,authenticate
from .models import *
from base.models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from .serializers import *
import datetime
from django.template.loader import render_to_string
from django.core.mail import EmailMessage
import math, random, datetime, pytz, string
from django.core.files.storage import FileSystemStorage
from django.conf import settings
from io import BytesIO
from PIL import Image
import json
import requests

def randomStringFunctionForImage():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(8)))
	str1 += ''.join((random.choice(string.digits) for x in range(4)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

# def uploadDocumentImages(image,thePath):
# 	filename = image.name
# 	filename = filename.split('.')
# 	extension = str(filename[-1])
# 	import io

# 	image_data = io.BytesIO(image.read())
# 	img = Image.open(image_data)
# 	st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
# 	img = Image.open(image_data)
# 	# im = img.thumbnail([int('100'),int('100')], Image.ANTIALIAS)
# 	im = img.save(str(settings.BASE_DIR)+'/media/'+str(thePath)+st+'.'+extension)
# 	filename=str(settings.WEB_BASE_URL)+'media/'+str(thePath)+st+'.'+extension

# 	# img = Image.open(image_data)    
# 	# img.save(str(settings.BASE_DIR)+'/media/'+str(thePath)+st+'.'+extension)
# 	return filename

# def uploadDocumentImages(image,thePath):
# 	import os
# 	fullPath='media/'+str(thePath)
# 	fs = FileSystemStorage(location=fullPath)
# 	beforename = os.path.splitext(image.name)[0]
# 	beforename=beforename.replace(' ','')
# 	filetype = os.path.splitext(image.name)[1]
# 	theName=randomStringFunctionForImage()
# 	theImageName=str(theName)+str(filetype)
# 	filename = fs.save(theImageName, image)
# 	return str(fullPath)+'/'+filename

def uploadDocumentImages(image,thePath):
	import os
	import boto3
	from botocore.exceptions import NoCredentialsError
	try:
		bucket=str(settings.AWS_BUCKET_NAME)
		thePath=thePath.lower()
		ACCESS_KEY=str(settings.AWS_ACCESS_KEY_ID)
		SECRET_KEY=str(settings.AWS_SECRET_ACCESS_KEY)
		s3 = boto3.client('s3', aws_access_key_id=ACCESS_KEY,
					  aws_secret_access_key=SECRET_KEY)
		try:
			filetype = os.path.splitext(image.name)[1]
			imageName=randomStringFunctionForImage()
			thePath=thePath+'/'+imageName+'.'+filetype
			thePath=str(thePath)
			theFile=s3.upload_fileobj(image,bucket,thePath)
			print("Upload Successful")
			filename=str(settings.AWS_BUCKET_URL_1)+str(bucket)+str(settings.AWS_BUCKET_URL_2)+thePath
			return filename
		except FileNotFoundError as e:
			print("The file was not found")
			return ''
		except NoCredentialsError:
			print("Credentials not available")
			return ''
	except Exception as e:
		print(e)
		return ''

class addProduct(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			if not data.get('productName'):
				response['status_code']=400
				response['status_message']='productName required'
				return Response(response)
			if not data.get('productPrice'):
				response['status_code']=400
				response['status_message']='productPrice required'
				return Response(response)
			if not data.get('productQuantity'):
				response['status_code']=400
				response['status_message']='productQuantity required'
				return Response(response)
			if not request.FILES.get('productImage'):
				response['status_code']=400
				response['status_message']='productImage required'
				return Response(response)
			if not data.get('productDescription'):
				response['status_code']=400
				response['status_message']='productDescription required'
				return Response(response)
			if not data.get('giftId'):
				response['status_code']=400
				response['status_message']='giftId required'
				return Response(response)

			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)
			
			try:
				import requests
				theURL=str(settings.COMPANY_ACCESS_URL)+'company/subscriptions/getCompanyModulesForLimit/'
				theToken=str(settings.COMPANY_ACCESS_KEY)
				payload={'AccessKey':theToken,
						 'companyID':str(storeObj.companyID),}
				apiResponse = requests.request("POST", theURL, data=payload)
				apiResponse = apiResponse.json()
				if apiResponse['status_code']==200:
					if apiResponse['data'][0]['canAddProducts']=='True':
						theAlreadyStoreCount=product.objects.filter(companyId=storeObj.companyID).count()
						if int(theAlreadyStoreCount)<int(apiResponse['data'][0]['productLimit']):
							pass
						else:
							response['status_code']=400
							response['status_message']='Your company have reach the limit of subscription plan.'
							return Response(response)
					else:
						response['status_code']=400
						response['status_message']='You can not add products with your current company plan'
						return Response(response)
				elif apiResponse['status_code']==404:
					response['status_code']=400
					response['status_message']="Your company don't have any plan"
					return Response(response)
				else:
					return Response(apiResponse)
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)

			beforeNameOfUser=data.get('productName')
			name3Letter=beforeNameOfUser[0:3]
			name3Letter=name3Letter.upper()
			latExt=product.objects.all().last()
			if latExt:
				lastId=latExt.productId
				print("last",lastId)
				last5Number=lastId[3:]
				last5Number=int(last5Number)
				new5Number=last5Number+1
				new5Number=str(new5Number)
				new5Number = new5Number.zfill(5)
				theUniqueID=str(name3Letter)+str(new5Number)
			else:
				theUniqueID=str(name3Letter)+str('00001')
			theProductObj=product.objects.create(storeId=storeObj.userUniqueID,productName=data.get('productName'))
			filename=''
			productImage=request.FILES.get('productImage')
			if productImage:
				filename=uploadDocumentImages(productImage,'Product')
			if theProductObj:
				theProductObj.productId=theUniqueID
				theProductObj.productPrice=data.get('productPrice')
				theProductObj.productQuantity=data.get('productQuantity')
				theProductObj.productImage=filename
				theProductObj.productDescription=data.get('productDescription')
				theProductObj.productGiftID=data.get('giftId')
				theProductObj.companyId=storeObj.companyID
				theProductObj.save()
			else:
				response['status_code']=400
				response['status_message']='Oops! Something went wrong'
				return Response(response)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getProductList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData = []
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)
			
			if not data.get('search'):
				if not data.get('status'):
					allProducts=product.objects.filter(storeId=storeObj.userUniqueID,isdeleted=False)
				else:
					if data.get('status')=='active':
						allProducts=product.objects.filter(storeId=storeObj.userUniqueID,isdeleted=False,isdisabled=False)
					elif data.get('status')=='inactive':
						allProducts=product.objects.filter(storeId=storeObj.userUniqueID,isdeleted=False,isdisabled=True)
					else:
						allProducts=product.objects.filter(storeId=storeObj.userUniqueID,isdeleted=False)
			else:
				if not data.get('status'):
					allProducts=product.objects.filter(storeId=storeObj.userUniqueID,isdeleted=False,productName__icontains=data.get('search'))
					# allProducts=product.objects.filter(storeId=storeObj.userUniqueID,isdeleted=False)
				else:
					if data.get('status')=='active':
						allProducts=product.objects.filter(storeId=storeObj.userUniqueID,isdeleted=False,productName__icontains=data.get('search'),isdisabled=False)
						# allProducts=product.objects.filter(storeId=storeObj.userUniqueID,isdeleted=False,isdisabled=False)
					elif data.get('status')=='inactive':
						allProducts=product.objects.filter(storeId=storeObj.userUniqueID,isdeleted=False,productName__icontains=data.get('search'),isdisabled=True)
						# allProducts=product.objects.filter(storeId=storeObj.userUniqueID,isdeleted=False,isdisabled=True)
					else:
						allProducts=product.objects.filter(storeId=storeObj.userUniqueID,isdeleted=False,productName__icontains=data.get('search'))
						# allProducts=product.objects.filter(storeId=storeObj.userUniqueID,isdeleted=False)
				# allProducts=product.objects.filter(storeId=storeObj.userUniqueID,isdeleted=False,productName__contains=data.get('search'))
			if allProducts:
				theSerialData=GetProductData(allProducts,many=True)
				allData.append(theSerialData.data)
				print('allData',allData)
			response['data']= allData
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class viewProduct(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('productId'):
				response['status_code']=400
				response['status_message']='productId required'
				return Response(response)

			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)

			allProducts=product.objects.filter(storeId=storeObj.userUniqueID,productId=data.get('productId')).first()
			if allProducts:
				theSerialData=GetProductData(allProducts)
				response['data']=theSerialData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class addGift(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)
			if not data.get('giftName'):
				response['status_code']=400
				response['status_message']='giftName required'
				return Response(response)
			if not request.FILES.get('giftImage'):
				response['status_code']=400
				response['status_message']='giftImage required'
				return Response(response)
			if not data.get('giftDescription'):
				response['status_code']=400
				response['status_message']='giftDescription required'
				return Response(response)
			if not data.get('categoryId'):
				response['status_code']=400
				response['status_message']='categoryId required'
				return Response(response)

			theCategoryObj=	thecategory.objects.filter(categoryId=data.get('categoryId'))
			if not theCategoryObj:
				response['status_code']=400
				response['status_message']='Invalid categoryId required'
				return Response(response)

			quanList=data.get("giftQuantities")
			if not quanList:
				response['status_code']=400
				response['status_message']='giftQuantities required'
				return Response(response)
			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)
			
			beforeNameOfGift=data.get('giftName')
			name3LetterGift=beforeNameOfGift[0:3]
			name3LetterGift=name3LetterGift.upper()
			latExtGift=gift.objects.all().last()
			if latExtGift:
				lastGiftId=latExtGift.giftId
				last5NumberGift=lastGiftId[3:]
				last5NumberGift=int(last5NumberGift)
				new5NumberGift=last5NumberGift+1
				new5NumberGift=str(new5NumberGift)
				new5NumberGift = new5NumberGift.zfill(5)
				theUniqueIDGift=str(name3LetterGift)+str(new5NumberGift)
			else:
				theUniqueIDGift=str(name3LetterGift)+str('00001')

			# alreadyGift=Gift.objects.filter(giftName=data.get('giftName')).first()
			# if alreadyGift:
			# 	response['status_code']=400
			# 	response['status_message']='Gift name already exist'
			# 	return Response(response)

			theGiftObj=gift.objects.create(giftName=data.get('giftName'))
			filename=''
			giftImage=request.FILES.get('giftImage')
			if giftImage:
				filename=uploadDocumentImages(giftImage,'Gift')

			if theGiftObj:
				theGiftObj.storeId=storeObj.userUniqueID
				theGiftObj.giftId=theUniqueIDGift
				theGiftObj.giftImage=filename
				theGiftObj.giftDescription=data.get('giftDescription')
				theGiftObj.categoryId=data.get('categoryId')
				theGiftObj.save()

			quanList=json.loads(quanList)
			for quan in quanList:
				theQuanID=quan['id']
				theWeight=quan['quanWeight']
				theUnit=quan['quanUnit']
				thePrice=quan['quanPrice']
				addonquantity.objects.create(addOnId=theQuanID,forGift=theGiftObj,addOnWeight=theWeight,addOnUnit=theUnit,addOnPrice=thePrice)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getGiftsList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)
			allGifts=gift.objects.filter(isdeleted=False,storeId=storeObj.userUniqueID)

			if not data.get('search'):
				if not data.get('status'):
					allGifts=gift.objects.filter(isdeleted=False,storeId=storeObj.userUniqueID)
				else:
					if data.get('status')=='active':
						allGifts=gift.objects.filter(isdeleted=False,storeId=storeObj.userUniqueID,isdisabled=False)
					elif data.get('status')=='inactive':
						allGifts=gift.objects.filter(isdeleted=False,storeId=storeObj.userUniqueID,isdisabled=True)
					else:
						allGifts=gift.objects.filter(isdeleted=False,storeId=storeObj.userUniqueID)
			else:
				if not data.get('status'):
					allGifts=gift.objects.filter(isdeleted=False,storeId=storeObj.userUniqueID,giftName__icontains=data.get('search'))
				else:
					if data.get('status')=='active':
						allGifts=gift.objects.filter(isdeleted=False,storeId=storeObj.userUniqueID,giftName__icontains=data.get('search'),isdisabled=False)
					elif data.get('status')=='inactive':
						allGifts=gift.objects.filter(isdeleted=False,storeId=storeObj.userUniqueID,giftName__icontains=data.get('search'),isdisabled=True)
					else:
						allGifts=gift.objects.filter(isdeleted=False,storeId=storeObj.userUniqueID,giftName__icontains=data.get('search'))
			if allGifts:
				theSerialData=GetGiftData(allGifts,many=True)
				response['data']=theSerialData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getQuantityList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)

			url = str(settings.ADMIN_ACCESS_URL)+"superadmin/setting/getQuantitiesForOthers/"
			payload={'AccessKey': str(settings.ADMIN_ACCESS_KEY)}
			res = requests.request("POST", url,data=payload)
			return Response(res.json())
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getGiftDetails(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)
			if not data.get('giftId'):
				response['status_code']=400
				response['status_message']='giftId required'
				return Response(response)
			allGifts=gift.objects.filter(isdeleted=False,storeId=storeObj.userUniqueID,giftId=data.get('giftId')).first()
			if allGifts:
				theSerialData=GetGiftData(allGifts)
				response['data']=theSerialData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updateGift(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")
			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)
			if not data.get('giftId'):
				response['status_code']=400
				response['status_message']='giftId required'
				return Response(response)
			theGiftObj=gift.objects.filter(giftId=data.get('giftId'),storeId=storeObj.userUniqueID).first()
			if not theGiftObj:
				response['status_code']=400
				response['status_message']='Invalid Gift Id'
				return Response(response)
			if theGiftObj:
				giftImage=request.FILES.get('giftImage')
				if giftImage:
					filename=uploadDocumentImages(giftImage,'Gift')
					theGiftObj.giftImage=filename
				if data.get('giftName'):
					theGiftObj.giftName=data.get('giftName')
				if data.get('giftDescription'):
					theGiftObj.giftDescription=data.get('giftDescription')
				if data.get('categoryId'):
					theCategoryObj=	thecategory.objects.filter(categoryId=data.get('categoryId'))
					if theCategoryObj:
						theGiftObj.categoryId=data.get('categoryId')
				theGiftObj.save()
			quanList=data.get("giftQuantities")
			if quanList:
				oldQuan=addonquantity.objects.filter(forGift=theGiftObj)
				for oquan in oldQuan:
					oquan.delete()
				quanList=json.loads(quanList)
				for quan in quanList:
					theQuanID=quan['id']
					theWeight=quan['quanWeight']
					theUnit=quan['quanUnit']
					thePrice=quan['quanPrice']
					addonquantity.objects.create(addOnId=theQuanID,forGift=theGiftObj,addOnWeight=theWeight,addOnUnit=theUnit,addOnPrice=thePrice)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updateProduct(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			if not data.get('productId'):
				response['status_code']=400
				response['status_message']='productId required'
				return Response(response)

			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)
			theProductObj=product.objects.filter(productId=data.get('productId'),storeId=storeObj.userUniqueID).first()
			
			if theProductObj:
				productImage=request.FILES.get('productImage')
				if productImage:
					filename=uploadDocumentImages(productImage,'Product')
					theProductObj.productImage=filename
				if not data.get('productName'):
					theProductObj.productName=data.get('productName')
				if not data.get('productPrice'):
					theProductObj.productPrice=data.get('productPrice')
				if not data.get('productQuantity'):
					theProductObj.productQuantity=data.get('productQuantity')
				if not data.get('productDescription'):
					theProductObj.productDescription=data.get('productDescription')
				if not data.get('giftId'):
					theProductObj.productGiftID=data.get('giftId')
				theProductObj.save()
			else:
				response['status_code']=400
				response['status_message']='Oops! Something went wrong'
				return Response(response)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class addGiftForCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)

			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)

			if not data.get('companyId'):
				response['status_code']=400
				response['status_message']='companyId required'
				return Response(response)
			
			if not data.get('giftName'):
				response['status_code']=400
				response['status_message']='giftName required'
				return Response(response)
			if not request.FILES.get('giftImage'):
				response['status_code']=400
				response['status_message']='giftImage required'
				return Response(response)
			if not data.get('giftDescription'):
				response['status_code']=400
				response['status_message']='giftDescription required'
				return Response(response)
			quanList=data.get("giftQuantities")
			if not quanList:
				response['status_code']=400
				response['status_message']='giftQuantities required'
				return Response(response)
			
			if not data.get('categoryId'):
				response['status_code']=400
				response['status_message']='categoryId required'
				return Response(response)
			
			theCategoryObj=	thecategory.objects.filter(categoryId=data.get('categoryId'))
			if not theCategoryObj:
				response['status_code']=400
				response['status_message']='Invalid categoryId required'
				return Response(response)

			beforeNameOfGift=data.get('giftName')
			name3LetterGift=beforeNameOfGift[0:3]
			name3LetterGift=name3LetterGift.upper()
			latExtGift=gift.objects.all().last()
			if latExtGift:
				lastGiftId=latExtGift.giftId
				last5NumberGift=lastGiftId[3:]
				last5NumberGift=int(last5NumberGift)
				new5NumberGift=last5NumberGift+1
				new5NumberGift=str(new5NumberGift)
				new5NumberGift = new5NumberGift.zfill(5)
				theUniqueIDGift=str(name3LetterGift)+str(new5NumberGift)
			else:
				theUniqueIDGift=str(name3LetterGift)+str('00001')

			# alreadyGift=Gift.objects.filter(giftName=data.get('giftName')).first()
			# if alreadyGift:
			# 	response['status_code']=400
			# 	response['status_message']='Gift name already exist'
			# 	return Response(response)

			theGiftObj=gift.objects.create(giftName=data.get('giftName'))
			filename=''
			giftImage=request.FILES.get('giftImage')
			if giftImage:
				filename=uploadDocumentImages(giftImage,'Gift')

			if theGiftObj:
				theGiftObj.companyId=data.get('companyId')
				theGiftObj.giftId=theUniqueIDGift
				theGiftObj.giftImage=filename
				theGiftObj.giftDescription=data.get('giftDescription')
				theGiftObj.productRelated='1'
				theGiftObj.categoryId=data.get('categoryId')
				theGiftObj.save()

			quanList=json.loads(quanList)
			for quan in quanList:
				theQuanID=quan['id']
				theWeight=quan['quanWeight']
				theUnit=quan['quanUnit']
				thePrice=quan['quanPrice']
				addonquantity.objects.create(addOnId=theQuanID,forGift=theGiftObj,addOnWeight=theWeight,addOnUnit=theUnit,addOnPrice=thePrice)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updateGiftForCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			

			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)

			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if not data.get('giftId'):
				response['status_code']=400
				response['status_message']='giftId required'
				return Response(response)
			if not data.get('companyId'):
				response['status_code']=400
				response['status_message']='companyId required'
				return Response(response)

			theGiftObj=gift.objects.filter(giftId=data.get('giftId'),companyId=data.get('companyId')).first()
			if not theGiftObj:
				response['status_code']=400
				response['status_message']='Invalid Gift Id'
				return Response(response)
			if theGiftObj:
				giftImage=request.FILES.get('giftImage')
				if giftImage:
					filename=uploadDocumentImages(giftImage,'Gift')
					theGiftObj.giftImage=filename
				if data.get('giftName'):
					theGiftObj.giftName=data.get('giftName')
				if data.get('giftDescription'):
					theGiftObj.giftDescription=data.get('giftDescription')
				
				if data.get('categoryId'):
					theCategoryObj=	thecategory.objects.filter(categoryId=data.get('categoryId'))
					if theCategoryObj:
						theGiftObj.categoryId=data.get('categoryId')

				theGiftObj.save()
			quanList=data.get("giftQuantities")
			if quanList:
				oldQuan=addonquantity.objects.filter(forGift=theGiftObj)
				for oquan in oldQuan:
					oquan.delete()
				quanList=json.loads(quanList)
				for quan in quanList:
					theQuanID=quan['id']
					theWeight=quan['quanWeight']
					theUnit=quan['quanUnit']
					thePrice=quan['quanPrice']
					addonquantity.objects.create(addOnId=theQuanID,forGift=theGiftObj,addOnWeight=theWeight,addOnUnit=theUnit,addOnPrice=thePrice)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getGiftsListForCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)

			if not data.get('companyId'):
				response['status_code']=400
				response['status_message']='companyId required'
				return Response(response)

			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			allGifts=gift.objects.filter(isdeleted=False,companyId=data.get('companyId'))
			if allGifts:
				theSerialData=GetGiftData(allGifts,many=True)
				response['data']=theSerialData.data
			else:
				response['data']=[]
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getGiftDetailsForCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)

			if not data.get('companyId'):
				response['status_code']=400
				response['status_message']='companyId required'
				return Response(response)
			if not data.get('giftId'):
				response['status_code']=400
				response['status_message']='giftId required'
				return Response(response)

			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)

			allGifts=gift.objects.filter(isdeleted=False,companyId=data.get('companyId'),giftId=data.get('giftId'))
			if allGifts:
				theSerialData=GetGiftData(allGifts)
				response['data']=theSerialData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getProductListForOthers(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=401
				response['status_message']='AccessKey required.'
				return Response(response,status=401)
			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required.'
				return Response(response,status=400)
			storeObject = storenew.objects.filter(userUniqueID=data.get('storeID')).first()
			if storeObject:
				teamData=GetStoreData(storeObject)
				response['storeData']=teamData.data
			if not data.get('search'):
				allProducts=product.objects.filter(storeId=data.get('storeID'),isdeleted=False,isdisabled=False)
			else:
				if data.get('search')=='':
					allProducts=product.objects.filter(storeId=data.get('storeID'),isdeleted=False,isdisabled=False)
				else:
					allProducts=product.objects.filter(storeId=data.get('storeID'),productName__icontains=data.get('search'),isdeleted=False,isdisabled=False)
			if allProducts:
				theSerialData=GetProductData(allProducts,many=True)
				response['productData']=theSerialData.data
				response['status_code']=200
				response['status_message']='Success'
			else:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response,status=400)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response,status=500)
		return Response(response)

class viewProductForOthers(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=401
				response['status_message']='AccessKey required.'
				return Response(response,status=401)
			if not data.get('storeID'):
				response['status_code']=400
				response['status_message']='storeID required.'
				return Response(response,status=400)
			if not data.get('productId'):
				response['status_code']=400
				response['status_message']='productId required'
				return Response(response,status=400)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=401
				response['status_message']='You dont have access.'
				return Response(response,status=401)
			print("Before products")
			print(data.get('productId'))
			print(data.get('storeID'))

			allProducts=product.objects.filter(storeId=data.get('storeID'),productId=data.get('productId'),isdeleted=False).first()
			print(allProducts)
			if allProducts:
				theSerialData=GetProductData(allProducts)
				response['data']=theSerialData.data
				response['status_code']=200
				response['status_message']='Success'
			else:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response,status=400)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response,status=500)
		return Response(response)

class addProductForCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=401
				response['status_message']='AccessKey required.'
				return Response(response,status=401)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=401
				response['status_message']='You dont have access.'
				return Response(response,status=401)

			if not data.get('productName'):
				response['status_code']=400
				response['status_message']='productName required'
				return Response(response)
			if not data.get('productPrice'):
				response['status_code']=400
				response['status_message']='productPrice required'
				return Response(response)
			if not data.get('productQuantity'):
				response['status_code']=400
				response['status_message']='productQuantity required'
				return Response(response)
			if not request.FILES.get('productImage'):
				response['status_code']=400
				response['status_message']='productImage required'
				return Response(response)
			if not data.get('productDescription'):
				response['status_code']=400
				response['status_message']='productDescription required'
				return Response(response)
			if not data.get('giftId'):
				response['status_code']=400
				response['status_message']='giftId required'
				return Response(response)
			if not data.get('companyId'):
				response['status_code']=400
				response['status_message']='companyId required'
				return Response(response)

			beforeNameOfUser=data.get('productName')
			name3Letter=beforeNameOfUser[0:3]
			name3Letter=name3Letter.upper()
			latExt=product.objects.all().last()
			if latExt:
				lastId=latExt.productId
				print("last",lastId)
				last5Number=lastId[3:]
				last5Number=int(last5Number)
				new5Number=last5Number+1
				new5Number=str(new5Number)
				new5Number = new5Number.zfill(5)
				theUniqueID=str(name3Letter)+str(new5Number)
			else:
				theUniqueID=str(name3Letter)+str('00001')
			theProductObj=product.objects.create(companyId=data.get('companyId'),productName=data.get('productName'))
			filename=''
			productImage=request.FILES.get('productImage')
			if productImage:
				filename=uploadDocumentImages(productImage,'Product')
			if theProductObj:
				theProductObj.productId=theUniqueID
				theProductObj.productPrice=data.get('productPrice')
				theProductObj.productQuantity=data.get('productQuantity')
				theProductObj.productImage=filename
				theProductObj.productDescription=data.get('productDescription')
				theProductObj.productGiftID=data.get('giftId')
				theProductObj.productRelated='1'
				theProductObj.save()
			else:
				response['status_code']=400
				response['status_message']='Oops! Something went wrong'
				return Response(response)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getProductListForCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=401
				response['status_message']='AccessKey required.'
				return Response(response,status=401)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=401
				response['status_message']='You dont have access.'
				return Response(response,status=401)
			if not data.get('companyId'):
				response['status_code']=400
				response['status_message']='companyId required.'
				return Response(response)
			allProducts=product.objects.filter(companyId=data.get('companyId'),isdeleted=False)
			if allProducts:
				theSerialData=GetProductData(allProducts,many=True)
				response['data']=theSerialData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class viewProductForCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			if not data.get('AccessKey'):
				response['status_code']=401
				response['status_message']='AccessKey required.'
				return Response(response,status=401)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=401
				response['status_message']='You dont have access.'
				return Response(response,status=401)

			if not data.get('productId'):
				response['status_code']=400
				response['status_message']='productId required'
				return Response(response)

			if not data.get('companyId'):
				response['status_code']=400
				response['status_message']='companyId required.'
				return Response(response)

			allProducts=product.objects.filter(companyId=data.get('companyId'),productId=data.get('productId')).first()
			if allProducts:
				theSerialData=GetProductData(allProducts)
				response['data']=theSerialData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updateProductForCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			if not data.get('AccessKey'):
				response['status_code']=401
				response['status_message']='AccessKey required.'
				return Response(response,status=401)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=401
				response['status_message']='You dont have access.'
				return Response(response,status=401)

			if not data.get('productId'):
				response['status_code']=400
				response['status_message']='productId required'
				return Response(response)
			if not data.get('companyId'):
				response['status_code']=400
				response['status_message']='companyId required'
				return Response(response)

			theProductObj=product.objects.filter(productId=data.get('productId'),companyId=data.get('companyId')).first()
			
			if theProductObj:
				productImage=request.FILES.get('productImage')
				if productImage:
					filename=uploadDocumentImages(productImage,'Product')
					theProductObj.productImage=filename
				if not data.get('productName'):
					theProductObj.productName=data.get('productName')
				if not data.get('productPrice'):
					theProductObj.productPrice=data.get('productPrice')
				if not data.get('productQuantity'):
					theProductObj.productQuantity=data.get('productQuantity')
				if not data.get('productDescription'):
					theProductObj.productDescription=data.get('productDescription')
				if not data.get('giftId'):
					theProductObj.productGiftID=data.get('giftId')
				theProductObj.save()
			else:
				response['status_code']=400
				response['status_message']='Oops! Something went wrong'
				return Response(response)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class addProductRating(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey is required'
				return Response(response)
			
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Unauthorized'
				return Response(response)
			
			if not data.get('productID'):
				response['status_code']=400
				response['status_message']='productID required'
				return Response(response)
			
			if not data.get('rating'):
				response['status_code']=400
				response['status_message']='rating required'
				return Response(response)
			
			if data.get('review'):
				response['status_code']=400
				response['status_message']='review required'
				return Response(response)

			if not data.get('customerID'):
				response['status_code']=400
				response['status_message']='customerID required'
				return Response(response)
			
			if not data.get('orderID'):
				response['status_code']=400
				response['status_message']='orderID required'
				return Response(response)
			
			theProductObject=product.objects.filter(productId=data.get('productID')).first()
			if not theProductObject:
				response['status_code']=400
				response['status_message']='Invalid product id.'
				return Response(response)
			
			theRating=ratingsproducts.objects.filter(product=theProductObject,customerID=data.get('customerID'),orderID=data.get('orderID')).first()
			if theRating:
				response['status_code']=400
				response['status_message']='Already rated'
				return Response(response)
			theTotalObject=totalratingsproducts.objects.filter(product=theProductObject).first()
			if not theTotalObject:
				theTotalObject=totalratingsproducts.objects.create(product=theProductObject)
			theRating=ratingsproducts.objects.create(product=theProductObject,customerID=data.get('customerID'))
			theRating.totalratings=theTotalObject
			theRating.rating=float(data.get('rating'))
			theRating.orderID=data.get('orderID')
			theRating.review=data.get('review')
			theRating.save()
			customerCount=int(theTotalObject.totalCount)+int('1')
			theTotalObject.totalCount=customerCount
			totalRates=float(theTotalObject.totalRatingNumbers)+float(data.get('rating'))
			theTotalObject.totalRatingNumbers=totalRates
			average=float(totalRates)/float(customerCount)
			theTotalObject.averageRating=average
			theTotalObject.save()
			theProductObject.productRating=float(average)
			theProductObject.save()
			response['status_code']=200
			response['status_message']='Ratings added successfully'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class enableDisableProduct(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('productId'):
				response['status_code']=400
				response['status_message']='productId required'
				return Response(response)

			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)
			
			if not data.get('status'):
				response['status_code']=400
				response['status_message']='status required'
				return Response(response)


			allProducts=product.objects.filter(storeId=storeObj.userUniqueID,productId=data.get('productId')).first()
			if allProducts:
				if data.get('status')=='active':
					allProducts.isdisabled=False
					allProducts.save()
				else:
					allProducts.isdisabled=True
					allProducts.save()
				# theSerialData=GetProductData(allProducts)
				# response['data']=theSerialData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class enableDisableGift(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('giftId'):
				response['status_code']=400
				response['status_message']='giftId required'
				return Response(response)

			session_token = request.META.get('HTTP_AUTHORIZATION')
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				else:
					session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			storeObj = storenew.objects.filter(token = session_token).first()
			if not storeObj:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)
			
			if not data.get('status'):
				response['status_code']=400
				response['status_message']='status required'
				return Response(response)
			
			theGiftObj=gift.objects.filter(giftId=data.get('giftId')).first()
			if theGiftObj:
				if data.get('status')=='active':
					theGiftObj.isdisabled=False
					theGiftObj.save()
				else:
					theGiftObj.isdisabled=True
					theGiftObj.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class addCategory(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('categoryName'):
				response['status_code']=400
				response['status_message']='categoryName required'
				return Response(response)
			if not request.FILES.get('categoryImage'):
				response['status_code']=400
				response['status_message']='categoryImage required'
				return Response(response)
			name3LetterGift='CAT'
			latExtGift=thecategory.objects.all().last()
			if latExtGift:
				lastGiftId=latExtGift.categoryId
				last5NumberGift=lastGiftId[3:]
				last5NumberGift=int(last5NumberGift)
				new5NumberGift=last5NumberGift+1
				new5NumberGift=str(new5NumberGift)
				new5NumberGift = new5NumberGift.zfill(5)
				theUniqueIDGift=str(name3LetterGift)+str(new5NumberGift)
			else:
				theUniqueIDGift=str(name3LetterGift)+str('00001')
			alreadyObj=thecategory.objects.filter(categoryName=data.get('categoryName'))
			# if not alreadyObj:
			theCategoryObj=thecategory.objects.create(categoryId=theUniqueIDGift,categoryName=data.get('categoryName'))
			filename=''
			categoryImage=request.FILES.get('categoryImage')
			if categoryImage:
				filename=uploadDocumentImages(categoryImage,'Category')
			if theCategoryObj:
				theCategoryObj.categoryImage = filename
				theCategoryObj.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updateCategory(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('categoryId'):
				response['status_code']=400
				response['status_message']='categoryId required'
				return Response(response)
			# if not data.get('categoryName'):
			#     response['status_code']=400
			#     response['status_message']='categoryName required'
			#     return Response(response)
			# if not request.FILES.get('categoryImage'):
			#     response['status_code']=400
			#     response['status_message']='categoryImage required'
			#     return Response(response)
			alreadyObj=thecategory.objects.filter(categoryName=data.get('categoryName'))
			# if alreadyObj:
			#     response['status_code']=400
			#     response['status_message']='Please select other name a category with this name already exist'
			#     return Response(response)
			theCatObject=thecategory.objects.filter(categoryId=data.get('categoryId')).first()
			if theCatObject:
				theCatObject.categoryName=data.get('categoryName')
				categoryImage=request.FILES.get('categoryImage')
				if categoryImage:
					filename=uploadDocumentImages(categoryImage,'Category')
					theCatObject.categoryImage=filename
				theCatObject.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getCategoryList(APIView):
	def get(self, request, *args, **kwargs):
		response={}
		try:
			allData=[]
			theCatObject=thecategory.objects.all()
			print('theCatObject',theCatObject)
			for obj in theCatObject:
				theData=GetCategoryData(obj).data
				allData.append(theData)
			response['status_code']=200
			response['status_message']='Success'
			response['data'] = allData	
			return Response(response)			
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class enableDisableCategory(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('categoryId'):
				response['status_code']=400
				response['status_message']='categoryId required'
				return Response(response)
			if not data.get('status'):
				response['status_code']=400
				response['status_message']='status required'
				return Response(response)
			theCatObject=thecategory.objects.filter(categoryId=data.get('categoryId')).first()
			if theCatObject:
				if data.get('status')=='True':
					theCatObject.isdisabled=False
				else:
					theCatObject.isdisabled=True
				theCatObject.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)