from rest_framework.views import APIView
from rest_framework.response import Response
import random,string,math
from django.template.loader import render_to_string
from django.core.mail import EmailMessage
from django.contrib.auth.models import User
from base.models import *
from django.conf import settings
from django.core.files.storage import FileSystemStorage

class adminLoginToken(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			theAccess=superadminaccessnew.objects.filter(theId='1').first()
			if not theAccess:
				theAccess=superadminaccessnew.objects.create(theId='1')
			theAccess.token=data.get('AccessKey')
			theAccess.save()
			response['status_code']=200
			response['status_message']='Done'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class adminLogoutToken(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			theAccess=superadminaccessnew.objects.filter(theId='1').first()
			if not theAccess:
				theAccess=superadminaccessnew.objects.create(theId='1')
			theAccess.token='A4D5M8I6N3L3O5G2O0U8T'
			theAccess.save()
			response['status_code']=200
			response['status_message']='Done'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class companyLoginToken(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			theAccess=companyaccessnew.objects.filter(token=data.get('AccessKey')).first()
			if not theAccess:
				theAccess=companyaccessnew.objects.create(token=data.get('AccessKey'))
			response['status_code']=200
			response['status_message']='Done'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class companyLogoutToken(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			theAccess=companyaccessnew.objects.filter(token=data.get('AccessKey')).first()
			if theAccess:
				theAccess.delete()
			response['status_code']=200
			response['status_message']='Done'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)



def randomStringFunction():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(10)))
	str1 += ''.join((random.choice(string.digits) for x in range(6)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

def randomStringFunctionSmall():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(4)))
	str1 += ''.join((random.choice(string.digits) for x in range(2)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString


def randomStringFunctionForImage():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(8)))
	str1 += ''.join((random.choice(string.digits) for x in range(4)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

# def findTimeObject(pickupTime):
# 	from datetime import time
# 	pickupTimeHour=pickupTime.split(':')[0]
# 	pickupTimeMinutes=pickupTime.split(':')[1]
# 	pickupTimeHour=int(pickupTimeHour)
# 	pickupTimeMinutes=int(pickupTimeMinutes)
# 	pickupTimeObject = time(hour = pickupTimeHour, minute = pickupTimeMinutes, second = 00)
# 	return pickupTimeObject

class addStore(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")
			theAccess=companyaccessnew.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			userOBJ = User.objects.filter(username = data.get('email')).first()
			print('userOBJ',userOBJ)
			if userOBJ:
				response['status_code']=400
				response['status_message']='Email already exist.'
				return Response(response)
			phnExist=storenew.objects.filter(phone=data.get('phone'))
			print('phnExist',phnExist)
			if phnExist:
				response['status_code']=400
				response['status_message']='Phone number already exist'
				return Response(response)
			
			try:
				import requests
				theURL=str(settings.COMPANY_ACCESS_URL)+'company/subscriptions/getCompanyModulesForLimit/'
				theToken=str(settings.COMPANY_ACCESS_KEY)
				payload={'AccessKey':theToken,
						 'companyID':data.get('companyID'),}
				apiResponse = requests.request("POST", theURL, data=payload)
				apiResponse = apiResponse.json()
				if apiResponse['status_code']==200:
					if apiResponse['data'][0]['canAddStore']=='True':
						theAlreadyStoreCount=storenew.objects.filter(companyID=data.get('companyID')).count()
						if int(theAlreadyStoreCount)<int(apiResponse['data'][0]['storeLimit']):
							pass
						else:
							response['status_code']=400
							response['status_message']='You have reach the limit of your plan.'
							return Response(response)
					else:
						response['status_code']=400
						response['status_message']='You can not add store with your current plan'
						return Response(response)
				elif apiResponse['status_code']==404:
					response['status_code']=400
					response['status_message']="You don't have any plan"
					return Response(response)
				else:
					return Response(apiResponse)
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
				
			thePassword=randomStringFunction()
			print('thePassword',thePassword)
			userOBJ = User.objects.create_user(username = data.get('email'), password = thePassword)
			print('userOBJ',userOBJ)
			userObjId=userOBJ.id
			print('userObjId',userObjId)
			beforeNameOfCompany=data.get('name')
			print('work')
			name3Letter=beforeNameOfCompany[0:3]
			print('work1')
			name3Letter=name3Letter.upper()
			print('work2')
			latExt=storenew.objects.all().last()
			print('latExt',latExt)
			if latExt:
				lastId=latExt.userUniqueID
				print('lastId',lastId)
				last5Number=lastId[3:]
				print('last5Number',last5Number)
				last5Number=int(last5Number)
				print('last5Number',last5Number)
				new5Number=last5Number+1
				print('new5Number',new5Number)
				new5Number=str(new5Number)
				print('new5Number',new5Number)
				new5Number = new5Number.zfill(5)
				print('new5Number',new5Number)
				theUniqueID=str(name3Letter)+str(new5Number)
				print('theUniqueID',theUniqueID)
			else:
				theUniqueID=str(name3Letter)+str('00001')
				
			# theUniqueID=randomStringFunction()
			adminObj = storenew.objects.create(companyID=data.get('companyID'),userUniqueID=theUniqueID,userTableID=userObjId, name = data.get('name'),email = data.get('email'),phone = data.get('phone'),countrycode = data.get('countrycode'),signupOtpVerfied=True,phoneVerifiedOtp=True,phoneverified=True,accountverified=True)
			passportImage=request.FILES.get('passportImage')
			if passportImage:
				filename=uploadDocumentImages(passportImage,'Documents')
				ownerDocs=storedocumentsnew.objects.create(userUniqueID=theUniqueID,document=filename,doctType='1',isApproved=True)
			licenceImage=request.FILES.get('licenceImage')
			if licenceImage:
				filename=uploadDocumentImages(licenceImage,'Documents')
				ownerDocs=storedocumentsnew.objects.create(userUniqueID=theUniqueID,document=filename,doctType='2',isApproved=True)
			nationalID=request.FILES.get('nationalID')
			if nationalID:
				filename=uploadDocumentImages(nationalID,'Documents')
				ownerDocs=storedocumentsnew.objects.create(userUniqueID=theUniqueID,document=filename,doctType='3',isApproved=True)
			registrationProof=request.FILES.get('registrationProof')
			if registrationProof:
				filename=uploadDocumentImages(registrationProof,'Documents')
				ownerDocs=storedocumentsnew.objects.create(userUniqueID=theUniqueID,document=filename,doctType='4',isApproved=True)
			theDocuments = request.FILES.getlist("documents")
			if theDocuments:
				for count, image in enumerate(theDocuments):
					filename=uploadDocumentImages(image,'Documents')
					ownerDocs=storedocumentsnew.objects.create(userUniqueID=theUniqueID,document=filename,isApproved=True)
			
			theImage=request.FILES.get('image')
			if theImage:
				filename=uploadDocumentImages(theImage,'Profile')
				adminObj.image=filename
			if data.get('name'):
				adminObj.name=data.get('name')
			if data.get('phone'):
				adminObj.phone=data.get('phone')
			if data.get('countrycode'):
				adminObj.countrycode=data.get('countrycode')
			if data.get('fbURL'):
				adminObj.fbURL=data.get('fbURL')
			if data.get('instaURL'):
				adminObj.instaURL=data.get('instaURL')
			if data.get('webURL'):
				adminObj.webURL=data.get('webURL')


			if data.get('description'):
				adminObj.description=data.get('description')
			if data.get('address'):
				adminObj.address=data.get('address')
			if data.get('latitude'):
				adminObj.latitude=data.get('latitude')
			if data.get('longitude'):
				adminObj.longitude=data.get('longitude')
			adminObj.save()
			print('working before time')
			# openingTime=findTimeObject(data.get('openingTime'))
			# closingTime=findTimeObject(data.get('closingTime'))
			openingTime=data.get('openingTime')
			closingTime=data.get('closingTime')

			theCompTiming=storetimingsnew.objects.filter(userUniqueID=theUniqueID).first()
			if not theCompTiming:
				theCompTiming=storetimingsnew.objects.create(userUniqueID=theUniqueID)
			if theCompTiming:
				# openingTime=findTimeObject(data.get('openingTime'))
				# closingTime=findTimeObject(data.get('closingTime'))
				theCompTiming.openingTime=openingTime
				theCompTiming.closingTime=closingTime
				if data.get('monday'):
					if data.get('monday')=='true':
						theCompTiming.monday=True
					else:
						theCompTiming.monday=False
				if data.get('tuesday'):
					if data.get('tuesday')=='true':
						theCompTiming.tuesday=True
					else:
						theCompTiming.tuesday=False
				if data.get('wednesday'):
					if data.get('wednesday')=='true':
						theCompTiming.wednesday=True
					else:
						theCompTiming.wednesday=False

				if data.get('thursday'):
					if data.get('thursday')=='true':
						theCompTiming.thursday=True
					else:
						theCompTiming.thursday=False
				if data.get('friday'):
					if data.get('friday')=='true':
						theCompTiming.friday=True
					else:
						theCompTiming.friday=False
				if data.get('saturday'):
					if data.get('saturday')=='true':
						theCompTiming.saturday=True
					else:
						theCompTiming.saturday=False

				if data.get('sunday'):
					if data.get('sunday')=='true':
						theCompTiming.sunday=True
					else:
						theCompTiming.sunday=False
				theCompTiming.save()
			# if not data.get('jsonData'):return Response({'status_code':400,'status_message':'jsonData is required'})
			
			# theObj=storetimingsnewupdated.objects.filter(userUniqueID=data.get('storeID')).first()
			# if not theObj:
			theObj=storetimingsnewupdated.objects.create(userUniqueID=theUniqueID)
			theObj.theDaysData=data.get('jsonData')
			theObj.save()
			try:
				subject='Welcome'
				message = render_to_string('createStoreEmail.html', {
					'name': data.get('name'),
					'email': data.get('email'),
					'password': str(thePassword),
				})
				from_email = settings.EMAIL_HOST_USER
				to_email = data.get('email')
				message = EmailMessage(subject, message, from_email, [to_email])
				message.content_subtype = 'html'
				message.send()
			except Exception as e:
				print(e)
			response['storeId']=theUniqueID
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updateStore(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			theAccess=companyaccessnew.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			adminObj=storenew.objects.filter(userUniqueID=data.get('storeID')).first()
			if adminObj:
				
				theImage=request.FILES.get('image')
				if theImage:
					filename=uploadDocumentImages(theImage,'Profile')
					adminObj.image=filename
				if data.get('name'):
					adminObj.name=data.get('name')
				if data.get('phone'):
					adminObj.phone=data.get('phone')
				if data.get('countrycode'):
					adminObj.countrycode=data.get('countrycode')
				if data.get('fbURL'):
					adminObj.fbURL=data.get('fbURL')
				if data.get('instaURL'):
					adminObj.instaURL=data.get('instaURL')
				if data.get('webURL'):
					adminObj.webURL=data.get('webURL')


				if data.get('description'):
					adminObj.description=data.get('description')
				if data.get('address'):
					adminObj.address=data.get('address')
				if data.get('latitude'):
					adminObj.latitude=data.get('latitude')
				if data.get('longitude'):
					adminObj.longitude=data.get('longitude')
				adminObj.save()
			# openingTime=findTimeObject(data.get('openingTime'))
			# closingTime=findTimeObject(data.get('closingTime'))
			openingTime=data.get('openingTime')
			closingTime=data.get('closingTime')
			theCompTiming=storetimingsnew.objects.filter(userUniqueID=data.get('storeID')).first()
			if theCompTiming:
				theCompTiming.openingTime=openingTime
				theCompTiming.closingTime=closingTime
				if data.get('monday'):
					if data.get('monday')=='true':
						theCompTiming.monday=True
					else:
						theCompTiming.monday=False
				if data.get('tuesday'):
					if data.get('tuesday')=='true':
						theCompTiming.tuesday=True
					else:
						theCompTiming.tuesday=False
				if data.get('wednesday'):
					if data.get('wednesday')=='true':
						theCompTiming.wednesday=True
					else:
						theCompTiming.wednesday=False

				if data.get('thursday'):
					if data.get('thursday')=='true':
						theCompTiming.thursday=True
					else:
						theCompTiming.thursday=False
				if data.get('friday'):
					if data.get('friday')=='true':
						theCompTiming.friday=True
					else:
						theCompTiming.friday=False
				if data.get('saturday'):
					if data.get('saturday')=='true':
						theCompTiming.saturday=True
					else:
						theCompTiming.saturday=False

				if data.get('sunday'):
					if data.get('sunday')=='true':
						theCompTiming.sunday=True
					else:
						theCompTiming.sunday=False
				theCompTiming.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class changeStatusOfStore(APIView):
	def post(self,request,*args,**kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			theAccess=companyaccessnew.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			theStoreObj=storenew.objects.filter(userUniqueID=data.get('storeID')).first()
			if theStoreObj:
				if data.get('theStatus') == True:
					theStoreObj.isdisabled=False
				else:
					theStoreObj.isdisabled=True
				theStoreObj.save()
				response['status_code']=200
				response['status_message']='Success'
			else:
				response['status_code']=400
				response['status_message']='Not a valid store ID'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

# def uploadDocumentImages(image,thePath):
# 	import os
# 	fullPath='media/'+str(thePath)
# 	fs = FileSystemStorage(location=fullPath)
# 	beforename = os.path.splitext(image.name)[0]
# 	filetype = os.path.splitext(image.name)[1]
# 	theName=randomStringFunctionForImage()
# 	theImageName=str(theName)+str(filetype)
# 	filename = fs.save(theImageName, image)
# 	return str(fullPath)+'/'+filename

def uploadDocumentImages(image,thePath):
	import os
	import boto3
	from botocore.exceptions import NoCredentialsError
	try:
		bucket=str(settings.AWS_BUCKET_NAME)
		thePath=thePath.lower()
		ACCESS_KEY=str(settings.AWS_ACCESS_KEY_ID)
		SECRET_KEY=str(settings.AWS_SECRET_ACCESS_KEY)
		s3 = boto3.client('s3', aws_access_key_id=ACCESS_KEY,
					  aws_secret_access_key=SECRET_KEY)
		try:
			filetype = os.path.splitext(image.name)[1]
			imageName=randomStringFunctionForImage()
			thePath=thePath+'/'+imageName+'.'+filetype
			thePath=str(thePath)
			theFile=s3.upload_fileobj(image,bucket,thePath)
			print("Upload Successful")
			filename=str(settings.AWS_BUCKET_URL_1)+str(bucket)+str(settings.AWS_BUCKET_URL_2)+thePath
			return filename
		except FileNotFoundError as e:
			print("The file was not found")
			return ''
		except NoCredentialsError:
			print("Credentials not available")
			return ''
	except Exception as e:
		print(e)
		return ''

class updateDocuments(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			theAccess=companyaccessnew.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			theStoreObj=storenew.objects.filter(userUniqueID=data.get('storeID')).first()
			if not theStoreObj:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			userObjId=theCompObj.userTableID
			theUniqueID=data.get('storeID')
			passportImage=request.FILES.get('passportImage')
			if passportImage:
				passportImageID=request.FILES.get('passportImageID')
				if passportImageID == '0':
					filename=uploadDocumentImages(passportImage,'Documents')
					ownerDocs=storedocumentsnew.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,isApproved=True,doctType=1)
				else:
					filename=uploadDocumentImages(passportImage,'Documents')
					ownerDocs=storedocumentsnew.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=passportImageID,doctType=1)
					ownerDocs.document=filename
					ownerDocs.isApproved=True
					ownerDocs.save()
			licenceImage=request.FILES.get('licenceImage')
			if licenceImage:
				licenceImageID=request.FILES.get('licenceImageID')
				if licenceImageID == '0':
					filename=uploadDocumentImages(licenceImage,'Documents')
					ownerDocs=storedocumentsnew.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,isApproved=True,doctType=2)
				else:
					filename=uploadDocumentImages(licenceImage,'Documents')
					ownerDocs=storedocumentsnew.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=licenceImageID,doctType=2)
					ownerDocs.document=filename
					ownerDocs.isApproved=True
					ownerDocs.save()
			nationalID=request.FILES.get('nationalID')
			if nationalID:
				nationalProofID=request.FILES.get('nationalProofID')
				if nationalProofID == '0':
					filename=uploadDocumentImages(nationalID,'Documents')
					ownerDocs=storedocumentsnew.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,isApproved=True,doctType=3)
				else:
					filename=uploadDocumentImages(nationalID,'Documents')
					ownerDocs=storedocumentsnew.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=nationalProofID,doctType=3)
					ownerDocs.document=filename
					ownerDocs.isApproved=True
					ownerDocs.save()
			registrationProof=request.FILES.get('registrationProof')
			if registrationProof:
				registrationProofID=request.FILES.get('registrationProofID')
				if registrationProofID == '0':
					filename=uploadDocumentImages(registrationProof,'Documents')
					ownerDocs=storedocumentsnew.objects.create(userTableID=userObjId,userUniqueID=theUniqueID,document=filename,doctType=4,isApproved=True)
				else:
					filename=uploadDocumentImages(registrationProof,'Documents')
					ownerDocs=storedocumentsnew.objects.filter(userTableID=userObjId,userUniqueID=theUniqueID,id=registrationProofID,doctType=4)
					ownerDocs.document=filename
					ownerDocs.isApproved=True
					ownerDocs.save()
			theIDS = request.POST.getlist("ids")
			theDocuments = request.FILES.getlist("documents")
			for count, image in enumerate(theDocuments):
				if theIDS[count] == '0':
					filename=uploadDocumentImages(image,'Documents')
					ownerDocs=storedocumentsnew.objects.create(userTableID=compObjects.userTableID,userUniqueID=data.get('companyID'),document=filename,isApproved=True,doctType=5)
				else:
					alreadyDoc=storedocumentsnew.objects.filter(userUniqueID=data.get('companyID'),id=theIDS[count]).first()
					if alreadyDoc:
						filename=uploadDocumentImages(image,'Documents')
						alreadyDoc.document=filename
						alreadyDoc.isApproved=True
						alreadyDoc.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


def approveDocuments(companyID,docID):
	alreadyDoc=storedocumentsnew.objects.filter(userUniqueID=companyID,id=docID).first()
	if alreadyDoc:
		alreadyDoc.isApproved=True
		alreadyDoc.docStatus='2'
		alreadyDoc.save()

def rejectDocuments(companyID,docID,reason):
	alreadyDoc=storedocumentsnew.objects.filter(userUniqueID=companyID,id=docID).first()
	if alreadyDoc:
		alreadyDoc.isApproved=False
		alreadyDoc.docStatus='3'
		alreadyDoc.rejectReason=reason
		alreadyDoc.save()

class changeDocumentsStatus(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			print(data)
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			theAccess=companyaccessnew.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			theStoreObj=storenew.objects.filter(userUniqueID=data.get('storeID')).first()
			if not theStoreObj:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			docId = data.get("id")
			# theStatus = data.get("status")
			if data.get("status") == 'Accept':
				approveDocuments(data.get('storeID'),docId)
			elif data.get("status") == 'Reject':
				if not data.get('reason'):
					response['status_code']=400
					response['status_message']='Rejection reason is required'
					return Response(response)
				rejectDocuments(data.get('storeID'),docId,data.get('reason'))
			else:
				pass
			approveCount=0
			totalUplodedCount=0
			presentDocs=storedocumentsnew.objects.filter(userUniqueID=data.get('storeID'))
			for p in presentDocs:
				totalUplodedCount+=1
				if p.isApproved==True:
					approveCount+=1
			# if approveCount==0:
			# 	pass
			# elif approveCount==totalUplodedCount:
			# 	theStoreObj.risk=3
			# 	theStoreObj.save()
			# elif approveCount<totalUplodedCount:
			# 	theStoreObj.risk=2
			# 	theStoreObj.save()
			# else:
			# 	theStoreObj.risk=1
			# 	theStoreObj.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class setRadius(APIView):
	def get(self, request):
		response={}
		chargesObject=storeradius.objects.all().last()
		if chargesObject:
			response['radius']=chargesObject.radius
		else:
			response['radius']=0
		response['status_code']=200
		response['status_message']='Success'
		return Response(response)

	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			AccessKey = request.META.get('HTTP_AUTHORIZATION')
			if not AccessKey:
				if not data.get('AccessKey'):
					response['status_code']=400
					response['status_message']='AccessKey required'
					return Response(response)
				else:
					AccessKey=data.get('AccessKey')
			else:
				AccessKey = AccessKey.replace("Token ", "")

			theAccess=superadminaccessnew.objects.filter(token=AccessKey).first()
			if not theAccess:
				response['status_code']=401
				response['status_message']='You dont have access.'
				return Response(response,status=401)

			if not data.get('radius'):
				response['status_code']=400
				response['status_message']='radius required'
				return Response(response)
			radiusObject = storeradius.objects.all().last()
			if not radiusObject:
				radiusObject = storeradius.objects.create(radius=data.get('radius'))
			else:
				radiusObject.radius=data.get('radius')
				radiusObject.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response,status=500)
		return Response(response)



class updateOrAddTimings(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			import json
			data=request.data
			print("==1==")
			if not data.get('storeID'):return Response({'status_code':400,'status_message':'Store id is required'})
			if not data.get('jsonData'):return Response({'status_code':400,'status_message':'jsonData is required'})
			
			theObj=storetimingsnewupdated.objects.filter(userUniqueID=data.get('storeID')).first()
			if not theObj:
				theObj=storetimingsnewupdated.objects.create(userUniqueID=data.get('storeID'))
			theObj.theDaysData=data.get('jsonData')
			theObj.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)