from django.db import models

class country(models.Model):
	country = models.CharField(max_length = 50, null = True, blank = True)
	alphacodetwo = models.CharField(max_length = 50, null = True, blank = True)
	alphacodethree = models.CharField(max_length = 50, null = True, blank = True)
	isdeleted = models.BooleanField(default = False)
	isdisabled = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.country)+'-'+str(self.alphacodethree))

class state(models.Model):
	country = models.ForeignKey(country, on_delete=models.CASCADE,null=True)
	state = models.CharField(max_length = 50, null = True, blank = True)
	fulladdress = models.CharField(max_length = 150, null = True, blank = True)
	minimumage = models.CharField(max_length = 10, null = True, blank = True)
	isdeleted = models.BooleanField(default = False)
	isdisabled = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.state)+'-'+str(self.minimumage))

class district(models.Model):
	country = models.ForeignKey(country, on_delete=models.CASCADE)
	state = models.ForeignKey(state, on_delete=models.CASCADE)
	district = models.CharField(max_length = 50, null = True, blank = True)
	districtlatitude = models.CharField(max_length = 50, null = True, blank = True)
	districtlongitude = models.CharField(max_length = 50, null = True, blank = True)
	fulladdress = models.CharField(max_length = 150, null = True, blank = True)
	isdeleted = models.BooleanField(default = False)
	isdisabled = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.state)+'-'+str(self.district))

class thecategory(models.Model):
	categoryId = models.CharField(max_length = 50, null = True, blank = True)
	categoryName = models.CharField(max_length = 50, null = True, blank = True)
	categoryImage = models.FileField(upload_to='Category', blank = True, null = True)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)
	
	def __str__(self):
		return str(str(self.categoryName)+'-'+str(self.categoryId))

class quantities(models.Model):
	category = models.ForeignKey(thecategory, on_delete=models.CASCADE,null=True)
	quanWeight = models.CharField(max_length = 50, null = True, blank = True)
	quanUnit = models.CharField(max_length = 50, null = True, blank = True)
	quanPrice = models.CharField(max_length = 50, null = True, blank = True)
	isdeleted = models.BooleanField(default = False)
	isdisabled = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.id)+' - '+str(self.quanWeight)+'-'+str(self.quanUnit))

class appinfo(models.Model):
	email = models.CharField(max_length = 50, null = True, blank = True)
	contactno = models.CharField(max_length = 50, null = True, blank = True)
	address = models.TextField(null = True, blank = True)
	country = models.CharField(max_length = 50, null = True, blank = True)
	state = models.CharField(max_length = 50, null = True, blank = True)
	city = models.CharField(max_length = 50, null = True, blank = True)
	isdeleted = models.BooleanField(default = False)
	isdisabled = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.email)+' - '+str(self.contactno)+'-'+str(self.country))

class chatbotquestions(models.Model):
	question = models.TextField(blank = True)
	answer = models.TextField(blank = True)
	isdisabled = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.question)+' - '+str(self.answer))