from rest_framework import serializers
from .models import *

class GetAppInfoData(serializers.ModelSerializer):

	class Meta:
		model = appinfo
		fields = ['email','contactno','address','country','state','city']

class GetDistrictData(serializers.ModelSerializer):
	country =  serializers.SerializerMethodField(source='get_country')
	state =  serializers.SerializerMethodField(source='get_state')

	class Meta:
		model = district
		fields = ['id','isdisabled','district','districtlatitude','districtlongitude','fulladdress','state','country']
	
	def get_country(self, obj):
		return obj.country.country
	
	def get_state(self, obj):
		return obj.state.state

class GetCountryData(serializers.ModelSerializer):
	class Meta:
		model = country
		fields = ['id','isdisabled','country','alphacodetwo','alphacodethree']

class GetStatesData(serializers.ModelSerializer):
	country =  serializers.SerializerMethodField(source='get_country')
	
	class Meta:
		model = state
		fields = ['id','isdisabled','state','fulladdress','minimumage','country']
	
	def get_country(self, obj):
		return obj.country.country
class GetCategoryData(serializers.ModelSerializer):
	categoryImage =  serializers.SerializerMethodField(source='get_categoryImage')
	class Meta:
		model = thecategory
		fields = ['categoryId','categoryName','categoryImage','isdisabled']
	def get_categoryImage(self, obj):
		return str(obj.categoryImage.name)

# previous
# class GetQuantitesData(serializers.ModelSerializer):
# 	class Meta:
# 		model = quantities
# 		fields = ['id','quanWeight','quanUnit','isdisabled']

#New one
class GetQuantitesData(serializers.ModelSerializer):
	categoryName=serializers.SerializerMethodField(source='get_categoryName')
	categoryId=serializers.SerializerMethodField(source='get_categoryId')
	class Meta:
		model = quantities
		fields = ['id','quanWeight','quanUnit','categoryId','isdisabled','categoryName']

	def get_categoryName(self,obj):
		return obj.category.categoryName
	def get_categoryId(self,obj):
		return obj.category.categoryId